/* usb.c
 * USB vendor id and product ids
 * This file was generated by running python ./tools/make-usb.py
 * Don't change it directly.
 *
 * Copyright 2012, Michal Labedzki for Tieto Corporation
 *
 * Other values imported from libghoto2/camlibs/ptp2/library.c, music-players.h
 *
 * Copyright (C) 2001-2005 Mariusz Woloszyn <emsi@ipartners.pl>
 * Copyright (C) 2003-2013 Marcus Meissner <marcus@jet.franken.de>
 * Copyright (C) 2005 Hubert Figuiere <hfiguiere@teaser.fr>
 * Copyright (C) 2009 Axel Waggershauser <awagger@web.de>
 * Copyright (C) 2005-2007 Richard A. Low <richard@wentnet.com>
 * Copyright (C) 2005-2012 Linus Walleij <triad@df.lth.se>
 * Copyright (C) 2007 Ted Bullock
 * Copyright (C) 2012 Sony Mobile Communications AB
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

/*
 * XXX We should probably parse a USB ID file at program start instead
 * of generating this file.
 */

#include "config.h"
#include <epan/packet.h>

static const value_string usb_vendors_vals[] = {
    { 0x0001, "Fry's Electronics" },
    { 0x0002, "Ingram" },
    { 0x0003, "Club Mac" },
    { 0x0004, "Nebraska Furniture Mart" },
    { 0x0011, "Unknown" },
    { 0x0053, "Planex" },
    { 0x0078, "Microntek" },
    { 0x0079, "DragonRise Inc." },
    { 0x0080, "Unknown" },
    { 0x0085, "Boeye Technology Co., Ltd." },
    { 0x0102, "miniSTREAK" },
    { 0x0105, "Trust International B.V." },
    { 0x0127, "IBP" },
    { 0x0145, "Unknown" },
    { 0x017c, "MLK" },
    { 0x0200, "TP-Link" },
    { 0x0204, "Chipsbank Microelectronics Co., Ltd" },
    { 0x0218, "Hangzhou Worlde" },
    { 0x02ad, "HUMAX Co., Ltd." },
    { 0x0303, "Mini Automation Controller" },
    { 0x0324, "OCZ Technology Inc" },
    { 0x0325, "OCZ Technology Inc" },
    { 0x0386, "LTS" },
    { 0x03d9, "Shenzhen Sinote Tech-Electron Co., Ltd" },
    { 0x03da, "Bernd Walter Computer Technology" },
    { 0x03e7, "Intel" },
    { 0x03e8, "EndPoints, Inc." },
    { 0x03e9, "Thesys Microelectronics" },
    { 0x03ea, "Data Broadcasting Corp." },
    { 0x03eb, "Atmel Corp." },
    { 0x03ec, "Iwatsu America, Inc." },
    { 0x03ed, "Mitel Corp." },
    { 0x03ee, "Mitsumi" },
    { 0x03f0, "HP, Inc" },
    { 0x03f1, "Genoa Technology" },
    { 0x03f2, "Oak Technology, Inc." },
    { 0x03f3, "Adaptec, Inc." },
    { 0x03f4, "Diebold, Inc." },
    { 0x03f5, "Siemens Electromechanical" },
    { 0x03f8, "Epson Imaging Technology Center" },
    { 0x03f9, "KeyTronic Corp." },
    { 0x03fb, "OPTi, Inc." },
    { 0x03fc, "Elitegroup Computer Systems" },
    { 0x03fd, "Xilinx, Inc." },
    { 0x03fe, "Farallon Comunications" },
    { 0x0400, "National Semiconductor Corp." },
    { 0x0401, "National Registry, Inc." },
    { 0x0402, "ALi Corp." },
    { 0x0403, "Future Technology Devices International, Ltd" },
    { 0x0404, "NCR Corp." },
    { 0x0405, "Synopsys, Inc." },
    { 0x0406, "Fujitsu-ICL Computers" },
    { 0x0407, "Fujitsu Personal Systems, Inc." },
    { 0x0408, "Quanta Computer, Inc." },
    { 0x0409, "NEC Corp." },
    { 0x040a, "Kodak Co." },
    { 0x040b, "Weltrend Semiconductor" },
    { 0x040c, "VTech Computers, Ltd" },
    { 0x040d, "VIA Technologies, Inc." },
    { 0x040e, "MCCI" },
    { 0x040f, "Echo Speech Corp." },
    { 0x0411, "BUFFALO INC. (formerly MelCo., Inc.)" },
    { 0x0412, "Award Software International" },
    { 0x0413, "Leadtek Research, Inc." },
    { 0x0414, "Giga-Byte Technology Co., Ltd" },
    { 0x0416, "Winbond Electronics Corp." },
    { 0x0417, "Symbios Logic" },
    { 0x0418, "AST Research" },
    { 0x0419, "Samsung Info. Systems America, Inc." },
    { 0x041a, "Phoenix Technologies, Ltd" },
    { 0x041b, "d'TV" },
    { 0x041d, "S3, Inc." },
    { 0x041e, "Creative Technology, Ltd" },
    { 0x041f, "LCS Telegraphics" },
    { 0x0420, "Chips and Technologies" },
    { 0x0421, "Nokia Mobile Phones" },
    { 0x0422, "ADI Systems, Inc." },
    { 0x0423, "Computer Access Technology Corp." },
    { 0x0424, "Microchip Technology, Inc. (formerly SMSC)" },
    { 0x0425, "Motorola Semiconductors HK, Ltd" },
    { 0x0426, "Integrated Device Technology, Inc." },
    { 0x0427, "Motorola Electronics Taiwan, Ltd" },
    { 0x0428, "Advanced Gravis Computer Tech, Ltd" },
    { 0x0429, "Cirrus Logic" },
    { 0x042a, "Ericsson Austrian, AG" },
    { 0x042b, "Intel Corp." },
    { 0x042c, "Innovative Semiconductors, Inc." },
    { 0x042d, "Micronics" },
    { 0x042e, "Acer, Inc." },
    { 0x042f, "Molex, Inc." },
    { 0x0430, "Sun Microsystems, Inc." },
    { 0x0431, "Itac Systems, Inc." },
    { 0x0432, "Unisys Corp." },
    { 0x0433, "Alps Electric, Inc." },
    { 0x0434, "Samsung Info. Systems America, Inc." },
    { 0x0435, "Hyundai Electronics America" },
    { 0x0436, "Taugagreining HF" },
    { 0x0437, "Framatome Connectors USA" },
    { 0x0438, "Advanced Micro Devices, Inc." },
    { 0x0439, "Voice Technologies Group" },
    { 0x043d, "Lexmark International, Inc." },
    { 0x043e, "LG Electronics USA, Inc." },
    { 0x043f, "RadiSys Corp." },
    { 0x0440, "Eizo Nanao Corp." },
    { 0x0441, "Winbond Systems Lab." },
    { 0x0442, "Ericsson, Inc." },
    { 0x0443, "Gateway, Inc." },
    { 0x0445, "Lucent Technologies, Inc." },
    { 0x0446, "NMB Technologies Corp." },
    { 0x0447, "Momentum Microsystems" },
    { 0x0449, "Duta Multi Robotik" },
    { 0x044a, "Shamrock Tech. Co., Ltd" },
    { 0x044b, "WSI" },
    { 0x044c, "CCL/ITRI" },
    { 0x044d, "Siemens Nixdorf AG" },
    { 0x044e, "Alps Electric Co., Ltd" },
    { 0x044f, "ThrustMaster, Inc." },
    { 0x0450, "DFI, Inc." },
    { 0x0451, "Texas Instruments, Inc." },
    { 0x0452, "Mitsubishi Electronics America, Inc." },
    { 0x0453, "CMD Technology" },
    { 0x0454, "Vobis Microcomputer AG" },
    { 0x0455, "Telematics International, Inc." },
    { 0x0456, "Analog Devices, Inc." },
    { 0x0457, "Silicon Integrated Systems Corp." },
    { 0x0458, "KYE Systems Corp. (Mouse Systems)" },
    { 0x0459, "Adobe Systems, Inc." },
    { 0x045a, "SONICblue, Inc." },
    { 0x045b, "Hitachi, Ltd" },
    { 0x045d, "Nortel Networks, Ltd" },
    { 0x045e, "Microsoft Corp." },
    { 0x0460, "Ace Cad Enterprise Co., Ltd" },
    { 0x0461, "Primax Electronics, Ltd" },
    { 0x0463, "MGE UPS Systems" },
    { 0x0464, "AMP/Tycoelectronics Corp." },
    { 0x0467, "AT&T Paradyne" },
    { 0x0468, "Wieson Technologies Co., Ltd" },
    { 0x046a, "Cherry GmbH" },
    { 0x046b, "American Megatrends, Inc." },
    { 0x046c, "Toshiba Corp., Digital Media Equipment" },
    { 0x046d, "Logitech, Inc." },
    { 0x046e, "Behavior Tech. Computer Corp." },
    { 0x046f, "Crystal Semiconductor" },
    { 0x0471, "Philips (or NXP)" },
    { 0x0472, "Chicony Electronics Co., Ltd" },
    { 0x0473, "Sanyo Information Business Co., Ltd" },
    { 0x0474, "Sanyo Electric Co., Ltd" },
    { 0x0475, "Relisys/Teco Information System" },
    { 0x0476, "AESP" },
    { 0x0477, "Seagate Technology, Inc." },
    { 0x0478, "Connectix Corp." },
    { 0x0479, "Advanced Peripheral Laboratories" },
    { 0x047a, "Semtech Corp." },
    { 0x047b, "Silitek Corp." },
    { 0x047c, "Dell Computer Corp." },
    { 0x047d, "Kensington" },
    { 0x047e, "Agere Systems, Inc. (Lucent)" },
    { 0x047f, "Plantronics, Inc." },
    { 0x0480, "Toshiba America Inc" },
    { 0x0481, "Zenith Data Systems" },
    { 0x0482, "Kyocera Corp." },
    { 0x0483, "STMicroelectronics" },
    { 0x0484, "Specialix" },
    { 0x0485, "Nokia Monitors" },
    { 0x0486, "ASUS Computers, Inc." },
    { 0x0487, "Stewart Connector" },
    { 0x0488, "Cirque Corp." },
    { 0x0489, "Foxconn / Hon Hai" },
    { 0x048a, "S-MOS Systems, Inc." },
    { 0x048c, "Alps Electric Ireland, Ltd" },
    { 0x048d, "Integrated Technology Express, Inc." },
    { 0x048f, "Eicon Tech." },
    { 0x0490, "United Microelectronics Corp." },
    { 0x0491, "Capetronic" },
    { 0x0492, "Samsung SemiConductor, Inc." },
    { 0x0493, "MAG Technology Co., Ltd" },
    { 0x0495, "ESS Technology, Inc." },
    { 0x0496, "Micron Electronics" },
    { 0x0497, "Smile International" },
    { 0x0498, "Capetronic (Kaohsiung) Corp." },
    { 0x0499, "Yamaha Corp." },
    { 0x049a, "Gandalf Technologies, Ltd" },
    { 0x049b, "Curtis Computer Products" },
    { 0x049c, "Acer Advanced Labs, Inc." },
    { 0x049d, "VLSI Technology" },
    { 0x049f, "Compaq Computer Corp." },
    { 0x04a0, "Digital Equipment Corp." },
    { 0x04a1, "SystemSoft Corp." },
    { 0x04a2, "FirePower Systems" },
    { 0x04a3, "Trident Microsystems, Inc." },
    { 0x04a4, "Hitachi, Ltd" },
    { 0x04a5, "Acer Peripherals Inc. (now BenQ Corp.)" },
    { 0x04a6, "Nokia Display Products" },
    { 0x04a7, "Visioneer" },
    { 0x04a8, "Multivideo Labs, Inc." },
    { 0x04a9, "Canon, Inc." },
    { 0x04aa, "DaeWoo Telecom, Ltd" },
    { 0x04ab, "Chromatic Research" },
    { 0x04ac, "Micro Audiometrics Corp." },
    { 0x04ad, "Dooin Electronics" },
    { 0x04af, "Winnov L.P." },
    { 0x04b0, "Nikon Corp." },
    { 0x04b1, "Pan International" },
    { 0x04b3, "IBM Corp." },
    { 0x04b4, "Cypress Semiconductor Corp." },
    { 0x04b5, "ROHM LSI Systems USA, LLC" },
    { 0x04b6, "Hint Corp." },
    { 0x04b7, "Compal Electronics, Inc." },
    { 0x04b8, "Seiko Epson Corp." },
    { 0x04b9, "Rainbow Technologies, Inc." },
    { 0x04ba, "Toucan Systems, Ltd" },
    { 0x04bb, "I-O Data Device, Inc." },
    { 0x04bd, "Toshiba Electronics Taiwan Corp." },
    { 0x04be, "Telia Research AB" },
    { 0x04bf, "TDK Corp." },
    { 0x04c1, "U.S. Robotics (3Com)" },
    { 0x04c2, "Methode Electronics Far East PTE, Ltd" },
    { 0x04c3, "Maxi Switch, Inc." },
    { 0x04c4, "Lockheed Martin Energy Research" },
    { 0x04c5, "Fujitsu, Ltd" },
    { 0x04c6, "Toshiba America Electronic Components" },
    { 0x04c7, "Micro Macro Technologies" },
    { 0x04c8, "Konica Corp." },
    { 0x04ca, "Lite-On Technology Corp." },
    { 0x04cb, "Fuji Photo Film Co., Ltd" },
    { 0x04cc, "ST-Ericsson" },
    { 0x04cd, "Tatung Co. Of America" },
    { 0x04ce, "ScanLogic Corp." },
    { 0x04cf, "Myson Century, Inc." },
    { 0x04d0, "Digi International" },
    { 0x04d1, "ITT Canon" },
    { 0x04d2, "Altec Lansing Technologies" },
    { 0x04d3, "VidUS, Inc." },
    { 0x04d4, "LSI Logic, Inc." },
    { 0x04d5, "Forte Technologies, Inc." },
    { 0x04d6, "Mentor Graphics" },
    { 0x04d7, "Oki Semiconductor" },
    { 0x04d8, "Microchip Technology, Inc." },
    { 0x04d9, "Holtek Semiconductor, Inc." },
    { 0x04da, "Panasonic (Matsushita)" },
    { 0x04db, "Hypertec Pty, Ltd" },
    { 0x04dc, "Huan Hsin Holdings, Ltd" },
    { 0x04dd, "Sharp Corp." },
    { 0x04de, "MindShare, Inc." },
    { 0x04df, "Interlink Electronics" },
    { 0x04e1, "Iiyama North America, Inc." },
    { 0x04e2, "Exar Corp." },
    { 0x04e3, "Zilog, Inc." },
    { 0x04e4, "ACC Microelectronics" },
    { 0x04e5, "Promise Technology" },
    { 0x04e6, "SCM Microsystems, Inc." },
    { 0x04e7, "Elo TouchSystems" },
    { 0x04e8, "Samsung Electronics Co., Ltd" },
    { 0x04e9, "PC-Tel, Inc." },
    { 0x04ea, "Brooktree Corp." },
    { 0x04eb, "Northstar Systems, Inc." },
    { 0x04ec, "Tokyo Electron Device, Ltd" },
    { 0x04ed, "Annabooks" },
    { 0x04ef, "Pacific Electronic International, Inc." },
    { 0x04f0, "Daewoo Electronics Co., Ltd" },
    { 0x04f1, "Victor Company of Japan, Ltd" },
    { 0x04f2, "Chicony Electronics Co., Ltd" },
    { 0x04f3, "Elan Microelectronics Corp." },
    { 0x04f4, "Harting Elektronik, Inc." },
    { 0x04f5, "Fujitsu-ICL Systems, Inc." },
    { 0x04f6, "Norand Corp." },
    { 0x04f7, "Newnex Technology Corp." },
    { 0x04f8, "FuturePlus Systems" },
    { 0x04f9, "Brother Industries, Ltd" },
    { 0x04fa, "Dallas Semiconductor" },
    { 0x04fb, "Biostar Microtech International Corp." },
    { 0x04fc, "Sunplus Technology Co., Ltd" },
    { 0x04fd, "Soliton Systems, K.K." },
    { 0x04fe, "PFU, Ltd" },
    { 0x04ff, "E-CMOS Corp." },
    { 0x0500, "Siam United Hi-Tech" },
    { 0x0501, "Fujikura DDK, Ltd" },
    { 0x0502, "Acer, Inc." },
    { 0x0503, "Hitachi America, Ltd" },
    { 0x0504, "Hayes Microcomputer Products" },
    { 0x0506, "3Com Corp." },
    { 0x0507, "Hosiden Corp." },
    { 0x0508, "Clarion Co., Ltd" },
    { 0x0509, "Aztech Systems, Ltd" },
    { 0x050a, "Cinch Connectors" },
    { 0x050b, "Cable System International" },
    { 0x050c, "InnoMedia, Inc." },
    { 0x050d, "Belkin Components" },
    { 0x050e, "Neon Technology, Inc." },
    { 0x050f, "KC Technology, Inc." },
    { 0x0510, "Sejin Electron, Inc." },
    { 0x0511, "N'Able (DataBook) Technologies, Inc." },
    { 0x0512, "Hualon Microelectronics Corp." },
    { 0x0513, "digital-X, Inc." },
    { 0x0514, "FCI Electronics" },
    { 0x0515, "ACTC" },
    { 0x0516, "Longwell Electronics" },
    { 0x0517, "Butterfly Communications" },
    { 0x0518, "EzKEY Corp." },
    { 0x0519, "Star Micronics Co., Ltd" },
    { 0x051a, "WYSE Technology" },
    { 0x051b, "Silicon Graphics" },
    { 0x051c, "Shuttle, Inc." },
    { 0x051d, "American Power Conversion" },
    { 0x051e, "Scientific Atlanta, Inc." },
    { 0x051f, "IO Systems (Elite Electronics), Inc." },
    { 0x0520, "Taiwan Semiconductor Manufacturing Co." },
    { 0x0521, "Airborn Connectors" },
    { 0x0522, "Advanced Connectek, Inc." },
    { 0x0523, "ATEN GmbH" },
    { 0x0524, "Sola Electronics" },
    { 0x0525, "Netchip Technology, Inc." },
    { 0x0526, "Temic MHS S.A." },
    { 0x0527, "ALTRA" },
    { 0x0528, "ATI Technologies, Inc." },
    { 0x0529, "Aladdin Knowledge Systems" },
    { 0x052a, "Crescent Heart Software" },
    { 0x052b, "Tekom Technologies, Inc." },
    { 0x052c, "Canon Information Systems, Inc." },
    { 0x052d, "Avid Electronics Corp." },
    { 0x052e, "Standard Microsystems Corp." },
    { 0x052f, "Unicore Software, Inc." },
    { 0x0530, "American Microsystems, Inc." },
    { 0x0531, "Wacom Technology Corp." },
    { 0x0532, "Systech Corp." },
    { 0x0533, "Alcatel Mobile Phones" },
    { 0x0534, "Motorola, Inc." },
    { 0x0535, "LIH TZU Electric Co., Ltd" },
    { 0x0536, "Hand Held Products (Welch Allyn, Inc.)" },
    { 0x0537, "Inventec Corp." },
    { 0x0538, "Caldera International, Inc. (SCO)" },
    { 0x0539, "Shyh Shiun Terminals Co., Ltd" },
    { 0x053a, "PrehKeyTec GmbH" },
    { 0x053b, "Global Village Communication" },
    { 0x053c, "Institut of Microelectronic & Mechatronic Systems" },
    { 0x053d, "Silicon Architect" },
    { 0x053e, "Mobility Electronics" },
    { 0x053f, "Synopsys, Inc." },
    { 0x0540, "UniAccess AB" },
    { 0x0541, "Sirf Technology, Inc." },
    { 0x0543, "ViewSonic Corp." },
    { 0x0544, "Cristie Electronics, Ltd" },
    { 0x0545, "Xirlink, Inc." },
    { 0x0546, "Polaroid Corp." },
    { 0x0547, "Anchor Chips, Inc." },
    { 0x0548, "Tyan Computer Corp." },
    { 0x0549, "Pixera Corp." },
    { 0x054a, "Fujitsu Microelectronics, Inc." },
    { 0x054b, "New Media Corp." },
    { 0x054c, "Sony Corp." },
    { 0x054d, "Try Corp." },
    { 0x054e, "Proside Corp." },
    { 0x054f, "WYSE Technology Taiwan" },
    { 0x0550, "Fuji Xerox Co., Ltd" },
    { 0x0551, "CompuTrend Systems, Inc." },
    { 0x0552, "Philips Monitors" },
    { 0x0553, "STMicroelectronics Imaging Division (VLSI Vision)" },
    { 0x0554, "Dictaphone Corp." },
    { 0x0555, "ANAM S&T Co., Ltd" },
    { 0x0556, "Asahi Kasei Microsystems Co., Ltd" },
    { 0x0557, "ATEN International Co., Ltd" },
    { 0x0558, "Truevision, Inc." },
    { 0x0559, "Cadence Design Systems, Inc." },
    { 0x055a, "Kenwood USA" },
    { 0x055b, "KnowledgeTek, Inc." },
    { 0x055c, "Proton Electronic Ind." },
    { 0x055d, "Samsung Electro-Mechanics Co." },
    { 0x055e, "CTX Opto-Electronics Corp." },
    { 0x055f, "Mustek Systems, Inc." },
    { 0x0560, "Interface Corp." },
    { 0x0561, "Oasis Design, Inc." },
    { 0x0562, "Telex Communications, Inc." },
    { 0x0563, "Immersion Corp." },
    { 0x0564, "Kodak Digital Product Center, Japan Ltd. (formerly Chinon Industries Inc.)" },
    { 0x0565, "Peracom Networks, Inc." },
    { 0x0566, "Monterey International Corp." },
    { 0x0567, "Xyratex International, Ltd" },
    { 0x0568, "Quartz Ingenierie" },
    { 0x0569, "SegaSoft" },
    { 0x056a, "Wacom Co., Ltd" },
    { 0x056b, "Decicon, Inc." },
    { 0x056c, "eTEK Labs" },
    { 0x056d, "EIZO Corp." },
    { 0x056e, "Elecom Co., Ltd" },
    { 0x056f, "Korea Data Systems Co., Ltd" },
    { 0x0570, "Epson America" },
    { 0x0571, "Interex, Inc." },
    { 0x0572, "Conexant Systems (Rockwell), Inc." },
    { 0x0573, "Zoran Co. Personal Media Division (Nogatech)" },
    { 0x0574, "City University of Hong Kong" },
    { 0x0575, "Philips Creative Display Solutions" },
    { 0x0576, "BAFO/Quality Computer Accessories" },
    { 0x0577, "ELSA" },
    { 0x0578, "Intrinsix Corp." },
    { 0x0579, "GVC Corp." },
    { 0x057a, "Samsung Electronics America" },
    { 0x057b, "Y-E Data, Inc." },
    { 0x057c, "AVM GmbH" },
    { 0x057d, "Shark Multimedia, Inc." },
    { 0x057e, "Nintendo Co., Ltd" },
    { 0x057f, "QuickShot, Ltd" },
    { 0x0580, "Denron, Inc." },
    { 0x0581, "Racal Data Group" },
    { 0x0582, "Roland Corp." },
    { 0x0583, "Padix Co., Ltd (Rockfire)" },
    { 0x0584, "RATOC System, Inc." },
    { 0x0585, "FlashPoint Technology, Inc." },
    { 0x0586, "ZyXEL Communications Corp." },
    { 0x0587, "America Kotobuki Electronics Industries, Inc." },
    { 0x0588, "Sapien Design" },
    { 0x0589, "Victron" },
    { 0x058a, "Nohau Corp." },
    { 0x058b, "Infineon Technologies" },
    { 0x058c, "In Focus Systems" },
    { 0x058d, "Micrel Semiconductor" },
    { 0x058e, "Tripath Technology, Inc." },
    { 0x058f, "Alcor Micro Corp." },
    { 0x0590, "Omron Corp." },
    { 0x0591, "Questra Consulting" },
    { 0x0592, "Powerware Corp." },
    { 0x0593, "Incite" },
    { 0x0594, "Princeton Graphic Systems" },
    { 0x0595, "Zoran Microelectronics, Ltd" },
    { 0x0596, "MicroTouch Systems, Inc." },
    { 0x0597, "Trisignal Communications" },
    { 0x0598, "Niigata Canotec Co., Inc." },
    { 0x0599, "Brilliance Semiconductor, Inc." },
    { 0x059a, "Spectrum Signal Processing, Inc." },
    { 0x059b, "Iomega Corp." },
    { 0x059c, "A-Trend Technology Co., Ltd" },
    { 0x059d, "Advanced Input Devices" },
    { 0x059e, "Intelligent Instrumentation" },
    { 0x059f, "LaCie, Ltd" },
    { 0x05a0, "Vetronix Corp." },
    { 0x05a1, "USC Corp." },
    { 0x05a2, "Fuji Film Microdevices Co., Ltd" },
    { 0x05a3, "ARC International" },
    { 0x05a4, "Ortek Technology, Inc." },
    { 0x05a5, "Sampo Technology Corp." },
    { 0x05a6, "Cisco Systems, Inc." },
    { 0x05a7, "Bose Corp." },
    { 0x05a8, "Spacetec IMC Corp." },
    { 0x05a9, "OmniVision Technologies, Inc." },
    { 0x05aa, "Utilux South China, Ltd" },
    { 0x05ab, "In-System Design" },
    { 0x05ac, "Apple, Inc." },
    { 0x05ad, "Y.C. Cable U.S.A., Inc." },
    { 0x05ae, "Synopsys, Inc." },
    { 0x05af, "Jing-Mold Enterprise Co., Ltd" },
    { 0x05b0, "Fountain Technologies, Inc." },
    { 0x05b1, "First International Computer, Inc." },
    { 0x05b4, "LG Semicon Co., Ltd" },
    { 0x05b5, "Dialogic Corp." },
    { 0x05b6, "Proxima Corp." },
    { 0x05b7, "Medianix Semiconductor, Inc." },
    { 0x05b8, "SYSGRATION" },
    { 0x05b9, "Philips Research Laboratories" },
    { 0x05ba, "DigitalPersona, Inc." },
    { 0x05bb, "Grey Cell Systems" },
    { 0x05bc, "3G Green Green Globe Co., Ltd" },
    { 0x05bd, "RAFI GmbH & Co. KG" },
    { 0x05be, "Tyco Electronics (Raychem)" },
    { 0x05bf, "S & S Research" },
    { 0x05c0, "Keil Software" },
    { 0x05c1, "Kawasaki Microelectronics, Inc." },
    { 0x05c2, "Media Phonics (Suisse) S.A." },
    { 0x05c5, "Digi International, Inc." },
    { 0x05c6, "Qualcomm, Inc." },
    { 0x05c7, "Qtronix Corp." },
    { 0x05c8, "Cheng Uei Precision Industry Co., Ltd (Foxlink)" },
    { 0x05c9, "Semtech Corp." },
    { 0x05ca, "Ricoh Co., Ltd" },
    { 0x05cb, "PowerVision Technologies, Inc." },
    { 0x05cc, "ELSA AG" },
    { 0x05cd, "Silicom, Ltd" },
    { 0x05ce, "sci-worx GmbH" },
    { 0x05cf, "Sung Forn Co., Ltd" },
    { 0x05d0, "GE Medical Systems Lunar" },
    { 0x05d1, "Brainboxes, Ltd" },
    { 0x05d2, "Wave Systems Corp." },
    { 0x05d3, "Tohoku Ricoh Co., Ltd" },
    { 0x05d5, "Super Gate Technology Co., Ltd" },
    { 0x05d6, "Philips Semiconductors, CICT" },
    { 0x05d7, "Thomas & Betts Corp." },
    { 0x05d8, "Ultima Electronics Corp." },
    { 0x05d9, "Axiohm Transaction Solutions" },
    { 0x05da, "Microtek International, Inc." },
    { 0x05db, "Sun Corp. (Suntac?)" },
    { 0x05dc, "Lexar Media, Inc." },
    { 0x05dd, "Delta Electronics, Inc." },
    { 0x05df, "Silicon Vision, Inc." },
    { 0x05e0, "Symbol Technologies" },
    { 0x05e1, "Syntek Semiconductor Co., Ltd" },
    { 0x05e2, "ElecVision, Inc." },
    { 0x05e3, "Genesys Logic, Inc." },
    { 0x05e4, "Red Wing Corp." },
    { 0x05e5, "Fuji Electric Co., Ltd" },
    { 0x05e6, "Keithley Instruments" },
    { 0x05e8, "ICC, Inc." },
    { 0x05e9, "Kawasaki LSI" },
    { 0x05eb, "FFC, Ltd" },
    { 0x05ec, "COM21, Inc." },
    { 0x05ee, "Cytechinfo Inc." },
    { 0x05ef, "AVB, Inc. [anko?]" },
    { 0x05f0, "Canopus Co., Ltd" },
    { 0x05f1, "Compass Communications" },
    { 0x05f2, "Dexin Corp., Ltd" },
    { 0x05f3, "PI Engineering, Inc." },
    { 0x05f5, "Unixtar Technology, Inc." },
    { 0x05f6, "AOC International" },
    { 0x05f7, "RFC Distribution(s) PTE, Ltd" },
    { 0x05f9, "PSC Scanning, Inc." },
    { 0x05fa, "Siemens Telecommunications Systems, Ltd" },
    { 0x05fc, "Harman" },
    { 0x05fd, "InterAct, Inc." },
    { 0x05fe, "Chic Technology Corp." },
    { 0x05ff, "LeCroy Corp." },
    { 0x0600, "Barco Display Systems" },
    { 0x0601, "Jazz Hipster Corp." },
    { 0x0602, "Vista Imaging, Inc." },
    { 0x0603, "Novatek Microelectronics Corp." },
    { 0x0604, "Jean Co., Ltd" },
    { 0x0605, "Anchor C&C Co., Ltd" },
    { 0x0606, "Royal Information Electronics Co., Ltd" },
    { 0x0607, "Bridge Information Co., Ltd" },
    { 0x0608, "Genrad Ads" },
    { 0x0609, "SMK Manufacturing, Inc." },
    { 0x060a, "Worthington Data Solutions, Inc." },
    { 0x060b, "Solid Year" },
    { 0x060c, "EEH Datalink GmbH" },
    { 0x060d, "Auctor Corp." },
    { 0x060e, "Transmonde Technologies, Inc." },
    { 0x060f, "Joinsoon Electronics Mfg. Co., Ltd" },
    { 0x0610, "Costar Electronics, Inc." },
    { 0x0611, "Totoku Electric Co., Ltd" },
    { 0x0613, "TransAct Technologies, Inc." },
    { 0x0614, "Bio-Rad Laboratories" },
    { 0x0615, "Quabbin Wire & Cable Co., Inc." },
    { 0x0616, "Future Techno Designs PVT, Ltd" },
    { 0x0617, "Swiss Federal Insitute of Technology" },
    { 0x0618, "MacAlly" },
    { 0x0619, "Seiko Instruments, Inc." },
    { 0x061a, "Veridicom International, Inc." },
    { 0x061b, "Promptus Communications, Inc." },
    { 0x061c, "Act Labs, Ltd" },
    { 0x061d, "Quatech, Inc." },
    { 0x061e, "Nissei Electric Co." },
    { 0x0620, "Alaris, Inc." },
    { 0x0621, "ODU-Steckverbindungssysteme GmbH & Co. KG" },
    { 0x0622, "Iotech, Inc." },
    { 0x0623, "Littelfuse, Inc." },
    { 0x0624, "Avocent Corp." },
    { 0x0625, "TiMedia Technology Co., Ltd" },
    { 0x0626, "Nippon Systems Development Co., Ltd" },
    { 0x0627, "Adomax Technology Co., Ltd" },
    { 0x0628, "Tasking Software, Inc." },
    { 0x0629, "Zida Technologies, Ltd" },
    { 0x062a, "MosArt Semiconductor Corp." },
    { 0x062b, "Greatlink Electronics Taiwan, Ltd" },
    { 0x062c, "Institute for Information Industry" },
    { 0x062d, "Taiwan Tai-Hao Enterprises Co., Ltd" },
    { 0x062e, "Mainsuper Enterprises Co., Ltd" },
    { 0x062f, "Sin Sheng Terminal & Machine, Inc." },
    { 0x0631, "JUJO Electronics Corp." },
    { 0x0633, "Cyrix Corp." },
    { 0x0634, "Micron Technology, Inc." },
    { 0x0635, "Methode Electronics, Inc." },
    { 0x0636, "Sierra Imaging, Inc." },
    { 0x0638, "Avision, Inc." },
    { 0x0639, "Chrontel, Inc." },
    { 0x063a, "Techwin Corp." },
    { 0x063b, "Taugagreining HF" },
    { 0x063c, "Yamaichi Electronics Co., Ltd (Sakura)" },
    { 0x063d, "Fong Kai Industrial Co., Ltd" },
    { 0x063e, "RealMedia Technology, Inc." },
    { 0x063f, "New Technology Cable, Ltd" },
    { 0x0640, "Hitex Development Tools" },
    { 0x0641, "Woods Industries, Inc." },
    { 0x0642, "VIA Medical Corp." },
    { 0x0644, "TEAC Corp." },
    { 0x0645, "Who? Vision Systems, Inc." },
    { 0x0646, "UMAX" },
    { 0x0647, "Acton Research Corp." },
    { 0x0648, "Inside Out Networks" },
    { 0x0649, "Weli Science Co., Ltd" },
    { 0x064b, "Analog Devices, Inc. (White Mountain DSP)" },
    { 0x064c, "Ji-Haw Industrial Co., Ltd" },
    { 0x064d, "TriTech Microelectronics, Ltd" },
    { 0x064e, "Suyin Corp." },
    { 0x064f, "WIBU-Systems AG" },
    { 0x0650, "Dynapro Systems" },
    { 0x0651, "Likom Technology Sdn. Bhd." },
    { 0x0652, "Stargate Solutions, Inc." },
    { 0x0653, "CNF, Inc." },
    { 0x0654, "Granite Microsystems, Inc." },
    { 0x0655, "Space Shuttle Hi-Tech Co., Ltd" },
    { 0x0656, "Glory Mark Electronic, Ltd" },
    { 0x0657, "Tekcon Electronics Corp." },
    { 0x0658, "Sigma Designs, Inc." },
    { 0x0659, "Aethra" },
    { 0x065a, "Optoelectronics Co., Ltd" },
    { 0x065b, "Tracewell Systems" },
    { 0x065e, "Silicon Graphics" },
    { 0x065f, "Good Way Technology Co., Ltd & GWC technology Inc." },
    { 0x0660, "TSAY-E (BVI) International, Inc." },
    { 0x0661, "Hamamatsu Photonics K.K." },
    { 0x0662, "Kansai Electric Co., Ltd" },
    { 0x0663, "Topmax Electronic Co., Ltd" },
    { 0x0664, "ET&T Technology Co., Ltd." },
    { 0x0665, "Cypress Semiconductor" },
    { 0x0667, "Aiwa Co., Ltd" },
    { 0x0668, "WordWand" },
    { 0x0669, "Oce' Printing Systems GmbH" },
    { 0x066a, "Total Technologies, Ltd" },
    { 0x066b, "Linksys, Inc." },
    { 0x066d, "Entrega, Inc." },
    { 0x066e, "Acer Semiconductor America, Inc." },
    { 0x066f, "SigmaTel, Inc." },
    { 0x0670, "Sequel Imaging" },
    { 0x0672, "Labtec, Inc." },
    { 0x0673, "HCL" },
    { 0x0674, "Key Mouse Electronic Enterprise Co., Ltd" },
    { 0x0675, "DrayTek Corp." },
    { 0x0676, "Teles AG" },
    { 0x0677, "Aiwa Co., Ltd" },
    { 0x0678, "ACard Technology Corp." },
    { 0x067b, "Prolific Technology, Inc." },
    { 0x067c, "Efficient Networks, Inc." },
    { 0x067d, "Hohner Corp." },
    { 0x067e, "Intermec Technologies Corp." },
    { 0x067f, "Virata, Ltd" },
    { 0x0680, "Realtek Semiconductor Corp., CPP Div. (Avance Logic)" },
    { 0x0681, "Siemens Information and Communication Products" },
    { 0x0682, "Victor Company of Japan, Ltd" },
    { 0x0684, "Actiontec Electronics, Inc." },
    { 0x0685, "ZD Incorporated" },
    { 0x0686, "Minolta Co., Ltd" },
    { 0x068a, "Pertech, Inc." },
    { 0x068b, "Potrans International, Inc." },
    { 0x068e, "CH Products, Inc." },
    { 0x068f, "Nihon KOHDEN" },
    { 0x0690, "Golden Bridge Electech, Inc." },
    { 0x0693, "Hagiwara Sys-Com Co., Ltd" },
    { 0x0694, "Lego Group" },
    { 0x0698, "Chuntex (CTX)" },
    { 0x0699, "Tektronix, Inc." },
    { 0x069a, "Askey Computer Corp." },
    { 0x069b, "Thomson, Inc." },
    { 0x069d, "Hughes Network Systems (HNS)" },
    { 0x069e, "Welcat Inc." },
    { 0x069f, "Allied Data Technologies BV" },
    { 0x06a2, "Topro Technology, Inc." },
    { 0x06a3, "Saitek PLC" },
    { 0x06a4, "Xiamen Doowell Electron Co., Ltd" },
    { 0x06a5, "Divio" },
    { 0x06a7, "MicroStore, Inc." },
    { 0x06a8, "Topaz Systems, Inc." },
    { 0x06a9, "Westell" },
    { 0x06aa, "Sysgration, Ltd" },
    { 0x06ac, "Fujitsu Laboratories of America, Inc." },
    { 0x06ad, "Greatland Electronics Taiwan, Ltd" },
    { 0x06ae, "Professional Multimedia Testing Centre" },
    { 0x06af, "Harting, Inc. of North America" },
    { 0x06b8, "Pixela Corp." },
    { 0x06b9, "Alcatel Telecom" },
    { 0x06ba, "Smooth Cord & Connector Co., Ltd" },
    { 0x06bb, "EDA, Inc." },
    { 0x06bc, "Oki Data Corp." },
    { 0x06bd, "AGFA-Gevaert NV" },
    { 0x06be, "AME Optimedia Technology Co., Ltd" },
    { 0x06bf, "Leoco Corp." },
    { 0x06c2, "Phidgets Inc. (formerly GLAB)" },
    { 0x06c4, "Bizlink International Corp." },
    { 0x06c5, "Hagenuk, GmbH" },
    { 0x06c6, "Infowave Software, Inc." },
    { 0x06c8, "SIIG, Inc." },
    { 0x06c9, "Taxan (Europe), Ltd" },
    { 0x06ca, "Newer Technology, Inc." },
    { 0x06cb, "Synaptics, Inc." },
    { 0x06cc, "Terayon Communication Systems" },
    { 0x06cd, "Keyspan" },
    { 0x06ce, "Contec" },
    { 0x06cf, "SpheronVR AG" },
    { 0x06d0, "LapLink, Inc." },
    { 0x06d1, "Daewoo Electronics Co., Ltd" },
    { 0x06d3, "Mitsubishi Electric Corp." },
    { 0x06d4, "Cisco Systems" },
    { 0x06d5, "Toshiba" },
    { 0x06d6, "Aashima Technology B.V." },
    { 0x06d7, "Network Computing Devices (NCD)" },
    { 0x06d8, "Technical Marketing Research, Inc." },
    { 0x06da, "Phoenixtec Power Co., Ltd" },
    { 0x06db, "Paradyne" },
    { 0x06dc, "Foxlink Image Technology Co., Ltd" },
    { 0x06de, "Heisei Electronics Co., Ltd" },
    { 0x06e0, "Multi-Tech Systems, Inc." },
    { 0x06e1, "ADS Technologies, Inc." },
    { 0x06e4, "Alcatel Microelectronics" },
    { 0x06e6, "Tiger Jet Network, Inc." },
    { 0x06ea, "Sirius Technologies" },
    { 0x06eb, "PC Expert Tech. Co., Ltd" },
    { 0x06ef, "I.A.C. Geometrische Ingenieurs B.V." },
    { 0x06f0, "T.N.C Industrial Co., Ltd" },
    { 0x06f1, "Opcode Systems, Inc." },
    { 0x06f2, "Emine Technology Co." },
    { 0x06f6, "Wintrend Technology Co., Ltd" },
    { 0x06f7, "Wailly Technology Ltd" },
    { 0x06f8, "Guillemot Corp." },
    { 0x06f9, "ASYST electronic d.o.o." },
    { 0x06fa, "HSD S.r.L" },
    { 0x06fc, "Motorola Semiconductor Products Sector" },
    { 0x06fd, "Boston Acoustics" },
    { 0x06fe, "Gallant Computer, Inc." },
    { 0x0701, "Supercomal Wire & Cable SDN. BHD." },
    { 0x0703, "Bvtech Industry, Inc." },
    { 0x0705, "NKK Corp." },
    { 0x0706, "Ariel Corp." },
    { 0x0707, "Standard Microsystems Corp." },
    { 0x0708, "Putercom Co., Ltd" },
    { 0x0709, "Silicon Systems, Ltd (SSL)" },
    { 0x070a, "Oki Electric Industry Co., Ltd" },
    { 0x070d, "Comoss Electronic Co., Ltd" },
    { 0x070e, "Excel Cell Electronic Co., Ltd" },
    { 0x0710, "Connect Tech, Inc." },
    { 0x0711, "Magic Control Technology Corp." },
    { 0x0713, "Interval Research Corp." },
    { 0x0714, "NewMotion, Inc." },
    { 0x0717, "ZNK Corp." },
    { 0x0718, "Imation Corp." },
    { 0x0719, "Tremon Enterprises Co., Ltd" },
    { 0x071b, "Domain Technologies, Inc." },
    { 0x071c, "Xionics Document Technologies, Inc." },
    { 0x071d, "Eicon Networks Corp." },
    { 0x071e, "Ariston Technologies" },
    { 0x0720, "Keyence Corp." },
    { 0x0723, "Centillium Communications Corp." },
    { 0x0726, "Vanguard International Semiconductor-America" },
    { 0x0729, "Amitm" },
    { 0x072e, "Sunix Co., Ltd" },
    { 0x072f, "Advanced Card Systems, Ltd" },
    { 0x0731, "Susteen, Inc." },
    { 0x0732, "Goldfull Electronics & Telecommunications Corp." },
    { 0x0733, "ViewQuest Technologies, Inc." },
    { 0x0734, "Lasat Communications A/S" },
    { 0x0735, "Asuscom Network" },
    { 0x0736, "Lorom Industrial Co., Ltd" },
    { 0x0738, "Mad Catz, Inc." },
    { 0x073a, "Chaplet Systems, Inc." },
    { 0x073b, "Suncom Technologies" },
    { 0x073c, "Industrial Electronic Engineers, Inc." },
    { 0x073d, "Eutron S.p.a." },
    { 0x073e, "NEC, Inc." },
    { 0x0742, "Stollmann" },
    { 0x0745, "Syntech Information Co., Ltd" },
    { 0x0746, "Onkyo Corp." },
    { 0x0747, "Labway Corp." },
    { 0x0748, "Strong Man Enterprise Co., Ltd" },
    { 0x0749, "EVer Electronics Corp." },
    { 0x074a, "Ming Fortune Industry Co., Ltd" },
    { 0x074b, "Polestar Tech. Corp." },
    { 0x074c, "C-C-C Group PLC" },
    { 0x074d, "Micronas GmbH" },
    { 0x074e, "Digital Stream Corp." },
    { 0x0755, "Aureal Semiconductor" },
    { 0x0757, "Network Technologies, Inc." },
    { 0x0758, "Carl Zeiss Microscopy GmbH" },
    { 0x075b, "Sophisticated Circuits, Inc." },
    { 0x0763, "M-Audio" },
    { 0x0764, "Cyber Power System, Inc." },
    { 0x0765, "X-Rite, Inc." },
    { 0x0766, "Jess-Link Products Co., Ltd" },
    { 0x0767, "Tokheim Corp." },
    { 0x0768, "Camtel Technology Corp." },
    { 0x0769, "Surecom Technology Corp." },
    { 0x076a, "Smart Technology Enablers, Inc." },
    { 0x076b, "OmniKey AG" },
    { 0x076c, "Partner Tech" },
    { 0x076d, "Denso Corp." },
    { 0x076e, "Kuan Tech Enterprise Co., Ltd" },
    { 0x076f, "Jhen Vei Electronic Co., Ltd" },
    { 0x0770, "Welch Allyn, Inc - Medical Division" },
    { 0x0771, "Observator Instruments BV" },
    { 0x0772, "Your data Our Care" },
    { 0x0774, "AmTRAN Technology Co., Ltd" },
    { 0x0775, "Longshine Electronics Corp." },
    { 0x0776, "Inalways Corp." },
    { 0x0777, "Comda Enterprise Corp." },
    { 0x0778, "Volex, Inc." },
    { 0x0779, "ON Semiconductor (formerly Fairchild)" },
    { 0x077a, "Sankyo Seiki Mfg. Co., Ltd" },
    { 0x077b, "Linksys" },
    { 0x077c, "Forward Electronics Co., Ltd" },
    { 0x077d, "Griffin Technology" },
    { 0x077e, "Softing AG" },
    { 0x077f, "Well Excellent & Most Corp." },
    { 0x0780, "Sagem Monetel GmbH" },
    { 0x0781, "SanDisk Corp." },
    { 0x0782, "Trackerball" },
    { 0x0783, "C3PO" },
    { 0x0784, "Vivitar, Inc." },
    { 0x0785, "NTT-ME" },
    { 0x0789, "Logitec Corp." },
    { 0x078b, "Happ Controls, Inc." },
    { 0x078c, "GTCO/CalComp" },
    { 0x078e, "Brincom, Inc." },
    { 0x0790, "Pro-Image Manufacturing Co., Ltd" },
    { 0x0791, "Copartner Wire and Cable Mfg. Corp." },
    { 0x0792, "Axis Communications AB" },
    { 0x0793, "Wha Yu Industrial Co., Ltd" },
    { 0x0794, "ABL Electronics Corp." },
    { 0x0795, "RealChip, Inc." },
    { 0x0796, "Certicom Corp." },
    { 0x0797, "Grandtech Semiconductor Corp." },
    { 0x0798, "Optelec" },
    { 0x0799, "Altera" },
    { 0x079b, "Sagem" },
    { 0x079d, "Alfadata Computer Corp." },
    { 0x07a1, "Digicom S.p.A." },
    { 0x07a2, "National Technical Systems" },
    { 0x07a3, "Onnto Corp." },
    { 0x07a4, "Be, Inc." },
    { 0x07a6, "ADMtek, Inc." },
    { 0x07aa, "Corega K.K." },
    { 0x07ab, "Freecom Technologies" },
    { 0x07af, "Microtech" },
    { 0x07b0, "Trust Technologies" },
    { 0x07b1, "IMP, Inc." },
    { 0x07b2, "Motorola BCS, Inc." },
    { 0x07b3, "Plustek, Inc." },
    { 0x07b4, "Olympus Optical Co., Ltd" },
    { 0x07b5, "Mega World International, Ltd" },
    { 0x07b6, "Marubun Corp." },
    { 0x07b7, "TIME Interconnect, Ltd" },
    { 0x07b8, "AboCom Systems Inc" },
    { 0x07bc, "Canon Computer Systems, Inc." },
    { 0x07bd, "Webgear, Inc." },
    { 0x07be, "Veridicom" },
    { 0x07c0, "Code Mercenaries Hard- und Software GmbH" },
    { 0x07c1, "Keisokugiken" },
    { 0x07c4, "Datafab Systems, Inc." },
    { 0x07c5, "APG Cash Drawer" },
    { 0x07c6, "ShareWave, Inc." },
    { 0x07c7, "Powertech Industrial Co., Ltd" },
    { 0x07c8, "B.U.G., Inc." },
    { 0x07c9, "Allied Telesyn International" },
    { 0x07ca, "AVerMedia Technologies, Inc." },
    { 0x07cb, "Kingmax Technology, Inc." },
    { 0x07cc, "Carry Computer Eng., Co., Ltd" },
    { 0x07cd, "Elektor" },
    { 0x07ce, "Nidec Copal" },
    { 0x07cf, "Casio Computer Co., Ltd" },
    { 0x07d0, "Dazzle" },
    { 0x07d1, "D-Link System" },
    { 0x07d2, "Aptio Products, Inc." },
    { 0x07d3, "Cyberdata Corp." },
    { 0x07d5, "Radiant Systems" },
    { 0x07d7, "GCC Technologies, Inc." },
    { 0x07da, "Arasan Chip Systems" },
    { 0x07de, "Diamond Multimedia" },
    { 0x07df, "David Electronics Co., Ltd" },
    { 0x07e0, "NCP engineering GmbH" },
    { 0x07e1, "Ambient Technologies, Inc." },
    { 0x07e2, "Elmeg GmbH & Co., Ltd" },
    { 0x07e3, "Planex Communications, Inc." },
    { 0x07e4, "Movado Enterprise Co., Ltd" },
    { 0x07e5, "QPS, Inc." },
    { 0x07e6, "Allied Cable Corp." },
    { 0x07e7, "Mirvo Toys, Inc." },
    { 0x07e8, "Labsystems" },
    { 0x07ea, "Iwatsu Electric Co., Ltd" },
    { 0x07eb, "Double-H Technology Co., Ltd" },
    { 0x07ec, "Taiyo Electric Wire & Cable Co., Ltd" },
    { 0x07ee, "Torex Retail (formerly Logware)" },
    { 0x07ef, "STSN" },
    { 0x07f2, "Microcomputer Applications, Inc." },
    { 0x07f6, "Circuit Assembly Corp." },
    { 0x07f7, "Century Corp." },
    { 0x07f9, "Dotop Technology, Inc." },
    { 0x07fa, "DrayTek Corp." },
    { 0x07fc, "Thomann" },
    { 0x07fd, "Mark of the Unicorn" },
    { 0x07ff, "Unknown" },
    { 0x0801, "MagTek" },
    { 0x0802, "Mako Technologies, LLC" },
    { 0x0803, "Zoom Telephonics, Inc." },
    { 0x0809, "Genicom Technology, Inc." },
    { 0x080a, "Evermuch Technology Co., Ltd" },
    { 0x080b, "Cross Match Technologies" },
    { 0x080c, "Datalogic S.p.A." },
    { 0x080d, "Teco Image Systems Co., Ltd" },
    { 0x0810, "Personal Communication Systems, Inc." },
    { 0x0813, "Mattel, Inc." },
    { 0x0819, "eLicenser" },
    { 0x081a, "MG Logic" },
    { 0x081b, "Indigita Corp." },
    { 0x081c, "Mipsys" },
    { 0x081e, "AlphaSmart, Inc." },
    { 0x081f, "Manta" },
    { 0x0822, "Reudo Corp." },
    { 0x0825, "GC Protronics" },
    { 0x0826, "Data Transit" },
    { 0x0827, "BroadLogic, Inc." },
    { 0x0828, "Sato Corp." },
    { 0x0829, "DirecTV Broadband, Inc. (Telocity)" },
    { 0x082d, "Handspring" },
    { 0x0830, "Palm, Inc." },
    { 0x0832, "Kouwell Electronics Corp." },
    { 0x0833, "Sourcenext Corp." },
    { 0x0835, "Action Star Enterprise Co., Ltd" },
    { 0x0836, "TrekStor" },
    { 0x0839, "Samsung Techwin Co., Ltd" },
    { 0x083a, "Accton Technology Corp." },
    { 0x083f, "Global Village" },
    { 0x0840, "Argosy Research, Inc." },
    { 0x0841, "Rioport.com, Inc." },
    { 0x0844, "Welland Industrial Co., Ltd" },
    { 0x0846, "NetGear, Inc." },
    { 0x084d, "Minton Optic Industry Co., Inc." },
    { 0x084e, "KB Gear" },
    { 0x084f, "Empeg" },
    { 0x0850, "Fast Point Technologies, Inc." },
    { 0x0851, "Macronix International Co., Ltd" },
    { 0x0852, "CSEM" },
    { 0x0853, "Topre Corporation" },
    { 0x0854, "ActiveWire, Inc." },
    { 0x0856, "B&B Electronics" },
    { 0x0858, "Hitachi Maxell, Ltd" },
    { 0x0859, "Minolta Systems Laboratory, Inc." },
    { 0x085a, "Xircom" },
    { 0x085c, "ColorVision, Inc." },
    { 0x0862, "Teletrol Systems, Inc." },
    { 0x0863, "Filanet Corp." },
    { 0x0864, "NetGear, Inc." },
    { 0x0867, "Data Translation, Inc." },
    { 0x086a, "Emagic Soft- und Hardware GmbH" },
    { 0x086c, "DeTeWe - Deutsche Telephonwerke AG & Co." },
    { 0x086e, "System TALKS, Inc." },
    { 0x086f, "MEC IMEX, Inc." },
    { 0x0870, "Metricom" },
    { 0x0871, "SanDisk, Inc." },
    { 0x0873, "Xpeed, Inc." },
    { 0x0874, "A-Tec Subsystem, Inc." },
    { 0x0879, "Comtrol Corp." },
    { 0x087c, "Adesso/Kbtek America, Inc." },
    { 0x087d, "Jaton Corp." },
    { 0x087e, "Fujitsu Computer Products of America" },
    { 0x087f, "QualCore Logic Inc." },
    { 0x0880, "APT Technologies, Inc." },
    { 0x0883, "Recording Industry Association of America (RIAA)" },
    { 0x0885, "Boca Research, Inc." },
    { 0x0886, "XAC Automation Corp." },
    { 0x0887, "Hannstar Electronics Corp." },
    { 0x088a, "TechTools" },
    { 0x088b, "MassWorks, Inc." },
    { 0x088c, "Swecoin AB" },
    { 0x088e, "iLok" },
    { 0x0892, "DioGraphy, Inc." },
    { 0x0894, "TSI Incorporated" },
    { 0x0897, "Lauterbach" },
    { 0x089c, "United Technologies Research Cntr." },
    { 0x089d, "Icron Technologies Corp." },
    { 0x089e, "NST Co., Ltd" },
    { 0x089f, "Primex Aerospace Co." },
    { 0x08a5, "e9, Inc." },
    { 0x08a6, "Toshiba TEC" },
    { 0x08a8, "Andrea Electronics" },
    { 0x08a9, "CWAV Inc." },
    { 0x08ac, "Macraigor Systems LLC" },
    { 0x08ae, "Macally (Mace Group, Inc.)" },
    { 0x08b0, "Metrohm" },
    { 0x08b4, "Sorenson Vision, Inc." },
    { 0x08b7, "NATSU" },
    { 0x08b8, "J. Gordon Electronic Design, Inc." },
    { 0x08b9, "RadioShack Corp. (Tandy)" },
    { 0x08bb, "Texas Instruments" },
    { 0x08bd, "Citizen Watch Co., Ltd" },
    { 0x08c3, "Precise Biometrics" },
    { 0x08c4, "Proxim, Inc." },
    { 0x08c7, "Key Nice Enterprise Co., Ltd" },
    { 0x08c8, "2Wire, Inc." },
    { 0x08c9, "Nippon Telegraph and Telephone Corp." },
    { 0x08ca, "Aiptek International, Inc." },
    { 0x08cd, "Jue Hsun Ind. Corp." },
    { 0x08ce, "Long Well Electronics Corp." },
    { 0x08cf, "Productivity Enhancement Products" },
    { 0x08d1, "smartBridges, Inc." },
    { 0x08d3, "Virtual Ink" },
    { 0x08d4, "Fujitsu Siemens Computers" },
    { 0x08d8, "IXXAT Automation GmbH" },
    { 0x08d9, "Increment P Corp." },
    { 0x08dd, "Billionton Systems, Inc." },
    { 0x08de, "?" },
    { 0x08df, "Spyrus, Inc." },
    { 0x08e3, "Olitec, Inc." },
    { 0x08e4, "Pioneer Corp." },
    { 0x08e5, "Litronic" },
    { 0x08e6, "Gemalto (was Gemplus)" },
    { 0x08e7, "Pan-International Wire & Cable" },
    { 0x08e8, "Integrated Memory Logic" },
    { 0x08e9, "Extended Systems, Inc." },
    { 0x08ea, "Ericsson, Inc., Blue Ridge Labs" },
    { 0x08ec, "M-Systems Flash Disk Pioneers" },
    { 0x08ed, "MediaTek Inc." },
    { 0x08ee, "CCSI/Hesso" },
    { 0x08f0, "Corex Technologies" },
    { 0x08f1, "CTI Electronics Corp." },
    { 0x08f2, "Gotop Information Inc." },
    { 0x08f5, "SysTec Co., Ltd" },
    { 0x08f6, "Logic 3 International, Ltd" },
    { 0x08f7, "Vernier" },
    { 0x08f8, "Keen Top International Enterprise Co., Ltd" },
    { 0x08f9, "Wipro Technologies" },
    { 0x08fa, "Caere" },
    { 0x08fb, "Socket Communications" },
    { 0x08fc, "Sicon Cable Technology Co., Ltd" },
    { 0x08fd, "Digianswer A/S" },
    { 0x08ff, "AuthenTec, Inc." },
    { 0x0900, "Pinnacle Systems, Inc." },
    { 0x0901, "VST Technologies" },
    { 0x0906, "Faraday Technology Corp." },
    { 0x0908, "Siemens AG" },
    { 0x0909, "Audio-Technica Corp." },
    { 0x090a, "Trumpion Microelectronics, Inc." },
    { 0x090b, "Neurosmith" },
    { 0x090c, "Silicon Motion, Inc. - Taiwan (formerly Feiya Technology Corp.)" },
    { 0x090d, "Multiport Computer Vertriebs GmbH" },
    { 0x090e, "Shining Technology, Inc." },
    { 0x090f, "Fujitsu Devices, Inc." },
    { 0x0910, "Alation Systems, Inc." },
    { 0x0911, "Philips Speech Processing" },
    { 0x0912, "Voquette, Inc." },
    { 0x0915, "GlobeSpan, Inc." },
    { 0x0917, "SmartDisk Corp." },
    { 0x0919, "Tiger Electronics" },
    { 0x091e, "Garmin International" },
    { 0x0920, "Echelon Co." },
    { 0x0921, "GoHubs, Inc." },
    { 0x0922, "Dymo-CoStar Corp." },
    { 0x0923, "IC Media Corp." },
    { 0x0924, "Xerox" },
    { 0x0925, "Lakeview Research" },
    { 0x0927, "Summus, Ltd" },
    { 0x0928, "PLX Technology, Inc. (formerly Oxford Semiconductor, Ltd)" },
    { 0x0929, "American Biometric Co." },
    { 0x092a, "Toshiba Information & Industrial Sys. And Services" },
    { 0x092b, "Sena Technologies, Inc." },
    { 0x092f, "Northern Embedded Science/CAVNEX" },
    { 0x0930, "Toshiba Corp." },
    { 0x0931, "Harmonic Data Systems, Ltd" },
    { 0x0932, "Crescentec Corp." },
    { 0x0933, "Quantum Corp." },
    { 0x0934, "Spirent Communications" },
    { 0x0936, "NuTesla" },
    { 0x0939, "Lumberg, Inc." },
    { 0x093a, "Pixart Imaging, Inc." },
    { 0x093b, "Plextor Corp." },
    { 0x093c, "Intrepid Control Systems, Inc." },
    { 0x093d, "InnoSync, Inc." },
    { 0x093e, "J.S.T. Mfg. Co., Ltd" },
    { 0x093f, "Olympia Telecom Vertriebs GmbH" },
    { 0x0940, "Japan Storage Battery Co., Ltd" },
    { 0x0941, "Photobit Corp." },
    { 0x0942, "i2Go.com, LLC" },
    { 0x0943, "HCL Technologies India Private, Ltd" },
    { 0x0944, "KORG, Inc." },
    { 0x0945, "Pasco Scientific" },
    { 0x0948, "Kronauer music in digital" },
    { 0x094b, "Linkup Systems Corp." },
    { 0x094d, "Cable Television Laboratories" },
    { 0x094f, "Yano" },
    { 0x0951, "Kingston Technology" },
    { 0x0954, "RPM Systems Corp." },
    { 0x0955, "NVIDIA Corp." },
    { 0x0956, "BSquare Corp." },
    { 0x0957, "Agilent Technologies, Inc." },
    { 0x0958, "CompuLink Research, Inc." },
    { 0x0959, "Cologne Chip AG" },
    { 0x095a, "Portsmith" },
    { 0x095b, "Medialogic Corp." },
    { 0x095c, "K-Tec Electronics" },
    { 0x095d, "Polycom, Inc." },
    { 0x0964, "BITRAN" },
    { 0x0967, "Acer NeWeb Corp." },
    { 0x0968, "Catalyst Enterprises, Inc." },
    { 0x096e, "Feitian Technologies, Inc." },
    { 0x0971, "Gretag-Macbeth AG" },
    { 0x0973, "Schlumberger" },
    { 0x0974, "Datagraphix, a business unit of Anacomp" },
    { 0x0975, "OL'E Communications, Inc." },
    { 0x0976, "Adirondack Wire & Cable" },
    { 0x0977, "Lightsurf Technologies" },
    { 0x0978, "Beckhoff GmbH" },
    { 0x0979, "Jeilin Technology Corp., Ltd" },
    { 0x097a, "Minds At Work LLC" },
    { 0x097b, "Knudsen Engineering, Ltd" },
    { 0x097c, "Marunix Co., Ltd" },
    { 0x097d, "Rosun Technologies, Inc." },
    { 0x097e, "Biopac Systems Inc." },
    { 0x097f, "Barun Electronics Co., Ltd" },
    { 0x0981, "Oak Technology, Ltd" },
    { 0x0984, "Apricorn" },
    { 0x0985, "cab Produkttechnik GmbH & Co KG" },
    { 0x0986, "Matsushita Electric Works, Ltd." },
    { 0x098c, "Vitana Corp." },
    { 0x098d, "INDesign" },
    { 0x098e, "Integrated Intellectual Property, Inc." },
    { 0x098f, "Kenwood TMI Corp." },
    { 0x0993, "Gemstar eBook Group, Ltd" },
    { 0x0996, "Integrated Telecom Express, Inc." },
    { 0x099a, "Zippy Technology Corp." },
    { 0x099e, "Trimble Navigation, Ltd" },
    { 0x09a3, "PairGain Technologies" },
    { 0x09a4, "Contech Research, Inc." },
    { 0x09a5, "VCON Telecommunications" },
    { 0x09a6, "Poinchips" },
    { 0x09a7, "Data Transmission Network Corp." },
    { 0x09a8, "Lin Shiung Enterprise Co., Ltd" },
    { 0x09a9, "Smart Card Technologies Co., Ltd" },
    { 0x09aa, "Intersil Corp." },
    { 0x09ab, "Japan Cash Machine Co., Ltd." },
    { 0x09ae, "Tripp Lite" },
    { 0x09b0, "Fargo" },
    { 0x09b2, "Franklin Electronic Publishers, Inc." },
    { 0x09b3, "Altius Solutions, Inc." },
    { 0x09b4, "MDS Telephone Systems" },
    { 0x09b5, "Celltrix Technology Co., Ltd" },
    { 0x09bc, "Grundig" },
    { 0x09be, "MySmart.Com" },
    { 0x09bf, "Auerswald GmbH & Co. KG" },
    { 0x09c0, "Genpix Electronics, LLC" },
    { 0x09c1, "Arris Interactive LLC" },
    { 0x09c2, "Nisca Corp." },
    { 0x09c3, "HID Global" },
    { 0x09c4, "ACTiSYS Corp." },
    { 0x09c5, "Memory Corp." },
    { 0x09ca, "BMC Messsysteme GmbH" },
    { 0x09cb, "FLIR Systems" },
    { 0x09cc, "Workbit Corp." },
    { 0x09cd, "Psion Dacom Home Networks, Ltd" },
    { 0x09ce, "City Electronics, Ltd" },
    { 0x09cf, "Electronics Testing Center, Taiwan" },
    { 0x09d1, "NeoMagic, Inc." },
    { 0x09d2, "Vreelin Engineering, Inc." },
    { 0x09d3, "Com One" },
    { 0x09d7, "Hexagon NovAtel Inc." },
    { 0x09d8, "ELATEC GmbH" },
    { 0x09d9, "KRF Tech, Ltd" },
    { 0x09da, "A4Tech Co., Ltd." },
    { 0x09db, "Measurement Computing Corp." },
    { 0x09dc, "Aimex Corp." },
    { 0x09dd, "Fellowes, Inc." },
    { 0x09df, "Addonics Technologies Corp." },
    { 0x09e1, "Intellon Corp." },
    { 0x09e5, "Jo-Dan International, Inc." },
    { 0x09e6, "Silutia, Inc." },
    { 0x09e7, "Real 3D, Inc." },
    { 0x09e8, "AKAI  Professional M.I. Corp." },
    { 0x09e9, "Chen-Source, Inc." },
    { 0x09eb, "IM Networks, Inc." },
    { 0x09ef, "Xitel" },
    { 0x09f3, "GoFlight, Inc." },
    { 0x09f5, "AresCom" },
    { 0x09f6, "RocketChips, Inc." },
    { 0x09f7, "Edu-Science (H.K.), Ltd" },
    { 0x09f8, "SoftConnex Technologies, Inc." },
    { 0x09f9, "Bay Associates" },
    { 0x09fa, "Mtek Vision" },
    { 0x09fb, "Altera" },
    { 0x09ff, "Gain Technology Corp." },
    { 0x0a00, "Liquid Audio" },
    { 0x0a01, "ViA, Inc." },
    { 0x0a05, "Unknown Manufacturer" },
    { 0x0a07, "Ontrak Control Systems Inc." },
    { 0x0a0b, "Cybex Computer Products Co." },
    { 0x0a0d, "Servergy, Inc" },
    { 0x0a11, "Xentec, Inc." },
    { 0x0a12, "Cambridge Silicon Radio, Ltd" },
    { 0x0a13, "Telebyte, Inc." },
    { 0x0a14, "Spacelabs Medical, Inc." },
    { 0x0a15, "Scalar Corp." },
    { 0x0a16, "Trek Technology (S) PTE, Ltd" },
    { 0x0a17, "Pentax Corp." },
    { 0x0a18, "Heidelberger Druckmaschinen AG" },
    { 0x0a19, "Hua Geng Technologies, Inc." },
    { 0x0a21, "Medtronic Physio Control Corp." },
    { 0x0a22, "Century Semiconductor USA, Inc." },
    { 0x0a27, "Datacard Group" },
    { 0x0a2c, "AK-Modul-Bus Computer GmbH" },
    { 0x0a34, "TG3 Electronics, Inc." },
    { 0x0a35, "Radikal Technologies" },
    { 0x0a39, "Gilat Satellite Networks, Ltd" },
    { 0x0a3a, "PentaMedia Co., Ltd" },
    { 0x0a3c, "NTT DoCoMo, Inc." },
    { 0x0a3d, "Varo Vision" },
    { 0x0a3f, "Swissonic AG" },
    { 0x0a43, "Boca Systems, Inc." },
    { 0x0a46, "Davicom Semiconductor, Inc." },
    { 0x0a47, "Hirose Electric" },
    { 0x0a48, "I/O Interconnect" },
    { 0x0a4a, "Ploytec GmbH" },
    { 0x0a4b, "Fujitsu Media Devices, Ltd" },
    { 0x0a4c, "Computex Co., Ltd" },
    { 0x0a4d, "Evolution Electronics, Ltd" },
    { 0x0a4e, "Steinberg Soft-und Hardware GmbH" },
    { 0x0a4f, "Litton Systems, Inc." },
    { 0x0a50, "Mimaki Engineering Co., Ltd" },
    { 0x0a51, "Sony Electronics, Inc." },
    { 0x0a52, "Jebsee Electronics Co., Ltd" },
    { 0x0a53, "Portable Peripheral Co., Ltd" },
    { 0x0a5a, "Electronics For Imaging, Inc." },
    { 0x0a5b, "EAsics NV" },
    { 0x0a5c, "Broadcom Corp." },
    { 0x0a5d, "Diatrend Corp." },
    { 0x0a5f, "Zebra" },
    { 0x0a62, "MPMan" },
    { 0x0a66, "ClearCube Technology" },
    { 0x0a67, "Medeli Electronics Co., Ltd" },
    { 0x0a68, "Comaide Corp." },
    { 0x0a69, "Chroma ate, Inc." },
    { 0x0a6b, "Green House Co., Ltd" },
    { 0x0a6c, "Integrated Circuit Systems, Inc." },
    { 0x0a6d, "UPS Manufacturing" },
    { 0x0a6e, "Benwin" },
    { 0x0a6f, "Core Technology, Inc." },
    { 0x0a70, "International Game Technology" },
    { 0x0a71, "VIPColor Technologies USA, Inc." },
    { 0x0a72, "Sanwa Denshi" },
    { 0x0a73, "Mackie Designs" },
    { 0x0a7d, "NSTL, Inc." },
    { 0x0a7e, "Octagon Systems Corp." },
    { 0x0a80, "Rexon Technology Corp., Ltd" },
    { 0x0a81, "Chesen Electronics Corp." },
    { 0x0a82, "Syscan" },
    { 0x0a83, "NextComm, Inc." },
    { 0x0a84, "Maui Innovative Peripherals" },
    { 0x0a85, "Idexx Labs" },
    { 0x0a86, "NITGen Co., Ltd" },
    { 0x0a89, "Aktiv" },
    { 0x0a8d, "Picturetel" },
    { 0x0a8e, "Japan Aviation Electronics Industry, Ltd" },
    { 0x0a90, "Candy Technology Co., Ltd" },
    { 0x0a91, "Globlink Technology, Inc." },
    { 0x0a92, "EGO SYStems, Inc." },
    { 0x0a93, "C Technologies AB" },
    { 0x0a94, "Intersense" },
    { 0x0aa3, "Lava Computer Mfg., Inc." },
    { 0x0aa4, "Develco Elektronik" },
    { 0x0aa5, "First International Digital" },
    { 0x0aa6, "Perception Digital, Ltd" },
    { 0x0aa7, "Wincor Nixdorf International GmbH" },
    { 0x0aa8, "TriGem Computer, Inc." },
    { 0x0aa9, "Baromtec Co." },
    { 0x0aaa, "Japan CBM Corp." },
    { 0x0aab, "Vision Shape Europe SA" },
    { 0x0aac, "iCompression, Inc." },
    { 0x0aad, "Rohde & Schwarz GmbH & Co. KG" },
    { 0x0aae, "NEC infrontia Corp. (Nitsuko)" },
    { 0x0aaf, "Digitalway Co., Ltd" },
    { 0x0ab0, "Arrow Strong Electronics Co., Ltd" },
    { 0x0ab1, "FEIG ELECTRONIC GmbH" },
    { 0x0aba, "Ellisys" },
    { 0x0abe, "Stereo-Link" },
    { 0x0abf, "Diolan" },
    { 0x0ac3, "Sanyo Semiconductor Company Micro" },
    { 0x0ac4, "Leco Corp." },
    { 0x0ac5, "I & C Corp." },
    { 0x0ac6, "Singing Electrons, Inc." },
    { 0x0ac7, "Panwest Corp." },
    { 0x0ac8, "Z-Star Microelectronics Corp." },
    { 0x0ac9, "Micro Solutions, Inc." },
    { 0x0aca, "OPEN Networks Ltd" },
    { 0x0acc, "Koga Electronics Co." },
    { 0x0acd, "ID Tech" },
    { 0x0ace, "ZyDAS" },
    { 0x0acf, "Intoto, Inc." },
    { 0x0ad0, "Intellix Corp." },
    { 0x0ad1, "Remotec Technology, Ltd" },
    { 0x0ad2, "Service & Quality Technology Co., Ltd" },
    { 0x0ada, "Data Encryption Systems Ltd." },
    { 0x0ae3, "Allion Computer, Inc." },
    { 0x0ae4, "Taito Corp." },
    { 0x0ae7, "Neodym Systems, Inc." },
    { 0x0ae8, "System Support Co., Ltd" },
    { 0x0ae9, "North Shore Circuit Design L.L.P." },
    { 0x0aea, "SciEssence, LLC" },
    { 0x0aeb, "TTP Communications, Ltd" },
    { 0x0aec, "Neodio Technologies Corp." },
    { 0x0af0, "Option" },
    { 0x0af6, "Silver I Co., Ltd" },
    { 0x0af7, "B2C2, Inc." },
    { 0x0af9, "Hama, Inc." },
    { 0x0afa, "DMC Co., Ltd." },
    { 0x0afc, "Zaptronix Ltd" },
    { 0x0afd, "Tateno Dennou, Inc." },
    { 0x0afe, "Cummins Engine Co." },
    { 0x0aff, "Jump Zone Network Products, Inc." },
    { 0x0b00, "INGENICO" },
    { 0x0b05, "ASUSTek Computer, Inc." },
    { 0x0b0b, "Datamax-O'Neil" },
    { 0x0b0c, "Todos AB" },
    { 0x0b0d, "ProjectLab" },
    { 0x0b0e, "GN Netcom" },
    { 0x0b0f, "AVID Technology" },
    { 0x0b10, "Pcally" },
    { 0x0b11, "I Tech Solutions Co., Ltd" },
    { 0x0b1e, "Electronic Warfare Assoc., Inc. (EWA)" },
    { 0x0b1f, "Insyde Software Corp." },
    { 0x0b20, "TransDimension, Inc." },
    { 0x0b21, "Yokogawa Electric Corp." },
    { 0x0b22, "Japan System Development Co., Ltd" },
    { 0x0b23, "Pan-Asia Electronics Co., Ltd" },
    { 0x0b24, "Link Evolution Corp." },
    { 0x0b27, "Ritek Corp." },
    { 0x0b28, "Kenwood Corp." },
    { 0x0b2c, "Village Center, Inc." },
    { 0x0b30, "PNY Technologies, Inc." },
    { 0x0b33, "Contour Design, Inc." },
    { 0x0b37, "Hitachi ULSI Systems Co., Ltd" },
    { 0x0b38, "Gear Head" },
    { 0x0b39, "Omnidirectional Control Technology, Inc." },
    { 0x0b3a, "IPaxess" },
    { 0x0b3b, "Tekram Technology Co., Ltd" },
    { 0x0b3c, "Olivetti Techcenter" },
    { 0x0b3e, "Kikusui Electronics Corp." },
    { 0x0b41, "Hal Corp." },
    { 0x0b43, "Play.com, Inc." },
    { 0x0b47, "Sportbug.com, Inc." },
    { 0x0b48, "TechnoTrend AG" },
    { 0x0b49, "ASCII Corp." },
    { 0x0b4b, "Pine Corp. Ltd." },
    { 0x0b4d, "Graphtec America, Inc." },
    { 0x0b4e, "Musical Electronics, Ltd" },
    { 0x0b50, "Dumpries Co., Ltd" },
    { 0x0b51, "Comfort Keyboard Co." },
    { 0x0b52, "Colorado MicroDisplay, Inc." },
    { 0x0b54, "Sinbon Electronics Co., Ltd" },
    { 0x0b56, "TYI Systems, Ltd" },
    { 0x0b57, "Beijing HanwangTechnology Co., Ltd" },
    { 0x0b59, "Lake Communications, Ltd" },
    { 0x0b5a, "Corel Corp." },
    { 0x0b5f, "Green Electronics Co., Ltd" },
    { 0x0b60, "Nsine, Ltd" },
    { 0x0b61, "NEC Viewtechnology, Ltd" },
    { 0x0b62, "Orange Micro, Inc." },
    { 0x0b63, "ADLink Technology, Inc." },
    { 0x0b64, "Wonderful Wire Cable Co., Ltd" },
    { 0x0b65, "Expert Magnetics Corp." },
    { 0x0b66, "Cybiko Inc." },
    { 0x0b67, "Fairbanks Scales" },
    { 0x0b69, "CacheVision" },
    { 0x0b6a, "Maxim Integrated Products" },
    { 0x0b6f, "Nagano Japan Radio Co., Ltd" },
    { 0x0b70, "PortalPlayer, Inc." },
    { 0x0b71, "SHIN-EI Sangyo Co., Ltd" },
    { 0x0b72, "Embedded Wireless Technology Co., Ltd" },
    { 0x0b73, "Computone Corp." },
    { 0x0b75, "Roland DG Corp." },
    { 0x0b79, "Sunrise Telecom, Inc." },
    { 0x0b7a, "Zeevo, Inc." },
    { 0x0b7b, "Taiko Denki Co., Ltd" },
    { 0x0b7c, "ITRAN Communications, Ltd" },
    { 0x0b7d, "Astrodesign, Inc." },
    { 0x0b81, "id3 Technologies" },
    { 0x0b84, "Rextron Technology, Inc." },
    { 0x0b85, "Elkat Electronics, Sdn., Bhd." },
    { 0x0b86, "Exputer Systems, Inc." },
    { 0x0b87, "Plus-One I & T, Inc." },
    { 0x0b88, "Sigma Koki Co., Ltd, Technology Center" },
    { 0x0b89, "Advanced Digital Broadcast, Ltd" },
    { 0x0b8c, "SMART Technologies Inc." },
    { 0x0b95, "ASIX Electronics Corp." },
    { 0x0b96, "Sewon Telecom" },
    { 0x0b97, "O2 Micro, Inc." },
    { 0x0b98, "Playmates Toys, Inc." },
    { 0x0b99, "Audio International, Inc." },
    { 0x0b9b, "Dipl.-Ing. Stefan Kunde" },
    { 0x0b9d, "Softprotec Co." },
    { 0x0b9f, "Chippo Technologies" },
    { 0x0baf, "U.S. Robotics" },
    { 0x0bb0, "Concord Camera Corp." },
    { 0x0bb1, "Infinilink Corp." },
    { 0x0bb2, "Ambit Microsystems Corp." },
    { 0x0bb3, "Ofuji Technology" },
    { 0x0bb4, "HTC (High Tech Computer Corp.)" },
    { 0x0bb5, "Murata Manufacturing Co., Ltd" },
    { 0x0bb6, "Network Alchemy" },
    { 0x0bb7, "Joytech Computer Co., Ltd" },
    { 0x0bb8, "Hitachi Semiconductor and Devices Sales Co., Ltd" },
    { 0x0bb9, "Eiger M&C Co., Ltd" },
    { 0x0bba, "ZAccess Systems" },
    { 0x0bbb, "General Meters Corp." },
    { 0x0bbc, "Assistive Technology, Inc." },
    { 0x0bbd, "System Connection, Inc." },
    { 0x0bc0, "Knilink Technology, Inc." },
    { 0x0bc1, "Fuw Yng Electronics Co., Ltd" },
    { 0x0bc2, "Seagate RSS LLC" },
    { 0x0bc3, "IPWireless, Inc." },
    { 0x0bc4, "Microcube Corp." },
    { 0x0bc5, "JCN Co., Ltd" },
    { 0x0bc6, "ExWAY, Inc." },
    { 0x0bc7, "X10 Wireless Technology, Inc." },
    { 0x0bc8, "Telmax Communications" },
    { 0x0bc9, "ECI Telecom, Ltd" },
    { 0x0bca, "Startek Engineering, Inc." },
    { 0x0bcb, "Perfect Technic Enterprise Co., Ltd" },
    { 0x0bd7, "Andrew Pargeter & Associates" },
    { 0x0bda, "Realtek Semiconductor Corp." },
    { 0x0bdb, "Ericsson Business Mobile Networks BV" },
    { 0x0bdc, "Y Media Corp." },
    { 0x0bdd, "Orange PCS" },
    { 0x0be2, "Kanda Tsushin Kogyo Co., Ltd" },
    { 0x0be3, "TOYO Corp." },
    { 0x0be4, "Elka International, Ltd" },
    { 0x0be5, "DOME imaging systems, Inc." },
    { 0x0be6, "Dong Guan Humen Wonderful Wire Cable Factory" },
    { 0x0bed, "MEI" },
    { 0x0bee, "LTK Industries, Ltd" },
    { 0x0bef, "Way2Call Communications" },
    { 0x0bf0, "Pace Micro Technology PLC" },
    { 0x0bf1, "Intracom S.A." },
    { 0x0bf2, "Konexx" },
    { 0x0bf6, "Addonics Technologies, Inc." },
    { 0x0bf7, "Sunny Giken, Inc." },
    { 0x0bf8, "Fujitsu Siemens Computers" },
    { 0x0bfb, "Grass Valley Group" },
    { 0x0bfd, "Kvaser AB" },
    { 0x0c00, "FireFly Mouse Mat" },
    { 0x0c04, "MOTO Development Group, Inc." },
    { 0x0c05, "Appian Graphics" },
    { 0x0c06, "Hasbro Games, Inc." },
    { 0x0c07, "Infinite Data Storage, Ltd" },
    { 0x0c08, "Agate" },
    { 0x0c09, "Comjet Information System" },
    { 0x0c0a, "Highpoint Technologies, Inc." },
    { 0x0c0b, "Dura Micro, Inc. (Acomdata)" },
    { 0x0c12, "Zeroplus" },
    { 0x0c15, "Iris Graphics" },
    { 0x0c16, "Gyration, Inc." },
    { 0x0c17, "Cyberboard A/S" },
    { 0x0c18, "SynerTek Korea, Inc." },
    { 0x0c19, "cyberPIXIE, Inc." },
    { 0x0c1a, "Silicon Motion, Inc." },
    { 0x0c1b, "MIPS Technologies" },
    { 0x0c1c, "Hang Zhou Silan Electronics Co., Ltd" },
    { 0x0c1f, "Magicard" },
    { 0x0c22, "Tally Printer Corp." },
    { 0x0c23, "Lernout + Hauspie" },
    { 0x0c24, "Taiyo Yuden" },
    { 0x0c25, "Sampo Corp." },
    { 0x0c26, "Prolific Technology Inc." },
    { 0x0c27, "RFIDeas, Inc" },
    { 0x0c2e, "Metrologic Instruments" },
    { 0x0c30, "Mutoh Industries Ltd" },
    { 0x0c35, "Eagletron, Inc." },
    { 0x0c36, "E Ink Corp." },
    { 0x0c37, "e.Digital" },
    { 0x0c38, "Der An Electric Wire & Cable Co., Ltd" },
    { 0x0c39, "IFR" },
    { 0x0c3a, "Furui Precise Component (Kunshan) Co., Ltd" },
    { 0x0c3b, "Komatsu, Ltd" },
    { 0x0c3c, "Radius Co., Ltd" },
    { 0x0c3d, "Innocom, Inc." },
    { 0x0c3e, "Nextcell, Inc." },
    { 0x0c40, "ELMCU" },
    { 0x0c44, "Motorola iDEN" },
    { 0x0c45, "Microdia" },
    { 0x0c46, "WaveRider Communications, Inc." },
    { 0x0c4a, "ALGE-TIMING GmbH" },
    { 0x0c4b, "Reiner SCT Kartensysteme GmbH" },
    { 0x0c4c, "Needham's Electronics" },
    { 0x0c52, "Sealevel Systems, Inc." },
    { 0x0c53, "ViewPLUS, Inc." },
    { 0x0c54, "Glory, Ltd" },
    { 0x0c55, "Spectrum Digital, Inc." },
    { 0x0c56, "Billion Bright, Ltd" },
    { 0x0c57, "Imaginative Design Operation Co., Ltd" },
    { 0x0c58, "Vidar Systems Corp." },
    { 0x0c59, "Dong Guan Shinko Wire Co., Ltd" },
    { 0x0c5a, "TRS International Mfg., Inc." },
    { 0x0c5e, "Xytronix Research & Design" },
    { 0x0c60, "Apogee Electronics Corp." },
    { 0x0c62, "Chant Sincere Co., Ltd" },
    { 0x0c63, "Toko, Inc." },
    { 0x0c64, "Signality System Engineering Co., Ltd" },
    { 0x0c65, "Eminence Enterprise Co., Ltd" },
    { 0x0c66, "Rexon Electronics Corp." },
    { 0x0c67, "Concept Telecom, Ltd" },
    { 0x0c6a, "ACS" },
    { 0x0c6c, "JETI Technische Instrumente GmbH" },
    { 0x0c70, "MCT Elektronikladen" },
    { 0x0c72, "PEAK System" },
    { 0x0c74, "Optronic Laboratories Inc." },
    { 0x0c76, "JMTek, LLC." },
    { 0x0c77, "Sipix Group, Ltd" },
    { 0x0c78, "Detto Corp." },
    { 0x0c79, "NuConnex Technologies Pte., Ltd" },
    { 0x0c7a, "Wing-Span Enterprise Co., Ltd" },
    { 0x0c86, "NDA Technologies, Inc." },
    { 0x0c88, "Kyocera Wireless Corp." },
    { 0x0c89, "Honda Tsushin Kogyo Co., Ltd" },
    { 0x0c8a, "Pathway Connectivity, Inc." },
    { 0x0c8b, "Wavefly Corp." },
    { 0x0c8c, "Coactive Networks" },
    { 0x0c8d, "Tempo" },
    { 0x0c8e, "Cesscom Co., Ltd" },
    { 0x0c8f, "Applied Microsystems" },
    { 0x0c94, "Cryptera" },
    { 0x0c98, "Berkshire Products, Inc." },
    { 0x0c99, "Innochips Co., Ltd" },
    { 0x0c9a, "Hanwool Robotics Corp." },
    { 0x0c9b, "Jobin Yvon, Inc." },
    { 0x0c9c, "Brand Innovators BV" },
    { 0x0c9d, "SemTek" },
    { 0x0ca2, "Zyfer" },
    { 0x0ca3, "Sega Corp." },
    { 0x0ca4, "ST&T Instrument Corp." },
    { 0x0ca5, "BAE Systems Canada, Inc." },
    { 0x0ca6, "Castles Technology Co., Ltd" },
    { 0x0ca7, "Information Systems Laboratories" },
    { 0x0caa, "Allied Telesis KK." },
    { 0x0cad, "Motorola CGISS" },
    { 0x0cae, "Ascom Business Systems, Ltd" },
    { 0x0caf, "Buslink" },
    { 0x0cb0, "Flying Pig Systems" },
    { 0x0cb1, "Innovonics, Inc." },
    { 0x0cb6, "Celestix Networks, Pte., Ltd" },
    { 0x0cb7, "Singatron Enterprise Co., Ltd" },
    { 0x0cb8, "Opticis Co., Ltd" },
    { 0x0cba, "Trust Electronic (Shanghai) Co., Ltd" },
    { 0x0cbb, "Shanghai Darong Electronics Co., Ltd" },
    { 0x0cbc, "Palmax Technology Co., Ltd" },
    { 0x0cbd, "Pentel Co., Ltd (Electronics Equipment Div.)" },
    { 0x0cbe, "Keryx Technologies, Inc." },
    { 0x0cbf, "Union Genius Computer Co., Ltd" },
    { 0x0cc0, "Kuon Yi Industrial Corp." },
    { 0x0cc1, "Given Imaging, Ltd" },
    { 0x0cc2, "Timex Corp." },
    { 0x0cc3, "Rimage Corp." },
    { 0x0cc4, "emsys GmbH" },
    { 0x0cc5, "Sendo" },
    { 0x0cc6, "Intermagic Corp." },
    { 0x0cc8, "Technotools Corp." },
    { 0x0cc9, "BroadMAX Technologies, Inc." },
    { 0x0cca, "Amphenol" },
    { 0x0ccb, "SKNet Co., Ltd" },
    { 0x0ccc, "Domex Technology Corp." },
    { 0x0ccd, "TerraTec Electronic GmbH" },
    { 0x0cd4, "Bang Olufsen" },
    { 0x0cd5, "LabJack Corporation" },
    { 0x0cd6, "Scheidt & Bachmann" },
    { 0x0cd7, "NewChip S.r.l." },
    { 0x0cd8, "JS Digitech, Inc." },
    { 0x0cd9, "Hitachi Shin Din Cable, Ltd" },
    { 0x0cde, "Z-Com" },
    { 0x0ce5, "Validation Technologies International" },
    { 0x0ce9, "Pico Technology" },
    { 0x0cf1, "e-Conn Electronic Co., Ltd" },
    { 0x0cf2, "ENE Technology, Inc." },
    { 0x0cf3, "Qualcomm Atheros Communications" },
    { 0x0cf4, "Fomtex Corp." },
    { 0x0cf5, "Cellink Co., Ltd" },
    { 0x0cf6, "Compucable Corp." },
    { 0x0cf7, "ishoni Networks" },
    { 0x0cf8, "Clarisys, Inc." },
    { 0x0cf9, "Central System Research Co., Ltd" },
    { 0x0cfa, "Inviso, Inc." },
    { 0x0cfc, "Minolta-QMS, Inc." },
    { 0x0cff, "SAFA MEDIA Co., Ltd." },
    { 0x0d06, "telos EDV Systementwicklung GmbH" },
    { 0x0d08, "UTStarcom" },
    { 0x0d0b, "Contemporary Controls" },
    { 0x0d0c, "Astron Electronics Co., Ltd" },
    { 0x0d0d, "MKNet Corp." },
    { 0x0d0e, "Hybrid Networks, Inc." },
    { 0x0d0f, "Feng Shin Cable Co., Ltd" },
    { 0x0d10, "Elastic Networks" },
    { 0x0d11, "Maspro Denkoh Corp." },
    { 0x0d12, "Hansol Electronics, Inc." },
    { 0x0d13, "BMF Corp." },
    { 0x0d14, "Array Comm, Inc." },
    { 0x0d15, "OnStream b.v." },
    { 0x0d16, "Hi-Touch Imaging Technologies Co., Ltd" },
    { 0x0d17, "NALTEC, Inc." },
    { 0x0d18, "coaXmedia" },
    { 0x0d19, "Hank Connection Industrial Co., Ltd" },
    { 0x0d28, "NXP" },
    { 0x0d2f, "Andamiro" },
    { 0x0d32, "Leo Hui Electric Wire & Cable Co., Ltd" },
    { 0x0d33, "AirSpeak, Inc." },
    { 0x0d34, "Rearden Steel Technologies" },
    { 0x0d35, "Dah Kun Co., Ltd" },
    { 0x0d3a, "Posiflex Technologies, Inc." },
    { 0x0d3c, "Sri Cable Technology, Ltd" },
    { 0x0d3d, "Tangtop Technology Co., Ltd" },
    { 0x0d3e, "Fitcom, inc." },
    { 0x0d3f, "MTS Systems Corp." },
    { 0x0d40, "Ascor, Inc." },
    { 0x0d41, "Ta Yun Terminals Industrial Co., Ltd" },
    { 0x0d42, "Full Der Co., Ltd" },
    { 0x0d46, "Kobil Systems GmbH" },
    { 0x0d48, "Promethean Limited" },
    { 0x0d49, "Maxtor" },
    { 0x0d4a, "NF Corp." },
    { 0x0d4b, "Grape Systems, Inc." },
    { 0x0d4c, "Tedas AG" },
    { 0x0d4d, "Coherent, Inc." },
    { 0x0d4e, "Agere Systems Netherland BV" },
    { 0x0d4f, "EADS Airbus France" },
    { 0x0d50, "Cleware GmbH" },
    { 0x0d51, "Volex (Asia) Pte., Ltd" },
    { 0x0d53, "HMI Co., Ltd" },
    { 0x0d54, "Holon Corp." },
    { 0x0d55, "ASKA Technologies, Inc." },
    { 0x0d56, "AVLAB Technology, Inc." },
    { 0x0d57, "Solomon Microtech, Ltd" },
    { 0x0d59, "TRC Simulators b.v." },
    { 0x0d5c, "SMC Networks, Inc." },
    { 0x0d5e, "Myacom, Ltd" },
    { 0x0d5f, "CSI, Inc." },
    { 0x0d60, "IVL Technologies, Ltd" },
    { 0x0d61, "Meilu Electronics (Shenzhen) Co., Ltd" },
    { 0x0d62, "Darfon Electronics Corp." },
    { 0x0d63, "Fritz Gegauf AG" },
    { 0x0d64, "DXG Technology Corp." },
    { 0x0d65, "KMJP Co., Ltd" },
    { 0x0d66, "TMT" },
    { 0x0d67, "Advanet, Inc." },
    { 0x0d68, "Super Link Electronics Co., Ltd" },
    { 0x0d69, "NSI" },
    { 0x0d6a, "Megapower International Corp." },
    { 0x0d6b, "And-Or Logic" },
    { 0x0d70, "Try Computer Co., Ltd" },
    { 0x0d71, "Hirakawa Hewtech Corp." },
    { 0x0d72, "Winmate Communication, Inc." },
    { 0x0d73, "Hit's Communications, Inc." },
    { 0x0d76, "MFP Korea, Inc." },
    { 0x0d77, "Power Sentry/Newpoint" },
    { 0x0d78, "Japan Distributor Corp." },
    { 0x0d7a, "MARX Datentechnik GmbH" },
    { 0x0d7b, "Wellco Technology Co., Ltd" },
    { 0x0d7c, "Taiwan Line Tek Electronic Co., Ltd" },
    { 0x0d7d, "Phison Electronics Corp." },
    { 0x0d7e, "American Computer & Digital Components" },
    { 0x0d7f, "Essential Reality LLC" },
    { 0x0d80, "H.R. Silvine Electronics, Inc." },
    { 0x0d81, "TechnoVision" },
    { 0x0d83, "Think Outside, Inc." },
    { 0x0d87, "Dolby Laboratories Inc." },
    { 0x0d89, "Oz Software" },
    { 0x0d8a, "King Jim Co., Ltd" },
    { 0x0d8b, "Ascom Telecommunications, Ltd" },
    { 0x0d8c, "C-Media Electronics, Inc." },
    { 0x0d8d, "Promotion & Display Technology, Ltd" },
    { 0x0d8e, "Global Sun Technology, Inc." },
    { 0x0d8f, "Pitney Bowes" },
    { 0x0d90, "Sure-Fire Electrical Corp." },
    { 0x0d96, "Skanhex Technology, Inc." },
    { 0x0d97, "Santa Barbara Instrument Group" },
    { 0x0d98, "Mars Semiconductor Corp." },
    { 0x0d99, "Trazer Technologies, Inc." },
    { 0x0d9a, "RTX AS" },
    { 0x0d9b, "Tat Shing Electrical Co." },
    { 0x0d9c, "Chee Chen Hi-Technology Co., Ltd" },
    { 0x0d9d, "Sanwa Supply, Inc." },
    { 0x0d9e, "Avaya" },
    { 0x0d9f, "Powercom Co., Ltd" },
    { 0x0da0, "Danger Research" },
    { 0x0da1, "Suzhou Peter's Precise Industrial Co., Ltd" },
    { 0x0da2, "Land Instruments International, Ltd" },
    { 0x0da3, "Nippon Electro-Sensory Devices Corp." },
    { 0x0da4, "Polar Electro Oy" },
    { 0x0da7, "IOGear, Inc." },
    { 0x0da8, "softDSP Co., Ltd" },
    { 0x0dab, "Cubig Group" },
    { 0x0dad, "Westover Scientific" },
    { 0x0db0, "Micro Star International" },
    { 0x0db1, "Wen Te Electronics Co., Ltd" },
    { 0x0db2, "Shian Hwi Plug Parts, Plastic Factory" },
    { 0x0db3, "Tekram Technology Co., Ltd" },
    { 0x0db4, "Chung Fu Chen Yeh Enterprise Corp." },
    { 0x0db5, "Access IS" },
    { 0x0db7, "ELCON Systemtechnik" },
    { 0x0dba, "Digidesign" },
    { 0x0dbc, "A&D Medical" },
    { 0x0dbe, "Jiuh Shiuh Precision Industry Co., Ltd" },
    { 0x0dbf, "Jess-Link International" },
    { 0x0dc0, "G7 Solutions (formerly Great Notions)" },
    { 0x0dc1, "Tamagawa Seiki Co., Ltd" },
    { 0x0dc3, "Athena Smartcard Solutions, Inc." },
    { 0x0dc4, "inXtron, Inc." },
    { 0x0dc5, "SDK Co., Ltd" },
    { 0x0dc6, "Precision Squared Technology Corp." },
    { 0x0dc7, "First Cable Line, Inc." },
    { 0x0dcd, "NetworkFab Corp." },
    { 0x0dd0, "Access Solutions" },
    { 0x0dd1, "Contek Electronics Co., Ltd" },
    { 0x0dd2, "Power Quotient International Co., Ltd" },
    { 0x0dd3, "MediaQ" },
    { 0x0dd4, "Custom Engineering SPA" },
    { 0x0dd5, "California Micro Devices" },
    { 0x0dd7, "Kocom Co., Ltd" },
    { 0x0dd8, "Netac Technology Co., Ltd" },
    { 0x0dd9, "HighSpeed Surfing" },
    { 0x0dda, "Integrated Circuit Solution, Inc." },
    { 0x0ddb, "Tamarack, Inc." },
    { 0x0ddd, "Datelink Technology Co., Ltd" },
    { 0x0dde, "Ubicom, Inc." },
    { 0x0de0, "BD Consumer Healthcare" },
    { 0x0de7, "USBmicro" },
    { 0x0dea, "UTECH Electronic (D.G.) Co., Ltd." },
    { 0x0ded, "Novasonics" },
    { 0x0dee, "Lifetime Memory Products" },
    { 0x0def, "Full Rise Electronic Co., Ltd" },
    { 0x0df4, "NET&SYS" },
    { 0x0df6, "Sitecom Europe B.V." },
    { 0x0df7, "Mobile Action Technology, Inc." },
    { 0x0dfa, "Toyo Communication Equipment Co., Ltd" },
    { 0x0dfc, "GeneralTouch Technology Co., Ltd" },
    { 0x0e03, "Nippon Systemware Co., Ltd" },
    { 0x0e08, "Winbest Technology Co., Ltd" },
    { 0x0e0b, "Amigo Technology Inc." },
    { 0x0e0c, "Gesytec" },
    { 0x0e0d, "PicoQuant GmbH" },
    { 0x0e0f, "VMware, Inc." },
    { 0x0e16, "JMTek, LLC" },
    { 0x0e17, "Walex Electronic, Ltd" },
    { 0x0e1a, "Unisys" },
    { 0x0e1b, "Crewave" },
    { 0x0e1e, "Green Hills Software" },
    { 0x0e20, "Pegasus Technologies Ltd." },
    { 0x0e21, "Cowon Systems, Inc." },
    { 0x0e22, "Symbian Ltd." },
    { 0x0e23, "Liou Yuane Enterprise Co., Ltd" },
    { 0x0e25, "VinChip Systems, Inc." },
    { 0x0e26, "J-Phone East Co., Ltd" },
    { 0x0e30, "HeartMath LLC" },
    { 0x0e34, "Micro Computer Control Corp." },
    { 0x0e35, "3Pea Technologies, Inc." },
    { 0x0e36, "TiePie engineering" },
    { 0x0e38, "Stratitec, Inc." },
    { 0x0e39, "Smart Modular Technologies, Inc." },
    { 0x0e3a, "Neostar Technology Co., Ltd" },
    { 0x0e3b, "Mansella, Ltd" },
    { 0x0e41, "Line6, Inc." },
    { 0x0e44, "Sun-Riseful Technology Co., Ltd." },
    { 0x0e48, "Julia Corp., Ltd" },
    { 0x0e4a, "Shenzhen Bao Hing Electric Wire & Cable Mfr. Co." },
    { 0x0e4c, "Radica Games, Ltd" },
    { 0x0e50, "TechnoData Interware" },
    { 0x0e55, "Speed Dragon Multimedia, Ltd" },
    { 0x0e56, "Kingston Technology Company, Inc." },
    { 0x0e5a, "Active Co., Ltd" },
    { 0x0e5b, "Union Power Information Industrial Co., Ltd" },
    { 0x0e5c, "Bitland Information Technology Co., Ltd" },
    { 0x0e5d, "Neltron Industrial Co., Ltd" },
    { 0x0e5e, "Conwise Technology Co., Ltd." },
    { 0x0e66, "Hawking Technologies" },
    { 0x0e67, "Fossil, Inc." },
    { 0x0e6a, "Megawin Technology Co., Ltd" },
    { 0x0e6f, "Logic3" },
    { 0x0e70, "Tokyo Electronic Industry Co., Ltd" },
    { 0x0e72, "Hsi-Chin Electronics Co., Ltd" },
    { 0x0e75, "TVS Electronics, Ltd" },
    { 0x0e79, "Archos, Inc." },
    { 0x0e7b, "On-Tech Industry Co., Ltd" },
    { 0x0e7e, "Gmate, Inc." },
    { 0x0e82, "Ching Tai Electric Wire & Cable Co., Ltd" },
    { 0x0e83, "Shin An Wire & Cable Co." },
    { 0x0e8c, "Well Force Electronic Co., Ltd" },
    { 0x0e8d, "MediaTek Inc." },
    { 0x0e8f, "GreenAsia Inc." },
    { 0x0e90, "WiebeTech, LLC" },
    { 0x0e91, "VTech Engineering Canada, Ltd" },
    { 0x0e92, "C's Glory Enterprise Co., Ltd" },
    { 0x0e93, "eM Technics Co., Ltd" },
    { 0x0e95, "Future Technology Co., Ltd" },
    { 0x0e96, "Aplux Communications, Ltd" },
    { 0x0e97, "Fingerworks, Inc." },
    { 0x0e98, "Advanced Analogic Technologies, Inc." },
    { 0x0e99, "Parallel Dice Co., Ltd" },
    { 0x0e9a, "TA HSING Industries, Ltd" },
    { 0x0e9b, "ADTEC Corp." },
    { 0x0e9c, "Streamzap, Inc." },
    { 0x0e9f, "Tamura Corp." },
    { 0x0ea0, "Ours Technology, Inc." },
    { 0x0ea6, "Nihon Computer Co., Ltd" },
    { 0x0ea7, "MSL Enterprises Corp." },
    { 0x0ea8, "CenDyne, Inc." },
    { 0x0ead, "Humax Co., Ltd" },
    { 0x0eb0, "NovaTech" },
    { 0x0eb1, "WIS Technologies, Inc." },
    { 0x0eb2, "Y-S Electronic Co., Ltd" },
    { 0x0eb3, "Saint Technology Corp." },
    { 0x0eb7, "Endor AG" },
    { 0x0eb8, "Mettler Toledo" },
    { 0x0ebb, "Thermo Fisher Scientific" },
    { 0x0ebe, "VWeb Corp." },
    { 0x0ebf, "Omega Technology of Taiwan, Inc." },
    { 0x0ec0, "LHI Technology (China) Co., Ltd" },
    { 0x0ec1, "Abit Computer Corp." },
    { 0x0ec2, "Sweetray Industrial, Ltd" },
    { 0x0ec3, "Axell Co., Ltd" },
    { 0x0ec4, "Ballracing Developments, Ltd" },
    { 0x0ec5, "GT Information System Co., Ltd" },
    { 0x0ec6, "InnoVISION Multimedia, Ltd" },
    { 0x0ec7, "Theta Link Corp." },
    { 0x0ecd, "Lite-On IT Corp." },
    { 0x0ece, "TaiSol Electronics Co., Ltd" },
    { 0x0ecf, "Phogenix Imaging, LLC" },
    { 0x0ed1, "WinMaxGroup" },
    { 0x0ed2, "Kyoto Micro Computer Co., Ltd" },
    { 0x0ed3, "Wing-Tech Enterprise Co., Ltd" },
    { 0x0ed5, "Fiberbyte" },
    { 0x0eda, "Noriake Itron Corp." },
    { 0x0edf, "e-MDT Co., Ltd" },
    { 0x0ee0, "Shima Seiki Mfg., Ltd" },
    { 0x0ee1, "Sarotech Co., Ltd" },
    { 0x0ee2, "AMI Semiconductor, Inc." },
    { 0x0ee3, "ComTrue Technology Corp." },
    { 0x0ee4, "Sunrich Technology, Ltd" },
    { 0x0eee, "Digital Stream Technology, Inc." },
    { 0x0eef, "D-WAV Scientific Co., Ltd" },
    { 0x0ef0, "Hitachi Cable, Ltd" },
    { 0x0ef1, "Aichi Micro Intelligent Corp." },
    { 0x0ef2, "I/O Magic Corp." },
    { 0x0ef3, "Lynn Products, Inc." },
    { 0x0ef4, "DSI Datotech" },
    { 0x0ef5, "PointChips" },
    { 0x0ef6, "Yield Microelectronics Corp." },
    { 0x0ef7, "SM Tech Co., Ltd (Tulip)" },
    { 0x0efd, "Oasis Semiconductor" },
    { 0x0efe, "Wem Technology, Inc." },
    { 0x0f03, "Unitek UPS Systems" },
    { 0x0f06, "Visual Frontier Enterprise Co., Ltd" },
    { 0x0f08, "CSL Wire & Plug (Shen Zhen) Co." },
    { 0x0f0c, "CAS Corp." },
    { 0x0f0d, "Hori Co., Ltd" },
    { 0x0f0e, "Energy Full Corp." },
    { 0x0f0f, "Silego Technology Inc" },
    { 0x0f11, "LD Didactic GmbH" },
    { 0x0f12, "Mars Engineering Corp." },
    { 0x0f13, "Acetek Technology Co., Ltd" },
    { 0x0f14, "Ingenico" },
    { 0x0f18, "Finger Lakes Instrumentation" },
    { 0x0f19, "Oracom Co., Ltd" },
    { 0x0f1b, "Onset Computer Corp." },
    { 0x0f1c, "Funai Electric Co., Ltd" },
    { 0x0f1d, "Iwill Corp." },
    { 0x0f21, "IOI Technology Corp." },
    { 0x0f22, "Senior Industries, Inc." },
    { 0x0f23, "Leader Tech Manufacturer Co., Ltd" },
    { 0x0f24, "Flex-P Industries, Snd., Bhd." },
    { 0x0f2d, "ViPower, Inc." },
    { 0x0f2e, "Geniality Maple Technology Co., Ltd" },
    { 0x0f2f, "Priva Design Services" },
    { 0x0f30, "Jess Technology Co., Ltd" },
    { 0x0f31, "Chrysalis Development" },
    { 0x0f32, "YFC-BonEagle Electric Co., Ltd" },
    { 0x0f37, "Kokuyo Co., Ltd" },
    { 0x0f38, "Nien-Yi Industrial Corp." },
    { 0x0f39, "TG3 Electronics" },
    { 0x0f3d, "Airprime, Incorporated" },
    { 0x0f41, "RDC Semiconductor Co., Ltd" },
    { 0x0f42, "Nital Consulting Services, Inc." },
    { 0x0f44, "Polhemus" },
    { 0x0f49, "Evolis SA" },
    { 0x0f4b, "St. John Technology Co., Ltd" },
    { 0x0f4c, "WorldWide Cable Opto Corp." },
    { 0x0f4d, "Microtune, Inc." },
    { 0x0f4e, "Freedom Scientific" },
    { 0x0f52, "Wing Key Electrical Co., Ltd" },
    { 0x0f53, "Dongguan White Horse Cable Factory, Ltd" },
    { 0x0f54, "Kawai Musical Instruments Mfg. Co., Ltd" },
    { 0x0f55, "AmbiCom, Inc." },
    { 0x0f5c, "Prairiecomm, Inc." },
    { 0x0f5d, "NewAge International, LLC" },
    { 0x0f5f, "Key Technology Corp." },
    { 0x0f60, "NTK, Ltd" },
    { 0x0f61, "Varian, Inc." },
    { 0x0f62, "Acrox Technologies Co., Ltd" },
    { 0x0f63, "LeapFrog Enterprises" },
    { 0x0f68, "Kobe Steel, Ltd" },
    { 0x0f69, "Dionex Corp." },
    { 0x0f6a, "Vibren Technologies, Inc." },
    { 0x0f6e, "INTELLIGENT SYSTEMS" },
    { 0x0f73, "DFI" },
    { 0x0f78, "Guntermann & Drunck GmbH" },
    { 0x0f7c, "DQ Technology, Inc." },
    { 0x0f7d, "NetBotz, Inc." },
    { 0x0f7e, "Fluke Corp." },
    { 0x0f88, "VTech Holdings, Ltd" },
    { 0x0f8b, "Yazaki Corp." },
    { 0x0f8c, "Young Generation International Corp." },
    { 0x0f8d, "Uniwill Computer Corp." },
    { 0x0f8e, "Kingnet Technology Co., Ltd" },
    { 0x0f8f, "Soma Networks" },
    { 0x0f97, "CviLux Corp." },
    { 0x0f98, "CyberBank Corp." },
    { 0x0f9c, "Hyun Won, Inc." },
    { 0x0f9e, "Lucent Technologies" },
    { 0x0fa3, "Starconn Electronic Co., Ltd" },
    { 0x0fa4, "ATL Technology" },
    { 0x0fa5, "Sotec Co., Ltd" },
    { 0x0fa7, "Epox Computer Co., Ltd" },
    { 0x0fa8, "Logic Controls, Inc." },
    { 0x0faf, "Winpoint Electronic Corp." },
    { 0x0fb0, "Haurtian Wire & Cable Co., Ltd" },
    { 0x0fb1, "Inclose Design, Inc." },
    { 0x0fb2, "Juan-Chern Industrial Co., Ltd" },
    { 0x0fb6, "Heber Ltd" },
    { 0x0fb8, "Wistron Corp." },
    { 0x0fb9, "AACom Corp." },
    { 0x0fba, "San Shing Electronics Co., Ltd" },
    { 0x0fbb, "Bitwise Systems, Inc." },
    { 0x0fc1, "Mitac Internatinal Corp." },
    { 0x0fc2, "Plug and Jack Industrial, Inc." },
    { 0x0fc5, "Delcom Engineering" },
    { 0x0fc6, "Dataplus Supplies, Inc." },
    { 0x0fca, "Research In Motion, Ltd." },
    { 0x0fce, "Sony Ericsson Mobile Communications AB" },
    { 0x0fcf, "Dynastream Innovations, Inc." },
    { 0x0fd0, "Tulip Computers B.V." },
    { 0x0fd1, "Giant Electronics Ltd." },
    { 0x0fd2, "Seac Banche" },
    { 0x0fd4, "Tenovis GmbH & Co., KG" },
    { 0x0fd5, "Direct Access Technology, Inc." },
    { 0x0fd9, "Elgato Systems GmbH" },
    { 0x0fda, "Quantec Networks GmbH" },
    { 0x0fdc, "Micro Plus" },
    { 0x0fde, "Oregon Scientific" },
    { 0x0fe0, "Osterhout Design Group" },
    { 0x0fe2, "Air Techniques" },
    { 0x0fe4, "IN-Tech Electronics, Ltd" },
    { 0x0fe5, "Greenconn (U.S.A.), Inc." },
    { 0x0fe6, "ICS Advent" },
    { 0x0fe9, "DVICO" },
    { 0x0fea, "United Computer Accessories" },
    { 0x0feb, "CRS Electronic Co., Ltd" },
    { 0x0fec, "UMC Electronics Co., Ltd" },
    { 0x0fed, "Access Co., Ltd" },
    { 0x0fee, "Xsido Corp." },
    { 0x0fef, "MJ Research, Inc." },
    { 0x0ff6, "Core Valley Co., Ltd" },
    { 0x0ff7, "CHI SHING Computer Accessories Co., Ltd" },
    { 0x0ffc, "Clavia DMI AB" },
    { 0x0ffd, "EarlySense" },
    { 0x0fff, "Aopen, Inc." },
    { 0x1000, "Speed Tech Corp." },
    { 0x1001, "Ritronics Components (S) Pte., Ltd" },
    { 0x1003, "Sigma Corp." },
    { 0x1004, "LG Electronics, Inc." },
    { 0x1005, "Apacer Technology, Inc." },
    { 0x1006, "iRiver, Ltd." },
    { 0x1009, "Emuzed, Inc." },
    { 0x100a, "AV Chaseway, Ltd" },
    { 0x100b, "Chou Chin Industrial Co., Ltd" },
    { 0x100d, "Netopia, Inc." },
    { 0x1010, "Fukuda Denshi Co., Ltd" },
    { 0x1011, "Mobile Media Tech." },
    { 0x1012, "SDKM Fibres, Wires & Cables Berhad" },
    { 0x1013, "TST-Touchless Sensor Technology AG" },
    { 0x1014, "Densitron Technologies PLC" },
    { 0x1015, "Softronics Pty., Ltd" },
    { 0x1016, "Xiamen Hung's Enterprise Co., Ltd" },
    { 0x1017, "Speedy Industrial Supplies, Pte., Ltd" },
    { 0x1019, "Elitegroup Computer Systems (ECS)" },
    { 0x1020, "Labtec" },
    { 0x1022, "Shinko Shoji Co., Ltd" },
    { 0x1025, "Hyper-Paltek" },
    { 0x1026, "Newly Corp." },
    { 0x1027, "Time Domain" },
    { 0x1028, "Inovys Corp." },
    { 0x1029, "Atlantic Coast Telesys" },
    { 0x102a, "Ramos Technology Co., Ltd" },
    { 0x102b, "Infotronic America, Inc." },
    { 0x102c, "Etoms Electronics Corp." },
    { 0x102d, "Winic Corp." },
    { 0x1031, "Comax Technology, Inc." },
    { 0x1032, "C-One Technology Corp." },
    { 0x1033, "Nucam Corp." },
    { 0x1038, "SteelSeries ApS" },
    { 0x1039, "devolo AG" },
    { 0x103a, "PSA" },
    { 0x103d, "Stanton" },
    { 0x1043, "iCreate Technologies Corp." },
    { 0x1044, "Chu Yuen Enterprise Co., Ltd" },
    { 0x1046, "Winbond Electronics Corp. [hex]" },
    { 0x1048, "Targus Group International" },
    { 0x104b, "Mylex / Buslogic" },
    { 0x104c, "AMCO TEC International, Inc." },
    { 0x104d, "Newport Corporation" },
    { 0x104f, "WB Electronics" },
    { 0x1050, "Yubico.com" },
    { 0x1053, "Immanuel Electronics Co., Ltd" },
    { 0x1054, "BMS International Beheer N.V." },
    { 0x1055, "Complex Micro Interconnection Co., Ltd" },
    { 0x1056, "Hsin Chen Ent Co., Ltd" },
    { 0x1057, "ON Semiconductor" },
    { 0x1058, "Western Digital Technologies, Inc." },
    { 0x1059, "Giesecke & Devrient GmbH" },
    { 0x105b, "Foxconn International, Inc." },
    { 0x105c, "Hong Ji Electric Wire & Cable (Dongguan) Co., Ltd" },
    { 0x105d, "Delkin Devices, Inc." },
    { 0x105e, "Valence Semiconductor Design, Ltd" },
    { 0x105f, "Chin Shong Enterprise Co., Ltd" },
    { 0x1060, "Easthome Industrial Co., Ltd" },
    { 0x1063, "Motorola Electronics Taiwan, Ltd [hex]" },
    { 0x1065, "CCYU Technology" },
    { 0x1068, "Micropi Elettronica" },
    { 0x106a, "Loyal Legend, Ltd" },
    { 0x106c, "Curitel Communications, Inc." },
    { 0x106d, "San Chieh Manufacturing, Ltd" },
    { 0x106e, "ConectL" },
    { 0x106f, "Money Controls" },
    { 0x1076, "GCT Semiconductor, Inc." },
    { 0x107b, "Gateway, Inc." },
    { 0x107d, "Arlec Australia, Ltd" },
    { 0x107e, "Midoriya Electric Co., Ltd" },
    { 0x107f, "KidzMouse, Inc." },
    { 0x1082, "Shin-Etsukaken Co., Ltd" },
    { 0x1083, "Canon Electronics, Inc." },
    { 0x1084, "Pantech Co., Ltd" },
    { 0x108a, "Chloride Power Protection" },
    { 0x108b, "Grand-tek Technology Co., Ltd" },
    { 0x108c, "Robert Bosch GmbH" },
    { 0x108e, "Lotes Co., Ltd." },
    { 0x1091, "Numerik Jena" },
    { 0x1099, "Surface Optics Corp." },
    { 0x109a, "DATASOFT Systems GmbH" },
    { 0x109b, "Hisense" },
    { 0x109f, "eSOL Co., Ltd" },
    { 0x10a0, "Hirotech, Inc." },
    { 0x10a3, "Mitsubishi Materials Corp." },
    { 0x10a9, "SK Teletech Co., Ltd" },
    { 0x10aa, "Cables To Go" },
    { 0x10ab, "USI Co., Ltd" },
    { 0x10ac, "Honeywell, Inc." },
    { 0x10ae, "Princeton Technology Corp." },
    { 0x10af, "Liebert Corp." },
    { 0x10b5, "Comodo (PLX?)" },
    { 0x10b8, "DiBcom" },
    { 0x10bb, "TM Technology, Inc." },
    { 0x10bc, "Dinging Technology Co., Ltd" },
    { 0x10bd, "TMT Technology, Inc." },
    { 0x10bf, "SmartHome" },
    { 0x10c3, "Universal Laser Systems, Inc." },
    { 0x10c4, "Silicon Labs" },
    { 0x10c5, "Sanei Electric, Inc." },
    { 0x10c6, "Intec, Inc." },
    { 0x10cb, "Eratech" },
    { 0x10cc, "GBM Connector Co., Ltd" },
    { 0x10cd, "Kycon, Inc." },
    { 0x10ce, "Silicon Labs" },
    { 0x10cf, "Velleman Components, Inc." },
    { 0x10d1, "Hottinger Baldwin Measurement" },
    { 0x10d2, "RayComposer - R. Adams" },
    { 0x10d4, "Man Boon Manufactory, Ltd" },
    { 0x10d5, "Uni Class Technology Co., Ltd" },
    { 0x10d6, "Actions Semiconductor Co., Ltd" },
    { 0x10de, "Authenex, Inc." },
    { 0x10df, "In-Win Development, Inc." },
    { 0x10e0, "Post-Op Video, Inc." },
    { 0x10e1, "CablePlus, Ltd" },
    { 0x10e2, "Nada Electronics, Ltd" },
    { 0x10ec, "Vast Technologies, Inc." },
    { 0x10f0, "Nexio Co., Ltd" },
    { 0x10f1, "Importek" },
    { 0x10f5, "Turtle Beach" },
    { 0x10f8, "Cesys GmbH" },
    { 0x10fb, "Pictos Technologies, Inc." },
    { 0x10fd, "Anubis Electronics, Ltd" },
    { 0x10fe, "Thrane & Thrane" },
    { 0x1100, "VirTouch, Ltd" },
    { 0x1101, "EasyPass Industrial Co., Ltd" },
    { 0x1108, "Brightcom Technologies, Ltd" },
    { 0x110a, "Moxa Technologies Co., Ltd." },
    { 0x1110, "Analog Devices Canada, Ltd (Allied Telesyn)" },
    { 0x1111, "Pandora International Ltd." },
    { 0x1112, "YM ELECTRIC CO., Ltd" },
    { 0x1113, "Medion AG" },
    { 0x111e, "VSO Electric Co., Ltd" },
    { 0x112a, "RedRat" },
    { 0x112e, "Master Hill Electric Wire and Cable Co., Ltd" },
    { 0x112f, "Cellon International, Inc." },
    { 0x1130, "Tenx Technology, Inc." },
    { 0x1131, "Integrated System Solution Corp." },
    { 0x1132, "Toshiba Corp., Digital Media Equipment [hex]" },
    { 0x1136, "CTS Electronincs" },
    { 0x113c, "Arin Tech Co., Ltd" },
    { 0x113d, "Mapower Electronics Co., Ltd" },
    { 0x113f, "Integrated Biometrics, LLC" },
    { 0x1141, "V One Multimedia, Pte., Ltd" },
    { 0x1142, "CyberScan Technologies, Inc." },
    { 0x1145, "Japan Radio Company" },
    { 0x1146, "Shimane SANYO Electric Co., Ltd." },
    { 0x1147, "Ever Great Electric Wire and Cable Co., Ltd" },
    { 0x114b, "Sphairon Access Systems GmbH" },
    { 0x114c, "Tinius Olsen Testing Machine Co., Inc." },
    { 0x114d, "Alpha Imaging Technology Corp." },
    { 0x114f, "Wavecom" },
    { 0x115b, "Salix Technology Co., Ltd." },
    { 0x1162, "Secugen Corp." },
    { 0x1163, "DeLorme Publishing, Inc." },
    { 0x1164, "YUAN High-Tech Development Co., Ltd" },
    { 0x1165, "Telson Electronics Co., Ltd" },
    { 0x1166, "Bantam Interactive Technologies" },
    { 0x1167, "Salient Systems Corp." },
    { 0x1168, "BizConn International Corp." },
    { 0x116e, "Gigastorage Corp." },
    { 0x116f, "Silicon 10 Technology Corp." },
    { 0x1175, "Shengyih Steel Mold Co., Ltd" },
    { 0x117d, "Santa Electronic, Inc." },
    { 0x117e, "JNC, Inc." },
    { 0x1182, "Venture Corp., Ltd" },
    { 0x1183, "Compaq Computer Corp. [hex] (Digital Dream ?)" },
    { 0x1184, "Kyocera Elco Corp." },
    { 0x1188, "Bloomberg L.P." },
    { 0x1189, "Acer Communications & Multimedia" },
    { 0x118f, "You Yang Technology Co., Ltd" },
    { 0x1190, "Tripace" },
    { 0x1191, "Loyalty Founder Enterprise Co., Ltd" },
    { 0x1196, "Yankee Robotics, LLC" },
    { 0x1197, "Technoimagia Co., Ltd" },
    { 0x1198, "StarShine Technology Corp." },
    { 0x1199, "Sierra Wireless, Inc." },
    { 0x119a, "ZHAN QI Technology Co., Ltd" },
    { 0x119b, "ruwido austria GmbH" },
    { 0x11a0, "Chipcon AS" },
    { 0x11a3, "Technovas Co., Ltd" },
    { 0x11aa, "GlobalMedia Group, LLC" },
    { 0x11ab, "Exito Electronics Co., Ltd" },
    { 0x11ac, "Nike" },
    { 0x11b0, "ATECH FLASH TECHNOLOGY" },
    { 0x11be, "R&D International NV" },
    { 0x11c0, "Betop" },
    { 0x11c5, "Inmax" },
    { 0x11c9, "Nacon" },
    { 0x11ca, "VeriFone Inc" },
    { 0x11db, "Topfield Co., Ltd." },
    { 0x11e6, "K.I. Technology Co. Ltd." },
    { 0x11f5, "Siemens AG" },
    { 0x11f6, "Prolific" },
    { 0x11f7, "Alcatel (?)" },
    { 0x1203, "TSC Auto ID Technology Co., Ltd" },
    { 0x1209, "Generic" },
    { 0x120e, "Hudson Soft Co., Ltd" },
    { 0x120f, "Magellan" },
    { 0x1210, "DigiTech" },
    { 0x121e, "Jungsoft Co., Ltd" },
    { 0x121f, "Panini S.p.A." },
    { 0x1220, "TC Electronic" },
    { 0x1221, "Unknown manufacturer" },
    { 0x1222, "TiPro" },
    { 0x1223, "SKYCABLE ENTERPRISE. CO., LTD." },
    { 0x1228, "Datapaq Limited" },
    { 0x1230, "Chipidea-Microelectronica, S.A." },
    { 0x1233, "Denver Electronics" },
    { 0x1234, "Brain Actuated Technologies" },
    { 0x1235, "Focusrite-Novation" },
    { 0x1241, "Belkin" },
    { 0x1243, "Holtek Semiconductor, Inc." },
    { 0x124a, "AirVast" },
    { 0x124b, "Nyko (Honey Bee)" },
    { 0x124c, "MXI - Memory Experts International, Inc." },
    { 0x125c, "Apogee Inc." },
    { 0x125d, "JMicron" },
    { 0x125f, "A-DATA Technology Co., Ltd." },
    { 0x1260, "Standard Microsystems Corp." },
    { 0x1264, "Covidien Energy-based Devices" },
    { 0x1266, "Pirelli Broadband Solutions" },
    { 0x1267, "Logic3 / SpectraVideo plc" },
    { 0x126c, "Aristocrat Technologies" },
    { 0x126d, "Bel Stewart" },
    { 0x126e, "Strobe Data, Inc." },
    { 0x126f, "TwinMOS" },
    { 0x1274, "Ensoniq" },
    { 0x1275, "Xaxero Marine Software Engineering, Ltd." },
    { 0x1278, "Starlight Xpress" },
    { 0x1283, "zebris Medical GmbH" },
    { 0x1286, "Marvell Semiconductor, Inc." },
    { 0x1291, "Qualcomm Flarion Technologies, Inc. / Leadtek Research, Inc." },
    { 0x1292, "Innomedia" },
    { 0x1293, "Belkin Components [hex]" },
    { 0x1294, "RISO KAGAKU CORP." },
    { 0x1297, "DekTec" },
    { 0x129b, "CyberTAN Technology" },
    { 0x12a7, "Trendchip Technologies Corp." },
    { 0x12ab, "Honey Bee Electronic International Ltd." },
    { 0x12b8, "Zhejiang Xinya Electronic Technology Co., Ltd." },
    { 0x12b9, "E28" },
    { 0x12ba, "Licensed by Sony Computer Entertainment America" },
    { 0x12bd, "Gembird" },
    { 0x12c4, "Autocue Group Ltd" },
    { 0x12cf, "DEXIN" },
    { 0x12d1, "Huawei Technologies Co., Ltd." },
    { 0x12d2, "LINE TECH INDUSTRIAL CO., LTD." },
    { 0x12d3, "LINAK" },
    { 0x12d6, "EMS Dr. Thomas Wuensche" },
    { 0x12d7, "BETTER WIRE FACTORY CO., LTD." },
    { 0x12d8, "Araneus Information Systems Oy" },
    { 0x12e6, "Waldorf Music GmbH" },
    { 0x12ef, "Tapwave, Inc." },
    { 0x12f2, "ViewPlus Technologies, Inc." },
    { 0x12f5, "Dynamic System Electronics Corp." },
    { 0x12f7, "Memorex Products, Inc." },
    { 0x12fd, "AIN Comm. Technology Co., Ltd" },
    { 0x12ff, "Fascinating Electronics, Inc." },
    { 0x1306, "FM20 Barcode Scanner" },
    { 0x1307, "Transcend Information, Inc." },
    { 0x1308, "Shuttle, Inc." },
    { 0x1310, "Roper" },
    { 0x1312, "ICS Electronics" },
    { 0x1313, "ThorLabs" },
    { 0x131d, "Natural Point" },
    { 0x1325, "ams AG" },
    { 0x132a, "Envara Inc." },
    { 0x132b, "Konica Minolta" },
    { 0x133e, "Kemper Digital GmbH" },
    { 0x1342, "Mobility" },
    { 0x1343, "Citizen Systems" },
    { 0x1345, "Sino Lite Technology Corp." },
    { 0x1347, "Moravian Instruments" },
    { 0x1348, "Katsuragawa Electric Co., Ltd." },
    { 0x134c, "PanJit International Inc." },
    { 0x134e, "Digby's Bitpile, Inc. DBA D Bit" },
    { 0x1357, "P&E Microcomputer Systems" },
    { 0x135e, "Insta GmbH" },
    { 0x135f, "Control Development Inc." },
    { 0x1366, "SEGGER" },
    { 0x136b, "STEC" },
    { 0x136e, "Andor Technology Ltd." },
    { 0x1370, "Swissbit" },
    { 0x1371, "CNet Technology Inc." },
    { 0x1376, "Vimtron Electronics Co., Ltd." },
    { 0x1377, "Sennheiser electronic GmbH & Co. KG" },
    { 0x137b, "SCAPS GmbH" },
    { 0x137c, "YASKAWA ELECTRIC CORP." },
    { 0x1385, "Netgear, Inc" },
    { 0x138a, "Validity Sensors, Inc." },
    { 0x138e, "Jungo LTD" },
    { 0x1390, "TOMTOM B.V." },
    { 0x1391, "IdealTEK, Inc." },
    { 0x1395, "Sennheiser Communications" },
    { 0x1397, "BEHRINGER International GmbH" },
    { 0x1398, "Q-tec" },
    { 0x13ad, "Baltech" },
    { 0x13b0, "PerkinElmer Optoelectronics" },
    { 0x13b1, "Linksys" },
    { 0x13b2, "Alesis" },
    { 0x13b3, "Nippon Dics Co., Ltd." },
    { 0x13ba, "PCPlay" },
    { 0x13be, "Ricoh Printing Systems, Ltd." },
    { 0x13ca, "JyeTai Precision Industrial Co., Ltd." },
    { 0x13cf, "Wisair Ltd." },
    { 0x13d0, "Techsan Electronics Co., Ltd." },
    { 0x13d1, "A-Max Technology Macao Commercial Offshore Co. Ltd." },
    { 0x13d2, "Shark Multimedia" },
    { 0x13d3, "IMC Networks" },
    { 0x13d7, "Guidance Software, Inc." },
    { 0x13dc, "ALEREON, INC." },
    { 0x13dd, "i.Tech Dynamic Limited" },
    { 0x13e1, "Kaibo Wire & Cable (Shenzhen) Co., Ltd." },
    { 0x13e5, "Rane" },
    { 0x13e6, "TechnoScope Co., Ltd." },
    { 0x13ea, "Hengstler" },
    { 0x13ec, "Zydacron" },
    { 0x13ee, "MosArt" },
    { 0x13fd, "Initio Corporation" },
    { 0x13fe, "Kingston Technology Company Inc." },
    { 0x1400, "Axxion Group Corp." },
    { 0x1402, "Bowe Bell & Howell" },
    { 0x1403, "Sitronix" },
    { 0x1404, "Fundamental Software, Inc." },
    { 0x1409, "IDS Imaging Development Systems GmbH" },
    { 0x140e, "Telechips, Inc." },
    { 0x1410, "Novatel Wireless" },
    { 0x1415, "Nam Tai E&E Products Ltd. or OmniVision Technologies, Inc." },
    { 0x1419, "ABILITY ENTERPRISE CO., LTD." },
    { 0x1421, "Sensor Technology" },
    { 0x1424, "Posnet Polska S.A." },
    { 0x1429, "Vega Technologies Industrial (Austria) Co." },
    { 0x142a, "Thales E-Transactions" },
    { 0x142b, "Arbiter Systems, Inc." },
    { 0x1430, "RedOctane" },
    { 0x1431, "Pertech Resources, Inc." },
    { 0x1435, "Wistron NeWeb" },
    { 0x1436, "Denali Software, Inc." },
    { 0x143c, "Altek Corporation" },
    { 0x1443, "Digilent" },
    { 0x1446, "X.J.GROUP" },
    { 0x1451, "Force Dimension" },
    { 0x1452, "Dai Nippon Printing, Inc" },
    { 0x1453, "Radio Shack" },
    { 0x1456, "Extending Wire & Cable Co., Ltd." },
    { 0x1457, "First International Computer, Inc." },
    { 0x145f, "Trust" },
    { 0x1460, "Tatung Co." },
    { 0x1461, "Staccato Communications" },
    { 0x1462, "Micro Star International" },
    { 0x146b, "BigBen Interactive" },
    { 0x1472, "Huawei-3Com" },
    { 0x147a, "Formosa Industrial Computing, Inc." },
    { 0x147e, "Upek" },
    { 0x147f, "Hama GmbH & Co., KG" },
    { 0x1482, "Vaillant" },
    { 0x1484, "Elsa AG [hex]" },
    { 0x1485, "Silicom" },
    { 0x1487, "DSP Group, Ltd." },
    { 0x148e, "EVATRONIX SA" },
    { 0x148f, "Ralink Technology, Corp." },
    { 0x1491, "Futronic Technology Co. Ltd." },
    { 0x1493, "Suunto" },
    { 0x1497, "Panstrong Company Ltd." },
    { 0x1498, "Microtek International Inc." },
    { 0x149a, "Imagination Technologies" },
    { 0x14aa, "WideView Technology Inc." },
    { 0x14ad, "CTK Corporation" },
    { 0x14ae, "Printronix Inc." },
    { 0x14af, "ATP Electronics Inc." },
    { 0x14b0, "StarTech.com Ltd." },
    { 0x14b2, "Ralink Technology, Corp." },
    { 0x14c0, "Rockwell Automation, Inc." },
    { 0x14c2, "Gemlight Computer, Ltd" },
    { 0x14c8, "Zytronic" },
    { 0x14cd, "Super Top" },
    { 0x14d8, "JAMER INDUSTRIES CO., LTD." },
    { 0x14dd, "Raritan Computer, Inc." },
    { 0x14e0, "WiNRADiO Communications" },
    { 0x14e1, "Dialogue Technology Corp." },
    { 0x14e5, "SAIN Information & Communications Co., Ltd." },
    { 0x14ea, "Planex Communications" },
    { 0x14ed, "Shure Inc." },
    { 0x14f7, "TechniSat Digital GmbH" },
    { 0x1500, "Ellisys" },
    { 0x1501, "Pine-Tum Enterprise Co., Ltd." },
    { 0x1504, "Bixolon CO LTD" },
    { 0x1508, "Fibocom" },
    { 0x1509, "First International Computer, Inc." },
    { 0x1513, "medMobile" },
    { 0x1514, "Actel" },
    { 0x1516, "CompUSA" },
    { 0x1518, "Cheshire Engineering Corp." },
    { 0x1519, "Comneon" },
    { 0x151f, "Opal Kelly Incorporated" },
    { 0x1520, "Bitwire Corp." },
    { 0x1524, "ENE Technology Inc" },
    { 0x1527, "Silicon Portals" },
    { 0x1529, "UBIQUAM Co., Ltd." },
    { 0x152a, "Thesycon Systemsoftware & Consulting GmbH" },
    { 0x152b, "MIR Srl" },
    { 0x152d, "JMicron Technology Corp. / JMicron USA Technology Corp." },
    { 0x152e, "LG (HLDS)" },
    { 0x1532, "Razer USA, Ltd" },
    { 0x153b, "TerraTec Electronic GmbH" },
    { 0x1546, "U-Blox AG" },
    { 0x1547, "SG Intec Ltd & Co KG" },
    { 0x154a, "Celectronic GmbH" },
    { 0x154b, "PNY" },
    { 0x154d, "ConnectCounty Holdings Berhad" },
    { 0x154e, "D&M Holdings, Inc. (Denon/Marantz)" },
    { 0x154f, "SNBC CO., Ltd" },
    { 0x1554, "Prolink Microsystems Corp." },
    { 0x1557, "OQO" },
    { 0x1568, "Sunf Pu Technology Co., Ltd" },
    { 0x156f, "Quantum Corporation" },
    { 0x1570, "ALLTOP TECHNOLOGY CO., LTD." },
    { 0x157b, "Ketron SRL" },
    { 0x157e, "TRENDnet" },
    { 0x1582, "Fiberline" },
    { 0x1587, "SMA Technologie AG" },
    { 0x158d, "Oakley Inc." },
    { 0x158e, "JDS Uniphase Corporation (JDSU)" },
    { 0x1598, "Kunshan Guoji Electronics Co., Ltd." },
    { 0x15a2, "Freescale Semiconductor, Inc." },
    { 0x15a4, "Afatech Technologies, Inc." },
    { 0x15a8, "Teams Power Limited" },
    { 0x15a9, "Gemtek" },
    { 0x15aa, "Gearway Electronics (Dong Guan) Co., Ltd." },
    { 0x15ad, "VMware Inc." },
    { 0x15ba, "Olimex Ltd." },
    { 0x15c0, "XL Imaging" },
    { 0x15c2, "SoundGraph Inc." },
    { 0x15c5, "Advance Multimedia Internet Technology Inc. (AMIT)" },
    { 0x15c6, "Laboratoires MXM" },
    { 0x15c8, "KTF Technologies" },
    { 0x15c9, "D-Box Technologies" },
    { 0x15ca, "Textech International Ltd." },
    { 0x15d5, "Coulomb Electronics Ltd." },
    { 0x15d9, "Trust International B.V." },
    { 0x15dc, "Hynix Semiconductor Inc." },
    { 0x15e0, "Seong Ji Industrial Co., Ltd." },
    { 0x15e1, "RSA" },
    { 0x15e4, "Numark" },
    { 0x15e8, "SohoWare" },
    { 0x15e9, "Pacific Digital Corp." },
    { 0x15ec, "Belcarra Technologies Corp." },
    { 0x15f4, "HanfTek" },
    { 0x1604, "Tascam" },
    { 0x1605, "ACCES I/O Products, Inc." },
    { 0x1606, "Umax" },
    { 0x1608, "Inside Out Networks [hex]" },
    { 0x160a, "VIA Technologies, Inc." },
    { 0x160e, "INRO" },
    { 0x1614, "Amoi Electronics" },
    { 0x1617, "Sony Corp." },
    { 0x1619, "L & K Precision Technology Co., Ltd." },
    { 0x161c, "Digitech Systems" },
    { 0x1621, "Wionics Research" },
    { 0x1628, "Stonestreet One, Inc." },
    { 0x162a, "Airgo Networks Inc." },
    { 0x162f, "WiQuest Communications, Inc." },
    { 0x1630, "2Wire, Inc." },
    { 0x1631, "Good Way Technology" },
    { 0x1633, "AIM GmbH" },
    { 0x1645, "Entrega [hex]" },
    { 0x1649, "SofTec Microsystems" },
    { 0x164a, "ChipX" },
    { 0x164c, "Matrix Vision GmbH" },
    { 0x1657, "Struck Innovative Systeme GmbH" },
    { 0x165b, "Frontier Design Group" },
    { 0x165c, "Kondo Kagaku" },
    { 0x1660, "Creatix Polymedia GmbH" },
    { 0x1667, "GIGA-TMS INC." },
    { 0x1668, "Actiontec Electronics, Inc. [hex]" },
    { 0x1669, "PiKRON Ltd. [hex]" },
    { 0x166a, "Clipsal" },
    { 0x1677, "China Huada Integrated Circuit Design (Group) Co., Ltd. (CIDC Group)" },
    { 0x1679, "Total Phase" },
    { 0x167b, "Pure Digital Technologies, Inc." },
    { 0x1680, "Golden Bridge Electech Inc." },
    { 0x1681, "Prevo Technologies, Inc." },
    { 0x1682, "Maxwise Production Enterprise Ltd." },
    { 0x1684, "Godspeed Computer Corp." },
    { 0x1685, "Delock" },
    { 0x1686, "ZOOM Corporation" },
    { 0x1687, "Kingmax Digital Inc." },
    { 0x1688, "Saab AB" },
    { 0x1689, "Razer USA, Ltd" },
    { 0x168c, "Atheros Communications" },
    { 0x1690, "Askey Computer Corp. [hex]" },
    { 0x1696, "Hitachi Video and Information System, Inc." },
    { 0x1697, "VTec Test, Inc." },
    { 0x16a5, "Shenzhen Zhengerya Cable Co., Ltd." },
    { 0x16a6, "Unigraf" },
    { 0x16ab, "Global Sun Technology" },
    { 0x16ac, "Dongguan ChingLung Wire & Cable Co., Ltd." },
    { 0x16b4, "iStation" },
    { 0x16b5, "Persentec, Inc." },
    { 0x16c0, "Van Ooijen Technische Informatica" },
    { 0x16ca, "Wireless Cables, Inc." },
    { 0x16cc, "silex technology, Inc." },
    { 0x16d0, "MCS" },
    { 0x16d1, "Suprema Inc." },
    { 0x16d3, "Frontline Test Equipment, Inc." },
    { 0x16d5, "AnyDATA Corporation" },
    { 0x16d6, "JABLOCOM s.r.o." },
    { 0x16d8, "CMOTECH Co., Ltd." },
    { 0x16dc, "Wiener, Plein & Baus" },
    { 0x16de, "Telemecanique" },
    { 0x16df, "King Billion Electronics Co., Ltd." },
    { 0x16f0, "GN Hearing A/S" },
    { 0x16f5, "Futurelogic Inc." },
    { 0x1702, "FDI-MATELEC" },
    { 0x1706, "BlueView Technologies, Inc." },
    { 0x1707, "ARTIMI" },
    { 0x170b, "Swissonic" },
    { 0x170d, "Avnera" },
    { 0x1711, "Leica Microsystems" },
    { 0x1724, "Meyer Instruments (MIS)" },
    { 0x1725, "Vitesse Semiconductor" },
    { 0x1726, "Axesstel, Inc." },
    { 0x172f, "Waltop International Corp." },
    { 0x1733, "Cellink Technology Co., Ltd" },
    { 0x1736, "CANON IMAGING SYSTEM TECHNOLOGIES INC." },
    { 0x1737, "802.11g Adapter [Linksys WUSB54GC v3]" },
    { 0x173a, "Roche" },
    { 0x173d, "QSENN" },
    { 0x1740, "Senao" },
    { 0x1743, "General Atomics" },
    { 0x1748, "MQP Electronics" },
    { 0x174c, "ASMedia Technology Inc." },
    { 0x174f, "Syntek" },
    { 0x1753, "GERTEC Telecomunicacoes Ltda." },
    { 0x1756, "ENENSYS Technologies" },
    { 0x1759, "LucidPort Technology, Inc." },
    { 0x1761, "ASUSTek Computer, Inc. (wrong ID)" },
    { 0x1770, "MSI" },
    { 0x1772, "System Level Solutions, Inc." },
    { 0x1776, "Arowana" },
    { 0x1777, "Microscan Systems, Inc." },
    { 0x177f, "Sweex" },
    { 0x1781, "Multiple Vendors" },
    { 0x1782, "Spreadtrum Communications Inc." },
    { 0x1784, "TopSeed Technology Corp." },
    { 0x1787, "ATI AIB" },
    { 0x1788, "ShenZhen Litkconn Technology Co., Ltd." },
    { 0x178e, "ASUSTek Computer, Inc. (wrong ID)" },
    { 0x1796, "Printrex, Inc." },
    { 0x1797, "JALCO CO., LTD." },
    { 0x1799, "Thales Norway A/S" },
    { 0x179d, "Ricavision International, Inc." },
    { 0x17a0, "Samson Technologies Corp." },
    { 0x17a4, "Concept2" },
    { 0x17a5, "Advanced Connection Technology Inc." },
    { 0x17a7, "MICOMSOFT CO., LTD." },
    { 0x17a8, "Kamstrup A/S" },
    { 0x17b3, "Grey Innovation" },
    { 0x17b5, "Lunatone" },
    { 0x17ba, "SAURIS GmbH" },
    { 0x17c3, "Singim International Corp." },
    { 0x17cc, "Native Instruments" },
    { 0x17cf, "Hip Hing Cable & Plug Mfy. Ltd." },
    { 0x17d0, "Sanford L.P." },
    { 0x17d3, "Korea Techtron Co., Ltd." },
    { 0x17e9, "DisplayLink" },
    { 0x17eb, "Cornice, Inc." },
    { 0x17ef, "Lenovo" },
    { 0x17f4, "WaveSense" },
    { 0x17f5, "K.K. Rocky" },
    { 0x17f6, "Unicomp, Inc." },
    { 0x1809, "Advantech" },
    { 0x1822, "Twinhan" },
    { 0x1831, "Gwo Jinn Industries Co., Ltd." },
    { 0x1832, "Huizhou Shenghua Industrial Co., Ltd." },
    { 0x183d, "VIVOphone" },
    { 0x1843, "Vaisala" },
    { 0x1849, "ASRock Incorporation" },
    { 0x184f, "K2L GmbH" },
    { 0x1852, "GYROCOM C&C Co., LTD" },
    { 0x1854, "Memory Devices Ltd." },
    { 0x185b, "Compro" },
    { 0x1861, "Tech Technology Industrial Company" },
    { 0x1862, "Teridian Semiconductor Corp." },
    { 0x1870, "Nexio Co., Ltd" },
    { 0x1871, "Aveo Technology Corp." },
    { 0x1873, "Navilock" },
    { 0x187c, "Alienware Corporation" },
    { 0x187f, "Siano Mobile Silicon" },
    { 0x1892, "Vast Technologies, Inc." },
    { 0x1894, "Topseed" },
    { 0x1897, "Evertop Wire Cable Co." },
    { 0x189f, "3Shape A/S" },
    { 0x18a4, "CSSN" },
    { 0x18a5, "Verbatim, Ltd" },
    { 0x18b1, "Petalynx" },
    { 0x18b4, "e3C Technologies" },
    { 0x18b6, "Mikkon Technology Limited" },
    { 0x18b7, "Zotek Electronic Co., Ltd." },
    { 0x18c5, "AMIT Technology, Inc." },
    { 0x18cd, "Ecamm" },
    { 0x18d1, "Google Inc." },
    { 0x18d5, "Starline International Group Limited" },
    { 0x18d9, "Kaba" },
    { 0x18dc, "LKC Technologies, Inc." },
    { 0x18dd, "Planon System Solutions Inc." },
    { 0x18e3, "Fitipower Integrated Technology Inc" },
    { 0x18e8, "Qcom" },
    { 0x18ea, "Matrox Graphics, Inc." },
    { 0x18ec, "Arkmicro Technologies Inc." },
    { 0x18ef, "ELV Elektronik AG" },
    { 0x18f8, "[Maxxter]" },
    { 0x18fb, "Scriptel Corporation" },
    { 0x18fd, "FineArch Inc." },
    { 0x1901, "GE Healthcare" },
    { 0x1908, "GEMBIRD" },
    { 0x190d, "Motorola GSG" },
    { 0x1914, "Alco Digital Devices Limited" },
    { 0x1915, "Nordic Semiconductor ASA" },
    { 0x191c, "Innovative Technology LTD" },
    { 0x1923, "FitLinxx" },
    { 0x1926, "NextWindow" },
    { 0x1928, "Proceq SA" },
    { 0x192f, "Avago Technologies, Pte." },
    { 0x1930, "Shenzhen Xianhe Technology Co., Ltd." },
    { 0x1931, "Ningbo Broad Telecommunication Co., Ltd." },
    { 0x1934, "Feature Integration Technology Inc. (Fintek)" },
    { 0x1935, "Elektron Music Machines" },
    { 0x1938, "Meinberg Funkuhren GmbH & Co. KG" },
    { 0x1941, "Dream Link" },
    { 0x1943, "Sensoray Co., Inc." },
    { 0x1949, "Lab126, Inc." },
    { 0x194f, "PreSonus Audio Electronics, Inc." },
    { 0x1951, "Hyperstone AG" },
    { 0x1953, "Ironkey Inc." },
    { 0x1954, "Radiient Technologies" },
    { 0x195d, "Itron Technology iONE" },
    { 0x1963, "IK Multimedia" },
    { 0x1965, "Uniden Corporation" },
    { 0x1967, "CASIO HITACHI Mobile Communications Co., Ltd." },
    { 0x196b, "Wispro Technology Inc." },
    { 0x1970, "Dane-Elec Corp. USA" },
    { 0x1973, "Spectralink Corporation" },
    { 0x1975, "Dongguan Guneetal Wire & Cable Co., Ltd." },
    { 0x1976, "Chipsbrand Microelectronics (HK) Co., Ltd." },
    { 0x1977, "T-Logic" },
    { 0x197d, "Leuze electronic" },
    { 0x1980, "Storage Appliance Corporation" },
    { 0x1989, "Nuconn Technology Corp." },
    { 0x198f, "Beceem Communications Inc." },
    { 0x1990, "Acron Precision Industrial Co., Ltd." },
    { 0x1995, "Trillium Technology Pty. Ltd." },
    { 0x1996, "PixeLINK" },
    { 0x1997, "Shenzhen Riitek Technology Co., Ltd" },
    { 0x199b, "MicroStrain, Inc." },
    { 0x199e, "The Imaging Source Europe GmbH" },
    { 0x199f, "Benica Corporation" },
    { 0x19a5, "HARRIS Corp." },
    { 0x19a8, "Biforst Technology Inc." },
    { 0x19ab, "Bodelin" },
    { 0x19af, "S Life" },
    { 0x19b2, "Batronix" },
    { 0x19b4, "Celestron" },
    { 0x19b5, "B & W Group" },
    { 0x19b6, "Infotech Logistic, LLC" },
    { 0x19b9, "Data Robotics" },
    { 0x19c2, "Futuba" },
    { 0x19ca, "Mindtribe" },
    { 0x19cf, "Parrot SA" },
    { 0x19d1, "BYD" },
    { 0x19d2, "ZTE WCDMA Technologies MSM" },
    { 0x19db, "KFI Printers" },
    { 0x19e1, "WeiDuan Electronic Accessory (S.Z.) Co., Ltd." },
    { 0x19e8, "Industrial Technology Research Institute" },
    { 0x19ef, "Pak Heng Technology (Shenzhen) Co., Ltd." },
    { 0x19f7, "RODE Microphones" },
    { 0x19fa, "Gampaq Co.Ltd" },
    { 0x19fd, "MTI Instruments Inc." },
    { 0x19ff, "Dynex" },
    { 0x1a08, "Bellwood International, Inc." },
    { 0x1a0a, "USB-IF non-workshop" },
    { 0x1a12, "KES Co., Ltd." },
    { 0x1a1d, "Veho" },
    { 0x1a25, "Amphenol East Asia Ltd." },
    { 0x1a2a, "Seagate Branded Solutions" },
    { 0x1a2c, "China Resource Semico Co., Ltd" },
    { 0x1a32, "Quanta Microsystems, Inc." },
    { 0x1a34, "ACRUX" },
    { 0x1a36, "Biwin Technology Ltd." },
    { 0x1a40, "Terminus Technology Inc." },
    { 0x1a41, "Action Electronics Co., Ltd." },
    { 0x1a44, "VASCO Data Security International" },
    { 0x1a4a, "Silicon Image" },
    { 0x1a4b, "SafeBoot International B.V." },
    { 0x1a5a, "Tandberg Data" },
    { 0x1a61, "Abbott Diabetes Care" },
    { 0x1a64, "Mastervolt" },
    { 0x1a6a, "Spansion Inc." },
    { 0x1a6d, "SamYoung Electronics Co., Ltd" },
    { 0x1a6e, "Global Unichip Corp." },
    { 0x1a6f, "Sagem Orga GmbH" },
    { 0x1a72, "Physik Instrumente" },
    { 0x1a79, "Bayer Health Care LLC" },
    { 0x1a7b, "Lumberg Connect  GmbH & Co. KG" },
    { 0x1a7c, "Evoluent" },
    { 0x1a7e, "Meltec Systementwicklung" },
    { 0x1a81, "Holtek Semiconductor, Inc." },
    { 0x1a86, "QinHeng Electronics" },
    { 0x1a89, "Dynalith Systems Co., Ltd." },
    { 0x1a8b, "SGS Taiwan Ltd." },
    { 0x1a8d, "BandRich, Inc." },
    { 0x1a98, "Leica Camera AG" },
    { 0x1aa4, "Data Drive Thru, Inc." },
    { 0x1aa5, "UBeacon Technologies, Inc." },
    { 0x1aa6, "eFortune Technology Corp." },
    { 0x1aab, "Silvercreations Software AG" },
    { 0x1aad, "KeeTouch" },
    { 0x1ab1, "Rigol Technologies" },
    { 0x1ab2, "Allied Vision" },
    { 0x1acb, "Salcomp Plc" },
    { 0x1acc, "Midiplus Co, Ltd." },
    { 0x1ad1, "Desay Wire Co., Ltd." },
    { 0x1ad4, "APS" },
    { 0x1adb, "Schweitzer Engineering Laboratories, Inc" },
    { 0x1ae4, "ic-design Reinhard Gottinger GmbH" },
    { 0x1ae7, "X-TENSIONS" },
    { 0x1aed, "High Top Precision Electronic Co., Ltd." },
    { 0x1aef, "Conntech Electronic (Suzhou) Corporation" },
    { 0x1af1, "Connect One Ltd." },
    { 0x1af3, "Kingsis Technology Corporation" },
    { 0x1afe, "A. Eberle GmbH & Co. KG" },
    { 0x1b04, "Meilhaus Electronic GmbH" },
    { 0x1b0e, "BLUTRONICS S.r.l." },
    { 0x1b12, "Eventide" },
    { 0x1b1c, "Corsair" },
    { 0x1b1e, "General Imaging / General Electric" },
    { 0x1b1f, "eQ-3 Entwicklung GmbH" },
    { 0x1b20, "MStar Semiconductor, Inc." },
    { 0x1b22, "WiLinx Corp." },
    { 0x1b24, "Telegent Systems, Inc." },
    { 0x1b26, "Cellex Power Products, Inc." },
    { 0x1b27, "Current Electronics Inc." },
    { 0x1b28, "NAVIsis Inc." },
    { 0x1b32, "Ugobe Life Forms, Inc." },
    { 0x1b36, "ViXS Systems, Inc." },
    { 0x1b3b, "iPassion Technology Inc." },
    { 0x1b3f, "Generalplus Technology Inc." },
    { 0x1b47, "Energizer Holdings, Inc." },
    { 0x1b48, "Plastron Precision Co., Ltd." },
    { 0x1b52, "ARH Inc." },
    { 0x1b59, "K.S. Terminals Inc." },
    { 0x1b5a, "Chao Zhou Kai Yuan Electric Co., Ltd." },
    { 0x1b65, "The Hong Kong Standards and Testing Centre Ltd." },
    { 0x1b71, "Fushicai" },
    { 0x1b72, "ATERGI TECHNOLOGY CO., LTD." },
    { 0x1b73, "Fresco Logic" },
    { 0x1b75, "Ovislink Corp." },
    { 0x1b76, "Legend Silicon Corp." },
    { 0x1b80, "Afatech" },
    { 0x1b86, "Dongguan Guanshang Electronics Co., Ltd." },
    { 0x1b88, "ShenMing Electron (Dong Guan) Co., Ltd." },
    { 0x1b8c, "Altium Limited" },
    { 0x1b8d, "e-MOVE Technology Co., Ltd." },
    { 0x1b8e, "Amlogic, Inc." },
    { 0x1b8f, "MA LABS, Inc." },
    { 0x1b96, "N-Trig" },
    { 0x1b98, "YMax Communications Corp." },
    { 0x1b99, "Shenzhen Yuanchuan Electronic" },
    { 0x1ba1, "JINQ CHERN ENTERPRISE CO., LTD." },
    { 0x1ba2, "Lite Metals & Plastic (Shenzhen) Co., Ltd." },
    { 0x1ba4, "Ember Corporation" },
    { 0x1ba6, "Abilis Systems" },
    { 0x1ba8, "China Telecommunication Technology Labs" },
    { 0x1bad, "Harmonix Music" },
    { 0x1bae, "Vuzix Corporation" },
    { 0x1bbb, "T & A Mobile Phones" },
    { 0x1bbd, "Videology Imaging Solutions, Inc." },
    { 0x1bc0, "Beijing Senseshield Technology Co.,Ltd." },
    { 0x1bc4, "Ford Motor Co." },
    { 0x1bc5, "AVIXE Technology (China) Ltd." },
    { 0x1bc7, "Telit Wireless Solutions" },
    { 0x1bce, "Contac Cable Industrial Limited" },
    { 0x1bcf, "Sunplus Innovation Technology Inc." },
    { 0x1bd0, "Hangzhou Riyue Electronic Co., Ltd." },
    { 0x1bd5, "BG Systems, Inc." },
    { 0x1bda, "University Of Southampton" },
    { 0x1bde, "P-TWO INDUSTRIES, INC." },
    { 0x1bef, "Shenzhen Tongyuan Network-Communication Cables Co., Ltd" },
    { 0x1bf0, "RealVision Inc." },
    { 0x1bf5, "Extranet Systems Inc." },
    { 0x1bf6, "Orient Semiconductor Electronics, Ltd." },
    { 0x1bfd, "TouchPack" },
    { 0x1c02, "Kreton Corporation" },
    { 0x1c04, "QNAP System Inc." },
    { 0x1c05, "Shenxhen Stager Electric" },
    { 0x1c0c, "Ionics EMS, Inc." },
    { 0x1c0d, "Relm Wireless" },
    { 0x1c10, "Lanterra Industrial Co., Ltd." },
    { 0x1c11, "Input Club Inc." },
    { 0x1c13, "ALECTRONIC LIMITED" },
    { 0x1c1a, "Datel Electronics Ltd." },
    { 0x1c1b, "Volkswagen of America, Inc." },
    { 0x1c1f, "Goldvish S.A." },
    { 0x1c20, "Fuji Electric Device Technology Co., Ltd." },
    { 0x1c21, "ADDMM LLC" },
    { 0x1c22, "ZHONGSHAN CHIANG YU ELECTRIC CO., LTD." },
    { 0x1c26, "Shanghai Haiying Electronics Co., Ltd." },
    { 0x1c27, "HuiYang D & S Cable Co., Ltd." },
    { 0x1c28, "PMD Technologies" },
    { 0x1c29, "Elster GmbH" },
    { 0x1c31, "LS Cable Ltd." },
    { 0x1c34, "SpringCard" },
    { 0x1c37, "Authorizer Technologies, Inc." },
    { 0x1c3d, "NONIN MEDICAL INC." },
    { 0x1c3e, "Wep Peripherals" },
    { 0x1c40, "EZPrototypes" },
    { 0x1c49, "Cherng Weei Technology Corp." },
    { 0x1c4b, "Geratherm Medical AG" },
    { 0x1c4f, "SiGma Micro" },
    { 0x1c57, "Zalman Tech Co., Ltd." },
    { 0x1c6b, "Philips & Lite-ON Digital Solutions Corporation" },
    { 0x1c6c, "Skydigital Inc." },
    { 0x1c71, "Humanware Inc" },
    { 0x1c73, "AMT" },
    { 0x1c75, "Arturia" },
    { 0x1c77, "Kaetat Industrial Co., Ltd." },
    { 0x1c78, "Datascope Corp." },
    { 0x1c79, "Unigen Corporation" },
    { 0x1c7a, "LighTuning Technology Inc." },
    { 0x1c7b, "LUXSHARE PRECISION INDUSTRY (SHENZHEN) CO., LTD." },
    { 0x1c82, "Atracsys" },
    { 0x1c83, "Schomaecker GmbH" },
    { 0x1c87, "2N TELEKOMUNIKACE a.s." },
    { 0x1c88, "Somagic, Inc." },
    { 0x1c89, "HONGKONG WEIDIDA ELECTRON LIMITED" },
    { 0x1c8e, "ASTRON INTERNATIONAL CORP." },
    { 0x1c98, "ALPINE ELECTRONICS, INC." },
    { 0x1c9e, "OMEGA TECHNOLOGY" },
    { 0x1ca0, "ACCARIO Inc." },
    { 0x1ca1, "Symwave" },
    { 0x1cac, "Kinstone" },
    { 0x1cb3, "Aces Electronic Co., Ltd." },
    { 0x1cb4, "OPEX CORPORATION" },
    { 0x1cb6, "IdeaCom Technology Inc." },
    { 0x1cbe, "Luminary Micro Inc." },
    { 0x1cbf, "FORTAT SKYMARK INDUSTRIAL COMPANY" },
    { 0x1cc0, "PlantSense" },
    { 0x1cca, "NextWave Broadband Inc." },
    { 0x1ccd, "Bodatong Technology (Shenzhen) Co., Ltd." },
    { 0x1cd4, "adp corporation" },
    { 0x1cd5, "Firecomms Ltd." },
    { 0x1cd6, "Antonio Precise Products Manufactory Ltd." },
    { 0x1cde, "Telecommunications Technology Association (TTA)" },
    { 0x1cdf, "WonTen Technology Co., Ltd." },
    { 0x1ce0, "EDIMAX TECHNOLOGY CO., LTD." },
    { 0x1ce1, "Amphenol KAE" },
    { 0x1cf1, "Dresden Elektronik" },
    { 0x1cfc, "ANDES TECHNOLOGY CORPORATION" },
    { 0x1cfd, "Flextronics Digital Design Japan, LTD." },
    { 0x1d03, "iCON" },
    { 0x1d07, "Solid-Motion" },
    { 0x1d08, "NINGBO HENTEK DRAGON ELECTRONICS CO., LTD." },
    { 0x1d09, "TechFaith Wireless Technology Limited" },
    { 0x1d0a, "Johnson Controls, Inc. The Automotive Business Unit" },
    { 0x1d0b, "HAN HUA CABLE & WIRE TECHNOLOGY (J.X.) CO., LTD." },
    { 0x1d0d, "TDKMedia" },
    { 0x1d0f, "Sonix Technology Co., Ltd." },
    { 0x1d14, "ALPHA-SAT TECHNOLOGY LIMITED" },
    { 0x1d17, "C-Thru Music Ltd." },
    { 0x1d19, "Dexatek Technology Ltd." },
    { 0x1d1f, "Diostech Co., Ltd." },
    { 0x1d20, "SAMTACK INC." },
    { 0x1d27, "ASUS" },
    { 0x1d34, "Dream Cheeky" },
    { 0x1d45, "Touch" },
    { 0x1d4d, "PEGATRON CORPORATION" },
    { 0x1d50, "OpenMoko, Inc." },
    { 0x1d57, "Xenta" },
    { 0x1d5b, "Smartronix, Inc." },
    { 0x1d5c, "Fresco Logic" },
    { 0x1d6b, "Linux Foundation" },
    { 0x1d88, "Mahr GmbH" },
    { 0x1d90, "Citizen" },
    { 0x1d9d, "Sigma Sport" },
    { 0x1dd2, "Leo Bodnar Electronics Ltd" },
    { 0x1dd3, "Dajc Inc." },
    { 0x1de1, "Actions Microelectronics Co." },
    { 0x1de6, "MICRORISC s.r.o." },
    { 0x1e0e, "Qualcomm / Option" },
    { 0x1e10, "Point Grey Research, Inc." },
    { 0x1e17, "Mirion Technologies Dosimetry Services Division" },
    { 0x1e1d, "Kanguru Solutions" },
    { 0x1e1f, "INVIA" },
    { 0x1e29, "Festo AG & Co. KG" },
    { 0x1e2d, "Gemalto M2M GmbH" },
    { 0x1e3d, "Chipsbank Microelectronics Co., Ltd" },
    { 0x1e41, "Cleverscope" },
    { 0x1e44, "SHIMANO INC." },
    { 0x1e4e, "Cubeternet" },
    { 0x1e54, "TypeMatrix" },
    { 0x1e68, "TrekStor GmbH & Co. KG" },
    { 0x1e71, "NZXT" },
    { 0x1e74, "Coby Electronics Corporation" },
    { 0x1e7b, "Zurich Instruments" },
    { 0x1e7d, "ROCCAT" },
    { 0x1e8e, "Airbus Defence and Space" },
    { 0x1e91, "Other World Computing" },
    { 0x1ea7, "SHARKOON Technologies GmbH" },
    { 0x1eab, "Fujian Newland Computer Co., Ltd" },
    { 0x1eaf, "Leaflabs" },
    { 0x1eb8, "Modacom Co., Ltd." },
    { 0x1ebb, "NuCORE Technology, Inc." },
    { 0x1ecb, "AMTelecom" },
    { 0x1ed8, "FENDER MUSICAL INSTRUMENTS CORPORATION" },
    { 0x1eda, "AirTies Wireless Networks" },
    { 0x1edb, "Blackmagic design" },
    { 0x1ee8, "ONDA COMMUNICATION S.p.a." },
    { 0x1ef6, "EADS Deutschland GmbH" },
    { 0x1f0c, "CMX Systems" },
    { 0x1f28, "Cal-Comp" },
    { 0x1f3a, "Allwinner Technology" },
    { 0x1f44, "The Neat Company" },
    { 0x1f48, "H-TRONIC GmbH" },
    { 0x1f4d, "G-Tek Electronics Group" },
    { 0x1f52, "Systems & Electronic Development FZCO (SEDCO)" },
    { 0x1f6f, "Aliph" },
    { 0x1f75, "Innostor Technology Corporation" },
    { 0x1f82, "TANDBERG" },
    { 0x1f84, "Alere, Inc." },
    { 0x1f87, "Stantum" },
    { 0x1f9b, "Ubiquiti Networks, Inc." },
    { 0x1fab, "Samsung Opto-Electroncs Co., Ltd." },
    { 0x1fac, "Franklin Wireless" },
    { 0x1fae, "Lumidigm" },
    { 0x1fb2, "Withings" },
    { 0x1fba, "DERMALOG Identification Systems GmbH" },
    { 0x1fbd, "Delphin Technology AG" },
    { 0x1fc9, "NXP Semiconductors" },
    { 0x1fde, "ILX Lightwave Corporation" },
    { 0x1fe7, "Vertex Wireless Co., Ltd." },
    { 0x1ff7, "CVT Electronics.Co.,Ltd" },
    { 0x1ffb, "Pololu Corporation" },
    { 0x1fff, "Ideofy Inc." },
    { 0x2000, "CMX Systems" },
    { 0x2001, "D-Link Corp." },
    { 0x2002, "DAP Technologies" },
    { 0x2003, "detectomat" },
    { 0x2006, "LenovoMobile" },
    { 0x2009, "iStorage" },
    { 0x200c, "Reloop" },
    { 0x2013, "PCTV Systems" },
    { 0x2018, "Deutsche Telekom AG" },
    { 0x2019, "PLANEX" },
    { 0x201e, "Haier" },
    { 0x203a, "PARALLELS" },
    { 0x203d, "Encore Electronics Inc." },
    { 0x2040, "Hauppauge" },
    { 0x2047, "Texas Instruments" },
    { 0x2058, "Nano River Technology" },
    { 0x2077, "Taicang T&W Electronics Co. Ltd" },
    { 0x2080, "Barnes & Noble" },
    { 0x2086, "SIMPASS" },
    { 0x2087, "Cando" },
    { 0x20a0, "Clay Logic" },
    { 0x20b1, "XMOS Ltd" },
    { 0x20b3, "Hanvon" },
    { 0x20b7, "Qi Hardware" },
    { 0x20bc, "ShenZhen ShanWan Technology Co., Ltd." },
    { 0x20ce, "Minicircuits" },
    { 0x20df, "Simtec Electronics" },
    { 0x20f0, "L3Harris Technologies" },
    { 0x20f1, "NET New Electronic Technology GmbH" },
    { 0x20f4, "TRENDnet" },
    { 0x20f7, "XIMEA" },
    { 0x2100, "RT Systems" },
    { 0x2101, "ActionStar" },
    { 0x2104, "Tobii Technology AB" },
    { 0x2107, "RDING TECH CO.,LTD" },
    { 0x2109, "VIA Labs, Inc." },
    { 0x2113, "Softkinetic" },
    { 0x2116, "KT Tech" },
    { 0x211f, "CELOT Corporation" },
    { 0x2123, "Cheeky Dream" },
    { 0x2125, "Fiberpro Inc." },
    { 0x2133, "signotec GmbH" },
    { 0x2149, "Advanced Silicon S.A." },
    { 0x214b, "Huasheng Electronics" },
    { 0x214e, "Swiftpoint" },
    { 0x2162, "Broadxent (Creative Labs)" },
    { 0x2166, "JVC Kenwood" },
    { 0x2184, "GW Instek" },
    { 0x2188, "No brand" },
    { 0x219c, "Seal One AG" },
    { 0x21a1, "Emotiv Systems Pty. Ltd." },
    { 0x21a4, "Electronic Arts Inc." },
    { 0x21a9, "Saleae, Inc." },
    { 0x21ab, "Planeta Informatica" },
    { 0x21b4, "AudioQuest" },
    { 0x21d6, "Agecodagis SARL" },
    { 0x2207, "Fuzhou Rockchip Electronics Company" },
    { 0x221a, "ZTEX GmbH" },
    { 0x2222, "MacAlly" },
    { 0x2226, "Copper Mountain technologies" },
    { 0x2227, "SAMWOO Enterprise" },
    { 0x222a, "ILI Technology Corp." },
    { 0x2230, "Plugable" },
    { 0x2232, "Silicon Motion" },
    { 0x2233, "RadioShack Corporation" },
    { 0x2237, "Kobo Inc." },
    { 0x2245, "Aspeed Technology, Inc." },
    { 0x224f, "APDM" },
    { 0x2256, "Faderfox" },
    { 0x225d, "Morpho" },
    { 0x226e, "DISPLAX" },
    { 0x228d, "8D Technologies inc." },
    { 0x22a4, "VERZO Technology" },
    { 0x22a6, "Pie Digital, Inc." },
    { 0x22a7, "Fortinet Technologies" },
    { 0x22b1, "Secret Labs LLC" },
    { 0x22b8, "Motorola PCS" },
    { 0x22b9, "eTurboTouch Technology, Inc." },
    { 0x22ba, "Technology Innovation Holdings, Ltd" },
    { 0x22c9, "StepOver GmbH" },
    { 0x22cd, "Kinova Robotics Inc." },
    { 0x22d4, "Laview Technology" },
    { 0x22d9, "OPPO Electronics Corp." },
    { 0x22db, "Phase One" },
    { 0x22dc, "Mellanox Technologies" },
    { 0x22de, "WeTelecom Incorporated" },
    { 0x22df, "Medicom MTD, Ltd" },
    { 0x22e0, "secunet Security Networks AG" },
    { 0x22e8, "Cambridge Audio" },
    { 0x2304, "Pinnacle Systems, Inc." },
    { 0x230d, "Teracom" },
    { 0x2314, "INQ Mobile" },
    { 0x2318, "Shining Technologies, Inc. [hex]" },
    { 0x2319, "Tronsmart" },
    { 0x232b, "Pantum Ltd." },
    { 0x232e, "EA Elektro-Automatik GmbH & Co. KG" },
    { 0x2340, "Teleepoch" },
    { 0x2341, "Arduino SA" },
    { 0x2349, "P2 Engineering Group, LLC" },
    { 0x234b, "Free Software Initiative of Japan" },
    { 0x2357, "TP-Link" },
    { 0x2366, "Bitmanufaktur GmbH" },
    { 0x2367, "Teenage Engineering" },
    { 0x2368, "Peterson Electro-Musical Products Inc." },
    { 0x236a, "SiBEAM" },
    { 0x2373, "Pumatronix Ltda" },
    { 0x2375, "Digit@lway, Inc." },
    { 0x2378, "OnLive" },
    { 0x237d, "Cradlepoint" },
    { 0x2386, "Raydium Corporation" },
    { 0x238b, "Hytera Communications" },
    { 0x239a, "Adafruit" },
    { 0x23a0, "BIFIT" },
    { 0x23a6, "Tronical Components GmbH" },
    { 0x23b4, "Dental Wings Inc." },
    { 0x23c7, "Gemini" },
    { 0x23fc, "SesKion GmbH" },
    { 0x2405, "Custom Computer Services, Inc" },
    { 0x2406, "SANHO Digital Electronics Co., Ltd." },
    { 0x2420, "IRiver" },
    { 0x242e, "Vossloh-Schwabe Deutschland GmbH" },
    { 0x2433, "ASETEK" },
    { 0x2443, "Aessent Technology Ltd" },
    { 0x2457, "Ocean Optics Inc." },
    { 0x2458, "Bluegiga Technologies" },
    { 0x245f, "Chord Electronics Limited" },
    { 0x2464, "Nest" },
    { 0x2466, "Fractal Audio Systems" },
    { 0x2476, "YEI Technology" },
    { 0x2478, "Tripp-Lite" },
    { 0x248a, "Maxxter" },
    { 0x249c, "M2Tech s.r.l." },
    { 0x24a4, "Primare AB" },
    { 0x24ae, "Shenzhen Rapoo Technology Co., Ltd." },
    { 0x24c0, "Chaney Instrument" },
    { 0x24c6, "ThrustMaster, Inc." },
    { 0x24cf, "Lytro, Inc." },
    { 0x24dc, "Aladdin R.D." },
    { 0x24e0, "Yoctopuce Sarl" },
    { 0x24e1, "Paratronic" },
    { 0x24e3, "K-Touch" },
    { 0x24ea, "Meva" },
    { 0x24ed, "Zen Group" },
    { 0x24f0, "Metadot" },
    { 0x24ff, "Acroname Inc." },
    { 0x2500, "Ettus Research LLC" },
    { 0x2516, "Cooler Master Co., Ltd." },
    { 0x2520, "ANA-U GmbH" },
    { 0x2527, "Software Bisque" },
    { 0x2537, "Norelsys" },
    { 0x2544, "Energy Micro AS" },
    { 0x2546, "Ravensburger" },
    { 0x2548, "Pulse-Eight" },
    { 0x254e, "SHF Communication Technologies AG" },
    { 0x2554, "ASSA ABLOY AB" },
    { 0x2555, "Basis Science Inc." },
    { 0x255e, "Beijing Bonxeon Technology Co., Ltd." },
    { 0x2560, "e-con Systems" },
    { 0x2563, "ShenZhen ShanWan Technology Co., Ltd." },
    { 0x256b, "Perreaux Industries Ltd" },
    { 0x256f, "3Dconnexion" },
    { 0x2573, "ESI Audiotechnik GmbH" },
    { 0x2574, "AVer Information, Inc." },
    { 0x2575, "Weida Hi-Tech Co., Ltd." },
    { 0x2576, "AFO Co., Ltd." },
    { 0x2578, "Pluscom" },
    { 0x2581, "Plug-up" },
    { 0x258d, "Sequans Communications" },
    { 0x259a, "TriQuint Semiconductor" },
    { 0x25a7, "Areson Technology Corp" },
    { 0x25b5, "FlatFrog" },
    { 0x25bb, "Brunner Elektronik AG" },
    { 0x25bf, "Elegant Invention" },
    { 0x25c4, "ARCAM" },
    { 0x25c6, "Vitus Audio (AVA Group A/S)" },
    { 0x25c8, "Visual Planet Ltd" },
    { 0x25da, "Netatmo" },
    { 0x25e3, "Lumigon" },
    { 0x25f0, "ShanWan" },
    { 0x25fb, "Pentax Ricoh Imaging Co., Ltd" },
    { 0x2604, "Tenda" },
    { 0x2625, "MilDef AB" },
    { 0x2626, "Aruba Networks" },
    { 0x262a, "SAVITECH Corp." },
    { 0x2632, "TwinMOS" },
    { 0x2639, "Xsens" },
    { 0x264a, "Thermaltake" },
    { 0x2650, "Electronics For Imaging, Inc. [hex]" },
    { 0x2659, "Sundtek" },
    { 0x2662, "Moog Music Inc." },
    { 0x266e, "Silicon Integrated Systems" },
    { 0x2672, "GoPro" },
    { 0x2676, "Basler AG" },
    { 0x2685, "Cardo Peripheral Systems LTD" },
    { 0x2687, "Fitbit Inc." },
    { 0x2689, "StepOver International GmbH" },
    { 0x268b, "Dimension Engineering" },
    { 0x26a9, "Research Industrial Systems Engineering" },
    { 0x26aa, "Yaesu Musen" },
    { 0x26b5, "Electrocompaniet" },
    { 0x26bd, "Integral Memory" },
    { 0x26e2, "Ingenieurbuero Dietzsch und Thiele, PartG" },
    { 0x26f2, "Micromega" },
    { 0x2707, "Bardac Corporation" },
    { 0x270d, "Rosand Technologies" },
    { 0x2717, "Xiaomi Inc." },
    { 0x272a, "StarLeaf Ltd." },
    { 0x272c, "Signum Systems" },
    { 0x2730, "Citizen" },
    { 0x2735, "DigitalWay" },
    { 0x273f, "Hughski Limited" },
    { 0x2756, "Victor Hasselblad AB" },
    { 0x2759, "Philip Morris Products S.A." },
    { 0x2765, "Firstbeat Technologies, Ltd." },
    { 0x2766, "LifeScan" },
    { 0x2770, "NHJ, Ltd" },
    { 0x27a8, "Square, Inc." },
    { 0x27b8, "ThingM" },
    { 0x27bd, "Codethink Ltd." },
    { 0x27c0, "Cadwell Laboratories, Inc." },
    { 0x27c6, "Shenzhen Goodix Technology Co.,Ltd." },
    { 0x27d4, "Blackstar Amplification Limited" },
    { 0x27dd, "Mindeo" },
    { 0x27f2, "Softnautics LLP" },
    { 0x2803, "StarLine LLC." },
    { 0x2806, "SIMPASS" },
    { 0x2817, "Signal Hound, Inc." },
    { 0x2818, "Codex Digital Limited" },
    { 0x2821, "ASUSTek Computer Inc." },
    { 0x2822, "REFLEXdigital" },
    { 0x2833, "Oculus VR, Inc." },
    { 0x2836, "OUYA" },
    { 0x286b, "STANEO SAS" },
    { 0x2886, "Seeed Technology Co., Ltd." },
    { 0x2890, "Teknic, Inc" },
    { 0x2899, "Toptronic Industrial Co., Ltd" },
    { 0x289b, "Dracal/Raphnet technologies" },
    { 0x289d, "Seek Thermal, Inc." },
    { 0x28bd, "XP-Pen" },
    { 0x28c7, "Ultimaker B.V." },
    { 0x28d4, "Devialet" },
    { 0x28de, "Valve Software" },
    { 0x28e0, "PT. Prasimax Inovasi Teknologi" },
    { 0x28e9, "GDMicroelectronics" },
    { 0x28f3, "Clover Network, Inc." },
    { 0x28f9, "Profitap HQ BV" },
    { 0x290c, "R. Hamilton & Co. Ltd." },
    { 0x2912, "Audioengine" },
    { 0x2916, "Yota Devices" },
    { 0x2931, "Jolla Oy" },
    { 0x2939, "Zaber Technologies Inc." },
    { 0x2957, "Obsidian Research Corporation" },
    { 0x2961, "Miselu" },
    { 0x296b, "Xacti Corporation" },
    { 0x2972, "FiiO Electronics Technology" },
    { 0x298d, "Next Biometrics" },
    { 0x29bd, "Silicon Works" },
    { 0x29c1, "Taztag" },
    { 0x29c2, "Lewitt GmbH" },
    { 0x29c3, "Noviga" },
    { 0x29e2, "Huatune Technology (Shanghai) Co., Ltd." },
    { 0x29e7, "Brunel University" },
    { 0x29e8, "4Links Limited" },
    { 0x29ea, "Kinesis Corporation" },
    { 0x29f1, "Canaan Creative Co., Ltd" },
    { 0x2a03, "dog hunter AG" },
    { 0x2a0e, "Shenzhen DreamSource Technology Co., Ltd." },
    { 0x2a13, "Grabba International" },
    { 0x2a19, "Numato Systems Pvt. Ltd" },
    { 0x2a1d, "Oxford Nanopore Technologies, Ltd" },
    { 0x2a37, "RTD Embedded Technologies, Inc." },
    { 0x2a39, "RME" },
    { 0x2a3c, "Trinamic Motion Control GmbH & Co KG" },
    { 0x2a45, "Meizu Corp." },
    { 0x2a47, "Mundo Reader, S.L." },
    { 0x2a4b, "EMULEX Corporation" },
    { 0x2a62, "Flymaster Avionics" },
    { 0x2a6e, "Bare Conductive" },
    { 0x2a70, "OnePlus Technology (Shenzhen) Co., Ltd." },
    { 0x2a88, "DFU Technology Ltd" },
    { 0x2a8d, "Keysight Technologies, Inc." },
    { 0x2ab6, "T+A elektroakustik GmbH & Co KG, Germany" },
    { 0x2ac7, "Ultrahaptics Ltd." },
    { 0x2ad1, "Picotronic GmbH" },
    { 0x2ae5, "Fairphone B.V." },
    { 0x2aec, "Ambiq Micro, Inc." },
    { 0x2af4, "ROLI Ltd." },
    { 0x2b03, "STEREOLABS" },
    { 0x2b0e, "LeEco" },
    { 0x2b23, "Red Hat, Inc." },
    { 0x2b24, "KeepKey LLC" },
    { 0x2b3e, "NewAE Technology Inc." },
    { 0x2b4c, "ZUK" },
    { 0x2bc5, "Orbbec 3D Technology International, Inc" },
    { 0x2bcc, "InoTec GmbH Organisationssysteme" },
    { 0x2bd6, "Coroware, Inc." },
    { 0x2bd8, "ROPEX Industrie-Elektronik GmbH" },
    { 0x2c02, "Planex Communications" },
    { 0x2c1a, "Dolphin Peripherals" },
    { 0x2c23, "Supermicro Computer Incorporated" },
    { 0x2c4e, "Mercucys INC" },
    { 0x2c4f, "Canon Electronic Business Machines Co., Ltd." },
    { 0x2c55, "Magic Leap, Inc." },
    { 0x2c7c, "Quectel Wireless Solutions Co., Ltd." },
    { 0x2c97, "Ledger" },
    { 0x2c99, "Prusa" },
    { 0x2c9c, "Vayyar Imaging Ltd." },
    { 0x2c9d, "Nod Inc" },
    { 0x2ca3, "DJI Technology Co., Ltd." },
    { 0x2cb7, "Fibocom" },
    { 0x2cc0, "Hangzhou Zero Zero Infinity Technology Co., Ltd." },
    { 0x2cc2, "Lautsprecher Teufel GmbH" },
    { 0x2ccf, "Hypersecu" },
    { 0x2cd9, "Cambrionix Ltd" },
    { 0x2cdc, "Sea & Sun Technology GmbH" },
    { 0x2ce5, "InX8 Inc [AKiTiO]" },
    { 0x2cf0, "Nuand LLC" },
    { 0x2d1f, "Wacom Taiwan Information Co. Ltd." },
    { 0x2d25, "Kronegger GmbH." },
    { 0x2d2d, "proxmark.org" },
    { 0x2d37, "Zhuhai Poskey Technology Co.,Ltd" },
    { 0x2d6b, "NetUP Inc." },
    { 0x2d81, "Evollve Inc." },
    { 0x2d84, "Zhuhai Poskey Technology Co.,Ltd" },
    { 0x2dc8, "8BitDo" },
    { 0x2dcf, "Dialog Semiconductor" },
    { 0x2def, "Kirale Technologies" },
    { 0x2df2, "LIPS Corporation" },
    { 0x2e04, "HMD Global" },
    { 0x2e0e, "Hatteland Display AS" },
    { 0x2e24, "Hyperkin" },
    { 0x2e3b, "uSens Inc." },
    { 0x2e57, "MEGWARE Computer Vertrieb und Service GmbH" },
    { 0x2e69, "Swift Navigation" },
    { 0x2e95, "SCUF Gaming" },
    { 0x2f76, "KeyXentic Inc." },
    { 0x2fad, "Definium Technologies" },
    { 0x2fb0, "Infocrypt" },
    { 0x2fb2, "Fujitsu, Ltd" },
    { 0x2fc0, "Sensidyne, LP" },
    { 0x2fc6, "Comtrue Inc." },
    { 0x2fe0, "Xaptum, Inc." },
    { 0x2fe3, "NordicSemiconductor" },
    { 0x2fe7, "ELGIN S.A." },
    { 0x2feb, "Beijing Veikk E-Commerce Co., Ltd." },
    { 0x2ff4, "Quixant Plc" },
    { 0x3016, "Boundary Devices, LLC" },
    { 0x3036, "Control iD" },
    { 0x3037, "Beijing Chushifengmang Technology Development Co.,Ltd." },
    { 0x3057, "Kingsis Corporation" },
    { 0x308f, "Input Club" },
    { 0x30a4, "Blues Wireless" },
    { 0x30c2, "UNPARALLEL Innovation, Lda" },
    { 0x30c9, "Luxvisions Innotech Limited" },
    { 0x30ee, "Fujitsu Connected Technologies Limited" },
    { 0x30f2, "Varex Imaging" },
    { 0x3111, "Hiperscan GmbH" },
    { 0x3112, "Meteca SA" },
    { 0x3125, "Eagletron" },
    { 0x3136, "Navini Networks" },
    { 0x3145, "SafeLogic Inc." },
    { 0x3147, "Tanvas, Inc." },
    { 0x316c, "SigmaSense, LLC" },
    { 0x316d, "Purism, SPC" },
    { 0x316e, "SPECINFOSYSTEMS" },
    { 0x3171, "8086 Consultancy" },
    { 0x3176, "Whanam Electronics Co., Ltd" },
    { 0x3195, "Link Instruments" },
    { 0x31c9, "BeiJing LanXum Computer Technology Co., Ltd." },
    { 0x3200, "Alcatel-Lucent Enterprise" },
    { 0x3219, "Smak Tecnologia e Automacao LTDA" },
    { 0x321c, "Premio, Inc." },
    { 0x324c, "CUPRIS Ltd." },
    { 0x326d, "Agile Display Solutions Co., Ltd" },
    { 0x3275, "VidzMedia Pte Ltd" },
    { 0x3293, "Unhuman Inc." },
    { 0x32b3, "TEXA" },
    { 0x3310, "MUDITA Sp. z o.o." },
    { 0x3333, "InLine" },
    { 0x3334, "AEI" },
    { 0x3340, "Yakumo" },
    { 0x3344, "Leaguer Microelectronics (LME)" },
    { 0x348f, "ISY" },
    { 0x3504, "Micro Star" },
    { 0x3538, "Power Quotient International Co., Ltd" },
    { 0x3579, "DIVA" },
    { 0x357d, "Sharkoon" },
    { 0x3636, "InVibro" },
    { 0x3767, "Fanatec" },
    { 0x3838, "WEM" },
    { 0x3923, "National Instruments Corp." },
    { 0x40bb, "I-O Data" },
    { 0x4101, "i-rocks" },
    { 0x4102, "iRiver, Ltd." },
    { 0x413c, "Dell Computer Corp." },
    { 0x4146, "USBest Technology" },
    { 0x4168, "Targus" },
    { 0x4242, "USB Design by Example" },
    { 0x4255, "GoPro" },
    { 0x4317, "Broadcom Corp." },
    { 0x4348, "WinChipHead" },
    { 0x4572, "Shuttle, Inc." },
    { 0x4586, "Panram" },
    { 0x4670, "EMS Production" },
    { 0x46f4, "QEMU" },
    { 0x4752, "Miditech" },
    { 0x4757, "GW Instek" },
    { 0x4766, "Aceeca" },
    { 0x4855, "Memorex" },
    { 0x4971, "SimpleTech" },
    { 0x4d46, "Musical Fidelity" },
    { 0x5032, "Grandtec" },
    { 0x50c2, "Averatec (?)" },
    { 0x5131, "MSR" },
    { 0x5173, "Sweex" },
    { 0x5219, "I-Tetra" },
    { 0x5332, "Clearly Superior Technologies, Inc." },
    { 0x5345, "Owon" },
    { 0x534c, "SatoshiLabs" },
    { 0x534d, "MacroSilicon" },
    { 0x5354, "Meyer Instruments (MIS)" },
    { 0x544d, "Transmeta Corp." },
    { 0x5543, "UC-Logic Technology Corp." },
    { 0x5555, "Epiphan Systems Inc." },
    { 0x55aa, "OnSpec Electronic, Inc." },
    { 0x5654, "Gotview" },
    { 0x5656, "Uni-Trend Group Limited" },
    { 0x595a, "IRTOUCHSYSTEMS Co. Ltd." },
    { 0x5986, "Acer, Inc" },
    { 0x59e3, "Nonolith Labs" },
    { 0x5a57, "Zinwell" },
    { 0x6000, "Beholder International Ltd." },
    { 0x601a, "Ingenic Semiconductor Ltd." },
    { 0x6022, "Xektek" },
    { 0x6189, "Sitecom" },
    { 0x6244, "LightingSoft AG" },
    { 0x6253, "TwinHan Technology Co., Ltd" },
    { 0x636c, "CoreLogic, Inc." },
    { 0x6472, "Sony Corp." },
    { 0x6547, "Arkmicro Technologies Inc." },
    { 0x6557, "Emtec" },
    { 0x6615, "IRTOUCHSYSTEMS Co. Ltd." },
    { 0x6666, "Prototype product Vendor ID" },
    { 0x6677, "WiseGroup, Ltd." },
    { 0x675d, "Humanscale" },
    { 0x6891, "3Com" },
    { 0x695c, "Opera1" },
    { 0x6993, "Yealink Network Technology Co., Ltd." },
    { 0x6a75, "Shanghai Jujo Electronics Co., Ltd" },
    { 0x7104, "CME (Central Music Co.)" },
    { 0x726c, "StackFoundry LLC" },
    { 0x7302, "Solinftec" },
    { 0x734c, "TBS Technologies China" },
    { 0x7373, "Beijing STONE Technology Co. Ltd." },
    { 0x7392, "Edimax Technology Co., Ltd" },
    { 0x73d8, "Progeny Dental Equipment Specialists" },
    { 0x7669, "Venable Instruments" },
    { 0x7825, "Other World Computing" },
    { 0x8070, "ACCES I/O Products, Inc." },
    { 0x8086, "Intel Corp." },
    { 0x8087, "Intel Corp." },
    { 0x80ee, "VirtualBox" },
    { 0x8282, "Keio" },
    { 0x8301, "Hapurs" },
    { 0x8341, "EGO Systems, Inc." },
    { 0x8564, "Transcend Information, Inc." },
    { 0x8644, "Intenso GmbG" },
    { 0x8e06, "CH Products, Inc." },
    { 0x8ea3, "Doosl" },
    { 0x9016, "Sitecom" },
    { 0x9022, "TeVii Technology Ltd." },
    { 0x9148, "GeoLab, Ltd" },
    { 0x9516, "Studiologic" },
    { 0x9710, "MosChip Semiconductor" },
    { 0x9849, "Bestmedia CD Recordable GmbH & Co. KG" },
    { 0x9886, "Astro Gaming" },
    { 0x9999, "Odeon" },
    { 0x99fa, "Grandtec" },
    { 0x9ac4, "J. Westhues" },
    { 0x9e88, "Marvell Semiconductor, Inc." },
    { 0xa014, "Insignia (Best Buy)" },
    { 0xa108, "Ingenic Semiconductor Co.,Ltd" },
    { 0xa128, "AnMo Electronics Corp. / Dino-Lite (?)" },
    { 0xa168, "AnMo Electronics Corporation" },
    { 0xa466, "Haikou Xingong Electronics Co.,Ltd" },
    { 0xa600, "ASIX s.r.o." },
    { 0xa727, "3Com" },
    { 0xa88a, "Clas Ohlsson" },
    { 0xaaaa, "MXT" },
    { 0xab12, "aplic" },
    { 0xabcd, "LogiLink" },
    { 0xb58e, "Blue Microphones" },
    { 0xba77, "Clockmaker" },
    { 0xc216, "Card Device Expert Co., LTD" },
    { 0xc251, "Keil Software, Inc." },
    { 0xc502, "AGPTek" },
    { 0xcace, "CACE Technologies Inc." },
    { 0xcd12, "SMART TECHNOLOGY INDUSTRIAL LTD." },
    { 0xd208, "Ultimarc" },
    { 0xd209, "Ultimarc" },
    { 0xd904, "LogiLink" },
    { 0xe2b7, "Jie Li" },
    { 0xe4e4, "Xorcom Ltd." },
    { 0xeb03, "MakingThings" },
    { 0xeb1a, "eMPIA Technology, Inc." },
    { 0xeb2a, "KWorld" },
    { 0xef18, "SMART TECHNOLOGY INDUSTRIAL LTD." },
    { 0xf003, "Hewlett Packard" },
    { 0xf007, "Teslong" },
    { 0xf182, "Leap Motion" },
    { 0xf3f0, "CCT, Inc" },
    { 0xf4ec, "Atten Electronics / Siglent Technologies" },
    { 0xf4ed, "Shenzhen Siglent Co., Ltd." },
    { 0xf766, "Hama" },
    { 0xfa11, "DyingLight" },
    { 0xfc08, "Conrad Electronic SE" },
    { 0xff00, "Power Delivery" },
    { 0xffee, "FNK Tech" },
    { 0, NULL }
};
value_string_ext ext_usb_vendors_vals = VALUE_STRING_EXT_INIT(usb_vendors_vals);


static const value_string usb_products_vals[] = {
    { 0x00017778, "Counterfeit flash drive [Kingston]" },
    { 0x00020002, "passport00" },
    { 0x00117788, "counterfeit flash drive" },
    { 0x00535301, "GW-US54ZGL 802.11bg" },
    { 0x00780006, "Joystick" },
    { 0x00790006, "PC TWIN SHOCK Gamepad" },
    { 0x00790011, "Gamepad" },
    { 0x00791800, "Mayflash Wii U Pro Game Controller Adapter [DirectInput]" },
    { 0x0079181b, "Venom Arcade Joystick" },
    { 0x00791843, "Mayflash GameCube Controller Adapter" },
    { 0x00791844, "Mayflash GameCube Controller" },
    { 0x0080a001, "JMS578 based SATA bridge" },
    { 0x00850600, "eBook Reader" },
    { 0x0105145f, "NW-3100 802.11b/g 54Mbps Wireless Network Adapter [zd1211]" },
    { 0x01270002, "HDM Interface" },
    { 0x01270127, "ibp" },
    { 0x01450112, "Card Reader" },
    { 0x017c145f, "Trust Deskset" },
    { 0x02000201, "MA180 UMTS Modem" },
    { 0x02046025, "CBM2080 / CBM2090 Flash drive controller" },
    { 0x02046026, "CBM1180 Flash drive controller" },
    { 0x02180301, "MIDI Port" },
    { 0x02ad138c, "PVR Mass Storage" },
    { 0x0324bc06, "OCZ ATV USB 2.0 Flash Drive" },
    { 0x0324bc08, "OCZ Rally2/ATV USB 2.0 Flash Drive" },
    { 0x0325ac02, "ATV Turbo / Rally2 Dual Channel USB 2.0 Flash Drive" },
    { 0x03860001, "PSX for USB Converter" },
    { 0x03d90499, "SE340D PC Remote Control" },
    { 0x03da0002, "HD44780 LCD interface" },
    { 0x03e72150, "Myriad VPU [Movidius Neural Compute Stick]" },
    { 0x03e72485, "Movidius MyriadX" },
    { 0x03e7f63b, "Myriad VPU [Movidius Neural Compute Stick]" },
    { 0x03e80004, "SE401 Webcam" },
    { 0x03e80008, "101 Ethernet [klsi]" },
    { 0x03e80015, "ATAPI Enclosure" },
    { 0x03e82123, "SiPix StyleCam Deluxe" },
    { 0x03e88004, "Aox 99001" },
    { 0x03eb0902, "4-Port Hub" },
    { 0x03eb2002, "Mass Storage Device" },
    { 0x03eb2015, "at90usbkey sample firmware (HID keyboard)" },
    { 0x03eb2018, "at90usbkey sample firmware (CDC ACM)" },
    { 0x03eb2019, "stk525 sample firmware (microphone)" },
    { 0x03eb201c, "at90usbkey sample firmware (HID mouse)" },
    { 0x03eb201d, "at90usbkey sample firmware (HID generic)" },
    { 0x03eb2022, "at90usbkey sample firmware (composite device)" },
    { 0x03eb2040, "LUFA Test PID" },
    { 0x03eb2041, "LUFA Mouse Demo Application" },
    { 0x03eb2042, "LUFA Keyboard Demo Application" },
    { 0x03eb2043, "LUFA Joystick Demo Application" },
    { 0x03eb2044, "LUFA CDC Demo Application" },
    { 0x03eb2045, "LUFA Mass Storage Demo Application" },
    { 0x03eb2046, "LUFA Audio Output Demo Application" },
    { 0x03eb2047, "LUFA Audio Input Demo Application" },
    { 0x03eb2048, "LUFA MIDI Demo Application" },
    { 0x03eb2049, "Stripe Snoop Magnetic Stripe Reader" },
    { 0x03eb204a, "LUFA CDC Class Bootloader" },
    { 0x03eb204b, "LUFA USB to Serial Adapter Project" },
    { 0x03eb204c, "LUFA RNDIS Demo Application" },
    { 0x03eb204d, "LUFA Combined Mouse and Keyboard Demo Application" },
    { 0x03eb204e, "LUFA Dual CDC Demo Application" },
    { 0x03eb204f, "LUFA Generic HID Demo Application" },
    { 0x03eb2060, "Benito Programmer Project" },
    { 0x03eb2061, "LUFA Combined Mass Storage and Keyboard Demo Application" },
    { 0x03eb2062, "LUFA Combined CDC and Mouse Demo Application" },
    { 0x03eb2063, "LUFA Datalogger Device" },
    { 0x03eb2064, "Interfaceless Control-Only LUFA Devices" },
    { 0x03eb2065, "LUFA Test and Measurement Demo Application" },
    { 0x03eb2066, "LUFA Multiple Report HID Demo" },
    { 0x03eb2068, "LUFA Virtual Serial/Mass Storage Demo" },
    { 0x03eb2069, "LUFA Webserver Project" },
    { 0x03eb2103, "JTAG ICE mkII" },
    { 0x03eb2104, "AVR ISP mkII" },
    { 0x03eb2105, "AVRONE!" },
    { 0x03eb2106, "STK600 development board" },
    { 0x03eb2107, "AVR Dragon" },
    { 0x03eb2109, "STK541 ZigBee Development Board" },
    { 0x03eb210a, "AT86RF230 [RZUSBSTICK] transceiver" },
    { 0x03eb210d, "XPLAIN evaluation kit (CDC ACM)" },
    { 0x03eb2110, "AVR JTAGICE3 Debugger and Programmer" },
    { 0x03eb2111, "Xplained Pro board debugger and programmer" },
    { 0x03eb2122, "XMEGA-A1 Explained evaluation kit" },
    { 0x03eb2140, "AVR JTAGICE3 (v3.x) Debugger and Programmer" },
    { 0x03eb2141, "ICE debugger" },
    { 0x03eb2145, "ATMEGA328P-XMINI (CDC ACM)" },
    { 0x03eb2310, "EVK11xx evaluation board" },
    { 0x03eb2404, "The Micro" },
    { 0x03eb2fe4, "ATxmega32A4U DFU bootloader" },
    { 0x03eb2fe6, "Cactus V6 (DFU)" },
    { 0x03eb2fea, "Cactus RF60 (DFU)" },
    { 0x03eb2fee, "atmega8u2 DFU bootloader" },
    { 0x03eb2fef, "atmega16u2 DFU bootloader" },
    { 0x03eb2ff0, "atmega32u2 DFU bootloader" },
    { 0x03eb2ff1, "at32uc3a3 DFU bootloader" },
    { 0x03eb2ff3, "atmega16u4 DFU bootloader" },
    { 0x03eb2ff4, "atmega32u4 DFU bootloader" },
    { 0x03eb2ff6, "at32uc3b0/1 DFU bootloader" },
    { 0x03eb2ff7, "at90usb82 DFU bootloader" },
    { 0x03eb2ff8, "at32uc3a0/1 DFU bootloader" },
    { 0x03eb2ff9, "at90usb646/647 DFU bootloader" },
    { 0x03eb2ffa, "at90usb162 DFU bootloader" },
    { 0x03eb2ffb, "at90usb AVR DFU bootloader" },
    { 0x03eb2ffd, "at89c5130/c5131 DFU bootloader" },
    { 0x03eb2fff, "at89c5132/c51snd1c DFU bootloader" },
    { 0x03eb3301, "at43301 4-Port Hub" },
    { 0x03eb3312, "4-Port Hub" },
    { 0x03eb4102, "AirVast W-Buddie WN210" },
    { 0x03eb5601, "at76c510 Prism-II 802.11b Access Point" },
    { 0x03eb5603, "Cisco 7920 WiFi IP Phone" },
    { 0x03eb6119, "AT91SAM CDC Demo Application" },
    { 0x03eb6124, "at91sam SAMBA bootloader" },
    { 0x03eb6127, "AT91SAM HID Keyboard Demo Application" },
    { 0x03eb6129, "AT91SAM Mass Storage Demo Application" },
    { 0x03eb6200, "AT91SAM HID Mouse Demo Application" },
    { 0x03eb7603, "D-Link DWL-120 802.11b Wireless Adapter [Atmel at76c503a]" },
    { 0x03eb7604, "at76c503a 802.11b Adapter" },
    { 0x03eb7605, "at76c503a 802.11b Adapter" },
    { 0x03eb7606, "at76c505 802.11b Adapter" },
    { 0x03eb7611, "at76c510 rfmd2948 802.11b Access Point" },
    { 0x03eb7613, "WL-1130 USB" },
    { 0x03eb7614, "AT76c505a Wireless Adapter" },
    { 0x03eb7615, "AT76C505AMX Wireless Adapter" },
    { 0x03eb7617, "AT76C505AS Wireless Adapter" },
    { 0x03eb7800, "Mini Album" },
    { 0x03eb800c, "Airspy HF+" },
    { 0x03ebff01, "WootingOne" },
    { 0x03ebff02, "WootingTwo" },
    { 0x03ebff07, "Tux Droid fish dongle" },
    { 0x03ee0000, "CD-R/RW Drive" },
    { 0x03ee2501, "eHome Infrared Receiver" },
    { 0x03ee2502, "eHome Infrared Receiver" },
    { 0x03ee5609, "Japanese Keyboard" },
    { 0x03ee641f, "WIF-0402C Bluetooth Adapter" },
    { 0x03ee6438, "Bluetooth Device" },
    { 0x03ee6440, "WML-C52APR Bluetooth Adapter" },
    { 0x03ee6901, "SmartDisk FDD" },
    { 0x03ee6902, "Floppy Disk Drive" },
    { 0x03ee7500, "CD-R/RW" },
    { 0x03eeffff, "Dongle with BlueCore in DFU mode" },
    { 0x03f00004, "DeskJet 895c" },
    { 0x03f00011, "OfficeJet G55" },
    { 0x03f00012, "DeskJet 1125C Printer Port" },
    { 0x03f00024, "KU-0316 Keyboard" },
    { 0x03f0002a, "LaserJet P1102" },
    { 0x03f00053, "DeskJet 2620 All-in-One Printer" },
    { 0x03f00101, "ScanJet 4100c" },
    { 0x03f00102, "PhotoSmart S20" },
    { 0x03f00104, "DeskJet 880c/970c" },
    { 0x03f00105, "ScanJet 4200c" },
    { 0x03f00107, "CD-Writer Plus" },
    { 0x03f0010c, "Multimedia Keyboard Hub" },
    { 0x03f00111, "G55xi Printer/Scanner/Copier" },
    { 0x03f00117, "LaserJet 3200" },
    { 0x03f0011c, "hn210w 802.11b Adapter" },
    { 0x03f0011d, "Bluetooth 1.2 Interface [Broadcom BCM2035]" },
    { 0x03f00121, "HP 39g+ [F2224A], 39gs [F2223A], 40gs [F2225A], 48gII [F2226A], 49g+ [F2228A], 50g [F2229A, NW240AA]" },
    { 0x03f00122, "HID Internet Keyboard" },
    { 0x03f00125, "DAT72 Tape" },
    { 0x03f00139, "Barcode Scanner 4430" },
    { 0x03f00201, "ScanJet 6200c" },
    { 0x03f00202, "PhotoSmart S20" },
    { 0x03f00204, "DeskJet 815c" },
    { 0x03f00205, "ScanJet 3300c" },
    { 0x03f00207, "CD-Writer Plus 8200e" },
    { 0x03f0020c, "Multimedia Keyboard" },
    { 0x03f00211, "OfficeJet G85" },
    { 0x03f00212, "DeskJet 1220C" },
    { 0x03f00217, "LaserJet 2200" },
    { 0x03f00218, "APOLLO P2500/2600" },
    { 0x03f00221, "StreamSmart 400 [F2235AA]" },
    { 0x03f00223, "Digital Drive Flash Reader" },
    { 0x03f0022a, "Laserjet CP1525nw" },
    { 0x03f00241, "Link-5 micro dongle" },
    { 0x03f00304, "DeskJet 810c/812c" },
    { 0x03f00305, "ScanJet 4300c" },
    { 0x03f00307, "CD-Writer+ CD-4e" },
    { 0x03f00311, "OfficeJet G85xi" },
    { 0x03f00312, "Color Inkjet CP1700" },
    { 0x03f00314, "designjet 30/130 series" },
    { 0x03f00317, "LaserJet 1200" },
    { 0x03f00324, "SK-2885 keyboard" },
    { 0x03f0034a, "Elite Keyboard" },
    { 0x03f00401, "ScanJet 5200c" },
    { 0x03f00404, "DeskJet 830c/832c" },
    { 0x03f00405, "ScanJet 3400cse" },
    { 0x03f00411, "OfficeJet G95" },
    { 0x03f00412, "Printing Support" },
    { 0x03f00417, "LaserJet 1200 series" },
    { 0x03f00423, "HS-COMBO Cardreader" },
    { 0x03f0042a, "LaserJet M1132 MFP" },
    { 0x03f00441, "Prime [NW280AA, G8X92AA]" },
    { 0x03f00504, "DeskJet 885c" },
    { 0x03f00505, "ScanJet 2100c" },
    { 0x03f00507, "DVD+RW" },
    { 0x03f0050c, "5219 Wireless Keyboard" },
    { 0x03f00511, "OfficeJet K60" },
    { 0x03f00512, "DeckJet 450" },
    { 0x03f00517, "LaserJet 1000" },
    { 0x03f0051d, "Bluetooth Interface" },
    { 0x03f0052a, "LaserJet M1212nf MFP" },
    { 0x03f00601, "ScanJet 6300c" },
    { 0x03f00604, "DeskJet 840c" },
    { 0x03f00605, "ScanJet 2200c" },
    { 0x03f00610, "Z24i Monitor Hub" },
    { 0x03f00611, "OfficeJet K60xi" },
    { 0x03f00612, "business inkjet 3000" },
    { 0x03f00624, "Bluetooth Dongle" },
    { 0x03f00641, "X1200 Optical Mouse" },
    { 0x03f00701, "ScanJet 5300c/5370c" },
    { 0x03f00704, "DeskJet 825c" },
    { 0x03f00705, "ScanJet 4400c" },
    { 0x03f0070c, "Personal Media Drive" },
    { 0x03f00711, "OfficeJet K80" },
    { 0x03f00712, "DeskJet 1180c" },
    { 0x03f00714, "Printing Support" },
    { 0x03f00741, "Prime Wireless Kit [FOK65AA]" },
    { 0x03f00801, "ScanJet 7400c" },
    { 0x03f00804, "DeskJet 816c" },
    { 0x03f00805, "HP4470C" },
    { 0x03f00811, "OfficeJet K80xi" },
    { 0x03f00817, "LaserJet 3300" },
    { 0x03f00901, "ScanJet 2300c" },
    { 0x03f00904, "DeskJet 845c" },
    { 0x03f00912, "Printing Support" },
    { 0x03f00917, "LaserJet 3330" },
    { 0x03f00924, "Modular Smartcard Keyboard" },
    { 0x03f00941, "X500 Optical Mouse" },
    { 0x03f0094a, "Optical Mouse [672662-001]" },
    { 0x03f00a01, "ScanJet 2400c" },
    { 0x03f00a17, "color LaserJet 3700" },
    { 0x03f00b01, "ScanJet 82x0C" },
    { 0x03f00b0c, "Wireless Keyboard and Optical Mouse receiver" },
    { 0x03f00b17, "LaserJet 2300d" },
    { 0x03f00c17, "LaserJet 1010" },
    { 0x03f00c24, "Bluetooth Dongle" },
    { 0x03f00d12, "OfficeJet 9100 series" },
    { 0x03f00d17, "LaserJet 1012" },
    { 0x03f00d4a, "SK-2025 Keyboard" },
    { 0x03f00e17, "LaserJet 1015" },
    { 0x03f00f0c, "Wireless Keyboard and Optical Mouse receiver" },
    { 0x03f00f11, "OfficeJet V40" },
    { 0x03f00f12, "Printing Support" },
    { 0x03f00f17, "LaserJet 1150" },
    { 0x03f00f2a, "LaserJet 400 color M451dn" },
    { 0x03f01001, "Photo Scanner 1000" },
    { 0x03f01002, "PhotoSmart 140 series" },
    { 0x03f01004, "DeskJet 970c/970cse" },
    { 0x03f01005, "ScanJet 5400c" },
    { 0x03f01011, "OfficeJet V40xi" },
    { 0x03f01016, "Jornada 548 / iPAQ HW6515 Pocket PC" },
    { 0x03f01017, "LaserJet 1300" },
    { 0x03f01024, "Smart Card Keyboard" },
    { 0x03f01027, "Virtual keyboard and mouse" },
    { 0x03f0102a, "LaserJet Professional P 1102w" },
    { 0x03f01102, "PhotoSmart 240 series" },
    { 0x03f01104, "DeskJet 959c" },
    { 0x03f01105, "ScanJet 5470c/5490c" },
    { 0x03f01111, "OfficeJet v60" },
    { 0x03f01116, "Jornada 568 Pocket PC" },
    { 0x03f01117, "LaserJet 1300n" },
    { 0x03f01151, "PSC-750xi Printer/Scanner/Copier" },
    { 0x03f01198, "HID-compliant mouse" },
    { 0x03f01202, "PhotoSmart 320 series" },
    { 0x03f01204, "DeskJet 930c" },
    { 0x03f01205, "ScanJet 4500C/5550C" },
    { 0x03f01211, "OfficeJet v60xi" },
    { 0x03f01217, "LaserJet 2300L" },
    { 0x03f01227, "Virtual CD-ROM" },
    { 0x03f01302, "PhotoSmart 370 series" },
    { 0x03f01305, "ScanJet 4570c" },
    { 0x03f01311, "OfficeJet V30" },
    { 0x03f01312, "DeskJet 460" },
    { 0x03f01317, "LaserJet 1005" },
    { 0x03f01327, "iLO Virtual Hub" },
    { 0x03f0134a, "Optical Mouse" },
    { 0x03f01405, "ScanJet 3670" },
    { 0x03f01411, "PSC 750" },
    { 0x03f01424, "f2105 Monitor Hub" },
    { 0x03f01502, "PhotoSmart 420 series" },
    { 0x03f01504, "DeskJet 920c" },
    { 0x03f0150c, "Mood Lighting (Microchip Technology Inc.)" },
    { 0x03f01511, "PSC 750xi" },
    { 0x03f01512, "Printing Support" },
    { 0x03f01517, "color LaserJet 3500" },
    { 0x03f01524, "Smart Card Keyboard - KR" },
    { 0x03f01539, "Mini Magnetic Stripe Reader" },
    { 0x03f01541, "Prime [G8X92AA]" },
    { 0x03f0154a, "Laser Mouse" },
    { 0x03f01602, "PhotoSmart 330 series" },
    { 0x03f01604, "DeskJet 940c" },
    { 0x03f01605, "ScanJet 5530C PhotoSmart" },
    { 0x03f01611, "psc 780" },
    { 0x03f01617, "LaserJet 3015" },
    { 0x03f0161d, "Wireless Rechargeable Optical Mouse (HID)" },
    { 0x03f01624, "Smart Card Keyboard - JP" },
    { 0x03f01702, "PhotoSmart 380 series" },
    { 0x03f01704, "DeskJet 948C" },
    { 0x03f01705, "ScanJet 5590" },
    { 0x03f01711, "psc 780xi" },
    { 0x03f01712, "Printing Support" },
    { 0x03f01717, "LaserJet 3020" },
    { 0x03f0171d, "Bluetooth 2.0 Interface [Broadcom BCM2045]" },
    { 0x03f01801, "Inkjet P-2000U" },
    { 0x03f01802, "PhotoSmart 470 series" },
    { 0x03f01804, "DeskJet 916C" },
    { 0x03f01805, "ScanJet 7650" },
    { 0x03f01811, "PSC 720" },
    { 0x03f01812, "OfficeJet Pro K550" },
    { 0x03f01817, "LaserJet 3030" },
    { 0x03f0181d, "Bluetooth 2.0 Interface" },
    { 0x03f01902, "PhotoSmart A430 series" },
    { 0x03f01904, "DeskJet 3820" },
    { 0x03f01911, "OfficeJet V45" },
    { 0x03f01917, "LaserJet 3380" },
    { 0x03f01a02, "PhotoSmart A510 series" },
    { 0x03f01a11, "OfficeJet 5100 series" },
    { 0x03f01a17, "color LaserJet 4650" },
    { 0x03f01b02, "PhotoSmart A610 series" },
    { 0x03f01b04, "DeskJet 3810" },
    { 0x03f01b05, "ScanJet 4850C/4890C" },
    { 0x03f01b07, "Premium Starter Webcam" },
    { 0x03f01c02, "PhotoSmart A710 series" },
    { 0x03f01c17, "Color LaserJet 2550l" },
    { 0x03f01d02, "PhotoSmart A310 series" },
    { 0x03f01d17, "LaserJet 1320" },
    { 0x03f01d24, "Barcode scanner" },
    { 0x03f01e02, "PhotoSmart A320 Printer series" },
    { 0x03f01e11, "PSC-950" },
    { 0x03f01e17, "LaserJet 1160 series" },
    { 0x03f01f02, "PhotoSmart A440 Printer series" },
    { 0x03f01f11, "PSC 920" },
    { 0x03f01f12, "OfficeJet Pro K5300" },
    { 0x03f01f17, "color LaserJet 5550" },
    { 0x03f01f1d, "un2400 Gobi Wireless Modem" },
    { 0x03f02001, "Floppy" },
    { 0x03f02002, "Hub" },
    { 0x03f02004, "DeskJet 640c" },
    { 0x03f02005, "ScanJet 3570c" },
    { 0x03f02012, "OfficeJet Pro K5400" },
    { 0x03f0201d, "un2400 Gobi Wireless Modem (QDL mode)" },
    { 0x03f02039, "Cashdrawer" },
    { 0x03f02102, "PhotoSmart 7345" },
    { 0x03f02104, "DeskJet 630c" },
    { 0x03f02112, "OfficeJet Pro L7500" },
    { 0x03f0211d, "Sierra MC5725 [ev2210]" },
    { 0x03f02202, "PhotoSmart 7600 series" },
    { 0x03f02205, "ScanJet 3500c" },
    { 0x03f02212, "OfficeJet Pro L7600" },
    { 0x03f02217, "color LaserJet 9500 MFP" },
    { 0x03f0222a, "LaserJet Pro MFP M125nw" },
    { 0x03f02302, "PhotoSmart 7600 series" },
    { 0x03f02304, "DeskJet 656c" },
    { 0x03f02305, "ScanJet 3970c" },
    { 0x03f02311, "OfficeJet d series" },
    { 0x03f02312, "OfficeJet Pro L7700" },
    { 0x03f02317, "LaserJet 4350" },
    { 0x03f0231d, "Broadcom 2070 Bluetooth Combo" },
    { 0x03f02402, "PhotoSmart 7700 series" },
    { 0x03f02404, "Deskjet F2280 series" },
    { 0x03f02405, "ScanJet 4070 PhotoSmart" },
    { 0x03f02417, "LaserJet 4250" },
    { 0x03f0241d, "Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x03f02424, "LP1965 19\" Monitor Hub" },
    { 0x03f02441, "Prime G2 [2AP18AA]" },
    { 0x03f02502, "PhotoSmart 7700 series" },
    { 0x03f02504, "DeskJet F4200 series" },
    { 0x03f02505, "ScanJet 3770" },
    { 0x03f02512, "OfficeJet Pro L7300 / Compaq LA2405 series monitor" },
    { 0x03f02514, "4-port hub" },
    { 0x03f02517, "LaserJet 2410" },
    { 0x03f0251d, "Gobi 2000 Wireless Modem" },
    { 0x03f02524, "LP3065 30\" Monitor Hub" },
    { 0x03f02602, "PhotoSmart A520 series" },
    { 0x03f02605, "ScanJet 3800c" },
    { 0x03f02611, "OfficeJet 7100 series" },
    { 0x03f02617, "Color LaserJet 2820 series" },
    { 0x03f02624, "Pole Display (HP522 2 x 20 Line Display)" },
    { 0x03f02702, "PhotoSmart A620 series" },
    { 0x03f02704, "DeskJet 915" },
    { 0x03f02717, "Color LaserJet 2830" },
    { 0x03f02724, "Magnetic Stripe Reader IDRA-334133-HP" },
    { 0x03f02805, "Scanjet G2710" },
    { 0x03f02811, "PSC-2100" },
    { 0x03f02817, "Color LaserJet 2840" },
    { 0x03f02902, "PhotoSmart A820 series" },
    { 0x03f02911, "PSC 2200" },
    { 0x03f02917, "LaserJet 2420" },
    { 0x03f02a11, "PSC 2150 series" },
    { 0x03f02a17, "LaserJet 2430" },
    { 0x03f02a1d, "Integrated Module with Bluetooth 2.1 Wireless technology" },
    { 0x03f02b11, "PSC 2170 series" },
    { 0x03f02b17, "LaserJet 1020" },
    { 0x03f02b4a, "Business Slim Keyboard" },
    { 0x03f02c12, "Officejet J4680" },
    { 0x03f02c17, "LaserJet 1022" },
    { 0x03f02c24, "Logitech M-UAL-96 Mouse" },
    { 0x03f02d05, "Scanjet 7000" },
    { 0x03f02d11, "OfficeJet 6110" },
    { 0x03f02d17, "Printing Support" },
    { 0x03f02e11, "PSC 1000" },
    { 0x03f02e17, "LaserJet 2600n" },
    { 0x03f02e24, "LP2275w Monitor Hub" },
    { 0x03f02f11, "PSC 1200" },
    { 0x03f02f17, "Color LaserJet 2605dn" },
    { 0x03f02f24, "LP2475w Monitor Hub" },
    { 0x03f03002, "PhotoSmart P1000" },
    { 0x03f03004, "DeskJet 980c" },
    { 0x03f03005, "ScanJet 4670v" },
    { 0x03f03011, "PSC 1100 series" },
    { 0x03f03017, "Printing Support" },
    { 0x03f0304a, "Slim Keyboard" },
    { 0x03f03102, "PhotoSmart P1100 Printer w/ Card Reader" },
    { 0x03f03104, "DeskJet 960c" },
    { 0x03f03111, "OfficeJet 4100 series" },
    { 0x03f03117, "EWS 2605dtn" },
    { 0x03f0311d, "Atheros AR9285 Malbec Bluetooth Adapter" },
    { 0x03f0312a, "LaserJet Pro M701n" },
    { 0x03f03202, "PhotoSmart 1215" },
    { 0x03f03207, "4 GB flash drive" },
    { 0x03f03211, "OfficeJet 4105 series" },
    { 0x03f03217, "LaserJet 3050" },
    { 0x03f03302, "PhotoSmart 1218" },
    { 0x03f03304, "DeskJet 990c" },
    { 0x03f03307, "v125w Stick" },
    { 0x03f03312, "OfficeJet J6410" },
    { 0x03f03317, "LaserJet 3052" },
    { 0x03f03402, "PhotoSmart 1115" },
    { 0x03f03404, "DeskJet 6122" },
    { 0x03f03417, "LaserJet 3055" },
    { 0x03f03502, "PhotoSmart 230" },
    { 0x03f03504, "DeskJet 6127c" },
    { 0x03f03511, "PSC 2300" },
    { 0x03f03517, "LaserJet 3390" },
    { 0x03f0354a, "Slim Keyboard" },
    { 0x03f03602, "PhotoSmart 1315" },
    { 0x03f03611, "PSC 2410 PhotoSmart" },
    { 0x03f03612, "Officejet Pro 8000 A809" },
    { 0x03f03617, "Color LaserJet 2605" },
    { 0x03f03711, "PSC 2500" },
    { 0x03f03717, "EWS UPD" },
    { 0x03f03724, "Webcam" },
    { 0x03f03802, "PhotoSmart 100" },
    { 0x03f03807, "c485w Flash Drive" },
    { 0x03f03817, "LaserJet P2015 series" },
    { 0x03f03902, "PhotoSmart 130" },
    { 0x03f03912, "Officejet Pro 8500" },
    { 0x03f03917, "LaserJet P2014" },
    { 0x03f03a02, "PhotoSmart 7150" },
    { 0x03f03a11, "OfficeJet 5500 series" },
    { 0x03f03a17, "Printing Support" },
    { 0x03f03a1d, "hs2340 HSPA+ mobile broadband" },
    { 0x03f03b02, "PhotoSmart 7150~" },
    { 0x03f03b05, "Scanjet N8460" },
    { 0x03f03b11, "PSC 1300 series" },
    { 0x03f03b17, "LaserJet M1005 MFP" },
    { 0x03f03b2a, "Color LaserJet MFP M277dw" },
    { 0x03f03c02, "PhotoSmart 7350" },
    { 0x03f03c05, "Scanjet Professional 1000 Mobile Scanner" },
    { 0x03f03c11, "PSC 1358" },
    { 0x03f03c17, "EWS UPD" },
    { 0x03f03d02, "PhotoSmart 7350~" },
    { 0x03f03d11, "OfficeJet 4215" },
    { 0x03f03d17, "LaserJet P1005" },
    { 0x03f03e02, "PhotoSmart 7550" },
    { 0x03f03e17, "LaserJet P1006" },
    { 0x03f03f02, "PhotoSmart 7550~" },
    { 0x03f03f11, "PSC-1315/PSC-1317" },
    { 0x03f03f17, "Laserjet P1505" },
    { 0x03f04002, "HP PhotoSmart ..." },
    { 0x03f04004, "CP1160" },
    { 0x03f04102, "PhotoSmart 618" },
    { 0x03f04105, "ScanJet 4370" },
    { 0x03f04111, "OfficeJet 7200 series" },
    { 0x03f04117, "LaserJet 1018" },
    { 0x03f04202, "HP PhotoSmart 812" },
    { 0x03f04205, "ScanJet G3010" },
    { 0x03f04211, "OfficeJet 7300 series" },
    { 0x03f04217, "EWS CM1015" },
    { 0x03f04302, "HP PhotoSmart 850" },
    { 0x03f04305, "ScanJet G3110" },
    { 0x03f04311, "OfficeJet 7400 series" },
    { 0x03f04317, "Color LaserJet CM1017" },
    { 0x03f04402, "HP PhotoSmart 935" },
    { 0x03f04417, "EWS UPD" },
    { 0x03f04502, "HP PhotoSmart 945" },
    { 0x03f04505, "ScanJet G4010" },
    { 0x03f04507, "External HDD" },
    { 0x03f04511, "PhotoSmart 2600" },
    { 0x03f04512, "E709n [Officejet 6500 Wireless]" },
    { 0x03f04517, "EWS UPD" },
    { 0x03f04605, "ScanJet G4050" },
    { 0x03f04611, "PhotoSmart 2700" },
    { 0x03f04717, "Color LaserJet CP1215" },
    { 0x03f04811, "PSC 1600" },
    { 0x03f04911, "PSC 2350" },
    { 0x03f04b11, "OfficeJet 6200" },
    { 0x03f04c11, "PSC 1500 series" },
    { 0x03f04c17, "EWS UPD" },
    { 0x03f04d11, "PSC 1400" },
    { 0x03f04d17, "EWS UPD" },
    { 0x03f04e11, "PhotoSmart 2570 series" },
    { 0x03f04f11, "OfficeJet 5600 (USBHUB)" },
    { 0x03f04f17, "Color LaserJet CM1312 MFP" },
    { 0x03f05004, "DeskJet 995c" },
    { 0x03f05011, "PhotoSmart 3100 series" },
    { 0x03f05017, "EWS UPD" },
    { 0x03f05111, "PhotoSmart 3200 series" },
    { 0x03f05211, "PhotoSmart 3300 series" },
    { 0x03f05307, "v165w Stick" },
    { 0x03f05311, "OfficeJet 6300" },
    { 0x03f05312, "Officejet Pro 8500A" },
    { 0x03f05317, "Color LaserJet CP2025 series" },
    { 0x03f05411, "OfficeJet 4300" },
    { 0x03f05511, "DeskJet F300 series" },
    { 0x03f05611, "PhotoSmart C3180" },
    { 0x03f05617, "LaserJet M1120 MFP" },
    { 0x03f05711, "PhotoSmart C4100 series" },
    { 0x03f05717, "LaserJet M1120n MFP" },
    { 0x03f05811, "PhotoSmart C5100 series" },
    { 0x03f05817, "LaserJet M1319f MFP" },
    { 0x03f0581d, "lt4112 Gobi 4G Module Network Device" },
    { 0x03f05911, "PhotoSmart C6180" },
    { 0x03f05912, "Officejet Pro 8600" },
    { 0x03f05a11, "PhotoSmart C7100 series" },
    { 0x03f05b11, "OfficeJet J2100 series" },
    { 0x03f05b12, "Officejet Pro 8100" },
    { 0x03f05c11, "PhotoSmart C4200 Printer series" },
    { 0x03f05c12, "OfficeJet 6700" },
    { 0x03f05c17, "LaserJet P2055 series" },
    { 0x03f05d11, "PhotoSmart C5200 series" },
    { 0x03f05e11, "PhotoSmart D7400 series" },
    { 0x03f06002, "HP PhotoSmart C500" },
    { 0x03f06004, "DeskJet 5550" },
    { 0x03f06102, "Hewlett Packard Digital Camera" },
    { 0x03f06104, "DeskJet 5650c" },
    { 0x03f06117, "color LaserJet 3550" },
    { 0x03f06202, "PhotoSmart 215" },
    { 0x03f06204, "DeskJet 5150c" },
    { 0x03f06217, "Color LaserJet 4700" },
    { 0x03f06302, "HP PhotoSmart 612" },
    { 0x03f06317, "Color LaserJet 4730mfp" },
    { 0x03f06402, "HP PhotoSmart 715" },
    { 0x03f06411, "PhotoSmart C8100 series" },
    { 0x03f06417, "LaserJet 5200" },
    { 0x03f06502, "HP PhotoSmart 120" },
    { 0x03f06511, "PhotoSmart C7200 series" },
    { 0x03f06602, "HP PhotoSmart 320" },
    { 0x03f06611, "PhotoSmart C4380 series" },
    { 0x03f06617, "LaserJet 5200L" },
    { 0x03f06702, "HP PhotoSmart 720" },
    { 0x03f06717, "Color LaserJet 3000" },
    { 0x03f06802, "HP PhotoSmart 620" },
    { 0x03f06811, "PhotoSmart D5300 series" },
    { 0x03f06817, "Color LaserJet 3800" },
    { 0x03f06911, "PhotoSmart D7200 series" },
    { 0x03f06917, "Color LaserJet 3600" },
    { 0x03f06a02, "HP PhotoSmart 735" },
    { 0x03f06a11, "PhotoSmart C6200 series" },
    { 0x03f06a17, "LaserJet 4240" },
    { 0x03f06b02, "HP PhotoSmart 707" },
    { 0x03f06b11, "Photosmart C4500 series" },
    { 0x03f06c02, "HP PhotoSmart 733" },
    { 0x03f06c11, "Photosmart C4480" },
    { 0x03f06c17, "Color LaserJet 4610" },
    { 0x03f06d02, "HP PhotoSmart 607" },
    { 0x03f06e02, "HP PhotoSmart 507" },
    { 0x03f06f17, "Color LaserJet CP6015 series" },
    { 0x03f07004, "DeskJet 3320c" },
    { 0x03f07102, "HP PhotoSmart 635" },
    { 0x03f07104, "DeskJet 3420c" },
    { 0x03f07117, "CM8060 Color MFP with Edgeline Technology" },
    { 0x03f07202, "HP PhotoSmart 43x" },
    { 0x03f07204, "DeskJet 36xx" },
    { 0x03f07217, "LaserJet M5035 MFP" },
    { 0x03f07302, "HP PhotoSmart M307" },
    { 0x03f07304, "DeskJet 35xx" },
    { 0x03f07311, "Photosmart Premium C309" },
    { 0x03f07317, "LaserJet P3005" },
    { 0x03f07402, "HP PhotoSmart 407" },
    { 0x03f07404, "Printing Support" },
    { 0x03f07417, "LaserJet M4345 MFP" },
    { 0x03f07502, "HP PhotoSmart M22" },
    { 0x03f07504, "Printing Support" },
    { 0x03f07517, "LaserJet M3035 MFP" },
    { 0x03f07602, "HP PhotoSmart 717" },
    { 0x03f07604, "DeskJet 3940" },
    { 0x03f07611, "DeskJet F2492 All-in-One" },
    { 0x03f07617, "LaserJet P3004" },
    { 0x03f07702, "HP PhotoSmart 817" },
    { 0x03f07704, "DeskJet D4100" },
    { 0x03f07717, "CM8050 Color MFP with Edgeline Technology" },
    { 0x03f07802, "HP PhotoSmart 417" },
    { 0x03f07804, "DeskJet D1360" },
    { 0x03f07817, "Color LaserJet CP3505" },
    { 0x03f07902, "HP PhotoSmart 517" },
    { 0x03f07917, "LaserJet M5025 MFP" },
    { 0x03f07a02, "HP PhotoSmart M415" },
    { 0x03f07a04, "DeskJet D2460" },
    { 0x03f07a11, "Photosmart B109" },
    { 0x03f07a17, "LaserJet M3027 MFP" },
    { 0x03f07b02, "HP PhotoSmart M23" },
    { 0x03f07b17, "Color LaserJet CP4005" },
    { 0x03f07c02, "HP PhotoSmart 217" },
    { 0x03f07c17, "Color LaserJet CM6040 series" },
    { 0x03f07d02, "HP PhotoSmart 317" },
    { 0x03f07d04, "DeskJet F2100 Printer series" },
    { 0x03f07d17, "Color LaserJet CM4730 MFP" },
    { 0x03f07e02, "HP PhotoSmart 818" },
    { 0x03f07e04, "DeskJet F4100 Printer series" },
    { 0x03f08002, "HP PhotoSmart M425" },
    { 0x03f08017, "LaserJet P4515" },
    { 0x03f08102, "HP PhotoSmart M525" },
    { 0x03f08104, "Printing Support" },
    { 0x03f08117, "LaserJet P4015" },
    { 0x03f0811c, "Ethernet HN210E" },
    { 0x03f08202, "HP PhotoSmart M527" },
    { 0x03f08204, "Printing Support" },
    { 0x03f08207, "FHA-3510 2.4GHz Wireless Optical Mobile Mouse" },
    { 0x03f08217, "LaserJet P4014" },
    { 0x03f08317, "LaserJet M9050 MFP" },
    { 0x03f08402, "HP PhotoSmart M725" },
    { 0x03f08404, "DeskJet 6800 series" },
    { 0x03f08417, "LaserJet M9040 MFP" },
    { 0x03f08502, "HP PhotoSmart M727" },
    { 0x03f08504, "DeskJet 6600 series" },
    { 0x03f08604, "DeskJet 5440" },
    { 0x03f08607, "Optical Mobile Mouse" },
    { 0x03f08702, "HP PhotoSmart R927" },
    { 0x03f08704, "DeskJet 5940" },
    { 0x03f08711, "Deskjet 2050 J510" },
    { 0x03f08802, "HP PhotoSmart R967" },
    { 0x03f08804, "DeskJet 6980 series" },
    { 0x03f08904, "DeskJet 6940 series" },
    { 0x03f08911, "Deskjet 1050 J410" },
    { 0x03f08b02, "HP PhotoSmart E327" },
    { 0x03f08c02, "HP PhotoSmart E427" },
    { 0x03f08c07, "Digital Stereo Headset" },
    { 0x03f08c11, "Deskjet F4500 series" },
    { 0x03f09002, "PhotoSmart M437" },
    { 0x03f09102, "PhotoSmart M537" },
    { 0x03f09207, "HD-4110 Webcam" },
    { 0x03f09302, "PhotoSmart R930 series" },
    { 0x03f09402, "PhotoSmart R837" },
    { 0x03f0942a, "LaserJet Pro M12a" },
    { 0x03f09502, "PhotoSmart R840 series" },
    { 0x03f0952a, "LaserJet Pro M12w" },
    { 0x03f09602, "HP PhotoSmart M737" },
    { 0x03f09702, "HP PhotoSmart R742" },
    { 0x03f09802, "PhotoSmart Mz60 series" },
    { 0x03f09902, "PhotoSmart M630 series" },
    { 0x03f09a02, "PhotoSmart E330 series" },
    { 0x03f09b02, "HP PhotoSmart M547" },
    { 0x03f09b07, "Portable Drive" },
    { 0x03f09c02, "PhotoSmart M440 series" },
    { 0x03f0a004, "DeskJet 5850c" },
    { 0x03f0a011, "Deskjet 3050A" },
    { 0x03f0a407, "Wireless Optical Comfort Mouse" },
    { 0x03f0b002, "PhotoSmart 7200 series" },
    { 0x03f0b102, "PhotoSmart 7200 series" },
    { 0x03f0b107, "v255w/c310w Flash Drive" },
    { 0x03f0b116, "Webcam" },
    { 0x03f0b202, "PhotoSmart 7600 series" },
    { 0x03f0b302, "PhotoSmart 7600 series" },
    { 0x03f0b402, "PhotoSmart 7700 series" },
    { 0x03f0b502, "PhotoSmart 7700 series" },
    { 0x03f0b602, "PhotoSmart 7900 series" },
    { 0x03f0b702, "PhotoSmart 7900 series" },
    { 0x03f0b802, "PhotoSmart 7400 series" },
    { 0x03f0b902, "PhotoSmart 7800 series" },
    { 0x03f0ba02, "PhotoSmart 8100 series" },
    { 0x03f0bb02, "PhotoSmart 8400 series" },
    { 0x03f0bc02, "PhotoSmart 8700 series" },
    { 0x03f0bd02, "PhotoSmart Pro B9100 series" },
    { 0x03f0bef4, "NEC Picty760" },
    { 0x03f0c002, "PhotoSmart 7800 series" },
    { 0x03f0c102, "PhotoSmart 8000 series" },
    { 0x03f0c111, "Deskjet 1510" },
    { 0x03f0c202, "PhotoSmart 8200 series" },
    { 0x03f0c211, "Deskjet 2540 series" },
    { 0x03f0c302, "DeskJet D2300" },
    { 0x03f0c402, "PhotoSmart D5100 series" },
    { 0x03f0c502, "PhotoSmart D6100 series" },
    { 0x03f0c602, "PhotoSmart D7100 series" },
    { 0x03f0c702, "PhotoSmart D7300 series" },
    { 0x03f0c802, "PhotoSmart D5060 Printer" },
    { 0x03f0d104, "Bluetooth Dongle" },
    { 0x03f0d507, "39gII [NW249AA]" },
    { 0x03f0efbe, "NEC Picty900" },
    { 0x03f0f0be, "NEC Picty920" },
    { 0x03f0f1be, "NEC Picty800" },
    { 0x03f30020, "AWN-8020 WLAN [Intersil PRISM 2.5]" },
    { 0x03f30080, "AVC-1100 Audio Capture" },
    { 0x03f30083, "AVC-2200 Device" },
    { 0x03f30087, "AVC-2210 Loader" },
    { 0x03f30088, "AVC-2210 Device" },
    { 0x03f3008b, "AVC-2310 Loader" },
    { 0x03f3008c, "AVC-2310 Device" },
    { 0x03f30094, "eHome Infrared Receiver" },
    { 0x03f3009b, "AVC-1410 GameBridge TV NTSC" },
    { 0x03f32000, "USBXchange" },
    { 0x03f32001, "USBXchange Adapter" },
    { 0x03f32002, "USB2-Xchange" },
    { 0x03f32003, "USB2-Xchange Adapter" },
    { 0x03f34000, "4-port hub" },
    { 0x03f3adcc, "Composite Device Support" },
    { 0x03f90100, "KT-2001 Keyboard" },
    { 0x03f90101, "Keyboard" },
    { 0x03f90102, "Keyboard Mouse" },
    { 0x03fd0008, "Platform Cable USB II" },
    { 0x03fd0050, "dfu downloader" },
    { 0x040005dc, "Rigol Technologies DS1000USB Oscilloscope" },
    { 0x04000807, "Bluetooth Dongle" },
    { 0x0400080a, "Bluetooth Device" },
    { 0x040009c4, "Rigol Technologies DG1022 Arbitrary Waveform Generator" },
    { 0x04001000, "Mustek BearPaw 1200 Scanner" },
    { 0x04001001, "Mustek BearPaw 2400 Scanner" },
    { 0x04001237, "Hub" },
    { 0x0400a000, "Smart Display Reference Device" },
    { 0x0400c359, "Logitech Harmony" },
    { 0x0400c35b, "Printing Support" },
    { 0x0400c55d, "Rigol Technologies DS5000USB Oscilloscope" },
    { 0x04020611, "TrekStor i.Beat Sweez FM" },
    { 0x04025462, "M5462 IDE Controller" },
    { 0x04025602, "M5602 Video Camera Controller" },
    { 0x04025603, "M5603 Video Camera Controller" },
    { 0x04025606, "M5606 Video Camera Controller [UVC]" },
    { 0x04025621, "M5621 High-Speed IDE Controller" },
    { 0x04025623, "M5623 Scanner Controller" },
    { 0x04025627, "Welland ME-740PS USB2 3.5\" Power Saving Enclosure" },
    { 0x04025632, "M5632 Host-to-Host Link" },
    { 0x04025635, "M5635 Flash Card Reader" },
    { 0x04025636, "USB 2.0 Storage Device" },
    { 0x04025637, "M5637 IDE Controller" },
    { 0x04025642, "Storage Device" },
    { 0x04025661, "M5661 MP3 player" },
    { 0x04025667, "M5667 MP3 player" },
    { 0x04025668, "Nextar MA715A-8R" },
    { 0x04029665, "Gateway Webcam" },
    { 0x04030000, "H4SMK 7 Port Hub / Bricked Counterfeit FT232 Serial (UART) IC" },
    { 0x04030232, "Serial Converter" },
    { 0x04031060, "JTAG adapter" },
    { 0x04031234, "IronLogic RFID Adapter [Z-2 USB]" },
    { 0x04031235, "Iron Logic Z-397 RS-485/422 converter" },
    { 0x04036001, "FT232 Serial (UART) IC" },
    { 0x04036002, "Lumel PD12" },
    { 0x04036007, "Serial Converter" },
    { 0x04036008, "Serial Converter" },
    { 0x04036009, "Serial Converter" },
    { 0x04036010, "FT2232C/D/H Dual UART/FIFO IC" },
    { 0x04036011, "FT4232H Quad HS USB-UART/FIFO IC" },
    { 0x04036014, "FT232H Single HS USB-UART/FIFO IC" },
    { 0x04036015, "Bridge(I2C/SPI/UART/FIFO)" },
    { 0x0403601f, "Myriad-RF LimeSDR-Mini" },
    { 0x04036f70, "HB-RF-USB" },
    { 0x04038028, "Dev board JTAG (FT232H based)" },
    { 0x04038040, "4 Port Hub" },
    { 0x04038070, "7 Port Hub" },
    { 0x04038140, "Vehicle Explorer Interface" },
    { 0x04038210, "MGTimer - MGCC (Vic) Timing System" },
    { 0x04038348, "FT232BM [SIENNA Serial Interface]" },
    { 0x04038370, "7 Port Hub" },
    { 0x04038371, "PS/2 Keyboard And Mouse" },
    { 0x04038372, "FT8U100AX Serial Port" },
    { 0x04038508, "Selectronic SP PRO" },
    { 0x040387d0, "Cressi Dive Computer Interface" },
    { 0x04038a28, "Rainforest Automation ZigBee Controller" },
    { 0x04038a98, "TIAO Multi-Protocol Adapter" },
    { 0x04038b28, "Alpermann+Velte TCI70" },
    { 0x04038b29, "Alpermann+Velte TC60 CLS" },
    { 0x04038b2a, "Alpermann+Velte Rubidium Q1" },
    { 0x04038b2b, "Alpermann+Velte TCD" },
    { 0x04038b2c, "Alpermann+Velte TCC70" },
    { 0x04039090, "SNAP Stick 200" },
    { 0x04039132, "LCD and Temperature Interface" },
    { 0x04039133, "CallerID" },
    { 0x04039135, "Rotary Pub alarm" },
    { 0x04039136, "Pulsecounter" },
    { 0x04039e90, "Marvell OpenRD Base/Client" },
    { 0x04039f08, "CIB-1894 Conclusion SmartLink Box:" },
    { 0x04039f80, "Ewert Energy Systems CANdapter" },
    { 0x0403a6d0, "Texas Instruments XDS100v2 JTAG / BeagleBone A3" },
    { 0x0403a951, "HCP HIT GSM/GPRS modem [Cinterion MC55i]" },
    { 0x0403a9a0, "FT2232D - Dual UART/FIFO IC - FTDI" },
    { 0x0403abb8, "Lego Mindstorms NXTCam" },
    { 0x0403b0c0, "microSensys RFID device" },
    { 0x0403b0c1, "microSensys RFID device" },
    { 0x0403b0c2, "iID contactless RFID device" },
    { 0x0403b0c3, "iID contactless RFID device" },
    { 0x0403b0c4, "RFID device" },
    { 0x0403b0c5, "RFID device" },
    { 0x0403b810, "US Interface Navigator (CAT and 2nd PTT lines)" },
    { 0x0403b811, "US Interface Navigator (WKEY and FSK lines)" },
    { 0x0403b812, "US Interface Navigator (RS232 and CONFIG lines)" },
    { 0x0403b9b0, "Fujitsu SK-16FX-100PMC V1.1" },
    { 0x0403baf8, "Amontec JTAGkey" },
    { 0x0403bcd8, "Stellaris Development Board" },
    { 0x0403bcd9, "Stellaris Evaluation Board" },
    { 0x0403bcda, "Stellaris ICDI Board" },
    { 0x0403bd90, "PICAXE Download Cable [AXE027]" },
    { 0x0403bdc8, "Egnite GmbH - JTAG/RS-232 adapter" },
    { 0x0403bfd8, "OpenDCC" },
    { 0x0403bfd9, "OpenDCC (Sniffer)" },
    { 0x0403bfda, "OpenDCC (Throttle)" },
    { 0x0403bfdb, "OpenDCC (Gateway)" },
    { 0x0403bfdc, "OpenDCC (GBM)" },
    { 0x0403c580, "HID UNIKEY dongle [F-Response]" },
    { 0x0403c630, "lcd2usb interface" },
    { 0x0403c631, "i2c-tiny-usb interface" },
    { 0x0403c632, "xu1541 c64 floppy drive interface" },
    { 0x0403c633, "TinyCrypt dongle" },
    { 0x0403c634, "glcd2usb interface" },
    { 0x0403c7d0, "RR-CirKits LocoBuffer-USB" },
    { 0x0403c8b8, "Alpermann+Velte MTD TCU" },
    { 0x0403c8b9, "Alpermann+Velte MTD TCU 1HE" },
    { 0x0403c8ba, "Alpermann+Velte Rubidium H1" },
    { 0x0403c8bb, "Alpermann+Velte Rubidium H3" },
    { 0x0403c8bc, "Alpermann+Velte Rubidium S1" },
    { 0x0403c8bd, "Alpermann+Velte Rubidium T1" },
    { 0x0403c8be, "Alpermann+Velte Rubidium D1" },
    { 0x0403c8bf, "Alpermann+Velte TC60 RLV" },
    { 0x0403cc48, "Tactrix OpenPort 1.3 Mitsubishi" },
    { 0x0403cc49, "Tactrix OpenPort 1.3 Subaru" },
    { 0x0403cc4a, "Tactrix OpenPort 1.3 Universal" },
    { 0x0403cff8, "Amontec JTAGkey" },
    { 0x0403d010, "SCS PTC-IIusb" },
    { 0x0403d011, "SCS Position-Tracker/TNC" },
    { 0x0403d012, "SCS DRAGON 1" },
    { 0x0403d013, "SCS DRAGON 1" },
    { 0x0403d388, "Xsens converter" },
    { 0x0403d389, "Xsens Wireless Receiver" },
    { 0x0403d38a, "Xsens serial converter" },
    { 0x0403d38b, "Xsens serial converter" },
    { 0x0403d38c, "Xsens Wireless Receiver" },
    { 0x0403d38d, "Xsens Awinda Station" },
    { 0x0403d38e, "Xsens serial converter" },
    { 0x0403d38f, "Xsens serial converter" },
    { 0x0403d491, "Zolix Omni 1509 monochromator" },
    { 0x0403d578, "Accesio USB-COM-4SM" },
    { 0x0403d6f8, "UNI Black BOX" },
    { 0x0403d738, "Propox JTAGcable II" },
    { 0x0403d739, "Propox ISPcable III" },
    { 0x0403d9a9, "Actisense USG-1 NMEA Serial Gateway" },
    { 0x0403d9aa, "Actisense NGT-1 NMEA2000 PC Interface" },
    { 0x0403d9ab, "Actisense NGT-1 NMEA2000 Gateway" },
    { 0x0403daf4, "Qundis Serial Infrared Head" },
    { 0x0403e0d0, "Total Phase Aardvark I2C/SPI Host Adapter" },
    { 0x0403e521, "EVER Sinline XL Series UPS" },
    { 0x0403e6c8, "PYRAMID Computer GmbH LCD" },
    { 0x0403e700, "Elster Unicom III Optical Probe" },
    { 0x0403e729, "Segway Robotic Mobility Platforms 200" },
    { 0x0403e888, "Expert ISDN Control USB" },
    { 0x0403e889, "USB-RS232 OptoBridge" },
    { 0x0403e88a, "Expert mouseCLOCK USB II" },
    { 0x0403e88b, "Precision Clock MSF USB" },
    { 0x0403e88c, "Expert mouseCLOCK USB II HBG" },
    { 0x0403e8d8, "Aaronia AG Spectran Spectrum Analyzer" },
    { 0x0403e8dc, "Aaronia AG UBBV Preamplifier" },
    { 0x0403ea90, "Eclo 1-Wire Adapter" },
    { 0x0403ecd9, "miControl miCan-Stick" },
    { 0x0403ed71, "HAMEG HO870 Serial Port" },
    { 0x0403ed72, "HAMEG HO720 Serial Port" },
    { 0x0403ed73, "HAMEG HO730 Serial Port" },
    { 0x0403ed74, "HAMEG HO820 Serial Port" },
    { 0x0403ef10, "FT1245BL" },
    { 0x0403f070, "Serial Converter 422/485 [Vardaan VEUSB422R3]" },
    { 0x0403f0c8, "SPROG Decoder Programmer" },
    { 0x0403f0c9, "SPROG-DCC CAN-USB" },
    { 0x0403f0e9, "Tagsys L-P101" },
    { 0x0403f0ee, "Tagsys Medio P200x" },
    { 0x0403f1a0, "Asix PRESTO Programmer" },
    { 0x0403f208, "Papenmeier Braille-Display" },
    { 0x0403f3c0, "4N-GALAXY Serial Converter" },
    { 0x0403f458, "ABACUS ELECTRICS Optical Probe" },
    { 0x0403f608, "CTI USB-485-Mini" },
    { 0x0403f60b, "CTI USB-Nano-485" },
    { 0x0403f680, "Suunto Sports Instrument" },
    { 0x0403f758, "GW Instek GDS-8x0 Oscilloscope" },
    { 0x0403f7c0, "ZeitControl Cardsystems TagTracer MIFARE" },
    { 0x0403f850, "USB-UIRT (Universal Infrared Receiver+Transmitter)" },
    { 0x0403f918, "Ant8 Logic Probe" },
    { 0x0403fa00, "Matrix Orbital USB Serial" },
    { 0x0403fa01, "Matrix Orbital MX2 or MX3" },
    { 0x0403fa02, "Matrix Orbital MX4 or MX5" },
    { 0x0403fa03, "Matrix Orbital VK/LK202 Family" },
    { 0x0403fa04, "Matrix Orbital VK/LK204 Family" },
    { 0x0403fa20, "Ross-Tech HEX-USB" },
    { 0x0403fc08, "Crystalfontz CFA-632 USB LCD" },
    { 0x0403fc09, "Crystalfontz CFA-634 USB LCD" },
    { 0x0403fc0b, "Crystalfontz CFA-633 USB LCD" },
    { 0x0403fc0c, "Crystalfontz CFA-631 USB LCD" },
    { 0x0403fc0d, "Crystalfontz CFA-635 USB LCD" },
    { 0x0403fc82, "SEMC DSS-20/DSS-25 SyncStation" },
    { 0x0403fd48, "ShipModul MiniPlex-4xUSB NMEA Multiplexer" },
    { 0x0403fd49, "ShipModul MiniPlex-4xUSB-AIS NMEA Multiplexer" },
    { 0x0403fd4b, "ShipModul MiniPlex NMEA Multiplexer" },
    { 0x0403ff08, "ToolHouse LoopBack Adapter" },
    { 0x0403ff18, "ScienceScope Logbook ML" },
    { 0x0403ff19, "Logbook Bus" },
    { 0x0403ff1a, "Logbook Bus" },
    { 0x0403ff1b, "Logbook Bus" },
    { 0x0403ff1c, "ScienceScope Logbook LS" },
    { 0x0403ff1d, "ScienceScope Logbook HS" },
    { 0x0403ff1e, "Logbook Bus" },
    { 0x0403ff1f, "Logbook Bus" },
    { 0x04040202, "78XX Scanner" },
    { 0x04040203, "78XX Scanner - Embedded System" },
    { 0x04040310, "K590 Printer, Self-Service" },
    { 0x04040311, "7167 Printer, Receipt/Slip" },
    { 0x04040312, "7197 Printer Receipt" },
    { 0x04040320, "5932-USB Keyboard" },
    { 0x04040321, "5953-USB Dynakey" },
    { 0x04040322, "5932-USB Enhanced Keyboard" },
    { 0x04040323, "5932-USB Enhanced Keyboard, Flash-Recovery/Download" },
    { 0x04040324, "5953-USB Enhanced Dynakey" },
    { 0x04040325, "5953-USB Enhanced Dynakey Flash-Recovery/Download" },
    { 0x04040328, "K016: USB-MSR ISO 3-track MSR: POS Standard (See HID pages)" },
    { 0x04040329, "K018: USB-MSR JIS 2-Track MSR: POS Standard" },
    { 0x0404032a, "K016: USB-MSR ISO 3-Track MSR: HID Keyboard Mode" },
    { 0x0404032b, "K016/K018: USB-MSR Flash-Recovery/Download" },
    { 0x04080103, "FV TouchCam N1 (Audio)" },
    { 0x0408030c, "HP Webcam" },
    { 0x040803b2, "HP Webcam" },
    { 0x040803f4, "HP Webcam" },
    { 0x04081030, "FV TouchCam N1 (Video)" },
    { 0x04083000, "Optical dual-touch panel" },
    { 0x04083001, "Optical Touch Screen" },
    { 0x04083008, "Optical Touch Screen" },
    { 0x0408a060, "HD Webcam" },
    { 0x0408b009, "Medion MD99000 (P9514)/Olivetti Olipad 110" },
    { 0x0408b00a, "Medion Lifetab P9514" },
    { 0x04090011, "PC98 Series Layout Keyboard Mouse" },
    { 0x04090012, "ATerm IT75DSU ISDN TA" },
    { 0x04090014, "Japanese Keyboard" },
    { 0x04090019, "109 Japanese Keyboard with Bus-Powered Hub" },
    { 0x0409001a, "PC98 Series Layout Keyboard with Bus-Powered Hub" },
    { 0x04090025, "Mini Keyboard with Bus-Powered Hub" },
    { 0x04090027, "MultiSync Monitor" },
    { 0x0409002c, "Clik!-USB Drive" },
    { 0x04090034, "109 Japanese Keyboard with One-touch start buttons" },
    { 0x0409003f, "Wireless Keyboard with One-touch start buttons" },
    { 0x04090040, "Floppy" },
    { 0x0409004e, "SuperScript 1400 Series" },
    { 0x0409004f, "Wireless Keyboard with One-touch start buttons" },
    { 0x04090050, "7-port hub" },
    { 0x04090058, "HighSpeed Hub" },
    { 0x04090059, "HighSpeed Hub" },
    { 0x0409005a, "HighSpeed Hub" },
    { 0x0409006a, "Conceptronic USB Harddisk Box" },
    { 0x0409007d, "MINICUBE2" },
    { 0x0409007e, "PG-FP5 Flash Memory Programmer" },
    { 0x04090081, "SuperScript 1400 Series" },
    { 0x04090082, "SuperScript 1400 Series" },
    { 0x04090094, "Japanese Keyboard with One-touch start buttons" },
    { 0x04090095, "Japanese Keyboard" },
    { 0x040900a9, "AtermIT21L 128K Support Standard" },
    { 0x040900aa, "AtermITX72 128K Support Standard" },
    { 0x040900ab, "AtermITX62 128K Support Standard" },
    { 0x040900ac, "AtermIT42 128K Support Standard" },
    { 0x040900ae, "INSMATEV70G-MAX Standard" },
    { 0x040900af, "AtermITX70 128K Support Standard" },
    { 0x040900b0, "AtermITX80 128K Support Standard" },
    { 0x040900b2, "AtermITX80D 128K Support Standard" },
    { 0x040900c0, "Wireless Remocon" },
    { 0x040900f7, "Smart Display PK-SD10" },
    { 0x0409011d, "e228 Mobile Phone" },
    { 0x04090203, "HID Audio Controls" },
    { 0x0409021d, "Aterm WL54SU2 802.11g Wireless Adapter [Atheros AR5523]" },
    { 0x04090242, "NEC FOMA N01A" },
    { 0x04090248, "Aterm PA-WL54GU" },
    { 0x04090249, "Aterm WL300NU-G" },
    { 0x040902b4, "Aterm WL300NU-AG" },
    { 0x040902b6, "Aterm WL300NU-GS 802.11n Wireless Adapter" },
    { 0x040902bc, "Computer Monitor" },
    { 0x04090300, "LifeTouch Note" },
    { 0x04090301, "LifeTouch Note (debug mode)" },
    { 0x040955aa, "Hub" },
    { 0x040955ab, "Hub [iMac/iTouch kbd]" },
    { 0x04098010, "Intellibase Hub" },
    { 0x04098011, "Intellibase Hub" },
    { 0x0409efbe, "P!cty 900 [HP DJ]" },
    { 0x0409f0be, "P!cty 920 [HP DJ 812c]" },
    { 0x040a0001, "DVC-323" },
    { 0x040a0002, "DVC-325" },
    { 0x040a0100, "DC-220" },
    { 0x040a0110, "DC-260" },
    { 0x040a0111, "DC-265" },
    { 0x040a0112, "DC-290" },
    { 0x040a0120, "DC-240" },
    { 0x040a0121, "Kodak DC240" },
    { 0x040a0130, "DC-280" },
    { 0x040a0131, "DC-5000" },
    { 0x040a0132, "DC-3400" },
    { 0x040a0140, "DC-4800" },
    { 0x040a0160, "Kodak DC4800" },
    { 0x040a0170, "Kodak DX3900" },
    { 0x040a0200, "Digital Camera" },
    { 0x040a0300, "EZ-200" },
    { 0x040a0400, "Kodak MC3" },
    { 0x040a0402, "Digital Camera" },
    { 0x040a0403, "Kodak Z7590" },
    { 0x040a0500, "Kodak DX3500" },
    { 0x040a0510, "Kodak DX3600" },
    { 0x040a0525, "Kodak DX3215" },
    { 0x040a0530, "Kodak DX3700" },
    { 0x040a0535, "Kodak CX4230" },
    { 0x040a0540, "Kodak LS420" },
    { 0x040a0550, "Kodak DX4900" },
    { 0x040a0555, "Kodak DX4330" },
    { 0x040a0560, "Kodak CX4210" },
    { 0x040a0565, "Kodak LS743" },
    { 0x040a0566, "Kodak CX4310" },
    { 0x040a0567, "Kodak LS753" },
    { 0x040a0568, "Kodak LS443" },
    { 0x040a0569, "Kodak LS663" },
    { 0x040a0570, "Kodak DX6340" },
    { 0x040a0571, "Kodak CX6330" },
    { 0x040a0572, "Kodak DX6440" },
    { 0x040a0573, "Kodak CX6230" },
    { 0x040a0574, "Kodak CX6200" },
    { 0x040a0575, "Kodak DX6490" },
    { 0x040a0576, "Kodak DX4530" },
    { 0x040a0577, "Kodak DX7630" },
    { 0x040a0578, "Kodak CX7310" },
    { 0x040a0579, "Kodak CX7220" },
    { 0x040a057a, "Kodak CX7330" },
    { 0x040a057b, "Kodak CX7430" },
    { 0x040a057c, "Kodak CX7530" },
    { 0x040a057d, "Kodak DX7440" },
    { 0x040a057e, "Kodak C300" },
    { 0x040a057f, "Kodak DX7590" },
    { 0x040a0580, "Kodak Z730" },
    { 0x040a0581, "Digital Camera" },
    { 0x040a0582, "Digital Camera" },
    { 0x040a0583, "Digital Camera" },
    { 0x040a0584, "Kodak CX6445" },
    { 0x040a0585, "Kodak M893 IS" },
    { 0x040a0586, "Kodak CX7525" },
    { 0x040a0587, "Kodak Z700" },
    { 0x040a0588, "Kodak Z740" },
    { 0x040a0589, "Kodak C360" },
    { 0x040a058a, "Kodak C310" },
    { 0x040a058b, "Digital Camera" },
    { 0x040a058c, "Kodak C330" },
    { 0x040a058d, "Kodak C340" },
    { 0x040a058e, "Kodak V530" },
    { 0x040a058f, "Kodak V550" },
    { 0x040a0590, "Digital Camera" },
    { 0x040a0591, "Kodak V570" },
    { 0x040a0592, "Kodak P850" },
    { 0x040a0593, "Kodak P880" },
    { 0x040a0594, "Digital Camera" },
    { 0x040a0595, "Digital Camera" },
    { 0x040a0596, "Digital Camera" },
    { 0x040a0597, "Digital Camera" },
    { 0x040a0598, "EASYSHARE M1033 digital camera" },
    { 0x040a0599, "Digital Camera" },
    { 0x040a059a, "Kodak C530" },
    { 0x040a059b, "Digital Camera" },
    { 0x040a059c, "Kodak CD33" },
    { 0x040a059d, "Kodak Z612" },
    { 0x040a059e, "Kodak Z650" },
    { 0x040a059f, "Kodak M753" },
    { 0x040a05a0, "Kodak V603" },
    { 0x040a05a1, "Digital Camera" },
    { 0x040a05a2, "Kodak C533" },
    { 0x040a05a3, "Digital Camera" },
    { 0x040a05a4, "Digital Camera" },
    { 0x040a05a5, "Digital Camera" },
    { 0x040a05a6, "Digital Camera" },
    { 0x040a05a7, "Kodak C643" },
    { 0x040a05a8, "Digital Camera" },
    { 0x040a05a9, "Kodak C875" },
    { 0x040a05aa, "Kodak C433" },
    { 0x040a05ab, "Kodak V705" },
    { 0x040a05ac, "Kodak V610" },
    { 0x040a05ad, "Kodak M883" },
    { 0x040a05ae, "Kodak C743" },
    { 0x040a05af, "Kodak C653" },
    { 0x040a05b0, "Digital Camera" },
    { 0x040a05b1, "Digital Camera" },
    { 0x040a05b2, "Digital Camera" },
    { 0x040a05b3, "Kodak Z710" },
    { 0x040a05b4, "Kodak Z712 IS" },
    { 0x040a05b5, "Kodak Z812 IS" },
    { 0x040a05b6, "Digital Camera" },
    { 0x040a05b7, "Kodak C613" },
    { 0x040a05b8, "Kodak V803" },
    { 0x040a05b9, "Digital Camera" },
    { 0x040a05ba, "Kodak C633" },
    { 0x040a05bb, "Digital Camera" },
    { 0x040a05bc, "Digital Camera" },
    { 0x040a05bd, "Digital Camera" },
    { 0x040a05be, "Digital Camera" },
    { 0x040a05bf, "Digital Camera" },
    { 0x040a05c0, "Kodak ZD710" },
    { 0x040a05c1, "Kodak M863" },
    { 0x040a05c2, "Digital Camera" },
    { 0x040a05c3, "Kodak C813" },
    { 0x040a05c4, "Digital Camera" },
    { 0x040a05c5, "Digital Camera" },
    { 0x040a05c6, "Kodak C913" },
    { 0x040a05c8, "EASYSHARE Z1485 IS Digital Camera" },
    { 0x040a05cd, "Kodak Z950" },
    { 0x040a05ce, "Kodak M1063" },
    { 0x040a05cf, "Kodak Z915" },
    { 0x040a05d3, "EasyShare M320 Camera" },
    { 0x040a05d4, "EasyShare C180 Digital Camera" },
    { 0x040a060b, "Kodak C183" },
    { 0x040a0617, "Kodak C1530" },
    { 0x040a1001, "EasyShare SV811 Digital Picture Frame" },
    { 0x040a4000, "InkJet Color Printer" },
    { 0x040a4021, "Photo Printer 6800" },
    { 0x040a4022, "1400 Digital Photo Printer" },
    { 0x040a402b, "Photo Printer 6850" },
    { 0x040a402e, "605 Photo Printer" },
    { 0x040a4034, "805 Photo Printer" },
    { 0x040a4035, "7000 Photo Printer" },
    { 0x040a4037, "7010 Photo Printer" },
    { 0x040a4038, "7015 Photo Printer" },
    { 0x040a404d, "8810 Photo Printer" },
    { 0x040a404f, "305 Photo Printer" },
    { 0x040a4056, "ESP 7200 Series AiO" },
    { 0x040a4109, "EasyShare Printer Dock Series 3" },
    { 0x040a410d, "EasyShare G600 Printer Dock" },
    { 0x040a5010, "Wireless Adapter" },
    { 0x040a5012, "DBT-220 Bluetooth Adapter" },
    { 0x040a6001, "i30" },
    { 0x040a6002, "i40" },
    { 0x040a6003, "i50" },
    { 0x040a6004, "i60" },
    { 0x040a6005, "i80" },
    { 0x040a6029, "i900" },
    { 0x040a602a, "i900" },
    { 0x040b0a68, "Func MS-3 gaming mouse [WT6573F MCU]" },
    { 0x040b2000, "wired Keyboard [Dynex DX-WRK1401]" },
    { 0x040b2367, "Human Interface Device [HP CalcPad 200 Calculator and Numeric Keypad]" },
    { 0x040b6510, "Weltrend Bar Code Reader" },
    { 0x040b6520, "Xploder Xbox Memory Unit (8MB)" },
    { 0x040b6533, "Speed-Link Competition Pro" },
    { 0x040b6543, "Manhattan Magnetic Card Strip Reader" },
    { 0x040d3184, "VNT VT6656 USB-802.11 Wireless LAN Adapter" },
    { 0x040d340f, "Audinst HUD-mx2" },
    { 0x040d6205, "USB 2.0 Card Reader" },
    { 0x04110001, "LUA-TX Ethernet [pegasus]" },
    { 0x04110005, "LUA-TX Ethernet" },
    { 0x04110006, "WLI-USB-L11 Wireless LAN Adapter" },
    { 0x04110009, "LUA2-TX Ethernet" },
    { 0x0411000b, "WLI-USB-L11G-WR Wireless LAN Adapter" },
    { 0x0411000d, "WLI-USB-L11G Wireless LAN Adapter" },
    { 0x04110012, "LUA-KTX Ethernet" },
    { 0x04110013, "USB2-IDE Adapter" },
    { 0x04110016, "WLI-USB-S11 802.11b Adapter" },
    { 0x04110018, "USB2-IDE Adapter" },
    { 0x0411001c, "USB-IDE Bridge: DUB-PxxG" },
    { 0x04110027, "WLI-USB-KS11G 802.11b Adapter" },
    { 0x0411002a, "SMSC USB97C202 \"HD-HB300V2-EU\"" },
    { 0x0411003d, "LUA-U2-KTX Ethernet" },
    { 0x04110044, "WLI-USB-KB11 Wireless LAN Adapter" },
    { 0x0411004b, "WLI-USB-G54 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x0411004d, "WLI-USB-B11 Wireless LAN Adapter" },
    { 0x04110050, "WLI2-USB2-G54 Wireless LAN Adapter" },
    { 0x0411005e, "WLI-U2-KG54-YB WLAN" },
    { 0x04110065, "Python2 WDM Encoder" },
    { 0x04110066, "WLI-U2-KG54 WLAN" },
    { 0x04110067, "WLI-U2-KG54-AI WLAN" },
    { 0x0411006e, "LUA-U2-GT 10/100/1000 Ethernet Adapter" },
    { 0x04110089, "RUF-C/U2 Flash Drive" },
    { 0x0411008b, "Nintendo Wi-Fi" },
    { 0x04110091, "WLI-U2-KAMG54 Wireless LAN Adapter" },
    { 0x04110092, "WLI-U2-KAMG54 Bootloader" },
    { 0x04110097, "WLI-U2-KG54-BB" },
    { 0x041100a9, "WLI-U2-AMG54HP Wireless LAN Adapter" },
    { 0x041100aa, "WLI-U2-AMG54HP Bootloader" },
    { 0x041100b3, "PC-OP-RS1 RemoteStation" },
    { 0x041100bc, "WLI-U2-KG125S 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x041100ca, "802.11n Network Adapter" },
    { 0x041100cb, "WLI-U2-G300N 802.11n Adapter" },
    { 0x041100d8, "WLI-U2-SG54HP" },
    { 0x041100d9, "WLI-U2-G54HP" },
    { 0x041100da, "WLI-U2-KG54L 802.11bg [ZyDAS ZD1211B]" },
    { 0x041100db, "External Hard Drive HD-PF32OU2 [Buffalo Ministation]" },
    { 0x041100e8, "WLI-UC-G300N Wireless LAN Adapter [Ralink RT2870]" },
    { 0x041100f9, "Portable DVD Writer (DVSM-PL58U2)" },
    { 0x04110105, "External Hard Drive HD-CEU2 [Drive Station]" },
    { 0x0411012c, "SATA Bridge" },
    { 0x0411012e, "WLI-UC-AG300N Wireless LAN Adapter" },
    { 0x04110148, "WLI-UC-G300HP Wireless LAN Adapter" },
    { 0x04110150, "WLP-UC-AG300 Wireless LAN Adapter" },
    { 0x04110157, "External Hard Drive HD-PEU2" },
    { 0x04110158, "WLI-UC-GNHP Wireless LAN Adapter" },
    { 0x0411015d, "WLI-UC-GN Wireless LAN Adapter [Ralink RT3070]" },
    { 0x0411016f, "WLI-UC-G301N Wireless LAN Adapter [Ralink RT3072]" },
    { 0x0411017f, "Sony UWA-BR100 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" },
    { 0x0411019e, "WLI-UC-GNP Wireless LAN Adapter" },
    { 0x041101a1, "MiniStation Metro" },
    { 0x041101a2, "WLI-UC-GNM Wireless LAN Adapter [Ralink RT8070]" },
    { 0x041101ba, "SATA Bridge" },
    { 0x041101dc, "Ultra-Slim Portable DVD Writer (DVSM-PC58U2V)" },
    { 0x041101de, "External Hard Drive HD-PCTU3 [Buffalo MiniStation]" },
    { 0x041101ea, "SATA Bridge" },
    { 0x041101ee, "WLI-UC-GNM2 Wireless LAN Adapter [Ralink RT3070]" },
    { 0x041101f1, "SATA Adapter [HD-LBU3]" },
    { 0x041101fd, "WLI-UC-G450 Wireless LAN Adapter" },
    { 0x0411027e, "HD-LCU3" },
    { 0x04131310, "WinFast TV - NTSC + FM" },
    { 0x04131311, "WinFast TV - NTSC + MTS + FM" },
    { 0x04131312, "WinFast TV - PAL BG + FM" },
    { 0x04131313, "WinFast TV - PAL BG+TXT + FM" },
    { 0x04131314, "WinFast TV Audio - PHP PAL I" },
    { 0x04131315, "WinFast TV Audio - PHP PAL I+TXT" },
    { 0x04131316, "WinFast TV Audio - PHP PAL DK" },
    { 0x04131317, "WinFast TV Audio - PHP PAL DK+TXT" },
    { 0x04131318, "WinFast TV - PAL I/DK + FM" },
    { 0x04131319, "WinFast TV - PAL N + FM" },
    { 0x0413131a, "WinFast TV Audio - PHP SECAM LL" },
    { 0x0413131b, "WinFast TV Audio - PHP SECAM LL+TXT" },
    { 0x0413131c, "WinFast TV Audio - PHP SECAM DK" },
    { 0x0413131d, "WinFast TV - SECAM DK + TXT + FM" },
    { 0x0413131e, "WinFast TV - NTSC Japan + FM" },
    { 0x04131320, "WinFast TV - NTSC" },
    { 0x04131321, "WinFast TV - NTSC + MTS" },
    { 0x04131322, "WinFast TV - PAL BG" },
    { 0x04131323, "WinFast TV - PAL BG+TXT" },
    { 0x04131324, "WinFast TV Audio - PHP PAL I" },
    { 0x04131325, "WinFast TV Audio - PHP PAL I+TXT" },
    { 0x04131326, "WinFast TV Audio - PHP PAL DK" },
    { 0x04131327, "WinFast TV Audio - PHP PAL DK+TXT" },
    { 0x04131328, "WinFast TV - PAL I/DK" },
    { 0x04131329, "WinFast TV - PAL N" },
    { 0x0413132a, "WinFast TV Audio - PHP SECAM LL" },
    { 0x0413132b, "WinFast TV Audio - PHP SECAM LL+TXT" },
    { 0x0413132c, "WinFast TV Audio - PHP SECAM DK" },
    { 0x0413132d, "WinFast TV - SECAM DK + TXT" },
    { 0x0413132e, "WinFast TV - NTSC Japan" },
    { 0x04136023, "EMP Audio Device" },
    { 0x04136024, "WinFast PalmTop/Novo TV Video" },
    { 0x04136025, "WinFast DTV Dongle (cold state)" },
    { 0x04136026, "WinFast DTV Dongle (warm state)" },
    { 0x04136029, "WinFast DTV Dongle Gold" },
    { 0x04136125, "WinFast DTV Dongle" },
    { 0x04136126, "WinFast DTV Dongle BDA Driver" },
    { 0x04136a03, "RTL2832 [WinFast DTV Dongle Mini]" },
    { 0x04136f00, "WinFast DTV Dongle (STK7700P based)" },
    { 0x04160035, "W89C35 802.11bg WLAN Adapter" },
    { 0x04160101, "Hub" },
    { 0x04160961, "AVL Flash Card Reader" },
    { 0x04163810, "Smart Card Controller" },
    { 0x04163811, "Generic Controller - Single interface" },
    { 0x04163812, "Smart Card Controller_2Interface" },
    { 0x04163813, "Panel Display" },
    { 0x04165011, "Virtual Com Port" },
    { 0x0416511b, "Nuvoton Nu-Link1 ICE" },
    { 0x0416511c, "Nuvoton Nu-Link1 ICE" },
    { 0x0416511d, "Nuvoton Nu-Link1 ICE/VCOM" },
    { 0x0416511e, "Nuvoton Nu-Link1 MSC/VCOM" },
    { 0x04165200, "Nuvoton Nu-Link2-ME ICE/MSC/VCOM" },
    { 0x04165201, "Nuvoton Nu-Link2-Pro ICE/MSC/VCOM" },
    { 0x04165210, "Nuvoton Nu-Link2 MSC FW UPGRADE" },
    { 0x04165211, "Nuvoton Nu-Link2 HID FW UPGRADE" },
    { 0x04165518, "4-Port Hub" },
    { 0x0416551a, "PC Sync Keypad" },
    { 0x0416551b, "PC Async Keypad" },
    { 0x0416551c, "Sync Tenkey" },
    { 0x0416551d, "Async Tenkey" },
    { 0x0416551e, "Keyboard" },
    { 0x0416551f, "Keyboard w/ Sys and Media" },
    { 0x04165521, "Keyboard" },
    { 0x04166481, "16-bit Scanner" },
    { 0x04167721, "Memory Stick Reader/Writer" },
    { 0x04167722, "Memory Stick Reader/Writer" },
    { 0x04167723, "SD Card Reader" },
    { 0x0416c141, "Barcode Scanner" },
    { 0x04190001, "IrDA Remote Controller / Creative Cordless Mouse" },
    { 0x04190600, "Desktop Wireless 6000" },
    { 0x04192694, "Laila" },
    { 0x04193001, "Xerox P1202 Laser Printer" },
    { 0x04193003, "Olivetti PG L12L" },
    { 0x04193201, "Docuprint P8ex" },
    { 0x04193404, "SCX-5x12 series" },
    { 0x04193406, "MFP 830 series" },
    { 0x04193407, "ML-912" },
    { 0x04193601, "InkJet Color Printer" },
    { 0x04193602, "InkJet Color Printer" },
    { 0x04194602, "Remote NDIS Network Device" },
    { 0x04198001, "Hub" },
    { 0x04198002, "SyncMaster HID Monitor Control" },
    { 0x0419aa03, "SDAS-3 MP3 Player" },
    { 0x041e0414, "HS-720 Headset" },
    { 0x041e1002, "Nomad II" },
    { 0x041e1003, "Blaster GamePad Cobra" },
    { 0x041e1050, "GamePad Cobra" },
    { 0x041e1053, "Mouse Gamer HD7600L" },
    { 0x041e200c, "MuVo V100" },
    { 0x041e2020, "Zen X-Fi 2" },
    { 0x041e2029, "ZiiO" },
    { 0x041e2801, "Prodikeys PC-MIDI multifunction keyboard" },
    { 0x041e3000, "SoundBlaster Extigy" },
    { 0x041e3002, "SB External Composite Device" },
    { 0x041e3010, "SoundBlaster MP3+" },
    { 0x041e3014, "SB External Composite Device" },
    { 0x041e3015, "Sound Blaster Digital Music LX" },
    { 0x041e3020, "SoundBlaster Audigy 2 NX" },
    { 0x041e3030, "SB External Composite Device" },
    { 0x041e3040, "SoundBlaster Live! 24-bit External SB0490" },
    { 0x041e3060, "Sound Blaster Audigy 2 ZS External" },
    { 0x041e3061, "SoundBlaster Audigy 2 ZS Video Editor" },
    { 0x041e3090, "Sound Blaster Digital Music SX" },
    { 0x041e30d0, "Xmod" },
    { 0x041e30d3, "Sound Blaster Play!" },
    { 0x041e3100, "IR Receiver (SB0540)" },
    { 0x041e3121, "WoW tap chat" },
    { 0x041e3220, "Sound Blaster Tactic(3D) Sigma sound card" },
    { 0x041e3232, "Sound Blaster Premium HD [SBX]" },
    { 0x041e3237, "SB X-Fi Surround 5.1 Pro" },
    { 0x041e3263, "SB X-Fi Surround 5.1 Pro" },
    { 0x041e3f00, "E-Mu Xboard 25 MIDI Controller" },
    { 0x041e3f02, "E-Mu 0202" },
    { 0x041e3f04, "E-Mu 0404" },
    { 0x041e3f07, "E-Mu Xmidi 1x1" },
    { 0x041e3f0e, "Xmidi 1x1 Tab" },
    { 0x041e4003, "VideoBlaster Webcam Go Plus [W9967CF]" },
    { 0x041e4004, "Nomad II MG" },
    { 0x041e4005, "Webcam Blaster Go ES" },
    { 0x041e4007, "Go Mini" },
    { 0x041e400a, "PC-Cam 300" },
    { 0x041e400b, "PC-Cam 600" },
    { 0x041e400c, "Webcam 5 [pwc]" },
    { 0x041e400d, "Webcam PD1001" },
    { 0x041e400f, "PC-CAM 550 (Composite)" },
    { 0x041e4011, "Webcam PRO eX" },
    { 0x041e4012, "PC-CAM350" },
    { 0x041e4013, "PC-Cam 750" },
    { 0x041e4015, "CardCam Value" },
    { 0x041e4016, "CardCam" },
    { 0x041e4017, "Webcam Mobile [PD1090]" },
    { 0x041e4018, "Webcam Vista [PD1100]" },
    { 0x041e4019, "Audio Device" },
    { 0x041e401a, "Webcam Vista [PD1100]" },
    { 0x041e401c, "Webcam NX [PD1110]" },
    { 0x041e401d, "Webcam NX Ultra" },
    { 0x041e401e, "Webcam NX Pro" },
    { 0x041e401f, "Webcam Notebook [PD1171]" },
    { 0x041e4020, "Webcam NX" },
    { 0x041e4021, "Webcam NX Ultra" },
    { 0x041e4022, "Webcam NX Pro" },
    { 0x041e4028, "Vista Plus cam [VF0090]" },
    { 0x041e4029, "Webcam Live!" },
    { 0x041e402f, "DC-CAM 3000Z" },
    { 0x041e4034, "Webcam Instant" },
    { 0x041e4035, "Webcam Instant" },
    { 0x041e4036, "Webcam Live!/Live! Pro" },
    { 0x041e4037, "Webcam Live!" },
    { 0x041e4038, "ORITE CCD Webcam [PC370R]" },
    { 0x041e4039, "Webcam Live! Effects" },
    { 0x041e403a, "Webcam NX Pro 2" },
    { 0x041e403b, "Creative Webcam Vista [VF0010]" },
    { 0x041e403c, "Webcam Live! Ultra" },
    { 0x041e403d, "Webcam Notebook Ultra" },
    { 0x041e403e, "Webcam Vista Plus" },
    { 0x041e4041, "Webcam Live! Motion" },
    { 0x041e4043, "Vibra Plus Webcam" },
    { 0x041e4045, "Live! Cam Voice" },
    { 0x041e4049, "Live! Cam Voice" },
    { 0x041e4051, "Live! Cam Notebook Pro [VF0250]" },
    { 0x041e4052, "Live! Cam Vista IM" },
    { 0x041e4053, "Live! Cam Video IM" },
    { 0x041e4054, "Live! Cam Video IM" },
    { 0x041e4055, "Live! Cam Video IM Pro" },
    { 0x041e4056, "Live! Cam Video IM Pro" },
    { 0x041e4057, "Live! Cam Optia" },
    { 0x041e4058, "Live! Cam Optia AF" },
    { 0x041e405f, "WebCam Vista (VF0330)" },
    { 0x041e4061, "Live! Cam Notebook Pro [VF0400]" },
    { 0x041e4063, "Live! Cam Video IM Pro" },
    { 0x041e4068, "Live! Cam Notebook [VF0470]" },
    { 0x041e406c, "Live! Cam Sync [VF0520]" },
    { 0x041e4083, "Live! Cam Socialize [VF0640]" },
    { 0x041e4087, "Live! Cam Socialize HD 1080 [VF0680]" },
    { 0x041e4088, "Live! Cam Chat HD [VF0700]" },
    { 0x041e4095, "Live! Cam Sync HD [VF0770]" },
    { 0x041e4097, "Live! Cam Chat HD [VF0700]" },
    { 0x041e4100, "Nomad Jukebox 2" },
    { 0x041e4101, "Nomad Jukebox 3" },
    { 0x041e4102, "NOMAD MuVo^2" },
    { 0x041e4106, "Nomad MuVo" },
    { 0x041e4107, "NOMAD MuVo" },
    { 0x041e4108, "Nomad Jukebox Zen" },
    { 0x041e4109, "Nomad Jukebox Zen NX" },
    { 0x041e410b, "Nomad Jukebox Zen USB 2.0" },
    { 0x041e410c, "Nomad MuVo NX" },
    { 0x041e410f, "NOMAD MuVo^2 (Flash)" },
    { 0x041e4110, "Nomad Jukebox Zen Xtra" },
    { 0x041e4111, "Dell Digital Jukebox" },
    { 0x041e4116, "MuVo^2" },
    { 0x041e4117, "Nomad MuVo TX" },
    { 0x041e411b, "Zen Touch" },
    { 0x041e411c, "Nomad MuVo USB 2.0" },
    { 0x041e411d, "Zen" },
    { 0x041e411e, "Zen Micro" },
    { 0x041e411f, "Creative ZEN Vision" },
    { 0x041e4120, "Nomad MuVo TX FM" },
    { 0x041e4123, "Creative Portable Media Center" },
    { 0x041e4124, "MuVo^2 FM (uHDD)" },
    { 0x041e4126, "Dell DJ (2nd gen)" },
    { 0x041e4127, "Dell DJ" },
    { 0x041e4128, "Creative ZEN Xtra (MTP mode)" },
    { 0x041e412b, "MuVo N200 with FM radio" },
    { 0x041e412f, "Dell DJ (2nd generation)" },
    { 0x041e4130, "Creative ZEN Micro (MTP mode)" },
    { 0x041e4131, "Creative ZEN Touch (MTP mode)" },
    { 0x041e4132, "Dell Dell Pocket DJ (MTP mode)" },
    { 0x041e4133, "Creative ZEN MicroPhoto (alternate version)" },
    { 0x041e4134, "Zen Neeon" },
    { 0x041e4136, "Zen Sleek" },
    { 0x041e4137, "Creative ZEN Sleek (MTP mode)" },
    { 0x041e4139, "Zen Nano Plus" },
    { 0x041e413c, "Creative ZEN MicroPhoto" },
    { 0x041e413d, "Creative ZEN Sleek Photo" },
    { 0x041e413e, "Creative ZEN Vision:M" },
    { 0x041e4150, "Creative ZEN V" },
    { 0x041e4151, "Creative ZEN Vision:M (DVP-HD0004)" },
    { 0x041e4152, "Creative ZEN V Plus" },
    { 0x041e4153, "Creative ZEN Vision W" },
    { 0x041e4154, "Zen Stone" },
    { 0x041e4155, "Zen Stone plus" },
    { 0x041e4157, "Creative ZEN" },
    { 0x041e4158, "Creative ZEN V 2GB" },
    { 0x041e4161, "Creative ZEN Mozaic" },
    { 0x041e4162, "Creative ZEN X-Fi" },
    { 0x041e4169, "Creative ZEN X-Fi 3" },
    { 0x041e500f, "Broadband Blaster 8012U-V" },
    { 0x041e5015, "TECOM Bluetooth Device" },
    { 0x041e6000, "ZiiLABS Zii EGG" },
    { 0x041effff, "Webcam Live! Ultra" },
    { 0x04201307, "Celly SIM Card Reader" },
    { 0x04210001, "E61i (PC Suite mode)" },
    { 0x0421000a, "Nokia N81 Mobile Phone" },
    { 0x04210018, "6288 GSM Smartphone" },
    { 0x04210019, "6288 GSM Smartphone (imaging mode)" },
    { 0x0421001a, "6288 GSM Smartphone (file transfer mode)" },
    { 0x04210024, "5610 XpressMusic (Storage mode)" },
    { 0x04210025, "5610 XpressMusic (PC Suite mode)" },
    { 0x04210028, "5610 XpressMusic (Imaging mode)" },
    { 0x0421002d, "6120 Phone (Mass storage mode)" },
    { 0x0421002e, "Nokia 6120c Classic Mobile Phone" },
    { 0x0421002f, "6120 Phone (PC-Suite mode)" },
    { 0x04210039, "Nokia N96 Mobile Phone" },
    { 0x0421003c, "Nokia 6500c Classic Mobile Phone" },
    { 0x04210042, "E51 (PC Suite mode)" },
    { 0x0421005f, "Nokia 3110c Mobile Phone" },
    { 0x04210064, "3109c GSM Phone" },
    { 0x04210065, "Nokia 3109c Mobile Phone" },
    { 0x0421006b, "5310 Xpress Music (PC Suite mode)" },
    { 0x0421006c, "Nokia 5310 XpressMusic" },
    { 0x0421006d, "N95 (Storage mode)" },
    { 0x0421006e, "Nokia N95 Mobile Phone 8GB" },
    { 0x0421006f, "N95 (Printing mode)" },
    { 0x04210070, "N95 (PC Suite mode)" },
    { 0x04210074, "Nokia N82 Mobile Phone" },
    { 0x04210079, "Nokia N78 Mobile Phone" },
    { 0x0421008d, "Nokia 6220 Classic" },
    { 0x04210092, "Nokia N85 Mobile Phone" },
    { 0x04210096, "N810 Internet Tablet" },
    { 0x04210098, "Nokia 6210 Navigator" },
    { 0x042100aa, "E71 (Mass storage mode)" },
    { 0x042100ab, "E71 (PC Suite mode)" },
    { 0x042100e4, "Nokia E71" },
    { 0x042100e5, "Nokia E66" },
    { 0x042100ea, "Nokia 5320 XpressMusic" },
    { 0x04210103, "ADL Flashing Engine AVALON Parent" },
    { 0x04210104, "ADL Re-Flashing Engine Parent" },
    { 0x04210105, "Nokia Firmware Upgrade Mode" },
    { 0x04210106, "ROM Parent" },
    { 0x0421010d, "E75 (Storage Mode)" },
    { 0x0421010e, "E75 (PC Suite mode)" },
    { 0x0421010f, "E75 (Media transfer mode)" },
    { 0x04210110, "E75 (Imaging Mode)" },
    { 0x04210154, "Nokia 5800 XpressMusic" },
    { 0x04210155, "Nokia 5800 XpressMusic v2" },
    { 0x04210156, "5800 XpressMusic (Storage mode)" },
    { 0x04210157, "5800 XpressMusic (Imaging mode)" },
    { 0x04210159, "Nokia 5800 XpressMusic v3" },
    { 0x04210179, "Nokia E63" },
    { 0x04210186, "Nokia N79" },
    { 0x04210199, "6700 Classic (msc)" },
    { 0x0421019a, "6700 Classic (PC Suite)" },
    { 0x0421019b, "6700 Classic (mtp)" },
    { 0x042101a1, "Nokia E71x" },
    { 0x042101b0, "6303 classic Phone (PC Suite mode)" },
    { 0x042101b1, "6303 classic Phone (Mass storage mode)" },
    { 0x042101b2, "6303 classic Phone (Printing and media mode)" },
    { 0x042101c7, "N900 (Storage Mode)" },
    { 0x042101c8, "N900 (PC-Suite Mode)" },
    { 0x042101cf, "Nokia E52" },
    { 0x042101ee, "Nokia 3710" },
    { 0x042101f4, "Nokia N97-1" },
    { 0x042101f5, "Nokia N97" },
    { 0x04210209, "Nokia 5130 XpressMusic" },
    { 0x04210221, "Nokia E72" },
    { 0x04210228, "5530 XpressMusic" },
    { 0x04210229, "Nokia 5530" },
    { 0x0421023a, "6730 Classic" },
    { 0x0421026a, "N97 (mass storage)" },
    { 0x0421026b, "Nokia N97 mini" },
    { 0x0421026c, "N97 (PC Suite)" },
    { 0x0421026d, "N97 (Pictures)" },
    { 0x04210274, "Nokia X6" },
    { 0x04210295, "660i/6600i Slide Phone (Mass Storage)" },
    { 0x04210297, "Nokia 6600i" },
    { 0x042102c1, "Nokia 2710" },
    { 0x042102e1, "5230 (Storage mode)" },
    { 0x042102e2, "Nokia 5230" },
    { 0x042102e3, "5230 (PC-Suite mode)" },
    { 0x042102e4, "5230 (Imaging mode)" },
    { 0x042102fe, "Nokia N8" },
    { 0x04210302, "Nokia N8 (Ovi mode)" },
    { 0x04210334, "Nokia E7" },
    { 0x04210335, "Nokia E7 (Ovi mode)" },
    { 0x04210360, "C1-01 Ovi Suite Mode" },
    { 0x04210396, "C7-00 (Modem mode)" },
    { 0x042103a4, "C5 (Storage mode)" },
    { 0x042103c0, "C7-00 (Mass storage mode)" },
    { 0x042103c1, "Nokia C7" },
    { 0x042103c2, "Sim" },
    { 0x042103cd, "Nokia C7 (ID2)" },
    { 0x042103d1, "N950" },
    { 0x042103d2, "Nokia N950" },
    { 0x04210400, "7600 Phone Parent" },
    { 0x04210401, "6650 GSM Phone" },
    { 0x04210402, "6255 Phone Parent" },
    { 0x04210404, "5510" },
    { 0x04210405, "9500 GSM Communicator" },
    { 0x04210407, "Music Player HDR-1(tm)" },
    { 0x0421040b, "N-Gage GSM Phone" },
    { 0x0421040d, "6620 Phone Parent" },
    { 0x0421040e, "6651 Phone Parent" },
    { 0x0421040f, "6230 GSM Phone" },
    { 0x04210410, "6630 Imaging Smartphone" },
    { 0x04210411, "7610 Phone Parent" },
    { 0x04210413, "6260 Phone Parent" },
    { 0x04210414, "7370" },
    { 0x04210415, "9300 GSM Smartphone" },
    { 0x04210416, "6170 Phone Parent" },
    { 0x04210417, "7270 Phone Parent" },
    { 0x04210418, "E70 (PC Suite mode)" },
    { 0x04210419, "E60 (PC Suite mode)" },
    { 0x0421041a, "9500 GSM Communicator (RNDIS)" },
    { 0x0421041b, "9300 GSM Smartphone (RNDIS)" },
    { 0x0421041c, "7710 Phone Parent" },
    { 0x0421041d, "6670 Phone Parent" },
    { 0x0421041e, "6680" },
    { 0x0421041f, "6235 Phone Parent" },
    { 0x04210421, "3230 Phone Parent" },
    { 0x04210422, "6681 Phone Parent" },
    { 0x04210423, "6682 Phone Parent" },
    { 0x04210428, "6230i Modem" },
    { 0x04210429, "6230i MultiMedia Card" },
    { 0x04210431, "770 Internet Tablet" },
    { 0x04210432, "N90 Phone Parent" },
    { 0x04210435, "E70 (IP Passthrough/RNDIS mode)" },
    { 0x04210436, "E60 (IP Passthrough/RNDIS mode)" },
    { 0x04210437, "6265 Phone Parent" },
    { 0x0421043a, "N70 USB Phone Parent" },
    { 0x0421043b, "3155 Phone Parent" },
    { 0x0421043c, "6155 Phone Parent" },
    { 0x0421043d, "6270 Phone Parent" },
    { 0x04210443, "N70 Phone Parent" },
    { 0x04210444, "N91" },
    { 0x0421044c, "NM850iG Phone Parent" },
    { 0x0421044d, "E61 (PC Suite mode)" },
    { 0x0421044e, "E61 (Data Exchange mode)" },
    { 0x0421044f, "E61 (IP Passthrough/RNDIS mode)" },
    { 0x04210453, "9300 Phone Parent" },
    { 0x04210456, "6111 Phone Parent" },
    { 0x04210457, "6111 Phone (Printing mode)" },
    { 0x0421045a, "6280 Phone Parent" },
    { 0x0421045d, "6282 Phone Parent" },
    { 0x04210462, "Nokia 3250 Mobile Phone" },
    { 0x0421046e, "6110 Navigator" },
    { 0x04210471, "6110 Navigator" },
    { 0x04210478, "Nokia N93 Mobile Phone" },
    { 0x0421047e, "Nokia 5500 Sport Mobile Phone" },
    { 0x04210485, "Nokia N91 Mobile Phone" },
    { 0x04210488, "Nokia N73" },
    { 0x042104b4, "Nokia 5700 XpressMusic Mobile Phone" },
    { 0x042104b9, "5300" },
    { 0x042104ba, "Nokia 5300 Mobile Phone" },
    { 0x042104bc, "5200 (Nokia mode)" },
    { 0x042104bd, "5200 (Storage mode)" },
    { 0x042104be, "Nokia 5200 Mobile Phone" },
    { 0x042104c3, "N800 Internet Tablet" },
    { 0x042104ce, "E90 Communicator (PC Suite mode)" },
    { 0x042104cf, "E90 Communicator (Storage mode)" },
    { 0x042104d1, "Nokia N73 Mobile Phone" },
    { 0x042104e1, "Nokia N75 Mobile Phone" },
    { 0x042104e5, "Nokia N93i Mobile Phone" },
    { 0x042104ef, "Nokia N95 Mobile Phone" },
    { 0x042104f0, "Nokia N95 (PC Suite mode)" },
    { 0x042104f1, "Nokia N80 Internet Edition (Media Player)" },
    { 0x042104f9, "6300 (PC Suite mode)" },
    { 0x04210508, "E65 (PC Suite mode)" },
    { 0x04210509, "E65 (Storage mode)" },
    { 0x04210518, "N9 Phone" },
    { 0x0421051a, "Nokia N9" },
    { 0x0421054d, "C2-01" },
    { 0x04210600, "Digital Pen SU-1B" },
    { 0x04210610, "CS-15 (Internet Stick 3G modem)" },
    { 0x04210661, "Lumia 620/920" },
    { 0x04210662, "301 Dual SIM (Mass Storage)" },
    { 0x04210663, "301 Dual SIM" },
    { 0x0421069a, "130 [RM-1035] (Charging only)" },
    { 0x042106fc, "Lumia 640 Phone" },
    { 0x04210720, "X (RM-980)" },
    { 0x04210800, "Connectivity Cable DKU-5" },
    { 0x04210801, "Data Cable DKU-6" },
    { 0x04210802, "CA-42 Phone Parent" },
    { 0x0423000a, "NetMate Ethernet" },
    { 0x0423000c, "NetMate2 Ethernet" },
    { 0x0423000d, "USB Chief Analyzer" },
    { 0x04230100, "Generic Universal Protocol Analyzer" },
    { 0x04230101, "UPA USBTracer" },
    { 0x04230200, "Generic 10K Universal Protocol Analyzer" },
    { 0x0423020a, "PETracer ML" },
    { 0x04230300, "Generic Universal Protocol Analyzer" },
    { 0x04230301, "2500H Tracer Trainer" },
    { 0x0423030a, "PETracer x1" },
    { 0x04231237, "Andromeda Hub" },
    { 0x04240001, "Integrated Hub" },
    { 0x04240140, "LPC47M14x hub" },
    { 0x04240acd, "Sitecom Internal Multi Memory reader/writer MD-005" },
    { 0x04240fdc, "Floppy" },
    { 0x042410cd, "Sitecom Internal Multi Memory reader/writer MD-005" },
    { 0x04242020, "USB Hub" },
    { 0x042420cd, "Sitecom Internal Multi Memory reader/writer MD-005" },
    { 0x042420fc, "6-in-1 Card Reader" },
    { 0x04242134, "Hub" },
    { 0x04242228, "9-in-2 Card Reader" },
    { 0x0424223a, "8-in-1 Card Reader" },
    { 0x04242503, "USB 2.0 Hub" },
    { 0x04242507, "hub" },
    { 0x04242512, "USB 2.0 Hub" },
    { 0x04242513, "2.0 Hub" },
    { 0x04242514, "USB 2.0 Hub" },
    { 0x04242517, "Hub" },
    { 0x04242524, "USB MultiSwitch Hub" },
    { 0x04242602, "USB 2.0 Hub" },
    { 0x04242640, "USB 2.0 Hub" },
    { 0x04242660, "Hub" },
    { 0x04242744, "Hub" },
    { 0x0424274d, "HTC Hub Controller" },
    { 0x04242807, "Hub" },
    { 0x04243fc7, "RME Babyface audio system" },
    { 0x04243fcc, "RME MADIface" },
    { 0x04244041, "Hub and media card controller" },
    { 0x04244060, "Ultra Fast Media Reader" },
    { 0x04244064, "Ultra Fast Media Reader" },
    { 0x04244712, "USB4712 high-speed hub" },
    { 0x04244713, "USB4715 high-speed hub (2 ports disabled)" },
    { 0x04244714, "USB4715 high-speed hub (1 port disabled)" },
    { 0x04244715, "USB4715 high-speed hub" },
    { 0x04244910, "USB491x hub integrated functions (primary)" },
    { 0x04244912, "USB4912 high-speed hub (1 port disabled)" },
    { 0x04244914, "USB4914 high-speed hub" },
    { 0x04244916, "USB4916 high-speed hub" },
    { 0x04244920, "USB491x hub integrated functions (secondary)" },
    { 0x04244925, "USB4925 high-speed hub (primary upstream)" },
    { 0x04244927, "USB4927 high-speed hub (primary upstream)" },
    { 0x04244931, "USB4925/4927 high-speed hub (secondary upstream)" },
    { 0x04244940, "USB47xx/49xx hub integrated WinUSB" },
    { 0x04244942, "USB47xx/49xx hub integrated I2S audio port" },
    { 0x04244943, "USB47xx/49xx hub integrated I2S audio + HID port" },
    { 0x04244944, "USB47xx/49xx hub integrated serial port" },
    { 0x04244946, "USB47xx/49xx hub integrated serial + I2S audio port" },
    { 0x04244947, "USB47xx/49xx hub integrated serial + I2S audio + HID port" },
    { 0x0424494a, "USB47xx/49xx hub integrated WinUSB + I2S audio port" },
    { 0x0424494b, "USB47xx/49xx hub integrated WinUSB + I2S audio + HID port" },
    { 0x0424494c, "USB47xx/49xx hub integrated WinUSB + serial port" },
    { 0x0424494e, "USB47xx/49xx hub integrated WinUSB + serial + I2S audio port" },
    { 0x0424494f, "USB47xx/49xx hub integrated WinUSB + serial + I2S audio + HID port" },
    { 0x04245434, "Hub" },
    { 0x04245534, "Hub" },
    { 0x04245744, "Hub" },
    { 0x04245807, "Hub" },
    { 0x04247500, "LAN7500 Ethernet 10/100/1000 Adapter" },
    { 0x04249500, "LAN9500/LAN9500i" },
    { 0x04249512, "SMC9512/9514 USB Hub" },
    { 0x04249514, "SMC9514 Hub" },
    { 0x04249904, "LAN9512/LAN9514 Ethernet 10/100 Adapter (SAL10)" },
    { 0x04249e00, "LAN9500A/LAN9500Ai" },
    { 0x0424a700, "2 Port Hub" },
    { 0x0424ec00, "SMSC9512/9514 Fast Ethernet Adapter" },
    { 0x04250101, "G-Tech Wireless Mouse & Keyboard" },
    { 0x0425f102, "G-Tech U+P Wireless Mouse" },
    { 0x04260426, "WDM Driver" },
    { 0x04284001, "GamePad Pro" },
    { 0x042b9316, "8x931Hx Customer Hub" },
    { 0x042e0380, "MP3 Player" },
    { 0x04300002, "109 Keyboard" },
    { 0x04300005, "Type 6 Keyboard" },
    { 0x0430000a, "109 Japanese Keyboard" },
    { 0x0430000b, "109 Japanese Keyboard" },
    { 0x04300082, "109 Japanese Keyboard" },
    { 0x04300083, "109 Japanese Keyboard" },
    { 0x043000a2, "Type 7 Keyboard" },
    { 0x04300100, "3-button Mouse" },
    { 0x04300502, "Panasonic CF-19 HID Touch Panel" },
    { 0x0430100e, "24.1\" LCD Monitor v4 / FID-638 Mouse" },
    { 0x043036ba, "Bus Powered Hub" },
    { 0x0430a101, "remote key/mouse for P3 chip" },
    { 0x0430a102, "remote key/mouse/storage for P3 chip" },
    { 0x0430a103, "remote storage for P3 chip" },
    { 0x0430a111, "remote keyboard for P4 chip" },
    { 0x0430a112, "remote mouse for P4 chip" },
    { 0x0430a113, "remote storage for P4 chip" },
    { 0x0430a4a2, "Ethernet (RNDIS and CDC ethernet)" },
    { 0x0430cdab, "Raritan KVM dongle" },
    { 0x04310100, "Mouse-Trak 3-button Track Ball" },
    { 0x04320031, "Document Processor" },
    { 0x04331101, "IBM Game Controller" },
    { 0x0433abab, "Keyboard" },
    { 0x04360005, "CameraMate (DPCM_USB)" },
    { 0x04387900, "Root Hub" },
    { 0x043d0001, "Laser Printer" },
    { 0x043d0002, "Optra E310 Printer" },
    { 0x043d0003, "Laser Printer" },
    { 0x043d0004, "Laser Printer" },
    { 0x043d0005, "Laser Printer" },
    { 0x043d0006, "Laser Printer" },
    { 0x043d0007, "Laser Printer" },
    { 0x043d0008, "Inkjet Color Printer" },
    { 0x043d0009, "Optra S2450 Printer" },
    { 0x043d000a, "Laser Printer" },
    { 0x043d000b, "Inkjet Color Printer" },
    { 0x043d000c, "Optra E312 Printer" },
    { 0x043d000d, "Laser Printer" },
    { 0x043d000e, "Laser Printer" },
    { 0x043d000f, "Laser Printer" },
    { 0x043d0010, "Laser Printer" },
    { 0x043d0011, "Laser Printer" },
    { 0x043d0012, "Inkjet Color Printer" },
    { 0x043d0013, "Inkjet Color Printer" },
    { 0x043d0014, "InkJet Color Printer" },
    { 0x043d0015, "InkJet Color Printer" },
    { 0x043d0016, "Z12 Color Jetprinter" },
    { 0x043d0017, "Z32 printer" },
    { 0x043d0018, "Z52 Printer" },
    { 0x043d0019, "Forms Printer" },
    { 0x043d001a, "Z65 Printer" },
    { 0x043d001b, "InkJet Photo Printer" },
    { 0x043d001c, "Kodak Personal Picture Maker 200 Printer" },
    { 0x043d001d, "InkJet Color Printer" },
    { 0x043d001e, "InkJet Photo Printer" },
    { 0x043d001f, "Kodak Personal Picture Maker 200 Card Reader" },
    { 0x043d0020, "Z51 Printer" },
    { 0x043d0021, "Z33 Printer" },
    { 0x043d0022, "InkJet Color Printer" },
    { 0x043d0023, "Laser Printer" },
    { 0x043d0024, "Laser Printer" },
    { 0x043d0025, "InkJet Color Printer" },
    { 0x043d0026, "InkJet Color Printer" },
    { 0x043d0027, "InkJet Color Printer" },
    { 0x043d0028, "InkJet Color Printer" },
    { 0x043d0029, "Scan Print Copy" },
    { 0x043d002a, "Scan Print Copy" },
    { 0x043d002b, "Scan Print Copy" },
    { 0x043d002c, "Scan Print Copy" },
    { 0x043d002d, "X70/X73 Scan/Print/Copy" },
    { 0x043d002e, "Scan Print Copy" },
    { 0x043d002f, "Scan Print Copy" },
    { 0x043d0030, "Scan Print Copy" },
    { 0x043d0031, "Scan Print Copy" },
    { 0x043d0032, "Scan Print Copy" },
    { 0x043d0033, "Scan Print Copy" },
    { 0x043d0034, "Scan Print Copy" },
    { 0x043d0035, "Scan Print Copy" },
    { 0x043d0036, "Scan Print Copy" },
    { 0x043d0037, "Scan Print Copy" },
    { 0x043d0038, "Scan Print Copy" },
    { 0x043d0039, "Scan Print Copy" },
    { 0x043d003a, "Scan Print Copy" },
    { 0x043d003b, "Scan Print Copy" },
    { 0x043d003c, "Scan Print Copy" },
    { 0x043d003d, "X83 Scan/Print/Copy" },
    { 0x043d003e, "Scan Print Copy" },
    { 0x043d003f, "Scan Print Copy" },
    { 0x043d0040, "Scan Print Copy" },
    { 0x043d0041, "Scan Print Copy" },
    { 0x043d0042, "Scan Print Copy" },
    { 0x043d0043, "Scan Print Copy" },
    { 0x043d0044, "Scan Print Copy" },
    { 0x043d0045, "Scan Print Copy" },
    { 0x043d0046, "Scan Print Copy" },
    { 0x043d0047, "Scan Print Copy" },
    { 0x043d0048, "Scan Print Copy" },
    { 0x043d0049, "Scan Print Copy" },
    { 0x043d004a, "Scan Print Copy" },
    { 0x043d004b, "Scan Print Copy" },
    { 0x043d004c, "Scan Print Copy" },
    { 0x043d004d, "Laser Printer" },
    { 0x043d004e, "Laser Printer" },
    { 0x043d004f, "InkJet Color Printer" },
    { 0x043d0050, "InkJet Color Printer" },
    { 0x043d0051, "Laser Printer" },
    { 0x043d0052, "Laser Printer" },
    { 0x043d0053, "InkJet Color Printer" },
    { 0x043d0054, "InkJet Color Printer" },
    { 0x043d0057, "Z35 Printer" },
    { 0x043d0058, "Laser Printer" },
    { 0x043d005a, "X63" },
    { 0x043d005c, "InkJet Color Printer" },
    { 0x043d0060, "X74/X75 Scanner" },
    { 0x043d0061, "X74 Hub" },
    { 0x043d0065, "X5130" },
    { 0x043d0069, "X74/X75 Printer" },
    { 0x043d006d, "X125" },
    { 0x043d006e, "C510" },
    { 0x043d0072, "X6170 Printer" },
    { 0x043d0073, "InkJet Color Printer" },
    { 0x043d0078, "InkJet Color Printer" },
    { 0x043d0079, "InkJet Color Printer" },
    { 0x043d007a, "Generic Hub" },
    { 0x043d007b, "InkJet Color Printer" },
    { 0x043d007c, "X1110/X1130/X1140/X1150/X1170/X1180/X1185" },
    { 0x043d007d, "Photo 3150" },
    { 0x043d008a, "4200 series" },
    { 0x043d008b, "InkJet Color Printer" },
    { 0x043d008c, "to CF/SM/SD/MS Card Reader" },
    { 0x043d008e, "InkJet Color Printer" },
    { 0x043d008f, "X422" },
    { 0x043d0091, "Laser Printer E232" },
    { 0x043d0093, "X5250" },
    { 0x043d0095, "E220 Printer" },
    { 0x043d0096, "2200 series" },
    { 0x043d0097, "P6250" },
    { 0x043d0098, "7100 series" },
    { 0x043d009e, "P910 series Human Interface Device" },
    { 0x043d009f, "InkJet Color Printer" },
    { 0x043d00a9, "IBM Infoprint 1410 MFP" },
    { 0x043d00ab, "InkJet Color Printer" },
    { 0x043d00b2, "3300 series" },
    { 0x043d00b8, "7300 series" },
    { 0x043d00b9, "8300 series" },
    { 0x043d00ba, "InkJet Color Printer" },
    { 0x043d00bb, "2300 series" },
    { 0x043d00bd, "Printing Support" },
    { 0x043d00be, "Printing Support" },
    { 0x043d00bf, "Printing Support" },
    { 0x043d00c0, "6300 series" },
    { 0x043d00c1, "4300 series" },
    { 0x043d00c7, "Printing Support" },
    { 0x043d00c8, "Printing Support" },
    { 0x043d00c9, "Printing Support" },
    { 0x043d00cb, "Printing Support" },
    { 0x043d00cc, "E120(n)" },
    { 0x043d00d0, "9300 series" },
    { 0x043d00d3, "X340 Scanner" },
    { 0x043d00d4, "X342n Scanner" },
    { 0x043d00d5, "Printing Support" },
    { 0x043d00d6, "X340 Scanner" },
    { 0x043d00e8, "X642e" },
    { 0x043d00e9, "2400 series" },
    { 0x043d00f6, "3400 series" },
    { 0x043d00f7, "InkJet Color Printer" },
    { 0x043d00ff, "InkJet Color Printer" },
    { 0x043d010b, "2500 series" },
    { 0x043d010d, "3500-4500 series" },
    { 0x043d010f, "6500 series" },
    { 0x043d0142, "X3650 (Printer, Scanner, Copier)" },
    { 0x043d01fa, "S310 series" },
    { 0x043d4303, "Xerox WorkCentre Pro 412" },
    { 0x043e3001, "AN-WF100 802.11abgn Wireless Adapter [Broadcom BCM4323]" },
    { 0x043e3004, "TWFM-B003D 802.11abgn Wireless Module [Broadcom BCM43236B]" },
    { 0x043e3009, "VC400" },
    { 0x043e3101, "AN-WF500 802.11abgn + BT Wireless Adapter [Broadcom BCM43242]" },
    { 0x043e42bd, "Flatron 795FT Plus Monitor" },
    { 0x043e4a4d, "Flatron 915FT Plus Monitor" },
    { 0x043e7001, "MF-PD100 Soul Digital MP3 Player" },
    { 0x043e7013, "MP3 Player" },
    { 0x043e7040, "LG Electronics Inc. T54" },
    { 0x043e70b1, "LG Electronics Inc. UP3" },
    { 0x043e70d7, "Mouse Scanner LSM-150 [LG Smart Scan Mouse]" },
    { 0x043e70f5, "External HDD" },
    { 0x043e8484, "LPC-U30 Webcam II" },
    { 0x043e8585, "LPC-UC35 Webcam" },
    { 0x043e8888, "Electronics VCS Camera II(LPC-U20)" },
    { 0x043e9800, "Remote Control Receiver_iMON" },
    { 0x043e9803, "eHome Infrared Receiver" },
    { 0x043e9804, "DMB Receiver Control" },
    { 0x043e9c01, "LGE Sync" },
    { 0x04411456, "Hub" },
    { 0x0442abba, "Bluetooth Device" },
    { 0x0443000e, "Multimedia Keyboard" },
    { 0x0443002e, "Millennium Keyboard" },
    { 0x04466781, "Keyboard with PS/2 Mouse Port" },
    { 0x04466782, "Keyboard" },
    { 0x04490128, "Menengah" },
    { 0x04490210, "Dasar" },
    { 0x04490612, "Lanjutan" },
    { 0x044e1104, "Japanese Keyboard" },
    { 0x044e2002, "MD-5500 Printer" },
    { 0x044e2014, "Bluetooth Device" },
    { 0x044e3001, "UGTZ4 Bluetooth" },
    { 0x044e3002, "Bluetooth Device" },
    { 0x044e3003, "Bluetooth Device" },
    { 0x044e3004, "Bluetooth Adapter" },
    { 0x044e3005, "Integrated Bluetooth Device" },
    { 0x044e3006, "Bluetooth Adapter" },
    { 0x044e3007, "Bluetooth Controller (ALPS/UGX)" },
    { 0x044e300c, "Bluetooth Controller (ALPS/UGPZ6)" },
    { 0x044e300d, "Bluetooth Controller (ALPS/UGPZ6)" },
    { 0x044e3010, "Bluetooth Adapter" },
    { 0x044e3017, "BCM2046 Bluetooth Device" },
    { 0x044effff, "Compaq Bluetooth Multiport Module" },
    { 0x044f0400, "HOTAS Cougar" },
    { 0x044f0402, "HOTAS Warthog Joystick" },
    { 0x044f0404, "HOTAS Warthog Throttle" },
    { 0x044f044f, "GP XID" },
    { 0x044f0f00, "Steering Wheel for Xbox" },
    { 0x044f0f03, "Steering Wheel for Xbox" },
    { 0x044f0f07, "Controller for Xbox" },
    { 0x044f0f0c, "Xbox Memory Unit (8MB)" },
    { 0x044f0f10, "Modena GT Wheel" },
    { 0x044fa003, "Rage 3D Game Pad" },
    { 0x044fa01b, "PK-GP301 Driving Wheel" },
    { 0x044fa0a0, "Top Gun Joystick" },
    { 0x044fa0a1, "Top Gun Joystick (rev2)" },
    { 0x044fa0a3, "Fusion Digital GamePad" },
    { 0x044fa201, "PK-GP201 PlayStick" },
    { 0x044fb108, "T-Flight Hotas X Flight Stick" },
    { 0x044fb10a, "T.16000M Joystick" },
    { 0x044fb203, "360 Modena Pro Wheel" },
    { 0x044fb300, "Firestorm Dual Power" },
    { 0x044fb303, "FireStorm Dual Analog 2" },
    { 0x044fb304, "Firestorm Dual Power" },
    { 0x044fb307, "vibrating Upad" },
    { 0x044fb30b, "Wireless VibrationPad" },
    { 0x044fb315, "Firestorm Dual Analog 3" },
    { 0x044fb320, "Dual Trigger gamepad PC/PS2 2.0" },
    { 0x044fb323, "Dual Trigger 3-in-1 (PC Mode)" },
    { 0x044fb324, "Dual Trigger 3-in-1 (PS3 Mode)" },
    { 0x044fb326, "Gamepad GP XID" },
    { 0x044fb351, "F16 MFD 1" },
    { 0x044fb352, "F16 MFD 2" },
    { 0x044fb365, "UbiSoft UbiConnect" },
    { 0x044fb603, "force feedback Wheel" },
    { 0x044fb605, "force feedback Racing Wheel" },
    { 0x044fb651, "Ferrari GT Rumble Force Wheel" },
    { 0x044fb653, "RGT Force Feedback Clutch Racing Wheel" },
    { 0x044fb654, "Ferrari GT Force Feedback Wheel" },
    { 0x044fb678, "T.Flight Rudder Pedals" },
    { 0x044fb679, "T-Rudder" },
    { 0x044fb687, "TWCS Throttle" },
    { 0x044fb700, "Tacticalboard" },
    { 0x04510422, "TUSB422 Port Controller with Power Delivery" },
    { 0x04511234, "Bluetooth Device" },
    { 0x04511428, "Hub" },
    { 0x04511446, "TUSB2040/2070 Hub" },
    { 0x045116a2, "CC Debugger" },
    { 0x045116a6, "BM-USBD1 BlueRobin RF heart rate sensor receiver" },
    { 0x045116a8, "CC2531 ZigBee" },
    { 0x045116ae, "CC2531 Dongle" },
    { 0x04512036, "TUSB2036 Hub" },
    { 0x04512046, "TUSB2046 Hub" },
    { 0x04512077, "TUSB2077 Hub" },
    { 0x04512f90, "SM-USB-DIG" },
    { 0x04513200, "TUSB3200 Boot Loader" },
    { 0x04513410, "TUSB3410 Microcontroller" },
    { 0x04513f00, "OMAP1610" },
    { 0x04513f02, "SMC WSKP100 Wi-Fi Phone" },
    { 0x0451505f, "TUSB5052 Serial" },
    { 0x04515153, "TUSB5052 Hub" },
    { 0x04515409, "Frontier Labs NEX IA+ Digital Audio Player" },
    { 0x04516000, "AU5 ADSL Modem (pre-reenum)" },
    { 0x04516001, "AU5 ADSL Modem" },
    { 0x04516060, "RNDIS/BeWAN ADSL2+" },
    { 0x04516070, "RNDIS/BeWAN ADSL2+" },
    { 0x0451625f, "TUSB6250 ATA Bridge" },
    { 0x04518041, "Hub" },
    { 0x04518042, "Hub" },
    { 0x04518043, "Hub" },
    { 0x04518140, "TUSB8041 4-Port Hub" },
    { 0x04518142, "TUSB8041 4-Port Hub" },
    { 0x0451926b, "TUSB9260 Boot Loader" },
    { 0x0451bef3, "CC1352R1 Launchpad" },
    { 0x0451dbc0, "Device Bay Controller" },
    { 0x0451e001, "GraphLink [SilverLink]" },
    { 0x0451e003, "TI-84 Plus Calculator" },
    { 0x0451e004, "TI-89 Titanium Calculator" },
    { 0x0451e008, "TI-84 Plus Silver Calculator" },
    { 0x0451e00e, "TI-89 Titanium Presentation Link" },
    { 0x0451e00f, "TI-84 Plus Presentation Link" },
    { 0x0451e010, "TI SmartPad Keyboard" },
    { 0x0451e011, "Nspire CAS+ prototype" },
    { 0x0451e012, "TI-Nspire Calculator" },
    { 0x0451e013, "Network Bridge" },
    { 0x0451e01c, "Data Collection Sled [Nspire Lab Cradle, Nspire Datatracker Cradle]" },
    { 0x0451e01e, "Nspire CX Navigator Access Point" },
    { 0x0451e01f, "Python Adapter (firmware install mode)" },
    { 0x0451e020, "Python Adapter" },
    { 0x0451e022, "Nspire CX II" },
    { 0x0451f430, "MSP-FET430UIF JTAG Tool" },
    { 0x0451f432, "eZ430 Development Tool" },
    { 0x0451ffff, "Bluetooth Device" },
    { 0x04520021, "HID Monitor Controls" },
    { 0x04520050, "Diamond Pro 900u CRT Monitor" },
    { 0x04520051, "Integrated Hub" },
    { 0x04520100, "Control Panel for Leica TCS SP5" },
    { 0x04536781, "NMB Keyboard" },
    { 0x04536783, "Chicony Composite Keyboard" },
    { 0x0456f000, "FT2232 JTAG ICE [gnICE]" },
    { 0x0456f001, "FT2232H Hi-Speed JTAG ICE [gnICE+]" },
    { 0x04570150, "Super Talent 1GB Flash Drive" },
    { 0x04570151, "Super Flash 1GB / GXT  64MB Flash Drive" },
    { 0x04570162, "SiS162 usb Wireless LAN Adapter" },
    { 0x04570163, "SiS163U 802.11 Wireless LAN Adapter" },
    { 0x04570817, "SiS-184-ASUS-4352.17 touch panel" },
    { 0x045710e1, "HID Touch Controller" },
    { 0x04575401, "Wireless Adapter RO80211GS-USB" },
    { 0x04580001, "Mouse" },
    { 0x04580002, "Genius NetMouse Pro" },
    { 0x04580003, "Genius NetScroll+" },
    { 0x04580006, "Easy Mouse+" },
    { 0x04580007, "Trackbar Emotion" },
    { 0x0458000b, "NetMouse Wheel(P+U)" },
    { 0x0458000c, "TACOMA Fingerprint V1.06.01" },
    { 0x0458000e, "Genius NetScroll Optical" },
    { 0x04580013, "TACOMA Fingerprint Mouse V1.06.01" },
    { 0x0458001a, "Genius WebScroll+" },
    { 0x0458002e, "NetScroll + Traveler / NetScroll 110" },
    { 0x04580036, "Pocket Mouse LE" },
    { 0x04580039, "NetScroll+ Superior" },
    { 0x0458003a, "NetScroll+ Mini Traveler / Genius NetScroll 120" },
    { 0x0458004c, "Slimstar Pro Keyboard" },
    { 0x04580056, "Ergo 300 Mouse" },
    { 0x04580057, "Enhanced Gaming Device" },
    { 0x04580059, "Enhanced Laser Device" },
    { 0x0458005a, "Enhanced Device" },
    { 0x0458005b, "Enhanced Device" },
    { 0x0458005c, "Enhanced Laser Gaming Device" },
    { 0x0458005d, "Enhanced Device" },
    { 0x04580061, "Bluetooth Dongle" },
    { 0x04580066, "Genius Traveler 1000 Wireless Mouse" },
    { 0x04580072, "Navigator 335" },
    { 0x04580083, "Bluetooth Dongle" },
    { 0x04580087, "Ergo 525V Laser Mouse" },
    { 0x04580088, "Genius Traveler 515 Laser" },
    { 0x04580089, "Genius Traveler 350" },
    { 0x045800ca, "Pen Mouse" },
    { 0x04580100, "EasyPen Tablet" },
    { 0x04580101, "CueCat" },
    { 0x0458011b, "NetScroll T220" },
    { 0x04580186, "Genius DX-120 Mouse" },
    { 0x04581001, "Joystick" },
    { 0x04581002, "Game Pad" },
    { 0x04581003, "Genius VideoCam" },
    { 0x04581004, "Flight2000 F-23 Joystick" },
    { 0x0458100a, "Aashima Technology Trust Sight Fighter Vibration Feedback Joystick" },
    { 0x04582001, "ColorPage-Vivid Pro Scanner" },
    { 0x04582004, "ColorPage-HR6 V1 Scanner" },
    { 0x04582005, "ColorPage-HR6/Vivid3" },
    { 0x04582007, "ColorPage-HR6 V2 Scanner" },
    { 0x04582008, "ColorPage-HR6 V2 Scanner" },
    { 0x04582009, "ColorPage-HR6A Scanner" },
    { 0x04582011, "ColorPage-Vivid3x Scanner" },
    { 0x04582012, "Plustek Scanner" },
    { 0x04582013, "ColorPage-HR7 Scanner" },
    { 0x04582014, "ColorPage-Vivid4" },
    { 0x04582015, "ColorPage-HR7LE Scanner" },
    { 0x04582016, "ColorPage-HR6X Scanner" },
    { 0x04582017, "ColorPage-Vivid3xe" },
    { 0x04582018, "ColorPage-HR7X" },
    { 0x04582019, "ColorPage-HR6X Slim" },
    { 0x0458201a, "ColorPage-Vivid4xe" },
    { 0x0458201b, "ColorPage-Vivid4x" },
    { 0x0458201c, "ColorPage-HR8" },
    { 0x0458201d, "ColorPage-Vivid 1200 X" },
    { 0x0458201e, "ColorPage-Slim 1200" },
    { 0x0458201f, "ColorPage-Vivid 1200 XE" },
    { 0x04582020, "ColorPage-Slim 1200 USB2" },
    { 0x04582021, "ColorPage-SF600" },
    { 0x04583017, "SPEED WHEEL 3 Vibration" },
    { 0x04583018, "Wireless 2.4Ghz Game Pad" },
    { 0x04583019, "10-Button USB Joystick with Vibration" },
    { 0x0458301a, "MaxFire G-12U Vibration" },
    { 0x0458301c, "Genius MaxFighter F-16U" },
    { 0x0458301d, "Genius MaxFire MiniPad" },
    { 0x0458400f, "Genius TVGo DVB-T02Q MCE" },
    { 0x04584012, "TVGo DVB-T03 [AF9015]" },
    { 0x04585003, "G-pen 560 Tablet" },
    { 0x04585004, "G-pen Tablet" },
    { 0x04585005, "Genius EasyPen M406" },
    { 0x04585012, "Genius EasyPen M406W" },
    { 0x04585014, "Genius EasyPen 340" },
    { 0x0458505e, "Genius iSlim 330" },
    { 0x04586001, "GF3000F Ethernet Adapter" },
    { 0x04587004, "VideoCAM Express V2" },
    { 0x04587006, "Dsc 1.3 Smart Camera Device" },
    { 0x04587007, "VideoCAM Web" },
    { 0x04587009, "G-Shot G312 Still Camera Device" },
    { 0x0458700c, "VideoCAM Web V3" },
    { 0x0458700d, "G-Shot G511 Composite Device" },
    { 0x0458700f, "VideoCAM Web" },
    { 0x04587012, "WebCAM USB2.0" },
    { 0x04587014, "VideoCAM Live V3" },
    { 0x0458701c, "G-Shot G512 Still Camera" },
    { 0x04587020, "Sim 321C" },
    { 0x04587025, "Eye 311Q Camera" },
    { 0x04587029, "Genius Look 320s (SN9C201 + HV7131R)" },
    { 0x0458702f, "Genius Slim 322" },
    { 0x04587035, "i-Look 325T Camera" },
    { 0x04587045, "Genius Look 1320 V2" },
    { 0x0458704c, "Genius i-Look 1321" },
    { 0x0458704d, "Slim 1322AF" },
    { 0x04587055, "Slim 2020AF camera" },
    { 0x0458705a, "Asus USB2.0 Webcam" },
    { 0x0458705c, "Genius iSlim 1300AF" },
    { 0x04587061, "Genius iLook 1321 V2" },
    { 0x04587066, "Acer Crystal Eye Webcam" },
    { 0x04587067, "Genius iSlim 1300AF V2" },
    { 0x04587068, "Genius eFace 1325R" },
    { 0x0458706d, "Genius iSlim 2000AF V2" },
    { 0x04587076, "Genius FaceCam 312" },
    { 0x04587079, "FaceCam 2025R" },
    { 0x0458707f, "TVGo DVB-T03 [RTL2832]" },
    { 0x04587088, "WideCam 1050" },
    { 0x04587089, "Genius FaceCam 320" },
    { 0x0458708c, "Genius WideCam F100" },
    { 0x045a07da, "Supra Express 56K modem" },
    { 0x045a0b4a, "SupraMax 2890 56K Modem [Lucent Atlas]" },
    { 0x045a0b68, "SupraMax 56K Modem" },
    { 0x045a5001, "Rio 600 MP3 Player" },
    { 0x045a5002, "Rio 800 MP3 Player" },
    { 0x045a5003, "Nike Psa/Play MP3 Player" },
    { 0x045a5005, "Rio S10 MP3 Player" },
    { 0x045a5006, "Rio S50 MP3 Player" },
    { 0x045a5007, "Rio S35 MP3 Player" },
    { 0x045a5008, "Rio 900 MP3 Player" },
    { 0x045a5009, "Rio S30 MP3 Player" },
    { 0x045a500d, "Fuse MP3 Player" },
    { 0x045a500e, "Chiba MP3 Player" },
    { 0x045a500f, "Cali MP3 Player" },
    { 0x045a5010, "Rio S11 MP3 Player" },
    { 0x045a501c, "Virgin MPF-1000" },
    { 0x045a501d, "Rio Fuse" },
    { 0x045a501e, "Rio Chiba" },
    { 0x045a501f, "Rio Cali" },
    { 0x045a503f, "Cali256 MP3 Player" },
    { 0x045a5042, "Rio Forge" },
    { 0x045a5202, "Rio Riot MP3 Player" },
    { 0x045a5210, "Rio Karma Music Player" },
    { 0x045a5220, "Rio Nitrus MP3 Player" },
    { 0x045a5221, "Rio Eigen" },
    { 0x045b0053, "RX610 RX-Stick" },
    { 0x045b0229, "mSATA Adapter [renkforce Pi-102]" },
    { 0x045e0007, "SideWinder Game Pad" },
    { 0x045e0008, "SideWinder Precision Pro" },
    { 0x045e0009, "IntelliMouse" },
    { 0x045e000b, "Natural Keyboard Elite" },
    { 0x045e000e, "SideWinder\302\256 Freestyle Pro" },
    { 0x045e0014, "Digital Sound System 80" },
    { 0x045e001a, "SideWinder Precision Racing Wheel" },
    { 0x045e001b, "SideWinder Force Feedback 2 Joystick" },
    { 0x045e001c, "Internet Keyboard Pro" },
    { 0x045e001d, "Natural Keyboard Pro" },
    { 0x045e001e, "IntelliMouse Explorer" },
    { 0x045e0023, "Trackball Optical" },
    { 0x045e0024, "Trackball Explorer" },
    { 0x045e0025, "IntelliEye Mouse" },
    { 0x045e0026, "SideWinder GamePad Pro" },
    { 0x045e0027, "SideWinder PnP GamePad" },
    { 0x045e0028, "SideWinder Dual Strike" },
    { 0x045e0029, "IntelliMouse Optical" },
    { 0x045e002b, "Internet Keyboard Pro" },
    { 0x045e002d, "Internet Keyboard" },
    { 0x045e002f, "Integrated Hub" },
    { 0x045e0033, "Sidewinder Strategic Commander" },
    { 0x045e0034, "SideWinder Force Feedback Wheel" },
    { 0x045e0038, "SideWinder Precision 2" },
    { 0x045e0039, "IntelliMouse Optical" },
    { 0x045e003b, "SideWinder Game Voice" },
    { 0x045e003c, "SideWinder Joystick" },
    { 0x045e0040, "Wheel Mouse Optical" },
    { 0x045e0047, "IntelliMouse Explorer 3.0" },
    { 0x045e0048, "Office Keyboard 1.0A" },
    { 0x045e0053, "Optical Mouse" },
    { 0x045e0059, "Wireless IntelliMouse Explorer" },
    { 0x045e005c, "Office Keyboard (106/109)" },
    { 0x045e005f, "Wireless MultiMedia Keyboard" },
    { 0x045e0061, "Wireless MultiMedia Keyboard (106/109)" },
    { 0x045e0063, "Wireless Natural MultiMedia Keyboard" },
    { 0x045e0065, "Wireless Natural MultiMedia Keyboard (106/109)" },
    { 0x045e006a, "Wireless Optical Mouse (IntelliPoint)" },
    { 0x045e006d, "eHome Remote Control Keyboard keys" },
    { 0x045e006e, "MN-510 802.11b Wireless Adapter [Intersil ISL3873B]" },
    { 0x045e006f, "Smart Display Reference Device" },
    { 0x045e0070, "Wireless MultiMedia Keyboard" },
    { 0x045e0071, "Wireless MultiMedia Keyboard (106/109)" },
    { 0x045e0072, "Wireless Natural MultiMedia Keyboard" },
    { 0x045e0073, "Wireless Natural MultiMedia Keyboard (106/109)" },
    { 0x045e0079, "IXI Ogo CT-17 handheld device" },
    { 0x045e007a, "10/100 USB NIC" },
    { 0x045e007d, "Notebook Optical Mouse" },
    { 0x045e007e, "Wireless Transceiver for Bluetooth" },
    { 0x045e0080, "Digital Media Pro Keyboard" },
    { 0x045e0083, "Basic Optical Mouse" },
    { 0x045e0084, "Basic Optical Mouse" },
    { 0x045e008a, "Wireless Optical Desktop Receiver 2.0A" },
    { 0x045e008b, "Dual Receiver Wireless Mouse (IntelliPoint)" },
    { 0x045e008c, "Wireless Intellimouse Explorer 2.0" },
    { 0x045e0095, "IntelliMouse Explorer 4.0 (IntelliPoint)" },
    { 0x045e009c, "Wireless Transceiver for Bluetooth 2.0" },
    { 0x045e009d, "Wireless Optical Desktop 3.0" },
    { 0x045e00a0, "eHome Infrared Receiver" },
    { 0x045e00a4, "Compact Optical Mouse, model 1016" },
    { 0x045e00b0, "Digital Media Pro Keyboard" },
    { 0x045e00b4, "Digital Media Keyboard 1.0A" },
    { 0x045e00b9, "Wireless Optical Mouse 3.0" },
    { 0x045e00bb, "Fingerprint Reader" },
    { 0x045e00bc, "Fingerprint Reader" },
    { 0x045e00bd, "Fingerprint Reader" },
    { 0x045e00c2, "MN-710 802.11g Wireless Adapter [Intersil ISL3886]" },
    { 0x045e00c9, "Microsoft/Intel Bandon Portable Media Center" },
    { 0x045e00ca, "Fingerprint Reader" },
    { 0x045e00cb, "Basic Optical Mouse v2.0" },
    { 0x045e00ce, "Generic PPC Flash device" },
    { 0x045e00d1, "Optical Mouse with Tilt Wheel" },
    { 0x045e00d2, "Notebook Optical Mouse with Tilt Wheel" },
    { 0x045e00da, "eHome Infrared Receiver" },
    { 0x045e00db, "Natural Ergonomic Keyboard 4000 V1.0" },
    { 0x045e00dd, "Comfort Curve Keyboard 2000 V1.0" },
    { 0x045e00e1, "Wireless Laser Mouse 6000 Receiver" },
    { 0x045e00f4, "LifeCam VX-6000 (SN9C20x + OV9650)" },
    { 0x045e00f5, "LifeCam VX-3000" },
    { 0x045e00f6, "Comfort Optical Mouse 1000" },
    { 0x045e00f7, "LifeCam VX-1000" },
    { 0x045e00f8, "LifeCam NX-6000" },
    { 0x045e00f9, "Wireless Desktop Receiver 3.1" },
    { 0x045e0202, "Xbox Controller" },
    { 0x045e0280, "Xbox Memory Unit (8MB)" },
    { 0x045e0283, "Xbox Communicator" },
    { 0x045e0284, "Xbox DVD Playback Kit" },
    { 0x045e0285, "Xbox Controller S" },
    { 0x045e0288, "Xbox Controller S Hub" },
    { 0x045e0289, "Xbox Controller S" },
    { 0x045e028b, "Xbox360 DVD Emulator" },
    { 0x045e028d, "Xbox360 Memory Unit 64MB" },
    { 0x045e028e, "Xbox360 Controller" },
    { 0x045e028f, "Xbox360 Wireless Controller" },
    { 0x045e0290, "Xbox360 Performance Pipe (PIX)" },
    { 0x045e0291, "Xbox 360 Wireless Receiver for Windows" },
    { 0x045e0292, "Xbox360 Wireless Networking Adapter" },
    { 0x045e029c, "Xbox360 HD-DVD Drive" },
    { 0x045e029d, "Xbox360 HD-DVD Drive" },
    { 0x045e029e, "Xbox360 HD-DVD Memory Unit" },
    { 0x045e02a0, "Xbox360 Big Button IR" },
    { 0x045e02a1, "Xbox 360 Wireless Receiver for Windows" },
    { 0x045e02a8, "Xbox360 Wireless N Networking Adapter [Atheros AR7010+AR9280]" },
    { 0x045e02ad, "Xbox NUI Audio" },
    { 0x045e02ae, "Xbox NUI Camera" },
    { 0x045e02b0, "Xbox NUI Motor" },
    { 0x045e02b6, "Xbox360 Bluetooth Wireless Headset" },
    { 0x045e02bb, "Kinect Audio" },
    { 0x045e02be, "Kinect for Windows NUI Audio" },
    { 0x045e02bf, "Kinect for Windows NUI Camera" },
    { 0x045e02c2, "Kinect for Windows NUI Motor" },
    { 0x045e02d1, "Xbox One Controller" },
    { 0x045e02d5, "Xbox One Digital TV Tuner" },
    { 0x045e02dd, "Xbox One Controller (Firmware 2015)" },
    { 0x045e02e3, "Xbox One Elite Controller" },
    { 0x045e02e6, "Wireless XBox Controller Dongle" },
    { 0x045e02ea, "Xbox One S Controller" },
    { 0x045e02fd, "Xbox One S Controller [Bluetooth]" },
    { 0x045e0400, "Windows Powered Pocket PC 2002" },
    { 0x045e0401, "Windows Powered Pocket PC 2002" },
    { 0x045e0402, "Windows Powered Pocket PC 2002" },
    { 0x045e0403, "Windows Powered Pocket PC 2002" },
    { 0x045e0404, "Windows Powered Pocket PC 2002" },
    { 0x045e0405, "Windows Powered Pocket PC 2002" },
    { 0x045e0406, "Windows Powered Pocket PC 2002" },
    { 0x045e0407, "Windows Powered Pocket PC 2002" },
    { 0x045e0408, "Windows Powered Pocket PC 2002" },
    { 0x045e0409, "Windows Powered Pocket PC 2002" },
    { 0x045e040a, "Windows Powered Pocket PC 2002" },
    { 0x045e040b, "Windows Powered Pocket PC 2002" },
    { 0x045e040c, "Windows Powered Pocket PC 2002" },
    { 0x045e040d, "Windows Powered Pocket PC 2002" },
    { 0x045e040e, "Windows Powered Pocket PC 2002" },
    { 0x045e040f, "Windows Powered Pocket PC 2002" },
    { 0x045e0410, "Windows Powered Pocket PC 2002" },
    { 0x045e0411, "Windows Powered Pocket PC 2002" },
    { 0x045e0412, "Windows Powered Pocket PC 2002" },
    { 0x045e0413, "Windows Powered Pocket PC 2002" },
    { 0x045e0414, "Windows Powered Pocket PC 2002" },
    { 0x045e0415, "Windows Powered Pocket PC 2002" },
    { 0x045e0416, "Windows Powered Pocket PC 2002" },
    { 0x045e0417, "Windows Powered Pocket PC 2002" },
    { 0x045e0432, "Windows Powered Pocket PC 2003" },
    { 0x045e0433, "Windows Powered Pocket PC 2003" },
    { 0x045e0434, "Windows Powered Pocket PC 2003" },
    { 0x045e0435, "Windows Powered Pocket PC 2003" },
    { 0x045e0436, "Windows Powered Pocket PC 2003" },
    { 0x045e0437, "Windows Powered Pocket PC 2003" },
    { 0x045e0438, "Windows Powered Pocket PC 2003" },
    { 0x045e0439, "Windows Powered Pocket PC 2003" },
    { 0x045e043a, "Windows Powered Pocket PC 2003" },
    { 0x045e043b, "Windows Powered Pocket PC 2003" },
    { 0x045e043c, "Windows Powered Pocket PC 2003" },
    { 0x045e043d, "Becker Traffic Assist Highspeed 7934" },
    { 0x045e043e, "Windows Powered Pocket PC 2003" },
    { 0x045e043f, "Windows Powered Pocket PC 2003" },
    { 0x045e0440, "Windows Powered Pocket PC 2003" },
    { 0x045e0441, "Windows Powered Pocket PC 2003" },
    { 0x045e0442, "Windows Powered Pocket PC 2003" },
    { 0x045e0443, "Windows Powered Pocket PC 2003" },
    { 0x045e0444, "Windows Powered Pocket PC 2003" },
    { 0x045e0445, "Windows Powered Pocket PC 2003" },
    { 0x045e0446, "Windows Powered Pocket PC 2003" },
    { 0x045e0447, "Windows Powered Pocket PC 2003" },
    { 0x045e0448, "Windows Powered Pocket PC 2003" },
    { 0x045e0449, "Windows Powered Pocket PC 2003" },
    { 0x045e044a, "Windows Powered Pocket PC 2003" },
    { 0x045e044b, "Windows Powered Pocket PC 2003" },
    { 0x045e044c, "Windows Powered Pocket PC 2003" },
    { 0x045e044d, "Windows Powered Pocket PC 2003" },
    { 0x045e044e, "Windows Powered Pocket PC 2003" },
    { 0x045e044f, "Windows Powered Pocket PC 2003" },
    { 0x045e0450, "Windows Powered Pocket PC 2003" },
    { 0x045e0451, "Windows Powered Pocket PC 2003" },
    { 0x045e0452, "Windows Powered Pocket PC 2003" },
    { 0x045e0453, "Windows Powered Pocket PC 2003" },
    { 0x045e0454, "Windows Powered Pocket PC 2003" },
    { 0x045e0455, "Windows Powered Pocket PC 2003" },
    { 0x045e0456, "Windows Powered Pocket PC 2003" },
    { 0x045e0457, "Windows Powered Pocket PC 2003" },
    { 0x045e0458, "Windows Powered Pocket PC 2003" },
    { 0x045e0459, "Windows Powered Pocket PC 2003" },
    { 0x045e045a, "Windows Powered Pocket PC 2003" },
    { 0x045e045b, "Windows Powered Pocket PC 2003" },
    { 0x045e045c, "Windows Powered Pocket PC 2003" },
    { 0x045e045d, "Windows Powered Pocket PC 2003" },
    { 0x045e045e, "Windows Powered Pocket PC 2003" },
    { 0x045e045f, "Windows Powered Pocket PC 2003" },
    { 0x045e0460, "Windows Powered Pocket PC 2003" },
    { 0x045e0461, "Windows Powered Pocket PC 2003" },
    { 0x045e0462, "Windows Powered Pocket PC 2003" },
    { 0x045e0463, "Windows Powered Pocket PC 2003" },
    { 0x045e0464, "Windows Powered Pocket PC 2003" },
    { 0x045e0465, "Windows Powered Pocket PC 2003" },
    { 0x045e0466, "Windows Powered Pocket PC 2003" },
    { 0x045e0467, "Windows Powered Pocket PC 2003" },
    { 0x045e0468, "Windows Powered Pocket PC 2003" },
    { 0x045e0469, "Windows Powered Pocket PC 2003" },
    { 0x045e046a, "Windows Powered Pocket PC 2003" },
    { 0x045e046b, "Windows Powered Pocket PC 2003" },
    { 0x045e046c, "Windows Powered Pocket PC 2003" },
    { 0x045e046d, "Windows Powered Pocket PC 2003" },
    { 0x045e046e, "Windows Powered Pocket PC 2003" },
    { 0x045e046f, "Windows Powered Pocket PC 2003" },
    { 0x045e0470, "Windows Powered Pocket PC 2003" },
    { 0x045e0471, "Windows Powered Pocket PC 2003" },
    { 0x045e0472, "Windows Powered Pocket PC 2003" },
    { 0x045e0473, "Windows Powered Pocket PC 2003" },
    { 0x045e0474, "Windows Powered Pocket PC 2003" },
    { 0x045e0475, "Windows Powered Pocket PC 2003" },
    { 0x045e0476, "Windows Powered Pocket PC 2003" },
    { 0x045e0477, "Windows Powered Pocket PC 2003" },
    { 0x045e0478, "Windows Powered Pocket PC 2003" },
    { 0x045e0479, "Windows Powered Pocket PC 2003" },
    { 0x045e047a, "Windows Powered Pocket PC 2003" },
    { 0x045e047b, "Windows Powered Pocket PC 2003" },
    { 0x045e04c8, "Windows Powered Smartphone 2002" },
    { 0x045e04c9, "Windows Powered Smartphone 2002" },
    { 0x045e04ca, "Windows Powered Smartphone 2002" },
    { 0x045e04cb, "Windows Powered Smartphone 2002" },
    { 0x045e04cc, "Windows Powered Smartphone 2002" },
    { 0x045e04cd, "Windows Powered Smartphone 2002" },
    { 0x045e04ce, "Windows Powered Smartphone 2002" },
    { 0x045e04d7, "Windows Powered Smartphone 2003" },
    { 0x045e04d8, "Windows Powered Smartphone 2003" },
    { 0x045e04d9, "Windows Powered Smartphone 2003" },
    { 0x045e04da, "Windows Powered Smartphone 2003" },
    { 0x045e04db, "Windows Powered Smartphone 2003" },
    { 0x045e04dc, "Windows Powered Smartphone 2003" },
    { 0x045e04dd, "Windows Powered Smartphone 2003" },
    { 0x045e04de, "Windows Powered Smartphone 2003" },
    { 0x045e04df, "Windows Powered Smartphone 2003" },
    { 0x045e04e0, "Windows Powered Smartphone 2003" },
    { 0x045e04e1, "Windows Powered Smartphone 2003" },
    { 0x045e04e2, "Windows Powered Smartphone 2003" },
    { 0x045e04e3, "Windows Powered Smartphone 2003" },
    { 0x045e04e4, "Windows Powered Smartphone 2003" },
    { 0x045e04e5, "Windows Powered Smartphone 2003" },
    { 0x045e04e6, "Windows Powered Smartphone 2003" },
    { 0x045e04e7, "Windows Powered Smartphone 2003" },
    { 0x045e04e8, "Windows Powered Smartphone 2003" },
    { 0x045e04e9, "Windows Powered Smartphone 2003" },
    { 0x045e04ea, "Windows Powered Smartphone 2003" },
    { 0x045e04ec, "Microsoft Windows Phone" },
    { 0x045e0622, "Microsoft Windows MTP Simulator" },
    { 0x045e063e, "Microsoft Zune HD" },
    { 0x045e0640, "Microsoft Kin 1" },
    { 0x045e0641, "Microsoft/Sharp/nVidia Kin TwoM" },
    { 0x045e0642, "KIN Phone" },
    { 0x045e0707, "Wireless Laser Mouse 8000" },
    { 0x045e0708, "Transceiver v 3.0 for Bluetooth" },
    { 0x045e070a, "Charon Bluetooth Dongle (DFU)" },
    { 0x045e070f, "LifeChat LX-3000 Headset" },
    { 0x045e0710, "Microsoft Zune" },
    { 0x045e0713, "Wireless Presenter Mouse 8000" },
    { 0x045e0719, "Xbox 360 Wireless Adapter" },
    { 0x045e071f, "Mouse/Keyboard 2.4GHz Transceiver V2.0" },
    { 0x045e0721, "LifeCam NX-3000 (UVC-compliant)" },
    { 0x045e0723, "LifeCam VX-7000 (UVC-compliant)" },
    { 0x045e0724, "SideWinder Mouse" },
    { 0x045e0728, "LifeCam VX-5000" },
    { 0x045e0730, "Digital Media Keyboard 3000" },
    { 0x045e0734, "Wireless Optical Desktop 700" },
    { 0x045e0736, "Sidewinder X5 Mouse" },
    { 0x045e0737, "Compact Optical Mouse 500" },
    { 0x045e0745, "Nano Transceiver v1.0 for Bluetooth" },
    { 0x045e074a, "LifeCam VX-500 [1357]" },
    { 0x045e0750, "Wired Keyboard 600" },
    { 0x045e0752, "Wired Keyboard 400" },
    { 0x045e075d, "LifeCam Cinema" },
    { 0x045e0761, "LifeCam VX-2000" },
    { 0x045e0765, "Xbox360 Slim Internal Wireless Module (1400) [Marvell 88W8786U]" },
    { 0x045e0766, "LifeCam VX-800" },
    { 0x045e0768, "Sidewinder X4" },
    { 0x045e076c, "Comfort Mouse 4500" },
    { 0x045e076d, "LifeCam HD-5000" },
    { 0x045e0770, "LifeCam VX-700" },
    { 0x045e0772, "LifeCam Studio" },
    { 0x045e0779, "LifeCam HD-3000" },
    { 0x045e077f, "LifeChat LX-6000 Headset" },
    { 0x045e0780, "Comfort Curve Keyboard 3000" },
    { 0x045e0797, "Optical Mouse 200" },
    { 0x045e0799, "Surface Pro embedded keyboard" },
    { 0x045e07a5, "Wireless Receiver 1461C" },
    { 0x045e07b2, "2.4GHz Transceiver v8.0 used by mouse Wireless Desktop 900" },
    { 0x045e07b6, "Comfort Curve Keyboard 3000" },
    { 0x045e07b9, "Wired Keyboard 200" },
    { 0x045e07c6, "RTL8153 GigE [Surface Ethernet Adapter]" },
    { 0x045e07ca, "Surface Pro 3 Docking Station Audio Device" },
    { 0x045e07cd, "Surface Keyboard" },
    { 0x045e07f8, "Wired Keyboard 600 (model 1576)" },
    { 0x045e07fd, "Nano Transceiver 1.1" },
    { 0x045e0800, "Wireless keyboard (All-in-One-Media)" },
    { 0x045e0810, "LifeCam HD-3000" },
    { 0x045e0823, "Classic IntelliMouse" },
    { 0x045e0900, "Surface Dock Hub" },
    { 0x045e0901, "Surface Dock Hub" },
    { 0x045e0902, "Surface Dock Hub" },
    { 0x045e0903, "Surface Dock Hub" },
    { 0x045e0904, "Surface Dock Extender" },
    { 0x045e0905, "Surface Dock Audio" },
    { 0x045e090b, "Hub" },
    { 0x045e090c, "SD Card" },
    { 0x045e091a, "Hub" },
    { 0x045e0927, "RTL8153B GigE [Surface Ethernet Adapter]" },
    { 0x045e0955, "Hub" },
    { 0x045e0957, "Hub" },
    { 0x045e09a0, "RTL8153B GigE [Surface Ethernet Adapter]" },
    { 0x045e09c0, "Surface Type Cover" },
    { 0x045e0a00, "Lumia 950 Dual SIM (RM-1118)" },
    { 0x045e930a, "ISOUSB.SYS Intel 82930 Isochronous IO Test Board" },
    { 0x045effca, "Catalina" },
    { 0x045efff8, "Keyboard" },
    { 0x045effff, "Windows CE Mass Storage" },
    { 0x04600004, "Tablet (5x3.75)" },
    { 0x04600006, "LCD Tablet (12x9)" },
    { 0x04600008, "Tablet (3x2.25)" },
    { 0x04610010, "HP PR1101U / Primax PMX-KPR1101U Keyboard" },
    { 0x04610300, "G2-300 Scanner" },
    { 0x04610301, "G2E-300 Scanner" },
    { 0x04610302, "G2-300 #2 Scanner" },
    { 0x04610303, "G2E-300 #2 Scanner" },
    { 0x04610340, "Colorado 9600 Scanner" },
    { 0x04610341, "Colorado 600u Scanner" },
    { 0x04610345, "Visioneer 6200 Scanner" },
    { 0x04610346, "Memorex Maxx 6136u Scanner" },
    { 0x04610347, "Primascan Colorado 2600u/Visioneer 4400 Scanner" },
    { 0x04610360, "Colorado 19200 Scanner" },
    { 0x04610361, "Colorado 1200u Scanner" },
    { 0x04610363, "VistaScan Astra 3600(ENG)" },
    { 0x04610364, "LG Electronics Scanworks 600U Scanner" },
    { 0x04610365, "VistaScan Astra 3600(ENG)" },
    { 0x04610366, "6400" },
    { 0x04610367, "VistaScan Astra 3600(ENG)" },
    { 0x04610371, "Visioneer Onetouch 8920 Scanner" },
    { 0x04610374, "UMAX Astra 2500" },
    { 0x04610375, "VistaScan Astra 3600(ENG)" },
    { 0x04610377, "Medion MD 5345 Scanner" },
    { 0x04610378, "VistaScan Astra 3600(ENG)" },
    { 0x0461037b, "Medion MD 6190 Scanner" },
    { 0x0461037c, "VistaScan Astra 3600(ENG)" },
    { 0x04610380, "G2-600 Scanner" },
    { 0x04610381, "ReadyScan 636i Scanner" },
    { 0x04610382, "G2-600 #2 Scanner" },
    { 0x04610383, "G2E-600 Scanner" },
    { 0x0461038a, "UMAX Astra 3000/3600" },
    { 0x0461038b, "Xerox 2400 Onetouch" },
    { 0x0461038c, "UMAX Astra 4100" },
    { 0x04610392, "Medion/Lifetec/Tevion/Cytron MD 6190" },
    { 0x046103a8, "9420M" },
    { 0x04610813, "IBM UltraPort Camera" },
    { 0x04610815, "Micro Innovations IC200 Webcam" },
    { 0x04610819, "Fujifilm IX-30 Camera [webcam mode]" },
    { 0x0461081a, "Fujifilm IX-30 Camera [storage mode]" },
    { 0x0461081c, "Elitegroup ECS-C11 Camera" },
    { 0x0461081d, "Elitegroup ECS-C11 Storage" },
    { 0x04610a00, "Micro Innovations Web Cam 320" },
    { 0x04614d01, "Comfort Keyboard / Kensington Orbit Elite" },
    { 0x04614d02, "Mouse-in-a-Box" },
    { 0x04614d03, "Kensington Mouse-in-a-box" },
    { 0x04614d04, "Mouse" },
    { 0x04614d06, "Balless Mouse (HID)" },
    { 0x04614d0f, "HP Optical Mouse" },
    { 0x04614d15, "Dell Optical Mouse" },
    { 0x04614d17, "Optical Mouse" },
    { 0x04614d20, "HP Optical Mouse" },
    { 0x04614d2a, "PoPo Elixir Mouse (HID)" },
    { 0x04614d2b, "Wireless Laser Mini Mouse (HID)" },
    { 0x04614d2c, "PoPo Mini Pointer Mouse (HID)" },
    { 0x04614d2e, "Optical Mobile Mouse (HID)" },
    { 0x04614d51, "0Y357C PMX-MMOCZUL (B) [Dell Laser Mouse]" },
    { 0x04614d62, "HP Laser Mobile Mini Mouse" },
    { 0x04614d75, "Rocketfish RF-FLBTAD Bluetooth Adapter" },
    { 0x04614d81, "Dell N889 Optical Mouse" },
    { 0x04614d8a, "HP Multimedia Keyboard" },
    { 0x04614d91, "Laser mouse M-D16DL" },
    { 0x04614d92, "Optical mouse M-D17DR" },
    { 0x04614db1, "Dell Laptop Integrated Webcam 2Mpix" },
    { 0x04614de3, "HP 5-Button Optical Comfort Mouse" },
    { 0x04614de7, "webcam" },
    { 0x04614e04, "Lenovo Keyboard KB1021" },
    { 0x04614e22, "Dell Mouse, 2 Buttons, Modell: MS111-P" },
    { 0x04614e6f, "Acer Wired Keyboard Model KBAY211" },
    { 0x04630001, "UPS" },
    { 0x0463ffff, "UPS" },
    { 0x046a0001, "Keyboard" },
    { 0x046a0003, "My3000 Hub" },
    { 0x046a0004, "CyBoard Keyboard" },
    { 0x046a0005, "XX33 SmartCard Reader Keyboard" },
    { 0x046a0008, "Wireless Keyboard and Mouse" },
    { 0x046a0010, "SmartBoard XX44" },
    { 0x046a0011, "G83 (RS 6000) Keyboard" },
    { 0x046a0021, "CyMotion Expert Combo" },
    { 0x046a0023, "Keyboard" },
    { 0x046a0027, "CyMotion Master Solar Keyboard" },
    { 0x046a002a, "Wireless Mouse & Keyboard" },
    { 0x046a002d, "SmartTerminal XX44" },
    { 0x046a003c, "Raptor Gaming Keyboard" },
    { 0x046a003d, "Raptor Gaming Keyboard Integrated Hub" },
    { 0x046a003e, "SmartTerminal ST-2xxx" },
    { 0x046a0041, "G86 6240 Keyboard" },
    { 0x046a0080, "eHealth Terminal ST 1503" },
    { 0x046a0081, "eHealth Keyboard G87 1504" },
    { 0x046a00a1, "SmartCard Reader Keyboard KC 1000 SC" },
    { 0x046a0106, "R-300 Wireless Mouse Receiver" },
    { 0x046a010d, "MX-Board 3.0 Keyboard" },
    { 0x046a0180, "Strait 3.0" },
    { 0x046ab090, "Keyboard" },
    { 0x046ab091, "Mouse" },
    { 0x046b0001, "Keyboard" },
    { 0x046b0101, "PS/2 Keyboard, Mouse & Joystick Ports" },
    { 0x046b0301, "USB 1.0 Hub" },
    { 0x046b0500, "Serial & Parallel Ports" },
    { 0x046bff10, "Virtual Keyboard and Mouse" },
    { 0x046d0082, "Acer Aspire 5672 Webcam" },
    { 0x046d0200, "WingMan Extreme Joystick" },
    { 0x046d0203, "M2452 Keyboard" },
    { 0x046d0242, "Chillstream for Xbox 360" },
    { 0x046d0301, "M4848 Mouse" },
    { 0x046d0401, "HP PageScan" },
    { 0x046d0402, "NEC PageScan" },
    { 0x046d040f, "Logitech/Storm PageScan" },
    { 0x046d0430, "Mic (Cordless)" },
    { 0x046d0801, "QuickCam Home" },
    { 0x046d0802, "Webcam C200" },
    { 0x046d0804, "Webcam C250" },
    { 0x046d0805, "Webcam C300" },
    { 0x046d0807, "Webcam B500" },
    { 0x046d0808, "Webcam C600" },
    { 0x046d0809, "Webcam Pro 9000" },
    { 0x046d080a, "Portable Webcam C905" },
    { 0x046d080f, "Webcam C120" },
    { 0x046d0810, "QuickCam Pro" },
    { 0x046d0819, "Webcam C210" },
    { 0x046d081a, "Webcam C260" },
    { 0x046d081b, "Webcam C310" },
    { 0x046d081d, "HD Webcam C510" },
    { 0x046d0820, "QuickCam VC" },
    { 0x046d0821, "HD Webcam C910" },
    { 0x046d0823, "HD Webcam B910" },
    { 0x046d0825, "Webcam C270" },
    { 0x046d0826, "HD Webcam C525" },
    { 0x046d0828, "HD Webcam B990" },
    { 0x046d082b, "Webcam C170" },
    { 0x046d082c, "HD Webcam C615" },
    { 0x046d082d, "HD Pro Webcam C920" },
    { 0x046d0830, "QuickClip" },
    { 0x046d0836, "B525 HD Webcam" },
    { 0x046d0837, "BCC950 ConferenceCam" },
    { 0x046d0840, "QuickCam Express" },
    { 0x046d0843, "Webcam C930e" },
    { 0x046d0850, "QuickCam Web" },
    { 0x046d085c, "C922 Pro Stream Webcam" },
    { 0x046d0870, "QuickCam Express" },
    { 0x046d0890, "QuickCam Traveler" },
    { 0x046d0892, "OrbiCam" },
    { 0x046d0894, "CrystalCam" },
    { 0x046d0895, "QuickCam for Dell Notebooks" },
    { 0x046d0896, "OrbiCam" },
    { 0x046d0897, "QuickCam for Dell Notebooks" },
    { 0x046d0899, "QuickCam for Dell Notebooks" },
    { 0x046d089d, "QuickCam E2500 series" },
    { 0x046d08a0, "QuickCam IM" },
    { 0x046d08a1, "QuickCam IM with sound" },
    { 0x046d08a2, "Labtec Webcam Pro" },
    { 0x046d08a3, "QuickCam QuickCam Chat" },
    { 0x046d08a6, "QuickCam IM" },
    { 0x046d08a7, "QuickCam Image" },
    { 0x046d08a9, "Notebook Deluxe" },
    { 0x046d08aa, "Labtec Notebooks" },
    { 0x046d08ac, "QuickCam Cool" },
    { 0x046d08ad, "QuickCam Communicate STX" },
    { 0x046d08ae, "QuickCam for Notebooks" },
    { 0x046d08af, "QuickCam Easy/Cool" },
    { 0x046d08b0, "QuickCam 3000 Pro [pwc]" },
    { 0x046d08b1, "QuickCam Notebook Pro" },
    { 0x046d08b2, "QuickCam Pro 4000" },
    { 0x046d08b3, "QuickCam Zoom" },
    { 0x046d08b4, "QuickCam Zoom" },
    { 0x046d08b5, "QuickCam Sphere" },
    { 0x046d08b9, "QuickCam IM" },
    { 0x046d08bd, "Microphone (Pro 4000)" },
    { 0x046d08c0, "QuickCam Pro 3000" },
    { 0x046d08c1, "QuickCam Fusion" },
    { 0x046d08c2, "QuickCam PTZ" },
    { 0x046d08c3, "Camera (Notebooks Pro)" },
    { 0x046d08c5, "QuickCam Pro 5000" },
    { 0x046d08c6, "QuickCam for DELL Notebooks" },
    { 0x046d08c7, "QuickCam OEM Cisco VT Camera II" },
    { 0x046d08c9, "QuickCam Ultra Vision" },
    { 0x046d08ca, "Mic (Fusion)" },
    { 0x046d08cb, "Mic (Notebooks Pro)" },
    { 0x046d08cc, "Mic (PTZ)" },
    { 0x046d08ce, "QuickCam Pro 5000" },
    { 0x046d08cf, "QuickCam UpdateMe" },
    { 0x046d08d0, "QuickCam Express" },
    { 0x046d08d7, "QuickCam Communicate STX" },
    { 0x046d08d8, "QuickCam for Notebook Deluxe" },
    { 0x046d08d9, "QuickCam IM/Connect" },
    { 0x046d08da, "QuickCam Messanger" },
    { 0x046d08dd, "QuickCam for Notebooks" },
    { 0x046d08e0, "QuickCam Express" },
    { 0x046d08e1, "Labtec Webcam" },
    { 0x046d08f0, "QuickCam Messenger" },
    { 0x046d08f1, "QuickCam Express" },
    { 0x046d08f2, "Microphone (Messenger)" },
    { 0x046d08f3, "QuickCam Express" },
    { 0x046d08f4, "Labtec Webcam" },
    { 0x046d08f5, "QuickCam Messenger Communicate" },
    { 0x046d08f6, "QuickCam Messenger Plus" },
    { 0x046d0900, "ClickSmart 310" },
    { 0x046d0901, "ClickSmart 510" },
    { 0x046d0903, "ClickSmart 820" },
    { 0x046d0905, "ClickSmart 820" },
    { 0x046d0910, "QuickCam Cordless" },
    { 0x046d0920, "QuickCam Express" },
    { 0x046d0921, "Labtec Webcam" },
    { 0x046d0922, "QuickCam Live" },
    { 0x046d0928, "QuickCam Express" },
    { 0x046d0929, "Labtec Webcam Pro" },
    { 0x046d092a, "QuickCam for Notebooks" },
    { 0x046d092b, "Labtec Webcam Plus" },
    { 0x046d092c, "QuickCam Chat" },
    { 0x046d092d, "QuickCam Express / Go" },
    { 0x046d092e, "QuickCam Chat" },
    { 0x046d092f, "QuickCam Express Plus" },
    { 0x046d0950, "Pocket Camera" },
    { 0x046d0960, "ClickSmart 420" },
    { 0x046d0970, "Pocket750" },
    { 0x046d0990, "QuickCam Pro 9000" },
    { 0x046d0991, "QuickCam Pro for Notebooks" },
    { 0x046d0992, "QuickCam Communicate Deluxe" },
    { 0x046d0994, "QuickCam Orbit/Sphere AF" },
    { 0x046d09a1, "QuickCam Communicate MP/S5500" },
    { 0x046d09a2, "QuickCam Communicate Deluxe/S7500" },
    { 0x046d09a4, "QuickCam E 3500" },
    { 0x046d09a5, "Quickcam 3000 For Business" },
    { 0x046d09a6, "QuickCam Vision Pro" },
    { 0x046d09b0, "Acer OrbiCam" },
    { 0x046d09b2, "Fujitsu Webcam" },
    { 0x046d09c0, "QuickCam for Dell Notebooks Mic" },
    { 0x046d09c1, "QuickCam Deluxe for Notebooks" },
    { 0x046d0a01, "USB Headset" },
    { 0x046d0a02, "Premium Stereo USB Headset 350" },
    { 0x046d0a03, "Logitech USB Microphone" },
    { 0x046d0a04, "V20 portable speakers (USB powered)" },
    { 0x046d0a07, "Z-10 Speakers" },
    { 0x046d0a0b, "ClearChat Pro USB" },
    { 0x046d0a0c, "Clear Chat Comfort USB Headset" },
    { 0x046d0a10, "V10 Notebook Speakers" },
    { 0x046d0a13, "Z-5 Speakers" },
    { 0x046d0a14, "USB Headset" },
    { 0x046d0a15, "G35 Headset" },
    { 0x046d0a17, "G330 Headset" },
    { 0x046d0a1f, "G930" },
    { 0x046d0a29, "H600 [Wireless Headset]" },
    { 0x046d0a37, "USB Headset H540" },
    { 0x046d0a38, "Headset H340" },
    { 0x046d0a44, "Headset H390" },
    { 0x046d0a45, "960 Headset" },
    { 0x046d0a4d, "G430 Surround Sound Gaming Headset" },
    { 0x046d0a5b, "G933 Wireless Headset Dongle" },
    { 0x046d0a5d, "G933 Headset Battery Charger" },
    { 0x046d0a66, "[G533 Wireless Headset Dongle]" },
    { 0x046d0b02, "C-UV35 [Bluetooth Mini-Receiver] (HID proxy mode)" },
    { 0x046d8801, "Video Camera" },
    { 0x046db014, "Bluetooth Mouse M336/M337/M535" },
    { 0x046db305, "BT Mini-Receiver" },
    { 0x046dbfe4, "Premium Optical Wheel Mouse" },
    { 0x046dc000, "N43 [Pilot Mouse]" },
    { 0x046dc001, "N48/M-BB48/M-UK96A [FirstMouse Plus]" },
    { 0x046dc002, "M-BA47 [MouseMan Plus]" },
    { 0x046dc003, "MouseMan" },
    { 0x046dc004, "WingMan Gaming Mouse" },
    { 0x046dc005, "WingMan Gaming Wheel Mouse" },
    { 0x046dc00b, "MouseMan Wheel" },
    { 0x046dc00c, "Optical Wheel Mouse" },
    { 0x046dc00d, "MouseMan Wheel+" },
    { 0x046dc00e, "M-BJ58/M-BJ69 Optical Wheel Mouse" },
    { 0x046dc00f, "MouseMan Traveler/Mobile" },
    { 0x046dc011, "Optical MouseMan" },
    { 0x046dc012, "Mouseman Dual Optical" },
    { 0x046dc014, "Corded Workstation Mouse" },
    { 0x046dc015, "Corded Workstation Mouse" },
    { 0x046dc016, "Optical Wheel Mouse" },
    { 0x046dc018, "Optical Wheel Mouse" },
    { 0x046dc019, "Optical Tilt Wheel Mouse" },
    { 0x046dc01a, "M-BQ85 Optical Wheel Mouse" },
    { 0x046dc01b, "MX310 Optical Mouse" },
    { 0x046dc01c, "Optical Mouse" },
    { 0x046dc01d, "MX510 Optical Mouse" },
    { 0x046dc01e, "MX518 Optical Mouse" },
    { 0x046dc024, "MX300 Optical Mouse" },
    { 0x046dc025, "MX500 Optical Mouse" },
    { 0x046dc030, "iFeel Mouse" },
    { 0x046dc031, "iFeel Mouse+" },
    { 0x046dc032, "MouseMan iFeel" },
    { 0x046dc033, "iFeel MouseMan+" },
    { 0x046dc034, "MouseMan Optical" },
    { 0x046dc035, "Mouse" },
    { 0x046dc036, "Mouse" },
    { 0x046dc037, "Mouse" },
    { 0x046dc038, "Mouse" },
    { 0x046dc03d, "M-BT96a Pilot Optical Mouse" },
    { 0x046dc03e, "Premium Optical Wheel Mouse (M-BT58)" },
    { 0x046dc03f, "M-BT85 [UltraX Optical Mouse]" },
    { 0x046dc040, "Corded Tilt-Wheel Mouse" },
    { 0x046dc041, "G5 Laser Mouse" },
    { 0x046dc042, "G3 Laser Mouse" },
    { 0x046dc043, "MX320/MX400 Laser Mouse" },
    { 0x046dc044, "LX3 Optical Mouse" },
    { 0x046dc045, "Optical Mouse" },
    { 0x046dc046, "RX1000 Laser Mouse" },
    { 0x046dc047, "Laser Mouse M-UAL120" },
    { 0x046dc048, "G9 Laser Mouse" },
    { 0x046dc049, "G5 Laser Mouse" },
    { 0x046dc050, "RX 250 Optical Mouse" },
    { 0x046dc051, "G3 (MX518) Optical Mouse" },
    { 0x046dc053, "Laser Mouse" },
    { 0x046dc054, "Bluetooth mini-receiver" },
    { 0x046dc058, "M115 Mouse" },
    { 0x046dc05a, "M90/M100 Optical Mouse" },
    { 0x046dc05b, "M-U0004 810-001317 [B110 Optical USB Mouse]" },
    { 0x046dc05d, "Optical Mouse" },
    { 0x046dc05f, "M115 Optical Mouse" },
    { 0x046dc061, "RX1500 Laser Mouse" },
    { 0x046dc062, "M-UAS144 [LS1 Laser Mouse]" },
    { 0x046dc063, "DELL Laser Mouse" },
    { 0x046dc064, "M110 corded optical mouse (M-B0001)" },
    { 0x046dc066, "G9x Laser Mouse" },
    { 0x046dc068, "G500 Laser Mouse" },
    { 0x046dc069, "M-U0007 [Corded Mouse M500]" },
    { 0x046dc06a, "USB Optical Mouse" },
    { 0x046dc06b, "G700 Wireless Gaming Mouse" },
    { 0x046dc06c, "Optical Mouse" },
    { 0x046dc077, "M105 Optical Mouse" },
    { 0x046dc07c, "M-R0017 [G700s Rechargeable Gaming Mouse]" },
    { 0x046dc07d, "G502 Mouse" },
    { 0x046dc07e, "G402 Gaming Mouse" },
    { 0x046dc080, "G303 Gaming Mouse" },
    { 0x046dc083, "G403 Prodigy Gaming Mouse" },
    { 0x046dc084, "G203 Gaming Mouse" },
    { 0x046dc08b, "G502 SE HERO Gaming Mouse" },
    { 0x046dc101, "UltraX Media Remote" },
    { 0x046dc110, "Harmony 785/880/885 Remote" },
    { 0x046dc111, "Harmony 525 Remote" },
    { 0x046dc112, "Harmony 890 Remote" },
    { 0x046dc11f, "Harmony 900/1100 Remote" },
    { 0x046dc121, "Harmony One Remote" },
    { 0x046dc122, "Harmony 650/700 Remote" },
    { 0x046dc124, "Harmony 300/350 Remote" },
    { 0x046dc125, "Harmony 200 Remote" },
    { 0x046dc126, "Harmony Link" },
    { 0x046dc129, "Harmony Hub" },
    { 0x046dc12b, "Harmony Touch/Ultimate Remote" },
    { 0x046dc201, "WingMan Extreme Joystick with Throttle" },
    { 0x046dc202, "WingMan Formula" },
    { 0x046dc207, "WingMan Extreme Digital 3D" },
    { 0x046dc208, "WingMan Gamepad Extreme" },
    { 0x046dc209, "WingMan Gamepad" },
    { 0x046dc20a, "WingMan RumblePad" },
    { 0x046dc20b, "WingMan Action Pad" },
    { 0x046dc20c, "WingMan Precision" },
    { 0x046dc20d, "WingMan Attack 2" },
    { 0x046dc20e, "WingMan Formula GP" },
    { 0x046dc211, "iTouch Cordless Receiver" },
    { 0x046dc212, "WingMan Extreme Digital 3D" },
    { 0x046dc213, "J-UH16 (Freedom 2.4 Cordless Joystick)" },
    { 0x046dc214, "ATK3 (Attack III Joystick)" },
    { 0x046dc215, "Extreme 3D Pro" },
    { 0x046dc216, "F310 Gamepad [DirectInput Mode]" },
    { 0x046dc218, "F510 Gamepad [DirectInput Mode]" },
    { 0x046dc219, "F710 Gamepad [DirectInput Mode]" },
    { 0x046dc21a, "Precision Gamepad" },
    { 0x046dc21c, "G13 Advanced Gameboard" },
    { 0x046dc21d, "F310 Gamepad [XInput Mode]" },
    { 0x046dc21e, "F510 Gamepad [XInput Mode]" },
    { 0x046dc21f, "F710 Wireless Gamepad [XInput Mode]" },
    { 0x046dc221, "G11/G15 Keyboard / Keyboard" },
    { 0x046dc222, "G15 Keyboard / LCD" },
    { 0x046dc223, "G11/G15 Keyboard / USB Hub" },
    { 0x046dc225, "G11/G15 Keyboard / G keys" },
    { 0x046dc226, "G15 Refresh Keyboard" },
    { 0x046dc227, "G15 Refresh Keyboard" },
    { 0x046dc228, "G19 Gaming Keyboard" },
    { 0x046dc229, "G19 Gaming Keyboard Macro Interface" },
    { 0x046dc22a, "Gaming Keyboard G110" },
    { 0x046dc22b, "Gaming Keyboard G110 G-keys" },
    { 0x046dc22d, "G510 Gaming Keyboard" },
    { 0x046dc22e, "G510 Gaming Keyboard onboard audio" },
    { 0x046dc231, "G13 Virtual Mouse" },
    { 0x046dc232, "Gaming Virtual Keyboard" },
    { 0x046dc245, "G400 Optical Mouse" },
    { 0x046dc246, "Gaming Mouse G300" },
    { 0x046dc247, "G100S Optical Gaming Mouse" },
    { 0x046dc248, "G105 Gaming Keyboard" },
    { 0x046dc24a, "G600 Gaming Mouse" },
    { 0x046dc24c, "G400s Optical Mouse" },
    { 0x046dc24d, "G710 Gaming Keyboard" },
    { 0x046dc24e, "G500s Laser Gaming Mouse" },
    { 0x046dc24f, "G29 Driving Force Racing Wheel [PS3]" },
    { 0x046dc260, "G29 Driving Force Racing Wheel [PS4]" },
    { 0x046dc281, "WingMan Force" },
    { 0x046dc283, "WingMan Force 3D" },
    { 0x046dc285, "WingMan Strike Force 3D" },
    { 0x046dc286, "Force 3D Pro" },
    { 0x046dc287, "Flight System G940" },
    { 0x046dc291, "WingMan Formula Force" },
    { 0x046dc293, "WingMan Formula Force GP" },
    { 0x046dc294, "Driving Force" },
    { 0x046dc295, "Momo Force Steering Wheel" },
    { 0x046dc298, "Driving Force Pro" },
    { 0x046dc299, "G25 Racing Wheel" },
    { 0x046dc29b, "G27 Racing Wheel" },
    { 0x046dc29c, "Speed Force Wireless Wheel for Wii" },
    { 0x046dc2a0, "Wingman Force Feedback Mouse" },
    { 0x046dc2a1, "WingMan Force Feedback Mouse" },
    { 0x046dc2ab, "G13 Joystick" },
    { 0x046dc301, "iTouch Keyboard" },
    { 0x046dc302, "iTouch Pro Keyboard" },
    { 0x046dc303, "iTouch Keyboard" },
    { 0x046dc305, "Internet Keyboard" },
    { 0x046dc307, "Internet Keyboard" },
    { 0x046dc308, "Internet Navigator Keyboard" },
    { 0x046dc309, "Y-BF37 [Internet Navigator Keyboard]" },
    { 0x046dc30a, "iTouch Composite" },
    { 0x046dc30b, "NetPlay Keyboard" },
    { 0x046dc30c, "Internet Keys (X)" },
    { 0x046dc30d, "Internet Keys" },
    { 0x046dc30e, "UltraX Keyboard (Y-BL49)" },
    { 0x046dc30f, "Logicool HID-Compliant Keyboard (106 key)" },
    { 0x046dc311, "Y-UF49 [Internet Pro Keyboard]" },
    { 0x046dc312, "DeLuxe 250 Keyboard" },
    { 0x046dc313, "Internet 350 Keyboard" },
    { 0x046dc315, "Classic Keyboard 200" },
    { 0x046dc316, "HID-Compliant Keyboard" },
    { 0x046dc317, "Wave Corded Keyboard" },
    { 0x046dc318, "Illuminated Keyboard" },
    { 0x046dc31a, "Comfort Wave 450" },
    { 0x046dc31b, "Compact Keyboard K300" },
    { 0x046dc31c, "Keyboard K120" },
    { 0x046dc31d, "Media Keyboard K200" },
    { 0x046dc31f, "Comfort Keyboard K290" },
    { 0x046dc326, "Washable Keyboard K310" },
    { 0x046dc328, "Corded Keyboard K280e" },
    { 0x046dc32b, "G910 Orion Spark Mechanical Keyboard" },
    { 0x046dc332, "G502 Proteus Spectrum Optical Mouse" },
    { 0x046dc335, "G910 Orion Spectrum Mechanical Keyboard" },
    { 0x046dc33a, "G413 Gaming Keyboard" },
    { 0x046dc401, "TrackMan Marble Wheel" },
    { 0x046dc402, "Marble Mouse (2-button)" },
    { 0x046dc403, "Turbo TrackMan Marble FX" },
    { 0x046dc404, "TrackMan Wheel" },
    { 0x046dc408, "Marble Mouse (4-button)" },
    { 0x046dc501, "Cordless Mouse Receiver" },
    { 0x046dc502, "Cordless Mouse & iTouch Keys" },
    { 0x046dc503, "Cordless Mouse+Keyboard Receiver" },
    { 0x046dc504, "Cordless Mouse+Keyboard Receiver" },
    { 0x046dc505, "Cordless Mouse+Keyboard Receiver" },
    { 0x046dc506, "MX700 Cordless Mouse Receiver" },
    { 0x046dc508, "Cordless Trackball" },
    { 0x046dc509, "Cordless Keyboard & Mouse" },
    { 0x046dc50a, "Cordless Mouse" },
    { 0x046dc50b, "Cordless Desktop Optical" },
    { 0x046dc50c, "Cordless Desktop S510" },
    { 0x046dc50d, "Cordless Mouse" },
    { 0x046dc50e, "Cordless Mouse Receiver" },
    { 0x046dc510, "Cordless Mouse" },
    { 0x046dc512, "LX-700 Cordless Desktop Receiver" },
    { 0x046dc513, "MX3000 Cordless Desktop Receiver" },
    { 0x046dc514, "Cordless Mouse" },
    { 0x046dc515, "Cordless 2.4 GHz Presenter Presentation remote control" },
    { 0x046dc517, "LX710 Cordless Desktop Laser" },
    { 0x046dc518, "MX610 Laser Cordless Mouse" },
    { 0x046dc51a, "MX Revolution/G7 Cordless Mouse" },
    { 0x046dc51b, "V220 Cordless Optical Mouse for Notebooks" },
    { 0x046dc521, "Cordless Mouse Receiver" },
    { 0x046dc525, "MX Revolution Cordless Mouse" },
    { 0x046dc526, "Nano Receiver" },
    { 0x046dc529, "Logitech Keyboard + Mice" },
    { 0x046dc52b, "Unifying Receiver" },
    { 0x046dc52d, "R700 Remote Presenter receiver" },
    { 0x046dc52e, "MK260 Wireless Combo Receiver" },
    { 0x046dc52f, "Unifying Receiver" },
    { 0x046dc531, "C-U0007 [Unifying Receiver]" },
    { 0x046dc532, "Unifying Receiver" },
    { 0x046dc534, "Unifying Receiver" },
    { 0x046dc537, "Cordless Mouse Receiver" },
    { 0x046dc53a, "PowerPlay Wireless Charging System" },
    { 0x046dc603, "3Dconnexion Spacemouse Plus XT" },
    { 0x046dc605, "3Dconnexion CADman" },
    { 0x046dc606, "3Dconnexion Spacemouse Classic" },
    { 0x046dc621, "3Dconnexion Spaceball 5000" },
    { 0x046dc623, "3Dconnexion Space Traveller 3D Mouse" },
    { 0x046dc625, "3Dconnexion Space Pilot 3D Mouse" },
    { 0x046dc626, "3Dconnexion Space Navigator 3D Mouse" },
    { 0x046dc627, "3Dconnexion Space Explorer 3D Mouse" },
    { 0x046dc628, "3Dconnexion Space Navigator for Notebooks" },
    { 0x046dc629, "3Dconnexion SpacePilot Pro 3D Mouse" },
    { 0x046dc62b, "3Dconnexion Space Mouse Pro" },
    { 0x046dc640, "NuLOOQ navigator" },
    { 0x046dc702, "Cordless Presenter" },
    { 0x046dc703, "Elite Keyboard Y-RP20 + Mouse MX900 (Bluetooth)" },
    { 0x046dc704, "diNovo Wireless Desktop" },
    { 0x046dc705, "MX900 Bluetooth Wireless Hub (C-UJ16A)" },
    { 0x046dc707, "Bluetooth wireless hub" },
    { 0x046dc708, "Bluetooth wireless hub" },
    { 0x046dc709, "BT Mini-Receiver (HCI mode)" },
    { 0x046dc70a, "MX5000 Cordless Desktop" },
    { 0x046dc70b, "BT Mini-Receiver (HID proxy mode)" },
    { 0x046dc70c, "BT Mini-Receiver (HID proxy mode)" },
    { 0x046dc70d, "Bluetooth wireless hub" },
    { 0x046dc70e, "MX1000 Bluetooth Laser Mouse" },
    { 0x046dc70f, "Bluetooth wireless hub" },
    { 0x046dc712, "Bluetooth wireless hub" },
    { 0x046dc714, "diNovo Edge Keyboard" },
    { 0x046dc715, "Bluetooth wireless hub" },
    { 0x046dc71a, "Bluetooth wireless hub" },
    { 0x046dc71d, "Bluetooth wireless hub" },
    { 0x046dc71f, "diNovo Mini Wireless Keyboard" },
    { 0x046dc720, "Bluetooth wireless hub" },
    { 0x046dca03, "MOMO Racing" },
    { 0x046dca04, "Formula Vibration Feedback Wheel" },
    { 0x046dca84, "Cordless Controller for Xbox" },
    { 0x046dca88, "Thunderpad for Xbox" },
    { 0x046dca8a, "Precision Vibration Feedback Wheel for Xbox" },
    { 0x046dcaa3, "DriveFX Racing Wheel" },
    { 0x046dcab1, "Cordless Keyboard for Wii HID Receiver" },
    { 0x046dd001, "QuickCam Pro" },
    { 0x046df301, "Controller" },
    { 0x046e0100, "Keyboard" },
    { 0x046e3001, "Mass Storage Device" },
    { 0x046e3002, "Mass Storage Device" },
    { 0x046e3003, "Mass Storage Device" },
    { 0x046e3005, "Mass Storage Device" },
    { 0x046e3008, "Mass Storage Device" },
    { 0x046e5250, "KeyMaestro Multimedia Keyboard" },
    { 0x046e5273, "KeyMaestro Multimedia Keyboard" },
    { 0x046e52e6, "Cordless Mouse" },
    { 0x046e5308, "KeyMaestro Keyboard" },
    { 0x046e5408, "KeyMaestro Multimedia Keyboard/Hub" },
    { 0x046e5500, "Portable Keyboard 86+9 keys (Model 6100C US)" },
    { 0x046e5550, "5 button optical mouse model M873U" },
    { 0x046e5720, "Smart Card Reader" },
    { 0x046e6782, "BTC 7932 mouse+keyboard" },
    { 0x04710101, "DSS350 Digital Speaker System" },
    { 0x04710104, "DSS330 Digital Speaker System [uda1321]" },
    { 0x04710105, "UDA1321" },
    { 0x0471014b, "Philips HDD6320/00 or HDD6330/17" },
    { 0x0471014c, "Philips HDD14XX,HDD1620 or HDD1630/17" },
    { 0x0471014d, "Philips HDD085/00 or HDD082/17" },
    { 0x0471014f, "Philips GoGear SA9200" },
    { 0x04710160, "MP3 Player" },
    { 0x04710161, "MP3 Player" },
    { 0x04710163, "GoGear SA1100" },
    { 0x04710164, "Philips SA1115/55" },
    { 0x04710165, "Philips GoGear Audio" },
    { 0x04710172, "Philips Shoqbox" },
    { 0x04710181, "Philips PSA610" },
    { 0x047101eb, "Philips HDD6320" },
    { 0x04710201, "Hub" },
    { 0x04710222, "Creative Nomad Jukebox" },
    { 0x04710302, "PCA645VC Webcam [pwc]" },
    { 0x04710303, "PCA646VC Webcam [pwc]" },
    { 0x04710304, "Askey VC010 Webcam [pwc]" },
    { 0x04710307, "PCVC675K Webcam [pwc]" },
    { 0x04710308, "PCVC680K Webcam [pwc]" },
    { 0x0471030b, "PC VGA Camera (Vesta Fun)" },
    { 0x0471030c, "PCVC690K Webcam [pwc]" },
    { 0x04710310, "PCVC730K Webcam [pwc]" },
    { 0x04710311, "PCVC740K ToUcam Pro [pwc]" },
    { 0x04710312, "PCVC750K Webcam [pwc]" },
    { 0x04710314, "DMVC 1000K" },
    { 0x04710316, "DMVC 2000K Video Capture" },
    { 0x04710321, "FunCam" },
    { 0x04710322, "DMVC1300K PC Camera" },
    { 0x04710325, "SPC 200NC PC Camera" },
    { 0x04710326, "SPC 300NC PC Camera" },
    { 0x04710327, "Webcam SPC 6000 NC (Webcam w/ mic)" },
    { 0x04710328, "SPC 700NC PC Camera" },
    { 0x04710329, "SPC 900NC PC Camera / ORITE CCD Webcam(PC370R)" },
    { 0x0471032d, "SPC 210NC PC Camera" },
    { 0x0471032e, "SPC 315NC PC Camera" },
    { 0x04710330, "SPC 710NC PC Camera" },
    { 0x04710331, "SPC 1300NC PC Camera" },
    { 0x04710332, "SPC 1000NC PC Camera" },
    { 0x04710333, "SPC 620NC PC Camera" },
    { 0x04710334, "SPC 520/525NC PC Camera" },
    { 0x04710401, "Semiconductors CICT Keyboard" },
    { 0x04710402, "PS/2 Mouse on Semiconductors CICT Keyboard" },
    { 0x04710406, "15 inch Detachable Monitor" },
    { 0x04710407, "10 inch Mobile Monitor" },
    { 0x04710408, "SG3WA1/74 802.11b WLAN Adapter [Atmel AT76C503A]" },
    { 0x04710471, "Digital Speaker System" },
    { 0x04710601, "OVU1020 IR Dongle (Kbd+Mouse)" },
    { 0x04710602, "ATI Remote Wonder II Input Device" },
    { 0x04710603, "ATI Remote Wonder II Controller" },
    { 0x04710608, "eHome Infrared Receiver" },
    { 0x0471060a, "TSU9600 Remote Control" },
    { 0x0471060c, "Consumer Infrared Transceiver (HP)" },
    { 0x0471060d, "Consumer Infrared Transceiver (SRM5100)" },
    { 0x0471060e, "RF Dongle" },
    { 0x0471060f, "Consumer Infrared Transceiver" },
    { 0x04710613, "Infrared Transceiver" },
    { 0x04710617, "IEEE802.15.4 RF Dongle" },
    { 0x04710619, "TSU9400 Remote Control" },
    { 0x04710666, "Hantek DDS-3005 Arbitrary Waveform Generator" },
    { 0x04710700, "Semiconductors CICT Hub" },
    { 0x04710701, "150P1 TFT Display" },
    { 0x04710809, "AVNET Bluetooth Device" },
    { 0x04710811, "JR24 CDRW" },
    { 0x04710814, "DCCX38/P data cable" },
    { 0x04710815, "eHome Infrared Receiver" },
    { 0x04710844, "SA2111/02 1GB Flash Audio Player" },
    { 0x0471084a, "GoGear SA3125" },
    { 0x0471084e, "Philips GoGear SA6014/SA6015/SA6024/SA6025/SA6044/SA6045" },
    { 0x04710857, "Philips GoGear SA5145" },
    { 0x04710888, "Hantek DDS-3005 Arbitrary Waveform Generator" },
    { 0x04711103, "Digital Speaker System" },
    { 0x04711120, "Creative Rhomba MP3 player" },
    { 0x04711125, "Nike psa[128max Player" },
    { 0x04711137, "HDD065 MP3 player" },
    { 0x04711201, "Arima Bluetooth Device" },
    { 0x04711230, "Wireless Adapter 11g" },
    { 0x04711232, "SNU6500 Wireless Adapter" },
    { 0x04711233, "Wireless Adapter Bootloader Download" },
    { 0x04711236, "SNU5600 802.11bg" },
    { 0x04711237, "TalkTalk SNU5630NS/05 802.11bg" },
    { 0x04711552, "ISP 1581 Hi-Speed USB MPEG2 Encoder Reference Kit" },
    { 0x04711801, "Diva MP3 player" },
    { 0x04712002, "Philips GoGear SA6125/SA6145/SA6185" },
    { 0x04712004, "Philips GoGear SA3345" },
    { 0x0471200a, "Wireless Network Adapter" },
    { 0x0471200f, "802.11n Wireless Adapter" },
    { 0x04712021, "SDE3273FC/97 2.5\" SATA HDD Enclosure [INIC-1608L]" },
    { 0x04712022, "Philips SA5285" },
    { 0x04712034, "Webcam SPC530NC" },
    { 0x04712036, "Webcam SPC1030NC" },
    { 0x0471203f, "TSU9200 Remote Control" },
    { 0x04712046, "TSU9800 Remote Control" },
    { 0x0471204e, "GoGear RaGa (SA1942/02)" },
    { 0x0471205e, "TSU9300 Remote Control" },
    { 0x0471206c, "MCE IR Receiver - Spinel plusf0r ASUS" },
    { 0x04712070, "GoGear Mix" },
    { 0x04712075, "Philips GoGear ViBE SA1VBE04" },
    { 0x04712076, "GoGear Aria" },
    { 0x04712077, "Philips GoGear Muse" },
    { 0x04712079, "GoGear Opus" },
    { 0x0471207b, "Philips GoGear ViBE SA1VBE04/08" },
    { 0x0471207c, "Philips GoGear Aria" },
    { 0x04712088, "MCE IR Receiver with ALS- Spinel plus for ASUS" },
    { 0x0471208e, "Philips GoGear SA1VBE08KX/78" },
    { 0x0471209e, "PTA01 Wireless Adapter" },
    { 0x047120b6, "GoGear Vibe" },
    { 0x047120b7, "Philips GoGear VIBE SA2VBE[08|16]K/02" },
    { 0x047120b9, "Philips GoGear Ariaz" },
    { 0x047120d0, "SPZ2000 Webcam [PixArt PAC7332]" },
    { 0x047120e3, "GoGear Raga" },
    { 0x047120e4, "GoGear ViBE 8GB" },
    { 0x047120e5, "Philips GoGear Vibe/02" },
    { 0x04712160, "Mio LINK Heart Rate Monitor" },
    { 0x047121e0, "GoGEAR Raga" },
    { 0x0471262c, "SPC230NC Webcam" },
    { 0x04712721, "PTA 317 TV Camera" },
    { 0x0471485d, "Senselock SenseIV v2.x" },
    { 0x04717e01, "Philips PSA235" },
    { 0x0471df55, "LPCXpresso LPC-Link" },
    { 0x04720065, "PFU-65 Keyboard [Chicony]" },
    { 0x0472b086, "Asus USB2.0 Webcam" },
    { 0x0472b091, "Webcam" },
    { 0x04740110, "Digital Voice Recorder R200" },
    { 0x04740217, "Xacti J2" },
    { 0x0474022f, "C5 Digital Media Camera (mass storage mode)" },
    { 0x04740230, "Sanyo VPC-C5" },
    { 0x04740231, "C5 Digital Media Camera (PC control mode)" },
    { 0x04740401, "Optical Drive" },
    { 0x04740701, "SCP-4900 Cellphone" },
    { 0x0474071f, "Usb Com Port Enumerator" },
    { 0x04740722, "W33SA Camera" },
    { 0x04750100, "NEC Petiscan" },
    { 0x04750103, "Eclipse 1200U/Episode" },
    { 0x04750210, "Scorpio Ultra 3" },
    { 0x04780001, "QuickCam" },
    { 0x04780002, "QuickClip" },
    { 0x04780003, "QuickCam Pro" },
    { 0x047a0004, "ScreenCoder UR7HCTS2-USB" },
    { 0x047b0001, "Keyboard" },
    { 0x047b0002, "Keyboard and Mouse" },
    { 0x047b0011, "SK-1688U Keyboard" },
    { 0x047b00f9, "SK-1789u Keyboard" },
    { 0x047b0101, "BlueTooth Keyboard and Mouse" },
    { 0x047b020b, "SK-3105 SmartCard Reader" },
    { 0x047b050e, "Internet Compact Keyboard" },
    { 0x047b1000, "Trust Office Scan USB 19200" },
    { 0x047b1002, "HP ScanJet 4300c Parallel Port" },
    { 0x047cffff, "UPS Tower 500W LV" },
    { 0x047d1001, "Mouse*in*a*Box" },
    { 0x047d1002, "Expert Mouse Pro" },
    { 0x047d1003, "Orbit TrackBall" },
    { 0x047d1004, "MouseWorks" },
    { 0x047d1005, "TurboBall" },
    { 0x047d1006, "TurboRing" },
    { 0x047d1009, "Orbit TrackBall for Mac" },
    { 0x047d1012, "PocketMouse" },
    { 0x047d1013, "Mouse*in*a*Box Optical Pro" },
    { 0x047d1014, "Expert Mouse Pro Wireless" },
    { 0x047d1015, "Expert Mouse" },
    { 0x047d1016, "ADB/USB Orbit" },
    { 0x047d1018, "Studio Mouse" },
    { 0x047d101d, "Mouse*in*a*Box Optical Pro" },
    { 0x047d101e, "Studio Mouse Wireless" },
    { 0x047d101f, "PocketMouse Pro" },
    { 0x047d1020, "Expert Mouse Trackball" },
    { 0x047d1021, "Expert Mouse Wireless" },
    { 0x047d1022, "Orbit Optical" },
    { 0x047d1023, "Pocket Mouse Pro Wireless" },
    { 0x047d1024, "PocketMouse" },
    { 0x047d1025, "Mouse*in*a*Box Optical Elite Wireless" },
    { 0x047d1026, "Pocket Mouse Pro" },
    { 0x047d1027, "StudioMouse" },
    { 0x047d1028, "StudioMouse Wireless" },
    { 0x047d1029, "Mouse*in*a*Box Optical Elite" },
    { 0x047d102a, "Mouse*in*a*Box Optical" },
    { 0x047d102b, "PocketMouse" },
    { 0x047d102c, "Iridio" },
    { 0x047d102d, "Pilot Optical" },
    { 0x047d102e, "Pilot Optical Pro" },
    { 0x047d102f, "Pilot Optical Pro Wireless" },
    { 0x047d1042, "Ci25m Notebook Optical Mouse [Diamond Eye Precision]" },
    { 0x047d1043, "Ci65m Wireless Notebook Optical Mouse" },
    { 0x047d104a, "PilotMouse Mini Retractable" },
    { 0x047d105d, "PocketMouse Bluetooth" },
    { 0x047d105e, "Bluetooth EDR Dongle" },
    { 0x047d1061, "PocketMouse Grip" },
    { 0x047d1062, "PocketMouse Max" },
    { 0x047d1063, "PocketMouse Max Wireless" },
    { 0x047d1064, "PocketMouse 2.0 Wireless" },
    { 0x047d1065, "PocketMouse 2.0" },
    { 0x047d1066, "PocketMouse Max Glow" },
    { 0x047d1067, "ValueMouse" },
    { 0x047d1068, "ValueOpt White" },
    { 0x047d1069, "ValueOpt Black" },
    { 0x047d106a, "PilotMouse Laser Wireless Mini" },
    { 0x047d106b, "PilotMouse Laser - 3 Button" },
    { 0x047d106c, "PilotMouse Laser - Gaming" },
    { 0x047d106d, "PilotMouse Laser - Wired" },
    { 0x047d106e, "PilotMouse Micro Laser" },
    { 0x047d1070, "ValueOpt Travel" },
    { 0x047d1071, "ValueOpt RF TX" },
    { 0x047d1072, "PocketMouse Colour" },
    { 0x047d1073, "PilotMouse Laser - 6 Button" },
    { 0x047d1074, "PilotMouse Laser Wireless Mini" },
    { 0x047d1075, "SlimBlade Presenter Media Mouse" },
    { 0x047d1076, "SlimBlade Media Mouse" },
    { 0x047d1077, "SlimBlade Presenter Mouse" },
    { 0x047d1152, "Bluetooth EDR Dongle" },
    { 0x047d2002, "Optical Elite Wireless" },
    { 0x047d2010, "Wireless Presentation Remote" },
    { 0x047d2012, "Wireless Presenter with Laser Pointer" },
    { 0x047d2021, "PilotBoard Wireless" },
    { 0x047d2030, "PilotBoard Wireless" },
    { 0x047d2034, "SlimBlade Media Notebook Set" },
    { 0x047d2041, "SlimBlade Trackball" },
    { 0x047d2048, "Orbit Trackball with Scroll Ring" },
    { 0x047d4003, "Gravis Xterminator Digital Gamepad" },
    { 0x047d4005, "Gravis Eliminator GamePad Pro" },
    { 0x047d4006, "Gravis Eliminator AfterShock" },
    { 0x047d4007, "Gravis Xterminator Force" },
    { 0x047d4008, "Gravis Destroyer TiltPad" },
    { 0x047d5001, "Cabo I Camera" },
    { 0x047d5002, "VideoCam CABO II" },
    { 0x047d5003, "VideoCam" },
    { 0x047e0300, "ORiNOCO Card" },
    { 0x047e1001, "USS720 Parallel Port" },
    { 0x047e2892, "Systems Soft Modem" },
    { 0x047ebad1, "Lucent 56k Modem" },
    { 0x047ef101, "Atlas Modem" },
    { 0x047f0101, "Bulk Driver" },
    { 0x047f02ee, "BT600" },
    { 0x047f0301, "Bulk Driver" },
    { 0x047f0411, "Savi Office Base Station" },
    { 0x047f0ca1, "USB DSP v4 Audio Interface" },
    { 0x047f4254, "BUA-100 Bluetooth Adapter" },
    { 0x047faa05, "DA45" },
    { 0x047fac01, "Savi 7xx" },
    { 0x047fad01, "GameCom 777 5.1 Headset" },
    { 0x047faf01, "DA80" },
    { 0x047fc008, "Audio 655 DSP" },
    { 0x047fc00e, "Blackwire C310 headset" },
    { 0x047fc03b, "HD1" },
    { 0x047fda60, "DA60" },
    { 0x04800001, "InTouch Module" },
    { 0x04800004, "InTouch Module" },
    { 0x04800011, "InTouch Module" },
    { 0x04800014, "InTouch Module" },
    { 0x04800100, "Stor.E Slim USB 3.0" },
    { 0x04800200, "External Disk" },
    { 0x04800820, "Canvio Advance Disk" },
    { 0x04800821, "Canvio Advance 2TB model DTC920" },
    { 0x04800900, "MQ04UBF100" },
    { 0x0480a006, "External Disk 1.5TB" },
    { 0x0480a007, "External Disk USB 3.0" },
    { 0x0480a009, "Stor.E Basics" },
    { 0x0480a00d, "STOR.E BASICS 500GB" },
    { 0x0480a100, "Canvio Alu 2TB 2.5\" Black External Disk Model HDTH320EK3CA" },
    { 0x0480a102, "Canvio Alu 2TB 2.5\" Black External Disk Model HDTH320EK3CA" },
    { 0x0480a202, "Canvio Basics HDD" },
    { 0x0480a208, "Canvio Basics 2TB USB 3.0 Portable Hard Drive" },
    { 0x0480b001, "Stor.E Partner" },
    { 0x0480b207, "Canvio Ready" },
    { 0x0480d000, "External Disk 2TB Model DT01ABA200" },
    { 0x0480d010, "External Disk 3TB" },
    { 0x0480d011, "Canvio Desk" },
    { 0x0482000e, "FS-1020D Printer" },
    { 0x0482000f, "FS-1920 Mono Printer" },
    { 0x04820015, "FS-1030D printer" },
    { 0x04820100, "Finecam S3x" },
    { 0x04820101, "Finecam S4" },
    { 0x04820103, "Finecam S5" },
    { 0x04820105, "Finecam L3" },
    { 0x04820106, "Finecam" },
    { 0x04820107, "Digital Camera Device" },
    { 0x04820108, "Digital Camera Device" },
    { 0x04820203, "AH-K3001V" },
    { 0x04820204, "iBurst Terminal" },
    { 0x04820408, "FS-1320D Printer" },
    { 0x04820640, "ECOSYS M6026cdn" },
    { 0x0482069b, "ECOSYS M2635dn" },
    { 0x04830137, "BeWAN ADSL USB ST (blue or green)" },
    { 0x04830138, "Unicorn II (ST70138B + MTC-20174TQ chipset)" },
    { 0x04830adb, "Android Debug Bridge (ADB) device" },
    { 0x04830afb, "Android Fastboot device" },
    { 0x04831307, "Cytronix 6in1 Card Reader" },
    { 0x0483163d, "Cool Icam Digi-MP3" },
    { 0x04832015, "TouchChip\302\256 Fingerprint Reader" },
    { 0x04832016, "Fingerprint Reader" },
    { 0x04832017, "Biometric Smart Card Reader" },
    { 0x04832018, "BioSimKey" },
    { 0x04832302, "Portable Flash Device (PFD)" },
    { 0x04833744, "ST-LINK/V1" },
    { 0x04833747, "ST Micro Connect Lite" },
    { 0x04833748, "ST-LINK/V2" },
    { 0x0483374b, "ST-LINK/V2.1" },
    { 0x0483374d, "STLINK-V3 Loader" },
    { 0x0483374e, "STLINK-V3" },
    { 0x0483374f, "STLINK-V3" },
    { 0x04833752, "ST-LINK/V2.1" },
    { 0x04833753, "STLINK-V3" },
    { 0x04834810, "ISDN adapter" },
    { 0x0483481d, "BT Digital Access adapter" },
    { 0x04835000, "ST Micro/Ergenic ERG BT-002 Bluetooth Adapter" },
    { 0x04835001, "ST Micro Bluetooth Device" },
    { 0x04835710, "Joystick in FS Mode" },
    { 0x04835720, "Mass Storage Device" },
    { 0x04835721, "Interrupt Demo" },
    { 0x04835722, "Bulk Demo" },
    { 0x04835730, "Audio Speaker" },
    { 0x04835731, "Microphone" },
    { 0x04835740, "Virtual COM Port" },
    { 0x04835750, "LED badge -- mini LED display -- 11x44" },
    { 0x04837270, "ST Micro Serial Bridge" },
    { 0x04837554, "56k SoftModem" },
    { 0x04838213, "ThermaData Logger Cradle" },
    { 0x04838259, "Probe" },
    { 0x048391d1, "Sensor Hub" },
    { 0x0483a171, "ThermaData WiFi" },
    { 0x0483a2e0, "BMeasure instrument" },
    { 0x0483df11, "STM Device in DFU Mode" },
    { 0x0483ff10, "Swann ST56 Modem" },
    { 0x04860185, "EeePC T91MT HID Touch Panel" },
    { 0x04890502, "SmartMedia Card Reader Firmware Loader" },
    { 0x04890503, "SmartMedia Card Reader" },
    { 0x0489d00c, "Rollei Compactline (Storage Mode)" },
    { 0x0489d00e, "Rollei Compactline (Video Mode)" },
    { 0x0489e000, "T-Com TC 300" },
    { 0x0489e003, "Pirelli DP-L10" },
    { 0x0489e00d, "Broadcom Bluetooth 2.1 Device" },
    { 0x0489e00f, "Foxconn T77H114 BCM2070 [Single-Chip Bluetooth 2.1 + EDR Adapter]" },
    { 0x0489e011, "Acer Bluetooth module" },
    { 0x0489e016, "Ubee PXU1900 WiMAX Adapter [Beceem BCSM250]" },
    { 0x0489e02c, "Atheros AR5BBU12 Bluetooth Device" },
    { 0x0489e032, "Broadcom BCM20702 Bluetooth" },
    { 0x0489e040, "Vizio VTAB1008" },
    { 0x0489e042, "Broadcom BCM20702 Bluetooth" },
    { 0x0489e04d, "Atheros AR3012 Bluetooth" },
    { 0x0489e055, "BCM43142A0 broadcom bluetooth" },
    { 0x048d1165, "IT1165 Flash Controller" },
    { 0x048d1172, "Flash Drive" },
    { 0x048d1234, "Chipsbank CBM2199 Flash Drive" },
    { 0x048d1336, "SD/MMC Cardreader" },
    { 0x048d1345, "Multi Cardreader" },
    { 0x048d8297, "IT8297 RGB LED Controller" },
    { 0x048d9006, "IT9135 BDA Afatech DVB-T HDTV Dongle" },
    { 0x048d9009, "Zolid HD DVD Maker" },
    { 0x048d9135, "Zolid Mini DVB-T Stick" },
    { 0x048d9306, "IT930x DVB stick" },
    { 0x048d9503, "ITE it9503 feature-limited DVB-T transmission chip [ccHDtv]" },
    { 0x048d9507, "ITE it9507 full featured DVB-T transmission chip [ccHDtv]" },
    { 0x048d9910, "IT9910 chipset based grabber" },
    { 0x048dff59, "Hdmi-CEC Bridge" },
    { 0x04910003, "Taxan Monitor Control" },
    { 0x04920140, "MP3 player" },
    { 0x04920141, "MP3 Player" },
    { 0x0497c001, "Camera Device" },
    { 0x04991000, "UX256 MIDI I/F" },
    { 0x04991001, "MU1000" },
    { 0x04991002, "MU2000" },
    { 0x04991003, "MU500" },
    { 0x04991004, "UW500" },
    { 0x04991005, "MOTIF6" },
    { 0x04991006, "MOTIF7" },
    { 0x04991007, "MOTIF8" },
    { 0x04991008, "UX96 MIDI I/F" },
    { 0x04991009, "UX16 MIDI I/F" },
    { 0x0499100a, "EOS BX" },
    { 0x0499100c, "UC-MX" },
    { 0x0499100d, "UC-KX" },
    { 0x0499100e, "S08" },
    { 0x0499100f, "CLP-150" },
    { 0x04991010, "CLP-170" },
    { 0x04991011, "P-250" },
    { 0x04991012, "TYROS" },
    { 0x04991013, "PF-500" },
    { 0x04991014, "S90" },
    { 0x04991015, "MOTIF-R" },
    { 0x04991016, "MDP-5" },
    { 0x04991017, "CVP-204" },
    { 0x04991018, "CVP-206" },
    { 0x04991019, "CVP-208" },
    { 0x0499101a, "CVP-210" },
    { 0x0499101b, "PSR-1100" },
    { 0x0499101c, "PSR-2100" },
    { 0x0499101d, "CLP-175" },
    { 0x0499101e, "PSR-K1" },
    { 0x0499101f, "EZ-J24" },
    { 0x04991020, "EZ-250i" },
    { 0x04991021, "MOTIF ES 6" },
    { 0x04991022, "MOTIF ES 7" },
    { 0x04991023, "MOTIF ES 8" },
    { 0x04991024, "CVP-301" },
    { 0x04991025, "CVP-303" },
    { 0x04991026, "CVP-305" },
    { 0x04991027, "CVP-307" },
    { 0x04991028, "CVP-309" },
    { 0x04991029, "CVP-309GP" },
    { 0x0499102a, "PSR-1500" },
    { 0x0499102b, "PSR-3000" },
    { 0x0499102e, "ELS-01/01C" },
    { 0x04991030, "PSR-295/293" },
    { 0x04991031, "DGX-205/203" },
    { 0x04991032, "DGX-305" },
    { 0x04991033, "DGX-505" },
    { 0x04991037, "PSR-E403" },
    { 0x0499103c, "MOTIF-RACK ES" },
    { 0x04991054, "S90XS Keyboard/Music Synthesizer" },
    { 0x0499160f, "P-105" },
    { 0x04991613, "Clavinova CLP535" },
    { 0x04991617, "PSR-E353 digital keyboard" },
    { 0x04991704, "Steinberg UR44" },
    { 0x04992000, "DGP-7" },
    { 0x04992001, "DGP-5" },
    { 0x04993001, "YST-MS55D USB Speaker" },
    { 0x04993003, "YST-M45D USB Speaker" },
    { 0x04994000, "NetVolante RTA54i Broadband&ISDN Router" },
    { 0x04994001, "NetVolante RTW65b Broadband Wireless Router" },
    { 0x04994002, "NetVolante RTW65i Broadband&ISDN Wireless Router" },
    { 0x04994004, "NetVolante RTA55i Broadband VoIP Router" },
    { 0x04995000, "CS1D" },
    { 0x04995001, "DSP1D" },
    { 0x04995002, "DME32" },
    { 0x04995003, "DM2000" },
    { 0x04995004, "02R96" },
    { 0x04995005, "ACU16-C" },
    { 0x04995006, "NHB32-C" },
    { 0x04995007, "DM1000" },
    { 0x04995008, "01V96" },
    { 0x04995009, "SPX2000" },
    { 0x0499500a, "PM5D" },
    { 0x0499500b, "DME64N" },
    { 0x0499500c, "DME24N" },
    { 0x04996001, "CRW2200UX Lightspeed 2 External CD-RW Drive" },
    { 0x04997000, "DTX" },
    { 0x04997010, "UB99" },
    { 0x049c0002, "Keyboard (?)" },
    { 0x049f0002, "InkJet Color Printer" },
    { 0x049f0003, "iPAQ PocketPC" },
    { 0x049f000e, "Internet Keyboard" },
    { 0x049f0012, "InkJet Color Printer" },
    { 0x049f0018, "PA-1/PA-2 MP3 Player" },
    { 0x049f0019, "InkJet Color Printer" },
    { 0x049f001a, "S4 100 Scanner" },
    { 0x049f001e, "IJ650 Inkjet Printer" },
    { 0x049f001f, "WL215 Adapter" },
    { 0x049f0021, "S200 Scanner" },
    { 0x049f0027, "Bluetooth Multiport Module by Compaq" },
    { 0x049f002a, "1400P Inkjet Printer" },
    { 0x049f002b, "A3000" },
    { 0x049f002c, "Lexmark X125" },
    { 0x049f0032, "802.11b Adapter [ipaq h5400]" },
    { 0x049f0033, "Wireless LAN MultiPort W100 [Intersil PRISM 2.5]" },
    { 0x049f0036, "Bluetooth Multiport Module" },
    { 0x049f0051, "KU-0133 Easy Access Interner Keyboard" },
    { 0x049f0076, "Wireless LAN MultiPort W200" },
    { 0x049f0080, "GPRS Multiport" },
    { 0x049f0086, "Bluetooth Device" },
    { 0x049f504a, "Personal Jukebox PJB100" },
    { 0x049f505a, "Linux-USB \"CDC Subset\" Device, or Itsy (experimental)" },
    { 0x049f8511, "iPAQ Networking 10/100 Ethernet [pegasus2]" },
    { 0x04a1fff0, "Telex Composite Device" },
    { 0x04a40004, "DVD-CAM DZ-MV100A Camcorder" },
    { 0x04a4001e, "DVDCAM USB HS Interface" },
    { 0x04a50001, "Keyboard" },
    { 0x04a50002, "API Ergo K/B" },
    { 0x04a50003, "API Generic K/B Mouse" },
    { 0x04a512a6, "AcerScan C310U" },
    { 0x04a51a20, "Prisa 310U" },
    { 0x04a51a2a, "Prisa 620U" },
    { 0x04a52022, "Prisa 320U/340U" },
    { 0x04a52040, "Prisa 620UT" },
    { 0x04a5205e, "ScanPrisa 640BU" },
    { 0x04a52060, "Prisa 620U+/640U" },
    { 0x04a5207e, "Prisa 640BU" },
    { 0x04a5209e, "ScanPrisa 640BT" },
    { 0x04a520ae, "S2W 3000U" },
    { 0x04a520b0, "S2W 3300U/4300U" },
    { 0x04a520be, "Prisa 640BT" },
    { 0x04a520c0, "Prisa 1240UT" },
    { 0x04a520de, "S2W 4300U+" },
    { 0x04a520f8, "Benq 5000" },
    { 0x04a520fc, "Benq 5000" },
    { 0x04a520fe, "SW2 5300U" },
    { 0x04a52137, "Benq 5150/5250" },
    { 0x04a52202, "Benq 7400UT" },
    { 0x04a52311, "Benq 5560" },
    { 0x04a53003, "Benq Webcam" },
    { 0x04a53008, "Benq 1500" },
    { 0x04a5300a, "Benq 3410" },
    { 0x04a5300c, "Benq 1016" },
    { 0x04a53019, "Benq DC C40" },
    { 0x04a54000, "P30 Composite Device" },
    { 0x04a54013, "BenQ-Siemens EF82/SL91" },
    { 0x04a54044, "BenQ-Siemens SF71" },
    { 0x04a54045, "BenQ-Siemens E81" },
    { 0x04a54048, "BenQ M7" },
    { 0x04a56001, "Mass Storage Device" },
    { 0x04a56002, "Mass Storage Device" },
    { 0x04a56003, "ATA/ATAPI Adapter" },
    { 0x04a56004, "Mass Storage Device" },
    { 0x04a56005, "Mass Storage Device" },
    { 0x04a56006, "Mass Storage Device" },
    { 0x04a56007, "Mass Storage Device" },
    { 0x04a56008, "Mass Storage Device" },
    { 0x04a56009, "Mass Storage Device" },
    { 0x04a5600a, "Mass Storage Device" },
    { 0x04a5600b, "Mass Storage Device" },
    { 0x04a5600c, "Mass Storage Device" },
    { 0x04a5600d, "Mass Storage Device" },
    { 0x04a5600e, "Mass Storage Device" },
    { 0x04a5600f, "Mass Storage Device" },
    { 0x04a56010, "Mass Storage Device" },
    { 0x04a56011, "Mass Storage Device" },
    { 0x04a56012, "Mass Storage Device" },
    { 0x04a56013, "Mass Storage Device" },
    { 0x04a56014, "Mass Storage Device" },
    { 0x04a56015, "Mass Storage Device" },
    { 0x04a56125, "MP3 Player" },
    { 0x04a56180, "MP3 Player" },
    { 0x04a56200, "MP3 Player" },
    { 0x04a57500, "Hi-Speed Mass Storage Device" },
    { 0x04a59000, "AWL300 Wireless Adapter" },
    { 0x04a59001, "AWL400 Wireless Adapter" },
    { 0x04a59213, "Kbd Hub" },
    { 0x04a600b9, "Audio" },
    { 0x04a60180, "Hub Type P" },
    { 0x04a60181, "HID Monitor Controls" },
    { 0x04a70100, "StrobePro" },
    { 0x04a70101, "Strobe Pro Scanner (1.01)" },
    { 0x04a70102, "StrobePro Scanner" },
    { 0x04a70211, "OneTouch 7600 Scanner" },
    { 0x04a70221, "OneTouch 5300 Scanner" },
    { 0x04a70223, "OneTouch 8200" },
    { 0x04a70224, "OneTouch 4800 USB/Microtek Scanport 3000" },
    { 0x04a70225, "VistaScan Astra 3600(ENG)" },
    { 0x04a70226, "OneTouch 5300 USB" },
    { 0x04a70229, "OneTouch 7100" },
    { 0x04a7022a, "OneTouch 6600" },
    { 0x04a7022c, "OneTouch 9000/9020" },
    { 0x04a70231, "6100 Scanner" },
    { 0x04a70311, "6200 EPP/USB Scanner" },
    { 0x04a70321, "OneTouch 8100 EPP/USB Scanner" },
    { 0x04a70331, "OneTouch 8600 EPP/USB Scanner" },
    { 0x04a70341, "6400" },
    { 0x04a70361, "VistaScan Astra 3600(ENG)" },
    { 0x04a70362, "OneTouch 9320" },
    { 0x04a70371, "OneTouch 8700/8920" },
    { 0x04a70380, "OneTouch 7700" },
    { 0x04a70382, "Photo Port 7700" },
    { 0x04a70390, "9650" },
    { 0x04a703a0, "Xerox 4800 One Touch" },
    { 0x04a70410, "OneTouch Pro 8800/8820" },
    { 0x04a70421, "9450 USB" },
    { 0x04a70423, "9750 Scanner" },
    { 0x04a70424, "Strobe XP 450" },
    { 0x04a70425, "Strobe XP 100" },
    { 0x04a70426, "Strobe XP 200" },
    { 0x04a70427, "Strobe XP 100" },
    { 0x04a70444, "OneTouch 7300" },
    { 0x04a70445, "CardReader 100" },
    { 0x04a70446, "Xerox DocuMate 510" },
    { 0x04a70447, "XEROX DocuMate 520" },
    { 0x04a70448, "XEROX DocuMate 250" },
    { 0x04a70449, "Xerox DocuMate 252" },
    { 0x04a7044a, "Xerox 6400" },
    { 0x04a7044c, "Xerox DocuMate 262" },
    { 0x04a70474, "Strobe XP 300" },
    { 0x04a70475, "Xerox DocuMate 272" },
    { 0x04a70478, "Strobe XP 220" },
    { 0x04a70479, "Strobe XP 470" },
    { 0x04a7047a, "9450" },
    { 0x04a7047b, "9650" },
    { 0x04a7047d, "9420" },
    { 0x04a70480, "9520" },
    { 0x04a7048f, "Strobe XP 470" },
    { 0x04a70491, "Strobe XP 450" },
    { 0x04a70493, "9750" },
    { 0x04a70494, "Strobe XP 120" },
    { 0x04a70497, "Patriot 430" },
    { 0x04a70498, "Patriot 680" },
    { 0x04a70499, "Patriot 780" },
    { 0x04a7049b, "Strobe XP 100" },
    { 0x04a704a0, "7400" },
    { 0x04a704ac, "Xerox Travel Scanner 100" },
    { 0x04a704bb, "strobe 400 scanner" },
    { 0x04a704cd, "Xerox Travel Scanner 150" },
    { 0x04a80101, "Hub" },
    { 0x04a80303, "Peripheral Switch" },
    { 0x04a80404, "Peripheral Switch" },
    { 0x04a91005, "BJ Printer Hub" },
    { 0x04a91035, "PD Printer Storage" },
    { 0x04a91050, "BJC-8200" },
    { 0x04a91051, "BJC-3000 Color Printer" },
    { 0x04a91052, "BJC-6100" },
    { 0x04a91053, "BJC-6200" },
    { 0x04a91054, "BJC-6500" },
    { 0x04a91055, "BJC-85" },
    { 0x04a91056, "BJC-2110 Color Printer" },
    { 0x04a91057, "LR1" },
    { 0x04a9105a, "BJC-55" },
    { 0x04a9105b, "S600 Printer" },
    { 0x04a9105c, "S400" },
    { 0x04a9105d, "S450 Printer" },
    { 0x04a9105e, "S800" },
    { 0x04a91062, "S500 Printer" },
    { 0x04a91063, "S4500" },
    { 0x04a91064, "S300 Printer" },
    { 0x04a91065, "S100" },
    { 0x04a91066, "S630" },
    { 0x04a91067, "S900" },
    { 0x04a91068, "S9000" },
    { 0x04a91069, "S820" },
    { 0x04a9106a, "S200 Printer" },
    { 0x04a9106b, "S520 Printer" },
    { 0x04a9106d, "S750 Printer" },
    { 0x04a9106e, "S820D" },
    { 0x04a91070, "S530D" },
    { 0x04a91072, "I850 Printer" },
    { 0x04a91073, "I550 Printer" },
    { 0x04a91074, "S330 Printer" },
    { 0x04a91076, "i70" },
    { 0x04a91077, "i950" },
    { 0x04a9107a, "S830D" },
    { 0x04a9107b, "i320" },
    { 0x04a9107c, "i470D" },
    { 0x04a9107d, "i9100" },
    { 0x04a9107e, "i450" },
    { 0x04a9107f, "i860" },
    { 0x04a91082, "i350" },
    { 0x04a91084, "i250" },
    { 0x04a91085, "i255" },
    { 0x04a91086, "i560" },
    { 0x04a91088, "i965" },
    { 0x04a9108a, "i455" },
    { 0x04a9108b, "i900D" },
    { 0x04a9108c, "i475D" },
    { 0x04a9108d, "PIXMA iP2000" },
    { 0x04a9108f, "i80" },
    { 0x04a91090, "i9900 Photo Printer" },
    { 0x04a91091, "PIXMA iP1500" },
    { 0x04a91093, "PIXMA iP4000" },
    { 0x04a91094, "PIXMA iP3000x Printer" },
    { 0x04a91095, "PIXMA iP6000D" },
    { 0x04a91097, "PIXMA iP5000" },
    { 0x04a91098, "PIXMA iP1000" },
    { 0x04a91099, "PIXMA iP8500" },
    { 0x04a9109c, "PIXMA iP4000R" },
    { 0x04a9109d, "iP90" },
    { 0x04a910a0, "PIXMA iP1600 Printer" },
    { 0x04a910a2, "iP4200" },
    { 0x04a910a4, "iP5200R" },
    { 0x04a910a5, "iP5200" },
    { 0x04a910a7, "iP6210D" },
    { 0x04a910a8, "iP6220D" },
    { 0x04a910a9, "iP6600D" },
    { 0x04a910b6, "PIXMA iP4300 Printer" },
    { 0x04a910b7, "PIXMA iP5300 Printer" },
    { 0x04a910c2, "PIXMA iP1800 Printer" },
    { 0x04a910c4, "Pixma iP4500 Printer" },
    { 0x04a910c9, "PIXMA iP4600 Printer" },
    { 0x04a910ca, "PIXMA iP3600 Printer" },
    { 0x04a910e3, "PIXMA iX6850 Printer" },
    { 0x04a912fe, "Printer in service mode" },
    { 0x04a91404, "W6400PG" },
    { 0x04a91405, "W8400PG" },
    { 0x04a9150f, "BIJ2350 PCL" },
    { 0x04a91510, "BIJ1350 PCL" },
    { 0x04a91512, "BIJ1350D PCL" },
    { 0x04a91601, "DR-2080C Scanner" },
    { 0x04a91607, "DR-6080 Scanner" },
    { 0x04a91608, "DR-2580C Scanner" },
    { 0x04a91609, "DR-3080CII" },
    { 0x04a9160a, "DR-2050C Scanner" },
    { 0x04a91700, "PIXMA MP110 Scanner" },
    { 0x04a91701, "PIXMA MP130 Scanner" },
    { 0x04a91702, "MP410 Composite" },
    { 0x04a91703, "MP430 Composite" },
    { 0x04a91704, "MP330 Composite" },
    { 0x04a91706, "PIXMA MP750 Scanner" },
    { 0x04a91707, "PIXMA MP780/MP790" },
    { 0x04a91708, "PIXMA MP760/MP770" },
    { 0x04a91709, "PIXMA MP150 Scanner" },
    { 0x04a9170a, "PIXMA MP170 Scanner" },
    { 0x04a9170b, "PIXMA MP450 Scanner" },
    { 0x04a9170c, "PIXMA MP500 Scanner" },
    { 0x04a9170d, "PIXMA MP800 Scanner" },
    { 0x04a9170e, "PIXMA MP800R" },
    { 0x04a91710, "MP950" },
    { 0x04a91712, "PIXMA MP530" },
    { 0x04a91713, "PIXMA MP830 Scanner" },
    { 0x04a91714, "MP160" },
    { 0x04a91715, "PIXMA MP180" },
    { 0x04a91716, "PIXMA MP460" },
    { 0x04a91717, "PIXMA MP510" },
    { 0x04a91718, "PIXMA MP600" },
    { 0x04a91719, "PIXMA MP600R" },
    { 0x04a9171a, "PIXMA MP810" },
    { 0x04a9171b, "PIXMA MP960" },
    { 0x04a9171c, "PIXMA MX7600" },
    { 0x04a91721, "PIXMA MP210" },
    { 0x04a91722, "PIXMA MP220" },
    { 0x04a91723, "PIXMA MP470" },
    { 0x04a91724, "PIXMA MP520 series" },
    { 0x04a91725, "PIXMA MP610" },
    { 0x04a91726, "PIXMA MP970" },
    { 0x04a91727, "PIXMA MX300" },
    { 0x04a91728, "PIXMA MX310 series" },
    { 0x04a91729, "PIXMA MX700" },
    { 0x04a9172b, "MP140 ser" },
    { 0x04a9172c, "PIXMA MX850" },
    { 0x04a9172d, "PIXMA MP980" },
    { 0x04a9172e, "PIXMA MP630" },
    { 0x04a9172f, "PIXMA MP620" },
    { 0x04a91730, "PIXMA MP540" },
    { 0x04a91731, "PIXMA MP480" },
    { 0x04a91732, "PIXMA MP240" },
    { 0x04a91733, "PIXMA MP260" },
    { 0x04a91734, "PIXMA MP190" },
    { 0x04a91735, "PIXMA MX860" },
    { 0x04a91736, "PIXMA MX320 series" },
    { 0x04a91737, "PIXMA MX330" },
    { 0x04a9173a, "PIXMA MP250" },
    { 0x04a9173b, "PIXMA MP270 All-In-One Printer" },
    { 0x04a9173c, "PIXMA MP490" },
    { 0x04a9173d, "PIXMA MP550" },
    { 0x04a9173e, "PIXMA MP560" },
    { 0x04a9173f, "PIXMA MP640" },
    { 0x04a91740, "PIXMA MP990" },
    { 0x04a91741, "PIXMA MX340" },
    { 0x04a91742, "PIXMA MX350" },
    { 0x04a91743, "PIXMA MX870" },
    { 0x04a91746, "PIXMA MP280" },
    { 0x04a91747, "PIXMA MP495" },
    { 0x04a91748, "PIXMA MG5100 Series" },
    { 0x04a91749, "PIXMA MG5200 Series" },
    { 0x04a9174a, "PIXMA MG6100 Series" },
    { 0x04a9174b, "PIXMA MG8100 Series" },
    { 0x04a9174d, "PIXMA MX360" },
    { 0x04a9174e, "PIXMA MX410" },
    { 0x04a9174f, "PIXMA MX420" },
    { 0x04a91750, "PIXMA MX880 Series" },
    { 0x04a91752, "PIXMA MG3100 Series" },
    { 0x04a91753, "PIXMA MG4100 Series" },
    { 0x04a91754, "PIXMA MG5300 Series" },
    { 0x04a91755, "PIXMA MG6200 Series" },
    { 0x04a91756, "PIXMA MG8200 Series" },
    { 0x04a91757, "PIXMA MP493" },
    { 0x04a91759, "PIXMA MX370 Series" },
    { 0x04a9175b, "PIXMA MX430 Series" },
    { 0x04a9175c, "PIXMA MX510 Series" },
    { 0x04a9175d, "PIXMA MX710 Series" },
    { 0x04a9175e, "PIXMA MX890 Series" },
    { 0x04a9175f, "PIXMA MP230" },
    { 0x04a91762, "PIXMA MG3200 Series" },
    { 0x04a91763, "PIXMA MG4200 Series" },
    { 0x04a91764, "PIXMA MG5400 Series" },
    { 0x04a91765, "PIXMA MG6300 Series" },
    { 0x04a91766, "PIXMA MX390 Series" },
    { 0x04a91768, "PIXMA MX450 Series" },
    { 0x04a91769, "PIXMA MX520 Series" },
    { 0x04a9176a, "PIXMA MX720 Series" },
    { 0x04a9176b, "PIXMA MX920 Series" },
    { 0x04a9176d, "PIXMA MG2500 Series" },
    { 0x04a9176e, "PIXMA MG3500 Series" },
    { 0x04a9176f, "PIXMA MG6500 Series" },
    { 0x04a91770, "PIXMA MG6400 Series" },
    { 0x04a91771, "PIXMA MG5500 Series" },
    { 0x04a91772, "PIXMA MG7100 Series" },
    { 0x04a91774, "PIXMA MX470 Series" },
    { 0x04a91775, "PIXMA MX530 Series" },
    { 0x04a9177c, "PIXMA MG7500 Series" },
    { 0x04a9177e, "PIXMA MG6600 Series" },
    { 0x04a9177f, "PIXMA MG5600 Series" },
    { 0x04a91780, "PIXMA MG2900 Series" },
    { 0x04a91787, "PIXMA MX490 Series" },
    { 0x04a9178a, "PIXMA MG3600 Series" },
    { 0x04a9178d, "PIXMA MG6853" },
    { 0x04a9180b, "PIXMA MG3000 series" },
    { 0x04a91856, "PIXMA TS6250" },
    { 0x04a91900, "CanoScan LiDE 90" },
    { 0x04a91901, "CanoScan 8800F" },
    { 0x04a91904, "CanoScan LiDE 100" },
    { 0x04a91905, "CanoScan LiDE 200" },
    { 0x04a91906, "CanoScan 5600F" },
    { 0x04a91907, "CanoScan LiDE 700F" },
    { 0x04a91909, "CanoScan LiDE 110" },
    { 0x04a9190a, "CanoScan LiDE 210" },
    { 0x04a9190d, "CanoScan 9000F Mark II" },
    { 0x04a9190e, "CanoScan LiDE 120" },
    { 0x04a9190f, "CanoScan LiDE 220" },
    { 0x04a92200, "CanoScan LiDE 25" },
    { 0x04a92201, "CanoScan FB320U" },
    { 0x04a92202, "CanoScan FB620U" },
    { 0x04a92204, "CanoScan FB630U" },
    { 0x04a92205, "CanoScan FB1210U" },
    { 0x04a92206, "CanoScan N650U/N656U" },
    { 0x04a92207, "CanoScan 1220U" },
    { 0x04a92208, "CanoScan D660U" },
    { 0x04a9220a, "CanoScan D2400UF" },
    { 0x04a9220b, "CanoScan D646U" },
    { 0x04a9220c, "CanoScan D1250U2" },
    { 0x04a9220d, "CanoScan N670U/N676U/LiDE 20" },
    { 0x04a9220e, "CanoScan N1240U/LiDE 30" },
    { 0x04a9220f, "CanoScan 8000F" },
    { 0x04a92210, "CanoScan 9900F" },
    { 0x04a92212, "CanoScan 5000F" },
    { 0x04a92213, "CanoScan LiDE 50/LiDE 35/LiDE 40" },
    { 0x04a92214, "CanoScan LiDE 80" },
    { 0x04a92215, "CanoScan 3000/3000F/3000ex" },
    { 0x04a92216, "CanoScan 3200F" },
    { 0x04a92217, "CanoScan 5200F" },
    { 0x04a92219, "CanoScan 9950F" },
    { 0x04a9221b, "CanoScan 4200F" },
    { 0x04a9221c, "CanoScan LiDE 60" },
    { 0x04a9221e, "CanoScan 8400F" },
    { 0x04a9221f, "CanoScan LiDE 500F" },
    { 0x04a92220, "CanoScan LIDE 25" },
    { 0x04a92224, "CanoScan LiDE 600F" },
    { 0x04a92225, "CanoScan LiDE 70" },
    { 0x04a92228, "CanoScan 4400F" },
    { 0x04a92229, "CanoScan 8600F" },
    { 0x04a92602, "MultiPASS C555" },
    { 0x04a92603, "MultiPASS C755" },
    { 0x04a9260a, "LBP810" },
    { 0x04a9260e, "LBP-2000" },
    { 0x04a92610, "MPC600F" },
    { 0x04a92611, "SmartBase MPC400" },
    { 0x04a92612, "MultiPASS C855" },
    { 0x04a92617, "LBP1210" },
    { 0x04a9261a, "iR1600" },
    { 0x04a9261b, "iR1610" },
    { 0x04a9261c, "iC2300" },
    { 0x04a9261f, "MPC200 Printer" },
    { 0x04a92621, "iR2000" },
    { 0x04a92622, "iR2010" },
    { 0x04a92623, "FAX-B180C" },
    { 0x04a92629, "FAXPHONE L75" },
    { 0x04a9262b, "LaserShot LBP-1120 Printer" },
    { 0x04a9262c, "imageCLASS D300" },
    { 0x04a9262d, "iR C3200" },
    { 0x04a9262f, "PIXMA MP730" },
    { 0x04a92630, "PIXMA MP700" },
    { 0x04a92631, "LASER CLASS 700" },
    { 0x04a92632, "FAX-L2000" },
    { 0x04a92633, "LASERCLASS 500" },
    { 0x04a92634, "PC-D300/FAX-L400/ICD300" },
    { 0x04a92635, "MPC190" },
    { 0x04a92636, "LBP3200" },
    { 0x04a92637, "iR C6800" },
    { 0x04a92638, "iR C3100" },
    { 0x04a9263c, "PIXMA MP360" },
    { 0x04a9263d, "PIXMA MP370" },
    { 0x04a9263e, "PIXMA MP390" },
    { 0x04a9263f, "PIXMA MP375R" },
    { 0x04a92646, "MF5530 Scanner Device V1.9.1" },
    { 0x04a92647, "MF5550 Composite" },
    { 0x04a9264c, "PIXMA MP740" },
    { 0x04a9264d, "PIXMA MP710" },
    { 0x04a9264e, "MF5630" },
    { 0x04a9264f, "MF5650 (FAX)" },
    { 0x04a92650, "iR 6800C EUR" },
    { 0x04a92651, "iR 3100C EUR" },
    { 0x04a92654, "LBP3600" },
    { 0x04a92655, "FP-L170/MF350/L380/L398" },
    { 0x04a92656, "iR1510-1670 CAPT Printer" },
    { 0x04a92657, "LBP3210" },
    { 0x04a92659, "MF8100" },
    { 0x04a9265b, "CAPT Printer" },
    { 0x04a9265c, "iR C3220" },
    { 0x04a9265d, "MF5730" },
    { 0x04a9265e, "MF5750" },
    { 0x04a9265f, "MF5770" },
    { 0x04a92660, "MF3110" },
    { 0x04a92663, "iR3570/iR4570" },
    { 0x04a92664, "iR2270/iR2870" },
    { 0x04a92665, "iR C2620" },
    { 0x04a92666, "iR C5800" },
    { 0x04a92667, "iR85PLUS" },
    { 0x04a92669, "iR105PLUS" },
    { 0x04a9266a, "LBP3000" },
    { 0x04a9266b, "iR8070" },
    { 0x04a9266c, "iR9070" },
    { 0x04a9266d, "iR 5800C EUR" },
    { 0x04a9266e, "CAPT Device" },
    { 0x04a9266f, "iR2230" },
    { 0x04a92670, "iR3530" },
    { 0x04a92671, "iR5570/iR6570" },
    { 0x04a92672, "iR C3170" },
    { 0x04a92673, "iR 3170C EUR" },
    { 0x04a92674, "FAX-L120" },
    { 0x04a92675, "iR2830" },
    { 0x04a92676, "LBP2900" },
    { 0x04a92677, "iR C2570" },
    { 0x04a92678, "iR 2570C EUR" },
    { 0x04a92679, "LBP5000" },
    { 0x04a9267a, "iR2016" },
    { 0x04a9267b, "iR2020" },
    { 0x04a9267d, "MF7100 series" },
    { 0x04a9267e, "LBP3300" },
    { 0x04a92684, "MF3200 series" },
    { 0x04a92686, "MF6500 series" },
    { 0x04a92687, "iR4530" },
    { 0x04a92688, "LBP3460" },
    { 0x04a92689, "FAX-L180/L380S/L398S" },
    { 0x04a9268a, "LC310/L390/L408S" },
    { 0x04a9268b, "LBP3500" },
    { 0x04a9268c, "iR C6870" },
    { 0x04a9268d, "iR 6870C EUR" },
    { 0x04a9268e, "iR C5870" },
    { 0x04a9268f, "iR 5870C EUR" },
    { 0x04a92691, "iR7105" },
    { 0x04a926a1, "LBP5300" },
    { 0x04a926a3, "MF4100 series" },
    { 0x04a926a4, "LBP5100" },
    { 0x04a926b0, "MF4600 series" },
    { 0x04a926b4, "MF4010 series" },
    { 0x04a926b5, "MF4200 series" },
    { 0x04a926b6, "FAX-L140/L130" },
    { 0x04a926b9, "LBP3310" },
    { 0x04a926ba, "LBP5050" },
    { 0x04a926da, "LBP3010/LBP3018/LBP3050" },
    { 0x04a926db, "LBP3100/LBP3108/LBP3150" },
    { 0x04a926e6, "iR1024" },
    { 0x04a926ea, "LBP9100C" },
    { 0x04a926ee, "MF4320-4350" },
    { 0x04a926f1, "LBP7200C" },
    { 0x04a926ff, "LBP6300" },
    { 0x04a9271a, "LBP6000" },
    { 0x04a9271b, "LBP6200" },
    { 0x04a9271c, "LBP7010C/7018C" },
    { 0x04a92736, "I-SENSYS MF4550d" },
    { 0x04a92737, "MF4410" },
    { 0x04a92742, "imageRUNNER1133 series" },
    { 0x04a92771, "LBP6020" },
    { 0x04a92796, "LBP6230/6240" },
    { 0x04a93041, "PowerShot S10" },
    { 0x04a93042, "CanoScan FS4000US Film Scanner" },
    { 0x04a93043, "PowerShot S20" },
    { 0x04a93044, "EOS D30" },
    { 0x04a93045, "PowerShot S100" },
    { 0x04a93046, "IXY Digital" },
    { 0x04a93047, "Digital IXUS" },
    { 0x04a93048, "PowerShot G1" },
    { 0x04a93049, "PowerShot Pro90 IS" },
    { 0x04a9304a, "CP-10" },
    { 0x04a9304b, "IXY Digital 300" },
    { 0x04a9304c, "PowerShot S300" },
    { 0x04a9304d, "Digital IXUS 300" },
    { 0x04a9304e, "PowerShot A20" },
    { 0x04a9304f, "PowerShot A10" },
    { 0x04a93050, "PowerShot unknown 1" },
    { 0x04a93051, "PowerShot S110" },
    { 0x04a93052, "Digital IXUS V" },
    { 0x04a93055, "PowerShot G2" },
    { 0x04a93056, "PowerShot S40" },
    { 0x04a93057, "PowerShot S30" },
    { 0x04a93058, "PowerShot A40" },
    { 0x04a93059, "PowerShot A30" },
    { 0x04a9305b, "ZR45MC Digital Camcorder" },
    { 0x04a9305c, "PowerShot unknown 2" },
    { 0x04a93060, "EOS D60" },
    { 0x04a93061, "PowerShot A100" },
    { 0x04a93062, "PowerShot A200" },
    { 0x04a93063, "CP-100" },
    { 0x04a93065, "PowerShot S200" },
    { 0x04a93066, "Digital IXUS 330" },
    { 0x04a93067, "MV550i Digital Video Camera" },
    { 0x04a93069, "PowerShot G3" },
    { 0x04a9306a, "Digital unknown 3" },
    { 0x04a9306b, "MVX2i Digital Video Camera" },
    { 0x04a9306c, "PowerShot S45" },
    { 0x04a9306d, "Canon PowerShot S45" },
    { 0x04a9306e, "PowerShot G3 (normal mode)" },
    { 0x04a9306f, "Canon PowerShot G3" },
    { 0x04a93070, "PowerShot S230" },
    { 0x04a93071, "Canon Digital IXUS v3" },
    { 0x04a93072, "Canon PowerShot SD100" },
    { 0x04a93073, "Canon PowerShot A70" },
    { 0x04a93074, "Canon PowerShot A60" },
    { 0x04a93075, "Canon PowerShot S400" },
    { 0x04a93076, "Canon PowerShot A300" },
    { 0x04a93077, "Canon PowerShot S50" },
    { 0x04a93078, "ZR70MC Digital Camcorder" },
    { 0x04a9307a, "MV650i (normal mode)" },
    { 0x04a9307b, "MV630i Digital Video Camera" },
    { 0x04a9307c, "CP-200" },
    { 0x04a9307d, "CP-300" },
    { 0x04a9307f, "Optura 20" },
    { 0x04a93080, "MVX150i (normal mode) / Optura 20 (normal mode)" },
    { 0x04a93081, "Optura 10" },
    { 0x04a93082, "MVX100i / Optura 10" },
    { 0x04a93083, "EOS 10D" },
    { 0x04a93084, "EOS 300D / EOS Digital Rebel" },
    { 0x04a93085, "Canon PowerShot G5" },
    { 0x04a93087, "Canon Elura 50" },
    { 0x04a93088, "Elura 50 (normal mode)" },
    { 0x04a9308d, "Canon MVX3i" },
    { 0x04a9308e, "FV M1 (normal mode) / MVX 3i (normal mode) / Optura Xi (normal mode)" },
    { 0x04a93093, "Optura 300" },
    { 0x04a93096, "IXY DV M2 (normal mode) / MVX 10i (normal mode)" },
    { 0x04a93099, "Canon EOS Kiss Digital" },
    { 0x04a9309a, "Canon PowerShot A80" },
    { 0x04a9309b, "Canon Digital IXUS i" },
    { 0x04a9309c, "Canon PowerShot S1 IS" },
    { 0x04a9309d, "Powershot Pro 1" },
    { 0x04a9309f, "Camera" },
    { 0x04a930a0, "Canon MV750i" },
    { 0x04a930a1, "Camera" },
    { 0x04a930a2, "Camera" },
    { 0x04a930a5, "Canon Elura 65" },
    { 0x04a930a8, "Elura 60E/Optura 40 (ptp)" },
    { 0x04a930a9, "MVX25i (normal mode) / Optura 40 (normal mode)" },
    { 0x04a930b1, "Canon Powershot S70" },
    { 0x04a930b2, "Canon Powershot S60" },
    { 0x04a930b3, "Canon Powershot G6" },
    { 0x04a930b4, "Canon PowerShot S500" },
    { 0x04a930b5, "Canon PowerShot A75" },
    { 0x04a930b6, "Canon Digital IXUS IIs" },
    { 0x04a930b7, "Canon PowerShot A400" },
    { 0x04a930b8, "Canon PowerShot A310" },
    { 0x04a930b9, "Canon PowerShot A85" },
    { 0x04a930ba, "Canon PowerShot S410" },
    { 0x04a930bb, "Canon PowerShot A95" },
    { 0x04a930bc, "Canon EOS 10D" },
    { 0x04a930bd, "CP-220" },
    { 0x04a930be, "CP-330" },
    { 0x04a930bf, "Canon Digital IXUS 40" },
    { 0x04a930c0, "Canon Digital IXUS 30" },
    { 0x04a930c1, "Canon PowerShot A520" },
    { 0x04a930c2, "Canon PowerShot A510" },
    { 0x04a930c4, "Digital IXUS i5 (normal mode) / IXY Digital L2 (normal mode) / PowerShot SD20 (normal mode)" },
    { 0x04a930ea, "Canon EOS 1D Mark II" },
    { 0x04a930eb, "EOS 20D" },
    { 0x04a930ec, "Canon EOS 20D" },
    { 0x04a930ee, "Canon EOS 350D" },
    { 0x04a930ef, "Canon EOS 350D" },
    { 0x04a930f0, "Canon PowerShot S2 IS" },
    { 0x04a930f1, "Canon Digital IXUS Wireless" },
    { 0x04a930f2, "Canon PowerShot SD500" },
    { 0x04a930f4, "Canon Digital IXUS iZ" },
    { 0x04a930f5, "SELPHY CP500" },
    { 0x04a930f6, "SELPHY CP400" },
    { 0x04a930f8, "Canon PowerShot A430" },
    { 0x04a930f9, "Canon PowerShot A410" },
    { 0x04a930fa, "Canon PowerShot S80" },
    { 0x04a930fc, "Canon PowerShot A620" },
    { 0x04a930fd, "Canon PowerShot A610" },
    { 0x04a930fe, "Canon Digital IXUS 65" },
    { 0x04a930ff, "Canon PowerShot SD450" },
    { 0x04a93100, "PowerShot TX1" },
    { 0x04a93102, "Canon EOS 5D" },
    { 0x04a93105, "Canon Optura 600" },
    { 0x04a9310b, "SELPHY CP600" },
    { 0x04a9310e, "Canon Digital IXUS 50" },
    { 0x04a9310f, "Canon PowerShot A420" },
    { 0x04a93110, "Canon EOS Kiss Digital X" },
    { 0x04a93113, "Canon EOS 30D" },
    { 0x04a93115, "Canon PowerShot SD900" },
    { 0x04a93116, "Canon Digital IXUS 750" },
    { 0x04a93117, "Canon PowerShot A700" },
    { 0x04a93119, "Canon Digital IXUS 800" },
    { 0x04a9311a, "Canon PowerShot S3 IS" },
    { 0x04a9311b, "Canon PowerShot A540" },
    { 0x04a9311c, "Canon PowerShot SD600" },
    { 0x04a93125, "Canon PowerShot G7" },
    { 0x04a93126, "Canon PowerShot A530" },
    { 0x04a93127, "SELPHY CP710" },
    { 0x04a93128, "SELPHY CP510" },
    { 0x04a9312d, "Elura 100" },
    { 0x04a93136, "Canon Digital IXUS 850 IS" },
    { 0x04a93137, "Canon PowerShot SD40" },
    { 0x04a93138, "Canon PowerShot A710 IS" },
    { 0x04a93139, "Canon PowerShot A640" },
    { 0x04a9313a, "Canon PowerShot A630" },
    { 0x04a93141, "SELPHY ES1" },
    { 0x04a93142, "SELPHY CP730" },
    { 0x04a93143, "SELPHY CP720" },
    { 0x04a93145, "Canon EOS Kiss X2" },
    { 0x04a93146, "Canon EOS 40D" },
    { 0x04a93147, "Canon EOS 1D Mark III" },
    { 0x04a93148, "Canon PowerShot S5 IS" },
    { 0x04a93149, "Canon PowerShot A460" },
    { 0x04a9314b, "Canon PowerShot SD850" },
    { 0x04a9314c, "Canon PowerShot A570 IS" },
    { 0x04a9314d, "Canon PowerShot A560" },
    { 0x04a9314e, "Canon PowerShot SD750" },
    { 0x04a9314f, "Canon PowerShot SD1000" },
    { 0x04a93150, "Canon PowerShot A550" },
    { 0x04a93155, "Canon PowerShot A450" },
    { 0x04a9315a, "Canon PowerShot G9" },
    { 0x04a9315b, "Canon PowerShot A650IS" },
    { 0x04a9315d, "Canon PowerShot A720 IS" },
    { 0x04a9315e, "Canon Powershot SX100 IS" },
    { 0x04a9315f, "Canon Digital IXUS 960 IS" },
    { 0x04a93160, "Canon Digital IXUS 860 IS" },
    { 0x04a93170, "SELPHY CP750" },
    { 0x04a93171, "SELPHY CP740" },
    { 0x04a93172, "SELPHY CP520" },
    { 0x04a93173, "Canon Digital IXUS 970 IS" },
    { 0x04a93174, "Canon Digital IXUS 85 IS" },
    { 0x04a93175, "Canon PowerShot SD770 IS" },
    { 0x04a93176, "Canon PowerShot A590 IS" },
    { 0x04a93177, "Canon PowerShot A580" },
    { 0x04a9317a, "Canon PowerShot A740" },
    { 0x04a9317b, "Canon EOS 1000D" },
    { 0x04a93184, "Canon Powershot SD1100 IS" },
    { 0x04a93185, "SELPHY ES2" },
    { 0x04a93186, "SELPHY ES20" },
    { 0x04a9318d, "Canon PowerShot SX10 IS" },
    { 0x04a9318e, "PowerShot A1000 IS" },
    { 0x04a9318f, "Canon PowerShot G10" },
    { 0x04a93191, "Canon PowerShot A2000 IS" },
    { 0x04a93192, "Canon PowerShot SX110 IS" },
    { 0x04a93193, "Canon IXY 3000 IS" },
    { 0x04a93195, "PowerShot SX1 IS" },
    { 0x04a93196, "Canon PowerShot SD880 IS" },
    { 0x04a93199, "Canon EOS 5D Mark II" },
    { 0x04a9319a, "Canon EOS 7D" },
    { 0x04a9319b, "Canon EOS 50D" },
    { 0x04a931aa, "SELPHY CP770" },
    { 0x04a931ab, "SELPHY CP760" },
    { 0x04a931ad, "PowerShot E1" },
    { 0x04a931af, "SELPHY ES3" },
    { 0x04a931b0, "SELPHY ES30" },
    { 0x04a931b1, "SELPHY CP530" },
    { 0x04a931bc, "Canon PowerShot D10" },
    { 0x04a931bd, "Canon Digital IXUS 110 IS" },
    { 0x04a931be, "Canon PowerShot A2100 IS" },
    { 0x04a931bf, "Canon PowerShot A480" },
    { 0x04a931c0, "Canon PowerShot SX200 IS" },
    { 0x04a931c1, "Canon PowerShot SD970 IS" },
    { 0x04a931c2, "Canon PowerShot SD780 IS" },
    { 0x04a931c3, "Canon PowerShot A1100 IS" },
    { 0x04a931c4, "Canon Digital IXUS 95 IS" },
    { 0x04a931cf, "Canon EOS Kiss X3" },
    { 0x04a931d0, "Canon EOS 1D Mark IV" },
    { 0x04a931dd, "SELPHY CP780" },
    { 0x04a931df, "Canon PowerShot G11" },
    { 0x04a931e0, "Canon PowerShot SX120 IS" },
    { 0x04a931e1, "PowerShot S90" },
    { 0x04a931e4, "Canon PowerShot SX20 IS" },
    { 0x04a931e5, "Digital IXUS 200 IS" },
    { 0x04a931e6, "Canon PowerShot SD940 IS" },
    { 0x04a931e7, "SELPHY CP790" },
    { 0x04a931ea, "Canon Rebel T2i" },
    { 0x04a931ee, "SELPHY ES40" },
    { 0x04a931ef, "PowerShot A495" },
    { 0x04a931f0, "PowerShot A490" },
    { 0x04a931f1, "Canon PowerShot A3100 IS" },
    { 0x04a931f2, "Canon PowerShot A3000 IS" },
    { 0x04a931f3, "Canon Digital IXUS 130" },
    { 0x04a931f4, "Canon PowerShot SD1300 IS" },
    { 0x04a931f5, "Powershot SD3500 IS / IXUS 210 IS" },
    { 0x04a931f6, "Canon PowerShot SX210 IS" },
    { 0x04a931f7, "Powershot SD4000 IS / IXUS 300 HS / IXY 30S" },
    { 0x04a931f8, "Powershot SD4500 IS / IXUS 1000 HS / IXY 50S" },
    { 0x04a931ff, "Digital IXUS 55" },
    { 0x04a93209, "Vixia HF S21 A" },
    { 0x04a9320f, "PowerShot G12" },
    { 0x04a93210, "Powershot SX30 IS" },
    { 0x04a93211, "Canon PowerShot SX130 IS" },
    { 0x04a93212, "Powershot S95" },
    { 0x04a93214, "SELPHY CP800" },
    { 0x04a93215, "Canon EOS 60D" },
    { 0x04a93217, "Canon EOS 1100D" },
    { 0x04a93218, "Canon EOS 600D" },
    { 0x04a93219, "EOS 1D X" },
    { 0x04a93223, "PowerShot A3300 IS" },
    { 0x04a93224, "PowerShot A3200 IS" },
    { 0x04a93225, "Canon IXUS 310IS" },
    { 0x04a93226, "Canon PowerShot A800" },
    { 0x04a93227, "PowerShot ELPH 100 HS / IXUS 115 HS" },
    { 0x04a93228, "Canon PowerShot SX230HS" },
    { 0x04a93229, "PowerShot ELPH 300 HS / IXUS 220 HS" },
    { 0x04a9322a, "PowerShot A2200" },
    { 0x04a9322b, "Powershot A1200" },
    { 0x04a9322c, "Canon PowerShot SX220HS" },
    { 0x04a93233, "Canon PowerShot G1 X" },
    { 0x04a93234, "PowerShot SX150 IS" },
    { 0x04a93235, "PowerShot ELPH 510 HS / IXUS 1100 HS" },
    { 0x04a93236, "PowerShot S100" },
    { 0x04a93237, "PowerShot ELPH 310 HS / IXUS 230 HS" },
    { 0x04a93238, "Canon PowerShot SX40HS" },
    { 0x04a9323a, "Canon EOS 5D Mark III" },
    { 0x04a9323b, "Canon Rebel T4i" },
    { 0x04a9323d, "Canon EOS M" },
    { 0x04a9323e, "PowerShot A1300" },
    { 0x04a9323f, "PowerShot A810" },
    { 0x04a93240, "PowerShot ELPH 320 HS / IXUS 240 HS" },
    { 0x04a93241, "PowerShot ELPH 110 HS / IXUS 125 HS" },
    { 0x04a93242, "PowerShot D20" },
    { 0x04a93243, "Canon PowerShot A4000IS" },
    { 0x04a93244, "PowerShot SX260 HS" },
    { 0x04a93245, "Canon PowerShot SX240HS" },
    { 0x04a93246, "PowerShot ELPH 530 HS / IXUS 510 HS" },
    { 0x04a93247, "PowerShot ELPH 520 HS / IXUS 500 HS" },
    { 0x04a93248, "PowerShot A3400 IS" },
    { 0x04a93249, "Canon PowerShot A2400IS" },
    { 0x04a9324a, "PowerShot A2300" },
    { 0x04a93250, "Canon EOS 6D" },
    { 0x04a93252, "EOS 1D C" },
    { 0x04a93253, "EOS 70D" },
    { 0x04a93255, "SELPHY CP900" },
    { 0x04a93256, "SELPHY CP810" },
    { 0x04a93258, "PowerShot G15" },
    { 0x04a93259, "PowerShot SX50 HS" },
    { 0x04a9325a, "PowerShot SX160 IS" },
    { 0x04a9325b, "Canon PowerShot S110" },
    { 0x04a9325c, "Canon PowerShot SX500IS" },
    { 0x04a9325e, "PowerShot N" },
    { 0x04a9325f, "PowerShot SX280 HS" },
    { 0x04a93260, "PowerShot SX270 HS" },
    { 0x04a93261, "PowerShot A3500 IS" },
    { 0x04a93262, "PowerShot A2600" },
    { 0x04a93263, "PowerShot SX275 HS" },
    { 0x04a93264, "PowerShot A1400" },
    { 0x04a93265, "Powershot ELPH 130 IS / IXUS 140" },
    { 0x04a93266, "Powershot ELPH 120 IS / IXUS 135" },
    { 0x04a93268, "PowerShot ELPH 330 HS / IXUS 255 HS" },
    { 0x04a9326f, "EOS 7D Mark II" },
    { 0x04a93270, "EOS 100D" },
    { 0x04a93271, "PowerShot A2500" },
    { 0x04a93272, "EOS 700D" },
    { 0x04a93274, "PowerShot G16" },
    { 0x04a93275, "PowerShot S120" },
    { 0x04a93276, "PowerShot SX170 IS" },
    { 0x04a93277, "PowerShot SX510 HS" },
    { 0x04a93278, "PowerShot S200" },
    { 0x04a9327a, "SELPHY CP910" },
    { 0x04a9327b, "SELPHY CP820" },
    { 0x04a9327d, "Powershot ELPH 115 IS / IXUS 132" },
    { 0x04a9327f, "EOS Rebel T5 / EOS 1200D / EOS Kiss X70" },
    { 0x04a93284, "PowerShot D30" },
    { 0x04a93285, "PowerShot SX700 HS" },
    { 0x04a93286, "PowerShot SX600 HS" },
    { 0x04a93287, "PowerShot ELPH 140 IS / IXUS 150" },
    { 0x04a93288, "Powershot ELPH 135 / IXUS 145" },
    { 0x04a93289, "PowerShot ELPH 340 HS / IXUS 265 HS" },
    { 0x04a9328a, "PowerShot ELPH 150 IS / IXUS 155" },
    { 0x04a9328b, "PowerShot N Facebook(R) Ready" },
    { 0x04a93299, "EOS M3" },
    { 0x04a9329a, "PowerShot SX60 HS" },
    { 0x04a9329b, "PowerShot SX520 HS" },
    { 0x04a9329c, "PowerShot SX400 IS" },
    { 0x04a9329d, "PowerShot G7 X" },
    { 0x04a9329f, "PowerShot SX530 HS" },
    { 0x04a932a0, "EOS M10" },
    { 0x04a932a6, "PowerShot SX710 HS" },
    { 0x04a932a7, "PowerShot SX610 HS" },
    { 0x04a932a8, "PowerShot G3 X" },
    { 0x04a932aa, "Powershot ELPH 160 / IXUS 160" },
    { 0x04a932ab, "PowerShot ELPH 350HS / IXUS 275 HS" },
    { 0x04a932ac, "PowerShot ELPH 170 IS / IXUS 170" },
    { 0x04a932ad, "PowerShot SX410 IS" },
    { 0x04a932b1, "SELPHY CP1200" },
    { 0x04a932b2, "PowerShot G9 X" },
    { 0x04a932b3, "PowerShot G5 X" },
    { 0x04a932b4, "EOS Rebel T6" },
    { 0x04a932bb, "EOS M5" },
    { 0x04a932bf, "PowerShot SX420 IS" },
    { 0x04a932c1, "PowerShot ELPH 180 / IXUS 175" },
    { 0x04a932c2, "PowerShot SX720 HS" },
    { 0x04a932c5, "EOS M6" },
    { 0x04a932cc, "EOS 200D" },
    { 0x04a932d1, "EOS M100" },
    { 0x04a932d2, "EOS M50" },
    { 0x04a932d4, "Powershot ELPH 185 / IXUS 185 / IXY 200" },
    { 0x04a932d5, "PowerShot SX430 IS" },
    { 0x04a932db, "SELPHY CP1300" },
    { 0x04ad2501, "Bluetooth Device" },
    { 0x04b00102, "Coolpix 990" },
    { 0x04b00103, "Coolpix 880" },
    { 0x04b00104, "Coolpix 995" },
    { 0x04b00106, "Coolpix 775" },
    { 0x04b00107, "Coolpix 5000" },
    { 0x04b00108, "Coolpix 2500" },
    { 0x04b00109, "Nikon Coolpix 2500" },
    { 0x04b0010a, "Coolpix 4500" },
    { 0x04b0010b, "Nikon Coolpix 4500" },
    { 0x04b0010d, "Nikon Coolpix 5700" },
    { 0x04b0010e, "Coolpix 4300 (storage)" },
    { 0x04b0010f, "Nikon Coolpix 4300" },
    { 0x04b00110, "Coolpix 3500 (Sierra Mode)" },
    { 0x04b00111, "Nikon Coolpix 3500" },
    { 0x04b00112, "Nikon Coolpix 885" },
    { 0x04b00113, "Nikon Coolpix 5000" },
    { 0x04b00114, "Coolpix 3100 (storage)" },
    { 0x04b00115, "Nikon Coolpix 3100" },
    { 0x04b00117, "Nikon Coolpix 2100" },
    { 0x04b00119, "Nikon Coolpix 5400" },
    { 0x04b0011d, "Nikon Coolpix 3700" },
    { 0x04b0011f, "Nikon Coolpix 8700" },
    { 0x04b00121, "Nikon Coolpix 3200" },
    { 0x04b00122, "Nikon Coolpix 2200" },
    { 0x04b00124, "Coolpix 8400 (mass storage mode)" },
    { 0x04b00125, "Coolpix 8400 (ptp)" },
    { 0x04b00126, "Coolpix 8800" },
    { 0x04b00127, "Nikon Coolpix 8800" },
    { 0x04b00129, "Nikon Coolpix 4800" },
    { 0x04b0012c, "Coolpix 4100 (storage)" },
    { 0x04b0012d, "Nikon Coolpix 4100" },
    { 0x04b0012e, "Nikon Coolpix 5600" },
    { 0x04b00130, "Nikon Coolpix 4600" },
    { 0x04b00131, "Nikon Coolpix 4600a" },
    { 0x04b00135, "Nikon Coolpix 5900" },
    { 0x04b00136, "Coolpix 7900 (storage)" },
    { 0x04b00137, "Nikon Coolpix 7900" },
    { 0x04b00139, "Nikon Coolpix 7600" },
    { 0x04b0013a, "Coolpix 100 (storage)" },
    { 0x04b0013b, "Coolpix 100 (ptp)" },
    { 0x04b00140, "Nikon Coolpix P1" },
    { 0x04b00141, "Coolpix P2 (storage)" },
    { 0x04b00142, "Nikon Coolpix P2" },
    { 0x04b00144, "Nikon Coolpix S4" },
    { 0x04b0014e, "Nikon Coolpix S6" },
    { 0x04b00157, "Nikon Coolpix S7c" },
    { 0x04b0015b, "Nikon Coolpix P5000" },
    { 0x04b0015d, "Nikon Coolpix S500" },
    { 0x04b0015f, "Nikon Coolpix L12" },
    { 0x04b00161, "Nikon Coolpix S200" },
    { 0x04b00163, "Nikon Coolpix P5100" },
    { 0x04b00169, "Nikon Coolpix P50" },
    { 0x04b0016b, "Nikon Coolpix P80" },
    { 0x04b0016f, "Nikon Coolpix P6000" },
    { 0x04b00171, "Nikon Coolpix S60" },
    { 0x04b00173, "Nikon Coolpix P90" },
    { 0x04b00177, "Nikon Coolpix S220" },
    { 0x04b00178, "Nikon Coolpix S225" },
    { 0x04b0017d, "Nikon Coolpix P100" },
    { 0x04b0017e, "Nikon Coolpix L110" },
    { 0x04b0017f, "Nikon Coolpix P7000" },
    { 0x04b00184, "Nikon Coolpix P500" },
    { 0x04b00185, "Nikon Coolpix L120" },
    { 0x04b00186, "Nikon Coolpix S9100" },
    { 0x04b00188, "Nikon Coolpix AW100" },
    { 0x04b0018b, "Nikon Coolpix P7100" },
    { 0x04b00202, "Nikon Coolpix SQ" },
    { 0x04b00203, "Coolpix 4200 (mass storage mode)" },
    { 0x04b00204, "Nikon Coolpix 4200" },
    { 0x04b00205, "Coolpix 5200 (storage)" },
    { 0x04b00206, "Nikon Coolpix 5200" },
    { 0x04b00208, "Nikon Coolpix L1" },
    { 0x04b0020c, "Nikon Coolpix P4" },
    { 0x04b0021e, "Nikon Coolpix S6000" },
    { 0x04b0021f, "Nikon Coolpix S8000" },
    { 0x04b00220, "Nikon Coolpix S5100" },
    { 0x04b00221, "Nikon Coolpix P300" },
    { 0x04b00222, "Nikon Coolpix S8200" },
    { 0x04b00223, "Nikon Coolpix P510" },
    { 0x04b00225, "Nikon Coolpix P7700" },
    { 0x04b00301, "Coolpix 2000 (storage)" },
    { 0x04b00302, "Nikon Coolpix 2000" },
    { 0x04b00305, "Nikon Coolpix L4" },
    { 0x04b00309, "Nikon Coolpix L11" },
    { 0x04b0030b, "Nikon Coolpix L10" },
    { 0x04b00311, "Nikon Coolpix P60" },
    { 0x04b00315, "Nikon Coolpix L16" },
    { 0x04b00317, "Nikon Coolpix L20" },
    { 0x04b00318, "Nikon Coolpix L19" },
    { 0x04b0031b, "Nikon Coolpix S3000" },
    { 0x04b00320, "Nikon Coolpix S3100" },
    { 0x04b00324, "Nikon Coolpix L23" },
    { 0x04b0032a, "Nikon Coolpix S3300" },
    { 0x04b0032d, "Nikon Coolpix S2600" },
    { 0x04b00337, "Nikon Coolpix S01" },
    { 0x04b00402, "Nikon DSC D100" },
    { 0x04b00403, "D2H (mass storage mode)" },
    { 0x04b00404, "Nikon D2H SLR" },
    { 0x04b00405, "D70 (mass storage mode)" },
    { 0x04b00406, "Nikon DSC D70" },
    { 0x04b00408, "Nikon D2X SLR" },
    { 0x04b00409, "D50 digital camera" },
    { 0x04b0040a, "Nikon D50" },
    { 0x04b0040c, "Nikon D2Hs" },
    { 0x04b0040e, "Nikon DSC D70s" },
    { 0x04b0040f, "D200 (mass storage mode)" },
    { 0x04b00410, "Nikon DSC D200" },
    { 0x04b00412, "Nikon DSC D80" },
    { 0x04b00413, "D40 (mass storage mode)" },
    { 0x04b00414, "Nikon DSC D40" },
    { 0x04b00416, "Nikon DSC D2Xs" },
    { 0x04b00418, "Nikon DSC D40x" },
    { 0x04b0041a, "Nikon DSC D300" },
    { 0x04b0041c, "Nikon D3" },
    { 0x04b0041e, "Nikon DSC D60" },
    { 0x04b00421, "Nikon DSC D90" },
    { 0x04b00422, "Nikon DSC D700" },
    { 0x04b00423, "Nikon DSC D5000" },
    { 0x04b00424, "Nikon DSC D3000" },
    { 0x04b00425, "Nikon DSC D300s" },
    { 0x04b00426, "Nikon DSC D3s" },
    { 0x04b00427, "Nikon DSC D3100" },
    { 0x04b00428, "Nikon DSC D7000" },
    { 0x04b00429, "Nikon DSC D5100" },
    { 0x04b0042a, "Nikon DSC D800" },
    { 0x04b0042b, "Nikon DSC D4" },
    { 0x04b0042d, "Nikon DSC D600" },
    { 0x04b0042e, "Nikon DSC D800E" },
    { 0x04b0042f, "Nikon DSC D5200" },
    { 0x04b00430, "D7100" },
    { 0x04b00436, "D810" },
    { 0x04b0043f, "D5600" },
    { 0x04b00601, "Nikon V1" },
    { 0x04b00602, "Nikon J1" },
    { 0x04b00f03, "PD-10 Wireless Printer Adapter" },
    { 0x04b04000, "Coolscan LS 40 ED" },
    { 0x04b04001, "LS 50 ED/Coolscan V ED" },
    { 0x04b04002, "Super Coolscan LS-5000 ED" },
    { 0x04b33003, "Rapid Access III Keyboard" },
    { 0x04b33004, "Media Access Pro Keyboard" },
    { 0x04b3300a, "Rapid Access IIIe Keyboard" },
    { 0x04b33016, "UltraNav Keyboard Hub" },
    { 0x04b33018, "UltraNav Keyboard" },
    { 0x04b3301a, "2-port low-power hub" },
    { 0x04b3301b, "SK-8815 Keyboard" },
    { 0x04b3301c, "Enhanced Performance Keyboard" },
    { 0x04b33020, "Enhanced Performance Keyboard" },
    { 0x04b33025, "NetVista Full Width Keyboard" },
    { 0x04b33100, "NetVista Mouse" },
    { 0x04b33103, "ScrollPoint Pro Mouse" },
    { 0x04b33104, "ScrollPoint Wireless Mouse" },
    { 0x04b33105, "ScrollPoint Optical (HID)" },
    { 0x04b33107, "ThinkPad 800dpi Optical Travel Mouse" },
    { 0x04b33108, "800dpi Optical Mouse w/ Scroll Point" },
    { 0x04b33109, "Optical ScrollPoint Pro Mouse" },
    { 0x04b3310b, "Red Wheel Mouse" },
    { 0x04b3310c, "Wheel Mouse" },
    { 0x04b34427, "Portable CD ROM" },
    { 0x04b34482, "Serial Converter" },
    { 0x04b34484, "SMSC USB20H04 3-Port Hub [ThinkPad X4 UltraBase, Wistron S Note-3 Media Slice]" },
    { 0x04b34485, "ThinkPad Dock Hub" },
    { 0x04b34524, "40 Character Vacuum Fluorescent Display" },
    { 0x04b34525, "Double sided CRT" },
    { 0x04b34535, "4610 Suremark Printer" },
    { 0x04b34550, "NVRAM (128 KB)" },
    { 0x04b34554, "Cash Drawer" },
    { 0x04b34580, "Hub w/ NVRAM" },
    { 0x04b34581, "4800-2xx Hub w/ Cash Drawer" },
    { 0x04b34604, "Keyboard w/ Card Reader" },
    { 0x04b34671, "4820 LCD w/ MSR/KB" },
    { 0x04b40001, "Mouse" },
    { 0x04b40002, "CY7C63x0x Thermometer" },
    { 0x04b40033, "Mouse" },
    { 0x04b40060, "Wireless optical mouse" },
    { 0x04b400f3, "FX3 micro-controller (DFU mode)" },
    { 0x04b40100, "Cino FuzzyScan F760-B" },
    { 0x04b40101, "Keyboard/Hub" },
    { 0x04b40102, "Keyboard with APM" },
    { 0x04b40130, "MyIRC Remote Receiver" },
    { 0x04b40306, "Telephone Receiver" },
    { 0x04b40407, "Optical Skype Mouse" },
    { 0x04b40bad, "MetaGeek Wi-Spy" },
    { 0x04b41002, "CY7C63001 R100 FM Radio" },
    { 0x04b41006, "Human Interface Device" },
    { 0x04b42050, "hub" },
    { 0x04b42830, "Opera1 DVB-S (cold state)" },
    { 0x04b43813, "NANO BIOS Programmer" },
    { 0x04b44235, "Monitor 02 Driver" },
    { 0x04b44381, "SCAPS USC-1 Scanner Controller" },
    { 0x04b44611, "Storage Adapter FX2 (CY)" },
    { 0x04b44616, "Flash Disk (TPP)" },
    { 0x04b44624, "DS-Xtreme Flash Card" },
    { 0x04b44717, "West Bridge" },
    { 0x04b45201, "Combi Keyboard-Hub (Hub)" },
    { 0x04b45202, "Combi Keyboard-Hub (Keyboard)" },
    { 0x04b45500, "HID->COM RS232 Adapter" },
    { 0x04b45a9b, "Dacal CD/DVD Library D-101/DC-300/DC-016RW" },
    { 0x04b46370, "ViewMate Desktop Mouse CC2201" },
    { 0x04b46502, "CY4609" },
    { 0x04b46506, "CY4603" },
    { 0x04b4650a, "CY4613" },
    { 0x04b46560, "CY7C65640 USB-2.0 \"TetraHub\"" },
    { 0x04b46570, "Unprogrammed CY7C65632/34 hub HX2VL" },
    { 0x04b46572, "Unprogrammed CY7C65642 hub" },
    { 0x04b46830, "CY7C68300A EZ-USB AT2 USB 2.0 to ATA/ATAPI" },
    { 0x04b46831, "Storage Adapter ISD-300LP (CY)" },
    { 0x04b47417, "Wireless PC Lock/Ultra Mouse" },
    { 0x04b48329, "USB To keyboard/Mouse Converter" },
    { 0x04b48613, "CY7C68013 EZ-USB FX2 USB 2.0 Development Kit" },
    { 0x04b48614, "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" },
    { 0x04b4861f, "Anysee E30 USB 2.0 DVB-T Receiver" },
    { 0x04b4bca1, "Barcode Reader" },
    { 0x04b4cc04, "Centor USB RACIA-ALVAR USB PORT" },
    { 0x04b4cc06, "Centor-P RACIA-ALVAR USB PORT" },
    { 0x04b4d5d5, "CY7C63x0x Zoltrix Z-Boxer GamePad" },
    { 0x04b4de61, "Barcode Reader" },
    { 0x04b4de64, "Barcode Reader" },
    { 0x04b4f000, "CY30700 Licorice evaluation board" },
    { 0x04b4f111, "CY8CKIT-002 PSoC MiniProg3 Rev A Program and debug kit" },
    { 0x04b4f115, "PSoC FirstTouch Programmer" },
    { 0x04b4f231, "DELLY Changer 4in1 universal IR remote" },
    { 0x04b4f232, "Mono embedded computer" },
    { 0x04b4fd10, "Gembird MSIS-PM" },
    { 0x04b4fd13, "Energenie EG-PMS" },
    { 0x04b4fd15, "Energenie EG-PMS2" },
    { 0x04b53064, "Hantek DSO-3064" },
    { 0x04b80001, "Stylus Color 740 / Photo 750" },
    { 0x04b80002, "ISD Smart Cable for Mac" },
    { 0x04b80003, "ISD Smart Cable" },
    { 0x04b80004, "Printer" },
    { 0x04b80005, "Printer" },
    { 0x04b80006, "Printer" },
    { 0x04b80007, "Printer" },
    { 0x04b80015, "Stylus Photo R3000" },
    { 0x04b80101, "GT-7000U [Perfection 636]" },
    { 0x04b80102, "GT-2200" },
    { 0x04b80103, "GT-6600U [Perfection 610]" },
    { 0x04b80104, "GT-7600UF [Perfection 1200U/1200U Photo]" },
    { 0x04b80105, "Stylus Scan 2000" },
    { 0x04b80106, "Stylus Scan 2500" },
    { 0x04b80107, "ES-2000 [Expression 1600U]" },
    { 0x04b80108, "CC-700" },
    { 0x04b80109, "ES-8500 [Expression 1640 XL]" },
    { 0x04b8010a, "GT-8700/GT-8700F [Perfection 1640SU/1640SU PHOTO]" },
    { 0x04b8010b, "GT-7700U [Perfection 1240U]" },
    { 0x04b8010c, "GT-6700U [Perfection 640]" },
    { 0x04b8010d, "CC-500L" },
    { 0x04b8010e, "ES-2200 [Perfection 1680]" },
    { 0x04b8010f, "GT-7200U [Perfection 1250/1250 PHOTO]" },
    { 0x04b80110, "GT-8200U/GT-8200UF [Perfection 1650/1650 PHOTO]" },
    { 0x04b80112, "GT-9700F [Perfection 2450 PHOTO]" },
    { 0x04b80114, "Perfection 660" },
    { 0x04b80116, "GT-9400UF [Perfection 3170]" },
    { 0x04b80118, "GT-F600 [Perfection 4180]" },
    { 0x04b80119, "GT-X750 [Perfection 4490 Photo]" },
    { 0x04b8011a, "CC-550L [1000 ICS]" },
    { 0x04b8011b, "GT-9300UF [Perfection 2400 PHOTO]" },
    { 0x04b8011c, "GT-9800F [Perfection 3200]" },
    { 0x04b8011d, "GT-7300U [Perfection 1260/1260 PHOTO]" },
    { 0x04b8011e, "GT-8300UF [Perfection 1660 PHOTO]" },
    { 0x04b8011f, "GT-8400UF [Perfection 1670/1670 PHOTO]" },
    { 0x04b80120, "GT-7400U [Perfection 1270]" },
    { 0x04b80121, "GT-F500/GT-F550 [Perfection 2480/2580 PHOTO]" },
    { 0x04b80122, "GT-F520/GT-F570 [Perfection 3590 PHOTO]" },
    { 0x04b80126, "ES-7000H [GT-15000]" },
    { 0x04b80128, "GT-X700 [Perfection 4870]" },
    { 0x04b80129, "ES-10000G [Expression 10000XL]" },
    { 0x04b8012a, "GT-X800 [Perfection 4990 PHOTO]" },
    { 0x04b8012b, "ES-H300 [GT-2500]" },
    { 0x04b8012c, "GT-X900 [Perfection V700/V750 Photo]" },
    { 0x04b8012d, "GT-F650 [GT-S600/Perfection V10/V100]" },
    { 0x04b8012e, "GT-F670 [Perfection V200 Photo]" },
    { 0x04b8012f, "GT-F700 [Perfection V350]" },
    { 0x04b80130, "GT-X770 [Perfection V500]" },
    { 0x04b80131, "GT-F720 [GT-S620/Perfection V30/V300 Photo]" },
    { 0x04b80133, "GT-1500 [GT-D1000]" },
    { 0x04b80135, "GT-X970" },
    { 0x04b80136, "ES-D400 [GT-S80]" },
    { 0x04b80137, "ES-D200 [GT-S50]" },
    { 0x04b80138, "ES-H7200 [GT-20000]" },
    { 0x04b8013a, "GT-X820 [Perfection V600 Photo]" },
    { 0x04b80142, "GT-F730 [GT-S630/Perfection V33/V330 Photo]" },
    { 0x04b80143, "GT-S55" },
    { 0x04b80144, "GT-S85" },
    { 0x04b80151, "Perfection V800 Photo" },
    { 0x04b80202, "Interface Card UB-U05 for Thermal Receipt Printers [M129C/TM-T70/TM-T88IV]" },
    { 0x04b80401, "CP 800 Digital Camera" },
    { 0x04b80402, "PhotoPC 850z" },
    { 0x04b80403, "PhotoPC 3000z" },
    { 0x04b80509, "JVC PIX-MC10" },
    { 0x04b80601, "Stylus Photo 875DC Card Reader" },
    { 0x04b80602, "Stylus Photo 895 Card Reader" },
    { 0x04b80801, "CC-600PX [Stylus CX5200/CX5400/CX6600]" },
    { 0x04b80802, "CC-570L [Stylus CX3100/CX3200]" },
    { 0x04b80803, "Printer (Composite Device)" },
    { 0x04b80804, "Storage Device" },
    { 0x04b80805, "Stylus CX6300/CX6400" },
    { 0x04b80806, "PM-A850 [Stylus Photo RX600/610]" },
    { 0x04b80807, "Stylus Photo RX500/510" },
    { 0x04b80808, "Stylus CX5200/CX5300/CX5400" },
    { 0x04b80809, "Storage Device" },
    { 0x04b8080a, "F-3200" },
    { 0x04b8080c, "ME100 [Stylus CX1500]" },
    { 0x04b8080d, "Stylus CX4500/4600" },
    { 0x04b8080e, "PX-A550 [CX-3500/3600/3650 MFP]" },
    { 0x04b8080f, "Stylus Photo RX420/RX425/RX430" },
    { 0x04b80810, "PM-A900 [Stylus Photo RX700]" },
    { 0x04b80811, "PM-A870 [Stylus Photo RX620/RX630]" },
    { 0x04b80812, "MFP Composite Device" },
    { 0x04b80813, "Stylus CX6500/6600" },
    { 0x04b80814, "PM-A700" },
    { 0x04b80815, "LP-A500 [AcuLaser CX1]" },
    { 0x04b80816, "Printer (Composite Device)" },
    { 0x04b80817, "LP-M5500/LP-M5500F" },
    { 0x04b80818, "Stylus CX3700/CX3800/DX3800" },
    { 0x04b80819, "PX-A650 [Stylus CX4700/CX4800/DX4800/DX4850]" },
    { 0x04b8081a, "PM-A750 [Stylus Photo RX520/RX530]" },
    { 0x04b8081b, "MFP Composite Device" },
    { 0x04b8081c, "PM-A890 [Stylus Photo RX640/RX650]" },
    { 0x04b8081d, "PM-A950" },
    { 0x04b8081e, "MFP Composite Device" },
    { 0x04b8081f, "Stylus CX7700/7800" },
    { 0x04b80820, "Stylus CX4100/CX4200/DX4200" },
    { 0x04b80821, "Stylus CX5700F/CX5800F" },
    { 0x04b80822, "Storage Device" },
    { 0x04b80823, "MFP Composite Device" },
    { 0x04b80824, "Storage Device" },
    { 0x04b80825, "MFP Composite Device" },
    { 0x04b80826, "Storage Device" },
    { 0x04b80827, "PM-A820 [Stylus Photo RX560/RX580/RX585/RX590]" },
    { 0x04b80828, "PM-A970" },
    { 0x04b80829, "PM-T990" },
    { 0x04b8082a, "PM-A920" },
    { 0x04b8082b, "Stylus CX5900/CX5000/DX5000/DX5050" },
    { 0x04b8082c, "Storage Device" },
    { 0x04b8082d, "Storage Device" },
    { 0x04b8082e, "PX-A720 [Stylus CX5900/CX6000/DX6000]" },
    { 0x04b8082f, "PX-A620 [Stylus CX3900/DX4000/DX4050]" },
    { 0x04b80830, "ME 200 [Stylus CX2800/CX2900]" },
    { 0x04b80831, "Stylus CX6900F/CX7000F/DX7000F" },
    { 0x04b80832, "MFP Composite Device" },
    { 0x04b80833, "LP-M5600" },
    { 0x04b80834, "LP-M6000" },
    { 0x04b80835, "AcuLaser CX21" },
    { 0x04b80836, "PM-T960" },
    { 0x04b80837, "PM-A940 [Stylus Photo RX680/RX685/RX690]" },
    { 0x04b80838, "PX-A640 [CX7300/CX7400/DX7400]" },
    { 0x04b80839, "PX-A740 [CX8300/CX8400/DX8400]" },
    { 0x04b8083a, "PX-FA700 [CX9300F/CX9400Fax/DX9400F]" },
    { 0x04b8083b, "MFP Composite Device" },
    { 0x04b8083c, "PM-A840S [Stylus Photo RX595/RX610]" },
    { 0x04b8083d, "MFP Composite Device" },
    { 0x04b8083e, "MFP Composite Device" },
    { 0x04b8083f, "Stylus CX4300/CX4400/CX5500/CX5600/DX4400/DX4450" },
    { 0x04b80841, "PX-401A [ME 300/Stylus NX100]" },
    { 0x04b80843, "LP-M5000" },
    { 0x04b80844, "EP-901A/EP-901F [Artisan 800/Stylus Photo PX800FW]" },
    { 0x04b80846, "EP-801A [Artisan 700/Stylus Photo PX700W/TX700W]" },
    { 0x04b80847, "PX-601F [ME Office 700FW/Stylus Office BX600FW/TX600FW]" },
    { 0x04b80848, "ME Office 600F/Stylus Office BX300F/TX300F" },
    { 0x04b80849, "Stylus SX205" },
    { 0x04b8084a, "PX-501A [Stylus NX400]" },
    { 0x04b8084d, "PX-402A [Stylus SX115/Stylus NX110 Series]" },
    { 0x04b8084f, "Multifunctional Printer Scanner [ME Office 510 / Epson Stylus SX215]" },
    { 0x04b80850, "EP-702A [Stylus Photo PX650/TX650 Series]" },
    { 0x04b80851, "Stylus SX410" },
    { 0x04b80852, "EP-802A [Artisan 710 Series/Stylus Photo PX710W/TX720W Series]" },
    { 0x04b80853, "EP-902A [Artisan 810 Series/Stylus Photo PX810FW Series]" },
    { 0x04b80854, "ME OFFICE 650FN Series/Stylus Office BX310FN/TX520FN Series" },
    { 0x04b80855, "PX-602F [Stylus Office BX610FW/TX620FW Series]" },
    { 0x04b80856, "PX-502A [Stylus SX515W]" },
    { 0x04b8085c, "ME 320/330 Series [Stylus SX125]" },
    { 0x04b8085d, "PX-603F [ME OFFICE 960FWD Series/Stylus Office BX625FWD/TX620FWD Series]" },
    { 0x04b8085e, "PX-503A [ME OFFICE 900WD Series/Stylus Office BX525WD]" },
    { 0x04b8085f, "Stylus Office BX320FW/TX525FW Series" },
    { 0x04b80860, "EP-903A/EP-903F [Artisan 835/Stylus Photo PX820FWD Series]" },
    { 0x04b80861, "EP-803A/EP-803AW [Artisan 725/Stylus Photo PX720WD/TX720WD Series]" },
    { 0x04b80862, "EP-703A [Stylus Photo PX660 Series]" },
    { 0x04b80863, "ME OFFICE 620F Series/Stylus Office BX305F/BX305FW/TX320F" },
    { 0x04b80864, "ME OFFICE 560W Series" },
    { 0x04b80865, "ME OFFICE 520 Series" },
    { 0x04b80866, "AcuLaser MX20DN/MX20DNF/MX21DNF" },
    { 0x04b80869, "PX-1600F" },
    { 0x04b8086a, "PX-673F [Stylus Office BX925FWD]" },
    { 0x04b80870, "Stylus Office BX305FW Plus" },
    { 0x04b80871, "K200 Series" },
    { 0x04b80872, "K300 Series" },
    { 0x04b80873, "L200 Series" },
    { 0x04b80878, "EP-704A" },
    { 0x04b80879, "EP-904A/EP-904F [Artisan 837/Stylus Photo PX830FWD Series]" },
    { 0x04b8087b, "EP-804A/EP-804AR/EP-804AW [Stylus Photo PX730WD/Artisan 730 Series]" },
    { 0x04b8087c, "PX-1700F" },
    { 0x04b8087d, "PX-B750F/WP-4525 Series" },
    { 0x04b8087f, "PX-403A" },
    { 0x04b80880, "PX-434A [Stylus NX330 Series]" },
    { 0x04b80881, "PX-404A [ME OFFICE 535]" },
    { 0x04b80883, "ME 340 Series/Stylus NX130 Series" },
    { 0x04b80884, "Stylus NX430W Series" },
    { 0x04b80885, "Stylus NX230/SX235W Series" },
    { 0x04b8088f, "Stylus Office BX635FWD" },
    { 0x04b80890, "ME OFFICE 940FW Series/Stylus Office BX630FW Series" },
    { 0x04b80891, "Stylus Office BX535WD" },
    { 0x04b80892, "Stylus Office BX935FWD" },
    { 0x04b80893, "EP-774A" },
    { 0x04b80e03, "Thermal Receipt Printer [TM-T20]" },
    { 0x04b81114, "XP-440 [Expression Home Small-in-One Printer]" },
    { 0x04b81129, "ET-4750 [WorkForce ET-4750 EcoTank All-in-One]" },
    { 0x04b90300, "SafeNet USB SuperPro/UltraPro" },
    { 0x04b91000, "iKey 1000 Token" },
    { 0x04b91001, "iKey 1200 Token" },
    { 0x04b91002, "iKey Token" },
    { 0x04b91003, "iKey Token" },
    { 0x04b91004, "iKey Token" },
    { 0x04b91005, "iKey Token" },
    { 0x04b91006, "iKey Token" },
    { 0x04b91200, "iKey 2000 Token" },
    { 0x04b91201, "iKey Token" },
    { 0x04b91202, "iKey 2032 Token" },
    { 0x04b91203, "iKey Token" },
    { 0x04b91204, "iKey Token" },
    { 0x04b91205, "iKey Token" },
    { 0x04b91206, "iKey 4000 Token" },
    { 0x04b91300, "iKey 3000 Token" },
    { 0x04b91301, "iKey 3000" },
    { 0x04b91302, "iKey Token" },
    { 0x04b91303, "iKey Token" },
    { 0x04b91304, "iKey Token" },
    { 0x04b91305, "iKey Token" },
    { 0x04b91306, "iKey Token" },
    { 0x04b98000, "SafeNet Sentinel Hardware Key" },
    { 0x04bb0101, "USB2-IDE/ATAPI Bridge Adapter" },
    { 0x04bb014a, "HDCL-UT" },
    { 0x04bb0201, "USB2-IDE/ATAPI Bridge Adapter" },
    { 0x04bb0204, "DVD Multi-plus unit iU-CD2" },
    { 0x04bb0206, "DVD Multi-plus unit DVR-UEH8" },
    { 0x04bb0301, "Storage Device" },
    { 0x04bb0314, "USB-SSMRW SD-card" },
    { 0x04bb0319, "USB2-IDE/ATAPI Bridge Adapter" },
    { 0x04bb031a, "USB2-IDE/ATAPI Bridge Adapter" },
    { 0x04bb031b, "USB2-IDE/ATAPI Bridge Adapter" },
    { 0x04bb031e, "USB-SDRW SD-card" },
    { 0x04bb0502, "Nogatech Live! (BT)" },
    { 0x04bb0528, "GV-USB Video Capture" },
    { 0x04bb0901, "USB ETT" },
    { 0x04bb0904, "ET/TX Ethernet [pegasus]" },
    { 0x04bb0913, "ET/TX-S Ethernet [pegasus2]" },
    { 0x04bb0919, "USB WN-B11" },
    { 0x04bb0922, "IOData AirPort WN-B11/USBS 802.11b" },
    { 0x04bb0930, "ETG-US2" },
    { 0x04bb0937, "WN-WAG/USL Wireless LAN Adapter" },
    { 0x04bb0938, "WN-G54/USL Wireless LAN Adapter" },
    { 0x04bb093b, "WN-GDN/USB" },
    { 0x04bb093f, "WNGDNUS2 802.11n" },
    { 0x04bb0944, "WHG-AGDN/US Wireless LAN Adapter" },
    { 0x04bb0945, "WN-GDN/US3 Wireless LAN Adapter" },
    { 0x04bb0947, "WN-G150U Wireless LAN Adapter" },
    { 0x04bb0948, "WN-G300U Wireless LAN Adapter" },
    { 0x04bb0a03, "Serial USB-RSAQ1" },
    { 0x04bb0a07, "USB2-iCN Adapter" },
    { 0x04bb0a08, "USB2-iCN Adapter" },
    { 0x04bb0c01, "FM-10 Pro Disk" },
    { 0x04bf0100, "MediaReader CF" },
    { 0x04bf0115, "USB-PDC Adapter UPA9664" },
    { 0x04bf0116, "USB-cdmaOne Adapter UCA1464" },
    { 0x04bf0117, "USB-PHS Adapter UHA6400" },
    { 0x04bf0118, "USB-PHS Adapter UPA6400" },
    { 0x04bf0135, "MediaReader Dual" },
    { 0x04bf0202, "73S1121F Smart Card Reader-" },
    { 0x04bf0309, "Bluetooth USB dongle" },
    { 0x04bf030a, "IBM Bluetooth Ultraport Module" },
    { 0x04bf030b, "Bluetooth Device" },
    { 0x04bf030c, "Ultraport Bluetooth Device" },
    { 0x04bf0310, "Integrated Bluetooth" },
    { 0x04bf0311, "Integrated Bluetooth Device" },
    { 0x04bf0317, "Bluetooth UltraPort Module from IBM" },
    { 0x04bf0318, "IBM Integrated Bluetooth" },
    { 0x04bf0319, "Bluetooth Adapter" },
    { 0x04bf0320, "Bluetooth Adapter" },
    { 0x04bf0321, "Bluetooth Device" },
    { 0x04bf0a28, "INDI AV-IN Device" },
    { 0x04c10020, "56K Voice Pro" },
    { 0x04c10022, "56K Voice Pro" },
    { 0x04c1007e, "ISDN TA" },
    { 0x04c10082, "OfficeConnect Analog Modem" },
    { 0x04c1008f, "Pro ISDN TA" },
    { 0x04c10097, "OfficeConnect Analog" },
    { 0x04c1009d, "HomeConnect Webcam [vicam]" },
    { 0x04c100a9, "ISDN Pro TA-U" },
    { 0x04c100b9, "HomeConnect IDSL Modem" },
    { 0x04c13021, "56k Voice FaxModem Pro" },
    { 0x04c31102, "Mouse" },
    { 0x04c32102, "Mouse" },
    { 0x04c51029, "fi-4010c Scanner" },
    { 0x04c51033, "fi-4110CU" },
    { 0x04c51041, "fi-4120c Scanner" },
    { 0x04c51042, "fi-4220c Scanner" },
    { 0x04c5105b, "AH-F401U Air H device" },
    { 0x04c51084, "PalmSecure Sensor V2" },
    { 0x04c51096, "fi-5110EOX" },
    { 0x04c51097, "fi-5110C" },
    { 0x04c510ae, "fi-4120C2" },
    { 0x04c510af, "fi-4220C2" },
    { 0x04c510c7, "fi-60f scanner" },
    { 0x04c510e0, "fi-5120c Scanner" },
    { 0x04c510e1, "fi-5220C" },
    { 0x04c510e7, "fi-5900C" },
    { 0x04c510fe, "S500" },
    { 0x04c51104, "KD02906 Line Thermal Printer" },
    { 0x04c51140, "FOMA F903iX HIGH-SPEED" },
    { 0x04c5114f, "fi-6130" },
    { 0x04c51150, "fi-6230" },
    { 0x04c511f3, "fi-6130Z" },
    { 0x04c5125a, "PalmSecure Sensor Device - MP" },
    { 0x04c5132e, "fi-7160" },
    { 0x04c5200f, "Sigma DP2 (Mass Storage)" },
    { 0x04c52010, "Sigma DP2 (PictBridge)" },
    { 0x04c5201d, "SATA 3.0 6Gbit/s Adaptor [GROOVY]" },
    { 0x04c80720, "Digital Color Camera" },
    { 0x04c80721, "e-miniD Camera" },
    { 0x04c80722, "e-mini" },
    { 0x04c80723, "KD-200Z Camera" },
    { 0x04c80726, "KD-310Z Camera" },
    { 0x04c80728, "Revio C2 Mass Storage Device" },
    { 0x04c80729, "Revio C2 Digital Camera" },
    { 0x04c8072c, "Revio KD20M" },
    { 0x04c8072d, "Revio KD410Z" },
    { 0x04ca0020, "USB Keyboard" },
    { 0x04ca004b, "Keyboard" },
    { 0x04ca004f, "SK-9020 keyboard" },
    { 0x04ca008a, "Acer Wired Mouse Model SM-9023" },
    { 0x04ca1766, "HID Monitor Controls" },
    { 0x04ca2004, "Bluetooth 4.0 [Broadcom BCM20702A0]" },
    { 0x04ca2006, "Broadcom BCM43142A0 Bluetooth Device" },
    { 0x04ca2007, "Broadcom BCM43142A0 Bluetooth Device" },
    { 0x04ca3005, "Atheros Bluetooth" },
    { 0x04ca300b, "Atheros AR3012 Bluetooth" },
    { 0x04ca300d, "Atheros AR3012 Bluetooth" },
    { 0x04ca300f, "Atheros AR3012 Bluetooth" },
    { 0x04ca3014, "Qualcomm Atheros Bluetooth" },
    { 0x04ca3015, "Qualcomm Atheros QCA9377 Bluetooth" },
    { 0x04ca7022, "HP HD Webcam" },
    { 0x04ca7025, "HP HD Webcam" },
    { 0x04ca7046, "TOSHIBA Web Camera - HD" },
    { 0x04ca9304, "Hub" },
    { 0x04caf01c, "TT1280DA DVB-T TV Tuner" },
    { 0x04cb0100, "FinePix 30i/40i/50i, A101/201, 1300/2200, 1400/2400/2600/2800/4500/4700/4800/4900/6800/6900 Zoom" },
    { 0x04cb0103, "FinePix NX-500/NX-700 printer" },
    { 0x04cb0104, "FinePix A101, 2600/2800/4800/6800 Zoom (PC CAM)" },
    { 0x04cb0108, "FinePix F601 Zoom (DSC)" },
    { 0x04cb0109, "FinePix F601 Zoom (PC CAM)" },
    { 0x04cb010a, "FinePix S602 (Pro) Zoom (DSC)" },
    { 0x04cb010b, "FinePix S602 (Pro) Zoom (PC CAM)" },
    { 0x04cb010d, "FinePix S2 pro" },
    { 0x04cb010e, "FinePix F402 Zoom (DSC)" },
    { 0x04cb010f, "FinePix F402 Zoom (PC CAM)" },
    { 0x04cb0110, "FinePix M603 Zoom (DSC)" },
    { 0x04cb0111, "FinePix M603 Zoom (PC CAM)" },
    { 0x04cb0112, "FinePix A202, A200 Zoom (DSC)" },
    { 0x04cb0113, "FinePix A202, A200 Zoom (PC CAM)" },
    { 0x04cb0114, "FinePix F401 Zoom (DSC)" },
    { 0x04cb0115, "FinePix F401 Zoom (PC CAM)" },
    { 0x04cb0116, "FinePix A203 Zoom (DSC)" },
    { 0x04cb0117, "FinePix A203 Zoom (PC CAM)" },
    { 0x04cb0118, "FinePix A303 Zoom (DSC)" },
    { 0x04cb0119, "FinePix A303 Zoom (PC CAM)" },
    { 0x04cb011a, "FinePix S304/3800 Zoom (DSC)" },
    { 0x04cb011b, "FinePix S304/3800 Zoom (PC CAM)" },
    { 0x04cb011c, "FinePix A204/2650 Zoom (DSC)" },
    { 0x04cb011d, "FinePix A204/2650 Zoom (PC CAM)" },
    { 0x04cb0120, "FinePix F700 Zoom (DSC)" },
    { 0x04cb0121, "FinePix F700 Zoom (PC CAM)" },
    { 0x04cb0122, "FinePix F410 Zoom (DSC)" },
    { 0x04cb0123, "FinePix F410 Zoom (PC CAM)" },
    { 0x04cb0124, "FinePix A310 Zoom (DSC)" },
    { 0x04cb0125, "FinePix A310 Zoom (PC CAM)" },
    { 0x04cb0126, "FinePix A210 Zoom (DSC)" },
    { 0x04cb0127, "FinePix A210 Zoom (PC CAM)" },
    { 0x04cb0128, "FinePix A205(S) Zoom (DSC)" },
    { 0x04cb0129, "FinePix A205(S) Zoom (PC CAM)" },
    { 0x04cb012a, "FinePix F610 Zoom (DSC)" },
    { 0x04cb012b, "FinePix Digital Camera 030513" },
    { 0x04cb012c, "FinePix S7000 Zoom (DSC)" },
    { 0x04cb012d, "FinePix S7000 Zoom (PC CAM)" },
    { 0x04cb012f, "FinePix Digital Camera 030731" },
    { 0x04cb0130, "FinePix S5000 Zoom (DSC)" },
    { 0x04cb0131, "FinePix S5000 Zoom (PC CAM)" },
    { 0x04cb013b, "FinePix Digital Camera 030722" },
    { 0x04cb013c, "FinePix S3000 Zoom (DSC)" },
    { 0x04cb013d, "FinePix S3000 Zoom (PC CAM)" },
    { 0x04cb013e, "FinePix F420 Zoom (DSC)" },
    { 0x04cb013f, "FinePix F420 Zoom (PC CAM)" },
    { 0x04cb0142, "Fuji FinePix S7000" },
    { 0x04cb0148, "FinePix A330 Zoom (DSC)" },
    { 0x04cb0149, "FinePix A330 Zoom (UVC)" },
    { 0x04cb014a, "Fuji FinePix A330" },
    { 0x04cb014b, "FinePix A340 Zoom (DSC)" },
    { 0x04cb014c, "FinePix A340 Zoom (UVC)" },
    { 0x04cb0159, "FinePix F710 Zoom (DSC)" },
    { 0x04cb0165, "FinePix S3500 Zoom (DSC)" },
    { 0x04cb0168, "FinePix E500 Zoom (DSC)" },
    { 0x04cb0169, "FinePix E500 Zoom (UVC)" },
    { 0x04cb016b, "FinePix E510 Zoom (DSC)" },
    { 0x04cb016c, "FinePix E510 Zoom (PC CAM)" },
    { 0x04cb016e, "FinePix S5500 Zoom (DSC)" },
    { 0x04cb016f, "FinePix S5500 Zoom (UVC)" },
    { 0x04cb0171, "FinePix E550 Zoom (DSC)" },
    { 0x04cb0172, "FinePix E550 Zoom (UVC)" },
    { 0x04cb0177, "FinePix F10 (DSC)" },
    { 0x04cb0179, "Finepix F10 (PTP)" },
    { 0x04cb0186, "FinePix S5200/S5600 Zoom (DSC)" },
    { 0x04cb0188, "FinePix S5200/S5600 Zoom (PTP)" },
    { 0x04cb018e, "FinePix S9500 Zoom (DSC)" },
    { 0x04cb018f, "Fuji FinePix S9500" },
    { 0x04cb0192, "FinePix E900 Zoom (DSC)" },
    { 0x04cb0193, "Fuji FinePix E900" },
    { 0x04cb019b, "Fuji FinePix F30" },
    { 0x04cb01af, "FinePix A700 (PTP)" },
    { 0x04cb01bf, "Fuji FinePix S6500fd" },
    { 0x04cb01c0, "Fuji FinePix F20" },
    { 0x04cb01c1, "Fuji FinePix F31fd" },
    { 0x04cb01c3, "Fuji S5 Pro" },
    { 0x04cb01c4, "Fuji FinePix S5700" },
    { 0x04cb01c5, "Fuji FinePix F40fd" },
    { 0x04cb01c6, "Fuji FinePix A820" },
    { 0x04cb01d2, "Fuji FinePix A800" },
    { 0x04cb01d3, "Fuji FinePix A920" },
    { 0x04cb01d4, "Fuji FinePix F50fd" },
    { 0x04cb01d5, "FinePix F47 (PTP)" },
    { 0x04cb01d7, "Fuji FinePix S5800" },
    { 0x04cb01d8, "Fuji FinePix Z100fd" },
    { 0x04cb01db, "Fuji FinePix S100fs" },
    { 0x04cb01dd, "Fuji FinePix S1000fd" },
    { 0x04cb01e0, "Fuji FinePix F100fd" },
    { 0x04cb01e4, "Fuji FinePix F200 EXR" },
    { 0x04cb01e6, "Fuji FinePix F60fd" },
    { 0x04cb01e8, "Fuji FinePix S2000HD" },
    { 0x04cb01ef, "Fuji FinePix S1500" },
    { 0x04cb01f7, "FinePix J250 (PTP)" },
    { 0x04cb01fa, "Fuji FinePix F70 EXR" },
    { 0x04cb01fd, "A160" },
    { 0x04cb01fe, "Fuji Fujifilm A220" },
    { 0x04cb0200, "Fuji FinePix S1800" },
    { 0x04cb0201, "Fuji FinePix Z35" },
    { 0x04cb0209, "Fuji FinePix S2500HD" },
    { 0x04cb020d, "Fuji FinePix Z700EXR" },
    { 0x04cb020e, "Fuji FinePix F80EXR" },
    { 0x04cb023e, "FinePix AX300" },
    { 0x04cb0240, "Fuji FinePix S2950" },
    { 0x04cb0241, "FinePix S3200 Digital Camera" },
    { 0x04cb0263, "Fuji FinePix X10" },
    { 0x04cb0265, "Fuji FinePix S4300" },
    { 0x04cb026e, "Fuji FinePix X-S1" },
    { 0x04cb0271, "Fuji FinePix HS30EXR" },
    { 0x04cb0278, "FinePix JV300" },
    { 0x04cb0288, "Fuji FinePix XF1" },
    { 0x04cb02c5, "FinePix S9900W Digital Camera (PTP)" },
    { 0x04cb5006, "ASK-300" },
    { 0x04cc1122, "Hub" },
    { 0x04cc1520, "USB 2.0 Hub (Avocent KVM)" },
    { 0x04cc1521, "USB 2.0 Hub" },
    { 0x04cc1a62, "GW Instek GSP-830 Spectrum Analyzer (HID)" },
    { 0x04cc2323, "Ux500 serial debug port" },
    { 0x04cc2533, "NFC device (PN533)" },
    { 0x04cc8116, "Camera" },
    { 0x04ce0002, "SL11R-IDE IDE Bridge" },
    { 0x04ce0100, "USB2PRN Printer Class" },
    { 0x04ce0300, "Phantom 336CX - C3 scanner" },
    { 0x04ce04ce, "SL11DEMO, VID: 0x4ce, PID: 0x4ce" },
    { 0x04ce07d1, "SL11R, VID: 0x4ce, PID: 0x07D1" },
    { 0x04cf0022, "OCZ Alchemy Series Elixir II Keyboard" },
    { 0x04cf0800, "MTP800 Mass Storage Device" },
    { 0x04cf8810, "CS8810 Mass Storage Device" },
    { 0x04cf8811, "CS8811 Mass Storage Device" },
    { 0x04cf8813, "CS8813 Mass Storage Device" },
    { 0x04cf8818, "USB2.0 to ATAPI Bridge Controller" },
    { 0x04cf8819, "USB 2.0 SD/MMC Reader" },
    { 0x04cf9920, "CS8819A2-114 Mass Storage Device" },
    { 0x04d20070, "ADA70 Speakers" },
    { 0x04d20305, "Non-Compliant Audio Device" },
    { 0x04d20311, "ADA-310 Speakers" },
    { 0x04d22060, "Claritel-i750 - vp" },
    { 0x04d2ff05, "ADA-305 Speakers" },
    { 0x04d2ff47, "Lansing HID Audio Controls" },
    { 0x04d2ff49, "Lansing HID Audio Controls" },
    { 0x04d71be4, "Bluetooth Device" },
    { 0x04d80002, "PicoLCD 20x2" },
    { 0x04d80003, "PICkit 2 Microcontroller Programmer" },
    { 0x04d8000a, "CDC RS-232 Emulation Demo" },
    { 0x04d8000b, "PIC18F2550 (32K Flashable 10 Channel, 10 Bit A/D USB Microcontroller)" },
    { 0x04d80032, "PICkit1" },
    { 0x04d80033, "PICkit2" },
    { 0x04d80036, "PICkit Serial Analyzer" },
    { 0x04d800e0, "PIC32 Starter Board" },
    { 0x04d804cd, "28Cxxx EEPROM Programmer" },
    { 0x04d80a04, "AGP LIN Serial Analyzer" },
    { 0x04d88000, "In-Circuit Debugger" },
    { 0x04d88001, "ICD2 in-circuit debugger" },
    { 0x04d88101, "PIC24F Starter Kit" },
    { 0x04d88107, "Microstick II" },
    { 0x04d88108, "ChipKit Pro MX7 (PIC32MX)" },
    { 0x04d89004, "Microchip REAL ICE" },
    { 0x04d89009, "ICD3" },
    { 0x04d8900a, "PICkit3" },
    { 0x04d89012, "PICkit4" },
    { 0x04d89015, "ICD 4 In-Circuit Debugger" },
    { 0x04d8c001, "PicoLCD 20x4" },
    { 0x04d8e11c, "TL866CS EEPROM Programmer [MiniPRO]" },
    { 0x04d8ed16, "BeamiRC 2.0 CNC remote controller analoge" },
    { 0x04d8edb4, "micro PLC (ATSAMD51G19A) [Black Brix ECU II]" },
    { 0x04d8edb5, "ATMEGA32U4 [Black Brix ECU]" },
    { 0x04d8f2c4, "Macareux-labs Hygrometry Temperature Sensor" },
    { 0x04d8f2f7, "Yepkit YKUSH" },
    { 0x04d8f3aa, "Macareux-labs Usbce Bootloader mode" },
    { 0x04d8f437, "SBE Tech Ultrasonic Anemometer" },
    { 0x04d8f4b5, "SmartScope" },
    { 0x04d8f5fe, "TrueRNG" },
    { 0x04d8f8da, "Hughski Ltd. ColorHug" },
    { 0x04d8f8e8, "Harmony 300/350 Remote" },
    { 0x04d8f91c, "SPROG IIv3" },
    { 0x04d8faff, "Dangerous Prototypes BusPirate v4 Bootloader mode" },
    { 0x04d8fb00, "Dangerous Prototypes BusPirate v4" },
    { 0x04d8fbb2, "GCUSB-nStep stepper motor controller" },
    { 0x04d8fbba, "DiscFerret Magnetic Disc Analyser (bootloader mode)" },
    { 0x04d8fbbb, "DiscFerret Magnetic Disc Analyser (active mode)" },
    { 0x04d8fc1e, "Bachrus Speedometer Interface" },
    { 0x04d8fc92, "Open Bench Logic Sniffer" },
    { 0x04d8ffee, "Devantech USB-ISS" },
    { 0x04d8ffef, "PICoPLC [APStech]" },
    { 0x04d90006, "Wired Keyboard (78/79 key) [RPI Wired Keyboard 5]" },
    { 0x04d90022, "Portable Keyboard" },
    { 0x04d90348, "Keyboard" },
    { 0x04d9048e, "Optical Mouse" },
    { 0x04d90499, "Optical Mouse" },
    { 0x04d91135, "Mouse [MGK-15BU/MLK-15BU]" },
    { 0x04d91203, "Keyboard" },
    { 0x04d91400, "PS/2 keyboard + mouse controller" },
    { 0x04d91503, "Keyboard" },
    { 0x04d91603, "Keyboard" },
    { 0x04d91702, "Keyboard LKS02" },
    { 0x04d91818, "Keyboard [Diatec Filco Majestouch 2]" },
    { 0x04d92011, "Keyboard [Diatec Filco Majestouch 1]" },
    { 0x04d92013, "Keyboard [Das Keyboard]" },
    { 0x04d92206, "Fujitsu Siemens Mouse Esprimo Q" },
    { 0x04d92221, "Keyboard" },
    { 0x04d92323, "Keyboard" },
    { 0x04d92519, "Shenzhen LogoTech 2.4GHz receiver" },
    { 0x04d92832, "HT82A832R Audio MCU" },
    { 0x04d92834, "HT82A834R Audio MCU" },
    { 0x04d94545, "Keyboard [Diatec Majestouch 2 Tenkeyless]" },
    { 0x04d9a01c, "wireless multimedia keyboard with trackball [Trust ADURA 17911]" },
    { 0x04d9a050, "Chatman V1" },
    { 0x04d9a052, "USB-zyTemp" },
    { 0x04d9a055, "Keyboard" },
    { 0x04d9a075, "Optical Gaming Mouse" },
    { 0x04d9a096, "Keyboard" },
    { 0x04d9a09f, "E-Signal LUOM G10 Mechanical Gaming Mouse" },
    { 0x04d9a100, "Mouse [HV-MS735]" },
    { 0x04d9a11b, "Mouse [MX-3200]" },
    { 0x04d9a29f, "Microarray fingerprint reader" },
    { 0x04d9b534, "LGT8F328P Microprocessor" },
    { 0x04d9e002, "MCU" },
    { 0x04da0901, "LS-120 Camera" },
    { 0x04da0912, "SDR-S10" },
    { 0x04da0b01, "CD-R/RW Drive" },
    { 0x04da0b03, "SuperDisk 240MB" },
    { 0x04da0d01, "CD-R Drive KXL-840AN" },
    { 0x04da0d09, "CD-R Drive KXL-RW32AN" },
    { 0x04da0d0a, "CD-R Drive KXL-CB20AN" },
    { 0x04da0d0d, "CDRCB03" },
    { 0x04da0d0e, "DVD-ROM & CD-R/RW" },
    { 0x04da0d14, "DVD-RAM MLT08" },
    { 0x04da0f07, "KX-MB2030 Multifunction Laser Printer" },
    { 0x04da0f40, "Printer" },
    { 0x04da104d, "Elite Panaboard UB-T880 (HID)" },
    { 0x04da104e, "Elite Panaboard Pen Adaptor (HID)" },
    { 0x04da1500, "MFSUSB Driver" },
    { 0x04da1800, "DY-WL10 802.11abgn Adapter [Broadcom BCM4323]" },
    { 0x04da1b00, "MultiMediaCard" },
    { 0x04da2121, "EB-VS6" },
    { 0x04da2145, "Panasonic P905i" },
    { 0x04da2158, "Panasonic P906i" },
    { 0x04da2316, "DVC Mass Storage Device" },
    { 0x04da2317, "DVC USB-SERIAL Driver for WinXP" },
    { 0x04da2318, "NV-GS11/230/250 (webcam mode)" },
    { 0x04da2319, "NV-GS15 (webcam mode)" },
    { 0x04da231a, "NV-GS11/230/250 (DV mode)" },
    { 0x04da231d, "DVC Web Camera Device" },
    { 0x04da231e, "DVC DV Stream Device" },
    { 0x04da2372, "Panasonic Lumix FZ5" },
    { 0x04da2374, "Panasonic DMC-GF1" },
    { 0x04da2375, "Leica D-LUX 2" },
    { 0x04da2451, "HDC-SD9" },
    { 0x04da245b, "HC-X920K (3MOS Full HD video camcorder)" },
    { 0x04da2477, "SDR-H85 Camcorder (PC mode)" },
    { 0x04da2478, "SDR-H85 Camcorder (recorder mode - SD card)" },
    { 0x04da2479, "SDR-H85 Camcorder (recorder mode - HDD)" },
    { 0x04da2497, "HDC-TM700" },
    { 0x04da250c, "Gobi Wireless Modem (QDL mode)" },
    { 0x04da250d, "Gobi Wireless Modem" },
    { 0x04da3904, "N5HBZ0000055 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" },
    { 0x04da3908, "N5HBZ0000062 802.11abgn Wireless Adapter [Atheros AR9374v1.1]" },
    { 0x04da3c04, "JT-P100MR-20 [ePassport Reader]" },
    { 0x04dd13a6, "MFC2000" },
    { 0x04dd6006, "AL-1216" },
    { 0x04dd6007, "AL-1045" },
    { 0x04dd6008, "AL-1255" },
    { 0x04dd6009, "AL-1530CS" },
    { 0x04dd600a, "AL-1540CS" },
    { 0x04dd600b, "AL-1456" },
    { 0x04dd600c, "AL-1555" },
    { 0x04dd600d, "AL-1225" },
    { 0x04dd600e, "AL-1551CS" },
    { 0x04dd600f, "AR-122E" },
    { 0x04dd6010, "AR-152E" },
    { 0x04dd6011, "AR-157E" },
    { 0x04dd6012, "SN-1045" },
    { 0x04dd6013, "SN-1255" },
    { 0x04dd6014, "SN-1456" },
    { 0x04dd6015, "SN-1555" },
    { 0x04dd6016, "AR-153E" },
    { 0x04dd6017, "AR-122E N" },
    { 0x04dd6018, "AR-153E N" },
    { 0x04dd6019, "AR-152E N" },
    { 0x04dd601a, "AR-157E N" },
    { 0x04dd601b, "AL-1217" },
    { 0x04dd601c, "AL-1226" },
    { 0x04dd601d, "AR-123E" },
    { 0x04dd6021, "IS01" },
    { 0x04dd7002, "DVC Ver.1.0" },
    { 0x04dd7004, "VE-CG40U Digital Still Camera" },
    { 0x04dd7005, "VE-CG30 Digital Still Camera" },
    { 0x04dd7007, "VL-Z7S Digital Camcorder" },
    { 0x04dd8004, "Zaurus SL-5000D/SL-5500 PDA" },
    { 0x04dd8005, "Zaurus A-300" },
    { 0x04dd8006, "Zaurus SL-B500/SL-5600 PDA" },
    { 0x04dd8007, "Zaurus C-700 PDA" },
    { 0x04dd9009, "AR-M160" },
    { 0x04dd9014, "IM-DR80 Portable NetMD Player" },
    { 0x04dd9031, "Zaurus C-750/C-760/C-860/SL-C3000 PDA" },
    { 0x04dd9032, "Zaurus SL-6000" },
    { 0x04dd903a, "GSM GPRS" },
    { 0x04dd9050, "Zaurus C-860 PDA" },
    { 0x04dd9056, "Viewcam Z" },
    { 0x04dd9073, "AM-900" },
    { 0x04dd9074, "GSM GPRS" },
    { 0x04dd90a9, "Sharp Composite" },
    { 0x04dd90d0, "USB-to-Serial Comm. Port" },
    { 0x04dd90f2, "Sharp 3G GSM USB Control" },
    { 0x04dd9120, "WS004SH" },
    { 0x04dd9122, "WS007SH" },
    { 0x04dd9123, "W-ZERO3 ES Smartphone" },
    { 0x04dd91a3, "922SH Internet Machine" },
    { 0x04dd939a, "IS03" },
    { 0x04e10201, "Monitor Hub" },
    { 0x04e21410, "XR21V1410 USB-UART IC" },
    { 0x04e60001, "E-USB ATA Bridge" },
    { 0x04e60002, "eUSCSI SCSI Bridge" },
    { 0x04e60003, "eUSB SmartMedia Card Reader" },
    { 0x04e60005, "eUSB SmartMedia/CompactFlash Card Reader" },
    { 0x04e60006, "eUSB SmartMedia Card Reader" },
    { 0x04e60007, "Hifd" },
    { 0x04e60009, "eUSB ATA/ATAPI Adapter" },
    { 0x04e6000a, "eUSB CompactFlash Adapter" },
    { 0x04e6000b, "eUSCSI Bridge" },
    { 0x04e6000c, "eUSCSI Bridge" },
    { 0x04e6000d, "Dazzle MS" },
    { 0x04e60012, "Dazzle SD/MMC" },
    { 0x04e60101, "eUSB ATA Bridge (Sony Spressa USB CDRW)" },
    { 0x04e60311, "Dazzle DM-CF" },
    { 0x04e60312, "Dazzle DM-SD/MMC" },
    { 0x04e60313, "Dazzle SM" },
    { 0x04e60314, "Dazzle MS" },
    { 0x04e60322, "e-Film Reader-5" },
    { 0x04e60325, "eUSB ORCA Quad Reader" },
    { 0x04e60327, "Digital Media Reader" },
    { 0x04e603fe, "DMHS2 DFU Adapter" },
    { 0x04e60406, "eUSB SmartDM Reader" },
    { 0x04e604e6, "eUSB DFU Adapter" },
    { 0x04e604e7, "STCII DFU Adapter" },
    { 0x04e604e8, "eUSBDM DFU Adapter" },
    { 0x04e604e9, "DM-E DFU Adapter" },
    { 0x04e60500, "Veridicom 5thSense Fingerprint Sensor and eUSB SmartCard" },
    { 0x04e60701, "DCS200 Loader Device" },
    { 0x04e60702, "DVD Creation Station 200" },
    { 0x04e60703, "DVC100 Loader Device" },
    { 0x04e60704, "Digital Video Creator 100" },
    { 0x04e61001, "SCR300 Smart Card Reader" },
    { 0x04e61010, "USBAT-2 CompactFlash Card Reader" },
    { 0x04e61014, "e-Film Reader-3" },
    { 0x04e61020, "USBAT ATA/ATAPI Adapter" },
    { 0x04e62007, "RSA SecurID ComboReader" },
    { 0x04e62009, "Citibank Smart Card Reader" },
    { 0x04e6200a, "Reflex v.2 Smart Card Reader" },
    { 0x04e6200d, "STR391 Reader" },
    { 0x04e65111, "SCR331-DI SmartCard Reader" },
    { 0x04e65113, "SCR333 SmartCard Reader" },
    { 0x04e65114, "SCR331-DI SmartCard Reader" },
    { 0x04e65115, "SCR335 SmartCard Reader" },
    { 0x04e65116, "SCR331-LC1 / SCR3310 SmartCard Reader" },
    { 0x04e65117, "SCR3320 - Smart Card Reader" },
    { 0x04e65118, "Expresscard SIM Card Reader" },
    { 0x04e65119, "SCR3340 - ExpressCard54 Smart Card Reader" },
    { 0x04e6511b, "SmartCard Reader" },
    { 0x04e6511d, "SCR3311 Smart Card Reader" },
    { 0x04e65120, "SCR331-DI SmartCard Reader" },
    { 0x04e65121, "SDI010 Smart Card Reader" },
    { 0x04e65151, "SCR338 Keyboard Smart Card Reader" },
    { 0x04e65292, "SCL011 RFID reader" },
    { 0x04e65410, "SCR35xx Smart Card Reader" },
    { 0x04e65591, "SCL3711-NFC&RW" },
    { 0x04e65810, "uTrust 2700 R Smart Card Reader" },
    { 0x04e6e000, "SCRx31 Reader" },
    { 0x04e6e001, "SCR331 SmartCard Reader" },
    { 0x04e6e003, "SPR532 PinPad SmartCard Reader" },
    { 0x04e70001, "TouchScreen" },
    { 0x04e70002, "Touchmonitor Interface 2600 Rev 2" },
    { 0x04e70004, "4000U CarrollTouch\302\256 Touchmonitor Interface" },
    { 0x04e70007, "2500U IntelliTouch\302\256 Touchmonitor Interface" },
    { 0x04e70008, "3000U AccuTouch\302\256 Touchmonitor Interface" },
    { 0x04e70009, "4000U CarrollTouch\302\256 Touchmonitor Interface" },
    { 0x04e70020, "Touchscreen Interface (2700)" },
    { 0x04e70021, "Touchmonitor Interface" },
    { 0x04e70030, "4500U CarrollTouch\302\256 Touchmonitor Interface" },
    { 0x04e70032, "Touchmonitor Interface" },
    { 0x04e70033, "Touchmonitor Interface" },
    { 0x04e70041, "5010 Surface Capacitive Touchmonitor Interface" },
    { 0x04e70042, "Touchmonitor Interface" },
    { 0x04e70050, "2216 AccuTouch\302\256 Touchmonitor Interface" },
    { 0x04e70071, "Touchmonitor Interface" },
    { 0x04e70072, "Touchmonitor Interface" },
    { 0x04e70081, "Touchmonitor Interface" },
    { 0x04e70082, "Touchmonitor Interface" },
    { 0x04e700ff, "Touchmonitor Interface" },
    { 0x04e80001, "Printer Bootloader" },
    { 0x04e80100, "Kingston Flash Drive (128MB)" },
    { 0x04e80110, "Connect3D Flash Drive" },
    { 0x04e80111, "Connect3D Flash Drive" },
    { 0x04e80300, "E2530 / GT-C3350 Phones (Mass storage mode)" },
    { 0x04e80409, "Samsung YP-900" },
    { 0x04e804a4, "Samsung I550W Phone" },
    { 0x04e804e8, "Galaxy (MIDI mode)" },
    { 0x04e81003, "MP3 Player and Recorder" },
    { 0x04e81006, "SDC-200Z" },
    { 0x04e8130c, "NX100" },
    { 0x04e81323, "WB700 Camera" },
    { 0x04e81f05, "S2 Portable [JMicron] (500GB)" },
    { 0x04e81f06, "HX-MU064DA portable harddisk" },
    { 0x04e82018, "WIS09ABGN LinkStick Wireless LAN Adapter" },
    { 0x04e82035, "Digital Photo Frame Mass Storage" },
    { 0x04e82036, "Digital Photo Frame Mini Monitor" },
    { 0x04e83004, "ML-4600" },
    { 0x04e83005, "Docuprint P1210" },
    { 0x04e83008, "ML-6060 laser printer" },
    { 0x04e8300c, "ML-1210 Printer" },
    { 0x04e8300e, "Laser Printer" },
    { 0x04e83104, "ML-3550N" },
    { 0x04e83210, "ML-5200A Laser Printer" },
    { 0x04e83226, "Laser Printer" },
    { 0x04e83228, "Laser Printer" },
    { 0x04e8322a, "Laser Printer" },
    { 0x04e8322c, "Laser Printer" },
    { 0x04e83230, "ML-1440" },
    { 0x04e83232, "Laser Printer" },
    { 0x04e83236, "ML-1450" },
    { 0x04e83238, "ML-1430" },
    { 0x04e8323a, "ML-1710 Printer" },
    { 0x04e8323b, "Phaser 3130" },
    { 0x04e8323c, "Laser Printer" },
    { 0x04e8323d, "Phaser 3120" },
    { 0x04e8323e, "Laser Printer" },
    { 0x04e83240, "Laser Printer" },
    { 0x04e83242, "ML-1510 Laser Printer" },
    { 0x04e83248, "Color Laser Printer" },
    { 0x04e8324a, "Laser Printer" },
    { 0x04e8324c, "ML-1740 Printer" },
    { 0x04e8324d, "Phaser 3121" },
    { 0x04e83256, "ML-1520 Laser Printer" },
    { 0x04e8325b, "Xerox Phaser 3117 Laser Printer" },
    { 0x04e8325f, "Phaser 3425 Laser Printer" },
    { 0x04e83260, "CLP-510 Color Laser Printer" },
    { 0x04e83268, "ML-1610 Mono Laser Printer" },
    { 0x04e8326c, "ML-2010P Mono Laser Printer" },
    { 0x04e83276, "ML-3050/ML-3051 Laser Printer" },
    { 0x04e8327e, "ML-2510 Series" },
    { 0x04e8328e, "CLP-310 Color Laser Printer" },
    { 0x04e83292, "ML-1640 Series Laser Printer" },
    { 0x04e83296, "ML-2580N Mono Laser Printer" },
    { 0x04e83297, "ML-191x/ML-252x Laser Printer" },
    { 0x04e8329f, "CLP-325 Color Laser Printer" },
    { 0x04e83301, "ML-1660 Series" },
    { 0x04e8330c, "ML-1865" },
    { 0x04e8330f, "ML-216x Series Laser Printer" },
    { 0x04e83310, "ML-331x Series Laser Printer" },
    { 0x04e83315, "ML-2540 Series Laser Printer" },
    { 0x04e8331e, "M262x/M282x Xpress Series Laser Printer" },
    { 0x04e83409, "SCX-4216F Scanner" },
    { 0x04e8340c, "SCX-5x15 series" },
    { 0x04e8340d, "SCX-6x20 series" },
    { 0x04e8340e, "MFP 560 series" },
    { 0x04e8340f, "Printing Support" },
    { 0x04e83412, "SCX-4x20 series" },
    { 0x04e83413, "SCX-4100 Scanner" },
    { 0x04e83415, "Composite Device" },
    { 0x04e83419, "Composite Device" },
    { 0x04e8341a, "Printing Support" },
    { 0x04e8341b, "SCX-4200 series" },
    { 0x04e8341c, "Composite Device" },
    { 0x04e8341d, "Composite Device" },
    { 0x04e8341f, "Composite Device" },
    { 0x04e83420, "Composite Device" },
    { 0x04e83426, "SCX-4500 Laser Printer" },
    { 0x04e8342d, "SCX-4x28 Series" },
    { 0x04e8344f, "SCX-3400 Series" },
    { 0x04e8347e, "C48x Series Color Laser Multifunction Printer" },
    { 0x04e83605, "InkJet Color Printer" },
    { 0x04e83606, "InkJet Color Printer" },
    { 0x04e83609, "InkJet Color Printer" },
    { 0x04e83902, "InkJet Color Printer" },
    { 0x04e83903, "Xerox WorkCentre XK50cx" },
    { 0x04e8390f, "InkJet Color Printer" },
    { 0x04e83911, "SCX-1020 series" },
    { 0x04e84005, "GT-S8000 Jet (msc)" },
    { 0x04e84f1f, "Samsung Jet S8000" },
    { 0x04e85000, "YP-MF series" },
    { 0x04e85001, "YP-100" },
    { 0x04e85002, "YP-30" },
    { 0x04e85003, "YP-700" },
    { 0x04e85004, "YP-30" },
    { 0x04e85005, "YP-300" },
    { 0x04e85006, "YP-750" },
    { 0x04e8500d, "MP3 Player" },
    { 0x04e85010, "Yepp YP-35" },
    { 0x04e85011, "YP-780" },
    { 0x04e85013, "YP-60" },
    { 0x04e85015, "yepp upgrade" },
    { 0x04e8501b, "MP3 Player" },
    { 0x04e8501d, "Samsung YH-920 (501d)" },
    { 0x04e85021, "Yepp YP-ST5" },
    { 0x04e85022, "Samsung YH-920 (5022)" },
    { 0x04e85024, "Samsung YH-925GS" },
    { 0x04e85026, "YP-MT6V" },
    { 0x04e85027, "YP-T7" },
    { 0x04e8502b, "YP-F1" },
    { 0x04e8502e, "Samsung YH-820" },
    { 0x04e8502f, "Samsung YH-925(-GS)" },
    { 0x04e85032, "YP-J70" },
    { 0x04e85033, "Samsung YH-J70J" },
    { 0x04e8503b, "YP-U1 MP3 Player" },
    { 0x04e8503c, "Samsung YP-Z5" },
    { 0x04e8503d, "YP-T7F" },
    { 0x04e85041, "YP-Z5" },
    { 0x04e85047, "Samsung YP-T7J" },
    { 0x04e85050, "YP-U2 MP3 Player" },
    { 0x04e85051, "YP-F2R" },
    { 0x04e85054, "Samsung YP-U2J (YP-U2JXB/XAA)" },
    { 0x04e85055, "YP-T9" },
    { 0x04e85057, "Samsung YP-F2J" },
    { 0x04e8505a, "Samsung YP-K5" },
    { 0x04e8507d, "Samsung YP-U3" },
    { 0x04e8507f, "Samsung YP-T9" },
    { 0x04e85080, "Yepp YP-K3 (msc)" },
    { 0x04e85081, "Samsung YP-K3" },
    { 0x04e85082, "YP-P2 (msc)" },
    { 0x04e85083, "Samsung YP-P2" },
    { 0x04e8508a, "Samsung YP-T10" },
    { 0x04e8508b, "Samsung YP-S5" },
    { 0x04e8508c, "YP-S5" },
    { 0x04e85090, "YP-S3 (msc)" },
    { 0x04e85091, "Samsung YP-S3" },
    { 0x04e85092, "YP-U4 (msc)" },
    { 0x04e85093, "Samsung YP-U4" },
    { 0x04e85095, "YP-S2" },
    { 0x04e8510f, "Samsung YP-R1" },
    { 0x04e85115, "Samsung YP-Q1" },
    { 0x04e85118, "Samsung YP-M1" },
    { 0x04e85119, "Yepp YP-P3" },
    { 0x04e8511a, "Samsung YP-P3" },
    { 0x04e8511c, "YP-Q2" },
    { 0x04e8511d, "Samsung YP-Q2" },
    { 0x04e85121, "Samsung YP-U5" },
    { 0x04e85123, "Yepp YP-M1" },
    { 0x04e85125, "Samsung YP-R0" },
    { 0x04e85130, "Samsung YP-Q3" },
    { 0x04e85137, "Samsung YP-Z3" },
    { 0x04e85a00, "YP-NEU" },
    { 0x04e85a01, "YP-NDU" },
    { 0x04e85a03, "Yepp MP3 Player" },
    { 0x04e85a04, "YP-800" },
    { 0x04e85a08, "YP-90" },
    { 0x04e85a0f, "Meizu M6 MiniPlayer" },
    { 0x04e85b01, "Memory Stick Reader/Writer" },
    { 0x04e85b02, "Memory Stick Reader/Writer" },
    { 0x04e85b03, "Memory Stick Reader/Writer" },
    { 0x04e85b04, "Memory Stick Reader/Writer" },
    { 0x04e85b05, "Memory Stick Reader/Writer" },
    { 0x04e85b11, "SEW-2001u Card" },
    { 0x04e85f00, "NEXiO Sync" },
    { 0x04e85f01, "NEXiO Sync" },
    { 0x04e85f02, "NEXiO Sync" },
    { 0x04e85f03, "NEXiO Sync" },
    { 0x04e85f04, "NEXiO Sync" },
    { 0x04e85f05, "STORY Station 1TB" },
    { 0x04e86032, "G2 Portable hard drive" },
    { 0x04e86033, "G2 Portable device" },
    { 0x04e86034, "G2 Portable hard drive" },
    { 0x04e860b3, "M2 Portable Hard Drive" },
    { 0x04e860c4, "M2 Portable Hard Drive USB 3.0" },
    { 0x04e86124, "D3 Station External Hard Drive" },
    { 0x04e86125, "D3 Station External Hard Drive" },
    { 0x04e861b5, "M3 Portable Hard Drive 2TB" },
    { 0x04e861b6, "M3 Portable Hard Drive 1TB" },
    { 0x04e861b7, "M3 Portable Hard Drive 4TB" },
    { 0x04e861f3, "Portable SSD T3 (MU-PT250B, MU-PT500B)" },
    { 0x04e861f5, "Portable SSD T5" },
    { 0x04e86601, "Mobile Phone" },
    { 0x04e86602, "Galaxy" },
    { 0x04e86603, "Galaxy" },
    { 0x04e86611, "MITs Sync" },
    { 0x04e86613, "MITs Sync" },
    { 0x04e86615, "MITs Sync" },
    { 0x04e86617, "MITs Sync" },
    { 0x04e86619, "MITs Sync" },
    { 0x04e8661b, "MITs Sync" },
    { 0x04e8661e, "Handheld" },
    { 0x04e86620, "Handheld" },
    { 0x04e86622, "Handheld" },
    { 0x04e86624, "Handheld" },
    { 0x04e8662e, "MITs Sync" },
    { 0x04e86630, "MITs Sync" },
    { 0x04e86632, "MITs Sync" },
    { 0x04e8663e, "D900e/B2100 Phone" },
    { 0x04e8663f, "SGH-E720/SGH-E840" },
    { 0x04e86640, "Usb Modem Enumerator" },
    { 0x04e86642, "Samsung M7600 Beat/GT-S8300T/SGH-F490/S8300" },
    { 0x04e86651, "i8510 Innov8" },
    { 0x04e86702, "Samsung X830 Mobile Phone" },
    { 0x04e86708, "U600 Phone" },
    { 0x04e86709, "Samsung U600 Mobile Phone" },
    { 0x04e86727, "Samsung F250 Mobile Phone" },
    { 0x04e86734, "Samsung Juke (SCH-U470)" },
    { 0x04e86752, "Samsung GT-B2700" },
    { 0x04e86759, "D900e/B2100 Media Player" },
    { 0x04e8675a, "D900e/B2100 Mass Storage" },
    { 0x04e8675b, "D900e Camera" },
    { 0x04e86763, "Samsung SAMSUNG Trance" },
    { 0x04e86772, "Standalone LTE device (Trial)" },
    { 0x04e86795, "S5230" },
    { 0x04e86802, "Standalone HSPA device" },
    { 0x04e86806, "Composite LTE device (Trial)" },
    { 0x04e86807, "Composite HSPA device" },
    { 0x04e86819, "Samsung GT-S8500" },
    { 0x04e8681c, "Galaxy Portal/Spica/S" },
    { 0x04e8681d, "Galaxy Portal/Spica Android Phone" },
    { 0x04e86843, "E2530 Phone (Samsung Kies mode)" },
    { 0x04e8684a, "Samsung S5620" },
    { 0x04e8684e, "Wave (GT-S8500)" },
    { 0x04e8685b, "GT-I9100 Phone [Galaxy S II] (mass storage mode)" },
    { 0x04e8685c, "GT-I9250 Phone [Galaxy Nexus] (Mass storage mode)" },
    { 0x04e8685d, "GT-I9100 Phone [Galaxy S II] (Download mode)" },
    { 0x04e8685e, "Samsung Galaxy Y" },
    { 0x04e86860, "Galaxy A5 (MTP)" },
    { 0x04e86863, "Galaxy series, misc. (tethering mode)" },
    { 0x04e86864, "GT-I9070 (network tethering, USB debugging enabled)" },
    { 0x04e86865, "Galaxy (PTP mode)" },
    { 0x04e86866, "Galaxy (debugging mode)" },
    { 0x04e86868, "Escape Composite driver for Android Phones: Modem+Diagnostic+ADB" },
    { 0x04e86875, "GT-B3710 Standalone LTE device (Commercial)" },
    { 0x04e86876, "GT-B3710 LTE Modem" },
    { 0x04e86877, "Samsung Galaxy models Kies mode" },
    { 0x04e8687a, "GT-E2370 mobile phone" },
    { 0x04e86888, "GT-B3730 Composite LTE device (Commercial)" },
    { 0x04e86889, "GT-B3730 Composite LTE device (Commercial)" },
    { 0x04e8689a, "LTE Storage Driver [CMC2xx]" },
    { 0x04e8689e, "GT-S5670 [Galaxy Fit]" },
    { 0x04e868a9, "Samsung Vibrant SGH-T959/Captivate/Media player mode" },
    { 0x04e868aa, "Reality" },
    { 0x04e868af, "Samsung GT-B2710/Xcover 271" },
    { 0x04e87011, "SEW-2003U Card" },
    { 0x04e87021, "Bluetooth Device" },
    { 0x04e87061, "eHome Infrared Receiver" },
    { 0x04e87080, "Anycall SCH-W580" },
    { 0x04e87081, "Human Interface Device" },
    { 0x04e87301, "Fingerprint Device" },
    { 0x04e88001, "Handheld" },
    { 0x04e88002, "Portable SSD 500GB Model Number: MU - P8500B" },
    { 0x04e88003, "Portable SSD T1" },
    { 0x04e8d003, "GT-I9003" },
    { 0x04e8e020, "SERI E02 SCOM 6200 UMTS Phone" },
    { 0x04e8e021, "SERI E02 SCOM 6200 Virtual UARTs" },
    { 0x04e8e022, "SERI E02 SCOM 6200 Flash Load Disk" },
    { 0x04e8e20c, "Samsung GT-S5230" },
    { 0x04e8f000, "Intensity 3 (Mass Storage Mode)" },
    { 0x04e8ff30, "SG_iMON" },
    { 0x04ebe004, "eHome Infrared Transceiver" },
    { 0x04f10001, "GC-QX3 Digital Still Camera" },
    { 0x04f10004, "GR-DVL815U Digital Video Camera" },
    { 0x04f10006, "DV Camera Storage" },
    { 0x04f10008, "GZ-MG30AA/MC500E Digital Video Camera" },
    { 0x04f10009, "GR-DX25EK Digital Video Camera" },
    { 0x04f1000a, "GR-D72 Digital Video Camera" },
    { 0x04f11001, "GC-A50 Camera Device" },
    { 0x04f13008, "MP-PRX1 Ethernet" },
    { 0x04f13009, "MP-XP7250 WLAN Adapter" },
    { 0x04f16105, "JVC Alneo XA-HD500" },
    { 0x04f20001, "KU-8933 Keyboard" },
    { 0x04f20002, "NT68P81 Keyboard" },
    { 0x04f20110, "KU-2971 Keyboard" },
    { 0x04f20111, "KU-9908 Keyboard" },
    { 0x04f20112, "KU-8933 Keyboard with PS/2 Mouse port" },
    { 0x04f20116, "KU-2971/KU-0325 Keyboard" },
    { 0x04f20200, "KBR-0108" },
    { 0x04f20201, "Gaming Keyboard KPD0250" },
    { 0x04f20220, "Wireless HID Receiver" },
    { 0x04f20402, "Genius LuxeMate i200 Keyboard" },
    { 0x04f20403, "KU-0420 keyboard" },
    { 0x04f20418, "KU-0418 Tactical Pad" },
    { 0x04f20618, "RG-0618U Wireless HID Receiver & KG-0609 Wireless Keyboard with Touchpad" },
    { 0x04f20718, "wired mouse" },
    { 0x04f20760, "Acer KU-0760 Keyboard" },
    { 0x04f20833, "KU-0833 Keyboard" },
    { 0x04f20841, "HP Multimedia Keyboard" },
    { 0x04f20860, "2.4G Multimedia Wireless Kit" },
    { 0x04f20939, "Amazon Basics mouse" },
    { 0x04f21061, "HP KG-1061 Wireless Keyboard+Mouse" },
    { 0x04f21121, "Periboard 717 Mini Wireless Keyboard" },
    { 0x04f2a001, "E-Video DC-100 Camera" },
    { 0x04f2a120, "ORITE CCD Webcam(PC370R)" },
    { 0x04f2a121, "ORITE CCD Webcam(PC370R)" },
    { 0x04f2a122, "ORITE CCD Webcam(PC370R)" },
    { 0x04f2a123, "ORITE CCD Webcam(PC370R)" },
    { 0x04f2a124, "ORITE CCD Webcam(PC370R)" },
    { 0x04f2a128, "PC Camera (SN9C202 + OV7663 + EEPROM)" },
    { 0x04f2a133, "Gateway Webcam" },
    { 0x04f2a136, "LabTec Webcam 5500" },
    { 0x04f2a147, "Medion Webcam" },
    { 0x04f2a204, "DSC WIA Device (1300)" },
    { 0x04f2a208, "DSC WIA Device (2320)" },
    { 0x04f2a209, "Labtec DC-2320" },
    { 0x04f2a20a, "DSC WIA Device (3310)" },
    { 0x04f2a20c, "DSC WIA Device (3320)" },
    { 0x04f2a210, "Audio Device" },
    { 0x04f2b008, "USB 2.0 Camera" },
    { 0x04f2b009, "Integrated Camera" },
    { 0x04f2b010, "Integrated Camera" },
    { 0x04f2b012, "1.3 MPixel UVC Webcam" },
    { 0x04f2b013, "USB 2.0 Camera" },
    { 0x04f2b015, "VGA 24fps UVC Webcam" },
    { 0x04f2b016, "VGA 30fps UVC Webcam" },
    { 0x04f2b018, "2M UVC Webcam" },
    { 0x04f2b021, "ViewSonic 1.3M, USB2.0 Webcam" },
    { 0x04f2b022, "Gateway USB 2.0 Webcam" },
    { 0x04f2b023, "Gateway USB 2.0 Webcam" },
    { 0x04f2b024, "USB 2.0 Webcam" },
    { 0x04f2b025, "Camera" },
    { 0x04f2b027, "Gateway USB 2.0 Webcam" },
    { 0x04f2b028, "VGA UVC Webcam" },
    { 0x04f2b029, "1.3M UVC Webcam" },
    { 0x04f2b036, "Asus Integrated 0.3M UVC Webcam" },
    { 0x04f2b044, "Acer CrystalEye Webcam" },
    { 0x04f2b057, "integrated USB webcam" },
    { 0x04f2b059, "CKF7037 HP webcam" },
    { 0x04f2b064, "CNA7137 Integrated Webcam" },
    { 0x04f2b070, "Camera" },
    { 0x04f2b071, "2.0M UVC Webcam / CNF7129" },
    { 0x04f2b083, "CKF7063 Webcam (HP)" },
    { 0x04f2b091, "Webcam" },
    { 0x04f2b104, "CNF7069 Webcam" },
    { 0x04f2b107, "CNF7070 Webcam" },
    { 0x04f2b14c, "CNF8050 Webcam" },
    { 0x04f2b159, "CNF8243 Webcam" },
    { 0x04f2b15c, "Sony Vaio Integrated Camera" },
    { 0x04f2b175, "4-Port Hub" },
    { 0x04f2b1aa, "Webcam-101" },
    { 0x04f2b1ac, "HP Laptop Integrated Webcam [2 MP Fixed]" },
    { 0x04f2b1b4, "Lenovo Integrated Camera" },
    { 0x04f2b1b9, "Asus Integrated Webcam" },
    { 0x04f2b1cf, "Lenovo Integrated Camera" },
    { 0x04f2b1d6, "CNF9055 Toshiba Webcam" },
    { 0x04f2b1d8, "1.3M Webcam" },
    { 0x04f2b1e4, "Toshiba Integrated Webcam" },
    { 0x04f2b213, "Fujitsu Integrated Camera" },
    { 0x04f2b217, "Lenovo Integrated Camera (0.3MP)" },
    { 0x04f2b221, "integrated camera" },
    { 0x04f2b230, "Integrated HP HD Webcam" },
    { 0x04f2b249, "HP Integrated Webcam" },
    { 0x04f2b257, "Lenovo Integrated Camera" },
    { 0x04f2b26b, "Sony Visual Communication Camera" },
    { 0x04f2b272, "Lenovo EasyCamera" },
    { 0x04f2b2b0, "Camera" },
    { 0x04f2b2b9, "Lenovo Integrated Camera UVC" },
    { 0x04f2b2da, "thinkpad t430s camera" },
    { 0x04f2b2db, "Thinkpad T430 camera" },
    { 0x04f2b2ea, "Integrated Camera [ThinkPad]" },
    { 0x04f2b2f4, "HP Webcam-50" },
    { 0x04f2b330, "Asus 720p CMOS webcam" },
    { 0x04f2b354, "UVC 1.00 device HD UVC WebCam" },
    { 0x04f2b394, "Integrated Camera" },
    { 0x04f2b3eb, "HP 720p HD Monitor Webcam" },
    { 0x04f2b3f6, "HD WebCam (Acer)" },
    { 0x04f2b3fd, "HD WebCam (Asus N-series)" },
    { 0x04f2b40e, "HP Truevision HD camera" },
    { 0x04f2b444, "Lenovo Integrated Webcam" },
    { 0x04f2b49f, "Bluetooth (RTL8723BE)" },
    { 0x04f2b563, "Integrated Camera" },
    { 0x04f2b5ce, "Integrated Camera" },
    { 0x04f2b5cf, "Integrated IR Camera" },
    { 0x04f2b5db, "HP Webcam" },
    { 0x04f2b604, "Integrated Camera (1280x720@30)" },
    { 0x04f2b681, "ThinkPad T490 Webcam" },
    { 0x04f3000a, "Touchscreen" },
    { 0x04f30103, "ActiveJet K-2024 Multimedia Keyboard" },
    { 0x04f3016f, "Touchscreen" },
    { 0x04f301a4, "Wireless Keyboard" },
    { 0x04f30201, "Touchscreen" },
    { 0x04f30210, "Optical Mouse" },
    { 0x04f30212, "Laser Mouse" },
    { 0x04f30214, "Lynx M9 Optical Mouse" },
    { 0x04f30230, "3D Optical Mouse" },
    { 0x04f30232, "Mouse" },
    { 0x04f30234, "Optical Mouse" },
    { 0x04f30235, "Optical Mouse" },
    { 0x04f302f4, "2.4G Cordless Mouse" },
    { 0x04f30381, "Touchscreen" },
    { 0x04f304a0, "Dream Cheeky Stress/Panic Button" },
    { 0x04f32234, "Touchscreen" },
    { 0x04f90002, "HL-1050 Laser Printer" },
    { 0x04f90005, "Printer" },
    { 0x04f90006, "HL-1240 Laser Printer" },
    { 0x04f90007, "HL-1250 Laser Printer" },
    { 0x04f90008, "HL-1270 Laser Printer" },
    { 0x04f90009, "Printer" },
    { 0x04f9000a, "P2500 series" },
    { 0x04f9000b, "Printer" },
    { 0x04f9000c, "Printer" },
    { 0x04f9000d, "HL-1440 Laser Printer" },
    { 0x04f9000e, "HL-1450 series" },
    { 0x04f9000f, "HL-1470N series" },
    { 0x04f90010, "Printer" },
    { 0x04f90011, "Printer" },
    { 0x04f90012, "Printer" },
    { 0x04f90013, "Printer" },
    { 0x04f90014, "Printer" },
    { 0x04f90015, "Printer" },
    { 0x04f90016, "Printer" },
    { 0x04f90017, "Printer" },
    { 0x04f90018, "Printer" },
    { 0x04f9001a, "HL-1430 Laser Printer" },
    { 0x04f9001c, "Printer" },
    { 0x04f9001e, "Printer" },
    { 0x04f90020, "HL-5130 series" },
    { 0x04f90021, "HL-5140 series" },
    { 0x04f90022, "HL-5150D series" },
    { 0x04f90023, "HL-5170DN series" },
    { 0x04f90024, "Printer" },
    { 0x04f90025, "Printer" },
    { 0x04f90027, "HL-2030 Laser Printer" },
    { 0x04f90028, "Printer" },
    { 0x04f90029, "Printer" },
    { 0x04f9002a, "HL-52x0 series" },
    { 0x04f9002b, "HL-5250DN Printer" },
    { 0x04f9002c, "Printer" },
    { 0x04f9002d, "Printer" },
    { 0x04f90039, "HL-5340 series" },
    { 0x04f90041, "HL-2250DN Laser Printer" },
    { 0x04f90042, "HL-2270DW Laser Printer" },
    { 0x04f9004d, "HL-6180DW series" },
    { 0x04f90080, "HL-L6250DN series" },
    { 0x04f90100, "MFC8600/9650 series" },
    { 0x04f90101, "MFC9600/9870 series" },
    { 0x04f90102, "MFC9750/1200 series" },
    { 0x04f90104, "MFC-8300J" },
    { 0x04f90105, "MFC-9600J" },
    { 0x04f90106, "MFC-7300C" },
    { 0x04f90107, "MFC-7400C" },
    { 0x04f90108, "MFC-9200C" },
    { 0x04f90109, "MFC-830" },
    { 0x04f9010a, "MFC-840" },
    { 0x04f9010b, "MFC-860" },
    { 0x04f9010c, "MFC-7400J" },
    { 0x04f9010d, "MFC-9200J" },
    { 0x04f9010e, "MFC-3100C Scanner" },
    { 0x04f9010f, "MFC-5100C" },
    { 0x04f90110, "MFC-4800 Scanner" },
    { 0x04f90111, "MFC-6800" },
    { 0x04f90112, "DCP1000 Port(FaxModem)" },
    { 0x04f90113, "MFC-8500" },
    { 0x04f90114, "MFC9700 Port(FaxModem)" },
    { 0x04f90115, "MFC-9800 Scanner" },
    { 0x04f90116, "DCP1400 Scanner" },
    { 0x04f90119, "MFC-9660" },
    { 0x04f9011a, "MFC-9860" },
    { 0x04f9011b, "MFC-9880" },
    { 0x04f9011c, "MFC-9760" },
    { 0x04f9011d, "MFC-9070" },
    { 0x04f9011e, "MFC-9180" },
    { 0x04f9011f, "MFC-9160" },
    { 0x04f90120, "MFC580 Port(FaxModem)" },
    { 0x04f90121, "MFC-590" },
    { 0x04f90122, "MFC-5100J" },
    { 0x04f90124, "MFC-4800J" },
    { 0x04f90125, "MFC-6800J" },
    { 0x04f90127, "MFC-9800J" },
    { 0x04f90128, "MFC-8500J" },
    { 0x04f90129, "Imagistics 2500 (MFC-8640D clone)" },
    { 0x04f9012b, "MFC-9030" },
    { 0x04f9012e, "FAX4100e IntelliFax 4100e" },
    { 0x04f9012f, "FAX-4750e" },
    { 0x04f90130, "FAX-5750e" },
    { 0x04f90132, "MFC-5200C RemovableDisk" },
    { 0x04f90135, "MFC-100 Scanner" },
    { 0x04f90136, "MFC-150CL Scanner" },
    { 0x04f9013c, "MFC-890 Port" },
    { 0x04f9013d, "MFC-5200J" },
    { 0x04f9013e, "MFC-4420C RemovableDisk" },
    { 0x04f9013f, "MFC-4820C RemovableDisk" },
    { 0x04f90140, "DCP-8020" },
    { 0x04f90141, "DCP-8025D" },
    { 0x04f90142, "MFC-8420" },
    { 0x04f90143, "MFC-8820D" },
    { 0x04f90144, "DCP-4020C RemovableDisk" },
    { 0x04f90146, "MFC-3220C" },
    { 0x04f90147, "FAX-1820C Printer" },
    { 0x04f90148, "MFC-3320CN" },
    { 0x04f90149, "FAX-1920CN Printer" },
    { 0x04f9014a, "MFC-3420C" },
    { 0x04f9014b, "MFC-3820CN" },
    { 0x04f9014c, "DCP-3020C" },
    { 0x04f9014d, "FAX-1815C Printer" },
    { 0x04f9014e, "MFC-8820J" },
    { 0x04f9014f, "DCP-8025J" },
    { 0x04f90150, "MFC-8220 Port(FaxModem)" },
    { 0x04f90151, "MFC-8210J" },
    { 0x04f90153, "DCP-1000J" },
    { 0x04f90157, "MFC-3420J Printer" },
    { 0x04f90158, "MFC-3820JN Port(FaxModem)" },
    { 0x04f9015d, "MFC Composite Device" },
    { 0x04f9015e, "DCP-8045D" },
    { 0x04f9015f, "MFC-8440" },
    { 0x04f90160, "MFC-8840D" },
    { 0x04f90161, "MFC-210C" },
    { 0x04f90162, "MFC-420CN Remote Setup Port" },
    { 0x04f90163, "MFC-410CN RemovableDisk" },
    { 0x04f90165, "MFC-620CN" },
    { 0x04f90166, "MFC-610CLN RemovableDisk" },
    { 0x04f90168, "MFC-620CLN" },
    { 0x04f90169, "DCP-110C RemovableDisk" },
    { 0x04f9016b, "DCP-310CN RemovableDisk" },
    { 0x04f9016c, "FAX-2440C Printer" },
    { 0x04f9016d, "MFC-5440CN" },
    { 0x04f9016e, "MFC-5840CN Remote Setup Port" },
    { 0x04f90170, "FAX-1840C Printer" },
    { 0x04f90171, "FAX-1835C Printer" },
    { 0x04f90172, "FAX-1940CN Printer" },
    { 0x04f90173, "MFC-3240C Remote Setup Port" },
    { 0x04f90174, "MFC-3340CN RemovableDisk" },
    { 0x04f9017b, "Imagistics sx2100" },
    { 0x04f90180, "MFC-7420" },
    { 0x04f90181, "MFC-7820N Port(FaxModem)" },
    { 0x04f90182, "DCP-7010" },
    { 0x04f90183, "DCP-7020" },
    { 0x04f90184, "DCP-7025 Printer" },
    { 0x04f90185, "MFC-7220 Printer" },
    { 0x04f90186, "Composite Device" },
    { 0x04f90187, "FAX-2820 Printer" },
    { 0x04f90188, "FAX-2920 Printer" },
    { 0x04f9018a, "MFC-9420CN" },
    { 0x04f9018c, "DCP-115C" },
    { 0x04f9018d, "DCP-116C" },
    { 0x04f9018e, "DCP-117C" },
    { 0x04f9018f, "DCP-118C" },
    { 0x04f90190, "DCP-120C" },
    { 0x04f90191, "DCP-315CN" },
    { 0x04f90192, "DCP-340CW" },
    { 0x04f90193, "MFC-215C" },
    { 0x04f90194, "MFC-425CN" },
    { 0x04f90195, "MFC-820CW Remote Setup Port" },
    { 0x04f90196, "MFC-820CN Remote Setup Port" },
    { 0x04f90197, "MFC-640CW" },
    { 0x04f9019a, "MFC-840CLN Remote Setup Port" },
    { 0x04f901a2, "MFC-8640D" },
    { 0x04f901a3, "Composite Device" },
    { 0x04f901a4, "DCP-8065DN Printer" },
    { 0x04f901a5, "MFC-8460N Port(FaxModem)" },
    { 0x04f901a6, "MFC-8860DN Port(FaxModem)" },
    { 0x04f901a7, "MFC-8870DW Printer" },
    { 0x04f901a8, "DCP-130C" },
    { 0x04f901a9, "DCP-330C" },
    { 0x04f901aa, "DCP-540CN" },
    { 0x04f901ab, "MFC-240C" },
    { 0x04f901ae, "DCP-750CW RemovableDisk" },
    { 0x04f901af, "MFC-440CN" },
    { 0x04f901b0, "MFC-660CN" },
    { 0x04f901b1, "MFC-665CW" },
    { 0x04f901b2, "MFC-845CW" },
    { 0x04f901b4, "MFC-460CN" },
    { 0x04f901b5, "MFC-630CD" },
    { 0x04f901b6, "MFC-850CDN" },
    { 0x04f901b7, "MFC-5460CN" },
    { 0x04f901b8, "MFC-5860CN" },
    { 0x04f901ba, "MFC-3360C" },
    { 0x04f901bd, "MFC-8660DN" },
    { 0x04f901be, "DCP-750CN RemovableDisk" },
    { 0x04f901bf, "MFC-860CDN" },
    { 0x04f901c0, "DCP-128C" },
    { 0x04f901c1, "DCP-129C" },
    { 0x04f901c2, "DCP-131C" },
    { 0x04f901c3, "DCP-329C" },
    { 0x04f901c4, "DCP-331C" },
    { 0x04f901c5, "MFC-239C" },
    { 0x04f901c9, "DCP-9040CN" },
    { 0x04f901ca, "MFC-9440CN" },
    { 0x04f901cb, "DCP-9045CDN" },
    { 0x04f901cc, "MFC-9840CDW" },
    { 0x04f901ce, "DCP-135C" },
    { 0x04f901cf, "DCP-150C" },
    { 0x04f901d0, "DCP-350C" },
    { 0x04f901d1, "DCP-560CN" },
    { 0x04f901d2, "DCP-770CW" },
    { 0x04f901d3, "DCP-770CN" },
    { 0x04f901d4, "MFC-230C" },
    { 0x04f901d5, "MFC-235C" },
    { 0x04f901d6, "MFC-260C" },
    { 0x04f901d7, "MFC-465CN" },
    { 0x04f901d8, "MFC-680CN" },
    { 0x04f901d9, "MFC-685CW" },
    { 0x04f901da, "MFC-885CW" },
    { 0x04f901db, "MFC-480CN" },
    { 0x04f901dc, "MFC-650CD" },
    { 0x04f901dd, "MFC-870CDN" },
    { 0x04f901de, "MFC-880CDN" },
    { 0x04f901df, "DCP-155C" },
    { 0x04f901e0, "MFC-265C" },
    { 0x04f901e1, "DCP-153C" },
    { 0x04f901e2, "DCP-157C" },
    { 0x04f901e3, "DCP-353C" },
    { 0x04f901e4, "DCP-357C" },
    { 0x04f901e7, "MFC-7340" },
    { 0x04f901e9, "DCP-7040" },
    { 0x04f901ea, "DCP-7030" },
    { 0x04f901eb, "MFC-7320" },
    { 0x04f901ec, "MFC-9640CW" },
    { 0x04f901f4, "MFC-5890CN" },
    { 0x04f9020a, "MFC-8670DN" },
    { 0x04f9020c, "DCP-9042CDN" },
    { 0x04f9020d, "MFC-9450CDN" },
    { 0x04f90216, "MFC-8880DN" },
    { 0x04f90217, "MFC-8480DN" },
    { 0x04f90219, "MFC-8380DN" },
    { 0x04f9021a, "MFC-8370DN" },
    { 0x04f9021b, "DCP-8070D" },
    { 0x04f9021c, "MFC-9320CW" },
    { 0x04f9021d, "MFC-9120CN" },
    { 0x04f9021e, "DCP-9010CN" },
    { 0x04f9021f, "DCP-8085DN" },
    { 0x04f90220, "MFC-9010CN" },
    { 0x04f90222, "DCP-195C" },
    { 0x04f90223, "DCP-365CN" },
    { 0x04f90224, "DCP-375CW" },
    { 0x04f90225, "DCP-395CN" },
    { 0x04f90227, "DCP-595CN" },
    { 0x04f90228, "MFC-255CW" },
    { 0x04f90229, "MFC-295CN" },
    { 0x04f9022a, "MFC-495CW" },
    { 0x04f9022b, "MFC-495CN" },
    { 0x04f9022c, "MFC-795CW" },
    { 0x04f9022d, "MFC-675CD" },
    { 0x04f9022e, "MFC-695CDN" },
    { 0x04f9022f, "MFC-735CD" },
    { 0x04f90230, "MFC-935CDN" },
    { 0x04f90234, "DCP-373CW" },
    { 0x04f90235, "DCP-377CW" },
    { 0x04f90236, "DCP-390CN" },
    { 0x04f90239, "MFC-253CW" },
    { 0x04f9023a, "MFC-257CW" },
    { 0x04f9023e, "DCP-197C" },
    { 0x04f9023f, "MFC-8680DN" },
    { 0x04f90240, "MFC-J950DN" },
    { 0x04f90245, "MFC-9560CDW" },
    { 0x04f90248, "DCP-7055 scanner/printer" },
    { 0x04f9024e, "MFC-7460DN" },
    { 0x04f90253, "DCP-J125" },
    { 0x04f90254, "DCP-J315W" },
    { 0x04f90255, "DCP-J515W" },
    { 0x04f90256, "DCP-J515N" },
    { 0x04f90257, "DCP-J715W" },
    { 0x04f90258, "DCP-J715N" },
    { 0x04f90259, "MFC-J220" },
    { 0x04f9025a, "MFC-J410" },
    { 0x04f9025b, "MFC-J265W" },
    { 0x04f9025c, "MFC-J415W" },
    { 0x04f9025d, "MFC-J615W" },
    { 0x04f9025e, "MFC-J615N" },
    { 0x04f9025f, "MFC-J700D" },
    { 0x04f90260, "MFC-J800D" },
    { 0x04f90261, "MFC-J850DN" },
    { 0x04f9026b, "MFC-J630W" },
    { 0x04f9026d, "MFC-J805D" },
    { 0x04f9026e, "MFC-J855DN" },
    { 0x04f9026f, "MFC-J270W" },
    { 0x04f90270, "MFC-7360N" },
    { 0x04f90273, "DCP-7057 scanner/printer" },
    { 0x04f90276, "MFC-5895CW" },
    { 0x04f90278, "MFC-J410W" },
    { 0x04f90279, "DCP-J525W" },
    { 0x04f9027a, "DCP-J525N" },
    { 0x04f9027b, "DCP-J725DW" },
    { 0x04f9027c, "DCP-J725N" },
    { 0x04f9027d, "DCP-J925DW" },
    { 0x04f9027e, "MFC-J955DN" },
    { 0x04f9027f, "MFC-J280W" },
    { 0x04f90280, "MFC-J435W" },
    { 0x04f90281, "MFC-J430W" },
    { 0x04f90282, "MFC-J625DW" },
    { 0x04f90283, "MFC-J825DW" },
    { 0x04f90284, "MFC-J825N" },
    { 0x04f90285, "MFC-J705D" },
    { 0x04f90287, "MFC-J860DN" },
    { 0x04f90288, "MFC-J5910DW" },
    { 0x04f90289, "MFC-J5910CDW" },
    { 0x04f9028a, "DCP-J925N" },
    { 0x04f9028d, "MFC-J835DW" },
    { 0x04f9028f, "MFC-J425W" },
    { 0x04f90290, "MFC-J432W" },
    { 0x04f90291, "DCP-8110DN" },
    { 0x04f90292, "DCP-8150DN" },
    { 0x04f90293, "DCP-8155DN" },
    { 0x04f90294, "DCP-8250DN" },
    { 0x04f90295, "MFC-8510DN" },
    { 0x04f90296, "MFC-8520DN" },
    { 0x04f90298, "MFC-8910DW" },
    { 0x04f90299, "MFC-8950DW" },
    { 0x04f9029a, "MFC-8690DW" },
    { 0x04f9029c, "MFC-8515DN" },
    { 0x04f9029e, "MFC-9125CN" },
    { 0x04f9029f, "MFC-9325CW" },
    { 0x04f902a0, "DCP-J140W" },
    { 0x04f902a5, "MFC-7240" },
    { 0x04f902a6, "FAX-2940" },
    { 0x04f902a7, "FAX-2950" },
    { 0x04f902a8, "MFC-7290" },
    { 0x04f902ab, "FAX-2990" },
    { 0x04f902ac, "DCP-8110D" },
    { 0x04f902ad, "MFC-9130CW" },
    { 0x04f902ae, "MFC-9140CDN" },
    { 0x04f902af, "MFC-9330CDW" },
    { 0x04f902b0, "MFC-9340CDW" },
    { 0x04f902b1, "DCP-9020CDN" },
    { 0x04f902b2, "MFC-J810DN" },
    { 0x04f902b3, "MFC-J4510DW" },
    { 0x04f902b4, "MFC-J4710DW" },
    { 0x04f902b5, "DCP-8112DN" },
    { 0x04f902b6, "DCP-8152DN" },
    { 0x04f902b7, "DCP-8157DN" },
    { 0x04f902b8, "MFC-8512DN" },
    { 0x04f902ba, "MFC-8912DW" },
    { 0x04f902bb, "MFC-8952DW" },
    { 0x04f902bc, "DCP-J540N" },
    { 0x04f902bd, "DCP-J740N" },
    { 0x04f902be, "MFC-J710D" },
    { 0x04f902bf, "MFC-J840N" },
    { 0x04f902c0, "DCP-J940N" },
    { 0x04f902c1, "MFC-J960DN" },
    { 0x04f902c2, "DCP-J4110DW" },
    { 0x04f902c3, "MFC-J4310DW" },
    { 0x04f902c4, "MFC-J4410DW" },
    { 0x04f902c5, "MFC-J4610DW" },
    { 0x04f902c6, "DCP-J4210N" },
    { 0x04f902c7, "MFC-J4510N" },
    { 0x04f902c8, "MFC-J4910CDW" },
    { 0x04f902c9, "MFC-J4810DN" },
    { 0x04f902ca, "MFC-8712DW" },
    { 0x04f902cb, "MFC-8710DW" },
    { 0x04f902cc, "MFC-J2310" },
    { 0x04f902cd, "MFC-J2510" },
    { 0x04f902ce, "DCP-7055W" },
    { 0x04f902cf, "DCP-7057W" },
    { 0x04f902d0, "DCP-1510" },
    { 0x04f902d1, "MFC-1810" },
    { 0x04f902d3, "DCP-9020CDW" },
    { 0x04f902d4, "MFC-8810DW" },
    { 0x04f902dd, "DCP-J4215N" },
    { 0x04f902de, "DCP-J132W" },
    { 0x04f902df, "DCP-J152W" },
    { 0x04f902e0, "DCP-J152N" },
    { 0x04f902e1, "DCP-J172W" },
    { 0x04f902e2, "DCP-J552DW" },
    { 0x04f902e3, "DCP-J552N" },
    { 0x04f902e4, "DCP-J752DW" },
    { 0x04f902e5, "DCP-J752N" },
    { 0x04f902e6, "DCP-J952N" },
    { 0x04f902e7, "MFC-J245" },
    { 0x04f902e8, "MFC-J470DW" },
    { 0x04f902e9, "MFC-J475DW" },
    { 0x04f902ea, "MFC-J285DW" },
    { 0x04f902eb, "MFC-J650DW" },
    { 0x04f902ec, "MFC-J870DW" },
    { 0x04f902ed, "MFC-J870N" },
    { 0x04f902ee, "MFC-J720D" },
    { 0x04f902ef, "MFC-J820DN" },
    { 0x04f902f0, "MFC-J980DN" },
    { 0x04f902f1, "MFC-J890DN" },
    { 0x04f902f2, "MFC-J6520DW" },
    { 0x04f902f3, "MFC-J6570CDW" },
    { 0x04f902f4, "MFC-J6720DW" },
    { 0x04f902f5, "MFC-J6920DW" },
    { 0x04f902f6, "MFC-J6970CDW" },
    { 0x04f902f7, "MFC-J6975CDW" },
    { 0x04f902f8, "MFC-J6770CDW" },
    { 0x04f902f9, "DCP-J132N" },
    { 0x04f902fa, "MFC-J450DW" },
    { 0x04f902fb, "MFC-J875DW" },
    { 0x04f902fc, "DCP-J100" },
    { 0x04f902fd, "DCP-J105" },
    { 0x04f902fe, "MFC-J200" },
    { 0x04f902ff, "MFC-J3520" },
    { 0x04f90300, "MFC-J3720" },
    { 0x04f9030f, "DCP-L8400CDN" },
    { 0x04f90310, "DCP-L8450CDW" },
    { 0x04f90311, "MFC-L8600CDW" },
    { 0x04f90312, "MFC-L8650CDW" },
    { 0x04f90313, "MFC-L8850CDW" },
    { 0x04f90314, "MFC-L9550CDW" },
    { 0x04f90318, "MFC-7365DN" },
    { 0x04f90320, "MFC-L2740DW" },
    { 0x04f90321, "DCP-L2500D" },
    { 0x04f90322, "DCP-L2520DW" },
    { 0x04f90324, "DCP-L2520D" },
    { 0x04f90326, "DCP-L2540DN" },
    { 0x04f90328, "DCP-L2540DW" },
    { 0x04f90329, "DCP-L2560DW" },
    { 0x04f90330, "HL-L2380DW" },
    { 0x04f90331, "MFC-L2700DW" },
    { 0x04f90335, "FAX-L2700DN" },
    { 0x04f90337, "MFC-L2720DW" },
    { 0x04f90338, "MFC-L2720DN" },
    { 0x04f90339, "DCP-J4120DW" },
    { 0x04f9033a, "MFC-J4320DW" },
    { 0x04f9033c, "MFC-J2320" },
    { 0x04f9033d, "MFC-J4420DW" },
    { 0x04f90340, "MFC-J4620DW" },
    { 0x04f90341, "MFC-J2720" },
    { 0x04f90342, "MFC-J4625DW" },
    { 0x04f90343, "MFC-J5320DW" },
    { 0x04f90346, "MFC-J5620DW" },
    { 0x04f90347, "MFC-J5720DW" },
    { 0x04f90349, "DCP-J4220N" },
    { 0x04f9034b, "MFC-J4720N" },
    { 0x04f9034e, "MFC-J5720CDW" },
    { 0x04f9034f, "MFC-J5820DN" },
    { 0x04f90350, "MFC-J5620CDW" },
    { 0x04f90351, "DCP-J137N" },
    { 0x04f90353, "DCP-J557N" },
    { 0x04f90354, "DCP-J757N" },
    { 0x04f90355, "DCP-J957N" },
    { 0x04f90356, "MFC-J877N" },
    { 0x04f90357, "MFC-J727D" },
    { 0x04f90358, "MFC-J987DN" },
    { 0x04f90359, "MFC-J827DN" },
    { 0x04f9035a, "MFC-J897DN" },
    { 0x04f9035b, "DCP-1610W" },
    { 0x04f9035c, "DCP-1610NW" },
    { 0x04f9035d, "MFC-1910W" },
    { 0x04f9035e, "MFC-1910NW" },
    { 0x04f90360, "DCP-1618W" },
    { 0x04f90361, "MFC-1919NW" },
    { 0x04f90364, "MFC-J5625DW" },
    { 0x04f90365, "MFC-J4520DW" },
    { 0x04f90366, "MFC-J5520DW" },
    { 0x04f90367, "DCP-7080D" },
    { 0x04f90368, "DCP-7080" },
    { 0x04f90369, "DCP-7180DN" },
    { 0x04f9036a, "DCP-7189DW" },
    { 0x04f9036b, "MFC-7380" },
    { 0x04f9036c, "MFC-7480D" },
    { 0x04f9036d, "MFC-7880DN" },
    { 0x04f9036e, "MFC-7889DW" },
    { 0x04f9036f, "DCP-9022CDW" },
    { 0x04f90370, "MFC-9142CDN" },
    { 0x04f90371, "MFC-9332CDW" },
    { 0x04f90372, "MFC-9342CDW" },
    { 0x04f90373, "MFC-L2700D" },
    { 0x04f90376, "DCP-1600" },
    { 0x04f90377, "MFC-1900" },
    { 0x04f90378, "DCP-1608" },
    { 0x04f90379, "DCP-1619" },
    { 0x04f9037a, "MFC-1906" },
    { 0x04f9037b, "MFC-1908" },
    { 0x04f9037c, "ADS-2000e" },
    { 0x04f9037d, "ADS-2100e" },
    { 0x04f9037e, "ADS-2500We" },
    { 0x04f9037f, "ADS-2600We" },
    { 0x04f90380, "DCP-J562DW" },
    { 0x04f90381, "DCP-J562N" },
    { 0x04f90383, "DCP-J962N" },
    { 0x04f90384, "MFC-J480DW" },
    { 0x04f90385, "MFC-J485DW" },
    { 0x04f90386, "MFC-J460DW" },
    { 0x04f90388, "MFC-J680DW" },
    { 0x04f90389, "MFC-J880DW" },
    { 0x04f9038a, "MFC-J885DW" },
    { 0x04f9038b, "MFC-J880N" },
    { 0x04f9038c, "MFC-J730DN" },
    { 0x04f9038d, "MFC-J990DN" },
    { 0x04f9038e, "MFC-J830DN" },
    { 0x04f9038f, "MFC-J900DN" },
    { 0x04f90390, "MFC-J5920DW" },
    { 0x04f90392, "MFC-L2705DW" },
    { 0x04f90393, "DCP-T300" },
    { 0x04f90394, "DCP-T500W" },
    { 0x04f90395, "DCP-T700W" },
    { 0x04f90396, "MFC-T800W" },
    { 0x04f90397, "DCP-J963N" },
    { 0x04f903b3, "MFC-J6925DW" },
    { 0x04f903b4, "MFC-J6573CDW" },
    { 0x04f903b5, "MFC-J6973CDW" },
    { 0x04f903b6, "MFC-J6990CDW" },
    { 0x04f903bb, "MFC-L2680W" },
    { 0x04f903bc, "MFC-L2700DN" },
    { 0x04f903bd, "DCP-J762N" },
    { 0x04f903fd, "ADS-2700W" },
    { 0x04f91000, "Printer" },
    { 0x04f91002, "Printer" },
    { 0x04f92002, "PTUSB Printing" },
    { 0x04f92004, "PT-2300/2310 p-Touch Laber Printer" },
    { 0x04f92007, "PT-2420PC P-touch Label Printer" },
    { 0x04f92015, "QL-500 label printer" },
    { 0x04f92016, "QL-550 printer" },
    { 0x04f9201a, "PT-18R P-touch label printer" },
    { 0x04f9201b, "QL-650TD Label Printer" },
    { 0x04f92020, "QL-1050 Label Printer" },
    { 0x04f92027, "QL-560 Label Printer" },
    { 0x04f92028, "QL-570 Label Printer" },
    { 0x04f9202a, "QL-1060N Label Printer" },
    { 0x04f9202b, "PT-7600 P-touch Label Printer" },
    { 0x04f9202c, "PT-1230PC P-touch Label Printer E mode" },
    { 0x04f9202d, "PT-2430PC P-touch Label Printer" },
    { 0x04f92030, "PT-1230PC P-touch Label Printer EL mode" },
    { 0x04f92041, "PT-2730 P-touch Label Printer" },
    { 0x04f92042, "QL-700 Label Printer" },
    { 0x04f92043, "QL-710W Label Printer" },
    { 0x04f92044, "QL-720NW Label Printer" },
    { 0x04f9204d, "QL-720NW Label Printer (mass storage mode)" },
    { 0x04f92061, "PT-P700 P-touch Label Printer" },
    { 0x04f92064, "PT-P700 P-touch Label Printer RemovableDisk" },
    { 0x04f9209b, "QL-800 Label Printer" },
    { 0x04f9209c, "QL-810W Label Printer" },
    { 0x04f9209d, "QL-820NWB Label Printer" },
    { 0x04f920a7, "QL-1100 Label Printer" },
    { 0x04f920a8, "QL-1110NWB Label Printer" },
    { 0x04f920a9, "QL-1100 Label Printer (mass storage)" },
    { 0x04f920aa, "QL-1110NWB Label Printer (mass storage)" },
    { 0x04f920ab, "QL-1115NWB Label Printer" },
    { 0x04f920ac, "QL-1115NWB Label Printer (mass storage)" },
    { 0x04f920c0, "QL-600 Label Printer" },
    { 0x04f92100, "Card Reader Writer" },
    { 0x04f92102, "Sewing machine" },
    { 0x04f960a0, "ADS-2000" },
    { 0x04f960a1, "ADS-2100" },
    { 0x04f960a4, "ADS-2500W" },
    { 0x04f960a5, "ADS-2600W" },
    { 0x04f960a6, "ADS-1000W" },
    { 0x04f960a7, "ADS-1100W" },
    { 0x04f960a8, "ADS-1500W" },
    { 0x04f960a9, "ADS-1600W" },
    { 0x04fa2490, "DS1490F 2-in-1 Fob, 1-Wire adapter" },
    { 0x04fa4201, "DS4201 Audio DAC" },
    { 0x04fc0003, "CM1092 / Wintech CM-5098 Optical Mouse" },
    { 0x04fc0005, "USB OpticalWheel Mouse" },
    { 0x04fc0013, "ViewMate Desktop Mouse CC2201" },
    { 0x04fc0015, "ViewMate Desktop Mouse CC2201" },
    { 0x04fc00d3, "00052486 / Laser Mouse M1052 [hama]" },
    { 0x04fc0171, "SPCA1527A/SPCA1528 SD card camera (Mass Storage mode)" },
    { 0x04fc0201, "SPCP825 RS232C Adapter" },
    { 0x04fc0232, "Fingerprint" },
    { 0x04fc0538, "Wireless Optical Mouse 2.4G [Bright]" },
    { 0x04fc0561, "Flexcam 100" },
    { 0x04fc05d8, "Wireless keyboard/mouse" },
    { 0x04fc05da, "SPEEDLINK SNAPPY Wireless Mouse Nano" },
    { 0x04fc0c15, "SPIF215A SATA bridge" },
    { 0x04fc0c25, "SATALink SPIF225A" },
    { 0x04fc1528, "SPCA1527A/SPCA1528 SD card camera (webcam mode)" },
    { 0x04fc1533, "Mass Storage" },
    { 0x04fc2080, "ASUS Webcam" },
    { 0x04fc500c, "CA500C Digital Camera" },
    { 0x04fc504a, "Aiptek Mini PenCam 1.3" },
    { 0x04fc504b, "Aiptek Mega PockerCam 1.3/Maxell MaxPocket LE 1.3" },
    { 0x04fc5330, "Digitrex 2110" },
    { 0x04fc5331, "Vivitar Vivicam 10" },
    { 0x04fc5360, "Sunplus Generic Digital Camera" },
    { 0x04fc5563, "Digital Media Player MP3/WMA [The Sharper Image]" },
    { 0x04fc5720, "Card Reader Driver" },
    { 0x04fc6333, "Siri A9 UVC chipset" },
    { 0x04fc7333, "Finet Technology Palmpix DC-85" },
    { 0x04fc757a, "Aiptek, MP315 MP3 Player" },
    { 0x04fcffff, "PureDigital Ritz Disposable" },
    { 0x04fd0003, "Smart Card Reader II" },
    { 0x04fe0006, "Happy Hacking Keyboard Lite2" },
    { 0x05000001, "DART Keyboard Mouse" },
    { 0x05000002, "DART-2 Keyboard" },
    { 0x05020001, "Handheld" },
    { 0x05020736, "Handheld" },
    { 0x050215b1, "PDA n311" },
    { 0x05021631, "c10 Series" },
    { 0x05021632, "c20 Series" },
    { 0x050216e1, "n10 Handheld Sync" },
    { 0x050216e2, "n20 Pocket PC Sync" },
    { 0x050216e3, "n30 Handheld Sync" },
    { 0x05022008, "Liquid Gallant Duo E350 (preloader)" },
    { 0x05023202, "Liquid" },
    { 0x05023203, "Liquid (Debug mode)" },
    { 0x05023230, "BeTouch E120" },
    { 0x05023317, "Liquid" },
    { 0x05023325, "Acer Iconia TAB A500 (ID1)" },
    { 0x05023341, "Acer Iconia TAB A500 (ID2)" },
    { 0x05023344, "Acer Iconia TAB A501" },
    { 0x05023348, "Acer Iconia TAB A100 (ID1)" },
    { 0x05023349, "Acer Iconia TAB A100 (ID2)" },
    { 0x05023378, "Acer Iconia TAB A700" },
    { 0x0502337c, "Acer Iconia TAB A200 (ID1)" },
    { 0x0502337d, "Acer Iconia TAB A200 (ID2)" },
    { 0x0502338a, "Acer Iconia TAB A510" },
    { 0x050233c3, "Acer E350 Liquid Gallant Duo" },
    { 0x050233c4, "Liquid Gallant Duo E350 (debug mode)" },
    { 0x050233c7, "Liquid Gallant Duo E350 (USB tethering)" },
    { 0x050233c8, "Liquid Gallant Duo E350 (debug mode, USB tethering)" },
    { 0x0502d001, "Divio NW801/DVC-V6+ Digital Camera" },
    { 0x0506009d, "HomeConnect Camera" },
    { 0x050600a0, "3CREB96 Bluetooth Adapter" },
    { 0x050600a1, "Bluetooth Device" },
    { 0x050600a2, "Bluetooth Device" },
    { 0x050600df, "3Com Home Connect lite" },
    { 0x05060100, "HomeConnect ADSL Modem Driver" },
    { 0x050603e8, "3C19250 Ethernet [klsi]" },
    { 0x05060a01, "3CRSHEW696 Wireless Adapter" },
    { 0x05060a11, "3CRWE254G72 802.11g Adapter" },
    { 0x050611f8, "HomeConnect 3C460" },
    { 0x05062922, "HomeConnect Cable Modem External with" },
    { 0x05063021, "U.S.Robotics 56000 Voice FaxModem Pro" },
    { 0x05064601, "3C460B 10/100 Ethernet Adapter" },
    { 0x0506f002, "3CP4218 ADSL Modem (pre-init)" },
    { 0x0506f003, "3CP4218 ADSL Modem" },
    { 0x0506f100, "3CP4218 ADSL Modem (pre-init)" },
    { 0x05070011, "Konami ParaParaParadise Controller" },
    { 0x05090801, "ADSL Modem" },
    { 0x05090802, "ADSL Modem (RFC1483)" },
    { 0x05090806, "DSL Modem" },
    { 0x0509080f, "Binatone ADSL500 Modem Network Interface" },
    { 0x05090812, "Pirelli ADSL Modem Network Interface" },
    { 0x050d0004, "Direct Connect" },
    { 0x050d0012, "F8T012 Bluetooth Adapter" },
    { 0x050d0013, "F8T013 Bluetooth Adapter" },
    { 0x050d0017, "B8T017 Bluetooth+EDR 2.1 / F4U017 USB 2.0 7-port Hub" },
    { 0x050d003a, "Universal Media Reader" },
    { 0x050d0050, "F5D6050 802.11b Wireless Adapter v2000 [Atmel at76c503a]" },
    { 0x050d0081, "F8T001v2 Bluetooth" },
    { 0x050d0083, "Bluetooth Device" },
    { 0x050d0084, "F8T003v2 Bluetooth" },
    { 0x050d0102, "Flip KVM" },
    { 0x050d0103, "F5U103 Serial Adapter [etek]" },
    { 0x050d0106, "VideoBus II Adapter, Video" },
    { 0x050d0108, "F1DE108B KVM" },
    { 0x050d0109, "F5U109/F5U409 PDA Adapter" },
    { 0x050d0115, "SCSI Adapter" },
    { 0x050d0119, "F5U120-PC Dual PS/2 Ports / F5U118-UNV ADB Adapter" },
    { 0x050d0121, "F5D5050 100Mbps Ethernet" },
    { 0x050d0122, "Ethernet Adapter" },
    { 0x050d0131, "Bluetooth Device with trace filter" },
    { 0x050d016a, "Bluetooth Mini Dongle" },
    { 0x050d0200, "Nostromo SpeedPad n52te Gaming Keyboard" },
    { 0x050d0201, "Peripheral Switch" },
    { 0x050d0208, "USBView II Video Adapter [nt1004]" },
    { 0x050d0210, "F5U228 Hi-Speed USB 2.0 DVD Creator" },
    { 0x050d0211, "F5U211 USB 2.0 15-in-1 Media Reader & Writer" },
    { 0x050d0224, "F5U224 USB 2.0 4-Port Hub" },
    { 0x050d0234, "F5U234 USB 2.0 4-Port Hub" },
    { 0x050d0237, "F5U237 USB 2.0 7-Port Hub" },
    { 0x050d0240, "F5U240 USB 2.0 CF Card Reader" },
    { 0x050d0249, "USB 2 Flash Media Device" },
    { 0x050d0257, "F5U257 Serial" },
    { 0x050d0304, "FSU304 USB 2.0 - 4 Ports Hub" },
    { 0x050d0307, "USB 2.0 - 7 ports Hub [FSU307]" },
    { 0x050d038c, "F2CU038 HDMI Adapter" },
    { 0x050d0409, "F5U409 Serial" },
    { 0x050d0416, "Staples 12416 7 port desktop hub" },
    { 0x050d0551, "F6C550-AVR UPS" },
    { 0x050d065a, "F8T065BF Mini Bluetooth 4.0 Adapter" },
    { 0x050d0706, "2-N-1 7-Port Hub (Lower half)" },
    { 0x050d0802, "Nostromo n40 Gamepad" },
    { 0x050d0803, "Nostromo 1745 GamePad" },
    { 0x050d0805, "Nostromo N50 GamePad" },
    { 0x050d0815, "Nostromo n52 HID SpeedPad Mouse Wheel" },
    { 0x050d0826, "ErgoFit Wireless Optical Mouse (HID)" },
    { 0x050d0980, "HID UPS Battery" },
    { 0x050d1004, "F9L1004 802.11n Surf N300 XR Wireless Adapter [Realtek RTL8192CU]" },
    { 0x050d1102, "F7D1102 N150/Surf Micro Wireless Adapter v1000 [Realtek RTL8188CUS]" },
    { 0x050d1103, "F9L1103 N750 DB 802.11abgn 2x3:3 [Ralink RT3573]" },
    { 0x050d1106, "F9L1106v1 802.11a/b/g/n/ac Wireless Adapter [Broadcom BCM43526]" },
    { 0x050d1109, "F9L1109v1 802.11a/b/g/n/ac Wireless Adapter [Realtek RTL8812AU]" },
    { 0x050d110a, "F9L1101v2 802.11abgn Wireless Adapter [Realtek RTL8192DU]" },
    { 0x050d11f2, "ISY Wireless Micro Adapter IWL 2000 [RTL8188CUS]" },
    { 0x050d1202, "F5U120-PC Parallel Printer Port" },
    { 0x050d1203, "F5U120-PC Serial Port" },
    { 0x050d2103, "F7D2102 802.11n N300 Micro Wireless Adapter v3000 [Realtek RTL8192CU]" },
    { 0x050d21f1, "N300 WLAN N Adapter [ISY]" },
    { 0x050d21f2, "RTL8192CU 802.11n WLAN Adapter [ISY IWL 4000]" },
    { 0x050d258a, "F5U258 Host to Host cable" },
    { 0x050d3101, "F1DF102U/F1DG102U Flip Hub" },
    { 0x050d3201, "F1DF102U/F1DG102U Flip KVM" },
    { 0x050d4050, "ZD1211B" },
    { 0x050d5055, "F5D5055 Gigabit Network Adapter [AX88xxx]" },
    { 0x050d6050, "F6D6050 802.11abgn Wireless Adapter [Broadcom BCM4323]" },
    { 0x050d6051, "F5D6051 802.11b Wireless Network Adapter [ZyDAS ZD1201]" },
    { 0x050d615a, "F7D4101 / F9L1101v1 802.11abgn Wireless Adapter [Broadcom BCM4323]" },
    { 0x050d7050, "F5D7050 Wireless G Adapter v1000/v2000 [Intersil ISL3887]" },
    { 0x050d7051, "F5D7051 802.11g Adapter v1000 [Broadcom 4320 USB]" },
    { 0x050d705a, "F5D7050 Wireless G Adapter v3000 [Ralink RT2571W]" },
    { 0x050d705b, "Wireless G Adapter" },
    { 0x050d705c, "F5D7050 Wireless G Adapter v4000 [Zydas ZD1211B]" },
    { 0x050d705e, "F5D7050 Wireless G Adapter v5000 [Realtek RTL8187B]" },
    { 0x050d706a, "2-N-1 7-Port Hub (Upper half)" },
    { 0x050d8053, "F5D8053 N Wireless USB Adapter v1000/v4000 [Ralink RT2870]" },
    { 0x050d805c, "F5D8053 N Wireless Adapter v3000 [Ralink RT2870]" },
    { 0x050d805e, "F5D8053 N Wireless USB Adapter v5000 [Realtek RTL8192U]" },
    { 0x050d815c, "F5D8053 N Wireless USB Adapter v3000 [Ralink RT2870]" },
    { 0x050d815f, "F5D8053 N Wireless USB Adapter v6000 [Realtek RTL8192SU]" },
    { 0x050d825a, "F5D8055 N+ Wireless Adapter v1000 [Ralink RT2870]" },
    { 0x050d825b, "F5D8055 N+ Wireless Adapter v2000 [Ralink RT3072]" },
    { 0x050d845a, "F7D2101 802.11n Surf & Share Wireless Adapter v1000 [Realtek RTL8192SU]" },
    { 0x050d905b, "F5D9050 Wireless G+ MIMO Network Adapter v3000 [Ralink RT2573]" },
    { 0x050d905c, "F5D9050 Wireless G+ MIMO Network Adapter v4000 [Ralink RT2573]" },
    { 0x050d935a, "F6D4050 N150 Enhanced Wireless Network Adapter v1000 [Ralink RT3070]" },
    { 0x050d935b, "F6D4050 N150 Enhanced Wireless Network Adapter v2000 [Ralink RT3070]" },
    { 0x050d945a, "F7D1101 v1 Basic Wireless Adapter [Realtek RTL8188SU]" },
    { 0x050d945b, "F7D1101 v2 Basic Wireless Adapter [Ralink RT3370]" },
    { 0x050dd321, "Dynex DX-NUSB 802.11bgn Wireless Adapter [Broadcom BCM43231]" },
    { 0x050f0001, "Hub" },
    { 0x050f0003, "KC82C160S Hub" },
    { 0x050f0180, "KC-180 IrDA Dongle" },
    { 0x050f0190, "KC2190 USB Host-to-Host cable" },
    { 0x05100001, "Keyboard" },
    { 0x05101000, "Keyboard with PS/2 Mouse Port" },
    { 0x0510e001, "Mouse" },
    { 0x0511002b, "AOC DVB" },
    { 0x05180001, "USB to PS2 Adaptor v1.09" },
    { 0x05180002, "EZ-9900C Keyboard" },
    { 0x05190003, "TSP100ECO/TSP100II" },
    { 0x0519c002, "Xlive Bluetooth XBM-100S MP3 Player" },
    { 0x051aa005, "Smart Display Version 9973" },
    { 0x051c0005, "VFD Module" },
    { 0x051cc001, "eHome Infrared Receiver" },
    { 0x051cc002, "eHome Infrared Receiver" },
    { 0x051d0001, "UPS" },
    { 0x051d0002, "Uninterruptible Power Supply" },
    { 0x051d0003, "UPS" },
    { 0x0525100d, "RFMD Bluetooth Device" },
    { 0x05251080, "NET1080 USB-USB Bridge" },
    { 0x05251200, "SSDC Adapter II" },
    { 0x05251265, "File-backed Storage Gadget" },
    { 0x05253424, "V30x/V4xx fingerprint sensor [Lumidigm]" },
    { 0x0525a0f0, "Cambridge Electronic Devices Power1401 mk 2" },
    { 0x0525a140, "USB Clik! 40" },
    { 0x0525a141, "(OME) PocketZip 40 MP3 Player Driver" },
    { 0x0525a220, "GVC Bluetooth Wireless Adapter" },
    { 0x0525a4a0, "Linux-USB \"Gadget Zero\"" },
    { 0x0525a4a1, "Linux-USB Ethernet Gadget" },
    { 0x0525a4a2, "Linux-USB Ethernet/RNDIS Gadget" },
    { 0x0525a4a3, "Linux-USB user-mode isochronous source/sink" },
    { 0x0525a4a4, "Linux-USB user-mode bulk source/sink" },
    { 0x0525a4a5, "Pocketbook Pro 903 / Mobius 2 Action Cam / xDuoo X3 / PocketBook Pro 602" },
    { 0x0525a4a6, "Linux-USB Serial Gadget" },
    { 0x0525a4a7, "Linux-USB Serial Gadget (CDC ACM mode)" },
    { 0x0525a4a8, "Linux-USB Printer Gadget" },
    { 0x0525a4a9, "Linux-USB OBEX Gadget" },
    { 0x0525a4aa, "Linux-USB CDC Composite Gadge (Ethernet and ACM)" },
    { 0x05287561, "TV Wonder" },
    { 0x05287562, "TV Wonder, Edition (FN5)" },
    { 0x05287563, "TV Wonder, Edition (FI)" },
    { 0x05287564, "TV Wonder, Edition (FQ)" },
    { 0x05287565, "TV Wonder, Edition (NTSC+)" },
    { 0x05287566, "TV Wonder, Edition (FN5)" },
    { 0x05287567, "TV Wonder, Edition (FI)" },
    { 0x05287568, "TV Wonder, Edition (FQ)" },
    { 0x05287569, "Live! Pro (A)" },
    { 0x0528756a, "Live! Pro Audio (O)" },
    { 0x05290001, "HASP copy protection dongle" },
    { 0x0529030b, "eToken R1 v3.1.3.x" },
    { 0x05290313, "eToken R1 v3.2.3.x" },
    { 0x0529031b, "eToken R1 v3.3.3.x" },
    { 0x05290323, "eToken R1 v3.4.3.x" },
    { 0x05290412, "eToken R2 v2.2.4.x" },
    { 0x0529041a, "eToken R2 v2.2.4.x" },
    { 0x05290422, "eToken R2 v2.4.4.x" },
    { 0x0529042a, "eToken R2 v2.5.4.x" },
    { 0x0529050c, "eToken Pro v4.1.5.x" },
    { 0x05290514, "eToken Pro v4.2.5.4" },
    { 0x05290600, "eToken Pro 64k (4.2)" },
    { 0x05290620, "Token JC" },
    { 0x052b0102, "Ca508A HP1020 Camera v.1.3.1.6" },
    { 0x052b0801, "Yakumo MegaImage 37" },
    { 0x052b1512, "Yakumo MegaImage IV" },
    { 0x052b1513, "Aosta CX100 Webcam" },
    { 0x052b1514, "Aosta CX100 Webcam Storage" },
    { 0x052b1905, "Yakumo MegaImage 47" },
    { 0x052b1911, "Yakumo MegaImage 47 SL" },
    { 0x052b2202, "WDM Still Image Capture" },
    { 0x052b2203, "Sound Vision Stream Driver" },
    { 0x052b3a06, "DigiLife DDV-5120A" },
    { 0x052bd001, "P35U Camera Capture" },
    { 0x053601a0, "PDT" },
    { 0x053a0b00, "Hub" },
    { 0x053a0b01, "Preh MCI 3100" },
    { 0x05400101, "Panache Surf ISDN TA" },
    { 0x054300fe, "G773 Monitor Hub" },
    { 0x054300ff, "P815 Monitor Hub" },
    { 0x05430bf2, "airpanel V150 Wireless Smart Display" },
    { 0x05430bf3, "airpanel V110 Wireless Smart Display" },
    { 0x05430ed9, "Color Pocket PC V35" },
    { 0x05430f01, "airsync Wi-Fi Wireless Adapter" },
    { 0x05431527, "Color Pocket PC V36" },
    { 0x05431529, "Color Pocket PC V37" },
    { 0x0543152b, "Color Pocket PC V38" },
    { 0x0543152e, "Pocket PC" },
    { 0x05431921, "Communicator Pocket PC" },
    { 0x05431922, "Smartphone" },
    { 0x05431923, "Pocket PC V30" },
    { 0x05431a11, "Wireless 802.11g Adapter" },
    { 0x05431e60, "TA310 - ATSC/NTSC/PAL Driver(PCM4)" },
    { 0x05434153, "ViewSonic G773 Control (?)" },
    { 0x05457333, "Trution Web Camera" },
    { 0x05458002, "IBM NetCamera" },
    { 0x05458009, "Veo PC Camera" },
    { 0x0545800c, "Veo Stingray" },
    { 0x0545800d, "Veo PC Camera" },
    { 0x05458080, "IBM C-It Webcam" },
    { 0x0545808a, "Veo PC Camera" },
    { 0x0545808b, "Veo Stingray" },
    { 0x0545808d, "Veo PC Camera" },
    { 0x0545810a, "Veo Advanced Connect Webcam" },
    { 0x0545810b, "Veo PC Camera" },
    { 0x0545810c, "Veo PC Camera" },
    { 0x05458135, "Veo Mobile/Advanced Web Camera" },
    { 0x0545813a, "Veo PC Camera" },
    { 0x0545813b, "Veo PC Camera" },
    { 0x0545813c, "Veo Mobile/Advanced Web Camera" },
    { 0x05458333, "Veo Stingray/Connect Web Camera" },
    { 0x0545888c, "eVision 123 digital camera" },
    { 0x0545888d, "eVision 123 digital camera" },
    { 0x05460daf, "PDC 2300Z" },
    { 0x05461bed, "PDC 1320 Camera" },
    { 0x05462035, "Polaroid Freescape/MPU-433158" },
    { 0x05463097, "PDC 310" },
    { 0x05463155, "PDC 3070 Camera" },
    { 0x05463187, "Digital Camera" },
    { 0x05463191, "Ion 80 Camera" },
    { 0x05463273, "PDC 2030 Camera" },
    { 0x05463304, "a500 Digital Camera" },
    { 0x0546dccf, "Sound Vision Stream Driver" },
    { 0x05470001, "ICSI Bluetooth Device" },
    { 0x05470080, "I3SYSTEM HYUNY" },
    { 0x05471002, "Python2 WDM Encoder" },
    { 0x05471006, "Hantek DSO-2100 UF" },
    { 0x05472131, "AN2131 EZUSB Microcontroller" },
    { 0x05472235, "AN2235 EZUSB-FX Microcontroller" },
    { 0x05472710, "EZ-Link Loader (EZLNKLDR.SYS)" },
    { 0x05472720, "AN2720 USB-USB Bridge" },
    { 0x05472727, "Xircom PGUNET USB-USB Bridge" },
    { 0x05472750, "EZ-Link (EZLNKUSB.SYS)" },
    { 0x05472810, "Cypress ATAPI Bridge" },
    { 0x05474018, "AmScope MU1803" },
    { 0x05474d90, "AmScope MD1900 camera" },
    { 0x05476010, "AmScope MU1000 camera" },
    { 0x05476510, "Touptek UCMOS05100KPA" },
    { 0x05477000, "PowerSpec MCE460 Front Panel LED Display" },
    { 0x05477777, "Bluetooth Device" },
    { 0x05479999, "AN2131 uninitialized (?)" },
    { 0x05481005, "EZ Cart II GameBoy Flash Programmer" },
    { 0x054c0001, "HUB" },
    { 0x054c0002, "Standard HUB" },
    { 0x054c0010, "Cyber-shot, Mavica (msc)" },
    { 0x054c0014, "Nogatech USBVision (SY)" },
    { 0x054c0022, "Storage Adapter V2 (TPP)" },
    { 0x054c0023, "CD Writer" },
    { 0x054c0024, "Mavica CD-1000 Camera" },
    { 0x054c0025, "NW-MS7 Walkman MemoryStick Reader" },
    { 0x054c002b, "Portable USB Harddrive V2" },
    { 0x054c002c, "USB Floppy Disk Drive" },
    { 0x054c002d, "MSAC-US1 MemoryStick Reader" },
    { 0x054c002e, "HandyCam MemoryStick Reader" },
    { 0x054c0030, "Storage Adapter V2 (TPP)" },
    { 0x054c0032, "MemoryStick MSC-U01 Reader" },
    { 0x054c0035, "Network Walkman (E)" },
    { 0x054c0036, "Net MD" },
    { 0x054c0037, "MG Memory Stick Reader/Writer" },
    { 0x054c0038, "Clie PEG-S300/D PalmOS PDA" },
    { 0x054c0039, "Network Walkman (MS)" },
    { 0x054c003c, "VAIO-MX LCD Control" },
    { 0x054c0045, "Digital Imaging Video" },
    { 0x054c0046, "Network Walkman" },
    { 0x054c0049, "UP-D895" },
    { 0x054c004a, "Memory Stick Hi-Fi System" },
    { 0x054c004b, "Memory Stick Reader/Writer" },
    { 0x054c004e, "Sony DSC-U10" },
    { 0x054c0056, "MG Memory Stick Reader/Writer" },
    { 0x054c0058, "Clie PEG-N7x0C PalmOS PDA Mass Storage" },
    { 0x054c0066, "Clie PEG-N7x0C/PEG-T425 PalmOS PDA Serial" },
    { 0x054c0067, "CMR-PC3 Webcam" },
    { 0x054c0069, "Memorystick MSC-U03 Reader" },
    { 0x054c006c, "FeliCa S310 [PaSoRi]" },
    { 0x054c006d, "Clie PEG-T425 PDA Mass Storage" },
    { 0x054c006f, "Network Walkman (EV)" },
    { 0x054c0073, "Storage CRX1750U" },
    { 0x054c0075, "Net MD" },
    { 0x054c0076, "Storage Adapter ACR-U20" },
    { 0x054c007c, "Net MD" },
    { 0x054c007f, "IC Recorder (MS)" },
    { 0x054c0080, "Net MD" },
    { 0x054c0081, "Net MD" },
    { 0x054c0084, "Net MD" },
    { 0x054c0085, "Net MD" },
    { 0x054c0086, "Net MD" },
    { 0x054c008b, "Micro Vault 64M Mass Storage" },
    { 0x054c0095, "Clie s360" },
    { 0x054c0099, "Clie NR70 PDA Mass Storage" },
    { 0x054c009a, "Clie NR70 PDA Serial" },
    { 0x054c00ab, "Visual Communication Camera (PCGA-UVC10)" },
    { 0x054c00af, "DPP-EX Series Digital Photo Printer" },
    { 0x054c00bf, "IC Recorder (S)" },
    { 0x054c00c0, "Handycam DCR-30" },
    { 0x054c00c6, "Net MD" },
    { 0x054c00c7, "Net MD" },
    { 0x054c00c8, "MZ-N710 Minidisc Walkman" },
    { 0x054c00c9, "Net MD" },
    { 0x054c00ca, "MZ-DN430 Minidisc Walkman" },
    { 0x054c00cb, "MSAC-US20 Memory Stick Reader" },
    { 0x054c00da, "Clie nx60" },
    { 0x054c00e8, "Network Walkman (MS)" },
    { 0x054c00e9, "Handheld" },
    { 0x054c00eb, "Net MD" },
    { 0x054c0101, "Net MD" },
    { 0x054c0103, "IC Recorder (ST)" },
    { 0x054c0105, "Micro Vault Hub" },
    { 0x054c0107, "VCC-U01 Visual Communication Camera" },
    { 0x054c0110, "Digital Imaging Video" },
    { 0x054c0113, "Net MD" },
    { 0x054c0116, "IC Recorder (P)" },
    { 0x054c0144, "Clie PEG-TH55 PDA" },
    { 0x054c0147, "Visual Communication Camera (PCGA-UVC11)" },
    { 0x054c014c, "Aiwa AM-NX9 Net MD Music Recorder MDLP" },
    { 0x054c014d, "Memory Stick Reader/Writer" },
    { 0x054c0154, "Eyetoy Audio Device" },
    { 0x054c0155, "Eyetoy Video Device" },
    { 0x054c015f, "IC Recorder (BM)" },
    { 0x054c0169, "Clie PEG-TJ35 PDA Serial" },
    { 0x054c016a, "Clie PEG-TJ35 PDA Mass Storage" },
    { 0x054c016b, "Mobile HDD" },
    { 0x054c016d, "IC Recorder (SX)" },
    { 0x054c016e, "DPP-EX50 Digital Photo Printer" },
    { 0x054c0171, "Fingerprint Sensor 3500" },
    { 0x054c017e, "Net MD" },
    { 0x054c017f, "Hi-MD WALKMAN" },
    { 0x054c0180, "Net MD" },
    { 0x054c0181, "Hi-MD WALKMAN" },
    { 0x054c0182, "Net MD" },
    { 0x054c0183, "Hi-MD WALKMAN" },
    { 0x054c0184, "Net MD" },
    { 0x054c0185, "Hi-MD WALKMAN" },
    { 0x054c0186, "Net MD" },
    { 0x054c0187, "Hi-MD MZ-NH600 WALKMAN" },
    { 0x054c0188, "Net MD" },
    { 0x054c018a, "Net MD" },
    { 0x054c018b, "Hi-MD SOUND GATE" },
    { 0x054c019e, "Micro Vault 1.0G Mass Storage" },
    { 0x054c01ad, "ATRAC HDD PA" },
    { 0x054c01bb, "FeliCa S320 [PaSoRi]" },
    { 0x054c01bd, "MRW62E Multi-Card Reader/Writer" },
    { 0x054c01c3, "NW-E55 Network Walkman" },
    { 0x054c01c6, "MEMORY P-AUDIO" },
    { 0x054c01c7, "Printing Support" },
    { 0x054c01c8, "PSP Type A" },
    { 0x054c01c9, "PSP Type B" },
    { 0x054c01d0, "DVD+RW External Drive DRU-700A" },
    { 0x054c01d5, "IC RECORDER" },
    { 0x054c01de, "VRD-VC10 [Video Capture]" },
    { 0x054c01e7, "UP-D897" },
    { 0x054c01e8, "UP-DR150 Photo Printer" },
    { 0x054c01e9, "Net MD" },
    { 0x054c01ea, "Hi-MD WALKMAN" },
    { 0x054c01ee, "IC RECORDER" },
    { 0x054c01fa, "IC Recorder (P)" },
    { 0x054c01fb, "NW-E405 Network Walkman" },
    { 0x054c020f, "Device" },
    { 0x054c0210, "ATRAC HDD PA" },
    { 0x054c0219, "Net MD" },
    { 0x054c021a, "Hi-MD WALKMAN" },
    { 0x054c021b, "Net MD" },
    { 0x054c021c, "Hi-MD WALKMAN" },
    { 0x054c021d, "Net MD" },
    { 0x054c0226, "UP-CR10L" },
    { 0x054c0227, "Printing Support" },
    { 0x054c022c, "Net MD" },
    { 0x054c022d, "Hi-MD AUDIO" },
    { 0x054c0233, "ATRAC HDD PA" },
    { 0x054c0236, "Mobile HDD" },
    { 0x054c023b, "DVD+RW External Drive DRU-800UL" },
    { 0x054c023c, "Net MD" },
    { 0x054c023d, "Hi-MD WALKMAN" },
    { 0x054c0243, "MicroVault Flash Drive" },
    { 0x054c024b, "Vaio VGX Mouse" },
    { 0x054c0257, "IFU-WLM2 USB Wireless LAN Module (Wireless Mode)" },
    { 0x054c0258, "IFU-WLM2 USB Wireless LAN Module (Memory Mode)" },
    { 0x054c0259, "IC RECORDER" },
    { 0x054c0267, "Tachikoma Device" },
    { 0x054c0268, "Batoh Device / PlayStation 3 Controller" },
    { 0x054c0269, "HDD WALKMAN" },
    { 0x054c026a, "HDD WALKMAN" },
    { 0x054c0271, "IC Recorder (P)" },
    { 0x054c027c, "NETWORK WALKMAN" },
    { 0x054c027e, "SONY Communicator" },
    { 0x054c027f, "IC RECORDER" },
    { 0x054c0286, "Net MD" },
    { 0x054c0287, "Hi-MD WALKMAN" },
    { 0x054c0290, "VGP-UVC100 Visual Communication Camera" },
    { 0x054c0296, "Sony DSC-S730" },
    { 0x054c029b, "PRS-500 eBook reader" },
    { 0x054c02a5, "MicroVault Flash Drive" },
    { 0x054c02af, "Handycam DCR-DVD306E" },
    { 0x054c02c0, "Sony DSC-A100" },
    { 0x054c02c4, "Device" },
    { 0x054c02d1, "DVD RW" },
    { 0x054c02d2, "PSP Slim" },
    { 0x054c02d4, "UP-CX1" },
    { 0x054c02d8, "SBAC-US10 SxS PRO memory card reader/writer" },
    { 0x054c02e1, "FeliCa S330 [PaSoRi]" },
    { 0x054c02ea, "PlayStation 3 Memory Card Adaptor" },
    { 0x054c02f8, "Sony DSC-W200" },
    { 0x054c02f9, "DSC-H9" },
    { 0x054c0317, "WALKMAN" },
    { 0x054c031a, "Walkman NWD-B103F" },
    { 0x054c031e, "PRS-300/PRS-505 eBook reader" },
    { 0x054c0325, "Sony Walkman NWZ-A815/NWZ-A818" },
    { 0x054c0326, "Sony Walkman NWZ-S516" },
    { 0x054c0327, "Sony Walkman NWZ-S615F/NWZ-S616F/NWZ-S618F" },
    { 0x054c033e, "DSC-W120/W290" },
    { 0x054c0343, "Sony DSC-W130" },
    { 0x054c0346, "Handycam DCR-SR55E" },
    { 0x054c0348, "HandyCam HDR-TG3E" },
    { 0x054c035a, "Sony Walkman NWZ-S716F" },
    { 0x054c035b, "Sony Walkman NWZ-A826/NWZ-A828/NWZ-A829" },
    { 0x054c035c, "Sony Walkman NWZ-A726/NWZ-A728/NWZ-A768" },
    { 0x054c035f, "UP-DR200 Photo Printer" },
    { 0x054c0360, "M2 Card Reader" },
    { 0x054c036e, "Sony Walkman NWZ-B135" },
    { 0x054c0382, "Memory Stick PRO-HG Duo Adaptor (MSAC-UAH1)" },
    { 0x054c0385, "Sony Walkman NWZ-E436F" },
    { 0x054c0387, "IC Recorder (P)" },
    { 0x054c0388, "Sony Walkman NWZ-W202" },
    { 0x054c038c, "Sony Walkman NWZ-S739F" },
    { 0x054c038e, "Sony Walkman NWZ-S638F" },
    { 0x054c0398, "Sony Walkman NWZ-X1051/NWZ-X1061" },
    { 0x054c03bc, "Webbie HD - MHS-CM1" },
    { 0x054c03c3, "UP-DR80MD" },
    { 0x054c03c4, "Stryker SDP1000" },
    { 0x054c03c5, "UP-DR80" },
    { 0x054c03cc, "SD Card Reader" },
    { 0x054c03d1, "DPF-X95" },
    { 0x054c03d3, "DR-BT100CX" },
    { 0x054c03d5, "PlayStation Move motion controller" },
    { 0x054c03d8, "Sony Walkman NWZ-B142F" },
    { 0x054c03fc, "Sony Walkman NWZ-E344" },
    { 0x054c03fd, "Sony Walkman NWZ-E445" },
    { 0x054c03fe, "Sony Walkman NWZ-S545" },
    { 0x054c0404, "Sony Walkman NWZ-A845" },
    { 0x054c042f, "PlayStation Move navigation controller" },
    { 0x054c0440, "DSC-H55" },
    { 0x054c0485, "MHS-PM5 HD camcorder" },
    { 0x054c04a3, "Sony SLT-A55" },
    { 0x054c04a7, "Sony SLT-A35" },
    { 0x054c04bb, "Sony Walkman NWZ-W252B" },
    { 0x054c04be, "Sony Walkman NWZ-B153F" },
    { 0x054c04cb, "Sony Walkman NWZ-E354" },
    { 0x054c04cc, "Sony Walkman NWZ-S754" },
    { 0x054c04d1, "Sony Sony Tablet P1" },
    { 0x054c052a, "Sony DSC-RX100" },
    { 0x054c052b, "Sony DSC-RX1" },
    { 0x054c0541, "DSC-HX100V [Cybershot Digital Still Camera]" },
    { 0x054c0543, "Sony DSC-HX100V" },
    { 0x054c0574, "Sony SLT-A65V" },
    { 0x054c059a, "Sony NWZ-B163F" },
    { 0x054c05a6, "Sony Walkman NWZ-E464" },
    { 0x054c05a8, "Sony NWZ-S765" },
    { 0x054c05b3, "Sony Sony Tablet S" },
    { 0x054c05b4, "Sony Sony Tablet S1" },
    { 0x054c05c4, "DualShock 4 [CUH-ZCT1x]" },
    { 0x054c061f, "Sony DSC-HX200V" },
    { 0x054c0689, "Walkman NWZ-B173F" },
    { 0x054c06bb, "WALKMAN NWZ-F805" },
    { 0x054c06c3, "RC-S380" },
    { 0x054c07c4, "ILCE-6000 (aka Alpha-6000) in Mass Storage mode" },
    { 0x054c082f, "Walkman NWZW Series" },
    { 0x054c0847, "WG-C10 Portable Wireless Server" },
    { 0x054c0884, "MDR-ZX770BN [Wireless Noise Canceling Stereo Headset]" },
    { 0x054c088c, "Portable Headphone Amplifier" },
    { 0x054c08b7, "ILCE-6000 (aka Alpha-6000) in MTP mode" },
    { 0x054c094e, "ILCE-6000 (aka Alpha-6000) in PC Remote mode" },
    { 0x054c0994, "ILCE-6000 (aka Alpha-6000) in charging mode" },
    { 0x054c09cc, "DualShock 4 [CUH-ZCT2x]" },
    { 0x054c0ba0, "Dualshock4 Wireless Adaptor" },
    { 0x054c0bb5, "Headset MDR-1000X" },
    { 0x054c0c02, "ILCE-7M3 [A7III] in Mass Storage mode" },
    { 0x054c0c03, "ILCE-7M3 [A7III] in MTP mode" },
    { 0x054c0c34, "ILCE-7M3 [A7III] in PC Remote mode" },
    { 0x054c0cd3, "WH-1000XM3 [Wireless Noise-Canceling Headphones]" },
    { 0x054c0cda, "PlayStation Classic controller" },
    { 0x054c1000, "Wireless Buzz! Receiver" },
    { 0x054c1294, "Sony DCR-SR75" },
    { 0x05500002, "InkJet Color Printer" },
    { 0x05500004, "InkJet Color Printer" },
    { 0x05500005, "InkJet Color Printer" },
    { 0x0550000b, "Workcentre 24" },
    { 0x0550014e, "CM215b Printer" },
    { 0x05500165, "DocuPrint M215b" },
    { 0x05530001, "TerraCAM" },
    { 0x05530002, "CPiA Webcam" },
    { 0x05530100, "STV0672 Camera" },
    { 0x05530140, "Video Camera" },
    { 0x05530150, "CDE CAM 100" },
    { 0x05530151, "Digital Blue QX5 Microscope" },
    { 0x05530200, "Dual-mode Camera0" },
    { 0x05530201, "Dual-mode Camera1" },
    { 0x05530202, "STV0680 Camera" },
    { 0x05530674, "Multi-mode Camera" },
    { 0x05530679, "NMS Video Camera (Webcam)" },
    { 0x05531002, "Che-ez! Splash" },
    { 0x05560001, "AK5370 I/F A/D Converter" },
    { 0x05572001, "UC-1284 Printer Port" },
    { 0x05572002, "10Mbps Ethernet [klsi]" },
    { 0x05572004, "UC-100KM PS/2 Mouse and Keyboard adapter" },
    { 0x05572006, "UC-1284B Printer Port" },
    { 0x05572007, "UC-110T 100Mbps Ethernet [pegasus]" },
    { 0x05572008, "UC-232A Serial Port [pl2303]" },
    { 0x05572009, "UC-210T Ethernet" },
    { 0x05572011, "UC-2324 4xSerial Ports [mos7840]" },
    { 0x05572202, "CS124U Miniview II KVM Switch" },
    { 0x05572212, "Keyboard/Mouse" },
    { 0x05572213, "CS682 2-Port USB 2.0 DVI KVM Switch" },
    { 0x05572221, "Winbond Hermon" },
    { 0x05572404, "4-port switch" },
    { 0x05572600, "IDE Bridge" },
    { 0x05572701, "CE700A KVM Extender" },
    { 0x05574000, "DSB-650 10Mbps Ethernet [klsi]" },
    { 0x05577000, "Hub" },
    { 0x05577820, "UC-2322 2xSerial Ports [mos7820]" },
    { 0x05578021, "Hub" },
    { 0x05581009, "GW Instek GDS-1000 Oscilloscope" },
    { 0x0558100a, "GW Instek GDS-1000A Oscilloscope" },
    { 0x05582009, "GW Instek GDS-2000 Oscilloscope" },
    { 0x055d0001, "Keyboard" },
    { 0x055d0bb1, "Bluetooth Device" },
    { 0x055d1030, "Optical Wheel Mouse (OMS3CB/OMGB30)" },
    { 0x055d1031, "Optical Wheel Mouse (OMA3CB/OMGI30)" },
    { 0x055d1040, "Mouse HID Device" },
    { 0x055d1050, "E-Mail Optical Wheel Mouse (OMS3CE)" },
    { 0x055d1080, "Optical Wheel Mouse (OMS3CH)" },
    { 0x055d2020, "Floppy Disk Drive" },
    { 0x055d6780, "Keyboard V1" },
    { 0x055d6781, "Keyboard Mouse" },
    { 0x055d8001, "E.M. Hub" },
    { 0x055d9000, "AnyCam [pwc]" },
    { 0x055d9001, "MPC-C30 AnyCam Premium for Notebooks [pwc]" },
    { 0x055da000, "SWL-2100U" },
    { 0x055da010, "WLAN Adapter(SWL-2300)" },
    { 0x055da011, "Boot Device" },
    { 0x055da012, "WLAN Adapter(SWL-2300)" },
    { 0x055da013, "WLAN Adapter(SWL-2350)" },
    { 0x055da230, "Boot Device" },
    { 0x055db000, "11Mbps WLAN Mini Adapter" },
    { 0x055db230, "Netopia 802.11b WLAN Adapter" },
    { 0x055db231, "LG Wireless LAN 11b Adapter" },
    { 0x055f0001, "ScanExpress 1200 CU" },
    { 0x055f0002, "ScanExpress 600 CU" },
    { 0x055f0003, "ScanExpress 1200 USB" },
    { 0x055f0006, "ScanExpress 1200 UB" },
    { 0x055f0007, "ScanExpress 1200 USB Plus" },
    { 0x055f0008, "ScanExpress 1200 CU Plus" },
    { 0x055f0010, "BearPaw 1200F" },
    { 0x055f0210, "ScanExpress A3 USB" },
    { 0x055f0218, "BearPaw 2400 TA" },
    { 0x055f0219, "BearPaw 2400 TA Plus" },
    { 0x055f021a, "BearPaw 2448 TA Plus" },
    { 0x055f021b, "BearPaw 1200 CU Plus" },
    { 0x055f021c, "BearPaw 1200 CU Plus" },
    { 0x055f021d, "BearPaw 2400 CU Plus" },
    { 0x055f021e, "BearPaw 1200 TA/CS" },
    { 0x055f021f, "SNAPSCAN e22" },
    { 0x055f0400, "BearPaw 2400 TA Pro" },
    { 0x055f0401, "P 3600 A3 Pro" },
    { 0x055f0408, "BearPaw 2448 CU Pro" },
    { 0x055f0409, "BearPaw 2448 TA Pro" },
    { 0x055f040b, "ScanExpress A3 USB 1200 PRO" },
    { 0x055f0501, "ScanExpress A3 2400 Pro" },
    { 0x055f0873, "ScanExpress 600 USB" },
    { 0x055f1000, "BearPaw 4800 TA Pro" },
    { 0x055fa350, "gSmart 350 Camera" },
    { 0x055fa800, "MDC 800 Camera" },
    { 0x055fb500, "MDC 3000 Camera" },
    { 0x055fc005, "PC CAM 300A" },
    { 0x055fc200, "gSmart 300" },
    { 0x055fc211, "Kowa Bs888e Microcamera" },
    { 0x055fc220, "gSmart mini" },
    { 0x055fc230, "Digicam 330K" },
    { 0x055fc232, "MDC3500 Camera" },
    { 0x055fc360, "DV 4000 Camera" },
    { 0x055fc420, "gSmart mini 2 Camera" },
    { 0x055fc430, "gSmart LCD 2 Camera" },
    { 0x055fc440, "DV 3000 Camera" },
    { 0x055fc520, "gSmart mini 3 Camera" },
    { 0x055fc530, "gSmart LCD 2 Camera" },
    { 0x055fc540, "gSmart D30 Camera" },
    { 0x055fc630, "MDC 4000 Camera" },
    { 0x055fc631, "MDC 4000 Camera" },
    { 0x055fc650, "MDC 5500Z Camera" },
    { 0x055fd001, "WCam 300" },
    { 0x055fd003, "WCam 300A" },
    { 0x055fd004, "WCam 300AN" },
    { 0x05620001, "Enhanced Microphone" },
    { 0x05620002, "Telex Microphone" },
    { 0x05650001, "Serial Port [etek]" },
    { 0x05650002, "Enet Ethernet [klsi]" },
    { 0x05650003, "@Home Networks Ethernet [klsi]" },
    { 0x05650005, "Enet2 Ethernet [klsi]" },
    { 0x05650041, "Peracom Remote NDIS Ethernet Adapter" },
    { 0x05660110, "ViewMate Desktop Mouse CC2201" },
    { 0x05661001, "ViewMate Desktop Mouse CC2201" },
    { 0x05661002, "ViewMate Desktop Mouse CC2201" },
    { 0x05661003, "ViewMate Desktop Mouse CC2201" },
    { 0x05661004, "ViewMate Desktop Mouse CC2201" },
    { 0x05661005, "ViewMate Desktop Mouse CC2201" },
    { 0x05661006, "ViewMate Desktop Mouse CC2201" },
    { 0x05661007, "ViewMate Desktop Mouse CC2201" },
    { 0x05662800, "MIC K/B" },
    { 0x05662801, "MIC K/B Mouse" },
    { 0x05662802, "Kbd Hub" },
    { 0x05663002, "Keyboard" },
    { 0x05663004, "Genius KB-29E" },
    { 0x05663013, "BakkerElkhuizen Wired Keyboard S-board 840 Design" },
    { 0x05663020, "BakkerElkhuizen Wired Keyboard S-board 840 Design USB-Hub" },
    { 0x05663027, "Sun-Flex ProTouch" },
    { 0x05663107, "Keyboard" },
    { 0x05663132, "Optical mouse M-DY4DR / M-DY6DR" },
    { 0x05664006, "FID 638 Mouse (Sun Microsystems)" },
    { 0x056a0000, "PenPartner" },
    { 0x056a0001, "PenPartner 4x5" },
    { 0x056a0002, "PenPartner 6x8" },
    { 0x056a0003, "PTU-600 [Cintiq Partner]" },
    { 0x056a0010, "ET-0405 [Graphire]" },
    { 0x056a0011, "ET-0405A [Graphire2 (4x5)]" },
    { 0x056a0012, "ET-0507A [Graphire2 (5x7)]" },
    { 0x056a0013, "CTE-430 [Graphire3 (4x5)]" },
    { 0x056a0014, "CTE-630 [Graphire3 (6x8)]" },
    { 0x056a0015, "CTE-440 [Graphire4 (4x5)]" },
    { 0x056a0016, "CTE-640 [Graphire4 (6x8)]" },
    { 0x056a0017, "CTE-450 [Bamboo Fun (small)]" },
    { 0x056a0018, "CTE-650 [Bamboo Fun (medium)]" },
    { 0x056a0019, "CTE-631 [Bamboo One]" },
    { 0x056a0020, "GD-0405 [Intuos (4x5)]" },
    { 0x056a0021, "GD-0608 [Intuos (6x8)]" },
    { 0x056a0022, "GD-0912 [Intuos (9x12)]" },
    { 0x056a0023, "GD-1212 [Intuos (12x12)]" },
    { 0x056a0024, "GD-1218 [Intuos (12x18)]" },
    { 0x056a0026, "PTH-450 [Intuos5 touch (S)]" },
    { 0x056a0027, "PTH-650 [Intuos5 touch (M)]" },
    { 0x056a0028, "PTH-850 [Intuos5 touch (L)]" },
    { 0x056a0029, "PTK-450 [Intuos5 (S)]" },
    { 0x056a002a, "PTK-650 [Intuos5 (M)]" },
    { 0x056a0030, "PL400" },
    { 0x056a0031, "PL500" },
    { 0x056a0032, "PL600" },
    { 0x056a0033, "PL600SX" },
    { 0x056a0034, "PL550" },
    { 0x056a0035, "PL800" },
    { 0x056a0037, "PL700" },
    { 0x056a0038, "PL510" },
    { 0x056a0039, "DTU-710" },
    { 0x056a003a, "DTI-520" },
    { 0x056a003b, "Integrated Hub" },
    { 0x056a003f, "DTZ-2100 [Cintiq 21UX]" },
    { 0x056a0041, "XD-0405-U [Intuos2 (4x5)]" },
    { 0x056a0042, "XD-0608-U [Intuos2 (6x8)]" },
    { 0x056a0043, "XD-0912-U [Intuos2 (9x12)]" },
    { 0x056a0044, "XD-1212-U [Intuos2 (12x12)]" },
    { 0x056a0045, "XD-1218-U [Intuos2 (12x18)]" },
    { 0x056a0047, "Intuos2 6x8" },
    { 0x056a0057, "DTK-2241" },
    { 0x056a0059, "DTH-2242 tablet" },
    { 0x056a005b, "DTH-2200 [Cintiq 22HD Touch] tablet" },
    { 0x056a005d, "DTH-2242 touchscreen" },
    { 0x056a005e, "DTH-2200 [Cintiq 22HD Touch] touchscreen" },
    { 0x056a0060, "FT-0405 [Volito, PenPartner, PenStation (4x5)]" },
    { 0x056a0061, "FT-0203 [Volito, PenPartner, PenStation (2x3)]" },
    { 0x056a0062, "CTF-420 [Volito2]" },
    { 0x056a0063, "CTF-220 [BizTablet]" },
    { 0x056a0064, "CTF-221 [PenPartner2]" },
    { 0x056a0065, "MTE-450 [Bamboo]" },
    { 0x056a0069, "CTF-430 [Bamboo One]" },
    { 0x056a006a, "CTE-460 [Bamboo One Pen (S)]" },
    { 0x056a006b, "CTE-660 [Bamboo One Pen (M)]" },
    { 0x056a0081, "CTE-630BT [Graphire Wireless (6x8)]" },
    { 0x056a0084, "ACK-40401 [Wireless Accessory Kit]" },
    { 0x056a0090, "TPC90" },
    { 0x056a0093, "TPC93" },
    { 0x056a0097, "TPC97" },
    { 0x056a009a, "TPC9A" },
    { 0x056a00a2, "STU-300B [LCD signature pad]" },
    { 0x056a00b0, "PTZ-430 [Intuos3 (4x5)]" },
    { 0x056a00b1, "PTZ-630 [Intuos3 (6x8)]" },
    { 0x056a00b2, "PTZ-930 [Intuos3 (9x12)]" },
    { 0x056a00b3, "PTZ-1230 [Intuos3 (12x12)]" },
    { 0x056a00b4, "PTZ-1231W [Intuos3 (12x19)]" },
    { 0x056a00b5, "PTZ-631W [Intuos3 (6x11)]" },
    { 0x056a00b7, "PTZ-431W [Intuos3 (4x6)]" },
    { 0x056a00b8, "PTK-440 [Intuos4 (4x6)]" },
    { 0x056a00b9, "PTK-640 [Intuos4 (6x9)]" },
    { 0x056a00ba, "PTK-840 [Intuos4 (8x13)]" },
    { 0x056a00bb, "PTK-1240 [Intuos4 (12x19)]" },
    { 0x056a00c0, "DTF-521" },
    { 0x056a00c4, "DTF-720" },
    { 0x056a00c5, "DTZ-2000W [Cintiq 20WSX]" },
    { 0x056a00c6, "DTZ-1200W [Cintiq 12WX]" },
    { 0x056a00c7, "DTU-1931" },
    { 0x056a00cc, "DTK-2100 [Cintiq 21UX]" },
    { 0x056a00ce, "DTU-2231" },
    { 0x056a00d0, "CTT-460 [Bamboo Touch]" },
    { 0x056a00d1, "CTH-460 [Bamboo Pen & Touch]" },
    { 0x056a00d2, "CTH-461 [Bamboo Fun/Craft/Comic Pen & Touch (S)]" },
    { 0x056a00d3, "CTH-661 [Bamboo Fun/Comic Pen & Touch (M)]" },
    { 0x056a00d4, "CTL-460 [Bamboo Pen (S)]" },
    { 0x056a00d5, "CTL-660 [Bamboo Pen (M)]" },
    { 0x056a00d6, "CTH-460 [Bamboo Pen & Touch]" },
    { 0x056a00d7, "CTH-461 [Bamboo Fun/Craft/Comic Pen & Touch (S)]" },
    { 0x056a00d8, "CTH-661 [Bamboo Fun/Comic Pen & Touch (M)]" },
    { 0x056a00d9, "CTT-460 [Bamboo Touch]" },
    { 0x056a00da, "CTH-461SE [Bamboo Pen & Touch Special Edition (S)]" },
    { 0x056a00db, "CTH-661SE [Bamboo Pen & Touch Special Edition (M)]" },
    { 0x056a00dc, "CTT-470 [Bamboo Touch]" },
    { 0x056a00dd, "CTL-470 [Bamboo Connect]" },
    { 0x056a00de, "CTH-470 [Bamboo Fun Pen & Touch]" },
    { 0x056a00df, "CTH-670 [Bamboo Create/Fun]" },
    { 0x056a00e2, "TPCE2" },
    { 0x056a00e3, "TPCE3" },
    { 0x056a00e5, "TPCE5" },
    { 0x056a00e6, "TPCE6" },
    { 0x056a00ec, "TPCEC" },
    { 0x056a00ed, "TPCED" },
    { 0x056a00ef, "TPCEF" },
    { 0x056a00f0, "DTU-1631" },
    { 0x056a00f4, "DTK-2400 [Cintiq 24HD] tablet" },
    { 0x056a00f6, "DTH-2400 [Cintiq 24HD touch] touchscreen" },
    { 0x056a00f8, "DTH-2400 [Cintiq 24HD touch] tablet" },
    { 0x056a00f9, "DTK-2200 [Cintiq 22HD] hub" },
    { 0x056a00fa, "DTK-2200 [Cintiq 22HD] tablet" },
    { 0x056a00fb, "DTU-1031" },
    { 0x056a0100, "TPC100" },
    { 0x056a0101, "TPC101" },
    { 0x056a010d, "TPC10D" },
    { 0x056a010e, "TPC10E" },
    { 0x056a010f, "TPC10F" },
    { 0x056a0116, "TPC116" },
    { 0x056a012c, "TPC12C" },
    { 0x056a0221, "MDP-123 [Inkling]" },
    { 0x056a0300, "CTL-471 [Bamboo Splash, One by Wacom (S)]" },
    { 0x056a0301, "CTL-671 [One by Wacom (M)]" },
    { 0x056a0302, "CTH-480 [Intuos Pen & Touch (S)]" },
    { 0x056a0303, "CTH-680 [Intuos Pen & Touch (M)]" },
    { 0x056a0304, "DTK-1300 [Cintiq 13HD]" },
    { 0x056a0307, "DTH-A1300 [Cintiq Companion Hybrid] tablet" },
    { 0x056a0309, "DTH-A1300 [Cintiq Companion Hybrid] touchscreen" },
    { 0x056a030e, "CTL-480 [Intuos Pen (S)]" },
    { 0x056a0314, "PTH-451 [Intuos pro (S)]" },
    { 0x056a0315, "PTH-651 [Intuos pro (M)]" },
    { 0x056a0317, "PTH-851 [Intuos pro (L)]" },
    { 0x056a0318, "CTH-301 [Bamboo]" },
    { 0x056a0319, "CTH-300 [Bamboo Pad wireless]" },
    { 0x056a0323, "CTL-680 [Intuos Pen (M)]" },
    { 0x056a032a, "DTK-2700 [Cintiq 27QHD]" },
    { 0x056a032b, "DTH-2700 [Cintiq 27QHD touch] tablet" },
    { 0x056a032c, "DTH-2700 [Cintiq 27QHD touch] touchscreen" },
    { 0x056a032f, "DTU-1031X" },
    { 0x056a0331, "ACK-411050 [ExpressKey Remote]" },
    { 0x056a0333, "DTH-1300 [Cintiq 13HD Touch] tablet" },
    { 0x056a0335, "DTH-1300 [Cintiq 13HD Touch] touchscreen" },
    { 0x056a0336, "DTU-1141" },
    { 0x056a033b, "CTL-490 [Intuos Draw (S)]" },
    { 0x056a033c, "CTH-490 [Intuos Art/Photo/Comic (S)]" },
    { 0x056a033d, "CTL-690 [Intuos Draw (M)]" },
    { 0x056a033e, "CTH-690 [Intuos Art (M)]" },
    { 0x056a0343, "DTK-1651" },
    { 0x056a0347, "DTH-W1620 [MobileStudio Pro 16] internal hub" },
    { 0x056a0348, "DTH-W1620 [MobileStudio Pro 16] external hub" },
    { 0x056a034a, "DTH-W1320 [MobileStudio Pro 13] touchscreen" },
    { 0x056a034b, "DTH-W1620 [MobileStudio Pro 16] touchscreen" },
    { 0x056a034d, "DTH-W1320 [MobileStudio Pro 13] tablet" },
    { 0x056a034e, "DTH-W1620 [MobileStudio Pro 16] tablet" },
    { 0x056a034f, "DTH-1320 [Cintiq Pro 13] tablet" },
    { 0x056a0350, "DTH-1620 [Cintiq Pro 16] tablet" },
    { 0x056a0351, "DTH-2420 [Cintiq Pro 24 PT] tablet" },
    { 0x056a0352, "DTH-3220 [Cintiq Pro 32] tablet" },
    { 0x056a0353, "DTH-1320 [Cintiq Pro 13] touchscreen" },
    { 0x056a0354, "DTH-1620 [Cintiq Pro 16] touchscreen" },
    { 0x056a0355, "DTH-2420 [Cintiq Pro 24 PT] touchscreen" },
    { 0x056a0356, "DTH-3220 [Cintiq Pro 32] touchscreen" },
    { 0x056a0357, "PTH-660 [Intuos Pro (M)]" },
    { 0x056a0358, "PTH-860 [Intuos Pro (L)]" },
    { 0x056a0359, "DTU-1141B" },
    { 0x056a035a, "DTH-1152 tablet" },
    { 0x056a0368, "DTH-1152 touchscreen" },
    { 0x056a0374, "CTL-4100 [Intuos (S)]" },
    { 0x056a0375, "CTL-6100 [Intuos (M)]" },
    { 0x056a0376, "CTL-4100WL [Intuos BT (S)]" },
    { 0x056a0378, "CTL-6100WL [Intuos BT (M)]" },
    { 0x056a037a, "CTL-472 [One by Wacom (S)]" },
    { 0x056a037b, "CTL-672 [One by Wacom (M)]" },
    { 0x056a037c, "DTK-2420 [Cintiq Pro 24 P]" },
    { 0x056a037d, "DTH-2452 tablet" },
    { 0x056a037e, "DTH-2452 touchscreen" },
    { 0x056a0382, "DTK-2451 tablet" },
    { 0x056a038a, "DTH-3220 [Cintiq Pro 32] internal hub" },
    { 0x056a038d, "DTH-3220 [Cintiq Pro 32] internal hub" },
    { 0x056a038e, "DTH-3220 [Cintiq Pro 32] external hub" },
    { 0x056a038f, "DTH-3220 [Cintiq Pro 32] internal hub" },
    { 0x056a0390, "DTK-1660 [Cintiq 16]" },
    { 0x056a0392, "PTH-460 [Intuos Pro (S)]" },
    { 0x056a0396, "DTK-1660E" },
    { 0x056a0398, "DTH-W1320 [MobileStudio Pro 13] tablet" },
    { 0x056a0399, "DTH-W1620 [MobileStudio Pro 16] tablet" },
    { 0x056a039a, "DTH-W1320 [MobileStudio Pro 13] touchscreen" },
    { 0x056a039b, "DTH-W1620 [MobileStudio Pro 16] touchscreen" },
    { 0x056a039c, "DTH-W1320 [MobileStudio Pro 16] external hub" },
    { 0x056a039d, "DTH-W1320 [MobileStudio Pro 16] internal hub" },
    { 0x056a03aa, "DTH-W1620 [MobileStudio Pro 16] tablet" },
    { 0x056a03ac, "DTH-W1620 [MobileStudio Pro 16] touchscreen" },
    { 0x056a0400, "PenPartner 4x5" },
    { 0x056a4001, "TPC4001" },
    { 0x056a4004, "TPC4004" },
    { 0x056a4850, "PenPartner 6x8" },
    { 0x056a5000, "TPC5000" },
    { 0x056a5002, "TPC5002" },
    { 0x056a5010, "TPC5010" },
    { 0x056c0006, "KwikLink Host-Host Connector" },
    { 0x056c8007, "Kwik232 Serial Port" },
    { 0x056c8100, "KwikLink Host-Host Connector" },
    { 0x056c8101, "KwikLink USB-USB Bridge" },
    { 0x056d0000, "Hub" },
    { 0x056d0001, "Monitor" },
    { 0x056d0002, "HID Monitor Controls" },
    { 0x056d0003, "Device Bay Controller" },
    { 0x056d4001, "Monitor" },
    { 0x056e0002, "29UO Mouse" },
    { 0x056e0057, "Micro Grast Pop M-PGDL" },
    { 0x056e005c, "Micro Grast Pop M-PG2DL" },
    { 0x056e005d, "Micro Grast Fit M-FGDL" },
    { 0x056e005e, "Micro Grast Fit M-FG2DL" },
    { 0x056e0062, "Optical mouse M-D18DR" },
    { 0x056e0063, "Laser mouse M-SODL" },
    { 0x056e0069, "Laser mouse M-GE1UL" },
    { 0x056e0071, "Laser mouse M-GE3DL" },
    { 0x056e0072, "Laser mouse M-LS6UL" },
    { 0x056e0073, "Laser mouse M-LS7UL" },
    { 0x056e0074, "Optical mouse M-FW1UL" },
    { 0x056e0075, "Laser mouse M-FW2DL" },
    { 0x056e0077, "Laser mouse M-LY2UL" },
    { 0x056e0079, "Laser mouse M-D21DL" },
    { 0x056e007b, "Laser mouse M-D20DR" },
    { 0x056e007c, "Laser Bluetooth mouse M-BT5BL" },
    { 0x056e007e, "Option mouse M-M8UR" },
    { 0x056e007f, "Option mouse M-M9UR" },
    { 0x056e0081, "Option mouse M-DY6DR" },
    { 0x056e0082, "Laser mouse M-D22DR" },
    { 0x056e0088, "Micro Grast2 Bit M-BG3DL" },
    { 0x056e0089, "Micro Grast2 Pop M-PG3DL" },
    { 0x056e008c, "M-NE3DL Mouse" },
    { 0x056e008d, "ORIME M-NE4DR" },
    { 0x056e008f, "M-BT8BL Bluetooth Mouse" },
    { 0x056e0092, "Wireless BlueLED Mouse (M-BL2DB)" },
    { 0x056e009c, "IR Mouse M-IR02DR" },
    { 0x056e009d, "IR Mouse M-IR03DR" },
    { 0x056e009f, "BlueLED Mouse M-HS1DB" },
    { 0x056e00a1, "IR Mouse M-IR05DR" },
    { 0x056e00a4, "Blue LED Mouse M-BL06DB" },
    { 0x056e00a5, "M-NV1BR Bluetooth Mouse" },
    { 0x056e00a7, "Blue LED Mouse M-BL08DB" },
    { 0x056e00a8, "M-BL09DB Mouse" },
    { 0x056e00a9, "M-BL10UB Mouse" },
    { 0x056e00aa, "M-BL11DB Mouse" },
    { 0x056e00ac, "M-A-BL01UL / M-BL15DB Mouse" },
    { 0x056e00b4, "Track on Glass Mouse M-TG02DL" },
    { 0x056e00b5, "Track on Glass Mouse M-TG03UL" },
    { 0x056e00b6, "Track on Glass Mouse M-TG04DL" },
    { 0x056e00b8, "M-A-BL01UL or M-ASKL2 Mouse" },
    { 0x056e00b9, "M-A-BL02DB or M-ASKL Mouse" },
    { 0x056e00cb, "M-BL21DB Mouse" },
    { 0x056e00cd, "M-XG1UB Mouse" },
    { 0x056e00ce, "M-XG1DB Mouse" },
    { 0x056e00cf, "M-XG1BB Bluetooth Mouse" },
    { 0x056e00d0, "M-XG2UB Mouse" },
    { 0x056e00d1, "M-XG2DB Mouse" },
    { 0x056e00d2, "M-XG2BB Bluetooth Mouse" },
    { 0x056e00d3, "M-XG3DL Mouse" },
    { 0x056e00d4, "M-LS11DL Mouse" },
    { 0x056e00da, "M-XG4UB Mouse" },
    { 0x056e00db, "M-XG4DB Mouse" },
    { 0x056e00dc, "M-XG4BB Bluetooth Mouse" },
    { 0x056e00dd, "M-LS12UL Mouse" },
    { 0x056e00de, "M-LS13UL Mouse" },
    { 0x056e00df, "M-BL22DB Mouse" },
    { 0x056e00e1, "M-WK01DB or M-A-BL04DB" },
    { 0x056e00e2, "M-A-BL03DB" },
    { 0x056e00e3, "M-XGx10UB" },
    { 0x056e00e4, "M-XGx10DB" },
    { 0x056e00e5, "M-XGx10BB" },
    { 0x056e00e6, "M-XGx20DL or M-XGx20DB UltimateLaser Mouse" },
    { 0x056e00f1, "M-XT1DRBK USB EX-G Wireless Optical TrackBall" },
    { 0x056e00f2, "M-XT1URBK EX-G Optical Trackball" },
    { 0x056e00f3, "M-BL23DB" },
    { 0x056e00f4, "M-BT13BL LBT-UAN05C2" },
    { 0x056e00f7, "M-KN1DB" },
    { 0x056e00f8, "M-BL22DB Mouse (other version)" },
    { 0x056e00f9, "M-XT2URBK EX-G Optical TrackBall" },
    { 0x056e00fa, "M-XT2DRBK EX-G Wireless Optical TrackBall" },
    { 0x056e00fb, "M-XT3URBK EX-G Optical TrackBall" },
    { 0x056e00fc, "M-XT3DRBK EX-G Wireless Optical TrackBall" },
    { 0x056e00fd, "M-XT4DRBK EX-G Wireless Optical TrackBall" },
    { 0x056e00fe, "M-DT1URBK or M-DT2URBK DEFT Optical TrackBall" },
    { 0x056e00ff, "M-DT1DRBK or M-DT2DRBK DEFT Wireless Optical Mouse" },
    { 0x056e0101, "M-BL25UBS" },
    { 0x056e0103, "M-BT16BBS" },
    { 0x056e0104, "M-BL26UBC" },
    { 0x056e0105, "M-BL26DBC" },
    { 0x056e0107, "M-LS15UL" },
    { 0x056e0108, "M-LS15DL" },
    { 0x056e0109, "M-LS16UL Mouse" },
    { 0x056e010a, "M-LS16DL / M-KN2DLS" },
    { 0x056e010b, "M-BL21DB Mouse" },
    { 0x056e010c, "M-HT1URBK HUGE Optical TrackBall" },
    { 0x056e010d, "M-HT1DRBK HUGE Wireless Optical TrackBall" },
    { 0x056e010e, "M-KS1DBS / M-FPG3DBS" },
    { 0x056e010f, "M-FBG3DB" },
    { 0x056e0115, "M-BT13BL" },
    { 0x056e0121, "M-ED01DB" },
    { 0x056e0122, "M-NK01DB" },
    { 0x056e0124, "Dual connect Mouse M-DC01MB Bluetooth" },
    { 0x056e0128, "TrackBall Mouse M-XPT1MR Wired" },
    { 0x056e0129, "TrackBall Mouse M-XPT1MR Wireless" },
    { 0x056e0130, "TrackBall Mouse M-XPT1MR Bluetooth" },
    { 0x056e0131, "TrackBall Mouse M-DPT1MR Wired" },
    { 0x056e0132, "TrackBall Mouse M-DPT1MR Wireless" },
    { 0x056e0133, "TrackBall Mouse M-DPT1MR Bluetooth" },
    { 0x056e0136, "M-BT20BB" },
    { 0x056e0137, "BlueTooth 4.0 Mouse M-BT21BB" },
    { 0x056e0138, "M-A-BL07DB" },
    { 0x056e0140, "M-G01UR" },
    { 0x056e0141, "M-Y9UB" },
    { 0x056e0142, "M-DY13DB" },
    { 0x056e0144, "M-FBL01DB" },
    { 0x056e1055, "TK-DCP03 WIRED" },
    { 0x056e1057, "TK-DCP03 BT" },
    { 0x056e2003, "JC-U3613M" },
    { 0x056e2004, "JC-U3613M" },
    { 0x056e200c, "LD-USB/TX" },
    { 0x056e200f, "JC-U4013S Gamepad" },
    { 0x056e2012, "JC-U4013S Gamepad" },
    { 0x056e4002, "Laneed 100Mbps Ethernet LD-USB/TX [pegasus]" },
    { 0x056e4005, "LD-USBL/TX" },
    { 0x056e400b, "LD-USB/TX" },
    { 0x056e4010, "LD-USB20" },
    { 0x056e5003, "UC-SGT" },
    { 0x056e5004, "UC-SGT" },
    { 0x056e6008, "Flash Disk" },
    { 0x056eabc1, "LD-USB/TX" },
    { 0x056fcd00, "CDM-751 CD organizer" },
    { 0x05710002, "echoFX InterView Lite" },
    { 0x05720001, "Ezcam II Webcam" },
    { 0x05720002, "Ezcam II Webcam" },
    { 0x05720040, "Wondereye CP-115 Webcam" },
    { 0x05720041, "Webcam Notebook" },
    { 0x05720042, "Webcam Notebook" },
    { 0x05720320, "DVBSky T330 DVB-T2/C tuner" },
    { 0x05721232, "V.90 modem" },
    { 0x05721234, "Typhoon Redfun Modem V90 56k" },
    { 0x05721252, "HCF V90 Data Fax Voice Modem" },
    { 0x05721253, "Zoom V.92 Faxmodem" },
    { 0x05721300, "SoftK56 Data Fax Voice CARP" },
    { 0x05721301, "Modem Enumerator" },
    { 0x05721328, "TrendNet TFM-561 modem" },
    { 0x05721804, "HP Dock Audio" },
    { 0x05722000, "SoftGate 802.11 Adapter" },
    { 0x05722002, "SoftGate 802.11 Adapter" },
    { 0x0572262a, "tm5600 Video & Audio Grabber Capture" },
    { 0x0572680c, "DVBSky T680C DVB-T2/C tuner" },
    { 0x05726831, "DVBSky S960 DVB-S2 tuner" },
    { 0x05728390, "WinFast PalmTop/Novo TV Video" },
    { 0x05728392, "WinFast PalmTop/Novo TV Video" },
    { 0x0572960c, "DVBSky S960C DVB-S2 tuner" },
    { 0x0572c686, "Geniatech T220A DVB-T2 TV Stick" },
    { 0x0572c688, "Geniatech T230 DVB-T2 TV Stick" },
    { 0x0572cafc, "CX861xx ROM Boot Loader" },
    { 0x0572cafd, "CX82310 ROM Boot Loader" },
    { 0x0572cafe, "AccessRunner ADSL Modem" },
    { 0x0572cb00, "ADSL Modem" },
    { 0x0572cb01, "ADSL Modem" },
    { 0x0572cb06, "StarModem Network Interface" },
    { 0x05730003, "USBGear USBG-V1" },
    { 0x05730400, "D-Link V100" },
    { 0x05730600, "Dazzle USBVision (1006)" },
    { 0x05731300, "leadtek USBVision (1006)" },
    { 0x05732000, "X10 va10a Wireless Camera" },
    { 0x05732001, "Dazzle EmMe (2001)" },
    { 0x05732101, "Zoran Co. PMD (Nogatech) AV-grabber Manhattan" },
    { 0x05732d00, "Osprey 50" },
    { 0x05732d01, "Hauppauge USB-Live Model 600" },
    { 0x05733000, "Dazzle MicroCam (NTSC)" },
    { 0x05733001, "Dazzle MicroCam (PAL)" },
    { 0x05734000, "Nogatech TV! (NTSC)" },
    { 0x05734001, "Nogatech TV! (PAL)" },
    { 0x05734002, "Nogatech TV! (PAL-I-)" },
    { 0x05734003, "Nogatech TV! (MF-)" },
    { 0x05734008, "Nogatech TV! (NTSC) (T)" },
    { 0x05734009, "Nogatech TV! (PAL) (T)" },
    { 0x05734010, "Nogatech TV! (NTSC) (A)" },
    { 0x05734100, "USB-TV FM (NTSC)" },
    { 0x05734110, "PNY USB-TV (NTSC) FM" },
    { 0x05734400, "Nogatech TV! Pro (NTSC)" },
    { 0x05734401, "Nogatech TV! Pro (PAL)" },
    { 0x05734450, "PixelView PlayTv-USB PRO (PAL) FM" },
    { 0x05734451, "Nogatech TV! Pro (PAL+)" },
    { 0x05734452, "Nogatech TV! Pro (PAL-I+)" },
    { 0x05734500, "Nogatech TV! Pro (NTSC)" },
    { 0x05734501, "Nogatech TV! Pro (PAL)" },
    { 0x05734550, "ZTV ZT-721 2.4GHz A/V Receiver" },
    { 0x05734551, "Dazzle TV! Pro Audio (P+)" },
    { 0x05734d00, "Hauppauge WinTV-USB USA" },
    { 0x05734d01, "Hauppauge WinTV-USB" },
    { 0x05734d02, "Hauppauge WinTV-USB UK" },
    { 0x05734d03, "Hauppauge WinTV-USB France" },
    { 0x05734d04, "Hauppauge WinTV (PAL D/K)" },
    { 0x05734d10, "Hauppauge WinTV-USB with FM USA radio" },
    { 0x05734d11, "Hauppauge WinTV-USB (PAL) with FM radio" },
    { 0x05734d12, "Hauppauge WinTV-USB UK with FM Radio" },
    { 0x05734d14, "Hauppauge WinTV (PAL D/K FM)" },
    { 0x05734d20, "Hauppauge WinTV-USB II (PAL) with FM radio" },
    { 0x05734d21, "Hauppauge WinTV-USB II (PAL)" },
    { 0x05734d22, "Hauppauge WinTV-USB II (PAL) Model 566" },
    { 0x05734d23, "Hauppauge WinTV-USB France 4D23" },
    { 0x05734d24, "Hauppauge WinTV Pro (PAL D/K)" },
    { 0x05734d25, "Hauppauge WinTV-USB Model 40209 rev B234" },
    { 0x05734d26, "Hauppauge WinTV-USB Model 40209 rev B243" },
    { 0x05734d27, "Hauppauge WinTV-USB Model 40204 Rev B281" },
    { 0x05734d28, "Hauppauge WinTV-USB Model 40204 rev B283" },
    { 0x05734d29, "Hauppauge WinTV-USB Model 40205 rev B298" },
    { 0x05734d2a, "Hauppague WinTV-USB Model 602 Rev B285" },
    { 0x05734d2b, "Hauppague WinTV-USB Model 602 Rev B282" },
    { 0x05734d2c, "Hauppauge WinTV Pro (PAL/SECAM)" },
    { 0x05734d30, "Hauppauge WinTV-USB FM Model 40211 Rev B123" },
    { 0x05734d31, "Hauppauge WinTV-USB III (PAL) with FM radio Model 568" },
    { 0x05734d32, "Hauppauge WinTV-USB III (PAL) FM Model 573" },
    { 0x05734d34, "Hauppauge WinTV Pro (PAL D/K FM)" },
    { 0x05734d35, "Hauppauge WinTV-USB III (PAL) FM Model 597" },
    { 0x05734d36, "Hauppauge WinTV Pro (PAL B/G FM)" },
    { 0x05734d37, "Hauppauge WinTV-USB Model 40219 rev E189" },
    { 0x05734d38, "Hauppauge WinTV Pro (NTSC FM)" },
    { 0x057b0000, "FlashBuster-U Floppy" },
    { 0x057b0001, "Tri-Media Reader Floppy" },
    { 0x057b0006, "Tri-Media Reader Card Reader" },
    { 0x057b0010, "Memory Stick Reader Writer" },
    { 0x057b0020, "HEXA Media Drive 6-in-1 Card Reader Writer" },
    { 0x057b0030, "Memory Card Viewer (TV)" },
    { 0x057c0b00, "ISDN-Controller B1 Family" },
    { 0x057c0c00, "ISDN-Controller FRITZ!Card" },
    { 0x057c1000, "ISDN-Controller FRITZ!Card v2.0" },
    { 0x057c1900, "ISDN-Controller FRITZ!Card v2.1" },
    { 0x057c2000, "ISDN-Connector FRITZ!X" },
    { 0x057c2200, "BlueFRITZ!" },
    { 0x057c2300, "Teledat X130 DSL" },
    { 0x057c2800, "Teledat 2a/b / X120 / NetXXL ISDN Terminal Adapter" },
    { 0x057c3200, "Teledat X130 DSL" },
    { 0x057c3500, "FRITZ!Card DSL SL" },
    { 0x057c3701, "FRITZ!Box SL" },
    { 0x057c3702, "FRITZ!Box" },
    { 0x057c3800, "BlueFRITZ! Bluetooth Stick" },
    { 0x057c3a00, "FRITZ!Box Fon" },
    { 0x057c3c00, "FRITZ!Box WLAN" },
    { 0x057c3d00, "FRITZ!Box Fon WLAN 7050/7140/7170/IAD3331" },
    { 0x057c3e01, "FRITZ!Box (Annex A)" },
    { 0x057c4001, "FRITZ!Box Fon (Annex A)" },
    { 0x057c4101, "FRITZ!Box WLAN (Annex A)" },
    { 0x057c4201, "FRITZ!Box Fon WLAN (Annex A)" },
    { 0x057c4601, "Eumex 5520PC (WinXP/2000)" },
    { 0x057c4602, "Eumex 400 (WinXP/2000)" },
    { 0x057c4701, "AVM FRITZ!Box Fon ata" },
    { 0x057c5401, "Eumex 300 IP" },
    { 0x057c5601, "AVM Fritz!WLAN [Texas Instruments TNETW1450]" },
    { 0x057c6201, "AVM Fritz!WLAN v1.1 [Texas Instruments TNETW1450]" },
    { 0x057c62ff, "AVM Fritz!WLAN USB (in CD-ROM-mode)" },
    { 0x057c8401, "Fritz!WLAN N [Atheros AR9001U]" },
    { 0x057c8402, "Fritz!WLAN N 2.4 [Atheros AR9001U]" },
    { 0x057c8403, "Fritz!WLAN N v2 [Atheros AR9271]" },
    { 0x057c84ff, "AVM Fritz!WLAN USB N (in CD-ROM-mode)" },
    { 0x057c8501, "FRITZ WLAN N v2 [RT5572/rt2870.bin]" },
    { 0x057e0300, "USB-EXI Adapter (GCP-2000)" },
    { 0x057e0304, "RVT-H Reader" },
    { 0x057e0305, "Broadcom BCM2045A Bluetooth Radio [Nintendo Wii]" },
    { 0x057e0306, "Wii Remote Controller RVL-003" },
    { 0x057e0337, "Wii U GameCube Controller Adapter" },
    { 0x057e2000, "Switch" },
    { 0x057e2006, "Joy-Con L" },
    { 0x057e2007, "Joy-Con R" },
    { 0x057e2009, "Switch Pro Controller" },
    { 0x057e200e, "Joy-Con Charging Grip" },
    { 0x057e3000, "SDK Debugger" },
    { 0x057f6238, "USB StrikePad" },
    { 0x05810107, "Tera Barcode Scanner 2.4 GHz Receiver" },
    { 0x0581020c, "Tera 2D Barcode Scanner EVHK0012" },
    { 0x05820000, "UA-100(G)" },
    { 0x05820002, "UM-4/MPU-64 MIDI Interface" },
    { 0x05820003, "SoundCanvas SC-8850" },
    { 0x05820004, "U-8" },
    { 0x05820005, "UM-2(C/EX)" },
    { 0x05820007, "SoundCanvas SC-8820" },
    { 0x05820008, "PC-300" },
    { 0x05820009, "UM-1(E/S/X)" },
    { 0x0582000b, "SK-500" },
    { 0x0582000c, "SC-D70" },
    { 0x05820010, "EDIROL UA-5" },
    { 0x05820011, "Edirol UA-5 Sound Capture" },
    { 0x05820012, "XV-5050" },
    { 0x05820013, "XV-5050" },
    { 0x05820014, "EDIROL UM-880 MIDI I/F (native)" },
    { 0x05820015, "EDIROL UM-880 MIDI I/F (generic)" },
    { 0x05820016, "EDIROL SD-90" },
    { 0x05820017, "EDIROL SD-90" },
    { 0x05820018, "UA-1A" },
    { 0x0582001b, "MMP-2" },
    { 0x0582001c, "MMP-2" },
    { 0x0582001d, "V-SYNTH" },
    { 0x0582001e, "V-SYNTH" },
    { 0x05820023, "EDIROL UM-550" },
    { 0x05820024, "EDIROL UM-550" },
    { 0x05820025, "EDIROL UA-20" },
    { 0x05820026, "EDIROL UA-20" },
    { 0x05820027, "EDIROL SD-20" },
    { 0x05820028, "EDIROL SD-20" },
    { 0x05820029, "EDIROL SD-80" },
    { 0x0582002a, "EDIROL SD-80" },
    { 0x0582002b, "EDIROL UA-700" },
    { 0x0582002c, "EDIROL UA-700" },
    { 0x0582002d, "XV-2020 Synthesizer" },
    { 0x0582002e, "XV-2020 Synthesizer" },
    { 0x0582002f, "VariOS" },
    { 0x05820030, "VariOS" },
    { 0x05820033, "EDIROL PCR" },
    { 0x05820034, "EDIROL PCR" },
    { 0x05820035, "M-1000" },
    { 0x05820037, "Digital Piano" },
    { 0x05820038, "Digital Piano" },
    { 0x0582003b, "BOSS GS-10" },
    { 0x0582003c, "BOSS GS-10" },
    { 0x05820040, "GI-20" },
    { 0x05820041, "GI-20" },
    { 0x05820042, "RS-70" },
    { 0x05820043, "RS-70" },
    { 0x05820044, "EDIROL UA-1000" },
    { 0x05820047, "EDIROL UR-80 WAVE" },
    { 0x05820048, "EDIROL UR-80 MIDI" },
    { 0x05820049, "EDIROL UR-80 WAVE" },
    { 0x0582004a, "EDIROL UR-80 MIDI" },
    { 0x0582004b, "EDIROL M-100FX" },
    { 0x0582004c, "EDIROL PCR-A WAVE" },
    { 0x0582004d, "EDIROL PCR-A MIDI" },
    { 0x0582004e, "EDIROL PCR-A WAVE" },
    { 0x0582004f, "EDIROL PCR-A MIDI" },
    { 0x05820050, "EDIROL UA-3FX" },
    { 0x05820052, "EDIROL UM-1SX" },
    { 0x05820054, "Digital Piano" },
    { 0x05820060, "EXR Series" },
    { 0x05820064, "EDIROL PCR-1 WAVE" },
    { 0x05820065, "EDIROL PCR-1 MIDI" },
    { 0x05820066, "EDIROL PCR-1 WAVE" },
    { 0x05820067, "EDIROL PCR-1 MIDI" },
    { 0x0582006a, "SP-606" },
    { 0x0582006b, "SP-606" },
    { 0x0582006d, "FANTOM-X" },
    { 0x0582006e, "FANTOM-X" },
    { 0x05820073, "EDIROL UA-25" },
    { 0x05820074, "EDIROL UA-25" },
    { 0x05820075, "BOSS DR-880" },
    { 0x05820076, "BOSS DR-880" },
    { 0x0582007a, "RD" },
    { 0x0582007b, "RD" },
    { 0x0582007d, "EDIROL UA-101" },
    { 0x05820080, "G-70" },
    { 0x05820081, "G-70" },
    { 0x05820084, "V-SYNTH XT" },
    { 0x05820089, "BOSS GT-PRO" },
    { 0x0582008b, "EDIROL PC-50" },
    { 0x0582008c, "EDIROL PC-50" },
    { 0x0582008d, "EDIROL UA-101 USB1" },
    { 0x05820092, "EDIROL PC-80 WAVE" },
    { 0x05820093, "EDIROL PC-80 MIDI" },
    { 0x05820096, "EDIROL UA-1EX" },
    { 0x0582009a, "EDIROL UM-3EX" },
    { 0x0582009d, "EDIROL UM-1" },
    { 0x058200a0, "MD-P1" },
    { 0x058200a2, "Digital Piano" },
    { 0x058200a3, "EDIROL UA-4FX" },
    { 0x058200a6, "Juno-G" },
    { 0x058200a9, "MC-808" },
    { 0x058200ad, "SH-201" },
    { 0x058200b2, "VG-99" },
    { 0x058200b3, "VG-99" },
    { 0x058200b7, "BK-7m/VIMA JM-5/8" },
    { 0x058200c2, "SonicCell" },
    { 0x058200c4, "EDIROL M-16DX" },
    { 0x058200c5, "SP-555" },
    { 0x058200c7, "V-Synth GT" },
    { 0x058200d1, "Music Atelier" },
    { 0x058200d3, "M-380/400" },
    { 0x058200da, "BOSS GT-10" },
    { 0x058200db, "BOSS GT-10 Guitar Effects Processor" },
    { 0x058200dc, "BOSS GT-10B" },
    { 0x058200de, "Fantom G" },
    { 0x058200e6, "EDIROL UA-25EX (Advanced mode)" },
    { 0x058200e7, "EDIROL UA-25EX" },
    { 0x058200e9, "UA-1G" },
    { 0x058200eb, "VS-100" },
    { 0x058200f6, "GW-8/AX-Synth" },
    { 0x058200f8, "JUNO Series" },
    { 0x058200fc, "VS-700C" },
    { 0x058200fd, "VS-700" },
    { 0x058200fe, "VS-700 M1" },
    { 0x058200ff, "VS-700 M2" },
    { 0x05820100, "VS-700" },
    { 0x05820101, "VS-700 M2" },
    { 0x05820102, "VB-99" },
    { 0x05820104, "UM-1G" },
    { 0x05820106, "UM-2G" },
    { 0x05820108, "UM-3G" },
    { 0x05820109, "eBand JS-8" },
    { 0x0582010d, "A-500S" },
    { 0x0582010f, "A-PRO" },
    { 0x05820110, "A-PRO" },
    { 0x05820111, "GAIA SH-01" },
    { 0x05820113, "ME-25" },
    { 0x05820114, "SD-50" },
    { 0x05820116, "WAVE/MP3 RECORDER R-05" },
    { 0x05820117, "VS-20" },
    { 0x05820119, "OCTAPAD SPD-30" },
    { 0x0582011c, "Lucina AX-09" },
    { 0x0582011e, "BR-800" },
    { 0x05820120, "OCTA-CAPTURE" },
    { 0x05820121, "OCTA-CAPTURE" },
    { 0x05820123, "JUNO-Gi" },
    { 0x05820124, "M-300" },
    { 0x05820127, "GR-55" },
    { 0x0582012a, "UM-ONE" },
    { 0x0582012b, "DUO-CAPTURE" },
    { 0x0582012f, "QUAD-CAPTURE" },
    { 0x05820130, "MICRO BR BR-80" },
    { 0x05820132, "TRI-CAPTURE" },
    { 0x05820134, "V-Mixer" },
    { 0x05820138, "Boss RC-300 (Audio mode)" },
    { 0x05820139, "Boss RC-300 (Storage mode)" },
    { 0x0582013a, "JUPITER-80" },
    { 0x0582013e, "R-26" },
    { 0x05820145, "SPD-SX" },
    { 0x0582014b, "eBand JS-10" },
    { 0x0582014d, "GT-100" },
    { 0x05820150, "TD-15" },
    { 0x05820151, "TD-11" },
    { 0x05820154, "JUPITER-50" },
    { 0x05820156, "A-Series" },
    { 0x05820158, "TD-30" },
    { 0x05820159, "DUO-CAPTURE EX" },
    { 0x0582015b, "INTEGRA-7" },
    { 0x0582015d, "R-88" },
    { 0x058201b5, "Boutique Series Synthesizer (Normal mode)" },
    { 0x058201b6, "Boutique Series Synthesizer (Storage mode)" },
    { 0x058201df, "Rubix22" },
    { 0x058201e0, "Rubix24" },
    { 0x058201e1, "Rubix44" },
    { 0x058201ef, "Go:KEYS MIDI" },
    { 0x05820505, "EDIROL UA-101" },
    { 0x05830001, "4 Axis 12 button +POV" },
    { 0x05830002, "4 Axis 12 button +POV" },
    { 0x05832030, "RM-203 USB Nest [mode 1]" },
    { 0x05832031, "RM-203 USB Nest [mode 2]" },
    { 0x05832032, "RM-203 USB Nest [mode 3]" },
    { 0x05832033, "RM-203 USB Nest [mode 4]" },
    { 0x05832050, "PX-205 PSX Bridge" },
    { 0x0583205f, "PSX/USB converter" },
    { 0x05832060, "2-axis 8-button gamepad" },
    { 0x0583206f, "USB, 2-axis 8-button gamepad" },
    { 0x05833050, "QF-305u Gamepad" },
    { 0x05833379, "Rockfire X-Force" },
    { 0x0583337f, "Rockfire USB RacingStar Vibra" },
    { 0x0583509f, "USB,4-Axis,12-Button with POV" },
    { 0x05835259, "Rockfire USB SkyShuttle Vibra" },
    { 0x0583525f, "USB Vibration Pad" },
    { 0x05835308, "USB Wireless VibrationPad" },
    { 0x05835359, "Rockfire USB SkyShuttle Pro" },
    { 0x0583535f, "USB,real VibrationPad" },
    { 0x05835659, "Rockfire USB SkyShuttle Vibra" },
    { 0x0583565f, "USB VibrationPad" },
    { 0x05836009, "Revenger" },
    { 0x0583600f, "USB,GameBoard II" },
    { 0x05836258, "USB, 4-axis, 6-button joystick w/view finder" },
    { 0x05836889, "Windstorm Pro" },
    { 0x0583688f, "QF-688uv Windstorm Pro Joystick" },
    { 0x05837070, "QF-707u Bazooka Joystick" },
    { 0x0583a000, "MaxFire G-08XU Gamepad" },
    { 0x0583a015, "4-Axis,16-Button with POV" },
    { 0x0583a019, "USB, Vibration ,4-axis, 8-button joystick w/view finder" },
    { 0x0583a020, "USB,4-Axis,10-Button with POV" },
    { 0x0583a021, "USB,4-Axis,12-Button with POV" },
    { 0x0583a022, "USB,4-Axis,14-Button with POV" },
    { 0x0583a023, "USB,4-Axis,16-Button with POV" },
    { 0x0583a024, "4axis,12button vibrition audio gamepad" },
    { 0x0583a025, "4axis,12button vibrition audio gamepad" },
    { 0x0583a130, "USB Wireless 2.4GHz Gamepad" },
    { 0x0583a131, "USB Wireless 2.4GHz Joystick" },
    { 0x0583a132, "USB Wireless 2.4GHz Wheelpad" },
    { 0x0583a133, "USB Wireless 2.4GHz Wheel&Gamepad" },
    { 0x0583a202, "ForceFeedbackWheel" },
    { 0x0583a209, "MetalStrike FF" },
    { 0x0583b000, "USB,4-Axis,12-Button with POV" },
    { 0x0583b001, "USB,4-Axis,12-Button with POV" },
    { 0x0583b002, "Vibration,12-Button USB Wheel" },
    { 0x0583b005, "USB,12-Button Wheel" },
    { 0x0583b008, "USB Wireless 2.4GHz Wheel" },
    { 0x0583b009, "USB,12-Button  Wheel" },
    { 0x0583b00a, "PSX/USB converter" },
    { 0x0583b00b, "PSX/USB converter" },
    { 0x0583b00c, "PSX/USB converter" },
    { 0x0583b00d, "PSX/USB converter" },
    { 0x0583b00e, "4-Axis,12-Button with POV" },
    { 0x0583b00f, "USB,5-Axis,10-Button with POV" },
    { 0x0583b010, "MetalStrike Pro" },
    { 0x0583b012, "Wireless MetalStrike" },
    { 0x0583b013, "USB,Wiress  2.4GHZ Joystick" },
    { 0x0583b016, "USB,5-Axis,10-Button with POV" },
    { 0x0583b018, "TW6 Wheel" },
    { 0x0583ff60, "USB Wireless VibrationPad" },
    { 0x05840008, "Fujifilm MemoryCard ReaderWriter" },
    { 0x05840220, "U2SCX SCSI Converter" },
    { 0x05840304, "U2SCX-LVD (SCSI Converter)" },
    { 0x0584b000, "REX-USB60" },
    { 0x0584b020, "REX-USB60F" },
    { 0x05850001, "Digital Camera" },
    { 0x05850002, "Digital Camera" },
    { 0x05850003, "Digital Camera" },
    { 0x05850004, "Digital Camera" },
    { 0x05850005, "Digital Camera" },
    { 0x05850006, "Digital Camera" },
    { 0x05850007, "Digital Camera" },
    { 0x05850008, "Digital Camera" },
    { 0x05850009, "Digital Camera" },
    { 0x0585000a, "Digital Camera" },
    { 0x0585000b, "Digital Camera" },
    { 0x0585000c, "Digital Camera" },
    { 0x0585000d, "Digital Camera" },
    { 0x0585000e, "Digital Camera" },
    { 0x0585000f, "Digital Camera" },
    { 0x05860025, "802.11b/g/n USB Wireless Network Adapter" },
    { 0x05860100, "omni.net" },
    { 0x05860102, "omni.net II ISDN TA [HFC-S]" },
    { 0x05860110, "omni.net Plus" },
    { 0x05861000, "omni.net LCD Plus - ISDN TA" },
    { 0x05861500, "Omni 56K Plus" },
    { 0x05862011, "Scorpion-980N keyboard" },
    { 0x05863304, "LAN Modem" },
    { 0x05863309, "ADSL Modem Prestige 600 series" },
    { 0x0586330a, "ADSL Modem Interface" },
    { 0x0586330e, "USB Broadband ADSL Modem Rev 1.10" },
    { 0x05863400, "ZyAIR B-220 IEEE 802.11b Adapter" },
    { 0x05863401, "ZyAIR G-220 802.11bg" },
    { 0x05863402, "ZyAIR G-220F 802.11bg" },
    { 0x05863403, "AG-200 802.11abg Wireless Adapter [Atheros AR5523]" },
    { 0x05863407, "G-200 v2 802.11bg" },
    { 0x05863408, "G-260 802.11bg" },
    { 0x05863409, "AG-225H 802.11bg" },
    { 0x0586340a, "M-202 802.11bg" },
    { 0x0586340c, "G-270S 802.11bg Wireless Adapter [Atheros AR5523]" },
    { 0x0586340f, "G-220 v2 802.11bg" },
    { 0x05863410, "ZyAIR G-202 802.11bg" },
    { 0x05863412, "802.11bg" },
    { 0x05863413, "ZyAIR AG-225H v2 802.11bg" },
    { 0x05863415, "G-210H 802.11g Wireless Adapter" },
    { 0x05863416, "NWD-210N 802.11b/g/n-draft wireless adapter" },
    { 0x05863417, "NWD271N 802.11n Wireless Adapter [Atheros AR9001U-(2)NG]" },
    { 0x05863418, "NWD211AN 802.11abgn Wireless Adapter [Ralink RT2870]" },
    { 0x05863419, "G-220 v3 802.11bg Wireless Adapter [ZyDAS ZD1211B]" },
    { 0x0586341a, "NWD-270N Wireless N-lite USB Adapter" },
    { 0x0586341e, "NWD2105 802.11bgn Wireless Adapter [Ralink RT3070]" },
    { 0x0586341f, "NWD2205 802.11n Wireless N Adapter [Realtek RTL8192CU]" },
    { 0x05863425, "NWD6505 802.11a/b/g/n/ac Wireless Adapter [MediaTek MT7610U]" },
    { 0x0586343e, "N220 802.11bgn Wireless Adapter" },
    { 0x058b0015, "Flash Loader utility" },
    { 0x058b001c, "Flash Drive" },
    { 0x058b0041, "Flash Loader utility" },
    { 0x058c0007, "Flash" },
    { 0x058c0008, "LP130" },
    { 0x058c000a, "LP530" },
    { 0x058c0010, "Projector" },
    { 0x058c0011, "Projector" },
    { 0x058c0012, "Projector" },
    { 0x058c0013, "Projector" },
    { 0x058c0014, "Projector" },
    { 0x058c0015, "Projector" },
    { 0x058c0016, "Projector" },
    { 0x058c0017, "Projector" },
    { 0x058c0018, "Projector" },
    { 0x058c0019, "Projector" },
    { 0x058c001a, "Projector" },
    { 0x058c001b, "Projector" },
    { 0x058c001c, "Projector" },
    { 0x058c001d, "Projector" },
    { 0x058c001e, "Projector" },
    { 0x058c001f, "Projector" },
    { 0x058cffe5, "IN34 Projector" },
    { 0x058cffeb, "Projector IN76" },
    { 0x058f1234, "Flash Drive" },
    { 0x058f198b, "Webcam (Gigatech P-09)" },
    { 0x058f2412, "SCard R/W CSR-145" },
    { 0x058f2802, "Monterey Keyboard" },
    { 0x058f5492, "Hub" },
    { 0x058f6232, "Hi-Speed 16-in-1 Flash Card Reader/Writer" },
    { 0x058f6254, "USB Hub" },
    { 0x058f6331, "SD/MMC/MS Card Reader" },
    { 0x058f6332, "Multi-Function Card Reader" },
    { 0x058f6335, "SD/MMC Card Reader" },
    { 0x058f6360, "Multimedia Card Reader" },
    { 0x058f6361, "Multimedia Card Reader" },
    { 0x058f6362, "Flash Card Reader/Writer" },
    { 0x058f6364, "AU6477 Card Reader Controller" },
    { 0x058f6366, "Multi Flash Reader" },
    { 0x058f6377, "AU6375 4-LUN card reader" },
    { 0x058f6386, "Memory Card" },
    { 0x058f6387, "Flash Drive" },
    { 0x058f6390, "USB 2.0-IDE bridge" },
    { 0x058f6391, "IDE Bridge" },
    { 0x058f6998, "AU6998 Flash Disk Controller" },
    { 0x058f9213, "MacAlly Kbd Hub" },
    { 0x058f9215, "AU9814 Hub" },
    { 0x058f9254, "Hub" },
    { 0x058f9310, "Mass Storage (UID4/5A & UID7A)" },
    { 0x058f9320, "Micro Storage Driver for Win98" },
    { 0x058f9321, "Micro Storage Driver for Win98" },
    { 0x058f9330, "SD Reader" },
    { 0x058f9331, "Micro Storage Driver for Win98" },
    { 0x058f9340, "Delkin eFilm Reader-32" },
    { 0x058f9350, "Delkin eFilm Reader-32" },
    { 0x058f9360, "8-in-1 Media Card Reader" },
    { 0x058f9361, "Multimedia Card Reader" },
    { 0x058f9368, "Multimedia Card Reader" },
    { 0x058f9380, "Flash Drive" },
    { 0x058f9381, "Flash Drive" },
    { 0x058f9382, "Acer/Sweex Flash drive" },
    { 0x058f9384, "qdi U2Disk T209M" },
    { 0x058f9410, "Keyboard" },
    { 0x058f9472, "Keyboard Hub" },
    { 0x058f9510, "ChunghwaTL USB02 Smartcard Reader" },
    { 0x058f9520, "Watchdata W 1981" },
    { 0x058f9540, "AU9540 Smartcard Reader" },
    { 0x058f9720, "USB-Serial Adapter" },
    { 0x058fa014, "Asus Integrated Webcam" },
    { 0x058fb002, "Acer Integrated Webcam" },
    { 0x05900004, "Cable Modem" },
    { 0x0590000b, "MR56SVS" },
    { 0x05900028, "HJ-720IT / HEM-7080IT-E / HEM-790IT" },
    { 0x05900051, "FT232BM [E58CIFQ1 with FTDI USB2Serial Converter]" },
    { 0x05920002, "UPS (X-Slot)" },
    { 0x05951001, "Digitrex DSC-1300/DSC-2100 (mass storage mode)" },
    { 0x05952002, "DIGITAL STILL CAMERA 6M 4X" },
    { 0x05954343, "Digital Camera EX-20 DSC" },
    { 0x05960001, "Touchscreen" },
    { 0x05960002, "Touch Screen Controller" },
    { 0x05960500, "PCT Multitouch HID Controller" },
    { 0x05960543, "DELL XPS touchscreen" },
    { 0x059b0001, "Zip 100 (Type 1)" },
    { 0x059b000b, "Zip 100 (Type 2)" },
    { 0x059b0021, "Win98 Disk Controller" },
    { 0x059b0030, "Zip 250 (Ver 1)" },
    { 0x059b0031, "Zip 100 (Type 3)" },
    { 0x059b0032, "Zip 250 (Ver 2)" },
    { 0x059b0034, "Zip 100 Driver" },
    { 0x059b0037, "Zip 750 MB" },
    { 0x059b0040, "SCSI Bridge" },
    { 0x059b0042, "Rev 70 GB" },
    { 0x059b0050, "Zip CD 650 Writer" },
    { 0x059b0053, "CDRW55292EXT CD-RW External Drive" },
    { 0x059b0056, "External CD-RW Drive Enclosure" },
    { 0x059b0057, "Mass Storage Device" },
    { 0x059b005d, "Mass Storage Device" },
    { 0x059b005f, "CDRW64892EXT3-C CD-RW 52x24x52x External Drive" },
    { 0x059b0060, "PCMCIA PocketZip Dock" },
    { 0x059b0061, "Varo PocketZip 40 MP3 Player" },
    { 0x059b006d, "HipZip MP3 Player" },
    { 0x059b0070, "eGo Portable Hard Drive" },
    { 0x059b007c, "Ultra Max USB/1394" },
    { 0x059b007d, "HTC42606 0G9AT00 [Iomega HDD]" },
    { 0x059b007e, "Mini 256MB/512MB Flash Drive [IOM2D5]" },
    { 0x059b00db, "FotoShow Zip 250 Driver" },
    { 0x059b0150, "Mass Storage Device" },
    { 0x059b015d, "Super DVD Writer" },
    { 0x059b0173, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x059b0174, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x059b0176, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x059b0177, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x059b0178, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x059b0179, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x059b017a, "HDD" },
    { 0x059b017b, "HDD/1394A" },
    { 0x059b017c, "HDD/1394B" },
    { 0x059b0251, "Optical" },
    { 0x059b0252, "Optical" },
    { 0x059b0275, "ST332082 0A" },
    { 0x059b0278, "LDHD-UPS [Professional Desktop Hard Drive eSATA / USB2.0]" },
    { 0x059b027a, "LPHD250-U [Portable Hard Drive Silver Series 250 Go]" },
    { 0x059b0470, "Prestige Portable Hard Drive" },
    { 0x059b047a, "Select Portable Hard Drive" },
    { 0x059b0571, "Prestige Portable Hard Drive" },
    { 0x059b0579, "eGo Portable Hard Drive" },
    { 0x059b1052, "DVD+RW External Drive" },
    { 0x059f0201, "StudioDrive USB2" },
    { 0x059f0202, "StudioDrive USB2" },
    { 0x059f0203, "StudioDrive USB2" },
    { 0x059f0211, "PocketDrive" },
    { 0x059f0212, "PocketDrive" },
    { 0x059f0213, "PocketDrive USB2" },
    { 0x059f0323, "LaCie d2 Drive USB2" },
    { 0x059f0421, "Big Disk G465" },
    { 0x059f0525, "BigDisk Extreme 500" },
    { 0x059f0641, "Mobile Hard Drive" },
    { 0x059f0828, "d2 Quadra" },
    { 0x059f0829, "BigDisk Extreme+" },
    { 0x059f1004, "Little Disk 20 GB" },
    { 0x059f100c, "Rugged Triple Interface Mobile Hard Drive" },
    { 0x059f1010, "Desktop Hard Drive" },
    { 0x059f1016, "Desktop Hard Drive" },
    { 0x059f1018, "Desktop Hard Drive" },
    { 0x059f1019, "Desktop Hard Drive" },
    { 0x059f1021, "Little Disk" },
    { 0x059f1027, "iamaKey V2" },
    { 0x059f102a, "Rikiki Hard Drive" },
    { 0x059f103d, "D2" },
    { 0x059f1049, "rikiki Harddrive" },
    { 0x059f1052, "P'9220 Mobile Drive" },
    { 0x059f1053, "P'9230 2TB [Porsche Design Desktop Drive 2TB]" },
    { 0x059f1061, "Rugged USB3-FW" },
    { 0x059f1064, "Rugged 16 and 32 GB" },
    { 0x059f106b, "Rugged Mini HDD" },
    { 0x059f106d, "Porsche Design Mobile Drive" },
    { 0x059f106e, "Porsche Design Desktop Drive" },
    { 0x059f1094, "Rugged THB" },
    { 0x059f1095, "Rugged" },
    { 0x059fa601, "HardDrive" },
    { 0x059fa602, "CD R/W" },
    { 0x05a38388, "Marvell 88W8388 802.11a/b/g WLAN" },
    { 0x05a39230, "Camera" },
    { 0x05a39320, "Camera" },
    { 0x05a39331, "Camera" },
    { 0x05a39422, "Camera" },
    { 0x05a39520, "Camera" },
    { 0x05a41000, "WKB-1000S Wireless Ergo Keyboard with Touchpad" },
    { 0x05a42000, "WKB-2000 Wireless Keyboard with Touchpad" },
    { 0x05a49720, "Keyboard Mouse" },
    { 0x05a49722, "Keyboard" },
    { 0x05a49731, "MCK-600W/MCK-800USB Keyboard" },
    { 0x05a49783, "Wireless Keypad" },
    { 0x05a49837, "Targus Number Keypad" },
    { 0x05a49862, "Targus Number Keypad (Composite Device)" },
    { 0x05a49881, "IR receiver [VRC-1100 Vista MCE Remote Control]" },
    { 0x05a60001, "CVA124 Cable Voice Adapter (WDM)" },
    { 0x05a60002, "CVA122 Cable Voice Adapter (WDM)" },
    { 0x05a60003, "CVA124E Cable Voice Adapter (WDM)" },
    { 0x05a60004, "CVA122E Cable Voice Adapter (WDM)" },
    { 0x05a60008, "STA1520 Tuning Adapter" },
    { 0x05a60a00, "Integrated Management Controller Hub" },
    { 0x05a60a01, "Virtual Keyboard/Mouse" },
    { 0x05a60a02, "Virtual Mass Storage" },
    { 0x05a60a03, "Virtual Ethernet/RNDIS" },
    { 0x05a74000, "Bluetooth Headset" },
    { 0x05a74001, "Bluetooth Headset in DFU mode" },
    { 0x05a74002, "Bluetooth Headset Series 2" },
    { 0x05a74003, "Bluetooth Headset Series 2 in DFU mode" },
    { 0x05a7400d, "SoundLink Color II speaker in DFU mode" },
    { 0x05a740fe, "SoundLink Color II speaker" },
    { 0x05a7bc50, "SoundLink Wireless Mobile speaker" },
    { 0x05a7bc51, "SoundLink Wireless Mobile speaker in DFU mode" },
    { 0x05a90511, "OV511 Webcam" },
    { 0x05a90518, "OV518 Webcam" },
    { 0x05a90519, "OV519 Microphone" },
    { 0x05a91550, "VEHO Filmscanner" },
    { 0x05a92640, "OV2640 Webcam" },
    { 0x05a92642, "Integrated Webcam for Dell XPS 2010" },
    { 0x05a92643, "Monitor Webcam" },
    { 0x05a9264b, "Monitor Webcam" },
    { 0x05a92800, "SuperCAM" },
    { 0x05a94519, "Webcam Classic" },
    { 0x05a97670, "OV7670 Webcam" },
    { 0x05a98065, "GAIA Sensor FPGA Demo Board" },
    { 0x05a98519, "OV519 Webcam" },
    { 0x05a9a511, "OV511+ Webcam" },
    { 0x05a9a518, "D-Link DSB-C310 Webcam" },
    { 0x05ab0002, "Parallel Port" },
    { 0x05ab0030, "Storage Adapter V2 (TPP)" },
    { 0x05ab0031, "ATA Bridge" },
    { 0x05ab0060, "USB 2.0 ATA Bridge" },
    { 0x05ab0061, "Storage Adapter V3 (TPP-I)" },
    { 0x05ab0101, "Storage Adapter (TPP)" },
    { 0x05ab0130, "Compact Flash and Microdrive Reader (TPP)" },
    { 0x05ab0200, "USS725 ATA Bridge" },
    { 0x05ab0201, "Storage Adapter (TPP)" },
    { 0x05ab0202, "ATA Bridge" },
    { 0x05ab0300, "Portable Hard Drive (TPP)" },
    { 0x05ab0301, "Portable Hard Drive V2" },
    { 0x05ab0350, "Portable Hard Drive (TPP)" },
    { 0x05ab0351, "Portable Hard Drive V2" },
    { 0x05ab081a, "ATA Bridge" },
    { 0x05ab0cda, "ATA Bridge for CD-R/RW" },
    { 0x05ab1001, "BAYI Printer Class Support" },
    { 0x05ab5700, "Storage Adapter V2 (TPP)" },
    { 0x05ab5701, "USB Storage Adapter V2" },
    { 0x05ab5901, "Smart Board (TPP)" },
    { 0x05ab5a01, "ATI Storage Adapter (TPP)" },
    { 0x05ab5d01, "DataBook Adapter (TPP)" },
    { 0x05ac0201, "USB Keyboard [Alps or Logitech, M2452]" },
    { 0x05ac0202, "Keyboard [ALPS]" },
    { 0x05ac0205, "Extended Keyboard [Mitsumi]" },
    { 0x05ac0206, "Extended Keyboard [Mitsumi]" },
    { 0x05ac020b, "Pro Keyboard [Mitsumi, A1048/US layout]" },
    { 0x05ac020c, "Extended Keyboard [Mitsumi]" },
    { 0x05ac020d, "Pro Keyboard [Mitsumi, A1048/JIS layout]" },
    { 0x05ac020e, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac020f, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0214, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0215, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0216, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac0217, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0218, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0219, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac021a, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac021b, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac021c, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac021d, "Aluminum Mini Keyboard (ANSI)" },
    { 0x05ac021e, "Aluminum Mini Keyboard (ISO)" },
    { 0x05ac021f, "Aluminum Mini Keyboard (JIS)" },
    { 0x05ac0220, "Aluminum Keyboard (ANSI)" },
    { 0x05ac0221, "Aluminum Keyboard (ISO)" },
    { 0x05ac0222, "Aluminum Keyboard (JIS)" },
    { 0x05ac0223, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0224, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0225, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac0229, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac022a, "Internal Keyboard/Trackpad (MacBook Pro) (ISO)" },
    { 0x05ac022b, "Internal Keyboard/Trackpad (MacBook Pro) (JIS)" },
    { 0x05ac0230, "Internal Keyboard/Trackpad (MacBook Pro 4,1) (ANSI)" },
    { 0x05ac0231, "Internal Keyboard/Trackpad (MacBook Pro 4,1) (ISO)" },
    { 0x05ac0232, "Internal Keyboard/Trackpad (MacBook Pro 4,1) (JIS)" },
    { 0x05ac0236, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0237, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0238, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac023f, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0240, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0241, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac0242, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0243, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0244, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac0245, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0246, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0247, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac024a, "Internal Keyboard/Trackpad (MacBook Air) (ISO)" },
    { 0x05ac024d, "Internal Keyboard/Trackpad (MacBook Air) (ISO)" },
    { 0x05ac024f, "Aluminium Keyboard (ANSI)" },
    { 0x05ac0250, "Aluminium Keyboard (ISO)" },
    { 0x05ac0252, "Internal Keyboard/Trackpad (ANSI)" },
    { 0x05ac0253, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0254, "Internal Keyboard/Trackpad (JIS)" },
    { 0x05ac0259, "Internal Keyboard/Trackpad" },
    { 0x05ac025a, "Internal Keyboard/Trackpad" },
    { 0x05ac0263, "Apple Internal Keyboard / Trackpad (MacBook Retina)" },
    { 0x05ac0267, "Magic Keyboard A1644" },
    { 0x05ac0269, "Magic Mouse 2 (Lightning connector)" },
    { 0x05ac0273, "Internal Keyboard/Trackpad (ISO)" },
    { 0x05ac0301, "USB Mouse [Mitsumi, M4848]" },
    { 0x05ac0302, "Optical Mouse [Fujitsu]" },
    { 0x05ac0304, "Mighty Mouse [Mitsumi, M1152]" },
    { 0x05ac0306, "Optical USB Mouse [Fujitsu]" },
    { 0x05ac030a, "Internal Trackpad" },
    { 0x05ac030b, "Internal Trackpad" },
    { 0x05ac030d, "Magic Mouse" },
    { 0x05ac030e, "MC380Z/A [Magic Trackpad]" },
    { 0x05ac1000, "Bluetooth HCI MacBookPro (HID mode)" },
    { 0x05ac1001, "Keyboard Hub [ALPS]" },
    { 0x05ac1002, "Extended Keyboard Hub [Mitsumi]" },
    { 0x05ac1003, "Hub in Pro Keyboard [Mitsumi, A1048]" },
    { 0x05ac1006, "Hub in Aluminum Keyboard" },
    { 0x05ac1008, "Mini DisplayPort to Dual-Link DVI Adapter" },
    { 0x05ac1101, "Speakers" },
    { 0x05ac1105, "Audio in LED Cinema Display" },
    { 0x05ac1107, "Thunderbolt Display Audio" },
    { 0x05ac1112, "FaceTime HD Camera (Display)" },
    { 0x05ac1201, "3G iPod" },
    { 0x05ac1202, "iPod 2G" },
    { 0x05ac1203, "iPod 4.Gen Grayscale 40G" },
    { 0x05ac1204, "iPod [Photo]" },
    { 0x05ac1205, "iPod Mini 1.Gen/2.Gen" },
    { 0x05ac1206, "iPod '06'" },
    { 0x05ac1207, "iPod '07'" },
    { 0x05ac1208, "iPod '08'" },
    { 0x05ac1209, "iPod Video" },
    { 0x05ac120a, "iPod Nano" },
    { 0x05ac1223, "iPod Classic/Nano 3.Gen (DFU mode)" },
    { 0x05ac1224, "iPod Nano 3.Gen (DFU mode)" },
    { 0x05ac1225, "iPod Nano 4.Gen (DFU mode)" },
    { 0x05ac1227, "Mobile Device (DFU Mode)" },
    { 0x05ac1231, "iPod Nano 5.Gen (DFU mode)" },
    { 0x05ac1240, "iPod Nano 2.Gen (DFU mode)" },
    { 0x05ac1242, "iPod Nano 3.Gen (WTF mode)" },
    { 0x05ac1243, "iPod Nano 4.Gen (WTF mode)" },
    { 0x05ac1245, "iPod Classic 3.Gen (WTF mode)" },
    { 0x05ac1246, "iPod Nano 5.Gen (WTF mode)" },
    { 0x05ac1255, "iPod Nano 4.Gen (DFU mode)" },
    { 0x05ac1260, "iPod Nano 2.Gen" },
    { 0x05ac1261, "iPod Classic" },
    { 0x05ac1262, "iPod Nano 3.Gen" },
    { 0x05ac1263, "iPod Nano 4.Gen" },
    { 0x05ac1265, "iPod Nano 5.Gen" },
    { 0x05ac1266, "iPod Nano 6.Gen" },
    { 0x05ac1267, "iPod Nano 7.Gen" },
    { 0x05ac1281, "Apple Mobile Device [Recovery Mode]" },
    { 0x05ac1290, "Apple iPhone" },
    { 0x05ac1291, "Apple iPod Touch" },
    { 0x05ac1292, "Apple iPhone 3G" },
    { 0x05ac1293, "Apple iPod Touch 2G" },
    { 0x05ac1294, "Apple iPhone 3GS" },
    { 0x05ac1296, "iPod Touch 3.Gen (8GB)" },
    { 0x05ac1297, "Apple iPhone 4" },
    { 0x05ac1299, "Apple iPod Touch 3rd Gen" },
    { 0x05ac129a, "Apple iPad" },
    { 0x05ac129c, "iPhone 4(CDMA)" },
    { 0x05ac129e, "iPod Touch 4.Gen" },
    { 0x05ac129f, "iPad 2" },
    { 0x05ac12a0, "Apple iPhone 4S" },
    { 0x05ac12a2, "iPad 2 (3G; 64GB)" },
    { 0x05ac12a3, "iPad 2 (CDMA)" },
    { 0x05ac12a4, "iPad 3 (wifi)" },
    { 0x05ac12a5, "iPad 3 (CDMA)" },
    { 0x05ac12a6, "iPad 3 (3G, 16 GB)" },
    { 0x05ac12a8, "iPhone 5/5C/5S/6/SE" },
    { 0x05ac12a9, "iPad 2" },
    { 0x05ac12aa, "iPod Touch 5.Gen [A1421]" },
    { 0x05ac12ab, "iPad 4/Mini1" },
    { 0x05ac1300, "iPod Shuffle" },
    { 0x05ac1301, "iPod Shuffle 2.Gen" },
    { 0x05ac1302, "iPod Shuffle 3.Gen" },
    { 0x05ac1303, "iPod Shuffle 4.Gen" },
    { 0x05ac1392, "Apple Watch charger" },
    { 0x05ac1393, "AirPods case" },
    { 0x05ac1395, "Smart Battery Case [iPhone 6]" },
    { 0x05ac1398, "Smart Battery Case" },
    { 0x05ac1401, "Modem" },
    { 0x05ac1402, "Ethernet Adapter [A1277]" },
    { 0x05ac1500, "SuperDrive [A1379]" },
    { 0x05ac8005, "OHCI Root Hub Simulation" },
    { 0x05ac8006, "EHCI Root Hub Simulation" },
    { 0x05ac8007, "XHCI Root Hub USB 2.0 Simulation" },
    { 0x05ac8202, "HCF V.90 Data/Fax Modem" },
    { 0x05ac8203, "Bluetooth HCI" },
    { 0x05ac8204, "Built-in Bluetooth 2.0+EDR HCI" },
    { 0x05ac8205, "Bluetooth HCI" },
    { 0x05ac8206, "Bluetooth HCI" },
    { 0x05ac820a, "Bluetooth HID Keyboard" },
    { 0x05ac820b, "Bluetooth HID Mouse" },
    { 0x05ac820f, "Bluetooth HCI" },
    { 0x05ac8213, "Bluetooth Host Controller" },
    { 0x05ac8215, "Built-in Bluetooth 2.0+EDR HCI" },
    { 0x05ac8216, "Bluetooth USB Host Controller" },
    { 0x05ac8217, "Bluetooth USB Host Controller" },
    { 0x05ac8218, "Bluetooth Host Controller" },
    { 0x05ac821a, "Bluetooth Host Controller" },
    { 0x05ac821f, "Built-in Bluetooth 2.0+EDR HCI" },
    { 0x05ac8240, "Built-in IR Receiver" },
    { 0x05ac8241, "Built-in IR Receiver" },
    { 0x05ac8242, "Built-in IR Receiver" },
    { 0x05ac8281, "Bluetooth Host Controller" },
    { 0x05ac8286, "Bluetooth Host Controller" },
    { 0x05ac8289, "Bluetooth Host Controller" },
    { 0x05ac828c, "Bluetooth Host Controller" },
    { 0x05ac8290, "Bluetooth Host Controller" },
    { 0x05ac8300, "Built-in iSight (no firmware loaded)" },
    { 0x05ac8403, "Internal Memory Card Reader" },
    { 0x05ac8404, "Internal Memory Card Reader" },
    { 0x05ac8406, "Internal Memory Card Reader" },
    { 0x05ac8501, "Built-in iSight [Micron]" },
    { 0x05ac8502, "Built-in iSight" },
    { 0x05ac8505, "Built-in iSight" },
    { 0x05ac8507, "Built-in iSight" },
    { 0x05ac8508, "iSight in LED Cinema Display" },
    { 0x05ac8509, "FaceTime HD Camera" },
    { 0x05ac850a, "FaceTime Camera" },
    { 0x05ac8510, "FaceTime HD Camera (Built-in)" },
    { 0x05ac8600, "iBridge" },
    { 0x05ac911c, "Hub in A1082 [Cinema HD Display 23\"]" },
    { 0x05ac9127, "Hub in Thunderbolt Display" },
    { 0x05ac912f, "Hub in 30\" Cinema Display" },
    { 0x05ac9215, "Studio Display 15\"" },
    { 0x05ac9217, "Studio Display 17\"" },
    { 0x05ac9218, "Cinema Display 23\"" },
    { 0x05ac9219, "Cinema Display 20\"" },
    { 0x05ac921c, "A1082 [Cinema HD Display 23\"]" },
    { 0x05ac921e, "Cinema Display 24\"" },
    { 0x05ac9221, "30\" Cinema Display" },
    { 0x05ac9226, "LED Cinema Display" },
    { 0x05ac9227, "Thunderbolt Display" },
    { 0x05ac9232, "Cinema HD Display 30\"" },
    { 0x05acffff, "Bluetooth in DFU mode - Driver" },
    { 0x05af0806, "HP SK806A Keyboard" },
    { 0x05af0809, "Wireless Keyboard and Mouse" },
    { 0x05af0821, "IDE to" },
    { 0x05af3062, "Cordless Keyboard" },
    { 0x05af9167, "KB 9151B - 678" },
    { 0x05af9267, "KB 9251B - 678 Mouse" },
    { 0x05b11389, "Bluetooth Wireless Adapter" },
    { 0x05b44857, "M-Any DAH-210" },
    { 0x05b46001, "HYUNDAI GDS30C6001 SSFDC / MMC I/F Controller" },
    { 0x05b83002, "Scroll Mouse" },
    { 0x05b83126, "APT-905 Wireless presenter" },
    { 0x05b83223, "ISY Wireless Presenter" },
    { 0x05ba0007, "Fingerprint Reader" },
    { 0x05ba0008, "Fingerprint Reader" },
    { 0x05ba000a, "Fingerprint Reader" },
    { 0x05bc0004, "Trackball" },
    { 0x05c50002, "AccelePort USB 2" },
    { 0x05c50004, "AccelePort USB 4" },
    { 0x05c50008, "AccelePort USB 8" },
    { 0x05c60114, "Select RW-200 CDMA Wireless Modem" },
    { 0x05c60229, "Nokia 5530 Xpressmusic" },
    { 0x05c60a02, "Jolla Device Developer Mode" },
    { 0x05c60a07, "Jolla Device MTP" },
    { 0x05c60afe, "Jolla Device Charging Only" },
    { 0x05c61000, "Mass Storage Device" },
    { 0x05c63100, "CDMA Wireless Modem/Phone" },
    { 0x05c63196, "Nokia/Verizon 6205 Balboa/Verizon Music Phone" },
    { 0x05c63197, "CDMA Wireless Modem/Phone" },
    { 0x05c66000, "Siemens SG75" },
    { 0x05c66503, "AnyData APE-540H" },
    { 0x05c66613, "Onda H600/N501HS ZTE MF330" },
    { 0x05c66764, "A0001 Phone [OnePlus One]" },
    { 0x05c69000, "SIMCom SIM5218 modem" },
    { 0x05c69001, "Gobi Wireless Modem" },
    { 0x05c69002, "Gobi Wireless Modem" },
    { 0x05c69003, "Quectel UC20" },
    { 0x05c69008, "Gobi Wireless Modem (QDL mode)" },
    { 0x05c69018, "Qualcomm HSUSB Device" },
    { 0x05c69025, "HSUSB Device" },
    { 0x05c69090, "Quectel UC15" },
    { 0x05c69091, "Intex Aqua Fish & Jolla C Diagnostic Mode" },
    { 0x05c69092, "Nokia 8110 4G" },
    { 0x05c690ba, "Audio 1.0 device" },
    { 0x05c690bb, "Snapdragon interface (MIDI + ADB)" },
    { 0x05c690dc, "Fairphone 2 (Charging & ADB)" },
    { 0x05c69201, "Gobi Wireless Modem (QDL mode)" },
    { 0x05c69202, "Gobi Wireless Modem" },
    { 0x05c69203, "Gobi Wireless Modem" },
    { 0x05c69205, "Gobi 2000" },
    { 0x05c69211, "Acer Gobi Wireless Modem (QDL mode)" },
    { 0x05c69212, "Acer Gobi Wireless Modem" },
    { 0x05c69214, "Acer Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x05c69215, "Quectel EC20 LTE modem / Acer Gobi 2000 Wireless Modem" },
    { 0x05c69221, "Gobi Wireless Modem (QDL mode)" },
    { 0x05c69222, "Gobi Wireless Modem" },
    { 0x05c69224, "Sony Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x05c69225, "Sony Gobi 2000 Wireless Modem" },
    { 0x05c69231, "Gobi Wireless Modem (QDL mode)" },
    { 0x05c69234, "Top Global Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x05c69235, "Top Global Gobi 2000 Wireless Modem" },
    { 0x05c69244, "Samsung Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x05c69245, "Samsung Gobi 2000 Wireless Modem" },
    { 0x05c69264, "Asus Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x05c69265, "Asus Gobi 2000 Wireless Modem" },
    { 0x05c69274, "iRex Technologies Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x05c69275, "iRex Technologies Gobi 2000 Wireless Modem" },
    { 0x05c6f003, "Nokia 8110 4G" },
    { 0x05c70113, "PC Line Mouse" },
    { 0x05c71001, "Lynx Mouse" },
    { 0x05c72001, "Keyboard" },
    { 0x05c72011, "SCorpius Keyboard" },
    { 0x05c76001, "Ten-Keypad" },
    { 0x05c80103, "FO13FF-65 PC-CAM" },
    { 0x05c8010b, "Webcam (UVC)" },
    { 0x05c8021a, "HP Webcam" },
    { 0x05c80233, "HP Webcam" },
    { 0x05c80318, "Webcam" },
    { 0x05c80361, "SunplusIT INC. HP Truevision HD Webcam" },
    { 0x05c8036e, "Webcam" },
    { 0x05c80374, "HP EliteBook integrated HD Webcam" },
    { 0x05c8038e, "HP Wide Vision HD integrated webcam" },
    { 0x05c803a1, "XiaoMi Webcam" },
    { 0x05c803b1, "Webcam" },
    { 0x05c803bc, "HP Wide Vision HD Integrated Webcam" },
    { 0x05c803cb, "HP Wide Vision HD Integrated Webcam" },
    { 0x05c80403, "Webcam" },
    { 0x05c8041b, "HP 2.0MP High Definition Webcam" },
    { 0x05ca0101, "RDC-5300 Camera" },
    { 0x05ca0110, "Ricoh Caplio R5" },
    { 0x05ca0325, "Ricoh Caplio GX" },
    { 0x05ca0327, "Sea & Sea 5000G" },
    { 0x05ca032b, "Ricoh Caplio R1v" },
    { 0x05ca032d, "Ricoh Caplio GX 8" },
    { 0x05ca032f, "Ricoh Caplio R3" },
    { 0x05ca033d, "Ricoh Caplio RR750" },
    { 0x05ca0353, "Sea & Sea 2G" },
    { 0x05ca03a1, "IS200e" },
    { 0x05ca0403, "Printing Support" },
    { 0x05ca0405, "Type 101" },
    { 0x05ca0406, "Type 102" },
    { 0x05ca0437, "Aficio SP 3510SF" },
    { 0x05ca044e, "SP C250SF (multifunction device: printer, scanner, fax)" },
    { 0x05ca1803, "V5 camera [R5U870]" },
    { 0x05ca1810, "Pavilion Webcam [R5U870]" },
    { 0x05ca1812, "Pavilion Webcam" },
    { 0x05ca1814, "HD Webcam" },
    { 0x05ca1815, "Dell Laptop Integrated Webcam" },
    { 0x05ca1820, "Integrated Webcam" },
    { 0x05ca1830, "Visual Communication Camera VGP-VCC2 [R5U870]" },
    { 0x05ca1832, "Visual Communication Camera VGP-VCC3 [R5U870]" },
    { 0x05ca1833, "Visual Communication Camera VGP-VCC2 [R5U870]" },
    { 0x05ca1834, "Visual Communication Camera VGP-VCC2 [R5U870]" },
    { 0x05ca1835, "Visual Communication Camera VGP-VCC5 [R5U870]" },
    { 0x05ca1836, "Visual Communication Camera VGP-VCC4 [R5U870]" },
    { 0x05ca1837, "Visual Communication Camera VGP-VCC4 [R5U870]" },
    { 0x05ca1839, "Visual Communication Camera VGP-VCC6 [R5U870]" },
    { 0x05ca183a, "Visual Communication Camera VGP-VCC7 [R5U870]" },
    { 0x05ca183b, "Visual Communication Camera VGP-VCC8 [R5U870]" },
    { 0x05ca183d, "Sony Vaio Integrated Webcam" },
    { 0x05ca183e, "Visual Communication Camera VGP-VCC9 [R5U870]" },
    { 0x05ca183f, "Sony Visual Communication Camera Integrated Webcam" },
    { 0x05ca1841, "Fujitsu F01/ Lifebook U810 [R5U870]" },
    { 0x05ca1870, "Webcam 1000" },
    { 0x05ca1880, "R5U880" },
    { 0x05ca18b0, "Sony Vaio Integrated Webcam" },
    { 0x05ca18b1, "Sony Vaio Integrated Webcam" },
    { 0x05ca18b3, "Sony Vaio Integrated Webcam" },
    { 0x05ca18b5, "Sony Vaio Integrated Webcam" },
    { 0x05ca2201, "RDC-7 Camera" },
    { 0x05ca2202, "Caplio RR30" },
    { 0x05ca2203, "Caplio 300G" },
    { 0x05ca2204, "Caplio G3" },
    { 0x05ca2205, "Caplio RR30 / Medion MD 6126 Camera" },
    { 0x05ca2206, "Konica DG-3Z" },
    { 0x05ca2207, "Caplio Pro G3" },
    { 0x05ca2208, "Caplio G4" },
    { 0x05ca2209, "Caplio 400G wide" },
    { 0x05ca220a, "KONICA MINOLTA DG-4Wide" },
    { 0x05ca220b, "Caplio RX" },
    { 0x05ca220c, "Caplio GX" },
    { 0x05ca220d, "Caplio R1/RZ1" },
    { 0x05ca220e, "Sea & Sea 5000G" },
    { 0x05ca220f, "Rollei dr5" },
    { 0x05ca2211, "Caplio R1S" },
    { 0x05ca2212, "Caplio R1v Camera" },
    { 0x05ca2213, "Caplio R2" },
    { 0x05ca2214, "Caplio GX 8" },
    { 0x05ca2215, "DSC 725" },
    { 0x05ca2216, "Caplio R3" },
    { 0x05ca2222, "RDC-i500" },
    { 0x05cb1483, "PV8630 interface (scanners, webcams)" },
    { 0x05cc2100, "MicroLink ISDN Office" },
    { 0x05cc2219, "MicroLink ISDN" },
    { 0x05cc2265, "MicroLink 56k" },
    { 0x05cc2267, "MicroLink 56k (V.250)" },
    { 0x05cc2280, "MicroLink 56k Fun" },
    { 0x05cc3000, "Micolink USB2Ethernet [pegasus]" },
    { 0x05cc3100, "AirLancer USB-11" },
    { 0x05cc3363, "MicroLink ADSL Fun" },
    { 0x05d10003, "Bluetooth Adapter BL-554" },
    { 0x05d70099, "10Mbps Ethernet [klsi]" },
    { 0x05d84001, "Artec Ultima 2000" },
    { 0x05d84002, "Artec Ultima 2000 (GT6801 based)/Lifetec LT9385/ScanMagic 1200 UB Plus Scanner" },
    { 0x05d84003, "Artec E+ 48U" },
    { 0x05d84004, "Artec E+ Pro" },
    { 0x05d84005, "MEM48U" },
    { 0x05d84006, "TRUST EASY WEBSCAN 19200" },
    { 0x05d84007, "TRUST 240H EASY WEBSCAN GOLD" },
    { 0x05d84008, "Trust Easy Webscan 19200" },
    { 0x05d84009, "Umax Astraslim" },
    { 0x05d84013, "IT Scan 1200" },
    { 0x05d88105, "Artec T1 USB TVBOX (cold)" },
    { 0x05d88106, "Artec T1 USB TVBOX (warm)" },
    { 0x05d88107, "Artec T1 USB TVBOX with AN2235 (cold)" },
    { 0x05d88108, "Artec T1 USB TVBOX with AN2235 (warm)" },
    { 0x05d88109, "Artec T1 USB2.0 TVBOX (cold" },
    { 0x05d9a225, "A225 Printer" },
    { 0x05d9a758, "A758 Printer" },
    { 0x05d9a794, "A794 Printer" },
    { 0x05da0091, "ScanMaker X6u" },
    { 0x05da0093, "ScanMaker V6USL" },
    { 0x05da0094, "Phantom 336CX/C3" },
    { 0x05da0099, "ScanMaker X6/X6U" },
    { 0x05da009a, "Phantom C6" },
    { 0x05da00a0, "Phantom 336CX/C3 (#2)" },
    { 0x05da00a3, "ScanMaker V6USL" },
    { 0x05da00ac, "ScanMaker V6UL" },
    { 0x05da00b6, "ScanMaker V6UPL" },
    { 0x05da00ef, "ScanMaker V6UPL" },
    { 0x05da1006, "Jenoptik JD350 entrance" },
    { 0x05da1011, "NHJ Che-ez! Kiss Digital Camera" },
    { 0x05da1018, "Digital Dream Enigma 1.3" },
    { 0x05da1020, "Digital Dream l'espion xtra" },
    { 0x05da1025, "Take-it Still Camera Device" },
    { 0x05da1026, "Take-it" },
    { 0x05da1043, "Take-It 1300 DSC Bulk Driver" },
    { 0x05da1045, "Take-it D1" },
    { 0x05da1047, "Take-it Camera Composite Device" },
    { 0x05da1048, "Take-it Q3" },
    { 0x05da1049, "3M Still Camera Device" },
    { 0x05da1051, "Camcorder Series" },
    { 0x05da1052, "Mass Storage Device" },
    { 0x05da1053, "Take-it DV Composite Device" },
    { 0x05da1054, "Mass Storage Device" },
    { 0x05da1055, "Digital Camera Series(536)" },
    { 0x05da1056, "Mass Storage Device" },
    { 0x05da1057, "Take-it DSC Camera Device(536)" },
    { 0x05da1058, "Mass Storage Device" },
    { 0x05da1059, "Camcorder DSC Series" },
    { 0x05da1060, "Microtek Take-it MV500" },
    { 0x05da2007, "ArtixScan DI 1210" },
    { 0x05da200c, "1394_USB2 Scanner" },
    { 0x05da200e, "ArtixScan DI 810" },
    { 0x05da2017, "UF ICE Scanner" },
    { 0x05da201c, "4800 Scanner" },
    { 0x05da201d, "ArtixScan DI 1610" },
    { 0x05da201f, "4800 Scanner-ICE" },
    { 0x05da202e, "ArtixScan DI 2020" },
    { 0x05da208b, "ScanMaker 6800" },
    { 0x05da208f, "ArtixScan DI 2010" },
    { 0x05da209e, "ScanMaker 4700LP" },
    { 0x05da20a7, "ScanMaker 5600" },
    { 0x05da20b0, "ScanMaker X12USL" },
    { 0x05da20b1, "ScanMaker 8700" },
    { 0x05da20b4, "ScanMaker 4700" },
    { 0x05da20bd, "ScanMaker 5700" },
    { 0x05da20c9, "ScanMaker 6700" },
    { 0x05da20d2, "Microtek ArtixScan 1800f" },
    { 0x05da20d6, "PS4000" },
    { 0x05da20de, "ScanMaker 9800XL" },
    { 0x05da20e0, "ScanMaker 9700XL" },
    { 0x05da20ed, "ScanMaker 4700" },
    { 0x05da20ee, "Micortek ScanMaker X12USL" },
    { 0x05da2838, "RT2832U" },
    { 0x05da3008, "Scanner" },
    { 0x05da300a, "4800 ICE Scanner" },
    { 0x05da300b, "4800 Scanner" },
    { 0x05da300f, "MiniScan C5" },
    { 0x05da3020, "4800dpi Scanner" },
    { 0x05da3021, "1200dpi Scanner" },
    { 0x05da3022, "Scanner 4800dpi" },
    { 0x05da3023, "USB1200II Scanner" },
    { 0x05da3025, "ScanMaker S460" },
    { 0x05da30c1, "USB600 Scanner" },
    { 0x05da30ce, "ScanMaker 3800" },
    { 0x05da30cf, "ScanMaker 4800" },
    { 0x05da30d4, "USB1200 Scanner" },
    { 0x05da30d8, "Scanner" },
    { 0x05da30d9, "USB2400 Scanner" },
    { 0x05da30e4, "ScanMaker 4100" },
    { 0x05da30e5, "USB3200 Scanner" },
    { 0x05da30e6, "ScanMaker i320" },
    { 0x05da40b3, "ScanMaker 3600" },
    { 0x05da40b8, "ScanMaker 3700" },
    { 0x05da40c7, "ScanMaker 4600" },
    { 0x05da40ca, "ScanMaker 3600" },
    { 0x05da40cb, "ScanMaker 3700" },
    { 0x05da40dd, "ScanMaker 3750i" },
    { 0x05da40ff, "ScanMaker 3600" },
    { 0x05da5003, "Goya" },
    { 0x05da5013, "3200 Scanner" },
    { 0x05da6072, "XT-3500 A4 HD Scanner" },
    { 0x05da80a3, "ScanMaker V6USL (#2)" },
    { 0x05da80ac, "ScanMaker V6UL/SpicyU" },
    { 0x05db0003, "SUNTAC U-Cable type D2" },
    { 0x05db0005, "SUNTAC U-Cable type P1" },
    { 0x05db0009, "SUNTAC Slipper U" },
    { 0x05db000a, "SUNTAC Ir-Trinity" },
    { 0x05db000b, "SUNTAC U-Cable type A3" },
    { 0x05db0011, "SUNTAC U-Cable type A4" },
    { 0x05dc0001, "jumpSHOT CompactFlash Reader" },
    { 0x05dc0002, "JumpShot" },
    { 0x05dc0003, "JumpShot" },
    { 0x05dc0080, "Jumpdrive Secure 64MB" },
    { 0x05dc0081, "RBC Compact Flash Drive" },
    { 0x05dc00a7, "JumpDrive Impact" },
    { 0x05dc0100, "JumpDrive PRO" },
    { 0x05dc0200, "JumpDrive 2.0 Pro" },
    { 0x05dc0300, "Jumpdrive Geysr" },
    { 0x05dc0301, "JumpDrive Classic" },
    { 0x05dc0302, "JD Micro" },
    { 0x05dc0303, "JD Micro Pro" },
    { 0x05dc0304, "JD Secure II" },
    { 0x05dc0310, "JumpDrive" },
    { 0x05dc0311, "JumpDrive Classic" },
    { 0x05dc0312, "JD Micro" },
    { 0x05dc0313, "JD Micro Pro" },
    { 0x05dc0320, "JumpDrive" },
    { 0x05dc0321, "JD Micro" },
    { 0x05dc0322, "JD Micro Pro" },
    { 0x05dc0323, "UFC" },
    { 0x05dc0330, "JumpDrive Expression" },
    { 0x05dc0340, "JumpDrive TAD" },
    { 0x05dc0350, "Express Card" },
    { 0x05dc0400, "UFDC" },
    { 0x05dc0401, "UFDC" },
    { 0x05dc0403, "Locked B Device" },
    { 0x05dc0405, "Locked C Device" },
    { 0x05dc0407, "Locked D Device" },
    { 0x05dc0409, "Locked E Device" },
    { 0x05dc040b, "Locked F Device" },
    { 0x05dc040d, "Locked G Device" },
    { 0x05dc040f, "Locked H Device" },
    { 0x05dc0410, "JumpDrive" },
    { 0x05dc0411, "JumpDrive" },
    { 0x05dc0413, "Locked J Device" },
    { 0x05dc0415, "Locked K Device" },
    { 0x05dc0417, "Locked L Device" },
    { 0x05dc0419, "Locked M Device" },
    { 0x05dc041b, "Locked N Device" },
    { 0x05dc041d, "Locked O Device" },
    { 0x05dc041f, "Locked P Device" },
    { 0x05dc0420, "JumpDrive" },
    { 0x05dc0421, "JumpDrive" },
    { 0x05dc0423, "Locked R Device" },
    { 0x05dc0425, "Locked S Device" },
    { 0x05dc0427, "Locked T Device" },
    { 0x05dc0429, "Locked U Device" },
    { 0x05dc042b, "Locked V Device" },
    { 0x05dc042d, "Locked W Device" },
    { 0x05dc042f, "Locked X Device" },
    { 0x05dc0431, "Locked Y Device" },
    { 0x05dc0433, "Locked Z Device" },
    { 0x05dc4d02, "MP3 Player" },
    { 0x05dc4d12, "MP3 Player" },
    { 0x05dc4d30, "MP3 Player" },
    { 0x05dca201, "JumpDrive S70 4GB" },
    { 0x05dca209, "JumpDrive S70" },
    { 0x05dca300, "JumpDrive2" },
    { 0x05dca400, "JumpDrive trade; Pro 40-501" },
    { 0x05dca410, "JumpDrive 128MB/256MB" },
    { 0x05dca411, "JumpDrive Traveler" },
    { 0x05dca420, "JumpDrive Pro" },
    { 0x05dca421, "JumpDrive Pro II" },
    { 0x05dca422, "JumpDrive Micro Pro" },
    { 0x05dca430, "JumpDrive Secure" },
    { 0x05dca431, "JumpDrive Secure II" },
    { 0x05dca432, "JumpDrive Classic" },
    { 0x05dca440, "JumpDrive Lightning" },
    { 0x05dca450, "JumpDrive TouchGuard" },
    { 0x05dca460, "JD Mercury" },
    { 0x05dca501, "JumpDrive Classic" },
    { 0x05dca510, "JumpDrive Sport" },
    { 0x05dca530, "JumpDrive Expression" },
    { 0x05dca531, "JumpDrive Secure II" },
    { 0x05dca560, "JumpDrive FireFly" },
    { 0x05dca701, "JumpDrive FireFly" },
    { 0x05dca731, "JumpDrive FireFly" },
    { 0x05dca762, "JumpDrive FireFly" },
    { 0x05dca768, "JumpDrive Retrax" },
    { 0x05dca790, "JumpDrive 2GB" },
    { 0x05dca811, "16GB Gizmo!" },
    { 0x05dca813, "16gB flash thumb drive" },
    { 0x05dca815, "JumpDrive V10" },
    { 0x05dca81d, "LJDTT16G [JumpDrive 16GB]" },
    { 0x05dca833, "JumpDrive S23 64GB" },
    { 0x05dca838, "JumpDrive Tough" },
    { 0x05dcb002, "USB CF Reader" },
    { 0x05dcb018, "Multi-Card Reader" },
    { 0x05dcb047, "SDHC Reader [RW047-7000]" },
    { 0x05dcb051, "microSD RDR UHS-I Card Reader [LRWM03U-7000]" },
    { 0x05dcba02, "Workflow CFR1" },
    { 0x05dcba0a, "Workflow DD512" },
    { 0x05dcc753, "JumpDrive TwistTurn" },
    { 0x05dcc75c, "JumpDrive V10" },
    { 0x05dda011, "HID UPS Battery" },
    { 0x05ddff31, "AWU-120" },
    { 0x05ddff32, "FriendlyNET AeroLAN AL2011" },
    { 0x05ddff35, "PCW 100 - Wireless 802.11b Adapter" },
    { 0x05ddff91, "2Wire PC Port Phoneline 10Mbps Adapter" },
    { 0x05e00700, "Bar Code Scanner (CS1504)" },
    { 0x05e00800, "Spectrum24 Wireless LAN Adapter" },
    { 0x05e01200, "Bar Code Scanner" },
    { 0x05e01701, "Bar Code Scanner (CDC)" },
    { 0x05e01900, "SNAPI Imaging Device" },
    { 0x05e02000, "MC3090 Rugged Mobile Computer" },
    { 0x05e0200d, "MC70 Rugged Mobile Computer" },
    { 0x05e10100, "802.11g + Bluetooth Wireless Adapter" },
    { 0x05e10408, "STK1160 Video Capture Device" },
    { 0x05e10500, "DC-112X Webcam" },
    { 0x05e10501, "DC-1125 Webcam" },
    { 0x05e10890, "STK011 Camera" },
    { 0x05e10892, "STK013 Camera" },
    { 0x05e10895, "STK016 Camera" },
    { 0x05e10896, "STK017 Camera" },
    { 0x05e12010, "ARCTIC Sound P261 Headphones" },
    { 0x05e3000a, "Keyboard with PS/2 Port" },
    { 0x05e3000b, "Mouse" },
    { 0x05e30100, "Nintendo Game Boy Advance SP" },
    { 0x05e30120, "Pacific Image Electronics PrimeFilm 1800u slide/negative scanner" },
    { 0x05e30131, "CF/SM Reader/Writer" },
    { 0x05e30142, "Multiple Slides Scanner-3600" },
    { 0x05e30143, "Multiple Frames Film Scanner-36series" },
    { 0x05e30145, "Reflecta CrystalScan 7200 Photo-Scanner" },
    { 0x05e30180, "Plustek Scanner" },
    { 0x05e30182, "Wize Media 1000" },
    { 0x05e30189, "ScanJet 4600 series" },
    { 0x05e3018a, "Xerox 6400" },
    { 0x05e30300, "GLUSB98PT Parallel Port" },
    { 0x05e30301, "USB2LPT Cable Release2" },
    { 0x05e30406, "Hub" },
    { 0x05e30501, "GL620USB Host-Host interface" },
    { 0x05e30502, "GL620USB-A GeneLink USB-USB Bridge" },
    { 0x05e30503, "Webcam" },
    { 0x05e30504, "HID Keyboard Filter" },
    { 0x05e30510, "Camera" },
    { 0x05e30604, "USB 1.1 Hub" },
    { 0x05e30605, "Hub" },
    { 0x05e30606, "USB 2.0 Hub / D-Link DUB-H4 USB 2.0 Hub" },
    { 0x05e30607, "Logitech G110 Hub" },
    { 0x05e30608, "Hub" },
    { 0x05e30610, "Hub" },
    { 0x05e30612, "Hub" },
    { 0x05e30616, "hub" },
    { 0x05e30660, "USB 2.0 Hub" },
    { 0x05e30700, "SIIG US2256 CompactFlash Card Reader" },
    { 0x05e30701, "USB 2.0 IDE Adapter" },
    { 0x05e30702, "USB 2.0 IDE Adapter [GL811E]" },
    { 0x05e30703, "Card Reader" },
    { 0x05e30704, "Card Reader" },
    { 0x05e30705, "Card Reader" },
    { 0x05e30706, "Card Reader" },
    { 0x05e30707, "Card Reader" },
    { 0x05e30708, "Card Reader" },
    { 0x05e30709, "Card Reader" },
    { 0x05e3070a, "Pen Flash" },
    { 0x05e3070b, "DMHS1B Rev 3 DFU Adapter" },
    { 0x05e3070e, "USB 2.0 Card Reader" },
    { 0x05e3070f, "Pen Flash" },
    { 0x05e30710, "USB 2.0 33-in-1 Card Reader" },
    { 0x05e30711, "Card Reader" },
    { 0x05e30712, "Delkin Mass Storage Device" },
    { 0x05e30715, "USB 2.0 microSD Reader" },
    { 0x05e30716, "Multislot Card Reader/Writer" },
    { 0x05e30717, "All-in-1 Card Reader" },
    { 0x05e30718, "IDE/SATA Adapter" },
    { 0x05e30719, "SATA adapter" },
    { 0x05e30722, "SD/MMC card reader" },
    { 0x05e30723, "GL827L SD/MMC/MS Flash Card Reader" },
    { 0x05e30726, "SD Card Reader" },
    { 0x05e30727, "microSD Reader/Writer" },
    { 0x05e30731, "GL3310 SATA 3Gb/s Bridge Controller" },
    { 0x05e30732, "All-in-One Cardreader" },
    { 0x05e30736, "Colour arc SD Card Reader [PISEN]" },
    { 0x05e30738, "Card reader" },
    { 0x05e30741, "microSD Card Reader" },
    { 0x05e30743, "SDXC and microSDXC CardReader" },
    { 0x05e30745, "Logilink CR0012" },
    { 0x05e30748, "All-in-One Cardreader" },
    { 0x05e30749, "SD Card Reader and Writer" },
    { 0x05e30751, "microSD Card Reader" },
    { 0x05e30760, "USB 2.0 Card Reader/Writer" },
    { 0x05e30761, "Genesys Mass Storage Device" },
    { 0x05e30780, "USBFS DFU Adapter" },
    { 0x05e307a0, "Pen Flash" },
    { 0x05e30880, "Wasp (SL-6612)" },
    { 0x05e30927, "Card Reader" },
    { 0x05e31205, "Afilias Optical Mouse H3003 / Trust Optical USB MultiColour Mouse MI-2330" },
    { 0x05e3a700, "Pen Flash" },
    { 0x05e3f102, "VX7012 TV Box" },
    { 0x05e3f103, "VX7012 TV Box" },
    { 0x05e3f104, "VX7012 TV Box" },
    { 0x05e3fd21, "3M TL20 Temperature Logger" },
    { 0x05e3fe00, "Razer Mouse" },
    { 0x05e90008, "KL5KUSB101B Ethernet [klsi]" },
    { 0x05e90009, "Sony 10Mbps Ethernet [pegasus]" },
    { 0x05e9000c, "USB-to-RS-232" },
    { 0x05e9000d, "USB-to-RS-232" },
    { 0x05e90014, "RS-232 J104" },
    { 0x05e90040, "Ethernet Adapter" },
    { 0x05e92008, "Ethernet Adapter" },
    { 0x05ef020a, "Top Shot Pegasus Joystick" },
    { 0x05ef8884, "Mag Turbo Force Wheel" },
    { 0x05ef8888, "Top Shot Force Feedback Racing Wheel" },
    { 0x05f00101, "DA-Port DAC" },
    { 0x05f20010, "AQ Mouse" },
    { 0x05f30007, "Kinesis Advantage PRO MPC/USB Keyboard" },
    { 0x05f30081, "Kinesis Integrated Hub" },
    { 0x05f300ff, "VEC Footpedal" },
    { 0x05f30203, "Y-mouse Keyboard & Mouse Adapter" },
    { 0x05f3020b, "PS2 Adapter" },
    { 0x05f30232, "X-Keys Switch Interface, Programming Mode" },
    { 0x05f30261, "X-Keys Switch Interface, SPLAT Mode" },
    { 0x05f30264, "X-Keys Switch Interface, Composite Mode" },
    { 0x05f91104, "Magellan 2200VS" },
    { 0x05f91206, "Gryphon series (OEM mode)" },
    { 0x05f9120c, "Gryphon GD4430-BK" },
    { 0x05f92202, "Point of Sale Handheld Scanner" },
    { 0x05f92206, "Gryphon series (keyboard emulation mode)" },
    { 0x05f9220c, "Datalogic Gryphon GD4430" },
    { 0x05f92601, "Datalogic Magellan 1000i Barcode Scanner" },
    { 0x05f92602, "Datalogic Magellan 1100i Barcode Scanner" },
    { 0x05f94204, "Gryphon series (RS-232 emulation mode)" },
    { 0x05f95204, "Datalogic Gryphon GFS4170 (config mode)" },
    { 0x05fa3301, "Keyboard with PS/2 Mouse Port" },
    { 0x05fa3302, "Keyboard" },
    { 0x05fa3303, "Keyboard with PS/2 Mouse Port" },
    { 0x05fc0001, "Soundcraft Si Multi Digital Card" },
    { 0x05fc0010, "Soundcraft Si MADI combo card" },
    { 0x05fc7849, "Harman/Kardon SoundSticks" },
    { 0x05fd0239, "SV-239 HammerHead Digital" },
    { 0x05fd0251, "Raider Pro" },
    { 0x05fd0253, "ProPad 8 Digital" },
    { 0x05fd0286, "SV-286 Cyclone Digital" },
    { 0x05fd1007, "Mad Catz Controller" },
    { 0x05fd107a, "PowerPad Pro X-Box pad" },
    { 0x05fd262a, "3dfx HammerHead FX" },
    { 0x05fd262f, "HammerHead Fx" },
    { 0x05fddaae, "Game Shark" },
    { 0x05fddbae, "Datel XBoxMC" },
    { 0x05fe0001, "Mouse" },
    { 0x05fe0003, "Cypress USB Mouse" },
    { 0x05fe0005, "Viewmaster 4D Browser Mouse" },
    { 0x05fe0007, "Twinhead Mouse" },
    { 0x05fe0009, "Inland Pro 4500/5000 Mouse" },
    { 0x05fe0011, "Browser Mouse" },
    { 0x05fe0014, "Gamepad" },
    { 0x05fe1010, "Optical Wireless" },
    { 0x05fe2001, "Microsoft Wireless Receiver 700" },
    { 0x05fe3030, "Controller" },
    { 0x05fe3031, "Controller" },
    { 0x06010003, "Internet Security Co., Ltd. SecureKey" },
    { 0x06021001, "ViCam Webcam" },
    { 0x06030002, "Sino Wealth keyboard/mouse 2.4 GHz receiver" },
    { 0x060300f1, "Keyboard (Labtec Ultra Flat Keyboard)" },
    { 0x060300f2, "Keyboard (Labtec Ultra Flat Keyboard)" },
    { 0x06036871, "Mouse" },
    { 0x06038611, "NTK96550 based camera" },
    { 0x0609031d, "eHome Infrared Receiver" },
    { 0x06090322, "eHome Infrared Receiver" },
    { 0x06090334, "eHome Infrared Receiver" },
    { 0x0609ff12, "SMK Bluetooth Device" },
    { 0x060b0001, "MacAlly Keyboard" },
    { 0x060b0230, "KSK-8003 UX Keyboard" },
    { 0x060b0540, "DeltaCo TB-106U Keyboard" },
    { 0x060b1006, "Japanese Keyboard - 260U" },
    { 0x060b2101, "Keyboard" },
    { 0x060b2231, "KSK-6001 UELX Keyboard" },
    { 0x060b2270, "Gigabyte K8100 Aivia Gaming Keyboard" },
    { 0x060b500a, "Cougar 500k Gaming Keyboard" },
    { 0x060b5253, "Thermaltake MEKA G-Unit Gaming Keyboard" },
    { 0x060b5811, "ACK-571U Wireless Keyboard" },
    { 0x060b5903, "Japanese Keyboard - 595U" },
    { 0x060b6001, "SolidTek USB 2p HUB" },
    { 0x060b6002, "SolidTek USB Keyboard" },
    { 0x060b6003, "Japanese Keyboard - 600HM" },
    { 0x060b6231, "Thermaltake eSPORTS Meka Keyboard" },
    { 0x060b8007, "P-W1G1F12 VER:1 [Macally MegaCam]" },
    { 0x060ba001, "Maxwell Compact Pc PM3" },
    { 0x0617000a, "Thymio-II" },
    { 0x0617000c, "Thymio-II Wireless" },
    { 0x06180101, "Mouse" },
    { 0x06190101, "SLP-100 Driver" },
    { 0x06190102, "SLP-200 Driver" },
    { 0x06190103, "SLP-100N Driver" },
    { 0x06190104, "SLP-200N Driver" },
    { 0x06190105, "SLP-240 Driver" },
    { 0x06190501, "SLP-440 Driver" },
    { 0x06190502, "SLP-450 Driver" },
    { 0x061a0110, "5thSense Fingerprint Sensor" },
    { 0x061a0200, "FPS200 Fingerprint Sensor" },
    { 0x061a8200, "VKI-A Fingerprint Sensor/Flash Storage (dumb)" },
    { 0x061a9200, "VKI-B Fingerprint Sensor/Flash Storage (smart)" },
    { 0x061dc020, "SSU-100" },
    { 0x061e0001, "nissei 128DE-USB -" },
    { 0x061e0010, "nissei 128DE-PNA -" },
    { 0x06200004, "QuickVideo weeCam" },
    { 0x06200007, "QuickVideo weeCam" },
    { 0x0620000a, "QuickVideo weeCam" },
    { 0x0620000b, "QuickVideo weeCam" },
    { 0x06240013, "SC Secure KVM" },
    { 0x06240248, "Virtual Hub" },
    { 0x06240249, "Virtual Keyboard/Mouse" },
    { 0x06240251, "Virtual Mass Storage" },
    { 0x06240252, "Virtual SD card reader" },
    { 0x06240294, "Dell 03R874 KVM dongle" },
    { 0x06240402, "Cisco Virtual Keyboard and Mouse" },
    { 0x06240403, "Cisco Virtual Mass Storage" },
    { 0x06241774, "Cybex SC985" },
    { 0x062a0000, "Optical mouse" },
    { 0x062a0001, "Notebook Optical Mouse" },
    { 0x062a0020, "Logic3 Gamepad" },
    { 0x062a0033, "Competition Pro Steering Wheel" },
    { 0x062a0102, "Wireless Keyboard/Mouse Combo [MK1152WC]" },
    { 0x062a0201, "Defender Office Keyboard (K7310) S Zodiak KM-9010" },
    { 0x062a0252, "Emerge Uni-retractable Laser Mouse" },
    { 0x062a2410, "Wireless PS3 gamepad" },
    { 0x062a3286, "Nano Receiver [Sandstrom Laser Mouse SMWLL11]" },
    { 0x062a4101, "Wireless Keyboard/Mouse" },
    { 0x062a4102, "Wireless Mouse" },
    { 0x062a4106, "Wireless Mouse 2.4G" },
    { 0x062a4c01, "2,4Ghz Wireless Transceiver [for Delux M618 Plus Wireless Vertical Mouse]" },
    { 0x062a6301, "Trust Wireless Optical Mouse MI-4150K" },
    { 0x062a9003, "VoIP Conference Hub (A16GH)" },
    { 0x062a9004, "USR9602 USB Internet Mini Phone" },
    { 0x06340655, "Embedded Mass Storage Drive [RealSSD]" },
    { 0x06360003, "Vivicam 35Xx" },
    { 0x06380268, "iVina 1200U Scanner" },
    { 0x0638026a, "Minolta Dimage Scan Dual II AF-2820U (2886)" },
    { 0x06380a10, "iVina FB1600/UMAX Astra 4500" },
    { 0x06380a13, "AV600U" },
    { 0x06380a15, "Konica Minolta SC-110" },
    { 0x06380a16, "Konica Minolta SC-215" },
    { 0x06380a2a, "AV220 C2" },
    { 0x06380a30, "UMAX Astra 6700 Scanner" },
    { 0x06380a41, "Avision AM3000/MF3000 Series" },
    { 0x06380f01, "fi-4010CU" },
    { 0x06384004, "Minolta Dimage Scan Elite II AF-2920 (2888)" },
    { 0x06400026, "LPC-Stick" },
    { 0x06440000, "Floppy" },
    { 0x06440200, "All-In-One Multi-Card Reader CA200/B/S" },
    { 0x06441000, "CD-ROM Drive" },
    { 0x0644800d, "TASCAM Portastudio DP-01FX" },
    { 0x0644800e, "TASCAM US-122L" },
    { 0x0644801d, "TASCAM DR-100" },
    { 0x06448021, "TASCAM US-122mkII" },
    { 0x0644d001, "CD-R/RW Unit" },
    { 0x0644d002, "CD-R/RW Unit" },
    { 0x0644d010, "CD-RW/DVD Unit" },
    { 0x06470100, "ARC SpectraPro UV/VIS/IR Monochromator/Spectrograph" },
    { 0x06470101, "ARC AM-VM Mono Airpath/Vacuum Monochromator/Spectrograph" },
    { 0x06470102, "ARC Inspectrum Mono" },
    { 0x06470103, "ARC Filterwheel" },
    { 0x064703e9, "Inspectrum 128x1024 F VIS Spectrograph" },
    { 0x064703ea, "Inspectrum 256x1024 F VIS Spectrograph" },
    { 0x064703eb, "Inspectrum 128x1024 B VIS Spectrograph" },
    { 0x064703ec, "Inspectrum 256x1024 B VIS Spectrograph" },
    { 0x064b0165, "Blackfin 535 [ADZS HPUSB ICE]" },
    { 0x064e2100, "Sony Visual Communication Camera" },
    { 0x064e3410, "RGBIR Camera" },
    { 0x064e9700, "Asus Integrated Webcam" },
    { 0x064ea100, "Acer OrbiCam" },
    { 0x064ea101, "Acer CrystalEye Webcam" },
    { 0x064ea102, "Acer/Lenovo Webcam [CN0316]" },
    { 0x064ea103, "Acer/HP Integrated Webcam [CN0314]" },
    { 0x064ea110, "HP Webcam" },
    { 0x064ea114, "Lemote Webcam" },
    { 0x064ea116, "UVC 1.3MPixel WebCam" },
    { 0x064ea127, "HP Integrated Webcam" },
    { 0x064ea136, "Asus Integrated Webcam [CN031B]" },
    { 0x064ea219, "1.3M WebCam (notebook emachines E730, Acer sub-brand)" },
    { 0x064ec107, "HP webcam [dv6-1190en]" },
    { 0x064ec335, "HP TrueVision HD" },
    { 0x064ed101, "Acer CrystalEye Webcam" },
    { 0x064ed213, "UVC HD Webcam" },
    { 0x064ed217, "HP TrueVision HD" },
    { 0x064ee201, "Lenovo Integrated Webcam" },
    { 0x064ee203, "Lenovo Integrated Webcam" },
    { 0x064ee258, "HP TrueVision HD Integrated Webcam" },
    { 0x064ee263, "HP TrueVision HD Integrated Webcam" },
    { 0x064ef102, "Lenovo Integrated Webcam [R5U877]" },
    { 0x064ef103, "Lenovo Integrated Webcam [R5U877]" },
    { 0x064ef207, "Lenovo EasyCamera Integrated Webcam" },
    { 0x064ef209, "HP Webcam" },
    { 0x064ef300, "UVC 0.3M Webcam" },
    { 0x064f03e9, "CmStick (MSD, article no. 1001-xx-xxx)" },
    { 0x064f03f2, "CmStick/M (MSD, article no. 1010-xx-xxx)" },
    { 0x064f03f3, "CmStick/M (MSD, article no. 1011-xx-xxx)" },
    { 0x064f0bd7, "Wibu-Box/U (article no. 3031-xx-xxx)" },
    { 0x064f0bd8, "Wibu-Box/RU (article no. 3032-xx-xxx)" },
    { 0x064f2af9, "CmStick (HID, article no. 1001-xx-xxx)" },
    { 0x064f2b03, "CmStick/M (HID, article no. 1011-xx-xxx)" },
    { 0x064f5213, "CmStick/M (COMPOSITE, article no. 1011-xx-xxx)" },
    { 0x06540005, "Device Bay Controller" },
    { 0x06540006, "Hub" },
    { 0x06540007, "Device Bay Controller" },
    { 0x06540016, "Hub" },
    { 0x06580200, "Aeotec Z-Stick Gen5 (ZW090) - UZB" },
    { 0x065a0001, "Opticon OPR-2001 / NLV-1001 (keyboard mode)" },
    { 0x065a0009, "NLV-1001 (serial mode) / OPN-2001 [Opticon]" },
    { 0x06630103, "CobraPad" },
    { 0x06640301, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640302, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640303, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640304, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640305, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640306, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640307, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06640309, "Groovy Technology Corp. GTouch Touch Screen" },
    { 0x06655161, "USB to Serial" },
    { 0x06670fa1, "TD-U8000 Tape Drive" },
    { 0x066b0105, "SCM eUSB SmartMedia Card Reader" },
    { 0x066b010a, "Melco MCR-U2 SmartMedia / CompactFlash Reader" },
    { 0x066b200c, "USB10TX" },
    { 0x066b2202, "USB10TX Ethernet [pegasus]" },
    { 0x066b2203, "USB100TX Ethernet [pegasus]" },
    { 0x066b2204, "USB100TX HomePNA Ethernet [pegasus]" },
    { 0x066b2206, "USB Ethernet [pegasus]" },
    { 0x066b2207, "HomeLink Phoneline 10M Network Adapter" },
    { 0x066b2211, "WUSB11 802.11b Adapter" },
    { 0x066b2212, "WUSB11v2.5 802.11b Adapter" },
    { 0x066b2213, "WUSB12v1.1 802.11b Adapter" },
    { 0x066b2219, "Instant Wireless Network Adapter" },
    { 0x066b400b, "USB10TX" },
    { 0x066f003b, "MP3 Player" },
    { 0x066f003e, "MP3 Player" },
    { 0x066f003f, "MP3 Player" },
    { 0x066f0040, "MP3 Player" },
    { 0x066f0041, "MP3 Player" },
    { 0x066f0042, "MP3 Player" },
    { 0x066f0043, "MP3 Player" },
    { 0x066f004b, "A-Max PA11 MP3 Player" },
    { 0x066f3400, "STMP3400 D-Major MP3 Player" },
    { 0x066f3410, "STMP3410 D-Major MP3 Player" },
    { 0x066f3500, "Player Recovery Device" },
    { 0x066f3780, "STMP3780/i.MX23 SystemOnChip in RecoveryMode" },
    { 0x066f4200, "STIr4200 IrDA Bridge" },
    { 0x066f4210, "STIr4210 IrDA Bridge" },
    { 0x066f8000, "MSCN MP3 Player" },
    { 0x066f8001, "SigmaTel MSCN Audio Player" },
    { 0x066f8004, "MSCNMMC MP3 Player" },
    { 0x066f8008, "i-Bead 100 MP3 Player" },
    { 0x066f8020, "MP3 Player" },
    { 0x066f8034, "MP3 Player" },
    { 0x066f8036, "MP3 Player" },
    { 0x066f8038, "MP3 Player" },
    { 0x066f8056, "MP3 Player" },
    { 0x066f8060, "MP3 Player" },
    { 0x066f8066, "MP3 Player" },
    { 0x066f807e, "MP3 Player" },
    { 0x066f8092, "MP3 Player" },
    { 0x066f8096, "MP3 Player" },
    { 0x066f809a, "MP3 Player" },
    { 0x066f80aa, "MP3 Player" },
    { 0x066f80ac, "MP3 Player" },
    { 0x066f80b8, "MP3 Player" },
    { 0x066f80ba, "MP3 Player" },
    { 0x066f80bc, "MP3 Player" },
    { 0x066f80bf, "MP3 Player" },
    { 0x066f80c5, "MP3 Player" },
    { 0x066f80c8, "MP3 Player" },
    { 0x066f80ca, "MP3 Player" },
    { 0x066f80cc, "MP3 Player" },
    { 0x066f8104, "MP3 Player" },
    { 0x066f8106, "MP3 Player" },
    { 0x066f8108, "MP3 Player" },
    { 0x066f810a, "MP3 Player" },
    { 0x066f810c, "MP3 Player" },
    { 0x066f8122, "MP3 Player" },
    { 0x066f8124, "MP3 Player" },
    { 0x066f8126, "MP3 Player" },
    { 0x066f8128, "MP3 Player" },
    { 0x066f8134, "MP3 Player" },
    { 0x066f8136, "MP3 Player" },
    { 0x066f8138, "MP3 Player" },
    { 0x066f813a, "MP3 Player" },
    { 0x066f813e, "MP3 Player" },
    { 0x066f8140, "MP3 Player" },
    { 0x066f8142, "MP3 Player" },
    { 0x066f8144, "MP3 Player" },
    { 0x066f8146, "MP3 Player" },
    { 0x066f8148, "MP3 Player" },
    { 0x066f814c, "MP3 Player" },
    { 0x066f8201, "MP3 Player" },
    { 0x066f8202, "Jens of Sweden / I-BEAD 150M/150H MP3 player" },
    { 0x066f8203, "MP3 Player" },
    { 0x066f8204, "MP3 Player" },
    { 0x066f8205, "MP3 Player" },
    { 0x066f8206, "Digital MP3 Music Player" },
    { 0x066f8207, "MP3 Player" },
    { 0x066f8208, "MP3 Player" },
    { 0x066f8209, "MP3 Player" },
    { 0x066f820a, "MP3 Player" },
    { 0x066f820b, "MP3 Player" },
    { 0x066f820c, "MP3 Player" },
    { 0x066f820d, "MP3 Player" },
    { 0x066f820e, "MP3 Player" },
    { 0x066f820f, "MP3 Player" },
    { 0x066f8210, "MP3 Player" },
    { 0x066f8211, "MP3 Player" },
    { 0x066f8212, "MP3 Player" },
    { 0x066f8213, "MP3 Player" },
    { 0x066f8214, "MP3 Player" },
    { 0x066f8215, "MP3 Player" },
    { 0x066f8216, "MP3 Player" },
    { 0x066f8217, "MP3 Player" },
    { 0x066f8218, "MP3 Player" },
    { 0x066f8219, "MP3 Player" },
    { 0x066f821a, "MP3 Player" },
    { 0x066f821b, "MP3 Player" },
    { 0x066f821c, "MP3 Player" },
    { 0x066f821d, "MP3 Player" },
    { 0x066f821e, "MP3 Player" },
    { 0x066f821f, "MP3 Player" },
    { 0x066f8220, "MP3 Player" },
    { 0x066f8221, "MP3 Player" },
    { 0x066f8222, "MP3 Player" },
    { 0x066f8223, "MP3 Player" },
    { 0x066f8224, "MP3 Player" },
    { 0x066f8225, "MP3 Player" },
    { 0x066f8226, "MP3 Player" },
    { 0x066f8227, "MP3 Player" },
    { 0x066f8228, "MP3 Player" },
    { 0x066f8229, "MP3 Player" },
    { 0x066f8230, "MP3 Player" },
    { 0x066f829c, "MP3 Player" },
    { 0x066f82e0, "MP3 Player" },
    { 0x066f8320, "TrekStor i.Beat fun" },
    { 0x066f835d, "MP3 Player" },
    { 0x066f83b5, "Transcend T.sonic 530 MP3 Player" },
    { 0x066f842a, "TrekStor Vibez 8/12GB" },
    { 0x066f846c, "Maxfield G-Flash NG 1GB" },
    { 0x066f8550, "Medion MD8333" },
    { 0x066f8588, "Medion MD8333" },
    { 0x066f9000, "MP3 Player" },
    { 0x066f9001, "MP3 Player" },
    { 0x066f9002, "MP3 Player" },
    { 0x066fa010, "SigmaTel Inc. MTPMSCN Audio Player" },
    { 0x06700001, "Calibrator" },
    { 0x06700005, "Enable Cable" },
    { 0x06721041, "LCS1040 Speaker System" },
    { 0x06725000, "SpaceBall 4000 FLX" },
    { 0x06735000, "Keyboard" },
    { 0x06750110, "Vigor 128 ISDN TA" },
    { 0x06750530, "Vigor530 IEEE 802.11G Adapter (ISL3880+NET2280)" },
    { 0x06750550, "Vigor550" },
    { 0x06751688, "miniVigor 128 ISDN TA [HFC-S]" },
    { 0x06756694, "miniVigor 128 ISDN TA" },
    { 0x067707d5, "TM-ED1285(USB)" },
    { 0x06770fa1, "TD-U8000 Tape Drive" },
    { 0x067b0000, "PL2301 USB-USB Bridge" },
    { 0x067b0001, "PL2302 USB-USB Bridge" },
    { 0x067b0307, "Motorola Serial Adapter" },
    { 0x067b04bb, "PL2303 Serial (IODATA USB-RSAQ2)" },
    { 0x067b0600, "IDE Bridge" },
    { 0x067b0610, "Onext EG210U MODEM" },
    { 0x067b0611, "AlDiga AL-11U Quad-band GSM/GPRS/EDGE modem" },
    { 0x067b1231, "Orico SATA External Hard Disk Drive Lay-Flat Docking Station with USB 3.0 & eSATA interfaces." },
    { 0x067b2303, "PL2303 Serial Port / Mobile Action MA-8910P" },
    { 0x067b2305, "PL2305 Parallel Port" },
    { 0x067b2306, "Raylink Bridge Controller" },
    { 0x067b2307, "PL2307 USB-ATAPI4 Bridge" },
    { 0x067b2313, "FITEL PHS U Cable Adaptor" },
    { 0x067b2315, "Flash Disk Embedded Hub" },
    { 0x067b2316, "Flash Disk Security Device" },
    { 0x067b2317, "Mass Storage Device" },
    { 0x067b2501, "PL2501 USB-USB Bridge (USB 2.0)" },
    { 0x067b2506, "Kaser 8gB micro hard drive" },
    { 0x067b2507, "PL2507 Hi-speed USB to IDE bridge controller" },
    { 0x067b2515, "Flash Disk Embedded Hub" },
    { 0x067b2517, "Flash Disk Mass Storage Device" },
    { 0x067b2528, "Storage device (8gB thumb drive)" },
    { 0x067b2571, "LG Electronics GE24LU21" },
    { 0x067b25a1, "PL25A1 Host-Host Bridge" },
    { 0x067b2773, "PL2773 SATAII bridge controller" },
    { 0x067b3400, "Hi-Speed Flash Disk with TruePrint AES3400" },
    { 0x067b3500, "Hi-Speed Flash Disk with TruePrint AES3500" },
    { 0x067b3507, "PL3507 ATAPI6 Bridge" },
    { 0x067baaa0, "Prolific Pharos" },
    { 0x067baaa2, "PL2303 Serial Adapter (IODATA USB-RSAQ3)" },
    { 0x067baaa3, "PL2303x Serial Adapter" },
    { 0x067c1001, "Siemens SpeedStream 100MBps Ethernet" },
    { 0x067c1022, "Siemens SpeedStream 1022 802.11b Adapter" },
    { 0x067c1023, "SpeedStream Wireless" },
    { 0x067c4020, "SpeedStream 4020 ATM/ADSL Installer" },
    { 0x067c4031, "Efficient ADSL Modem" },
    { 0x067c4032, "SpeedStream 4031 ATM/ADSL Installer" },
    { 0x067c4033, "SpeedStream 4031 ATM/ADSL Installer" },
    { 0x067c4060, "Alcatel Speedstream 4060 ADSL Modem" },
    { 0x067c4062, "Efficient Networks 4060 Loader" },
    { 0x067c5667, "Efficient Networks Virtual Bus for ADSL Modem" },
    { 0x067cc031, "SpeedStream 4031 ATM/ADSL Installer" },
    { 0x067cc032, "SpeedStream 4031 ATM/ADSL Installer" },
    { 0x067cc033, "SpeedStream 4031 ATM/ADSL Installer" },
    { 0x067cc060, "SpeedStream 4060 Miniport ATM/ADSL Adapter" },
    { 0x067cd667, "Efficient Networks Virtual Bus for ADSL Modem" },
    { 0x067ce240, "Speedstream Ethernet Adapter E240" },
    { 0x067ce540, "Speedstream Ethernet Adapter E240" },
    { 0x067e0801, "HID Keyboard, Barcode scanner" },
    { 0x067e0803, "VCP, Barcode scanner" },
    { 0x067e0805, "VCP + UVC, Barcode scanner" },
    { 0x067e1001, "Mobile Computer" },
    { 0x067f4552, "DSL-200 ADSL Modem" },
    { 0x067f6542, "DSL Modem" },
    { 0x067f6549, "DSL Modem" },
    { 0x067f7541, "DSL Modem" },
    { 0x06800002, "Arowana Optical Wheel Mouse MSOP-01" },
    { 0x06810001, "Dect Base" },
    { 0x06810002, "Gigaset 3075 Passive ISDN" },
    { 0x06810005, "ID-Mouse with Fingerprint Reader" },
    { 0x06810012, "I-Gate 802.11b Adapter" },
    { 0x0681001b, "WLL013" },
    { 0x0681001d, "Hipath 1000" },
    { 0x06810022, "Gigaset SX353 ISDN" },
    { 0x06810026, "DECT Data - Gigaset M34" },
    { 0x0681002b, "A-100-I ADSL Modem" },
    { 0x0681002e, "ADSL Router_S-141" },
    { 0x06810034, "GSM module MC35/ES75 USB Modem" },
    { 0x06813c06, "54g USB Network Adapter" },
    { 0x06857000, "HSDPA Modem" },
    { 0x06862001, "PagePro 4110W" },
    { 0x06862004, "PagePro 1200W" },
    { 0x06862005, "Magicolor 2300 DL" },
    { 0x06863001, "PagePro 4100" },
    { 0x06863005, "PagePro 1250E" },
    { 0x06863006, "PagePro 1250W" },
    { 0x06863009, "Magicolor 2300W" },
    { 0x0686300b, "PagePro 1350W" },
    { 0x0686300c, "PagePro 1300W" },
    { 0x0686301b, "Develop D 1650iD" },
    { 0x06863023, "Develop D 2050iD" },
    { 0x0686302e, "Develop D 1650iD PCL" },
    { 0x06863034, "Develop D 2050iD PCL" },
    { 0x06864001, "Dimage 2300" },
    { 0x06864003, "Dimage 2330 Zoom Camera" },
    { 0x06864004, "Dimage Scan Elite II AF-2920 (2888)" },
    { 0x06864005, "Minolta DiMAGE E201 Mass Storage Device" },
    { 0x06864006, "Dimage 7 Camera" },
    { 0x06864007, "Dimage S304 Camera" },
    { 0x06864008, "Dimage 5 Camera" },
    { 0x06864009, "Dimage X Camera" },
    { 0x0686400a, "Dimage S404 Camera" },
    { 0x0686400b, "Dimage 7i Camera" },
    { 0x0686400c, "Dimage F100 Camera" },
    { 0x0686400d, "Dimage Scan Dual III AF-2840 (2889)" },
    { 0x0686400e, "Dimage Scan Elite 5400 (2890)" },
    { 0x0686400f, "Dimage 7Hi Camera" },
    { 0x06864010, "Dimage Xi Camera" },
    { 0x06864011, "Dimage F300 Camera" },
    { 0x06864012, "Dimage F200 Camera" },
    { 0x06864014, "Dimage S414 Camera" },
    { 0x06864015, "Dimage XT Camera [storage]" },
    { 0x06864016, "Dimage XT Camera [remote mode]" },
    { 0x06864017, "Dimage E223" },
    { 0x06864018, "Dimage Z1  Camera" },
    { 0x06864019, "Dimage A1 Camera [remote mode]" },
    { 0x0686401a, "Dimage A1 Camera [storage]" },
    { 0x0686401c, "Dimage X20 Camera" },
    { 0x0686401e, "Dimage E323 Camera" },
    { 0x068e00d3, "OEM 3 axis 5 button joystick" },
    { 0x068e00e2, "HFX OEM Joystick" },
    { 0x068e00f0, "Multi-Function Panel" },
    { 0x068e00f1, "Pro Throttle" },
    { 0x068e00f2, "Flight Sim Pedals" },
    { 0x068e00f3, "Fighterstick" },
    { 0x068e00f4, "Combatstick" },
    { 0x068e00fa, "Ch Throttle Quadrant" },
    { 0x068e00ff, "Flight Sim Yoke" },
    { 0x068e0500, "GameStick 3D" },
    { 0x068e0501, "CH Pro Pedals" },
    { 0x068e0504, "F-16 Combat Stick" },
    { 0x068fc00d, "MEK-6500" },
    { 0x06930002, "FlashGate SmartMedia Card Reader" },
    { 0x06930003, "FlashGate CompactFlash Card Reader" },
    { 0x06930005, "FlashGate" },
    { 0x06930006, "SM PCCard R/W and SPD" },
    { 0x06930007, "FlashGate ME (Authenticated)" },
    { 0x0693000a, "SDCard/MMC Reader/Writer" },
    { 0x06940001, "Mindstorms Tower" },
    { 0x06940002, "Mindstorms NXT" },
    { 0x06940005, "Mindstorms EV3" },
    { 0x06940006, "Mindstorms EV3 Firmware Update" },
    { 0x06981786, "1300ex Monitor" },
    { 0x06982003, "CTX M730V built in Camera" },
    { 0x06989999, "VLxxxx Monitor+Hub" },
    { 0x06990347, "AFG 3022B" },
    { 0x06990365, "TDS 2004B" },
    { 0x0699036a, "TDS 2024B" },
    { 0x069a0001, "VC010 Webcam [pwc]" },
    { 0x069a0303, "Cable Modem" },
    { 0x069a0311, "ADSL Router Remote NDIS Device" },
    { 0x069a0318, "Remote NDIS Device" },
    { 0x069a0319, "220V Remote NDIS Device" },
    { 0x069a0320, "IEEE 802.11b Wireless LAN Card" },
    { 0x069a0321, "Dynalink WLL013 / Compex WLU11A 802.11b Adapter" },
    { 0x069a0402, "Scientific Atlanta WebSTAR 100 & 200 series Cable Modem" },
    { 0x069a0811, "BT Virtual Bus for Helium" },
    { 0x069a0821, "BT Voyager 1010 802.11b Adapter" },
    { 0x069a4402, "Scientific Atlanta WebSTAR 2000 series Cable Modem" },
    { 0x069a4403, "Scientific Atlanta WebSTAR 300 series Cable Modem" },
    { 0x069a4501, "Scientific-Atlanta WebSTAR 2000 series Cable Modem" },
    { 0x069b0704, "DCM245 Cable Modem" },
    { 0x069b0705, "THG540K Cable Modem" },
    { 0x069b0709, "Lyra PDP2424" },
    { 0x069b070c, "MP3 Player" },
    { 0x069b070d, "MP3 Player" },
    { 0x069b070e, "MP3 Player" },
    { 0x069b070f, "RCA Lyra RD1071 MP3 Player" },
    { 0x069b0731, "Lyra M200E256" },
    { 0x069b0761, "RCA H100A" },
    { 0x069b0774, "Thomson EM28 Series" },
    { 0x069b0777, "Thomson / RCA Opal / Lyra MC4002" },
    { 0x069b0778, "PEARL USB Device" },
    { 0x069b077c, "Thomson Lyra MC5104B (M51 Series)" },
    { 0x069b2220, "RCA Kazoo RD1000 MP3 Player" },
    { 0x069b300a, "RCA Lyra MP3 Player" },
    { 0x069b3012, "MP3 Player" },
    { 0x069b3013, "MP3 Player" },
    { 0x069b301a, "Thomson RCA H106" },
    { 0x069b3028, "Thomson scenium E308" },
    { 0x069b3035, "Thomson / RCA Lyra HC308A" },
    { 0x069b5557, "RCA CDS6300" },
    { 0x069d0001, "Satellite Receiver Device" },
    { 0x069d0002, "Satellite Device" },
    { 0x069e0005, "Marx CryptoBox v1.2" },
    { 0x069f0010, "Tornado Speakerphone FaxModem 56.0" },
    { 0x069f0011, "Tornado Speakerphone FaxModem 56.0" },
    { 0x069f1000, "ADT VvBus for CopperJet" },
    { 0x069f1004, "CopperJet 821 RouterPlus" },
    { 0x06a20033, "USB Mouse" },
    { 0x06a30006, "Cyborg Gold Joystick" },
    { 0x06a30109, "P880 Pad" },
    { 0x06a30160, "ST290 Pro" },
    { 0x06a30200, "Racing Wheel" },
    { 0x06a30201, "Adrenalin Gamepad" },
    { 0x06a30241, "Xbox Adrenalin Gamepad" },
    { 0x06a30255, "X52 Flight Controller" },
    { 0x06a3040b, "P990 Dual Analog Pad" },
    { 0x06a3040c, "P2900 Wireless Pad" },
    { 0x06a30422, "ST90 Joystick" },
    { 0x06a30460, "ST290 Pro Flight Stick" },
    { 0x06a30463, "ST290" },
    { 0x06a30464, "Cyborg Evo" },
    { 0x06a30471, "Cyborg Graphite Stick" },
    { 0x06a30501, "R100 Sports Wheel" },
    { 0x06a30502, "ST200 Stick" },
    { 0x06a30506, "R220 Digital Wheel" },
    { 0x06a3051e, "Cyborg Digital II Stick" },
    { 0x06a3052d, "P750 Gamepad" },
    { 0x06a3053c, "X45 Flight Controller" },
    { 0x06a3053f, "X36F Flightstick" },
    { 0x06a3056c, "P2000 Tilt Pad" },
    { 0x06a3056f, "P2000 Tilt Pad" },
    { 0x06a305d2, "PC Dash 2" },
    { 0x06a3075c, "X52 Flight Controller" },
    { 0x06a30762, "Saitek X52 Pro Flight Control System" },
    { 0x06a30763, "Pro Flight Rudder Pedals" },
    { 0x06a30764, "Flight Pro Combat Rudder" },
    { 0x06a30805, "R440 Force Wheel" },
    { 0x06a30b4e, "Pro Flight Backlit Information Panel" },
    { 0x06a30bac, "Pro Flight Yoke" },
    { 0x06a30c2d, "Pro Flight Quadrant" },
    { 0x06a30d05, "Pro Flight Radio Panel" },
    { 0x06a30d06, "Flight Pro Multi Panel" },
    { 0x06a30d67, "Pro Flight Switch Panel" },
    { 0x06a31003, "GM2 Action Pad" },
    { 0x06a31009, "Action Pad" },
    { 0x06a3100a, "SP550 Pad and Joystick Combo" },
    { 0x06a3100b, "SP550 Pad" },
    { 0x06a31509, "P3000 Wireless Pad" },
    { 0x06a31589, "P3000 Wireless Pad" },
    { 0x06a32541, "X45 Flight Controller" },
    { 0x06a33509, "P3000 RF GamePad" },
    { 0x06a3353e, "Cyborg Evo Wireless" },
    { 0x06a33589, "P3000 Wireless Pad" },
    { 0x06a335be, "Cyborg Evo" },
    { 0x06a35509, "P3000 Wireless Pad" },
    { 0x06a3712c, "Pro Flight Yoke integrated hub" },
    { 0x06a38000, "Gamers' Keyboard" },
    { 0x06a3801e, "Cyborg 3D Digital Stick II" },
    { 0x06a38020, "Eclipse Keyboard" },
    { 0x06a38021, "Eclipse II Keyboard" },
    { 0x06a3802d, "P750 Pad" },
    { 0x06a3803f, "X36 Flight Controller" },
    { 0x06a3806f, "P2000 Tilt Pad" },
    { 0x06a380c0, "Pro Gamer Command Unit" },
    { 0x06a380c1, "Cyborg Command Pad Unit" },
    { 0x06a3a2ae, "Pro Flight Instrument Panel" },
    { 0x06a3a502, "Gaming Mouse" },
    { 0x06a3f518, "P3200 Rumble Force Game Pad" },
    { 0x06a3f51a, "P3600" },
    { 0x06a3ff04, "R440 Force Wheel" },
    { 0x06a3ff0c, "Cyborg Force Rumble Pad" },
    { 0x06a3ff0d, "P2600 Rumble Force Pad" },
    { 0x06a3ff12, "Cyborg 3D Force Stick" },
    { 0x06a3ff17, "ST 330 Rumble Force Stick" },
    { 0x06a3ff52, "Cyborg 3D Rumble Force Joystick" },
    { 0x06a3ffb5, "Cyborg Evo Force Joystick" },
    { 0x06a50000, "Typhoon Webcam 100k [nw8000]" },
    { 0x06a5d001, "ProLink DS3303u Webcam" },
    { 0x06a5d800, "Chicony TwinkleCam" },
    { 0x06a5d820, "Wize Media 1000" },
    { 0x06a80042, "SignatureGem 1X5 Pad" },
    { 0x06a80043, "SignatureGem 1X5-HID Pad" },
    { 0x06a90005, "WireSpeed Dual Connect Modem" },
    { 0x06a90006, "WireSpeed Dual Connect Modem" },
    { 0x06a9000a, "WireSpeed Dual Connect Modem" },
    { 0x06a9000b, "WireSpeed Dual Connect Modem" },
    { 0x06a9000e, "A90-211WG-01 802.11g Adapter [Intersil ISL3887]" },
    { 0x06b90120, "SpeedTouch 120g 802.11g Wireless Adapter [Intersil ISL3886]" },
    { 0x06b90121, "SpeedTouch 121g Wireless Dongle" },
    { 0x06b92001, "SPEED TOUCH Card" },
    { 0x06b94061, "SpeedTouch ISDN or ADSL Modem" },
    { 0x06b94062, "SpeedTouch ISDN or ADSL router" },
    { 0x06b9a5a5, "DynaMiTe Modem" },
    { 0x06bc000b, "Okipage 14ex Printer" },
    { 0x06bc0027, "Okipage 14e" },
    { 0x06bc00f7, "OKI B4600 Mono Printer" },
    { 0x06bc015e, "OKIPOS 411/412 POS Printer" },
    { 0x06bc01c9, "OKI B430 Mono Printer" },
    { 0x06bc020b, "OKI ES4140 Mono Printer" },
    { 0x06bc02bb, "OKI PT390 POS Printer" },
    { 0x06bc0383, "MC563 Multifunction Printer" },
    { 0x06bc0a91, "B2500MFP (printer+scanner)" },
    { 0x06bc3801, "B6100 Laser Printer" },
    { 0x06bd0001, "SnapScan 1212U" },
    { 0x06bd0002, "SnapScan 1236U" },
    { 0x06bd0100, "SnapScan Touch" },
    { 0x06bd0101, "SNAPSCAN ELITE" },
    { 0x06bd0200, "ScanMaker 8700" },
    { 0x06bd02bf, "DUOSCAN f40" },
    { 0x06bd0400, "CL30" },
    { 0x06bd0401, "Mass Storage" },
    { 0x06bd0403, "ePhoto CL18 Camera" },
    { 0x06bd0404, "ePhoto CL20 Camera" },
    { 0x06bd2061, "SnapScan 1212U (?)" },
    { 0x06bd208d, "Snapscan e40" },
    { 0x06bd208f, "SnapScan e50" },
    { 0x06bd2091, "SnapScan e20" },
    { 0x06bd2093, "SnapScan e10" },
    { 0x06bd2095, "SnapScan e25" },
    { 0x06bd2097, "SnapScan e26" },
    { 0x06bd20fd, "SnapScan e52" },
    { 0x06bd20ff, "SnapScan e42" },
    { 0x06be0800, "Optimedia Camera" },
    { 0x06be1005, "Dazzle DPVM! (1005)" },
    { 0x06bed001, "P35U Camera Capture" },
    { 0x06c20030, "PhidgetRFID" },
    { 0x06c20031, "RFID reader" },
    { 0x06c20038, "4-Motor PhidgetServo v3.0" },
    { 0x06c20039, "1-Motor PhidgetServo v3.0" },
    { 0x06c2003a, "8-Motor PhidgetAvancedServo" },
    { 0x06c20040, "PhidgetInterface Kit 0-0-4" },
    { 0x06c20044, "PhidgetInterface Kit 0-16-16" },
    { 0x06c20045, "PhidgetInterface Kit 8-8-8" },
    { 0x06c20048, "PhidgetStepper (Under Development)" },
    { 0x06c20049, "PhidgetTextLED Ver 1.0" },
    { 0x06c2004a, "PhidgetLED Ver 1.0" },
    { 0x06c2004b, "PhidgetEncoder Ver 1.0" },
    { 0x06c20051, "PhidgetInterface Kit 0-5-7 (Custom)" },
    { 0x06c20052, "PhidgetTextLCD" },
    { 0x06c20053, "PhidgetInterfaceKit 0-8-8" },
    { 0x06c20058, "PhidgetMotorControl Ver 1.0" },
    { 0x06c20070, "PhidgetTemperatureSensor Ver 1.0" },
    { 0x06c20071, "PhidgetAccelerometer Ver 1.0" },
    { 0x06c20072, "PhidgetWeightSensor Ver 1.0" },
    { 0x06c20073, "PhidgetHumiditySensor" },
    { 0x06c20074, "PhidgetPHSensor" },
    { 0x06c20075, "PhidgetGyroscope" },
    { 0x06c90005, "Monitor Control" },
    { 0x06c90007, "Monitor Control" },
    { 0x06c90009, "Monitor Control" },
    { 0x06ca2003, "uSCSI" },
    { 0x06cb0001, "TouchPad" },
    { 0x06cb0002, "Integrated TouchPad" },
    { 0x06cb0003, "cPad" },
    { 0x06cb0005, "Touchpad/FPS" },
    { 0x06cb0006, "TouchScreen" },
    { 0x06cb0007, "USB Styk" },
    { 0x06cb0008, "WheelPad" },
    { 0x06cb0009, "Composite TouchPad and TrackPoint" },
    { 0x06cb000e, "HID Device" },
    { 0x06cb0010, "Wireless TouchPad" },
    { 0x06cb0013, "DisplayPad" },
    { 0x06cb009a, "Metallica MIS Touch Fingerprint Reader" },
    { 0x06cb00a2, "Metallica MOH Touch Fingerprint Reader" },
    { 0x06cb00bd, "Prometheus MIS Touch Fingerprint Reader" },
    { 0x06cb2970, "touchpad" },
    { 0x06cc0101, "Cable Modem" },
    { 0x06cc0102, "Cable Modem" },
    { 0x06cc0103, "Cable Modem" },
    { 0x06cc0104, "Cable Modem" },
    { 0x06cc0304, "Cable Modem" },
    { 0x06cd0101, "USA-28 PDA [no firmware]" },
    { 0x06cd0102, "USA-28X PDA [no firmware]" },
    { 0x06cd0103, "USA-19 PDA [no firmware]" },
    { 0x06cd0104, "PDA [prerenum]" },
    { 0x06cd0105, "USA-18X PDA [no firmware]" },
    { 0x06cd0106, "USA-19W PDA [no firmware]" },
    { 0x06cd0107, "USA-19 PDA" },
    { 0x06cd0108, "USA-19W PDA" },
    { 0x06cd0109, "USA-49W serial adapter [no firmware]" },
    { 0x06cd010a, "USA-49W serial adapter" },
    { 0x06cd010b, "USA-19Qi serial adapter [no firmware]" },
    { 0x06cd010c, "USA-19Qi serial adapter" },
    { 0x06cd010d, "USA-19Q serial Adapter (no firmware)" },
    { 0x06cd010e, "USA-19Q serial Adapter" },
    { 0x06cd010f, "USA-28 PDA" },
    { 0x06cd0110, "USA-28Xb PDA" },
    { 0x06cd0111, "USA-18 serial Adapter" },
    { 0x06cd0112, "USA-18X PDA" },
    { 0x06cd0113, "USA-28Xb PDA [no firmware]" },
    { 0x06cd0114, "USA-28Xa PDA [no firmware]" },
    { 0x06cd0115, "USA-28Xa PDA" },
    { 0x06cd0116, "USA-18XA serial Adapter (no firmware)" },
    { 0x06cd0117, "USA-18XA serial Adapter" },
    { 0x06cd0118, "USA-19QW PDA [no firmware]" },
    { 0x06cd0119, "USA-19QW PDA" },
    { 0x06cd011a, "USA-49Wlc serial adapter [no firmware]" },
    { 0x06cd011b, "MPR Serial Preloader (MPRQI)" },
    { 0x06cd011c, "MPR Serial (MPRQI)" },
    { 0x06cd011d, "MPR Serial Preloader (MPRQ)" },
    { 0x06cd011e, "MPR Serial (MPRQ)" },
    { 0x06cd0121, "USA-19hs serial adapter" },
    { 0x06cd012a, "USA-49Wlc serial adapter" },
    { 0x06cd0201, "UIA-10 Digital Media Remote [Cypress AN2131SC]" },
    { 0x06cd0202, "UIA-11 Digital Media Remote" },
    { 0x06ce8311, "COM-1(USB)H" },
    { 0x06cf1010, "PanoCam 10" },
    { 0x06cf1012, "PanoCam 12/12X" },
    { 0x06d00622, "LapLink Gold USB-USB Bridge [net1080]" },
    { 0x06d30284, "FX-USB-AW/-BD RS482 Converters" },
    { 0x06d30380, "CP8000D Port" },
    { 0x06d30381, "CP770D Port" },
    { 0x06d30385, "CP900D Port" },
    { 0x06d30387, "CP980D Port" },
    { 0x06d3038b, "CP3020D Port" },
    { 0x06d3038c, "CP900DW(ID) Port" },
    { 0x06d30393, "CP9500D/DW Port" },
    { 0x06d30394, "CP9000D/DW Port" },
    { 0x06d30398, "P93D" },
    { 0x06d303a1, "CP9550D/DW Port" },
    { 0x06d303a5, "CP9550DW-S" },
    { 0x06d303a9, "CP-9600DW" },
    { 0x06d303aa, "CP3020DA" },
    { 0x06d303ad, "CP-9800D/DW" },
    { 0x06d303ae, "CP-9800DW-S" },
    { 0x06d30f10, "Hori/Namco FlightStick 2" },
    { 0x06d321ba, "FOMA D905i" },
    { 0x06d33b10, "P95D" },
    { 0x06d33b21, "CP-9810D/DW" },
    { 0x06d33b30, "CP-D70DW / CP-D707DW" },
    { 0x06d33b31, "CP-K60DW-S" },
    { 0x06d33b36, "CP-D80DW" },
    { 0x06d33b50, "CP-W5000DW" },
    { 0x06d33b60, "CP-D90DW" },
    { 0x06d33b80, "CP-M1" },
    { 0x06d54000, "Japanese Keyboard" },
    { 0x06d60025, "Gamepad" },
    { 0x06d60026, "Predator TH 400 Gamepad" },
    { 0x06d6002d, "Trust PowerC@m 350FT" },
    { 0x06d6002e, "Trust PowerC@m 350FS" },
    { 0x06d60030, "Trust 710 LCD POWERC@M ZOOM - MSD" },
    { 0x06d60031, "Trust 610/710 LCD POWERC@M ZOOM" },
    { 0x06d6003a, "Trust PowerC@m 770Z (mass storage mode)" },
    { 0x06d6003b, "Trust PowerC@m 770Z (webcam mode)" },
    { 0x06d6003c, "Trust 910z PowerC@m" },
    { 0x06d6003f, "Trust 735S POWERC@M ZOOM, WDM DSC Bulk Driver" },
    { 0x06d60050, "Trust 738AV LCD PV Digital Camera" },
    { 0x06d60062, "TRUST 782AV LCD P. V. Video Capture" },
    { 0x06d60066, "TRUST Digital PCTV and Movie Editor" },
    { 0x06d60067, "Trust 350FS POWERC@M FLASH" },
    { 0x06d6006b, "TRUST AUDIO VIDEO EDITOR" },
    { 0x06da0002, "UPS" },
    { 0x06da0003, "1300VA UPS" },
    { 0x06dc0012, "Scan 1200c Scanner" },
    { 0x06dc0014, "Prolink Winscan Pro 2448U" },
    { 0x06e00319, "MT9234ZBA-USB MultiModem ZBA" },
    { 0x06e0f101, "MT5634ZBA-USB MultiModemUSB (old firmware)" },
    { 0x06e0f103, "MT5634MU MultiMobileUSB" },
    { 0x06e0f104, "MT5634ZBA-USB MultiModemUSB (new firmware)" },
    { 0x06e0f107, "MT5634ZBA-USB-V92 MultiModemUSB" },
    { 0x06e0f120, "MT9234ZBA-USB-CDC-ACM-XR MultiModem ZBA CDC-ACM-XR" },
    { 0x06e10008, "UBS-10BT Ethernet [klsi]" },
    { 0x06e10009, "UBS-10BT Ethernet" },
    { 0x06e10833, "Mass Storage Device" },
    { 0x06e1a155, "FM Radio Receiver/Instant FM Music (RDX-155-EF)" },
    { 0x06e1a160, "Instant Video-To-Go RDX-160 (no firmware)" },
    { 0x06e1a161, "Instant Video-To-Go RDX-160" },
    { 0x06e1a190, "Instand VCD Capture" },
    { 0x06e1a191, "Instant VideoXpress" },
    { 0x06e1a337, "Mini DigitalTV" },
    { 0x06e1a701, "DVD Xpress" },
    { 0x06e1a708, "saa7114H video input card (Instant VideoMPX)" },
    { 0x06e1b337, "Mini DigitalTV" },
    { 0x06e1b701, "DVD Xpress B" },
    { 0x06e60200, "Internet Phone" },
    { 0x06e60201, "Internet Phone" },
    { 0x06e60202, "Composite Device" },
    { 0x06e60203, "Internet Phone" },
    { 0x06e60210, "Composite Device" },
    { 0x06e60211, "Internet Phone" },
    { 0x06e60212, "Internet Phone" },
    { 0x06e6031c, "Internet Phone" },
    { 0x06e6031d, "Internet Phone" },
    { 0x06e6031e, "Internet Phone" },
    { 0x06e63200, "Composite Device" },
    { 0x06e63201, "Internet Phone" },
    { 0x06e63202, "Composite Device" },
    { 0x06e63203, "Composite Device" },
    { 0x06e67200, "Composite Device" },
    { 0x06e67210, "Composite Device" },
    { 0x06e67250, "Composite Device" },
    { 0x06e6825c, "Internet Phone" },
    { 0x06e6831c, "Internet Phone" },
    { 0x06e6831d, "Composite Device" },
    { 0x06e6831e, "Composite Device" },
    { 0x06e6b200, "Composite Device" },
    { 0x06e6b201, "Composite Device" },
    { 0x06e6b202, "Internet Phone" },
    { 0x06e6b210, "Internet Phone" },
    { 0x06e6b211, "Composite Device" },
    { 0x06e6b212, "Composite Device" },
    { 0x06e6b250, "Composite Device" },
    { 0x06e6b251, "Internet Phone" },
    { 0x06e6b252, "Internet Phone" },
    { 0x06e6c200, "Internet Phone" },
    { 0x06e6c201, "Internet Phone" },
    { 0x06e6c202, "Composite Device" },
    { 0x06e6c203, "Internet Phone" },
    { 0x06e6c210, "Personal PhoneGateway" },
    { 0x06e6c211, "Personal PhoneGateway" },
    { 0x06e6c212, "Personal PhoneGateway" },
    { 0x06e6c213, "PPG Device" },
    { 0x06e6c25c, "Composite Device" },
    { 0x06e6c290, "PPG Device" },
    { 0x06e6c291, "PPG Device" },
    { 0x06e6c292, "PPG Device" },
    { 0x06e6c293, "Personal PhoneGateway" },
    { 0x06e6c31c, "Composite Device" },
    { 0x06e6c39c, "Personal PhoneGateway" },
    { 0x06e6c39d, "PPG Device" },
    { 0x06e6c39e, "PPG Device" },
    { 0x06e6c39f, "PPG Device" },
    { 0x06e6c700, "Internet Phone" },
    { 0x06e6c701, "Internet Phone" },
    { 0x06e6c702, "Composite Device" },
    { 0x06e6c703, "Internet Phone" },
    { 0x06e6c710, "VoIP Combo Device" },
    { 0x06e6c711, "VoIP Combo" },
    { 0x06e6c712, "VoIP Combo Device" },
    { 0x06e6c713, "VoIP Combo Device" },
    { 0x06e6cf00, "Composite Device" },
    { 0x06e6cf01, "Internet Phone" },
    { 0x06e6cf02, "Internet Phone" },
    { 0x06e6cf03, "Composite Device" },
    { 0x06e6d210, "Personal PhoneGateway" },
    { 0x06e6d211, "PPG Device" },
    { 0x06e6d212, "PPG Device" },
    { 0x06e6d213, "Personal PhoneGateway" },
    { 0x06e6d700, "Composite Device" },
    { 0x06e6d701, "Composite Device" },
    { 0x06e6d702, "Internet Phone" },
    { 0x06e6d703, "Composite Device" },
    { 0x06e6d710, "VoIP Combo" },
    { 0x06e6d711, "VoIP Combo Device" },
    { 0x06e6d712, "VoIP Combo" },
    { 0x06e6d713, "VoIP Combo" },
    { 0x06e6df00, "Composite Device" },
    { 0x06e6df01, "Composite Device" },
    { 0x06e6df02, "Internet Phone" },
    { 0x06e6df03, "Internet Phone" },
    { 0x06e6f200, "Internet Phone" },
    { 0x06e6f201, "Internet Phone" },
    { 0x06e6f202, "Composite Device" },
    { 0x06e6f203, "Composite Device" },
    { 0x06e6f210, "Internet Phone" },
    { 0x06e6f250, "Composite Device" },
    { 0x06e6f252, "Internet Phone" },
    { 0x06e6f310, "Internet Phone" },
    { 0x06e6f350, "Composite Device" },
    { 0x06ea0001, "NetCom Roadster II 56k" },
    { 0x06ea0002, "Roadster II 56k" },
    { 0x06f0de01, "DualCam Video Camera" },
    { 0x06f0de02, "DualCam Still Camera" },
    { 0x06f1a011, "SonicPort" },
    { 0x06f1a021, "SonicPort Optical" },
    { 0x06f20011, "KVM Switch Keyboard" },
    { 0x06f70003, "USB->Din 4 Adaptor" },
    { 0x06f83002, "Hercules Blog Webcam" },
    { 0x06f83004, "Hercules Classic Silver" },
    { 0x06f83005, "Hercules Dualpix Exchange" },
    { 0x06f83007, "Hercules Dualpix Chat and Show" },
    { 0x06f83020, "Hercules Webcam EC300" },
    { 0x06f8a300, "Dual Analog Leader GamePad" },
    { 0x06f8b000, "Hercules DJ Console" },
    { 0x06f8b121, "Hercules P32 DJ" },
    { 0x06f8c000, "Hercules Muse Pocket" },
    { 0x06f8d002, "Hercules DJ Console" },
    { 0x06f8e000, "HWGUSB2-54 WLAN" },
    { 0x06f8e010, "HWGUSB2-54-LB" },
    { 0x06f8e020, "HWGUSB2-54V2-AP" },
    { 0x06f8e031, "Hercules HWNUm-300 Wireless N mini [Realtek RTL8191SU]" },
    { 0x06f8e032, "HWGUm-54 [Hercules Wireless G Ultra Mini Key]" },
    { 0x06f8e033, "Hercules HWNUp-150 802.11n Wireless N Pico [Realtek RTL8188CUS]" },
    { 0x06fd0101, "Audio Device" },
    { 0x06fd0102, "Audio Device" },
    { 0x06fd0201, "2-piece Audio Device" },
    { 0x07070100, "2202 Ethernet [klsi]" },
    { 0x07070200, "2202 Ethernet [pegasus]" },
    { 0x07070201, "EZ Connect USB Ethernet" },
    { 0x0707ee04, "SMCWUSB32 802.11b Wireless LAN Card" },
    { 0x0707ee06, "SMC2862W-G v1 EZ Connect 802.11g Adapter [Intersil ISL3886]" },
    { 0x0707ee13, "SMC2862W-G v2 EZ Connect 802.11g Adapter [Intersil ISL3887]" },
    { 0x0708047e, "USB-1284 BRIDGE" },
    { 0x070a4002, "Bluetooth Device" },
    { 0x070a4003, "Bluetooth Device" },
    { 0x07100001, "WhiteHeat (fake ID)" },
    { 0x07108001, "WhiteHeat" },
    { 0x07110100, "Hub" },
    { 0x07110180, "IRXpress Infrared Device" },
    { 0x07110181, "IRXpress Infrared Device" },
    { 0x07110200, "BAY-3U1S1P Serial Port" },
    { 0x07110210, "MCT1S Serial Port" },
    { 0x07110230, "MCT-232 Serial Port" },
    { 0x07110231, "PS/2 Mouse Port" },
    { 0x07110232, "Serial On Port" },
    { 0x07110240, "PS/2 to USB Converter" },
    { 0x07110260, "PS/2 Keyboard and Mouse" },
    { 0x07110300, "BAY-3U1S1P Parallel Port" },
    { 0x07110302, "Parallel Port" },
    { 0x07110900, "SVGA Adapter" },
    { 0x07115001, "Trigger UV-002BD[Startech USBVGAE]" },
    { 0x07115100, "Magic Control Technology Corp. (USB2VGA dongle)" },
    { 0x07140003, "ADB converter" },
    { 0x07180002, "SuperDisk 120MB" },
    { 0x07180003, "SuperDisk 120MB (Authenticated)" },
    { 0x07180060, "Flash Drive" },
    { 0x07180061, "Flash Drive" },
    { 0x07180062, "Flash Drive" },
    { 0x07180063, "Swivel Flash Drive" },
    { 0x07180064, "Flash Drive" },
    { 0x07180065, "Flash Drive" },
    { 0x07180066, "Flash Drive" },
    { 0x07180067, "Flash Drive" },
    { 0x07180068, "Flash Drive" },
    { 0x07180084, "Flash Drive Mini" },
    { 0x0718043c, "Flash drive 16GB [Nano Pro]" },
    { 0x07180582, "Revo Flash Drive" },
    { 0x07180622, "TDK Trans-It 4GB" },
    { 0x07180624, "TDK Trans-It 16GB" },
    { 0x07181120, "RDX External dock (redbud)" },
    { 0x07184006, "8x Slim DVD Multi-Format Recorder External" },
    { 0x0718d000, "Disc Stakka CD/DVD Manager" },
    { 0x071b0002, "DTI-56362-USB Digital Interface Unit" },
    { 0x071b0101, "Audio4-USB DSP Data Acquisition Unit" },
    { 0x071b0184, "Archos 2 8GB EM184RB" },
    { 0x071b0201, "Audio4-5410 DSP Data Acquisition Unit" },
    { 0x071b0301, "SB-USB JTAG Emulator" },
    { 0x071b3203, "Rockchip Media Player" },
    { 0x071b32bb, "Music Mediatouch" },
    { 0x071d1000, "Diva 2.01 S/T [PSB2115F]" },
    { 0x071d1003, "Diva ISDN 2.0" },
    { 0x071d1005, "Diva ISDN 4.0 [HFC-S]" },
    { 0x071d2000, "Teledat Surf" },
    { 0x07208001, "LJ-V7001" },
    { 0x07230002, "Palladia 300/400 Adsl Modem" },
    { 0x07291000, "USC-1000 Serial Port" },
    { 0x072f0001, "AC1030-based SmartCard Reader" },
    { 0x072f0008, "ACR 80 Smart Card Reader" },
    { 0x072f0100, "AET65" },
    { 0x072f0101, "AET65" },
    { 0x072f0102, "AET62" },
    { 0x072f0103, "AET62" },
    { 0x072f0901, "ACR1281U-C4 (BSI)" },
    { 0x072f1000, "PLDT Drive" },
    { 0x072f1001, "PLDT Drive" },
    { 0x072f2011, "ACR88U" },
    { 0x072f2100, "ACR128U" },
    { 0x072f2200, "ACR122U" },
    { 0x072f220a, "ACR1281U-C5 (BSI)" },
    { 0x072f220c, "ACR1283 Bootloader" },
    { 0x072f220f, "ACR1281U-C2 (qPBOC)" },
    { 0x072f2211, "ACR1261 1S Dual Reader" },
    { 0x072f2214, "ACR1222 1SAM PICC Reader" },
    { 0x072f2215, "ACR1281 2S CL Reader" },
    { 0x072f221a, "ACR1251U-A1" },
    { 0x072f221b, "ACR1251U-C" },
    { 0x072f2224, "ACR1281 1S Dual Reader" },
    { 0x072f222b, "ACR1222U-C8" },
    { 0x072f222c, "ACR1283L-D2" },
    { 0x072f222d, "[OEM Reader]" },
    { 0x072f222e, "ACR123U" },
    { 0x072f2242, "ACR1251 1S Dual Reader" },
    { 0x072f8002, "AET63 BioTRUSTKey" },
    { 0x072f8003, "ACR120" },
    { 0x072f8103, "ACR120" },
    { 0x072f8201, "APG8201" },
    { 0x072f8900, "ACR89U-A1" },
    { 0x072f8901, "ACR89U-A2" },
    { 0x072f8902, "ACR89U-A3" },
    { 0x072f9000, "ACR38 AC1038-based Smart Card Reader" },
    { 0x072f9006, "CryptoMate" },
    { 0x072f90cc, "ACR38 SmartCard Reader" },
    { 0x072f90ce, "[OEM Reader]" },
    { 0x072f90cf, "ACR38 SAM Smart Card Reader" },
    { 0x072f90d0, "PertoSmart EMV - Card Reader" },
    { 0x072f90d2, "ACR83U" },
    { 0x072f90d8, "ACR3801" },
    { 0x072f90db, "CryptoMate64" },
    { 0x072fb000, "ACR3901U" },
    { 0x072fb100, "ACR39U" },
    { 0x072fb101, "ACR39K" },
    { 0x072fb102, "ACR39T" },
    { 0x072fb103, "ACR39F" },
    { 0x072fb104, "ACR39U-SAM" },
    { 0x072fb106, "ACOS5T2" },
    { 0x072fb200, "ACOS5T1" },
    { 0x072fb301, "ACR32-A1" },
    { 0x07310528, "SonyEricsson DCU-11 Cable" },
    { 0x07330101, "Digital Video Camera" },
    { 0x07330110, "VQ110 Video Camera" },
    { 0x07330401, "CS330 Webcam" },
    { 0x07330402, "M-318B Webcam" },
    { 0x07330430, "Intel Pro Share Webcam" },
    { 0x07330630, "VQ630 Dual Mode Digital Camera(Bulk)" },
    { 0x07330631, "Hercules Dualpix" },
    { 0x07330780, "Smart Cam Deluxe(composite)" },
    { 0x07331310, "Epsilon 1.3/Jenoptik JD C1.3/UMAX AstraPix 470 (mass storage mode)" },
    { 0x07331311, "Epsilon 1.3/Jenoptik JD C1.3/UMAX AstraPix 470 (PC Cam mode)" },
    { 0x07331314, "Mercury 2.1MEG Deluxe Classic Cam" },
    { 0x07332211, "Jenoptik jdc 21 LCD Camera" },
    { 0x07332221, "Mercury Digital Pro 3.1p" },
    { 0x07333261, "Concord 3045 spca536a Camera" },
    { 0x07333281, "Cyberpix S550V" },
    { 0x07340001, "560V Modem" },
    { 0x07340002, "Lasat 560V Modem" },
    { 0x0734043a, "DVS Audio" },
    { 0x0734043b, "3DeMon USB Capture" },
    { 0x07352100, "ISDN Adapter" },
    { 0x07352101, "ISDN Adapter" },
    { 0x07356694, "ISDNlink 128K" },
    { 0x0735c541, "ISDN TA 280" },
    { 0x07382215, "X-55 Rhino Stick" },
    { 0x07382237, "V.1 Stick" },
    { 0x07384506, "Wireless Controller" },
    { 0x07384507, "XBox Device" },
    { 0x07384516, "Control Pad" },
    { 0x07384520, "Control Pad Pro" },
    { 0x07384522, "LumiCON" },
    { 0x07384526, "Control Pad Pro" },
    { 0x07384530, "Universal MC2 Racing Wheel and Pedals" },
    { 0x07384536, "MicroCON" },
    { 0x07384540, "Beat Pad" },
    { 0x07384556, "Lynx Wireless Controller" },
    { 0x07384566, "XBox Device" },
    { 0x07384576, "XBox Device" },
    { 0x07384586, "MicroCON Wireless Controller" },
    { 0x07384588, "Blaster" },
    { 0x073845ff, "Beat Pad" },
    { 0x07384716, "Wired Xbox 360 Controller" },
    { 0x07384718, "Street Fighter IV FightStick SE for Xbox 360" },
    { 0x07384726, "Xbox 360 Controller" },
    { 0x07384728, "Street Fighter IV FightPad for Xbox 360" },
    { 0x07384730, "MC2 Racing Wheel for Xbox 360" },
    { 0x07384736, "MicroCON for Xbox 360" },
    { 0x07384738, "Street Fighter IV Wired Controller for Xbox 360" },
    { 0x07384740, "Beat Pad for Xbox 360" },
    { 0x07384743, "Beat Pad Pro" },
    { 0x07384758, "Arcade Game Stick" },
    { 0x07384a01, "FightStick TE 2 for Xbox One" },
    { 0x07386040, "Beat Pad Pro" },
    { 0x07388818, "Street Fighter IV Arcade FightStick (PS3)" },
    { 0x07389871, "Portable Drum Kit" },
    { 0x0738a109, "S.T.R.I.K.E.7 Keyboard" },
    { 0x0738a215, "X-55 Rhino Throttle" },
    { 0x0738b726, "Modern Warfare 2 Controller for Xbox 360" },
    { 0x0738b738, "Marvel VS Capcom 2 TE FightStick for Xbox 360" },
    { 0x0738beef, "Joytech Neo SE Advanced Gamepad" },
    { 0x0738cb02, "Saitek Cyborg Rumble Pad" },
    { 0x0738cb03, "Saitek P3200 Rumble Pad" },
    { 0x0738cb29, "Saitek Aviator Stick AV8R02" },
    { 0x0738f738, "Super Street Fighter IV FightStick TE S for Xbox 360" },
    { 0x073a2230, "infrared dongle for remote" },
    { 0x073c0305, "Pole Display (PC305-3415  2 x 20 Line Display)" },
    { 0x073c0322, "Pole Display (PC322-3415  2 x 20 Line Display)" },
    { 0x073c0324, "Pole Display (LB324-USB   4 x 20 Line Display)" },
    { 0x073c0330, "Pole Display (P330-3415   2 x 20 Line Display)" },
    { 0x073c0424, "Pole Display (SP324-4415  4 x 20 Line Display)" },
    { 0x073c0450, "Pole Display (L450-USB   Graphic Line Display)" },
    { 0x073c0505, "Pole Display (SPC505-3415 2 x 20 Line Display)" },
    { 0x073c0522, "Pole Display (SPC522-3415 2 x 20 Line Display)" },
    { 0x073c0624, "Pole Display (SP324-3415  4 x 20 Line Display)" },
    { 0x073d0000, "SmartKey" },
    { 0x073d0005, "Crypto Token" },
    { 0x073d0007, "CryptoIdentity CCID" },
    { 0x073d0025, "SmartKey 3" },
    { 0x073d0c00, "Pocket Reader" },
    { 0x073d0d00, "StarSign Bio Token 3.0 EU" },
    { 0x073e0301, "Game Pad" },
    { 0x07422008, "ISDN TA [HFC-S]" },
    { 0x07422009, "ISDN TA [HFC-S]" },
    { 0x0742200a, "ISDN TA [HFC-S]" },
    { 0x07464700, "Integra MZA-4.7" },
    { 0x07465500, "SE-U55 Audio Device" },
    { 0x074d3553, "Composite USB-Device" },
    { 0x074d3554, "Composite USB-Device" },
    { 0x074d3556, "Composite USB-Device" },
    { 0x074e0001, "PS/2 Adapter" },
    { 0x074e0002, "PS/2 Adapter" },
    { 0x07570a00, "SUN Adapter" },
    { 0x075b0001, "Kick-off! Watchdog" },
    { 0x07630115, "O2 / KeyRig 25" },
    { 0x07630117, "Trigger Finger" },
    { 0x07630119, "MidAir" },
    { 0x07630150, "M-Audio Uno" },
    { 0x07630160, "M-Audio 1x1" },
    { 0x07630192, "M-Audio Keystation 88es" },
    { 0x07630193, "ProKeys 88" },
    { 0x07630194, "ProKeys 88sx" },
    { 0x07630195, "Oxygen 8 v2" },
    { 0x07630196, "Oxygen 49" },
    { 0x07630197, "Oxygen 61" },
    { 0x07630198, "Axiom 25" },
    { 0x07630199, "Axiom 49" },
    { 0x0763019a, "Axiom 61" },
    { 0x0763019b, "KeyRig 49" },
    { 0x0763019c, "KeyStudio" },
    { 0x07631001, "MidiSport 2x2" },
    { 0x07631002, "MidiSport 2x2" },
    { 0x07631003, "MidiSport 2x2" },
    { 0x07631010, "MidiSport 1x1" },
    { 0x07631011, "MidiSport 1x1" },
    { 0x07631014, "M-Audio Keystation Loader" },
    { 0x07631015, "M-Audio Keystation" },
    { 0x07631020, "Midisport 4x4" },
    { 0x07631021, "MidiSport 4x4" },
    { 0x07631030, "M-Audio MIDISPORT 8x8" },
    { 0x07631031, "MidiSport 8x8/s Loader" },
    { 0x07631033, "MidiSport 8x8/s" },
    { 0x07631040, "M-Audio MidiSport 2x4 Loader" },
    { 0x07631041, "M-Audio MidiSport 2x4" },
    { 0x07631110, "MidiSport 1x1" },
    { 0x07632001, "M Audio Quattro" },
    { 0x07632002, "M Audio Duo" },
    { 0x07632003, "M Audio AudioPhile" },
    { 0x07632004, "M-Audio MobilePre" },
    { 0x07632006, "M-Audio Transit" },
    { 0x07632007, "M-Audio Sonica Theater" },
    { 0x07632008, "M-Audio Ozone" },
    { 0x0763200d, "M-Audio OmniStudio" },
    { 0x0763200f, "M-Audio MobilePre" },
    { 0x07632010, "M-Audio Fast Track" },
    { 0x07632012, "M-Audio Fast Track Pro" },
    { 0x07632013, "M-Audio JamLab" },
    { 0x07632015, "M-Audio RunTime DFU" },
    { 0x07632016, "M-Audio RunTime DFU" },
    { 0x07632019, "M-Audio Ozone Academic" },
    { 0x0763201a, "M-Audio Micro" },
    { 0x0763201b, "M-Audio RunTime DFU" },
    { 0x0763201d, "M-Audio Producer" },
    { 0x07632024, "M-Audio Fast Track MKII" },
    { 0x07632080, "M-Audio Fast Track Ultra" },
    { 0x07632081, "M-Audio RunTime DFU / Fast Track Ultra 8R" },
    { 0x07632803, "M-Audio Audiophile DFU" },
    { 0x07632804, "M-Audio MobilePre DFU" },
    { 0x07632806, "M-Audio Transit DFU" },
    { 0x07632815, "M-Audio DFU" },
    { 0x07632816, "M-Audio DFU" },
    { 0x0763281b, "M-Audio DFU" },
    { 0x07632880, "M-Audio DFU" },
    { 0x07632881, "M-Audio DFU" },
    { 0x07640005, "Cyber Power UPS" },
    { 0x07640501, "CP1500 AVR UPS" },
    { 0x07640601, "PR1500LCDRT2U UPS" },
    { 0x07655001, "Huey PRO Colorimeter" },
    { 0x07655010, "X-Rite Pantone Color Sensor" },
    { 0x07655020, "i1 Display Pro" },
    { 0x07656003, "ColorMunki Smile" },
    { 0x0765d094, "X-Rite DTP94 [Quato Silver Haze Pro]" },
    { 0x07660017, "Packard Bell Carbon" },
    { 0x0766001b, "Packard Bell Go" },
    { 0x07660204, "TopSpeed Cyberlink Remote Control" },
    { 0x07680006, "Camtel Technology USB TV Genie Pro FM Model TVB330" },
    { 0x07680023, "eHome Infrared Receiver" },
    { 0x076911f2, "EP-9001-g 802.11g 54M WLAN Adapter" },
    { 0x076911f3, "RT2570" },
    { 0x076911f7, "802.11g 54M WLAN Adapter" },
    { 0x076931f3, "RT2573" },
    { 0x076b0596, "CardMan 2020" },
    { 0x076b1021, "CardMan 1021" },
    { 0x076b1221, "CardMan 1221" },
    { 0x076b1784, "CardMan 6020" },
    { 0x076b3021, "CardMan 3021 / 3121" },
    { 0x076b3022, "CardMan 3121 (HID Technologies)" },
    { 0x076b3610, "CardMan 3620" },
    { 0x076b3621, "CardMan 3621" },
    { 0x076b3821, "CardMan 3821" },
    { 0x076b4321, "CardMan 4321" },
    { 0x076b5121, "CardMan 5121" },
    { 0x076b5125, "CardMan 5125" },
    { 0x076b5321, "CardMan 5321" },
    { 0x076b5340, "CardMan 5021 CL" },
    { 0x076b6622, "CardMan 6121" },
    { 0x076ba011, "CCID Smart Card Reader Keyboard" },
    { 0x076ba021, "CCID Smart Card Reader" },
    { 0x076ba022, "CardMan Smart@Link" },
    { 0x076bc000, "CardMan 3x21 CS" },
    { 0x076bc001, "CardMan 5121 CS" },
    { 0x076c0204, "CD7220 Communications Port" },
    { 0x076c0302, "RP-600" },
    { 0x07714455, "OMC45III" },
    { 0x0771ae0f, "OMC45III" },
    { 0x07790133, "FUSB307B" },
    { 0x07790134, "FUSB308B" },
    { 0x077b08be, "BEFCMU10 v4 Cable Modem" },
    { 0x077b2219, "WUSB11 V2.6 802.11b Adapter" },
    { 0x077b2226, "USB200M 100baseTX Adapter" },
    { 0x077b2227, "Network Everywhere NWU11B" },
    { 0x077c0005, "NEC Keyboard" },
    { 0x077d0223, "IMic Audio In/Out" },
    { 0x077d0405, "iMate, ADB Adapter" },
    { 0x077d0410, "PowerMate" },
    { 0x077d041a, "PowerWave" },
    { 0x077d04aa, "SoundKnob" },
    { 0x077d07af, "iMic" },
    { 0x077d1016, "AirClick" },
    { 0x077d627a, "Radio SHARK" },
    { 0x077e008a, "NetLink Compact MPI/Profibus adapter" },
    { 0x077e0160, "EDICblue" },
    { 0x077e0220, "VAS5054A" },
    { 0x07801202, "ORGA 900 Smart Card Terminal Virtual Com Port" },
    { 0x07801302, "ORGA 6000 Smart Card Terminal Virtual Com Port" },
    { 0x07801303, "ORGA 6000 Smart Card Terminal USB RNDIS" },
    { 0x0780df55, "ORGA 900/6000 Smart Card Terminal DFU" },
    { 0x07810001, "SDDR-05a ImageMate CompactFlash Reader" },
    { 0x07810002, "SDDR-31 ImageMate II CompactFlash Reader" },
    { 0x07810005, "SDDR-05b (CF II) ImageMate CompactFlash Reader" },
    { 0x07810100, "ImageMate SDDR-12" },
    { 0x07810200, "SDDR-09 (SSFDC) ImageMate SmartMedia Reader [eusb]" },
    { 0x07810400, "SecureMate SD/MMC Reader" },
    { 0x07810621, "SDDR-86 Imagemate 6-in-1 Reader" },
    { 0x07810720, "Sansa C200 series in recovery mode" },
    { 0x07810729, "Sansa E200 series in recovery mode" },
    { 0x07810810, "SDDR-75 ImageMate CF-SM Reader" },
    { 0x07810830, "ImageMate CF/MMC/SD Reader" },
    { 0x07811234, "Cruzer Mini Flash Drive" },
    { 0x07815150, "SDCZ2 Cruzer Mini Flash Drive (thin)" },
    { 0x07815151, "Cruzer Micro Flash Drive" },
    { 0x07815153, "Cruzer Flash Drive" },
    { 0x07815204, "Cruzer Crossfire" },
    { 0x07815402, "U3 Cruzer Micro" },
    { 0x07815406, "Cruzer Micro U3" },
    { 0x07815408, "Cruzer Titanium U3" },
    { 0x0781540e, "Cruzer Contour Flash Drive" },
    { 0x07815530, "Cruzer" },
    { 0x07815567, "Cruzer Blade" },
    { 0x0781556b, "Cruzer Edge" },
    { 0x0781556c, "Ultra" },
    { 0x0781556d, "Memory Vault" },
    { 0x07815571, "Cruzer Fit" },
    { 0x07815575, "Cruzer Glide" },
    { 0x07815576, "Cruzer Facet" },
    { 0x07815577, "Cruzer Pop (8GB)" },
    { 0x0781557d, "Cruzer Force" },
    { 0x07815580, "SDCZ80 Flash Drive" },
    { 0x07815581, "Ultra" },
    { 0x07815583, "Ultra Fit" },
    { 0x07815588, "Extreme Pro" },
    { 0x07815589, "SD8SB8U512G[Extreme 500]" },
    { 0x0781558c, "Extreme Portable SSD" },
    { 0x07815590, "Ultra Dual" },
    { 0x07815591, "Ultra Flair" },
    { 0x07815e10, "Encrypted" },
    { 0x07816100, "Ultra II SD Plus 2GB" },
    { 0x07816500, "uSSD 5000" },
    { 0x07817100, "Cruzer Mini" },
    { 0x07817101, "Pen Flash" },
    { 0x07817102, "Cruzer Mini" },
    { 0x07817103, "Cruzer Mini" },
    { 0x07817104, "Cruzer Micro Mini 256MB Flash Drive" },
    { 0x07817105, "Cruzer Mini" },
    { 0x07817106, "Cruzer Mini" },
    { 0x07817112, "Cruzer Micro 128MB Flash Drive" },
    { 0x07817113, "Cruzer Micro 256MB Flash Drive" },
    { 0x07817114, "Cruzer Mini" },
    { 0x07817115, "Cruzer Mini" },
    { 0x07817301, "Sansa e100 series (mtp)" },
    { 0x07817302, "Sansa e100 series (msc)" },
    { 0x07817400, "SanDisk Sansa m230/m240" },
    { 0x07817401, "SanDisk Sansa m200-tcc (MTP mode)" },
    { 0x07817410, "SanDisk Sansa c150" },
    { 0x07817420, "SanDisk Sansa e200/e250/e260/e270/e280" },
    { 0x07817421, "Sansa E200 Series (msc)" },
    { 0x07817422, "SanDisk Sansa e260/e280 v2" },
    { 0x07817423, "Sansa E200 series v2 (msc)" },
    { 0x07817430, "SanDisk Sansa m240/m250" },
    { 0x07817431, "Sansa M200 series V4 (msc)" },
    { 0x07817432, "SanDisk Sansa Clip" },
    { 0x07817433, "Sansa Clip (msc)" },
    { 0x07817434, "SanDisk Sansa Clip v2" },
    { 0x07817435, "Sansa Clip V2 (msc)" },
    { 0x07817450, "SanDisk Sansa c240/c250" },
    { 0x07817451, "Sansa C240" },
    { 0x07817452, "SanDisk Sansa c250 v2" },
    { 0x07817460, "SanDisk Sansa Express" },
    { 0x07817480, "SanDisk Sansa Connect" },
    { 0x07817481, "Sansa Connect (in recovery mode)" },
    { 0x078174b0, "SanDisk Sansa View" },
    { 0x078174b1, "Sansa View (mtp)" },
    { 0x078174c0, "SanDisk Sansa Fuze" },
    { 0x078174c1, "Sansa Fuze (msc)" },
    { 0x078174c2, "SanDisk Sansa Fuze v2" },
    { 0x078174c3, "Sansa Fuze V2 (msc)" },
    { 0x078174d0, "SanDisk Sansa Clip+" },
    { 0x078174d1, "Sansa Clip+ (msc)" },
    { 0x078174e0, "SanDisk Sansa Fuze+" },
    { 0x078174e4, "SanDisk Sansa Clip Zip" },
    { 0x078174e5, "Sansa Clip Zip" },
    { 0x07818181, "Pen Flash" },
    { 0x07818183, "Hi-Speed Mass Storage Device" },
    { 0x07818185, "SDCZ2 Cruzer Mini Flash Drive (older, thick)" },
    { 0x07818888, "Card Reader" },
    { 0x07818889, "SDDR-88 Imagemate 8-in-1 Reader" },
    { 0x07818919, "Card Reader" },
    { 0x07818989, "ImageMate 12-in-1 Reader" },
    { 0x07819191, "ImageMate CF" },
    { 0x07819219, "Card Reader" },
    { 0x07819292, "ImageMate CF Reader/Writer" },
    { 0x07819393, "ImageMate SD-MMC" },
    { 0x07819595, "ImageMate xD-SM" },
    { 0x07819797, "ImageMate MS-PRO" },
    { 0x07819919, "Card Reader" },
    { 0x07819999, "SDDR-99 5-in-1 Reader" },
    { 0x0781a7c1, "Storage device (SD card reader)" },
    { 0x0781a7e8, "SDDR-113 MicroMate SDHC Reader" },
    { 0x0781b2b3, "SDDR-103 MobileMate SD+ Reader" },
    { 0x0781b2b5, "SDDR-104 MobileMate SD+ Reader" },
    { 0x0781b4b5, "SDDR-89 V4 ImageMate 12-in-1 Reader" },
    { 0x0781b6b7, "SDDR-99 V4 ImageMate 5-in-1 Reader" },
    { 0x0781b6ba, "CF SDDR-289" },
    { 0x0781cfc9, "SDDR-489 ImageMate Pro Reader" },
    { 0x07830003, "LTC31 SmartCard Reader" },
    { 0x07830006, "LTC31v2" },
    { 0x07830009, "KBR36" },
    { 0x07830010, "LTC32" },
    { 0x07840100, "Vivicam 2655" },
    { 0x07841310, "Vivicam 3305" },
    { 0x07841688, "Vivicam 3665" },
    { 0x07841689, "Gateway DC-M42/Labtec DC-505/Vivitar Vivicam 3705" },
    { 0x07842620, "AOL Photocam Plus" },
    { 0x07842888, "Polaroid DC700" },
    { 0x07843330, "Nytec ND-3200 Camera" },
    { 0x07844300, "Traveler D1" },
    { 0x07845260, "Werlisa Sport PX 100 / JVC GC-A33 Camera" },
    { 0x07845300, "Pretec dc530" },
    { 0x07850001, "MN128mini-V ISDN TA" },
    { 0x07850003, "MN128mini-J ISDN TA" },
    { 0x07890026, "LHD Device" },
    { 0x07890033, "DVD Multi-plus unit LDR-H443SU2" },
    { 0x07890063, "LDR Device" },
    { 0x07890064, "LDR-R Device" },
    { 0x078900b3, "DVD Multi-plus unit LDR-H443U2" },
    { 0x078900cc, "LHD Device" },
    { 0x07890105, "LAN-TX/U1H2 10/100 Ethernet Adapter [pegasus II]" },
    { 0x0789010c, "Realtek RTL8187 Wireless 802.11g 54Mbps Network Adapter" },
    { 0x07890160, "LAN-GTJ/U2A" },
    { 0x07890162, "LAN-WN22/U2 Wireless LAN Adapter" },
    { 0x07890163, "LAN-WN12/U2 Wireless LAN Adapter" },
    { 0x07890164, "LAN-W150/U2M Wireless LAN Adapter" },
    { 0x07890166, "LAN-W300N/U2 Wireless LAN Adapter" },
    { 0x07890168, "LAN-W150N/U2 Wireless LAN Adapter" },
    { 0x07890170, "LAN-W300AN/U2 Wireless LAN Adapter" },
    { 0x078b0010, "Driving UGCI" },
    { 0x078b0020, "Flying UGCI" },
    { 0x078b0030, "Fighting UGCI" },
    { 0x078c0090, "Tablet Adapter" },
    { 0x078c0100, "Tablet Adapter" },
    { 0x078c0200, "Tablet Adapter" },
    { 0x078c0300, "Tablet Adapter" },
    { 0x078c0400, "Digitizer (Whiteboard)" },
    { 0x07976801, "Flatbed Scanner" },
    { 0x07976802, "InkJet Color Printer" },
    { 0x07978001, "SmartCam" },
    { 0x0797801a, "Typhoon StyloCam" },
    { 0x0797801c, "Meade Binoculars/Camera" },
    { 0x07978901, "ScanHex SX-35a" },
    { 0x07978909, "ScanHex SX-35b" },
    { 0x07978911, "ScanHex SX-35c" },
    { 0x07980001, "Braille Voyager" },
    { 0x07980640, "BC640" },
    { 0x07980680, "BC680" },
    { 0x07997651, "Programming Unit" },
    { 0x079b0024, "MSO300/MSO301 Fingerprint Sensor" },
    { 0x079b0026, "MSO350/MSO351 Fingerprint Sensor & SmartCard Reader" },
    { 0x079b0027, "USB-Serial Controller" },
    { 0x079b002f, "Mobile" },
    { 0x079b0030, "Mobile Communication Device" },
    { 0x079b0042, "Mobile" },
    { 0x079b0047, "CBM/MSO1300 Fingerprint Sensor" },
    { 0x079b004a, "XG-760A 802.11bg" },
    { 0x079b004b, "Wi-Fi 11g adapter" },
    { 0x079b0052, "MSO1350 Fingerprint Sensor & SmartCard Reader" },
    { 0x079b0056, "Agfa AP1100 Photo Printer" },
    { 0x079b005d, "Mobile Mass Storage" },
    { 0x079b0062, "XG-76NA 802.11bg" },
    { 0x079b0078, "Laser Pro Monochrome MFP" },
    { 0x079d0201, "GamePort Adapter" },
    { 0x07a1d952, "Palladio USB V.92 Modem" },
    { 0x07a607c2, "AN986A Ethernet" },
    { 0x07a60986, "AN986 Pegasus Ethernet" },
    { 0x07a68266, "Infineon WildCard-USB Wireless LAN Adapter" },
    { 0x07a68511, "ADM8511 Pegasus II Ethernet" },
    { 0x07a68513, "ADM8513 Pegasus II Ethernet" },
    { 0x07a68515, "ADM8515 Pegasus II Ethernet" },
    { 0x07aa0001, "Ether USB-T Ethernet [klsi]" },
    { 0x07aa0004, "FEther USB-TX Ethernet [pegasus]" },
    { 0x07aa000c, "WirelessLAN USB-11" },
    { 0x07aa000d, "FEther USB-TXS" },
    { 0x07aa0011, "Wireless LAN USB-11 mini" },
    { 0x07aa0012, "Stick-11 802.11b Adapter" },
    { 0x07aa0017, "FEther USB2-TX" },
    { 0x07aa0018, "Wireless LAN USB-11 mini 2" },
    { 0x07aa001a, "ULUSB-11 Key" },
    { 0x07aa001c, "CG-WLUSB2GT 802.11g Wireless Adapter [Intersil ISL3880]" },
    { 0x07aa0020, "CG-WLUSB2GTST 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x07aa002e, "CG-WLUSB2GPX [Ralink RT2571W]" },
    { 0x07aa002f, "CG-WLUSB2GNL" },
    { 0x07aa0031, "CG-WLUSB2GS 802.11bg [Atheros AR5523]" },
    { 0x07aa003c, "CG-WLUSB2GNL" },
    { 0x07aa003f, "CG-WLUSB300AGN" },
    { 0x07aa0041, "CG-WLUSB300GNS" },
    { 0x07aa0042, "CG-WLUSB300GNM" },
    { 0x07aa0043, "CG-WLUSB300N rev A2 [Realtek RTL8192U]" },
    { 0x07aa0047, "CG-WLUSBNM" },
    { 0x07aa0051, "CG-WLUSB300NM" },
    { 0x07aa7613, "Stick-11 V2 802.11b Adapter" },
    { 0x07aa9601, "FEther USB-TXC" },
    { 0x07abfc01, "IDE bridge" },
    { 0x07abfc02, "Cable II USB-2" },
    { 0x07abfc03, "USB2-IDE IDE bridge" },
    { 0x07abfc77, "Quattro 3.0" },
    { 0x07abfcd6, "Freecom HD Classic" },
    { 0x07abfcf6, "DataBar" },
    { 0x07abfcf8, "Freecom Classic SL Network Drive" },
    { 0x07abfcfe, "Hard Drive 80GB" },
    { 0x07af0004, "SCSI-DB25 SCSI Bridge [shuttle]" },
    { 0x07af0005, "SCSI-HD50 SCSI Bridge [shuttle]" },
    { 0x07af0006, "CameraMate SmartMedia and CompactFlash Card Reader [eusb/shuttle]" },
    { 0x07affc01, "Freecom USB-IDE" },
    { 0x07b00001, "ISDN TA" },
    { 0x07b00002, "ISDN TA128 Plus" },
    { 0x07b00003, "ISDN TA128 Deluxe" },
    { 0x07b00005, "ISDN TA128 SE" },
    { 0x07b00006, "ISDN TA 128 [HFC-S]" },
    { 0x07b00007, "ISDN TA [HFC-S]" },
    { 0x07b00008, "ISDN TA" },
    { 0x07b20100, "SURFboard Voice over IP Cable Modem" },
    { 0x07b20900, "SURFboard Gateway" },
    { 0x07b20950, "SURFboard SBG950 Gateway" },
    { 0x07b21000, "SURFboard SBG1000 Gateway" },
    { 0x07b24100, "SurfBoard SB4100 Cable Modem" },
    { 0x07b24200, "SurfBoard SB4200 Cable Modem" },
    { 0x07b24210, "SurfBoard 4210 Cable Modem" },
    { 0x07b24220, "SURFboard SB4220 Cable Modem" },
    { 0x07b24500, "CG4500 Communications Gateway" },
    { 0x07b2450b, "CG4501 Communications Gateway" },
    { 0x07b2450e, "CG4500E Communications Gateway" },
    { 0x07b25100, "SurfBoard SB5100 Cable Modem" },
    { 0x07b25101, "SurfBoard SB5101 Cable Modem" },
    { 0x07b25120, "SurfBoard SB5120 Cable Modem (RNDIS)" },
    { 0x07b25121, "Surfboard 5121 Cable Modem" },
    { 0x07b26002, "MTR7000 Cable Tuning Adapter" },
    { 0x07b27030, "WU830G 802.11bg Wireless Adapter [Envara WiND512]" },
    { 0x07b30001, "OpticPro 1212U Scanner" },
    { 0x07b30003, "Scanner" },
    { 0x07b30010, "OpticPro U12 Scanner" },
    { 0x07b30011, "OpticPro U24 Scanner" },
    { 0x07b30013, "OpticPro UT12 Scanner" },
    { 0x07b30014, "Scanner" },
    { 0x07b30015, "OpticPro U24 Scanner" },
    { 0x07b30017, "OpticPro UT12/16/24 Scanner" },
    { 0x07b30204, "Scanner" },
    { 0x07b30400, "OpticPro 1248U Scanner" },
    { 0x07b30401, "OpticPro 1248U Scanner #2" },
    { 0x07b30403, "OpticPro U16B Scanner" },
    { 0x07b30404, "Scanner" },
    { 0x07b30405, "A8 Namecard-s Controller" },
    { 0x07b30406, "A8 Namecard-D Controller" },
    { 0x07b30410, "Scanner" },
    { 0x07b30412, "Scanner" },
    { 0x07b30413, "OpticSlim 1200 Scanner" },
    { 0x07b30601, "OpticPro ST24 Scanner" },
    { 0x07b30800, "OpticPro ST48 Scanner" },
    { 0x07b30807, "OpticFilm 7200 scanner" },
    { 0x07b30900, "OpticBook 3600 Scanner" },
    { 0x07b3090c, "OpticBook 3600 Plus Scanner" },
    { 0x07b30a06, "TVcam VD100" },
    { 0x07b30b00, "SmartPhoto F50" },
    { 0x07b30c00, "OpticPro ST64 Scanner" },
    { 0x07b30c03, "OpticPro ST64+ Scanner" },
    { 0x07b30c04, "Optic Film 7200i scanner" },
    { 0x07b30c0c, "PL806 Scanner" },
    { 0x07b30c26, "OpticBook 4600 Scanner" },
    { 0x07b30c2b, "Mobile Office D428 Scanner" },
    { 0x07b30e08, "OpticBook A300 Scanner" },
    { 0x07b31300, "OpticBook 3800 Scanner" },
    { 0x07b31301, "OpticBook 4800 Scanner" },
    { 0x07b3130f, "Bookreader v200" },
    { 0x07b40100, "Camedia C-2100/C-3000 Ultra Zoom Camera" },
    { 0x07b40102, "Olympus E-1" },
    { 0x07b40105, "Camedia C-310Z/C-700/C-750UZ/C-755/C-765UZ/C-3040/C-4000/C-5050Z/D-560/C-3020Z Zoom Camera" },
    { 0x07b40109, "Olympus X-925" },
    { 0x07b4010a, "MAUSB-10 xD and SmartMedia Card Reader" },
    { 0x07b40110, "Olympus E-410" },
    { 0x07b40112, "MAUSB-100 xD Card Reader" },
    { 0x07b40113, "Olympus mju 500" },
    { 0x07b40114, "Olympus IR-300" },
    { 0x07b40116, "Olympus X925" },
    { 0x07b40118, "Olympus E-410" },
    { 0x07b40125, "Tough TG-1 Camera" },
    { 0x07b40126, "VR340/D750 Digital Camera" },
    { 0x07b4012f, "Olympus E-PL5" },
    { 0x07b40184, "P-S100 port" },
    { 0x07b40202, "Foot Switch RS-26" },
    { 0x07b40203, "Digital Voice Recorder DW-90" },
    { 0x07b40206, "Digital Voice Recorder DS-330" },
    { 0x07b40207, "Digital Voice Recorder & Camera W-10" },
    { 0x07b40209, "Digital Voice Recorder DM-20" },
    { 0x07b4020b, "Digital Voice Recorder DS-4000" },
    { 0x07b4020d, "Digital Voice Recorder VN-240PC" },
    { 0x07b40211, "Digital Voice Recorder DS-2300" },
    { 0x07b40218, "Foot Switch RS-28" },
    { 0x07b40244, "Digital Voice Recorder VN-8500PC" },
    { 0x07b4024f, "Digital Voice Recorder DS-7000" },
    { 0x07b40280, "m:robe 100" },
    { 0x07b40295, "Digital Voice Recorder VN-541PC" },
    { 0x07b50017, "Joystick" },
    { 0x07b50213, "Thrustmaster Firestorm Digital 3 Gamepad" },
    { 0x07b50312, "Gamepad" },
    { 0x07b59902, "GamePad" },
    { 0x07b8110c, "XX1" },
    { 0x07b81201, "IEEE 802.11b Adapter" },
    { 0x07b8200c, "XX2" },
    { 0x07b82573, "Wireless LAN Card" },
    { 0x07b82770, "802.11n/b/g Mini Wireless LAN USB2.0 Adapter" },
    { 0x07b82870, "802.11n/b/g Wireless LAN USB2.0 Adapter" },
    { 0x07b83070, "802.11n/b/g Mini Wireless LAN USB2.0 Adapter" },
    { 0x07b83071, "802.11n/b/g Mini Wireless LAN USB2.0 Adapter" },
    { 0x07b83072, "802.11n/b/g Mini Wireless LAN USB2.0 Adapter" },
    { 0x07b84000, "DU-E10 Ethernet [klsi]" },
    { 0x07b84002, "DU-E100 Ethernet [pegasus]" },
    { 0x07b84003, "1/10/100 Ethernet Adapter" },
    { 0x07b84004, "XX4" },
    { 0x07b84007, "XX5" },
    { 0x07b8400b, "XX6" },
    { 0x07b8400c, "XX7" },
    { 0x07b8401a, "RTL8151" },
    { 0x07b84102, "USB 1.1 10/100M Fast Ethernet Adapter" },
    { 0x07b84104, "XX9" },
    { 0x07b8420a, "UF200 Ethernet" },
    { 0x07b85301, "GW-US54ZGL 802.11bg" },
    { 0x07b86001, "WUG2690 802.11bg Wireless Module [ZyDAS ZD1211+AL2230]" },
    { 0x07b88188, "AboCom Systems Inc [WN2001 Prolink Wireless-N Nano Adapter]" },
    { 0x07b8a001, "WUG2200 802.11g Wireless Adapter [Envara WiND512]" },
    { 0x07b8abc1, "DU-E10 Ethernet [pegasus]" },
    { 0x07b8b000, "BWU613" },
    { 0x07b8b02a, "AboCom Bluetooth Device" },
    { 0x07b8b02b, "Bluetooth dongle" },
    { 0x07b8b02c, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b02d, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b02e, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b030, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b031, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b032, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b033, "BCM92045DG-Flash with trace filter" },
    { 0x07b8b21a, "WUG2400 802.11g Wireless Adapter [Texas Instruments TNETW1450]" },
    { 0x07b8b21b, "HWU54DM" },
    { 0x07b8b21c, "RT2573" },
    { 0x07b8b21d, "RT2573" },
    { 0x07b8b21e, "RT2573" },
    { 0x07b8b21f, "WUG2700" },
    { 0x07b8d011, "MP3 Player" },
    { 0x07b8e001, "Mass Storage Device" },
    { 0x07b8e002, "Mass Storage Device" },
    { 0x07b8e003, "Mass Storage Device" },
    { 0x07b8e004, "Mass Storage Device" },
    { 0x07b8e005, "Mass Storage Device" },
    { 0x07b8e006, "Mass Storage Device" },
    { 0x07b8e007, "Mass Storage Device" },
    { 0x07b8e008, "Mass Storage Device" },
    { 0x07b8e009, "Mass Storage Device" },
    { 0x07b8e00a, "Mass Storage Device" },
    { 0x07b8e4f0, "Card Reader Driver" },
    { 0x07b8f101, "DSB-560 Modem [atlas]" },
    { 0x07be1935, "Elektron Music Machines" },
    { 0x07c01113, "JoyWarrior24F8" },
    { 0x07c01116, "JoyWarrior24F14" },
    { 0x07c01121, "The Claw" },
    { 0x07c01500, "IO-Warrior 40" },
    { 0x07c01501, "IO-Warrior 24" },
    { 0x07c01502, "IO-Warrior 48" },
    { 0x07c01503, "IO-Warrior 28" },
    { 0x07c01511, "IO-Warrior 24 Power Vampire" },
    { 0x07c01512, "IO-Warrior 24 Power Vampire" },
    { 0x07c10068, "HKS-0200 USBDAQ" },
    { 0x07c40102, "USB to LS120" },
    { 0x07c40103, "USB to IDE" },
    { 0x07c41234, "USB to ATAPI" },
    { 0x07c4a000, "CompactFlash Card Reader" },
    { 0x07c4a001, "CompactFlash & SmartMedia Card Reader [eusb]" },
    { 0x07c4a002, "Disk Drive" },
    { 0x07c4a003, "Datafab-based Reader" },
    { 0x07c4a004, "USB to MMC Class Drive" },
    { 0x07c4a005, "CompactFlash & SmartMedia Card Reader" },
    { 0x07c4a006, "SmartMedia Card Reader" },
    { 0x07c4a007, "Memory Stick Class Drive" },
    { 0x07c4a103, "MDSM-B reader" },
    { 0x07c4a107, "USB to Memory Stick (LC1) Drive" },
    { 0x07c4a109, "LC1 CompactFlash & SmartMedia Card Reader" },
    { 0x07c4a10b, "USB to CF+MS(LC1)" },
    { 0x07c4a200, "DF-UT-06 Hama MMC/SD Reader" },
    { 0x07c4a400, "CompactFlash & Microdrive Reader" },
    { 0x07c4a600, "Card Reader" },
    { 0x07c4a604, "12-in-1 Card Reader" },
    { 0x07c4ad01, "Mass Storage Device" },
    { 0x07c4ae01, "Mass Storage Device" },
    { 0x07c4af01, "Mass Storage Device" },
    { 0x07c4b000, "USB to CF(LC1)" },
    { 0x07c4b001, "USB to CF+PCMCIA" },
    { 0x07c4b004, "MMC/SD Reader" },
    { 0x07c4b006, "USB to PCMCIA" },
    { 0x07c4b00a, "USB to CF+SD Drive(LC1)" },
    { 0x07c4b00b, "USB to Memory Stick(LC1)" },
    { 0x07c4c010, "Kingston FCR-HS2/ATA Card Reader" },
    { 0x07c50500, "Cash Drawer" },
    { 0x07c60002, "Bodega Wireless Access Point" },
    { 0x07c60003, "Bodega Wireless Network Adapter" },
    { 0x07c80202, "MN128-SOHO PAL" },
    { 0x07c9b100, "AT-USB100" },
    { 0x07ca0002, "AVerTV PVR USB/EZMaker Pro Device" },
    { 0x07ca0026, "AVerTV" },
    { 0x07ca0337, "A867 DVB-T dongle" },
    { 0x07ca0837, "H837 Hybrid ATSC/QAM" },
    { 0x07ca1228, "MPEG-2 Capture Device (M038)" },
    { 0x07ca1830, "AVerTV Volar Video Capture (H830)" },
    { 0x07ca1871, "TD310 DVB-T/T2/C dongle" },
    { 0x07ca3835, "AVerTV Volar Green HD (A835B)" },
    { 0x07ca850a, "AverTV Volar Black HD (A850)" },
    { 0x07ca850b, "AverTV Red HD+ (A850T)" },
    { 0x07caa309, "AVerTV DVB-T (A309)" },
    { 0x07caa801, "AVerTV DVB-T (A800)" },
    { 0x07caa815, "AVerTV DVB-T Volar X (A815)" },
    { 0x07caa827, "AVerTV Hybrid Volar HX (A827)" },
    { 0x07caa867, "AVerTV DVB-T (A867)" },
    { 0x07cab300, "A300 DVB-T TV receiver" },
    { 0x07cab800, "MR800 FM Radio" },
    { 0x07cae880, "MPEG-2 Capture Device (E880)" },
    { 0x07cae882, "MPEG-2 Capture Device (E882)" },
    { 0x07cc0000, "CF Card Reader" },
    { 0x07cc0001, "Reader (UICSE)" },
    { 0x07cc0002, "Reader (UIS)" },
    { 0x07cc0003, "SM Card Reader" },
    { 0x07cc0004, "SM/CF/PCMCIA Card Reader" },
    { 0x07cc0005, "Reader (UISA2SE)" },
    { 0x07cc0006, "SM/CF/PCMCIA Card Reader" },
    { 0x07cc0007, "Reader (UISA6SE)" },
    { 0x07cc000c, "SM/CF Card Reader" },
    { 0x07cc000d, "SM/CF Card Reader" },
    { 0x07cc000e, "Reader (UISDA)" },
    { 0x07cc000f, "Reader (UICLIK)" },
    { 0x07cc0010, "Reader (UISMA)" },
    { 0x07cc0012, "Reader (UISC6SE-FLASH)" },
    { 0x07cc0014, "Litronic Fortezza Reader" },
    { 0x07cc0030, "Mass Storage (UISDMC12S)" },
    { 0x07cc0040, "Mass Storage (UISDMC13S)" },
    { 0x07cc0100, "Reader (UID)" },
    { 0x07cc0101, "Reader (UIM)" },
    { 0x07cc0102, "Reader (UISDMA)" },
    { 0x07cc0103, "Reader (UISDMC)" },
    { 0x07cc0104, "Reader (UISDM)" },
    { 0x07cc0200, "6-in-1 Card Reader" },
    { 0x07cc0201, "Mass Storage (UISDMC1S & UISDMC3S)" },
    { 0x07cc0202, "Mass Storage (UISDMC5S)" },
    { 0x07cc0203, "Mass Storage (UISMC5S)" },
    { 0x07cc0204, "Mass Storage (UIM4/5S & UIM7S)" },
    { 0x07cc0205, "Mass Storage (UIS4/5S & UIS7S)" },
    { 0x07cc0206, "Mass Storage (UISDMC10S & UISDMC11S)" },
    { 0x07cc0207, "Mass Storage (UPIDMA)" },
    { 0x07cc0208, "Mass Storage (UCFC II)" },
    { 0x07cc0210, "Mass Storage (UPIXXA)" },
    { 0x07cc0213, "Mass Storage (UPIDA)" },
    { 0x07cc0214, "Mass Storage (UPIMA)" },
    { 0x07cc0215, "Mass Storage (UPISA)" },
    { 0x07cc0217, "Mass Storage (UPISDMA)" },
    { 0x07cc0223, "Mass Storage (UCIDA)" },
    { 0x07cc0224, "Mass Storage (UCIMA)" },
    { 0x07cc0225, "Mass Storage (UIS7S)" },
    { 0x07cc0227, "Mass Storage (UCIDMA)" },
    { 0x07cc0234, "Mass Storage (UIM7S)" },
    { 0x07cc0235, "Mass Storage (UIS4S-S)" },
    { 0x07cc0237, "Velper (UISDMC4S)" },
    { 0x07cc0300, "6-in-1 Card Reader" },
    { 0x07cc0301, "6-in-1 Card Reader" },
    { 0x07cc0303, "Mass Storage (UID10W)" },
    { 0x07cc0304, "Mass Storage (UIM10W)" },
    { 0x07cc0305, "Mass Storage (UIS10W)" },
    { 0x07cc0308, "Mass Storage (UIC10W)" },
    { 0x07cc0309, "Mass Storage (UISC3W)" },
    { 0x07cc0310, "Mass Storage (UISDMA2W)" },
    { 0x07cc0311, "Mass Storage (UISDMC14W)" },
    { 0x07cc0320, "Mass Storage (UISDMC4W)" },
    { 0x07cc0321, "Mass Storage (UISDMC37W)" },
    { 0x07cc0330, "WINTERREADER Reader" },
    { 0x07cc0350, "9-in-1 Card Reader" },
    { 0x07cc0500, "Mass Storage" },
    { 0x07cc0501, "Mass Storage" },
    { 0x07cd0001, "USBuart Serial Port" },
    { 0x07cec007, "DPB-4000" },
    { 0x07cec009, "DPB-6000" },
    { 0x07cec010, "CPB-7000" },
    { 0x07cf1001, "QV-8000SX/5700/3000EX Digicam; Exilim EX-M20" },
    { 0x07cf1003, "Exilim EX-S500" },
    { 0x07cf1004, "Exilim EX-Z120" },
    { 0x07cf1011, "USB-CASIO PC CAMERA" },
    { 0x07cf1042, "Casio EX-Z120" },
    { 0x07cf1049, "Casio EX-S770" },
    { 0x07cf104c, "Casio EX-Z700" },
    { 0x07cf104d, "Casio EX-Z65" },
    { 0x07cf1116, "EXILIM EX-Z19" },
    { 0x07cf1125, "Exilim EX-H10 Digital Camera (mass storage mode)" },
    { 0x07cf1133, "Exilim EX-Z350 Digital Camera (mass storage mode)" },
    { 0x07cf1225, "Exilim EX-H10 Digital Camera (PictBridge mode)" },
    { 0x07cf1233, "Exilim EX-Z350 Digital Camera (PictBridge mode)" },
    { 0x07cf2002, "E-125 Cassiopeia Pocket PC" },
    { 0x07cf3801, "WMP-1 MP3-Watch" },
    { 0x07cf4001, "Label Printer KL-P1000" },
    { 0x07cf4007, "CW50 Device" },
    { 0x07cf4104, "Cw75 Device" },
    { 0x07cf4107, "CW-L300 Device" },
    { 0x07cf4500, "LV-20 Digital Camera" },
    { 0x07cf6101, "fx-9750gII" },
    { 0x07cf6102, "fx-CP400" },
    { 0x07cf6801, "PL-40R" },
    { 0x07cf6802, "MIDI Keyboard" },
    { 0x07cf6803, "CTK-3500 (MIDI keyboard)" },
    { 0x07d00001, "Digital Video Creator I" },
    { 0x07d00002, "Global Village VideoFX Grabber" },
    { 0x07d00003, "Fusion Model DVC-50 Rev 1 (NTSC)" },
    { 0x07d00004, "DVC-800 (PAL) Grabber" },
    { 0x07d00005, "Fusion Video and Audio Ports" },
    { 0x07d00006, "DVC 150 Loader Device" },
    { 0x07d00007, "DVC 150" },
    { 0x07d00327, "Fusion Digital Media Reader" },
    { 0x07d01001, "DM-FLEX DFU Adapter" },
    { 0x07d01002, "DMHS2 DFU Adapter" },
    { 0x07d01102, "CF Reader/Writer" },
    { 0x07d01103, "SD Reader/Writer" },
    { 0x07d01104, "SM Reader/Writer" },
    { 0x07d01105, "MS Reader/Writer" },
    { 0x07d01106, "xD/SM Reader/Writer" },
    { 0x07d01202, "MultiSlot Reader/Writer" },
    { 0x07d02000, "FX2 DFU Adapter" },
    { 0x07d02001, "eUSB CompactFlash Reader" },
    { 0x07d04100, "Kingsun SF-620 Infrared Adapter" },
    { 0x07d04101, "Connectivity Cable (CA-42 clone)" },
    { 0x07d04959, "Kingsun KS-959 Infrared Adapter" },
    { 0x07d113ec, "VvBus for Helium 2xx" },
    { 0x07d113ed, "VvBus for Helium 2xx" },
    { 0x07d113f1, "DSL-302G Modem" },
    { 0x07d113f2, "DSL-502G Router" },
    { 0x07d13300, "DWA-130 802.11n Wireless N Adapter(rev.E) [Realtek RTL8191SU]" },
    { 0x07d13302, "DWA-130 802.11n Wireless N Adapter(rev.C2) [Realtek RTL8191SU]" },
    { 0x07d13303, "DWA-131 802.11n Wireless N Nano Adapter(rev.A1) [Realtek RTL8192SU]" },
    { 0x07d13304, "FR-300USB 802.11bgn Wireless Adapter" },
    { 0x07d13a07, "WUA-2340 RangeBooster G Adapter(rev.A) [Atheros AR5523]" },
    { 0x07d13a08, "WUA-2340 RangeBooster G Adapter(rev.A) (no firmware) [Atheros AR5523]" },
    { 0x07d13a09, "DWA-160 802.11abgn Xtreme N Dual Band Adapter(rev.A2) [Atheros AR9170+AR9104]" },
    { 0x07d13a0d, "DWA-120 802.11g Wireless 108G Adapter [Atheros AR5523]" },
    { 0x07d13a0f, "DWA-130 802.11n Wireless N Adapter(rev.D) [Atheros AR9170+AR9102]" },
    { 0x07d13a10, "DWA-126 802.11n Wireless Adapter [Atheros AR9271]" },
    { 0x07d13b01, "AirPlus G DWL-G122 Wireless Adapter(rev.D) [Marvell 88W8338+88W8010]" },
    { 0x07d13b10, "DWA-142 RangeBooster N Adapter [Marvell 88W8362+88W8060]" },
    { 0x07d13b11, "DWA-130 802.11n Wireless N Adapter(rev.A1) [Marvell 88W8362+88W8060]" },
    { 0x07d13c03, "AirPlus G DWL-G122 Wireless Adapter(rev.C1) [Ralink RT2571W]" },
    { 0x07d13c04, "WUA-1340" },
    { 0x07d13c05, "EH103 Wireless G Adapter" },
    { 0x07d13c06, "DWA-111 802.11bg Wireless Adapter [Ralink RT2571W]" },
    { 0x07d13c07, "DWA-110 Wireless G Adapter(rev.A1) [Ralink RT2571W]" },
    { 0x07d13c09, "DWA-140 RangeBooster N Adapter(rev.B1) [Ralink RT2870]" },
    { 0x07d13c0a, "DWA-140 RangeBooster N Adapter(rev.B2) [Ralink RT3072]" },
    { 0x07d13c0b, "DWA-110 Wireless G Adapter(rev.B) [Ralink RT2870]" },
    { 0x07d13c0d, "DWA-125 Wireless N 150 Adapter(rev.A1) [Ralink RT3070]" },
    { 0x07d13c0e, "WUA-2340 RangeBooster G Adapter(rev.B) [Ralink RT2070]" },
    { 0x07d13c0f, "AirPlus G DWL-G122 Wireless Adapter(rev.E1) [Ralink RT2070]" },
    { 0x07d13c10, "DWA-160 802.11abgn Xtreme N Dual Band Adapter(rev.A1) [Atheros AR9170+AR9104]" },
    { 0x07d13c11, "DWA-160 Xtreme N Dual Band USB Adapter(rev.B) [Ralink RT2870]" },
    { 0x07d13c13, "DWA-130 802.11n Wireless N Adapter(rev.B) [Ralink RT2870]" },
    { 0x07d13c15, "DWA-140 RangeBooster N Adapter(rev.B3) [Ralink RT2870]" },
    { 0x07d13c16, "DWA-125 Wireless N 150 Adapter(rev.A2) [Ralink RT3070]" },
    { 0x07d13e02, "DWM-156 3.75G HSUPA Adapter" },
    { 0x07d15100, "Remote NDIS Device" },
    { 0x07d1a800, "DWM-152 3.75G HSUPA Adapter" },
    { 0x07d1f101, "DBT-122 Bluetooth" },
    { 0x07d1fc01, "DBT-120 Bluetooth Adapter" },
    { 0x07de2820, "VC500 Video Capture Dongle" },
    { 0x07e04742, "VPN GovNet Box" },
    { 0x07e15201, "V.90 Modem" },
    { 0x07e40967, "SCard R/W CSR-145" },
    { 0x07e40968, "SCard R/W CSR-145" },
    { 0x07e505c2, "IDE-to-USB2.0 PCA" },
    { 0x07e55c01, "Que! CDRW" },
    { 0x07ee0002, "Cash Drawer I/F" },
    { 0x07ef0001, "Internet Access Device" },
    { 0x07f20001, "KEYLOK II" },
    { 0x07f70005, "ScanLogic/Century Corporation uATA" },
    { 0x07f7011e, "Century USB Disk Enclosure" },
    { 0x07fa0778, "miniVigor 128 ISDN TA" },
    { 0x07fa0846, "ISDN TA [HFC-S]" },
    { 0x07fa0847, "ISDN TA [HFC-S]" },
    { 0x07fa1012, "BeWAN ADSL USB ST (grey)" },
    { 0x07fa1196, "BWIFI-USB54AR 802.11bg" },
    { 0x07faa904, "BeWAN ADSL" },
    { 0x07faa905, "BeWAN ADSL ST" },
    { 0x07fc1113, "SWISSONIC EasyKeys61 Midikeyboard" },
    { 0x07fd0000, "FastLane MIDI Interface" },
    { 0x07fd0001, "MIDI Interface" },
    { 0x07fd0002, "MOTU Audio for 64 bit" },
    { 0x07fd0004, "MicroBook" },
    { 0x07fd0008, "M Series" },
    { 0x07ff00ff, "Portable Hard Drive" },
    { 0x07ffffff, "Mad Catz Gamepad" },
    { 0x08010001, "Mini Swipe Reader (Keyboard Emulation)" },
    { 0x08010002, "Mini Swipe Reader" },
    { 0x08010003, "Magstripe Insert Reader" },
    { 0x08031300, "V92 Faxmodem" },
    { 0x08033095, "V.92 56K Mini External Modem Model 3095" },
    { 0x08034310, "4410a Wireless-G Adapter [Intersil ISL3887]" },
    { 0x08034410, "4410b Wireless-G Adapter [ZyDAS ZD1211B]" },
    { 0x08035241, "Cable Modem" },
    { 0x08035551, "DSL Modem" },
    { 0x08039700, "2986L FaxModem" },
    { 0x08039800, "Cable Modem" },
    { 0x0803a312, "Wireless-G" },
    { 0x080b0002, "Fingerprint Scanner (After ReNumeration)" },
    { 0x080b0010, "300LC Series Fingerprint Scanner (Before ReNumeration)" },
    { 0x080c0300, "Gryphon D120 Barcode Scanner" },
    { 0x080c0400, "Gryphon D120 Barcode Scanner" },
    { 0x080c0500, "Gryphon D120 Barcode Scanner" },
    { 0x080c0600, "Gryphon M100 Barcode Scanner" },
    { 0x080d0102, "Hercules Scan@home 48" },
    { 0x080d0104, "3.2Slim" },
    { 0x080d0110, "UMAX AstraSlim 1200 Scanner" },
    { 0x08100001, "Dual PSX Adaptor" },
    { 0x08100002, "Dual PCS Adaptor" },
    { 0x08100003, "PlayStation Gamepad" },
    { 0x0810e001, "Twin controller" },
    { 0x0810e501, "SNES Gamepad" },
    { 0x08130001, "Intel Play QX3 Microscope" },
    { 0x08130002, "Dual Mode Camera Plus" },
    { 0x08190101, "License Management and Copy Protection" },
    { 0x081a1000, "Duo Pen Tablet" },
    { 0x081b0600, "Storage Adapter" },
    { 0x081b0601, "Storage Adapter" },
    { 0x081edf00, "Handheld" },
    { 0x081fe401, "MM812" },
    { 0x08222001, "IRXpress Infrared Device" },
    { 0x082d0100, "Visor" },
    { 0x082d0200, "Treo" },
    { 0x082d0300, "Treo 600" },
    { 0x082d0400, "Handheld" },
    { 0x082d0500, "Handheld" },
    { 0x082d0600, "Handheld" },
    { 0x08300001, "m500" },
    { 0x08300002, "m505" },
    { 0x08300003, "m515" },
    { 0x08300004, "Handheld" },
    { 0x08300005, "Handheld" },
    { 0x08300006, "Handheld" },
    { 0x08300010, "Handheld" },
    { 0x08300011, "Handheld" },
    { 0x08300012, "Handheld" },
    { 0x08300013, "Handheld" },
    { 0x08300014, "Handheld" },
    { 0x08300020, "i705" },
    { 0x08300021, "Handheld" },
    { 0x08300022, "Handheld" },
    { 0x08300023, "Handheld" },
    { 0x08300024, "Handheld" },
    { 0x08300030, "Handheld" },
    { 0x08300031, "Tungsten W" },
    { 0x08300032, "Handheld" },
    { 0x08300033, "Handheld" },
    { 0x08300034, "Handheld" },
    { 0x08300040, "m125" },
    { 0x08300041, "Handheld" },
    { 0x08300042, "Handheld" },
    { 0x08300043, "Handheld" },
    { 0x08300044, "Handheld" },
    { 0x08300050, "m130" },
    { 0x08300051, "Handheld" },
    { 0x08300052, "Handheld" },
    { 0x08300053, "Handheld" },
    { 0x08300054, "Handheld" },
    { 0x08300060, "Tungsten C/E/T/T2/T3 / Zire 71" },
    { 0x08300061, "Lifedrive / Treo 650/680 / Tunsten E2/T5/TX / Centro / Zire 21/31/72 / Z22" },
    { 0x08300062, "Handheld" },
    { 0x08300063, "Handheld" },
    { 0x08300064, "Handheld" },
    { 0x08300070, "Zire" },
    { 0x08300071, "Handheld" },
    { 0x08300072, "Handheld" },
    { 0x08300080, "Serial Adapter [for Palm III]" },
    { 0x08300081, "Handheld" },
    { 0x08300082, "Handheld" },
    { 0x083000a0, "Treo 800w" },
    { 0x08300101, "Pre" },
    { 0x08325850, "Cable" },
    { 0x0833012e, "KeikaiDenwa 8 with charger" },
    { 0x0833039f, "KeikaiDenwa 8" },
    { 0x08362836, "i.Beat mood" },
    { 0x08390005, "Digimax Camera" },
    { 0x08390008, "Digimax 230 Camera" },
    { 0x08390009, "Digimax 340" },
    { 0x0839000a, "Digimax 410" },
    { 0x0839000e, "Digimax 360" },
    { 0x08390010, "Digimax 300" },
    { 0x08391003, "Digimax 210SE" },
    { 0x08391005, "Digimax 220" },
    { 0x08391009, "Digimax V4" },
    { 0x08391012, "6500 Document Camera" },
    { 0x0839103f, "Digimax S500" },
    { 0x08391058, "S730 Camera" },
    { 0x08391064, "Digimax D830 Camera" },
    { 0x08391542, "Digimax 50 Duo" },
    { 0x08393000, "Digimax 35 MP3" },
    { 0x083a1046, "10/100 Ethernet [pegasus]" },
    { 0x083a1060, "HomeLine Adapter" },
    { 0x083a1f4d, "SMC8013WG Broadband Remote NDIS Device" },
    { 0x083a3046, "10/100 Series Adapter" },
    { 0x083a3060, "1/10/100 Adapter" },
    { 0x083a3501, "2664W" },
    { 0x083a3502, "WN3501D Wireless Adapter" },
    { 0x083a3503, "T-Sinus 111 Wireless Adapter" },
    { 0x083a4501, "T-Sinus 154data" },
    { 0x083a4502, "Siemens S30853-S1016-R107 802.11g Wireless Adapter [Intersil ISL3886]" },
    { 0x083a4505, "SMCWUSB-G 802.11bg" },
    { 0x083a4507, "SMCWUSBT-G2 802.11g Wireless Adapter [Atheros AR5523]" },
    { 0x083a4521, "Siemens S30863-S1016-R107-2 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x083a4531, "T-Com Sinus 154 data II [Intersil ISL3887]" },
    { 0x083a5046, "SpeedStream 10/100 Ethernet [pegasus]" },
    { 0x083a5501, "Wireless Adapter 11g" },
    { 0x083a6500, "Cable Modem" },
    { 0x083a6618, "802.11n Wireless Adapter" },
    { 0x083a7511, "Arcadyan 802.11N Wireless Adapter" },
    { 0x083a7512, "Arcadyan 802.11N Wireless Adapter" },
    { 0x083a7522, "Arcadyan 802.11N Wireless Adapter" },
    { 0x083a8522, "Arcadyan 802.11N Wireless Adapter" },
    { 0x083a8541, "WN4501F 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x083aa512, "Arcadyan 802.11N Wireless Adapter" },
    { 0x083aa618, "SMCWUSBS-N EZ Connect N Draft 11n Wireless Adapter [Ralink RT2870]" },
    { 0x083aa701, "SMCWUSBS-N3 EZ Connect N Wireless Adapter [Ralink RT3070]" },
    { 0x083ab004, "CPWUE001 USB/Ethernet Adapter" },
    { 0x083ab522, "SMCWUSBS-N2 EZ Connect N Wireless Adapter [Ralink RT2870]" },
    { 0x083abb01, "BlueExpert Bluetooth Device" },
    { 0x083ac003, "802.11b Wireless Adapter" },
    { 0x083ac501, "Zoom 4410 Wireless-G [Intersil ISL3887]" },
    { 0x083ac561, "802.11a/g Wireless Adapter" },
    { 0x083ad522, "Speedport W 102 Stick IEEE 802.11n USB 2.0 Adapter" },
    { 0x083ae501, "ZD1211B" },
    { 0x083ae503, "Arcadyan WN4501 802.11b/g" },
    { 0x083ae506, "WUS-201 802.11bg" },
    { 0x083af501, "802.11g Wireless Adapter" },
    { 0x083af502, "802.11g Wireless Adapter" },
    { 0x083af522, "Arcadyan WN7512 802.11n" },
    { 0x083fb100, "TelePort V.90 Fax/Modem" },
    { 0x08400060, "Storage Adapter Bridge Module" },
    { 0x08410001, "Rio 500" },
    { 0x08461001, "EA101 10 Mbps 10BASE-T Ethernet [Kawasaki LSI KL5KLUSB101B]" },
    { 0x08461002, "Ethernet" },
    { 0x08461020, "FA101 Fast Ethernet USB 1.1" },
    { 0x08461040, "FA120 Fast Ethernet USB 2.0 [Asix AX88172 / AX8817x]" },
    { 0x08461100, "Managed Switch M4100 series, M5300 series, M7100 series" },
    { 0x08464110, "MA111(v1) 802.11b Wireless [Intersil Prism 3.0]" },
    { 0x08464200, "WG121(v1) 54 Mbps Wireless [Intersil ISL3886]" },
    { 0x08464210, "WG121(v2) 54 Mbps Wireless [Intersil ISL3886]" },
    { 0x08464220, "WG111(v1) 54 Mbps Wireless [Intersil ISL3886]" },
    { 0x08464230, "MA111(v2) 802.11b Wireless [SIS SIS 162]" },
    { 0x08464240, "WG111(v1) rev 2 54 Mbps Wireless [Intersil ISL3887]" },
    { 0x08464260, "WG111v3 54 Mbps Wireless [realtek RTL8187B]" },
    { 0x08464300, "WG111U Double 108 Mbps Wireless [Atheros AR5004X / AR5005UX]" },
    { 0x08464301, "WG111U (no firmware) Double 108 Mbps Wireless [Atheros AR5004X / AR5005UX]" },
    { 0x08465f00, "WPN111 802.11g Wireless Adapter [Atheros AR5523]" },
    { 0x084668e1, "LB1120-100NAS" },
    { 0x08466a00, "WG111v2 54 Mbps Wireless [RealTek RTL8187L]" },
    { 0x08467100, "WN121T RangeMax Next Wireless-N [Marvell TopDog]" },
    { 0x08469000, "WN111(v1) RangeMax Next Wireless [Marvell 88W8362+88W8060]" },
    { 0x08469001, "WN111(v2) RangeMax Next Wireless [Atheros AR9170+AR9101]" },
    { 0x08469010, "WNDA3100v1 802.11abgn [Atheros AR9170+AR9104]" },
    { 0x08469011, "WNDA3100v2 802.11abgn [Broadcom BCM4323]" },
    { 0x08469012, "WNDA4100 802.11abgn 3x3:3 [Ralink RT3573]" },
    { 0x08469014, "WNDA3100v3 802.11abgn 2x2:2 [MediaTek MT7632U]" },
    { 0x08469018, "WNDA3200 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" },
    { 0x08469020, "WNA3100(v1) Wireless-N 300 [Broadcom BCM43231]" },
    { 0x08469021, "WNA3100M(v1) Wireless-N 300 [Realtek RTL8192CU]" },
    { 0x08469030, "WNA1100 Wireless-N 150 [Atheros AR9271]" },
    { 0x08469040, "WNA1000 Wireless-N 150 [Atheros AR9170+AR9101]" },
    { 0x08469041, "WNA1000M 802.11bgn [Realtek RTL8188CUS]" },
    { 0x08469042, "On Networks N150MA 802.11bgn [Realtek RTL8188CUS]" },
    { 0x08469043, "WNA1000Mv2 802.11bgn [Realtek RTL8188CUS?]" },
    { 0x08469050, "A6200 802.11a/b/g/n/ac Wireless Adapter [Broadcom BCM43526]" },
    { 0x08469051, "A6200v2 802.11a/b/g/n/ac (2x2) Wireless Adapter [Realtek RTL8812AU]" },
    { 0x08469052, "A6100 AC600 DB Wireless Adapter [Realtek RTL8811AU]" },
    { 0x08469054, "Nighthawk A7000 802.11ac Wireless Adapter AC1900 [Realtek 8814AU]" },
    { 0x0846a001, "PA101 10 Mbps HPNA Home Phoneline RJ-1" },
    { 0x0846f001, "On Networks N300MA 802.11bgn [Realtek RTL8192CU]" },
    { 0x084d0001, "Jenoptik JD800i" },
    { 0x084d0003, "S-Cam F5/D-Link DSC-350 Digital Camera" },
    { 0x084d0011, "Argus DC3500 Digital Camera" },
    { 0x084d0014, "Praktica DC 32" },
    { 0x084d0019, "Praktica DPix3000" },
    { 0x084d0025, "Praktica DC 60" },
    { 0x084d1001, "ScanHex SX-35d" },
    { 0x084e0001, "JamCam Camera" },
    { 0x084e1001, "Jam Studio Tablet" },
    { 0x084e1002, "Pablo Tablet" },
    { 0x084f0001, "Empeg-Car Mark I/II Player" },
    { 0x08511542, "SiPix Blink" },
    { 0x08511543, "Maxell WS30 Slim Digital Camera, or Pandigital PI8004W01 digital photo frame" },
    { 0x0851a168, "MXIC" },
    { 0x08530100, "HHKB Professional" },
    { 0x08530119, "RealForce 105UB" },
    { 0x08530200, "RealForce Compact Keyboard" },
    { 0x08540100, "I/O Board" },
    { 0x08540101, "I/O Board, rev1" },
    { 0x0856ac01, "uLinks USOTL4 RS422/485 Adapter" },
    { 0x08583102, "Bluetooth Device" },
    { 0x0858ffff, "Maxell module with BlueCore in DFU mode" },
    { 0x085a0001, "Portstation Dual Serial Port" },
    { 0x085a0003, "Portstation Paraller Port" },
    { 0x085a0008, "Ethernet" },
    { 0x085a0009, "Ethernet" },
    { 0x085a000b, "Portstation Dual PS/2 Port" },
    { 0x085a0021, "1 port to Serial Converter" },
    { 0x085a0022, "Parallel Port" },
    { 0x085a0023, "2 port to Serial Converter" },
    { 0x085a0024, "Parallel Port" },
    { 0x085a0026, "PortGear SCSI" },
    { 0x085a0027, "1 port to Serial Converter" },
    { 0x085a0028, "PortGear to SCSI Converter" },
    { 0x085a0032, "PortStation SCSI Module" },
    { 0x085a003c, "Bluetooth Adapter" },
    { 0x085a0299, "Colorvision, Inc. Monitor Spyder" },
    { 0x085a8021, "1 port to Serial" },
    { 0x085a8023, "2 port to Serial" },
    { 0x085a8027, "PGSDB9 Serial Port" },
    { 0x085c0100, "Spyder 1" },
    { 0x085c0200, "Spyder 2" },
    { 0x085c0300, "Spyder 3" },
    { 0x085c0400, "Spyder 4" },
    { 0x08644100, "MA101 802.11b Adapter" },
    { 0x08644102, "MA101 802.11b Adapter" },
    { 0x08679812, "ECON Data acquisition unit" },
    { 0x08679816, "DT9816 ECON data acquisition module" },
    { 0x08679836, "DT9836 data acquisition card" },
    { 0x086a0001, "Unitor8" },
    { 0x086a0002, "AMT8" },
    { 0x086a0003, "MT4" },
    { 0x086c1001, "Eumex 504PC ISDN TA" },
    { 0x086c1002, "Eumex 504PC (FlashLoad)" },
    { 0x086c1003, "TA33 ISDN TA" },
    { 0x086c1004, "TA33 (FlashLoad)" },
    { 0x086c1005, "Eumex 604PC HomeNet" },
    { 0x086c1006, "Eumex 604PC HomeNet (FlashLoad)" },
    { 0x086c1007, "Eumex 704PC DSL" },
    { 0x086c1008, "Eumex 704PC DSL (FlashLoad)" },
    { 0x086c1009, "Eumex 724PC DSL" },
    { 0x086c100a, "Eumex 724PC DSL (FlashLoad)" },
    { 0x086c100b, "OpenCom 30" },
    { 0x086c100c, "OpenCom 30 (FlashLoad)" },
    { 0x086c100d, "BeeTel Home 100" },
    { 0x086c100e, "BeeTel Home 100 (FlashLoad)" },
    { 0x086c1011, "USB2DECT" },
    { 0x086c1012, "USB2DECT (FlashLoad)" },
    { 0x086c1013, "Eumex 704PC LAN" },
    { 0x086c1014, "Eumex 704PC LAN (FlashLoad)" },
    { 0x086c1019, "Eumex 504 SE" },
    { 0x086c101a, "Eumex 504 SE (Flash-Mode)" },
    { 0x086c1021, "OpenCom 40" },
    { 0x086c1022, "OpenCom 40 (FlashLoad)" },
    { 0x086c1023, "OpenCom 45" },
    { 0x086c1024, "OpenCom 45 (FlashLoad)" },
    { 0x086c1025, "Sinus 61 data" },
    { 0x086c1029, "dect BOX" },
    { 0x086c102c, "Eumex 604PC HomeNet [FlashLoad]" },
    { 0x086c1030, "Eumex 704PC DSL [FlashLoad]" },
    { 0x086c1032, "OpenCom 40 [FlashLoad]" },
    { 0x086c1033, "OpenCom 30 plus" },
    { 0x086c1034, "OpenCom 30 plus (FlashLoad)" },
    { 0x086c1041, "Eumex 220PC" },
    { 0x086c1042, "Eumex 220PC (FlashMode)" },
    { 0x086c1055, "Eumex 220 Version 2 ISDN TA" },
    { 0x086c1056, "Eumex 220 Version 2 ISDN TA (Flash-Mode)" },
    { 0x086c2000, "OpenCom 1000" },
    { 0x086e1920, "SGC-X2UL" },
    { 0x08700001, "Ricochet GS" },
    { 0x08710001, "SDDR-01 Compact Flash Reader" },
    { 0x08710002, "SDDR-31 Compact Flash Reader" },
    { 0x08710005, "SDDR-05 Compact Flash Reader" },
    { 0x087d5704, "Ethernet" },
    { 0x08860630, "Intel PC Camera CS630" },
    { 0x088a1002, "DigiView DV3100" },
    { 0x088b4944, "MassWorks ID-75 TouchScreen" },
    { 0x088c2030, "Ticket Printer TTP 2030" },
    { 0x088e5036, "Portable secure storage for software licenses" },
    { 0x08920101, "Smartdio Reader/Writer" },
    { 0x08940010, "Remote NDIS Network Device" },
    { 0x08970001, "ICE In-Circuit Emulator" },
    { 0x08970002, "Power Debug/Power Debug II" },
    { 0x08970004, "PowerDebug" },
    { 0x08970005, "PowerDebug PRO" },
    { 0x08a60051, "B-SV4" },
    { 0x08a90005, "USBee ZX" },
    { 0x08a90009, "USBee SX" },
    { 0x08a90012, "USBee AX-Standard" },
    { 0x08a90013, "USBee AX-Plus" },
    { 0x08a90014, "USBee AX-Pro" },
    { 0x08a90015, "USBee DX" },
    { 0x08ac2024, "usbWiggler" },
    { 0x08b00006, "814 Sample Processor" },
    { 0x08b00015, "857 Titrando" },
    { 0x08b0001a, "852 Titrando" },
    { 0x08b70001, "Playstation adapter" },
    { 0x08b801f4, "USBSIMM1" },
    { 0x08bb2702, "PCM2702 16-bit stereo audio DAC" },
    { 0x08bb2704, "PCM2704 16-bit stereo audio DAC" },
    { 0x08bb2705, "PCM2705 stereo audio DAC" },
    { 0x08bb2706, "PCM2706 stereo audio DAC" },
    { 0x08bb2707, "PCM2707 stereo audio DAC" },
    { 0x08bb27c4, "PCM2704C stereo audio DAC" },
    { 0x08bb27c5, "PCM2705C stereo audio DAC" },
    { 0x08bb27c6, "PCM2706C stereo audio DAC" },
    { 0x08bb27c7, "PCM2707C stereo audio DAC" },
    { 0x08bb2900, "PCM2900 Audio Codec" },
    { 0x08bb2901, "PCM2901 Audio Codec" },
    { 0x08bb2902, "PCM2902 Audio Codec" },
    { 0x08bb2904, "PCM2904 Audio Codec" },
    { 0x08bb2910, "PCM2912 Audio Codec" },
    { 0x08bb2912, "PCM2912A Audio Codec" },
    { 0x08bb29b0, "PCM2900B Audio CODEC" },
    { 0x08bb29b2, "PCM2902 Audio CODEC" },
    { 0x08bb29b3, "PCM2903B Audio CODEC" },
    { 0x08bb29b6, "PCM2906B Audio CODEC" },
    { 0x08bb29c0, "PCM2900C Audio CODEC" },
    { 0x08bb29c2, "PCM2902C Audio CODEC" },
    { 0x08bb29c3, "PCM2903C Audio CODEC" },
    { 0x08bb29c6, "PCM2906C Audio CODEC" },
    { 0x08bd0208, "CLP-521 Label Printer" },
    { 0x08bd1100, "X1-USB Floppy" },
    { 0x08c30001, "100 SC" },
    { 0x08c30002, "100 A" },
    { 0x08c30003, "100 SC BioKeyboard" },
    { 0x08c30006, "100 A BioKeyboard" },
    { 0x08c30100, "100 MC ISP" },
    { 0x08c30101, "100 MC FingerPrint and SmartCard Reader" },
    { 0x08c30300, "100 AX" },
    { 0x08c30400, "100 SC" },
    { 0x08c30401, "150 MC" },
    { 0x08c30402, "200 MC FingerPrint and SmartCard Reader" },
    { 0x08c30404, "100 SC Upgrade" },
    { 0x08c30405, "150 MC Upgrade" },
    { 0x08c30406, "100 MC Upgrade" },
    { 0x08c40100, "Skyline 802.11b Wireless Adapter" },
    { 0x08c402f2, "Farallon Home Phoneline Adapter" },
    { 0x08ca0001, "Tablet" },
    { 0x08ca0010, "Tablet" },
    { 0x08ca0020, "APT-6000U Tablet" },
    { 0x08ca0021, "APT-2 Tablet" },
    { 0x08ca0022, "Tablet" },
    { 0x08ca0023, "Tablet" },
    { 0x08ca0024, "Tablet" },
    { 0x08ca0100, "Pen Drive" },
    { 0x08ca0102, "DualCam" },
    { 0x08ca0103, "Pocket DV Digital Camera" },
    { 0x08ca0104, "Pocket DVII" },
    { 0x08ca0105, "Mega DV(Disk)" },
    { 0x08ca0106, "Pocket DV3100+" },
    { 0x08ca0107, "Pocket DV3100" },
    { 0x08ca0109, "Nisis DV4 Digital Camera" },
    { 0x08ca010a, "Trust 738AV LCD PV Mass Storage" },
    { 0x08ca0111, "PenCam VGA Plus" },
    { 0x08ca2008, "Mini PenCam 2" },
    { 0x08ca2010, "Pocket CAM 3 Mega (webcam)" },
    { 0x08ca2011, "Pocket CAM 3 Mega (storage)" },
    { 0x08ca2016, "PocketCam 2 Mega" },
    { 0x08ca2018, "Pencam SD 2M" },
    { 0x08ca2019, "Pencam SD 2M (mass storage mode)" },
    { 0x08ca2020, "Slim 3000F" },
    { 0x08ca2022, "Slim 3200" },
    { 0x08ca2024, "Pocket DV3500" },
    { 0x08ca2028, "Pocket Cam4M" },
    { 0x08ca2040, "Pocket DV4100M" },
    { 0x08ca2042, "Pocket DV5100M Composite Device" },
    { 0x08ca2043, "Pocket DV5100M (Disk)" },
    { 0x08ca2060, "Pocket DV5300" },
    { 0x08d10001, "smartNIC Ethernet [catc]" },
    { 0x08d10003, "smartNIC 2 PnP Ethernet" },
    { 0x08d40009, "SCR SmartCard Reader" },
    { 0x08d80002, "USB-to-CAN compact" },
    { 0x08d80003, "USB-to-CAN II" },
    { 0x08d80100, "USB-to-CAN" },
    { 0x08dd0112, "Wireless LAN Adapter" },
    { 0x08dd0113, "Wireless LAN Adapter" },
    { 0x08dd0986, "USB-100N Ethernet [pegasus]" },
    { 0x08dd0987, "USBLP-100 HomePNA Ethernet [pegasus]" },
    { 0x08dd0988, "USBEL-100 Ethernet [pegasus]" },
    { 0x08dd1986, "10/100 LAN Adapter" },
    { 0x08dd2103, "DVB-T TV-Tuner Card-R" },
    { 0x08dd8511, "USBE-100 Ethernet [pegasus2]" },
    { 0x08dd90ff, "USB2AR Ethernet" },
    { 0x08de7a01, "802.11b Adapter" },
    { 0x08df0001, "Rosetta Token V1" },
    { 0x08df0002, "Rosetta Token V2" },
    { 0x08df0003, "Rosetta Token V3" },
    { 0x08df0a00, "Lynks Interface" },
    { 0x08e30002, "USB-RS232 Bridge" },
    { 0x08e30100, "Interface ADSL" },
    { 0x08e30101, "Interface ADSL" },
    { 0x08e30102, "ADSL" },
    { 0x08e30301, "RNIS ISDN TA [HFC-S]" },
    { 0x08e40142, "Pioneer DVR-LX60D" },
    { 0x08e40148, "Pioneer XMP3" },
    { 0x08e40184, "DDJ-WeGO" },
    { 0x08e40185, "DDJ-WeGO2" },
    { 0x08e60001, "GemPC-Touch 430" },
    { 0x08e60430, "GemPC430 SmartCard Reader" },
    { 0x08e60432, "GemPC432 SmartCard Reader" },
    { 0x08e60435, "GemPC435 SmartCard Reader" },
    { 0x08e60437, "GemPC433 SL SmartCard Reader" },
    { 0x08e61359, "UA SECURE STORAGE TOKEN" },
    { 0x08e62202, "Gem e-Seal Pro Token" },
    { 0x08e63437, "GemPC Twin SmartCard Reader" },
    { 0x08e63438, "GemPC Key SmartCard Reader" },
    { 0x08e63478, "PinPad Smart Card Reader" },
    { 0x08e634ec, "Compact Smart Card Reader Writer" },
    { 0x08e64433, "GemPC433-Swap" },
    { 0x08e65501, "GemProx-PU Contactless Smart Card Reader" },
    { 0x08e65503, "Prox-DU Contactless Interface" },
    { 0x08e6ace0, "UA HYBRID TOKEN" },
    { 0x08e90100, "XTNDAccess IrDA Dongle" },
    { 0x08ea00c9, "ADSL Modem HM120dp Loader" },
    { 0x08ea00ca, "ADSL WAN Modem HM120dp" },
    { 0x08ea00ce, "HM230d Virtual Bus for Helium" },
    { 0x08eaabba, "USB Driver for Bluetooth Wireless Technology" },
    { 0x08eaabbb, "Bluetooth Device in DFU State" },
    { 0x08ec0001, "TravelDrive 2C" },
    { 0x08ec0002, "TravelDrive 2C" },
    { 0x08ec0005, "TravelDrive 2C" },
    { 0x08ec0008, "TravelDrive 2C" },
    { 0x08ec0010, "DiskOnKey" },
    { 0x08ec0011, "DiskOnKey" },
    { 0x08ec0012, "TravelDrive 2C" },
    { 0x08ec0014, "TravelDrive 2C" },
    { 0x08ec0015, "Kingston DataTraveler ELITE" },
    { 0x08ec0016, "Kingston DataTraveler U3" },
    { 0x08ec0020, "TravelDrive Intuix U3 2GB" },
    { 0x08ec0021, "TravelDrive" },
    { 0x08ec0022, "TravelDrive" },
    { 0x08ec0023, "TravelDrive" },
    { 0x08ec0024, "TravelDrive" },
    { 0x08ec0025, "TravelDrive" },
    { 0x08ec0026, "TravelDrive" },
    { 0x08ec0027, "TravelDrive" },
    { 0x08ec0028, "TravelDrive" },
    { 0x08ec0029, "TravelDrive" },
    { 0x08ec0030, "TravelDrive" },
    { 0x08ec0822, "TravelDrive 2C" },
    { 0x08ec0832, "Hi-Speed Mass Storage Device" },
    { 0x08ec0834, "M-Disk 220" },
    { 0x08ec0998, "Kingston Data Traveler2.0 Disk Driver" },
    { 0x08ec0999, "Kingston Data Traveler2.0 Disk Driver" },
    { 0x08ec1000, "TravelDrive 2C" },
    { 0x08ec2000, "TravelDrive 2C" },
    { 0x08ec2038, "TravelDrive" },
    { 0x08ec2039, "TravelDrive" },
    { 0x08ec204a, "TravelDrive" },
    { 0x08ec204b, "TravelDrive" },
    { 0x08ed0002, "CECT M800 memory card" },
    { 0x08f00005, "CardScan 800c" },
    { 0x08f2007f, "Super Q2 Tablet" },
    { 0x08f70001, "LabPro" },
    { 0x08f70002, "EasyTemp/Go!Temp" },
    { 0x08f70003, "Go!Link" },
    { 0x08f70004, "Go!Motion" },
    { 0x08fd0001, "Bluetooth Device" },
    { 0x08ff1600, "AES1600" },
    { 0x08ff1610, "AES1600" },
    { 0x08ff1660, "AES1660 Fingerprint Sensor" },
    { 0x08ff1680, "AES1660 Fingerprint Sensor" },
    { 0x08ff168f, "AES1660 Fingerprint Sensor" },
    { 0x08ff2500, "AES2501" },
    { 0x08ff2501, "AES2501" },
    { 0x08ff2502, "AES2501" },
    { 0x08ff2503, "AES2501" },
    { 0x08ff2504, "AES2501" },
    { 0x08ff2505, "AES2501" },
    { 0x08ff2506, "AES2501" },
    { 0x08ff2507, "AES2501" },
    { 0x08ff2508, "AES2501" },
    { 0x08ff2509, "AES2501" },
    { 0x08ff250a, "AES2501" },
    { 0x08ff250b, "AES2501" },
    { 0x08ff250c, "AES2501" },
    { 0x08ff250d, "AES2501" },
    { 0x08ff250e, "AES2501" },
    { 0x08ff250f, "AES2501" },
    { 0x08ff2510, "AES2510" },
    { 0x08ff2550, "AES2550 Fingerprint Sensor" },
    { 0x08ff2580, "AES2501 Fingerprint Sensor" },
    { 0x08ff2588, "AES2501" },
    { 0x08ff2589, "AES2501" },
    { 0x08ff258a, "AES2501" },
    { 0x08ff258b, "AES2501" },
    { 0x08ff258c, "AES2501" },
    { 0x08ff258d, "AES2501" },
    { 0x08ff258e, "AES2501" },
    { 0x08ff258f, "AES2501" },
    { 0x08ff2660, "AES2660 Fingerprint Sensor" },
    { 0x08ff2680, "AES2660 Fingerprint Sensor" },
    { 0x08ff268f, "AES2660 Fingerprint Sensor" },
    { 0x08ff2810, "AES2810" },
    { 0x08ff3400, "AES3400 TruePrint Sensor" },
    { 0x08ff3401, "AES3400 Sensor" },
    { 0x08ff3402, "AES3400 Sensor" },
    { 0x08ff3403, "AES3400 Sensor" },
    { 0x08ff3404, "AES3400 TruePrint Sensor" },
    { 0x08ff3405, "AES3400 TruePrint Sensor" },
    { 0x08ff3406, "AES3400 TruePrint Sensor" },
    { 0x08ff3407, "AES3400 TruePrint Sensor" },
    { 0x08ff4902, "BioMV with TruePrint AES3500" },
    { 0x08ff4903, "BioMV with TruePrint AES3400" },
    { 0x08ff5500, "AES4000" },
    { 0x08ff5501, "AES4000 TruePrint Sensor" },
    { 0x08ff5503, "AES4000 TruePrint Sensor" },
    { 0x08ff5505, "AES4000 TruePrint Sensor" },
    { 0x08ff5507, "AES4000 TruePrint Sensor" },
    { 0x08ff55ff, "AES4000 TruePrint Sensor." },
    { 0x08ff5700, "AES3500 Fingerprint Reader" },
    { 0x08ff5701, "AES3500 TruePrint Sensor" },
    { 0x08ff5702, "AES3500 TruePrint Sensor" },
    { 0x08ff5703, "AES3500 TruePrint Sensor" },
    { 0x08ff5704, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5705, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5706, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5707, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5710, "AES3500 TruePrint Sensor" },
    { 0x08ff5711, "AES3500 TruePrint Sensor" },
    { 0x08ff5712, "AES3500 TruePrint Sensor" },
    { 0x08ff5713, "AES3500 TruePrint Sensor" },
    { 0x08ff5714, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5715, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5716, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5717, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5730, "AES3500 TruePrint Sensor" },
    { 0x08ff5731, "AES3500 TruePrint Sensor" },
    { 0x08ff5732, "AES3500 TruePrint Sensor" },
    { 0x08ff5733, "AES3500 TruePrint Sensor" },
    { 0x08ff5734, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5735, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5736, "AES3500-BZ TruePrint Sensor" },
    { 0x08ff5737, "AES3500-BZ TruePrint Sensor" },
    { 0x08ffafe3, "FingerLoc Sensor Module (Anchor)" },
    { 0x08ffafe4, "FingerLoc Sensor Module (Anchor)" },
    { 0x08ffafe5, "FingerLoc Sensor Module (Anchor)" },
    { 0x08ffafe6, "FingerLoc Sensor Module (Anchor)" },
    { 0x08fffffd, "AES2510 Sensor (USB Emulator)" },
    { 0x08ffffff, "Sensor (Emulator)" },
    { 0x09010001, "Hard Drive Adapter (TPP)" },
    { 0x09010002, "SigmaDrive Adapter (TPP)" },
    { 0x090801f4, "SIMATIC NET CP 5711" },
    { 0x090801fe, "SIMATIC NET PC Adapter A2" },
    { 0x090804b1, "MediSET" },
    { 0x090804b2, "NC interface" },
    { 0x090804b3, "keyboard front panel Cockpit" },
    { 0x090804b4, "SCR_CCID" },
    { 0x09082701, "ShenZhen SANZHAI Technology Co.,Ltd Spy Pen VGA" },
    { 0x090a1001, "T33520 Flash Card Controller" },
    { 0x090a1100, "Comotron C3310 MP3 player" },
    { 0x090a1200, "MP3 player" },
    { 0x090a1540, "Digitex Container Flash Disk" },
    { 0x090c0371, "Silicon Motion SM371 Camera" },
    { 0x090c0373, "Silicon Motion Camera" },
    { 0x090c037a, "Silicon Motion Camera" },
    { 0x090c037b, "Silicon Motion Camera" },
    { 0x090c037c, "300k Pixel Camera" },
    { 0x090c1000, "Flash Drive" },
    { 0x090c1132, "5-in-1 Card Reader" },
    { 0x090c337b, "Silicon Motion Camera" },
    { 0x090c3710, "Silicon Motion Camera" },
    { 0x090c3720, "Silicon Motion Camera" },
    { 0x090c37bc, "HP Webcam-101 Integrated Camera" },
    { 0x090c37c0, "Silicon Motion Camera" },
    { 0x090c6000, "SD/SDHC Card Reader (SG365 / FlexiDrive XC+)" },
    { 0x090c6200, "microSD card reader" },
    { 0x090c71b3, "SM731 Camera" },
    { 0x090c837b, "Silicon Motion Camera" },
    { 0x090c937b, "Silicon Motion Camera" },
    { 0x090cb370, "Silicon Motion SM370 Camera" },
    { 0x090cb371, "Silicon Motion SM371 Camera" },
    { 0x090cf37d, "Endoscope camera" },
    { 0x09110c1c, "SpeechMike III" },
    { 0x0911149a, "SpeechMike II Pro Plus LFH5276" },
    { 0x09112512, "SpeechMike Pro" },
    { 0x09150001, "DSL Modem" },
    { 0x09150002, "ADSL ATM Modem" },
    { 0x09150005, "LAN Modem" },
    { 0x09152000, "802.11 Adapter" },
    { 0x09152002, "802.11 Adapter" },
    { 0x09158000, "ADSL LAN Modem" },
    { 0x09158005, "DSL-302G Modem" },
    { 0x09158101, "ADSL WAN Modem" },
    { 0x09158102, "DSL-200 ADSL Modem" },
    { 0x09158103, "DSL-200 ADSL Modem" },
    { 0x09158104, "DSL-200 Modem" },
    { 0x09158400, "DSL Modem" },
    { 0x09158401, "DSL Modem" },
    { 0x09158402, "DSL Modem" },
    { 0x09158500, "DSL Modem" },
    { 0x09158501, "DSL Modem" },
    { 0x09170001, "eFilm Reader-11 SM/CF" },
    { 0x09170002, "eFilm Reader-11 SM" },
    { 0x09170003, "eFilm Reader-11 CF" },
    { 0x09170200, "FireFly" },
    { 0x09170201, "FireLite" },
    { 0x09170202, "STORAGE ADAPTER (FirePower)" },
    { 0x09170204, "FlashTrax Storage" },
    { 0x09170205, "STORAGE ADAPTER (CrossFire)" },
    { 0x09170206, "FireFly 20G HDD" },
    { 0x09170207, "FireLite" },
    { 0x0917020f, "STORAGE ADAPTER (FireLite)" },
    { 0x0917da01, "eFilm Reader-11 Test" },
    { 0x0917ffff, "eFilm Reader-11 (Class/PDR)" },
    { 0x09190100, "Fast Flicks Digital Camera" },
    { 0x091e0003, "GPS (various models)" },
    { 0x091e0004, "iQue 3600" },
    { 0x091e0200, "Data Card Programmer (install)" },
    { 0x091e086e, "Forerunner 735XT" },
    { 0x091e097f, "Forerunner 235" },
    { 0x091e1200, "Data Card Programmer" },
    { 0x091e21a5, "etrex Cx (msc)" },
    { 0x091e2236, "nuvi 360" },
    { 0x091e2271, "Edge 605/705" },
    { 0x091e2295, "Colorado 300" },
    { 0x091e22b6, "eTrex Vista HCx (Mass Storage mode)" },
    { 0x091e231b, "Oregon 400t" },
    { 0x091e2353, "N\303\274vi 205T" },
    { 0x091e2380, "Oregon series" },
    { 0x091e23cc, "n\303\274vi 1350" },
    { 0x091e2459, "GPSmap 62/78 series" },
    { 0x091e2491, "Edge 800" },
    { 0x091e2518, "eTrex 10" },
    { 0x091e2519, "eTrex 30" },
    { 0x091e2535, "Edge 800" },
    { 0x091e253c, "GPSmap 62sc" },
    { 0x091e255b, "Nuvi 2505LM" },
    { 0x091e2613, "Edge 200 TWN" },
    { 0x091e26a1, "Nuvi 55" },
    { 0x091e2802, "fenix 3" },
    { 0x091e28db, "Drive 5" },
    { 0x091e47fb, "nuviCam" },
    { 0x091e4cdb, "Fenix 6" },
    { 0x09207500, "Network Interface" },
    { 0x09211001, "GoCOM232 Serial" },
    { 0x09220007, "LabelWriter 330" },
    { 0x09220009, "LabelWriter 310" },
    { 0x09220013, "LabelManager 400" },
    { 0x09220019, "LabelWriter 400" },
    { 0x0922001a, "LabelWriter 400 Turbo" },
    { 0x09220020, "LabelWriter 450" },
    { 0x09220400, "LabelWriter SE450" },
    { 0x09221001, "LabelManager PnP" },
    { 0x09228003, "M10 Digital Postal Scale" },
    { 0x09228004, "M25 Digital Postal Scale" },
    { 0x09228009, "S250 Digital Postal Scale" },
    { 0x0923010f, "SIIG MobileCam" },
    { 0x092423dd, "DocuPrint M760 (X760_USB)" },
    { 0x09243ce8, "Phaser 3428 Printer" },
    { 0x09243cea, "Phaser 3125" },
    { 0x09243cec, "Phaser 3250" },
    { 0x09243d5b, "Phaser 6115MFP TWAIN Scanner" },
    { 0x09243d6d, "WorkCentre 6015N/NI" },
    { 0x0924420f, "WorkCentre PE220 Series" },
    { 0x0924421f, "M20 Scanner" },
    { 0x0924423b, "Printing Support" },
    { 0x09244274, "Xerox Phaser 3635MFPX" },
    { 0x0924ffef, "WorkCenter M15" },
    { 0x0924fffb, "DocuPrint M750 (X750_USB)" },
    { 0x09250005, "Gamtec.,Ltd SmartJoy PLUS Adapter" },
    { 0x092503e8, "Wii Classic Controller Adapter" },
    { 0x09251031, "WiseGroup Ltd, Gameport Controller" },
    { 0x09251700, "PS/SS/N64 Joypad" },
    { 0x09253881, "Saleae Logic" },
    { 0x09258101, "Phidgets, Inc., 1-Motor PhidgetServo v2.0" },
    { 0x09258104, "Phidgets, Inc., 4-Motor PhidgetServo v2.0" },
    { 0x09258800, "WiseGroup Ltd, MP-8800 Quad Joypad" },
    { 0x09258866, "WiseGroup Ltd, MP-8866 Dual Joypad" },
    { 0x09288000, "Firmware uploader" },
    { 0x0928ffff, "Blank Oxford Device" },
    { 0x092b4210, "20S - Bluetooth Motorcycle headset & universal intercom" },
    { 0x092f0004, "JTAG-4" },
    { 0x092f0005, "JTAG-5" },
    { 0x09300009, "Toshiba Gigabeat MEGF-40" },
    { 0x0930000c, "Toshiba Gigabeat" },
    { 0x0930000f, "Toshiba Gigabeat P20" },
    { 0x09300010, "Toshiba Gigabeat S" },
    { 0x09300011, "Toshiba Gigabeat P10" },
    { 0x09300014, "Toshiba Gigabeat V30" },
    { 0x09300016, "Toshiba Gigabeat U" },
    { 0x09300018, "Toshiba Gigabeat MEU202" },
    { 0x09300019, "Toshiba Gigabeat T" },
    { 0x0930001a, "Toshiba Gigabeat MEU201" },
    { 0x0930001d, "Toshiba Gigabeat MET401" },
    { 0x093001bf, "2.5\"External Hard Disk" },
    { 0x09300200, "Integrated Bluetooth (Taiyo Yuden)" },
    { 0x0930021c, "Atheros AR3012 Bluetooth" },
    { 0x09300301, "PCX1100U Cable Modem (WDM)" },
    { 0x09300302, "PCX2000 Cable Modem (WDM)" },
    { 0x09300305, "Cable Modem PCX3000" },
    { 0x09300307, "Cable Modem PCX2500" },
    { 0x09300308, "PCX2200 Cable Modem (WDM)" },
    { 0x09300309, "PCX5000 Cable Modem (WDM)" },
    { 0x0930030b, "Cable Modem PCX2600" },
    { 0x09300501, "Bluetooth Controller" },
    { 0x09300502, "Integrated Bluetooth" },
    { 0x09300503, "Bluetooth Controller" },
    { 0x09300505, "Integrated Bluetooth" },
    { 0x09300506, "Integrated Bluetooth" },
    { 0x09300507, "Bluetooth Adapter" },
    { 0x09300508, "Integrated Bluetooth HCI" },
    { 0x09300509, "BT EDR Dongle" },
    { 0x09300706, "PocketPC e740" },
    { 0x09300707, "Pocket PC e330 Series" },
    { 0x09300708, "Pocket PC e350 Series" },
    { 0x09300709, "Pocket PC e750 Series" },
    { 0x0930070a, "Pocket PC e400 Series" },
    { 0x0930070b, "Pocket PC e800 Series" },
    { 0x09300963, "Toshiba Excite AT300" },
    { 0x09300a07, "WLM-10U1 802.11abgn Wireless Adapter [Ralink RT3572]" },
    { 0x09300a08, "WLM-20U2/GN-1080 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" },
    { 0x09300a0b, "WLU5053 802.11abgn Wireless Module [Broadcom BCM43236B]" },
    { 0x09300a13, "AX88179 Gigabit Ethernet [Toshiba]" },
    { 0x09300b05, "PX1220E-1G25 External hard drive" },
    { 0x09300b09, "PX1396E-3T01 External hard drive" },
    { 0x09300b1a, "STOR.E ALU 2S" },
    { 0x09301300, "Wireless Broadband (CDMA EV-DO) SM-Bus Minicard Status Port" },
    { 0x09301301, "Wireless Broadband (CDMA EV-DO) Minicard Status Port" },
    { 0x09301302, "Wireless Broadband (3G HSDPA) SM-Bus Minicard Status Port" },
    { 0x09301303, "Wireless Broadband (3G HSDPA) Minicard Status Port" },
    { 0x09301308, "Broadband (3G HSDPA) SM-Bus Minicard Diagnostics Port" },
    { 0x0930130b, "F3507g Mobile Broadband Module" },
    { 0x0930130c, "F3607gw Mobile Broadband Module" },
    { 0x09301311, "F3607gw v2 Mobile Broadband Module" },
    { 0x09301400, "Memory Stick 2GB" },
    { 0x0930140b, "Memory Stick 64GB" },
    { 0x0930642f, "TravelDrive" },
    { 0x09306506, "TravelDrive 2C" },
    { 0x09306507, "TravelDrive 2C" },
    { 0x09306508, "TravelDrive 2C" },
    { 0x09306509, "TravelDrive 2C" },
    { 0x09306510, "TravelDrive 2C" },
    { 0x09306517, "TravelDrive 2C" },
    { 0x09306518, "TravelDrive 2C" },
    { 0x09306519, "Kingston DataTraveler 2.0 USB Stick" },
    { 0x0930651a, "TravelDrive 2C" },
    { 0x0930651b, "TravelDrive 2C" },
    { 0x0930651c, "TravelDrive 2C" },
    { 0x0930651d, "TravelDrive 2C" },
    { 0x0930651e, "TravelDrive 2C" },
    { 0x0930651f, "TravelDrive 2C" },
    { 0x09306520, "TravelDrive 2C" },
    { 0x09306521, "TravelDrive 2C" },
    { 0x09306522, "TravelDrive 2C" },
    { 0x09306523, "TravelDrive" },
    { 0x09306524, "TravelDrive" },
    { 0x09306525, "TravelDrive" },
    { 0x09306526, "TravelDrive" },
    { 0x09306527, "TravelDrive" },
    { 0x09306528, "TravelDrive" },
    { 0x09306529, "TravelDrive" },
    { 0x0930652a, "TravelDrive" },
    { 0x0930652b, "TravelDrive" },
    { 0x0930652c, "TravelDrive" },
    { 0x0930652d, "TravelDrive" },
    { 0x0930652f, "TravelDrive" },
    { 0x09306530, "TravelDrive" },
    { 0x09306531, "TravelDrive" },
    { 0x09306532, "256M Stick" },
    { 0x09306533, "512M Stick" },
    { 0x09306534, "TravelDrive" },
    { 0x0930653c, "Kingston DataTraveler 2.0 Stick (512M)" },
    { 0x0930653d, "Kingston DataTraveler 2.0 Stick (1GB)" },
    { 0x0930653e, "Flash Memory" },
    { 0x09306540, "TransMemory Flash Memory" },
    { 0x09306544, "TransMemory-Mini / Kingston DataTraveler 2.0 Stick" },
    { 0x09306545, "Kingston DataTraveler 102/2.0 / HEMA Flash Drive 2 GB / PNY Attache 4GB Stick" },
    { 0x09307100, "Toshiba Thrive AT100/AT105" },
    { 0x0930a002, "SunplusIT SATA bridge" },
    { 0x09320300, "VideoAdvantage" },
    { 0x09320302, "Syntek DC-112X" },
    { 0x09320320, "VideoAdvantage" },
    { 0x09320482, "USB2.0 TVBOX" },
    { 0x09321100, "DC-1100 Video Enhamcement Device" },
    { 0x09321112, "Veo Web Camera" },
    { 0x0932a311, "Video Enhancement Device" },
    { 0x0936000a, "Moebius" },
    { 0x0936000b, "iMoebius" },
    { 0x0936000c, "Rhythmedics 6 BioData Integrator" },
    { 0x0936000d, "Hypurius" },
    { 0x0936000e, "Millennius" },
    { 0x0936000f, "Purius" },
    { 0x09360030, "Composite Device, Mass Storage Device (Flash Drive) amd HID" },
    { 0x0936003c, "Rhythmedics HID Bootloader" },
    { 0x09390b15, "Toshiba Stor.E Alu 2" },
    { 0x09390b16, "Toshiba StorE HDD" },
    { 0x093a0007, "CMOS 100K-R Rev. 1.90" },
    { 0x093a010e, "Digital camera, CD302N/Elta Medi@ digi-cam/HE-501A" },
    { 0x093a010f, "Argus DC-1610/DC-1620/Emprex PCD3600/Philips P44417B keychain camera/Precision Mini,Model HA513A/Vivitar Vivicam 55" },
    { 0x093a020f, "Bullet Line Photo Viewer" },
    { 0x093a050f, "Mars-Semi Pc-Camera" },
    { 0x093a2460, "Q-TEC WEBCAM 100" },
    { 0x093a2468, "SoC PC-Camera" },
    { 0x093a2470, "SoC PC-Camera" },
    { 0x093a2471, "SoC PC-Camera" },
    { 0x093a2500, "USB Optical Mouse" },
    { 0x093a2510, "Optical Mouse" },
    { 0x093a2521, "Optical Mouse" },
    { 0x093a2600, "Typhoon Easycam USB 330K (newer)/Typhoon Easycam USB 2.0 VGA 1.3M/Sansun SN-508" },
    { 0x093a2601, "SPC 610NC Laptop Camera" },
    { 0x093a2603, "PAC7312 Camera" },
    { 0x093a2608, "PAC7311 Trust WB-3300p" },
    { 0x093a260e, "PAC7311 Gigaware VGA PC Camera:Trust WB-3350p:SIGMA cam 2350" },
    { 0x093a260f, "PAC7311 SnakeCam" },
    { 0x093a2621, "PAC731x Trust Webcam" },
    { 0x093a2622, "Webcam Genius" },
    { 0x093a2624, "Webcam" },
    { 0x093a2628, "Webcam Genius iLook 300" },
    { 0x093a2700, "GE 1.3 MP MiniCam Pro" },
    { 0x093b0010, "Storage Adapter" },
    { 0x093b0011, "PlexWriter 40/12/40U" },
    { 0x093b0012, "PlexWriter 48/24/48U" },
    { 0x093b0041, "PX-708A DVD RW" },
    { 0x093b0042, "PX-712UF DVD RW" },
    { 0x093ba002, "ConvertX M402U XLOADER" },
    { 0x093ba003, "ConvertX AV100U A/V Capture Audio" },
    { 0x093ba004, "ConvertX TV402U XLOADER" },
    { 0x093ba005, "ConvertX TV100U A/V Capture" },
    { 0x093ba102, "ConvertX M402U A/V Capture" },
    { 0x093ba104, "ConvertX PX-TV402U/NA" },
    { 0x093c0601, "ValueCAN" },
    { 0x093c0701, "NeoVI Blue vehicle bus interface" },
    { 0x09440001, "PXR4 4-Track Digital Recorder" },
    { 0x09440020, "KAOSS Pad KP3 Dynamic Effect/Sampler" },
    { 0x09440023, "KAOSSILATOR PRO Dynamic Phrase Synthesizer" },
    { 0x0944010d, "nanoKEY MIDI keyboard" },
    { 0x0944010e, "nanoPAD pad controller" },
    { 0x0944010f, "nanoKONTROL studio controller" },
    { 0x09440117, "nanoKONTROL2 MIDI Controller" },
    { 0x09440f03, "K-Series K61P MIDI studio controller" },
    { 0x09480301, "USB Pro (24/48)" },
    { 0x09480302, "USB Pro (24/96 playback)" },
    { 0x09480303, "USB Pro (24/96 record)" },
    { 0x09480304, "USB Pro (16/48)" },
    { 0x09481105, "USB One" },
    { 0x094b0001, "neonode N2" },
    { 0x094f0101, "U640MO-03" },
    { 0x094f05fc, "METALWEAR-HDD" },
    { 0x09510008, "Ethernet" },
    { 0x0951000a, "KNU101TX 100baseTX Ethernet" },
    { 0x09511539, "Iron Key D300 (Virtual CD-ROM and USB Stick)" },
    { 0x09511600, "DataTraveler II Pen Drive" },
    { 0x09511601, "DataTraveler II+ Pen Drive" },
    { 0x09511602, "DataTraveler Mini" },
    { 0x09511603, "DataTraveler 1GB/2GB Pen Drive" },
    { 0x09511606, "Eee PC 701 SD Card Reader [ENE UB6225]" },
    { 0x09511607, "DataTraveler 100" },
    { 0x0951160b, "DataTraveler 2.0 (2GB)" },
    { 0x0951160d, "DataTraveler Vault Privacy" },
    { 0x0951160e, "DT110P/1GB Capless" },
    { 0x09511613, "DataTraveler DT101C Flash Drive" },
    { 0x09511616, "DataTraveler Locker 4GB" },
    { 0x0951161a, "Dell HyperVisor internal flash drive" },
    { 0x09511621, "DataTraveler 150 (32GB)" },
    { 0x09511624, "DataTraveler G2" },
    { 0x09511625, "DataTraveler 101 II" },
    { 0x0951162a, "DataTraveler 112 4GB Pen Drive" },
    { 0x0951162b, "DataTraveler HyperX 3.0" },
    { 0x0951162d, "DataTraveler 102" },
    { 0x09511630, "DataTraveler 200 (32GB)" },
    { 0x09511642, "DT101 G2" },
    { 0x09511643, "DataTraveler G3" },
    { 0x09511653, "Data Traveler 100 G2 8 GiB" },
    { 0x09511656, "DataTraveler Ultimate G2" },
    { 0x09511660, "Data Traveller 108" },
    { 0x09511665, "Digital DataTraveler SE9" },
    { 0x09511666, "DataTraveler 100 G3/G4/SE9 G2/50" },
    { 0x09511689, "DataTraveler SE9" },
    { 0x0951168a, "DataTraveler Micro" },
    { 0x0951168c, "DT Elite 3.0" },
    { 0x095116a4, "HyperX 7.1 Audio" },
    { 0x095116b3, "HyperX Savage" },
    { 0x095116d2, "HX-KB4BL1-US [HYPERX Alloy FPS Pro]" },
    { 0x095116d4, "HyperX SavageEXO [0382]" },
    { 0x095116d5, "DataTraveler Elite G2" },
    { 0x095116df, "HyperX QuadCast" },
    { 0x095116e4, "HyperX Pulsefire Raid" },
    { 0x09557005, "Bootloader" },
    { 0x09557018, "T186 [Tegra Parker]" },
    { 0x0955701a, "U-Boot running on Tegra" },
    { 0x09557020, "L4T (Linux for Tegra) running on Tegra" },
    { 0x09557030, "T30 [Tegra 3] recovery mode" },
    { 0x095570a9, "nVidia CM9-Adam" },
    { 0x09557100, "Tegra Device" },
    { 0x09557140, "T124 [Tegra K1/Logan 32-bit]" },
    { 0x09557210, "SHIELD Controller" },
    { 0x09557321, "Switch [Tegra Erista] recovery mode" },
    { 0x09557721, "T210 [TX1 Tegra Erista] recovery mode" },
    { 0x09557820, "T20 [Tegra 2] recovery mode" },
    { 0x09557c18, "T186 [TX2 Tegra Parker] recovery mode" },
    { 0x0955b400, "SHIELD (debug)" },
    { 0x0955b401, "SHIELD" },
    { 0x0955cf05, "SHIELD Tablet (debug)" },
    { 0x0955cf06, "SHIELD Tablet" },
    { 0x0955cf07, "SHIELD Tablet" },
    { 0x0955cf08, "SHIELD Tablet" },
    { 0x0955cf09, "SHIELD Tablet" },
    { 0x09570200, "E-Video DC-350 Camera" },
    { 0x09570202, "E-Video DC-350 Camera" },
    { 0x09570407, "33220A Waveform Generator" },
    { 0x09570518, "82357B GPIB Interface" },
    { 0x09570a07, "34411A Multimeter" },
    { 0x09571507, "33210A Waveform Generator" },
    { 0x09571745, "Test and Measurement Device (IVI)" },
    { 0x09571f01, "N5181A MXG Analog Signal Generator" },
    { 0x09572918, "U2702A oscilloscope" },
    { 0x0957fb18, "LC Device" },
    { 0x09592bd0, "Intelligent ISDN (Ver. 3.60.04) [HFC-S]" },
    { 0x095a3003, "Express Ethernet" },
    { 0x095d0001, "Polycom ViaVideo" },
    { 0x09670204, "WarpLink 802.11b Adapter" },
    { 0x096e0005, "ePass2000" },
    { 0x096e0006, "HID Dongle (for OEMs - manufacturer string is \"OEM\")" },
    { 0x096e0120, "Microcosm Ltd Dinkey" },
    { 0x096e0305, "ePass2000Auto" },
    { 0x096e0309, "ePass3000GM" },
    { 0x096e0401, "ePass3000" },
    { 0x096e0405, "Zzkey Dongle" },
    { 0x096e0608, "SC Reader KP382" },
    { 0x096e0702, "ePass3003" },
    { 0x096e0703, "ePass3003Auto" },
    { 0x096e0802, "ePass2000 (G&D STARCOS SPK 2.4)" },
    { 0x096e0807, "ePass2003" },
    { 0x09712000, "i1 Pro" },
    { 0x09712001, "i1 Monitor" },
    { 0x09712003, "Eye-One display" },
    { 0x09712005, "Huey" },
    { 0x09712007, "ColorMunki Photo" },
    { 0x09730001, "e-gate Smart Card" },
    { 0x09790222, "Keychain Display" },
    { 0x09790224, "JL2005A Toy Camera" },
    { 0x09790226, "JL2005A Toy Camera" },
    { 0x09790227, "JL2005B/C/D Toy Camera" },
    { 0x097a0001, "Digital Wallet" },
    { 0x097e0035, "MP35 v1.0" },
    { 0x09840040, "SATA Wire (2.5\")" },
    { 0x09840200, "Hard Drive Storage (TPP)" },
    { 0x09841407, "Secure Key 3.0" },
    { 0x09850045, "Mach4/200 Label Printer" },
    { 0x098500a3, "A3/200 or A3/300 Label Printer" },
    { 0x09930001, "REB1100 eBook Reader" },
    { 0x09930002, "eBook" },
    { 0x099a0638, "Sanwa Supply Inc. Small Keyboard" },
    { 0x099a2620, "Graphics tablet [Polostar PT1001, Zeniq PT1001, Leogics PT1001]" },
    { 0x099a610c, "EL-610 Super Mini Electron luminescent Keyboard" },
    { 0x099a6330, "SANWA Supply Inc. Slim Keyboard" },
    { 0x099a713a, "WK-713 Multimedia Keyboard" },
    { 0x099a7160, "Hyper Slim Keyboard" },
    { 0x09a68001, "Mass Storage Device" },
    { 0x09aa1000, "Prism GT 802.11b/g Adapter" },
    { 0x09aa3642, "Prism 2.x 802.11b Adapter" },
    { 0x09ae0002, "Any Device (see discussion)" },
    { 0x09b02400, "HDP5000" },
    { 0x09b20001, "eBookman Palm Computer" },
    { 0x09bc0002, "MPaxx MP150 MP3 Player" },
    { 0x09be0001, "MySmartPad" },
    { 0x09bf00c0, "COMpact 2104 ISDN PBX" },
    { 0x09bf00db, "COMpact 4410/2206 ISDN" },
    { 0x09bf00dc, "COMpact 4406 DSL (PBX)" },
    { 0x09bf00dd, "COMpact 2204 (PBX)" },
    { 0x09bf00de, "COMpact 2104 (Rev.2 PBX)" },
    { 0x09bf00e0, "COMmander Business (PBX)" },
    { 0x09bf00e2, "COMmander Basic.2 (PBX)" },
    { 0x09bf00f1, "COMfort 2000 (System telephone)" },
    { 0x09bf00f2, "COMfort 1200 (System telephone)" },
    { 0x09bf00f5, "COMfortel 2500 (System telephone)" },
    { 0x09bf8000, "COMpact 2104 DSL (DSL modem)" },
    { 0x09bf8001, "COMpact 4406 DSL (DSL modem)" },
    { 0x09bf8002, "Analog/ISDN Converter (Line converter)" },
    { 0x09bf8005, "WG-640 (Automatic event dialer)" },
    { 0x09c00136, "Axon CNS, MultiClamp 700B" },
    { 0x09c00202, "8PSK DVB-S tuner" },
    { 0x09c00203, "Skywalker-1 DVB-S tuner" },
    { 0x09c00204, "Skywalker-CW3K DVB-S tuner" },
    { 0x09c00205, "Skywalker-CW3K DVB-S tuner" },
    { 0x09c00206, "Skywalker-2 DVB-S tuner" },
    { 0x09c11337, "TOUCHSTONE DEVICE" },
    { 0x09c30007, "Reader V2" },
    { 0x09c30008, "ZFG-9800-AC SmartCard Reader" },
    { 0x09c30014, "ActivIdentity ActivKey SIM USB Token" },
    { 0x09c30028, "Crescendo Key" },
    { 0x09c30029, "Crescendo Key" },
    { 0x09c3002a, "Crescendo Key" },
    { 0x09c3002b, "Crescendo Key" },
    { 0x09c3002c, "Crescendo Key" },
    { 0x09c3002e, "Crescendo Key" },
    { 0x09c40011, "ACT-IR2000U IrDA Dongle" },
    { 0x09ca5544, "PIO" },
    { 0x09cb1001, "Network Adapter" },
    { 0x09cb1002, "Ex-Series RNDIS interface" },
    { 0x09cb1004, "Ex-Series UVC interface" },
    { 0x09cb1005, "Ex-Series RNDIS and UVC interface" },
    { 0x09cb1006, "Ex-Series RNDIS and MSD interface" },
    { 0x09cb1007, "Ex-Series UVC and MSD interface" },
    { 0x09cb1008, "Serial Port" },
    { 0x09cb1996, "FLIR ONE Camera" },
    { 0x09cb4007, "Breach" },
    { 0x09cc0404, "BAFO USB-ATA/ATAPI Bridge Controller" },
    { 0x09cd2001, "Psion WaveFinder DAB radio receiver" },
    { 0x09d30001, "ISDN TA / Light Rider 128K" },
    { 0x09d3000b, "Bluetooth Adapter class 2" },
    { 0x09d70100, "GPS/GNSS/SPAN sensor" },
    { 0x09d80320, "TWN3 Multi125" },
    { 0x09d80406, "TWN4 MIFARE NFC" },
    { 0x09da0006, "Optical Mouse WOP-35 / Trust 450L Optical Mouse" },
    { 0x09da000a, "Optical Mouse Opto 510D / OP-620D" },
    { 0x09da000e, "X-F710F Optical Mouse 3xFire Gaming Mouse" },
    { 0x09da0018, "Trust Human Interface Device" },
    { 0x09da001a, "Wireless Mouse & RXM-15 Receiver" },
    { 0x09da002a, "Wireless Optical Mouse NB-30" },
    { 0x09da022b, "Wireless Mouse (Battery Free)" },
    { 0x09da024f, "RF Receiver and G6-20D Wireless Optical Mouse" },
    { 0x09da0260, "KV-300H Isolation Keyboard" },
    { 0x09da032b, "Wireless Mouse (Battery Free)" },
    { 0x09da09da, "Bloody V8 Mouse" },
    { 0x09da1068, "Bloody A90 Mouse" },
    { 0x09da112c, "Bloody V5 Mouse" },
    { 0x09da3a60, "Bloody V8M Core 2 Mouse" },
    { 0x09da8090, "X-718BK Oscar Optical Gaming Mouse" },
    { 0x09da9033, "X-718BK Optical Mouse" },
    { 0x09da9066, "F3 V-Track Gaming Mouse" },
    { 0x09da9090, "XL-730K / XL-750BK / XL-755BK Mice" },
    { 0x09daf613, "Bloody V7M Mouse" },
    { 0x09db0075, "MiniLab 1008" },
    { 0x09db0076, "PMD-1024" },
    { 0x09db007a, "PMD-1208LS" },
    { 0x09db0081, "USB-1616FS" },
    { 0x09db0082, "USB-1208FS" },
    { 0x09db0088, "USB-1616FS internal hub" },
    { 0x09e15121, "MicroLink dLAN" },
    { 0x09e80045, "MPK Mini Mk II MIDI Controller" },
    { 0x09e80062, "MPD16 MIDI Pad Controller Unit" },
    { 0x09e8006d, "EWI electronic wind instrument" },
    { 0x09e80071, "MPK25 MIDI Keyboard" },
    { 0x09e80076, "LPK25 MIDI Keyboard" },
    { 0x09eb4331, "iRhythm Tuner Remote" },
    { 0x09ef0101, "MD-Port DG2 MiniDisc Interface" },
    { 0x09f30018, "GF-46 Multi-Mode Display Module" },
    { 0x09f30028, "RP-48 Combination Pushbutton-Rotary Module" },
    { 0x09f30048, "LGTII - Landing Gear and Trim Control Module" },
    { 0x09f30064, "MCPPro - Airliner Mode Control Panel (Autopilot)" },
    { 0x09f30300, "EFIS - Electronic Flight Information System" },
    { 0x09f50168, "Network Adapter" },
    { 0x09f50188, "LAN Adapter" },
    { 0x09f50850, "Adapter" },
    { 0x09fb6001, "Blaster" },
    { 0x0a050001, "Hub" },
    { 0x0a057211, "hub" },
    { 0x0a070064, "ADU100 Data Acquisition Interface" },
    { 0x0a070078, "ADU120 Data Acquisition Interface" },
    { 0x0a070082, "ADU130 Data Acquisition Interface" },
    { 0x0a0700c8, "ADU200 Relay I/O Interface" },
    { 0x0a0700d0, "ADU208 Relay I/O Interface" },
    { 0x0a0700da, "ADU218 Solid-State Relay I/O Interface" },
    { 0x0a0d2514, "CTS-1000 Internal Hub" },
    { 0x0a120001, "Bluetooth Dongle (HCI mode)" },
    { 0x0a120002, "Frontline Test Equipment Bluetooth Device" },
    { 0x0a120003, "Nanosira" },
    { 0x0a120004, "Nanosira WHQL Reference Radio" },
    { 0x0a120005, "Nanosira-Multimedia" },
    { 0x0a120006, "Nanosira-Multimedia WHQL Reference Radio" },
    { 0x0a120007, "Nanosira3-ROM" },
    { 0x0a120008, "Nanosira3-ROM" },
    { 0x0a120009, "Nanosira4-EDR WHQL Reference Radio" },
    { 0x0a12000a, "Nanosira4-EDR-ROM" },
    { 0x0a12000b, "Nanosira5-ROM" },
    { 0x0a120042, "SPI Converter" },
    { 0x0a120043, "Bluetooth Device" },
    { 0x0a120100, "Casira with BlueCore2-External Module" },
    { 0x0a120101, "Casira with BlueCore2-Flash Module" },
    { 0x0a120102, "Casira with BlueCore3-Multimedia Module" },
    { 0x0a120103, "Casira with BlueCore3-Flash Module" },
    { 0x0a120104, "Casira with BlueCore4-External Module" },
    { 0x0a120105, "Casira with BlueCore4-Multimedia Module" },
    { 0x0a121000, "Bluetooth Dongle (HID proxy mode)" },
    { 0x0a121010, "Bluetooth Device" },
    { 0x0a121011, "Bluetooth Device" },
    { 0x0a121012, "Bluetooth Device" },
    { 0x0a12ffff, "USB Bluetooth Device in DFU State" },
    { 0x0a161111, "ThumbDrive" },
    { 0x0a168888, "IBM USB Memory Key" },
    { 0x0a169988, "Trek2000 TD-G2" },
    { 0x0a170004, "Optio 330" },
    { 0x0a170006, "Optio S / S4" },
    { 0x0a170007, "Optio 550" },
    { 0x0a170009, "Optio 33WR" },
    { 0x0a17000a, "Optio 555" },
    { 0x0a17000c, "Optio 43WR (mass storage mode)" },
    { 0x0a17000d, "Pentax Optio 43WR" },
    { 0x0a170015, "Optio S40/S5i" },
    { 0x0a17003b, "Optio 50 (mass storage mode)" },
    { 0x0a17003d, "Optio S55" },
    { 0x0a170041, "Optio S5z" },
    { 0x0a170043, "*ist DL" },
    { 0x0a170047, "Optio S60" },
    { 0x0a170052, "Optio 60 Digital Camera" },
    { 0x0a17006e, "K10D" },
    { 0x0a170070, "K100D" },
    { 0x0a170093, "K200D" },
    { 0x0a1700a7, "Optio E50" },
    { 0x0a1700f7, "Pentax Optio W90" },
    { 0x0a171001, "EI2000 Camera powered by Digita!" },
    { 0x0a218001, "MMT-7305WW [Medtronic Minimed CareLink]" },
    { 0x0a270102, "SP35" },
    { 0x0a2c0008, "GPIO Ports" },
    { 0x0a340101, "TG82tp" },
    { 0x0a340110, "Deck 82-key backlit keyboard" },
    { 0x0a35002a, "SAC - Software Assigned Controller" },
    { 0x0a35008a, "SAC Hub" },
    { 0x0a3a0163, "KN-W510U 1.0 Wireless LAN Adapter" },
    { 0x0a460268, "ST268" },
    { 0x0a466688, "ZT6688 Fast Ethernet Adapter" },
    { 0x0a468515, "ADMtek ADM8515 NIC" },
    { 0x0a469000, "DM9000E Fast Ethernet Adapter" },
    { 0x0a469601, "DM9601 Fast Ethernet Adapter" },
    { 0x0a483233, "Multimedia Card Reader" },
    { 0x0a483239, "Multimedia Card Reader" },
    { 0x0a483258, "Dane Elec zMate SD Reader" },
    { 0x0a483259, "Dane Elec zMate CF Reader" },
    { 0x0a485000, "MediaGear xD-SM" },
    { 0x0a48500a, "Mass Storage Device" },
    { 0x0a48500f, "Mass Storage Device" },
    { 0x0a485010, "Mass Storage Device" },
    { 0x0a485011, "Mass Storage Device" },
    { 0x0a485014, "Mass Storage Device" },
    { 0x0a485020, "Mass Storage Device" },
    { 0x0a485021, "Mass Storage Device" },
    { 0x0a485022, "Mass Storage Device" },
    { 0x0a485023, "Mass Storage Device" },
    { 0x0a485024, "Mass Storage Device" },
    { 0x0a485025, "Mass Storage Device" },
    { 0x0a4aa400, "AUDIO JUNCTION 2.0" },
    { 0x0a4c15d9, "OPTICAL MOUSE" },
    { 0x0a4d0064, "MK-225 Driver" },
    { 0x0a4d0065, "MK-225C Driver" },
    { 0x0a4d0066, "MK-225C Driver" },
    { 0x0a4d0067, "MK-425C Driver" },
    { 0x0a4d0078, "MK-37 Driver" },
    { 0x0a4d0079, "MK-37C Driver" },
    { 0x0a4d007a, "MK-37C Driver" },
    { 0x0a4d008c, "TerraTec MIDI MASTER" },
    { 0x0a4d008d, "MK-249C Driver" },
    { 0x0a4d008e, "MK-249C MIDI Keyboard" },
    { 0x0a4d008f, "MK-449C Driver" },
    { 0x0a4d0090, "Keystation 49e Driver" },
    { 0x0a4d0091, "Keystation 61es Driver" },
    { 0x0a4d00a0, "MK-361 Driver" },
    { 0x0a4d00a1, "MK-361C Driver" },
    { 0x0a4d00a2, "MK-361C Driver" },
    { 0x0a4d00a3, "MK-461C MIDI Keyboard" },
    { 0x0a4d00b5, "Keystation Pro 88 Driver" },
    { 0x0a4d00d2, "E-Keys Driver" },
    { 0x0a4d00f0, "UC-16 Driver" },
    { 0x0a4d00f1, "X-Session Driver" },
    { 0x0a4d00f5, "UC-33e MIDI Controller" },
    { 0x0a531000, "Scanner" },
    { 0x0a532000, "Q-Scan A6 Scanner" },
    { 0x0a532001, "Q-Scan A6 Scanner" },
    { 0x0a532013, "Media Drive A6 Scanner" },
    { 0x0a532014, "Media Drive A6 Scanner" },
    { 0x0a532015, "BizCardReader 600C" },
    { 0x0a532016, "BizCardReader 600C" },
    { 0x0a53202a, "Scanshell-CSSN" },
    { 0x0a533000, "Q-Scan A8 Scanner" },
    { 0x0a533002, "Q-Scan A8 Reader" },
    { 0x0a533015, "BizCardReader 300G" },
    { 0x0a53302a, "LM9832 - PA570 Mini Business Card Scanner [Targus]" },
    { 0x0a535001, "BizCardReader 900C" },
    { 0x0a5c0201, "iLine10(tm) Network Adapter" },
    { 0x0a5c0bdc, "802.11a/b/g/n/ac Wireless Adapter" },
    { 0x0a5c2000, "Bluetooth Device" },
    { 0x0a5c2001, "Bluetooth Device" },
    { 0x0a5c2009, "BCM2035 Bluetooth" },
    { 0x0a5c200a, "BCM2035 Bluetooth dongle" },
    { 0x0a5c200f, "Bluetooth Controller" },
    { 0x0a5c201d, "Bluetooth Device" },
    { 0x0a5c201e, "IBM Integrated Bluetooth IV" },
    { 0x0a5c2020, "Bluetooth dongle" },
    { 0x0a5c2021, "BCM2035B3 Bluetooth Adapter" },
    { 0x0a5c2033, "BCM2033 Bluetooth" },
    { 0x0a5c2035, "BCM2035 Bluetooth" },
    { 0x0a5c2038, "Blutonium Device" },
    { 0x0a5c2039, "BCM2045 Bluetooth" },
    { 0x0a5c2045, "Bluetooth Controller" },
    { 0x0a5c2046, "Bluetooth Device" },
    { 0x0a5c2047, "Bluetooth Device" },
    { 0x0a5c205e, "Bluetooth Device" },
    { 0x0a5c2100, "Bluetooth 2.0+eDR dongle" },
    { 0x0a5c2101, "BCM2045 Bluetooth" },
    { 0x0a5c2102, "ANYCOM Blue USB-200/250" },
    { 0x0a5c2110, "BCM2045B (BDC-2) [Bluetooth Controller]" },
    { 0x0a5c2111, "ANYCOM Blue USB-UHE 200/250" },
    { 0x0a5c2120, "2045 Bluetooth 2.0 USB-UHE Device with trace filter" },
    { 0x0a5c2121, "BCM2210 Bluetooth" },
    { 0x0a5c2122, "Bluetooth 2.0+EDR dongle" },
    { 0x0a5c2123, "Bluetooth dongle" },
    { 0x0a5c2130, "2045 Bluetooth 2.0 USB-UHE Device with trace filter" },
    { 0x0a5c2131, "2045 Bluetooth 2.0 Device with trace filter" },
    { 0x0a5c2145, "BCM2045B (BDC-2.1) [Bluetooth Controller]" },
    { 0x0a5c2148, "BCM92046DG-CL1ROM Bluetooth 2.1 Adapter" },
    { 0x0a5c2150, "BCM2046 Bluetooth Device" },
    { 0x0a5c2151, "Bluetooth" },
    { 0x0a5c2154, "BCM92046DG-CL1ROM Bluetooth 2.1 UHE Dongle" },
    { 0x0a5c216a, "BCM43142A0 Bluetooth" },
    { 0x0a5c216c, "BCM43142A0 Bluetooth Device" },
    { 0x0a5c216d, "BCM43142A0 Bluetooth 4.0" },
    { 0x0a5c216f, "BCM20702A0 Bluetooth" },
    { 0x0a5c217d, "HP Bluethunder" },
    { 0x0a5c217f, "BCM2045B (BDC-2.1)" },
    { 0x0a5c2198, "Bluetooth 3.0 Device" },
    { 0x0a5c219b, "Bluetooth 2.1 Device" },
    { 0x0a5c21b1, "HP Bluetooth Module" },
    { 0x0a5c21b4, "BCM2070 Bluetooth 2.1 + EDR" },
    { 0x0a5c21b9, "BCM2070 Bluetooth 2.1 + EDR" },
    { 0x0a5c21ba, "BCM2070 Bluetooth 2.1 + EDR" },
    { 0x0a5c21bb, "BCM2070 Bluetooth 2.1 + EDR" },
    { 0x0a5c21bc, "BCM2070 Bluetooth 2.1 + EDR" },
    { 0x0a5c21bd, "BCM2070 Bluetooth 2.1 + EDR" },
    { 0x0a5c21d7, "BCM43142 Bluetooth 4.0" },
    { 0x0a5c21e1, "HP Portable SoftSailing" },
    { 0x0a5c21e3, "HP Portable Valentine" },
    { 0x0a5c21e6, "BCM20702 Bluetooth 4.0 [ThinkPad]" },
    { 0x0a5c21e8, "BCM20702A0 Bluetooth 4.0" },
    { 0x0a5c21ec, "BCM20702A0 Bluetooth 4.0" },
    { 0x0a5c21f1, "HP Portable Bumble Bee" },
    { 0x0a5c22be, "BCM2070 Bluetooth 3.0 + HS" },
    { 0x0a5c4500, "BCM2046B1 USB 2.0 Hub (part of BCM2046 Bluetooth)" },
    { 0x0a5c4502, "Keyboard (Boot Interface Subclass)" },
    { 0x0a5c4503, "Mouse (Boot Interface Subclass)" },
    { 0x0a5c5800, "BCM5880 Secure Applications Processor" },
    { 0x0a5c5801, "BCM5880 Secure Applications Processor with fingerprint swipe sensor" },
    { 0x0a5c5802, "BCM5880 Secure Applications Processor with fingerprint touch sensor" },
    { 0x0a5c5803, "BCM5880 Secure Applications Processor with secure keyboard" },
    { 0x0a5c5804, "BCM5880 Secure Applications Processor with fingerprint swipe sensor" },
    { 0x0a5c6300, "Pirelli Remote NDIS Device" },
    { 0x0a5c6410, "BCM20703A1 Bluetooth 4.1 + LE" },
    { 0x0a5cbd11, "BCM4320 802.11bg Wireless Adapter" },
    { 0x0a5cbd12, "BCM4326U 802.11bg Wireless Adapter" },
    { 0x0a5cbd13, "BCM4323 802.11abgn Wireless Adapter" },
    { 0x0a5cbd16, "BCM4319 802.11bgn Wireless Adapter" },
    { 0x0a5cbd17, "BCM43236 802.11abgn Wireless Adapter" },
    { 0x0a5cbd1d, "BCM43526 802.11a/b/g/n/ac (2x2) Wireless Adapter" },
    { 0x0a5cbd1e, "BCM43143 802.11bgn (1x1) Wireless Adapter" },
    { 0x0a5cbd1f, "BCM43242 802.11abgn Wireless Adapter" },
    { 0x0a5cd11b, "Eminent EM4045 [Broadcom 4320 USB]" },
    { 0x0a5f0009, "LP2844 Printer" },
    { 0x0a5f0050, "P120i / WM120i" },
    { 0x0a5f0080, "GK420d Label Printer" },
    { 0x0a5f0081, "GK420t Label Printer" },
    { 0x0a5f0084, "GX420d Desktop Label Printer" },
    { 0x0a5f008b, "HC100 wristbands Printer" },
    { 0x0a5f008c, "ZP 450 Printer" },
    { 0x0a5f00d1, "Zebra GC420d Label Printer" },
    { 0x0a5f0110, "ZD500 Desktop Label Printer" },
    { 0x0a5f930a, "Printer" },
    { 0x0a620010, "MPMan MP-F40 MP3 Player" },
    { 0x0a6b0001, "Compact Flash R/W with MP3 player" },
    { 0x0a6b000f, "FlashDisk" },
    { 0x0a6f0400, "Xanboo" },
    { 0x0a710001, "VP485 Printer" },
    { 0x0a730002, "XD-2 [Spike]" },
    { 0x0a810101, "Keyboard" },
    { 0x0a810103, "Keyboard" },
    { 0x0a810203, "Mouse" },
    { 0x0a810205, "PS/2 Keyboard+Mouse Adapter" },
    { 0x0a810701, "USB Missile Launcher" },
    { 0x0a81ff01, "Wireless Missile Launcher" },
    { 0x0a824600, "TravelScan 460/464" },
    { 0x0a826605, "ScanShell 800N" },
    { 0x0a890001, "Guardant Stealth/Net" },
    { 0x0a890002, "Guardant ID" },
    { 0x0a890003, "Guardant Stealth 2" },
    { 0x0a890004, "Rutoken" },
    { 0x0a890005, "Guardant Fidus" },
    { 0x0a890006, "Guardant Stealth 3" },
    { 0x0a890007, "Guardant Stealth 2" },
    { 0x0a890008, "Guardant Stealth 3 Sign/Time" },
    { 0x0a890009, "Guardant Code" },
    { 0x0a89000a, "Guardant Sign Pro" },
    { 0x0a89000b, "Guardant Sign Pro HID" },
    { 0x0a89000c, "Guardant Stealth 3 Sign/Time" },
    { 0x0a89000d, "Guardant Code HID" },
    { 0x0a89000f, "Guardant System Firmware Update" },
    { 0x0a890020, "Rutoken S" },
    { 0x0a890025, "Rutoken lite" },
    { 0x0a890026, "Rutoken lite HID" },
    { 0x0a89002a, "Rutoken Mass Storage" },
    { 0x0a89002b, "Guardant Mass Storage" },
    { 0x0a890030, "Rutoken ECP" },
    { 0x0a890040, "Rutoken ECP HID" },
    { 0x0a890060, "Rutoken Magistra" },
    { 0x0a890061, "Rutoken Magistra" },
    { 0x0a890069, "Reader" },
    { 0x0a890080, "Rutoken PinPad Ex" },
    { 0x0a890081, "Rutoken PinPad In" },
    { 0x0a890082, "Rutoken PinPad 2" },
    { 0x0a8e2011, "Filter Driver For JAE XMC R/W" },
    { 0x0a913801, "Targus PAKP003 Mouse" },
    { 0x0a920011, "SYS WaveTerminal U2A" },
    { 0x0a920021, "GIGAPort" },
    { 0x0a920031, "GIGAPortAG" },
    { 0x0a920053, "AudioTrak Optoplay" },
    { 0x0a920061, "Waveterminal U24" },
    { 0x0a920071, "MAYA EX7" },
    { 0x0a920091, "Maya 44" },
    { 0x0a9200b1, "MAYA EX5" },
    { 0x0a921000, "MIDI Mate" },
    { 0x0a921010, "RoMI/O" },
    { 0x0a921020, "M4U" },
    { 0x0a921030, "M8U" },
    { 0x0a921090, "KeyControl49" },
    { 0x0a9210a0, "KeyControl25" },
    { 0x0a930002, "C-Pen 10" },
    { 0x0a930005, "MyPen Light" },
    { 0x0a93000d, "Input Pen" },
    { 0x0a930010, "C-Pen 20" },
    { 0x0a930a93, "PayPen" },
    { 0x0aa50002, "irock! 500 Series" },
    { 0x0aa50801, "MP3 Player" },
    { 0x0aa60101, "Hercules Jukebox" },
    { 0x0aa61501, "Store 'n' Go HD Drive" },
    { 0x0aa63011, "Tevion MD 81488" },
    { 0x0aa66021, "Disney MixMax" },
    { 0x0aa69601, "MyMusix PD-6070" },
    { 0x0aa69702, "Perception Digital, Ltd Gigaware GX400" },
    { 0x0aa70100, "POS Keyboard, TA58P-USB" },
    { 0x0aa70101, "POS Keyboard, TA85P-USB" },
    { 0x0aa70102, "POS Keyboard, TA59-USB" },
    { 0x0aa70103, "POS Keyboard, TA60-USB" },
    { 0x0aa70104, "SNIkey Keyboard, SNIKey-KB-USB" },
    { 0x0aa70200, "Operator Display, BA63-USB" },
    { 0x0aa70201, "Operator Display, BA66-USB" },
    { 0x0aa70202, "Operator Display & Scanner, XiCheck-BA63" },
    { 0x0aa70203, "Operator Display & Scanner, XiCheck-BA66" },
    { 0x0aa70204, "Graphics Operator Display, BA63GV" },
    { 0x0aa70300, "POS Printer (printer class mode), TH210" },
    { 0x0aa70301, "POS Printer (native mode), TH210" },
    { 0x0aa70302, "POS Printer (printer class mode), TH220" },
    { 0x0aa70303, "POS Printer (native mode), TH220" },
    { 0x0aa70304, "POS Printer, TH230" },
    { 0x0aa70305, "Lottery Printer, XiPrintPlus" },
    { 0x0aa70306, "POS Printer (printer class mode), TH320" },
    { 0x0aa70307, "POS Printer (native mode), TH320" },
    { 0x0aa70308, "POS Printer (printer class mode), TH420" },
    { 0x0aa70309, "POS Printer (native mode), TH420" },
    { 0x0aa7030a, "POS Printer, TH200B" },
    { 0x0aa70400, "Lottery Scanner, Xiscan S" },
    { 0x0aa70401, "Lottery Scanner, Xiscan 3" },
    { 0x0aa70402, "Programmable Magnetic Swipe Card Reader, MSRP-USB" },
    { 0x0aa70500, "IDE Adapter" },
    { 0x0aa70501, "Hub Printer Interface" },
    { 0x0aa70502, "Hub SNIKey Keyboard" },
    { 0x0aa74304, "Banking Printer TP07" },
    { 0x0aa74305, "Banking Printer TP07c" },
    { 0x0aa74500, "WN Central Special Electronics" },
    { 0x0aa80060, "TG 11Mbps WLAN Mini Adapter" },
    { 0x0aa81001, "DreamComboM4100" },
    { 0x0aa83002, "InkJet Color Printer" },
    { 0x0aa88001, "TG_iMON" },
    { 0x0aa88002, "TG_KLOSS" },
    { 0x0aa8a001, "TG_X2" },
    { 0x0aa8a002, "TGVFD_KLOSS" },
    { 0x0aa8ffda, "iMON_VFD" },
    { 0x0aa9f01b, "Medion MD 6242 MP3 Player" },
    { 0x0aad0003, "NRP-Z21" },
    { 0x0aad000c, "NRP-Z11" },
    { 0x0aad0013, "NRP-Z22" },
    { 0x0aad0014, "NRP-Z23" },
    { 0x0aad0015, "NRP-Z24" },
    { 0x0aad0016, "NRP-Z51" },
    { 0x0aad0017, "NRP-Z52" },
    { 0x0aad0018, "NRP-Z55" },
    { 0x0aad0019, "NRP-Z56" },
    { 0x0aad0021, "NRP-Z91" },
    { 0x0aad0023, "NRP-Z81" },
    { 0x0aad002c, "NRP-Z31" },
    { 0x0aad002d, "NRP-Z37" },
    { 0x0aad002f, "NRP-Z27" },
    { 0x0aad0051, "NRP-Z28" },
    { 0x0aad0052, "NRP-Z98" },
    { 0x0aad0062, "NRP-Z92" },
    { 0x0aad0070, "NRP-Z57" },
    { 0x0aad0083, "NRP-Z85" },
    { 0x0aad0095, "NRP-Z86" },
    { 0x0aad0117, "HMF / HMP / HMS-X / HMO series Oscilloscopes" },
    { 0x0aad0118, "HMF / HMP / HMS-X / HMO series Oscilloscopes" },
    { 0x0aad0119, "HMF / HMP / HMS-X / HMO series Oscilloscopes" },
    { 0x0ab10002, "OBID RFID-Reader" },
    { 0x0ab10004, "OBID classic-pro" },
    { 0x0aba8001, "Tracker 110 Protocol Analyzer" },
    { 0x0aba8002, "Explorer 200 Protocol Analyzer" },
    { 0x0abe0101, "SL1200 DAC" },
    { 0x0abf3370, "I2C/SPI Adapter - U2C-12" },
    { 0x0ac80301, "Web Camera" },
    { 0x0ac80302, "ZC0302 Webcam" },
    { 0x0ac80321, "Vimicro generic vc0321 Camera" },
    { 0x0ac80323, "Luxya WC-1200 USB 2.0 Webcam" },
    { 0x0ac80328, "A4Tech PK-130MG" },
    { 0x0ac80336, "Elecom UCAM-DLQ30" },
    { 0x0ac8301b, "ZC0301 Webcam" },
    { 0x0ac8303b, "ZC0303 Webcam" },
    { 0x0ac8305b, "ZC0305 Webcam" },
    { 0x0ac8307b, "USB 1.1 Webcam" },
    { 0x0ac8332d, "Vega USB 2.0 Camera" },
    { 0x0ac83343, "Sirius USB 2.0 Camera" },
    { 0x0ac83370, "Traveler TV 6500 SF Dia-scanner" },
    { 0x0ac83420, "Venus USB2.0 Camera" },
    { 0x0ac8c001, "Sony embedded vimicro Camera" },
    { 0x0ac8c002, "Visual Communication Camera VGP-VCC1" },
    { 0x0ac8c302, "Vega USB 2.0 Camera" },
    { 0x0ac8c303, "Saturn USB 2.0 Camera" },
    { 0x0ac8c326, "Namuga 1.3M Webcam" },
    { 0x0ac8c33f, "Webcam" },
    { 0x0ac8c412, "Lenovo IdeaCentre Web Camera" },
    { 0x0ac8c429, "Lenovo ThinkCentre Web Camera" },
    { 0x0ac8c42d, "Lenovo IdeaCentre Web Camera" },
    { 0x0ac90000, "Backpack CD-ReWriter" },
    { 0x0ac90001, "BACKPACK  2 Cable" },
    { 0x0ac90010, "BACKPACK" },
    { 0x0ac90011, "Backpack 40GB Hard Drive" },
    { 0x0ac90110, "BACKPACK" },
    { 0x0ac90111, "BackPack" },
    { 0x0ac91234, "BACKPACK" },
    { 0x0aca1060, "OPEN NT1 Plus II" },
    { 0x0acd0300, "IDT1221U RS-232 Adapter" },
    { 0x0acd0401, "Spectrum III Hybrid Smartcard Reader" },
    { 0x0acd0630, "Spectrum III Mag-Only Insert Reader (SPT3-355 Series) USB-CDC" },
    { 0x0acd0810, "SecurePIN (IDPA-506100Y) PIN Pad" },
    { 0x0acd2030, "ValueMag Magnetic Stripe Reader" },
    { 0x0acd3710, "ViVOpay Kiosk III" },
    { 0x0ace1201, "ZD1201 802.11b" },
    { 0x0ace1211, "ZD1211 802.11g" },
    { 0x0ace1215, "ZD1211B 802.11g" },
    { 0x0ace1221, "ZD1221 802.11n" },
    { 0x0ace1602, "ZyXEL Omni FaxModem 56K" },
    { 0x0ace1608, "ZyXEL Omni FaxModem 56K UNO" },
    { 0x0ace1611, "ZyXEL Omni FaxModem 56K Plus" },
    { 0x0ace2011, "Virtual media for 802.11bg" },
    { 0x0ace20ff, "Virtual media for 802.11bg" },
    { 0x0acea211, "ZD1211 802.11b/g Wireless Adapter" },
    { 0x0aceb215, "802.11bg" },
    { 0x0ada0005, "DK2" },
    { 0x0aec2101, "SmartMedia Card Reader" },
    { 0x0aec2102, "CompactFlash Card Reader" },
    { 0x0aec2103, "MMC/SD Card Reader" },
    { 0x0aec2104, "MemoryStick Card Reader" },
    { 0x0aec2201, "SmartMedia+CompactFlash Card Reader" },
    { 0x0aec2202, "SmartMedia+MMC/SD Card Reader" },
    { 0x0aec2203, "SmartMedia+MemoryStick Card Reader" },
    { 0x0aec2204, "CompactFlash+MMC/SD Card Reader" },
    { 0x0aec2205, "CompactFlash+MemoryStick Card Reader" },
    { 0x0aec2206, "MMC/SD+MemoryStick Card Reader" },
    { 0x0aec2301, "SmartMedia+CompactFlash+MMC/SD Card Reader" },
    { 0x0aec2302, "SmartMedia+CompactFlash+MemoryStick Card Reader" },
    { 0x0aec2303, "SmartMedia+MMC/SD+MemoryStick Card Reader" },
    { 0x0aec2304, "CompactFlash+MMC/SD+MemoryStick Card Reader" },
    { 0x0aec3016, "MMC/SD+Memory Stick Card Reader" },
    { 0x0aec3050, "ND3050 8-in-1 Card Reader" },
    { 0x0aec3060, "1.1 FS Card Reader" },
    { 0x0aec3101, "MMC/SD Card Reader" },
    { 0x0aec3102, "MemoryStick Card Reader" },
    { 0x0aec3201, "MMC/SD+MemoryStick Card Reader" },
    { 0x0aec3216, "HS Card Reader" },
    { 0x0aec3260, "7-in-1 Card Reader" },
    { 0x0aec5010, "ND5010 Card Reader" },
    { 0x0af05000, "UMTS Card" },
    { 0x0af06000, "GlobeTrotter 3G datacard" },
    { 0x0af06300, "GT 3G Quad UMTS/GPRS Card" },
    { 0x0af06600, "GlobeTrotter 3G+ datacard" },
    { 0x0af06711, "GlobeTrotter Express 7.2 v2" },
    { 0x0af06971, "Globetrotter HSDPA Modem" },
    { 0x0af07251, "Globetrotter HSUPA Modem (aka iCON HSUPA E)" },
    { 0x0af07501, "Globetrotter HSUPA Modem (icon 411 aka \"Vodafone K3760\")" },
    { 0x0af07601, "Globetrotter MO40x 3G Modem (GTM 382)" },
    { 0x0af07701, "Globetrotter HSUPA Modem (aka icon 451)" },
    { 0x0af0d055, "Globetrotter GI0505 [iCON 505]" },
    { 0x0af70101, "Digital TV USB Receiver (DVB-S/T/C / ATSC)" },
    { 0x0af90010, "USB SightCam 100" },
    { 0x0af90011, "Micro Innovations IC50C Webcam" },
    { 0x0afa07d2, "Controller Board for Projected Capacitive Touch Screen DUS3000" },
    { 0x0b050001, "MeMO Pad HD 7 (CD-ROM mode)" },
    { 0x0b050301, "MyPal A696 GPS PDA" },
    { 0x0b051101, "Mass Storage (UISDMC4S)" },
    { 0x0b051706, "WL-167G v1 802.11g Adapter [Ralink RT2571]" },
    { 0x0b051707, "WL-167G v1 802.11g Adapter [Ralink RT2571]" },
    { 0x0b051708, "Mass Storage Device" },
    { 0x0b05170b, "Multi card reader" },
    { 0x0b05170c, "WL-159g 802.11bg [ZyDAS ZD1211B+AL2230]" },
    { 0x0b05170d, "802.11b/g Wireless Network Adapter" },
    { 0x0b051712, "BT-183 Bluetooth 2.0+EDR adapter" },
    { 0x0b051715, "2045 Bluetooth 2.0 Device with trace filter" },
    { 0x0b051716, "Bluetooth Device" },
    { 0x0b051717, "WL169gE 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x0b05171b, "A9T wireless 802.11bg" },
    { 0x0b05171c, "802.11b/g Wireless Network Adapter" },
    { 0x0b05171f, "My Cinema U3000 Mini [DiBcom DiB7700P]" },
    { 0x0b051723, "WL-167G v2 802.11g Adapter [Ralink RT2571W]" },
    { 0x0b051724, "RT2573" },
    { 0x0b051726, "Laptop OLED Display" },
    { 0x0b05172a, "802.11n Network Adapter" },
    { 0x0b05172b, "802.11n Network Adapter" },
    { 0x0b051731, "802.11n Network Adapter" },
    { 0x0b051732, "802.11n Network Adapter" },
    { 0x0b051734, "AF-200" },
    { 0x0b05173c, "BT-183 Bluetooth 2.0" },
    { 0x0b05173f, "My Cinema U3100 Mini" },
    { 0x0b051742, "802.11n Network Adapter" },
    { 0x0b051743, "Xonar U1 Audio Station" },
    { 0x0b051751, "BT-253 Bluetooth Adapter" },
    { 0x0b05175b, "Laptop OLED Display" },
    { 0x0b051760, "802.11n Network Adapter" },
    { 0x0b051761, "USB-N11 802.11n Network Adapter [Ralink RT2870]" },
    { 0x0b051774, "Gobi Wireless Modem (QDL mode)" },
    { 0x0b051776, "Gobi Wireless Modem" },
    { 0x0b051779, "My Cinema U3100 Mini Plus [AF9035A]" },
    { 0x0b051784, "USB-N13 802.11n Network Adapter (rev. A1) [Ralink RT3072]" },
    { 0x0b051786, "USB-N10 802.11n Network Adapter [Realtek RTL8188SU]" },
    { 0x0b051788, "BT-270 Bluetooth Adapter" },
    { 0x0b051791, "WL-167G v3 802.11n Adapter [Realtek RTL8188SU]" },
    { 0x0b05179c, "Bluetooth Adapter" },
    { 0x0b05179d, "USB-N53 802.11abgn Network Adapter [Ralink RT3572]" },
    { 0x0b05179e, "Eee Note EA800 (network mode)" },
    { 0x0b05179f, "Eee Note EA800 (tablet mode)" },
    { 0x0b0517a0, "Xonar U3 sound card" },
    { 0x0b0517a1, "Eee Note EA800 (mass storage mode)" },
    { 0x0b0517ab, "USB-N13 802.11n Network Adapter (rev. B1) [Realtek RTL8192CU]" },
    { 0x0b0517ba, "N10 Nano 802.11n Network Adapter [Realtek RTL8192CU]" },
    { 0x0b0517c2, "ROG Spitfire" },
    { 0x0b0517c7, "WL-330NUL" },
    { 0x0b0517c9, "USB-AC53 802.11a/b/g/n/ac Wireless Adapter [Broadcom BCM43526]" },
    { 0x0b0517cb, "Broadcom BCM20702A0 Bluetooth" },
    { 0x0b0517d1, "AC51 802.11a/b/g/n/ac Wireless Adapter [Mediatek MT7610U]" },
    { 0x0b0517d2, "USB-AC56 802.11a/b/g/n/ac Wireless Adapter [Realtek RTL8812AU]" },
    { 0x0b0517d3, "USB-N10 v2 802.11b/g/n Wireless Adapter [MediaTek MT7601U]" },
    { 0x0b0517db, "USB-AC50 802.11a/b/g/n/ac (1x1) Wireless Adapter [MediaTek MT7610U]" },
    { 0x0b0517e8, "USB-N14 802.11b/g/n (2x2) Wireless Adapter [Ralink RT5372]" },
    { 0x0b0517eb, "USB-AC55 802.11a/b/g/n/ac Wireless Adapter [MediaTek MT7612U]" },
    { 0x0b0517f5, "Xonar U5 sound card" },
    { 0x0b05180a, "Broadcom BCM20702 Single-Chip Bluetooth 4.0 + LE" },
    { 0x0b051817, "USB-AC68 802.11a/b/g/n/ac (4x4) Wireless Adapter [Realtek RTL8814AU]" },
    { 0x0b051825, "Qualcomm Bluetooth 4.1" },
    { 0x0b0518f0, "Realtek 8188EUS [USB-N10 Nano]" },
    { 0x0b054c80, "Asus TF300 Transformer" },
    { 0x0b054c81, "Asus TF300 Transformer (USB debug mode)" },
    { 0x0b054c90, "Asus TF700 Transformer" },
    { 0x0b054c91, "Transformer Pad Infinity TF700 (Debug mode)" },
    { 0x0b054ca0, "Transformer Pad TF701T" },
    { 0x0b054ca1, "Transformer Pad TF701T (Debug mode)" },
    { 0x0b054d00, "Asus TF201 Transformer Prime (keyboard dock)" },
    { 0x0b054d01, "Asus TF201 Transformer Prime (tablet only)" },
    { 0x0b054d04, "Asus TFXXX Transformer Prime (unknown version)" },
    { 0x0b054daf, "Transformer Pad Infinity TF700 (Fastboot)" },
    { 0x0b054e01, "Asus TF101 Eeepad Slider" },
    { 0x0b054e0f, "Asus TF101 Eeepad Transformer" },
    { 0x0b054e1f, "Asus TF101 Eeepad Transformer (debug mode)" },
    { 0x0b055410, "MeMO Pad HD 7 (MTP mode)" },
    { 0x0b055412, "MeMO Pad HD 7 (PTP mode)" },
    { 0x0b05550f, "Fonepad 7" },
    { 0x0b056101, "Cable Modem" },
    { 0x0b05620a, "Remote NDIS Device" },
    { 0x0b057772, "Zenfone GO (ZB500KL) (MTP mode)" },
    { 0x0b057773, "Zenfone GO (ZB500KL) (Debug, MTP mode)" },
    { 0x0b057774, "Zenfone GO (ZB500KL) (RNDIS mode)" },
    { 0x0b057775, "Zenfone GO (ZB500KL) (Debug, RNDIS mode)" },
    { 0x0b057776, "Zenfone GO (ZB500KL) (PTP mode)" },
    { 0x0b057777, "Zenfone GO (ZB500KL) (Debug, PTP mode)" },
    { 0x0b05b700, "Broadcom Bluetooth 2.1" },
    { 0x0b0b106e, "Datamax E-4304" },
    { 0x0b0c0009, "Todos Argos Mini II Smart Card Reader" },
    { 0x0b0c001e, "e.dentifier2 (ABN AMRO electronic banking card reader NL)" },
    { 0x0b0c002e, "C200 smartcard controller (Nordea card reader)" },
    { 0x0b0c003f, "Todos C400 smartcard controller (Handelsbanken card reader)" },
    { 0x0b0c0050, "Argos Mini II Smart Card Reader (CCID)" },
    { 0x0b0d0000, "CenturyCD" },
    { 0x0b0e0305, "Jabra EVOLVE Link MS" },
    { 0x0b0e0311, "Jabra EVOLVE 65" },
    { 0x0b0e0312, "enc060:Buttons Volume up/down/mute + phone [Jabra]" },
    { 0x0b0e0343, "Jabra UC VOICE 150a" },
    { 0x0b0e0348, "Jabra UC VOICE 550a MS" },
    { 0x0b0e034c, "Jabra UC Voice 750 MS" },
    { 0x0b0e034d, "Jabra UC VOICE 750" },
    { 0x0b0e0410, "Jabra SPEAK 410" },
    { 0x0b0e0420, "Jabra SPEAK 510" },
    { 0x0b0e0422, "Jabra SPEAK 510 USB" },
    { 0x0b0e0933, "Jabra Freeway" },
    { 0x0b0e094d, "GN Netcom / Jabra REVO Wireless" },
    { 0x0b0e1017, "Jabra PRO 930" },
    { 0x0b0e1022, "Jabra PRO 9450, Type 9400BS (DECT Headset)" },
    { 0x0b0e1041, "Jabra PRO 9460" },
    { 0x0b0e1900, "Jabra Biz 1900" },
    { 0x0b0e2007, "GN 2000 Stereo Corded Headset" },
    { 0x0b0e2456, "Jabra SPEAK 810" },
    { 0x0b0e245e, "Jabra Link 370" },
    { 0x0b0e620c, "Jabra BT620s" },
    { 0x0b0e9330, "Jabra GN9330 Headset" },
    { 0x0b0ea346, "Jabra Engage 75 Stereo" },
    { 0x0b0ea50a, "Alienware Wireless Gaming Headset AW988" },
    { 0x0b0f0400, "DNxID" },
    { 0x0b1e8007, "Blackhawk USB560-BP JTAG Emulator" },
    { 0x0b20ddee, "Isabella Her Prototype" },
    { 0x0b28100c, "Kenwood Media Keg HD10GB7 Sport Player" },
    { 0x0b300006, "SM Media-Shuttle Card Reader" },
    { 0x0b330020, "ShuttleXpress" },
    { 0x0b330030, "ShuttlePro v2" },
    { 0x0b330401, "RollerMouse Free 2" },
    { 0x0b330700, "RollerMouse Pro" },
    { 0x0b3308a0, "Perfit Mouse" },
    { 0x0b331000, "RollerMouse Red" },
    { 0x0b331010, "Vidamic Technomouse IQ" },
    { 0x0b380003, "Keyboard" },
    { 0x0b380010, "107-Key Keyboard" },
    { 0x0b390001, "Composite USB PS2 Converter" },
    { 0x0b390109, "USB TO Ethernet" },
    { 0x0b390421, "Serial" },
    { 0x0b390801, "USB-Parallel Bridge" },
    { 0x0b390901, "OCT To Fast Ethernet Converter" },
    { 0x0b390c03, "LAN DOCK Serial Converter" },
    { 0x0b3b0163, "TL-WN320G 1.0 WLAN Adapter" },
    { 0x0b3b1601, "Allnet 0193 802.11b Adapter" },
    { 0x0b3b1602, "ZyXEL ZyAIR B200 802.11b Adapter" },
    { 0x0b3b1612, "AIR.Mate 2@net 802.11b Adapter" },
    { 0x0b3b1613, "802.11b Wireless LAN Adapter" },
    { 0x0b3b1620, "Allnet Wireless Network Adapter [Envara WiND512]" },
    { 0x0b3b1630, "QuickWLAN 802.11bg" },
    { 0x0b3b5630, "802.11bg" },
    { 0x0b3b6630, "ZD1211" },
    { 0x0b3ca010, "Simple_Way Printer/Scanner/Copier" },
    { 0x0b3cc000, "Olicard 100" },
    { 0x0b3cc700, "Olicard 100 (Mass Storage mode)" },
    { 0x0b410011, "Crossam2+USB IR commander" },
    { 0x0b430003, "PS2 Controller Converter" },
    { 0x0b430005, "GameCube Adaptor" },
    { 0x0b481003, "Technotrend/Hauppauge USB-Nova" },
    { 0x0b481004, "TT-PCline" },
    { 0x0b481005, "Technotrend/Hauppauge USB-Nova" },
    { 0x0b481006, "Technotrend/Hauppauge DEC3000-s" },
    { 0x0b481007, "TT-micro plus Device" },
    { 0x0b481008, "Technotrend/Hauppauge DEC2000-t" },
    { 0x0b481009, "Technotrend/Hauppauge DEC2540-t" },
    { 0x0b483001, "DVB-S receiver" },
    { 0x0b483002, "DVB-C receiver" },
    { 0x0b483003, "DVB-T receiver" },
    { 0x0b483004, "TT TV-Stick" },
    { 0x0b483005, "TT TV-Stick (8kB EEPROM)" },
    { 0x0b483006, "TT-connect S-2400 DVB-S receiver" },
    { 0x0b483007, "TT-connect S2-3600" },
    { 0x0b483008, "TT-connect" },
    { 0x0b483009, "TT-connect S-2400 DVB-S receiver (8kB EEPROM)" },
    { 0x0b48300a, "TT-connect S2-3650 CI" },
    { 0x0b48300b, "TT-connect C-3650 CI" },
    { 0x0b48300c, "TT-connect T-3650 CI" },
    { 0x0b48300d, "TT-connect CT-3650 CI" },
    { 0x0b48300e, "TT-connect C-2400" },
    { 0x0b483011, "TT-connect S2-4600" },
    { 0x0b483012, "TT-connect CT2-4650 CI" },
    { 0x0b483014, "TT-TVStick CT2-4400" },
    { 0x0b483015, "TT-connect CT2-4650 CI" },
    { 0x0b483017, "TT-connect S2-4650 CI" },
    { 0x0b49064f, "Trance Vibrator" },
    { 0x0b4b0100, "D'music MP3 Player" },
    { 0x0b4d110a, "Graphtec CC200-20" },
    { 0x0b4d1123, "Electronic Cutting Tool [Silhouette Portrait]" },
    { 0x0b4e6500, "MP3 Player" },
    { 0x0b4e8028, "MP3 Player" },
    { 0x0b4e8920, "MP3 Player" },
    { 0x0b510020, "Comfort Keyboard" },
    { 0x0b62000b, "Bluetooth Device" },
    { 0x0b620059, "iBOT2 Webcam" },
    { 0x0b660041, "Xtreme" },
    { 0x0b67555e, "SCB-R9000" },
    { 0x0b6aa132, "WUP-005 [Nintendo Wii U Pro Controller]" },
    { 0x0b7000ba, "iRiver H10 20GB" },
    { 0x0b7a07d0, "Bluetooth Dongle" },
    { 0x0b810001, "Biothentic II smartcard reader with fingerprint sensor" },
    { 0x0b810002, "DFU-Enabled Devices (DFU)" },
    { 0x0b810012, "BioPAD biometric module (DFU + CDC)" },
    { 0x0b810102, "Certis V1 fingerprint reader" },
    { 0x0b810103, "Certis V2 fingerprint reader" },
    { 0x0b810200, "CL1356T / CL1356T5 / CL1356A smartcard readers (CCID)" },
    { 0x0b810201, "CL1356T / CL1356T5 / CL1356A smartcard readers (DFU + CCID)" },
    { 0x0b810220, "CL1356A FFPJP smartcard reader (CCID + HID)" },
    { 0x0b810221, "CL1356A smartcard reader (DFU + CCID + HID)" },
    { 0x0b865100, "XMC5100 Zippy Drive" },
    { 0x0b865110, "XMC5110 Flash Drive" },
    { 0x0b865200, "XMC5200 Zippy Drive" },
    { 0x0b865201, "XMC5200 Zippy Drive" },
    { 0x0b865202, "XMC5200 Zippy Drive" },
    { 0x0b865280, "XMC5280 Storage Drive" },
    { 0x0b86fff0, "ISP5200 Debugger" },
    { 0x0b8c0001, "Interactive Whiteboard Controller (SB6) (HID)" },
    { 0x0b8c00c3, "Sympodium ID350" },
    { 0x0b951720, "10/100 Ethernet" },
    { 0x0b951780, "AX88178" },
    { 0x0b951790, "AX88179 Gigabit Ethernet" },
    { 0x0b956802, "AX68002 KVM Switch SoC" },
    { 0x0b957720, "AX88772" },
    { 0x0b95772a, "AX88772A Fast Ethernet" },
    { 0x0b95772b, "AX88772B" },
    { 0x0b957e2b, "AX88772B Fast Ethernet Controller" },
    { 0x0b977732, "Smart Card Reader" },
    { 0x0b977761, "Oz776 1.1 Hub" },
    { 0x0b977762, "Oz776 SmartCard Reader" },
    { 0x0b977772, "OZ776 CCID Smartcard Reader" },
    { 0x0b9b4012, "Reflex RC-controller Interface" },
    { 0x0baf00e5, "USR6000" },
    { 0x0baf00eb, "USR1120 802.11b Adapter" },
    { 0x0baf00ec, "56K Faxmodem" },
    { 0x0baf00f1, "SureConnect ADSL ATM Adapter" },
    { 0x0baf00f2, "SureConnect ADSL Loader" },
    { 0x0baf00f5, "SureConnect ADSL ATM Adapter" },
    { 0x0baf00f6, "SureConnect ADSL Loader" },
    { 0x0baf00f7, "SureConnect ADSL ATM Adapter" },
    { 0x0baf00f8, "SureConnect ADSL Loader" },
    { 0x0baf00f9, "SureConnect ADSL ATM Adapter" },
    { 0x0baf00fa, "SureConnect ADSL Loader" },
    { 0x0baf00fb, "SureConnect ADSL Ethernet/USB Router" },
    { 0x0baf0111, "USR5420 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x0baf0118, "U5 802.11g Adapter" },
    { 0x0baf011b, "Wireless MAXg Adapter [Broadcom 4320]" },
    { 0x0baf0121, "USR5423 802.11bg Wireless Adapter [ZyDAS ZD1211B]" },
    { 0x0baf0303, "USR5637 56K Faxmodem" },
    { 0x0baf6112, "FaxModem Model 5633" },
    { 0x0bb00100, "Sound Vision Stream" },
    { 0x0bb05007, "3340z/Rollei DC3100" },
    { 0x0bb20302, "U10H010 802.11b Wireless Adapter [Intersil PRISM 3]" },
    { 0x0bb26098, "USB Cable Modem" },
    { 0x0bb40001, "Android Phone via mass storage [Wiko Cink Peax 2]" },
    { 0x0bb400ce, "mmO2 XDA GSM/GPRS Pocket PC" },
    { 0x0bb400cf, "SPV C500 Smart Phone" },
    { 0x0bb40306, "Vive Hub Bluetooth 4.1 (Broadcom BCM920703)" },
    { 0x0bb40a01, "PocketPC Sync" },
    { 0x0bb40a02, "Himalaya GSM/GPRS Pocket PC" },
    { 0x0bb40a03, "PocketPC Sync" },
    { 0x0bb40a04, "PocketPC Sync" },
    { 0x0bb40a05, "PocketPC Sync" },
    { 0x0bb40a06, "PocketPC Sync" },
    { 0x0bb40a07, "Magician PocketPC SmartPhone / O2 XDA" },
    { 0x0bb40a08, "PocketPC Sync" },
    { 0x0bb40a09, "PocketPC Sync" },
    { 0x0bb40a0a, "PocketPC Sync" },
    { 0x0bb40a0b, "PocketPC Sync" },
    { 0x0bb40a0c, "PocketPC Sync" },
    { 0x0bb40a0d, "PocketPC Sync" },
    { 0x0bb40a0e, "PocketPC Sync" },
    { 0x0bb40a0f, "PocketPC Sync" },
    { 0x0bb40a10, "PocketPC Sync" },
    { 0x0bb40a11, "PocketPC Sync" },
    { 0x0bb40a12, "PocketPC Sync" },
    { 0x0bb40a13, "PocketPC Sync" },
    { 0x0bb40a14, "PocketPC Sync" },
    { 0x0bb40a15, "PocketPC Sync" },
    { 0x0bb40a16, "PocketPC Sync" },
    { 0x0bb40a17, "PocketPC Sync" },
    { 0x0bb40a18, "PocketPC Sync" },
    { 0x0bb40a19, "PocketPC Sync" },
    { 0x0bb40a1a, "PocketPC Sync" },
    { 0x0bb40a1b, "PocketPC Sync" },
    { 0x0bb40a1c, "PocketPC Sync" },
    { 0x0bb40a1d, "PocketPC Sync" },
    { 0x0bb40a1e, "PocketPC Sync" },
    { 0x0bb40a1f, "PocketPC Sync" },
    { 0x0bb40a20, "PocketPC Sync" },
    { 0x0bb40a21, "PocketPC Sync" },
    { 0x0bb40a22, "PocketPC Sync" },
    { 0x0bb40a23, "PocketPC Sync" },
    { 0x0bb40a24, "PocketPC Sync" },
    { 0x0bb40a25, "PocketPC Sync" },
    { 0x0bb40a26, "PocketPC Sync" },
    { 0x0bb40a27, "PocketPC Sync" },
    { 0x0bb40a28, "PocketPC Sync" },
    { 0x0bb40a29, "PocketPC Sync" },
    { 0x0bb40a2a, "PocketPC Sync" },
    { 0x0bb40a2b, "PocketPC Sync" },
    { 0x0bb40a2c, "PocketPC Sync" },
    { 0x0bb40a2d, "PocketPC Sync" },
    { 0x0bb40a2e, "PocketPC Sync" },
    { 0x0bb40a2f, "PocketPC Sync" },
    { 0x0bb40a30, "PocketPC Sync" },
    { 0x0bb40a31, "PocketPC Sync" },
    { 0x0bb40a32, "PocketPC Sync" },
    { 0x0bb40a33, "PocketPC Sync" },
    { 0x0bb40a34, "PocketPC Sync" },
    { 0x0bb40a35, "PocketPC Sync" },
    { 0x0bb40a36, "PocketPC Sync" },
    { 0x0bb40a37, "PocketPC Sync" },
    { 0x0bb40a38, "PocketPC Sync" },
    { 0x0bb40a39, "PocketPC Sync" },
    { 0x0bb40a3a, "PocketPC Sync" },
    { 0x0bb40a3b, "PocketPC Sync" },
    { 0x0bb40a3c, "PocketPC Sync" },
    { 0x0bb40a3d, "PocketPC Sync" },
    { 0x0bb40a3e, "PocketPC Sync" },
    { 0x0bb40a3f, "PocketPC Sync" },
    { 0x0bb40a40, "PocketPC Sync" },
    { 0x0bb40a41, "PocketPC Sync" },
    { 0x0bb40a42, "PocketPC Sync" },
    { 0x0bb40a43, "PocketPC Sync" },
    { 0x0bb40a44, "PocketPC Sync" },
    { 0x0bb40a45, "PocketPC Sync" },
    { 0x0bb40a46, "PocketPC Sync" },
    { 0x0bb40a47, "PocketPC Sync" },
    { 0x0bb40a48, "PocketPC Sync" },
    { 0x0bb40a49, "PocketPC Sync" },
    { 0x0bb40a4a, "PocketPC Sync" },
    { 0x0bb40a4b, "PocketPC Sync" },
    { 0x0bb40a4c, "PocketPC Sync" },
    { 0x0bb40a4d, "PocketPC Sync" },
    { 0x0bb40a4e, "PocketPC Sync" },
    { 0x0bb40a4f, "PocketPC Sync" },
    { 0x0bb40a50, "SmartPhone (MTP)" },
    { 0x0bb40a51, "SPV C400 / T-Mobile SDA GSM/GPRS Pocket PC" },
    { 0x0bb40a52, "SmartPhone Sync" },
    { 0x0bb40a53, "SmartPhone Sync" },
    { 0x0bb40a54, "SmartPhone Sync" },
    { 0x0bb40a55, "SmartPhone Sync" },
    { 0x0bb40a56, "SmartPhone Sync" },
    { 0x0bb40a57, "SmartPhone Sync" },
    { 0x0bb40a58, "SmartPhone Sync" },
    { 0x0bb40a59, "SmartPhone Sync" },
    { 0x0bb40a5a, "SmartPhone Sync" },
    { 0x0bb40a5b, "SmartPhone Sync" },
    { 0x0bb40a5c, "SmartPhone Sync" },
    { 0x0bb40a5d, "SmartPhone Sync" },
    { 0x0bb40a5e, "SmartPhone Sync" },
    { 0x0bb40a5f, "SmartPhone Sync" },
    { 0x0bb40a60, "SmartPhone Sync" },
    { 0x0bb40a61, "SmartPhone Sync" },
    { 0x0bb40a62, "SmartPhone Sync" },
    { 0x0bb40a63, "SmartPhone Sync" },
    { 0x0bb40a64, "SmartPhone Sync" },
    { 0x0bb40a65, "SmartPhone Sync" },
    { 0x0bb40a66, "SmartPhone Sync" },
    { 0x0bb40a67, "SmartPhone Sync" },
    { 0x0bb40a68, "SmartPhone Sync" },
    { 0x0bb40a69, "SmartPhone Sync" },
    { 0x0bb40a6a, "SmartPhone Sync" },
    { 0x0bb40a6b, "SmartPhone Sync" },
    { 0x0bb40a6c, "SmartPhone Sync" },
    { 0x0bb40a6d, "SmartPhone Sync" },
    { 0x0bb40a6e, "SmartPhone Sync" },
    { 0x0bb40a6f, "SmartPhone Sync" },
    { 0x0bb40a70, "SmartPhone Sync" },
    { 0x0bb40a71, "SmartPhone Sync" },
    { 0x0bb40a72, "SmartPhone Sync" },
    { 0x0bb40a73, "SmartPhone Sync" },
    { 0x0bb40a74, "SmartPhone Sync" },
    { 0x0bb40a75, "SmartPhone Sync" },
    { 0x0bb40a76, "SmartPhone Sync" },
    { 0x0bb40a77, "SmartPhone Sync" },
    { 0x0bb40a78, "SmartPhone Sync" },
    { 0x0bb40a79, "SmartPhone Sync" },
    { 0x0bb40a7a, "SmartPhone Sync" },
    { 0x0bb40a7b, "SmartPhone Sync" },
    { 0x0bb40a7c, "SmartPhone Sync" },
    { 0x0bb40a7d, "SmartPhone Sync" },
    { 0x0bb40a7e, "SmartPhone Sync" },
    { 0x0bb40a7f, "SmartPhone Sync" },
    { 0x0bb40a80, "SmartPhone Sync" },
    { 0x0bb40a81, "SmartPhone Sync" },
    { 0x0bb40a82, "SmartPhone Sync" },
    { 0x0bb40a83, "SmartPhone Sync" },
    { 0x0bb40a84, "SmartPhone Sync" },
    { 0x0bb40a85, "SmartPhone Sync" },
    { 0x0bb40a86, "SmartPhone Sync" },
    { 0x0bb40a87, "SmartPhone Sync" },
    { 0x0bb40a88, "SmartPhone Sync" },
    { 0x0bb40a89, "SmartPhone Sync" },
    { 0x0bb40a8a, "SmartPhone Sync" },
    { 0x0bb40a8b, "SmartPhone Sync" },
    { 0x0bb40a8c, "SmartPhone Sync" },
    { 0x0bb40a8d, "SmartPhone Sync" },
    { 0x0bb40a8e, "SmartPhone Sync" },
    { 0x0bb40a8f, "SmartPhone Sync" },
    { 0x0bb40a90, "SmartPhone Sync" },
    { 0x0bb40a91, "SmartPhone Sync" },
    { 0x0bb40a92, "SmartPhone Sync" },
    { 0x0bb40a93, "SmartPhone Sync" },
    { 0x0bb40a94, "SmartPhone Sync" },
    { 0x0bb40a95, "SmartPhone Sync" },
    { 0x0bb40a96, "SmartPhone Sync" },
    { 0x0bb40a97, "SmartPhone Sync" },
    { 0x0bb40a98, "SmartPhone Sync" },
    { 0x0bb40a99, "SmartPhone Sync" },
    { 0x0bb40a9a, "SmartPhone Sync" },
    { 0x0bb40a9b, "SmartPhone Sync" },
    { 0x0bb40a9c, "SmartPhone Sync" },
    { 0x0bb40a9d, "SmartPhone Sync" },
    { 0x0bb40a9e, "SmartPhone Sync" },
    { 0x0bb40a9f, "SmartPhone Sync" },
    { 0x0bb40b03, "Ozone Mobile Broadband" },
    { 0x0bb40b04, "Hermes / TyTN / T-Mobile MDA Vario II / O2 Xda Trion" },
    { 0x0bb40b05, "P3600" },
    { 0x0bb40b06, "Athena / Advantage x7500 / Dopod U1000 / T-Mobile AMEO" },
    { 0x0bb40b0c, "Elf / Touch / P3450 / T-Mobile MDA Touch / O2 Xda Nova / Dopod S1" },
    { 0x0bb40b1f, "Sony Ericsson XPERIA X1" },
    { 0x0bb40b2f, "Rhodium" },
    { 0x0bb40b51, "Qtek 8310 mobile phone [Tornado Noble]" },
    { 0x0bb40bce, "Vario MDA" },
    { 0x0bb40c01, "Dream / ADP1 / G1 / Magic / Tattoo / FP1" },
    { 0x0bb40c02, "HTC Zopo ZP100 (ID1)" },
    { 0x0bb40c03, "Android Phone [Fairphone First Edition (FP1)]" },
    { 0x0bb40c13, "Diamond" },
    { 0x0bb40c1f, "Sony Ericsson XPERIA X1" },
    { 0x0bb40c5f, "Snap" },
    { 0x0bb40c86, "Sensation" },
    { 0x0bb40c87, "Desire (debug)" },
    { 0x0bb40c8d, "EVO 4G (debug)" },
    { 0x0bb40c91, "Vision" },
    { 0x0bb40c93, "HTC EVO 4G LTE" },
    { 0x0bb40c94, "Vision" },
    { 0x0bb40c97, "Legend" },
    { 0x0bb40c99, "Desire (debug)" },
    { 0x0bb40c9e, "Incredible" },
    { 0x0bb40ca2, "Desire HD (debug mode)" },
    { 0x0bb40ca5, "Android Phone [Evo Shift 4G]" },
    { 0x0bb40ca8, "HTC EVO 4G LTE (second ID)" },
    { 0x0bb40cab, "Desire / Desire HD / Hero / Thunderbolt (HTC Sync Mode)" },
    { 0x0bb40cae, "T-Mobile MyTouch 4G Slide [Doubleshot]" },
    { 0x0bb40de5, "One (M7)" },
    { 0x0bb40dea, "M7_UL [HTC One]" },
    { 0x0bb40f25, "One M8" },
    { 0x0bb40f63, "Desire 610 Via MTP" },
    { 0x0bb40f64, "Desire 601" },
    { 0x0bb40fb4, "Remote NDIS based Device" },
    { 0x0bb40ff0, "One Mini (M4)" },
    { 0x0bb40ff8, "Desire HD (Tethering Mode)" },
    { 0x0bb40ff9, "Desire / Desire HD / Hero / Thunderbolt (Charge Mode)" },
    { 0x0bb40ffe, "Desire HD (modem mode)" },
    { 0x0bb40fff, "Android Fastboot Bootloader" },
    { 0x0bb42008, "HTC Zopo ZP100 (ID2)" },
    { 0x0bb4200b, "Android Phone via PTP [Wiko Cink Peax 2]" },
    { 0x0bb42134, "Vive Hub (SMSC USB2137B)" },
    { 0x0bb42744, "Vive Hub (HTC CB USB2)" },
    { 0x0bb42c87, "Vive" },
    { 0x0bb4685c, "Hewlett-Packard HP Touchpad" },
    { 0x0bc20502, "ST3300601CB-RK 300 GB External Hard Drive" },
    { 0x0bc20503, "ST3250824A [Barracuda 7200.9]" },
    { 0x0bc22000, "Storage Adapter V3 (TPP)" },
    { 0x0bc22100, "FreeAgent Go" },
    { 0x0bc22200, "FreeAgent Go FW" },
    { 0x0bc22300, "Expansion Portable" },
    { 0x0bc2231a, "Expansion Portable" },
    { 0x0bc2231c, "Expansion Portable" },
    { 0x0bc22320, "USB 3.0 bridge [Portable Expansion Drive]" },
    { 0x0bc22321, "Expansion Portable" },
    { 0x0bc22322, "SRD0NF1 Expansion Portable (STEA)" },
    { 0x0bc22340, "FreeAgent External Hard Drive" },
    { 0x0bc23000, "FreeAgent Desktop" },
    { 0x0bc23008, "FreeAgent Desk 1TB" },
    { 0x0bc23101, "FreeAgent XTreme 640GB" },
    { 0x0bc23312, "SRD00F2 Expansion Desktop Drive (STBV)" },
    { 0x0bc2331a, "Desktop HDD 5TB (ST5000DM000)" },
    { 0x0bc23320, "SRD00F2 [Expansion Desktop Drive]" },
    { 0x0bc23322, "SRD0NF2 [Expansion Desktop Drive]" },
    { 0x0bc23323, "Seagate RSS LLC" },
    { 0x0bc23332, "Expansion" },
    { 0x0bc23343, "desktop drive stgy8000400" },
    { 0x0bc25020, "FreeAgent GoFlex" },
    { 0x0bc25021, "FreeAgent GoFlex USB 2.0" },
    { 0x0bc25030, "FreeAgent GoFlex Upgrade Cable STAE104" },
    { 0x0bc25031, "FreeAgent GoFlex USB 3.0" },
    { 0x0bc25032, "SATA cable" },
    { 0x0bc25070, "FreeAgent GoFlex Desk" },
    { 0x0bc25071, "FreeAgent GoFlex Desk" },
    { 0x0bc250a1, "FreeAgent GoFlex Desk" },
    { 0x0bc250a5, "FreeAgent GoFlex Desk USB 3.0" },
    { 0x0bc25121, "FreeAgent GoFlex" },
    { 0x0bc25161, "FreeAgent GoFlex dock" },
    { 0x0bc26126, "Maxtor D3 Station 5TB" },
    { 0x0bc261b5, "Maxtor HX-M201TCB [M3 Portable 2TB]" },
    { 0x0bc261b6, "Maxtor HX-M101TCB/GM [M3 Portable 1TB]" },
    { 0x0bc261b7, "Maxtor M3 Portable" },
    { 0x0bc2a003, "Backup Plus" },
    { 0x0bc2a0a1, "Backup Plus Desktop" },
    { 0x0bc2a0a4, "Backup Plus Desktop Drive" },
    { 0x0bc2aa14, "STJ4000400 [Seagate Basic Portable Drive 4TB]" },
    { 0x0bc2ab00, "Slim Portable Drive" },
    { 0x0bc2ab1e, "Backup Plus Portable Drive" },
    { 0x0bc2ab20, "Backup Plus Portable Drive" },
    { 0x0bc2ab21, "Backup Plus Slim" },
    { 0x0bc2ab24, "Backup Plus Portable Drive" },
    { 0x0bc2ab26, "Backup Plus Slim Portable Drive 1 TB" },
    { 0x0bc2ab28, "Seagate Backup Plus Portable 5TB SRD00F1" },
    { 0x0bc2ab2d, "SRD00F1 [Backup Plus Ultra Slim]" },
    { 0x0bc2ab31, "Backup Plus Desktop Drive (5TB)" },
    { 0x0bc2ab34, "Backup Plus" },
    { 0x0bc2ab38, "Backup Plus Hub (Mass Storage)" },
    { 0x0bc2ab44, "Backup Plus Hub" },
    { 0x0bc2ac20, "Backup Plus Slim 2TB" },
    { 0x0bc30001, "UMTS-TDD (TD-CDMA) modem" },
    { 0x0bc70001, "ActiveHome (ACPI-compliant)" },
    { 0x0bc70002, "Firecracker Interface (ACPI-compliant)" },
    { 0x0bc70003, "VGA Video Sender (ACPI-compliant)" },
    { 0x0bc70004, "X10 Receiver" },
    { 0x0bc70005, "Wireless Transceiver (ACPI-compliant)" },
    { 0x0bc70006, "Wireless Transceiver (ACPI-compliant)" },
    { 0x0bc70007, "Wireless Transceiver (ACPI-compliant)" },
    { 0x0bc70008, "Wireless Transceiver (ACPI-compliant)" },
    { 0x0bc70009, "Wireless Transceiver (ACPI-compliant)" },
    { 0x0bc7000a, "Wireless Transceiver (ACPI-compliant)" },
    { 0x0bc7000b, "Transceiver (ACPI-compliant)" },
    { 0x0bc7000c, "Transceiver (ACPI-compliant)" },
    { 0x0bc7000d, "Transceiver (ACPI-compliant)" },
    { 0x0bc7000e, "Transceiver (ACPI-compliant)" },
    { 0x0bc7000f, "Transceiver (ACPI-compliant)" },
    { 0x0bd7a021, "Amptek DP4 multichannel signal analyzer" },
    { 0x0bda0103, "USB 2.0 Card Reader" },
    { 0x0bda0104, "Mass Storage Device" },
    { 0x0bda0106, "Mass Storage Device" },
    { 0x0bda0107, "Mass Storage Device" },
    { 0x0bda0108, "Mass Storage Device" },
    { 0x0bda0109, "microSDXC Card Reader [Hama 00091047]" },
    { 0x0bda0111, "RTS5111 Card Reader Controller" },
    { 0x0bda0113, "Mass Storage Device" },
    { 0x0bda0115, "Mass Storage Device (Multicard Reader)" },
    { 0x0bda0116, "RTS5116 Card Reader Controller" },
    { 0x0bda0117, "Mass Storage Device" },
    { 0x0bda0118, "Mass Storage Device" },
    { 0x0bda0119, "Storage Device (SD card reader)" },
    { 0x0bda0129, "RTS5129 Card Reader Controller" },
    { 0x0bda0138, "RTS5138 Card Reader Controller" },
    { 0x0bda0139, "RTS5139 Card Reader Controller" },
    { 0x0bda0151, "Mass Storage Device (Multicard Reader)" },
    { 0x0bda0152, "Mass Storage Device" },
    { 0x0bda0153, "3-in-1 (SD/SDHC/SDXC) Card Reader" },
    { 0x0bda0156, "Mass Storage Device" },
    { 0x0bda0157, "Mass Storage Device" },
    { 0x0bda0158, "USB 2.0 multicard reader" },
    { 0x0bda0159, "RTS5159 Card Reader Controller" },
    { 0x0bda0161, "Mass Storage Device" },
    { 0x0bda0168, "Mass Storage Device" },
    { 0x0bda0169, "Mass Storage Device" },
    { 0x0bda0171, "Mass Storage Device" },
    { 0x0bda0176, "Mass Storage Device" },
    { 0x0bda0178, "Mass Storage Device" },
    { 0x0bda0179, "RTL8188ETV Wireless LAN 802.11n Network Adapter" },
    { 0x0bda0184, "RTS5182 Card Reader" },
    { 0x0bda0186, "Card Reader" },
    { 0x0bda0301, "multicard reader" },
    { 0x0bda0307, "Card Reader" },
    { 0x0bda0316, "Card Reader" },
    { 0x0bda0326, "Card reader" },
    { 0x0bda0411, "Hub" },
    { 0x0bda0811, "Realtek 8812AU/8821AU 802.11ac WLAN Adapter [USB Wireless Dual-Band Adapter 2.4/5Ghz]" },
    { 0x0bda0821, "RTL8821A Bluetooth" },
    { 0x0bda1724, "RTL8723AU 802.11n WLAN Adapter" },
    { 0x0bda1a2b, "RTL8188GU 802.11n WLAN Adapter (Driver CDROM Mode)" },
    { 0x0bda2831, "RTL2831U DVB-T" },
    { 0x0bda2832, "RTL2832U DVB-T" },
    { 0x0bda2838, "RTL2838 DVB-T" },
    { 0x0bda5401, "RTL 8153 USB 3.0 hub with gigabit ethernet" },
    { 0x0bda5411, "RTS5411 Hub" },
    { 0x0bda568c, "Integrated Webcam HD" },
    { 0x0bda570c, "Asus laptop camera" },
    { 0x0bda5730, "HP 2.0MP High Definition Webcam" },
    { 0x0bda5751, "Integrated Webcam" },
    { 0x0bda5775, "HP \"Truevision HD\" laptop camera" },
    { 0x0bda5776, "HP Truevision HD integrated webcam" },
    { 0x0bda57b3, "Acer 640 \303\227 480 laptop camera" },
    { 0x0bda57cc, "HD Webcam - Realtek Semiconductor" },
    { 0x0bda57cf, "HD WebCam" },
    { 0x0bda57da, "Built-In Video Camera" },
    { 0x0bda58c2, "Integrated Webcam HD" },
    { 0x0bda58c8, "Integrated Webcam HD" },
    { 0x0bda8150, "RTL8150 Fast Ethernet Adapter" },
    { 0x0bda8151, "RTL8151 Adapteon Business Mobile Networks BV" },
    { 0x0bda8152, "RTL8152 Fast Ethernet Adapter" },
    { 0x0bda8153, "RTL8153 Gigabit Ethernet Adapter" },
    { 0x0bda8171, "RTL8188SU 802.11n WLAN Adapter" },
    { 0x0bda8172, "RTL8191SU 802.11n WLAN Adapter" },
    { 0x0bda8174, "RTL8192SU 802.11n WLAN Adapter" },
    { 0x0bda8176, "RTL8188CUS 802.11n WLAN Adapter" },
    { 0x0bda8178, "RTL8192CU 802.11n WLAN Adapter" },
    { 0x0bda8179, "RTL8188EUS 802.11n Wireless Network Adapter" },
    { 0x0bda817f, "RTL8188RU 802.11n WLAN Adapter" },
    { 0x0bda8187, "RTL8187 Wireless Adapter" },
    { 0x0bda8189, "RTL8187B Wireless 802.11g 54Mbps Network Adapter" },
    { 0x0bda818b, "RTL8192EU 802.11b/g/n WLAN Adapter" },
    { 0x0bda8192, "RTL8191SU 802.11n Wireless Adapter" },
    { 0x0bda8193, "RTL8192DU 802.11an WLAN Adapter" },
    { 0x0bda8197, "RTL8187B Wireless Adapter" },
    { 0x0bda8198, "RTL8187B Wireless Adapter" },
    { 0x0bda8199, "RTL8187SU 802.11g WLAN Adapter" },
    { 0x0bda8723, "RTL8723A Bluetooth" },
    { 0x0bda8812, "RTL8812AU 802.11a/b/g/n/ac 2T2R DB WLAN Adapter" },
    { 0x0bda8813, "RTL8814AU 802.11a/b/g/n/ac Wireless Adapter" },
    { 0x0bda881a, "RTL8812AU-VS 802.11a/b/g/n/ac 2T2R DB WLAN Adapter" },
    { 0x0bda8821, "RTL8821A Bluetooth" },
    { 0x0bda9210, "RTL9210 M.2 NVME Adapter" },
    { 0x0bdaa811, "RTL8811AU 802.11a/b/g/n/ac WLAN Adapter" },
    { 0x0bdab009, "Realtek Bluetooth 4.2 Adapter" },
    { 0x0bdab00a, "Realtek Bluetooth 4.2 Adapter" },
    { 0x0bdab00b, "Realtek Bluetooth 4.2 Adapter" },
    { 0x0bdab023, "RTL8822BE Bluetooth 4.2 Adapter" },
    { 0x0bdab711, "RTL8188GU 802.11n WLAN Adapter (After Modeswitch)" },
    { 0x0bdab720, "RTL8723BU 802.11b/g/n WLAN Adapter" },
    { 0x0bdab723, "RTL8723B Bluetooth" },
    { 0x0bdab728, "RTL8723B Bluetooth" },
    { 0x0bdab72a, "RTL8723B Bluetooth" },
    { 0x0bdab812, "RTL88x2bu [AC1200 Techkey]" },
    { 0x0bdaf179, "RTL8188FTV 802.11b/g/n 1T1R 2.4G WLAN Adapter" },
    { 0x0bdb1000, "BV Bluetooth Device" },
    { 0x0bdb1002, "Bluetooth Device 1.2" },
    { 0x0bdb1049, "C3607w Mobile Broadband Module" },
    { 0x0bdb1900, "F3507g Mobile Broadband Module" },
    { 0x0bdb1902, "F3507g v2 Mobile Broadband Module" },
    { 0x0bdb1904, "F3607gw Mobile Broadband Module" },
    { 0x0bdb1905, "F3607gw v2 Mobile Broadband Module" },
    { 0x0bdb1906, "F3607gw v3 Mobile Broadband Module" },
    { 0x0bdb1909, "F3307 v2 Mobile Broadband Module" },
    { 0x0bdb190a, "F3307 Mobile Broadband Module" },
    { 0x0bdb190b, "C3607w v2 Mobile Broadband Module" },
    { 0x0bdb1926, "H5321 gw Mobile Broadband Module" },
    { 0x0bed1100, "CASHFLOW SC" },
    { 0x0bed1101, "Series 2000 Combo Acceptor" },
    { 0x0bf0c010, "EHD100SD" },
    { 0x0bf10001, "netMod Driver Ver 2.4.17 (CAPI)" },
    { 0x0bf10002, "netMod Driver Ver 2.4 (CAPI)" },
    { 0x0bf10003, "netMod Driver Ver 2.4 (CAPI)" },
    { 0x0bf60103, "Storage Device" },
    { 0x0bf61234, "Storage Device" },
    { 0x0bf6a000, "Cable 205 (TPP)" },
    { 0x0bf6a001, "Cable 205" },
    { 0x0bf6a002, "IDE Bridge" },
    { 0x0bf81001, "Fujitsu Pocket Loox 600 PDA" },
    { 0x0bf81006, "SmartCard Reader 2A" },
    { 0x0bf81007, "Connect2Air E-5400 802.11g Wireless Adapter" },
    { 0x0bf81009, "Connect2Air E-5400 D1700 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x0bf8100c, "Keyboard FSC KBPC PX" },
    { 0x0bf8100f, "miniCard D2301 802.11bg Wireless Module [SiS 163U]" },
    { 0x0bf81017, "Keyboard KB SCR" },
    { 0x0bf8101f, "Fujitsu Full HD Pro Webcam" },
    { 0x0bfb0200, "TURBO iDDR Front Panel" },
    { 0x0bfd0004, "USBcan II" },
    { 0x0bfd000b, "Leaf Light HS" },
    { 0x0bfd000e, "Leaf SemiPro HS" },
    { 0x0c001607, "Apex M500" },
    { 0x0c080378, "Q 16MB Storage Device" },
    { 0x0c09a5a5, "Litto Version USB2.0" },
    { 0x0c0a6124, "RocketStor 6124V" },
    { 0x0c0b27cb, "6-in-1 Flash Reader and Writer" },
    { 0x0c0b27d7, "Multi Memory reader/writer MD-005" },
    { 0x0c0b27da, "Multi Memory reader/writer MD-005" },
    { 0x0c0b27dc, "Multi Memory reader/writer MD-005" },
    { 0x0c0b27e7, "3,5'' HDD case MD-231" },
    { 0x0c0b27ee, "3,5'' HDD case MD-231" },
    { 0x0c0b2814, "3,5'' HDD case MD-231" },
    { 0x0c0b2815, "3,5'' HDD case MD-231" },
    { 0x0c0b281d, "3,5'' HDD case MD-231" },
    { 0x0c0b5fab, "Storage Adaptor" },
    { 0x0c0ba109, "CF/SM Reader and Writer" },
    { 0x0c0ba10c, "SD/MS Reader and Writer" },
    { 0x0c0bb001, "USB 2.0 Mass Storage IDE adapter" },
    { 0x0c0bb004, "MMC/SD Reader and Writer" },
    { 0x0c120005, "PSX Vibration Feedback Converter / Intec Wireless Controller for Xbox" },
    { 0x0c120030, "PSX Vibration Feedback Converter" },
    { 0x0c12700e, "Logic Analyzer (LAP-C-16032)" },
    { 0x0c128801, "Nyko Xbox Controller" },
    { 0x0c128802, "Xbox Controller" },
    { 0x0c128809, "Red Octane Ignition Xbox DDR Pad" },
    { 0x0c12880a, "Pelican Eclipse PL-2023" },
    { 0x0c128810, "Xbox Controller" },
    { 0x0c129902, "VibraX" },
    { 0x0c160002, "RF Technology Receiver" },
    { 0x0c160003, "RF Technology Receiver" },
    { 0x0c160008, "RF Technology Receiver" },
    { 0x0c160080, "eHome Infrared Receiver" },
    { 0x0c160081, "eHome Infrared Receiver" },
    { 0x0c1f1800, "Tango 2E" },
    { 0x0c240001, "Bluetooth Adaptor" },
    { 0x0c240002, "Bluetooth Device2" },
    { 0x0c240005, "Bluetooth Device(BC04-External)" },
    { 0x0c24000b, "Bluetooth Device(BC04-External)" },
    { 0x0c24000c, "Bluetooth Adaptor" },
    { 0x0c24000e, "Bluetooth Device(BC04-External)" },
    { 0x0c24000f, "Bluetooth Device (V2.0+EDR)" },
    { 0x0c240010, "Bluetooth Device(BC04-External)" },
    { 0x0c240012, "Bluetooth Device(BC04-External)" },
    { 0x0c240018, "Bluetooth Device(BC04-External)" },
    { 0x0c240019, "Bluetooth Device" },
    { 0x0c240021, "Bluetooth Device (V2.1+EDR)" },
    { 0x0c240c24, "Bluetooth Device(SAMPLE)" },
    { 0x0c24ffff, "Bluetooth module with BlueCore in DFU mode" },
    { 0x0c250310, "Scream Cam" },
    { 0x0c260018, "USB-Serial Controller [Icom Inc. OPC-478UC]" },
    { 0x0c26002b, "Icom Inc. IC-R30" },
    { 0x0c27232a, "pcProx Plus RFID Reader (CDC serial)" },
    { 0x0c273bfa, "pcProx Card Reader" },
    { 0x0c2e0007, "Metrologic MS7120 Barcode Scanner (IBM SurePOS mode)" },
    { 0x0c2e0200, "MS7120 Barcode Scanner" },
    { 0x0c2e0204, "Metrologic MS7120 Barcode Scanner (keyboard mode)" },
    { 0x0c2e0206, "Metrologic MS4980 Barcode Scanner" },
    { 0x0c2e0700, "Metrologic MS7120 Barcode Scanner (uni-directional serial mode)" },
    { 0x0c2e0720, "Metrologic MS7120 Barcode Scanner (bi-directional serial mode)" },
    { 0x0c2e0a64, "[Stratos 2700]" },
    { 0x0c2e0b61, "Vuquest 3310g" },
    { 0x0c2e0b6a, "Vuquest 3310 Area-Imaging Scanner" },
    { 0x0c2e0b81, "Barcode scanner Voyager 1400g Series" },
    { 0x0c306010, "Kona 1400 Cutting Plotter" },
    { 0x0c408000, "2.4GHz receiver" },
    { 0x0c440021, "iDEN P2k0 Device" },
    { 0x0c440022, "iDEN P2k1 Device" },
    { 0x0c4403a2, "iDEN Smartphone" },
    { 0x0c4441d9, "i1 phone" },
    { 0x0c450011, "EBUDDY" },
    { 0x0c450520, "MaxTrack Wireless Mouse" },
    { 0x0c451018, "Compact Flash storage memory card reader" },
    { 0x0c451020, "Mass Storage Reader" },
    { 0x0c451028, "Mass Storage Reader" },
    { 0x0c451030, "Mass Storage Reader" },
    { 0x0c451031, "Sonix Mass Storage Device" },
    { 0x0c451032, "Mass Storage Reader" },
    { 0x0c451033, "Sonix Mass Storage Device" },
    { 0x0c451034, "Mass Storage Reader" },
    { 0x0c451035, "Mass Storage Reader" },
    { 0x0c451036, "Mass Storage Reader" },
    { 0x0c451037, "Sonix Mass Storage Device" },
    { 0x0c451050, "CF Card Reader" },
    { 0x0c451058, "HDD Reader" },
    { 0x0c451060, "iFlash SM-Direct Card Reader" },
    { 0x0c451061, "Mass Storage Reader" },
    { 0x0c451062, "Mass Storage Reader" },
    { 0x0c451063, "Sonix Mass Storage Device" },
    { 0x0c451064, "Mass Storage Reader" },
    { 0x0c451065, "Mass Storage Reader" },
    { 0x0c451066, "Mass Storage Reader" },
    { 0x0c451067, "Mass Storage Reader" },
    { 0x0c451158, "A56AK" },
    { 0x0c45184c, "VoIP Phone" },
    { 0x0c451a90, "2M pixel Microscope Camera (with capture button) [Andonstar V160]" },
    { 0x0c455004, "Redragon Mitra RGB Keyboard" },
    { 0x0c455101, "2.4G Wireless Device [Rii MX3]" },
    { 0x0c456001, "Genius VideoCAM NB" },
    { 0x0c456005, "Sweex Mini Webcam" },
    { 0x0c456007, "VideoCAM Eye" },
    { 0x0c456009, "VideoCAM ExpressII" },
    { 0x0c45600d, "TwinkleCam USB camera" },
    { 0x0c456011, "PC Camera (SN9C102)" },
    { 0x0c456019, "PC Camera (SN9C102)" },
    { 0x0c456024, "VideoCAM ExpressII" },
    { 0x0c456025, "VideoCAM ExpressII" },
    { 0x0c456028, "Typhoon Easycam USB 330K (older)" },
    { 0x0c456029, "Triplex i-mini PC Camera" },
    { 0x0c45602a, "Meade ETX-105EC Camera" },
    { 0x0c45602b, "VideoCAM NB 300" },
    { 0x0c45602c, "Clas Ohlson TWC-30XOP Webcam" },
    { 0x0c45602d, "VideoCAM ExpressII" },
    { 0x0c45602e, "VideoCAM Messenger" },
    { 0x0c456030, "VideoCAM ExpressII" },
    { 0x0c45603f, "VideoCAM ExpressII" },
    { 0x0c456040, "CCD PC Camera (PC390A)" },
    { 0x0c45606a, "CCD PC Camera (PC390A)" },
    { 0x0c45607a, "CCD PC Camera (PC390A)" },
    { 0x0c45607b, "Win2 PC Camera" },
    { 0x0c45607c, "CCD PC Camera (PC390A)" },
    { 0x0c45607e, "CCD PC Camera (PC390A)" },
    { 0x0c456080, "Audio (Microphone)" },
    { 0x0c456082, "VideoCAM Look" },
    { 0x0c456083, "VideoCAM Look" },
    { 0x0c45608c, "VideoCAM Look" },
    { 0x0c45608e, "VideoCAM Look" },
    { 0x0c45608f, "PC Camera (SN9C103 + OV7630)" },
    { 0x0c4560a8, "VideoCAM Look" },
    { 0x0c4560aa, "VideoCAM Look" },
    { 0x0c4560ab, "PC Camera" },
    { 0x0c4560af, "VideoCAM Look" },
    { 0x0c4560b0, "Genius VideoCam Look" },
    { 0x0c4560c0, "PC Camera with Mic (SN9C105)" },
    { 0x0c4560c8, "Win2 PC Camera" },
    { 0x0c4560cc, "PC Camera with Mic (SN9C105)" },
    { 0x0c4560ec, "PC Camera with Mic (SN9C105)" },
    { 0x0c4560ef, "Win2 PC Camera" },
    { 0x0c4560fa, "PC Camera with Mic (SN9C105)" },
    { 0x0c4560fb, "Composite Device" },
    { 0x0c4560fc, "PC Camera with Mic (SN9C105)" },
    { 0x0c4560fe, "Audio (Microphone)" },
    { 0x0c456108, "Win2 PC Camera" },
    { 0x0c456122, "PC Camera (SN9C110)" },
    { 0x0c456123, "PC Camera (SN9C110)" },
    { 0x0c456128, "PC Camera (SN9C325 + OM6802)" },
    { 0x0c45612a, "PC Camera (SN9C325)" },
    { 0x0c45612c, "PC Camera (SN9C110)" },
    { 0x0c45612e, "PC Camera (SN9C110)" },
    { 0x0c45612f, "PC Camera (SN9C110)" },
    { 0x0c456130, "PC Camera (SN9C120)" },
    { 0x0c456138, "Win2 PC Camera" },
    { 0x0c45613a, "PC Camera (SN9C120)" },
    { 0x0c45613b, "Win2 PC Camera" },
    { 0x0c45613c, "PC Camera (SN9C120)" },
    { 0x0c45613e, "PC Camera (SN9C120)" },
    { 0x0c456143, "PC Camera (SN9C120 + SP80708)" },
    { 0x0c456240, "PC Camera (SN9C201 + MI1300)" },
    { 0x0c456242, "PC Camera (SN9C201 + MI1310)" },
    { 0x0c456243, "PC Camera (SN9C201 + S5K4AAFX)" },
    { 0x0c456248, "PC Camera (SN9C201 + OV9655)" },
    { 0x0c45624b, "PC Camera (SN9C201 + CX1332)" },
    { 0x0c45624c, "PC Camera (SN9C201 + MI1320)" },
    { 0x0c45624e, "PC Camera (SN9C201 + SOI968)" },
    { 0x0c45624f, "PC Camera (SN9C201 + OV9650)" },
    { 0x0c456251, "PC Camera (SN9C201 + OV9650)" },
    { 0x0c456253, "PC Camera (SN9C201 + OV9650)" },
    { 0x0c456260, "PC Camera (SN9C201 + OV7670ISP)" },
    { 0x0c456262, "PC Camera (SN9C201 + OM6802)" },
    { 0x0c456270, "PC Camera (SN9C201 + MI0360/MT9V011 or MI0360SOC/MT9V111) U-CAM PC Camera NE878, Whitcom WHC017, ..." },
    { 0x0c45627a, "PC Camera (SN9C201 + S5K53BEB)" },
    { 0x0c45627b, "PC Camera (SN9C201 + OV7660)" },
    { 0x0c45627c, "PC Camera (SN9C201 + HV7131R)" },
    { 0x0c45627f, "PC Camera (SN9C201 + OV965x + EEPROM)" },
    { 0x0c456280, "PC Camera with Microphone (SN9C202 + MI1300)" },
    { 0x0c456282, "PC Camera with Microphone (SN9C202 + MI1310)" },
    { 0x0c456283, "PC Camera with Microphone (SN9C202 + S5K4AAFX)" },
    { 0x0c456288, "PC Camera with Microphone (SN9C202 + OV9655)" },
    { 0x0c45628a, "PC Camera with Microphone (SN9C202 + ICM107)" },
    { 0x0c45628b, "PC Camera with Microphone (SN9C202 + CX1332)" },
    { 0x0c45628c, "PC Camera with Microphone (SN9C202 + MI1320)" },
    { 0x0c45628e, "PC Camera with Microphone (SN9C202 + SOI968)" },
    { 0x0c45628f, "PC Camera with Microphone (SN9C202 + OV9650)" },
    { 0x0c4562a0, "PC Camera with Microphone (SN9C202 + OV7670ISP)" },
    { 0x0c4562a2, "PC Camera with Microphone (SN9C202 + OM6802)" },
    { 0x0c4562b0, "PC Camera with Microphone (SN9C202 + MI0360/MT9V011 or MI0360SOC/MT9V111)" },
    { 0x0c4562b3, "PC Camera with Microphone (SN9C202 + OV9655)" },
    { 0x0c4562ba, "PC Camera with Microphone (SN9C202 + S5K53BEB)" },
    { 0x0c4562bb, "PC Camera with Microphone (SN9C202 + OV7660)" },
    { 0x0c4562bc, "PC Camera with Microphone (SN9C202 + HV7131R)" },
    { 0x0c4562be, "PC Camera with Microphone (SN9C202 + OV7663)" },
    { 0x0c4562c0, "Sonix USB 2.0 Camera" },
    { 0x0c4562e0, "MSI Starcam Racer" },
    { 0x0c456300, "PC Microscope camera" },
    { 0x0c456310, "Sonix USB 2.0 Camera" },
    { 0x0c456321, "HP Integrated Webcam" },
    { 0x0c456340, "Camera" },
    { 0x0c456341, "Defender G-Lens 2577 HD720p Camera" },
    { 0x0c456366, "Webcam Vitade AF" },
    { 0x0c4563e0, "Sonix Integrated Webcam" },
    { 0x0c4563f1, "Integrated Webcam" },
    { 0x0c4563f8, "Sonix Integrated Webcam" },
    { 0x0c456409, "Webcam" },
    { 0x0c456413, "Integrated Webcam" },
    { 0x0c456417, "Integrated Webcam" },
    { 0x0c456419, "Integrated Webcam" },
    { 0x0c45641d, "1.3 MPixel Integrated Webcam" },
    { 0x0c456433, "Laptop Integrated Webcam HD (Composite Device)" },
    { 0x0c45643f, "Dell Integrated HD Webcam" },
    { 0x0c45644d, "1.3 MPixel Integrated Webcam" },
    { 0x0c456480, "Sonix 1.3 MP Laptop Integrated Webcam" },
    { 0x0c45648b, "Integrated Webcam" },
    { 0x0c4564ad, "Dell Laptop Integrated Webcam HD" },
    { 0x0c4564bd, "Sony Visual Communication Camera" },
    { 0x0c4564d0, "Integrated Webcam" },
    { 0x0c4564d2, "Integrated Webcam" },
    { 0x0c45651b, "HP Webcam" },
    { 0x0c45652f, "Backlit Gaming Keyboard" },
    { 0x0c456705, "Integrated HD Webcam" },
    { 0x0c45670c, "Integrated Webcam HD" },
    { 0x0c456710, "Integrated Webcam" },
    { 0x0c456712, "Integrated Webcam HD" },
    { 0x0c45671d, "Integrated_Webcam_HD" },
    { 0x0c457401, "TEMPer Temperature Sensor" },
    { 0x0c457402, "TEMPerHUM Temperature & Humidity Sensor" },
    { 0x0c457403, "Foot Switch" },
    { 0x0c457404, "Foot switch FS1-P" },
    { 0x0c458000, "DC31VC" },
    { 0x0c458006, "Dual Mode Camera (8006 VGA)" },
    { 0x0c45800a, "Vivitar Vivicam3350B" },
    { 0x0c4a0889, "Timy" },
    { 0x0c4a088a, "Timy 2" },
    { 0x0c4b0100, "cyberJack e-com/pinpad" },
    { 0x0c4b0300, "cyberJack pinpad(a)" },
    { 0x0c4b0400, "cyberJack e-com(a)" },
    { 0x0c4b0401, "cyberJack pinpad(a2)" },
    { 0x0c4b0500, "cyberJack RFID standard dual interface smartcard reader" },
    { 0x0c4b0501, "cyberJack RFID comfort dual interface smartcard reader" },
    { 0x0c4b0502, "cyberJack compact" },
    { 0x0c4b0504, "cyberJack go / go plus" },
    { 0x0c4b0505, "cyberJack wave" },
    { 0x0c4b9102, "cyberJack RFID basis contactless smartcard reader" },
    { 0x0c4c0021, "EMP-21 Universal Programmer" },
    { 0x0c522101, "SeaLINK+232" },
    { 0x0c522102, "SeaLINK+485" },
    { 0x0c522103, "SeaLINK+232I" },
    { 0x0c522104, "SeaLINK+485I" },
    { 0x0c522211, "SeaPORT+2/232 (Port 1)" },
    { 0x0c522212, "SeaPORT+2/485 (Port 1)" },
    { 0x0c522213, "SeaPORT+2 (Port 1)" },
    { 0x0c522221, "SeaPORT+2/232 (Port 2)" },
    { 0x0c522222, "SeaPORT+2/485 (Port 2)" },
    { 0x0c522223, "SeaPORT+2 (Port 2)" },
    { 0x0c522411, "SeaPORT+4/232 (Port 1)" },
    { 0x0c522412, "SeaPORT+4/485 (Port 1)" },
    { 0x0c522413, "SeaPORT+4 (Port 1)" },
    { 0x0c522421, "SeaPORT+4/232 (Port 2)" },
    { 0x0c522422, "SeaPORT+4/485 (Port 2)" },
    { 0x0c522423, "SeaPORT+4 (Port 2)" },
    { 0x0c522431, "SeaPORT+4/232 (Port 3)" },
    { 0x0c522432, "SeaPORT+4/485 (Port 3)" },
    { 0x0c522433, "SeaPORT+4 (Port 3)" },
    { 0x0c522441, "SeaPORT+4/232 (Port 4)" },
    { 0x0c522442, "SeaPORT+4/485 (Port 4)" },
    { 0x0c522443, "SeaPORT+4 (Port 4)" },
    { 0x0c522811, "SeaLINK+8/232 (Port 1)" },
    { 0x0c522812, "SeaLINK+8/485 (Port 1)" },
    { 0x0c522813, "SeaLINK+8 (Port 1)" },
    { 0x0c522821, "SeaLINK+8/232 (Port 2)" },
    { 0x0c522822, "SeaLINK+8/485 (Port 2)" },
    { 0x0c522823, "SeaLINK+8 (Port 2)" },
    { 0x0c522831, "SeaLINK+8/232 (Port 3)" },
    { 0x0c522832, "SeaLINK+8/485 (Port 3)" },
    { 0x0c522833, "SeaLINK+8 (Port 3)" },
    { 0x0c522841, "SeaLINK+8/232 (Port 4)" },
    { 0x0c522842, "SeaLINK+8/485 (Port 4)" },
    { 0x0c522843, "SeaLINK+8 (Port 4)" },
    { 0x0c522851, "SeaLINK+8/232 (Port 5)" },
    { 0x0c522852, "SeaLINK+8/485 (Port 5)" },
    { 0x0c522853, "SeaLINK+8 (Port 5)" },
    { 0x0c522861, "SeaLINK+8/232 (Port 6)" },
    { 0x0c522862, "SeaLINK+8/485 (Port 6)" },
    { 0x0c522863, "SeaLINK+8 (Port 6)" },
    { 0x0c522871, "SeaLINK+8/232 (Port 7)" },
    { 0x0c522872, "SeaLINK+8/485 (Port 7)" },
    { 0x0c522873, "SeaLINK+8 (Port 7)" },
    { 0x0c522881, "SeaLINK+8/232 (Port 8)" },
    { 0x0c522882, "SeaLINK+8/485 (Port 8)" },
    { 0x0c522883, "SeaLINK+8 (Port 8)" },
    { 0x0c529020, "SeaLINK+422" },
    { 0x0c52a02a, "SeaLINK+8 (Port 1+2)" },
    { 0x0c52a02b, "SeaLINK+8 (Port 3+4)" },
    { 0x0c52a02c, "SeaLINK+8 (Port 5+6)" },
    { 0x0c52a02d, "SeaLINK+8 (Port 7+8)" },
    { 0x0c550510, "Spectrum Digital XDS510 JTAG Debugger" },
    { 0x0c550540, "SPI540" },
    { 0x0c555416, "TMS320C5416 DSK" },
    { 0x0c556416, "TMS320C6416 DDB" },
    { 0x0c600001, "MiniMe" },
    { 0x0c600002, "MiniDAC" },
    { 0x0c600003, "ONE" },
    { 0x0c600004, "GiO" },
    { 0x0c600007, "Duet" },
    { 0x0c600009, "Jam" },
    { 0x0c60000a, "Jam Bootloader" },
    { 0x0c60000b, "MiC" },
    { 0x0c60000c, "MiC Bootloader" },
    { 0x0c608007, "Duet DFU Mode" },
    { 0x0c6a0005, "Color 320 x 240 LCD Display Terminal with Touchscreen" },
    { 0x0c6c04b2, "Specbos 1201" },
    { 0x0c700000, "USB08 Development board" },
    { 0x0c700747, "Eye Movement Recorder [Visagraph]/[ReadAlyzer]" },
    { 0x0c72000c, "PCAN-USB" },
    { 0x0c72000d, "PCAN Pro" },
    { 0x0c740002, "OL 700-30 Goniometer" },
    { 0x0c760001, "Mass Storage Controller" },
    { 0x0c760002, "Mass Storage Controller" },
    { 0x0c760003, "USBdisk" },
    { 0x0c760004, "Mass Storage Controller" },
    { 0x0c760005, "Transcend Flash disk" },
    { 0x0c760006, "Transcend JetFlash" },
    { 0x0c760007, "Mass Storage Device" },
    { 0x0c761600, "Ion Quick Play LP turntable" },
    { 0x0c761605, "SSS Headphone Set" },
    { 0x0c761607, "audio controller" },
    { 0x0c765663, "Audio Device" },
    { 0x0c771001, "SiPix Web2" },
    { 0x0c771002, "SiPix SC2100" },
    { 0x0c771010, "SiPix Snap" },
    { 0x0c771011, "SiPix Blink 2" },
    { 0x0c771015, "SiPix CAMeleon" },
    { 0x0c880021, "Handheld" },
    { 0x0c8817da, "Qualcomm Kyocera CDMA Technologies MSM" },
    { 0x0c8e6000, "Luxian Series" },
    { 0x0c94a000, "EPP 1217" },
    { 0x0c981140, "USB PC Watchdog" },
    { 0x0c9c1511, "BI-1511 Laser Simulator" },
    { 0x0c9c1512, "BI-1512 Syncbus Monitor" },
    { 0x0c9c1514, "BI-1514 HPC" },
    { 0x0c9c1532, "BI-1532 GPC" },
    { 0x0c9d0170, "3873 Manual Insert card reader" },
    { 0x0ca60010, "EZUSB PC/SC Smart Card Reader" },
    { 0x0ca60050, "EZ220PU Reader Controller" },
    { 0x0ca61077, "Bludrive Family Smart Card Reader" },
    { 0x0ca6107e, "Reader Controller" },
    { 0x0ca62010, "myPad110 PC/SC Smart Card Reader" },
    { 0x0ca63050, "EZ710 Smart Card Reader" },
    { 0x0caa3001, "AT-VT-Kit3 Serial Adapter" },
    { 0x0cad1007, "APX Series Consolette" },
    { 0x0cad1020, "MOTOTRBO Series Radio (Portable)" },
    { 0x0cad1030, "APX Series Radio (Portable)" },
    { 0x0cad1031, "APX Series Radio (Mobile)" },
    { 0x0cad1602, "IMPRES Battery Data Reader" },
    { 0x0cad9001, "PowerPad Pocket PC Device" },
    { 0x0caf2507, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x0caf2515, "Flash Disk Embedded Hub" },
    { 0x0caf2516, "Flash Disk Security Device" },
    { 0x0caf2517, "Flash Disk Mass Storage Device" },
    { 0x0caf25c7, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x0caf3a00, "Hard Drive" },
    { 0x0caf3a20, "Mass Storage Device" },
    { 0x0caf3acd, "Mass Storage Device" },
    { 0x0cbc0101, "Pocket PC P6C" },
    { 0x0cbc0201, "Personal Digital Assistant" },
    { 0x0cbc0301, "Personal Digital Assistant P6M+" },
    { 0x0cbc0401, "Pocket PC" },
    { 0x0ccd0012, "PHASE 26" },
    { 0x0ccd0013, "PHASE 26" },
    { 0x0ccd0014, "PHASE 26" },
    { 0x0ccd0015, "Flash Update for TerraTec PHASE 26" },
    { 0x0ccd0021, "Cameo Grabster 200" },
    { 0x0ccd0023, "Mystify Claw" },
    { 0x0ccd0028, "Aureon 5.1 MkII" },
    { 0x0ccd0032, "MIDI HUBBLE" },
    { 0x0ccd0035, "Miditech Play'n Roll" },
    { 0x0ccd0036, "Cinergy 250 Audio" },
    { 0x0ccd0037, "Cinergy 250 Audio" },
    { 0x0ccd0038, "Cinergy T\302\262 DVB-T Receiver" },
    { 0x0ccd0039, "Grabster AV 400" },
    { 0x0ccd003b, "Cinergy 400" },
    { 0x0ccd003c, "Grabster AV 250" },
    { 0x0ccd0042, "Cinergy Hybrid T XS" },
    { 0x0ccd0043, "Cinergy T XS" },
    { 0x0ccd004e, "Cinergy T XS" },
    { 0x0ccd004f, "Cinergy Analog XS" },
    { 0x0ccd0055, "Cinergy T XE (Version 1, AF9005)" },
    { 0x0ccd005c, "Cinergy T\302\262" },
    { 0x0ccd0069, "Cinergy T XE (Version 2, AF9015)" },
    { 0x0ccd006b, "Cinergy HT PVR (EU)" },
    { 0x0ccd0072, "Cinergy Hybrid T" },
    { 0x0ccd0077, "Aureon Dual USB" },
    { 0x0ccd0078, "Cinergy T XXS" },
    { 0x0ccd0086, "Cinergy Hybrid XE" },
    { 0x0ccd008e, "Cinergy HTC XS" },
    { 0x0ccd0096, "Grabby" },
    { 0x0ccd0097, "Cinergy T RC MKII" },
    { 0x0ccd0099, "AfaTech 9015 [Cinergy T Stick Dual]" },
    { 0x0ccd00a5, "Cinergy Hybrid Stick" },
    { 0x0ccd00a9, "RTL2838 DVB-T COFDM Demodulator [TerraTec Cinergy T Stick Black]" },
    { 0x0ccd00b3, "NOXON DAB/DAB+ Stick" },
    { 0x0ccd00b9, "WDR DAB/DAB+ Stick" },
    { 0x0ccd00e0, "NOXON DAB/DAB+ Stick V2" },
    { 0x0ccd0102, "Cinergy S2 Stick" },
    { 0x0ccd0105, "Cinergy S2 Box" },
    { 0x0ccd10a7, "TerraTec G3" },
    { 0x0ccd10ad, "Cinergy H5 Rev. 2" },
    { 0x0cd40101, "BeolinkPC2" },
    { 0x0cd50003, "U3" },
    { 0x0cd50009, "UE9" },
    { 0x0cd6000c, "S&B TPU" },
    { 0x0cd6000e, "S&B BKV" },
    { 0x0cd60011, "Money Coin Unit" },
    { 0x0cd82007, "Smart Card Reader/JSTU-9700" },
    { 0x0cde0001, "XI-750 802.11b Wireless Adapter [Atmel AT76C503A]" },
    { 0x0cde0002, "XI-725/726 Prism2.5 802.11b Adapter" },
    { 0x0cde0003, "Sagem 802.11b Dongle" },
    { 0x0cde0004, "Sagem 802.11b Dongle" },
    { 0x0cde0005, "XI-735 Prism3 802.11b Adapter" },
    { 0x0cde0006, "XG-300 802.11b Adapter" },
    { 0x0cde0008, "XG-703A 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x0cde0009, "(ZD1211)IEEE 802.11b+g Adapter" },
    { 0x0cde0011, "ZD1211" },
    { 0x0cde0012, "AR5523" },
    { 0x0cde0013, "AR5523 driver (no firmware)" },
    { 0x0cde0014, "NB 802.11g Wireless LAN Adapter(3887A)" },
    { 0x0cde0015, "XG-705A 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x0cde0016, "NB 802.11g Wireless LAN Adapter(3887A)" },
    { 0x0cde0018, "NB 802.11a/b/g Wireless LAN Adapter(3887A)" },
    { 0x0cde001a, "802.11bg" },
    { 0x0cde001c, "802.11b/g Wireless Network Adapter" },
    { 0x0cde0020, "AG-760A 802.11abg Wireless Adapter [ZyDAS ZD1211B]" },
    { 0x0cde0022, "802.11b/g/n Wireless Network Adapter" },
    { 0x0cde0023, "UB81 802.11bgn" },
    { 0x0cde0025, "802.11b/g/n USB Wireless Network Adapter" },
    { 0x0cde0026, "UB82 802.11abgn" },
    { 0x0cde0027, "Sphairon Homelink 1202 802.11n Wireless Adapter [Atheros AR9170]" },
    { 0x0ce50003, "Matrix" },
    { 0x0ce91001, "PicoScope3000 series PC Oscilloscope" },
    { 0x0ce91007, "PicoScope 2000 series PC Oscilloscope" },
    { 0x0ce91008, "PicoScope 5000 series PC Oscilloscope" },
    { 0x0ce91009, "PicoScope 4000 series PC Oscilloscope" },
    { 0x0ce9100e, "PicoScope 6000 series PC Oscilloscope" },
    { 0x0ce91012, "PicoScope 3000A series PC Oscilloscope" },
    { 0x0ce91016, "PicoScope 2000A series PC Oscilloscope" },
    { 0x0ce91018, "PicoScope 4000A series PC Oscilloscope" },
    { 0x0ce91200, "PicoScope 2000 series PC Oscilloscope" },
    { 0x0ce91201, "PicoScope 3000 series PC Oscilloscope" },
    { 0x0ce91202, "PicoScope 4000 series PC Oscilloscope" },
    { 0x0ce91203, "PicoScope 5000 series PC Oscilloscope" },
    { 0x0ce91204, "PicoScope 6000 series PC Oscilloscope" },
    { 0x0ce91211, "PicoScope 3000 series PC Oscilloscope" },
    { 0x0ce91212, "PicoScope 4000 series PC Oscilloscope" },
    { 0x0cf26220, "SD Card Reader (SG361)" },
    { 0x0cf26225, "SD card reader (UB6225)" },
    { 0x0cf26230, "SD Card Reader (UB623X)" },
    { 0x0cf26250, "SD card reader (UB6250)" },
    { 0x0cf30001, "AR5523" },
    { 0x0cf30002, "AR5523 (no firmware)" },
    { 0x0cf30003, "AR5523" },
    { 0x0cf30004, "AR5523 (no firmware)" },
    { 0x0cf30005, "AR5523" },
    { 0x0cf30006, "AR5523 (no firmware)" },
    { 0x0cf30036, "AR9462 Bluetooth" },
    { 0x0cf31001, "Thomson TG121N [Atheros AR9001U-(2)NG]" },
    { 0x0cf31002, "TP-Link TL-WN821N v2 / TL-WN822N v1 802.11n [Atheros AR9170]" },
    { 0x0cf31006, "TP-Link TL-WN322G v3 / TL-WN422G v2 802.11g [Atheros AR9271]" },
    { 0x0cf31010, "3Com 3CRUSBN275 802.11abgn Wireless Adapter [Atheros AR9170]" },
    { 0x0cf320ff, "AR7010 (no firmware)" },
    { 0x0cf33000, "AR3011 Bluetooth (no firmware)" },
    { 0x0cf33002, "AR3011 Bluetooth" },
    { 0x0cf33004, "AR3012 Bluetooth 4.0" },
    { 0x0cf33005, "AR3011 Bluetooth" },
    { 0x0cf33007, "AR3012 Bluetooth 4.0 (no firmware)" },
    { 0x0cf33008, "Bluetooth (AR3011)" },
    { 0x0cf3311d, "Bluetooth" },
    { 0x0cf3311f, "AR3012 Bluetooth" },
    { 0x0cf37015, "TP-Link TL-WN821N v3 / TL-WN822N v2 802.11n [Atheros AR7010+AR9287]" },
    { 0x0cf39170, "AR9170 802.11n" },
    { 0x0cf39271, "AR9271 802.11n" },
    { 0x0cf39378, "QCA9377-7" },
    { 0x0cf3b002, "Ubiquiti WiFiStation 802.11n [Atheros AR9271]" },
    { 0x0cf3b003, "Ubiquiti WiFiStationEXT 802.11n [Atheros AR9271]" },
    { 0x0cf3e006, "Dell Wireless 1802 Bluetooth 4.0 LE" },
    { 0x0cf3e300, "QCA61x4 Bluetooth 4.0" },
    { 0x0cf80750, "Claritel-i750 - vp" },
    { 0x0cfc2301, "Magicolor 2300 DL" },
    { 0x0cfc2350, "Magicolor 2350EN/3300" },
    { 0x0cfc3100, "Magicolor 3100" },
    { 0x0cfc7300, "Magicolor 5450/5550" },
    { 0x0cff0320, "SR-380N" },
    { 0x0d080602, "DV007 [serial]" },
    { 0x0d080603, "DV007 [storage]" },
    { 0x0d100001, "StormPort (WDM)" },
    { 0x0d160001, "PhotoShuttle" },
    { 0x0d160002, "Photo Printer 730 series" },
    { 0x0d160004, "Photo Printer 63xPL/PS" },
    { 0x0d160007, "P510K" },
    { 0x0d160009, "P72x Series" },
    { 0x0d16000a, "P728L" },
    { 0x0d16000b, "P510L" },
    { 0x0d16000d, "P518A" },
    { 0x0d16000e, "P910L" },
    { 0x0d160010, "M610" },
    { 0x0d160100, "Photo Printer 63xPL/PS" },
    { 0x0d160102, "Photo Printer 64xPS" },
    { 0x0d160103, "Photo Printer 730 series" },
    { 0x0d160104, "Photo Printer 63xPL/PS" },
    { 0x0d160105, "Photo Printer 64xPS" },
    { 0x0d16010e, "P510S" },
    { 0x0d160110, "P110S" },
    { 0x0d160111, "P510Si" },
    { 0x0d160112, "P518S" },
    { 0x0d160200, "Photo Printer 64xDL" },
    { 0x0d160309, "CS-200e" },
    { 0x0d16030a, "CS-220e" },
    { 0x0d160501, "P75x Series" },
    { 0x0d160502, "P52x Series" },
    { 0x0d160503, "P310L" },
    { 0x0d16050a, "P310W" },
    { 0x0d16050f, "P530D" },
    { 0x0d160800, "X610" },
    { 0x0d280204, "ARM mbed" },
    { 0x0d2f0002, "Pump It Up Pad" },
    { 0x0d3a0206, "Series 3xxx Cash Drawer" },
    { 0x0d3a0207, "Series 3xxx Cash Drawer" },
    { 0x0d3a0500, "Magnetic Stripe Reader" },
    { 0x0d3d0001, "HID Keyboard" },
    { 0x0d3d0040, "PS/2 Adapter" },
    { 0x0d462012, "KAAN Standard Plus (Smartcard reader)" },
    { 0x0d463003, "mIDentity Light / KAAN SIM III" },
    { 0x0d463014, "Smart Token" },
    { 0x0d464000, "mIDentity (mass storage)" },
    { 0x0d464001, "mIDentity Basic/Classic (composite device)" },
    { 0x0d464081, "mIDentity Basic/Classic (installationless)" },
    { 0x0d480001, "ACTIVboard" },
    { 0x0d480004, "ACTIVboard" },
    { 0x0d480100, "Audio" },
    { 0x0d493000, "Drive" },
    { 0x0d493005, "Personal Storage 3000LS" },
    { 0x0d493010, "3000LE Drive" },
    { 0x0d493100, "Hi-Speed USB-IDE Bridge Controller" },
    { 0x0d493200, "Personal Storage 3200" },
    { 0x0d495000, "5000XT Drive" },
    { 0x0d495010, "5000LE Drive" },
    { 0x0d495020, "Mobile Hard Disk Drive" },
    { 0x0d497000, "OneTouch" },
    { 0x0d497010, "OneTouch" },
    { 0x0d497100, "OneTouch II 300GB External Hard Disk" },
    { 0x0d497310, "OneTouch 4" },
    { 0x0d497410, "Mobile Hard Disk Drive (1TB)" },
    { 0x0d497450, "Basics Portable USB Device" },
    { 0x0d4e047a, "WLAN Card" },
    { 0x0d4e1000, "Wireless Card Model 0801" },
    { 0x0d4e1001, "Wireless Card Model 0802" },
    { 0x0d500011, "USB-Temp2 Thermometer" },
    { 0x0d500030, "Multiplexer" },
    { 0x0d500040, "F4 foot switch" },
    { 0x0d5902a8, "Digital Clock" },
    { 0x0d5ca001, "SMC2662W (v1) EZ Connect 802.11b Wireless Adapter [Atmel AT76C503A]" },
    { 0x0d5ca002, "SMC2662W v2 / SMC2662W-AR / Belkin F5D6050 [Atmel at76c503a]" },
    { 0x0d5e2346, "BT Digital Access adapter" },
    { 0x0d620003, "Smartcard Reader" },
    { 0x0d620004, "Keyboard" },
    { 0x0d62001b, "Keyboard" },
    { 0x0d62001c, "Benq X120 Internet Keyboard Pro" },
    { 0x0d620306, "M530 Mouse" },
    { 0x0d620800, "Magic Wheel" },
    { 0x0d622021, "AM805 Keyboard" },
    { 0x0d622026, "TECOM Bluetooth Device" },
    { 0x0d622050, "Mouse" },
    { 0x0d622106, "Dell L20U Multimedia Keyboard" },
    { 0x0d62910e, "HP Business Slim Keyboard" },
    { 0x0d62a100, "Optical Mouse" },
    { 0x0d640105, "Dual Mode Digital Camera 1.3M" },
    { 0x0d640107, "Horus MT-409 Camera" },
    { 0x0d640108, "Dual Mode Digital Camera" },
    { 0x0d640202, "Dual Mode Video Camera Device" },
    { 0x0d640303, "DXG-305V Camera" },
    { 0x0d641001, "SiPix Stylecam/UMAX AstraPix 320s" },
    { 0x0d641002, "Fashion Cam 01 Dual-Mode DSC (Video Camera)" },
    { 0x0d641003, "Fashion Cam Dual-Mode DSC (Controller)" },
    { 0x0d641021, "D-Link DSC 350F" },
    { 0x0d641208, "Dual Mode Still Camera Device" },
    { 0x0d642208, "Mass Storage" },
    { 0x0d643105, "Dual Mode Digital Camera Disk" },
    { 0x0d643108, "Digicam Mass Storage Device" },
    { 0x0d645566, "Contour Roam Model 1600" },
    { 0x0d7a0001, "CrypToken" },
    { 0x0d7d0100, "PS1001/1011/1006/1026 Flash Disk" },
    { 0x0d7d0110, "Gigabyte FlexDrive" },
    { 0x0d7d0120, "Disk Pro 64MB" },
    { 0x0d7d0124, "GIGABYTE Disk" },
    { 0x0d7d0240, "I/O-Magic/Transcend 6-in-1 Card Reader" },
    { 0x0d7d110e, "NEC uPD720121/130 USB-ATA/ATAPI Bridge" },
    { 0x0d7d1240, "Apacer 6-in-1 Card Reader 2.0" },
    { 0x0d7d1270, "Wolverine SixPac 6000" },
    { 0x0d7d1300, "Flash Disk" },
    { 0x0d7d1320, "PS2031 Flash Disk" },
    { 0x0d7d1400, "Attache 256MB USB 2.0 Flash Drive" },
    { 0x0d7d1420, "PS2044 Pen Drive" },
    { 0x0d7d1470, "Vosonic X's-Drive II+ VP2160" },
    { 0x0d7d1620, "USB Disk Pro" },
    { 0x0d7d1900, "USB Thumb Drive" },
    { 0x0d7e2507, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x0d7e2517, "Hi-Speed Mass Storage Device" },
    { 0x0d7e25c7, "Hi-Speed USB-to-IDE Bridge Controller" },
    { 0x0d7f0100, "P5 Glove glove controller" },
    { 0x0d8a0101, "TEPRA PRO" },
    { 0x0d8c0001, "Audio Device" },
    { 0x0d8c0002, "Composite Device" },
    { 0x0d8c0003, "Sound Device" },
    { 0x0d8c0004, "CM6631A Audio Processor" },
    { 0x0d8c0005, "Blue Snowball" },
    { 0x0d8c0006, "Storm HP-USB500 5.1 Headset" },
    { 0x0d8c000c, "Audio Adapter" },
    { 0x0d8c000d, "Composite Device" },
    { 0x0d8c000e, "Audio Adapter (Planet UP-100, Genius G-Talk)" },
    { 0x0d8c0014, "Audio Adapter (Unitek Y-247A)" },
    { 0x0d8c001f, "CM108 Audio Controller" },
    { 0x0d8c0102, "CM106 Like Sound Device" },
    { 0x0d8c0103, "CM102-A+/102S+ Audio Controller" },
    { 0x0d8c0104, "CM103+ Audio Controller" },
    { 0x0d8c0105, "CM108 Audio Controller" },
    { 0x0d8c0107, "CM108 Audio Controller" },
    { 0x0d8c010f, "CM108 Audio Controller" },
    { 0x0d8c0115, "CM108 Audio Controller" },
    { 0x0d8c0139, "Multimedia Headset [Gigaware by Ignition L.P.]" },
    { 0x0d8c013c, "CM108 Audio Controller" },
    { 0x0d8c0201, "CM6501" },
    { 0x0d8c5000, "Mass Storage Controller" },
    { 0x0d8c5200, "Mass Storage Controller(0D8C,5200)" },
    { 0x0d8cb213, "USB Phone CM109 (aka CT2000,VPT1000)" },
    { 0x0d8d0234, "V-234 Composite Device" },
    { 0x0d8d0550, "V-550 Composite Device" },
    { 0x0d8d0551, "V-551 Composite Device" },
    { 0x0d8d0552, "V-552 Composite Device" },
    { 0x0d8d0651, "V-651 Composite Device" },
    { 0x0d8d0652, "V-652 Composite Device" },
    { 0x0d8d0653, "V-653 Composite Device" },
    { 0x0d8d0654, "V-654 Composite Device" },
    { 0x0d8d0655, "V-655 Composite Device" },
    { 0x0d8d0656, "V-656 Composite Device" },
    { 0x0d8d0657, "V-657 Composite Device" },
    { 0x0d8d0658, "V-658 Composite Device" },
    { 0x0d8d0659, "V-659 Composite Device" },
    { 0x0d8d0660, "V-660 Composite Device" },
    { 0x0d8d0661, "V-661 Composite Device" },
    { 0x0d8d0662, "V-662 Composite Device" },
    { 0x0d8d0850, "V-850 Composite Device" },
    { 0x0d8d0851, "V-851 Composite Device" },
    { 0x0d8d0852, "V-852 Composite Device" },
    { 0x0d8d0901, "V-901 Composite Device" },
    { 0x0d8d0902, "V-902 Composite Device" },
    { 0x0d8d0903, "V-903 Composite Device" },
    { 0x0d8d4754, "Voyager DMP Composite Device" },
    { 0x0d8dbb00, "Bloomberg Composite Device" },
    { 0x0d8dbb01, "Bloomberg Composite Device" },
    { 0x0d8dbb02, "Bloomberg Composite Device" },
    { 0x0d8dbb03, "Bloomberg Composite Device" },
    { 0x0d8dbb04, "Bloomberg Composite Device" },
    { 0x0d8dbb05, "Bloomberg Composite Device" },
    { 0x0d8dfffe, "Global Tuner Composite Device" },
    { 0x0d8dffff, "Voyager DMP Composite Device" },
    { 0x0d8e0163, "802.11g 54 Mbps Wireless Dongle" },
    { 0x0d8e1621, "802.11b Wireless Adapter" },
    { 0x0d8e3762, "Cohiba 802.11g Wireless Mini adapter [Intersil ISL3887]" },
    { 0x0d8e3763, "802.11g Wireless dongle" },
    { 0x0d8e7100, "802.11b Adapter" },
    { 0x0d8e7110, "WL-210 / WU210P 802.11b Wireless Adapter [Atmel AT76C503A]" },
    { 0x0d8e7605, "TRENDnet TEW-224UB 802.11b Wireless Adapter [Atmel AT76C503A]" },
    { 0x0d8e7801, "AR5523" },
    { 0x0d8e7802, "AR5523 (no firmware)" },
    { 0x0d8e7811, "AR5523" },
    { 0x0d8e7812, "AR5523 (no firmware)" },
    { 0x0d8e7a01, "PRISM25 802.11b Adapter" },
    { 0x0d960000, "Jenoptik JD350 video" },
    { 0x0d963300, "SX330z Camera" },
    { 0x0d964100, "SX410z Camera" },
    { 0x0d964102, "MD 9700 Camera" },
    { 0x0d964104, "Jenoptik JD-4100z3s" },
    { 0x0d96410a, "Medion 9801/Novatech SX-410z" },
    { 0x0d965200, "SX-520z Camera" },
    { 0x0d970001, "SBIG Astronomy Camera (without firmware)" },
    { 0x0d970101, "SBIG Astronomy Camera (with firmware)" },
    { 0x0d980300, "Avaya Wireless Card" },
    { 0x0d981007, "Discovery Kids Digital Camera" },
    { 0x0d9a0001, "Bluetooth Device" },
    { 0x0d9e0300, "Wireless Card" },
    { 0x0d9f0001, "Uninterruptible Power Supply" },
    { 0x0d9f0002, "Black Knight PRO / WOW Uninterruptible Power Supply (Cypress HID->COM RS232)" },
    { 0x0d9f00a2, "Imperial Uninterruptible Power Supply (HID PDC)" },
    { 0x0d9f00a3, "Smart King PRO Uninterruptible Power Supply (HID PDC)" },
    { 0x0d9f00a4, "WOW Uninterruptible Power Supply (HID PDC)" },
    { 0x0d9f00a5, "Vanguard Uninterruptible Power Supply (HID PDC)" },
    { 0x0d9f00a6, "Black Knight PRO Uninterruptible Power Supply (HID PDC)" },
    { 0x0da40001, "Interface" },
    { 0x0da40003, "FlowLink" },
    { 0x0da40008, "Loop" },
    { 0x0da80001, "SDS 200A Oscilloscope" },
    { 0x0dab0100, "DVR/CVR-M140 MP3 Player" },
    { 0x0db01020, "PC2PC WLAN Card" },
    { 0x0db01967, "Bluetooth Dongle" },
    { 0x0db03713, "Primo 73" },
    { 0x0db03801, "Motorola Bluetooth 2.1+EDR Device" },
    { 0x0db03870, "MS-3870 802.11bgn Wireless Module [Ralink RT3070]" },
    { 0x0db03871, "MS-3871 802.11bgn Wireless Module [Ralink RT8070]" },
    { 0x0db04011, "Medion Flash XL V2.0 Card Reader" },
    { 0x0db04023, "Lexar Mobile Card Reader" },
    { 0x0db04600, "802.11b/g Turbo Wireless Adapter" },
    { 0x0db05501, "Mass Storage Device" },
    { 0x0db05502, "Mass Storage Device" },
    { 0x0db05513, "MP3 Player" },
    { 0x0db05515, "MP3 Player" },
    { 0x0db05516, "MP3 Player" },
    { 0x0db05572, "Micro-Star International P610/Model MS-5557" },
    { 0x0db05580, "Mega Sky 580 DVB-T Tuner [M902x]" },
    { 0x0db05581, "Mega Sky 580 DVB-T Tuner [GL861]" },
    { 0x0db06823, "UB11B/MS-6823 802.11b Wi-Fi adapter" },
    { 0x0db06826, "IEEE 802.11g Wireless Network Adapter" },
    { 0x0db06855, "Bluetooth Device" },
    { 0x0db06861, "MSI-6861 802.11g WiFi adapter" },
    { 0x0db06865, "RT2570" },
    { 0x0db06869, "RT2570" },
    { 0x0db06874, "RT2573" },
    { 0x0db06877, "RT2573" },
    { 0x0db06881, "Bluetooth Class I EDR Device" },
    { 0x0db0688a, "Bluetooth Class I EDR Device" },
    { 0x0db06899, "802.11bgn 1T1R Mini Card Wireless Adapter" },
    { 0x0db06970, "MS-6970 BToes Bluetooth adapter" },
    { 0x0db0697a, "Bluetooth Dongle" },
    { 0x0db06982, "Medion Flash XL Card Reader" },
    { 0x0db0a861, "RT2573" },
    { 0x0db0a874, "RT2573" },
    { 0x0db0a970, "Bluetooth dongle" },
    { 0x0db0a97a, "Bluetooth EDR Device" },
    { 0x0db0b970, "Bluetooth EDR Device" },
    { 0x0db0b97a, "Bluetooth EDR Device" },
    { 0x0db0ffff, "Bluetooth Adapter in DFU mode" },
    { 0x0db50139, "Barcode Module - CDC serial" },
    { 0x0db5013a, "Barcode Module - Virtual Keyboard" },
    { 0x0db5013b, "Barcode Module - HID" },
    { 0x0db50160, "NFC and Smartcard Module (NSM)" },
    { 0x0db50164, "NFC and Smartcard Module (NSM)with 4 SAM slots" },
    { 0x0db70002, "Goldpfeil P-LAN" },
    { 0x0dba1000, "Mbox 1 [Mbox]" },
    { 0x0dba3000, "Mbox 2" },
    { 0x0dbab011, "Eleven Rack" },
    { 0x0dbc0003, "AND Serial Cable [AND Smart Cable]" },
    { 0x0dbf0002, "SmartDongle Security Key" },
    { 0x0dbf0200, "HDD Storage Solution" },
    { 0x0dbf021b, "USB-2.0 IDE Adapter" },
    { 0x0dbf0300, "Storage Adapter" },
    { 0x0dbf0333, "Storage Adapter" },
    { 0x0dbf0502, "FSC Storagebird XL hard disk" },
    { 0x0dbf0707, "ZIV Drive" },
    { 0x0dc30801, "ASEDrive III" },
    { 0x0dc30802, "ASEDrive IIIe" },
    { 0x0dc31104, "ASEDrive IIIe KB" },
    { 0x0dc31701, "ASEKey" },
    { 0x0dc31702, "ASEKey" },
    { 0x0dc40040, "Mass Storage Device" },
    { 0x0dc40041, "Mass Storage Device" },
    { 0x0dc40042, "Mass Storage Device" },
    { 0x0dc40101, "Hi-Speed Mass Storage Device" },
    { 0x0dc40209, "SK-3500 S2" },
    { 0x0dc4020a, "Oyen Digital MiniPro 2.5\" hard drive enclosure" },
    { 0x0dc40290, "Mass Storage Device [NT2 U3.1]" },
    { 0x0dc62301, "Wireless Touchpad Keyboard" },
    { 0x0dcd0001, "Remote Interface Adapter" },
    { 0x0dcd0002, "High Bandwidth Codec" },
    { 0x0dd01002, "Triple Talk Speech Synthesizer" },
    { 0x0dd20003, "Mass Storage (P)" },
    { 0x0dd40237, "K80 80mm Thermal Printer" },
    { 0x0dd80562, "Netac Portable SSD Z6s" },
    { 0x0dd81060, "USB-CF-Card" },
    { 0x0dd8e007, "OnlyDisk U222 Pendrive" },
    { 0x0dd8f607, "OnlyDisk U210 1G flash drive [U-SAFE]" },
    { 0x0dda0001, "Multi-Card Reader 6in1" },
    { 0x0dda0002, "Multi-Card Reader 7in1" },
    { 0x0dda0003, "Flash Disk" },
    { 0x0dda0005, "Internal Multi-Card Reader 6in1" },
    { 0x0dda0008, "SD single card reader" },
    { 0x0dda0009, "MS single card reader" },
    { 0x0dda000a, "MS+SD Dual Card Reader" },
    { 0x0dda000b, "SM single card reader" },
    { 0x0dda0101, "All-In-One Card Reader" },
    { 0x0dda0102, "All-In-One Card Reader" },
    { 0x0dda0301, "MP3 Player" },
    { 0x0dda0302, "Multi-Card MP3 Player" },
    { 0x0dda1001, "Multi-Flash Disk" },
    { 0x0dda2001, "Multi-Card Reader" },
    { 0x0dda2002, "Q018 default PID" },
    { 0x0dda2003, "Multi-Card Reader" },
    { 0x0dda2005, "Datalux DLX-1611 16in1 Card Reader" },
    { 0x0dda2006, "All-In-One Card Reader" },
    { 0x0dda2007, "USB to ATAPI bridge" },
    { 0x0dda2008, "All-In-One Card Reader" },
    { 0x0dda2013, "SD/MS Combo Card Reader" },
    { 0x0dda2014, "SD/MS Single Card Reader" },
    { 0x0dda2023, "card reader SD/MS DEMO board with ICSI brand name (MaskROM version)" },
    { 0x0dda2024, "card reader SD/MS DEMO board with Generic brand name (MaskROM version)" },
    { 0x0dda2026, "USB2.0 Card Reader" },
    { 0x0dda2027, "USB 2.0 Card Reader" },
    { 0x0dda2315, "UFD MP3 player (model 2)" },
    { 0x0dda2318, "UFD MP3 player (model 1)" },
    { 0x0dda2321, "UFD MP3 player" },
    { 0x0de70191, "U401 Interface card" },
    { 0x0de701a5, "U421 interface card" },
    { 0x0de701c3, "U451 relay interface card" },
    { 0x0dee4010, "Storage Adapter" },
    { 0x0df40201, "MNG-2005" },
    { 0x0df60001, "C-Media VOIP Device" },
    { 0x0df60004, "Bluetooth 2.0 Adapter 100m" },
    { 0x0df60007, "Bluetooth 2.0 Adapter 10m" },
    { 0x0df6000b, "Bluetooth 2.0 Adapter DFU" },
    { 0x0df6000d, "WL-168 Wireless Network Adapter 54g" },
    { 0x0df60017, "WL-182 Wireless-N Network USB Card" },
    { 0x0df60019, "Bluetooth 2.0 adapter 10m CN-512v2 001" },
    { 0x0df6001a, "Bluetooth 2.0 adapter 100m CN-521v2 001" },
    { 0x0df6002b, "WL-188 Wireless Network 300N USB Adapter" },
    { 0x0df6002c, "WL-301 Wireless Network 300N USB Adapter" },
    { 0x0df6002d, "WL-302 Wireless Network 300N USB dongle" },
    { 0x0df60036, "WL-603 Wireless Adapter" },
    { 0x0df60039, "WL-315 Wireless-N USB Adapter" },
    { 0x0df6003b, "WL-321 Wireless USB Gaming Adapter 300N" },
    { 0x0df6003c, "WL-323 Wireless-N USB Adapter" },
    { 0x0df6003d, "WL-324 Wireless USB Adapter 300N" },
    { 0x0df6003e, "WL-343 Wireless USB Adapter 150N X1" },
    { 0x0df6003f, "WL-608 Wireless USB Adapter 54g" },
    { 0x0df60040, "WL-344 Wireless Adapter 300N X2 [Ralink RT3071]" },
    { 0x0df60041, "WL-329 Wireless Dualband USB adapter 300N" },
    { 0x0df60042, "WL-345 Wireless USB adapter 300N X3" },
    { 0x0df60045, "WL-353 Wireless USB Adapter 150N Nano" },
    { 0x0df60047, "WL-352v1 Wireless USB Adapter 300N 002" },
    { 0x0df60048, "WL-349v1 Wireless Adapter 150N 002 [Ralink RT3070]" },
    { 0x0df60049, "WL-356 Wireless Adapter 300N" },
    { 0x0df6004a, "WL-358v1 Wireless Micro USB Adapter 300N X3 002" },
    { 0x0df6004b, "WL-349v3 Wireless Micro Adapter 150N X1 [Realtek RTL8192SU]" },
    { 0x0df6004c, "WL-352 802.11n Adapter [Realtek RTL8191SU]" },
    { 0x0df60050, "WL-349v4 Wireless Micro Adapter 150N X1 [Ralink RT3370]" },
    { 0x0df60056, "LN-031 10/100/1000 Ethernet Adapter" },
    { 0x0df6005d, "WLA-2000 v1.001 WLAN [RTL8191SU]" },
    { 0x0df60060, "WLA-4000 802.11bgn [Ralink RT3072]" },
    { 0x0df60062, "WLA-5000 802.11abgn [Ralink RT3572]" },
    { 0x0df6006f, "WLA-5100" },
    { 0x0df60072, "AX88179 Gigabit Ethernet [Sitecom]" },
    { 0x0df6061c, "LN-028 Network USB 2.0 Adapter" },
    { 0x0df6214a, "IDE/SATA Combo Adapter [CN-330]" },
    { 0x0df621f4, "44 St Bluetooth Device" },
    { 0x0df62200, "Sitecom bluetooth2.0 class 2 dongle CN-512" },
    { 0x0df62208, "Sitecom bluetooth2.0 class 2 dongle CN-520" },
    { 0x0df62209, "Sitecom bluetooth2.0 class 1 dongle CN-521" },
    { 0x0df63068, "DC-104v2 ISDN Adapter [HFC-S]" },
    { 0x0df69071, "WL-113 rev 1 Wireless Network USB Adapter" },
    { 0x0df69075, "WL-117 Hi-Speed USB Adapter" },
    { 0x0df690ac, "WL-172 Wireless Network USB Adapter 54g Turbo" },
    { 0x0df69712, "WL-113 rev 2 Wireless Network USB Adapter" },
    { 0x0df70620, "MA-620 Infrared Adapter" },
    { 0x0df70700, "MA-700 Bluetooth Adapter" },
    { 0x0df70720, "MA-720 Bluetooth Adapter" },
    { 0x0df70722, "Bluetooth Dongle" },
    { 0x0df70730, "MA-730/MA-730G Bluetooth Adapter" },
    { 0x0df70800, "Data Cable" },
    { 0x0df70820, "Data Cable" },
    { 0x0df70900, "MA i-gotU Travel Logger GPS" },
    { 0x0df71800, "Generic Card Reader" },
    { 0x0df71802, "Card Reader" },
    { 0x0dfc0001, "Touchscreen" },
    { 0x0dfc0003, "MultiTouch TouchScreen(Dualtouch)" },
    { 0x0dfc0101, "5-point Touch Screen" },
    { 0x0dfcd107, "MultiTouch TouchScreen" },
    { 0x0e0b9031, "802.11n Wireless USB Card" },
    { 0x0e0b9041, "802.11n Wireless USB Card" },
    { 0x0e0c0101, "LonUSB LonTalk Network Adapter" },
    { 0x0e0d0003, "PicoHarp 300" },
    { 0x0e0f0001, "Device" },
    { 0x0e0f0002, "Virtual USB Hub" },
    { 0x0e0f0003, "Virtual Mouse" },
    { 0x0e0f0004, "Virtual CCID" },
    { 0x0e0f0005, "Virtual Mass Storage" },
    { 0x0e0f0006, "Virtual Keyboard" },
    { 0x0e0f000a, "Virtual Sensors" },
    { 0x0e0f8001, "Root Hub" },
    { 0x0e0f8002, "Root Hub" },
    { 0x0e0f8003, "Root Hub" },
    { 0x0e0ff80a, "Smoker FX2" },
    { 0x0e200101, "NoteTaker" },
    { 0x0e200200, "Seiko Instruments InkLink Handwriting System" },
    { 0x0e210300, "iAudio CW200" },
    { 0x0e210400, "MP3 Player" },
    { 0x0e210500, "iAudio M3" },
    { 0x0e210510, "iAudio X5, subpack USB port" },
    { 0x0e210513, "iAudio X5, side USB port" },
    { 0x0e210520, "iAudio M5, side USB port" },
    { 0x0e210601, "iAudio G3" },
    { 0x0e210681, "iAUDIO E2" },
    { 0x0e210700, "iAudio U3" },
    { 0x0e210701, "Cowon iAudio U3 (MTP mode)" },
    { 0x0e210711, "Cowon iAudio 6 (MTP mode)" },
    { 0x0e210751, "Cowon iAudio 7 (MTP mode)" },
    { 0x0e210760, "iAUDIO U5 / iAUDIO G2" },
    { 0x0e210761, "Cowon iAudio U5 (MTP mode)" },
    { 0x0e210800, "Cowon D2 (UMS mode)" },
    { 0x0e210801, "Cowon iAudio D2 (MTP mode)" },
    { 0x0e210861, "Cowon iAudio D2+ FW 2.x (MTP mode)" },
    { 0x0e210871, "Cowon iAudio D2+ DAB FW 4.x (MTP mode)" },
    { 0x0e210881, "Cowon iAudio D2+ FW 3.x (MTP mode)" },
    { 0x0e210891, "Cowon iAudio D2+ DMB FW 1.x (MTP mode)" },
    { 0x0e210901, "Cowon iAudio S9 (MTP mode)" },
    { 0x0e210910, "iAUDIO 9" },
    { 0x0e210911, "Cowon iAudio 9 (MTP mode)" },
    { 0x0e210920, "J3" },
    { 0x0e210921, "Cowon iAudio J3 (MTP mode)" },
    { 0x0e210931, "Cowon iAudio X7 (MTP mode)" },
    { 0x0e210941, "Cowon iAudio C2 (MTP mode)" },
    { 0x0e210952, "Cowon iAudio 10 (MTP mode)" },
    { 0x0e360009, "Handyscope HS3" },
    { 0x0e36000b, "Handyscope HS4" },
    { 0x0e36000f, "Handyscope HS4-DIFF (br)" },
    { 0x0e360010, "Handyscope HS2" },
    { 0x0e360011, "TiePieSCOPE HS805 (br)" },
    { 0x0e360012, "TiePieSCOPE HS805" },
    { 0x0e360013, "Handyprobe HP3" },
    { 0x0e360014, "Handyprobe HP3" },
    { 0x0e360018, "Handyprobe HP2" },
    { 0x0e36001b, "Handyscope HS5" },
    { 0x0e360042, "TiePieSCOPE HS801" },
    { 0x0e3600fd, "USB To Parallel adapter" },
    { 0x0e3600fe, "USB To Parallel adapter" },
    { 0x0e390137, "Bluetooth Device" },
    { 0x0e3a1100, "CW-1100 Wireless Network Adapter" },
    { 0x0e414147, "TonePort GX" },
    { 0x0e41414d, "Pod HD500" },
    { 0x0e414156, "POD HD Desktop" },
    { 0x0e414250, "BassPODxt" },
    { 0x0e414252, "BassPODxt Pro" },
    { 0x0e414642, "BassPODxt Live" },
    { 0x0e414650, "PODxt Live" },
    { 0x0e414750, "GuitarPort" },
    { 0x0e415044, "PODxt" },
    { 0x0e415050, "PODxt Pro" },
    { 0x0e41534d, "SeaMonkey" },
    { 0x0e480100, "CardPro SmartCard Reader" },
    { 0x0e4c1097, "Gamester Controller" },
    { 0x0e4c1103, "Gamester Reflex" },
    { 0x0e4c2390, "Jtech Controller" },
    { 0x0e4c3510, "Gamester for Xbox" },
    { 0x0e4c7288, "funkey reader" },
    { 0x0e500001, "Matrix USB-Key" },
    { 0x0e500002, "Matrixlock Dongle (HID)" },
    { 0x0e55110a, "Tanic S110-SG1 + ISSC IS1002N [Slow Infra-Red (SIR) & Bluetooth 1.2 (Class 2) Adapter]" },
    { 0x0e55110b, "MS3303H USB-to-Serial Bridge" },
    { 0x0e566021, "K-PEX 100" },
    { 0x0e5c6118, "LCD Device" },
    { 0x0e5c6119, "remote receive and control device" },
    { 0x0e5c6441, "C-Media Sound Device" },
    { 0x0e5e6622, "CW6622" },
    { 0x0e660001, "HWUN1 Hi-Gain Wireless-300N Adapter w/ Upgradable Antenna [Ralink RT2870]" },
    { 0x0e660003, "HWDN1 Hi-Gain Wireless-300N Dish Adapter [Ralink RT2870]" },
    { 0x0e660009, "HWUN2 Hi-Gain Wireless-150N Adapter w/ Upgradable Antenna [Ralink RT2770]" },
    { 0x0e66000b, "HWDN2 Hi-Gain Wireless-150N Dish Adapter [Ralink RT2770]" },
    { 0x0e660013, "HWUN3 Hi-Gain Wireless-N Adapter [Ralink RT3070]" },
    { 0x0e660015, "HWDN2 Rev. E Hi-Gain Wireless-150N Dish Adapter [Realtek RTL8191SU]" },
    { 0x0e660017, "HAWNU1 Hi-Gain Wireless-150N Network Adapter with Range Amplifier [Ralink RT3070]" },
    { 0x0e660018, "Wireless-N Network Adapter [Ralink RT2870]" },
    { 0x0e66400b, "UF100 10/100 Network Adapter" },
    { 0x0e66400c, "UF100 Ethernet [pegasus2]" },
    { 0x0e670002, "Wrist PDA" },
    { 0x0e6a0101, "MA100 [USB-UART Bridge IC]" },
    { 0x0e6a02c0, "Defender Gaming Keyboard" },
    { 0x0e6a030b, "Truly Ergonomic Computer Keyboard (Device Firmware Update mode)" },
    { 0x0e6a030c, "Truly Ergonomic Computer Keyboard" },
    { 0x0e6a6001, "GEMBIRD Flexible keyboard KB-109F-B-DE" },
    { 0x0e6a7f5c, "BPF-015 Key Chain Photo Frame" },
    { 0x0e6f0003, "Freebird wireless Controller" },
    { 0x0e6f0005, "Eclipse wireless Controller" },
    { 0x0e6f0006, "Edge wireless Controller" },
    { 0x0e6f0008, "After Glow Pro Controller" },
    { 0x0e6f0105, "Disney's High School Musical 3 Dance Pad for Xbox 360" },
    { 0x0e6f0113, "Afterglow AX.1 Gamepad" },
    { 0x0e6f011f, "Rock Candy Wired Controller for Xbox 360" },
    { 0x0e6f0128, "Wireless PS3 Controller" },
    { 0x0e6f0131, "PDP EA Sports Controller" },
    { 0x0e6f0133, "Wired Controller" },
    { 0x0e6f0139, "Afterglow Prismatic Wired Controller for Xbox One" },
    { 0x0e6f013a, "PDP Xbox One Controller" },
    { 0x0e6f0146, "Rock Candy Wired Controller for Xbox One" },
    { 0x0e6f0147, "PDP Marvel Controller for Xbox One" },
    { 0x0e6f015c, "PDP Arcade Stick for Xbox One" },
    { 0x0e6f0161, "Camo Wired Controller for Xbox One" },
    { 0x0e6f0162, "Xbox One Wired Controller" },
    { 0x0e6f0163, "Legendary Collection Deliverer of Truth" },
    { 0x0e6f0164, "Battlefield 1 Wired Controller for Xbox One" },
    { 0x0e6f0165, "Titanfall 2 Wired Controller for Xbox One" },
    { 0x0e6f0201, "Pelican PL-3601" },
    { 0x0e6f0213, "Afterglow Gamepad for Xbox 360" },
    { 0x0e6f021f, "Rock Candy Gamepad for Xbox 360" },
    { 0x0e6f0246, "Rock Candy Gamepad for Xbox One" },
    { 0x0e6f0301, "Controller" },
    { 0x0e6f0346, "Rock Candy Wired Controller for Xbox One" },
    { 0x0e6f0401, "Controller" },
    { 0x0e6f0413, "Afterglow AX.1 Gamepad for Xbox 360" },
    { 0x0e6f0501, "Wired Controller" },
    { 0x0e6ff501, "Hi-TEC Essentials Wired Gamepad" },
    { 0x0e6ff900, "Afterglow AX.1" },
    { 0x0e791106, "Pocket Media Assistant - PMA400" },
    { 0x0e791204, "Gmini XS 200" },
    { 0x0e791207, "Archos Gmini XS100" },
    { 0x0e791208, "Archos XS202 (MTP mode)" },
    { 0x0e79120a, "Archos 104 (MTP mode)" },
    { 0x0e79120c, "Archos 204 (MTP mode)" },
    { 0x0e791301, "Archos 404 (MTP mode)" },
    { 0x0e791303, "Archos 404CAM (MTP mode)" },
    { 0x0e791306, "504 Portable Multimedia Player" },
    { 0x0e791307, "Archos 504 (MTP mode)" },
    { 0x0e791309, "Archos 604 (MTP mode)" },
    { 0x0e79130b, "Archos 604WIFI (MTP mode)" },
    { 0x0e79130d, "Archos 704 mobile dvr" },
    { 0x0e79130f, "Archos 704TV (MTP mode)" },
    { 0x0e791311, "Archos 405 (MTP mode)" },
    { 0x0e791313, "Archos 605 (MTP mode)" },
    { 0x0e791315, "Archos 605F (MTP mode)" },
    { 0x0e791319, "Archos 705 (MTP mode)" },
    { 0x0e79131b, "Archos TV+ (MTP mode)" },
    { 0x0e79131d, "Archos 105 (MTP mode)" },
    { 0x0e791321, "Archos 405HDD (MTP mode)" },
    { 0x0e791330, "5 Tablet" },
    { 0x0e791331, "Archos 5 (MTP mode)" },
    { 0x0e791332, "5 IMT" },
    { 0x0e791333, "Archos 5 (MTP mode)" },
    { 0x0e791335, "Archos 7 (MTP mode)" },
    { 0x0e791341, "Archos SPOD (MTP mode)" },
    { 0x0e791351, "Archos 5S IT (MTP mode)" },
    { 0x0e791357, "Archos 5H IT (MTP mode)" },
    { 0x0e791416, "32 IT" },
    { 0x0e791417, "A43 IT" },
    { 0x0e791458, "Archos Arnova Childpad" },
    { 0x0e7914ad, "97 Titanium HD" },
    { 0x0e791508, "Archos 8o G9 (MTP mode)" },
    { 0x0e791509, "Archos 8o G9 Turbo (MTP mode)" },
    { 0x0e79150e, "80 G9" },
    { 0x0e791518, "Archos 80G9" },
    { 0x0e791528, "Archos 101 G9" },
    { 0x0e791529, "Archos 101 G9 (v2)" },
    { 0x0e791538, "Archos 101 G9 Turbo 250 HD" },
    { 0x0e791539, "Archos 101 G9 Turbo" },
    { 0x0e791568, "Archos 70it2 (mode 1)" },
    { 0x0e791569, "Archos 70it2 (mode 2)" },
    { 0x0e793001, "40 Titanium" },
    { 0x0e7e0001, "Yopy 3000 PDA" },
    { 0x0e7e1001, "YP3X00 PDA" },
    { 0x0e8d0002, "phone (mass storage mode) [Doro Primo 413]" },
    { 0x0e8d0003, "MT6227 phone" },
    { 0x0e8d0004, "MT6227 phone" },
    { 0x0e8d0023, "S103 / Powertel M6200" },
    { 0x0e8d00a5, "GSM modem [Medion Surfstick Model:S4222]" },
    { 0x0e8d1806, "Samsung SE-208 Slim Portable DVD Writer" },
    { 0x0e8d1836, "Samsung SE-S084 Super WriteMaster Slim External DVD writer" },
    { 0x0e8d1887, "Slim Portable DVD Writer" },
    { 0x0e8d1956, "Samsung SE-506 Portable BluRay Disc Writer" },
    { 0x0e8d2000, "MT65xx Preloader" },
    { 0x0e8d2008, "Cyrus Technology CS 24" },
    { 0x0e8d3329, "Qstarz BT-Q1000XT" },
    { 0x0e8d7612, "MT7612U 802.11a/b/g/n/ac Wireless Adapter" },
    { 0x0e8d763e, "MT7630e Bluetooth Adapter" },
    { 0x0e8d7668, "MT7668 2x2 Dual Band Dual Concurrent 802.11a/b/g/n/ac WiFi with MU-MIMO and Bluetooth 5.0 Radios" },
    { 0x0e8f0003, "MaxFire Blaze2" },
    { 0x0e8f0012, "Joystick/Gamepad" },
    { 0x0e8f0016, "4 port USB 1.1 hub UH-174" },
    { 0x0e8f0020, "USB to PS/2 Adapter" },
    { 0x0e8f0021, "Multimedia Keyboard Controller" },
    { 0x0e8f0022, "multimedia keyboard controller" },
    { 0x0e8f0201, "SmartJoy Frag Xpad/PS2 adaptor" },
    { 0x0e8f3008, "Xbox Controller" },
    { 0x0e8f300a, "steering Wheel" },
    { 0x0e900100, "Storage Adapter V1" },
    { 0x0e96c001, "TRUST 380 USB2 SPACEC@M" },
    { 0x0e970908, "Composite HID (Keyboard and Mouse)" },
    { 0x0e9c0000, "Streamzap Remote Control" },
    { 0x0ea02126, "7-in-1 Card Reader" },
    { 0x0ea02153, "SD Card Reader Key" },
    { 0x0ea02168, "Transcend JetFlash 2.0 / Astone USB Drive / Intellegent Stick 2.0" },
    { 0x0ea02213, "WinDroid N287 AH7N2502.013317" },
    { 0x0ea06803, "OTI-6803 Flash Disk" },
    { 0x0ea06808, "OTI-6808 Flash Disk" },
    { 0x0ea06828, "OTI-6828 Flash Disk" },
    { 0x0ea06858, "OTi-6858 serial adapter" },
    { 0x0eb09020, "NovaTech NV-902W" },
    { 0x0eb09021, "RT2573" },
    { 0x0eb16666, "WinFast WalkieTV TV Loader" },
    { 0x0eb16668, "WinFast WalkieTV TV Loader" },
    { 0x0eb17007, "WinFast WalkieTV WDM Capture" },
    { 0x0eb82200, "Ariva Scale" },
    { 0x0eb8f000, "BC60 Scale" },
    { 0x0ebb0002, "FT-IR Spectrometer" },
    { 0x0ec71008, "So., Show 301 Digital Camera" },
    { 0x0ecd1400, "CD\\RW 40X" },
    { 0x0ecda100, "LDW-411SX DVD/CD Rewritable Drive" },
    { 0x0ed16660, "Flash Disk 64M-C" },
    { 0x0ed16680, "Flash Disk 64M-B" },
    { 0x0ed17634, "MP3 Player" },
    { 0x0ed5e000, "USB-inSync Device" },
    { 0x0ed5f000, "Fiberbyte USB-inSync Device" },
    { 0x0ed5f201, "Fiberbyte USB-inSync DAQ-2500X" },
    { 0x0edf2060, "FID irock! 100 Series" },
    { 0x0ee31000, "Image Tank 1.5" },
    { 0x0ee40690, "SATA 3 Adapter" },
    { 0x0eee8810, "Mass Storage Drive" },
    { 0x0eef0001, "Titan6001 Surface Acoustic Wave Touchscreen Controller [eGalax]" },
    { 0x0eef0002, "Touchscreen Controller(Professional)" },
    { 0x0eef7200, "Touchscreen Controller" },
    { 0x0eef7904, "Multitouch Capacitive Touchscreen eGalaxTouch EXC7904-21v00_T13 [IIyama Prolite T1932-MSC]" },
    { 0x0eefa802, "eGalaxTouch EXC7920" },
    { 0x0eefb10e, "eGalaxTouch EXC3000" },
    { 0x0eefc000, "Multitouch Capacitive Touchscreen eGalaxTouch EXC3188-4643-08.00.00.00 Sirius_4643 PCAP3188UR Series [IIyama Prolite PLT1932MSC]" },
    { 0x0ef52202, "Flash Disk" },
    { 0x0ef52366, "Flash Disk" },
    { 0x0f030001, "Alpha 1200Sx" },
    { 0x0f0d000a, "Dead or Alive 4 FightStick for Xbox 360" },
    { 0x0f0d000c, "Horipad EX Turbo for Xbox 360" },
    { 0x0f0d000d, "Fighting Stick EX2 for Xbox 360" },
    { 0x0f0d0011, "Real Arcade Pro 3" },
    { 0x0f0d0016, "Real Arcade Pro.EX for Xbox 360" },
    { 0x0f0d001b, "Real Aracde Pro.VX" },
    { 0x0f0d0063, "Real Arcade Pro Hayabusa for Xbox One" },
    { 0x0f0d0067, "Horipad One" },
    { 0x0f0d0078, "Real Arcade Pro V Kai for Xbox One / Xbox 360" },
    { 0x0f0d0090, "Horipad Ultimate" },
    { 0x0f0d00c1, "HORIPAD for Nintendo Switch" },
    { 0x0f0f0006, "GreenPak Universal Dev Board (Active Mode)" },
    { 0x0f0f8006, "GreenPak Universal Dev Board (Reset Mode)" },
    { 0x0f111000, "CASSY-S" },
    { 0x0f111010, "Pocket-CASSY" },
    { 0x0f111020, "Mobile-CASSY" },
    { 0x0f111080, "Joule and Wattmeter" },
    { 0x0f111081, "Digital Multimeter P" },
    { 0x0f111090, "UMI P" },
    { 0x0f111100, "X-Ray Apparatus" },
    { 0x0f111101, "X-Ray Apparatus" },
    { 0x0f111200, "VideoCom" },
    { 0x0f112000, "COM3LAB" },
    { 0x0f112010, "Terminal Adapter" },
    { 0x0f112020, "Network Analyser" },
    { 0x0f112030, "Converter Control Unit" },
    { 0x0f112040, "Machine Test System" },
    { 0x0f140012, "Vital'Act 3S" },
    { 0x0f140038, "XIRING Smart Card Terminal LEO V2" },
    { 0x0f180002, "CCD" },
    { 0x0f180006, "Focuser" },
    { 0x0f180007, "Filter Wheel" },
    { 0x0f18000a, "ProLine CCD" },
    { 0x0f18000b, "Color Filter Wheel 4" },
    { 0x0f18000c, "PDF2" },
    { 0x0f18000d, "Guider" },
    { 0x0f30001c, "PS3 Guitar Controller Dongle" },
    { 0x0f30010b, "Philips Recoil" },
    { 0x0f300110, "Dual Analog Rumble Pad" },
    { 0x0f300111, "Colour Rumble Pad" },
    { 0x0f300202, "Joytech Advanced Controller" },
    { 0x0f300208, "Xbox & PC Gamepad" },
    { 0x0f308888, "BigBen XBMiniPad Controller" },
    { 0x0f390404, "Recreated ZX Spectrum Keyboard" },
    { 0x0f390876, "Keyboard [87 Francium Pro]" },
    { 0x0f391086, "DK2108SZ Keyboard [Ducky Zero]" },
    { 0x0f3d0112, "CDMA 1xEVDO PC Card, PC 5220" },
    { 0x0f44ef11, "Patriot (firmware not loaded)" },
    { 0x0f44ef12, "Patriot" },
    { 0x0f44ff11, "Liberty (firmware not loaded)" },
    { 0x0f44ff12, "Liberty" },
    { 0x0f490a00, "Zenius" },
    { 0x0f4d1000, "Bluetooth Dongle" },
    { 0x0f540101, "MP6 Stage Piano" },
    { 0x0f5d9455, "Compact Drive" },
    { 0x0f621001, "Targus Mini Trackball Optical Mouse" },
    { 0x0f630010, "Leapster Explorer" },
    { 0x0f630022, "Leap Reader" },
    { 0x0f630500, "Fly Fusion" },
    { 0x0f630600, "Leap Port Turbo" },
    { 0x0f630700, "POGO" },
    { 0x0f630800, "Didj" },
    { 0x0f630900, "TAGSchool" },
    { 0x0f630a00, "Leapster 2" },
    { 0x0f630b00, "Crammer" },
    { 0x0f630c00, "Tag Jr" },
    { 0x0f630d00, "My Pal Scout" },
    { 0x0f630e00, "Tag32" },
    { 0x0f630f00, "Tag64" },
    { 0x0f631000, "Kiwi16" },
    { 0x0f631100, "Leapster L2x" },
    { 0x0f631111, "Fly Fusion" },
    { 0x0f631300, "Didj UK/France (Leapster Advance)" },
    { 0x0f6e0100, "IS-CGB-EMULATOR" },
    { 0x0f6e0201, "GameBoy Advance Flash Gang Writer" },
    { 0x0f6e0202, "IS-AGB-CAPTURE" },
    { 0x0f6e0300, "IS-DOL-VIEWER" },
    { 0x0f6e0400, "IS-NITRO-EMULATOR" },
    { 0x0f6e0401, "IS-NITRO-UIC" },
    { 0x0f6e0402, "IS-NITRO-WRITER" },
    { 0x0f6e0403, "IS-NITRO-CAPTURE" },
    { 0x0f6e0404, "IS-NITRO-EMULATOR (DS Lite)" },
    { 0x0f6e0500, "IS-TWL-DEBUGGER" },
    { 0x0f6e0501, "IS-TWL-CAPTURE" },
    { 0x0f883012, "RT2570" },
    { 0x0f883014, "ZD1211B" },
    { 0x0f9c0301, "M-Any Premium DAH-610 MP3/WMA Player" },
    { 0x0f9c0332, "mobiBLU DAH-1200 MP3/Ogg Player" },
    { 0x0fb63fc3, "Firefly X10i I/O Board (with firmware)" },
    { 0x0fb63fc4, "Firefly X10i I/O Board (without firmware)" },
    { 0x0fb80002, "eHome Infrared Receiver" },
    { 0x0fc51222, "I/O Development Board" },
    { 0x0fca0001, "Blackberry Handheld" },
    { 0x0fca0004, "Blackberry Handheld" },
    { 0x0fca0006, "Blackberry Pearl" },
    { 0x0fca0008, "Blackberry Pearl" },
    { 0x0fca8001, "Blackberry Handheld" },
    { 0x0fca8004, "Blackberry" },
    { 0x0fca8007, "RIM BlackBerry Storm/9650" },
    { 0x0fca8010, "Blackberry Playbook (Connect to Windows mode)" },
    { 0x0fca8011, "Blackberry Playbook (Connect to Mac mode)" },
    { 0x0fca8014, "Blackberry Handheld Z30" },
    { 0x0fca8020, "Blackberry Playbook (CD-Rom mode)" },
    { 0x0fca8037, "Blackberry PRIV" },
    { 0x0fce0075, "SonyEricsson K850i" },
    { 0x0fce0076, "SonyEricsson W910" },
    { 0x0fce00af, "V640i Phone [PTP Camera]" },
    { 0x0fce00b3, "SonyEricsson W890i" },
    { 0x0fce00c6, "SonyEricsson W760i" },
    { 0x0fce00d4, "SonyEricsson C902" },
    { 0x0fce00d9, "SonyEricsson C702" },
    { 0x0fce00da, "SonyEricsson W980" },
    { 0x0fce00ef, "SonyEricsson C905" },
    { 0x0fce00f3, "SonyEricsson W595" },
    { 0x0fce00f5, "SonyEricsson W902" },
    { 0x0fce00fb, "SonyEricsson T700" },
    { 0x0fce0105, "SonyEricsson W705/W715" },
    { 0x0fce0112, "SonyEricsson W995" },
    { 0x0fce0133, "SonyEricsson U5" },
    { 0x0fce013a, "SonyEricsson U8i" },
    { 0x0fce0144, "SonyEricsson j10i2 (Elm)" },
    { 0x0fce014e, "SonyEricsson j108i (Cedar)" },
    { 0x0fce014f, "SonyEricsson LT15i Xperia arc S MTP" },
    { 0x0fce0156, "SonyEricsson MT11i Xperia Neo MTP" },
    { 0x0fce015a, "SonyEricsson MK16i Xperia MTP" },
    { 0x0fce0161, "SonyEricsson ST18a Xperia Ray MTP" },
    { 0x0fce0166, "SonyEricsson SK17i Xperia Mini Pro MTP" },
    { 0x0fce0167, "SonyEricsson ST15i Xperia Mini MTP" },
    { 0x0fce0168, "SonyEricsson ST17i Xperia Active MTP" },
    { 0x0fce0169, "SONY LT26i Xperia S MTP" },
    { 0x0fce016d, "SONY WT19i Live Walkman MTP" },
    { 0x0fce0170, "SONY ST21i Xperia Tipo MTP" },
    { 0x0fce0171, "SONY ST15i Xperia U MTP" },
    { 0x0fce0172, "SONY LT22i Xperia P MTP" },
    { 0x0fce0173, "SONY MT27i Xperia Sola MTP" },
    { 0x0fce0175, "SONY LT26w Xperia Acro HD IS12S MTP" },
    { 0x0fce0176, "SONY LT26w Xperia Acro HD SO-03D MTP" },
    { 0x0fce0177, "SONY LT28at Xperia Ion MTP" },
    { 0x0fce0178, "SONY LT29i Xperia GX MTP" },
    { 0x0fce017e, "SONY ST27i/ST27a Xperia go MTP" },
    { 0x0fce0181, "SONY SO-05D Xperia SX MTP" },
    { 0x0fce0182, "SONY LT30p Xperia T MTP" },
    { 0x0fce0186, "SONY LT25i Xperia V MTP" },
    { 0x0fce0188, "ST26i" },
    { 0x0fce019c, "C6833" },
    { 0x0fce019e, "C6903" },
    { 0x0fce01a5, "SO-04F" },
    { 0x0fce01a7, "D5503" },
    { 0x0fce01ba, "D6603 [Xperia Z3]" },
    { 0x0fce01bb, "D5803 [Xperia Z3 Compact] (MTP mode)" },
    { 0x0fce01e0, "F5122 [Xperia X dual] (MTP mode)" },
    { 0x0fce01e8, "F5321 [Xperia X Compact] (MTP mode)" },
    { 0x0fce01f9, "H8314 [Xperia XZ2 Compact]" },
    { 0x0fce1010, "WMC Modem" },
    { 0x0fce10af, "V640i Phone [PictBridge]" },
    { 0x0fce10c8, "SonyEricsson W302" },
    { 0x0fce10d4, "C902 Phone [PictBridge]" },
    { 0x0fce2105, "W715 Phone" },
    { 0x0fce2137, "Xperia X10 mini (USB debug)" },
    { 0x0fce2138, "Xperia X10 mini pro (Debug)" },
    { 0x0fce2149, "Xperia X8 (debug)" },
    { 0x0fce214e, "J108i Cedar (Windows-driver mode)" },
    { 0x0fce3137, "Xperia X10 mini" },
    { 0x0fce3138, "Xperia X10 mini pro" },
    { 0x0fce3149, "Xperia X8" },
    { 0x0fce4168, "SonyEricsson ST17i Xperia Active MTP+CDROM" },
    { 0x0fce4169, "SONY LT26i Xperia S MTP+CDROM" },
    { 0x0fce4170, "SONY ST21i Xperia Tipo MTP+CDROM" },
    { 0x0fce4171, "SONY ST25i Xperia U MTP+CDROM" },
    { 0x0fce4172, "SONY LT22i Xperia P MTP+CDROM" },
    { 0x0fce4173, "SONY MT27i Xperia Sola MTP+CDROM" },
    { 0x0fce4175, "SONY LT26w Xperia Acro HD IS12S MTP+CDROM" },
    { 0x0fce4176, "SONY LT26w Xperia Acro HD SO-03D MTP+CDROM" },
    { 0x0fce4177, "SONY LT28at Xperia Ion MTP+CDROM" },
    { 0x0fce4178, "SONY LT29i Xperia GX MTP+CDROM" },
    { 0x0fce417e, "SONY ST27i/ST27a Xperia go MTP+CDROM" },
    { 0x0fce4181, "SONY SO-05D Xperia SX MTP+CDROM" },
    { 0x0fce4182, "SONY LT30p Xperia T MTP+CDROM" },
    { 0x0fce4186, "SONY LT25i Xperia V MTP+CDROM" },
    { 0x0fce514f, "SonyEricsson LT15i Xperia Arc MTP+ADB" },
    { 0x0fce5156, "SonyEricsson MT11i Xperia Neo MTP+ADB" },
    { 0x0fce515a, "SonyEricsson MK16i Xperia MTP+ADB" },
    { 0x0fce5161, "SonyEricsson ST18i Xperia Ray MTP+ADB" },
    { 0x0fce5166, "SonyEricsson SK17i Xperia Mini Pro MTP+ADB" },
    { 0x0fce5167, "SonyEricsson ST15i Xperia Mini MTP+ADB" },
    { 0x0fce5168, "SonyEricsson ST17i Xperia Active MTP+ADB" },
    { 0x0fce5169, "SonyEricsson LT26i Xperia S MTP+ADB" },
    { 0x0fce516d, "SonyEricsson SK17i Xperia Mini Pro MTP+ADB" },
    { 0x0fce5170, "SONY ST21i Xperia Tipo MTP+ADB" },
    { 0x0fce5171, "SONY ST25i Xperia U MTP+ADB" },
    { 0x0fce5172, "SONY LT22i Xperia P MTP+ADB" },
    { 0x0fce5173, "SONY MT27i Xperia Sola MTP+ADB" },
    { 0x0fce5175, "SONY IS12S Xperia Acro HD MTP+ADB" },
    { 0x0fce5176, "SONY SO-03D Xperia Acro HD MTP+ADB" },
    { 0x0fce5177, "SONY LT28at Xperia Ion MTP+ADB" },
    { 0x0fce5178, "SONY LT29i Xperia GX MTP+ADB" },
    { 0x0fce517e, "SONY ST27i/ST27a Xperia go MTP+ADB" },
    { 0x0fce5181, "SONY SO-05D Xperia SX MTP+ADB" },
    { 0x0fce5182, "SONY LT30p Xperia T MTP+ADB" },
    { 0x0fce5186, "SONY LT25i Xperia V MTP+ADB" },
    { 0x0fce518c, "C1605 [Xperia E dual] MTD mode" },
    { 0x0fce51a7, "D5503 (Xperia Z1 Compact)" },
    { 0x0fce51e0, "F5122 [Xperia X dual] (developer mode)" },
    { 0x0fce614f, "Xperia X12 (debug mode)" },
    { 0x0fce6166, "Xperia Mini Pro" },
    { 0x0fce618c, "C1605 [Xperia E dual] MSC mode" },
    { 0x0fce715a, "Xperia Pro [Tethering]" },
    { 0x0fce7166, "Xperia Mini Pro (Tethering mode)" },
    { 0x0fce7177, "Xperia Ion [Tethering]" },
    { 0x0fce71f4, "G8441 (Xperia XZ1 Compact) [Tethering]" },
    { 0x0fce71f9, "H8314 [Xperia XZ2 Compact] (Tethering)" },
    { 0x0fce8004, "9000 Phone [Mass Storage]" },
    { 0x0fce81f4, "G8441 (Xperia XZ1 Compact) [Tethering]" },
    { 0x0fcea173, "SONY MT27i Xperia Sola MTP+UMS" },
    { 0x0fcea175, "SONY IS12S Xperia Acro HD MTP+UMS" },
    { 0x0fcea176, "SONY SO-03D Xperia Acro HD MTP+UMS" },
    { 0x0fcea177, "SONY LT28at Xperia Ion MTP+UMS" },
    { 0x0fcea17e, "SONY ST27i/ST27a Xperia go MTP+UMS" },
    { 0x0fceadde, "C2005 (Xperia M dual) in service mode" },
    { 0x0fceb173, "SONY MT27i Xperia Sola MTP+UMS+ADB" },
    { 0x0fceb175, "SONY IS12S Xperia Acro MTP+UMS+ADB" },
    { 0x0fceb176, "SONY SO-03D Xperia Acro MTP+UMS+ADB" },
    { 0x0fceb177, "SONY LT28at Xperia Ion MTP+UMS+ADB" },
    { 0x0fceb17e, "SONY ST27i/ST27a Xperia go MTP+UMS+ADB" },
    { 0x0fcec1e0, "F5122 [Xperia X dual] (MIDI mode)" },
    { 0x0fcec1e8, "F5321 [Xperia X Compact] (MIDI mode)" },
    { 0x0fcec1f9, "H8314 [Xperia XZ2 Compact] (MIDI)" },
    { 0x0fced008, "V800-Vodafone 802SE Phone" },
    { 0x0fced016, "K750i Phone" },
    { 0x0fced017, "K608i Phone" },
    { 0x0fced019, "VDC EGPRS Modem" },
    { 0x0fced025, "520 WMC Data Modem" },
    { 0x0fced028, "W800i" },
    { 0x0fced038, "W850i Phone" },
    { 0x0fced039, "K800i (phone mode)" },
    { 0x0fced041, "K510i Phone" },
    { 0x0fced042, "W810i Phone" },
    { 0x0fced043, "V630i Phone" },
    { 0x0fced046, "K610i Phone" },
    { 0x0fced065, "W960i Phone (PC Suite)" },
    { 0x0fced076, "W910i (Phone mode)" },
    { 0x0fced079, "K530 Phone" },
    { 0x0fced089, "W580i Phone (mass storage)" },
    { 0x0fced0a1, "K810" },
    { 0x0fced0af, "V640i Phone" },
    { 0x0fced0cf, "MD300 Mobile Broadband Modem" },
    { 0x0fced0d4, "C902 Phone [Modem]" },
    { 0x0fced0e1, "MD400 Mobile Broadband Modem" },
    { 0x0fced12a, "U100i Yari Phone" },
    { 0x0fced12e, "Xperia X10" },
    { 0x0fced144, "SonyEricsson j10i (Elm)" },
    { 0x0fced14e, "J108i Cedar (modem mode)" },
    { 0x0fcee000, "SonyEricsson K550i" },
    { 0x0fcee039, "K800i (msc mode)" },
    { 0x0fcee042, "W810i Phone" },
    { 0x0fcee043, "V630i Phone [Mass Storage]" },
    { 0x0fcee075, "K850i" },
    { 0x0fcee076, "W910i (Mass storage)" },
    { 0x0fcee089, "W580i Phone" },
    { 0x0fcee090, "W200 Phone (Mass Storage)" },
    { 0x0fcee0a1, "K810 (Mass Storage mode)" },
    { 0x0fcee0a3, "W660i" },
    { 0x0fcee0af, "V640i Phone [Mass Storage]" },
    { 0x0fcee0d4, "C902 Phone [Mass Storage]" },
    { 0x0fcee0ef, "C905 Phone [Mass Storage]" },
    { 0x0fcee0f3, "W595" },
    { 0x0fcee105, "W705" },
    { 0x0fcee112, "W995 Phone (Mass Storage)" },
    { 0x0fcee12e, "X10i Phone" },
    { 0x0fcee133, "Vivaz" },
    { 0x0fcee14e, "J108i Cedar (mass-storage mode)" },
    { 0x0fcee14f, "Xperia Arc/X12" },
    { 0x0fcee15a, "Xperia Pro [Mass Storage Class]" },
    { 0x0fcee161, "Xperia Ray" },
    { 0x0fcee166, "Xperia Mini Pro" },
    { 0x0fcee167, "XPERIA mini" },
    { 0x0fcee19b, "C2005 [Xperia M dual] (Mass Storage)" },
    { 0x0fcee1a9, "D5303" },
    { 0x0fcee1aa, "D2303" },
    { 0x0fcee1ad, "D5103" },
    { 0x0fcee1b0, "D6708" },
    { 0x0fcee1b5, "D2004" },
    { 0x0fcee1ba, "D6683" },
    { 0x0fcee1bb, "SO-02G" },
    { 0x0fcee1bc, "D2203" },
    { 0x0fcee1c0, "SGP621" },
    { 0x0fcee1c2, "D2533" },
    { 0x0fcee1c9, "E6553" },
    { 0x0fcee1cf, "SGP771" },
    { 0x0fcef0fa, "MN800 / Smartwatch 2 (DFU mode)" },
    { 0x0fcf1003, "ANT Development Board" },
    { 0x0fcf1004, "ANTUSB Stick" },
    { 0x0fcf1006, "ANT Development Board" },
    { 0x0fcf1008, "ANTUSB2 Stick" },
    { 0x0fcf1009, "ANTUSB-m Stick" },
    { 0x0fd20001, "RDS 6000" },
    { 0x0fd90011, "EyeTV Diversity" },
    { 0x0fd90018, "EyeTV Hybrid" },
    { 0x0fd90020, "EyeTV DTT Deluxe" },
    { 0x0fd90021, "EyeTV DTT" },
    { 0x0fd9002a, "EyeTV Sat" },
    { 0x0fd9002c, "EyeTV DTT Deluxe v2" },
    { 0x0fd90033, "Video Capture" },
    { 0x0fd90037, "Video Capture v2" },
    { 0x0fd90060, "Stream Deck" },
    { 0x0fd90063, "Stream Deck Mini" },
    { 0x0fd9006c, "Stream Deck XL" },
    { 0x0fd9006d, "Stream Deck original V2" },
    { 0x0fda0100, "quanton flight control" },
    { 0x0fdeca01, "WMRS200 weather station" },
    { 0x0fdeca05, "CM160" },
    { 0x0fdeca08, "WMR300 Professional Weather System" },
    { 0x0fe00100, "Bluetooth Mouse" },
    { 0x0fe00101, "Bluetooth IMU" },
    { 0x0fe00200, "Bluetooth Keypad" },
    { 0x0fe68101, "DM9601 Fast Ethernet Adapter" },
    { 0x0fe6811e, "Parallel Adapter" },
    { 0x0fe69700, "DM9601 Fast Ethernet Adapter" },
    { 0x0fe94020, "TViX M-6500" },
    { 0x0fe99010, "FusionRemote IR receiver" },
    { 0x0fe9db00, "FusionHDTV DVB-T (MT352+LgZ201) (uninitialized)" },
    { 0x0fe9db01, "FusionHDTV DVB-T (MT352+LgZ201) (initialized)" },
    { 0x0fe9db10, "FusionHDTV DVB-T (MT352+Thomson7579) (uninitialized)" },
    { 0x0fe9db11, "FusionHDTV DVB-T (MT352+Thomson7579) (initialized)" },
    { 0x0fe9db78, "FusionHDTV DVB-T Dual Digital 4 (ZL10353+xc2028/xc3028) (initialized)" },
    { 0x0ffc0021, "Nord Stage 2" },
    { 0x0ffc002a, "Nord Piano 4" },
    { 0x0ffdff00, "OEM" },
    { 0x1000153b, "TerraTec Electronic GmbH" },
    { 0x10030003, "SD14" },
    { 0x10030100, "SD9/SD10" },
    { 0x10038781, "Dock UD-01" },
    { 0x10041fae, "U8120 3G Cellphone" },
    { 0x10046000, "Various Mobile Phones" },
    { 0x10046005, "T5100" },
    { 0x10046010, "LG Electronics Inc. VX8550 V CAST Mobile Phone" },
    { 0x10046018, "GM360/GD510/GW520/KP501" },
    { 0x1004608f, "LG Electronics Inc. KC910 Renoir Mobile Phone" },
    { 0x1004611b, "LG Electronics Inc. GR-500 Music Player" },
    { 0x10046132, "LG Electronics Inc. KM900" },
    { 0x1004618e, "Ally/Optimus One/Vortex (debug mode)" },
    { 0x1004618f, "Ally/Optimus One" },
    { 0x1004619a, "LG Electronics Inc. LG8575" },
    { 0x100461c5, "P880 / Charge only" },
    { 0x100461c6, "Vortex (msc)" },
    { 0x100461cc, "Optimus S" },
    { 0x100461da, "G2 Android Phone [tethering mode]" },
    { 0x100461f1, "Optimus Android Phone [LG Software mode]" },
    { 0x100461f9, "LG Electronics Inc. V909 G-Slate" },
    { 0x100461fc, "Optimus 3" },
    { 0x100461fe, "Optimus Android Phone [USB tethering mode]" },
    { 0x1004627f, "G3 (VS985) Android Phone (MTP/Download mode)" },
    { 0x10046300, "G2/Optimus Android Phone [Charge mode]" },
    { 0x1004631c, "LG Electronics Inc. LG-E617G/P700" },
    { 0x1004631d, "Optimus Android Phone (Camera/PTP Mode)" },
    { 0x1004631e, "LM-X420xxx/G2/Optimus Android Phone (PTP/camera mode)" },
    { 0x1004631f, "Optimus Android Phone (Charge Mode)" },
    { 0x1004633a, "Ultimate 2 Android Phone L41C" },
    { 0x1004633e, "LM-X420xxx/G2/G3 Android Phone (MTP/download mode)" },
    { 0x10046344, "LM-X420xxx/G2 Android Phone (USB tethering mode)" },
    { 0x10046348, "LM-X420xxx Android Phone (MIDI mode)" },
    { 0x10046356, "Optimus Android Phone [Virtual CD mode]" },
    { 0x10046800, "CDMA Modem" },
    { 0x10047000, "LG LDP-7024D(LD)USB" },
    { 0x100491c8, "P880 / USB tethering" },
    { 0x1004a400, "Renoir (KC910)" },
    { 0x10051001, "MP3 Player" },
    { 0x10051004, "MP3 Player" },
    { 0x10051006, "MP3 Player" },
    { 0x1005b113, "Handy Steno/AH123 / Handy Steno 2.0/HT203" },
    { 0x1005b155, "Disk Module" },
    { 0x1005b223, "CD-RW + 6in1 Card Reader Digital Storage / Converter" },
    { 0x10063001, "iHP-100" },
    { 0x10063002, "iHP-120/140 MP3 Player" },
    { 0x10063003, "H320/H340" },
    { 0x10063004, "iRiver H300 Series MTP" },
    { 0x10064002, "iRiver Portable Media Center" },
    { 0x10064003, "iRiver Portable Media Center" },
    { 0x1009000e, "eHome Infrared Receiver" },
    { 0x10090013, "Angel MPEG Device" },
    { 0x10090015, "Lumanate Wave PAL SECAM DVBT Device" },
    { 0x10090016, "Lumanate Wave NTSC/ATSC Combo Device" },
    { 0x100a2402, "MP3 Player" },
    { 0x100a2404, "MP3 Player" },
    { 0x100a2405, "MP3 Player" },
    { 0x100a2406, "MP3 Player" },
    { 0x100aa0c0, "MP3 Player" },
    { 0x100d3342, "Cayman 3352 DSL Modem" },
    { 0x100d3382, "3380 Series Network Interface" },
    { 0x100d6072, "DSL Modem" },
    { 0x100d9031, "Motorola 802.11n Dualband USB Wireless Adapter" },
    { 0x100d9032, "Motorola 802.11n 5G USB Wireless Adapter" },
    { 0x100dcb01, "Cayman 3341 Ethernet DSL Router" },
    { 0x10110001, "AccFast Mp3" },
    { 0x10179015, "M625 [Vendor: DELUX]" },
    { 0x10190c55, "Flash Reader, Desknote UCR-61S2B" },
    { 0x10190f38, "Infrared Receiver" },
    { 0x10200006, "Wireless Keyboard" },
    { 0x1020000a, "Wireless Optical Mouse" },
    { 0x10200106, "Wireless Optical Mouse/Keyboard" },
    { 0x1025005e, "USB DVB-T device" },
    { 0x1025005f, "USB DVB-T device" },
    { 0x10250300, "MP3 Player" },
    { 0x10250350, "MP3 Player" },
    { 0x102c6151, "Q-Cam Sangha CIF" },
    { 0x102c6251, "Q-Cam VGA" },
    { 0x102cff0c, "Joytech Wireless Advanced Controller" },
    { 0x10330068, "3,5'' HDD case MD-231" },
    { 0x10380100, "Ideazon Zboard" },
    { 0x10381260, "Arctis 7 wireless adapter" },
    { 0x10381361, "Ideazon Sensei" },
    { 0x10381410, "SRW-S1 [Simraceway Steering Wheel]" },
    { 0x10381720, "Mouse" },
    { 0x10390824, "1866 802.11bg [Texas Instruments TNETW1450]" },
    { 0x10392140, "dsl+ 1100 duo" },
    { 0x103af000, "Actia Evo XS" },
    { 0x103d0100, "ScratchAmp" },
    { 0x103d0101, "ScratchAmp" },
    { 0x10421143, "iRiver T7 Volcano" },
    { 0x1043160f, "Wireless Network Adapter" },
    { 0x10434901, "AV-836 Video Capture Device" },
    { 0x10438006, "Flash Disk 32-256 MB" },
    { 0x10438012, "Flash Disk 256 MB" },
    { 0x10447001, "Gigabyte U7000 DVB-T tuner" },
    { 0x10447002, "Gigabyte U8000 DVB-T tuner" },
    { 0x10447004, "Gigabyte U7100 DVB-T tuner" },
    { 0x10447005, "Gigabyte U7200 DVB-T tuner [AF9035]" },
    { 0x10447006, "Gigabyte U6000 DVB-T tuner [em2863]" },
    { 0x10448001, "GN-54G" },
    { 0x10448002, "GN-BR402W" },
    { 0x10448003, "GN-WLBM101" },
    { 0x10448004, "GN-WLBZ101 802.11b Adapter" },
    { 0x10448005, "GN-WLBZ201 802.11b Adapter" },
    { 0x10448006, "GN-WBZB-M 802.11b Adapter" },
    { 0x10448007, "GN-WBKG" },
    { 0x10448008, "GN-WB01GS" },
    { 0x1044800a, "GN-WI05GS" },
    { 0x1044800b, "GN-WB30N 802.11n WLAN Card" },
    { 0x1044800c, "GN-WB31N 802.11n USB WLAN Card" },
    { 0x1044800d, "GN-WB32L 802.11n USB WLAN Card" },
    { 0x10466694, "Generic W6694 USB" },
    { 0x10468901, "Bluetooth Device" },
    { 0x10469967, "W9967CF/W9968CF Webcam IC" },
    { 0x10482010, "4-Port hub" },
    { 0x104d1003, "Model-52 LED Light Source Power Supply and Driver" },
    { 0x104d3001, "ESP301 3 Axis Motion Controller" },
    { 0x104f0001, "Infinity Phoenix" },
    { 0x104f0002, "Smartmouse" },
    { 0x104f0003, "FunProgrammer" },
    { 0x104f0004, "Infinity Unlimited" },
    { 0x104f0006, "Infinity Smart" },
    { 0x104f0007, "Infinity Smart module" },
    { 0x104f0008, "Infinity CryptoKey" },
    { 0x104f0009, "RE-BL PlayStation 3 IR-to-Bluetooth converter" },
    { 0x10500010, "Yubikey (v1 or v2)" },
    { 0x10500110, "Yubikey NEO(-N) OTP" },
    { 0x10500111, "Yubikey NEO(-N) OTP+CCID" },
    { 0x10500112, "Yubikey NEO(-N) CCID" },
    { 0x10500113, "Yubikey NEO(-N) U2F" },
    { 0x10500114, "Yubikey NEO(-N) OTP+U2F" },
    { 0x10500115, "Yubikey NEO(-N) U2F+CCID" },
    { 0x10500116, "Yubikey NEO(-N) OTP+U2F+CCID" },
    { 0x10500120, "Yubikey Touch U2F Security Key" },
    { 0x10500200, "Gnubby U2F" },
    { 0x10500211, "Gnubby" },
    { 0x10500401, "Yubikey 4/5 OTP" },
    { 0x10500402, "Yubikey 4/5 U2F" },
    { 0x10500403, "Yubikey 4/5 OTP+U2F" },
    { 0x10500404, "Yubikey 4/5 CCID" },
    { 0x10500405, "Yubikey 4/5 OTP+CCID" },
    { 0x10500406, "Yubikey 4/5 U2F+CCID" },
    { 0x10500407, "Yubikey 4/5 OTP+U2F+CCID" },
    { 0x10500410, "Yubikey plus OTP+U2F" },
    { 0x10545004, "DSL 7420 Loader" },
    { 0x10545005, "DSL 7420 LAN Modem" },
    { 0x10580200, "FireWire USB Combo" },
    { 0x10580400, "External HDD" },
    { 0x10580500, "hub" },
    { 0x10580701, "WD Passport (WDXMS)" },
    { 0x10580702, "WD Passport (WDXMS)" },
    { 0x10580704, "My Passport Essential (WDME)" },
    { 0x10580705, "My Passport Elite (WDML)" },
    { 0x1058070a, "My Passport Essential (WDBAAA), My Passport for Mac (WDBAAB), My Passport Essential SE (WDBABM), My Passport SE for Mac (WDBABW)" },
    { 0x1058070b, "My Passport Elite (WDBAAC)" },
    { 0x1058070c, "My Passport Studio (WDBAAE)" },
    { 0x1058071a, "My Passport Essential (WDBAAA)" },
    { 0x1058071d, "My Passport Studio (WDBALG)" },
    { 0x10580730, "My Passport Essential (WDBACY)" },
    { 0x10580732, "My Passport Essential SE (WDBGYS)" },
    { 0x10580740, "My Passport Essential (WDBACY)" },
    { 0x10580741, "My Passport Ultra" },
    { 0x10580742, "My Passport Essential SE (WDBGYS)" },
    { 0x10580748, "My Passport (WDBKXH, WDBY8L)" },
    { 0x105807a8, "My Passport (WDBBEP), My Passport for Mac (WDBLUZ)" },
    { 0x105807ae, "My Passport Edge for Mac (WDBJBH)" },
    { 0x105807ba, "PiDrive (WDLB)" },
    { 0x10580810, "My Passport Ultra (WDBZFP)" },
    { 0x10580816, "My Passport Air (WDBBLW)" },
    { 0x10580820, "My Passport Ultra (WDBMWV, WDBZFP)" },
    { 0x10580822, "My Passport Ultra (WDBBUZ)" },
    { 0x10580824, "My Passport Slim (WDBPDZ)" },
    { 0x10580830, "My Passport Ultra (WDBZFP)" },
    { 0x10580837, "My Passport Ultra (WDBBKD)" },
    { 0x10580900, "MyBook Essential External HDD" },
    { 0x10580901, "My Book Essential Edition (Green Ring) (WDG1U)" },
    { 0x10580902, "My Book Pro Edition (WDG1T)" },
    { 0x10580903, "My Book Premium Edition" },
    { 0x10580905, "My Book Pro Edition II (WD10000C033-001)" },
    { 0x10580910, "My Book Essential Edition (Green Ring) (WDG1U)" },
    { 0x10581001, "Elements Desktop (WDE1U)" },
    { 0x10581003, "WD Elements Desktop (WDE1UBK)" },
    { 0x10581010, "Elements Portable (WDBAAR)" },
    { 0x10581021, "Elements Desktop (WDBAAU)" },
    { 0x10581023, "Elements SE Portable (WDBABV)" },
    { 0x10581042, "Elements SE Portable (WDBPCK)" },
    { 0x10581048, "Elements Portable (WDBU6Y)" },
    { 0x10581078, "Elements Portable (WDBUZG)" },
    { 0x1058107c, "Elements Desktop (WDBWLG)" },
    { 0x105810a2, "Elements SE Portable (WDBPCK)" },
    { 0x105810a8, "Elements Portable (WDBUZG)" },
    { 0x105810b8, "Elements Portable (WDBU6Y, WDBUZG)" },
    { 0x10581100, "My Book Essential Edition 2.0 (WDH1U)" },
    { 0x10581102, "My Book Home Edition (WDH1CS)" },
    { 0x10581103, "My Book Studio" },
    { 0x10581104, "My Book Mirror Edition (WDH2U)" },
    { 0x10581105, "My Book Studio II" },
    { 0x10581110, "My Book Essential (WDBAAF), My Book for Mac (WDBAAG)" },
    { 0x10581111, "My Book Elite (WDBAAH)" },
    { 0x10581112, "My Book Studio (WDBAAJ), My Book Studio LX (WDBACH)" },
    { 0x10581123, "My Book 3.0 (WDBABP)" },
    { 0x10581130, "My Book Essential (WDBACW)" },
    { 0x10581140, "My Book Essential (WDBACW)" },
    { 0x10581170, "My Book Essential 3TB (WDBACW0030HBK)" },
    { 0x10581230, "My Book (WDBFJK)" },
    { 0x10581235, "My Book (WDBFJK0040HBK)" },
    { 0x10582599, "My Passport Ultra (WD40NMZW)" },
    { 0x1058259d, "My Passport Ultra (WDBBKD)" },
    { 0x1058259f, "My Passport Ultra (WD10JMVW)" },
    { 0x105825a1, "Elements / My Passport" },
    { 0x105825a2, "Elements 25A2" },
    { 0x105825a3, "Elements Desktop (WDBWLG)" },
    { 0x105825da, "My Book (WDBFJK)" },
    { 0x105825e1, "My Passport (WD20NMVW)" },
    { 0x105825e2, "My Passport (WD40NMZW)" },
    { 0x105825ee, "My Book 25EE" },
    { 0x105825f3, "My Passport SSD (WDBK3E)" },
    { 0x105825fa, "easystore Portable 5TB (WDBKUZ0050)" },
    { 0x105825fb, "easystore Desktop (WDBCKA)" },
    { 0x10582603, "My Passport Game Storage for PS4 4TB (WDBZGE0040)" },
    { 0x10582624, "easystore Portable 5TB (WDBKUZ0050)" },
    { 0x10582626, "My Passport (WDBPKJ)" },
    { 0x105830a0, "SATA adapter cable" },
    { 0x1059000b, "StarSign Bio Token 3.0" },
    { 0x105be065, "BCM43142A0 Bluetooth module" },
    { 0x10631555, "MC141555 Hub" },
    { 0x10634100, "SB4100 USB Cable Modem" },
    { 0x10650020, "USB-DVR2 Dev Board" },
    { 0x10652136, "EasyDisk ED1064" },
    { 0x10680001, "CPUSB - V 1.8 - software-rights management key" },
    { 0x106c1101, "CDMA 2000 1xRTT USB modem (HX-550C)" },
    { 0x106c1102, "Packet Service" },
    { 0x106c1103, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1104, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1105, "Composite Device" },
    { 0x106c1106, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1301, "Composite Device" },
    { 0x106c1302, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1303, "Packet Service" },
    { 0x106c1304, "Packet Service" },
    { 0x106c1401, "Composite Device" },
    { 0x106c1402, "Packet Service" },
    { 0x106c1403, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1501, "Packet Service" },
    { 0x106c1502, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1503, "Packet Service" },
    { 0x106c1601, "Packet Service" },
    { 0x106c1602, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c1603, "Packet Service" },
    { 0x106c2101, "AudioVox 8900 Cell Phone" },
    { 0x106c2102, "Packet Service" },
    { 0x106c2103, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c2301, "Packet Service" },
    { 0x106c2302, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c2303, "Packet Service" },
    { 0x106c2401, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c2402, "Packet Service" },
    { 0x106c2403, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c2501, "Packet Service" },
    { 0x106c2502, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c2503, "Packet Service" },
    { 0x106c2601, "Packet Service" },
    { 0x106c2602, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c2603, "Packet Service" },
    { 0x106c3701, "Broadband Wireless modem" },
    { 0x106c3702, "Pantech PX-500" },
    { 0x106c3714, "PANTECH USB MODEM [UM175]" },
    { 0x106c3716, "UMW190 Modem" },
    { 0x106c3721, "Option Beemo (GI0801) LTE surfstick" },
    { 0x106c3b14, "Option Beemo (GI0801) LTE surfstick" },
    { 0x106c3eb4, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c4101, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c4102, "Packet Service" },
    { 0x106c4301, "Composite Device" },
    { 0x106c4302, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c4401, "Composite Device" },
    { 0x106c4402, "Packet Service" },
    { 0x106c4501, "Packet Service" },
    { 0x106c4502, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c4601, "Composite Device" },
    { 0x106c4602, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c5101, "Packet Service" },
    { 0x106c5102, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c5301, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c5302, "Packet Service" },
    { 0x106c5401, "Packet Service" },
    { 0x106c5402, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c5501, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c5502, "Packet Service" },
    { 0x106c5601, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106c5602, "Packet Service" },
    { 0x106c7101, "Composite Device" },
    { 0x106c7102, "Packet Service" },
    { 0x106ca000, "Packet Service" },
    { 0x106ca001, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106cc100, "Packet Service" },
    { 0x106cc200, "Packet Service" },
    { 0x106cc500, "Packet Service Diagnostic Serial Port (WDM)" },
    { 0x106ce200, "Packet Service" },
    { 0x106cf003, "Pantech Crux" },
    { 0x106f0009, "CT10x Coin Transaction" },
    { 0x106f000a, "CR10x Coin Recycler" },
    { 0x106f000c, "Xchange" },
    { 0x10760031, "Bluetooth Device" },
    { 0x10760032, "Bluetooth Device" },
    { 0x10768002, "LU150 LTE Modem [Yota LU150]" },
    { 0x107b3009, "eHome Infrared Transceiver" },
    { 0x107b55b2, "WBU-110 802.11b Wireless Adapter [Intersil PRISM 3]" },
    { 0x107b55f2, "WGU-210 802.11g Adapter [Intersil ISL3886]" },
    { 0x1083160c, "CR-55" },
    { 0x1083160f, "DR-1210C" },
    { 0x10831614, "DR-4010C" },
    { 0x10831617, "DR-2510C" },
    { 0x10831618, "DR-X10C" },
    { 0x1083161a, "CR-25" },
    { 0x1083161b, "DR-2010C Scanner" },
    { 0x1083161d, "DR-3010C" },
    { 0x10831620, "DR-7090C" },
    { 0x10831622, "DR-9050C" },
    { 0x10831623, "DR-7550C" },
    { 0x10831624, "DR-6050C" },
    { 0x10831626, "DR-6010C" },
    { 0x1083162c, "P-150 Scanner" },
    { 0x10831638, "DR-6030C" },
    { 0x10831639, "CR-135i" },
    { 0x1083163e, "DR-M160" },
    { 0x1083163f, "DR-M140" },
    { 0x10831640, "DR-C125" },
    { 0x10831641, "DR-P215" },
    { 0x10831648, "FSU-201" },
    { 0x1083164a, "DR-C130" },
    { 0x1083164b, "DR-P208" },
    { 0x1083164f, "DR-G1130" },
    { 0x10831650, "DR-G1100" },
    { 0x10831651, "DR-C120" },
    { 0x10831654, "DR-F120" },
    { 0x10831657, "DR-M1060" },
    { 0x10831658, "DR-C225" },
    { 0x10831659, "DR-P215II" },
    { 0x1083165d, "DR-P208II" },
    { 0x108b0005, "HID Keyboard/Mouse PS/2 Translator" },
    { 0x108c017e, "GTC 400 C" },
    { 0x10918101, "Absoflex" },
    { 0x109b9109, "CROSSCALL Trekker-M1 Core (MTP-Mode)" },
    { 0x109b9118, "Medion P4013 Mobile" },
    { 0x109b9119, "CROSSCALL Trekker-M1 Core (PTP-Mode)" },
    { 0x109bf009, "CROSSCALL Trekker-M1 Core (CD-ROM-Mode)" },
    { 0x109f3163, "Trigem Mobile SmartDisplay84" },
    { 0x109f3164, "Trigem Mobile SmartDisplay121" },
    { 0x10a91102, "Sky Love Actually IM-U460K" },
    { 0x10a91104, "Sky Vega IM-A650S" },
    { 0x10a91105, "VEGA Android composite" },
    { 0x10a91106, "VEGA Android composite" },
    { 0x10a91107, "VEGA Android composite" },
    { 0x10a91108, "VEGA Android composite" },
    { 0x10a91109, "VEGA Android composite" },
    { 0x10a96021, "SIRIUS alpha" },
    { 0x10a96031, "Pantech Android composite" },
    { 0x10a96032, "Pantech Android composite" },
    { 0x10a96033, "Pantech Android composite" },
    { 0x10a96034, "Pantech Android composite" },
    { 0x10a96035, "Pantech Android composite" },
    { 0x10a96036, "Pantech Android composite" },
    { 0x10a96037, "Pantech Android composite" },
    { 0x10a96050, "Pantech Android composite" },
    { 0x10a96051, "Pantech Android composite" },
    { 0x10a96052, "Pantech Android composite" },
    { 0x10a96053, "Pantech Android composite" },
    { 0x10a96054, "Pantech Android composite" },
    { 0x10a96055, "Pantech Android composite" },
    { 0x10a96056, "Pantech Android composite" },
    { 0x10a96057, "Pantech Android composite" },
    { 0x10a96058, "Pantech Android composite" },
    { 0x10a96059, "Pantech Android composite" },
    { 0x10a96080, "MHS291LVW LTE Modem [Verizon Jetpack 4G LTE Mobile Hotspot MHS291L] (Zero CD Mode)" },
    { 0x10a96085, "MHS291LVW LTE Modem [Verizon Jetpack 4G LTE Mobile Hotspot MHS291L] (Modem Mode)" },
    { 0x10a97031, "Pantech Android composite" },
    { 0x10a97032, "Pantech Android composite" },
    { 0x10a97033, "Pantech Android composite" },
    { 0x10a97034, "Pantech Android composite" },
    { 0x10a97035, "Pantech Android composite" },
    { 0x10a97036, "Pantech Android composite" },
    { 0x10a97037, "Pantech Android composite" },
    { 0x10ab1002, "Bluetooth Device" },
    { 0x10ab1003, "BC02-EXT in DFU" },
    { 0x10ab1005, "Bluetooth Adptr" },
    { 0x10ab1006, "BC04-EXT in DFU" },
    { 0x10ab10c5, "Sony-Ericsson / Samsung DataCable" },
    { 0x10af0000, "UPS" },
    { 0x10af0001, "PowerSure PSA UPS" },
    { 0x10af0002, "PowerSure PST UPS" },
    { 0x10af0003, "PowerSure PSP UPS" },
    { 0x10af0004, "PowerSure PSI UPS" },
    { 0x10af0005, "UPStation GXT 2U UPS" },
    { 0x10af0006, "UPStation GXT UPS" },
    { 0x10af0007, "Nfinity Power Systems UPS" },
    { 0x10af0008, "PowerSure Interactive UPS" },
    { 0x10b59060, "Test Board" },
    { 0x10b80bb8, "DVB-T reference design (MOD300) (cold)" },
    { 0x10b80bb9, "DVB-T reference design (MOD300) (warm)" },
    { 0x10b80bc6, "DVB-T reference design (MOD3000P) (cold)" },
    { 0x10b80bc7, "DVB-T reference design (MOD3000P) (warm)" },
    { 0x10bd1427, "Ethernet" },
    { 0x10bf0001, "SmartHome PowerLinc" },
    { 0x10c300a4, "ULS PLS Series Laser Engraver Firmware Loader" },
    { 0x10c300a5, "ULS Print Support" },
    { 0x10c40002, "F32x USBXpress Device" },
    { 0x10c40003, "CommandIR" },
    { 0x10c4800a, "SPORTident" },
    { 0x10c4800b, "AES" },
    { 0x10c48030, "K4JRG Ham Radio devices" },
    { 0x10c48044, "USB Debug Adapter" },
    { 0x10c4804e, "Software Bisque Paramount ME" },
    { 0x10c480a9, "CP210x to UART Bridge Controller" },
    { 0x10c480c4, "Infrared Thermometer Adapter" },
    { 0x10c480ca, "ATM2400 Sensor Device" },
    { 0x10c4813f, "tams EasyControl" },
    { 0x10c48149, "West Mountain Radio Computerized Battery Analyzer" },
    { 0x10c4814a, "West Mountain Radio RIGblaster P&P" },
    { 0x10c4814b, "West Mountain Radio RIGtalk" },
    { 0x10c4818a, "Silicon Labs FM Radio Reference Design" },
    { 0x10c481e8, "Zephyr BioHarness" },
    { 0x10c4834b, "Infrared Online Sensor Adapter" },
    { 0x10c4834e, "Infrared Sensor Adapter" },
    { 0x10c48460, "Sangoma Wanpipe VoiceTime" },
    { 0x10c48461, "Sangoma U100" },
    { 0x10c48470, "Juniper Networks BX Series System Console" },
    { 0x10c48477, "Balluff RFID Reader" },
    { 0x10c48496, "SiLabs Cypress FW downloader" },
    { 0x10c48497, "SiLabs Cypress EVB" },
    { 0x10c484fb, "Infrared Blackbody Adapter" },
    { 0x10c48508, "RS485 Adapter" },
    { 0x10c48605, "dilitronics ESoLUX solar lighting controller" },
    { 0x10c48660, "Netronics CANdoISO" },
    { 0x10c486bc, "C8051F34x AudioDelay [AD-340]" },
    { 0x10c48789, "C8051F34x Extender & EDID MGR [EMX-DVI]" },
    { 0x10c487be, "C8051F34x HDMI Audio Extractor [EMX-HD-AUD]" },
    { 0x10c48863, "C8051F34x Bootloader" },
    { 0x10c48897, "C8051F38x HDMI Splitter [UHBX]" },
    { 0x10c488c9, "AES HID device" },
    { 0x10c48918, "C8051F38x HDMI Audio Extractor [VSA-HA-DP]" },
    { 0x10c48973, "C8051F38x HDMI Extender [UHBX-8X]" },
    { 0x10c489c6, "SPORTident HID device" },
    { 0x10c489e1, "C8051F38x HDMI Extender [UHBX-SW3-WP]" },
    { 0x10c489fb, "Qivicon ZigBee Stick" },
    { 0x10c48a3c, "C8051F38x HDBaseT Receiver [UHBX-R-XT]" },
    { 0x10c48a6c, "C8051F38x 4K HDMI Audio Extractor [EMX-AMP]" },
    { 0x10c48acb, "C8051F38x HDBaseT Wall Plate Receiver with IR, RS-232, and PoH [UHBX-R-WP]" },
    { 0x10c48af8, "C8051F38x 4K HDMI Audio Extractor w/Audio Amplifier, HDBT Input, Line Audio Input RS-232 Ports and IP Control [VSA-X21]" },
    { 0x10c48b8c, "C8051F38x 4K HDMI Audio Extractor w/Audio Amplifier, HDBT Input, Line Audio Input RS-232 Ports and IP Control [SC-3H]" },
    { 0x10c48db5, "C8051F38x CATx HDMI Receiver with USB [EX-HDU-R]" },
    { 0x10c48db6, "C8051F38x CATx HDMI Receiver" },
    { 0x10c4ea60, "CP210x UART Bridge" },
    { 0x10c4ea61, "CP210x UART Bridge" },
    { 0x10c4ea63, "CP210x UART Bridge" },
    { 0x10c4ea70, "CP2105 Dual UART Bridge" },
    { 0x10c4ea71, "CP2108 Quad UART Bridge" },
    { 0x10c4ea80, "CP2110 HID UART Bridge" },
    { 0x10c4ea90, "CP2112 HID I2C Bridge" },
    { 0x10c4ea91, "CP2112 HID SMBus/I2C Bridge for CP2614 Evaluation Kit" },
    { 0x10c4ea93, "CP2112 HID SMBus/I2C Bridge for CP2615 Evaluation Kit" },
    { 0x10c4eab0, "CP2114 I2S Audio Bridge" },
    { 0x10c4eac0, "CP2614 MFi Accessory Digital Audio Bridge" },
    { 0x10c4eac1, "CP2615 I2S Audio Bridge" },
    { 0x10c4eac9, "EFM8UB1 Bootloader" },
    { 0x10c4eaca, "EFM8UB2 Bootloader" },
    { 0x10c4eacb, "EFM8UB3 Bootloader" },
    { 0x10c5819a, "FM Radio" },
    { 0x10cc1101, "MP3 Player" },
    { 0x10ce0007, "Shinko/Sinfonia CHC-S1245" },
    { 0x10ce000e, "Shinko/Sinfonia CHC-S2145" },
    { 0x10ce0019, "Shinko/Sinfonia CHC-S6145" },
    { 0x10ce001d, "Shinko/Sinfonia CHC-S6245" },
    { 0x10ce001e, "Ciaat Brava 21" },
    { 0x10ce0039, "Sinfonia CHC-S2245" },
    { 0x10ce10ce, "Sinfonia CHC-S2245" },
    { 0x10ceea6a, "MobiData EDGE USB Modem" },
    { 0x10cf2011, "R-Engine MPEG2 encoder/decoder" },
    { 0x10cf5500, "8055 Experiment Interface Board (address=0)" },
    { 0x10cf5501, "8055 Experiment Interface Board (address=1)" },
    { 0x10cf5502, "8055 Experiment Interface Board (address=2)" },
    { 0x10cf5503, "8055 Experiment Interface Board (address=3)" },
    { 0x10d10101, "USB-Module for Spider8, CP32" },
    { 0x10d10202, "CP22 - Communication Processor" },
    { 0x10d10301, "CP42 - Communication Processor" },
    { 0x10d25243, "RayComposer" },
    { 0x10d50004, "PS/2 Converter" },
    { 0x10d55552, "KVM Human Interface Composite Device (Keyboard/Mouse ports)" },
    { 0x10d555a2, "2Port KVMSwitcher" },
    { 0x10d55a08, "Dual Bay Docking Station" },
    { 0x10d60c02, "BioniQ 1001 Tablet" },
    { 0x10d61000, "MP3 Player" },
    { 0x10d61100, "MPMan MP-Ki 128 MP3 Player/Recorder" },
    { 0x10d61101, "D-Wave 2GB MP4 Player / AK1025 MP3/MP4 Player" },
    { 0x10d62200, "Dunlop MP3 player 1GB / EGOMAN MD223AFD" },
    { 0x10d62300, "Memorex or iRiver MMP 8585/8586 or iRiver E200" },
    { 0x10d68888, "ADFU Device" },
    { 0x10d6ff51, "ADFU Device" },
    { 0x10d6ff61, "MP4 Player" },
    { 0x10d6ff66, "Craig 2GB MP3/Video Player" },
    { 0x10df0500, "iAPP CR-e500 Card reader" },
    { 0x10f02002, "iNexio Touchscreen controller" },
    { 0x10f11a08, "Internal Webcam" },
    { 0x10f11a1e, "Laptop Integrated Webcam 1.3M" },
    { 0x10f11a2a, "Laptop Integrated Webcam" },
    { 0x10f11a2e, "HP Truevision HD Integrated Webcam" },
    { 0x10f50200, "Audio Advantage Roadie" },
    { 0x10f50231, "Ear Force P11 Headset" },
    { 0x10f510f5, "EarForce PX21 Gaming Headset" },
    { 0x10f83201, "CeboLC" },
    { 0x10f83202, "CeboStick" },
    { 0x10f83203, "CeboMSA64" },
    { 0x10f83204, "CeboDFN" },
    { 0x10f83205, "PSAA2304W_CASC" },
    { 0x10f8c401, "USBV4F unconfigured" },
    { 0x10f8c402, "EFM01 unconfigured" },
    { 0x10f8c403, "MISS2 unconfigured" },
    { 0x10f8c404, "CID unconfigured" },
    { 0x10f8c405, "USBS6 unconfigured" },
    { 0x10f8c406, "OP_MISS2 unconfigured" },
    { 0x10f8c407, "NanoUsb uncofigured" },
    { 0x10f8c481, "USBV4F" },
    { 0x10f8c482, "EFM01" },
    { 0x10f8c483, "MISS2" },
    { 0x10f8c484, "CID" },
    { 0x10f8c485, "USBS6" },
    { 0x10f8c486, "OP_MISS2" },
    { 0x10f8c487, "NanoUsb" },
    { 0x10f8c501, "EFM02 unconfigured" },
    { 0x10f8c502, "EFM02/B unconfigured" },
    { 0x10f8c503, "EFM03 unconfigured" },
    { 0x10f8c581, "EFM02" },
    { 0x10f8c582, "EFM02/B" },
    { 0x10f8c583, "EFM03" },
    { 0x10fd7e50, "FlyCam Usb 100" },
    { 0x10fd804d, "Typhoon Webshot II Webcam [zc0301]" },
    { 0x10fd8050, "FlyCAM-USB 300 XP2" },
    { 0x10fdde00, "WinFast WalkieTV WDM Capture Driver." },
    { 0x10fe000c, "TT-3750 BGAN-XL Radio Module" },
    { 0x11000001, "VTPlayer VTP-1 Braille Mouse" },
    { 0x11010001, "FSK Electronics Super GSM Reader" },
    { 0x110a1110, "UPort 1110" },
    { 0x110a1150, "UPort 1150 1-Port RS-232/422/485" },
    { 0x110a1250, "UPort 1250 2-Port RS-232/422/485" },
    { 0x110a1251, "UPort 1250I 2-Port RS-232/422/485 with Isolation" },
    { 0x110a1410, "UPort 1410 4-Port RS-232" },
    { 0x110a1450, "UPort 1450 4-Port RS-232/422/485" },
    { 0x110a1451, "UPort 1450I 4-Port RS-232/422/485 with Isolation" },
    { 0x110a1613, "UPort 1610-16 16-Port RS-232" },
    { 0x110a1618, "UPort 1610-8 8-Port RS-232" },
    { 0x110a1653, "UPort 1650-16 16-Port RS-232/422/485" },
    { 0x110a1658, "UPort 1650-8 8-Port RS-232/422/485" },
    { 0x11105c01, "Huawei MT-882 Remote NDIS Network Device" },
    { 0x11106489, "ADSL ETH/USB RTR" },
    { 0x11109000, "ADSL LAN Adapter" },
    { 0x11109001, "ADSL Loader" },
    { 0x1110900f, "AT-AR215 DSL Modem" },
    { 0x11109010, "AT-AR215 DSL Modem" },
    { 0x11109021, "ADSL WAN Adapter" },
    { 0x11109022, "ADSL Loader" },
    { 0x11109023, "ADSL WAN Adapter" },
    { 0x11109024, "ADSL Loader" },
    { 0x11109031, "ADSL LAN Adapter" },
    { 0x11109032, "ADSL Loader" },
    { 0x11118888, "Evolution Device" },
    { 0x1113a0a2, "Active Sync device" },
    { 0x112a0001, "RedRat3 IR Transceiver" },
    { 0x112a0005, "RedRat3II IR Transceiver" },
    { 0x11300001, "BlyncLight" },
    { 0x11300002, "iBuddy" },
    { 0x11300004, "iBuddy Twins" },
    { 0x11300202, "Rocket Launcher" },
    { 0x11306604, "MCE IR-Receiver" },
    { 0x11306606, "U+P Mouse" },
    { 0x1130660c, "Foot Pedal/Thermometer" },
    { 0x11306626, "Key" },
    { 0x11306806, "Keychain photo frame" },
    { 0x1130c301, "Digital Photo viewer [Wallet Pix]" },
    { 0x1130f211, "TP6911 Audio Headset" },
    { 0x11311001, "KY-BT100 Bluetooth Adapter" },
    { 0x11311002, "Bluetooth Device" },
    { 0x11311003, "Bluetooth Device" },
    { 0x11311004, "Bluetooth Device" },
    { 0x11324331, "PDR-M4/M5/M70 Digital Camera" },
    { 0x11324332, "PDR-M60 Digital Camera" },
    { 0x11324333, "PDR-M2300/PDR-M700" },
    { 0x11324334, "PDR-M65" },
    { 0x11324335, "PDR-M61" },
    { 0x11324337, "PDR-M11" },
    { 0x11324338, "PDR-M25" },
    { 0x11363131, "CTS LS515" },
    { 0x113f1020, "Watson Two-Finger Roll Scanner" },
    { 0x113f1100, "Columbo Single-Finger Scanner" },
    { 0x11420709, "Cyberview High Speed Scanner" },
    { 0x11450001, "AirH PHONE AH-J3001V/J3002V" },
    { 0x114b0110, "Turbolink UB801R WLAN Adapter" },
    { 0x114b0150, "Turbolink UB801RE Wireless 802.11g 54Mbps Network Adapter [RTL8187]" },
    { 0x114f1234, "Fastrack Xtend FXT001 Modem" },
    { 0x11630100, "Earthmate GPS (orig)" },
    { 0x11630200, "Earthmate GPS (LT-20, LT-40)" },
    { 0x11632020, "Earthmate GPS (PN-40)" },
    { 0x11640300, "ELSAVISION 460D" },
    { 0x11640601, "Analog TV Tuner" },
    { 0x11640900, "TigerBird BMP837 USB2.0 WDM Encoder" },
    { 0x11640bc7, "Digital TV Tuner" },
    { 0x1164521b, "MC521A mini Card ATSC Tuner" },
    { 0x11646601, "Digital TV Tuner Card [RTL2832U]" },
    { 0x116f0005, "Flash Card Reader" },
    { 0x116fc108, "Flash Card Reader" },
    { 0x116fc109, "Flash Card Reader" },
    { 0x11830001, "DigitalDream l'espion XS" },
    { 0x118319c7, "ISDN TA" },
    { 0x11834008, "56k FaxModem" },
    { 0x1183504a, "PJB-100 Personal Jukebox" },
    { 0x11890893, "EP-1427X-2 Ethernet Adapter [Acer]" },
    { 0x11960010, "Trifid Camera without code" },
    { 0x11960011, "Trifid Camera" },
    { 0x11990019, "AC595U" },
    { 0x11990021, "AC597E" },
    { 0x11990024, "MC5727 CDMA modem" },
    { 0x11990110, "Composite Device" },
    { 0x11990112, "CDMA 1xEVDO PC Card, AirCard 580" },
    { 0x11990120, "AC595U" },
    { 0x11990218, "MC5720 Wireless Modem" },
    { 0x11996467, "MP Series Network Adapter" },
    { 0x11996468, "MP Series Network Adapter" },
    { 0x11996469, "MP Series Network Adapter" },
    { 0x11996802, "MC8755 Device" },
    { 0x11996803, "MC8765 Device" },
    { 0x11996804, "MC8755 Device" },
    { 0x11996805, "MC8765 Device" },
    { 0x11996812, "MC8775 Device" },
    { 0x11996820, "AC875 Device" },
    { 0x11996832, "MC8780 Device" },
    { 0x11996833, "MC8781 Device" },
    { 0x1199683a, "MC8785 Device" },
    { 0x1199683c, "Mobile Broadband 3G/UMTS (MC8790 Device)" },
    { 0x11996850, "AirCard 880 Device" },
    { 0x11996851, "AirCard 881 Device" },
    { 0x11996852, "AirCard 880E Device" },
    { 0x11996853, "AirCard 881E Device" },
    { 0x11996854, "AirCard 885 Device" },
    { 0x11996856, "ATT \"USB Connect 881\"" },
    { 0x11996870, "MC8780 Device" },
    { 0x11996871, "MC8781 Device" },
    { 0x11996893, "MC8777 Device" },
    { 0x119968a3, "MC8700 Modem" },
    { 0x119968aa, "4G LTE adapter" },
    { 0x11999000, "Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x11999001, "Gobi 2000 Wireless Modem" },
    { 0x11999002, "Gobi 2000 Wireless Modem" },
    { 0x11999003, "Gobi 2000 Wireless Modem" },
    { 0x11999004, "Gobi 2000 Wireless Modem" },
    { 0x11999005, "Gobi 2000 Wireless Modem" },
    { 0x11999006, "Gobi 2000 Wireless Modem" },
    { 0x11999007, "Gobi 2000 Wireless Modem" },
    { 0x11999008, "Gobi 2000 Wireless Modem" },
    { 0x11999009, "Gobi 2000 Wireless Modem" },
    { 0x1199900a, "Gobi 2000 Wireless Modem" },
    { 0x11999011, "MC8305 Modem" },
    { 0x11999013, "Sierra Wireless Gobi 3000 Modem device (MC8355)" },
    { 0x11999041, "EM7305 Modem" },
    { 0x11999055, "Gobi 9x15 Multimode 3G/4G LTE Modem (NAT mode)" },
    { 0x11999057, "Gobi 9x15 Multimode 3G/4G LTE Modem (IP passthrough mode)" },
    { 0x11999071, "AirPrime MC7455 3G/4G LTE Modem" },
    { 0x11999079, "EM7455" },
    { 0x119b0400, "Infrared Keyboard V2.01" },
    { 0x11a0eb11, "CC2400EB 2.0 ZigBee Sniffer" },
    { 0x11a38031, "MP3 Player" },
    { 0x11a38032, "MP3 Player" },
    { 0x11aa1518, "iREZ K2" },
    { 0x11ac6565, "FuelBand" },
    { 0x11b06208, "PRO-28U" },
    { 0x11b06298, "Kingston SNA-DC/U" },
    { 0x11bef0a0, "Martin Maxxyz DMX" },
    { 0x11c05506, "Gamepad" },
    { 0x11c50521, "IMT-0521 Smartcard Reader" },
    { 0x11c955f0, "GC-100XF" },
    { 0x11ca0201, "MX870/MX880" },
    { 0x11ca0207, "PIN Pad VX 810" },
    { 0x11ca0220, "PIN Pad VX 805" },
    { 0x11db1000, "PVR" },
    { 0x11db1100, "PVR" },
    { 0x11f50001, "SX1" },
    { 0x11f50003, "Mobile phone USB cable" },
    { 0x11f50004, "X75" },
    { 0x11f50005, "SXG75/EF81" },
    { 0x11f50008, "UMTS/HSDPA Data Card" },
    { 0x11f50101, "RCU Connect" },
    { 0x11f62001, "Willcom WSIM" },
    { 0x11f702df, "Serial cable (v2) for TD-10 Mobile Phone" },
    { 0x12030140, "TTP-245C" },
    { 0x12090001, "pid.codes Test PID" },
    { 0x12090002, "pid.codes Test PID" },
    { 0x12090003, "pid.codes Test PID" },
    { 0x12090004, "pid.codes Test PID" },
    { 0x12090005, "pid.codes Test PID" },
    { 0x12090006, "pid.codes Test PID" },
    { 0x12090007, "pid.codes Test PID" },
    { 0x12090008, "pid.codes Test PID" },
    { 0x12090009, "pid.codes Test PID" },
    { 0x1209000a, "pid.codes Test PID" },
    { 0x1209000b, "pid.codes Test PID" },
    { 0x1209000c, "pid.codes Test PID" },
    { 0x1209000d, "pid.codes Test PID" },
    { 0x1209000e, "pid.codes Test PID" },
    { 0x1209000f, "pid.codes Test PID" },
    { 0x12090010, "pid.codes Test PID" },
    { 0x120901c0, "Input Club Kiibohd Device" },
    { 0x120901cb, "Input Club Kiibohd Device Bootloader" },
    { 0x12090256, "Schwalm & Tate LLC pISO Raspberry Pi Hat" },
    { 0x1209053a, "Hackerspace San Salvador HSSV SAMR21-Mote" },
    { 0x12090cbd, "Andrzej Szombierski kuku.eu.org keyboard" },
    { 0x12090d32, "ODrive Robotics ODrive v3" },
    { 0x12091001, "InterBiometrics Hub" },
    { 0x12091002, "InterBiometrics Relais" },
    { 0x12091003, "InterBiometrics IBSecureCam-P" },
    { 0x12091004, "InterBiometrics IBSecureCam-O" },
    { 0x12091005, "InterBiometrics IBSecureCam-N" },
    { 0x12091006, "InterBiometrics Mini IO-Board" },
    { 0x12091007, "e-radionica.com Croduino SAMD" },
    { 0x12091986, "dgrubb Jaguar Tap" },
    { 0x12091ab5, "Arachnid Labs Tsunami" },
    { 0x12091ab6, "Arachnid Labs Tsunami Bootloader" },
    { 0x12092000, "Zygmunt Krynicki Lantern Brightness Sensor" },
    { 0x12092001, "OSHEC Pi-pilot opensource and openhardware autopilot system" },
    { 0x12092002, "Peter Lawrence PIC16F1-USB-DFU-Bootloader" },
    { 0x12092003, "Peter Lawrence SAMDx1-USB-DFU-Bootloader" },
    { 0x12092004, "GCBASIC Serial CDC Stack" },
    { 0x12092005, "GCBASIC OakTree Stack" },
    { 0x12092006, "GCBASIC Simulation Stack" },
    { 0x12092016, "Cupkee" },
    { 0x12092017, "Benjamin Shockley Mini SAM" },
    { 0x12092020, "Captain Credible Gate Crystal" },
    { 0x12092048, "Housedillon.com MRF49XA Transceiver" },
    { 0x12092100, "TinyFPGA B1 and B2 Boards" },
    { 0x12092101, "TinyFPGA A-Series Programmer" },
    { 0x12092200, "Dygma Shortcut Bootloader" },
    { 0x12092201, "Dygma Shortcut Keyboard" },
    { 0x12092222, "LabConnect Signalgenerator" },
    { 0x12092300, "Keyboardio Model 01 Bootloader" },
    { 0x12092301, "Keyboardio Model 01" },
    { 0x12092323, "bytewerk.org candleLight" },
    { 0x12092327, "K.T.E.C. Bootloader Device" },
    { 0x12092328, "K.T.E.C. Keyboard Device" },
    { 0x12092333, "Kai Ryu Kimera" },
    { 0x12092334, "Kai Ryu Staryu" },
    { 0x12092335, "Portwell Sense8" },
    { 0x12092336, "Portwell Sense8" },
    { 0x12092337, "/Dev /Net" },
    { 0x12092342, "Andreas Bogk Big Red Button" },
    { 0x12092345, "VV-Soft Simple Generic HID IO" },
    { 0x12092357, "KarolKucza TinyPassword" },
    { 0x12092400, "phooky Snap-Pad" },
    { 0x12092488, "Peter Lawrence CMSIS-DAP Dapper Miser" },
    { 0x12092552, "ProjectIota Electrolink" },
    { 0x12092600, "Majenko Technologies chipKIT Lenny" },
    { 0x12092635, "Sevinz GameBot" },
    { 0x12092800, "Entropic Engineering Triangulation" },
    { 0x12092801, "Entropic Engineering Object Manipulation" },
    { 0x12092a00, "mooware Wii adapter" },
    { 0x12092a01, "mooware SNES adapter" },
    { 0x12093000, "lloyd3000" },
    { 0x12093100, "OpenSimHardware Pedals & Buttons Controller" },
    { 0x1209317e, "Codecrete Wirekite" },
    { 0x12093210, "OSH Lab, LLC Magic Keys" },
    { 0x12093333, "LabConnect Digitalnetzteil" },
    { 0x1209345b, "kinX Hub" },
    { 0x1209345c, "kinX Keyboard Controller" },
    { 0x12093690, "Kigakudoh TouchMIDI32" },
    { 0x12094096, "CynaraKrewe Cynara" },
    { 0x1209414c, "Adi Linden" },
    { 0x1209414d, "Adi Linden" },
    { 0x12094242, "Komakallio Astrophotography Community KomaHub Remote Power Switch" },
    { 0x12094256, "CuVoodoo BusVoodoo multi-protocol debugging adapter" },
    { 0x12094321, "mooltipass Offline Password Keeper Bootloader" },
    { 0x12094322, "mooltipass Arduino Sketch" },
    { 0x12094356, "CuVoodoo firmware" },
    { 0x12094443, "j1rie IRMP_STM32 Bootloader" },
    { 0x12094444, "j1rie IRMP_STM32" },
    { 0x12094545, "SlothCo Enterprises Teletype Adapter" },
    { 0x12094646, "SmartPID SPC1000" },
    { 0x12094748, "Kate Gray GHETT-iO Bootloader" },
    { 0x12094750, "Chris Pavlina (c4757p) C4-x computer (development interface)" },
    { 0x12094757, "Chris Pavlina (c4757p) WCP52 Gain/Phase Analyzer" },
    { 0x12094801, "Wojciech Krutnik NVMemProg" },
    { 0x12094c60, "MightyPork GEX module" },
    { 0x12094c61, "MightyPork GEX wireless dongle" },
    { 0x12094d53, "mindsensors.com NXTCam5" },
    { 0x12095038, "frotz.net mdebug rswd protocol" },
    { 0x12095039, "frotz.net lpcboot protocol" },
    { 0x12095050, "trebb ISO50" },
    { 0x12095070, "SoloHacker security key [SoloKey]" },
    { 0x120950b0, "boot for security key [SoloKey]" },
    { 0x12095222, "telavivmakers attami" },
    { 0x120953c0, "SatoshiLabs TREZOR Bootloader" },
    { 0x120953c1, "SatoshiLabs TREZOR" },
    { 0x12095432, "Open Programmer" },
    { 0x12095457, "Openlab.Taipei Taiwanduino" },
    { 0x1209571c, "StreetoArcade PancadariaStick" },
    { 0x12095a22, "ikari_01 sd2snes" },
    { 0x12096000, "Pulsar Heavy Industries Cenx4" },
    { 0x1209600d, "Makdaam N93 Interface" },
    { 0x12096464, "Electric Exploits Shinewave" },
    { 0x12096502, "jj1bdx avrhwrng v2rev1" },
    { 0x12096570, "Iowa Scaled Engineering, LLC CKT-AVRPROGRAMMER" },
    { 0x12096666, "Talpa Chen VSFLogic" },
    { 0x12096667, "SensePost Universal Serial aBUSe - Generic HID" },
    { 0x12096742, "NPK Cubitel Atomic Force Microscope" },
    { 0x12096809, "Tach Radio Doppelganger" },
    { 0x12096948, "MySensors Sensebender Gateway BootLoader" },
    { 0x12096949, "MySensors Sensebender Gateway" },
    { 0x12096bcf, "blaste Gameboy Cart Flasher" },
    { 0x12097000, "Secalot Dongle" },
    { 0x12097001, "Secalot Bootloader" },
    { 0x120970b1, "Sutajio Ko-Usagi (Kosagi) Tomu" },
    { 0x12097331, "Dangerous Prototypes Bus Pirate Next Gen CDC" },
    { 0x12097332, "Dangerous Prototypes Bus Pirate Next Gen Logic Analyzer" },
    { 0x12097401, "Beststream-jp Tool_CDC" },
    { 0x12097530, "PotentialLabs Refflion - IoT Development Board - Bootloader" },
    { 0x12097531, "PotentialLabs Refflion - IoT Development Board - Sketch" },
    { 0x12097551, "The Tessel Project Tessel 2" },
    { 0x12097777, "circuitvalley IO Board V3" },
    { 0x12097778, "circuitvalley IO Board V3 Bootloader" },
    { 0x12097950, "PIC18F87J94 Bootloader [GenII]" },
    { 0x12097951, "PIC18F87J94 Application [GenII]" },
    { 0x12097952, "PIC18F87J94 Bootloader [GenIII/IV]" },
    { 0x12097953, "PIC18F87J94 Application [GenIII/IV]" },
    { 0x12097954, "PIC18F87J94 Application [GenIII/IV]" },
    { 0x12097bd0, "pokey9000 Tiny Bit Dingus" },
    { 0x12098000, "Autonomii NODii 2" },
    { 0x12098086, "MisfitTech Nano Zero Bootloader" },
    { 0x12098087, "MisfitTech Nano Zero" },
    { 0x12098123, "Danyboard M0 bootloader" },
    { 0x1209812a, "Danyboard M0" },
    { 0x1209813a, "MickMad HACK Bootloader" },
    { 0x1209813b, "MickMad HACK Sketch" },
    { 0x12098242, "Tom Wimmenhove Electronics NBS-DAC 192/24 UAC1" },
    { 0x12098243, "Tom Wimmenhove Electronics NBS-DAC 192/24 UAC2" },
    { 0x12098472, "Shantea Controls OpenDeck" },
    { 0x12098661, "ProgHQ TL866 programmer" },
    { 0x12098844, "munia.io MUNIA" },
    { 0x12098888, "Blinkinlabs POV Pendant" },
    { 0x12098889, "Blinkinlabs POV Pendant (bootloader)" },
    { 0x12098b00, "ReSwitched Libtransistor Serial Console" },
    { 0x12099021, "Connected Community Hackerspace ESPlant" },
    { 0x12099317, "Sutajio Ko-Usagi (Kosagi) Palawan-Tx" },
    { 0x12099999, "Sandeepan Sengupta CodeBridge Infineo" },
    { 0x12099db5, "PD Buddy Sink" },
    { 0x1209a033, "area0x33 Memtype" },
    { 0x1209a100, "KB LES Narsil analog breakout" },
    { 0x1209a10c, "KB LES Aminoacid Synthesizer" },
    { 0x1209a1e5, "Atreus Keyboards Atreus Keyboard" },
    { 0x1209a3a4, "MK::Box MK::Kbd" },
    { 0x1209a3a5, "MK::Box MK::Kbd Bootloader" },
    { 0x1209a55a, "Forever Young Software ATTINY2313" },
    { 0x1209a602, "Robotips RTBoard" },
    { 0x1209a7ea, "area3001 Knixx SW04" },
    { 0x1209a800, "sowbug.com WebLight" },
    { 0x1209a8b0, "Intelectron BootWare" },
    { 0x1209a8b1, "Intelectron FrameWare" },
    { 0x1209aa00, "Serg Oskin LinuxCNC HID Extender" },
    { 0x1209aa0b, "Open Bionics" },
    { 0x1209ab3d, "3DArtists Alligator board" },
    { 0x1209abba, "CoinWISE SafeWISE" },
    { 0x1209abc0, "Omzlo controller" },
    { 0x1209abcd, "Sandeepan Sengupta CodeBridge" },
    { 0x1209abd1, "OpenMV Cam" },
    { 0x1209acdc, "Gediminas Zukaitis midi-grid" },
    { 0x1209ace5, "SimAces Panel Ace" },
    { 0x1209aced, "Open Lighting Project Ja Rule Device" },
    { 0x1209acee, "Open Lighting Project Ja Rule Bootloader" },
    { 0x1209adb0, "tibounise ADB converter" },
    { 0x1209adda, "MicroPython Boards" },
    { 0x1209b007, "Konsgn Global_Boot" },
    { 0x1209b00b, "CrapLab Random Device" },
    { 0x1209b010, "IObitZ CodeBridge" },
    { 0x1209b01d, "WyoLum VeloKey" },
    { 0x1209b058, "Model B, LLC Holoseat" },
    { 0x1209b0b0, "Monero Hardware Monero Bootloader" },
    { 0x1209b100, "ptrandem iBizi" },
    { 0x1209b101, "IObitZ Infineo" },
    { 0x1209b195, "flehrad Big Switch PCB" },
    { 0x1209bab1, "ElectronicCats Meow Meow" },
    { 0x1209babe, "brunofreitas.com STM32 HID Bootloader" },
    { 0x1209bad1, "Gregory POTEAU CommLinkUSB" },
    { 0x1209bad2, "Gregory POTEAU XLinkUSB" },
    { 0x1209bade, "Semarme SemarmeHID" },
    { 0x1209bb00, "keyplus split keyboard firmware" },
    { 0x1209bb01, "keyplus xusb bootloader" },
    { 0x1209bb02, "keyplus nRF24 wireless keyboard dongle" },
    { 0x1209bb03, "keyplus nrf24lu1p-512 bootloader" },
    { 0x1209bb05, "keyplus kp_boot_32u4 bootloader" },
    { 0x1209beba, "serasidis.gr STM32 HID Bootloader" },
    { 0x1209beef, "Modal MC-USB" },
    { 0x1209c001, "Cynteract Alpha" },
    { 0x1209c0c0, "Geppetto_Electronics Orthrus" },
    { 0x1209c0c1, "Michael Bemmerl cookie-mouse" },
    { 0x1209c0ca, "Jean THOMAS DirtyJTAG" },
    { 0x1209c0d3, "Samy Kamkar USBdriveby" },
    { 0x1209c0da, "Monero Hardware Monero Firmware" },
    { 0x1209c0de, "KMRH Labs SBL Brain" },
    { 0x1209c0f5, "unethi PERswitch" },
    { 0x1209c1aa, "Proyecto CIAA Computadora Industrial Abierta Argentina" },
    { 0x1209c1b1, "Chibitronics Love-to-Code" },
    { 0x1209c311, "bg nerilex GB-USB-Link" },
    { 0x1209ca1c, "KnightOS Generic Hub" },
    { 0x1209ca1d, "KnightOS MTP Device" },
    { 0x1209caea, "Open Music Kontrollers Chimaera" },
    { 0x1209cafe, "ii iigadget" },
    { 0x1209cc14, "trebb NaN-15" },
    { 0x1209cc86, "Manfred's Technologies Anastasia Bootloader" },
    { 0x1209ceb0, "KG4LNE GE-FlashUSB" },
    { 0x1209cf20, "Smart Citizen SCK 2.0" },
    { 0x1209d00d, "Monero Hardware Monero Developer" },
    { 0x1209d017, "empiriKit empiriKit Controller" },
    { 0x1209d11d, "Koi Science DI-Lambda AVR" },
    { 0x1209d3d8, "Duet3d Duet 0.8.5" },
    { 0x1209d706, "SkyBean SkyDrop" },
    { 0x1209da42, "Devan Lai dap42 debug access probe" },
    { 0x1209daa0, "darknao btClubSportWheel" },
    { 0x1209dada, "Rebel Technology OWL" },
    { 0x1209db42, "Devan Lai dapboot DFU bootloader" },
    { 0x1209dc21, "FPGA-Computer Dual Charger" },
    { 0x1209dddd, "Stephan Electronics OpenCVMeter" },
    { 0x1209dead, "chaosfield.at AVR-Ruler" },
    { 0x1209deaf, "CrapLab 4chord MIDI" },
    { 0x1209ded1, "ManCave Made Quark One" },
    { 0x1209deed, "Kroneum Time Tracker" },
    { 0x1209df00, "D.F.Mac. @TripArts Music mi:muz:tuch" },
    { 0x1209df01, "D.F.Mac. @TripArts Music mi:muz:can" },
    { 0x1209df02, "D.F.Mac. @TripArts Music mi:muz:can-lite" },
    { 0x1209e116, "Elijah Motornyy open-oscilloscope-stm32f3" },
    { 0x1209e1ec, "FreeSRP" },
    { 0x1209e4ee, "trebb keytee" },
    { 0x1209e500, "GitleMikkelsen Helios Laser DAC" },
    { 0x1209eaea, "Pinscape Controller" },
    { 0x1209eb01, "RobotMaker.club EB1" },
    { 0x1209eba7, "VictorGrigoryev USBscope" },
    { 0x1209ee00, "Explore Embedded SODA(SWD OpenSource Debug Adapter)" },
    { 0x1209ee02, "Explore Embedded Explore M3 VCOM" },
    { 0x1209ee03, "Explore Embedded Explore M3 DFU" },
    { 0x1209ee2c, "jaka USB2RS485" },
    { 0x1209effa, "EffigyLabs atmega32u4-USB-LUFA-Bootloader" },
    { 0x1209effe, "EffigyLabs Control Pedal" },
    { 0x1209f000, "Uniti ARC" },
    { 0x1209f00d, "RomanStepanov Shifter/Pedals Adapter" },
    { 0x1209f12e, "Michael Bemmerl Feuermelder" },
    { 0x1209f16a, "uri_ba Cougar TQS adapter" },
    { 0x1209f16c, "uri_ba adapter for Vipercore's FCC3 Force Sensing Module" },
    { 0x1209f380, "Windsor Schmidt MD-380 Open Radio Firmware" },
    { 0x1209f3fc, "dRonin Flight controller-Lumenier Lux" },
    { 0x1209f49a, "TimVideos.us & HDMI2USB.tv Projects FPGA Programmer & UART Bridge (PIC based Firmware)" },
    { 0x1209fa11, "moonglow OpenXHC" },
    { 0x1209fa57, "3DRacers Pilot Board" },
    { 0x1209fa58, "3DRacers Pilot Board (Bootloader)" },
    { 0x1209fab1, "PAP Mechatronic Technology LamDiNao" },
    { 0x1209face, "Protean Synth Craft" },
    { 0x1209fade, "Open Collector dude" },
    { 0x1209feed, "ProgramGyar AVR-IR Sender" },
    { 0x1209ffff, "Life2Device Smart House" },
    { 0x120f524e, "RoadMate 1475T" },
    { 0x120f5260, "Triton Handheld GPS Receiver (300/400/500/1500/2000)" },
    { 0x1210000d, "RP250 Guitar Multi-Effects Processor" },
    { 0x12100016, "RP500 Guitar Multi-Effects Processor" },
    { 0x1210001b, "RP155 Guitar Multi-Effects Processor" },
    { 0x1210001c, "RP255 Guitar Multi-Effects Processor" },
    { 0x121e3403, "Muzio JM250 Audio Player" },
    { 0x121f0001, "VisionX without Firmware" },
    { 0x121f0002, "VisionX with Firmware" },
    { 0x121f0010, "I-Deal" },
    { 0x121f0020, "wI-Deal" },
    { 0x121f0021, "VisionX Page Scanner Extension" },
    { 0x121f0030, "VisionNext" },
    { 0x121f0040, "mI:Deal Check Scanner" },
    { 0x121f0041, "EverNext Check Scanner" },
    { 0x1220000a, "Hall of Fame Reverb" },
    { 0x1220002a, "Polytune" },
    { 0x12200032, "Ditto X2 Looper" },
    { 0x12200039, "Alter Ego X4 Vintage Echo" },
    { 0x12213234, "Disk (Thumb drive)" },
    { 0x1222faca, "programmable keyboard" },
    { 0x12280012, "Q18 Data Logger" },
    { 0x12280015, "TPaq21/MPaq21 Datalogger" },
    { 0x1228584c, "XL2 Logger" },
    { 0x12335677, "FUSB200 mp3 player" },
    { 0x12340000, "Neural Impulse Actuator Prototype 1.0 [NIA]" },
    { 0x12344321, "Human Interface Device" },
    { 0x1234ed02, "Emotiv EPOC Developer Headset Wireless Dongle" },
    { 0x12350001, "ReMOTE Audio/XStation First Edition" },
    { 0x12350002, "Speedio" },
    { 0x12350003, "RemoteSL + ZeroSL" },
    { 0x12350004, "ReMOTE LE" },
    { 0x12350005, "XIOSynth [First Edition]" },
    { 0x12350006, "XStation" },
    { 0x12350007, "XIOSynth" },
    { 0x12350008, "ReMOTE SL Compact" },
    { 0x12350009, "nIO" },
    { 0x1235000a, "Nocturn" },
    { 0x1235000b, "ReMOTE SL MkII" },
    { 0x1235000c, "ZeRO MkII" },
    { 0x1235000e, "Launchpad" },
    { 0x12350010, "Saffire 6" },
    { 0x12350011, "Ultranova" },
    { 0x12350012, "Nocturn Keyboard" },
    { 0x12350013, "VRM Box" },
    { 0x12350014, "VRM Box Audio Class (2-out)" },
    { 0x12350015, "Dicer" },
    { 0x12350016, "Ultranova" },
    { 0x12350018, "Twitch" },
    { 0x12350019, "Impulse 25" },
    { 0x1235001a, "Impulse 49" },
    { 0x1235001b, "Impulse 61" },
    { 0x12350032, "Launchkey 61" },
    { 0x12350069, "Launchpad MK2" },
    { 0x12350102, "LaunchKey Mini MK3" },
    { 0x12354661, "ReMOTE25" },
    { 0x12358000, "Scarlett 18i6" },
    { 0x12358002, "Scarlett 8i6" },
    { 0x12358006, "Focusrite Scarlett 2i2" },
    { 0x12358008, "Saffire 6" },
    { 0x1235800a, "Scarlett 2i4" },
    { 0x1235800c, "Scarlett 18i20" },
    { 0x1235800e, "iTrack Solo" },
    { 0x12358010, "Forte" },
    { 0x12358012, "Scarlett 6i6" },
    { 0x12358014, "Scarlett 18i8" },
    { 0x12358016, "Focusrite Scarlett 2i2" },
    { 0x12358202, "Focusrite Scarlett 2i2 2nd Gen" },
    { 0x12358203, "Focusrite Scarlett 6i6" },
    { 0x12358204, "Scarlett 18i8 2nd Gen" },
    { 0x12358210, "Scarlett 2i2 Camera" },
    { 0x12358211, "Scarlett Solo (3rd Gen.)" },
    { 0x12358214, "Scarlett 18i8 3rd Gen" },
    { 0x12358215, "Scarlett 18i20 3rd Gen" },
    { 0x12410504, "Wireless Trackball Keyboard" },
    { 0x12411111, "Mouse" },
    { 0x12411122, "Typhoon Stream Optical Mouse USB+PS/2" },
    { 0x12411155, "Memorex Optical ScrollPro Mouse SE MX4600" },
    { 0x12411166, "MI-2150 Trust Mouse" },
    { 0x12411177, "Mouse [HT82M21A]" },
    { 0x12411503, "Keyboard" },
    { 0x12411603, "Keyboard" },
    { 0x1241f767, "Keyboard" },
    { 0x1243e000, "Unique NFC/RFID reader (keyboard emulation)" },
    { 0x124a168b, "PRISM3 WLAN Adapter" },
    { 0x124a4017, "PC-Chips 802.11b Adapter" },
    { 0x124a4023, "WM168g 802.11bg Wireless Adapter [Intersil ISL3886]" },
    { 0x124a4025, "IOGear GWU513 v2 802.11bg Wireless Adapter [Intersil ISL3887]" },
    { 0x124b4d01, "Airflo EX Joystick" },
    { 0x124c3200, "Stealth MXP 1GB" },
    { 0x125c0010, "Alta series CCD" },
    { 0x125d0580, "JM580" },
    { 0x125f312a, "Superior S102" },
    { 0x125f312b, "Superior S102 Pro" },
    { 0x125fa15a, "DashDrive Durable HD710 portable HDD various size" },
    { 0x125fa22a, "DashDrive Elite HE720 500GB" },
    { 0x125fa31a, "HV620 Portable HDD" },
    { 0x125fa91a, "Portable HDD CH91" },
    { 0x125fc08a, "C008 Flash Drive" },
    { 0x125fc81a, "Flash drive" },
    { 0x125fc93a, "4GB Pen Drive" },
    { 0x125fc96a, "C906 Flash Drive" },
    { 0x125fcb10, "Dash Drive UV100" },
    { 0x125fcb20, "DashDrive UV110" },
    { 0x1260ee22, "SMC2862W-G v3 EZ Connect 802.11g Adapter [Intersil ISL3887]" },
    { 0x12666302, "Fastweb DRG A226M ADSL Router" },
    { 0x12670103, "G-720 Keyboard" },
    { 0x12670201, "Mouse" },
    { 0x12670210, "LG Optical Mouse 3D-310" },
    { 0x1267a001, "JP260 PC Game Pad" },
    { 0x1267c002, "Wireless Optical Mouse" },
    { 0x126f0163, "Storage device (2gB thumb drive)" },
    { 0x126f1325, "Mobile Disk" },
    { 0x126f2168, "Mobile Disk III" },
    { 0x126fa006, "G240 802.11bg" },
    { 0x12750002, "WeatherFax 2000 Demodulator" },
    { 0x12750080, "SkyEye Weather Satellite Receiver" },
    { 0x12750090, "WeatherFax 2000 Demodulator" },
    { 0x12780105, "SXV-M5" },
    { 0x12780107, "SXV-M7" },
    { 0x12780109, "SXV-M9" },
    { 0x12780110, "SXVF-H16" },
    { 0x12780115, "SXVF-H5" },
    { 0x12780119, "SXV-H9" },
    { 0x12780135, "SXVF-H35" },
    { 0x12780136, "SXVF-H36" },
    { 0x12780200, "SXV interface for paraller MX cameras" },
    { 0x12780305, "SXV-M5C" },
    { 0x12780307, "SXV-M7C" },
    { 0x12780319, "SXV-H9C" },
    { 0x12780325, "SXV-M25C" },
    { 0x12780326, "SXVR-M26C" },
    { 0x12780507, "Lodestar autoguider" },
    { 0x12780517, "CoStar" },
    { 0x12830100, "USB-RS232 Adaptor" },
    { 0x12830110, "CMS20" },
    { 0x12830111, "CMS 10" },
    { 0x12830112, "CMS 05" },
    { 0x12830114, "ARCUS digma PC-Interface" },
    { 0x12830115, "SAM Axioquick recorder" },
    { 0x12830116, "SAM Axioquick recorder" },
    { 0x12830120, "emed-X" },
    { 0x12830121, "emed-AT" },
    { 0x12830130, "PDM" },
    { 0x12830150, "CMS10GI (Golf)" },
    { 0x128600bc, "Marvell JTAG Probe" },
    { 0x12861fab, "88W8338 [Libertas] 802.11g" },
    { 0x12862001, "88W8388 802.11a/b/g WLAN" },
    { 0x12862006, "88W8362 802.11n WLAN" },
    { 0x1286203c, "K30326 802.11bgn Wireless Module [Marvell 88W8786U]" },
    { 0x1286204c, "Bluetooth and Wireless LAN Composite" },
    { 0x12868001, "BLOB boot loader firmware" },
    { 0x12910010, "FDM 2xxx Flash-OFDM modem" },
    { 0x12910011, "LR7F06/LR7F14 Flash-OFDM modem" },
    { 0x12920258, "Creative Labs VoIP Blaster" },
    { 0x12924154, "Retro Link Atari cable" },
    { 0x12930002, "F5U002 Parallel Port [uss720]" },
    { 0x12932101, "104-key keyboard" },
    { 0x12941320, "Webmail Notifier" },
    { 0x1297020f, "DTU-215 Multi-Standard Modulator" },
    { 0x129b160b, "Siemens S30853-S1031-R351 802.11g Wireless Adapter [Atheros AR5523]" },
    { 0x129b160c, "Siemens S30853-S1038-R351 802.11g Wireless Adapter [Atheros AR5523]" },
    { 0x129b1666, "TG54USB 802.11bg" },
    { 0x129b1667, "802.11bg" },
    { 0x129b1828, "Gigaset USB Adapter 300" },
    { 0x12ab0004, "Dance Pad for Xbox 360" },
    { 0x12ab0301, "Afterglow Wired Controller for Xbox 360" },
    { 0x12ab0303, "Mortal Kombat Klassic FightStick for Xbox 360" },
    { 0x12ab8809, "Dance Dance Revolution Dance Pad" },
    { 0x12ba0032, "Wireless Stereo Headset" },
    { 0x12ba0042, "Wireless Stereo Headset" },
    { 0x12ba00ff, "Rocksmith Guitar Adapter" },
    { 0x12ba0100, "RedOctane Guitar for PlayStation(R)3" },
    { 0x12ba0120, "RedOctane Drum Kit for PlayStation(R)3" },
    { 0x12ba0200, "Harmonix Guitar for PlayStation(R)3" },
    { 0x12ba0210, "Harmonix Drum Kit for PlayStation(R)3" },
    { 0x12bdd012, "JPD Shockforce gamepad" },
    { 0x12bdd015, "Generic 4-button NES USB Controller" },
    { 0x12c40006, "Teleprompter Two-button Hand Control (v1)" },
    { 0x12c40008, "Teleprompter Foot Control (v1)" },
    { 0x12cf0170, "Tt eSPORTS BLACK Gaming mouse" },
    { 0x12cf600b, "Cougar 600M Gaming Mouse" },
    { 0x12d11001, "E161/E169/E620/E800 HSDPA Modem" },
    { 0x12d11003, "E220 HSDPA Modem / E230/E270/E870 HSDPA/HSUPA Modem" },
    { 0x12d11004, "E220 (bis)" },
    { 0x12d11009, "U120" },
    { 0x12d11010, "ETS2252+ CDMA Fixed Wireless Terminal" },
    { 0x12d11021, "U8520" },
    { 0x12d11035, "U8120" },
    { 0x12d11037, "Ideos" },
    { 0x12d11038, "Ideos (debug mode)" },
    { 0x12d11039, "Ideos (tethering mode)" },
    { 0x12d11051, "Huawei Honor U8860" },
    { 0x12d11052, "MT7-L09 / P7-L10 / Y330-U01" },
    { 0x12d11053, "P7-L10 (PTP)" },
    { 0x12d11054, "P7-L10 (PTP + debug)" },
    { 0x12d11079, "GEM-703LT [Honor/MediaPad X2]" },
    { 0x12d1107e, "P10 smartphone" },
    { 0x12d11404, "EM770W miniPCI WCDMA Modem" },
    { 0x12d11406, "E1750" },
    { 0x12d1140b, "EC1260 Wireless Data Modem HSD USB Card" },
    { 0x12d1140c, "E180v" },
    { 0x12d11412, "EC168c" },
    { 0x12d11436, "Broadband stick" },
    { 0x12d11446, "HSPA modem" },
    { 0x12d11465, "K3765 HSPA" },
    { 0x12d114ac, "E815" },
    { 0x12d114c3, "K5005 Vodafone LTE/UMTS/GSM Modem/Networkcard" },
    { 0x12d114c8, "K5005 Vodafone LTE/UMTS/GSM MOdem/Networkcard" },
    { 0x12d114c9, "K3770 3G Modem" },
    { 0x12d114cf, "K3772" },
    { 0x12d114d1, "K3770 3G Modem (Mass Storage Mode)" },
    { 0x12d114db, "E353/E3131" },
    { 0x12d114dc, "E3372 LTE/UMTS/GSM HiLink Modem/Networkcard" },
    { 0x12d114f1, "Gobi 3000 HSPA+ Modem" },
    { 0x12d114fe, "Modem (Mass Storage Mode)" },
    { 0x12d11501, "Pulse" },
    { 0x12d11505, "E398 LTE/UMTS/GSM Modem/Networkcard" },
    { 0x12d11506, "Modem/Networkcard" },
    { 0x12d1150a, "E398 LTE/UMTS/GSM Modem/Networkcard" },
    { 0x12d11520, "K3765 HSPA" },
    { 0x12d11521, "K4505 HSPA+" },
    { 0x12d1155a, "R205 Mobile WiFi (CD-ROM mode)" },
    { 0x12d11573, "ME909u-521 mPCIe LTE/GPS card" },
    { 0x12d11575, "K5150 LTE modem" },
    { 0x12d115bb, "ME936 LTE/HSDPA+ 4G modem" },
    { 0x12d115c1, "ME906s LTE M.2 Module" },
    { 0x12d115ca, "E3131 3G/UMTS/HSPA+ Modem (Mass Storage Mode)" },
    { 0x12d11805, "AT&T Go Phone U2800A phone" },
    { 0x12d11c05, "Broadband stick (modem on)" },
    { 0x12d11c0b, "E173s 3G broadband stick (modem off)" },
    { 0x12d11c20, "R205 Mobile WiFi (Charging)" },
    { 0x12d11d50, "ET302s TD-SCDMA/TD-HSDPA Mobile Broadband" },
    { 0x12d11f01, "E353/E3131 (Mass storage mode)" },
    { 0x12d11f16, "K5150 LTE modem (Mass Storage Mode)" },
    { 0x12d1360e, "Y330-U01 (MTP Mode)" },
    { 0x12d1360f, "Huawei Mediapad (mode 0)" },
    { 0x12d1361f, "Huawei Mediapad (mode 1)" },
    { 0x12d1380b, "WiMAX USB modem(s)" },
    { 0x12d30002, "DeskLine CBD Control Box" },
    { 0x12d60444, "CPC-USB/ARM7" },
    { 0x12d60888, "CPC-USB/M16C" },
    { 0x12d80001, "Alea I True Random Number Generator" },
    { 0x12e60013, "Blofeld" },
    { 0x12ef0100, "Tapwave Handheld [Tapwave Zodiac]" },
    { 0x12f2000a, "Braille embosser [SpotDot Emprint]" },
    { 0x12f71a00, "TD Classic 003B" },
    { 0x12f71e23, "TravelDrive 2007 Flash Drive" },
    { 0x12fd1001, "AWU2000b 802.11b Stick" },
    { 0x12ff0101, "Advanced RC Servo Controller" },
    { 0x13021016, "Haier Ibiza Rhapsody" },
    { 0x13021017, "Haier Ibiza Rhapsody" },
    { 0x13070163, "256MB/512MB/1GB Flash Drive" },
    { 0x13070165, "2GB/4GB/8GB Flash Drive" },
    { 0x13070190, "Ut190 8 GB Flash Drive with MicroSD reader" },
    { 0x13070310, "SD/MicroSD CardReader [hama]/IT1327E [Basic Line flash drive]" },
    { 0x13070330, "63-in-1 Multi-Card Reader/Writer" },
    { 0x13070361, "CR-75: 51-in-1 Card Reader/Writer [Sakar]" },
    { 0x13071169, "TS2GJF210 JetFlash 210 2GB" },
    { 0x13071171, "Fingerprint Reader" },
    { 0x13080003, "VFD Module" },
    { 0x1308c001, "eHome Infrared Transceiver" },
    { 0x13100001, "Class 1 Bluetooth Dongle" },
    { 0x13130010, "LC1 Linear Camera (Jungo)" },
    { 0x13130011, "SP1 Spectrometer (Jungo)" },
    { 0x13130012, "SP2 Spectrometer (Jungo)" },
    { 0x13130110, "LC1 Linear Camera (VISA)" },
    { 0x13130111, "SP1 Spectrometer (VISA)" },
    { 0x13130112, "SP2 Spectrometer (VISA)" },
    { 0x13138001, "TXP-Series Slot (TXP5001, TXP5004)" },
    { 0x13138011, "BP1 Slit Beam Profiler" },
    { 0x13138012, "BC106 Camera Beam Profiler" },
    { 0x13138013, "WFS10 Wavefront Sensor" },
    { 0x13138016, "DMP40 Deformable Mirror" },
    { 0x13138017, "BC206 Camera Beam Profiler" },
    { 0x13138019, "BP2 Multi Slit Beam Profiler" },
    { 0x13138020, "PM300 Optical Power Meter" },
    { 0x13138021, "PM300E Optical Power and Energy Meter" },
    { 0x13138022, "PM320E Optical Power and Energy Meter" },
    { 0x13138025, "WFS20 Wavefront Sensor" },
    { 0x13138030, "ER100 Extinction Ratio Meter" },
    { 0x13138039, "PAX1000 Rotating Waveplate Polarimeter" },
    { 0x13138047, "CLD1000" },
    { 0x13138048, "TED4000" },
    { 0x13138049, "LDC4000" },
    { 0x1313804a, "ITC4000" },
    { 0x13138058, "LC-100" },
    { 0x13138060, "DC3100" },
    { 0x13138061, "DC4100" },
    { 0x13138062, "DC2100" },
    { 0x13138065, "CS2010" },
    { 0x13138066, "DC4104" },
    { 0x13138070, "PM100D" },
    { 0x13138072, "PM100USB Power and Energy Meter Interface" },
    { 0x13138073, "PM106 Wireless Powermeter Photodiode Sensor" },
    { 0x13138074, "PM160T Wireless Powermeter Thermal Sensor" },
    { 0x13138075, "PM400 Handheld Optical Power/Energy Meter" },
    { 0x13138076, "PM101 Serial PD Power Meter" },
    { 0x13138078, "PM100D Compact Power and Energy Meter Console" },
    { 0x13138080, "CCS100 - Compact Spectrometer" },
    { 0x13138081, "CCS100 Compact Spectrometer" },
    { 0x13138083, "CCS125 Spectrometer" },
    { 0x13138085, "CCS150 UV Spectrometer" },
    { 0x13138087, "CCS175 NIR Spectrometer" },
    { 0x13138089, "CCS200 Wide Range Spectrometer" },
    { 0x13138090, "SPCM Single Photon Counter" },
    { 0x131380a0, "LC100 series smart line camera" },
    { 0x131380b0, "PM200 Handheld Power and Energy Meter" },
    { 0x131380c0, "DC2200" },
    { 0x131380c9, "MTD Series" },
    { 0x131380f0, "TSP01" },
    { 0x131380f1, "M2SET Dongle" },
    { 0x13138180, "OCT Probe Controller (OCTH-1300)" },
    { 0x13138181, "OCT Device" },
    { 0x131d0155, "TrackIR 3 Pro Head Tracker" },
    { 0x131d0156, "TrackIR 4 Pro Head Tracker" },
    { 0x131d0158, "TrackIR 5 Pro Head Tracker" },
    { 0x132500d6, "I2C/SPI InterfaceBoard" },
    { 0x13250c08, "Embedded Linux Sensor Bridge" },
    { 0x13254002, "I2C Dongle" },
    { 0x132a1502, "WiND 802.11abg / 802.11bg WLAN" },
    { 0x132b0000, "Dimage A2 Camera" },
    { 0x132b0001, "Konica-Minolta DiMAGE A2" },
    { 0x132b0003, "Dimage Xg Camera" },
    { 0x132b0006, "Dimage Z2 Camera" },
    { 0x132b0007, "Konica-Minolta DiMAGE Z2" },
    { 0x132b0008, "Dimage X21 Camera" },
    { 0x132b0009, "Konica-Minolta DiMAGE X21" },
    { 0x132b000a, "Dimage Scan Dual IV AF-3200 (2891)" },
    { 0x132b000b, "Dimage Z10 Camera" },
    { 0x132b000d, "Dimage X50 Camera [storage?]" },
    { 0x132b000f, "Dimage X50 Camera [p2p?]" },
    { 0x132b0010, "Dimage G600 Camera" },
    { 0x132b0012, "Dimage Scan Elite 5400 II (2892)" },
    { 0x132b0013, "Dimage X31 Camera" },
    { 0x132b0015, "Dimage G530 Camera" },
    { 0x132b0017, "Dimage Z3 Camera" },
    { 0x132b0018, "Konica-Minolta DiMAGE Z3" },
    { 0x132b0019, "Konica-Minolta DiMAGE A200" },
    { 0x132b0021, "Dimage Z5 Camera" },
    { 0x132b0022, "Konica-Minolta DiMAGE Z5" },
    { 0x132b002c, "Dynax 5D camera" },
    { 0x132b2001, "Magicolor 2400w" },
    { 0x132b2004, "Magicolor 5430DL" },
    { 0x132b2005, "Magicolor 2430 DL" },
    { 0x132b2029, "Magicolor 5440DL" },
    { 0x132b2030, "PagePro 1350E(N)" },
    { 0x132b2033, "PagePro 1400W" },
    { 0x132b2043, "Magicolor 2530DL" },
    { 0x132b2045, "Magicolor 2500W" },
    { 0x132b2049, "Magicolor 2490MF" },
    { 0x133e0815, "Virus TI Desktop" },
    { 0x13420200, "EasiDock 200 Hub" },
    { 0x13420201, "EasiDock 200 Keyboard and Mouse Port" },
    { 0x13420202, "EasiDock 200 Serial Port" },
    { 0x13420203, "EasiDock 200 Printer Port" },
    { 0x13420204, "Ethernet" },
    { 0x13420304, "EasiDock Ethernet" },
    { 0x13430002, "CW-01" },
    { 0x13430003, "CX / DNP DS40" },
    { 0x13430004, "CX-W / DNP DS80 / Mitsubishi CP3800" },
    { 0x13430005, "CY / DNP DSRX1" },
    { 0x13430006, "CW-02 / OP900ii" },
    { 0x13430007, "DNP DS80DX" },
    { 0x13430008, "DNP DS620 (old)" },
    { 0x1343000a, "CX-02" },
    { 0x1343000b, "CX-02W" },
    { 0x1345001c, "Xbox Controller Hub" },
    { 0x13456006, "Defender Wireless Controller" },
    { 0x13470400, "G2CCD USB 1.1 obsolete" },
    { 0x13470401, "G2CCD-S with Sony ICX285 CCD" },
    { 0x13470402, "G2CCD2" },
    { 0x13470403, "G2/G3CCD-I KAI CCD" },
    { 0x13470404, "G2/G3/G4 CCD-F KAF CCD" },
    { 0x13470405, "Gx CCD-I CCD" },
    { 0x13470406, "Gx CCD-F CCD" },
    { 0x13470410, "G1-0400 CCD" },
    { 0x13470411, "G1-0800 CCD" },
    { 0x13470412, "G1-0300 CCD" },
    { 0x13470413, "G1-2000 CCD" },
    { 0x13470414, "G1-1400 CCD" },
    { 0x13470415, "G1-1200 CCD" },
    { 0x134704b0, "Gx CCD-B CCD" },
    { 0x134704b1, "Gx CCD-BI CCD" },
    { 0x134c0001, "Touch Panel Controller" },
    { 0x134c0002, "Touch Panel Controller" },
    { 0x134c0003, "Touch Panel Controller" },
    { 0x134c0004, "Touch Panel Controller" },
    { 0x13570089, "OpenSDA - CDC Serial Port" },
    { 0x13570503, "USB-ML-12 HCS08/HCS12 Multilink" },
    { 0x13570504, "DEMOJM" },
    { 0x13571000, "Smart Control Touchpad" },
    { 0x135e0021, "Berker KNX Data Interface" },
    { 0x135e0022, "Gira KNX Data Interface" },
    { 0x135e0023, "JUNG KNX Data Interface" },
    { 0x135e0024, "Merten/Schneider Electric KNX Data Interface" },
    { 0x135e0025, "Hager KNX Data Interface" },
    { 0x135e0026, "Feller KNX Data Interface" },
    { 0x135f0110, "Linear Spectrograph" },
    { 0x135f0111, "Spectrograph - Renumerated" },
    { 0x135f0200, "Linear Spectrograph" },
    { 0x135f0201, "Spectrograph - Renumerated" },
    { 0x135f0240, "MPP Spectrograph" },
    { 0x13660101, "J-Link PLUS" },
    { 0x13661015, "J-Link" },
    { 0x136e0012, "iXon Ultra CCD" },
    { 0x136e0014, "Zyla 5.5 sCMOS camera" },
    { 0x13700323, "Swissmemory cirrusWHITE" },
    { 0x13706828, "Victorinox Flash Drive" },
    { 0x13710001, "CNUSB-611AR Wireless Adapter-G [AT76C503]" },
    { 0x13710002, "CNUSB-611AR Wireless Adapter-G [AT76C503] (FiberLine WL-240U)" },
    { 0x13710013, "CNUSB-611 Wireless Adapter [AT76C505]" },
    { 0x13710014, "CNUSB-611 Wireless Adapter [AT76C505] (FiberLine WL-240U)" },
    { 0x13715743, "CNUSB-611 (D) Wireless Adapter [AT76C503]" },
    { 0x13719022, "CWD-854 [RT2573]" },
    { 0x13719032, "CWD-854 rev F" },
    { 0x13719401, "CWD-854 Wireless 802.11g 54Mbps Network Adapter [RTL8187]" },
    { 0x13774000, "HDVD800" },
    { 0x137b0002, "SCAPS USC-2 Scanner Controller" },
    { 0x137c0220, "MP Series" },
    { 0x137c0250, "SIGMA Series" },
    { 0x137c0401, "AC Drive" },
    { 0x13854250, "WG111T" },
    { 0x13854251, "WG111T (no firmware)" },
    { 0x13855f00, "WPN111 RangeMax(TM) Wireless USB 2.0 Adapter" },
    { 0x13855f01, "WPN111 (no firmware)" },
    { 0x13855f02, "WPN111 (no firmware)" },
    { 0x13856e00, "WPNT121 802.11g 240Mbps Wireless Adapter [Airgo AGN300]" },
    { 0x138a0001, "VFS101 Fingerprint Reader" },
    { 0x138a0005, "VFS301 Fingerprint Reader" },
    { 0x138a0007, "VFS451 Fingerprint Reader" },
    { 0x138a0008, "VFS300 Fingerprint Reader" },
    { 0x138a0010, "VFS Fingerprint sensor" },
    { 0x138a0011, "VFS5011 Fingerprint Reader" },
    { 0x138a0015, "VFS 5011 fingerprint sensor" },
    { 0x138a0017, "VFS 5011 fingerprint sensor" },
    { 0x138a0018, "Fingerprint scanner" },
    { 0x138a003c, "VFS471 Fingerprint Reader" },
    { 0x138a003d, "VFS491" },
    { 0x138a003f, "VFS495 Fingerprint Reader" },
    { 0x138a0050, "Swipe Fingerprint Sensor" },
    { 0x138a0090, "VFS7500 Touch Fingerprint Sensor" },
    { 0x138a0091, "VFS7552 Touch Fingerprint Sensor" },
    { 0x138e9000, "Raisonance S.A. STM32 ARM evaluation board / RLink dongle" },
    { 0x13900001, "GO 520 T / GO 630 / ONE / ONE XL" },
    { 0x13905454, "Blue & Me 2" },
    { 0x13907474, "GPS Sport Watch [Runner, Multi-Sport]" },
    { 0x1390a001, "Bandit Action Camera Batt-Stick" },
    { 0x13911000, "URTC-1000" },
    { 0x13950025, "Headset [PC 8]" },
    { 0x13950026, "SC230" },
    { 0x13950027, "SC260" },
    { 0x13950028, "SC230 CTRL" },
    { 0x13950029, "SC260 CTRL" },
    { 0x1395002a, "SC230 for Lync" },
    { 0x1395002b, "SC260 for Lync" },
    { 0x1395002d, "BTD-800" },
    { 0x1395002e, "Presence" },
    { 0x13950030, "CEHS-CI 02" },
    { 0x13950031, "U320 Gaming" },
    { 0x13950032, "SC30 for Lync" },
    { 0x13950033, "SC60 for Lync" },
    { 0x13950034, "SC30 Control" },
    { 0x13950035, "SC60 Control" },
    { 0x13950036, "SC630 for Lync" },
    { 0x13950037, "SC660 for Lync" },
    { 0x13950038, "SC630 CTRL" },
    { 0x13950039, "SC660 CTRL" },
    { 0x1395003f, "SP 20" },
    { 0x13950040, "MB Pro 1/2" },
    { 0x13950041, "SP 20 for Lync" },
    { 0x13950042, "SP 10" },
    { 0x13950043, "SP 10 for Lync" },
    { 0x13950046, "PXC 550" },
    { 0x1395004a, "MOMENTUM M2 OEBT" },
    { 0x1395004b, "MOMENTUM M2 AEBT" },
    { 0x1395004f, "SC230 for MS II" },
    { 0x13950050, "SC260 for MS II" },
    { 0x13950051, "USB-ED CC 01" },
    { 0x13950058, "USB-ED CC 01 for MS" },
    { 0x13950059, "SC40 for MS" },
    { 0x1395005a, "SC70 for MS" },
    { 0x1395005b, "SC40 CTRL" },
    { 0x1395005c, "SC70 CTRL" },
    { 0x13950060, "SCx5 MS" },
    { 0x13950061, "SCx5 CTRL" },
    { 0x13950064, "MB 660 MS" },
    { 0x13950065, "MB 660" },
    { 0x13950066, "SP 20 D UC" },
    { 0x13950067, "SP 20 D MS" },
    { 0x1395006b, "SC5x5 MS" },
    { 0x13950072, "Headset" },
    { 0x13953556, "USB Headset" },
    { 0x13970004, "FCA1616" },
    { 0x139700bc, "BCF2000" },
    { 0x13982103, "USB 2.0 Storage Device" },
    { 0x13ad9999, "Card reader" },
    { 0x13b0000a, "Alesis Photon X25 MIDI Controller" },
    { 0x13b1000a, "WUSB54G v2 802.11g Adapter [Intersil ISL3887]" },
    { 0x13b1000b, "WUSB11 v4.0 802.11b Adapter [ALi M4301]" },
    { 0x13b1000c, "WUSB54AG 802.11a/g Adapter [Intersil ISL3887]" },
    { 0x13b1000d, "WUSB54G v4 802.11g Adapter [Ralink RT2500USB]" },
    { 0x13b1000e, "WUSB54GS v1 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x13b10011, "WUSB54GP v4.0 802.11g Adapter [Ralink RT2500USB]" },
    { 0x13b10014, "WUSB54GS v2 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x13b10018, "USB200M 10/100 Ethernet Adapter" },
    { 0x13b1001a, "HU200TS Wireless Adapter" },
    { 0x13b1001e, "WUSBF54G 802.11bg" },
    { 0x13b10020, "WUSB54GC v1 802.11g Adapter [Ralink RT73]" },
    { 0x13b10022, "WUSB54GX4 802.11g 240Mbps Wireless Adapter [Airgo AGN300]" },
    { 0x13b10023, "WUSB54GR" },
    { 0x13b10024, "WUSBF54G v1.1 802.11bg" },
    { 0x13b10026, "WUSB54GSC v1 802.11g Adapter [Broadcom 4320 USB]" },
    { 0x13b10028, "WUSB200 802.11g Adapter [Ralink RT2671]" },
    { 0x13b10029, "WUSB300N 802.11bgn Wireless Adapter [Marvell 88W8362+88W8060]" },
    { 0x13b1002f, "AE1000 v1 802.11n [Ralink RT3572]" },
    { 0x13b10031, "AM10 v1 802.11n [Ralink RT3072]" },
    { 0x13b10039, "AE1200 802.11bgn Wireless Adapter [Broadcom BCM43235]" },
    { 0x13b1003a, "AE2500 802.11abgn Wireless Adapter [Broadcom BCM43236]" },
    { 0x13b1003b, "AE3000 802.11abgn (3x3) Wireless Adapter [Ralink RT3573]" },
    { 0x13b1003e, "AE6000 802.11a/b/g/n/ac Wireless Adapter [MediaTek MT7610U]" },
    { 0x13b1003f, "WUSB6300 802.11a/b/g/n/ac Wireless Adapter [Realtek RTL8812AU]" },
    { 0x13b10041, "Gigabit Ethernet Adapter" },
    { 0x13b10042, "WUSB6100M 802.11a/b/g/n/ac Wireless Adapter" },
    { 0x13b113b1, "WUSB200: Wireless-G Business Network Adapter with Rangebooster" },
    { 0x13b20030, "Multimix 8" },
    { 0x13ba0001, "Konig Electronic CMP-KEYPAD12 Numeric Keypad" },
    { 0x13ba0017, "PS/2 Keyboard+Mouse Adapter" },
    { 0x13ba0018, "Barcode PCP-BCG4209" },
    { 0x13cf1200, "Olidata Wireless Multimedia Adapter" },
    { 0x13d02282, "TechniSat DVB-PC TV Star 2" },
    { 0x13d17002, "Logik LOG DAX MP3 and DAB Player" },
    { 0x13d17017, "Technika MP-709" },
    { 0x13d17019, "MD 82288" },
    { 0x13d1abe6, "Wireless 802.11g 54Mbps Network Adapter [RTL8187]" },
    { 0x13d20400, "Pocket Ethernet [klsi]" },
    { 0x13d33201, "VisionDTV USB-Ter/HAMA USB DVB-T device cold" },
    { 0x13d33202, "VisionDTV USB-Ter/HAMA USB DVB-T device warm" },
    { 0x13d33203, "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" },
    { 0x13d33204, "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" },
    { 0x13d33205, "DNTV Live! Tiny USB2 BDA (No Remote)" },
    { 0x13d33206, "DNTV Live! Tiny USB2 BDA (No Remote)" },
    { 0x13d33207, "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" },
    { 0x13d33208, "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" },
    { 0x13d33209, "DTV-DVB UDST7022BDA DVB-S Box(Without HID)" },
    { 0x13d33211, "DTV-DVB Hybrid Analog/Capture / Pinnacle PCTV 310e" },
    { 0x13d33212, "DTV-DVB UDTT704C - DVBT/NTSC/PAL Driver(PCM4)" },
    { 0x13d33213, "DTV-DVB UDTT704D - DVBT/NTSC/PAL Driver (PCM4)" },
    { 0x13d33214, "DTV-DVB UDTT704F -(MiniCard) DVBT/NTSC/PAL Driver(Without HID)" },
    { 0x13d33215, "DTV-DVB UDAT7240 - ATSC/NTSC/PAL Driver(PCM4)" },
    { 0x13d33216, "DTV-DVB UDTT 7047-USB 2.0 DVB-T Driver" },
    { 0x13d33217, "Digital-TV Receiver." },
    { 0x13d33219, "DTV-DVB UDTT7049 - DVB-T Driver(Without HID)" },
    { 0x13d33220, "DTV-DVB UDTT 7047M-USB 2.0 DVB-T Driver" },
    { 0x13d33223, "DNTV Live! Tiny USB2 BDA (No Remote)" },
    { 0x13d33224, "DNTV Live! Tiny USB2 BDA (No Remote)" },
    { 0x13d33226, "DigitalNow TinyTwin DVB-T Receiver" },
    { 0x13d33234, "DVB-T FTA Half Minicard [RTL2832U]" },
    { 0x13d33236, "DTV-DVB UDTT 7047A-USB 2.0 DVB-T Driver" },
    { 0x13d33237, "DTV-DVB UDTT 704J - dual DVB-T Driver" },
    { 0x13d33239, "DTV-DVB UDTT704D - DVBT/NTSC/PAL Driver(Without HID)" },
    { 0x13d33240, "DTV-DVB UDXTTM6010 - A/D Driver(Without HID)" },
    { 0x13d33241, "DTV-DVB UDXTTM6010 - A/D Driver(Without HID)" },
    { 0x13d33242, "DTV-DVB UDAT7240LP - ATSC/NTSC/PAL Driver(Without HID)" },
    { 0x13d33243, "DTV-DVB UDXTTM6010 - A/D Driver(Without HID)" },
    { 0x13d33244, "DTV-DVB UDTT 7047Z-USB 2.0 DVB-T Driver" },
    { 0x13d33247, "AW-NU222 802.11bgn Wireless Module [Ralink RT2770+RT2720]" },
    { 0x13d33249, "Internal Bluetooth" },
    { 0x13d33250, "Broadcom Bluetooth 2.1" },
    { 0x13d33262, "802.11 n/g/b Wireless LAN USB Adapter" },
    { 0x13d33273, "802.11 n/g/b Wireless LAN USB Mini-Card" },
    { 0x13d33274, "DVB-T Dongle [RTL2832U]" },
    { 0x13d33282, "DVB-T + GPS Minicard [RTL2832U]" },
    { 0x13d33284, "Wireless LAN USB Mini-Card" },
    { 0x13d33304, "Asus Integrated Bluetooth module [AR3011]" },
    { 0x13d33306, "Mediao 802.11n WLAN [Realtek RTL8191SU]" },
    { 0x13d33315, "Bluetooth module" },
    { 0x13d33327, "AW-NU137 802.11bgn Wireless Module [Atheros AR9271]" },
    { 0x13d33362, "Atheros AR3012 Bluetooth 4.0 Adapter" },
    { 0x13d33375, "Atheros AR3012 Bluetooth 4.0 Adapter" },
    { 0x13d33392, "Azurewave 43228+20702" },
    { 0x13d33394, "Bluetooth" },
    { 0x13d33474, "Atheros AR3012 Bluetooth" },
    { 0x13d33526, "Bluetooth Radio" },
    { 0x13d35070, "Webcam" },
    { 0x13d35111, "Integrated Webcam" },
    { 0x13d35115, "Integrated Webcam" },
    { 0x13d35116, "Integrated Webcam" },
    { 0x13d35122, "2M Integrated Webcam" },
    { 0x13d35126, "PC Cam" },
    { 0x13d35130, "Integrated Webcam" },
    { 0x13d35134, "Integrated Webcam" },
    { 0x13d35615, "Lenovo EasyCamera" },
    { 0x13d35670, "HP TrueVision HD" },
    { 0x13d35682, "SunplusIT Integrated Camera" },
    { 0x13d35702, "UVC VGA Webcam" },
    { 0x13d35710, "UVC VGA Webcam" },
    { 0x13d35716, "UVC VGA Webcam" },
    { 0x13d35a07, "VGA UVC WebCam" },
    { 0x13d37020, "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" },
    { 0x13d37022, "DTV-DVB UDST7022BDA DVB-S Box(Without HID)" },
    { 0x13d3784b, "XHC Camera" },
    { 0x13d70001, "T5 PATA forensic bridge" },
    { 0x13d7000c, "T8-R2 forensic bridge" },
    { 0x13e50001, "SL-1" },
    { 0x13e50003, "TTM 57SL" },
    { 0x13ea0001, "C-56 Thermal Printer" },
    { 0x13ec0006, "HID Remote Control" },
    { 0x13ee0001, "Optical Mouse" },
    { 0x13ee0003, "Optical Mouse" },
    { 0x13fd0550, "INIC-1530 PATA Bridge" },
    { 0x13fd0840, "INIC-1618L SATA" },
    { 0x13fd0841, "Samsung SE-T084M DVD-RW" },
    { 0x13fd0940, "ASUS SBW-06D2X-U" },
    { 0x13fd1040, "INIC-1511L PATA Bridge" },
    { 0x13fd1340, "Hi-Speed USB to SATA Bridge" },
    { 0x13fd160f, "RocketFish SATA Bridge [INIC-1611]" },
    { 0x13fd1640, "INIC-1610L SATA Bridge" },
    { 0x13fd1669, "INIC-1609PN" },
    { 0x13fd1840, "INIC-1608 SATA bridge" },
    { 0x13fd1e40, "INIC-1610P SATA bridge" },
    { 0x13fd2040, "Samsung Writemaster external DVD writer" },
    { 0x13fd3920, "INIC-3619PN SATA Bridge" },
    { 0x13fd3940, "external DVD burner ECD819-SU3" },
    { 0x13fd3960, "INIC-3639" },
    { 0x13fd3e40, "ZALMAN ZM-VE350" },
    { 0x13fe1a00, "512MB/1GB Flash Drive" },
    { 0x13fe1a23, "512MB Flash Drive" },
    { 0x13fe1d00, "DataTraveler 2.0 1GB/4GB Flash Drive / Patriot Xporter 4GB Flash Drive" },
    { 0x13fe1e00, "Flash Drive 2 GB [ICIDU 2 GB]" },
    { 0x13fe1e50, "U3 Smart Drive" },
    { 0x13fe1f00, "Kingston DataTraveler / Patriot Xporter" },
    { 0x13fe1f23, "PS2232 flash drive controller" },
    { 0x13fe2240, "microSD card reader" },
    { 0x13fe3100, "2/4 GB stick" },
    { 0x13fe3123, "Verbatim STORE N GO 4GB" },
    { 0x13fe3200, "flash drive (2GB, EMTEC)" },
    { 0x13fe3600, "flash drive (4GB, EMTEC)" },
    { 0x13fe3800, "Rage XT Flash Drive" },
    { 0x13fe3d00, "Flash Drive" },
    { 0x13fe3e00, "Flash Drive" },
    { 0x13fe4100, "Flash drive" },
    { 0x13fe4200, "Platinum USB drive mini" },
    { 0x13fe5000, "USB flash drive (32 GB SHARKOON Accelerate)" },
    { 0x13fe5100, "Flash Drive" },
    { 0x13fe5200, "DataTraveler R3.0" },
    { 0x13fe5500, "Flash drive" },
    { 0x13fe6300, "SP Mobile C31 (64GB)" },
    { 0x14030001, "Digital Photo Frame" },
    { 0x14030003, "Digital Photo Frame (DPF-1104)" },
    { 0x1404cddc, "Dongle" },
    { 0x14091000, "generic (firmware not loaded yet)" },
    { 0x14091485, "uEye UI1485" },
    { 0x14093240, "uEye UI3240" },
    { 0x140eb011, "TCC780X-based player (USB Boot mode)" },
    { 0x140eb021, "TCC77X-based players (USB Boot mode)" },
    { 0x14101110, "Merlin S620" },
    { 0x14101120, "Merlin EX720" },
    { 0x14101130, "Merlin S720" },
    { 0x14101400, "Merlin U730/U740 (Vodafone)" },
    { 0x14101410, "Merlin U740 (non-Vodafone)" },
    { 0x14101430, "Merlin XU870" },
    { 0x14101450, "Merlin X950D" },
    { 0x14102110, "Ovation U720/MCD3000" },
    { 0x14102410, "Expedite EU740" },
    { 0x14102420, "Expedite EU850D/EU860D/EU870D" },
    { 0x14104100, "U727" },
    { 0x14104400, "Ovation MC930D/MC950D" },
    { 0x14109010, "Expedite E362" },
    { 0x1410a001, "Gobi Wireless Modem" },
    { 0x1410a008, "Gobi Wireless Modem (QDL mode)" },
    { 0x1410b001, "Ovation MC551" },
    { 0x14150000, "Sony SingStar USBMIC" },
    { 0x14150020, "Sony Wireless SingStar" },
    { 0x14152000, "Sony Playstation Eye" },
    { 0x14210605, "Sentech Camera" },
    { 0x14241001, "Temo" },
    { 0x14241002, "Thermal" },
    { 0x14241003, "Neo" },
    { 0x14241004, "Combo DF" },
    { 0x14241005, "Thermal-A" },
    { 0x14241006, "Thermal FV" },
    { 0x14241007, "Bingo HS" },
    { 0x14241008, "Thermal HS FV" },
    { 0x14241009, "Thermal FV EJ" },
    { 0x1424100a, "Thermal HD" },
    { 0x1424100b, "Thermal" },
    { 0x1424100c, "Neo" },
    { 0x1424100d, "Ergo" },
    { 0x1424100e, "Trio" },
    { 0x14241010, "Thermal HS FV EJ" },
    { 0x14241011, "Neo EJ" },
    { 0x14241012, "Thermal-A" },
    { 0x14241013, "Thermal-A EJ" },
    { 0x14241014, "Mobile" },
    { 0x14241015, "Temo HS" },
    { 0x14241016, "Mobile HS" },
    { 0x14241017, "TH230+ FV EJ" },
    { 0x14241018, "4610-1NR FV EJ" },
    { 0x142a0003, "Artema Hybrid" },
    { 0x142a0005, "Artema Modular" },
    { 0x142a0043, "medCompact" },
    { 0x142b03a5, "933A Portable Power Sentinel" },
    { 0x14300150, "wireless receiver for skylanders wii" },
    { 0x14304734, "Guitar Hero4 hub" },
    { 0x14304748, "Guitar Hero X-plorer" },
    { 0x1430474b, "Guitar Hero MIDI interface" },
    { 0x14308888, "TX6500+ Dance Pad" },
    { 0x1430f801, "Controller" },
    { 0x14350427, "UR054g 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x14350711, "UR055G 802.11bg" },
    { 0x14350804, "AR9170+AR9104 802.11abgn Wireless Adapter" },
    { 0x14350826, "AR5523" },
    { 0x14350827, "AR5523 (no firmware)" },
    { 0x14350828, "AR5523" },
    { 0x14350829, "AR5523 (no firmware)" },
    { 0x14430007, "Development board JTAG" },
    { 0x14466a73, "Stamps.com Model 510 5LB Scale" },
    { 0x14466a78, "DYMO Endicia 75lb Digital Scale" },
    { 0x14510301, "haptic device" },
    { 0x14510302, "haptic device" },
    { 0x14510400, "haptic device" },
    { 0x14510401, "delta.x haptic device" },
    { 0x14510402, "omega.x haptic device" },
    { 0x14510403, "sigma.x haptic device" },
    { 0x14510404, "haptic controller" },
    { 0x14510405, "dedicated haptic device" },
    { 0x14510406, "dedicated haptic device" },
    { 0x14510407, "dedicated haptic device" },
    { 0x14510408, "dedicated haptic device" },
    { 0x14528b01, "DS620" },
    { 0x14529001, "DS820" },
    { 0x14534026, "26-183 Serial Cable" },
    { 0x14575117, "OpenMoko Neo1973 kernel usbnet (g_ether, CDC Ethernet) mode" },
    { 0x14575118, "OpenMoko Neo1973 Debug board (V2+)" },
    { 0x14575119, "OpenMoko Neo1973 u-boot cdc_acm serial port" },
    { 0x1457511a, "HXD8 u-boot usbtty CDC ACM Mode" },
    { 0x1457511b, "SMDK2440 u-boot usbtty CDC ACM mode" },
    { 0x1457511c, "SMDK2443 u-boot usbtty CDC ACM mode" },
    { 0x1457511d, "QT2410 u-boot usbtty CDC ACM mode" },
    { 0x14575120, "OpenMoko Neo1973 u-boot usbtty generic serial" },
    { 0x14575121, "OpenMoko Neo1973 kernel mass storage (g_storage) mode" },
    { 0x14575122, "OpenMoko Neo1973 / Neo Freerunner kernel cdc_ether USB network" },
    { 0x14575123, "OpenMoko Neo1973 internal USB CSR4 module" },
    { 0x14575124, "OpenMoko Neo1973 Bluetooth Device ID service" },
    { 0x145f0106, "K56 V92 Modem" },
    { 0x145f013d, "PC Camera (SN9C201 + OV7660)" },
    { 0x145f013f, "Megapixel Auto Focus Webcam" },
    { 0x145f0142, "WB-6250X Webcam" },
    { 0x145f015a, "WB-8300X 2MP Webcam" },
    { 0x145f0161, "15901 802.11bg Wireless Adapter [Realtek RTL8187L]" },
    { 0x145f0167, "Widescreen 3MP Webcam" },
    { 0x145f0176, "Isla Keyboard" },
    { 0x145f019f, "17676 Webcam" },
    { 0x145f01e5, "Keyboard [GXT 830]" },
    { 0x145f0212, "Panora Widescreen Graphic Tablet" },
    { 0x145f023f, "Mouse [GXT 168]" },
    { 0x14609150, "eHome Infrared Transceiver" },
    { 0x14625512, "MegaStick-1 Flash Stick" },
    { 0x14628807, "DIGIVOX mini III [af9015]" },
    { 0x146b0601, "Controller for Xbox 360" },
    { 0x146b0902, "Wired Mini PS3 Game Controller" },
    { 0x14720007, "Aolynk WUB300g [ZyDAS ZD1211]" },
    { 0x14720009, "Aolynk WUB320g" },
    { 0x147ae015, "eHome Infrared Receiver" },
    { 0x147ae016, "eHome Infrared Receiver" },
    { 0x147ae017, "eHome Infrared Receiver" },
    { 0x147ae018, "eHome Infrared Receiver" },
    { 0x147ae02c, "Infrared Receiver" },
    { 0x147ae03a, "eHome Infrared Receiver" },
    { 0x147ae03c, "eHome Infrared Receiver" },
    { 0x147ae03d, "2 Channel Audio" },
    { 0x147ae03e, "Infrared Receiver [IR605A/Q]" },
    { 0x147e1000, "Biometric Touchchip/Touchstrip Fingerprint Sensor" },
    { 0x147e1001, "TCS5B Fingerprint sensor" },
    { 0x147e1002, "Biometric Touchchip/Touchstrip Fingerprint Sensor" },
    { 0x147e2016, "Biometric Touchchip/Touchstrip Fingerprint Sensor" },
    { 0x147e2020, "TouchChip Fingerprint Coprocessor (WBF advanced mode)" },
    { 0x147e3000, "TCS1C EIM/Cypress Fingerprint sensor" },
    { 0x147e3001, "TCS1C EIM/STM32 Fingerprint sensor" },
    { 0x14821005, "VRD PC-Interface" },
    { 0x14841746, "Ecomo 19H99 Monitor" },
    { 0x14847616, "Elsa Hub" },
    { 0x14850001, "U2E" },
    { 0x14850002, "Psion Gold Port Ethernet" },
    { 0x148f1000, "Motorola BC4 Bluetooth 3.0+HS Adapter" },
    { 0x148f1706, "RT2500USB Wireless Adapter" },
    { 0x148f2070, "RT2070 Wireless Adapter" },
    { 0x148f2570, "RT2570 Wireless Adapter" },
    { 0x148f2573, "RT2501/RT2573 Wireless Adapter" },
    { 0x148f2671, "RT2601/RT2671 Wireless Adapter" },
    { 0x148f2770, "RT2770 Wireless Adapter" },
    { 0x148f2870, "RT2870 Wireless Adapter" },
    { 0x148f3070, "RT2870/RT3070 Wireless Adapter" },
    { 0x148f3071, "RT3071 Wireless Adapter" },
    { 0x148f3072, "RT3072 Wireless Adapter" },
    { 0x148f3370, "RT3370 Wireless Adapter" },
    { 0x148f3572, "RT3572 Wireless Adapter" },
    { 0x148f3573, "RT3573 Wireless Adapter" },
    { 0x148f5370, "RT5370 Wireless Adapter" },
    { 0x148f5372, "RT5372 Wireless Adapter" },
    { 0x148f5572, "RT5572 Wireless Adapter" },
    { 0x148f7601, "MT7601U Wireless Adapter" },
    { 0x148f760b, "MT7601U Wireless Adapter" },
    { 0x148f761a, "MT7610U (\"Archer T2U\" 2.4G+5G WLAN Adapter" },
    { 0x148f9020, "RT2500USB Wireless Adapter" },
    { 0x148f9021, "RT2501USB Wireless Adapter" },
    { 0x14910020, "FS81 Fingerprint Scanner Module" },
    { 0x14910088, "Fingerprint Scanner Model FS88" },
    { 0x14930010, "Bluebird [Ambit]" },
    { 0x14930019, "Duck [Ambit2]" },
    { 0x1493001a, "Colibri [Ambit2 S]" },
    { 0x1493001b, "Emu [Ambit3 Peak]" },
    { 0x1493001c, "Finch [Ambit3 Sport]" },
    { 0x1493001d, "Greentit [Ambit2 R]" },
    { 0x1493001e, "Ibisbill [Ambit3 Run]" },
    { 0x1498a090, "DVB-T Tuner" },
    { 0x149a069b, "PURE Digital Evoke-1XT Tri-band" },
    { 0x149a2107, "DBX1 DSP core" },
    { 0x14aa0001, "Avermedia AverTV DVBT USB1.1 (cold)" },
    { 0x14aa0002, "Avermedia AverTV DVBT USB1.1 (warm)" },
    { 0x14aa0201, "AVermedia/Yakumo/Hama/Typhoon DVB-T USB2.0 (cold)" },
    { 0x14aa0221, "WT-220U DVB-T dongle" },
    { 0x14aa022b, "WT-220U DVB-T dongle" },
    { 0x14aa0301, "AVermedia/Yakumo/Hama/Typhoon DVB-T USB2.0 (warm)" },
    { 0x14b03410, "Serial Adapter ICUSB2321X [TUSB3410I]" },
    { 0x14b23a93, "Topcom 802.11bg Wireless Adapter [Atheros AR5523]" },
    { 0x14b23a95, "Toshiba WUS-G06G-JT 802.11bg Wireless Adapter [Atheros AR5523]" },
    { 0x14b23a98, "Airlink101 AWLL4130 802.11bg Wireless Adapter [Atheros AR5523]" },
    { 0x14b23c02, "Conceptronic C54RU v2 802.11bg Wireless Adapter [Ralink RT2571]" },
    { 0x14b23c05, "rt2570 802.11g WLAN" },
    { 0x14b23c06, "Conceptronic C300RU v1 802.11bgn Wireless Adapter [Ralink RT2870]" },
    { 0x14b23c07, "802.11n adapter" },
    { 0x14b23c09, "802.11n adapter" },
    { 0x14b23c22, "Conceptronic C54RU v3 802.11bg Wireless Adapter [Ralink RT2571W]" },
    { 0x14b23c23, "Airlink101 AWLL6080 802.11bgn Wireless Adapter [Ralink RT2870]" },
    { 0x14b23c24, "NEC NP01LM 802.11abg Wireless Adapter [Ralink RT2571W]" },
    { 0x14b23c25, "DrayTek Vigor N61 802.11bgn Wireless Adapter [Ralink RT2870]" },
    { 0x14b23c27, "Airlink101 AWLL6070 802.11bgn Wireless Adapter [Ralink RT2770]" },
    { 0x14b23c28, "Conceptronic C300RU v2 802.11bgn Wireless Adapter [Ralink RT2770]" },
    { 0x14b23c2b, "NEC NP02LM 802.11bgn Wireless Adapter [Ralink RT3072]" },
    { 0x14b23c2c, "Keebox W150NU 802.11bgn Wireless Adapter [Ralink RT3070]" },
    { 0x14c20250, "Storage Adapter V2" },
    { 0x14c20350, "Storage Adapter V2" },
    { 0x14c80005, "Touchscreen Controller" },
    { 0x14cd1212, "microSD card reader (SY-T18)" },
    { 0x14cd121c, "microSD card reader" },
    { 0x14cd121f, "microSD CardReader SY-T18" },
    { 0x14cd123a, "SD/MMC/RS-MMC Card Reader" },
    { 0x14cd125c, "SD card reader" },
    { 0x14cd127b, "SDXC Reader" },
    { 0x14cd168a, "Elecom Co., Ltd MR-K013 Multicard Reader" },
    { 0x14cd6116, "M6116 SATA Bridge" },
    { 0x14cd6600, "M110E PATA bridge" },
    { 0x14cd6700, "Card Reader" },
    { 0x14cd6900, "Card Reader" },
    { 0x14cd8123, "SD MMC Reader" },
    { 0x14cd8125, "SD MMC Reader" },
    { 0x14cd8601, "4-Port hub" },
    { 0x14cd8608, "Hub [Super Top]" },
    { 0x14dd1007, "D2CIM-VUSB KVM connector" },
    { 0x14e00501, "WR-G528e 'CHEETAH'" },
    { 0x14e15000, "PenMount 5000 Touch Controller" },
    { 0x14eaab10, "GW-US54GZ" },
    { 0x14eaab11, "GU-1000T" },
    { 0x14eaab13, "GW-US54Mini 802.11bg" },
    { 0x14ed1000, "MV5" },
    { 0x14ed1002, "MV51" },
    { 0x14ed1003, "MVi" },
    { 0x14ed1004, "SHA900" },
    { 0x14ed1005, "KSE1500" },
    { 0x14ed1011, "MV88+" },
    { 0x14ed1100, "ANIUSB-MATRIX" },
    { 0x14ed1101, "P300" },
    { 0x14ed29b6, "X2u Adapter" },
    { 0x14ed3000, "RMCE-USB" },
    { 0x14f70001, "SkyStar 2 HD CI" },
    { 0x14f70002, "SkyStar 2 HD CI" },
    { 0x14f70003, "CableStar Combo HD CI" },
    { 0x14f70004, "AirStar TeleStick 2" },
    { 0x14f70500, "DVB-PC TV Star HD" },
    { 0x1504001f, "SRP-350II Thermal Receipt Printer" },
    { 0x15090a01, "LI-3100 Area Meter" },
    { 0x15090a02, "LI-7000 CO2/H2O Gas Analyzer" },
    { 0x15090a03, "C-DiGit Blot Scanner" },
    { 0x15099242, "eHome Infrared Transceiver" },
    { 0x15130444, "medMobile" },
    { 0x15142003, "FlashPro3 Programmer" },
    { 0x15142004, "FlashPro3 Programmer" },
    { 0x15142005, "FlashPro3 Programmer" },
    { 0x15161603, "Flash Drive" },
    { 0x15168628, "Pen Drive" },
    { 0x15180001, "HDReye High Dynamic Range Camera" },
    { 0x15180002, "HDReye (before firmware loads)" },
    { 0x15190020, "HSIC Device" },
    { 0x151f0020, "XEM3001v1" },
    { 0x151f0021, "XEM3001v2" },
    { 0x151f0022, "XEM3010" },
    { 0x151f0023, "XEM3005" },
    { 0x151f0028, "XEM3050" },
    { 0x151f002b, "XEM5010" },
    { 0x151f002c, "XEM6001" },
    { 0x151f002d, "XEM6010-LX45" },
    { 0x151f002e, "XEM6010-LX150" },
    { 0x151f0030, "XEM6006-LX16" },
    { 0x151f0033, "XEM6002-LX9" },
    { 0x151f0034, "XEM7001-A15" },
    { 0x151f0036, "XEM7010-A50" },
    { 0x151f0037, "XEM7010-A200" },
    { 0x151f0120, "ZEM4310" },
    { 0x151f0121, "XEM6310-LX45" },
    { 0x151f0122, "XEM6310-LX150" },
    { 0x151f0123, "XEM6310MT-LX45T" },
    { 0x151f0125, "XEM7350-K70T" },
    { 0x151f0126, "XEM7350-K160T" },
    { 0x151f0127, "XEM7350-K410T" },
    { 0x151f0128, "XEM6310MT-LX150T" },
    { 0x151f0129, "ZEM5305-A2" },
    { 0x151f012b, "XEM7360-K160T" },
    { 0x151f012c, "XEM7360-K410T" },
    { 0x151f012d, "ZEM5310-A4" },
    { 0x151f0130, "XEM7310-A75" },
    { 0x151f0131, "XEM7310-A200" },
    { 0x15246680, "UTS 6680" },
    { 0x15270200, "YAP Phone (no firmware)" },
    { 0x15270201, "YAP Phone" },
    { 0x15293100, "CDMA 1xRTT USB Modem (U-100/105/200/300/520)" },
    { 0x152a8350, "NET Gmbh iCube Camera" },
    { 0x152a8400, "INI DVS128" },
    { 0x152a840d, "INI DAViS" },
    { 0x152a841a, "INI DAViS FX3" },
    { 0x152b0001, "spirobank II" },
    { 0x152b0002, "spirolab III" },
    { 0x152b0003, "MiniSpir" },
    { 0x152b0004, "Oxi" },
    { 0x152b0005, "spiros II" },
    { 0x152b0006, "smiths spirobank II" },
    { 0x152b0007, "smiths spirobank G-USB" },
    { 0x152b0008, "smiths MiniSpir" },
    { 0x152b0009, "spirobank G-USB" },
    { 0x152b000a, "smiths Oxi" },
    { 0x152b000b, "smiths spirolab III" },
    { 0x152b000c, "chorus III" },
    { 0x152b000d, "spirolab III Bw" },
    { 0x152b000e, "spirolab III" },
    { 0x152b000f, "easySpiro" },
    { 0x152b0010, "Spirotel converter" },
    { 0x152b0011, "spirobank" },
    { 0x152b0012, "spiro3 Zimmer" },
    { 0x152b0013, "spirotel serial" },
    { 0x152b0014, "spirotel II" },
    { 0x152b0015, "spirodoc" },
    { 0x152d0539, "JMS539/567 SuperSpeed SATA II/III 3.0G/6.0G Bridge" },
    { 0x152d0551, "JMS551 SuperSpeed two ports SATA 3Gb/s bridge" },
    { 0x152d0561, "JMS551 - Sharkoon SATA QuickPort Duo" },
    { 0x152d0562, "JMS567 SATA 6Gb/s bridge" },
    { 0x152d0567, "JMS567 SATA 6Gb/s bridge" },
    { 0x152d0576, "Gen1 SATA 6Gb/s Bridge" },
    { 0x152d0578, "JMS578 SATA 6Gb/s" },
    { 0x152d0583, "JMS583Gen 2 to PCIe Gen3x2 Bridge" },
    { 0x152d0770, "Alienware Integrated Webcam" },
    { 0x152d1561, "JMS561U two ports SATA 6Gb/s bridge" },
    { 0x152d1576, "External Disk 3.0" },
    { 0x152d2329, "JM20329 SATA Bridge" },
    { 0x152d2335, "ATA/ATAPI Bridge" },
    { 0x152d2336, "Hard Disk Drive" },
    { 0x152d2337, "ATA/ATAPI Bridge" },
    { 0x152d2338, "JM20337 Hi-Speed USB to SATA & PATA Combo Bridge" },
    { 0x152d2339, "JM20339 SATA Bridge" },
    { 0x152d2352, "ATA/ATAPI Bridge" },
    { 0x152d2509, "JMS539, JMS551 SATA 3Gb/s bridge" },
    { 0x152d2551, "JMS551 SATA 3Gb/s bridge" },
    { 0x152d2561, "CEB-2235S-U3 external RAID box" },
    { 0x152d2566, "JMS566 SATA 3Gb/s bridge" },
    { 0x152d2590, "JMS567 SATA 6Gb/s bridge" },
    { 0x152d3562, "JMS567 SATA 6Gb/s bridge" },
    { 0x152d3569, "JMS566 SATA 3Gb/s bridge" },
    { 0x152d578e, "JMS578 SATA 6Gb/s bridge" },
    { 0x152d8561, "salcar docking station two disks" },
    { 0x152e1640, "INIC-1605 SATA Bridge" },
    { 0x152e2507, "PL-2507 IDE Controller" },
    { 0x152e2571, "GP08NU6W DVD-RW" },
    { 0x152ee001, "GSA-5120D DVD-RW" },
    { 0x15320001, "RZ01-020300 Optical Mouse [Diamondback]" },
    { 0x15320002, "Diamondback Optical Mouse" },
    { 0x15320003, "Krait Mouse" },
    { 0x15320005, "Boomslang CE" },
    { 0x15320007, "DeathAdder Mouse" },
    { 0x15320009, "Gaming Mouse [Tempest Habu]" },
    { 0x1532000a, "Mamba (Wired)" },
    { 0x1532000c, "Lachesis" },
    { 0x1532000d, "DiamondBack 3G" },
    { 0x1532000e, "Megalodon" },
    { 0x1532000f, "Mamba (Wireless)" },
    { 0x15320012, "Gaming Mouse [Salmosa]" },
    { 0x15320013, "Orochi 2011" },
    { 0x15320015, "Naga Mouse" },
    { 0x15320016, "DeathAdder 3.5G" },
    { 0x15320017, "RZ01-0035 Laser Gaming Mouse [Imperator]" },
    { 0x15320019, "Marauder" },
    { 0x1532001a, "Spectre" },
    { 0x1532001b, "Gaming Headset" },
    { 0x1532001c, "RZ01-0036 Optical Gaming Mouse [Abyssus]" },
    { 0x1532001e, "Lachesis (5600 DPI)" },
    { 0x1532001f, "Naga Epic (Wired)" },
    { 0x15320020, "Abyssus 1800" },
    { 0x15320021, "Naga Epic Dock (Wireless, Bluetooth)" },
    { 0x15320022, "Gaming Mouse [TRON]" },
    { 0x15320023, "Gaming Keyboard [TRON]" },
    { 0x15320024, "Mamba 2012 (Wired)" },
    { 0x15320025, "Mamba 2012 (Wireless)" },
    { 0x15320029, "DeathAdder Black Edition" },
    { 0x1532002a, "Gaming Mouse [Star Wars: The Old Republic]" },
    { 0x1532002b, "Gaming Keyboard [Star Wars: The Old Republic]" },
    { 0x1532002c, "Gaming Headset [Star Wars: The Old Republic]" },
    { 0x1532002e, "RZ01-0058 Gaming Mouse [Naga 2012]" },
    { 0x1532002f, "Imperator 2012" },
    { 0x15320031, "Gaming Mouse Dock [Star Wars: The Old Republic]" },
    { 0x15320032, "Ouroboros 2012 (Wired)" },
    { 0x15320033, "Ouroboros 2012 (Wireless)" },
    { 0x15320034, "Taipan" },
    { 0x15320035, "Krait 2013 Essential" },
    { 0x15320036, "RZ01-0075, Gaming Mouse [Naga Hex (Red)]" },
    { 0x15320037, "DeathAdder 2013" },
    { 0x15320038, "DeathAdder 1800" },
    { 0x15320039, "Orochi 2013" },
    { 0x1532003e, "Naga Epic Chroma (Wired)" },
    { 0x1532003f, "Naga Epic Chroma (Wireless)" },
    { 0x15320040, "Naga 2014" },
    { 0x15320041, "Naga Hex" },
    { 0x15320042, "Abyssus 2014" },
    { 0x15320043, "DeathAdder Chroma" },
    { 0x15320044, "Mamba Chroma (Wired)" },
    { 0x15320045, "Mamba Chroma (Wireless)" },
    { 0x15320046, "Mamba 2015 Tournament Edition [RZ01-01370100-R3]" },
    { 0x15320048, "Orochi 2015 (Wired)" },
    { 0x1532004a, "RZ03-0133 Gaming Lapboard, Keyboard Mouse Combo, Dongle [Turret Dongle]" },
    { 0x1532004c, "Diamondback Chroma" },
    { 0x1532004d, "DeathAdder 2000 (Cynosa Pro Bundle)" },
    { 0x1532004f, "RZ01-0145, Gaming Mouse [DeathAdder 2000 (Alternate)]" },
    { 0x15320050, "Naga Hex V2" },
    { 0x15320053, "Naga Chroma" },
    { 0x15320054, "DeathAdder 3500" },
    { 0x15320056, "Orochi 2015 (Wireless)" },
    { 0x15320059, "RZ01-0212 Gaming Mouse [Lancehead (Wired)]" },
    { 0x1532005a, "RZ01-0212 Gaming Mouse [Lancehead (Wireless)]" },
    { 0x1532005b, "Abyssus V2" },
    { 0x1532005c, "DeathAdder Elite" },
    { 0x1532005e, "Abyssus 2000" },
    { 0x1532005f, "DeathAdder 2000" },
    { 0x15320060, "RZ01-0213 Gaming Mouse [Lancehead Tournament Edition]" },
    { 0x15320062, "Atheris" },
    { 0x15320064, "Basilisk" },
    { 0x15320065, "RZ01-0265, Gaming Mouse [Basilisk Essential]" },
    { 0x15320067, "Naga Trinity" },
    { 0x15320068, "Gaming Mouse Mat [Firefly Hyperflux]" },
    { 0x15320069, "Gaming Mouse [Mamba Hyperflux]" },
    { 0x1532006a, "Abyssus Elite (D.Va Edition)" },
    { 0x1532006b, "Abyssus Essential" },
    { 0x1532006c, "Mamba Elite (Wired)" },
    { 0x1532006e, "DeathAdder Essential" },
    { 0x1532006f, "RZ01-0257 Gaming Mouse [Lancehead Wireless (2019, Wireless, Receiver)]" },
    { 0x15320070, "RZ01-0257 Gaming Mouse [Lancehead Wireless (2019, Wired)]" },
    { 0x15320071, "RZ01-0254 Gaming Mouse [DeathAdder Essential White Edition]" },
    { 0x15320072, "Mamba 2018 (Wireless)" },
    { 0x15320073, "Mamba 2018 (Wired)" },
    { 0x15320078, "Viper (wired)" },
    { 0x1532007a, "RC30-0305 Gaming Mouse [Viper Ultimate (Wired)]" },
    { 0x1532007b, "RC30-0305 Gaming Mouse Dongle [Viper Ultimate (Wireless)]" },
    { 0x1532007e, "RC30-030502 Mouse Dock" },
    { 0x15320083, "RC30-0315, Gaming Mouse [Basilisk X HyperSpeed]" },
    { 0x15320084, "RZ01-0321 Gaming Mouse [DeathAdder V2]" },
    { 0x15320085, "RZ01-0316 Gaming Mouse [Basilisk V2]" },
    { 0x15320086, "Gaming Mouse [Basilisk Ultimate, Wired]" },
    { 0x15320088, "Gaming Mouse [Basilisk Ultimate, Wireless, Receiver]" },
    { 0x1532008a, "RZ01-0325, Gaming Mouse [Viper Mini]" },
    { 0x15320101, "Copperhead Mouse" },
    { 0x15320102, "Tarantula Keyboard" },
    { 0x15320103, "Gaming Keyboard [Reclusa]" },
    { 0x15320105, "Gaming Keyboard [ProType]" },
    { 0x15320106, "Gaming Keyboard [ProType]" },
    { 0x15320109, "Lycosa Keyboard" },
    { 0x1532010b, "Gaming Keyboard [Arctosa]" },
    { 0x1532010d, "BlackWidow Ultimate 2012" },
    { 0x1532010e, "BlackWidow Classic (Alternate)" },
    { 0x1532010f, "Anansi" },
    { 0x15320110, "Cyclosa" },
    { 0x15320111, "Nostromo" },
    { 0x15320113, "RZ07-0074 Gaming Keypad [Orbweaver]" },
    { 0x15320114, "DeathStalker Ultimate" },
    { 0x15320116, "Blade Pro (2015)" },
    { 0x15320118, "RZ03-0080, Gaming Keyboard [Deathstalker Essential]" },
    { 0x15320119, "Gaming Keyboard [Lycosa]" },
    { 0x1532011a, "BlackWidow Ultimate 2013" },
    { 0x1532011b, "BlackWidow Classic" },
    { 0x1532011c, "BlackWidow Tournament Edition Stealth" },
    { 0x1532011d, "Blade 2013" },
    { 0x1532011e, "Gaming Keyboard Dock [Edge Keyboard Dock]" },
    { 0x1532011f, "Deathstalker Essential 2014" },
    { 0x15320200, "Gaming Keyboard [Reclusa]" },
    { 0x15320201, "Tartarus" },
    { 0x15320202, "DeathStalker Expert" },
    { 0x15320203, "BlackWidow Chroma" },
    { 0x15320204, "DeathStalker Chroma" },
    { 0x15320205, "Blade Stealth" },
    { 0x15320207, "Orbweaver Chroma keypad" },
    { 0x15320208, "Tartarus Chroma" },
    { 0x15320209, "BlackWidow Tournament Edition Chroma" },
    { 0x1532020d, "Cynosa Pro keyboard (Cynosa Pro Bundle)" },
    { 0x1532020f, "Blade QHD" },
    { 0x15320210, "Blade Pro (Late 2016)" },
    { 0x15320211, "BlackWidow Chroma (Overwatch)" },
    { 0x15320214, "BlackWidow Ultimate 2016" },
    { 0x15320215, "Core" },
    { 0x15320216, "BlackWidow X Chroma" },
    { 0x15320217, "BlackWidow X Ultimate" },
    { 0x1532021a, "BlackWidow X Tournament Edition Chroma" },
    { 0x1532021b, "Gaming Keyboard [BlackWidow X Tournament Edition]" },
    { 0x1532021e, "Ornata Chroma" },
    { 0x1532021f, "Ornata" },
    { 0x15320220, "Blade Stealth (2016)" },
    { 0x15320221, "RZ03-0203 Gaming Keyboard [BlackWidow Chroma V2]" },
    { 0x15320224, "Blade (Late 2016)" },
    { 0x15320225, "Blade Pro (2017)" },
    { 0x15320226, "Huntsman Elite" },
    { 0x15320227, "Huntsman" },
    { 0x15320228, "BlackWidow Elite" },
    { 0x1532022a, "Cynosa Chroma" },
    { 0x1532022b, "Tartarus V2" },
    { 0x1532022c, "Cynosa Chroma Pro" },
    { 0x1532022d, "Blade Stealth (Mid 2017)" },
    { 0x1532022f, "Blade Pro FullHD (2017)" },
    { 0x15320232, "Blade Stealth (Late 2017)" },
    { 0x15320233, "Blade 15 (2018)" },
    { 0x15320234, "Blade Pro 17 (2019)" },
    { 0x15320235, "BlackWidow Lite (2018)" },
    { 0x15320237, "BlackWidow Essential" },
    { 0x15320239, "Blade Stealth (2019)" },
    { 0x1532023a, "Blade 15 (2019) Advanced" },
    { 0x1532023b, "Blade 15 (2018) Base Model" },
    { 0x1532023f, "RZ03-0274 Gaming Keyboard [Cynosa Lite]" },
    { 0x15320240, "Blade 15 (2018) Mercury" },
    { 0x15320241, "BlackWidow (2019)" },
    { 0x15320243, "Huntsman Tournament Edition" },
    { 0x15320244, "RZ07-0311 Gaming Keypad [Tartarus Pro]" },
    { 0x15320245, "Blade 15 (Mid 2019) Mercury" },
    { 0x15320246, "Blade 15 (Mid 2019) Base Model" },
    { 0x1532024a, "Blade Stealth (Late 2019)" },
    { 0x1532024b, "Gaming Laptop [Blade 15 Advanced (Late 2019)]" },
    { 0x1532024c, "Gaming Laptop [Blade Pro (Late 2019)]" },
    { 0x1532024d, "Blade 15 Studio Edition (2019)" },
    { 0x15320253, "RZ09-0330, Gaming Laptop [Blade 15 Advanced (Early 2020)]" },
    { 0x15320255, "RZ09-0328, Gaming Laptop [Blade 15 Base Model (2020)]" },
    { 0x15320256, "RZ09--0329, Gaming Laptop [Blade Pro 17 Full HD (2020)]" },
    { 0x1532025d, "RZ03-0338, Gaming Keyboard [Ornata V2]" },
    { 0x15320300, "RZ06-0063 Motion Sensing Controllers [Hydra]" },
    { 0x15320401, "Gaming Arcade Stick [Panthera]" },
    { 0x15320501, "Kraken 7.1" },
    { 0x15320502, "Gaming Headset [Kraken USB]" },
    { 0x15320504, "Kraken 7.1 Chroma" },
    { 0x15320506, "Kraken 7.1 (Alternate Version)" },
    { 0x15320510, "Kraken 7.1 V2" },
    { 0x15320511, "RZ19-0229 Gaming Microphone" },
    { 0x15320514, "Electra V2 USB" },
    { 0x15320517, "Nommo Chroma" },
    { 0x15320518, "Nommo Pro" },
    { 0x1532051a, "Nari Ultimate" },
    { 0x1532051c, "Nari (Wireless)" },
    { 0x1532051d, "Nari (Wired)" },
    { 0x1532051e, "RC30-026902, Gaming Headset [Nari Essential, Wireless, Receiver]" },
    { 0x1532051f, "RC30-026901, Gaming Headset [Nari Essential, Wired]" },
    { 0x15320520, "Kraken Tournament Edition" },
    { 0x15320521, "Kraken Kitty Edition" },
    { 0x15320527, "RZ04-0318 Gaming Headset [Kraken Ultimate]" },
    { 0x15320904, "R201-0282 Gaming Keyboard, Mouse Combination [Turret For Xbox One]" },
    { 0x15320a00, "Atrox Arcade Stick for Xbox One" },
    { 0x15320a02, "ManO'War" },
    { 0x15320a03, "Wildcat" },
    { 0x15320a15, "RZ06-0199, Gaming Controller [Wolverine Tournament Edition]" },
    { 0x15320c00, "RZ02-0135 Hard Gaming Mouse Mat [Firefly]" },
    { 0x15320c01, "Goliathus" },
    { 0x15320c02, "Goliathus Extended" },
    { 0x15320c04, "Firefly V2" },
    { 0x15320e03, "Gaming Webcam [Kiyo]" },
    { 0x15320f03, "Tiamat 7.1 V2" },
    { 0x15320f07, "Chroma Mug Holder" },
    { 0x15320f08, "Base Station Chroma" },
    { 0x15320f09, "Chroma HDK" },
    { 0x15320f0d, "Laptop Stand Chroma" },
    { 0x15320f13, "Lian Li O11 Dynamic Razer Edition" },
    { 0x15320f1a, "Core X Chroma" },
    { 0x15321000, "Gaming Controller [Raiju]" },
    { 0x15321004, "Gaming Controller [Raiju Ultimate Wired]" },
    { 0x15321007, "Gaming Controller [Raiju 2 Tournament Edition (USB)]" },
    { 0x15321008, "Gaming Flightstick [Panthera Evo]" },
    { 0x15321009, "Gaming Controller [Raiju 2 Ultimate Edition (BT)]" },
    { 0x1532100a, "Gaming Controller [Raiju 2 Tournament Edition (BT)]" },
    { 0x1532110d, "Bootloader (Alternate)" },
    { 0x1532800e, "Bootloader" },
    { 0x153b1181, "Cinergy S2 PCIe Dual Port 1" },
    { 0x153b1182, "Cinergy S2 PCIe Dual Port 2" },
    { 0x154601a4, "Antaris 4" },
    { 0x154601a5, "[u-blox 5]" },
    { 0x154601a6, "[u-blox 6]" },
    { 0x154601a7, "[u-blox 7]" },
    { 0x154601a8, "[u-blox 8]" },
    { 0x15461102, "LISA-U2" },
    { 0x15471000, "SG-Lock[U2]" },
    { 0x154a8180, "CARD STAR/medic2" },
    { 0x154b000f, "Flash Drive" },
    { 0x154b0010, "USB 2.0 Flash Drive" },
    { 0x154b0048, "Flash Drive" },
    { 0x154b004d, "8 GB Flash Drive" },
    { 0x154b0053, "Flash Drive" },
    { 0x154b0057, "32GB Micro Slide Attache Flash Drive" },
    { 0x154b005b, "Flash Drive" },
    { 0x154b0062, "Flash Drive" },
    { 0x154b007a, "Classic Attache Flash Drive" },
    { 0x154b5408, "2.5in drive enclosure" },
    { 0x154b6000, "Flash Drive" },
    { 0x154b6545, "FD Device" },
    { 0x154bfa05, "Flash Drive" },
    { 0x154e3000, "Marantz RC9001 Remote Control" },
    { 0x15545010, "PV-D231U(RN)-F [PixelView PlayTV SBTVD Full-Seg]" },
    { 0x15570002, "model 01 WiFi interface" },
    { 0x15570003, "model 01 Bluetooth interface" },
    { 0x15570a80, "Gobi Wireless Modem (QDL mode)" },
    { 0x15577720, "model 01+ Ethernet" },
    { 0x15578150, "model 01 Ethernet interface" },
    { 0x157e3006, "TEW-444UB EU [TRENDnet]" },
    { 0x157e3007, "TEW-444UB EU (no firmware)" },
    { 0x157e300a, "TEW-429UB 802.11bg" },
    { 0x157e300b, "TEW-429UB 802.11bg" },
    { 0x157e300c, "TEW-429UF A1 802.11bg Wireless Adapter [ZyDAS ZD1211B]" },
    { 0x157e300d, "TEW-429UB C1 802.11bg" },
    { 0x157e300e, "SMC SMCWUSB-N 802.11bgn 2x2:2 Wireless Adapter [Ralink RT2870]" },
    { 0x157e3012, "TEW-604UB 802.11bg Wireless Adapter [Atheros AR5523]" },
    { 0x157e3013, "TEW-645UB 802.11bgn 1x2:2 Wireless Adapter [Ralink RT2770]" },
    { 0x157e3204, "Allnet ALL0298 v2 802.11bg" },
    { 0x157e3205, "Allnet ALL0283 [AR5523]" },
    { 0x157e3206, "Allnet ALL0283 [AR5523](no firmware)" },
    { 0x157e3207, "TEW-509UB A1 802.11abg Wireless Adapter [ZyDAS ZD1211]" },
    { 0x157e3208, "TEW-509UB 1.1R 802.11abg Wireless Adapter" },
    { 0x15826003, "WL-430U 802.11bg" },
    { 0x158e0820, "SmartPocket Class Device" },
    { 0x15a20038, "9S08JS Bootloader" },
    { 0x15a2003b, "USB2CAN Application for ColdFire DEMOJM board" },
    { 0x15a20041, "i.MX51 SystemOnChip in RecoveryMode" },
    { 0x15a20042, "OSBDM - Debug Port" },
    { 0x15a2004e, "i.MX53 SystemOnChip in RecoveryMode" },
    { 0x15a2004f, "i.MX28 SystemOnChip in RecoveryMode" },
    { 0x15a20052, "i.MX50 SystemOnChip in RecoveryMode" },
    { 0x15a20054, "i.MX 6Dual/6Quad SystemOnChip in RecoveryMode" },
    { 0x15a20061, "i.MX 6Solo/6DualLite SystemOnChip in RecoveryMode" },
    { 0x15a2006a, "Vybrid series SystemOnChip in RecoveryMode" },
    { 0x15a20076, "i.MX 7Solo/7Dual SystemOnChip in RecoveryMode" },
    { 0x15a20080, "i.MX 6ULL SystemOnChip in RecoveryMode" },
    { 0x15a41000, "AF9015/AF9035 DVB-T stick" },
    { 0x15a41001, "AF9015/AF9035 DVB-T stick" },
    { 0x15a41336, "SDHC/MicroSD/MMC/MS/M2/CF/XD Flash Card Reader" },
    { 0x15a49015, "AF9015 DVB-T USB2.0 stick" },
    { 0x15a49016, "AF9015 DVB-T USB2.0 stick" },
    { 0x15a90002, "SparkLAN WL-682 802.11bg Wireless Adapter [Intersil ISL3887]" },
    { 0x15a90004, "WUBR-177G [Ralink RT2571W]" },
    { 0x15a90006, "Wireless 11n USB Adapter" },
    { 0x15a90010, "802.11n USB Wireless Card" },
    { 0x15a90012, "WUBR-208N 802.11abgn Wireless Adapter [Ralink RT2870]" },
    { 0x15a9002d, "WLTUBA-107 [Yota 4G LTE]" },
    { 0x15ba0003, "OpenOCD JTAG" },
    { 0x15ba0004, "OpenOCD JTAG TINY" },
    { 0x15ba002a, "ARM-USB-TINY-H JTAG interface" },
    { 0x15ba002b, "ARM-USB-OCD-H JTAG+RS232" },
    { 0x15ba003c, "TERES Keyboard+Touchpad" },
    { 0x15c00001, "2M pixel Microscope Camera" },
    { 0x15c00002, "3M pixel Microscope Camera" },
    { 0x15c00003, "1.3M pixel Microscope Camera (mono)" },
    { 0x15c00004, "1.3M pixel Microscope Camera (colour)" },
    { 0x15c00005, "3M pixel Microscope Camera (Mk 2)" },
    { 0x15c00006, "2M pixel Microscope Camera (with capture button)" },
    { 0x15c00007, "3M pixel Microscope Camera (with capture button)" },
    { 0x15c00008, "1.3M pixel Microscope Camera (colour, with capture button)" },
    { 0x15c00009, "1.3M pixel Microscope Camera (colour, with capture button)" },
    { 0x15c0000a, "2M pixel Microscope Camera (Mk 2)" },
    { 0x15c00010, "1.3M pixel \"Tinycam\"" },
    { 0x15c00101, "3M pixel Microscope Camera" },
    { 0x15c20036, "LC16M VFD Display/IR Receiver" },
    { 0x15c20038, "GD01 MX LCD Display/IR Receiver" },
    { 0x15c20042, "Antec Veris Multimedia Station E-Z IR Receiver" },
    { 0x15c2ffda, "iMON PAD Remote Controller" },
    { 0x15c2ffdc, "iMON PAD Remote Controller" },
    { 0x15c50008, "WL532U 802.11g Adapter" },
    { 0x15c61000, "DigistimSP (cold)" },
    { 0x15c61001, "DigistimSP (warm)" },
    { 0x15c61002, "DigimapSP USB (cold)" },
    { 0x15c61003, "DigimapSP USB (warm)" },
    { 0x15c61004, "DigistimSP (cold)" },
    { 0x15c61005, "DigistimSP (warm)" },
    { 0x15c61100, "Odyssee (cold)" },
    { 0x15c61101, "Odyssee (warm)" },
    { 0x15c61200, "Digispy" },
    { 0x15c83201, "EVER EV-W100/EV-W250" },
    { 0x15ca00c3, "Mini Optical Mouse" },
    { 0x15ca0101, "MIDI Interface cable" },
    { 0x15ca1806, "MIDI Interface cable" },
    { 0x15d90a33, "Optical Mouse" },
    { 0x15d90a37, "Mouse" },
    { 0x15d90a41, "MI-2540D [Optical mouse]" },
    { 0x15d90a4c, "USB+PS/2 Optical Mouse" },
    { 0x15d90a4d, "Optical Mouse" },
    { 0x15d90a4e, "AM-5400 [Optical Mouse]" },
    { 0x15d90a4f, "Optical Mouse" },
    { 0x15e12007, "RSA SecurID (R) Authenticator" },
    { 0x15e40024, "Mixtrack" },
    { 0x15e4003c, "DJ2GO2 Touch" },
    { 0x15e40140, "ION VCR 2 PC / Video 2 PC" },
    { 0x15e43f00, "Power A Mini Pro Elite" },
    { 0x15e43f0a, "Airflo Wired Controller for Xbox 360" },
    { 0x15e43f10, "Batarang controller for Xbox 360" },
    { 0x15e89100, "NUB100 Ethernet [pegasus]" },
    { 0x15e89110, "10/100 USB Ethernet" },
    { 0x15e904ce, "MemoryFrame MF-570" },
    { 0x15e91968, "MemoryFrame MF-570" },
    { 0x15e91969, "Digital Frame" },
    { 0x15f40001, "HanfTek UMT-010 USB2.0 DVB-T (cold)" },
    { 0x15f40025, "HanfTek UMT-010 USB2.0 DVB-T (warm)" },
    { 0x15f40131, "Astrometa DVB-T/T2/C FM & DAB receiver [RTL2832P]" },
    { 0x15f40135, "Astrometa T2hybrid" },
    { 0x160410c0, "Dell Integrated Hub" },
    { 0x16048000, "US-428 Audio/Midi Controller (without fw)" },
    { 0x16048001, "US-428 Audio/Midi Controller" },
    { 0x16048004, "US-224 Audio/Midi Controller (without fw)" },
    { 0x16048005, "US-224 Audio/Midi Controller" },
    { 0x16048006, "US-122 Audio/Midi Interface (without fw)" },
    { 0x16048007, "US-122 Audio/Midi Interface" },
    { 0x16050001, "DIO-32 (No Firmware Yet)" },
    { 0x16050002, "USB-DIO-48 (No Firmware Yet)" },
    { 0x16050003, "USB-DIO-96 (No Firmware Yet)" },
    { 0x16050004, "USB-DIO-32I (No Firmware Yet)" },
    { 0x16050005, "USB-DIO24 (based on -CTR6) (No Firmware Yet)" },
    { 0x16050006, "USB-DIO24-CTR6 (No Firmware Yet)" },
    { 0x16060002, "Astra 1236U Scanner" },
    { 0x16060010, "Astra 1220U" },
    { 0x16060030, "Astra 1600U/2000U" },
    { 0x16060050, "Scanner" },
    { 0x16060060, "Astra 3400/3450" },
    { 0x16060070, "Astra 4400/4450" },
    { 0x16060130, "Astra 2100U" },
    { 0x16060160, "Astra 5400U" },
    { 0x16060170, "Uniscan D50" },
    { 0x16060230, "Astra 2200/2200SU" },
    { 0x16060350, "Astra 4800/4850 Scanner" },
    { 0x16061030, "Astra 4000U" },
    { 0x16061220, "Genesys Logic Scanner Controller NT5.0" },
    { 0x16062010, "AstraCam Digital Camera" },
    { 0x16062020, "AstraCam 1000" },
    { 0x16062030, "AstraCam 1800 Digital Camera" },
    { 0x16080001, "EdgePort/4 Serial Port" },
    { 0x16080002, "Edgeport/8" },
    { 0x16080003, "Rapidport/4" },
    { 0x16080004, "Edgeport/4" },
    { 0x16080005, "Edgeport/2" },
    { 0x16080006, "Edgeport/4i" },
    { 0x16080007, "Edgeport/2i" },
    { 0x16080008, "Edgeport/8" },
    { 0x1608000c, "Edgeport/421" },
    { 0x1608000d, "Edgeport/21" },
    { 0x1608000e, "Edgeport/4" },
    { 0x1608000f, "Edgeport/8" },
    { 0x16080010, "Edgeport/2" },
    { 0x16080011, "Edgeport/4" },
    { 0x16080012, "Edgeport/416" },
    { 0x16080014, "Edgeport/8i" },
    { 0x16080018, "Edgeport/412" },
    { 0x16080019, "Edgeport/412" },
    { 0x1608001a, "Edgeport/2+2i" },
    { 0x16080101, "Edgeport/4" },
    { 0x16080105, "Edgeport/2" },
    { 0x16080106, "Edgeport/4i" },
    { 0x16080107, "Edgeport/2i" },
    { 0x1608010c, "Edgeport/421" },
    { 0x1608010d, "Edgeport/21" },
    { 0x16080110, "Edgeport/2" },
    { 0x16080111, "Edgeport/4" },
    { 0x16080112, "Edgeport/416" },
    { 0x16080114, "Edgeport/8i" },
    { 0x16080201, "Edgeport/4" },
    { 0x16080203, "Rapidport/4" },
    { 0x16080204, "Edgeport/4" },
    { 0x16080205, "Edgeport/2" },
    { 0x16080206, "Edgeport/4i" },
    { 0x16080207, "Edgeport/2i" },
    { 0x1608020c, "Edgeport/421" },
    { 0x1608020d, "Edgeport/21" },
    { 0x1608020e, "Edgeport/4" },
    { 0x1608020f, "Edgeport/8" },
    { 0x16080210, "Edgeport/2" },
    { 0x16080211, "Edgeport/4" },
    { 0x16080212, "Edgeport/416" },
    { 0x16080214, "Edgeport/8i" },
    { 0x16080215, "Edgeport/1" },
    { 0x16080216, "EPOS/44" },
    { 0x16080217, "Edgeport/42" },
    { 0x1608021a, "Edgeport/2+2i" },
    { 0x1608021b, "Edgeport/2c" },
    { 0x1608021c, "Edgeport/221c" },
    { 0x1608021d, "Edgeport/22c" },
    { 0x1608021e, "Edgeport/21c" },
    { 0x1608021f, "Edgeport/62" },
    { 0x16080240, "Edgeport/1" },
    { 0x16080241, "Edgeport/1i" },
    { 0x16080242, "Edgeport/4s" },
    { 0x16080243, "Edgeport/8s" },
    { 0x16080244, "Edgeport/8" },
    { 0x16080245, "Edgeport/22c" },
    { 0x16080301, "Watchport/P" },
    { 0x16080302, "Watchport/M" },
    { 0x16080303, "Watchport/W" },
    { 0x16080304, "Watchport/T" },
    { 0x16080305, "Watchport/H" },
    { 0x16080306, "Watchport/E" },
    { 0x16080307, "Watchport/L" },
    { 0x16080308, "Watchport/R" },
    { 0x16080309, "Watchport/A" },
    { 0x1608030a, "Watchport/D" },
    { 0x1608030b, "Watchport/D" },
    { 0x1608030c, "Power Management Port" },
    { 0x1608030e, "Power Management Port" },
    { 0x1608030f, "Watchport/G" },
    { 0x16080310, "Watchport/Tc" },
    { 0x16080311, "Watchport/Hc" },
    { 0x16081403, "MultiTech Systems MT4X56 Modem" },
    { 0x16081a17, "Agilent Technologies (E6473)" },
    { 0x160a3184, "VIA VNT-6656 [WiFi 802.11b/g USB Dongle]" },
    { 0x160e0001, "E2USBKey" },
    { 0x16140404, "WMA9109 UMTS Phone" },
    { 0x16140600, "Vodafone VDA GPS / Toschiba Protege G710" },
    { 0x16140804, "WP-S1 Phone" },
    { 0x16172002, "NVX-P1 Personal Navigation System" },
    { 0x161c0002, "DTC-02U [Digi Touch Controller]" },
    { 0x16300005, "802.11g Wireless Adapter [Intersil ISL3886]" },
    { 0x16300011, "PC Port 10 Mps Adapter" },
    { 0x1630ff81, "802.11b Wireless Adapter [Lucent/Agere Hermes I]" },
    { 0x16316200, "GWUSB2E" },
    { 0x1631c019, "RT2573" },
    { 0x16334510, "ASC1553" },
    { 0x16334520, "ASC429" },
    { 0x16334560, "ASC-FDX" },
    { 0x16450001, "1S Serial Port" },
    { 0x16450002, "2S Serial Port" },
    { 0x16450003, "1S25 Serial Port" },
    { 0x16450004, "4S Serial Port" },
    { 0x16450005, "E45 Ethernet [klsi]" },
    { 0x16450006, "Parallel Port" },
    { 0x16450007, "U1-SC25 SCSI" },
    { 0x16450008, "Ethernet" },
    { 0x16450016, "Bi-directional to Parallel Printer Converter" },
    { 0x16450080, "1 port to Serial Converter" },
    { 0x16450081, "1 port to Serial Converter" },
    { 0x16450093, "1S9 Serial Port" },
    { 0x16458000, "EZ-USB" },
    { 0x16458001, "1 port to Serial" },
    { 0x16458002, "2x Serial Port" },
    { 0x16458003, "1 port to Serial" },
    { 0x16458004, "2U4S serial/usb hub" },
    { 0x16458005, "Ethernet" },
    { 0x16458080, "1 port to Serial" },
    { 0x16458081, "1 port to Serial" },
    { 0x16458093, "PortGear Serial Port" },
    { 0x16490102, "uDART In-Circuit Debugger" },
    { 0x16490200, "SpYder USBSPYDER08" },
    { 0x164c0101, "mvBlueFOX camera (no firmware)" },
    { 0x164c0103, "mvBlueFOX camera" },
    { 0x164c0201, "mvBlueLYNX-X intelligent camera (bootloader)" },
    { 0x164c0203, "mvBlueLYNX-X intelligent camera" },
    { 0x16573150, "SIS3150 USB2.0 to VME interface" },
    { 0x165b8101, "Tranzport Control Surface" },
    { 0x165bfad1, "Alphatrack Control Surface" },
    { 0x165c0002, "Serial Adapter" },
    { 0x165c0006, "FT232 [ICS adapter HS]" },
    { 0x165c0008, "FT232 [Dual adapter HS]" },
    { 0x16670005, "PCR330A RFID Reader (125 kHz, keyboard emulation)" },
    { 0x16680009, "Gateway" },
    { 0x16680333, "Modem" },
    { 0x16680358, "InternetPhoneWizard" },
    { 0x16680405, "Gateway" },
    { 0x16680408, "Prism2.5 802.11b Adapter" },
    { 0x16680413, "Gateway" },
    { 0x16680421, "Prism2.5 802.11b Adapter" },
    { 0x16680441, "IBM Integrated Bluetooth II" },
    { 0x16680500, "BTM200B BlueTooth Adapter" },
    { 0x16681050, "802UIG-1 802.11g Wireless Mini Adapter [Intersil ISL3887]" },
    { 0x16681200, "802AIN Wireless N Network Adapter [Atheros AR9170+AR9101]" },
    { 0x16681441, "IBM Integrated Bluetooth II" },
    { 0x16682441, "BMDC-2 IBM Bluetooth III w.56k" },
    { 0x16683441, "IBM Integrated Bluetooth III" },
    { 0x16686010, "Gateway" },
    { 0x16686097, "802.11b Wireless Adapter" },
    { 0x16686106, "802UI3(B) 802.11b Wireless Adapter [Intersil PRISM 3]" },
    { 0x16687605, "UAT1 Wireless Ethernet Adapter" },
    { 0x16691001, "uLan2USB Converter - PS1 protocol" },
    { 0x166a0101, "C-Bus Multi-room Audio Matrix Switcher" },
    { 0x166a0201, "C-Bus Pascal Automation Controller" },
    { 0x166a0301, "C-Bus Wireless PC Interface" },
    { 0x166a0303, "C-Bus interface" },
    { 0x166a0304, "C-Bus Black and White Touchscreen" },
    { 0x166a0305, "C-Bus Spectrum Colour Touchscreen" },
    { 0x166a0401, "C-Bus Architectural Dimmer" },
    { 0x16770103, "Token" },
    { 0x16792001, "Beagle Protocol Analyzer" },
    { 0x16792002, "Cheetah SPI Host Adapter" },
    { 0x167b2009, "Flip Ultra U1120" },
    { 0x1680a332, "DVB-T Dongle [RTL2832U]" },
    { 0x16810001, "Tuner's Dashboard" },
    { 0x16810002, "DocuBrain(R) Tubachron" },
    { 0x16810003, "DocuBrain(R) I2C" },
    { 0x16810004, "DocuBrain(R) WWVB Receiver" },
    { 0x16810005, "DocuBrain(R) WWVB Transmitter" },
    { 0x16850200, "Infrared adapter" },
    { 0x16860045, "Handy Recorder stereo mix" },
    { 0x168601c0, "Zoom Handy Recorder card reader" },
    { 0x168601c5, "Zoom Handy Recorder multi track" },
    { 0x168603d5, "LiveTrak L-12" },
    { 0x16875289, "FlashDisk" },
    { 0x16876211, "FlashDisk" },
    { 0x16876213, "FlashDisk" },
    { 0x1689fd00, "Onza Tournament Edition controller" },
    { 0x1689fd01, "Onza Classic Edition" },
    { 0x1689fe00, "Sabertooth Elite" },
    { 0x168c0001, "AR5523" },
    { 0x168c0002, "AR5523 (no firmware)" },
    { 0x16900001, "Arcaze Gamepad" },
    { 0x16900101, "Creative Modem Blaster DE5670" },
    { 0x16900102, "V1456 VQE-R2 Modem [conexant]" },
    { 0x16900103, "1456 VQE-R3 Modem [conexant]" },
    { 0x16900104, "HCF V90 Data Fax RTAD Modem" },
    { 0x16900107, "HCF V.90 Data,Fax,RTAD Modem" },
    { 0x16900109, "MagicXpress V.90 Pocket Modem [conexant]" },
    { 0x16900203, "Voyager ADSL Modem Loader" },
    { 0x16900204, "Voyager ADSL Modem" },
    { 0x16900205, "DSL Modem" },
    { 0x16900206, "GlobeSpan ADSL WAN Modem" },
    { 0x16900208, "DSL Modem" },
    { 0x16900209, "Voyager 100 ADSL Modem" },
    { 0x16900211, "Globespan Virata ADSL LAN Modem" },
    { 0x16900212, "DSL Modem" },
    { 0x16900213, "HM121d DSL Modem" },
    { 0x16900214, "HM121d DSL Modem" },
    { 0x16900215, "Voyager 105 ADSL Modem" },
    { 0x16900701, "WLAN" },
    { 0x16900710, "SMCWUSBT-G" },
    { 0x16900711, "SMCWUSBT-G (no firmware)" },
    { 0x16900712, "AR5523" },
    { 0x16900713, "AR5523 (no firmware)" },
    { 0x16900715, "Name: Voyager 1055 Laptop 802.11g Adapter [Broadcom 4320]" },
    { 0x16900722, "RT2573" },
    { 0x16900726, "Wi-Fi Wireless LAN Adapter" },
    { 0x16900740, "802.11n Wireless LAN Card" },
    { 0x16900901, "Voyager 205 ADSL Router" },
    { 0x16902000, "naturaSign Pad Standard" },
    { 0x16902001, "naturaSign Pad Standard" },
    { 0x1690fe12, "Bootloader" },
    { 0x16a63000, "VTG-3xxx Video Test Generator family" },
    { 0x16a64000, "VTG-4xxx Video Test Generator family" },
    { 0x16a65000, "VTG-5xxx Video Test Generator family" },
    { 0x16a65001, "VTG-5xxx Special (update) mode of VTG-5xxx family" },
    { 0x16ab7801, "AR5523" },
    { 0x16ab7802, "AR5523 (no firmware)" },
    { 0x16ab7811, "AR5523" },
    { 0x16ab7812, "AR5523 (no firmware)" },
    { 0x16b40801, "U43" },
    { 0x16b50002, "Otto driving companion" },
    { 0x16c003e8, "free for internal lab use 1000" },
    { 0x16c003e9, "free for internal lab use 1001" },
    { 0x16c003ea, "free for internal lab use 1002" },
    { 0x16c003eb, "free for internal lab use 1003" },
    { 0x16c003ec, "free for internal lab use 1004" },
    { 0x16c003ed, "free for internal lab use 1005" },
    { 0x16c003ee, "free for internal lab use 1006" },
    { 0x16c003ef, "free for internal lab use 1007" },
    { 0x16c003f0, "free for internal lab use 1008" },
    { 0x16c003f1, "free for internal lab use 1009" },
    { 0x16c00477, "Teensy Rebootor" },
    { 0x16c00478, "Teensy Halfkay Bootloader" },
    { 0x16c00479, "Teensy Debug" },
    { 0x16c0047a, "Teensy Serial" },
    { 0x16c0047b, "Teensy Serial+Debug" },
    { 0x16c0047c, "Teensy Keyboard" },
    { 0x16c0047d, "Teensy Keyboard+Debug" },
    { 0x16c0047e, "Teensy Mouse" },
    { 0x16c0047f, "Teensy Mouse+Debug" },
    { 0x16c00480, "Teensy RawHID" },
    { 0x16c00481, "Teensy RawHID+Debug" },
    { 0x16c00482, "Teensyduino Keyboard+Mouse+Joystick" },
    { 0x16c00483, "Teensyduino Serial" },
    { 0x16c00484, "Teensyduino Disk" },
    { 0x16c00485, "Teensyduino MIDI" },
    { 0x16c00486, "Teensyduino RawHID" },
    { 0x16c00487, "Teensyduino Serial+Keyboard+Mouse+Joystick" },
    { 0x16c00488, "Teensyduino Flight Sim Controls" },
    { 0x16c005b5, "BU0836" },
    { 0x16c005dc, "shared ID for use with libusb" },
    { 0x16c005dd, "BlackcatUSB2" },
    { 0x16c005de, "Flashcat" },
    { 0x16c005df, "HID device except mice, keyboards, and joysticks" },
    { 0x16c005e1, "Free shared USB VID/PID pair for CDC devices" },
    { 0x16c005e4, "Free shared USB VID/PID pair for MIDI devices" },
    { 0x16c006b4, "USB2LPT with 2 interfaces" },
    { 0x16c006b5, "USB2LPT with 3 interfaces (native, HID, printer)" },
    { 0x16c0074e, "DSP-Weuffen USB-HPI-Programmer" },
    { 0x16c0074f, "DSP-Weuffen USB2-HPI-Programmer" },
    { 0x16c00762, "Osmocom SIMtrace" },
    { 0x16c0076b, "OpenPCD 13.56MHz RFID Reader" },
    { 0x16c0076c, "OpenPICC 13.56MHz RFID Simulator (native)" },
    { 0x16c008ac, "OpenBeacon USB stick" },
    { 0x16c008ca, "Alpermann+Velte Universal Display" },
    { 0x16c008cb, "Alpermann+Velte Studio Clock" },
    { 0x16c008cc, "Alpermann+Velte SAM7S MT Boot Loader" },
    { 0x16c008cd, "Alpermann+Velte SAM7X MT Boot Loader" },
    { 0x16c009ce, "LINKUSB" },
    { 0x16c00a32, "jbmedia Light-Manager Pro" },
    { 0x16c027d8, "libusb-bound devices" },
    { 0x16c027d9, "HID device except mice, keyboards, and joysticks" },
    { 0x16c027da, "Mouse" },
    { 0x16c027db, "Keyboard" },
    { 0x16c027dc, "Joystick" },
    { 0x16c027dd, "CDC-ACM class devices (modems)" },
    { 0x16c027de, "MIDI class devices" },
    { 0x16c0294a, "Eye Movement Recorder [Visagraph]" },
    { 0x16c0294b, "Eye Movement Recorder [ReadAlyzer]" },
    { 0x16ca1502, "Bluetooth Dongle" },
    { 0x16d00436, "Xylanta Ltd, XSP Device" },
    { 0x16d00498, "Braintechnology USB-LPS" },
    { 0x16d00504, "RETRO Innovations ZoomFloppy" },
    { 0x16d0054b, "GrauTec ReelBox OLED Display (external)" },
    { 0x16d005be, "EasyLogic Board" },
    { 0x16d005f0, "Superior Freedom Programmable IR Remote" },
    { 0x16d006cc, "Trinamic TMCM-3110" },
    { 0x16d006f0, "Axium AX-R4C Controller" },
    { 0x16d006f1, "Axium AX-R1D Controller" },
    { 0x16d006f9, "Gabotronics Xminilab" },
    { 0x16d00726, "Autonomic M400 Amplifier" },
    { 0x16d00727, "Autonomic M800 Amplifier" },
    { 0x16d00753, "Digistump DigiSpark" },
    { 0x16d0075c, "AB-1.x UAC1 [Audio Widget]" },
    { 0x16d0075d, "AB-1.x UAC2 [Audio Widget]" },
    { 0x16d007cc, "Xylanta Ltd, Saint3 Device" },
    { 0x16d007f8, "Axium AX-R4D Controller" },
    { 0x16d0080a, "S2E1 Interface" },
    { 0x16d00830, "DMXControl Projects e.V., Nodle U1" },
    { 0x16d00831, "DMXControl Projects e.V., Desklamp" },
    { 0x16d00832, "DMXControl Projects e.V., Nodle U2" },
    { 0x16d00833, "DMXControl Projects e.V., Nodle R4S" },
    { 0x16d00870, "Kaufmann Automotive GmbH, RKS+CAN Interface" },
    { 0x16d009f2, "Axium AX-1250 Amplifier" },
    { 0x16d009f4, "Axium AX-Mini4 Amplifier" },
    { 0x16d00b03, "AIS Receiver [dAISy]" },
    { 0x16d00b7d, "Autonomic M801 Amplifier" },
    { 0x16d00b7e, "Autonomic M401 Amplifier" },
    { 0x16d00b7f, "Autonomic M120e Amplifier" },
    { 0x16d00bd4, "codesrc SCSI2SD" },
    { 0x16d00c9b, "Fermium LABS srl/LabTrek srl Hall Effect Apparatus" },
    { 0x16d00d3c, "InputStick BT4.0" },
    { 0x16d00e1e, "AtomMiner" },
    { 0x16d10401, "SUP-SFR400(A) BioMini Fingerprint Reader" },
    { 0x16d56202, "CDMA/UMTS/GPRS modem" },
    { 0x16d56501, "CDMA 2000 1xRTT/EV-DO Modem" },
    { 0x16d56502, "CDMA/UMTS/GPRS modem" },
    { 0x16d56603, "ADU-890WH modem" },
    { 0x16d68000, "GDP-04 desktop phone" },
    { 0x16d68001, "EYE-02" },
    { 0x16d68003, "GDP-04 modem" },
    { 0x16d68004, "Bootloader" },
    { 0x16d68005, "GDP-04i" },
    { 0x16d68007, "BTP-06 modem" },
    { 0x16d85141, "CMOTECH CDMA Technologies modem" },
    { 0x16d85533, "CCU-550 CDMA EV-DO modem" },
    { 0x16d85543, "CDMA 2000 1xRTT/1xEVDO modem" },
    { 0x16d86280, "CMOTECH CDMA Technologies modem" },
    { 0x16d86803, "CNU-680 CDMA EV-DO modem" },
    { 0x16d88001, "Gobi 2000 Wireless Modem (QDL mode)" },
    { 0x16d88002, "Gobi 2000 Wireless Modem" },
    { 0x16dc0001, "CC" },
    { 0x16dc000b, "VM" },
    { 0x16dc0010, "PL512 Power Supply System" },
    { 0x16dc0011, "MARATON Power Supply System" },
    { 0x16dc0012, "MPOD Multi Channel Power Supply System" },
    { 0x16dc0015, "CML Control, Measurement and Data Logging System" },
    { 0x16f00001, "Speedlink Programming Interface" },
    { 0x16f00003, "Airlink Wireless Programming Interface" },
    { 0x16f00004, "Accessory Programming Interface" },
    { 0x17020002, "Encodeur" },
    { 0x17030001, "NormSoft, Inc. Pocket Tunes" },
    { 0x17030002, "NormSoft, Inc. Pocket Tunes 4" },
    { 0x170b0011, "MIDI-USB 1x1" },
    { 0x17110101, "DFC-365FX camera" },
    { 0x17113020, "IC80 HD Camera" },
    { 0x17240115, "PAXcam5" },
    { 0x17261000, "wireless modem" },
    { 0x17262000, "wireless modem" },
    { 0x17263000, "wireless modem" },
    { 0x172f0022, "Tablet" },
    { 0x172f0024, "Tablet" },
    { 0x172f0025, "Tablet" },
    { 0x172f0026, "Tablet" },
    { 0x172f0031, "Slim Tablet 12.1\"" },
    { 0x172f0032, "Slim Tablet 5.8\"" },
    { 0x172f0034, "Slim Tablet 12.1\"" },
    { 0x172f0038, "Genius G-Pen F509" },
    { 0x172f0500, "Media Tablet 14.1\"" },
    { 0x172f0501, "Media Tablet 10.6\"" },
    { 0x172f0502, "Sirius Battery Free Tablet" },
    { 0x17330101, "RF Wireless Optical Mouse OP-701" },
    { 0x17370039, "USB1000 Gigabit Notebook Adapter" },
    { 0x17370070, "WUSB100 v1 RangePlus Wireless Network Adapter [Ralink RT2870]" },
    { 0x17370071, "WUSB600N v1 Dual-Band Wireless-N Network Adapter [Ralink RT2870]" },
    { 0x17370073, "WUSB54GC v2 802.11g Adapter [Realtek RTL8187B]" },
    { 0x17370075, "WUSB54GSC v2 802.11g Adapter [Broadcom 4326U]" },
    { 0x17370077, "WUSB54GC v3 802.11g Adapter [Ralink RT2070L]" },
    { 0x17370078, "WUSB100 v2 RangePlus Wireless Network Adapter [Ralink RT3070]" },
    { 0x17370079, "WUSB600N v2 Dual-Band Wireless-N Network Adapter [Ralink RT3572]" },
    { 0x173a2198, "Accu-Chek Mobile" },
    { 0x173a21ca, "ACCU-CHEK Mobile Model U1" },
    { 0x173d0002, "GP-K7000 keyboard" },
    { 0x17400100, "EUB1200AC AC1200 DB Wireless Adapter [Realtek RTL8812AU]" },
    { 0x17400600, "EUB600v1 802.11abgn Wireless Adapter [Ralink RT3572]" },
    { 0x17400605, "LevelOne WUA-0605 N_Max Wireless USB Adapter" },
    { 0x17400615, "LevelOne WUA-0615 N_Max Wireless USB Adapter" },
    { 0x17401000, "NUB-350 802.11g Wireless Adapter [Intersil ISL3887]" },
    { 0x17402000, "NUB-8301 802.11bg" },
    { 0x17403701, "EUB-3701 EXT 802.11g Wireless Adapter [Ralink RT2571W]" },
    { 0x17409603, "RTL8188S WLAN Adapter" },
    { 0x17409701, "EnGenius 802.11n Wireless USB Adapter" },
    { 0x17409702, "EnGenius 802.11n Wireless USB Adapter" },
    { 0x17409703, "EnGenius 802.11n Wireless USB Adapter" },
    { 0x17409705, "EnGenius 802.11n Wireless USB Adapter" },
    { 0x17409706, "EUB9706 802.11n Wireless Adapter [Ralink RT3072]" },
    { 0x17409801, "EUB9801 802.11abgn Wireless Adapter [Ralink RT3572]" },
    { 0x17480101, "Packet-Master USB12" },
    { 0x174c07d1, "Transcend ESD400 Portable SSD (USB 3.0)" },
    { 0x174c1151, "ASM1151W" },
    { 0x174c1153, "ASM1153 SATA 3Gb/s bridge" },
    { 0x174c2074, "ASM1074 High-Speed hub" },
    { 0x174c3074, "ASM1074 SuperSpeed hub" },
    { 0x174c5106, "ASM1051 SATA 3Gb/s bridge" },
    { 0x174c5136, "ASM1053 SATA 3Gb/s bridge" },
    { 0x174c51d6, "ASM1051W SATA 3Gb/s bridge" },
    { 0x174c55aa, "ASM1051E SATA 6Gb/s bridge, ASM1053E SATA 6Gb/s bridge, ASM1153 SATA 3Gb/s bridge, ASM1153E SATA 6Gb/s bridge" },
    { 0x174f1105, "SM-MS/Pro-MMC-XD Card Reader" },
    { 0x174f110b, "HP Webcam" },
    { 0x174f1122, "HP Webcam" },
    { 0x174f1169, "Lenovo EasyCamera" },
    { 0x174f1403, "Integrated Webcam" },
    { 0x174f1404, "USB Camera device, 1.3 MPixel Web Cam" },
    { 0x174f1758, "XYZ printing cameraR2" },
    { 0x174f1759, "XYZ printing cameraL2" },
    { 0x174f5212, "USB 2.0 UVC PC Camera" },
    { 0x174f5a11, "PC Camera" },
    { 0x174f5a31, "Sonix USB 2.0 Camera" },
    { 0x174f5a35, "Sonix 1.3MPixel USB 2.0 Camera" },
    { 0x174f6a31, "Web Cam - Asus A8J, F3S, F5R, VX2S, V1S" },
    { 0x174f6a33, "Web Cam - Asus F3SA, F9J, F9S" },
    { 0x174f6a51, "2.0MPixel Web Cam - Asus Z96J, Z96S, S96S" },
    { 0x174f6a54, "Web Cam" },
    { 0x174f6d51, "2.0Mpixel Web Cam - Eurocom D900C" },
    { 0x174f8a12, "Syntek 0.3MPixel USB 2.0 UVC PC Camera" },
    { 0x174f8a33, "Syntek USB 2.0 UVC PC Camera" },
    { 0x174fa311, "1.3MPixel Web Cam - Asus A3A, A6J, A6K, A6M, A6R, A6T, A6V, A7T, A7sv, A7U" },
    { 0x174fa312, "1.3MPixel Web Cam" },
    { 0x174fa821, "Web Cam - Packard Bell BU45, PB Easynote MX66-208W" },
    { 0x174faa11, "Web Cam" },
    { 0x1753c901, "PPC900 Pinpad Terminal" },
    { 0x17560006, "DiviPitch" },
    { 0x17610b05, "802.11n Network Adapter (wrong ID - swapped vendor and device)" },
    { 0x1770ff00, "steel series rgb keyboard" },
    { 0x1776501c, "300K CMOS Camera" },
    { 0x17770003, "MicroHAWK ID-20" },
    { 0x177f0004, "MM004V5 Photo Key Chain (Digital Photo Frame) 1.5\"" },
    { 0x177f0153, "LW153 802.11n Adapter [ralink rt3070]" },
    { 0x177f0154, "LW154 802.11bgn (1x1:1) Wireless Adapter [Realtek RTL8188SU]" },
    { 0x177f0313, "LW313 802.11n Adapter [ralink rt2770 + rt2720]" },
    { 0x178107df, "Axium AX-800DAV Amplifier" },
    { 0x178107e1, "Axium AX-KPC Keypad" },
    { 0x178107e2, "Axium AX-KPD Keypad" },
    { 0x178107e3, "Axium AX-400DA Amplifier" },
    { 0x1781083e, "MetaGeek Wi-Spy" },
    { 0x1781083f, "MetaGeek Wi-Spy 2.4x" },
    { 0x17810938, "Iguanaworks USB IR Transceiver" },
    { 0x17810941, "qNimble Quark" },
    { 0x17810a96, "raphnet.net usb_game12" },
    { 0x17810a97, "raphnet.net SNES mouse adapter" },
    { 0x17810a98, "raphnet.net USBTenki" },
    { 0x17810a99, "raphnet.net NES" },
    { 0x17810a9a, "raphnet.net Gamecube/N64 controller" },
    { 0x17810a9b, "raphnet.net DB9Joy" },
    { 0x17810a9c, "raphnet.net Intellivision" },
    { 0x17810a9d, "raphnet.net 4nes4snes" },
    { 0x17810a9e, "raphnet.net Megadrive multitap" },
    { 0x17810a9f, "raphnet.net MultiDB9joy" },
    { 0x17810bad, "Mantracourt Load Cell" },
    { 0x17810c30, "Telldus TellStick" },
    { 0x17810c31, "Telldus TellStick Duo" },
    { 0x17810c9f, "USBtiny" },
    { 0x17811eef, "OpenAPC SecuKey" },
    { 0x17811ef0, "E1701 Modular Controller Card" },
    { 0x17811ef1, "E1701 Modular Controller Card" },
    { 0x17811ef2, "E1803 Compact Controller Card" },
    { 0x17823d00, "F200n mobile phone" },
    { 0x17840001, "eHome Infrared Transceiver" },
    { 0x17840004, "RF Combo Device" },
    { 0x17840006, "eHome Infrared Transceiver" },
    { 0x17840007, "eHome Infrared Transceiver" },
    { 0x17840008, "eHome Infrared Transceiver" },
    { 0x1784000a, "eHome Infrared Transceiver" },
    { 0x17840011, "eHome Infrared Transceiver" },
    { 0x178e0b05, "CrossLink cable 2GB (wrong ID - swapped vendor and device)" },
    { 0x17997051, "Belkin F5D7051 802.11g Adapter v1000 [Broadcom 4320]" },
    { 0x17998051, "Belkin F5D8051 v2 802.11bgn Wireless Adapter [Marvell 88W8362]" },
    { 0x179d0010, "Internal Infrared Transceiver" },
    { 0x17a00001, "C01U condenser microphone" },
    { 0x17a00002, "Q1U dynamic microphone" },
    { 0x17a00100, "C03U multi-pattern microphone" },
    { 0x17a00101, "UB1 boundary microphone" },
    { 0x17a00120, "Meteorite condenser microphone" },
    { 0x17a00130, "Go Mic Direct" },
    { 0x17a00132, "Go Mic Mobile wireless receiver" },
    { 0x17a00200, "StudioDock monitors (internal hub)" },
    { 0x17a00201, "StudioDock monitors (audio)" },
    { 0x17a00210, "StudioGT monitors" },
    { 0x17a00211, "StudioGT monitors [CM6400]" },
    { 0x17a00240, "Go Mic Connect" },
    { 0x17a00241, "G-Track Pro microphone" },
    { 0x17a00301, "Q2U handheld microphone with XLR" },
    { 0x17a00302, "GoMic compact condenser microphone" },
    { 0x17a00303, "C01U Pro condenser microphone" },
    { 0x17a00304, "Q2U handheld mic with XLR" },
    { 0x17a00305, "GoMic compact condenser mic" },
    { 0x17a00310, "Meteor condenser microphone" },
    { 0x17a00311, "Satellite condenser microphone" },
    { 0x17a01616, "RXD1 wireless receiver" },
    { 0x17a0b241, "G-Track Pro firmware update" },
    { 0x17a0b311, "Satellite firmware update" },
    { 0x17a40001, "Performance Monitor 3" },
    { 0x17a40002, "Performance Monitor 4" },
    { 0x17a80001, "Optical Eye/3-wire" },
    { 0x17a80005, "M-Bus Master MultiPort 250D" },
    { 0x17a80010, "444MHz Radio Mesh Frontend" },
    { 0x17a80011, "444MHz RF sniffer" },
    { 0x17a80012, "870MHz Radio Mesh Frontend" },
    { 0x17a80013, "870MHz RF sniffer" },
    { 0x17b30004, "Linux-USB Midi Gadget" },
    { 0x17b50010, "MFT Sensor" },
    { 0x17ba0001, "SAU510-USB [no firmware]" },
    { 0x17ba0510, "SAU510-USB and SAU510-USB plus JTAG Emulators" },
    { 0x17ba0511, "SAU510-USB Iso Plus JTAG Emulator" },
    { 0x17ba0520, "SAU510-USB Nano JTAG Emulator" },
    { 0x17ba1511, "Onboard Emulator on SAUModule development kit" },
    { 0x17cc041c, "Audio 2 DJ" },
    { 0x17cc041d, "Traktor Audio 2" },
    { 0x17cc0808, "Maschine Controller" },
    { 0x17cc0815, "Audio Kontrol 1" },
    { 0x17cc0839, "Audio 4 DJ" },
    { 0x17cc0d8d, "Guitarrig Mobile" },
    { 0x17cc1001, "Komplete Audio 6" },
    { 0x17cc1110, "Maschine Mikro" },
    { 0x17cc1915, "Session I/O" },
    { 0x17cc1940, "RigKontrol3" },
    { 0x17cc1969, "RigKontrol2" },
    { 0x17cc1978, "Audio 8 DJ" },
    { 0x17cc2280, "Medion MDPNA1500 in card reader mode" },
    { 0x17cc2305, "Traktor Kontrol X1" },
    { 0x17cc4711, "Kore Controller" },
    { 0x17cc4712, "Kore Controller 2" },
    { 0x17ccbaff, "Traktor Kontrol S4" },
    { 0x17e90051, "USB VGA Adaptor" },
    { 0x17e90198, "DisplayLink" },
    { 0x17e9019e, "Overfly FY-1016A" },
    { 0x17e9028f, "HIS Multi-View II" },
    { 0x17e9030b, "HP T100" },
    { 0x17e90377, "Plugable UD-160-A (M)" },
    { 0x17e90378, "Plugable UGA-2K-A" },
    { 0x17e90379, "Plugable UGA-125" },
    { 0x17e9037a, "Plugable UGA-165" },
    { 0x17e9037b, "Plugable USB-VGA-165" },
    { 0x17e9037c, "Plugable DC-125" },
    { 0x17e9037d, "Plugable USB2-HDMI-165" },
    { 0x17e9410a, "HDMI Adapter" },
    { 0x17e9430a, "HP Port Replicator (Composite Device)" },
    { 0x17e9430f, "Kensington Dock (Composite Device)" },
    { 0x17e94312, "S2340T" },
    { 0x17e9436e, "Dell D3100 Docking Station" },
    { 0x17e9ff10, "I1659FWUX {AOC Powered Monitor]" },
    { 0x17ef1000, "ThinkPad X6 UltraBase" },
    { 0x17ef1003, "Integrated Smart Card Reader" },
    { 0x17ef1004, "Integrated Webcam" },
    { 0x17ef1005, "ThinkPad X200 Ultrabase (42X4963 )" },
    { 0x17ef1008, "Hub" },
    { 0x17ef100a, "ThinkPad Mini Dock Plus Series 3" },
    { 0x17ef100f, "ThinkPad Ultra Dock Hub" },
    { 0x17ef1010, "ThinkPad Ultra Dock Hub" },
    { 0x17ef1020, "ThinkPad Dock Hub" },
    { 0x17ef1021, "ThinkPad Dock Hub [Cypress HX2VL]" },
    { 0x17ef3049, "ThinkPad OneLink integrated audio" },
    { 0x17ef304b, "AX88179 Gigabit Ethernet [ThinkPad OneLink GigaLAN]" },
    { 0x17ef304f, "RTL8153 Gigabit Ethernet [ThinkPad OneLink Pro Dock]" },
    { 0x17ef3060, "ThinkPad Dock" },
    { 0x17ef3062, "ThinkPad Dock Ethernet [Realtek RTL8153B]" },
    { 0x17ef3063, "ThinkPad Dock Audio" },
    { 0x17ef3066, "ThinkPad Thunderbolt 3 Dock MCU" },
    { 0x17ef3069, "ThinkPad TBT3 LAN" },
    { 0x17ef306a, "ThinkPad Thunderbolt 3 Dock Audio" },
    { 0x17ef3815, "ChipsBnk 2GB USB Stick" },
    { 0x17ef4802, "Vc0323+MI1310_SOC Camera" },
    { 0x17ef4807, "UVC Camera" },
    { 0x17ef480c, "Integrated Webcam" },
    { 0x17ef480d, "Integrated Webcam [R5U877]" },
    { 0x17ef480e, "Integrated Webcam [R5U877]" },
    { 0x17ef480f, "Integrated Webcam [R5U877]" },
    { 0x17ef4810, "Integrated Webcam [R5U877]" },
    { 0x17ef4811, "Integrated Webcam [R5U877]" },
    { 0x17ef4812, "Integrated Webcam [R5U877]" },
    { 0x17ef4813, "Integrated Webcam [R5U877]" },
    { 0x17ef4814, "Integrated Webcam [R5U877]" },
    { 0x17ef4815, "Integrated Webcam [R5U877]" },
    { 0x17ef4816, "Integrated Webcam" },
    { 0x17ef481c, "Integrated Webcam" },
    { 0x17ef481d, "Integrated Webcam" },
    { 0x17ef6004, "ISD-V4 Tablet Pen" },
    { 0x17ef6007, "Smartcard Keyboard" },
    { 0x17ef6009, "ThinkPad Keyboard with TrackPoint" },
    { 0x17ef600e, "Optical Mouse" },
    { 0x17ef6014, "Mini Wireless Keyboard N5901" },
    { 0x17ef6019, "M-U0025-O Mouse" },
    { 0x17ef6022, "Ultraslim Plus Wireless Keyboard and Mouse" },
    { 0x17ef6025, "ThinkPad Travel Mouse" },
    { 0x17ef602d, "Black Silk Keyboard" },
    { 0x17ef6032, "Wireless Dongle for Keyboard and Mouse" },
    { 0x17ef6044, "ThinkPad Laser Mouse" },
    { 0x17ef6047, "ThinkPad Compact Keyboard with TrackPoint" },
    { 0x17ef604b, "Precision Wireless Mouse" },
    { 0x17ef608d, "Optical Mouse" },
    { 0x17ef609b, "Professional Wireless Keyboard and Mouse Combo" },
    { 0x17ef609c, "Professional Wireless Keyboard" },
    { 0x17ef7203, "Ethernet adapter [U2L 100P-Y1]" },
    { 0x17ef7205, "Thinkpad LAN" },
    { 0x17ef7217, "VGA adapter" },
    { 0x17ef740a, "Lenovo K1" },
    { 0x17ef741c, "Lenovo ThinkPad Tablet" },
    { 0x17ef7423, "IdeaPad A1 Tablet" },
    { 0x17ef7435, "A789 (Mass Storage mode, with debug)" },
    { 0x17ef743a, "A789 (Mass Storage mode)" },
    { 0x17ef7497, "Lenovo P700" },
    { 0x17ef7498, "A789 (MTP mode, with debug)" },
    { 0x17ef749a, "A789 (PTP mode)" },
    { 0x17ef749b, "A789 (PTP mode, with debug)" },
    { 0x17ef74cc, "Lenovo Lifetab S9512" },
    { 0x17ef7604, "A760 (Mass Storage mode)" },
    { 0x17ef7605, "A760 (Mass Storage mode, with debug)" },
    { 0x17ef760a, "A760 (MTP mode)" },
    { 0x17ef760b, "A760 (MTP mode, with debug)" },
    { 0x17ef760c, "A760 (PTP mode)" },
    { 0x17ef760d, "A760 (PTP mode, with debug)" },
    { 0x17ef76fc, "B8000-H (Yoga Tablet 10) (mass storage)" },
    { 0x17ef76fd, "B8000-H (Yoga Tablet 10) (debug , mass storage)" },
    { 0x17ef76fe, "B8000-H (Yoga Tablet 10) (MTP)" },
    { 0x17ef76ff, "B8000-H (Yoga Tablet 10) (debug , MTP)" },
    { 0x17ef7702, "B8000-H (Yoga Tablet 10) (PTP)" },
    { 0x17ef7703, "B8000-H (Yoga Tablet 10) (debug , PTP)" },
    { 0x17ef7704, "B8000-H (Yoga Tablet 10) (USB tether)" },
    { 0x17ef7705, "B8000-H (Yoga Tablet 10) (debug , USB tether)" },
    { 0x17ef7706, "B8000-H (Yoga Tablet 10) (zerocd)" },
    { 0x17ef7707, "B8000-H (Yoga Tablet 10) (debug , zerocd)" },
    { 0x17ef785f, "TAB 2 A7-10 Tablet" },
    { 0x17efb000, "Virtual Keyboard and Mouse" },
    { 0x17efb001, "Ethernet" },
    { 0x17efb003, "Virtual Keyboard and Mouse / Mass Storage" },
    { 0x17eff003, "MEDION LIFETAB X10605 MTP mode" },
    { 0x17f4aaaa, "Jazz Blood Glucose Meter" },
    { 0x17f60709, "Model M Keyboard" },
    { 0x17f60822, "Ruffian 6 Keyboard v3 [Model M]" },
    { 0x18094604, "USB-4604" },
    { 0x18094761, "USB-4761 Portable Data Acquisition Module" },
    { 0x18223201, "VisionDTV USB-Ter/HAMA USB DVB-T device cold" },
    { 0x18223202, "VisionDTV USB-Ter/HAMA USB DVB-T device warm" },
    { 0x183d0010, "VoiceKey" },
    { 0x184f0012, "MOCCA compact" },
    { 0x18527022, "Fiio E10" },
    { 0x18527921, "Audiotrak ProDigy CUBE" },
    { 0x18527922, "Audiotrak DR.DAC2 DX [GYROCOM C&C]" },
    { 0x185b3020, "K100 Infrared Receiver" },
    { 0x185b3082, "K100 Infrared Receiver v2" },
    { 0x185bd000, "Compro Videomate DVB-U2000 - DVB-T USB cold" },
    { 0x185bd001, "Compro Videomate DVB-U2000 - DVB-T USB warm" },
    { 0x18700001, "iNexio Touchscreen controller" },
    { 0x18710101, "UVC camera (Bresser microscope)" },
    { 0x18710141, "Camera" },
    { 0x18710d01, "USB2.0 Camera" },
    { 0x1873ee93, "EasyLogger" },
    { 0x187c0511, "AlienFX Mobile lighting" },
    { 0x187c0513, "Gaming Desktop [Aurora R4]" },
    { 0x187c0550, "LED controller" },
    { 0x187c0600, "Dual Compatible Game Pad" },
    { 0x187f0010, "Stallar Board" },
    { 0x187f0100, "Stallar Board" },
    { 0x187f0200, "Nova A" },
    { 0x187f0201, "Nova B" },
    { 0x187f0202, "Nice" },
    { 0x187f0300, "Vega" },
    { 0x187f0301, "VeNice" },
    { 0x18945632, "Atek Tote Remote" },
    { 0x18945641, "TSAM-004 Presentation Remote" },
    { 0x189f0002, "Legato2 3D Scanner" },
    { 0x18a40001, "Snapshell IDR" },
    { 0x18a50214, "Portable Hard Drive" },
    { 0x18a50216, "External Hard Drive" },
    { 0x18a50218, "External Hard Drive" },
    { 0x18a50224, "Store 'n' Go Micro Plus" },
    { 0x18a50227, "Pocket Hard Drive" },
    { 0x18a5022b, "Portable Hard Drive (Store'n'Go)" },
    { 0x18a50237, "Portable Harddrive" },
    { 0x18a50243, "Flash Drive (Store'n'Go)" },
    { 0x18a50245, "Store'n'Stay" },
    { 0x18a50302, "Flash Drive" },
    { 0x18a50304, "Store 'n' Go" },
    { 0x18a50408, "Store 'n' Go" },
    { 0x18a54123, "Store N Go" },
    { 0x18b10037, "Maxter Remote Control" },
    { 0x18b41001, "DUTV007" },
    { 0x18b41002, "EC168 (v5) based USB DVB-T receiver" },
    { 0x18b41689, "DUTV009" },
    { 0x18b4fffa, "EC168 (v2) based USB DVB-T receiver" },
    { 0x18b4fffb, "EC168 (v3) based USB DVB-T receiver" },
    { 0x18c50002, "CG-WLUSB2GO" },
    { 0x18c50008, "CG-WLUSB2GNR Corega Wireless USB Adapter" },
    { 0x18c50012, "CG-WLUSB10 Corega Wireless USB Adapter" },
    { 0x18cdcafe, "Pico iMage" },
    { 0x18d10001, "Onda V972 (storage access)" },
    { 0x18d10003, "Android-powered device using AllWinner Technology SoC" },
    { 0x18d10006, "Onda V972 MTP" },
    { 0x18d10008, "Onda V972 PTP (camera)" },
    { 0x18d105b3, "Google Inc (for Sony) S1" },
    { 0x18d10d02, "Celkon A88" },
    { 0x18d12d00, "Android Open Accessory device (accessory)" },
    { 0x18d12d01, "Android Open Accessory device (accessory + ADB)" },
    { 0x18d12d02, "Google Inc (for Barnes & Noble) Nook Color" },
    { 0x18d12d03, "Android Open Accessory device (audio + ADB)" },
    { 0x18d12d04, "Android Open Accessory device (accessory + audio)" },
    { 0x18d12d05, "Android Open Accessory device (accessory + audio + ADB)" },
    { 0x18d14e0f, "Google Inc (for Asus) TF101 Transformer" },
    { 0x18d14e11, "Nexus One" },
    { 0x18d14e12, "Nexus One (debug)" },
    { 0x18d14e13, "Nexus One (tether)" },
    { 0x18d14e20, "Nexus S (fastboot)" },
    { 0x18d14e21, "Google Inc (for Samsung) Nexus S" },
    { 0x18d14e22, "Nexus S (debug)" },
    { 0x18d14e24, "Nexus S (tether)" },
    { 0x18d14e30, "Galaxy Nexus (fastboot)" },
    { 0x18d14e40, "Nexus 7 (fastboot)" },
    { 0x18d14e41, "Google Inc (for Asus) Nexus 7 (MTP)" },
    { 0x18d14e42, "Google Inc (for Asus) Nexus 7 (MTP+ADB)" },
    { 0x18d14e43, "Nexus 7 (PTP)" },
    { 0x18d14e44, "Nexus 7 2012 (PTP)" },
    { 0x18d14ee0, "Nexus/Pixel Device (fastboot)" },
    { 0x18d14ee1, "Nexus/Pixel Device (MTP)" },
    { 0x18d14ee2, "Nexus/Pixel Device (MTP + debug)" },
    { 0x18d14ee3, "Nexus/Pixel Device (tether)" },
    { 0x18d14ee4, "Nexus/Pixel Device (tether+ debug)" },
    { 0x18d14ee5, "Nexus/Pixel Device (PTP)" },
    { 0x18d14ee6, "Nexus/Pixel Device (PTP + debug)" },
    { 0x18d14ee7, "Nexus/Pixel Device (charging + debug)" },
    { 0x18d14ee8, "Nexus/Pixel Device (MIDI)" },
    { 0x18d14ee9, "Nexus/Pixel Device (MIDI + debug)" },
    { 0x18d15033, "Pixel earbuds" },
    { 0x18d170a8, "Google Inc (for Motorola) Xoom (MZ604)" },
    { 0x18d17102, "Google Inc (for Toshiba) Thrive 7/AT105" },
    { 0x18d1740a, "Google Inc (for Lenovo) Ideapad K1" },
    { 0x18d1b004, "Pandigital / B&N Novel 9\" tablet" },
    { 0x18d1b00a, "Google Inc (for Medion) MD99000 (P9514)" },
    { 0x18d1d001, "Nexus 4 (fastboot)" },
    { 0x18d1d002, "Nexus 4 (debug)" },
    { 0x18d1d00d, "Xiaomi Mi/Redmi 2 (fastboot)" },
    { 0x18d1d109, "LG G2x MTP" },
    { 0x18d1d10a, "Google Inc (for LG Electronics) P990/Optimus" },
    { 0x18d901a0, "B-Net 91 07" },
    { 0x18dd1000, "DocuPen RC800" },
    { 0x18e37102, "Multi Card Reader (Internal)" },
    { 0x18e39101, "All-in-1 Card Reader" },
    { 0x18e39102, "Multi Card Reader" },
    { 0x18e39512, "Webcam" },
    { 0x18e86144, "LR802UA 802.11b Wireless Adapter [ALi M4301AU]" },
    { 0x18e86196, "RT2573" },
    { 0x18e86229, "RT2573" },
    { 0x18e86232, "Wireless 802.11g 54Mbps Network Adapter [RTL8187]" },
    { 0x18ea0002, "DualHead2Go [Analog Edition]" },
    { 0x18ea0004, "TripleHead2Go [Digital Edition]" },
    { 0x18ec3118, "USB to IrDA adapter [ARK3116T]" },
    { 0x18ec3188, "ARK3188 UVC Webcam" },
    { 0x18ec3299, "Webcam Carrefour" },
    { 0x18ec3366, "Bresser Biolux NV" },
    { 0x18ec5850, "CVBS / S-Video Capture Device [UVC]" },
    { 0x18efe014, "FS20PCE" },
    { 0x18efe015, "FS20PCS" },
    { 0x18efe01a, "Bedien-Anzeige-Terminal" },
    { 0x18f60102, "Sirius Stiletto" },
    { 0x18f60110, "Sirius Stiletto 2" },
    { 0x18f80f97, "Optical Gaming Mouse [Xtrem]" },
    { 0x18f80f99, "Optical gaming mouse" },
    { 0x18f81142, "Optical gaming mouse" },
    { 0x18f81486, "X5s ZEUS Macro Pro Gaming Mouse" },
    { 0x18fb01c0, "ST1501-STN" },
    { 0x18fb01c1, "ST1526-STN" },
    { 0x18fb01c2, "ST1501-PYJ" },
    { 0x18fb01c3, "ST1501B-PYJ" },
    { 0x18fb01c4, "ST1501-PUN" },
    { 0x18fb01c5, "ST1401-STN" },
    { 0x18fb01c7, "ST1526-PYJ" },
    { 0x18fb01c8, "ST1501-ECA" },
    { 0x18fb01c9, "ST1476-STN" },
    { 0x18fb01cb, "ST1571-STN" },
    { 0x18fb0200, "ST1500" },
    { 0x18fb0201, "ST1550" },
    { 0x18fb0202, "ST1525" },
    { 0x18fb0204, "ST1400" },
    { 0x18fb0206, "ST1475" },
    { 0x18fb0207, "ST1570" },
    { 0x19010015, "Nemo Tracker" },
    { 0x19080102, "Digital Photo Frame" },
    { 0x19080226, "MicroSD Card Reader/Writer" },
    { 0x19081315, "Digital Photo Frame" },
    { 0x19081320, "DM8261 Flashdisc" },
    { 0x19082070, "Honk HK-5002 USB Speaker" },
    { 0x19082220, "Buildwin Media-Player" },
    { 0x19082311, "Generic UVC 1.00 camera [AppoTech AX2311]" },
    { 0x1915000c, "Wireless Desktop nRF24L01 CX-1766" },
    { 0x19150101, "HP Prime Wireless Kit [FOK65AA] (Flash mode)" },
    { 0x19152233, "Linksys WUSB11 v2.8 802.11b Adapter [Atmel AT76C505]" },
    { 0x19152234, "Linksys WUSB54G v1 OEM 802.11g Adapter [Intersil ISL3886]" },
    { 0x19152235, "Linksys WUSB54GP v1 OEM 802.11g Adapter [Intersil ISL3886]" },
    { 0x19152236, "Linksys WUSB11 v3.0 802.11b Adapter [Intersil PRISM 3]" },
    { 0x19157777, "Bitcraze Crazyradio (PA) dongle" },
    { 0x191c4104, "Banknote validator NV-150" },
    { 0x19230002, "Personal SyncPoint" },
    { 0x19260003, "1900 HID Touchscreen" },
    { 0x19260006, "1950 HID Touchscreen" },
    { 0x19260064, "1950 HID Touchscreen" },
    { 0x19260065, "1950 HID Touchscreen" },
    { 0x19260066, "1950 HID Touchscreen" },
    { 0x19260067, "1950 HID Touchscreen" },
    { 0x19260068, "1950 HID Touchscreen" },
    { 0x19260069, "1950 HID Touchscreen" },
    { 0x19260071, "1950 HID Touchscreen" },
    { 0x19260072, "1950 HID Touchscreen" },
    { 0x19260073, "1950 HID Touchscreen" },
    { 0x19260074, "1950 HID Touchscreen" },
    { 0x19260075, "1950 HID Touchscreen" },
    { 0x19260076, "1950 HID Touchscreen" },
    { 0x19260077, "1950 HID Touchscreen" },
    { 0x19260078, "1950 HID Touchscreen" },
    { 0x19260079, "1950 HID Touchscreen" },
    { 0x1926007a, "1950 HID Touchscreen" },
    { 0x1926007e, "1950 HID Touchscreen" },
    { 0x1926007f, "1950 HID Touchscreen" },
    { 0x19260080, "1950 HID Touchscreen" },
    { 0x19260081, "1950 HID Touchscreen" },
    { 0x19260082, "1950 HID Touchscreen" },
    { 0x19260083, "1950 HID Touchscreen" },
    { 0x19260084, "1950 HID Touchscreen" },
    { 0x19260085, "1950 HID Touchscreen" },
    { 0x19260086, "1950 HID Touchscreen" },
    { 0x19260087, "1950 HID Touchscreen" },
    { 0x19260dbf, "HID Touchscreen" },
    { 0x19260dc2, "HID Touchscreen" },
    { 0x19280400, "Equotip Piccolo" },
    { 0x192f0000, "Mouse" },
    { 0x192f0416, "ADNS-5700 Optical Mouse Controller (3-button)" },
    { 0x192f0616, "ADNS-5700 Optical Mouse Controller (5-button)" },
    { 0x192f0916, "ADNS-2710 Optical Mouse Controller" },
    { 0x19340602, "F71610 or F71612 Consumer Infrared Receiver/Transceiver" },
    { 0x19340702, "Integrated Consumer Infrared Receiver/Transceiver" },
    { 0x19345168, "F71610A or F71612A Consumer Infrared Receiver/Transceiver" },
    { 0x1935000d, "Elektron Digitakt" },
    { 0x19380501, "TCR51USB IRIG Time Code Reader" },
    { 0x19380502, "TCR600USB IRIG Time Code Reader" },
    { 0x19418021, "WH1080 Weather Station / USB Missile Launcher" },
    { 0x19432250, "Model 2250 MPEG and JPEG Capture Card" },
    { 0x19432253, "Model 2253 Audio/Video Codec Card" },
    { 0x19432255, "Model 2255 4 Channel Capture Card" },
    { 0x19432257, "Model 2257 4 Channel Capture Card" },
    { 0x19432263, "Model 2263 UVC HD Audio/Video Codec Card" },
    { 0x1943a250, "Model 2250 MPEG and JPEG Capture Card (cold)" },
    { 0x1943a253, "Model 2253 Audio/Video Codec Card (cold)" },
    { 0x19490002, "Amazon Kindle" },
    { 0x19490004, "Amazon Kindle 3/4/Paperwhite" },
    { 0x19490006, "Amazon Kindle Fire" },
    { 0x19490008, "Amazon Kindle Fire HD 8.9\"" },
    { 0x1949000a, "Amazon Kindle Fire 2nd generation (2012)" },
    { 0x19490331, "Kindle Fire HD 8 (2018)" },
    { 0x19490417, "Amazon Zukey; clone of Yubikey 4 OTP+U2F" },
    { 0x19490800, "Fire Phone" },
    { 0x194f0101, "AudioBox 22 VSL" },
    { 0x194f0102, "AudioBox 44 VSL" },
    { 0x194f0103, "AudioBox 1818 VSL" },
    { 0x194f0201, "FaderPort" },
    { 0x194f0301, "AudioBox" },
    { 0x19530202, "S200 2GB Rev. 1" },
    { 0x195d2030, "Func KB-460 Gaming Keyboard" },
    { 0x195d7002, "Libra-Q11 IR remote" },
    { 0x195d7006, "Libra-Q26 / 1.0 Remote" },
    { 0x195d7777, "Scorpius wireless keyboard" },
    { 0x195d7779, "Scorpius-P20MT" },
    { 0x19630005, "iRig KEYS" },
    { 0x19630046, "UNO Synth" },
    { 0x19650016, "HomePatrol-1" },
    { 0x19650018, "UBC125XLT" },
    { 0x1965001a, "BCD436HP Scanner" },
    { 0x19700000, "Z Mate 16GB" },
    { 0x19730002, "Pivot recovery" },
    { 0x19730003, "Pivot Media Transfer Protocol" },
    { 0x19730004, "Pivot Media Transfer Protocol" },
    { 0x19761307, "microSD Card Reader" },
    { 0x19766025, "CBM2090 Flash Drive" },
    { 0x19770111, "TL203 MP3 Player and Voice Recorder" },
    { 0x197d0222, "BCL 508i" },
    { 0x19800808, "Clickfree C2 Slimline (527SE)" },
    { 0x198f0210, "BCS200 WiMAX Adapter" },
    { 0x198f0220, "BCSM250 WiMAX Adapter" },
    { 0x19953202, "REC-ADPT-USB (recorder)" },
    { 0x19953203, "REC-A-ADPT-USB (recorder)" },
    { 0x19963010, "Camera Release 4" },
    { 0x19963011, "OEM Camera" },
    { 0x19963012, "e-ImageData Corp. ScanPro" },
    { 0x19970409, "wireless mini keyboard with touchpad" },
    { 0x19972433, "wireless mini keyboard with touchpad" },
    { 0x199b3065, "3DM-GX3-25 Orientation Sensor" },
    { 0x199e8101, "DFx 21BU04 Camera" },
    { 0x199e8457, "DFK AFU130-L53 camera" },
    { 0x19a50004, "Remote NDIS Network Device" },
    { 0x19a50012, "RF-7800S Secure Personal Radio" },
    { 0x19a50401, "Mass Storage Device" },
    { 0x19a50402, "Falcon III RF-7800V family RNDIS" },
    { 0x19ab1000, "ProScope HR" },
    { 0x19af6611, "Celestia VoIP Phone" },
    { 0x19b20010, "BX32 Batupo" },
    { 0x19b20011, "BX32P Barlino" },
    { 0x19b20012, "BX40 Bagero" },
    { 0x19b20013, "BX48 Batego" },
    { 0x19b40002, "SkyScout Personal Planetarium" },
    { 0x19b40101, "Handheld Digital Microscope 44302" },
    { 0x19b94b10, "Drobo" },
    { 0x19b98d20, "Drobo Elite" },
    { 0x19c26a11, "MDM166A Fluorescent Display" },
    { 0x19ca0001, "Sandio 3D HID Mouse" },
    { 0x19cf0001, "MiniKit Slim handsfree car kit in firmware update mode" },
    { 0x19d20001, "CDMA Wireless Modem" },
    { 0x19d20002, "MF632/ONDA ET502HS/MT505UP" },
    { 0x19d20007, "TU25 WiMAX Adapter [Beceem BCS200]" },
    { 0x19d20017, "MF669" },
    { 0x19d20031, "MF110/MF627/MF636" },
    { 0x19d20037, "ONDA MC503HSA" },
    { 0x19d20039, "MF100" },
    { 0x19d20063, "K3565-Z HSDPA" },
    { 0x19d20064, "MF627 AU" },
    { 0x19d20083, "MF190" },
    { 0x19d20103, "MF112" },
    { 0x19d20104, "K4505-Z" },
    { 0x19d20117, "MF667" },
    { 0x19d20146, "MF 195E (HSPA+ Modem)" },
    { 0x19d20167, "MF820 4G LTE" },
    { 0x19d20172, "AX226 WIMAX MODEM (After Modeswitch)" },
    { 0x19d20244, "ZTE V55 ID 1" },
    { 0x19d20245, "ZTE V55 ID 2" },
    { 0x19d20325, "LTE4G O2 ZTE MF821D LTE/UMTS/GSM Modem/Networkcard" },
    { 0x19d20326, "LTE4G O2 ZTE MF821D LTE/UMTS/GSM Modem/Networkcard" },
    { 0x19d20501, "Lever Cell Phone Model Z936L" },
    { 0x19d21001, "K3805-Z vodafone WCDMA/GSM Modem - storage mode (made by ZTE)" },
    { 0x19d21002, "K3805-Z vodafone WCDMA/GSM Modem/Networkcard (made by ZTE)" },
    { 0x19d21008, "K3570-Z" },
    { 0x19d21010, "K3571-Z" },
    { 0x19d21017, "K5006-Z vodafone LTE/UMTS/GSM Modem/Networkcard" },
    { 0x19d21018, "K5006-Z vodafone LTE/UMTS/GSM Modem/Networkcard" },
    { 0x19d21203, "MF691 [ T-Mobile webConnect Rocket 2.0]" },
    { 0x19d21217, "MF652" },
    { 0x19d21218, "MF652" },
    { 0x19d21270, "MF667" },
    { 0x19d22000, "MF627/MF628/MF628+/MF636+ HSDPA/HSUPA" },
    { 0x19d2fff2, "Gobi Wireless Modem (QDL mode)" },
    { 0x19d2fff3, "Gobi Wireless Modem" },
    { 0x19db02f1, "NAUT324C" },
    { 0x19f70001, "Podcaster" },
    { 0x19fa0607, "GAME CONTROLLER" },
    { 0x19fa0703, "Steering Wheel" },
    { 0x19ff0102, "1.3MP Webcam" },
    { 0x19ff0201, "Rocketfish Wireless 2.4G Laser Mouse" },
    { 0x19ff0220, "RF-HDWEBLT RocketFish HD WebCam" },
    { 0x19ff0238, "DX-WRM1401 Mouse" },
    { 0x19ff0239, "Bluetooth 4.0 Adapter [Broadcom, 1.12, BCM20702A0]" },
    { 0x19ff0303, "Insignia NS-DV45" },
    { 0x19ff0307, "Insignia Sport Player" },
    { 0x19ff0309, "Insignia Pilot 4GB" },
    { 0x1a0abadd, "USB OTG Compliance test device" },
    { 0x1a1d0407, "Mimi WiFi speakers" },
    { 0x1a2c0021, "Keyboard" },
    { 0x1a2c0024, "Multimedia Keyboard" },
    { 0x1a2c2124, "Keyboard" },
    { 0x1a2c2d23, "Keyboard" },
    { 0x1a2c427c, "Backlit Keyboard [Cougar Vantar]" },
    { 0x1a320304, "802.11n Wireless LAN Card" },
    { 0x1a340802, "Gamepad" },
    { 0x1a400101, "Hub" },
    { 0x1a400201, "FE 2.1 7-port Hub" },
    { 0x1a440001, "Digipass 905 SmartCard Reader" },
    { 0x1a613410, "CoPilot System Cable" },
    { 0x1a613650, "FreeStyle Libre" },
    { 0x1a613850, "FreeStyle Optium/Precision Neo" },
    { 0x1a613950, "FreeStyle Libre 2" },
    { 0x1a640000, "MasterBus Link" },
    { 0x1a721008, "E-861 PiezoWalk NEXACT Controller" },
    { 0x1a796002, "Contour" },
    { 0x1a796210, "Contour Next Link 2.4 glucometer" },
    { 0x1a796300, "Contour next link" },
    { 0x1a797410, "Contour Next" },
    { 0x1a797800, "Contour Plus One" },
    { 0x1a7c0068, "VerticalMouse 3" },
    { 0x1a7c0168, "VerticalMouse 3 Wireless" },
    { 0x1a7c0191, "VerticalMouse 4" },
    { 0x1a7c0195, "VerticalMouse C Wireless" },
    { 0x1a7e1001, "UFT75, UT150, UT60" },
    { 0x1a7e1003, "Thermostick" },
    { 0x1a811004, "Wireless Dongle 2.4 GHZ HT82D40REW" },
    { 0x1a811701, "Wireless dongle" },
    { 0x1a812004, "Keyboard" },
    { 0x1a812203, "Laser Gaming mouse" },
    { 0x1a812204, "Optical Mouse" },
    { 0x1a812205, "Laser Mouse" },
    { 0x1a814001, "Keyboard" },
    { 0x1a865512, "CH341 in EPP/MEM/I2C mode, EPP/I2C adapter" },
    { 0x1a865523, "CH341 in serial mode, usb to serial port converter" },
    { 0x1a865584, "CH341 in parallel mode, usb to printer port converter" },
    { 0x1a867523, "CH340 serial converter" },
    { 0x1a86752d, "CH345 MIDI adapter" },
    { 0x1a867584, "CH340S" },
    { 0x1a86e008, "HID-based serial adapater" },
    { 0x1a8d1002, "BandLuxe 3.5G HSDPA Adapter" },
    { 0x1a8d1009, "BandLuxe 3.5G HSPA Adapter" },
    { 0x1a8d100d, "4G LTE adapter" },
    { 0x1aab7736, "sceye (Gen 2)" },
    { 0x1aab7737, "sceye (Gen 3)" },
    { 0x1aab7738, "sceye (Gen 4, 3 Mpix)" },
    { 0x1aab7750, "sceyeS (Gen 5, 5 MPix)" },
    { 0x1aad0001, "Touchscreen" },
    { 0x1ab104b0, "DS6000 SERIES" },
    { 0x1ab104be, "DS4000 SERIES" },
    { 0x1ab104ce, "DS1xx4Z/MSO1xxZ series" },
    { 0x1ab10588, "DS1000 SERIES" },
    { 0x1ab20001, "Vision device" },
    { 0x1acc0103, "AudioLink plus 4x4 2.9.28" },
    { 0x1ad40002, "KM290-HRS" },
    { 0x1adb0001, "C662 Serial Cable" },
    { 0x1adb0003, "CDC Ethernet Gadget" },
    { 0x1ae70381, "VS-DVB-T 380U (af9015 based)" },
    { 0x1ae70525, "X-Tensions ISDN TA XC-525 [HFC-S USB]" },
    { 0x1ae72001, "SpeedLink Snappy Mic webcam (SL-6825-SBK)" },
    { 0x1ae79003, "SpeedLink Vicious And Devine Laplace webcam, white (VD-1504-SWT)" },
    { 0x1ae79004, "SpeedLink Vicious And Devine Laplace webcam, black (VD-1504-SBK)" },
    { 0x1af30001, "ZOWIE Gaming mouse" },
    { 0x1afe0001, "PQ Box 100" },
    { 0x1b040630, "ME-630" },
    { 0x1b040940, "ME-94" },
    { 0x1b040950, "ME-95" },
    { 0x1b040960, "ME-96" },
    { 0x1b041000, "ME-1000" },
    { 0x1b04100a, "ME-1000" },
    { 0x1b04100b, "ME-1000" },
    { 0x1b041400, "ME-1400" },
    { 0x1b04140a, "ME-1400A" },
    { 0x1b04140b, "ME-1400B" },
    { 0x1b04140c, "ME-1400C" },
    { 0x1b04140d, "ME-1400D" },
    { 0x1b04140e, "ME-1400E" },
    { 0x1b0414ea, "ME-1400EA" },
    { 0x1b0414eb, "ME-1400EB" },
    { 0x1b041604, "ME-1600/4U" },
    { 0x1b041608, "ME-1600/8U" },
    { 0x1b04160c, "ME-1600/12U" },
    { 0x1b04160f, "ME-1600/16U" },
    { 0x1b04168f, "ME-1600/16U8I" },
    { 0x1b044610, "ME-4610" },
    { 0x1b044650, "ME-4650" },
    { 0x1b044660, "ME-4660" },
    { 0x1b044661, "ME-4660I" },
    { 0x1b044662, "ME-4660" },
    { 0x1b044663, "ME-4660I" },
    { 0x1b044670, "ME-4670" },
    { 0x1b044671, "ME-4670I" },
    { 0x1b044672, "ME-4670S" },
    { 0x1b044673, "ME-4670IS" },
    { 0x1b044680, "ME-4680" },
    { 0x1b044681, "ME-4680I" },
    { 0x1b044682, "ME-4680S" },
    { 0x1b044683, "ME-4680IS" },
    { 0x1b046004, "ME-6000/4" },
    { 0x1b046008, "ME-6000/8" },
    { 0x1b04600f, "ME-6000/16" },
    { 0x1b046014, "ME-6000I/4" },
    { 0x1b046018, "ME-6000I/8" },
    { 0x1b04601f, "ME-6000I/16" },
    { 0x1b046034, "ME-6000ISLE/4" },
    { 0x1b046038, "ME-6000ISLE/8" },
    { 0x1b04603f, "ME-6000ISLE/16" },
    { 0x1b046044, "ME-6000/4/DIO" },
    { 0x1b046048, "ME-6000/8/DIO" },
    { 0x1b04604f, "ME-6000/16/DIO" },
    { 0x1b046054, "ME-6000I/4/DIO" },
    { 0x1b046058, "ME-6000I/8/DIO" },
    { 0x1b04605f, "ME-6000I/16/DIO" },
    { 0x1b046074, "ME-6000ISLE/4/DIO" },
    { 0x1b046078, "ME-6000ISLE/8/DIO" },
    { 0x1b04607f, "ME-6000ISLE/16/DIO" },
    { 0x1b046104, "ME-6100/4" },
    { 0x1b046108, "ME-6100/8" },
    { 0x1b04610f, "ME-6100/16" },
    { 0x1b046114, "ME-6100I/4" },
    { 0x1b046118, "ME-6100I/8" },
    { 0x1b04611f, "ME-6100I/16" },
    { 0x1b046134, "ME-6100ISLE/4" },
    { 0x1b046138, "ME-6100ISLE/8" },
    { 0x1b04613f, "ME-6100ISLE/16" },
    { 0x1b046144, "ME-6100/4/DIO" },
    { 0x1b046148, "ME-6100/8/DIO" },
    { 0x1b04614f, "ME-6100/16/DIO" },
    { 0x1b046154, "ME-6100I/4/DIO" },
    { 0x1b046158, "ME-6100I/8/DIO" },
    { 0x1b04615f, "ME-6100I/16/DIO" },
    { 0x1b046174, "ME-6100ISLE/4/DIO" },
    { 0x1b046178, "ME-6100ISLE/8/DIO" },
    { 0x1b04617f, "ME-6100ISLE/16/DIO" },
    { 0x1b046259, "ME-6200I/9/DIO" },
    { 0x1b046359, "ME-6300I/9/DIO" },
    { 0x1b04810a, "ME-8100A" },
    { 0x1b04810b, "ME-8100B" },
    { 0x1b04820a, "ME-8200A" },
    { 0x1b04820b, "ME-8200B" },
    { 0x1b0e1078, "BLUDRIVE II CCID" },
    { 0x1b0e1079, "BLUDRIVE II CCID" },
    { 0x1b0e1080, "WRITECHIP II CCID" },
    { 0x1b120011, "ModFactor" },
    { 0x1b1c0890, "Flash Padlock" },
    { 0x1b1c0a00, "SP2500 Speakers" },
    { 0x1b1c0a60, "Vengeance K60 Keyboard" },
    { 0x1b1c0c04, "Link Cooling Node" },
    { 0x1b1c0c06, "RM-Series C-Link Adapter" },
    { 0x1b1c0c0a, "Hydro Series H115i Liquid CPU Cooler" },
    { 0x1b1c0c0b, "Lighting Node Pro" },
    { 0x1b1c0c0c, "Lighting Node Loader" },
    { 0x1b1c0c22, "iCUE H150i RGB PRO XT Liquid CPU Cooler" },
    { 0x1b1c1a01, "Flash Voyager GT" },
    { 0x1b1c1a03, "Voyager 3.0" },
    { 0x1b1c1a09, "Voyager GT 3.0" },
    { 0x1b1c1a0a, "Survivor Stealth Flash Drive" },
    { 0x1b1c1a0b, "Flash Voyager LS" },
    { 0x1b1c1a0e, "Voyager GTX" },
    { 0x1b1c1a14, "Voyager Vega" },
    { 0x1b1c1a15, "Voyager Slider Flash Drive" },
    { 0x1b1c1a90, "Flash Voyager GT" },
    { 0x1b1c1ab1, "Voyager" },
    { 0x1b1c1b04, "Raptor K50 Keyboard" },
    { 0x1b1c1b07, "Vengeance K65 Gaming Keyboard" },
    { 0x1b1c1b08, "Vengeance K95 Keyboard" },
    { 0x1b1c1b09, "Vengeance K70R keyboard" },
    { 0x1b1c1b11, "K95 RGB Mechanical Gaming Keyboard" },
    { 0x1b1c1b13, "Vengeance K70RGB keyboard" },
    { 0x1b1c1b20, "STRAFE RGB Gaming Keyboard" },
    { 0x1b1c1b2d, "K95 RGB Platinum Keyboard [RGP0056]" },
    { 0x1b1c1b2e, "Corsair Corsair Gaming M65 Pro RGB Mouse" },
    { 0x1b1c1b2f, "Sabre RGB [CH-9303011-XX]" },
    { 0x1b1c1b3d, "Corsair Corsair Gaming K55 RGB Keyboard" },
    { 0x1b1c1b5e, "Harpoon Wireless Mouse" },
    { 0x1b1c1b65, "Harpoon Wireless Dongle" },
    { 0x1b1c1c00, "Controller for Corsair Link" },
    { 0x1b1c1c02, "AX1500i Power Supply" },
    { 0x1b1c1c05, "HX750i Power Supply" },
    { 0x1b1c1c07, "HX1000i Power Supply" },
    { 0x1b1c1c08, "HX1200i Power Supply" },
    { 0x1b1c1c0b, "RM750i Power Supply" },
    { 0x1b1c1c0c, "RM850i Power Supply" },
    { 0x1b1c1c1a, "Corsair CORSAIR Lighting Node CORE" },
    { 0x1b1e1003, "A1250" },
    { 0x1b1fc00f, "HM-CFG-USB/HM-CFG-USB-2 [HomeMatic Configuration adapter]" },
    { 0x1b1fc020, "HmIP-RFUSB" },
    { 0x1b244001, "TLG2300 Hybrid TV Device" },
    { 0x1b320064, "Pleo robotic dinosaur" },
    { 0x1b3b2933, "PC Camera/Webcam controller" },
    { 0x1b3b2935, "PC Camera/Webcam controller" },
    { 0x1b3b2936, "PC Camera/Webcam controller" },
    { 0x1b3b2937, "PC Camera/Webcam controller" },
    { 0x1b3b2938, "PC Camera/Webcam controller" },
    { 0x1b3b2939, "PC Camera/Webcam controller" },
    { 0x1b3b2950, "PC Camera/Webcam controller" },
    { 0x1b3b2951, "PC Camera/Webcam controller" },
    { 0x1b3b2952, "PC Camera/Webcam controller" },
    { 0x1b3b2953, "PC Camera/Webcam controller" },
    { 0x1b3b2955, "PC Camera/Webcam controller" },
    { 0x1b3b2956, "PC Camera/Webcam controller" },
    { 0x1b3b2957, "PC Camera/Webcam controller" },
    { 0x1b3b2958, "PC Camera/Webcam controller" },
    { 0x1b3b2959, "PC Camera/Webcam controller" },
    { 0x1b3b2960, "PC Camera/Webcam controller" },
    { 0x1b3b2961, "PC Camera/Webcam controller" },
    { 0x1b3b2962, "PC Camera/Webcam controller" },
    { 0x1b3b2963, "PC Camera/Webcam controller" },
    { 0x1b3b2965, "PC Camera/Webcam controller" },
    { 0x1b3b2966, "PC Camera/Webcam controller" },
    { 0x1b3b2967, "PC Camera/Webcam controller" },
    { 0x1b3b2968, "PC Camera/Webcam controller" },
    { 0x1b3b2969, "PC Camera/Webcam controller" },
    { 0x1b3f0c52, "808 Camera #9 (mass storage mode)" },
    { 0x1b3f2002, "808 Camera #9 (web-cam mode)" },
    { 0x1b3f2003, "GPD6000 [Digital MP3 Player]" },
    { 0x1b470001, "CHUSB Duo Charger (NiMH AA/AAA USB smart charger)" },
    { 0x1b522101, "FXMC Neural Network Controller" },
    { 0x1b522102, "FXMC Neural Network Controller V2" },
    { 0x1b522103, "FXMC Neural Network Controller V3" },
    { 0x1b524101, "Passport Reader CLR device" },
    { 0x1b524201, "Passport Reader PRM device" },
    { 0x1b524202, "Passport Reader PRM extension device" },
    { 0x1b524203, "Passport Reader PRM DSP device" },
    { 0x1b524204, "Passport Reader PRMC device" },
    { 0x1b524205, "Passport Reader CSHR device" },
    { 0x1b524206, "Passport Reader PRMC V2 device" },
    { 0x1b524301, "Passport Reader MRZ device" },
    { 0x1b524302, "Passport Reader MRZ DSP device" },
    { 0x1b524303, "Passport Reader CSLR device" },
    { 0x1b524401, "Card Reader" },
    { 0x1b524501, "Passport Reader RFID device" },
    { 0x1b524502, "Passport Reader RFID AIG device" },
    { 0x1b526101, "Neural Network Controller" },
    { 0x1b526202, "Fingerprint Reader device" },
    { 0x1b526203, "Fingerprint Scanner device" },
    { 0x1b528101, "Camera V1" },
    { 0x1b528102, "Recovery / Camera V2" },
    { 0x1b528103, "Camera V3" },
    { 0x1b710050, "Encore ENUTV-4 Analog TV Tuner" },
    { 0x1b713002, "USBTV007 Video Grabber [EasyCAP]" },
    { 0x1b731000, "xHC1 Controller" },
    { 0x1b753072, "AirLive WN-360USB adapter" },
    { 0x1b758171, "WN-370USB 802.11bgn Wireless Adapter [Realtek RTL8188SU]" },
    { 0x1b758187, "AirLive WL-1600USB 802.11g Adapter [Realtek RTL8187L]" },
    { 0x1b759170, "AirLive X.USB 802.11abgn [Atheros AR9170+AR9104]" },
    { 0x1b75a200, "AirLive WN-200USB wireless 11b/g/n dongle" },
    { 0x1b80c810, "MC810 [af9015]" },
    { 0x1b80d393, "DVB-T receiver [RTL2832U]" },
    { 0x1b80d396, "UB396-T [RTL2832U]" },
    { 0x1b80d397, "DVB-T receiver [RTL2832U]" },
    { 0x1b80d398, "DVB-T receiver [RTL2832U]" },
    { 0x1b80d700, "FM Radio SnapMusic Mobile 700 (FM700)" },
    { 0x1b80e297, "Conceptronic DVB-T CTVDIGRCU V3.0" },
    { 0x1b80e302, "CVBS / S-Video Capture Device [Pinnacle Dazzle / UB315-E]" },
    { 0x1b80e34c, "UB435-Q ATSC TV Stick" },
    { 0x1b80e383, "DVB-T UB383-T [af9015]" },
    { 0x1b80e385, "DVB-T UB385-T [af9015]" },
    { 0x1b80e386, "DVB-T UB385-T [af9015]" },
    { 0x1b80e399, "DVB-T KWorld PlusTV 399U [af9015]" },
    { 0x1b80e39a, "DVB-T395U [af9015]" },
    { 0x1b80e39b, "DVB-T395U [af9015]" },
    { 0x1b80e401, "Sveon STV22 DVB-T [af9015]" },
    { 0x1b80e409, "IT9137FN Dual DVB-T [KWorld UB499-2T]" },
    { 0x1b960001, "Duosense Transparent Electromagnetic Digitizer" },
    { 0x1ba40001, "InSight USB Link" },
    { 0x1ba40002, "EM358 Virtual COM Port" },
    { 0x1bad0002, "Rock Band Guitar for Xbox 360" },
    { 0x1bad0003, "Rock Band Drum Kit for Xbox 360" },
    { 0x1bad0130, "Ion Drum Rocker for Xbox 360" },
    { 0x1bad028e, "Controller" },
    { 0x1bad3330, "Rock Band 3 Keyboard wii interface" },
    { 0x1badf016, "Controller" },
    { 0x1badf018, "Street Fighter IV SE FightStick for Xbox 360" },
    { 0x1badf019, "BrawlStick for Xbox 360" },
    { 0x1badf021, "Ghost Recon Future Soldier Gamepad for Xbox 360" },
    { 0x1badf023, "MLG Pro Circuit Controller for Xbox 360" },
    { 0x1badf025, "Call of Duty Controller for Xbox 360" },
    { 0x1badf027, "FPS Pro Controller for Xbox 360" },
    { 0x1badf028, "Street Fighter IV FightPad for Xbox 360" },
    { 0x1badf02e, "FightPad" },
    { 0x1badf030, "MC2 MicroCON Racing Wheel for Xbox 360" },
    { 0x1badf036, "MicroCON Gamepad Pro for Xbox 360" },
    { 0x1badf038, "Street Fighter IV FightStick TE for Xbox 360" },
    { 0x1badf039, "Marvel VS Capcom 2 Tournament Stick for Xbox 360" },
    { 0x1badf03a, "Street Fighter X Tekken FightStick Pro for Xbox 360" },
    { 0x1badf03d, "Street Fighter IV Arcade Stick TE for Xbox 360" },
    { 0x1badf03e, "MLG Arcade FightStick TE for Xbox 360" },
    { 0x1badf03f, "Soulcalibur FightStick for Xbox 360" },
    { 0x1badf042, "Arcade FightStick TE S+ for Xbox 360" },
    { 0x1badf080, "FightStick TE2 for Xbox 360" },
    { 0x1badf501, "Horipad EX2 Turbo for Xbox 360" },
    { 0x1badf502, "Real Arcade Pro.VX SA for Xbox 360" },
    { 0x1badf503, "Fighting Stick VX for Xbox 360" },
    { 0x1badf504, "Real Arcade Pro.EX" },
    { 0x1badf505, "Fighting Stick EX2B for Xbox 360" },
    { 0x1badf506, "Real Arcade Pro.EX Premium VLX for Xbox 360" },
    { 0x1badf900, "Controller" },
    { 0x1badf901, "GameStop Controller" },
    { 0x1badf903, "Tron Controller for Xbox 360" },
    { 0x1badf904, "PDP Versus Fighting Pad for Xbox 360" },
    { 0x1badf906, "Mortal Kombat FightStick for Xbox 360" },
    { 0x1badf907, "Afterglow Gamepad" },
    { 0x1badfa01, "Gamepad" },
    { 0x1badfd00, "Razer Onza Tournament Edition" },
    { 0x1badfd01, "Razer Onza Classic Edition" },
    { 0x1bae0002, "VR920 Immersive Eyewear" },
    { 0x1bbb0003, "Alcatel one touch 4030D modem connection" },
    { 0x1bbb0017, "HSPA Data Card" },
    { 0x1bbb007a, "Alcatel OneTouch (firmware upgrade mode)" },
    { 0x1bbb011e, "Alcatel One Touch L100V / Telekom Speedstick LTE II" },
    { 0x1bbb0169, "Alcatel ONE TOUCH Fierce" },
    { 0x1bbb0195, "Alcatel OneTouch L850V / Telekom Speedstick LTE" },
    { 0x1bbba00e, "Vodafone Smart Tab 4G" },
    { 0x1bbbf000, "Alcatel OneTouch (mass storage mode)" },
    { 0x1bbbf017, "Alcatel One Touch L100V / Telekom Speedstick LTE II" },
    { 0x1bbd0060, "1.3MP Mono Camera" },
    { 0x1bbd0066, "1.3MP Mono Camera" },
    { 0x1bbd0067, "1.3MP Mono Camera" },
    { 0x1bc00013, "Elitee-e" },
    { 0x1bc00014, "Elite4" },
    { 0x1bc00020, "iToken" },
    { 0x1bc00021, "Mikey" },
    { 0x1bc00051, "Elite5" },
    { 0x1bc00055, "Elite5 v3.x" },
    { 0x1bc0485d, "EliteIV" },
    { 0x1bc70020, "HE863" },
    { 0x1bc70021, "HE910" },
    { 0x1bc70022, "GE910-QUAD" },
    { 0x1bc70023, "HE910-D ECM" },
    { 0x1bc70032, "LE910-EU V2" },
    { 0x1bc71003, "UC864-E" },
    { 0x1bc71004, "UC864-G" },
    { 0x1bc71005, "CC864-DUAL" },
    { 0x1bc71006, "CC864-SINGLE" },
    { 0x1bc71010, "DE910-DUAL" },
    { 0x1bc71011, "CE910-DUAL" },
    { 0x1bc71012, "UE910 V2" },
    { 0x1bc71101, "ME910C1" },
    { 0x1bc7110a, "ME310" },
    { 0x1bc71200, "LE920 (old firmware)" },
    { 0x1bc71201, "LE910 / LE920" },
    { 0x1bcf0005, "Optical Mouse" },
    { 0x1bcf0007, "Optical Mouse" },
    { 0x1bcf053a, "Targa Silvercrest OMC807-C optische Funkmaus" },
    { 0x1bcf05c5, "SPRF2413A [2.4GHz Wireless Keyboard/Mouse Receiver]" },
    { 0x1bcf05cf, "Micro keyboard & mouse receiver" },
    { 0x1bcf08a0, "Gaming mouse [Philips SPK9304]" },
    { 0x1bcf0c31, "SPIF30x Serial-ATA bridge" },
    { 0x1bcf2281, "SPCA2281 Web Camera" },
    { 0x1bcf2880, "Dell HD Webcam" },
    { 0x1bcf2883, "Asus Webcam" },
    { 0x1bcf2885, "ASUS Webcam" },
    { 0x1bcf2888, "HP Universal Camera" },
    { 0x1bcf2895, "Dell Integrated Webcam" },
    { 0x1bcf28a2, "Dell Integrated Webcam" },
    { 0x1bcf28a6, "DELL XPS Integrated Webcam" },
    { 0x1bcf28ae, "Laptop Integrated Webcam HD" },
    { 0x1bcf28bd, "Dell Integrated HD Webcam" },
    { 0x1bcf2985, "Laptop Integrated Webcam HD" },
    { 0x1bcf2b83, "Laptop Integrated Webcam FHD" },
    { 0x1bcf2b91, "Dell E5570 integrated webcam" },
    { 0x1bcf2b97, "Laptop Integrated Webcam FHD" },
    { 0x1bcf2c6e, "Laptop Integrated WebCam HD" },
    { 0x1bda0010, "Power Board v4 Rev B" },
    { 0x1bda0011, "Student Robotics SBv4B" },
    { 0x1bdcfabf, "Slacker Inc. Slacker Portable Media Player" },
    { 0x1bfd1268, "Touch Screen" },
    { 0x1bfd1368, "Touch Screen" },
    { 0x1bfd1568, "Capacitive Touch Screen" },
    { 0x1bfd1668, "IR Touch Screen" },
    { 0x1bfd1688, "Resistive Touch Screen" },
    { 0x1bfd2968, "Touch Screen" },
    { 0x1bfd5968, "Touch Screen" },
    { 0x1bfd6968, "Touch Screen" },
    { 0x1c042074, "ASM1074 High-Speed hub" },
    { 0x1c043074, "ASM1074 SuperSpeed hub" },
    { 0x1c05ea75, "G540 Programmer" },
    { 0x1c0c0102, "Plug Computer" },
    { 0x1c11b04d, "ErgoDox Infinity" },
    { 0x1c1a0100, "Action Replay DS \"3DS/DSi/DS/Lite Compatible\"" },
    { 0x1c28c003, "CamCube" },
    { 0x1c28c004, "CamBoard" },
    { 0x1c28c005, "ConceptCam" },
    { 0x1c28c006, "CamBoard 22" },
    { 0x1c28c007, "CamBoard nano" },
    { 0x1c28c008, "CamBoard mod" },
    { 0x1c28c009, "CamBoard plus" },
    { 0x1c28c00a, "DigiCam" },
    { 0x1c28c00d, "CamBoard pico LDD" },
    { 0x1c28c00f, "CamBoard pico" },
    { 0x1c290001, "ExMFE5 Simulator" },
    { 0x1c2910fc, "enCore device" },
    { 0x1c347241, "Prox'N'Roll RFID Scanner" },
    { 0x1c376190, "U2F Fido-compliant cryptotoken" },
    { 0x1c400533, "TiltStick" },
    { 0x1c400534, "i2c-tiny-usb interface" },
    { 0x1c400535, "glcd2usb interface" },
    { 0x1c400536, "Swiss ColorPAL" },
    { 0x1c400537, "MIST Board" },
    { 0x1c4b026f, "Spirostik" },
    { 0x1c4f0002, "Keyboard TRACER Gamma Ivory" },
    { 0x1c4f0003, "HID controller" },
    { 0x1c4f000e, "Genius KB-120 Keyboard" },
    { 0x1c4f0026, "Keyboard" },
    { 0x1c4f0032, "Optical Mouse with Scroll Wheel" },
    { 0x1c4f0034, "XM102K Optical Wheel Mouse" },
    { 0x1c4f0063, "Touchpad (integrated in detachable keyboard of Chuwi SurBook)" },
    { 0x1c4f0065, "Optical Wheel Mouse [Rapoo N1130]" },
    { 0x1c4f3000, "Micro USB Web Camera" },
    { 0x1c4f3002, "WebCam SiGma Micro" },
    { 0x1c571e45, "FPSGUN FG1000 Mouse" },
    { 0x1c6ba220, "DVD Writer Slimtype eSAU108" },
    { 0x1c6ba222, "DVD Writer Slimtype eTAU108" },
    { 0x1c6ba223, "DVD Writer Slimtype eUAU108" },
    { 0x1c71c004, "Braille Note Apex (braille terminal mode)" },
    { 0x1c73861f, "Anysee E30 USB 2.0 DVB-T Receiver" },
    { 0x1c750288, "KeyStep" },
    { 0x1c7a0577, "Fingerprint Sensor" },
    { 0x1c7a0603, "ES603 Swipe Fingerprint Sensor" },
    { 0x1c7a0801, "Fingerprint Reader" },
    { 0x1c820200, "spryTrac" },
    { 0x1c830001, "RS150 V2" },
    { 0x1c830002, "RFID card reader" },
    { 0x1c830003, "Communicator" },
    { 0x1c830005, "Mobile RFID Reader" },
    { 0x1c880007, "SMI Grabber (EasyCAP DC60+ clone) (no firmware) [SMI-2021CBE]" },
    { 0x1c88003c, "SMI Grabber (EasyCAP DC60+ clone) [SMI-2021CBE]" },
    { 0x1c9e6061, "WL-72B 3.5G MODEM" },
    { 0x1ca118ab, "SATA bridge" },
    { 0x1caca332, "C8 Webcam" },
    { 0x1cacb288, "C18 Webcam" },
    { 0x1cb66681, "IDC6681" },
    { 0x1cbe0002, "CDC serial port [TivaWare]" },
    { 0x1cbe00fd, "In-Circuit Debug Interface" },
    { 0x1cbe00ff, "Stellaris ROM DFU Bootloader" },
    { 0x1cbe0166, "CANAL USB2CAN" },
    { 0x1cbe0240, "McGill Robotics TM4C Microcontroller" },
    { 0x1cf10001, "Sensor Terminal Board" },
    { 0x1cf10004, "Wireless Handheld Terminal" },
    { 0x1cf10017, "deRFusbSniffer 2.4 GHz" },
    { 0x1cf10018, "deRFusb24E001" },
    { 0x1cf10019, "deRFusb14E001" },
    { 0x1cf1001a, "deRFusb23E00" },
    { 0x1cf1001b, "deRFusb13E00" },
    { 0x1cf1001c, "deRFnode" },
    { 0x1cf1001d, "deRFnode / gateway" },
    { 0x1cf10022, "deUSB level shifter" },
    { 0x1cf10023, "deRFusbSniffer Sub-GHz" },
    { 0x1cf10025, "deRFusb23E06" },
    { 0x1cf10027, "deRFusb13E06" },
    { 0x1cf10030, "ZigBee gateway [ConBee II]" },
    { 0x1d030028, "iCreativ MIDI Controller" },
    { 0x1d091026, "HSUPA Modem FLYING-LARK46-VER0.07 [Flying Angel]" },
    { 0x1d0d0214, "Trans-It Drive" },
    { 0x1d170001, "AXiS-49 Harmonic Table MIDI Keyboard" },
    { 0x1d191101, "DK DVB-T Dongle" },
    { 0x1d191102, "DK mini DVB-T Dongle" },
    { 0x1d191103, "DK 5217 DVB-T Dongle" },
    { 0x1d191104, "MSI DigiVox Micro HD" },
    { 0x1d196105, "Video grabber" },
    { 0x1d19610a, "Video grabber" },
    { 0x1d198202, "DK DVBC/T DONGLE" },
    { 0x1d270601, "Xtion" },
    { 0x1d340001, "Fidget" },
    { 0x1d340002, "Fidget (Basketball)" },
    { 0x1d340003, "Fidget (Golf Ball)" },
    { 0x1d340004, "Webmail Notifier" },
    { 0x1d340008, "button" },
    { 0x1d34000a, "Mailbox Friends Alert" },
    { 0x1d34000d, "Big Red Button" },
    { 0x1d340013, "LED Message Board" },
    { 0x1d340020, "Stress Ball" },
    { 0x1d451d45, "Foxlink Optical touch sensor" },
    { 0x1d45459d, "BenQ F5" },
    { 0x1d45465c, "Harrier Mini by EE" },
    { 0x1d4d0002, "Ralink RT2770/2720 802.11b/g/n Wireless LAN Mini-USB Device" },
    { 0x1d4d000c, "Ralink RT3070 802.11b/g/n Wireless Lan USB Device" },
    { 0x1d4d000e, "Ralink RT3070 802.11b/g/n Wireless Lan USB Device" },
    { 0x1d501db5, "IDBG (DFU)" },
    { 0x1d501db6, "IDBG" },
    { 0x1d505117, "Neo1973/FreeRunner kernel usbnet (g_ether, CDC Ethernet) mode" },
    { 0x1d505118, "Neo1973/FreeRunner Debug board (V2+)" },
    { 0x1d505119, "Neo1973/FreeRunner u-boot cdc_acm serial port" },
    { 0x1d50511a, "HXD8 u-boot usbtty CDC ACM Mode" },
    { 0x1d50511b, "SMDK2440 u-boot usbtty CDC ACM mode" },
    { 0x1d50511c, "SMDK2443 u-boot usbtty CDC ACM mode" },
    { 0x1d50511d, "QT2410 u-boot usbtty CDC ACM mode" },
    { 0x1d505120, "Neo1973/FreeRunner u-boot usbtty generic serial" },
    { 0x1d505121, "Neo1973/FreeRunner kernel mass storage (g_storage) mode" },
    { 0x1d505122, "Neo1973/FreeRunner kernel cdc_ether USB network" },
    { 0x1d505123, "Neo1973/FreeRunner internal USB CSR4 module" },
    { 0x1d505124, "Neo1973/FreeRunner Bluetooth Device ID service" },
    { 0x1d505300, "Rockbox" },
    { 0x1d50530e, "iriver H10 20GB (Rockbox)" },
    { 0x1d50530f, "iriver H10 5/6GB (Rockbox)" },
    { 0x1d505314, "Apple iPod Color/Photo (Rockbox)" },
    { 0x1d505315, "Apple iPod Nano 1g (Rockbox)" },
    { 0x1d505316, "Apple iPod Video (Rockbox)" },
    { 0x1d505318, "Apple iPod 4g Grayscale (Rockbox)" },
    { 0x1d505319, "Apple iPod Mini 1g (Rockbox)" },
    { 0x1d50531a, "Apple iPod Mini 2g (Rockbox)" },
    { 0x1d50531c, "Apple iPod Nano 2g (Rockbox)" },
    { 0x1d50531d, "Apple iPod Classic/6G (Rockbox)" },
    { 0x1d505321, "Cowon D2 (Rockbox)" },
    { 0x1d505329, "Toshiba Gigabeat S (Rockbox)" },
    { 0x1d505332, "Sandisk Sansa e200 series (Rockbox)" },
    { 0x1d505334, "Sandisk Sansa c200 series (Rockbox)" },
    { 0x1d505337, "Sandisk Sansa Clip (Rockbox)" },
    { 0x1d505338, "Sandisk Sansa e200v2 series (Rockbox)" },
    { 0x1d505339, "Sandisk Sansa m200 v4 series (Rockbox)" },
    { 0x1d50533a, "Sandisk Sansa Fuze (Rockbox)" },
    { 0x1d50533b, "Sandisk Sansa c200v2 series (Rockbox)" },
    { 0x1d50533c, "Sandisk Sansa Clipv2 (Rockbox)" },
    { 0x1d50533e, "Sandisk Sansa Clip+ (Rockbox)" },
    { 0x1d50533f, "Sandisk Sansa Fuze v2 (Rockbox)" },
    { 0x1d505340, "Sandisk Sansa Fuze+ (Rockbox)" },
    { 0x1d505341, "Sandisk Sansa Zip (Rockbox)" },
    { 0x1d505342, "Sandisk Sansa Connect (Rockbox)" },
    { 0x1d505346, "Olympus M:Robe 500i (Rockbox)" },
    { 0x1d505347, "Olympus m:robe MR-100 (Rockbox)" },
    { 0x1d505359, "Creative Zen X-Fi Style (Rockbox)" },
    { 0x1d50535d, "Creative Zen X-Fi2 (Rockbox)" },
    { 0x1d50535e, "Creative Zen X-Fi3 (Rockbox)" },
    { 0x1d505360, "Creative Zen X-Fi (Rockbox)" },
    { 0x1d505361, "Creative ZEN Mozaic (Rockbox)" },
    { 0x1d505362, "Creative Zen (Rockbox)" },
    { 0x1d505364, "Philips GoGear SA9200 (Rockbox)" },
    { 0x1d505365, "Philips GoGear HDD16x0 (Rockbox)" },
    { 0x1d505366, "Philips GoGear HDD63x0 (Rockbox)" },
    { 0x1d505378, "Onda VX747 (Rockbox)" },
    { 0x1d505379, "Onda VX767 (Rockbox)" },
    { 0x1d50537b, "Onda VX777 (Rockbox)" },
    { 0x1d50538c, "Samsung YH-820 (Rockbox)" },
    { 0x1d50538d, "Samsung YH-920 (Rockbox)" },
    { 0x1d50538e, "Samsung YH-925 (Rockbox)" },
    { 0x1d5053a0, "Packard Bell Vibe 500 (Rockbox)" },
    { 0x1d5053b4, "Rockchip 27xx generic (Rockbox)" },
    { 0x1d5053be, "HiFiMAN HM-60x (Rockbox)" },
    { 0x1d5053bf, "HiFiMAN HM-801 (Rockbox)" },
    { 0x1d5053d2, "HiFi E.T. MA9 (Rockbox)" },
    { 0x1d5053d3, "HiFi E.T. MA9C (Rockbox)" },
    { 0x1d5053d4, "HiFi E.T. MA8 (Rockbox)" },
    { 0x1d5053d5, "HiFi E.T. MA8C (Rockbox)" },
    { 0x1d5053dc, "Sony NWZ-E370/E380 series (Rockbox)" },
    { 0x1d5053dd, "Sony NWZ-E360 series (Rockbox)" },
    { 0x1d5053e6, "IHIFI 760 (Rockbox)" },
    { 0x1d5053e7, "IHIFI 960 (Rockbox)" },
    { 0x1d5053ff, "Generic Rockbox device" },
    { 0x1d506000, "Ubertooth Zero" },
    { 0x1d506001, "Ubertooth Zero (DFU)" },
    { 0x1d506002, "Ubertooth One" },
    { 0x1d506003, "Ubertooth One (DFU)" },
    { 0x1d506004, "LeoLipo" },
    { 0x1d506005, "LED Flower S" },
    { 0x1d506006, "LED Cube" },
    { 0x1d506007, "LED Flower" },
    { 0x1d506008, "Kisbee 802.15.4 transceiver" },
    { 0x1d506009, "Adjacent Reality Tracker" },
    { 0x1d50600a, "AVR Programmer" },
    { 0x1d50600b, "Hypna Go Go" },
    { 0x1d50600c, "CatNip LPC1343 development board" },
    { 0x1d50600d, "Enhanced RoboBrrd Brain board" },
    { 0x1d50600e, "OpenRISC Ordb2a-ep4ce22 development board" },
    { 0x1d50600f, "Paparazzi Lisa/M (DFU)" },
    { 0x1d506010, "OpenPipe: OSHW Bagpipes MIDI controller" },
    { 0x1d506011, "LeoLipo (DFU)" },
    { 0x1d506012, "Universal C64 Cartridge" },
    { 0x1d506013, "DiscFerret magnetic disc analyser (bootloader)" },
    { 0x1d506014, "DiscFerret magnetic disc analyser" },
    { 0x1d506015, "Smoothieboard" },
    { 0x1d506016, "phInterface" },
    { 0x1d506017, "Black Magic Debug Probe (DFU)" },
    { 0x1d506018, "Black Magic Debug Probe (Application)" },
    { 0x1d506019, "4pi 5 axis motion controller" },
    { 0x1d50601a, "Paparazzi Lisa/M" },
    { 0x1d50601b, "IST-2 chronograph for bullet speeds" },
    { 0x1d50601c, "EPOSMote II" },
    { 0x1d50601d, "UDS18B20 temperature sensor" },
    { 0x1d50601e, "5x5 STM32 prototyping board" },
    { 0x1d50601f, "uNSF" },
    { 0x1d506020, "Toad3" },
    { 0x1d506021, "AlphaSphere" },
    { 0x1d506022, "LightPack" },
    { 0x1d506023, "Pixelkit" },
    { 0x1d506024, "Illucia" },
    { 0x1d506025, "Keyglove (HID)" },
    { 0x1d506026, "Keyglove (Serial)" },
    { 0x1d506027, "Key64 Keyboard" },
    { 0x1d506028, "Teensy 2.0 Development Board [ErgoDox Keyboard]" },
    { 0x1d506029, "Marlin 2.0 (Serial)" },
    { 0x1d50602a, "Marlin 2.0 (Mass Storage)" },
    { 0x1d50602b, "FPGALink" },
    { 0x1d50602c, "5nes5snes (5x8)" },
    { 0x1d50602d, "5nes5snes (4x12)" },
    { 0x1d50602e, "Flexibity" },
    { 0x1d50602f, "K-copter" },
    { 0x1d506030, "USB-oscope" },
    { 0x1d506031, "Handmade GSM GPS tracker" },
    { 0x1d506032, "ncrmnt.org uISP" },
    { 0x1d506033, "frobiac / adnw keyboard" },
    { 0x1d506034, "Tiflomag Ergo 2" },
    { 0x1d506035, "FreeLaserTag Gun" },
    { 0x1d506036, "FreeLaserTag Big Brother" },
    { 0x1d506037, "FreeLaserTag Node" },
    { 0x1d506038, "Monaka" },
    { 0x1d506039, "eXtreme Feedback Device" },
    { 0x1d50603a, "TiLDA" },
    { 0x1d50603b, "Raspiface" },
    { 0x1d50603c, "Paparazzi (bootloader)" },
    { 0x1d50603d, "Paparazzi (Serial)" },
    { 0x1d50603e, "Paparazzi (Mass Storage)" },
    { 0x1d50603f, "airGuitar" },
    { 0x1d506040, "moco" },
    { 0x1d506041, "AlphaSphere (bootloader)" },
    { 0x1d506042, "Dspace robot controller" },
    { 0x1d506043, "pc-power" },
    { 0x1d506044, "open-usb-can (DFU)" },
    { 0x1d506045, "open-usb-can" },
    { 0x1d506046, "mimus-weigand" },
    { 0x1d506047, "RfCat Chronos Dongle" },
    { 0x1d506048, "RfCat Dons Dongle" },
    { 0x1d506049, "RfCat Chronos bootloader" },
    { 0x1d50604a, "RfCat Dons bootloader" },
    { 0x1d50604b, "HackRF Jawbreaker Software-Defined Radio" },
    { 0x1d50604c, "Makibox A6" },
    { 0x1d50604d, "Paella Pulse height analyzer" },
    { 0x1d50604e, "Miniscope v2b" },
    { 0x1d50604f, "Miniscope v2c" },
    { 0x1d506050, "GoodFET" },
    { 0x1d506051, "pinocc.io" },
    { 0x1d506052, "APB Team Robotic Development Board" },
    { 0x1d506053, "Darkgame Controller" },
    { 0x1d506054, "Satlab/AAUSAT3 BlueBox" },
    { 0x1d506055, "RADiuS ER900TRS-02 transciever with SMA Connector" },
    { 0x1d506056, "The Glitch" },
    { 0x1d506057, "OpenPipe MIDI Shield" },
    { 0x1d506058, "Novena OTG port" },
    { 0x1d506059, "xser serial" },
    { 0x1d50605a, "Daisho test" },
    { 0x1d50605b, "RfCat YARD Stick One" },
    { 0x1d50605c, "YARD Stick One bootloader" },
    { 0x1d50605d, "Funky Sensor v2" },
    { 0x1d50605e, "Blinkiverse Analog LED Fader" },
    { 0x1d50605f, "Small DIP package Cypress FX2" },
    { 0x1d506060, "Data logger using the Cypress FX2" },
    { 0x1d506061, "Power Manager" },
    { 0x1d506062, "WhiteRabbit console and Wishbone bridge" },
    { 0x1d506063, "CPC FPGA" },
    { 0x1d506064, "CPC FPGA (DFU)" },
    { 0x1d506065, "CPC FPGA (Serial)" },
    { 0x1d506066, "Nuand BladeRF" },
    { 0x1d506067, "Orbotron 9000 (Serial)" },
    { 0x1d506068, "Orbotron 9000 (HID)" },
    { 0x1d506069, "xser (DFU)" },
    { 0x1d50606a, "xser (legacy)" },
    { 0x1d50606b, "S08-245, urJtag compatible firmware for S08JS" },
    { 0x1d50606c, "Blinkytape full-color light tape" },
    { 0x1d50606d, "TinyG open source motion controller" },
    { 0x1d50606e, "Reefangel Evolution 1.0" },
    { 0x1d50606f, "Geschwister Schneider CAN adapter" },
    { 0x1d506070, "Open Pinball Project" },
    { 0x1d506071, "The Glitch HID" },
    { 0x1d506072, "The Glitch Disk" },
    { 0x1d506073, "The Glitch Serial" },
    { 0x1d506074, "The Glitch MIDI" },
    { 0x1d506075, "The Glitch RawHID" },
    { 0x1d506076, "Vultureprog BIOS chip programmer" },
    { 0x1d506077, "PaintDuino" },
    { 0x1d506078, "DTplug" },
    { 0x1d506079, "Mood Light" },
    { 0x1d50607a, "Fadecandy" },
    { 0x1d50607b, "RCDongle for IR remote control" },
    { 0x1d50607c, "OpenVizsla USB sniffer/analyzer" },
    { 0x1d50607d, "Spark Core Arduino-compatible board with WiFi" },
    { 0x1d50607e, "OSHUG Wuthering multi-tool" },
    { 0x1d50607f, "Spark Core Arduino-compatible board with WiFi (bootloader)" },
    { 0x1d506080, "arcin arcade controller" },
    { 0x1d506081, "BladeRF (bootloader)" },
    { 0x1d506082, "Facecandy (DFU)" },
    { 0x1d506083, "LightUp (bootloader)" },
    { 0x1d506084, "arcin arcade controller (DFU)" },
    { 0x1d506085, "IRKit for controlloing home electronics from iOS devices" },
    { 0x1d506086, "OneRNG entropy device" },
    { 0x1d506087, "Blinkytape (alternate endpoint config)" },
    { 0x1d506088, "picp PIC16F145x based PIC16F145x programmer" },
    { 0x1d506089, "Great Scott Gadgets HackRF One SDR" },
    { 0x1d50608a, "BLEduino" },
    { 0x1d50608b, "Loctronix ASR-2300 SDR/motion sensing module" },
    { 0x1d50608c, "Fx2lafw" },
    { 0x1d50608d, "Fx2lafw" },
    { 0x1d50608e, "Fx2lafw" },
    { 0x1d50608f, "Fx2lafw" },
    { 0x1d506090, "Fx2lafw" },
    { 0x1d506091, "Fx2lafw" },
    { 0x1d506092, "Fx2lafw" },
    { 0x1d506093, "Fx2lafw" },
    { 0x1d506094, "Fx2lafw" },
    { 0x1d506095, "Fx2lafw" },
    { 0x1d506096, "LightUp (sketch)" },
    { 0x1d506097, "Tessel JavaScript enabled Microcontroller with built-in WiFi" },
    { 0x1d506098, "RFIDler" },
    { 0x1d506099, "RASDR Radio Astronomy SDR Rx Interface" },
    { 0x1d50609a, "RASDR Radio Astronomy SDR Tx Interface" },
    { 0x1d50609b, "RASDR Radio Astronomy SDR (bootloader)" },
    { 0x1d50609c, "antiAFK keyboard" },
    { 0x1d50609d, "PIC16F145x bootloader" },
    { 0x1d50609e, "Clyde Lamp by Fabule (bootloader)" },
    { 0x1d50609f, "Clyde Lamp by Fabule (sketch)" },
    { 0x1d5060a0, "Smoothiepanel robotic control interface" },
    { 0x1d5060a1, "Airspy" },
    { 0x1d5060a2, "barebox (DFU)" },
    { 0x1d5060a3, "keyboard (bootloader)" },
    { 0x1d5060a4, "Papilio Duo (AVR)" },
    { 0x1d5060a5, "Papilio Duo (FPGA)" },
    { 0x1d5060a6, "HydraBus/HydraNFC (bootloader)" },
    { 0x1d5060a7, "HydraBus/HydraNFC" },
    { 0x1d5060a8, "reserved" },
    { 0x1d5060a9, "Blinky Light Controller (DFU)" },
    { 0x1d5060aa, "Blinky Light Controller" },
    { 0x1d5060ab, "AllPixel" },
    { 0x1d5060ac, "OpenBLT generic microcontroller (bootloader)" },
    { 0x1d5060ad, "Clasic Gamepad Adapter (NES)" },
    { 0x1d5060ae, "Clasic Gamepad Adapter (N64)" },
    { 0x1d5060af, "Clasic Gamepad Adapter (DB9)" },
    { 0x1d5060b0, "Waterott Arduino based Clock (caterina bootloader)" },
    { 0x1d5060b1, "Drinkbot (processing)" },
    { 0x1d5060b2, "Drinkbot (OTG-tablet support)" },
    { 0x1d5060b3, "calc.pw password generator device (standard)" },
    { 0x1d5060b4, "calc.pw password generator device (enhanced)" },
    { 0x1d5060b5, "TimVideos' HDMI2USB (FX2) - Unconfigured device" },
    { 0x1d5060b6, "TimVideos' HDMI2USB (FX2) - Firmware load/upgrade" },
    { 0x1d5060b7, "TimVideos' HDMI2USB (FX2) - HDMI/DVI Capture Device" },
    { 0x1d5060b8, "TimVideos' HDMI2USB (Soft+UTMI) - Unconfigured device" },
    { 0x1d5060b9, "TimVideos' HDMI2USB (Soft+UTMI) - Firmware upgrade" },
    { 0x1d5060ba, "TimVideos' HDMI2USB (Soft+UTMI) - HDMI/DVI Capture Device" },
    { 0x1d5060bc, "Simple CC25xx programmer / serial board" },
    { 0x1d5060bd, "Open Source control interface for multimedia applications" },
    { 0x1d5060be, "Pixelmatix Aurora (bootloader)" },
    { 0x1d5060bf, "Pixelmatix Aurora" },
    { 0x1d5060c0, "Nucular Keyboard adapter" },
    { 0x1d5060c1, "BrewBit Model-T pOSHW temperature controller for homebrewers (bootloader)" },
    { 0x1d5060c2, "BrewBit Model-T pOSHW temperature controller for homebrewers" },
    { 0x1d5060c3, "X Antenna Tracker arduino board" },
    { 0x1d5060c4, "CAN bus communication device" },
    { 0x1d5060c5, "PIC16F1 bootloader" },
    { 0x1d5060c6, "USBtrng hardware random number generator" },
    { 0x1d5060c7, "Zubax GNSS positioning module for light UAV systems" },
    { 0x1d5060c8, "Xlink data transfer and control system for Commodore C64" },
    { 0x1d5060c9, "random number generator" },
    { 0x1d5060ca, "FinalKey password manager" },
    { 0x1d5060cb, "PteroDAQ Data Acquisition on FRDM-KL25Z and future boards" },
    { 0x1d5060cc, "LamDiNao" },
    { 0x1d5060cd, "Open Lighting DMX512 / RDM widget" },
    { 0x1d5060de, "Cryptech.is random number generator" },
    { 0x1d5060df, "Numato Opsis HDMI2USB board (unconfigured)" },
    { 0x1d5060e0, "Numato Opsis HDMI2USB board (JTAG Programming Mode)" },
    { 0x1d5060e1, "Numato Opsis HDMI2USB board (User Mode)" },
    { 0x1d5060e2, "Osmocom SIMtrace 2 (DFU)" },
    { 0x1d5060e3, "Osmocom SIMtrace 2" },
    { 0x1d5060e4, "3D printed racing game - (Catalina CDC bootloader)" },
    { 0x1d5060e5, "3D printed racing game" },
    { 0x1d5060e6, "replacement for GoodFET/FaceDancer - GreatFet" },
    { 0x1d5060e7, "replacement for GoodFET/FaceDancer - GreatFet target" },
    { 0x1d5060e8, "Alpen Clack keyboard" },
    { 0x1d5060e9, "keyman64 keyboard itercepter" },
    { 0x1d5060ea, "Wiggleport FPGA-based I/O board" },
    { 0x1d5060eb, "candleLight CAN adapter" },
    { 0x1d5060ec, "Duet 2 WiFi or Duet 2 Ethernet 3D printer control electronics" },
    { 0x1d5060ed, "Duet 2 Maestro 3D printer control electronics" },
    { 0x1d5060ee, "Duet 3 motion control electronics" },
    { 0x1d5060f0, "UDAD-T1 data aquisition device (boot)" },
    { 0x1d5060f1, "UDAD-T1 data aquisition device" },
    { 0x1d5060f2, "UDAD-T2 data aquisition device (boot)" },
    { 0x1d5060f3, "UDAD-T2 data aquisition device" },
    { 0x1d5060f4, "Uniti ARC motor controller" },
    { 0x1d5060f5, "EightByEight Blinky Badge (DFU)" },
    { 0x1d5060f6, "EightByEight Blinky Badge" },
    { 0x1d5060f7, "cardio NFC/RFID card reader (bootloader)" },
    { 0x1d5060f8, "cardio NFC/RFID card reader" },
    { 0x1d5060fc, "OnlyKey Two-factor Authentication and Password Solution" },
    { 0x1d506100, "overlay64 video overlay module" },
    { 0x1d506104, "ScopeFun open source instrumentation" },
    { 0x1d506108, "Myriad-RF LimeSDR" },
    { 0x1d50610c, "Magic Keys (boot)" },
    { 0x1d50610d, "Magic Keys" },
    { 0x1d506114, "MIDI key" },
    { 0x1d506118, "Thomson MO5 keyboard" },
    { 0x1d506122, "Ultimate Hacking Keyboard" },
    { 0x1d50614c, "dwtk In-Circuit Emulator" },
    { 0x1d508085, "Box0 (box0-v5)" },
    { 0x1d50cc15, "rad1o badge for CCC summer camp 2015" },
    { 0x1d570005, "Wireless Receiver (Keyboard and Mouse)" },
    { 0x1d570006, "Wireless Receiver (RC Laser Pointer)" },
    { 0x1d57000c, "Optical Mouse" },
    { 0x1d57130f, "2.4Ghz wireless optical mouse receiver" },
    { 0x1d572400, "Wireless Mouse Receiver" },
    { 0x1d5732da, "2.4GHz Receiver (Keyboard and Mouse)" },
    { 0x1d5783d0, "Click-mouse!" },
    { 0x1d57ac01, "Wireless Receiver (Keyboard and Mouse)" },
    { 0x1d57ac02, "ViFit Activity Tracker" },
    { 0x1d57ac08, "RFID Receiver (Keyboard)" },
    { 0x1d57ad02, "SE340D PC Remote Control" },
    { 0x1d57ad03, "[T3] 2.4GHz and IR Air Mouse Remote Control" },
    { 0x1d57af01, "AUVIO Universal Remote Receiver for PlayStation 3" },
    { 0x1d57af03, "Wireless Receiver" },
    { 0x1d57fa20, "2.4GHz Wireless Reciever (Mini Keyboard & Mouse)" },
    { 0x1d5c2000, "FL2000/FL2000DX VGA/DVI/HDMI Adapter" },
    { 0x1d6b0001, "1.1 root hub" },
    { 0x1d6b0002, "2.0 root hub" },
    { 0x1d6b0003, "3.0 root hub" },
    { 0x1d6b0100, "PTP Gadget" },
    { 0x1d6b0101, "Audio Gadget" },
    { 0x1d6b0102, "EEM Gadget" },
    { 0x1d6b0103, "NCM (Ethernet) Gadget" },
    { 0x1d6b0104, "Multifunction Composite Gadget" },
    { 0x1d6b0105, "FunctionFS Gadget" },
    { 0x1d6b0200, "Qemu Audio Device" },
    { 0x1d880001, "Measurement Device [MarECon]" },
    { 0x1d880002, "Probe" },
    { 0x1d880003, "Surface Measurement [PS10]" },
    { 0x1d90201e, "PPU-700" },
    { 0x1d902037, "CL-S631 Barcode Printer" },
    { 0x1d9020f0, "Thermal Receipt Printer [CT-E351]" },
    { 0x1d9d1010, "Docking Station Topline 2009" },
    { 0x1d9d1011, "Docking Station Topline 2012" },
    { 0x1d9d1012, "Docking Station Topline 2016" },
    { 0x1dd30001, "Expert I/O 1000" },
    { 0x1de11101, "Generic Display Device (Mass storage mode)" },
    { 0x1de1c101, "Generic Display Device" },
    { 0x1e0ef000, "iCON 210 UMTS Surfstick" },
    { 0x1e102004, "Sony 1.3MP 1/3\" ICX445 IIDC video camera [Chameleon]" },
    { 0x1e170001, "instadose dosimeter" },
    { 0x1e1d0165, "Secure Pen drive" },
    { 0x1e1d1101, "FlashBlu Flash Drive" },
    { 0x1e290101, "CPX Adapter" },
    { 0x1e290102, "CPX Adapter >=HW10.09 [CP2102]" },
    { 0x1e290401, "iL3-TP [AT90USB646]" },
    { 0x1e290402, "FTDI232 [EasyPort]" },
    { 0x1e290403, "FTDI232 [EasyPort Mini]" },
    { 0x1e290404, "FTDI232 [Netzteil-GL]" },
    { 0x1e290405, "FTDI232 [MotorPr\303\274fstand]" },
    { 0x1e290406, "STM32F103 [EasyKit]" },
    { 0x1e290407, "LPC2378 [Robotino]" },
    { 0x1e290408, "LPC2378 [Robotino-Arm]" },
    { 0x1e290409, "LPC2378 [Robotino-Arm Bootloader]" },
    { 0x1e29040a, "LPC2378 [Robotino Bootloader]" },
    { 0x1e29040b, "LPC2378 [Robotino XT]" },
    { 0x1e29040c, "LPC2378 [Robotino XT Bootloader]" },
    { 0x1e29040d, "LPC2378 [Robotino 3]" },
    { 0x1e29040e, "LPC2378 [Robotino 3 Bootloader]" },
    { 0x1e29040f, "LPC2148 [Robotino gripper]" },
    { 0x1e290410, "LPC2148 [Robotino IR panel]" },
    { 0x1e290501, "CP2102 [CMSP]" },
    { 0x1e290601, "CMMP-AS" },
    { 0x1e290602, "FTDI232 [CMMS]" },
    { 0x1e2d004f, "EGS3 GSM/GPRS modem" },
    { 0x1e2d0054, "PH8 wireless module" },
    { 0x1e2d0058, "Wireless Module [Cinterion EHS6]" },
    { 0x1e2d0059, "Wireless Module [Cinterion BGx]" },
    { 0x1e2d005b, "Zoom 4625 Modem" },
    { 0x1e2d0061, "ALSx PLSx LTE modem" },
    { 0x1e2d00a0, "Cinterion ELS31-V" },
    { 0x1e3d198a, "Flash Disk" },
    { 0x1e3d2093, "CBM209x Flash Drive (OEM)" },
    { 0x1e3d4082, "CBM4082 SD Card Reader" },
    { 0x1e410001, "CS328A PC Oscilloscope" },
    { 0x1e410004, "CS448" },
    { 0x1e447220, "SM-BCR2" },
    { 0x1e4e0100, "WebCam" },
    { 0x1e4e0102, "GL-UPC822 UVC WebCam" },
    { 0x1e4e0109, "EtronTech CMOS based eSP570 WebCam [Onyx Titanium TC101]" },
    { 0x1e530005, "Conceptronic CMTD2" },
    { 0x1e530006, "O2 Sistemas ZoltarTV" },
    { 0x1e530007, "Wyplay Wyplayer" },
    { 0x1e542030, "2030 USB Keyboard" },
    { 0x1e680002, "TrekStor i.Beat Organix 2.0" },
    { 0x1e68001b, "DataStation maxi g.u" },
    { 0x1e68004c, "DataStation Pocket Click" },
    { 0x1e680050, "DataStation maxi light" },
    { 0x1e681045, "ST70408-3 [SurfTab breeze 7.0 quad 3G] (MTP Mode)" },
    { 0x1e681046, "ST70408-3 [SurfTab breeze 7.0 quad 3G] (PTP Mode)" },
    { 0x1e710001, "Avatar Optical Mouse" },
    { 0x1e71170e, "Kraken X" },
    { 0x1e711711, "Grid+ V3" },
    { 0x1e711714, "Smart Device" },
    { 0x1e711715, "Kraken M22" },
    { 0x1e712006, "Smart Device V2" },
    { 0x1e742211, "MP300" },
    { 0x1e742647, "2 GB 2 Go Video MP3 Player [MP601-2G]" },
    { 0x1e742659, "Coby 4GB Go Video MP3 Player [MP620-4G]" },
    { 0x1e744641, "A8705 MP3/Video Player" },
    { 0x1e746511, "MP705-8G MP3 player" },
    { 0x1e746512, "Coby COBY MP705" },
    { 0x1e747111, "MP957 Music and Video Player" },
    { 0x1e7b0002, "HF2" },
    { 0x1e7b0003, "UHF" },
    { 0x1e7b0004, "MFLI" },
    { 0x1e7d2c24, "Pyra Mouse (wired)" },
    { 0x1e7d2c2e, "Lua Mouse" },
    { 0x1e7d2c38, "Kiro Mouse" },
    { 0x1e7d2ced, "Kone Mouse" },
    { 0x1e7d2cee, "Kova 2016 Gray Mouse" },
    { 0x1e7d2cef, "Kova 2016 White Mouse" },
    { 0x1e7d2cf0, "Kova 2016 Black Mouse" },
    { 0x1e7d2cf6, "Pyra Mouse (wireless)" },
    { 0x1e7d2d50, "Kova[+] Mouse" },
    { 0x1e7d2d51, "Kone[+] Mouse" },
    { 0x1e7d2d5a, "Savu Mouse" },
    { 0x1e7d2db4, "Kone Pure Optical Mouse" },
    { 0x1e7d2dbe, "Kone Pure Mouse" },
    { 0x1e7d2dbf, "Kone Pure Military Mouse" },
    { 0x1e7d2dc2, "Kone Pure Optical Black Mouse" },
    { 0x1e7d2dcb, "Kone Pure SE(L) Mouse" },
    { 0x1e7d2e22, "Kone XTD Mouse" },
    { 0x1e7d2e23, "Kone XTD Optical Mouse" },
    { 0x1e7d2e27, "Kone AIMO Mouse" },
    { 0x1e7d2e4a, "Tyon Black Mouse" },
    { 0x1e7d2e4b, "Tyon White Mouse" },
    { 0x1e7d2e7c, "Nyth Black Mouse" },
    { 0x1e7d2e7d, "Nyth White Mouse" },
    { 0x1e7d2f76, "Sova Keyboard" },
    { 0x1e7d2f94, "Sova MK Keyboard" },
    { 0x1e7d2fa8, "Suora Keyboard" },
    { 0x1e7d2fc6, "Skeltr Keyboard" },
    { 0x1e7d2fda, "Ryos MK FX Keyboard" },
    { 0x1e7d30d4, "Arvo Keyboard" },
    { 0x1e7d3138, "Ryos MK Keyboard" },
    { 0x1e7d316a, "Ryos TKL Keyboard" },
    { 0x1e7d319c, "Isku Keyboard" },
    { 0x1e7d31ce, "Ryos MK Glow Keyboard" },
    { 0x1e7d3232, "Ryos MK Pro Keyboard" },
    { 0x1e7d3246, "Suora FX Keyboard" },
    { 0x1e7d3264, "Isku FX Keyboard" },
    { 0x1e8e6001, "P8GR" },
    { 0x1e91b0b1, "miniStack" },
    { 0x1ea70030, "Trust GXT 158 Orna Laser Gaming Mouse" },
    { 0x1ea70064, "2.4GHz Wireless rechargeable vertical mouse [More&Better]" },
    { 0x1ea70066, "[Mediatrack Edge Mini Keyboard]" },
    { 0x1ea70907, "Keyboard" },
    { 0x1ea71002, "Vintorez Gaming Mouse" },
    { 0x1ea72007, "SHARK ZONE K30 Illuminated Gaming Keyboard" },
    { 0x1eab0103, "HR200 Barcode scanner engine (HID keyboard)" },
    { 0x1eab0106, "HR200 Barcode scanner engine (Serial CDC)" },
    { 0x1eab0110, "HR200 Barcode scanner engine (HID Pos)" },
    { 0x1eab0c03, "HR100/HR3260 cordless/HR3290 cordless/BS80 Barcode scanner engine (HID keyboard)" },
    { 0x1eab0c06, "HR100/HR3260 cordless/HR3290 cordless/BS80 Barcode scanner engine (USB Serial CDC)" },
    { 0x1eab0c10, "HR100/HR3260 cordless/HR3290 cordless/BS80 Barcode scanner engine (HID Pos)" },
    { 0x1eab0d03, "EM2028 Barcode scanner engine (HID keyboard)" },
    { 0x1eab0d06, "EM2028 Barcode scanner engine (Serial CDC)" },
    { 0x1eab0d10, "EM2028 Barcode scanner engine (HID Pos)" },
    { 0x1eab1303, "EM30xx/EM20xx/HR3260 corded/HR200C Barcode scanner engine (HID keyboard)" },
    { 0x1eab1306, "EM30xx/EM20xx/HR3260 corded/HR200C Barcode scanner engine (USB serial CDC)" },
    { 0x1eab1310, "EM30xx/EM20xx/HR3260 corded/HR200C Barcode scanner engine (HID Pos)" },
    { 0x1eab1403, "HR15-xx Barcode scanner engine (HID keyboard)" },
    { 0x1eab1406, "HR15-xx Barcode scanner engine (Serial CDC)" },
    { 0x1eab1410, "HR15-xx Barcode scanner engine (HID Pos)" },
    { 0x1eab1603, "FM100-M/3250 Barcode scanner engine (HID keyboard)" },
    { 0x1eab1606, "FM100-M/3250 Barcode scanner engine (Serial CDC)" },
    { 0x1eab1610, "FM100-M/3250 Barcode scanner engine (HID Pos)" },
    { 0x1eab1903, "EM1300 Barcode scanner engine (HID keyboard)" },
    { 0x1eab1906, "EM1300 Barcode scanner engine (Serial CDC)" },
    { 0x1eab1910, "EM1300 Barcode scanner engine (HID Pos)" },
    { 0x1eab1a03, "HR3290 corded/HR22 Barcode scanner engine (HID keyboard)" },
    { 0x1eab1a06, "HR3290 corded/HR22 Barcode scanner engine (Serial CDC)" },
    { 0x1eab1a10, "HR3290 corded/HR22 Barcode scanner engine (HID Pos)" },
    { 0x1eab1c03, "HR2150 Barcode scanner engine (HID keyboard)" },
    { 0x1eab1c06, "HR2150 Barcode scanner engine (Serial CDC)" },
    { 0x1eab1c10, "HR2150 Barcode scanner engine (HID Pos)" },
    { 0x1eab1d03, "FM430 Barcode scanner engine (HID keyboard)" },
    { 0x1eab1d06, "FM430 Barcode scanner engine (Serial CDC)" },
    { 0x1eab1d10, "FM430 Barcode scanner engine (HID Pos)" },
    { 0x1eab1e03, "HR42 Barcode scanner engine (HID keyboard)" },
    { 0x1eab1e06, "HR42 Barcode scanner engine (Serial CDC)" },
    { 0x1eab1e10, "HR42 Barcode scanner engine (HID Pos)" },
    { 0x1eab1f03, "HR11+ Barcode scanner engine (HID keyboard)" },
    { 0x1eab1f06, "HR11+ Barcode scanner engine (Serial CDC)" },
    { 0x1eab1f10, "HR11+ Barcode scanner engine (HID Pos)" },
    { 0x1eab2003, "EM2037v2 Barcode scanner engine (HID keyboard)" },
    { 0x1eab2006, "EM2037v2 Barcode scanner engine (Serial CDC)" },
    { 0x1eab2010, "EM2037v2 Barcode scanner engine (HID Pos)" },
    { 0x1eab8003, "EM13x5-LD/HR15-70/HR100-70/HR12/HR1150-70 Barcode scanner engine (HID keyboard)" },
    { 0x1eab8006, "EM13x5-LD/HR15-70/HR100-70/HR12/HR1150-70 Barcode scanner engine (USB Serial CDC)" },
    { 0x1eab8010, "EM13x5-LD/HR15-70/HR100-70/HR12/HR1150-70 Barcode scanner engine (HID Pos)" },
    { 0x1eab8203, "EM3080-01/EM3095/FR20/FM30 Barcode scanner engine (HID keyboard)" },
    { 0x1eab8206, "EM3080-01/EM3095/FR20/FM30 Barcode scanner engine (USB Serial CDC)" },
    { 0x1eab8210, "EM3080-01/EM3095/FR20/FM30 Barcode scanner engine (HID Pos)" },
    { 0x1eab8303, "HR2160 Barcode scanner engine (HID keyboard)" },
    { 0x1eab8306, "HR2160 Barcode scanner engine (Serial CDC)" },
    { 0x1eab8310, "HR2160 Barcode scanner engine (HID Pos)" },
    { 0x1eaf0003, "Maple DFU interface" },
    { 0x1eaf0004, "Maple serial interface" },
    { 0x1eb87f00, "MW-U3500 WiMAX adapter" },
    { 0x1ecb02e2, "JMR1140 [Jiofi]" },
    { 0x1ed80004, "Mustang I/II" },
    { 0x1ed80005, "Mustang III/IV/V" },
    { 0x1ed80006, "Mustang I/II [Firmware Update]" },
    { 0x1ed80007, "Mustang III/IV/V [Firmware Update]" },
    { 0x1ed80010, "Mustang Mini" },
    { 0x1ed80011, "Mustang Mini [Firmware Update]" },
    { 0x1ed80014, "Mustang I (V.2)" },
    { 0x1ed80016, "Mustang IV v.2" },
    { 0x1eda2012, "Air2210 54 Mbps Wireless Adapter" },
    { 0x1eda2210, "Air2210 54 Mbps Wireless Adapter" },
    { 0x1eda2310, "Air2310 150 Mbps Wireless Adapter" },
    { 0x1eda2410, "Air2410 300 Mbps Wireless Adapter" },
    { 0x1edbbd3b, "Intensity Shuttle" },
    { 0x1edbbd46, "Mini Converter Analog to SDI" },
    { 0x1edbbd75, "2.5K Cinema Camera (BMCC)" },
    { 0x1ee80014, "MT833UP" },
    { 0x1ef62233, "Cassidian NH90 STTE" },
    { 0x1ef65064, "FDR Interface" },
    { 0x1ef65523, "Cassidian SSDC Adapter II" },
    { 0x1ef65545, "Cassidian SSDC Adapter III" },
    { 0x1ef65648, "RIU CSMU/BSD" },
    { 0x1ef6564a, "Cassidian RIU CSMU/BSD Simulator" },
    { 0x1f0c2000, "HP StreamSmart 410 [NW278AA]" },
    { 0x1f280020, "CDMA USB Modem A600" },
    { 0x1f280021, "CD INSTALLER USB Device" },
    { 0x1f3a1000, "Prestigio PER3464B ebook reader (Mass storage mode)" },
    { 0x1f3a1002, "mediacom XPRO 415" },
    { 0x1f3a1010, "Android device in fastboot mode" },
    { 0x1f3aefe8, "sunxi SoC OTG connector in FEL/flashing mode" },
    { 0x1f440001, "NM-1000 scanner" },
    { 0x1f480627, "Data capturing system" },
    { 0x1f480628, "Data capturing and control module" },
    { 0x1f4da115, "EVOLVEO XtraTV stick [DVB-T]" },
    { 0x1f4db803, "Lifeview LV5TDLX DVB-T [RTL2832U]" },
    { 0x1f4dc803, "NotOnlyTV (Lifeview) LV5TDLX DVB-T [RTL2832U]" },
    { 0x1f4dd220, "Geniatech T220 DVB-T2 TV Stick" },
    { 0x1f520001, "Ultima 49 Printer" },
    { 0x1f520002, "Ultima 90 Printer" },
    { 0x1f520003, "FormsPro 50 Printer" },
    { 0x1f520004, "Ultima 90+ Printer" },
    { 0x1f6f0023, "Jawbone Jambox" },
    { 0x1f6f8000, "Jawbone Jambox - Updating" },
    { 0x1f750611, "IS611 SATA/PATA Bridge Controller" },
    { 0x1f750621, "IS621 SATA Storage Controller" },
    { 0x1f750888, "IS888 SATA Storage Controller" },
    { 0x1f750902, "IS902 UFD controller" },
    { 0x1f750916, "IS916 Flash Drive" },
    { 0x1f750917, "IS917 Mass storage" },
    { 0x1f750918, "IS918 Flash Drive" },
    { 0x1f820001, "PrecisionHD Camera" },
    { 0x1f841f7e, "Lateral Flow Engine" },
    { 0x1f870002, "Multi-touch HID Controller" },
    { 0x1f9b0241, "AirView2-EXT" },
    { 0x1f9bb0b1, "UniFi VoIP Phone" },
    { 0x1fab104d, "ES65" },
    { 0x1fac0232, "U770 3G/4G Wimax/4G LTE Modem" },
    { 0x1fae0040, "M311 Fingerprint Scanner" },
    { 0x1fae212c, "M30x (Mercury) fingerprint sensor" },
    { 0x1fb20001, "Wi-Fi Body Scale (WBS01)" },
    { 0x1fbd0001, "Expert Key - Data aquisition system" },
    { 0x1fc90003, "LPC1343" },
    { 0x1fc9000c, "LPC4330FET180 [ARM Cortex M4 + M0] (device firmware upgrade mode)" },
    { 0x1fc90082, "LPC4330FET180 [ARM Cortex M4 + M0] (mass storage controller mode)" },
    { 0x1fc9010b, "PR533" },
    { 0x1fc90126, "i.MX 7ULP SystemOnChip in RecoveryMode" },
    { 0x1fc9012b, "i.MX 8M Dual/8M QuadLite/8M Quad Serial Downloader" },
    { 0x1fc95002, "PTN5002 [Startech VGA/DVI-D adapter]" },
    { 0x1fc98124, "SharkRF Bootloader" },
    { 0x1fc9824c, "LumiNode1" },
    { 0x1fde0001, "UART Bridge" },
    { 0x1fe71000, "VW100 series CDMA EV-DO Rev.A modem" },
    { 0x1ff70013, "CVTouch Screen (HID)" },
    { 0x1ff7001a, "Human Interface Device" },
    { 0x1ffb0081, "AVR Programmer" },
    { 0x1ffb0083, "Jrk 21v3 Motor Controller" },
    { 0x1ffb0089, "Micro Maestro 6-Servo Controller" },
    { 0x1ffb008a, "Mini Maestro 12-Channel Servo Controller" },
    { 0x1ffb008b, "Mini Maestro 18-Channel Servo Controller" },
    { 0x1ffb008c, "Mini Maestro 24-Channel Servo Controller" },
    { 0x1ffb00b0, "AVR Programmer v2" },
    { 0x20001f0c, "HP StreamSmart 410 [NW278AA]" },
    { 0x20010001, "DWL-120 WIRELESS ADAPTER" },
    { 0x20010201, "DHN-120 10Mb Home Phoneline Adapter" },
    { 0x20011a00, "DUB-E100 Fast Ethernet Adapter(rev.A) [ASIX AX88172]" },
    { 0x20011a02, "DUB-E100 Fast Ethernet Adapter(rev.C1) [ASIX AX88772]" },
    { 0x2001200c, "10/100 Ethernet" },
    { 0x20013101, "DWA-182 AC1200 DB Wireless Adapter(rev.A1) [Broadcom BCM43526]" },
    { 0x20013200, "DWL-120 802.11b Wireless Adapter(rev.E1) [Atmel at76c503a]" },
    { 0x20013301, "DWA-130 802.11n Wireless N Adapter(rev.C1) [Realtek RTL8192U]" },
    { 0x20013306, "DWL-G122 Wireless Adapter(rev.F1) [Realtek RTL8188SU]" },
    { 0x20013308, "DWA-121 802.11n Wireless N 150 Pico Adapter [Realtek RTL8188CUS]" },
    { 0x20013309, "DWA-135 802.11n Wireless N Adapter(rev.A1) [Realtek RTL8192CU]" },
    { 0x2001330a, "DWA-133 802.11n Wireless N Adapter [Realtek RTL8192CU]" },
    { 0x2001330d, "DWA-131 802.11n Wireless N Nano Adapter (rev.B1) [Realtek RTL8192CU]" },
    { 0x2001330f, "DWA-125 Wireless N 150 Adapter(rev.D1) [Realtek RTL8188ETV]" },
    { 0x20013310, "DWA-123 Wireless N 150 Adapter (rev.D1)" },
    { 0x20013314, "DWA-171 AC600 DB Wireless Adapter(rev.A1) [Realtek RTL8811AU]" },
    { 0x20013315, "DWA-182 Wireless AC Dualband Adapter(rev.C) [Realtek RTL8812AU]" },
    { 0x20013317, "DWA-137 Wireless N High-Gain Adapter [Ralink RT5372]" },
    { 0x20013319, "DWA-131 Wireless N Nano Adapter (Rev. E1) [Realtek RTL8192EU]" },
    { 0x20013500, "Elitegroup Computer Systems WLAN card WL-162" },
    { 0x20013700, "DWL-122 802.11b [Intersil Prism 3]" },
    { 0x20013701, "DWL-G120 Spinnaker 802.11g [Intersil ISL3886]" },
    { 0x20013702, "DWL-120 802.11b Wireless Adapter(rev.F) [Intersil ISL3871]" },
    { 0x20013703, "AirPlus G DWL-G122 Wireless Adapter(rev.A1) [Intersil ISL3880]" },
    { 0x20013704, "AirPlus G DWL-G122 Wireless Adapter(rev.A2) [Intersil ISL3887]" },
    { 0x20013705, "AirPlus G DWL-G120 Wireless Adapter(rev.C) [Intersil ISL3887]" },
    { 0x20013761, "IEEE 802.11g USB2.0 Wireless Network Adapter-PN" },
    { 0x20013a00, "DWL-AG132 [Atheros AR5523]" },
    { 0x20013a01, "DWL-AG132 (no firmware) [Atheros AR5523]" },
    { 0x20013a02, "DWL-G132 [Atheros AR5523]" },
    { 0x20013a03, "DWL-G132 (no firmware) [Atheros AR5523]" },
    { 0x20013a04, "DWL-AG122 [Atheros AR5523]" },
    { 0x20013a05, "DWL-AG122 (no firmware) [Atheros AR5523]" },
    { 0x20013a80, "AirPlus Xtreme G DWL-G132 Wireless Adapter" },
    { 0x20013a81, "predator Bootloader Download" },
    { 0x20013a82, "AirPremier AG DWL-AG132 Wireless Adapter" },
    { 0x20013a83, "predator Bootloader Download" },
    { 0x20013b00, "AirPlus DWL-120+ Wireless Adapter [Texas Instruments ACX100USB]" },
    { 0x20013b01, "WLAN Boot Device" },
    { 0x20013c00, "AirPlus G DWL-G122 Wireless Adapter(rev.B1) [Ralink RT2571]" },
    { 0x20013c01, "AirPlus AG DWL-AG122 Wireless Adapter" },
    { 0x20013c02, "AirPlus G DWL-G122 Wireless Adapter" },
    { 0x20013c05, "DUB-E100 Fast Ethernet Adapter(rev.B1) [ASIX AX88772]" },
    { 0x20013c15, "DWA-140 RangeBooster N Adapter(rev.B3) [Ralink RT5372]" },
    { 0x20013c17, "DWA-123 Wireless N 150 Adapter(rev.A1) [Ralink RT3370]" },
    { 0x20013c19, "DWA-125 Wireless N 150 Adapter(rev.A3) [Ralink RT5370]" },
    { 0x20013c1a, "DWA-160 802.11abgn Xtreme N Dual Band Adapter(rev.B2) [Ralink RT5572]" },
    { 0x20013c1b, "DWA-127 Wireless N 150 High-Gain Adapter(rev.A1) [Ralink RT3070]" },
    { 0x20013c1e, "DWA-125 Wireless N 150 Adapter(rev.B1) [Ralink RT5370]" },
    { 0x20014000, "DSB-650C Ethernet [klsi]" },
    { 0x20014001, "DSB-650TX Ethernet [pegasus]" },
    { 0x20014002, "DSB-650TX Ethernet [pegasus]" },
    { 0x20014003, "DSB-650TX-PNA Ethernet [pegasus]" },
    { 0x2001400b, "10/100 Ethernet" },
    { 0x20014102, "10/100 Ethernet" },
    { 0x20014a00, "DUB-1312 Gigabit Ethernet Adapter" },
    { 0x20015100, "DSL-200 ADSL ATM Modem" },
    { 0x20015102, "DSL-200 ADSL Loader" },
    { 0x20015b00, "Remote NDIS Network Device" },
    { 0x20019414, "Cable Modem" },
    { 0x20019b00, "Broadband Cable Modem Remote NDIS Device" },
    { 0x2001abc1, "DSB-650 Ethernet [pegasus]" },
    { 0x2001f013, "DLink 7 port USB2.0 Hub" },
    { 0x2001f103, "DUB-H7 7-port USB 2.0 hub" },
    { 0x2001f10d, "Accent Communications Modem" },
    { 0x2001f110, "DUB-AV300 A/V Capture" },
    { 0x2001f111, "DBT-122 Bluetooth adapter" },
    { 0x2001f112, "DUB-T210 Audio Device" },
    { 0x2001f116, "Formosa 2" },
    { 0x2001f117, "Formosa 3" },
    { 0x2001f118, "Formosa 4" },
    { 0x2003ea61, "dc3500" },
    { 0x20095004, "datAshur 4GB" },
    { 0x20095016, "datAshur 16GB" },
    { 0x20095032, "datAshur 32GB" },
    { 0x200c100b, "Play audio soundcard" },
    { 0x20130242, "QuatroStick 510e" },
    { 0x20130245, "PCTV 73ESE" },
    { 0x20130246, "PCTV 74E" },
    { 0x20130248, "PCTV 282E" },
    { 0x2013024c, "DVB-S2 Stick 460e" },
    { 0x2013024f, "nanoStick T2 290e" },
    { 0x20130251, "QuatroStick nano 520e" },
    { 0x20130258, "DVB-S2 Stick 461e" },
    { 0x2013025a, "AndroiDTV 78e" },
    { 0x2013025f, "tripleStick 292e" },
    { 0x20130262, "microStick 79e" },
    { 0x20180406, "Eumex 800" },
    { 0x20180408, "Eumex 800" },
    { 0x20193220, "GW-US11S WLAN [Atmel AT76C503A]" },
    { 0x20194901, "GW-USSuper300 802.11bgn Wireless Adapter [Realtek RTL8191SU]" },
    { 0x20194903, "GW-USFang300 802.11abgn Wireless Adapter [Realtek RTL8192DU]" },
    { 0x20194904, "GW-USUltra300 802.11abgn Wireless Adapter [Realtek RTL8192DU]" },
    { 0x20195303, "GW-US54GXS 802.11bg" },
    { 0x20195304, "GWUS300 802.11n" },
    { 0x2019ab01, "GW-US54HP" },
    { 0x2019ab24, "GW-US300MiniS" },
    { 0x2019ab25, "GW-USMini2N 802.11n Wireless Adapter [Ralink RT2870]" },
    { 0x2019ab28, "GW-USNano" },
    { 0x2019ab29, "GW-USMicro300" },
    { 0x2019ab2a, "GW-USNano2 802.11n Wireless Adapter [Realtek RTL8188CUS]" },
    { 0x2019ab2b, "GW-USEco300 802.11bgn Wireless Adapter [Realtek RTL8192CU]" },
    { 0x2019ab2c, "GW-USDual300 802.11abgn Wireless Adapter [Realtek RTL8192DU]" },
    { 0x2019ab50, "GW-US54Mini2" },
    { 0x2019c002, "GW-US54SG" },
    { 0x2019c007, "GW-US54GZL" },
    { 0x2019ed02, "GW-USMM" },
    { 0x2019ed06, "GW-US300MiniW 802.11bgn Wireless Adapter" },
    { 0x2019ed10, "GW-US300Mini2" },
    { 0x2019ed14, "GW-USMicroN" },
    { 0x2019ed16, "GW-USMicroN2W 802.11bgn Wireless Adapter [Realtek RTL8188SU]" },
    { 0x2019ed17, "GW-USValue-EZ 802.11n Wireless Adapter [Realtek RTL8188CUS]" },
    { 0x2019ed18, "GW-USHyper300 / GW-USH300N 802.11bgn Wireless Adapter [Realtek RTL8191SU]" },
    { 0x201e2009, "CE100 CDMA EVDO" },
    { 0x203d1480, "ENUWI-N3 [802.11n Wireless N150 Adapter]" },
    { 0x20400265, "WinTV-dualHD DVB" },
    { 0x2040026d, "WinTV-dualHD ATSC" },
    { 0x20400c80, "Windham" },
    { 0x20400c90, "Windham" },
    { 0x20401605, "WinTV-HVR 930C HD" },
    { 0x20401700, "CataMount" },
    { 0x20401800, "Okemo A" },
    { 0x20401801, "Okemo B" },
    { 0x20402000, "Tiger Minicard" },
    { 0x20402009, "Tiger Minicard R2" },
    { 0x2040200a, "Tiger Minicard" },
    { 0x20402010, "Tiger Minicard" },
    { 0x20402011, "WinTV MiniCard [Dell Digital TV Receiver]" },
    { 0x20402019, "Tiger Minicard" },
    { 0x20402400, "WinTV PVR USB2 (Model 24019)" },
    { 0x20404200, "WinTV" },
    { 0x20404700, "WinTV Nova-S-USB2" },
    { 0x20404902, "HD PVR" },
    { 0x20404903, "HS PVR" },
    { 0x20404982, "HD PVR" },
    { 0x20405500, "Windham" },
    { 0x20405510, "Windham" },
    { 0x20405520, "Windham" },
    { 0x20405530, "Windham" },
    { 0x20405580, "Windham" },
    { 0x20405590, "Windham" },
    { 0x20406500, "WinTV HVR-900" },
    { 0x20406502, "WinTV HVR-900" },
    { 0x20406503, "WinTV HVR-930" },
    { 0x20406513, "WinTV HVR-950/HVR-980" },
    { 0x20406600, "WinTV HVR-900H (Model 660xx)" },
    { 0x20407050, "Nova-T Stick" },
    { 0x20407060, "Nova-T Stick 2" },
    { 0x20407070, "Nova-T Stick 3" },
    { 0x20407240, "WinTV HVR-850" },
    { 0x20408400, "WinTV Nova-T-500" },
    { 0x20409300, "WinTV NOVA-T USB2 (cold)" },
    { 0x20409301, "WinTV NOVA-T USB2 (warm)" },
    { 0x20409941, "WinTV Nova-T-500" },
    { 0x20409950, "WinTV Nova-T-500" },
    { 0x2040b123, "WinTV-HVR-955Q" },
    { 0x2040b138, "WinTV-HVR-900 model 00246 [WinTV-T Video]" },
    { 0x2040b910, "Windham" },
    { 0x2040b980, "Windham" },
    { 0x2040b990, "Windham" },
    { 0x2040c000, "Windham" },
    { 0x2040c010, "Windham" },
    { 0x20470013, "MSP eZ-FET lite" },
    { 0x20470014, "MSP-FET" },
    { 0x20470200, "MSP430 Bootloader" },
    { 0x20470203, "eZ-FET Bootloader" },
    { 0x20470204, "MSP-FET Bootloader" },
    { 0x20470300, "MSP430 CDC Example" },
    { 0x20470301, "MSP430 HID Datapipe Example" },
    { 0x20470302, "MSP430 CDC+HID Example" },
    { 0x20470309, "MSP430 HID Mouse Example" },
    { 0x20470313, "MSP430 CDC+CDC Example" },
    { 0x20470314, "MSP430 HID+HID Example" },
    { 0x20470315, "MSP430 HID Keyboard Example" },
    { 0x20470316, "MSP430 MSC File System Emulation Example" },
    { 0x20470317, "MSP430 MSC SD Card Example" },
    { 0x20470318, "MSP430 MSC Multiple LUNs Example" },
    { 0x20470319, "MSP430 MSC+CDC+HID Example" },
    { 0x20470320, "MSP430 SYSBIOS Tasks MSC+CDC+HID Example" },
    { 0x20470321, "MSP430 SYSBIOS SWIs MSC+CDC+HID Example" },
    { 0x20470322, "MSP430 MSC Double-Buffering Example" },
    { 0x20470323, "MSP430 MSC CD-ROM Example" },
    { 0x204703df, "MSP430 User Experiment" },
    { 0x204703e0, "MSP430 User Experiment" },
    { 0x204703e1, "MSP430 User Experiment" },
    { 0x204703e2, "MSP430 User Experiment" },
    { 0x204703e3, "MSP430 User Experiment" },
    { 0x204703e4, "MSP430 User Experiment" },
    { 0x204703e5, "MSP430 User Experiment" },
    { 0x204703e6, "MSP430 User Experiment" },
    { 0x204703e7, "MSP430 User Experiment" },
    { 0x204703e8, "MSP430 User Experiment" },
    { 0x204703e9, "MSP430 User Experiment" },
    { 0x204703ea, "MSP430 User Experiment" },
    { 0x204703eb, "MSP430 User Experiment" },
    { 0x204703ec, "MSP430 User Experiment" },
    { 0x204703ed, "MSP430 User Experiment" },
    { 0x204703ee, "MSP430 User Experiment" },
    { 0x204703ef, "MSP430 User Experiment" },
    { 0x204703f0, "MSP430 User Experiment" },
    { 0x204703f1, "MSP430 User Experiment" },
    { 0x204703f2, "MSP430 User Experiment" },
    { 0x204703f3, "MSP430 User Experiment" },
    { 0x204703f4, "MSP430 User Experiment" },
    { 0x204703f5, "MSP430 User Experiment" },
    { 0x204703f6, "MSP430 User Experiment" },
    { 0x204703f7, "MSP430 User Experiment" },
    { 0x204703f8, "MSP430 User Experiment" },
    { 0x204703f9, "MSP430 User Experiment" },
    { 0x204703fa, "MSP430 User Experiment" },
    { 0x204703fb, "MSP430 User Experiment" },
    { 0x204703fc, "MSP430 User Experiment" },
    { 0x204703fd, "MSP430 User Experiment" },
    { 0x20470401, "MSP430 Keyboard Example" },
    { 0x20470855, "Invensense Embedded MotionApp HID Sensor" },
    { 0x204708f8, "FDC2x14/LDC13xx/LDC16xx EVM" },
    { 0x20470964, "Inventio Software MSP430" },
    { 0x20470a76, "GEOKON S-3810A-5 USB-RS485 CONVERTER" },
    { 0x2047ffe7, "HID v1.00 Device [Improv Device]" },
    { 0x20582058, "ViperBoard I2C, SPI, GPIO interface" },
    { 0x20779002, "W1M100 HSPA/WCDMA Module" },
    { 0x20800001, "nook" },
    { 0x20800002, "NOOKcolor" },
    { 0x20800003, "NOOK Simple Touch" },
    { 0x20800004, "NOOK Tablet" },
    { 0x20800005, "BNTV600 [Nook HD+]" },
    { 0x20800006, "BNTV400 [Nook HD]" },
    { 0x20800007, "BNRV500 [Nook Glowlight]" },
    { 0x2080000a, "BNRV510 [Nook Glowlight Plus]" },
    { 0x2080000b, "BNRV520 [Nook Glowlight 3]" },
    { 0x2080000c, "BNRV700 [Nook Glowlight Plus]" },
    { 0x20870a01, "Multi Touch Panel" },
    { 0x20870a02, "Multi Touch Panel" },
    { 0x20870b03, "Multi Touch Panel" },
    { 0x20a00006, "flirc" },
    { 0x20a04107, "GPF Crypto Stick V1.2" },
    { 0x20a04123, "IKALOGIC SCANALOGIC 2" },
    { 0x20a0414a, "MDE SPI Interface" },
    { 0x20a0415a, "OpenPilot" },
    { 0x20a0415b, "CopterControl" },
    { 0x20a0415c, "PipXtreme" },
    { 0x20a041e5, "BlinkStick" },
    { 0x20a04211, "Nitrokey Start" },
    { 0x20a04223, "ATSAMD21 [castAR]" },
    { 0x20a0428d, "Electrosense wideband converter" },
    { 0x20b110ad, "XUSB Loader" },
    { 0x20b1f7d1, "XTAG2 - JTAG Adapter" },
    { 0x20b30a18, "10.1 Touch screen overlay" },
    { 0x20b70713, "Milkymist JTAG/serial" },
    { 0x20b71540, "ben-wpan, AT86RF230-based" },
    { 0x20b71db5, "IDBG in DFU mode" },
    { 0x20b71db6, "IDBG in normal mode" },
    { 0x20b79db1, "Glasgow Debug Tool" },
    { 0x20b7c25b, "C2 Dongle" },
    { 0x20b7cb72, "ben-wpan, cntr" },
    { 0x20bc5500, "Frostbite controller" },
    { 0x20ce0012, "RF Sythesizer 250-4200MHz model SSG-4000LH" },
    { 0x20ce0021, "RF Switch Matrix" },
    { 0x20ce0022, "I/O Controller" },
    { 0x20df0001, "Entropy Key [UDEKEY01]" },
    { 0x20f02102, "EWLA V2 Module" },
    { 0x20f10101, "iCube3 Camera" },
    { 0x20f4646b, "TEW-646UBH High Power 150Mbps Wireless N Adapter [Realtek RTL8188SU]" },
    { 0x20f4648b, "TEW-648UBM 802.11n 150Mbps Micro Wireless N Adapter [Realtek RTL8188CUS]" },
    { 0x20f4664b, "TEW-664UB H/W:V2.0R" },
    { 0x20f4804b, "TEW-804UB 802.11a/b/g/n/ac (1x1) Wireless Adapter [Realtek RTL8811AU]" },
    { 0x20f4805b, "TEW-805UB 300Mbps+867Mbps Wireless AC Adapter [Realtek RTL8812AU]" },
    { 0x20f4806b, "TEW-806UBH 802.11a/b/g/n/ac (1x1) Wireless Adapter [MediaTek MT7610U]" },
    { 0x20f73001, "MQ or MD camera" },
    { 0x20f73002, "MU camera" },
    { 0x20f73021, "MJ camera" },
    { 0x20f730b3, "MQ in U3V mode or MC camera" },
    { 0x20f7a003, "MU camera" },
    { 0x21000e56, "USB62C Radio Cable [Yaesu 857/D - 897/D]" },
    { 0x21009e50, "USB-59 Radio Cable [Yaesu VX-8/D/DR]" },
    { 0x21009e52, "Yaesu VX-7" },
    { 0x21009e54, "CT29B Radio Cable" },
    { 0x21009e57, "RTS01 Radio Cable" },
    { 0x21009e58, "USB63C Radio Cable [Yaesu FTDX-1200]" },
    { 0x21009e5d, "K4Y Radio Cable" },
    { 0x21009e5f, "FT232RL [RTS05 Serial Cable]" },
    { 0x21010201, "SIIG 4-to-2 Printer Switch" },
    { 0x21011402, "Keyboard/Mouse Switch" },
    { 0x21040050, "Eye tracker [EYEX2]" },
    { 0x21040124, "Eyechip" },
    { 0x21090210, "Hub" },
    { 0x21090700, "VL700 SATA 3Gb/s bridge" },
    { 0x21090701, "VL701 SATA 3Gb/s bridge" },
    { 0x21090711, "VL711 SATA 6Gb/s bridge" },
    { 0x21090715, "VL817 SATA Adaptor" },
    { 0x21090810, "VL81x Hub" },
    { 0x21090811, "Hub" },
    { 0x21090812, "VL812 Hub" },
    { 0x21090813, "VL813 Hub" },
    { 0x21090820, "VL820 Hub" },
    { 0x21092210, "Hub" },
    { 0x21092811, "Hub" },
    { 0x21092812, "VL812 Hub" },
    { 0x21092813, "VL813 Hub" },
    { 0x21092820, "VL820 Hub" },
    { 0x21093431, "Hub" },
    { 0x2109711f, "External" },
    { 0x21098110, "Hub" },
    { 0x21130137, "DepthSense 311 (3D)" },
    { 0x21130145, "DepthSense 325" },
    { 0x21138000, "DepthSense 311 (Color)" },
    { 0x2116000a, "IDE Hard Drive Enclosure" },
    { 0x211f6801, "CDMA Products" },
    { 0x21231010, "Rocket Launcher" },
    { 0x21250000, "Bootloader" },
    { 0x21250010, "MCB-100 Series" },
    { 0x21330001, "LCD Signature Pad Sigma" },
    { 0x21330018, "Delta Pen" },
    { 0x21330019, "Delta Touch" },
    { 0x2133001c, "Kronos Pen" },
    { 0x21330022, "Epsilon Pen" },
    { 0x2149211b, "Touchscreen Controller" },
    { 0x21492306, "TS58xxA/TC56xxA [CoolTouch]" },
    { 0x21492703, "TS58xxA/TC56xxA [CoolTouch]" },
    { 0x214b7000, "4-port hub [Maxxter ACT-HUB2-4P, HS8836, iSoul ultra-slim]" },
    { 0x214e0005, "Z - Gaming mouse [SM700]" },
    { 0x21622031, "Network Blaster Wireless Adapter" },
    { 0x2162500c, "DE5771 Modem Blaster" },
    { 0x21628001, "Broadxent BritePort DSL Bridge 8010U" },
    { 0x2166600b, "TH-D74" },
    { 0x21840005, "GDS-3000 Oscilloscope" },
    { 0x21840006, "GDS-3000 Oscilloscope" },
    { 0x21840011, "AFG Function Generator (CDC)" },
    { 0x21840017, "DSO" },
    { 0x21840018, "DSO" },
    { 0x21840036, "AFG-125 Function Generator (CDC)" },
    { 0x21880610, "Hub" },
    { 0x21880611, "Hub" },
    { 0x21880620, "Hub" },
    { 0x21880625, "Hub" },
    { 0x21880754, "Card Reader" },
    { 0x21884042, "CalDigit Pro Audio" },
    { 0x219c0010, "USB 2200 K Secure Sign Token" },
    { 0x21a10001, "EPOC Consumer Headset Wireless Dongle" },
    { 0x21a4ac27, "SPORTS Active 2 Wireless Controller for PS3" },
    { 0x21a4ac40, "SPORTS Active 2 Wireless Controller for Wii" },
    { 0x21a91001, "16-channel Logic Analyzer [Logic16]" },
    { 0x21a91003, "Logic 4" },
    { 0x21a91004, "Logic8" },
    { 0x21a91005, "Logic Pro 8" },
    { 0x21a91006, "Logic Pro 16" },
    { 0x21ab0010, "RC700 NFC SmartCard Reader" },
    { 0x21ab0011, "DSR700 SmartCard Reader" },
    { 0x21b40081, "DragonFly" },
    { 0x21b40082, "DragonFly Red" },
    { 0x21d60002, "Seismic recorder [Tellus]" },
    { 0x22070001, "Various Viewpia DR/bq Kepler" },
    { 0x22070010, "GoClever Tab R83" },
    { 0x22070011, "SmartTab" },
    { 0x2207281a, "RK2818 in Mask ROM mode" },
    { 0x2207290a, "RK2918 in Mask ROM mode" },
    { 0x2207292a, "RK2928 in Mask ROM mode" },
    { 0x2207292c, "RK3026 in Mask ROM mode" },
    { 0x2207300a, "RK3066 in Mask ROM mode" },
    { 0x2207300b, "RK3168 in Mask ROM mode" },
    { 0x2207301a, "RK3036 in Mask ROM mode" },
    { 0x2207310a, "RK3066B in Mask ROM mode" },
    { 0x2207310b, "RK3188 in Mask ROM mode" },
    { 0x2207310c, "RK3126/RK3128 in Mask ROM mode" },
    { 0x2207310d, "RK3126 in Mask ROM mode" },
    { 0x2207320a, "RK3288 in Mask ROM mode" },
    { 0x2207320b, "RK3228/RK3229 in Mask ROM mode" },
    { 0x2207320c, "RK3328 in Mask ROM mode" },
    { 0x2207330a, "RK3368 in Mask ROM mode" },
    { 0x2207330c, "RK3399 in Mask ROM mode" },
    { 0x221a0100, "FPGA Boards" },
    { 0x22220004, "iWebKey Keyboard" },
    { 0x22220005, "ICEKey Keyboard" },
    { 0x22221001, "Generic Hub" },
    { 0x22222520, "Mini Tablet" },
    { 0x22224050, "AirStick joystick" },
    { 0x22273105, "SKYDATA SKD-U100" },
    { 0x222a0001, "Multi-Touch Screen" },
    { 0x222a0037, "Multi-Touch Screen" },
    { 0x22300001, "UD-160-A / M Integrated Hub" },
    { 0x22300003, "DC-125 / M Integrated Hub" },
    { 0x22321005, "WebCam SCB-0385N" },
    { 0x22321024, "Webcam SC-13HDL11624N [Namuga Co., Ltd.]" },
    { 0x22321028, "WebCam SC-03FFL11939N" },
    { 0x22321029, "WebCam SC-13HDL11939N" },
    { 0x22321037, "WebCam SC-03FFM12339N" },
    { 0x22321045, "WebCam SC-10HDP12631N" },
    { 0x22336323, "USB Electronic Scale" },
    { 0x22374161, "eReader White" },
    { 0x22374163, "Touch" },
    { 0x22374173, "Glo" },
    { 0x22451500, "AST1500/1510 PC-over-LAN Virtual Hub" },
    { 0x224f0001, "Access Point" },
    { 0x224f0002, "Docking Station" },
    { 0x224f0004, "V2 Opal ACM" },
    { 0x224f0005, "V2 Opal" },
    { 0x224f0006, "V2 Docking Station" },
    { 0x224f0007, "V2 Access Point ACM" },
    { 0x224f0008, "V2 Access Point" },
    { 0x22561007, "LV3 MIDI Controller" },
    { 0x225d0001, "FINGER VP Multimodal Biometric Sensor" },
    { 0x225d0008, "CBM-E3 Fingerprint Sensor" },
    { 0x225d0009, "CBM-V3 Fingerprint Sensor" },
    { 0x225d000a, "MSO1300-E3 Fingerprint Sensor" },
    { 0x225d000b, "MSO1300-V3 Fingerprint Sensor" },
    { 0x225d000c, "MSO1350-E3 Fingerprint Sensor & SmartCard Reader" },
    { 0x225d000d, "MSO1350-V3 Fingerprint Sensor & SmartCard Reader" },
    { 0x225d000e, "MorphoAccess SIGMA Biometric Access Control Terminal" },
    { 0x225d9015, "Tablet 2" },
    { 0x225d9024, "Tablet 2" },
    { 0x225d9039, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225d904d, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225d904e, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225d9091, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225d9092, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225df000, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225df003, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225df006, "Tablet 2 secure multifunction biometric tablet" },
    { 0x225df00e, "Tablet 2 secure multifunction biometric tablet" },
    { 0x228d0001, "Terminal Bike Key Reader" },
    { 0x22a6ffff, "PieKey \"beta\" 4GB model 4E4F41482E4F5247 (SM3251Q BB)" },
    { 0x22a71001, "FortiGate Device" },
    { 0x22b11000, "Netduino MCU pcb" },
    { 0x22b80001, "Wally 2.2 chipset" },
    { 0x22b80002, "Wally 2.4 chipset" },
    { 0x22b80005, "V.60c/V.60i GSM Phone" },
    { 0x22b8002e, "XT1806" },
    { 0x22b80830, "2386C-HT820" },
    { 0x22b80833, "2386C-HT820 [Flash Mode]" },
    { 0x22b80850, "Bluetooth Device" },
    { 0x22b81001, "Patriot 1.0 (GSM) chipset" },
    { 0x22b81002, "Patriot 2.0 chipset" },
    { 0x22b81005, "T280e GSM/GPRS Phone" },
    { 0x22b81101, "Patriot 1.0 (TDMA) chipset" },
    { 0x22b81801, "Rainbow chipset flash" },
    { 0x22b82035, "Bluetooth Device" },
    { 0x22b82805, "GSM Modem" },
    { 0x22b82821, "T720 GSM Phone" },
    { 0x22b82822, "V.120e GSM Phone" },
    { 0x22b82823, "Flash Interface" },
    { 0x22b82a01, "MSM6050 chipset" },
    { 0x22b82a02, "CDMA modem" },
    { 0x22b82a03, "MSM6050 chipset flash" },
    { 0x22b82a21, "V710 GSM Phone (P2K)" },
    { 0x22b82a22, "V710 GSM Phone (AT)" },
    { 0x22b82a23, "MSM6100 chipset flash" },
    { 0x22b82a41, "MSM6300 chipset" },
    { 0x22b82a42, "Usb Modem" },
    { 0x22b82a43, "MSM6300 chipset flash" },
    { 0x22b82a61, "E815 GSM Phone (P2K)" },
    { 0x22b82a62, "E815 GSM Phone (AT)" },
    { 0x22b82a63, "MSM6500 chipset flash" },
    { 0x22b82a65, "Motorola V3m/V750 verizon" },
    { 0x22b82a81, "MSM6025 chipset" },
    { 0x22b82a83, "MSM6025 chipset flash" },
    { 0x22b82ac1, "MSM6100 chipset" },
    { 0x22b82ac3, "MSM6100 chipset flash" },
    { 0x22b82d78, "XT300[SPICE]" },
    { 0x22b82e82, "XT1541 [Moto G 3rd Gen]" },
    { 0x22b82e83, "XT1033 [Moto G], PTP mode" },
    { 0x22b83001, "A835/E1000 GSM Phone (P2K)" },
    { 0x22b83002, "A835/E1000 GSM Phone (AT)" },
    { 0x22b83801, "C350L/C450 (P2K)" },
    { 0x22b83802, "C330/C350L/C450/EZX GSM Phone (AT)" },
    { 0x22b83803, "Neptune LT chipset flash" },
    { 0x22b84001, "OMAP 1.0 chipset" },
    { 0x22b84002, "A920/A925 UMTS Phone" },
    { 0x22b84003, "OMAP 1.0 chipset flash" },
    { 0x22b84008, "OMAP 1.0 chipset RDL" },
    { 0x22b841cf, "Motorola Xoom 2 Media Edition (ID2)" },
    { 0x22b841d6, "Motorola Droid X/MB525 (Defy)" },
    { 0x22b841d9, "Droid/Milestone" },
    { 0x22b841db, "Droid/Milestone (Debug mode)" },
    { 0x22b841dc, "Motorola Milestone / Verizon Droid" },
    { 0x22b841de, "Droid X (PC mode)" },
    { 0x22b84204, "MPx200 Smartphone" },
    { 0x22b84214, "MPc GSM" },
    { 0x22b84224, "MPx220 Smartphone" },
    { 0x22b84234, "MPc CDMA" },
    { 0x22b84244, "MPx100 Smartphone" },
    { 0x22b84285, "Droid X (Mass storage)" },
    { 0x22b842a7, "Motorola DROID2" },
    { 0x22b842d9, "XT910 [Droid RAZR]" },
    { 0x22b84311, "Motorola Xoom 2 Media Edition" },
    { 0x22b84362, "Motorola XT912/XT928" },
    { 0x22b8437f, "Motorola DROID4" },
    { 0x22b84801, "Neptune LTS chipset" },
    { 0x22b84803, "Neptune LTS chipset flash" },
    { 0x22b84810, "Triplet GSM Phone (storage)" },
    { 0x22b84811, "Motorola IdeaPad K1" },
    { 0x22b84901, "Triplet GSM Phone (P2K)" },
    { 0x22b84902, "Triplet GSM Phone (AT)" },
    { 0x22b84903, "Neptune LTE chipset flash" },
    { 0x22b84a01, "Neptune LTX chipset" },
    { 0x22b84a03, "Neptune LTX chipset flash" },
    { 0x22b84a32, "L6-imode Phone" },
    { 0x22b85801, "Neptune ULS chipset" },
    { 0x22b85803, "Neptune ULS chipset flash" },
    { 0x22b85901, "Neptune VLT chipset" },
    { 0x22b85903, "Neptune VLT chipset flash" },
    { 0x22b86001, "Dalhart EZX" },
    { 0x22b86003, "Dalhart flash" },
    { 0x22b86004, "EZX GSM Phone (CDC Net)" },
    { 0x22b86006, "MOTOROKR E6" },
    { 0x22b86008, "Dalhart RDL" },
    { 0x22b86009, "EZX GSM Phone (P2K)" },
    { 0x22b8600a, "Dalhart EZX config 17" },
    { 0x22b8600b, "Dalhart EZX config 18" },
    { 0x22b8600c, "EZX GSM Phone (USBLAN)" },
    { 0x22b86021, "JUIX chipset" },
    { 0x22b86023, "JUIX chipset flash" },
    { 0x22b86026, "Flash RAM Downloader/miniOS" },
    { 0x22b86027, "USBLAN" },
    { 0x22b8604c, "EZX GSM Phone (Storage)" },
    { 0x22b860ca, "Motorola A1200" },
    { 0x22b86101, "Talon integrated chipset" },
    { 0x22b86401, "Argon chipset" },
    { 0x22b86403, "Argon chipset flash" },
    { 0x22b86411, "ROKR Z6 (print mode)" },
    { 0x22b86413, "Motorola MTP Test Command Interface" },
    { 0x22b86415, "Motorola RAZR2 V8/U9/Z6" },
    { 0x22b86422, "ROKR Z6 (modem mode)" },
    { 0x22b86426, "ROKR Z6 (storage mode)" },
    { 0x22b86604, "Washington CDMA Phone" },
    { 0x22b86631, "CDC Modem" },
    { 0x22b87001, "Q Smartphone" },
    { 0x22b87086, "Atrix" },
    { 0x22b870a3, "Motorola Xoom (Factory test)" },
    { 0x22b870a8, "Motorola Xoom (MTP)" },
    { 0x22b870a9, "Motorola Xoom (MTP+ADB)" },
    { 0x22b870ca, "Motorola Milestone X2" },
    { 0x22b8fe01, "StarTAC III MS900" },
    { 0x22b90006, "Touch Screen" },
    { 0x22ba0108, "Double Shock Steering Wheel HID" },
    { 0x22ba0109, "Double Shock Steering Wheel Hub" },
    { 0x22c90601, "naturaSign Pad Colour" },
    { 0x22c90701, "naturaSign Pad Mobile" },
    { 0x22c90801, "naturaSign Pad Comfort" },
    { 0x22c90881, "naturaSign Pad Flawless" },
    { 0x22c90901, "naturaSign Pad Classic" },
    { 0x22c909e1, "naturaSign Pad Biometric" },
    { 0x22c90ce1, "duraSign Pad Brilliance" },
    { 0x22c90cf1, "duraSign Pad Biometric 5.0" },
    { 0x22c90d01, "duraSign 10.0" },
    { 0x22c90df1, "duraSign Pad Biometric 10.0" },
    { 0x22d41301, "Mionix NAOS 8200 [STM32F103 MCU]" },
    { 0x22d41308, "Mionix Avior 7000" },
    { 0x22d4130c, "Mionix Naos 7000" },
    { 0x22d41316, "Mionix Castor" },
    { 0x22d92765, "Oppo N1" },
    { 0x22d92767, "Oppo Find 5 (X909)" },
    { 0x22db0003, "IQ3 100MP IG030372" },
    { 0x22dc0004, "BlueField SOC" },
    { 0x22e00002, "SINA Flash Drive" },
    { 0x22e00003, "SINA ID Token A" },
    { 0x22e86512, "651N Audio" },
    { 0x22e86969, "Audio Prototype" },
    { 0x22e87512, "751R Audio" },
    { 0x22e8770a, "X70A Audio" },
    { 0x22e8850c, "851C Audio [Azur 850C]" },
    { 0x22e8851d, "851D Audio [Azur 851D]" },
    { 0x22e8ca02, "Audio" },
    { 0x22e8ca04, "Audio" },
    { 0x22e8ca06, "AmpMagic" },
    { 0x22e8dac2, "DacMagic Plus" },
    { 0x22e8dac3, "Azur DacMagic 100" },
    { 0x22e8dac4, "Azur DacMagic 100" },
    { 0x22e8dac6, "DacMagicXS 2.0" },
    { 0x22e8dac8, "Audio" },
    { 0x23040109, "Studio PCTV USB (SECAM)" },
    { 0x23040110, "Studio PCTV USB (PAL)" },
    { 0x23040111, "Miro PCTV USB" },
    { 0x23040112, "Studio PCTV USB (NTSC) with FM radio" },
    { 0x23040201, "Systems MovieBox Device" },
    { 0x23040204, "MovieBox USB_B" },
    { 0x23040205, "DVC 150B" },
    { 0x23040206, "Systems MovieBox Deluxe Device" },
    { 0x23040207, "Dazzle DVC90 Video Device" },
    { 0x23040208, "Studio PCTV USB2" },
    { 0x2304020e, "PCTV 200e" },
    { 0x2304020f, "PCTV 400e BDA Device" },
    { 0x23040210, "Studio PCTV USB (PAL) with FM radio" },
    { 0x23040212, "Studio PCTV USB (NTSC)" },
    { 0x23040213, "500-USB Device" },
    { 0x23040214, "Studio PCTV USB (PAL) with FM radio" },
    { 0x23040216, "PCTV 60e" },
    { 0x23040219, "PCTV 260e" },
    { 0x2304021a, "Dazzle DVC100 Audio Device" },
    { 0x2304021b, "Dazzle DVC130/DVC170" },
    { 0x2304021d, "Dazzle DVC130" },
    { 0x2304021e, "Dazzle DVC170" },
    { 0x2304021f, "PCTV Sat HDTV Pro BDA Device" },
    { 0x23040222, "PCTV Sat Pro BDA Device" },
    { 0x23040223, "DazzleTV Sat BDA Device" },
    { 0x23040225, "Remote Kit Infrared Transceiver" },
    { 0x23040226, "PCTV 330e" },
    { 0x23040227, "PCTV for Mac, HD Stick" },
    { 0x23040228, "PCTV DVB-T Flash Stick" },
    { 0x23040229, "PCTV Dual DVB-T 2001e" },
    { 0x2304022a, "PCTV 160e" },
    { 0x2304022b, "PCTV 71e [Afatech AF9015]" },
    { 0x23040232, "PCTV 170e" },
    { 0x23040236, "PCTV 72e [DiBcom DiB7000PC]" },
    { 0x23040237, "PCTV 73e [DiBcom DiB7000PC]" },
    { 0x2304023a, "PCTV 801e" },
    { 0x2304023b, "PCTV 801e SE" },
    { 0x2304023d, "PCTV 340e" },
    { 0x2304023e, "PCTV 340e SE" },
    { 0x23040300, "Studio Linx Video input cable (NTSC)" },
    { 0x23040301, "Studio Linx Video input cable (PAL)" },
    { 0x23040302, "Dazzle DVC120" },
    { 0x23040419, "PCTV Bungee USB (PAL) with FM radio" },
    { 0x2304061d, "PCTV Deluxe (NTSC) Device" },
    { 0x2304061e, "PCTV Deluxe (PAL) Device" },
    { 0x23042304, "1689" },
    { 0x230d0103, "Huwaii 3g wireless modem" },
    { 0x23180011, "CitiDISK Jr. IDE Enclosure" },
    { 0x23190014, "TSM01 Air Mouse + Keyboard" },
    { 0x232b0810, "P2000" },
    { 0x232e0010, "EA-PS-2000 B Series Power Supply" },
    { 0x23410001, "Uno (CDC ACM)" },
    { 0x23410010, "Mega 2560 (CDC ACM)" },
    { 0x23410036, "Leonardo Bootloader" },
    { 0x2341003b, "Serial Adapter (CDC ACM)" },
    { 0x2341003d, "Due Programming Port" },
    { 0x2341003e, "Due" },
    { 0x2341003f, "Mega ADK (CDC ACM)" },
    { 0x23410042, "Mega 2560 R3 (CDC ACM)" },
    { 0x23410043, "Uno R3 (CDC ACM)" },
    { 0x23410044, "Mega ADK R3 (CDC ACM)" },
    { 0x23410045, "Serial R3 (CDC ACM)" },
    { 0x23410049, "ISP" },
    { 0x23418036, "Leonardo (CDC ACM, HID)" },
    { 0x23418038, "Robot Control Board (CDC ACM, HID)" },
    { 0x23418039, "Robot Motor Board (CDC ACM, HID)" },
    { 0x234b0000, "Gnuk Token" },
    { 0x234b0001, "NeuG True RNG" },
    { 0x23570005, "M7350 4G Mi-Fi Router" },
    { 0x23570100, "TL-WN8200ND [Realtek RTL8192CU]" },
    { 0x23570101, "RTL8812AU Archer T4U 802.11ac" },
    { 0x23570103, "Archer T4UH wireless Realtek 8812AU" },
    { 0x23570105, "Archer T1U 802.11a/n/ac Wireless Adapter [MediaTek MT7610U]" },
    { 0x23570106, "Archer T9UH v1 [Realtek RTL8814AU]" },
    { 0x23570107, "TL-WN821N v5/v6 [RTL8192EU]" },
    { 0x23570108, "TL-WN822N Version 4 RTL8192EU" },
    { 0x23570109, "TL-WN823N v2/v3 [Realtek RTL8192EU]" },
    { 0x2357010b, "Archer T2UHP [MediaTek MT7610U]" },
    { 0x2357010c, "TL-WN722N v2/v3 [Realtek RTL8188EUS]" },
    { 0x2357010d, "Archer T4U v2 [Realtek RTL8812AU]" },
    { 0x2357010e, "Archer T4UH v2 [Realtek RTL8812AU]" },
    { 0x2357010f, "Archer T4UHP [Realtek RTL8812AU]" },
    { 0x23570115, "Archer T4U ver.3" },
    { 0x2357011e, "AC600 wireless Realtek RTL8811AU [Archer T2U Nano]" },
    { 0x23570120, "Archer T2U PLUS [RTL8821AU]" },
    { 0x2357012d, "Archer T3U [Realtek RTL8812BU]" },
    { 0x23570200, "MA 180 Zero CD" },
    { 0x23570201, "HSUPA Modem MA180" },
    { 0x23570600, "UE300 10/100/1000 LAN (mass storage CD-ROM mode) [Realtek RTL8153]" },
    { 0x23570601, "UE300 10/100/1000 LAN (ethernet mode) [Realtek RTL8153]" },
    { 0x23660001, "Reserved Prototyping PID" },
    { 0x23660002, "OpenBeacon USB 2" },
    { 0x23660003, "OpenPCD 2 RFID Reader for 13.56MHz" },
    { 0x23660004, "OpenBeacon" },
    { 0x23660005, "Blinkenlights WDIM" },
    { 0x23660006, "Blinkenlights WMCU" },
    { 0x23660007, "OpenBeacon Ethernet EasyReader PoE II - Active 2.4GHz RFID Reader" },
    { 0x23660008, "OpenBeacon WLAN" },
    { 0x23660009, "OpenPCD 2 RFID Reader for 13.56MHz" },
    { 0x2366000a, "OpenPCD 2 Audio & LCD Display" },
    { 0x23670002, "OP-1 Portable synthesizer" },
    { 0x2367000c, "OP-Z Portable synthesizer" },
    { 0x23680001, "BBS-1 [BodyBeat Sync]" },
    { 0x236a1965, "SB6501 802.11ad Wireless Network Adapter" },
    { 0x23730001, "5 MegaPixel Digital Still Camera [DSC5M]" },
    { 0x23750001, "Digital Audio Player" },
    { 0x2378100a, "Universal Wireless Controller" },
    { 0x237d0400, "MC400" },
    { 0x23863125, "Touch System" },
    { 0x23864328, "Touch System" },
    { 0x2386432f, "Touch System" },
    { 0x238b0a11, "DMR Radio" },
    { 0x239a0001, "CDC Bootloader" },
    { 0x239a801e, "Trinket M0" },
    { 0x23a00001, "Token iBank2key" },
    { 0x23a00002, "iBank2Key Type M Token" },
    { 0x23a00003, "iToken" },
    { 0x23a00008, "MS_KEY K - Angara" },
    { 0x23a62000, "Gibson Firebird X Pedal Board" },
    { 0x23a62001, "Gibson Firebird X Switch Board" },
    { 0x23b40200, "DW0200 Color Camera" },
    { 0x23b40300, "DW0300 Hight Speed Monochrome Camera" },
    { 0x23c71021, "FirstMix" },
    { 0x23fc0201, "SPI-Simulyzer box for SPI data communication" },
    { 0x23fc0202, "PSI5-Simulyzer box for PSI5 (Peripheral-Sensor-Interfacs) data communication" },
    { 0x23fc0203, "SENT-Simulyzer box for SENT data communication" },
    { 0x23fc0204, "DSI-Simulyzer box for DSI3 data communication" },
    { 0x24050002, "West Mountain Radio RIGblaster Advantage Audio" },
    { 0x24050003, "West Mountain Radio RIGblaster Advantage" },
    { 0x24066688, "PD7X Portable Storage" },
    { 0x242e0001, "DALI Master" },
    { 0x242e0002, "LiCS Bootloader Mode" },
    { 0x242e0003, "LiCS Running Mode" },
    { 0x242e0004, "iProgrammer" },
    { 0x242e0005, "NFC programming device" },
    { 0x2433b200, "[NZXT Kraken X60]" },
    { 0x244300dc, "aes220 FPGA Mini-Module" },
    { 0x2457100a, "HR2000 Spectrometer 1.00.0" },
    { 0x24571012, "HR4000 Spectrometer" },
    { 0x24580001, "BLED112 Bluetooth 4.0 Single Mode Dongle" },
    { 0x24640001, "Learning Thermostat" },
    { 0x24640002, "Learning Thermostat (2nd Generation)" },
    { 0x24640010, "Protect : Smoke + Carbon Monoxide" },
    { 0x24640020, "Heat Link" },
    { 0x24668003, "Axe-Fx II" },
    { 0x24668010, "Axe-FX III" },
    { 0x24761040, "3-Space Embedded Sensor" },
    { 0x24782008, "U209-000-R Serial Port" },
    { 0x248a8366, "Wireless Optical Mouse ACT-MUSW-002" },
    { 0x248a8367, "Telink Wireless Receiver" },
    { 0x24a40002, "I15_v1.06 [Primare Audio DAC]" },
    { 0x24ae0001, "KX Keyboard" },
    { 0x24ae0197, "meva Barcode Scanner" },
    { 0x24ae1813, "E9260 Wireless Multi-mode Keyboard" },
    { 0x24ae2000, "2.4G Wireless Device Serial" },
    { 0x24ae2001, "5 GHz Wireless Receiver" },
    { 0x24ae2003, "5GHz Wireless Transceiver" },
    { 0x24ae4110, "Optical Gaming Mouse [V280]" },
    { 0x24ae6000, "Wireless Audio" },
    { 0x24c00003, "Model 01036 weather center" },
    { 0x24c65000, "Razer Atrox Gaming Arcade Stick" },
    { 0x24c65300, "PowerA Mini ProEX Controller for Xbox 360" },
    { 0x24c65303, "Airflo Wired Controller for Xbox 360" },
    { 0x24c6530a, "ProEX Controller for Xbox 360" },
    { 0x24c6531a, "Pro Ex mini for XBOX" },
    { 0x24c65397, "FUS1ON Tournament Controller" },
    { 0x24c6541a, "PowerA CPFA115320-01 [Mini Controller for Xbox One]" },
    { 0x24c6542a, "Spectra for Xbox One" },
    { 0x24c6543a, "PowerA Wired Controller for Xbox One" },
    { 0x24c65500, "Horipad EX2 Turbo" },
    { 0x24c65501, "Hori Real Arcade Pro.VX-SA for Xbox 360" },
    { 0x24c65502, "Hori Fighting Stick VX Alt for Xbox 360" },
    { 0x24c65503, "Hori Fighting Edge for Xbox 360" },
    { 0x24c65506, "Hori Soulcalibur V Stick for Xbox 360" },
    { 0x24c6550d, "Hori Gem Controller for Xbox 360" },
    { 0x24c6550e, "Real Arcade Pro V Kai for Xbox One / Xbox 360" },
    { 0x24c6551a, "Fusion Pro Controller" },
    { 0x24c6561a, "Fusion Controller for Xbox One" },
    { 0x24c65b00, "Ferrari 458 Italia Racing Wheel" },
    { 0x24c65b02, "GPX Controller" },
    { 0x24c65d04, "Sabertooth Elite" },
    { 0x24c6fa00, "INF-8032385 Disney Infinity Reader" },
    { 0x24c6fafb, "Aplay Controller" },
    { 0x24c6fafd, "Afterglow Gamepad for Xbox 360" },
    { 0x24c6fafe, "Rock Candy Gamepad for Xbox 360" },
    { 0x24cf00a1, "Light Field Camera" },
    { 0x24dc0406, "JaCarta SF GOST" },
    { 0x24e13001, "Adp-usb" },
    { 0x24e13005, "Radius" },
    { 0x24ea0197, "Barcode Scanner" },
    { 0x24ed044d, "Chat Headset" },
    { 0x24f00105, "Das Keyboard 4" },
    { 0x24f00140, "Das Keyboard 4" },
    { 0x24f02020, "Das Keyboard 5Q" },
    { 0x25000020, "USRP B210" },
    { 0x25000021, "USRP B200-mini" },
    { 0x25000022, "USRP B205-mini" },
    { 0x25000200, "USRP B200" },
    { 0x25160003, "Storm Xornet" },
    { 0x25160004, "Storm QuickFire Rapid Mechanical Keyboard" },
    { 0x25160006, "Storm Recon" },
    { 0x25160007, "Storm Sentinel Advance II" },
    { 0x25160009, "Storm Quick Fire PRO" },
    { 0x25160011, "Storm Quick Fire TK 6keys" },
    { 0x25160014, "Storm Quick Fire TK Nkeys" },
    { 0x25160015, "Storm QuickFire Pro/Ultimate keyboard" },
    { 0x25160017, "CM Storm Quick Fire Stealth" },
    { 0x2516001a, "Storm Quick Fire XT" },
    { 0x25160020, "QuickFire Rapid-i Keyboard" },
    { 0x25160027, "CM Storm Coolermaster Novatouch TKL" },
    { 0x2516002d, "Alcor mouse" },
    { 0x25160042, "Masterkeys Lite L Combo RGB Keyboard" },
    { 0x25160044, "Masterkeys Lite L Combo RGB Mouse" },
    { 0x25160046, "Masterkeys PRO L" },
    { 0x25160047, "MasterKeys Pro L" },
    { 0x25160055, "MasterKeys L" },
    { 0x25161006, "MasterCase SL600M" },
    { 0x25169494, "Sirus Headset" },
    { 0x25200001, "EasyPrinter S3" },
    { 0x25271388, "Paramount 5" },
    { 0x25371066, "NS1066" },
    { 0x25371068, "NS1068/NS1068X SATA Bridge Controller" },
    { 0x2546e301, "TipToi Pen" },
    { 0x25481001, "CEC Adapter" },
    { 0x25481002, "CEC Adapter" },
    { 0x254ee2b3, "SHF 58035 A BiasBoard" },
    { 0x25550001, "B1 Fitness Band" },
    { 0x255e0001, "Device" },
    { 0x255e0002, "Dual" },
    { 0x2560c152, "See3CAM_CU51 5 Mpx monochrome camera" },
    { 0x2563031d, "DXT Mouse" },
    { 0x25630523, "BM0523 WirelessGamepad" },
    { 0x25630575, "ZD-V+ Wired Gaming Controller" },
    { 0x256b0121, "Audiant 80i" },
    { 0x256fc62e, "SpaceMouse Wireless (cabled)" },
    { 0x256fc62f, "SpaceMouse Wireless Receiver" },
    { 0x256fc631, "SpaceMouse Pro Wireless (cabled)" },
    { 0x256fc632, "SpaceMouse Pro Wireless Receiver" },
    { 0x256fc633, "SpaceMouse Enterprise" },
    { 0x256fc635, "SpaceMouse Compact" },
    { 0x256fc651, "CadMouse Wireless" },
    { 0x256fc652, "Universal Receiver" },
    { 0x256fc654, "CadMouse Pro Wireless" },
    { 0x256fc657, "CadMouse Pro Wireless Left" },
    { 0x25730017, "MAYA22" },
    { 0x25740901, "VC520" },
    { 0x25740910, "CAM520" },
    { 0x25740920, "VC320" },
    { 0x25740930, "CAM530" },
    { 0x25740940, "CAM340" },
    { 0x25740950, "VC322" },
    { 0x25740960, "VB342" },
    { 0x25760003, "TCM" },
    { 0x25760005, "BL [Boot Loader]" },
    { 0x25760011, "THM" },
    { 0x25784168, "2.4GHZ Wireless Arc Folding Mouse" },
    { 0x25811807, "Generic HID Smartcard" },
    { 0x25811808, "WinUSB Smartcard" },
    { 0x2581f1d0, "FIDO U2F Security Key" },
    { 0x25a72410, "Laser mouse" },
    { 0x25a7fa23, "2.4G Receiver" },
    { 0x25a7fa61, "Elecom Co., Ltd MR-K013 Multicard Reader" },
    { 0x25b50002, "Multitouch 3200" },
    { 0x25bb0063, "PRT.5105 [Yoke]" },
    { 0x25bb0064, "PRT.5105 [r