/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-lpp.c                                                               */
/* asn2wrs.py -q -L -p lpp -c ./lpp.cnf -s ./packet-lpp-template -D . -O ../.. LPP-PDU-Definitions.asn LPP-Broadcast-Definitions.asn */

/* packet-lpp.c
 * Routines for 3GPP LTE Positioning Protocol (LPP) packet dissection
 * Copyright 2011-2024 Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref 3GPP TS 37.355 version 18.4.0 Release 18
 * http://www.3gpp.org
 */

#include "config.h"

#include "math.h"

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/tfs.h>
#include <epan/proto_data.h>
#include <epan/unit_strings.h>
#include <wsutil/array.h>

#include "packet-per.h"
#include "packet-lpp.h"
#include "packet-media-type.h"

#define PNAME  "LTE Positioning Protocol (LPP)"
#define PSNAME "LPP"
#define PFNAME "lpp"

void proto_register_lpp(void);
void proto_reg_handoff_lpp(void);

/* Initialize the protocol and registered fields */
static int proto_lpp;

static int hf_lpp_LPP_Message_PDU;                /* LPP_Message */
static int hf_lpp_lpp_Ellipsoid_Point_PDU;        /* Ellipsoid_Point */
static int hf_lpp_lpp_Ellipsoid_PointWithUncertaintyCircle_PDU;  /* Ellipsoid_PointWithUncertaintyCircle */
static int hf_lpp_lpp_EllipsoidPointWithUncertaintyEllipse_PDU;  /* EllipsoidPointWithUncertaintyEllipse */
static int hf_lpp_lpp_EllipsoidPointWithAltitude_PDU;  /* EllipsoidPointWithAltitude */
static int hf_lpp_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_PDU;  /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_lpp_EllipsoidArc_PDU;           /* EllipsoidArc */
static int hf_lpp_lpp_HorizontalVelocity_PDU;     /* HorizontalVelocity */
static int hf_lpp_lpp_HorizontalWithVerticalVelocity_PDU;  /* HorizontalWithVerticalVelocity */
static int hf_lpp_lpp_HorizontalVelocityWithUncertainty_PDU;  /* HorizontalVelocityWithUncertainty */
static int hf_lpp_lpp_Polygon_PDU;                /* Polygon */
static int hf_lpp_lpp_LocationCoordinates_PDU;    /* LocationCoordinates */
static int hf_lpp_lpp_Velocity_PDU;               /* Velocity */
static int hf_lpp_lpp_LocationError_PDU;          /* LocationError */
static int hf_lpp_lpp_LocationSource_r13_PDU;     /* LocationSource_r13 */
static int hf_lpp_NR_DL_PRS_AssistanceData_r16_PDU;  /* NR_DL_PRS_AssistanceData_r16 */
static int hf_lpp_NR_DL_PRS_TRP_TEG_Info_r17_PDU;  /* NR_DL_PRS_TRP_TEG_Info_r17 */
static int hf_lpp_NR_IntegrityRiskParameters_r18_PDU;  /* NR_IntegrityRiskParameters_r18 */
static int hf_lpp_NR_IntegrityServiceAlert_r18_PDU;  /* NR_IntegrityServiceAlert_r18 */
static int hf_lpp_NR_IntegrityServiceParameters_r18_PDU;  /* NR_IntegrityServiceParameters_r18 */
static int hf_lpp_NR_On_Demand_DL_PRS_Configurations_r17_PDU;  /* NR_On_Demand_DL_PRS_Configurations_r17 */
static int hf_lpp_NR_PRU_DL_Info_r18_PDU;         /* NR_PRU_DL_Info_r18 */
static int hf_lpp_NR_TRP_BeamAntennaInfo_r17_PDU;  /* NR_TRP_BeamAntennaInfo_r17 */
static int hf_lpp_GNSS_ReferenceTime_PDU;         /* GNSS_ReferenceTime */
static int hf_lpp_GNSS_ReferenceLocation_PDU;     /* GNSS_ReferenceLocation */
static int hf_lpp_GNSS_IonosphericModel_PDU;      /* GNSS_IonosphericModel */
static int hf_lpp_GNSS_EarthOrientationParameters_PDU;  /* GNSS_EarthOrientationParameters */
static int hf_lpp_GNSS_RTK_ReferenceStationInfo_r15_PDU;  /* GNSS_RTK_ReferenceStationInfo_r15 */
static int hf_lpp_GNSS_RTK_CommonObservationInfo_r15_PDU;  /* GNSS_RTK_CommonObservationInfo_r15 */
static int hf_lpp_GNSS_RTK_AuxiliaryStationData_r15_PDU;  /* GNSS_RTK_AuxiliaryStationData_r15 */
static int hf_lpp_GNSS_SSR_CorrectionPoints_r16_PDU;  /* GNSS_SSR_CorrectionPoints_r16 */
static int hf_lpp_GNSS_Integrity_ServiceParameters_r17_PDU;  /* GNSS_Integrity_ServiceParameters_r17 */
static int hf_lpp_GNSS_Integrity_ServiceAlert_r17_PDU;  /* GNSS_Integrity_ServiceAlert_r17 */
static int hf_lpp_GNSS_LOS_NLOS_GridPoints_r18_PDU;  /* GNSS_LOS_NLOS_GridPoints_r18 */
static int hf_lpp_GNSS_SSR_IOD_Update_r18_PDU;    /* GNSS_SSR_IOD_Update_r18 */
static int hf_lpp_GNSS_TimeModelList_PDU;         /* GNSS_TimeModelList */
static int hf_lpp_GNSS_DifferentialCorrections_PDU;  /* GNSS_DifferentialCorrections */
static int hf_lpp_GNSS_NavigationModel_PDU;       /* GNSS_NavigationModel */
static int hf_lpp_GNSS_RealTimeIntegrity_PDU;     /* GNSS_RealTimeIntegrity */
static int hf_lpp_GNSS_DataBitAssistance_PDU;     /* GNSS_DataBitAssistance */
static int hf_lpp_GNSS_AcquisitionAssistance_PDU;  /* GNSS_AcquisitionAssistance */
static int hf_lpp_GNSS_Almanac_PDU;               /* GNSS_Almanac */
static int hf_lpp_GNSS_UTC_Model_PDU;             /* GNSS_UTC_Model */
static int hf_lpp_GNSS_AuxiliaryInformation_PDU;  /* GNSS_AuxiliaryInformation */
static int hf_lpp_BDS_DifferentialCorrections_r12_PDU;  /* BDS_DifferentialCorrections_r12 */
static int hf_lpp_BDS_GridModelParameter_r12_PDU;  /* BDS_GridModelParameter_r12 */
static int hf_lpp_GNSS_RTK_Observations_r15_PDU;  /* GNSS_RTK_Observations_r15 */
static int hf_lpp_GLO_RTK_BiasInformation_r15_PDU;  /* GLO_RTK_BiasInformation_r15 */
static int hf_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15_PDU;  /* GNSS_RTK_MAC_CorrectionDifferences_r15 */
static int hf_lpp_GNSS_RTK_Residuals_r15_PDU;     /* GNSS_RTK_Residuals_r15 */
static int hf_lpp_GNSS_RTK_FKP_Gradients_r15_PDU;  /* GNSS_RTK_FKP_Gradients_r15 */
static int hf_lpp_GNSS_SSR_OrbitCorrections_r15_PDU;  /* GNSS_SSR_OrbitCorrections_r15 */
static int hf_lpp_GNSS_SSR_ClockCorrections_r15_PDU;  /* GNSS_SSR_ClockCorrections_r15 */
static int hf_lpp_GNSS_SSR_CodeBias_r15_PDU;      /* GNSS_SSR_CodeBias_r15 */
static int hf_lpp_GNSS_SSR_URA_r16_PDU;           /* GNSS_SSR_URA_r16 */
static int hf_lpp_GNSS_SSR_PhaseBias_r16_PDU;     /* GNSS_SSR_PhaseBias_r16 */
static int hf_lpp_GNSS_SSR_STEC_Correction_r16_PDU;  /* GNSS_SSR_STEC_Correction_r16 */
static int hf_lpp_GNSS_SSR_GriddedCorrection_r16_PDU;  /* GNSS_SSR_GriddedCorrection_r16 */
static int hf_lpp_NavIC_DifferentialCorrections_r16_PDU;  /* NavIC_DifferentialCorrections_r16 */
static int hf_lpp_NavIC_GridModelParameter_r16_PDU;  /* NavIC_GridModelParameter_r16 */
static int hf_lpp_GNSS_SSR_OrbitCorrectionsSet2_r17_PDU;  /* GNSS_SSR_OrbitCorrectionsSet2_r17 */
static int hf_lpp_GNSS_SSR_ClockCorrectionsSet2_r17_PDU;  /* GNSS_SSR_ClockCorrectionsSet2_r17 */
static int hf_lpp_GNSS_SSR_URA_Set2_r17_PDU;      /* GNSS_SSR_URA_Set2_r17 */
static int hf_lpp_GNSS_LOS_NLOS_GriddedIndications_r18_PDU;  /* GNSS_LOS_NLOS_GriddedIndications_r18 */
static int hf_lpp_GNSS_SSR_SatellitePCVResiduals_r18_PDU;  /* GNSS_SSR_SatellitePCVResiduals_r18 */
static int hf_lpp_TBS_AssistanceDataList_r14_PDU;  /* TBS_AssistanceDataList_r14 */
static int hf_lpp_lpp_Sensor_MeasurementInformation_r13_PDU;  /* Sensor_MeasurementInformation_r13 */
static int hf_lpp_lpp_Sensor_MotionInformation_r15_PDU;  /* Sensor_MotionInformation_r15 */
static int hf_lpp_lpp_DisplacementTimeStamp_r15_PDU;  /* DisplacementTimeStamp_r15 */
static int hf_lpp_Sensor_AssistanceDataList_r14_PDU;  /* Sensor_AssistanceDataList_r14 */
static int hf_lpp_OTDOA_UE_Assisted_r15_PDU;      /* OTDOA_UE_Assisted_r15 */
static int hf_lpp_NR_UEB_TRP_LocationData_r16_PDU;  /* NR_UEB_TRP_LocationData_r16 */
static int hf_lpp_NR_UEB_TRP_RTD_Info_r16_PDU;    /* NR_UEB_TRP_RTD_Info_r16 */
static int hf_lpp_NR_IntegrityParameters_r18_PDU;  /* NR_IntegrityParameters_r18 */
static int hf_lpp_transactionID;                  /* LPP_TransactionID */
static int hf_lpp_endTransaction;                 /* BOOLEAN */
static int hf_lpp_sequenceNumber;                 /* SequenceNumber */
static int hf_lpp_acknowledgement;                /* Acknowledgement */
static int hf_lpp_lpp_MessageBody;                /* LPP_MessageBody */
static int hf_lpp_ackRequested;                   /* BOOLEAN */
static int hf_lpp_ackIndicator;                   /* SequenceNumber */
static int hf_lpp_c1;                             /* T_c1 */
static int hf_lpp_requestCapabilities;            /* RequestCapabilities */
static int hf_lpp_provideCapabilities;            /* ProvideCapabilities */
static int hf_lpp_requestAssistanceData;          /* RequestAssistanceData */
static int hf_lpp_provideAssistanceData;          /* ProvideAssistanceData */
static int hf_lpp_requestLocationInformation;     /* RequestLocationInformation */
static int hf_lpp_provideLocationInformation;     /* ProvideLocationInformation */
static int hf_lpp_abort;                          /* Abort */
static int hf_lpp_error;                          /* Error */
static int hf_lpp_spare7;                         /* NULL */
static int hf_lpp_spare6;                         /* NULL */
static int hf_lpp_spare5;                         /* NULL */
static int hf_lpp_spare4;                         /* NULL */
static int hf_lpp_spare3;                         /* NULL */
static int hf_lpp_spare2;                         /* NULL */
static int hf_lpp_spare1;                         /* NULL */
static int hf_lpp_spare0;                         /* NULL */
static int hf_lpp_messageClassExtension;          /* T_messageClassExtension */
static int hf_lpp_initiator;                      /* Initiator */
static int hf_lpp_transactionNumber;              /* TransactionNumber */
static int hf_lpp_criticalExtensions;             /* T_criticalExtensions */
static int hf_lpp_c1_01;                          /* T_c1_01 */
static int hf_lpp_requestCapabilities_r9;         /* RequestCapabilities_r9_IEs */
static int hf_lpp_criticalExtensionsFuture;       /* T_criticalExtensionsFuture */
static int hf_lpp_commonIEsRequestCapabilities;   /* CommonIEsRequestCapabilities */
static int hf_lpp_a_gnss_RequestCapabilities;     /* A_GNSS_RequestCapabilities */
static int hf_lpp_otdoa_RequestCapabilities;      /* OTDOA_RequestCapabilities */
static int hf_lpp_ecid_RequestCapabilities;       /* ECID_RequestCapabilities */
static int hf_lpp_epdu_RequestCapabilities;       /* EPDU_Sequence */
static int hf_lpp_sensor_RequestCapabilities_r13;  /* Sensor_RequestCapabilities_r13 */
static int hf_lpp_tbs_RequestCapabilities_r13;    /* TBS_RequestCapabilities_r13 */
static int hf_lpp_wlan_RequestCapabilities_r13;   /* WLAN_RequestCapabilities_r13 */
static int hf_lpp_bt_RequestCapabilities_r13;     /* BT_RequestCapabilities_r13 */
static int hf_lpp_nr_ECID_RequestCapabilities_r16;  /* NR_ECID_RequestCapabilities_r16 */
static int hf_lpp_nr_Multi_RTT_RequestCapabilities_r16;  /* NR_Multi_RTT_RequestCapabilities_r16 */
static int hf_lpp_nr_DL_AoD_RequestCapabilities_r16;  /* NR_DL_AoD_RequestCapabilities_r16 */
static int hf_lpp_nr_DL_TDOA_RequestCapabilities_r16;  /* NR_DL_TDOA_RequestCapabilities_r16 */
static int hf_lpp_nr_UL_RequestCapabilities_r16;  /* NR_UL_RequestCapabilities_r16 */
static int hf_lpp_criticalExtensions_01;          /* T_criticalExtensions_01 */
static int hf_lpp_c1_02;                          /* T_c1_02 */
static int hf_lpp_provideCapabilities_r9;         /* ProvideCapabilities_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_01;    /* T_criticalExtensionsFuture_01 */
static int hf_lpp_commonIEsProvideCapabilities;   /* CommonIEsProvideCapabilities */
static int hf_lpp_a_gnss_ProvideCapabilities;     /* A_GNSS_ProvideCapabilities */
static int hf_lpp_otdoa_ProvideCapabilities;      /* OTDOA_ProvideCapabilities */
static int hf_lpp_ecid_ProvideCapabilities;       /* ECID_ProvideCapabilities */
static int hf_lpp_epdu_ProvideCapabilities;       /* EPDU_Sequence */
static int hf_lpp_sensor_ProvideCapabilities_r13;  /* Sensor_ProvideCapabilities_r13 */
static int hf_lpp_tbs_ProvideCapabilities_r13;    /* TBS_ProvideCapabilities_r13 */
static int hf_lpp_wlan_ProvideCapabilities_r13;   /* WLAN_ProvideCapabilities_r13 */
static int hf_lpp_bt_ProvideCapabilities_r13;     /* BT_ProvideCapabilities_r13 */
static int hf_lpp_nr_ECID_ProvideCapabilities_r16;  /* NR_ECID_ProvideCapabilities_r16 */
static int hf_lpp_nr_Multi_RTT_ProvideCapabilities_r16;  /* NR_Multi_RTT_ProvideCapabilities_r16 */
static int hf_lpp_nr_DL_AoD_ProvideCapabilities_r16;  /* NR_DL_AoD_ProvideCapabilities_r16 */
static int hf_lpp_nr_DL_TDOA_ProvideCapabilities_r16;  /* NR_DL_TDOA_ProvideCapabilities_r16 */
static int hf_lpp_nr_UL_ProvideCapabilities_r16;  /* NR_UL_ProvideCapabilities_r16 */
static int hf_lpp_criticalExtensions_02;          /* T_criticalExtensions_02 */
static int hf_lpp_c1_03;                          /* T_c1_03 */
static int hf_lpp_requestAssistanceData_r9;       /* RequestAssistanceData_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_02;    /* T_criticalExtensionsFuture_02 */
static int hf_lpp_commonIEsRequestAssistanceData;  /* CommonIEsRequestAssistanceData */
static int hf_lpp_a_gnss_RequestAssistanceData;   /* A_GNSS_RequestAssistanceData */
static int hf_lpp_otdoa_RequestAssistanceData;    /* OTDOA_RequestAssistanceData */
static int hf_lpp_epdu_RequestAssistanceData;     /* EPDU_Sequence */
static int hf_lpp_sensor_RequestAssistanceData_r14;  /* Sensor_RequestAssistanceData_r14 */
static int hf_lpp_tbs_RequestAssistanceData_r14;  /* TBS_RequestAssistanceData_r14 */
static int hf_lpp_wlan_RequestAssistanceData_r14;  /* WLAN_RequestAssistanceData_r14 */
static int hf_lpp_nr_Multi_RTT_RequestAssistanceData_r16;  /* NR_Multi_RTT_RequestAssistanceData_r16 */
static int hf_lpp_nr_DL_AoD_RequestAssistanceData_r16;  /* NR_DL_AoD_RequestAssistanceData_r16 */
static int hf_lpp_nr_DL_TDOA_RequestAssistanceData_r16;  /* NR_DL_TDOA_RequestAssistanceData_r16 */
static int hf_lpp_bt_RequestAssistanceData_r18;   /* BT_RequestAssistanceData_r18 */
static int hf_lpp_criticalExtensions_03;          /* T_criticalExtensions_03 */
static int hf_lpp_c1_04;                          /* T_c1_04 */
static int hf_lpp_provideAssistanceData_r9;       /* ProvideAssistanceData_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_03;    /* T_criticalExtensionsFuture_03 */
static int hf_lpp_commonIEsProvideAssistanceData;  /* CommonIEsProvideAssistanceData */
static int hf_lpp_a_gnss_ProvideAssistanceData;   /* A_GNSS_ProvideAssistanceData */
static int hf_lpp_otdoa_ProvideAssistanceData;    /* OTDOA_ProvideAssistanceData */
static int hf_lpp_epdu_Provide_Assistance_Data;   /* EPDU_Sequence */
static int hf_lpp_sensor_ProvideAssistanceData_r14;  /* Sensor_ProvideAssistanceData_r14 */
static int hf_lpp_tbs_ProvideAssistanceData_r14;  /* TBS_ProvideAssistanceData_r14 */
static int hf_lpp_wlan_ProvideAssistanceData_r14;  /* WLAN_ProvideAssistanceData_r14 */
static int hf_lpp_nr_Multi_RTT_ProvideAssistanceData_r16;  /* NR_Multi_RTT_ProvideAssistanceData_r16 */
static int hf_lpp_nr_DL_AoD_ProvideAssistanceData_r16;  /* NR_DL_AoD_ProvideAssistanceData_r16 */
static int hf_lpp_nr_DL_TDOA_ProvideAssistanceData_r16;  /* NR_DL_TDOA_ProvideAssistanceData_r16 */
static int hf_lpp_bt_ProvideAssistanceData_r18;   /* BT_ProvideAssistanceData_r18 */
static int hf_lpp_criticalExtensions_04;          /* T_criticalExtensions_04 */
static int hf_lpp_c1_05;                          /* T_c1_05 */
static int hf_lpp_requestLocationInformation_r9;  /* RequestLocationInformation_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_04;    /* T_criticalExtensionsFuture_04 */
static int hf_lpp_commonIEsRequestLocationInformation;  /* CommonIEsRequestLocationInformation */
static int hf_lpp_a_gnss_RequestLocationInformation;  /* A_GNSS_RequestLocationInformation */
static int hf_lpp_otdoa_RequestLocationInformation;  /* OTDOA_RequestLocationInformation */
static int hf_lpp_ecid_RequestLocationInformation;  /* ECID_RequestLocationInformation */
static int hf_lpp_epdu_RequestLocationInformation;  /* EPDU_Sequence */
static int hf_lpp_sensor_RequestLocationInformation_r13;  /* Sensor_RequestLocationInformation_r13 */
static int hf_lpp_tbs_RequestLocationInformation_r13;  /* TBS_RequestLocationInformation_r13 */
static int hf_lpp_wlan_RequestLocationInformation_r13;  /* WLAN_RequestLocationInformation_r13 */
static int hf_lpp_bt_RequestLocationInformation_r13;  /* BT_RequestLocationInformation_r13 */
static int hf_lpp_nr_ECID_RequestLocationInformation_r16;  /* NR_ECID_RequestLocationInformation_r16 */
static int hf_lpp_nr_Multi_RTT_RequestLocationInformation_r16;  /* NR_Multi_RTT_RequestLocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_RequestLocationInformation_r16;  /* NR_DL_AoD_RequestLocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_RequestLocationInformation_r16;  /* NR_DL_TDOA_RequestLocationInformation_r16 */
static int hf_lpp_criticalExtensions_05;          /* T_criticalExtensions_05 */
static int hf_lpp_c1_06;                          /* T_c1_06 */
static int hf_lpp_provideLocationInformation_r9;  /* ProvideLocationInformation_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_05;    /* T_criticalExtensionsFuture_05 */
static int hf_lpp_commonIEsProvideLocationInformation;  /* CommonIEsProvideLocationInformation */
static int hf_lpp_a_gnss_ProvideLocationInformation;  /* A_GNSS_ProvideLocationInformation */
static int hf_lpp_otdoa_ProvideLocationInformation;  /* OTDOA_ProvideLocationInformation */
static int hf_lpp_ecid_ProvideLocationInformation;  /* ECID_ProvideLocationInformation */
static int hf_lpp_epdu_ProvideLocationInformation;  /* EPDU_Sequence */
static int hf_lpp_sensor_ProvideLocationInformation_r13;  /* Sensor_ProvideLocationInformation_r13 */
static int hf_lpp_tbs_ProvideLocationInformation_r13;  /* TBS_ProvideLocationInformation_r13 */
static int hf_lpp_wlan_ProvideLocationInformation_r13;  /* WLAN_ProvideLocationInformation_r13 */
static int hf_lpp_bt_ProvideLocationInformation_r13;  /* BT_ProvideLocationInformation_r13 */
static int hf_lpp_nr_ECID_ProvideLocationInformation_r16;  /* NR_ECID_ProvideLocationInformation_r16 */
static int hf_lpp_nr_Multi_RTT_ProvideLocationInformation_r16;  /* NR_Multi_RTT_ProvideLocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_ProvideLocationInformation_r16;  /* NR_DL_AoD_ProvideLocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_ProvideLocationInformation_r16;  /* NR_DL_TDOA_ProvideLocationInformation_r16 */
static int hf_lpp_criticalExtensions_06;          /* T_criticalExtensions_06 */
static int hf_lpp_c1_07;                          /* T_c1_07 */
static int hf_lpp_abort_r9;                       /* Abort_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_06;    /* T_criticalExtensionsFuture_06 */
static int hf_lpp_commonIEsAbort;                 /* CommonIEsAbort */
static int hf_lpp_epdu_Abort;                     /* EPDU_Sequence */
static int hf_lpp_error_r9;                       /* Error_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_07;    /* T_criticalExtensionsFuture_07 */
static int hf_lpp_commonIEsError;                 /* CommonIEsError */
static int hf_lpp_epdu_Error;                     /* EPDU_Sequence */
static int hf_lpp_accessTypes;                    /* T_accessTypes */
static int hf_lpp_carrierFreq_r14;                /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_carrierFreqOffset_r14;          /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_plmn_Identity;                  /* T_plmn_Identity */
static int hf_lpp_mcc;                            /* T_mcc */
static int hf_lpp_mcc_item;                       /* INTEGER_0_9 */
static int hf_lpp_mnc;                            /* T_mnc */
static int hf_lpp_mnc_item;                       /* INTEGER_0_9 */
static int hf_lpp_cellIdentity;                   /* T_cellIdentity */
static int hf_lpp_eutra;                          /* BIT_STRING_SIZE_28 */
static int hf_lpp_utra;                           /* BIT_STRING_SIZE_32 */
static int hf_lpp_plmn_Identity_01;               /* T_plmn_Identity_01 */
static int hf_lpp_mcc_01;                         /* T_mcc_01 */
static int hf_lpp_mnc_01;                         /* T_mnc_01 */
static int hf_lpp_locationAreaCode;               /* BIT_STRING_SIZE_16 */
static int hf_lpp_cellGlobalIdGERAN_cellIdentity;  /* BIT_STRING_SIZE_16 */
static int hf_lpp_mcc_02;                         /* T_mcc_02 */
static int hf_lpp_mnc_02;                         /* T_mnc_02 */
static int hf_lpp_cellidentity;                   /* BIT_STRING_SIZE_28 */
static int hf_lpp_latitudeSign;                   /* T_latitudeSign */
static int hf_lpp_degreesLatitude;                /* INTEGER_0_8388607 */
static int hf_lpp_degreesLongitude;               /* INTEGER_M8388608_8388607 */
static int hf_lpp_latitudeSign_01;                /* T_latitudeSign_01 */
static int hf_lpp_uncertainty;                    /* INTEGER_0_127 */
static int hf_lpp_latitudeSign_02;                /* T_latitudeSign_02 */
static int hf_lpp_uncertaintySemiMajor;           /* INTEGER_0_127 */
static int hf_lpp_uncertaintySemiMinor;           /* INTEGER_0_127 */
static int hf_lpp_orientationMajorAxis;           /* INTEGER_0_179 */
static int hf_lpp_confidence;                     /* INTEGER_0_100 */
static int hf_lpp_latitudeSign_03;                /* T_latitudeSign_03 */
static int hf_lpp_altitudeDirection;              /* T_altitudeDirection */
static int hf_lpp_altitude;                       /* INTEGER_0_32767 */
static int hf_lpp_latitudeSign_04;                /* T_latitudeSign_04 */
static int hf_lpp_altitudeDirection_01;           /* T_altitudeDirection_01 */
static int hf_lpp_uncertaintyAltitude;            /* INTEGER_0_127 */
static int hf_lpp_latitudeSign_05;                /* T_latitudeSign_05 */
static int hf_lpp_innerRadius;                    /* INTEGER_0_65535 */
static int hf_lpp_uncertaintyRadius;              /* INTEGER_0_127 */
static int hf_lpp_offsetAngle;                    /* INTEGER_0_179 */
static int hf_lpp_includedAngle;                  /* INTEGER_0_179 */
static int hf_lpp_EPDU_Sequence_item;             /* EPDU */
static int hf_lpp_ePDU_Identifier;                /* EPDU_Identifier */
static int hf_lpp_ePDU_Body;                      /* EPDU_Body */
static int hf_lpp_ePDU_ID;                        /* EPDU_ID */
static int hf_lpp_ePDU_Name;                      /* EPDU_Name */
static int hf_lpp_degreesLatitude_r16;            /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_degreesLongitude_r16;           /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_altitude_r16;                   /* INTEGER_M64000_1280000 */
static int hf_lpp_uncertaintySemiMajor_r16;       /* INTEGER_0_255 */
static int hf_lpp_uncertaintySemiMinor_r16;       /* INTEGER_0_255 */
static int hf_lpp_orientationMajorAxis_r16;       /* INTEGER_0_179 */
static int hf_lpp_horizontalConfidence_r16;       /* INTEGER_0_100 */
static int hf_lpp_uncertaintyAltitude_r16;        /* INTEGER_0_255 */
static int hf_lpp_verticalConfidence_r16;         /* INTEGER_0_100 */
static int hf_lpp_ha_HorizontalExtendedRangeUsed_r16;  /* BOOLEAN */
static int hf_lpp_ha_VerticalExtendedRangeUsed_r16;  /* BOOLEAN */
static int hf_lpp_confidence_r16;                 /* INTEGER_0_100 */
static int hf_lpp_ha_ExtendedUncertaintyRangeUsed_r16;  /* BOOLEAN */
static int hf_lpp_degreesLatitude_r15;            /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_degreesLongitude_r15;           /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_uncertaintySemiMajor_r15;       /* INTEGER_0_255 */
static int hf_lpp_uncertaintySemiMinor_r15;       /* INTEGER_0_255 */
static int hf_lpp_orientationMajorAxis_r15;       /* INTEGER_0_179 */
static int hf_lpp_confidence_r15;                 /* INTEGER_0_100 */
static int hf_lpp_altitude_r15;                   /* INTEGER_M64000_1280000 */
static int hf_lpp_horizontalConfidence_r15;       /* INTEGER_0_100 */
static int hf_lpp_uncertaintyAltitude_r15;        /* INTEGER_0_255 */
static int hf_lpp_verticalConfidence_r15;         /* INTEGER_0_100 */
static int hf_lpp_bearing;                        /* INTEGER_0_359 */
static int hf_lpp_horizontalSpeed;                /* INTEGER_0_2047 */
static int hf_lpp_verticalDirection;              /* T_verticalDirection */
static int hf_lpp_verticalSpeed;                  /* INTEGER_0_255 */
static int hf_lpp_uncertaintySpeed;               /* INTEGER_0_255 */
static int hf_lpp_verticalDirection_01;           /* T_verticalDirection_01 */
static int hf_lpp_horizontalUncertaintySpeed;     /* INTEGER_0_255 */
static int hf_lpp_verticalUncertaintySpeed;       /* INTEGER_0_255 */
static int hf_lpp_localOrigin_r18;                /* ReferencePoint_r16 */
static int hf_lpp_cartesianCoordinatesUnits_r18;  /* T_cartesianCoordinatesUnits_r18 */
static int hf_lpp_x_value_r18;                    /* X_Value_r18 */
static int hf_lpp_y_value_r18;                    /* Y_Value_r18 */
static int hf_lpp_uncertaintySemiMajor_r18;       /* INTEGER_0_127 */
static int hf_lpp_uncertaintySemiMinor_r18;       /* INTEGER_0_127 */
static int hf_lpp_orientationMajorAxis_r18;       /* INTEGER_0_179 */
static int hf_lpp_confidence_r18;                 /* INTEGER_0_100 */
static int hf_lpp_cartesianCoordinatesUnits_r18_01;  /* T_cartesianCoordinatesUnits_r18_01 */
static int hf_lpp_z_value_r18;                    /* Z_Value_r18 */
static int hf_lpp_uncertaintyAltitude_r18;        /* INTEGER_0_127 */
static int hf_lpp_vConfidence_r18;                /* INTEGER_0_100 */
static int hf_lpp_ellipsoidPoint;                 /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithUncertaintyCircle;  /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithUncertaintyEllipse;  /* BOOLEAN */
static int hf_lpp_polygon;                        /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithAltitude;     /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid;  /* BOOLEAN */
static int hf_lpp_ellipsoidArc;                   /* BOOLEAN */
static int hf_lpp_highAccuracyEllipsoidPointWithUncertaintyEllipse_r15;  /* BOOLEAN */
static int hf_lpp_highAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15;  /* BOOLEAN */
static int hf_lpp_ha_EllipsoidPointWithScalableUncertaintyEllipse_r16;  /* BOOLEAN */
static int hf_lpp_ha_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16;  /* BOOLEAN */
static int hf_lpp_local2dPointWithUncertaintyEllipse_r18;  /* BOOLEAN */
static int hf_lpp_local3dPointWithUncertaintyEllipsoid_r18;  /* BOOLEAN */
static int hf_lpp_mcc_r15;                        /* T_mcc_r15 */
static int hf_lpp_mcc_r15_item;                   /* INTEGER_0_9 */
static int hf_lpp_mnc_r15;                        /* T_mnc_r15 */
static int hf_lpp_mnc_r15_item;                   /* INTEGER_0_9 */
static int hf_lpp_nr_cellidentity_r15;            /* BIT_STRING_SIZE_36 */
static int hf_lpp_periodicSessionID_r15;          /* PeriodicSessionID_r15 */
static int hf_lpp_updateCapabilities_r15;         /* UpdateCapabilities_r15 */
static int hf_lpp_periodicSessionInitiator_r15;   /* T_periodicSessionInitiator_r15 */
static int hf_lpp_periodicSessionNumber_r15;      /* INTEGER_0_255 */
static int hf_lpp_minPeriodicReportingIntervalMs_r18;  /* T_minPeriodicReportingIntervalMs_r18 */
static int hf_lpp_minPeriodicReportingIntervalMs1_Supported_r18;  /* PositioningModes */
static int hf_lpp_minPeriodicReportingIntervalMs10_Supported_r18;  /* PositioningModes */
static int hf_lpp_minPeriodicReportingIntervalMs100_Supported_r18;  /* PositioningModes */
static int hf_lpp_Polygon_item;                   /* PolygonPoints */
static int hf_lpp_latitudeSign_06;                /* T_latitudeSign_06 */
static int hf_lpp_posModes;                       /* T_posModes */
static int hf_lpp_utcTime_r17_enum;               /* T_utcTime_r17_enum */
static int hf_lpp_gnssTime_r17;                   /* GNSS_ID_Bitmap */
static int hf_lpp_e_utraTime_r17;                 /* T_e_utraTime_r17 */
static int hf_lpp_nrTime_r17;                     /* T_nrTime_r17 */
static int hf_lpp_relativeTime_r17;               /* T_relativeTime_r17 */
static int hf_lpp_utcTime_r17_PositioningModes;   /* PositioningModes */
static int hf_lpp_gnssTime_r17_01;                /* T_gnssTime_r17 */
static int hf_lpp_posModes_r17;                   /* PositioningModes */
static int hf_lpp_gnss_TimeIDs_r17;               /* GNSS_ID_Bitmap */
static int hf_lpp_e_utraTime_r17_01;              /* PositioningModes */
static int hf_lpp_nrTime_r17_01;                  /* PositioningModes */
static int hf_lpp_relativeTime_r17_01;            /* PositioningModes */
static int hf_lpp_horizontalVelocity;             /* BOOLEAN */
static int hf_lpp_horizontalWithVerticalVelocity;  /* BOOLEAN */
static int hf_lpp_horizontalVelocityWithUncertainty;  /* BOOLEAN */
static int hf_lpp_horizontalWithVerticalVelocityAndUncertainty;  /* BOOLEAN */
static int hf_lpp_lpp_message_segmentation_req_r14;  /* T_lpp_message_segmentation_req_r14 */
static int hf_lpp_remoteUE_IndicationReq_r18;     /* T_remoteUE_IndicationReq_r18 */
static int hf_lpp_segmentationInfo_r14;           /* SegmentationInfo_r14 */
static int hf_lpp_lpp_message_segmentation_r14;   /* T_lpp_message_segmentation_r14 */
static int hf_lpp_remoteUE_Indication_r18_bool;   /* BOOLEAN */
static int hf_lpp_locationEstimateAndMeasurementReporting_r18;  /* T_locationEstimateAndMeasurementReporting_r18 */
static int hf_lpp_primaryCellID;                  /* ECGI */
static int hf_lpp_periodicAssistanceDataReq_r15;  /* PeriodicAssistanceDataControlParameters_r15 */
static int hf_lpp_primaryCellID_r15;              /* NCGI_r15 */
static int hf_lpp_periodicAssistanceData_r15;     /* PeriodicAssistanceDataControlParameters_r15 */
static int hf_lpp_locationInformationType;        /* LocationInformationType */
static int hf_lpp_triggeredReporting;             /* TriggeredReportingCriteria */
static int hf_lpp_periodicalReporting;            /* PeriodicalReportingCriteria */
static int hf_lpp_additionalInformation;          /* AdditionalInformation */
static int hf_lpp_qos;                            /* QoS */
static int hf_lpp_environment;                    /* Environment */
static int hf_lpp_locationCoordinateTypes;        /* LocationCoordinateTypes */
static int hf_lpp_velocityTypes;                  /* VelocityTypes */
static int hf_lpp_messageSizeLimitNB_r14;         /* MessageSizeLimitNB_r14 */
static int hf_lpp_scheduledLocationTime_r17;      /* ScheduledLocationTime_r17 */
static int hf_lpp_targetIntegrityRisk_r17;        /* TargetIntegrityRisk_r17 */
static int hf_lpp_periodicalReportingExt_r18;     /* PeriodicalReportingCriteriaExt_r18 */
static int hf_lpp_reportingAmount;                /* T_reportingAmount */
static int hf_lpp_reportingInterval;              /* T_reportingInterval */
static int hf_lpp_reportingAmount_r18;            /* T_reportingAmount_r18 */
static int hf_lpp_reportingIntervalMs_r18;        /* INTEGER_1_999 */
static int hf_lpp_cellChange;                     /* BOOLEAN */
static int hf_lpp_reportingDuration;              /* ReportingDuration */
static int hf_lpp_horizontalAccuracy;             /* HorizontalAccuracy */
static int hf_lpp_verticalCoordinateRequest;      /* BOOLEAN */
static int hf_lpp_verticalAccuracy;               /* VerticalAccuracy */
static int hf_lpp_responseTime;                   /* ResponseTime */
static int hf_lpp_velocityRequest;                /* BOOLEAN */
static int hf_lpp_responseTimeNB_r14;             /* ResponseTimeNB_r14 */
static int hf_lpp_horizontalAccuracyExt_r15;      /* HorizontalAccuracyExt_r15 */
static int hf_lpp_verticalAccuracyExt_r15;        /* VerticalAccuracyExt_r15 */
static int hf_lpp_accuracy;                       /* INTEGER_0_127 */
static int hf_lpp_accuracyExt_r15;                /* INTEGER_0_255 */
static int hf_lpp_time;                           /* INTEGER_1_128 */
static int hf_lpp_responseTimeEarlyFix_r12;       /* INTEGER_1_128 */
static int hf_lpp_unit_r15;                       /* T_unit_r15 */
static int hf_lpp_timeNB_r14;                     /* INTEGER_1_512 */
static int hf_lpp_responseTimeEarlyFixNB_r14;     /* INTEGER_1_512 */
static int hf_lpp_unitNB_r15;                     /* T_unitNB_r15 */
static int hf_lpp_measurementLimit_r14;           /* INTEGER_1_512 */
static int hf_lpp_utcTime_r17;                    /* UTCTime */
static int hf_lpp_gnssTime_r17_02;                /* T_gnssTime_r17_01 */
static int hf_lpp_gnss_TOD_msec_r17;              /* INTEGER_0_3599999 */
static int hf_lpp_gnss_TimeID_r17;                /* GNSS_ID */
static int hf_lpp_networkTime_r17;                /* T_networkTime_r17 */
static int hf_lpp_e_utraTime_r17_02;              /* T_e_utraTime_r17_01 */
static int hf_lpp_lte_PhysCellId_r17;             /* INTEGER_0_503 */
static int hf_lpp_lte_ArfcnEUTRA_r17;             /* ARFCN_ValueEUTRA */
static int hf_lpp_lte_CellGlobalId_r17;           /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_lte_SystemFrameNumber_r17;      /* INTEGER_0_1023 */
static int hf_lpp_nrTime_r17_02;                  /* T_nrTime_r17_01 */
static int hf_lpp_nr_PhysCellID_r17;              /* NR_PhysCellID_r16 */
static int hf_lpp_nr_ARFCN_r17;                   /* ARFCN_ValueNR_r15 */
static int hf_lpp_nr_CellGlobalID_r17;            /* NCGI_r15 */
static int hf_lpp_nr_SFN_r17;                     /* INTEGER_0_1023 */
static int hf_lpp_nr_Slot_r17;                    /* T_nr_Slot_r17 */
static int hf_lpp_scs15_r17;                      /* INTEGER_0_9 */
static int hf_lpp_scs30_r17;                      /* INTEGER_0_19 */
static int hf_lpp_scs60_r17;                      /* INTEGER_0_39 */
static int hf_lpp_scs120_r17;                     /* INTEGER_0_79 */
static int hf_lpp_relativeTime_r17_02;            /* INTEGER_1_1024 */
static int hf_lpp_locationEstimate;               /* LocationCoordinates */
static int hf_lpp_velocityEstimate;               /* Velocity */
static int hf_lpp_locationError;                  /* LocationError */
static int hf_lpp_earlyFixReport_r12;             /* EarlyFixReport_r12 */
static int hf_lpp_locationSource_r13;             /* LocationSource_r13 */
static int hf_lpp_locationTimestamp_r13;          /* UTCTime */
static int hf_lpp_integrityInfo_r17;              /* IntegrityInfo_r17 */
static int hf_lpp_ellipsoidPoint_01;              /* Ellipsoid_Point */
static int hf_lpp_ellipsoidPointWithUncertaintyCircle_01;  /* Ellipsoid_PointWithUncertaintyCircle */
static int hf_lpp_ellipsoidPointWithUncertaintyEllipse_01;  /* EllipsoidPointWithUncertaintyEllipse */
static int hf_lpp_locationCoordinates_polygon;    /* Polygon */
static int hf_lpp_ellipsoidPointWithAltitude_01;  /* EllipsoidPointWithAltitude */
static int hf_lpp_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid_01;  /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_ellipsoidArc_01;                /* EllipsoidArc */
static int hf_lpp_highAccuracyEllipsoidPointWithUncertaintyEllipse_v1510;  /* HighAccuracyEllipsoidPointWithUncertaintyEllipse_r15 */
static int hf_lpp_highAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_v1510;  /* HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 */
static int hf_lpp_ha_EllipsoidPointWithScalableUncertaintyEllipse_v1680;  /* HA_EllipsoidPointWithScalableUncertaintyEllipse_r16 */
static int hf_lpp_ha_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_v1680;  /* HA_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16 */
static int hf_lpp_local2dPointWithUncertaintyEllipse_v1800;  /* Local2dPointWithUncertaintyEllipse_r18 */
static int hf_lpp_local3dPointWithUncertaintyEllipsoid_v1800;  /* Local3dPointWithUncertaintyEllipsoid_r18 */
static int hf_lpp_horizontalVelocity_01;          /* HorizontalVelocity */
static int hf_lpp_horizontalWithVerticalVelocity_01;  /* HorizontalWithVerticalVelocity */
static int hf_lpp_horizontalVelocityWithUncertainty_01;  /* HorizontalVelocityWithUncertainty */
static int hf_lpp_horizontalWithVerticalVelocityAndUncertainty_01;  /* HorizontalWithVerticalVelocityAndUncertainty */
static int hf_lpp_locationfailurecause;           /* LocationFailureCause */
static int hf_lpp_horizontalProtectionLevel_r17;  /* INTEGER_0_50000 */
static int hf_lpp_verticalProtectionLevel_r17;    /* INTEGER_0_50000 */
static int hf_lpp_achievableTargetIntegrityRisk_r17;  /* INTEGER_10_90 */
static int hf_lpp_abortCause;                     /* T_abortCause */
static int hf_lpp_errorCause;                     /* T_errorCause */
static int hf_lpp_AreaID_CellList_r17_item;       /* NR_Cell_IDs_r17 */
static int hf_lpp_dl_PRS_ID_r16;                  /* INTEGER_0_255 */
static int hf_lpp_nr_DL_PRS_ResourceID_List_r16;  /* SEQUENCE_SIZE_1_nrMaxResourceIDs_r16_OF_NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_DL_PRS_ResourceID_List_r16_item;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_DL_PRS_ResourceSetID_r16;    /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_alpha_r16;                      /* INTEGER_0_359 */
static int hf_lpp_alpha_fine_r16;                 /* INTEGER_0_9 */
static int hf_lpp_beta_r16;                       /* INTEGER_0_359 */
static int hf_lpp_beta_fine_r16;                  /* INTEGER_0_9 */
static int hf_lpp_gamma_r16;                      /* INTEGER_0_359 */
static int hf_lpp_gamma_fine_r16;                 /* INTEGER_0_9 */
static int hf_lpp_coordinateID_r18;               /* VisibleString_SIZE_1_256 */
static int hf_lpp_point_r18;                      /* HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 */
static int hf_lpp_horizAxesOrientation_r18;       /* INTEGER_0_3599 */
static int hf_lpp_indicator_r17;                  /* T_indicator_r17 */
static int hf_lpp_soft_r17;                       /* INTEGER_0_10 */
static int hf_lpp_hard_r17;                       /* BOOLEAN */
static int hf_lpp_NR_AdditionalPathList_r16_item;  /* NR_AdditionalPath_r16 */
static int hf_lpp_NR_AdditionalPathListExt_r17_item;  /* NR_AdditionalPath_r16 */
static int hf_lpp_nr_RelativeTimeDifference_r16;  /* T_nr_RelativeTimeDifference_r16 */
static int hf_lpp_k0_r16;                         /* INTEGER_0_16351 */
static int hf_lpp_k1_r16;                         /* INTEGER_0_8176 */
static int hf_lpp_k2_r16;                         /* INTEGER_0_4088 */
static int hf_lpp_k3_r16;                         /* INTEGER_0_2044 */
static int hf_lpp_k4_r16;                         /* INTEGER_0_1022 */
static int hf_lpp_k5_r16;                         /* INTEGER_0_511 */
static int hf_lpp_kMinus6_r18;                    /* INTEGER_0_1046401 */
static int hf_lpp_kMinus5_r18;                    /* INTEGER_0_523201 */
static int hf_lpp_kMinus4_r18;                    /* INTEGER_0_261601 */
static int hf_lpp_kMinus3_r18;                    /* INTEGER_0_130801 */
static int hf_lpp_kMinus2_r18;                    /* INTEGER_0_65401 */
static int hf_lpp_kMinus1_r18;                    /* INTEGER_0_32701 */
static int hf_lpp_nr_PathQuality_r16;             /* NR_TimingQuality_r16 */
static int hf_lpp_nr_DL_PRS_RSRPP_r17;            /* INTEGER_0_126 */
static int hf_lpp_aggregatedDL_PRS_ID_r18;        /* INTEGER_0_255 */
static int hf_lpp_nr_DL_PRS_ResourceSetID_r18;    /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_nr_DL_PRS_ResourceID_r18;       /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_DL_PRS_ReferenceInfo_r16;    /* DL_PRS_ID_Info_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataList_r16;  /* SEQUENCE_SIZE_1_nrMaxFreqLayers_r16_OF_NR_DL_PRS_AssistanceDataPerFreq_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataList_r16_item;  /* NR_DL_PRS_AssistanceDataPerFreq_r16 */
static int hf_lpp_nr_SSB_Config_r16;              /* SEQUENCE_SIZE_1_nrMaxTRPs_r16_OF_NR_SSB_Config_r16 */
static int hf_lpp_nr_SSB_Config_r16_item;         /* NR_SSB_Config_r16 */
static int hf_lpp_nr_DL_PRS_AggregationInfo_r18;  /* NR_DL_PRS_AggregationInfo_r18 */
static int hf_lpp_nr_DL_PRS_PositioningFrequencyLayer_r16;  /* NR_DL_PRS_PositioningFrequencyLayer_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataPerFreq_r16;  /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_DL_PRS_AssistanceDataPerTRP_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataPerFreq_r16_item;  /* NR_DL_PRS_AssistanceDataPerTRP_r16 */
static int hf_lpp_nr_PhysCellID_r16;              /* NR_PhysCellID_r16 */
static int hf_lpp_nr_CellGlobalID_r16;            /* NCGI_r15 */
static int hf_lpp_nr_ARFCN_r16;                   /* ARFCN_ValueNR_r15 */
static int hf_lpp_nr_DL_PRS_SFN0_Offset_r16;      /* NR_DL_PRS_SFN0_Offset_r16 */
static int hf_lpp_nr_DL_PRS_ExpectedRSTD_r16;     /* INTEGER_M3841_3841 */
static int hf_lpp_nr_DL_PRS_ExpectedRSTD_Uncertainty_r16;  /* INTEGER_0_246 */
static int hf_lpp_nr_DL_PRS_Info_r16;             /* NR_DL_PRS_Info_r16 */
static int hf_lpp_prs_OnlyTP_r16;                 /* T_prs_OnlyTP_r16 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_r17;  /* NR_DL_PRS_ExpectedAoD_or_AoA_r17 */
static int hf_lpp_dl_PRS_SubcarrierSpacing_r16;   /* T_dl_PRS_SubcarrierSpacing_r16 */
static int hf_lpp_dl_PRS_ResourceBandwidth_r16;   /* INTEGER_1_63 */
static int hf_lpp_dl_PRS_StartPRB_r16;            /* INTEGER_0_2176 */
static int hf_lpp_dl_PRS_PointA_r16;              /* ARFCN_ValueNR_r15 */
static int hf_lpp_dl_PRS_CombSizeN_r16;           /* T_dl_PRS_CombSizeN_r16 */
static int hf_lpp_dl_PRS_CyclicPrefix_r16;        /* T_dl_PRS_CyclicPrefix_r16 */
static int hf_lpp_sfn_Offset_r16;                 /* INTEGER_0_1023 */
static int hf_lpp_integerSubframeOffset_r16;      /* INTEGER_0_9 */
static int hf_lpp_expectedAoD_r17;                /* T_expectedAoD_r17 */
static int hf_lpp_expectedDL_AzimuthAoD_r17;      /* INTEGER_0_359 */
static int hf_lpp_expectedDL_AzimuthAoD_Unc_r17;  /* INTEGER_0_60 */
static int hf_lpp_expectedDL_ZenithAoD_r17;       /* INTEGER_0_180 */
static int hf_lpp_expectedDL_ZenithAoD_Unc_r17;   /* INTEGER_0_30 */
static int hf_lpp_expectedAoA_r17;                /* T_expectedAoA_r17 */
static int hf_lpp_expectedDL_AzimuthAoA_r17;      /* INTEGER_0_359 */
static int hf_lpp_expectedDL_AzimuthAoA_Unc_r17;  /* INTEGER_0_60 */
static int hf_lpp_expectedDL_ZenithAoA_r17;       /* INTEGER_0_180 */
static int hf_lpp_expectedDL_ZenithAoA_Unc_r17;   /* INTEGER_0_30 */
static int hf_lpp_NR_DL_PRS_AggregationInfo_r18_item;  /* NR_linkedDL_PRS_ResourceSetID_PRS_AggregationList_r18 */
static int hf_lpp_NR_linkedDL_PRS_ResourceSetID_PRS_AggregationList_r18_item;  /* NR_DL_PRS_AggregationElement_r18 */
static int hf_lpp_nr_DL_PRS_FrequencyLayerIndex_r18;  /* INTEGER_0_nrMaxFreqLayers_1_r16 */
static int hf_lpp_nr_DL_PRS_TRP_Index_r18;        /* INTEGER_0_nrMaxTRPsPerFreq_1_r16 */
static int hf_lpp_nr_DL_PRS_ResourceSetIndex_r18;  /* INTEGER_0_nrMaxSetsPerTrpPerFreqLayer_1_r16 */
static int hf_lpp_NR_DL_PRS_BeamInfo_r16_item;    /* NR_DL_PRS_BeamInfoPerFreqLayer_r16 */
static int hf_lpp_NR_DL_PRS_BeamInfoPerFreqLayer_r16_item;  /* NR_DL_PRS_BeamInfoPerTRP_r16 */
static int hf_lpp_associated_DL_PRS_ID_r16;       /* INTEGER_0_255 */
static int hf_lpp_lcs_GCS_TranslationParameter_r16;  /* LCS_GCS_TranslationParameter_r16 */
static int hf_lpp_dl_PRS_BeamInfoSet_r16;         /* DL_PRS_BeamInfoSet_r16 */
static int hf_lpp_DL_PRS_BeamInfoSet_r16_item;    /* DL_PRS_BeamInfoResourceSet_r16 */
static int hf_lpp_DL_PRS_BeamInfoResourceSet_r16_item;  /* DL_PRS_BeamInfoElement_r16 */
static int hf_lpp_dl_PRS_Azimuth_r16;             /* INTEGER_0_359 */
static int hf_lpp_dl_PRS_Azimuth_fine_r16;        /* INTEGER_0_9 */
static int hf_lpp_dl_PRS_Elevation_r16;           /* INTEGER_0_180 */
static int hf_lpp_dl_PRS_Elevation_fine_r16;      /* INTEGER_0_9 */
static int hf_lpp_nr_IntegrityBeamInfoBounds_r18;  /* NR_IntegrityBeamInfoBounds_r18 */
static int hf_lpp_meanAzimuth_r18;                /* INTEGER_0_255 */
static int hf_lpp_stdDevAzimuth_r18;              /* INTEGER_0_255 */
static int hf_lpp_meanElevation_r18;              /* INTEGER_0_255 */
static int hf_lpp_stdDevElevation_r18;            /* INTEGER_0_255 */
static int hf_lpp_NR_DL_PRS_ExpectedLOS_NLOS_Assistance_r17_item;  /* NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerFreqLayer_r17 */
static int hf_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerFreqLayer_r17_item;  /* NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerTRP_r17 */
static int hf_lpp_dl_PRS_ID_r17;                  /* INTEGER_0_255 */
static int hf_lpp_nr_los_nlos_indicator_r17;      /* T_nr_los_nlos_indicator_r17 */
static int hf_lpp_perTrp_r17;                     /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_perResource_r17;                /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17 */
static int hf_lpp_perResource_r17_item;           /* NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17 */
static int hf_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17_item;  /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_nr_DL_PRS_ResourceSetList_r16;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ResourceSet_r16 */
static int hf_lpp_nr_DL_PRS_ResourceSetList_r16_item;  /* NR_DL_PRS_ResourceSet_r16 */
static int hf_lpp_dl_PRS_Periodicity_and_ResourceSetSlotOffset_r16;  /* NR_DL_PRS_Periodicity_and_ResourceSetSlotOffset_r16 */
static int hf_lpp_dl_PRS_ResourceRepetitionFactor_r16;  /* T_dl_PRS_ResourceRepetitionFactor_r16 */
static int hf_lpp_dl_PRS_ResourceTimeGap_r16;     /* T_dl_PRS_ResourceTimeGap_r16 */
static int hf_lpp_dl_PRS_NumSymbols_r16;          /* T_dl_PRS_NumSymbols_r16 */
static int hf_lpp_dl_PRS_MutingOption1_r16;       /* DL_PRS_MutingOption1_r16 */
static int hf_lpp_dl_PRS_MutingOption2_r16;       /* DL_PRS_MutingOption2_r16 */
static int hf_lpp_dl_PRS_ResourcePower_r16;       /* INTEGER_M60_50 */
static int hf_lpp_dl_PRS_ResourceList_r16;        /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_NR_DL_PRS_Resource_r16 */
static int hf_lpp_dl_PRS_ResourceList_r16_item;   /* NR_DL_PRS_Resource_r16 */
static int hf_lpp_dl_prs_MutingBitRepetitionFactor_r16;  /* T_dl_prs_MutingBitRepetitionFactor_r16 */
static int hf_lpp_nr_option1_muting_r16;          /* NR_MutingPattern_r16 */
static int hf_lpp_nr_option2_muting_r16;          /* NR_MutingPattern_r16 */
static int hf_lpp_po2_r16;                        /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r16;                        /* BIT_STRING_SIZE_4 */
static int hf_lpp_po6_r16;                        /* BIT_STRING_SIZE_6 */
static int hf_lpp_po8_r16;                        /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r16;                       /* BIT_STRING_SIZE_16 */
static int hf_lpp_po32_r16;                       /* BIT_STRING_SIZE_32 */
static int hf_lpp_nr_DL_PRS_ResourceID_r16;       /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_dl_PRS_SequenceID_r16;          /* INTEGER_0_4095 */
static int hf_lpp_dl_PRS_CombSizeN_AndReOffset_r16;  /* T_dl_PRS_CombSizeN_AndReOffset_r16 */
static int hf_lpp_n2_r16;                         /* INTEGER_0_1 */
static int hf_lpp_n4_r16;                         /* INTEGER_0_3 */
static int hf_lpp_n6_r16;                         /* INTEGER_0_5 */
static int hf_lpp_n12_r16;                        /* INTEGER_0_11 */
static int hf_lpp_dl_PRS_ResourceSlotOffset_r16;  /* INTEGER_0_nrMaxResourceOffsetValue_1_r16 */
static int hf_lpp_dl_PRS_ResourceSymbolOffset_r16;  /* INTEGER_0_12 */
static int hf_lpp_dl_PRS_QCL_Info_r16;            /* DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_PRS_ResourcePrioritySubset_r17;  /* DL_PRS_ResourcePrioritySubset_r17 */
static int hf_lpp_dl_PRS_ResourceSymbolOffset_v1800;  /* INTEGER_13 */
static int hf_lpp_ssb_r16;                        /* T_ssb_r16 */
static int hf_lpp_pci_r16;                        /* NR_PhysCellID_r16 */
static int hf_lpp_ssb_Index_r16;                  /* INTEGER_0_63 */
static int hf_lpp_rs_Type_r16;                    /* T_rs_Type_r16 */
static int hf_lpp_dl_PRS_r16;                     /* T_dl_PRS_r16 */
static int hf_lpp_qcl_DL_PRS_ResourceID_r16;      /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_qcl_DL_PRS_ResourceSetID_r16;   /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_scs15_r16;                      /* T_scs15_r16 */
static int hf_lpp_n5_r16;                         /* INTEGER_0_4 */
static int hf_lpp_n8_r16;                         /* INTEGER_0_7 */
static int hf_lpp_n10_r16;                        /* INTEGER_0_9 */
static int hf_lpp_n16_r16;                        /* INTEGER_0_15 */
static int hf_lpp_n20_r16;                        /* INTEGER_0_19 */
static int hf_lpp_n32_r16;                        /* INTEGER_0_31 */
static int hf_lpp_n40_r16;                        /* INTEGER_0_39 */
static int hf_lpp_n64_r16;                        /* INTEGER_0_63 */
static int hf_lpp_n80_r16;                        /* INTEGER_0_79 */
static int hf_lpp_n160_r16;                       /* INTEGER_0_159 */
static int hf_lpp_n320_r16;                       /* INTEGER_0_319 */
static int hf_lpp_n640_r16;                       /* INTEGER_0_639 */
static int hf_lpp_n1280_r16;                      /* INTEGER_0_1279 */
static int hf_lpp_n2560_r16;                      /* INTEGER_0_2559 */
static int hf_lpp_n5120_r16;                      /* INTEGER_0_5119 */
static int hf_lpp_n10240_r16;                     /* INTEGER_0_10239 */
static int hf_lpp_scs30_r16;                      /* T_scs30_r16 */
static int hf_lpp_n128_r16;                       /* INTEGER_0_127 */
static int hf_lpp_n20480_r16;                     /* INTEGER_0_20479 */
static int hf_lpp_scs60_r16;                      /* T_scs60_r16 */
static int hf_lpp_n256_r16;                       /* INTEGER_0_255 */
static int hf_lpp_n40960_r16;                     /* INTEGER_0_40959 */
static int hf_lpp_scs120_r16;                     /* T_scs120_r16 */
static int hf_lpp_n512_r16;                       /* INTEGER_0_511 */
static int hf_lpp_n81920_r16;                     /* INTEGER_0_81919 */
static int hf_lpp_DL_PRS_ResourcePrioritySubset_r17_item;  /* NR_DL_PRSResourcePriorityItem_r17 */
static int hf_lpp_nr_DL_PRS_PrioResourceSetID_r17;  /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_nr_DL_PRS_PrioResourceID_r17;   /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_NR_DL_PRS_MeasurementTimeWindowsConfig_r18_item;  /* NR_DL_PRS_MeasurementTimeWindowsConfigElement_r18 */
static int hf_lpp_nr_StartSFN_TimeWindow_r18;     /* INTEGER_0_1023 */
static int hf_lpp_nr_PeriodicOrOneShotTimeWindow_r18;  /* T_nr_PeriodicOrOneShotTimeWindow_r18 */
static int hf_lpp_nr_PeriodicityAndSlotOffsetTimeWindow_r18;  /* NR_DL_PRS_Periodicity_and_ResourceSetSlotOffset_r16 */
static int hf_lpp_nr_OneShotSlotOffsetTimeWindow_r18;  /* T_nr_OneShotSlotOffsetTimeWindow_r18 */
static int hf_lpp_scs15_r18;                      /* INTEGER_0_10239 */
static int hf_lpp_scs30_r18;                      /* INTEGER_0_20479 */
static int hf_lpp_scs60_r18;                      /* INTEGER_0_40959 */
static int hf_lpp_scs120_r18;                     /* INTEGER_0_81919 */
static int hf_lpp_nr_SymbolOffsetTimeWindow_r18;  /* INTEGER_0_13 */
static int hf_lpp_nr_DurationTimeWindow_r18;      /* T_nr_DurationTimeWindow_r18 */
static int hf_lpp_nr_SelectedDL_PRS_FrequencyLayerIndex_r18;  /* INTEGER_0_nrMaxFreqLayers_1_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexListPerFreq_r18;  /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_SelectedDL_PRS_IndexPerTRP_r18 */
static int hf_lpp_nr_SelectedDL_PRS_IndexListPerFreq_r18_item;  /* NR_SelectedDL_PRS_IndexPerTRP_r18 */
static int hf_lpp_nr_MeasurementsToPerformInTimeWindow_r18;  /* T_nr_MeasurementsToPerformInTimeWindow_r18 */
static int hf_lpp_nr_SelectedTRP_Index_r18;       /* INTEGER_0_nrMaxTRPsPerFreq_1_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceSetIndexList_r18;  /* T_dl_SelectedPRS_ResourceSetIndexList_r18 */
static int hf_lpp_dl_SelectedPRS_ResourceSetIndexList_r18_item;  /* INTEGER_0_nrMaxSetsPerTrpPerFreqLayer_1_r16 */
static int hf_lpp_prs_ProcessingCapabilityBandList_r16;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_prs_ProcessingCapabilityBandList_r16_item;  /* PRS_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_maxSupportedFreqLayers_r16;     /* INTEGER_1_4 */
static int hf_lpp_simulLTE_NR_PRS_r16;            /* T_simulLTE_NR_PRS_r16 */
static int hf_lpp_dummy;                          /* T_dummy */
static int hf_lpp_freqBandIndicatorNR_r16;        /* FreqBandIndicatorNR_r16 */
static int hf_lpp_supportedBandwidthPRS_r16;      /* T_supportedBandwidthPRS_r16 */
static int hf_lpp_fr1;                            /* T_fr1 */
static int hf_lpp_fr2;                            /* T_fr2 */
static int hf_lpp_dl_PRS_BufferType_r16;          /* T_dl_PRS_BufferType_r16 */
static int hf_lpp_durationOfPRS_Processing_r16;   /* T_durationOfPRS_Processing_r16 */
static int hf_lpp_durationOfPRS_ProcessingSymbols_r16;  /* T_durationOfPRS_ProcessingSymbols_r16 */
static int hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r16;  /* T_durationOfPRS_ProcessingSymbolsInEveryTms_r16 */
static int hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_r16;  /* T_maxNumOfDL_PRS_ResProcessedPerSlot_r16 */
static int hf_lpp_scs15_r16_01;                   /* T_scs15_r16_01 */
static int hf_lpp_scs30_r16_01;                   /* T_scs30_r16_01 */
static int hf_lpp_scs60_r16_01;                   /* T_scs60_r16_01 */
static int hf_lpp_scs120_r16_01;                  /* T_scs120_r16_01 */
static int hf_lpp_scs15_v1690;                    /* T_scs15_v1690 */
static int hf_lpp_scs30_v1690;                    /* T_scs30_v1690 */
static int hf_lpp_scs60_v1690;                    /* T_scs60_v1690 */
static int hf_lpp_scs120_v1690;                   /* T_scs120_v1690 */
static int hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17;  /* T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17 */
static int hf_lpp_prs_ProcessingWindowType1A_r17;  /* T_prs_ProcessingWindowType1A_r17 */
static int hf_lpp_prs_ProcessingWindowType1B_r17;  /* T_prs_ProcessingWindowType1B_r17 */
static int hf_lpp_prs_ProcessingWindowType2_r17;  /* T_prs_ProcessingWindowType2_r17 */
static int hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17;  /* SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 */
static int hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17_item;  /* PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 */
static int hf_lpp_dl_PRS_BufferType_RRC_Inactive_r17;  /* T_dl_PRS_BufferType_RRC_Inactive_r17 */
static int hf_lpp_durationOfPRS_Processing_RRC_Inactive_r17;  /* T_durationOfPRS_Processing_RRC_Inactive_r17 */
static int hf_lpp_durationOfPRS_ProcessingSymbols_r17;  /* T_durationOfPRS_ProcessingSymbols_r17 */
static int hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r17;  /* T_durationOfPRS_ProcessingSymbolsInEveryTms_r17 */
static int hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17;  /* T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17 */
static int hf_lpp_scs15_r17_01;                   /* T_scs15_r17 */
static int hf_lpp_scs30_r17_01;                   /* T_scs30_r17 */
static int hf_lpp_scs60_r17_01;                   /* T_scs60_r17 */
static int hf_lpp_scs120_r17_01;                  /* T_scs120_r17 */
static int hf_lpp_supportedLowerRxBeamSweepingFactor_FR2_r17;  /* T_supportedLowerRxBeamSweepingFactor_FR2_r17 */
static int hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17;  /* T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17 */
static int hf_lpp_prs_MeasurementWithoutMG_r17;   /* T_prs_MeasurementWithoutMG_r17 */
static int hf_lpp_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18;  /* T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18 */
static int hf_lpp_scs15_r18_01;                   /* T_scs15_r18 */
static int hf_lpp_scs30_r18_01;                   /* T_scs30_r18 */
static int hf_lpp_scs60_r18_01;                   /* T_scs60_r18 */
static int hf_lpp_scs120_r18_01;                  /* T_scs120_r18 */
static int hf_lpp_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18;  /* T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18 */
static int hf_lpp_scs15_r18_02;                   /* T_scs15_r18_01 */
static int hf_lpp_scs30_r18_02;                   /* T_scs30_r18_01 */
static int hf_lpp_scs60_r18_02;                   /* T_scs60_r18_01 */
static int hf_lpp_scs120_r18_02;                  /* T_scs120_r18_01 */
static int hf_lpp_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18;  /* T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18 */
static int hf_lpp_scs15_r18_03;                   /* T_scs15_r18_02 */
static int hf_lpp_scs30_r18_03;                   /* T_scs30_r18_02 */
static int hf_lpp_scs60_r18_03;                   /* T_scs60_r18_02 */
static int hf_lpp_scs120_r18_03;                  /* T_scs120_r18_02 */
static int hf_lpp_prs_BWA_TwoContiguousIntrabandInMG_RRC_Connected_r18;  /* PRS_BWA_TwoContiguousIntrabandInMG_r18 */
static int hf_lpp_prs_BWA_ThreeContiguousIntrabandInMG_RRC_Connected_r18;  /* PRS_BWA_ThreeContiguousIntrabandInMG_r18 */
static int hf_lpp_prs_BWA_TwoContiguousIntraband_RRC_IdleAndInactive_r18;  /* PRS_BWA_TwoContiguousIntrabandInMG_r18 */
static int hf_lpp_prs_BWA_ThreeContiguousIntraband_RRC_IdleAndInactive_r18;  /* PRS_BWA_ThreeContiguousIntrabandInMG_r18 */
static int hf_lpp_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_Connected_r18;  /* T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_Connected_r18 */
static int hf_lpp_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_IdleAndInactive_r18;  /* T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_IdleAndInactive_r18 */
static int hf_lpp_dl_PRS_MeasurementWithRxFH_RRC_Inactive_r18;  /* T_dl_PRS_MeasurementWithRxFH_RRC_Inactive_r18 */
static int hf_lpp_dl_PRS_MeasurementWithRxFH_RRC_Idle_r18;  /* T_dl_PRS_MeasurementWithRxFH_RRC_Idle_r18 */
static int hf_lpp_reducedNumOfSampleForMeasurementWithFH_RRC_Connected_r18;  /* T_reducedNumOfSampleForMeasurementWithFH_RRC_Connected_r18 */
static int hf_lpp_reducedNumOfSampleForMeasurementWithFH_RRC_IdleAndInactive_r18;  /* T_reducedNumOfSampleForMeasurementWithFH_RRC_IdleAndInactive_r18 */
static int hf_lpp_supportOfPRS_BWA_WithTwoPFL_Combination_r18;  /* T_supportOfPRS_BWA_WithTwoPFL_Combination_r18 */
static int hf_lpp_dl_PRS_MeasurementWithRxFH_RRC_Connected_r18;  /* DL_PRS_MeasurementWithRxFH_RRC_Connected_r18 */
static int hf_lpp_prsProcessingType_r17;          /* T_prsProcessingType_r17 */
static int hf_lpp_ppw_dl_PRS_BufferType_r17;      /* T_ppw_dl_PRS_BufferType_r17 */
static int hf_lpp_ppw_durationOfPRS_Processing1_r17;  /* T_ppw_durationOfPRS_Processing1_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsN_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsT_r17 */
static int hf_lpp_ppw_durationOfPRS_Processing2_r17;  /* T_ppw_durationOfPRS_Processing2_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN2_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsN2_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT2_r17;  /* T_ppw_durationOfPRS_ProcessingSymbolsT2_r17 */
static int hf_lpp_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17;  /* T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 */
static int hf_lpp_scs15_r17_02;                   /* T_scs15_r17_01 */
static int hf_lpp_scs30_r17_02;                   /* T_scs30_r17_01 */
static int hf_lpp_scs60_r17_02;                   /* T_scs60_r17_01 */
static int hf_lpp_scs120_r17_02;                  /* T_scs120_r17_01 */
static int hf_lpp_ppw_maxNumOfDL_Bandwidth_r17;   /* T_ppw_maxNumOfDL_Bandwidth_r17 */
static int hf_lpp_fr1_01;                         /* T_fr1_01 */
static int hf_lpp_fr2_01;                         /* T_fr2_01 */
static int hf_lpp_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR1_r18;  /* T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR1_r18 */
static int hf_lpp_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR2_r18;  /* T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR2_r18 */
static int hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18;  /* T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18 */
static int hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18;  /* T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18 */
static int hf_lpp_dl_PRS_BufferTypeOfBWA_r18;     /* T_dl_PRS_BufferTypeOfBWA_r18 */
static int hf_lpp_prs_durationOfTwoPRS_BWA_Processing_r18;  /* T_prs_durationOfTwoPRS_BWA_Processing_r18 */
static int hf_lpp_prs_durationOfTwoPRS_BWA_ProcessingSymbolsN_r18;  /* T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsN_r18 */
static int hf_lpp_prs_durationOfTwoPRS_BWA_ProcessingSymbolsT_r18;  /* T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsT_r18 */
static int hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18;  /* T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18 */
static int hf_lpp_scs15_r18_04;                   /* T_scs15_r18_03 */
static int hf_lpp_scs30_r18_04;                   /* T_scs30_r18_03 */
static int hf_lpp_scs60_r18_04;                   /* T_scs60_r18_03 */
static int hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18;  /* T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18 */
static int hf_lpp_scs60_r18_05;                   /* T_scs60_r18_04 */
static int hf_lpp_scs120_r18_04;                  /* T_scs120_r18_03 */
static int hf_lpp_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR1_r18;  /* T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR1_r18 */
static int hf_lpp_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR2_r18;  /* T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR2_r18 */
static int hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_01;  /* T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_01 */
static int hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_01;  /* T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_01 */
static int hf_lpp_dl_PRS_BufferTypeOfBWA_r18_01;  /* T_dl_PRS_BufferTypeOfBWA_r18_01 */
static int hf_lpp_prs_durationOfThreePRS_BWA_Processing_r18;  /* T_prs_durationOfThreePRS_BWA_Processing_r18 */
static int hf_lpp_prs_durationOfThreePRS_BWA_ProcessingSymbolsN_r18;  /* T_prs_durationOfThreePRS_BWA_ProcessingSymbolsN_r18 */
static int hf_lpp_prs_durationOfThreePRS_BWA_ProcessingSymbolsT_r18;  /* T_prs_durationOfThreePRS_BWA_ProcessingSymbolsT_r18 */
static int hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01;  /* T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01 */
static int hf_lpp_scs15_r18_05;                   /* T_scs15_r18_04 */
static int hf_lpp_scs30_r18_05;                   /* T_scs30_r18_04 */
static int hf_lpp_scs60_r18_06;                   /* T_scs60_r18_05 */
static int hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01;  /* T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01 */
static int hf_lpp_scs60_r18_07;                   /* T_scs60_r18_06 */
static int hf_lpp_scs120_r18_05;                  /* T_scs120_r18_04 */
static int hf_lpp_maximumPRS_BandwidthAcrossAllHopsFR1_r18;  /* T_maximumPRS_BandwidthAcrossAllHopsFR1_r18 */
static int hf_lpp_maximumPRS_BandwidthAcrossAllHopsFR2_r18;  /* T_maximumPRS_BandwidthAcrossAllHopsFR2_r18 */
static int hf_lpp_maximumFH_Hops_r18;             /* T_maximumFH_Hops_r18 */
static int hf_lpp_processingDuration_r18;         /* T_processingDuration_r18 */
static int hf_lpp_processingPRS_SymbolsDurationN3_r18;  /* T_processingPRS_SymbolsDurationN3_r18 */
static int hf_lpp_processingDurationT3_r18;       /* T_processingDurationT3_r18 */
static int hf_lpp_rf_RxRetuneTimeFR1_r18;         /* T_rf_RxRetuneTimeFR1_r18 */
static int hf_lpp_rf_RxRetuneTimeFR2_r18;         /* T_rf_RxRetuneTimeFR2_r18 */
static int hf_lpp_numOfOverlappingPRB_r18;        /* T_numOfOverlappingPRB_r18 */
static int hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16_item;  /* DL_PRS_QCL_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_ssb_FromNeighCellAsQCL_r16;     /* T_ssb_FromNeighCellAsQCL_r16 */
static int hf_lpp_prs_FromServNeighCellAsQCL_r16;  /* T_prs_FromServNeighCellAsQCL_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourceSetPerTrpPerFrequencyLayer_r16;  /* INTEGER_1_2 */
static int hf_lpp_maxNrOfTRP_AcrossFreqs_r16;     /* T_maxNrOfTRP_AcrossFreqs_r16 */
static int hf_lpp_maxNrOfPosLayer_r16;            /* INTEGER_1_4 */
static int hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16 */
static int hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16_item;  /* DL_PRS_ResourcesCapabilityPerBand_r16 */
static int hf_lpp_dl_PRS_ResourcesBandCombinationList_r16;  /* DL_PRS_ResourcesBandCombinationList_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourcesPerResourceSet_r16;  /* T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16;  /* T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16 */
static int hf_lpp_DL_PRS_ResourcesBandCombinationList_r16_item;  /* DL_PRS_ResourcesBandCombination_r16 */
static int hf_lpp_bandList_r16;                   /* SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16 */
static int hf_lpp_bandList_r16_item;              /* FreqBandIndicatorNR_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16;  /* T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16 */
static int hf_lpp_fr1_Only_r16;                   /* T_fr1_Only_r16 */
static int hf_lpp_fr2_Only_r16;                   /* T_fr2_Only_r16 */
static int hf_lpp_fr1_FR2Mix_r16;                 /* T_fr1_FR2Mix_r16 */
static int hf_lpp_fr1_r16;                        /* T_fr1_r16 */
static int hf_lpp_fr2_r16;                        /* T_fr2_r16 */
static int hf_lpp_NR_DL_PRS_TRP_TEG_Info_r17_item;  /* NR_DL_PRS_TRP_TEG_InfoPerFreqLayer_r17 */
static int hf_lpp_NR_DL_PRS_TRP_TEG_InfoPerFreqLayer_r17_item;  /* NR_DL_PRS_TRP_TEG_InfoPerTRP_r17 */
static int hf_lpp_dl_PRS_TEG_InfoSet_r17;         /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_TEG_InfoPerResourceSet_r17 */
static int hf_lpp_dl_PRS_TEG_InfoSet_r17_item;    /* DL_PRS_TEG_InfoPerResourceSet_r17 */
static int hf_lpp_nr_TRP_TxTEG_TimingErrorMargin_r17;  /* TEG_TimingErrorMargin_r17 */
static int hf_lpp_DL_PRS_TEG_InfoPerResourceSet_r17_item;  /* DL_PRS_TEG_InfoElement_r17 */
static int hf_lpp_dl_prs_trp_Tx_TEG_ID_r17;       /* INTEGER_0_maxNumOfTRP_TxTEGs_1_r17 */
static int hf_lpp_nr_ProbOnsetTRP_Fault_r18;      /* INTEGER_0_255 */
static int hf_lpp_nr_MeanTRP_FaultDuration_r18;   /* INTEGER_1_3600 */
static int hf_lpp_NR_IntegrityServiceAlert_r18_item;  /* NR_TRP_IntegrityServiceAlertPerFreqLayer_r18 */
static int hf_lpp_NR_TRP_IntegrityServiceAlertPerFreqLayer_r18_item;  /* NR_TRP_IntegrityServiceAlertElement_r18 */
static int hf_lpp_dl_PRS_ID_r18;                  /* INTEGER_0_255 */
static int hf_lpp_nr_PhysCellID_r18;              /* NR_PhysCellID_r16 */
static int hf_lpp_nr_CellGlobalID_r18;            /* NCGI_r15 */
static int hf_lpp_nr_ARFCN_r18;                   /* ARFCN_ValueNR_r15 */
static int hf_lpp_rtd_DoNotUse_r18;               /* BOOLEAN */
static int hf_lpp_trp_LocationDoNotUse_r18;       /* BOOLEAN */
static int hf_lpp_beamInfo_DoNotUse_r18;          /* BOOLEAN */
static int hf_lpp_beamAntennaInfo_DoNotUse_r18;   /* BOOLEAN */
static int hf_lpp_ir_Minimum_r18;                 /* INTEGER_0_255 */
static int hf_lpp_ir_Maximum_r18;                 /* INTEGER_0_255 */
static int hf_lpp_on_demand_dl_prs_configuration_list_r17;  /* SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_On_Demand_DL_PRS_Configuration_r17 */
static int hf_lpp_on_demand_dl_prs_configuration_list_r17_item;  /* On_Demand_DL_PRS_Configuration_r17 */
static int hf_lpp_onDemandDL_PRS_AggregationList_r18;  /* SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_OnDemandDL_PRS_AggregationInfo_r18 */
static int hf_lpp_onDemandDL_PRS_AggregationList_r18_item;  /* OnDemandDL_PRS_AggregationInfo_r18 */
static int hf_lpp_dl_prs_configuration_id_r17;    /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_nr_DL_PRS_PositioningFrequencyLayer_r17;  /* NR_DL_PRS_PositioningFrequencyLayer_r16 */
static int hf_lpp_nr_DL_PRS_Info_r17;             /* NR_DL_PRS_Info_r16 */
static int hf_lpp_nr_dl_prs_configuration_id_r17;  /* INTEGER_1_maxOD_DL_PRS_Configs_r17 */
static int hf_lpp_OnDemandDL_PRS_AggregationInfo_r18_item;  /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_NR_On_Demand_DL_PRS_Information_r17_item;  /* NR_On_Demand_DL_PRS_PerFreqLayer_r17 */
static int hf_lpp_dl_prs_FrequencyRangeReq_r17;   /* T_dl_prs_FrequencyRangeReq_r17 */
static int hf_lpp_dl_prs_ResourceSetPeriodicityReq_r17;  /* T_dl_prs_ResourceSetPeriodicityReq_r17 */
static int hf_lpp_dl_prs_ResourceBandwidthReq_r17;  /* INTEGER_1_63 */
static int hf_lpp_dl_prs_ResourceRepetitionFactorReq_r17;  /* T_dl_prs_ResourceRepetitionFactorReq_r17 */
static int hf_lpp_dl_prs_NumSymbolsReq_r17;       /* T_dl_prs_NumSymbolsReq_r17 */
static int hf_lpp_dl_prs_CombSizeN_Req_r17;       /* T_dl_prs_CombSizeN_Req_r17 */
static int hf_lpp_dl_prs_QCL_InformationReqTRPlist_r17;  /* DL_PRS_QCL_InformationReqTRPlist_r17 */
static int hf_lpp_DL_PRS_QCL_InformationReqTRPlist_r17_item;  /* DL_PRS_QCL_InformationReqPerTRP_r17 */
static int hf_lpp_dl_prs_QCL_InformationReqSet_r17;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17 */
static int hf_lpp_dl_prs_QCL_InformationReqSet_r17_item;  /* DL_PRS_QCL_InfoReq_r17 */
static int hf_lpp_nr_DL_PRS_ResourceSetID_r17;    /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_dl_prs_QCL_InformationReq_r17;  /* T_dl_prs_QCL_InformationReq_r17 */
static int hf_lpp_dl_prs_QCL_InfoRecPerResourceSet_r17;  /* DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_prs_QCL_Info_requested_r17;  /* NULL */
static int hf_lpp_dl_prs_QCL_InfoRecPerResource_r17;  /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_prs_QCL_InfoRecPerResource_r17_item;  /* DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_prs_StartTime_and_Duration_r17;  /* DL_PRS_StartTime_and_Duration_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_Information_r17;  /* NR_On_Demand_DL_PRS_Information_r17 */
static int hf_lpp_dl_prs_configuration_id_PrefList_r17;  /* SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17 */
static int hf_lpp_dl_prs_configuration_id_PrefList_r17_item;  /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_dl_PRS_AggregationID_PrefList_r18;  /* T_dl_PRS_AggregationID_PrefList_r18 */
static int hf_lpp_dl_PRS_AggregationID_PrefList_r18_item;  /* INTEGER_1_maxOD_DL_PRS_Configs_r17 */
static int hf_lpp_nr_OnDemandDL_PRS_AggregationReqList_r18;  /* SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18 */
static int hf_lpp_nr_OnDemandDL_PRS_AggregationReqList_r18_item;  /* NR_OnDemandDL_PRS_AggregationReqElement_r18 */
static int hf_lpp_dl_prs_start_time_r17;          /* INTEGER_1_1024 */
static int hf_lpp_dl_prs_duration_r17;            /* T_dl_prs_duration_r17 */
static int hf_lpp_seconds_r17;                    /* INTEGER_0_59 */
static int hf_lpp_minutes_r17;                    /* INTEGER_0_59 */
static int hf_lpp_hours_r17;                      /* INTEGER_0_23 */
static int hf_lpp_NR_OnDemandDL_PRS_AggregationReqElement_r18_item;  /* INTEGER_1_nrMaxFreqLayers_r16 */
static int hf_lpp_NR_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17_item;  /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_InformationSup_r17;  /* T_nr_on_demand_DL_PRS_InformationSup_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_ConfigurationsSup_r17;  /* T_nr_on_demand_DL_PRS_ConfigurationsSup_r17 */
static int hf_lpp_nr_PeriodicPRU_DL_Info_r18;     /* NR_PeriodicControlParam_r18 */
static int hf_lpp_nr_PeriodicPRU_DL_InfoReq_r18;  /* NR_PeriodicControlParam_r18 */
static int hf_lpp_deliveryAmount_r18;             /* INTEGER_1_32 */
static int hf_lpp_deliveryInterval_r18;           /* INTEGER_4_81920 */
static int hf_lpp_nr_TRP_LocationInfo_r16;        /* NR_TRP_LocationInfo_r16 */
static int hf_lpp_nr_DL_PRS_BeamInfo_r16;         /* NR_DL_PRS_BeamInfo_r16 */
static int hf_lpp_nr_RTD_Info_r16;                /* NR_RTD_Info_r16 */
static int hf_lpp_nr_TRP_BeamAntennaInfo_r17;     /* NR_TRP_BeamAntennaInfo_r17 */
static int hf_lpp_nr_DL_PRS_Expected_LOS_NLOS_Assistance_r17;  /* NR_DL_PRS_ExpectedLOS_NLOS_Assistance_r17 */
static int hf_lpp_nr_DL_PRS_TRP_TEG_Info_r17;     /* NR_DL_PRS_TRP_TEG_Info_r17 */
static int hf_lpp_nr_IntegrityServiceParameters_r18;  /* NR_IntegrityServiceParameters_r18 */
static int hf_lpp_nr_IntegrityServiceAlert_r18;   /* NR_IntegrityServiceAlert_r18 */
static int hf_lpp_nr_IntegrityRiskParameters_r18;  /* NR_IntegrityRiskParameters_r18 */
static int hf_lpp_nr_IntegrityParametersTRP_LocationInfo_r18;  /* NR_IntegrityParametersTRP_LocationInfo_r18 */
static int hf_lpp_nr_IntegrityParametersDL_PRS_BeamInfo_r18;  /* NR_IntegrityParametersDL_PRS_BeamInfo_r18 */
static int hf_lpp_nr_IntegrityParametersRTD_Info_r18;  /* NR_IntegrityParametersRTD_Info_r18 */
static int hf_lpp_nr_IntegrityParametersTRP_BeamAntennaInfo_r18;  /* NR_IntegrityParametersTRP_BeamAntennaInfo_r18 */
static int hf_lpp_nr_PRU_DL_Info_r18;             /* NR_PRU_DL_Info_r18 */
static int hf_lpp_trp_ErrorCorrelationTime_r18;   /* INTEGER_0_255 */
static int hf_lpp_dl_PRS_ResourceSetARP_ErrorCorrelationTime_r18;  /* INTEGER_0_255 */
static int hf_lpp_dl_PRS_ResourceARP_ErrorCorrelationTime_r18;  /* INTEGER_0_255 */
static int hf_lpp_dl_PRS_BeamInfoErrorCorrelationTime_r18;  /* INTEGER_0_255 */
static int hf_lpp_rtd_ErrorCorrelationTime_r18;   /* INTEGER_0_255 */
static int hf_lpp_trp_BeamAntennaInfoErrorCorrelationTime_r18;  /* INTEGER_0_255 */
static int hf_lpp_nr_PRU_LocationInfo_r18;        /* LocationCoordinates */
static int hf_lpp_nr_PRU_DL_TDOA_MeasInfo_r18;    /* NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_PRU_DL_AoD_MeasInfo_r18;     /* NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_PRU_RSCP_MeasInfo_r18;       /* NR_PRU_RSCP_MeasurementInformation_r18 */
static int hf_lpp_NR_PRU_RSCP_MeasurementInformation_r18_item;  /* NR_PRU_RSCP_MeasElement_r18 */
static int hf_lpp_nr_TimeStamp_r18;               /* NR_TimeStamp_r16 */
static int hf_lpp_nr_los_nlos_Indicator_r18;      /* T_nr_los_nlos_Indicator_r18 */
static int hf_lpp_perTRP;                         /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_perResource;                    /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_nr_RSCP_r18;                    /* INTEGER_0_3599 */
static int hf_lpp_nr_DL_PRS_RSRP_Result_r18;      /* INTEGER_0_126 */
static int hf_lpp_nr_DL_PRS_FirstPathRSRP_Result_r18;  /* INTEGER_0_126 */
static int hf_lpp_nr_PhaseQuality_r18;            /* NR_PhaseQuality_r18 */
static int hf_lpp_nr_PRU_RSCP_AddSampleMeasurements_r18;  /* SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_PRU_RSCP_AddSampleMeasurements_r18_item;  /* NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_PRU_RSRP_AddSampleMeasurements_r18;  /* T_nr_PRU_RSRP_AddSampleMeasurements_r18 */
static int hf_lpp_nr_PRU_RSRP_AddSampleMeasurements_r18_item;  /* INTEGER_0_61 */
static int hf_lpp_nr_PRU_FirstPathRSRP_ResultDiff_AddSampleMeasurements_r18;  /* T_nr_PRU_FirstPathRSRP_ResultDiff_AddSampleMeasurements_r18 */
static int hf_lpp_nr_PRU_FirstPathRSRP_ResultDiff_AddSampleMeasurements_r18_item;  /* INTEGER_0_61 */
static int hf_lpp_nr_PRU_RSCP_AdditionalMeasurements_r18;  /* NR_PRU_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_NR_PRU_RSCP_AdditionalMeasurements_r18_item;  /* NR_PRU_RSCP_AdditionalMeasurementElement_r18 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r18;  /* INTEGER_0_61 */
static int hf_lpp_nr_DL_PRS_FirstPathRSRP_ResultDiff_r18;  /* INTEGER_0_61 */
static int hf_lpp_nr_PRU_RSCP_AdditionalMeasurementsList_r18;  /* SEQUENCE_SIZE_1_nrNumOfSamples_r18_OF_NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_PRU_RSCP_AdditionalMeasurementsList_r18_item;  /* NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_PRU_RSRPDiff_AdditionalMeasurementsList_r18;  /* T_nr_PRU_RSRPDiff_AdditionalMeasurementsList_r18 */
static int hf_lpp_nr_PRU_RSRPDiff_AdditionalMeasurementsList_r18_item;  /* INTEGER_0_61 */
static int hf_lpp_nr_PRU_FirstPathRSRP_ResultDiff_AdditionalMeasurementsList_r18;  /* T_nr_PRU_FirstPathRSRP_ResultDiff_AdditionalMeasurementsList_r18 */
static int hf_lpp_nr_PRU_FirstPathRSRP_ResultDiff_AdditionalMeasurementsList_r18_item;  /* INTEGER_0_61 */
static int hf_lpp_referenceTRP_RTD_Info_r16;      /* ReferenceTRP_RTD_Info_r16 */
static int hf_lpp_rtd_InfoList_r16;               /* RTD_InfoList_r16 */
static int hf_lpp_dl_PRS_ID_Ref_r16;              /* INTEGER_0_255 */
static int hf_lpp_nr_PhysCellID_Ref_r16;          /* NR_PhysCellID_r16 */
static int hf_lpp_nr_CellGlobalID_Ref_r16;        /* NCGI_r15 */
static int hf_lpp_nr_ARFCN_Ref_r16;               /* ARFCN_ValueNR_r15 */
static int hf_lpp_refTime_r16;                    /* T_refTime_r16 */
static int hf_lpp_systemFrameNumber_r16;          /* BIT_STRING_SIZE_10 */
static int hf_lpp_utc_r16;                        /* UTCTime */
static int hf_lpp_rtd_RefQuality_r16;             /* NR_TimingQuality_r16 */
static int hf_lpp_RTD_InfoList_r16_item;          /* RTD_InfoListPerFreqLayer_r16 */
static int hf_lpp_RTD_InfoListPerFreqLayer_r16_item;  /* RTD_InfoElement_r16 */
static int hf_lpp_subframeOffset_r16;             /* INTEGER_0_1966079 */
static int hf_lpp_rtd_Quality_r16;                /* NR_TimingQuality_r16 */
static int hf_lpp_nr_IntegrityRTD_InfoBounds_r18;  /* NR_IntegrityRTD_InfoBounds_r18 */
static int hf_lpp_resolution_r18;                 /* T_resolution_r18 */
static int hf_lpp_meanRTD_r18;                    /* INTEGER_0_255 */
static int hf_lpp_stdDevRTD_r18;                  /* INTEGER_0_31 */
static int hf_lpp_NR_SelectedDL_PRS_IndexList_r16_item;  /* NR_SelectedDL_PRS_PerFreq_r16 */
static int hf_lpp_nr_SelectedDL_PRS_FrequencyLayerIndex_r16;  /* INTEGER_0_nrMaxFreqLayers_1_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexListPerFreq_r16;  /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_SelectedDL_PRS_IndexPerTRP_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexListPerFreq_r16_item;  /* NR_SelectedDL_PRS_IndexPerTRP_r16 */
static int hf_lpp_nr_SelectedTRP_Index_r16;       /* INTEGER_0_nrMaxTRPsPerFreq_1_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceSetIndexList_r16;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_SelectedPRS_ResourceSetIndex_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceSetIndexList_r16_item;  /* DL_SelectedPRS_ResourceSetIndex_r16 */
static int hf_lpp_nr_DL_SelectedPRS_ResourceSetIndex_r16;  /* INTEGER_0_nrMaxSetsPerTrpPerFreqLayer_1_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceIndexList_r16;  /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_SelectedPRS_ResourceIndex_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceIndexList_r16_item;  /* DL_SelectedPRS_ResourceIndex_r16 */
static int hf_lpp_nr_DL_SelectedPRS_ResourceIdIndex_r16;  /* INTEGER_0_nrMaxNumDL_PRS_ResourcesPerSet_1_r16 */
static int hf_lpp_ss_PBCH_BlockPower_r16;         /* INTEGER_M60_50 */
static int hf_lpp_halfFrameIndex_r16;             /* INTEGER_0_1 */
static int hf_lpp_ssb_periodicity_r16;            /* T_ssb_periodicity_r16 */
static int hf_lpp_ssb_PositionsInBurst_r16;       /* T_ssb_PositionsInBurst_r16 */
static int hf_lpp_shortBitmap_r16;                /* BIT_STRING_SIZE_4 */
static int hf_lpp_mediumBitmap_r16;               /* BIT_STRING_SIZE_8 */
static int hf_lpp_longBitmap_r16;                 /* BIT_STRING_SIZE_64 */
static int hf_lpp_ssb_SubcarrierSpacing_r16;      /* T_ssb_SubcarrierSpacing_r16 */
static int hf_lpp_sfn_SSB_Offset_r16;             /* INTEGER_0_15 */
static int hf_lpp_nr_SFN_r16;                     /* INTEGER_0_1023 */
static int hf_lpp_nr_Slot_r16;                    /* T_nr_Slot_r16 */
static int hf_lpp_scs15_r16_02;                   /* INTEGER_0_9 */
static int hf_lpp_scs30_r16_02;                   /* INTEGER_0_19 */
static int hf_lpp_scs60_r16_02;                   /* INTEGER_0_39 */
static int hf_lpp_scs120_r16_02;                  /* INTEGER_0_79 */
static int hf_lpp_nr_Symbol_r18;                  /* INTEGER_0_13 */
static int hf_lpp_timingQualityValue_r16;         /* INTEGER_0_31 */
static int hf_lpp_timingQualityResolution_r16;    /* T_timingQualityResolution_r16 */
static int hf_lpp_NR_TRP_BeamAntennaInfo_r17_item;  /* NR_TRP_BeamAntennaInfoPerFreqLayer_r17 */
static int hf_lpp_NR_TRP_BeamAntennaInfoPerFreqLayer_r17_item;  /* NR_TRP_BeamAntennaInfoPerTRP_r17 */
static int hf_lpp_associated_DL_PRS_ID_r17;       /* INTEGER_0_255 */
static int hf_lpp_lcs_GCS_TranslationParameter_r17;  /* LCS_GCS_TranslationParameter_r16 */
static int hf_lpp_nr_TRP_BeamAntennaAngles_r17;   /* NR_TRP_BeamAntennaAngles_r17 */
static int hf_lpp_NR_TRP_BeamAntennaAngles_r17_item;  /* NR_TRP_BeamAntennaInfoAzimuthElevation_r17 */
static int hf_lpp_azimuth_r17;                    /* INTEGER_0_359 */
static int hf_lpp_azimuth_fine_r17;               /* INTEGER_0_9 */
static int hf_lpp_elevationList_r17;              /* SEQUENCE_SIZE_1_1801_OF_ElevationElement_R17 */
static int hf_lpp_elevationList_r17_item;         /* ElevationElement_R17 */
static int hf_lpp_elevation_r17;                  /* INTEGER_0_180 */
static int hf_lpp_elevation_fine_r17;             /* INTEGER_0_9 */
static int hf_lpp_beamPowerList_r17;              /* SEQUENCE_SIZE_2_maxNumResourcesPerAngle_r17_OF_BeamPowerElement_r17 */
static int hf_lpp_beamPowerList_r17_item;         /* BeamPowerElement_r17 */
static int hf_lpp_nr_dl_prs_ResourceSetID_r17;    /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_nr_dl_prs_ResourceID_r17;       /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_dl_prs_RelativePower_r17;    /* INTEGER_0_30 */
static int hf_lpp_nr_dl_prs_RelativePowerFine_r17;  /* INTEGER_0_9 */
static int hf_lpp_nr_IntegrityBeamPowerBounds_r18;  /* NR_IntegrityBeamPowerBounds_r18 */
static int hf_lpp_meanBeamPower_r18;              /* INTEGER_0_127 */
static int hf_lpp_stdDevBeamPower_r18;            /* INTEGER_0_127 */
static int hf_lpp_NR_TRP_LocationInfo_r16_item;   /* NR_TRP_LocationInfoPerFreqLayer_r16 */
static int hf_lpp_referencePoint_r16;             /* ReferencePoint_r16 */
static int hf_lpp_trp_LocationInfoList_r16;       /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_TRP_LocationInfoElement_r16 */
static int hf_lpp_trp_LocationInfoList_r16_item;  /* TRP_LocationInfoElement_r16 */
static int hf_lpp_trp_Location_r16;               /* RelativeLocation_r16 */
static int hf_lpp_trp_DL_PRS_ResourceSets_r16;    /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_ResourceSets_TRP_Element_r16 */
static int hf_lpp_trp_DL_PRS_ResourceSets_r16_item;  /* DL_PRS_ResourceSets_TRP_Element_r16 */
static int hf_lpp_trp_LocationCartesian_r18;      /* RelativeCartesianLocation_r18 */
static int hf_lpp_nr_IntegrityTRP_LocationBounds_r18;  /* NR_IntegrityLocationBounds_r18 */
static int hf_lpp_dl_PRS_ResourceSetARP_r16;      /* RelativeLocation_r16 */
static int hf_lpp_dl_PRS_Resource_ARP_List_r16;   /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_Resource_ARP_Element_r16 */
static int hf_lpp_dl_PRS_Resource_ARP_List_r16_item;  /* DL_PRS_Resource_ARP_Element_r16 */
static int hf_lpp_dl_PRS_ResourceSetARP_Cartesian_r18;  /* RelativeCartesianLocation_r18 */
static int hf_lpp_nr_IntegrityDL_PRS_ResourceSetARP_LocationBounds_r18;  /* NR_IntegrityLocationBounds_r18 */
static int hf_lpp_dl_PRS_Resource_ARP_location_r16;  /* RelativeLocation_r16 */
static int hf_lpp_dl_PRS_Resource_ARP_locationCartesian_r18;  /* RelativeCartesianLocation_r18 */
static int hf_lpp_nr_IntegrityDL_PRS_ResourceARP_LocationBounds_r18;  /* NR_IntegrityLocationBounds_r18 */
static int hf_lpp_units_r18;                      /* T_units_r18 */
static int hf_lpp_meanLocationErrorBound_r18;     /* T_meanLocationErrorBound_r18 */
static int hf_lpp_horizontal_r18;                 /* INTEGER_0_255 */
static int hf_lpp_vertical_r18;                   /* INTEGER_0_255 */
static int hf_lpp_stdDevLocationErrorBound_r18;   /* T_stdDevLocationErrorBound_r18 */
static int hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17 */
static int hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17_item;  /* NR_UE_TEG_ID_CapabilityPerBand_r17 */
static int hf_lpp_freqBandIndicatorNR_r17;        /* FreqBandIndicatorNR_r16 */
static int hf_lpp_nr_UE_RxTEG_ID_MaxSupport_r17;  /* T_nr_UE_RxTEG_ID_MaxSupport_r17 */
static int hf_lpp_nr_UE_TxTEG_ID_MaxSupport_r17;  /* T_nr_UE_TxTEG_ID_MaxSupport_r17 */
static int hf_lpp_nr_UE_RxTxTEG_ID_MaxSupport_r17;  /* T_nr_UE_RxTxTEG_ID_MaxSupport_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17 */
static int hf_lpp_srs_CapabilityBandList_r16;     /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16 */
static int hf_lpp_srs_CapabilityBandList_r16_item;  /* SRS_CapabilityPerBand_r16 */
static int hf_lpp_srs_PosResourceConfigCA_BandList_r16;  /* SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16 */
static int hf_lpp_srs_PosResourceConfigCA_BandList_r16_item;  /* SRS_PosResourcesPerBand_r16 */
static int hf_lpp_maxNumberSRS_PosPathLossEstimateAllServingCells_r16;  /* T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 */
static int hf_lpp_maxNumberSRS_PosSpatialRelationsAllServingCells_r16;  /* T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 */
static int hf_lpp_olpc_SRS_Pos_r16;               /* OLPC_SRS_Pos_r16 */
static int hf_lpp_spatialRelationsSRS_Pos_r16;    /* SpatialRelationsSRS_Pos_r16 */
static int hf_lpp_posSRS_RRC_Inactive_InInitialUL_BWP_r17;  /* PosSRS_RRC_Inactive_InInitialUL_BWP_r17 */
static int hf_lpp_posSRS_RRC_Inactive_OutsideInitialUL_BWP_r17;  /* PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 */
static int hf_lpp_olpc_SRS_PosRRC_Inactive_r17;   /* OLPC_SRS_Pos_r16 */
static int hf_lpp_spatialRelationsSRS_PosRRC_Inactive_r17;  /* SpatialRelationsSRS_Pos_r16 */
static int hf_lpp_posSRS_SP_RRC_Inactive_InInitialUL_BWP_r17;  /* PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17 */
static int hf_lpp_posSRS_Preconfigured_RRC_InactiveInitialUL_BWP_r18;  /* T_posSRS_Preconfigured_RRC_InactiveInitialUL_BWP_r18 */
static int hf_lpp_posSRS_Preconfigured_RRC_InactiveOutsideInitialUL_BWP_r18;  /* T_posSRS_Preconfigured_RRC_InactiveOutsideInitialUL_BWP_r18 */
static int hf_lpp_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18;  /* T_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18 */
static int hf_lpp_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18;  /* T_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18 */
static int hf_lpp_posSRS_TxFH_RRC_Connected_r18;  /* PosSRS_TxFrequencyHoppingRRC_Connected_r18 */
static int hf_lpp_posSRS_TxFH_RRC_Inactive_r18;   /* PosSRS_TxFrequencyHoppingRRC_Inactive_r18 */
static int hf_lpp_posSRS_TxFH_WithTimeWindow_r18;  /* T_posSRS_TxFH_WithTimeWindow_r18 */
static int hf_lpp_posSRS_BWA_RRC_Inactive_r18;    /* PosSRS_BWA_RRC_Inactive_r18 */
static int hf_lpp_olpc_SRS_PosBasedOnPRS_Serving_r16;  /* T_olpc_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_lpp_olpc_SRS_PosBasedOnSSB_Neigh_r16;  /* T_olpc_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_lpp_olpc_SRS_PosBasedOnPRS_Neigh_r16;  /* T_olpc_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_lpp_maxNumberPathLossEstimatePerServing_r16;  /* T_maxNumberPathLossEstimatePerServing_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Serving_r16;  /* T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16;  /* T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Serving_r16;  /* T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnSRS_r16;  /* T_spatialRelation_SRS_PosBasedOnSRS_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16;  /* T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16;  /* T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_lpp_maxNumberSRS_PosResourceSetsPerBWP_r16;  /* T_maxNumberSRS_PosResourceSetsPerBWP_r16 */
static int hf_lpp_maxNumberSRS_PosResourcesPerBWP_r16;  /* T_maxNumberSRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumberPeriodicSRS_PosResourcesPerBWP_r16;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumberAP_SRS_PosResourcesPerBWP_r16;  /* T_maxNumberAP_SRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumberSP_SRS_PosResourcesPerBWP_r16;  /* T_maxNumberSP_SRS_PosResourcesPerBWP_r16 */
static int hf_lpp_posSRS_BWA_RRC_Connected_r18;   /* PosSRS_BWA_RRC_Connected_r18 */
static int hf_lpp_posSRS_BWA_IndependentCA_RRC_Connected_r18;  /* PosSRS_BWA_IndependentCA_RRC_Connected_r18 */
static int hf_lpp_maxNumOfSRSposResourceSets_r17;  /* T_maxNumOfSRSposResourceSets_r17 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17 */
static int hf_lpp_maxNumOfPeriodicSRSposResources_r17;  /* T_maxNumOfPeriodicSRSposResources_r17 */
static int hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17;  /* T_maxNumOfPeriodicSRSposResourcesPerSlot_r17 */
static int hf_lpp_dummy1;                         /* T_dummy1 */
static int hf_lpp_dummy2;                         /* T_dummy2 */
static int hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17;  /* T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17 */
static int hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17;  /* T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17 */
static int hf_lpp_maxNumOfSRSposResourceSets_r17_01;  /* T_maxNumOfSRSposResourceSets_r17_01 */
static int hf_lpp_maxNumOfPeriodicSRSposResources_r17_01;  /* T_maxNumOfPeriodicSRSposResources_r17_01 */
static int hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01;  /* T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01 */
static int hf_lpp_differentNumerologyBetweenSRSposAndInitialBWP_r17;  /* T_differentNumerologyBetweenSRSposAndInitialBWP_r17 */
static int hf_lpp_srsPosWithoutRestrictionOnBWP_r17;  /* T_srsPosWithoutRestrictionOnBWP_r17 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01 */
static int hf_lpp_differentCenterFreqBetweenSRSposAndInitialBWP_r17;  /* T_differentCenterFreqBetweenSRSposAndInitialBWP_r17 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResources_r17;  /* T_maxNumOfSemiPersistentSRSposResources_r17 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17;  /* T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17 */
static int hf_lpp_switchingTimeSRS_TX_OtherTX_r17;  /* T_switchingTimeSRS_TX_OtherTX_r17 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResources_r17_01;  /* T_maxNumOfSemiPersistentSRSposResources_r17_01 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01;  /* T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01 */
static int hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR1_r18;  /* T_maximumSRS_BandwidthAcrossAllHopsFR1_r18 */
static int hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR2_r18;  /* T_maximumSRS_BandwidthAcrossAllHopsFR2_r18 */
static int hf_lpp_maximumTxFH_Hops_r18;           /* T_maximumTxFH_Hops_r18 */
static int hf_lpp_rf_TxRetuneTimeFR1_r18;         /* T_rf_TxRetuneTimeFR1_r18 */
static int hf_lpp_rf_TxRetuneTimeFR2_r18;         /* T_rf_TxRetuneTimeFR2_r18 */
static int hf_lpp_switchTimeBetweenActiveBWP_FrequencyHop_r18;  /* T_switchTimeBetweenActiveBWP_FrequencyHop_r18 */
static int hf_lpp_numOfOverlappingPRB_r18_01;     /* T_numOfOverlappingPRB_r18_01 */
static int hf_lpp_maximumSRS_ResourcePeriodic_r18;  /* T_maximumSRS_ResourcePeriodic_r18 */
static int hf_lpp_maximumSRS_ResourceAperiodic_r18;  /* T_maximumSRS_ResourceAperiodic_r18 */
static int hf_lpp_maximumSRS_ResourceSemipersistent_r18;  /* T_maximumSRS_ResourceSemipersistent_r18 */
static int hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01;  /* T_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01 */
static int hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01;  /* T_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01 */
static int hf_lpp_maximumTxFH_Hops_r18_01;        /* T_maximumTxFH_Hops_r18_01 */
static int hf_lpp_rf_TxRetuneTimeFR1_r18_01;      /* T_rf_TxRetuneTimeFR1_r18_01 */
static int hf_lpp_rf_TxRetuneTimeFR2_r18_01;      /* T_rf_TxRetuneTimeFR2_r18_01 */
static int hf_lpp_switchTimeBetweenActiveBWP_FrequencyHop_r18_01;  /* T_switchTimeBetweenActiveBWP_FrequencyHop_r18_01 */
static int hf_lpp_numOfOverlappingPRB_r18_02;     /* T_numOfOverlappingPRB_r18_02 */
static int hf_lpp_maximumSRS_ResourcePeriodic_r18_01;  /* T_maximumSRS_ResourcePeriodic_r18_01 */
static int hf_lpp_maximumSRS_ResourceSemipersistent_r18_01;  /* T_maximumSRS_ResourceSemipersistent_r18_01 */
static int hf_lpp_numOfCarriersIntraBandContiguous_r18;  /* T_numOfCarriersIntraBandContiguous_r18 */
static int hf_lpp_maximumAggregatedBW_TwoCarriersFR1_r18;  /* T_maximumAggregatedBW_TwoCarriersFR1_r18 */
static int hf_lpp_maximumAggregatedBW_TwoCarriersFR2_r18;  /* T_maximumAggregatedBW_TwoCarriersFR2_r18 */
static int hf_lpp_maximumAggregatedBW_ThreeCarriersFR1_r18;  /* T_maximumAggregatedBW_ThreeCarriersFR1_r18 */
static int hf_lpp_maximumAggregatedBW_ThreeCarriersFR2_r18;  /* T_maximumAggregatedBW_ThreeCarriersFR2_r18 */
static int hf_lpp_maximumAggregatedResourceSet_r18;  /* T_maximumAggregatedResourceSet_r18 */
static int hf_lpp_maximumAggregatedResourcePeriodic_r18;  /* T_maximumAggregatedResourcePeriodic_r18 */
static int hf_lpp_maximumAggregatedResourceAperiodic_r18;  /* T_maximumAggregatedResourceAperiodic_r18 */
static int hf_lpp_maximumAggregatedResourceSemi_r18;  /* T_maximumAggregatedResourceSemi_r18 */
static int hf_lpp_maximumAggregatedResourcePeriodicPerSlot_r18;  /* T_maximumAggregatedResourcePeriodicPerSlot_r18 */
static int hf_lpp_maximumAggregatedResourceAperiodicPerSlot_r18;  /* T_maximumAggregatedResourceAperiodicPerSlot_r18 */
static int hf_lpp_maximumAggregatedResourceSemiPerSlot_r18;  /* T_maximumAggregatedResourceSemiPerSlot_r18 */
static int hf_lpp_numOfCarriersIntraBandContiguous_r18_01;  /* T_numOfCarriersIntraBandContiguous_r18_01 */
static int hf_lpp_maximumAggregatedBW_TwoCarriersFR1_r18_01;  /* T_maximumAggregatedBW_TwoCarriersFR1_r18_01 */
static int hf_lpp_maximumAggregatedBW_TwoCarriersFR2_r18_01;  /* T_maximumAggregatedBW_TwoCarriersFR2_r18_01 */
static int hf_lpp_maximumAggregatedBW_ThreeCarriersFR1_r18_01;  /* T_maximumAggregatedBW_ThreeCarriersFR1_r18_01 */
static int hf_lpp_maximumAggregatedBW_ThreeCarriersFR2_r18_01;  /* T_maximumAggregatedBW_ThreeCarriersFR2_r18_01 */
static int hf_lpp_maximumAggregatedResourceSet_r18_01;  /* T_maximumAggregatedResourceSet_r18_01 */
static int hf_lpp_maximumAggregatedResourcePeriodic_r18_01;  /* T_maximumAggregatedResourcePeriodic_r18_01 */
static int hf_lpp_maximumAggregatedResourceAperiodic_r18_01;  /* T_maximumAggregatedResourceAperiodic_r18_01 */
static int hf_lpp_maximumAggregatedResourceSemi_r18_01;  /* T_maximumAggregatedResourceSemi_r18_01 */
static int hf_lpp_maximumAggregatedResourcePeriodicPerSlot_r18_01;  /* T_maximumAggregatedResourcePeriodicPerSlot_r18_01 */
static int hf_lpp_maximumAggregatedResourceAperiodicPerSlot_r18_01;  /* T_maximumAggregatedResourceAperiodicPerSlot_r18_01 */
static int hf_lpp_maximumAggregatedResourceSemiPerSlot_r18_01;  /* T_maximumAggregatedResourceSemiPerSlot_r18_01 */
static int hf_lpp_guardPeriod_r18;                /* T_guardPeriod_r18 */
static int hf_lpp_powerClassForTwoAggregatedCarriers_r18;  /* T_powerClassForTwoAggregatedCarriers_r18 */
static int hf_lpp_powerClassForThreeAggregatedCarriers_r18;  /* T_powerClassForThreeAggregatedCarriers_r18 */
static int hf_lpp_numOfCarriersIntraBandContiguous_r18_02;  /* T_numOfCarriersIntraBandContiguous_r18_02 */
static int hf_lpp_maximumAggregatedBW_TwoCarriersFR1_r18_02;  /* T_maximumAggregatedBW_TwoCarriersFR1_r18_02 */
static int hf_lpp_maximumAggregatedBW_TwoCarriersFR2_r18_02;  /* T_maximumAggregatedBW_TwoCarriersFR2_r18_02 */
static int hf_lpp_maximumAggregatedBW_ThreeCarriersFR1_r18_02;  /* T_maximumAggregatedBW_ThreeCarriersFR1_r18_02 */
static int hf_lpp_maximumAggregatedBW_ThreeCarriersFR2_r18_02;  /* T_maximumAggregatedBW_ThreeCarriersFR2_r18_02 */
static int hf_lpp_maximumAggregatedResourceSet_r18_02;  /* T_maximumAggregatedResourceSet_r18_02 */
static int hf_lpp_maximumAggregatedResourcePeriodic_r18_02;  /* T_maximumAggregatedResourcePeriodic_r18_02 */
static int hf_lpp_maximumAggregatedResourceSemi_r18_02;  /* T_maximumAggregatedResourceSemi_r18_02 */
static int hf_lpp_maximumAggregatedResourcePeriodicPerSlot_r18_02;  /* T_maximumAggregatedResourcePeriodicPerSlot_r18_02 */
static int hf_lpp_maximumAggregatedResourceSemiPerSlot_r18_02;  /* T_maximumAggregatedResourceSemiPerSlot_r18_02 */
static int hf_lpp_guardPeriod_r18_01;             /* T_guardPeriod_r18_01 */
static int hf_lpp_powerClassForTwoAggregatedCarriers_r18_01;  /* T_powerClassForTwoAggregatedCarriers_r18_01 */
static int hf_lpp_powerClassForThreeAggregatedCarriers_r18_01;  /* T_powerClassForThreeAggregatedCarriers_r18_01 */
static int hf_lpp_phaseQualityIndex_r18;          /* INTEGER_0_179 */
static int hf_lpp_phaseQualityResolution_r18;     /* T_phaseQualityResolution_r18 */
static int hf_lpp_referencePointGeographicLocation_r16;  /* T_referencePointGeographicLocation_r16 */
static int hf_lpp_location3D_r16;                 /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_ha_location3D_r16;              /* HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 */
static int hf_lpp_localOrigin_v1800;              /* LocalOrigin_r18 */
static int hf_lpp_cartesianCoordinatesUnits_r18_02;  /* T_cartesianCoordinatesUnits_r18_02 */
static int hf_lpp_locationUnc_r18;                /* LocationUncertainty_r16 */
static int hf_lpp_delta_x_r18;                    /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_x_r18;             /* INTEGER_0_4095 */
static int hf_lpp_delta_y_r18;                    /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_y_r18;             /* INTEGER_0_4095 */
static int hf_lpp_delta_z_r18;                    /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_z_r18;             /* INTEGER_0_4095 */
static int hf_lpp_milli_arc_second_units_r16;     /* T_milli_arc_second_units_r16 */
static int hf_lpp_height_units_r16;               /* T_height_units_r16 */
static int hf_lpp_delta_latitude_r16;             /* Delta_Latitude_r16 */
static int hf_lpp_delta_longitude_r16;            /* Delta_Longitude_r16 */
static int hf_lpp_delta_height_r16;               /* Delta_Height_r16 */
static int hf_lpp_locationUNC_r16;                /* LocationUncertainty_r16 */
static int hf_lpp_delta_Latitude_r16;             /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_Latitude_r16;      /* INTEGER_0_4095 */
static int hf_lpp_delta_Longitude_r16;            /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_Longitude_r16;     /* INTEGER_0_4095 */
static int hf_lpp_delta_Height_r16;               /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_Height_r16;        /* INTEGER_0_4095 */
static int hf_lpp_horizontalUncertainty_r16;      /* INTEGER_0_255 */
static int hf_lpp_verticalUncertainty_r16;        /* INTEGER_0_255 */
static int hf_lpp_otdoa_ReferenceCellInfo;        /* OTDOA_ReferenceCellInfo */
static int hf_lpp_otdoa_NeighbourCellInfo;        /* OTDOA_NeighbourCellInfoList */
static int hf_lpp_otdoa_Error;                    /* OTDOA_Error */
static int hf_lpp_otdoa_ReferenceCellInfoNB_r14;  /* OTDOA_ReferenceCellInfoNB_r14 */
static int hf_lpp_otdoa_NeighbourCellInfoNB_r14;  /* OTDOA_NeighbourCellInfoListNB_r14 */
static int hf_lpp_physCellId;                     /* INTEGER_0_503 */
static int hf_lpp_cellGlobalId;                   /* ECGI */
static int hf_lpp_earfcnRef;                      /* ARFCN_ValueEUTRA */
static int hf_lpp_antennaPortConfig;              /* T_antennaPortConfig */
static int hf_lpp_cpLength;                       /* T_cpLength */
static int hf_lpp_prsInfo;                        /* PRS_Info */
static int hf_lpp_earfcnRef_v9a0;                 /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_tpId_r14;                       /* INTEGER_0_4095 */
static int hf_lpp_cpLengthCRS_r14;                /* T_cpLengthCRS_r14 */
static int hf_lpp_sameMBSFNconfigRef_r14;         /* BOOLEAN */
static int hf_lpp_dlBandwidth_r14;                /* T_dlBandwidth_r14 */
static int hf_lpp_addPRSconfigRef_r14;            /* SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info */
static int hf_lpp_addPRSconfigRef_r14_item;       /* PRS_Info */
static int hf_lpp_nr_LTE_SFN_Offset_r15;          /* INTEGER_0_1023 */
static int hf_lpp_tdd_config_v1520;               /* TDD_Config_v1520 */
static int hf_lpp_nr_LTE_fineTiming_Offset_r15;   /* INTEGER_0_19 */
static int hf_lpp_prs_Bandwidth;                  /* T_prs_Bandwidth */
static int hf_lpp_prs_ConfigurationIndex;         /* INTEGER_0_4095 */
static int hf_lpp_numDL_Frames;                   /* T_numDL_Frames */
static int hf_lpp_prs_MutingInfo_r9;              /* T_prs_MutingInfo_r9 */
static int hf_lpp_po2_r9;                         /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r9;                         /* BIT_STRING_SIZE_4 */
static int hf_lpp_po8_r9;                         /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r9;                        /* BIT_STRING_SIZE_16 */
static int hf_lpp_po32_v1420;                     /* BIT_STRING_SIZE_32 */
static int hf_lpp_po64_v1420;                     /* BIT_STRING_SIZE_64 */
static int hf_lpp_po128_v1420;                    /* BIT_STRING_SIZE_128 */
static int hf_lpp_po256_v1420;                    /* BIT_STRING_SIZE_256 */
static int hf_lpp_po512_v1420;                    /* BIT_STRING_SIZE_512 */
static int hf_lpp_po1024_v1420;                   /* BIT_STRING_SIZE_1024 */
static int hf_lpp_prsID_r14;                      /* INTEGER_0_4095 */
static int hf_lpp_add_numDL_Frames_r14;           /* INTEGER_1_160 */
static int hf_lpp_prsOccGroupLen_r14;             /* T_prsOccGroupLen_r14 */
static int hf_lpp_prsHoppingInfo_r14;             /* T_prsHoppingInfo_r14 */
static int hf_lpp_nb2_r14;                        /* INTEGER_0_maxAvailNarrowBands_Minus1_r14 */
static int hf_lpp_nb4_r14;                        /* T_nb4_r14 */
static int hf_lpp_nb4_r14_item;                   /* INTEGER_0_maxAvailNarrowBands_Minus1_r14 */
static int hf_lpp_subframeAssignment_v1520;       /* T_subframeAssignment_v1520 */
static int hf_lpp_OTDOA_NeighbourCellInfoList_item;  /* OTDOA_NeighbourFreqInfo */
static int hf_lpp_OTDOA_NeighbourFreqInfo_item;   /* OTDOA_NeighbourCellInfoElement */
static int hf_lpp_earfcn;                         /* ARFCN_ValueEUTRA */
static int hf_lpp_cpLength_01;                    /* T_cpLength_01 */
static int hf_lpp_antennaPortConfig_01;           /* T_antennaPortConfig_01 */
static int hf_lpp_slotNumberOffset;               /* INTEGER_0_19 */
static int hf_lpp_prs_SubframeOffset;             /* INTEGER_0_1279 */
static int hf_lpp_expectedRSTD;                   /* INTEGER_0_16383 */
static int hf_lpp_expectedRSTD_Uncertainty;       /* INTEGER_0_1023 */
static int hf_lpp_earfcn_v9a0;                    /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_prs_only_tp_r14;                /* T_prs_only_tp_r14 */
static int hf_lpp_cpLengthCRS_r14_01;             /* T_cpLengthCRS_r14_01 */
static int hf_lpp_sameMBSFNconfigNeighbour_r14;   /* BOOLEAN */
static int hf_lpp_dlBandwidth_r14_01;             /* T_dlBandwidth_r14_01 */
static int hf_lpp_addPRSconfigNeighbour_r14;      /* SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_Add_PRSconfigNeighbourElement_r14 */
static int hf_lpp_addPRSconfigNeighbour_r14_item;  /* Add_PRSconfigNeighbourElement_r14 */
static int hf_lpp_add_prsInfo_r14;                /* PRS_Info */
static int hf_lpp_physCellIdNB_r14;               /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdNB_r14;             /* ECGI */
static int hf_lpp_carrierFreqRef_r14;             /* CarrierFreq_NB_r14 */
static int hf_lpp_earfcn_r14;                     /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_eutra_NumCRS_Ports_r14;         /* T_eutra_NumCRS_Ports_r14 */
static int hf_lpp_otdoa_SIB1_NB_repetitions_r14;  /* T_otdoa_SIB1_NB_repetitions_r14 */
static int hf_lpp_nprsInfo_r14;                   /* PRS_Info_NB_r14 */
static int hf_lpp_nprsInfo_Type2_v1470;           /* PRS_Info_NB_r14 */
static int hf_lpp_tdd_config_r15;                 /* TDD_Config_v1520 */
static int hf_lpp_PRS_Info_NB_r14_item;           /* NPRS_Info_r14 */
static int hf_lpp_operationModeInfoNPRS_r14;      /* T_operationModeInfoNPRS_r14 */
static int hf_lpp_nprs_carrier_r14;               /* CarrierFreq_NB_r14 */
static int hf_lpp_nprsSequenceInfo_r14;           /* INTEGER_0_174 */
static int hf_lpp_nprsID_r14;                     /* INTEGER_0_4095 */
static int hf_lpp_partA_r14;                      /* T_partA_r14 */
static int hf_lpp_nprsBitmap_r14;                 /* T_nprsBitmap_r14 */
static int hf_lpp_subframePattern10_r14;          /* BIT_STRING_SIZE_10 */
static int hf_lpp_subframePattern40_r14;          /* BIT_STRING_SIZE_40 */
static int hf_lpp_nprs_MutingInfoA_r14;           /* T_nprs_MutingInfoA_r14 */
static int hf_lpp_po2_r14;                        /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r14;                        /* BIT_STRING_SIZE_4 */
static int hf_lpp_po8_r14;                        /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r14;                       /* BIT_STRING_SIZE_16 */
static int hf_lpp_partB_r14;                      /* T_partB_r14 */
static int hf_lpp_nprs_Period_r14;                /* T_nprs_Period_r14 */
static int hf_lpp_nprs_startSF_r14;               /* T_nprs_startSF_r14 */
static int hf_lpp_nprs_NumSF_r14;                 /* T_nprs_NumSF_r14 */
static int hf_lpp_nprs_MutingInfoB_r14;           /* T_nprs_MutingInfoB_r14 */
static int hf_lpp_sib1_SF_TDD_r15;                /* T_sib1_SF_TDD_r15 */
static int hf_lpp_partA_TDD_r15;                  /* T_partA_TDD_r15 */
static int hf_lpp_nprsBitmap_r15;                 /* T_nprsBitmap_r15 */
static int hf_lpp_subframePattern10_TDD_r15;      /* BIT_STRING_SIZE_8 */
static int hf_lpp_subframePattern40_TDD_r15;      /* BIT_STRING_SIZE_32 */
static int hf_lpp_nprs_MutingInfoA_r15;           /* T_nprs_MutingInfoA_r15 */
static int hf_lpp_po2_r15;                        /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r15;                        /* BIT_STRING_SIZE_4 */
static int hf_lpp_po8_r15;                        /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r15;                       /* BIT_STRING_SIZE_16 */
static int hf_lpp_OTDOA_NeighbourCellInfoListNB_r14_item;  /* OTDOA_NeighbourCellInfoNB_r14 */
static int hf_lpp_carrierFreq_r14_01;             /* CarrierFreq_NB_r14 */
static int hf_lpp_eutra_NumCRS_Ports_r14_01;      /* T_eutra_NumCRS_Ports_r14_01 */
static int hf_lpp_otdoa_SIB1_NB_repetitions_r14_01;  /* T_otdoa_SIB1_NB_repetitions_r14_01 */
static int hf_lpp_nprs_slotNumberOffset_r14;      /* INTEGER_0_19 */
static int hf_lpp_nprs_SFN_Offset_r14;            /* INTEGER_0_63 */
static int hf_lpp_nprs_SubframeOffset_r14;        /* INTEGER_0_1279 */
static int hf_lpp_expectedRSTD_r14;               /* INTEGER_0_16383 */
static int hf_lpp_expectedRSTD_Uncertainty_r14;   /* INTEGER_0_1023 */
static int hf_lpp_prsNeighbourCellIndex_r14;      /* INTEGER_1_72 */
static int hf_lpp_adType_r14;                     /* T_adType_r14 */
static int hf_lpp_nrPhysCellId_r15;               /* INTEGER_0_1007 */
static int hf_lpp_otdoaSignalMeasurementInformation;  /* OTDOA_SignalMeasurementInformation */
static int hf_lpp_otdoaSignalMeasurementInformation_NB_r14;  /* OTDOA_SignalMeasurementInformation_NB_r14 */
static int hf_lpp_systemFrameNumber;              /* BIT_STRING_SIZE_10 */
static int hf_lpp_physCellIdRef;                  /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdRef;                /* ECGI */
static int hf_lpp_referenceQuality;               /* OTDOA_MeasQuality */
static int hf_lpp_neighbourMeasurementList;       /* NeighbourMeasurementList */
static int hf_lpp_tpIdRef_r14;                    /* INTEGER_0_4095 */
static int hf_lpp_prsIdRef_r14;                   /* INTEGER_0_4095 */
static int hf_lpp_additionalPathsRef_r14;         /* AdditionalPathList_r14 */
static int hf_lpp_nprsIdRef_r14;                  /* INTEGER_0_4095 */
static int hf_lpp_carrierFreqOffsetNB_Ref_r14;    /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_hyperSFN_r14;                   /* BIT_STRING_SIZE_10 */
static int hf_lpp_motionTimeSource_r15;           /* MotionTimeSource_r15 */
static int hf_lpp_NeighbourMeasurementList_item;  /* NeighbourMeasurementElement */
static int hf_lpp_physCellIdNeighbour;            /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdNeighbour;          /* ECGI */
static int hf_lpp_earfcnNeighbour;                /* ARFCN_ValueEUTRA */
static int hf_lpp_rstd;                           /* INTEGER_0_12711 */
static int hf_lpp_rstd_Quality;                   /* OTDOA_MeasQuality */
static int hf_lpp_earfcnNeighbour_v9a0;           /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_tpIdNeighbour_r14;              /* INTEGER_0_4095 */
static int hf_lpp_prsIdNeighbour_r14;             /* INTEGER_0_4095 */
static int hf_lpp_delta_rstd_r14;                 /* INTEGER_0_5 */
static int hf_lpp_additionalPathsNeighbour_r14;   /* AdditionalPathList_r14 */
static int hf_lpp_nprsIdNeighbour_r14;            /* INTEGER_0_4095 */
static int hf_lpp_carrierFreqOffsetNB_Neighbour_r14;  /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_delta_SFN_r15;                  /* INTEGER_M8192_8191 */
static int hf_lpp_AdditionalPathList_r14_item;    /* AdditionalPath_r14 */
static int hf_lpp_timeSource_r15;                 /* T_timeSource_r15 */
static int hf_lpp_systemFrameNumber_r14;          /* BIT_STRING_SIZE_10 */
static int hf_lpp_physCellIdRef_r14;              /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdRef_r14;            /* ECGI */
static int hf_lpp_earfcnRef_r14;                  /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_referenceQuality_r14;           /* OTDOA_MeasQuality */
static int hf_lpp_neighbourMeasurementList_r14;   /* NeighbourMeasurementList_NB_r14 */
static int hf_lpp_NeighbourMeasurementList_NB_r14_item;  /* NeighbourMeasurementElement_NB_r14 */
static int hf_lpp_physCellIdNeighbour_r14;        /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdNeighbour_r14;      /* ECGI */
static int hf_lpp_earfcnNeighbour_r14;            /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_rstd_r14;                       /* INTEGER_0_12711 */
static int hf_lpp_rstd_Quality_r14;               /* OTDOA_MeasQuality */
static int hf_lpp_error_Resolution;               /* T_error_Resolution */
static int hf_lpp_error_Value;                    /* T_error_Value */
static int hf_lpp_error_NumSamples;               /* T_error_NumSamples */
static int hf_lpp_relativeTimeDifference_r14;     /* INTEGER_M256_255 */
static int hf_lpp_path_Quality_r14;               /* OTDOA_MeasQuality */
static int hf_lpp_assistanceAvailability;         /* BOOLEAN */
static int hf_lpp_multipathRSTD_r14;              /* T_multipathRSTD_r14 */
static int hf_lpp_maxNoOfRSTDmeas_r14;            /* INTEGER_1_32 */
static int hf_lpp_motionMeasurements_r15;         /* T_motionMeasurements_r15 */
static int hf_lpp_otdoa_Mode;                     /* T_otdoa_Mode */
static int hf_lpp_supportedBandListEUTRA;         /* SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA */
static int hf_lpp_supportedBandListEUTRA_item;    /* SupportedBandEUTRA */
static int hf_lpp_supportedBandListEUTRA_v9a0;    /* SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0 */
static int hf_lpp_supportedBandListEUTRA_v9a0_item;  /* SupportedBandEUTRA_v9a0 */
static int hf_lpp_interFreqRSTDmeasurement_r10;   /* T_interFreqRSTDmeasurement_r10 */
static int hf_lpp_additionalNeighbourCellInfoList_r10;  /* T_additionalNeighbourCellInfoList_r10 */
static int hf_lpp_prs_id_r14;                     /* T_prs_id_r14 */
static int hf_lpp_tp_separation_via_muting_r14;   /* T_tp_separation_via_muting_r14 */
static int hf_lpp_additional_prs_config_r14;      /* T_additional_prs_config_r14 */
static int hf_lpp_prs_based_tbs_r14;              /* T_prs_based_tbs_r14 */
static int hf_lpp_additionalPathsReport_r14;      /* T_additionalPathsReport_r14 */
static int hf_lpp_densePrsConfig_r14;             /* T_densePrsConfig_r14 */
static int hf_lpp_maxSupportedPrsBandwidth_r14;   /* T_maxSupportedPrsBandwidth_r14 */
static int hf_lpp_prsOccGroup_r14;                /* T_prsOccGroup_r14 */
static int hf_lpp_prsFrequencyHopping_r14;        /* T_prsFrequencyHopping_r14 */
static int hf_lpp_maxSupportedPrsConfigs_r14;     /* T_maxSupportedPrsConfigs_r14 */
static int hf_lpp_periodicalReporting_r14;        /* T_periodicalReporting_r14 */
static int hf_lpp_multiPrbNprs_r14;               /* T_multiPrbNprs_r14 */
static int hf_lpp_idleStateForMeasurements_r14;   /* T_idleStateForMeasurements_r14 */
static int hf_lpp_numberOfRXantennas_r14;         /* T_numberOfRXantennas_r14 */
static int hf_lpp_motionMeasurements_r15_01;      /* T_motionMeasurements_r15_01 */
static int hf_lpp_interRAT_RSTDmeasurement_r15;   /* T_interRAT_RSTDmeasurement_r15 */
static int hf_lpp_scheduledLocationRequestSupported_r17;  /* ScheduledLocationTimeSupport_r17 */
static int hf_lpp_periodicReportingIntervalMsSupport_r18;  /* PeriodicReportingIntervalMsSupport_r18 */
static int hf_lpp_bandEUTRA;                      /* INTEGER_1_maxFBI */
static int hf_lpp_bandEUTRA_v9a0;                 /* INTEGER_maxFBI_Plus1_maxFBI2 */
static int hf_lpp_locationServerErrorCauses;      /* OTDOA_LocationServerErrorCauses */
static int hf_lpp_targetDeviceErrorCauses;        /* OTDOA_TargetDeviceErrorCauses */
static int hf_lpp_cause;                          /* T_cause */
static int hf_lpp_cause_01;                       /* T_cause_01 */
static int hf_lpp_gnss_CommonAssistData;          /* GNSS_CommonAssistData */
static int hf_lpp_gnss_GenericAssistData;         /* GNSS_GenericAssistData */
static int hf_lpp_gnss_Error;                     /* A_GNSS_Error */
static int hf_lpp_gnss_PeriodicAssistData_r15;    /* GNSS_PeriodicAssistData_r15 */
static int hf_lpp_gnss_ReferenceTime;             /* GNSS_ReferenceTime */
static int hf_lpp_gnss_ReferenceLocation;         /* GNSS_ReferenceLocation */
static int hf_lpp_gnss_IonosphericModel;          /* GNSS_IonosphericModel */
static int hf_lpp_gnss_EarthOrientationParameters;  /* GNSS_EarthOrientationParameters */
static int hf_lpp_gnss_RTK_ReferenceStationInfo_r15;  /* GNSS_RTK_ReferenceStationInfo_r15 */
static int hf_lpp_gnss_RTK_CommonObservationInfo_r15;  /* GNSS_RTK_CommonObservationInfo_r15 */
static int hf_lpp_gnss_RTK_AuxiliaryStationData_r15;  /* GNSS_RTK_AuxiliaryStationData_r15 */
static int hf_lpp_gnss_SSR_CorrectionPoints_r16;  /* GNSS_SSR_CorrectionPoints_r16 */
static int hf_lpp_gnss_Integrity_ServiceParameters_r17;  /* GNSS_Integrity_ServiceParameters_r17 */
static int hf_lpp_gnss_Integrity_ServiceAlert_r17;  /* GNSS_Integrity_ServiceAlert_r17 */
static int hf_lpp_gnss_los_nlos_GridPoints_r18;   /* GNSS_LOS_NLOS_GridPoints_r18 */
static int hf_lpp_gnss_SSR_IOD_Update_r18;        /* GNSS_SSR_IOD_Update_r18 */
static int hf_lpp_GNSS_GenericAssistData_item;    /* GNSS_GenericAssistDataElement */
static int hf_lpp_gnss_ID;                        /* GNSS_ID */
static int hf_lpp_sbas_ID;                        /* SBAS_ID */
static int hf_lpp_gnss_TimeModels;                /* GNSS_TimeModelList */
static int hf_lpp_gnss_DifferentialCorrections;   /* GNSS_DifferentialCorrections */
static int hf_lpp_gnss_NavigationModel;           /* GNSS_NavigationModel */
static int hf_lpp_gnss_RealTimeIntegrity;         /* GNSS_RealTimeIntegrity */
static int hf_lpp_gnss_DataBitAssistance;         /* GNSS_DataBitAssistance */
static int hf_lpp_gnss_AcquisitionAssistance;     /* GNSS_AcquisitionAssistance */
static int hf_lpp_gnss_Almanac;                   /* GNSS_Almanac */
static int hf_lpp_gnss_UTC_Model;                 /* GNSS_UTC_Model */
static int hf_lpp_gnss_AuxiliaryInformation;      /* GNSS_AuxiliaryInformation */
static int hf_lpp_bds_DifferentialCorrections_r12;  /* BDS_DifferentialCorrections_r12 */
static int hf_lpp_bds_GridModel_r12;              /* BDS_GridModelParameter_r12 */
static int hf_lpp_gnss_RTK_Observations_r15;      /* GNSS_RTK_Observations_r15 */
static int hf_lpp_glo_RTK_BiasInformation_r15;    /* GLO_RTK_BiasInformation_r15 */
static int hf_lpp_gnss_RTK_MAC_CorrectionDifferences_r15;  /* GNSS_RTK_MAC_CorrectionDifferences_r15 */
static int hf_lpp_gnss_RTK_Residuals_r15;         /* GNSS_RTK_Residuals_r15 */
static int hf_lpp_gnss_RTK_FKP_Gradients_r15;     /* GNSS_RTK_FKP_Gradients_r15 */
static int hf_lpp_gnss_SSR_OrbitCorrections_r15;  /* GNSS_SSR_OrbitCorrections_r15 */
static int hf_lpp_gnss_SSR_ClockCorrections_r15;  /* GNSS_SSR_ClockCorrections_r15 */
static int hf_lpp_gnss_SSR_CodeBias_r15;          /* GNSS_SSR_CodeBias_r15 */
static int hf_lpp_gnss_SSR_URA_r16;               /* GNSS_SSR_URA_r16 */
static int hf_lpp_gnss_SSR_PhaseBias_r16;         /* GNSS_SSR_PhaseBias_r16 */
static int hf_lpp_gnss_SSR_STEC_Correction_r16;   /* GNSS_SSR_STEC_Correction_r16 */
static int hf_lpp_gnss_SSR_GriddedCorrection_r16;  /* GNSS_SSR_GriddedCorrection_r16 */
static int hf_lpp_navic_DifferentialCorrections_r16;  /* NavIC_DifferentialCorrections_r16 */
static int hf_lpp_navic_GridModel_r16;            /* NavIC_GridModelParameter_r16 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsSet2_r17;  /* GNSS_SSR_OrbitCorrectionsSet2_r17 */
static int hf_lpp_gnss_SSR_ClockCorrectionsSet2_r17;  /* GNSS_SSR_ClockCorrectionsSet2_r17 */
static int hf_lpp_gnss_SSR_URA_Set2_r17;          /* GNSS_SSR_URA_Set2_r17 */
static int hf_lpp_gnss_LOS_NLOS_GriddedIndications_r18;  /* GNSS_LOS_NLOS_GriddedIndications_r18 */
static int hf_lpp_gnss_SSR_SatellitePCVResiduals_r18;  /* GNSS_SSR_SatellitePCVResiduals_r18 */
static int hf_lpp_gnss_RTK_PeriodicObservations_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_glo_RTK_PeriodicBiasInformation_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferences_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_PeriodicResiduals_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_FKP_PeriodicGradients_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicOrbitCorrections_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicClockCorrections_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicCodeBias_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicURA_r16;       /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicPhaseBias_r16;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicSTEC_Correction_r16;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicGriddedCorrection_r16;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_Integrity_PeriodicServiceAlert_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsSet2_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicClockCorrectionsSet2_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicURA_Set2_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicIOD_Update_r18;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SystemTime;                /* GNSS_SystemTime */
static int hf_lpp_referenceTimeUnc;               /* INTEGER_0_127 */
static int hf_lpp_gnss_ReferenceTimeForCells;     /* SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell */
static int hf_lpp_gnss_ReferenceTimeForCells_item;  /* GNSS_ReferenceTimeForOneCell */
static int hf_lpp_networkTime;                    /* NetworkTime */
static int hf_lpp_bsAlign;                        /* T_bsAlign */
static int hf_lpp_gnss_TimeID;                    /* GNSS_ID */
static int hf_lpp_gnss_DayNumber;                 /* INTEGER_0_32767 */
static int hf_lpp_gnss_TimeOfDay;                 /* INTEGER_0_86399 */
static int hf_lpp_gnss_TimeOfDayFrac_msec;        /* INTEGER_0_999 */
static int hf_lpp_notificationOfLeapSecond;       /* T_notificationOfLeapSecond */
static int hf_lpp_gps_TOW_Assist;                 /* GPS_TOW_Assist */
static int hf_lpp_GPS_TOW_Assist_item;            /* GPS_TOW_AssistElement */
static int hf_lpp_satelliteID;                    /* INTEGER_1_64 */
static int hf_lpp_tlmWord;                        /* INTEGER_0_16383 */
static int hf_lpp_antiSpoof;                      /* INTEGER_0_1 */
static int hf_lpp_alert;                          /* INTEGER_0_1 */
static int hf_lpp_tlmRsvdBits;                    /* INTEGER_0_3 */
static int hf_lpp_secondsFromFrameStructureStart;  /* INTEGER_0_12533 */
static int hf_lpp_fractionalSecondsFromFrameStructureStart;  /* INTEGER_0_3999999 */
static int hf_lpp_frameDrift;                     /* INTEGER_M64_63 */
static int hf_lpp_cellID;                         /* T_cellID */
static int hf_lpp_eUTRA;                          /* T_eUTRA */
static int hf_lpp_cellGlobalIdEUTRA;              /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_uTRA;                           /* T_uTRA */
static int hf_lpp_mode;                           /* T_mode */
static int hf_lpp_fdd;                            /* T_fdd */
static int hf_lpp_primary_CPICH_Info;             /* INTEGER_0_511 */
static int hf_lpp_tdd;                            /* T_tdd */
static int hf_lpp_cellParameters;                 /* INTEGER_0_127 */
static int hf_lpp_cellGlobalIdUTRA;               /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_uarfcn;                         /* ARFCN_ValueUTRA */
static int hf_lpp_gSM;                            /* T_gSM */
static int hf_lpp_bcchCarrier;                    /* INTEGER_0_1023 */
static int hf_lpp_bsic;                           /* INTEGER_0_63 */
static int hf_lpp_cellGlobalIdGERAN;              /* CellGlobalIdGERAN */
static int hf_lpp_nBIoT_r14;                      /* T_nBIoT_r14 */
static int hf_lpp_nbPhysCellId_r14;               /* INTEGER_0_503 */
static int hf_lpp_nbCellGlobalId_r14;             /* ECGI */
static int hf_lpp_nbCarrierFreq_r14;              /* CarrierFreq_NB_r14 */
static int hf_lpp_nr_r15;                         /* T_nr_r15 */
static int hf_lpp_nrCellGlobalID_r15;             /* NCGI_r15 */
static int hf_lpp_nrARFCN_r15;                    /* ARFCN_ValueNR_r15 */
static int hf_lpp_threeDlocation;                 /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_klobucharModel;                 /* KlobucharModelParameter */
static int hf_lpp_neQuickModel;                   /* NeQuickModelParameter */
static int hf_lpp_klobucharModel2_r16;            /* KlobucharModel2Parameter_r16 */
static int hf_lpp_dataID;                         /* T_dataID */
static int hf_lpp_alfa0;                          /* INTEGER_M128_127 */
static int hf_lpp_alfa1;                          /* INTEGER_M128_127 */
static int hf_lpp_alfa2;                          /* INTEGER_M128_127 */
static int hf_lpp_alfa3;                          /* INTEGER_M128_127 */
static int hf_lpp_beta0;                          /* INTEGER_M128_127 */
static int hf_lpp_beta1;                          /* INTEGER_M128_127 */
static int hf_lpp_beta2;                          /* INTEGER_M128_127 */
static int hf_lpp_beta3;                          /* INTEGER_M128_127 */
static int hf_lpp_alfa1_r16;                      /* INTEGER_0_1023 */
static int hf_lpp_alfa2_r16;                      /* INTEGER_M128_127 */
static int hf_lpp_alfa3_r16;                      /* INTEGER_0_255 */
static int hf_lpp_alfa4_r16;                      /* INTEGER_0_255 */
static int hf_lpp_alfa5_r16;                      /* INTEGER_0_255 */
static int hf_lpp_alfa6_r16;                      /* INTEGER_M128_127 */
static int hf_lpp_alfa7_r16;                      /* INTEGER_M128_127 */
static int hf_lpp_alfa8_r16;                      /* INTEGER_M128_127 */
static int hf_lpp_alfa9_r16;                      /* INTEGER_M128_127 */
static int hf_lpp_ai0;                            /* INTEGER_0_2047 */
static int hf_lpp_ai1;                            /* INTEGER_M1024_1023 */
static int hf_lpp_ai2;                            /* INTEGER_M8192_8191 */
static int hf_lpp_ionoStormFlag1;                 /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag2;                 /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag3;                 /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag4;                 /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag5;                 /* INTEGER_0_1 */
static int hf_lpp_teop;                           /* INTEGER_0_65535 */
static int hf_lpp_pmX;                            /* INTEGER_M1048576_1048575 */
static int hf_lpp_pmXdot;                         /* INTEGER_M16384_16383 */
static int hf_lpp_pmY;                            /* INTEGER_M1048576_1048575 */
static int hf_lpp_pmYdot;                         /* INTEGER_M16384_16383 */
static int hf_lpp_deltaUT1;                       /* INTEGER_M1073741824_1073741823 */
static int hf_lpp_deltaUT1dot;                    /* INTEGER_M262144_262143 */
static int hf_lpp_referenceStationID_r15;         /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_referenceStationIndicator_r15;  /* T_referenceStationIndicator_r15 */
static int hf_lpp_antenna_reference_point_ECEF_X_r15;  /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_antenna_reference_point_ECEF_Y_r15;  /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_antenna_reference_point_ECEF_Z_r15;  /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_antennaHeight_r15;              /* INTEGER_0_65535 */
static int hf_lpp_antennaDescription_r15;         /* AntennaDescription_r15 */
static int hf_lpp_antenna_reference_point_unc_r15;  /* AntennaReferencePointUnc_r15 */
static int hf_lpp_physical_reference_station_info_r15;  /* PhysicalReferenceStationInfo_r15 */
static int hf_lpp_equalIntegerAmbiguityLevel_r16;  /* EqualIntegerAmbiguityLevel_r16 */
static int hf_lpp_antennaDescriptor_r15;          /* VisibleString_SIZE_1_256 */
static int hf_lpp_antennaSetUpID_r15;             /* T_antennaSetUpID_r15 */
static int hf_lpp_uncertainty_X_r15;              /* INTEGER_0_255 */
static int hf_lpp_confidence_X_r15;               /* INTEGER_0_100 */
static int hf_lpp_uncertainty_Y_r15;              /* INTEGER_0_255 */
static int hf_lpp_confidence_Y_r15;               /* INTEGER_0_100 */
static int hf_lpp_uncertainty_Z_r15;              /* INTEGER_0_255 */
static int hf_lpp_confidence_Z_r15;               /* INTEGER_0_100 */
static int hf_lpp_physicalReferenceStationID_r15;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_physical_ARP_ECEF_X_r15;        /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_physical_ARP_ECEF_Y_r15;        /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_physical_ARP_ECEF_Z_r15;        /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_physical_ARP_unc_r15;           /* AntennaReferencePointUnc_r15 */
static int hf_lpp_allReferenceStations_r16;       /* NULL */
static int hf_lpp_referenceStationList_r16;       /* ReferenceStationList_r16 */
static int hf_lpp_ReferenceStationList_r16_item;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_clockSteeringIndicator_r15;     /* INTEGER_0_3 */
static int hf_lpp_externalClockIndicator_r15;     /* INTEGER_0_3 */
static int hf_lpp_smoothingIndicator_r15;         /* T_smoothingIndicator_r15 */
static int hf_lpp_smoothingInterval_r15;          /* T_smoothingInterval_r15 */
static int hf_lpp_networkID_r15;                  /* GNSS_NetworkID_r15 */
static int hf_lpp_subNetworkID_r15;               /* GNSS_SubNetworkID_r15 */
static int hf_lpp_master_referenceStationID_r15;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_auxiliaryStationList_r15;       /* AuxiliaryStationList_r15 */
static int hf_lpp_AuxiliaryStationList_r15_item;  /* AuxiliaryStationElement_r15 */
static int hf_lpp_aux_referenceStationID_r15;     /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_aux_master_delta_latitude_r15;  /* INTEGER_M524288_524287 */
static int hf_lpp_aux_master_delta_longitude_r15;  /* INTEGER_M1048576_1048575 */
static int hf_lpp_aux_master_delta_height_r15;    /* INTEGER_M4194304_4194303 */
static int hf_lpp_aux_ARP_unc_r15;                /* Aux_ARP_Unc_r15 */
static int hf_lpp_horizontalUncertainty_r15;      /* INTEGER_0_255 */
static int hf_lpp_verticalUncertainty_r15;        /* INTEGER_0_255 */
static int hf_lpp_correctionPointSetID_r16;       /* INTEGER_0_16383 */
static int hf_lpp_correctionPoints_r16;           /* T_correctionPoints_r16 */
static int hf_lpp_listOfCorrectionPoints_r16;     /* GNSS_SSR_ListOfCorrectionPoints_r16 */
static int hf_lpp_arrayOfCorrectionPoints_r16;    /* GNSS_SSR_ArrayOfCorrectionPoints_r16 */
static int hf_lpp_referencePointLatitude_r16;     /* INTEGER_M16384_16383 */
static int hf_lpp_referencePointLongitude_r16;    /* INTEGER_M32768_32767 */
static int hf_lpp_relativeLocationsList_r16;      /* SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16 */
static int hf_lpp_relativeLocationsList_r16_item;  /* RelativeLocationElement_r16 */
static int hf_lpp_deltaLatitude_r16;              /* INTEGER_M512_511 */
static int hf_lpp_deltaLongitude_r16;             /* INTEGER_M1024_1023 */
static int hf_lpp_numberOfStepsLatitude_r16;      /* INTEGER_0_63 */
static int hf_lpp_numberOfStepsLongitude_r16;     /* INTEGER_0_63 */
static int hf_lpp_stepOfLatitude_r16;             /* INTEGER_1_511 */
static int hf_lpp_stepOfLongitude_r16;            /* INTEGER_1_1023 */
static int hf_lpp_bitmaskOfGrids_r16;             /* BIT_STRING_SIZE_64 */
static int hf_lpp_irMinimum_r17;                  /* INTEGER_0_255 */
static int hf_lpp_irMaximum_r17;                  /* INTEGER_0_255 */
static int hf_lpp_ionosphereDoNotUse_r17;         /* BOOLEAN */
static int hf_lpp_troposphereDoNotUse_r17;        /* BOOLEAN */
static int hf_lpp_gridPointsSetID_r18;            /* INTEGER_0_16383 */
static int hf_lpp_horizontalGridPoints_r18;       /* ArrayOfGridPoints_r18 */
static int hf_lpp_referenceAltitudeFine_r18;      /* INTEGER_0_9 */
static int hf_lpp_verticalGridPoints_r18;         /* VerticalGridPoints_r18 */
static int hf_lpp_referencePointLatitude_r18;     /* INTEGER_M16777216_16777215 */
static int hf_lpp_referencePointLongitude_r18;    /* INTEGER_M33554432_33554431 */
static int hf_lpp_numberOfStepsSouth_r18;         /* INTEGER_0_255 */
static int hf_lpp_numberOfStepsEast_r18;          /* INTEGER_0_255 */
static int hf_lpp_stepSouth_r18;                  /* SpatialDelta_r18 */
static int hf_lpp_stepEast_r18;                   /* SpatialDelta_r18 */
static int hf_lpp_bitmaskOfGrids_r18;             /* T_bitmaskOfGrids_r18 */
static int hf_lpp_bog16_r18;                      /* BIT_STRING_SIZE_16 */
static int hf_lpp_bog64_r18;                      /* BIT_STRING_SIZE_64 */
static int hf_lpp_bog256_r18;                     /* BIT_STRING_SIZE_256 */
static int hf_lpp_referenceAltitudeCoarse_r18;    /* INTEGER_M50_900 */
static int hf_lpp_numberOfStepsDown_r18;          /* INTEGER_1_3 */
static int hf_lpp_stepDown_r18;                   /* SpatialDelta_r18 */
static int hf_lpp_upperValidityDeltaAltitude_r18;  /* SpatialDelta_r18 */
static int hf_lpp_lowerValidityDeltaAltitude_r18;  /* SpatialDelta_r18 */
static int hf_lpp_epochTime_r18;                  /* GNSS_SystemTime */
static int hf_lpp_ssrUpdateInterval_r18;          /* INTEGER_0_15 */
static int hf_lpp_iod_ssr_r18;                    /* INTEGER_0_15 */
static int hf_lpp_iod_ssr_PCVResiduals_r18;       /* INTEGER_0_64 */
static int hf_lpp_GNSS_TimeModelList_item;        /* GNSS_TimeModelElement */
static int hf_lpp_gnss_TimeModelRefTime;          /* INTEGER_0_65535 */
static int hf_lpp_tA0;                            /* INTEGER_M67108864_67108863 */
static int hf_lpp_tA1;                            /* INTEGER_M4096_4095 */
static int hf_lpp_tA2;                            /* INTEGER_M64_63 */
static int hf_lpp_gnss_TO_ID;                     /* INTEGER_1_15 */
static int hf_lpp_weekNumber;                     /* INTEGER_0_8191 */
static int hf_lpp_deltaT;                         /* INTEGER_M128_127 */
static int hf_lpp_dgnss_RefTime;                  /* INTEGER_0_3599 */
static int hf_lpp_dgnss_SgnTypeList;              /* DGNSS_SgnTypeList */
static int hf_lpp_DGNSS_SgnTypeList_item;         /* DGNSS_SgnTypeElement */
static int hf_lpp_gnss_SignalID;                  /* GNSS_SignalID */
static int hf_lpp_gnss_StatusHealth;              /* INTEGER_0_7 */
static int hf_lpp_dgnss_SatList;                  /* DGNSS_SatList */
static int hf_lpp_DGNSS_SatList_item;             /* DGNSS_CorrectionsElement */
static int hf_lpp_svID;                           /* SV_ID */
static int hf_lpp_iod;                            /* BIT_STRING_SIZE_11 */
static int hf_lpp_udre;                           /* INTEGER_0_3 */
static int hf_lpp_pseudoRangeCor;                 /* INTEGER_M2047_2047 */
static int hf_lpp_rangeRateCor;                   /* INTEGER_M127_127 */
static int hf_lpp_udreGrowthRate;                 /* INTEGER_0_7 */
static int hf_lpp_udreValidityTime;               /* INTEGER_0_7 */
static int hf_lpp_nonBroadcastIndFlag;            /* INTEGER_0_1 */
static int hf_lpp_gnss_SatelliteList;             /* GNSS_NavModelSatelliteList */
static int hf_lpp_GNSS_NavModelSatelliteList_item;  /* GNSS_NavModelSatelliteElement */
static int hf_lpp_svHealth;                       /* BIT_STRING_SIZE_8 */
static int hf_lpp_gnss_ClockModel;                /* GNSS_ClockModel */
static int hf_lpp_gnss_OrbitModel;                /* GNSS_OrbitModel */
static int hf_lpp_svHealthExt_v1240;              /* T_svHealthExt_v1240 */
static int hf_lpp_standardClockModelList;         /* StandardClockModelList */
static int hf_lpp_nav_ClockModel;                 /* NAV_ClockModel */
static int hf_lpp_cnav_ClockModel;                /* CNAV_ClockModel */
static int hf_lpp_glonass_ClockModel;             /* GLONASS_ClockModel */
static int hf_lpp_sbas_ClockModel;                /* SBAS_ClockModel */
static int hf_lpp_bds_ClockModel_r12;             /* BDS_ClockModel_r12 */
static int hf_lpp_bds_ClockModel2_r16;            /* BDS_ClockModel2_r16 */
static int hf_lpp_navic_ClockModel_r16;           /* NavIC_ClockModel_r16 */
static int hf_lpp_keplerianSet;                   /* NavModelKeplerianSet */
static int hf_lpp_nav_KeplerianSet;               /* NavModelNAV_KeplerianSet */
static int hf_lpp_cnav_KeplerianSet;              /* NavModelCNAV_KeplerianSet */
static int hf_lpp_glonass_ECEF;                   /* NavModel_GLONASS_ECEF */
static int hf_lpp_sbas_ECEF;                      /* NavModel_SBAS_ECEF */
static int hf_lpp_bds_KeplerianSet_r12;           /* NavModel_BDS_KeplerianSet_r12 */
static int hf_lpp_bds_KeplerianSet2_r16;          /* NavModel_BDS_KeplerianSet2_r16 */
static int hf_lpp_navic_KeplerianSet_r16;         /* NavModel_NavIC_KeplerianSet_r16 */
static int hf_lpp_StandardClockModelList_item;    /* StandardClockModelElement */
static int hf_lpp_stanClockToc;                   /* INTEGER_0_16383 */
static int hf_lpp_stanClockAF2;                   /* INTEGER_M32_31 */
static int hf_lpp_stanClockAF1;                   /* INTEGER_M1048576_1048575 */
static int hf_lpp_stanClockAF0;                   /* INTEGER_M1073741824_1073741823 */
static int hf_lpp_stanClockTgd;                   /* INTEGER_M512_511 */
static int hf_lpp_sisa;                           /* INTEGER_0_255 */
static int hf_lpp_stanModelID;                    /* INTEGER_0_1 */
static int hf_lpp_navToc;                         /* INTEGER_0_37799 */
static int hf_lpp_navaf2;                         /* INTEGER_M128_127 */
static int hf_lpp_navaf1;                         /* INTEGER_M32768_32767 */
static int hf_lpp_navaf0;                         /* INTEGER_M2097152_2097151 */
static int hf_lpp_navTgd;                         /* INTEGER_M128_127 */
static int hf_lpp_cnavToc;                        /* INTEGER_0_2015 */
static int hf_lpp_cnavTop;                        /* INTEGER_0_2015 */
static int hf_lpp_cnavURA0;                       /* INTEGER_M16_15 */
static int hf_lpp_cnavURA1;                       /* INTEGER_0_7 */
static int hf_lpp_cnavURA2;                       /* INTEGER_0_7 */
static int hf_lpp_cnavAf2;                        /* INTEGER_M512_511 */
static int hf_lpp_cnavAf1;                        /* INTEGER_M524288_524287 */
static int hf_lpp_cnavAf0;                        /* INTEGER_M33554432_33554431 */
static int hf_lpp_cnavTgd;                        /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl1cp;                    /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl1cd;                    /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl1ca;                    /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl2c;                     /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl5i5;                    /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl5q5;                    /* INTEGER_M4096_4095 */
static int hf_lpp_gloTau;                         /* INTEGER_M2097152_2097151 */
static int hf_lpp_gloGamma;                       /* INTEGER_M1024_1023 */
static int hf_lpp_gloDeltaTau;                    /* INTEGER_M16_15 */
static int hf_lpp_sbasTo;                         /* INTEGER_0_5399 */
static int hf_lpp_sbasAgfo;                       /* INTEGER_M2048_2047 */
static int hf_lpp_sbasAgf1;                       /* INTEGER_M128_127 */
static int hf_lpp_bdsAODC_r12;                    /* INTEGER_0_31 */
static int hf_lpp_bdsToc_r12;                     /* INTEGER_0_131071 */
static int hf_lpp_bdsA0_r12;                      /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsA1_r12;                      /* INTEGER_M2097152_2097151 */
static int hf_lpp_bdsA2_r12;                      /* INTEGER_M1024_1023 */
static int hf_lpp_bdsTgd1_r12;                    /* INTEGER_M512_511 */
static int hf_lpp_bdsTgd2_r16;                    /* INTEGER_M512_511 */
static int hf_lpp_bdsToc_r16;                     /* INTEGER_0_2047 */
static int hf_lpp_bdsA0_r16;                      /* INTEGER_M16777216_16777215 */
static int hf_lpp_bdsA1_r16;                      /* INTEGER_M2097152_2097151 */
static int hf_lpp_bdsA2_r16;                      /* INTEGER_M1024_1023 */
static int hf_lpp_bdsTgdB1Cp_r16;                 /* INTEGER_M2048_2047 */
static int hf_lpp_bdsIscB1Cd_r16;                 /* INTEGER_M2048_2047 */
static int hf_lpp_bdsTgdB2ap_r17;                 /* INTEGER_M2048_2047 */
static int hf_lpp_bdsIscB2ad_r17;                 /* INTEGER_M2048_2047 */
static int hf_lpp_navic_Toc_r16;                  /* INTEGER_0_65535 */
static int hf_lpp_navic_af2_r16;                  /* INTEGER_M128_127 */
static int hf_lpp_navic_af1_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_navic_af0_r16;                  /* INTEGER_M2097152_2097151 */
static int hf_lpp_navic_Tgd_r16;                  /* INTEGER_M128_127 */
static int hf_lpp_keplerToe;                      /* INTEGER_0_16383 */
static int hf_lpp_keplerW;                        /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerDeltaN;                   /* INTEGER_M32768_32767 */
static int hf_lpp_keplerM0;                       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerOmegaDot;                 /* INTEGER_M8388608_8388607 */
static int hf_lpp_keplerE;                        /* INTEGER_0_4294967295 */
static int hf_lpp_keplerIDot;                     /* INTEGER_M8192_8191 */
static int hf_lpp_keplerAPowerHalf;               /* INTEGER_0_4294967295 */
static int hf_lpp_keplerI0;                       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerOmega0;                   /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerCrs;                      /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCis;                      /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCus;                      /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCrc;                      /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCic;                      /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCuc;                      /* INTEGER_M32768_32767 */
static int hf_lpp_navURA;                         /* INTEGER_0_15 */
static int hf_lpp_navFitFlag;                     /* INTEGER_0_1 */
static int hf_lpp_navToe;                         /* INTEGER_0_37799 */
static int hf_lpp_navOmega;                       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navDeltaN;                      /* INTEGER_M32768_32767 */
static int hf_lpp_navM0;                          /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navOmegaADot;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_navE;                           /* INTEGER_0_4294967295 */
static int hf_lpp_navIDot;                        /* INTEGER_M8192_8191 */
static int hf_lpp_navAPowerHalf;                  /* INTEGER_0_4294967295 */
static int hf_lpp_navI0;                          /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navOmegaA0;                     /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navCrs;                         /* INTEGER_M32768_32767 */
static int hf_lpp_navCis;                         /* INTEGER_M32768_32767 */
static int hf_lpp_navCus;                         /* INTEGER_M32768_32767 */
static int hf_lpp_navCrc;                         /* INTEGER_M32768_32767 */
static int hf_lpp_navCic;                         /* INTEGER_M32768_32767 */
static int hf_lpp_navCuc;                         /* INTEGER_M32768_32767 */
static int hf_lpp_addNAVparam;                    /* T_addNAVparam */
static int hf_lpp_ephemCodeOnL2;                  /* INTEGER_0_3 */
static int hf_lpp_ephemL2Pflag;                   /* INTEGER_0_1 */
static int hf_lpp_ephemSF1Rsvd;                   /* T_ephemSF1Rsvd */
static int hf_lpp_reserved1;                      /* INTEGER_0_8388607 */
static int hf_lpp_reserved2;                      /* INTEGER_0_16777215 */
static int hf_lpp_reserved3;                      /* INTEGER_0_16777215 */
static int hf_lpp_reserved4;                      /* INTEGER_0_65535 */
static int hf_lpp_ephemAODA;                      /* INTEGER_0_31 */
static int hf_lpp_cnavURAindex;                   /* INTEGER_M16_15 */
static int hf_lpp_cnavDeltaA;                     /* INTEGER_M33554432_33554431 */
static int hf_lpp_cnavAdot;                       /* INTEGER_M16777216_16777215 */
static int hf_lpp_cnavDeltaNo;                    /* INTEGER_M65536_65535 */
static int hf_lpp_cnavDeltaNoDot;                 /* INTEGER_M4194304_4194303 */
static int hf_lpp_cnavMo;                         /* T_cnavMo */
static int hf_lpp_cnavE;                          /* T_cnavE */
static int hf_lpp_cnavOmega;                      /* T_cnavOmega */
static int hf_lpp_cnavOMEGA0;                     /* T_cnavOMEGA0 */
static int hf_lpp_cnavDeltaOmegaDot;              /* INTEGER_M65536_65535 */
static int hf_lpp_cnavIo;                         /* T_cnavIo */
static int hf_lpp_cnavIoDot;                      /* INTEGER_M16384_16383 */
static int hf_lpp_cnavCis;                        /* INTEGER_M32768_32767 */
static int hf_lpp_cnavCic;                        /* INTEGER_M32768_32767 */
static int hf_lpp_cnavCrs;                        /* INTEGER_M8388608_8388607 */
static int hf_lpp_cnavCrc;                        /* INTEGER_M8388608_8388607 */
static int hf_lpp_cnavCus;                        /* INTEGER_M1048576_1048575 */
static int hf_lpp_cnavCuc;                        /* INTEGER_M1048576_1048575 */
static int hf_lpp_gloEn;                          /* INTEGER_0_31 */
static int hf_lpp_gloP1;                          /* T_gloP1 */
static int hf_lpp_gloP2;                          /* BOOLEAN */
static int hf_lpp_gloM;                           /* INTEGER_0_3 */
static int hf_lpp_gloX;                           /* INTEGER_M67108864_67108863 */
static int hf_lpp_gloXdot;                        /* INTEGER_M8388608_8388607 */
static int hf_lpp_gloXdotdot;                     /* INTEGER_M16_15 */
static int hf_lpp_gloY;                           /* INTEGER_M67108864_67108863 */
static int hf_lpp_gloYdot;                        /* INTEGER_M8388608_8388607 */
static int hf_lpp_gloYdotdot;                     /* INTEGER_M16_15 */
static int hf_lpp_gloZ;                           /* INTEGER_M67108864_67108863 */
static int hf_lpp_gloZdot;                        /* INTEGER_M8388608_8388607 */
static int hf_lpp_gloZdotdot;                     /* INTEGER_M16_15 */
static int hf_lpp_sbasAccuracy;                   /* BIT_STRING_SIZE_4 */
static int hf_lpp_sbasXg;                         /* INTEGER_M536870912_536870911 */
static int hf_lpp_sbasYg;                         /* INTEGER_M536870912_536870911 */
static int hf_lpp_sbasZg;                         /* INTEGER_M16777216_16777215 */
static int hf_lpp_sbasXgDot;                      /* INTEGER_M65536_65535 */
static int hf_lpp_sbasYgDot;                      /* INTEGER_M65536_65535 */
static int hf_lpp_sbasZgDot;                      /* INTEGER_M131072_131071 */
static int hf_lpp_sbasXgDotDot;                   /* INTEGER_M512_511 */
static int hf_lpp_sbagYgDotDot;                   /* INTEGER_M512_511 */
static int hf_lpp_sbasZgDotDot;                   /* INTEGER_M512_511 */
static int hf_lpp_bdsAODE_r12;                    /* INTEGER_0_31 */
static int hf_lpp_bdsURAI_r12;                    /* INTEGER_0_15 */
static int hf_lpp_bdsToe_r12;                     /* INTEGER_0_131071 */
static int hf_lpp_bdsAPowerHalf_r12;              /* INTEGER_0_4294967295 */
static int hf_lpp_bdsE_r12;                       /* INTEGER_0_4294967295 */
static int hf_lpp_bdsW_r12;                       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsDeltaN_r12;                  /* INTEGER_M32768_32767 */
static int hf_lpp_bdsM0_r12;                      /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsOmega0_r12;                  /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsOmegaDot_r12;                /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsI0_r12;                      /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsIDot_r12;                    /* INTEGER_M8192_8191 */
static int hf_lpp_bdsCuc_r12;                     /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCus_r12;                     /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCrc_r12;                     /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCrs_r12;                     /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCic_r12;                     /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCis_r12;                     /* INTEGER_M131072_131071 */
static int hf_lpp_bdsIODE_r16;                    /* INTEGER_0_255 */
static int hf_lpp_bdsToe_r16;                     /* INTEGER_0_2047 */
static int hf_lpp_bdsDeltaA_r16;                  /* INTEGER_M33554432_33554431 */
static int hf_lpp_bdsAdot_r16;                    /* INTEGER_M16777216_16777216 */
static int hf_lpp_bdsDeltaN0_r16;                 /* INTEGER_M65536_65535 */
static int hf_lpp_bdsDeltaN0dot_r16;              /* INTEGER_M4194304_4194303 */
static int hf_lpp_bdsM0_r16;                      /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsE_r16;                       /* INTEGER_0_8589934591 */
static int hf_lpp_bdsOmega_r16;                   /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsOmega0_r16;                  /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsI0_r16;                      /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsOmegaDot_r16;                /* INTEGER_M262144_262143 */
static int hf_lpp_bdsI0Dot_r16;                   /* INTEGER_M16384_16383 */
static int hf_lpp_bdsCuc_r16;                     /* INTEGER_M1048576_1048575 */
static int hf_lpp_bdsCus_r16;                     /* INTEGER_M1048576_1048575 */
static int hf_lpp_bdsCrc_r16;                     /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsCrs_r16;                     /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsCic_r16;                     /* INTEGER_M32768_32767 */
static int hf_lpp_bdsCis_r16;                     /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Toe_r16;                  /* INTEGER_0_65536 */
static int hf_lpp_navic_URAI_r16;                 /* INTEGER_0_15 */
static int hf_lpp_navic_W_r16;                    /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_DeltaN_r16;               /* INTEGER_M2097152_2097151 */
static int hf_lpp_navic_M0_r16;                   /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_OmegaDot_r16;             /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_E_r16;                    /* INTEGER_0_4294967295 */
static int hf_lpp_navic_IDot_r16;                 /* INTEGER_M8192_8191 */
static int hf_lpp_navic_APowerHalf_r16;           /* INTEGER_0_4294967295 */
static int hf_lpp_navic_I0_r16;                   /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_Omega0_r16;               /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_Crs_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cis_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cus_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Crc_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cic_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cuc_r16;                  /* INTEGER_M32768_32767 */
static int hf_lpp_gnss_BadSignalList;             /* GNSS_BadSignalList */
static int hf_lpp_GNSS_BadSignalList_item;        /* BadSignalElement */
static int hf_lpp_badSVID;                        /* SV_ID */
static int hf_lpp_badSignalID;                    /* GNSS_SignalIDs */
static int hf_lpp_gnss_TOD;                       /* INTEGER_0_3599 */
static int hf_lpp_gnss_TODfrac;                   /* INTEGER_0_999 */
static int hf_lpp_gnss_DataBitsSatList;           /* GNSS_DataBitsSatList */
static int hf_lpp_GNSS_DataBitsSatList_item;      /* GNSS_DataBitsSatElement */
static int hf_lpp_gnss_DataBitsSgnList;           /* GNSS_DataBitsSgnList */
static int hf_lpp_GNSS_DataBitsSgnList_item;      /* GNSS_DataBitsSgnElement */
static int hf_lpp_gnss_SignalType;                /* GNSS_SignalID */
static int hf_lpp_gnss_DataBits;                  /* BIT_STRING_SIZE_1_1024 */
static int hf_lpp_gnss_AcquisitionAssistList;     /* GNSS_AcquisitionAssistList */
static int hf_lpp_confidence_r10;                 /* INTEGER_0_100 */
static int hf_lpp_GNSS_AcquisitionAssistList_item;  /* GNSS_AcquisitionAssistElement */
static int hf_lpp_doppler0;                       /* INTEGER_M2048_2047 */
static int hf_lpp_doppler1;                       /* INTEGER_0_63 */
static int hf_lpp_dopplerUncertainty;             /* INTEGER_0_4 */
static int hf_lpp_codePhase;                      /* INTEGER_0_1022 */
static int hf_lpp_intCodePhase;                   /* INTEGER_0_127 */
static int hf_lpp_codePhaseSearchWindow;          /* INTEGER_0_31 */
static int hf_lpp_azimuth;                        /* INTEGER_0_511 */
static int hf_lpp_elevation;                      /* INTEGER_0_127 */
static int hf_lpp_codePhase1023;                  /* BOOLEAN */
static int hf_lpp_dopplerUncertaintyExt_r10;      /* T_dopplerUncertaintyExt_r10 */
static int hf_lpp_weekNumber_01;                  /* INTEGER_0_255 */
static int hf_lpp_toa;                            /* T_toa */
static int hf_lpp_ioda;                           /* INTEGER_0_3 */
static int hf_lpp_completeAlmanacProvided;        /* BOOLEAN */
static int hf_lpp_gnss_AlmanacList;               /* GNSS_AlmanacList */
static int hf_lpp_toa_ext_v1240;                  /* T_toa_ext_v1240 */
static int hf_lpp_ioda_ext_v1240;                 /* INTEGER_4_15 */
static int hf_lpp_weekNumber_ext_r16;             /* INTEGER_256_8191 */
static int hf_lpp_toa_ext2_r16;                   /* INTEGER_256_65535 */
static int hf_lpp_GNSS_AlmanacList_item;          /* GNSS_AlmanacElement */
static int hf_lpp_keplerianAlmanacSet;            /* AlmanacKeplerianSet */
static int hf_lpp_keplerianNAV_Almanac;           /* AlmanacNAV_KeplerianSet */
static int hf_lpp_keplerianReducedAlmanac;        /* AlmanacReducedKeplerianSet */
static int hf_lpp_keplerianMidiAlmanac;           /* AlmanacMidiAlmanacSet */
static int hf_lpp_keplerianGLONASS;               /* AlmanacGLONASS_AlmanacSet */
static int hf_lpp_ecef_SBAS_Almanac;              /* AlmanacECEF_SBAS_AlmanacSet */
static int hf_lpp_keplerianBDS_Almanac_r12;       /* AlmanacBDS_AlmanacSet_r12 */
static int hf_lpp_keplerianNavIC_Almanac_r16;     /* AlmanacNavIC_AlmanacSet_r16 */
static int hf_lpp_kepAlmanacE;                    /* INTEGER_0_2047 */
static int hf_lpp_kepAlmanacDeltaI;               /* INTEGER_M1024_1023 */
static int hf_lpp_kepAlmanacOmegaDot;             /* INTEGER_M1024_1023 */
static int hf_lpp_kepSV_StatusINAV;               /* T_kepSV_StatusINAV */
static int hf_lpp_kepSV_StatusFNAV;               /* T_kepSV_StatusFNAV */
static int hf_lpp_kepAlmanacAPowerHalf;           /* INTEGER_M4096_4095 */
static int hf_lpp_kepAlmanacOmega0;               /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacW;                    /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacM0;                   /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacAF0;                  /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacAF1;                  /* INTEGER_M4096_4095 */
static int hf_lpp_navAlmE;                        /* INTEGER_0_65535 */
static int hf_lpp_navAlmDeltaI;                   /* INTEGER_M32768_32767 */
static int hf_lpp_navAlmOMEGADOT;                 /* INTEGER_M32768_32767 */
static int hf_lpp_navAlmSVHealth;                 /* INTEGER_0_255 */
static int hf_lpp_navAlmSqrtA;                    /* INTEGER_0_16777215 */
static int hf_lpp_navAlmOMEGAo;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_navAlmOmega;                    /* INTEGER_M8388608_8388607 */
static int hf_lpp_navAlmMo;                       /* INTEGER_M8388608_8388607 */
static int hf_lpp_navAlmaf0;                      /* INTEGER_M1024_1023 */
static int hf_lpp_navAlmaf1;                      /* INTEGER_M1024_1023 */
static int hf_lpp_redAlmDeltaA;                   /* INTEGER_M128_127 */
static int hf_lpp_redAlmOmega0;                   /* INTEGER_M64_63 */
static int hf_lpp_redAlmPhi0;                     /* INTEGER_M64_63 */
static int hf_lpp_redAlmL1Health;                 /* BOOLEAN */
static int hf_lpp_redAlmL2Health;                 /* BOOLEAN */
static int hf_lpp_redAlmL5Health;                 /* BOOLEAN */
static int hf_lpp_midiAlmE;                       /* INTEGER_0_2047 */
static int hf_lpp_midiAlmDeltaI;                  /* INTEGER_M1024_1023 */
static int hf_lpp_midiAlmOmegaDot;                /* INTEGER_M1024_1023 */
static int hf_lpp_midiAlmSqrtA;                   /* INTEGER_0_131071 */
static int hf_lpp_midiAlmOmega0;                  /* INTEGER_M32768_32767 */
static int hf_lpp_midiAlmOmega;                   /* INTEGER_M32768_32767 */
static int hf_lpp_midiAlmMo;                      /* INTEGER_M32768_32767 */
static int hf_lpp_midiAlmaf0;                     /* INTEGER_M1024_1023 */
static int hf_lpp_midiAlmaf1;                     /* INTEGER_M512_511 */
static int hf_lpp_midiAlmL1Health;                /* BOOLEAN */
static int hf_lpp_midiAlmL2Health;                /* BOOLEAN */
static int hf_lpp_midiAlmL5Health;                /* BOOLEAN */
static int hf_lpp_gloAlm_NA;                      /* INTEGER_1_1461 */
static int hf_lpp_gloAlmnA;                       /* INTEGER_1_24 */
static int hf_lpp_gloAlmHA;                       /* INTEGER_0_31 */
static int hf_lpp_gloAlmLambdaA;                  /* INTEGER_M1048576_1048575 */
static int hf_lpp_gloAlmtlambdaA;                 /* INTEGER_0_2097151 */
static int hf_lpp_gloAlmDeltaIa;                  /* INTEGER_M131072_131071 */
static int hf_lpp_gloAlmDeltaTA;                  /* INTEGER_M2097152_2097151 */
static int hf_lpp_gloAlmDeltaTdotA;               /* INTEGER_M64_63 */
static int hf_lpp_gloAlmEpsilonA;                 /* INTEGER_0_32767 */
static int hf_lpp_gloAlmOmegaA;                   /* INTEGER_M32768_32767 */
static int hf_lpp_gloAlmTauA;                     /* INTEGER_M512_511 */
static int hf_lpp_gloAlmCA;                       /* INTEGER_0_1 */
static int hf_lpp_gloAlmMA;                       /* BIT_STRING_SIZE_2 */
static int hf_lpp_sbasAlmDataID;                  /* INTEGER_0_3 */
static int hf_lpp_sbasAlmHealth;                  /* BIT_STRING_SIZE_8 */
static int hf_lpp_sbasAlmXg;                      /* INTEGER_M16384_16383 */
static int hf_lpp_sbasAlmYg;                      /* INTEGER_M16384_16383 */
static int hf_lpp_sbasAlmZg;                      /* INTEGER_M256_255 */
static int hf_lpp_sbasAlmXgdot;                   /* INTEGER_M4_3 */
static int hf_lpp_sbasAlmYgDot;                   /* INTEGER_M4_3 */
static int hf_lpp_sbasAlmZgDot;                   /* INTEGER_M8_7 */
static int hf_lpp_sbasAlmTo;                      /* INTEGER_0_2047 */
static int hf_lpp_bdsAlmToa_r12;                  /* INTEGER_0_255 */
static int hf_lpp_bdsAlmSqrtA_r12;                /* INTEGER_0_16777215 */
static int hf_lpp_bdsAlmE_r12;                    /* INTEGER_0_131071 */
static int hf_lpp_bdsAlmW_r12;                    /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsAlmM0_r12;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsAlmOmega0_r12;               /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsAlmOmegaDot_r12;             /* INTEGER_M65536_65535 */
static int hf_lpp_bdsAlmDeltaI_r12;               /* INTEGER_M32768_32767 */
static int hf_lpp_bdsAlmA0_r12;                   /* INTEGER_M1024_1023 */
static int hf_lpp_bdsAlmA1_r12;                   /* INTEGER_M1024_1023 */
static int hf_lpp_bdsSvHealth_r12;                /* T_bdsSvHealth_r12 */
static int hf_lpp_svID_r16;                       /* SV_ID */
static int hf_lpp_navic_AlmToa_r16;               /* INTEGER_0_65535 */
static int hf_lpp_navic_AlmE_r16;                 /* INTEGER_0_65535 */
static int hf_lpp_navic_AlmOMEGADOT_r16;          /* INTEGER_M32768_32767 */
static int hf_lpp_navic_AlmSqrtA_r16;             /* INTEGER_0_16777215 */
static int hf_lpp_navic_AlmOMEGAo_r16;            /* INTEGER_M8388608_8388607 */
static int hf_lpp_navic_AlmOmega_r16;             /* INTEGER_M8388608_8388607 */
static int hf_lpp_navic_AlmMo_r16;                /* INTEGER_M8388608_8388607 */
static int hf_lpp_navic_Almaf0_r16;               /* INTEGER_M1024_1023 */
static int hf_lpp_navic_Almaf1_r16;               /* INTEGER_M1024_1023 */
static int hf_lpp_navicL5_i0_r16;                 /* INTEGER_M8388608_8388607 */
static int hf_lpp_utcModel1;                      /* UTC_ModelSet1 */
static int hf_lpp_utcModel2;                      /* UTC_ModelSet2 */
static int hf_lpp_utcModel3;                      /* UTC_ModelSet3 */
static int hf_lpp_utcModel4;                      /* UTC_ModelSet4 */
static int hf_lpp_utcModel5_r12;                  /* UTC_ModelSet5_r12 */
static int hf_lpp_gnss_Utc_A1;                    /* INTEGER_M8388608_8388607 */
static int hf_lpp_gnss_Utc_A0;                    /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_gnss_Utc_Tot;                   /* INTEGER_0_255 */
static int hf_lpp_gnss_Utc_WNt;                   /* INTEGER_0_255 */
static int hf_lpp_gnss_Utc_DeltaTls;              /* INTEGER_M128_127 */
static int hf_lpp_gnss_Utc_WNlsf;                 /* INTEGER_0_255 */
static int hf_lpp_gnss_Utc_DN;                    /* INTEGER_M128_127 */
static int hf_lpp_gnss_Utc_DeltaTlsf;             /* INTEGER_M128_127 */
static int hf_lpp_utcA0;                          /* INTEGER_M32768_32767 */
static int hf_lpp_utcA1;                          /* INTEGER_M4096_4095 */
static int hf_lpp_utcA2;                          /* INTEGER_M64_63 */
static int hf_lpp_utcDeltaTls;                    /* INTEGER_M128_127 */
static int hf_lpp_utcTot;                         /* INTEGER_0_65535 */
static int hf_lpp_utcWNot;                        /* INTEGER_0_8191 */
static int hf_lpp_utcWNlsf;                       /* INTEGER_0_255 */
static int hf_lpp_utcDN;                          /* T_utcDN */
static int hf_lpp_utcDeltaTlsf;                   /* INTEGER_M128_127 */
static int hf_lpp_utcWNlsf_ext_r16;               /* INTEGER_256_8191 */
static int hf_lpp_nA;                             /* INTEGER_1_1461 */
static int hf_lpp_tauC;                           /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_b1;                             /* INTEGER_M1024_1023 */
static int hf_lpp_b2;                             /* INTEGER_M512_511 */
static int hf_lpp_kp;                             /* T_kp */
static int hf_lpp_utcA1wnt;                       /* INTEGER_M8388608_8388607 */
static int hf_lpp_utcA0wnt;                       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_utcTot_01;                      /* INTEGER_0_255 */
static int hf_lpp_utcWNt;                         /* INTEGER_0_255 */
static int hf_lpp_uTC_ModelSet4_utcDN;            /* INTEGER_M128_127 */
static int hf_lpp_utcStandardID;                  /* INTEGER_0_7 */
static int hf_lpp_utcA0_r12;                      /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_utcA1_r12;                      /* INTEGER_M8388608_8388607 */
static int hf_lpp_utcDeltaTls_r12;                /* INTEGER_M128_127 */
static int hf_lpp_utcWNlsf_r12;                   /* INTEGER_0_255 */
static int hf_lpp_utcDN_r12;                      /* INTEGER_0_255 */
static int hf_lpp_utcDeltaTlsf_r12;               /* INTEGER_M128_127 */
static int hf_lpp_gnss_ID_GPS;                    /* GNSS_ID_GPS */
static int hf_lpp_gnss_ID_GLONASS;                /* GNSS_ID_GLONASS */
static int hf_lpp_gnss_ID_BDS_r16;                /* GNSS_ID_BDS_r16 */
static int hf_lpp_GNSS_ID_GPS_item;               /* GNSS_ID_GPS_SatElement */
static int hf_lpp_signalsAvailable;               /* GNSS_SignalIDs */
static int hf_lpp_GNSS_ID_GLONASS_item;           /* GNSS_ID_GLONASS_SatElement */
static int hf_lpp_channelNumber;                  /* INTEGER_M7_13 */
static int hf_lpp_GNSS_ID_BDS_r16_item;           /* GNSS_ID_BDS_SatElement_r16 */
static int hf_lpp_satType_r16;                    /* INTEGER_0_3 */
static int hf_lpp_dbds_RefTime_r12;               /* INTEGER_0_3599 */
static int hf_lpp_bds_SgnTypeList_r12;            /* BDS_SgnTypeList_r12 */
static int hf_lpp_BDS_SgnTypeList_r12_item;       /* BDS_SgnTypeElement_r12 */
static int hf_lpp_dbds_CorrectionList_r12;        /* DBDS_CorrectionList_r12 */
static int hf_lpp_DBDS_CorrectionList_r12_item;   /* DBDS_CorrectionElement_r12 */
static int hf_lpp_bds_UDREI_r12;                  /* INTEGER_0_15 */
static int hf_lpp_bds_RURAI_r12;                  /* INTEGER_0_15 */
static int hf_lpp_bds_ECC_DeltaT_r12;             /* INTEGER_M4096_4095 */
static int hf_lpp_bds_RefTime_r12;                /* INTEGER_0_3599 */
static int hf_lpp_gridIonList_r12;                /* GridIonList_r12 */
static int hf_lpp_GridIonList_r12_item;           /* GridIonElement_r12 */
static int hf_lpp_igp_ID_r12;                     /* INTEGER_1_320 */
static int hf_lpp_dt_r12;                         /* INTEGER_0_511 */
static int hf_lpp_givei_r12;                      /* INTEGER_0_15 */
static int hf_lpp_epochTime_r15;                  /* GNSS_SystemTime */
static int hf_lpp_gnss_ObservationList_r15;       /* GNSS_ObservationList_r15 */
static int hf_lpp_GNSS_ObservationList_r15_item;  /* GNSS_RTK_SatelliteDataElement_r15 */
static int hf_lpp_svID_r15;                       /* SV_ID */
static int hf_lpp_integer_ms_r15;                 /* INTEGER_0_254 */
static int hf_lpp_rough_range_r15;                /* INTEGER_0_1023 */
static int hf_lpp_rough_phase_range_rate_r15;     /* INTEGER_M8192_8191 */
static int hf_lpp_gnss_rtk_SatelliteSignalDataList_r15;  /* GNSS_RTK_SatelliteSignalDataList_r15 */
static int hf_lpp_GNSS_RTK_SatelliteSignalDataList_r15_item;  /* GNSS_RTK_SatelliteSignalDataElement_r15 */
static int hf_lpp_gnss_SignalID_r15;              /* GNSS_SignalID */
static int hf_lpp_fine_PseudoRange_r15;           /* INTEGER_M524288_524287 */
static int hf_lpp_fine_PhaseRange_r15;            /* INTEGER_M8388608_8388607 */
static int hf_lpp_lockTimeIndicator_r15;          /* INTEGER_0_1023 */
static int hf_lpp_halfCycleAmbiguityIndicator_r15;  /* BIT_STRING_SIZE_1 */
static int hf_lpp_carrier_to_noise_ratio_r15;     /* INTEGER_0_1023 */
static int hf_lpp_fine_PhaseRangeRate_r15;        /* INTEGER_M16384_16383 */
static int hf_lpp_cpbIndicator_r15;               /* BIT_STRING_SIZE_1 */
static int hf_lpp_l1_ca_cpBias_r15;               /* INTEGER_M32768_32767 */
static int hf_lpp_l1_p_cpBias_r15;                /* INTEGER_M32768_32767 */
static int hf_lpp_l2_ca_cpBias_r15;               /* INTEGER_M32768_32767 */
static int hf_lpp_l2_p_cpBias_r15;                /* INTEGER_M32768_32767 */
static int hf_lpp_master_ReferenceStationID_r15;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_l1_r15;                         /* GNSS_FrequencyID_r15 */
static int hf_lpp_l2_r15;                         /* GNSS_FrequencyID_r15 */
static int hf_lpp_rtkCorrectionDifferencesList_r15;  /* RTK_CorrectionDifferencesList_r15 */
static int hf_lpp_RTK_CorrectionDifferencesList_r15_item;  /* RTK_CorrectionDifferencesElement_r15 */
static int hf_lpp_auxiliary_referenceStationID_r15;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_geometric_ionospheric_corrections_differences_r15;  /* Geometric_Ionospheric_Corrections_Differences_r15 */
static int hf_lpp_Geometric_Ionospheric_Corrections_Differences_r15_item;  /* Geometric_Ionospheric_Corrections_Differences_Element_r15 */
static int hf_lpp_ambiguityStatusFlag_r15;        /* INTEGER_0_3 */
static int hf_lpp_non_synch_count_r15;            /* INTEGER_0_7 */
static int hf_lpp_geometricCarrierPhaseCorrectionDifference_r15;  /* INTEGER_M65536_65535 */
static int hf_lpp_iod_r15;                        /* BIT_STRING_SIZE_11 */
static int hf_lpp_ionosphericCarrierPhaseCorrectionDifference_r15;  /* INTEGER_M65536_65535 */
static int hf_lpp_n_Refs_r15;                     /* INTEGER_0_127 */
static int hf_lpp_rtk_residuals_list_r15;         /* RTK_Residuals_List_r15 */
static int hf_lpp_RTK_Residuals_List_r15_item;    /* RTK_Residuals_Element_r15 */
static int hf_lpp_s_oc_r15;                       /* INTEGER_0_255 */
static int hf_lpp_s_od_r15;                       /* INTEGER_0_511 */
static int hf_lpp_s_oh_r15;                       /* INTEGER_0_63 */
static int hf_lpp_s_lc_r15;                       /* INTEGER_0_1023 */
static int hf_lpp_s_ld_r15;                       /* INTEGER_0_1023 */
static int hf_lpp_fkp_gradients_list_r15;         /* FKP_Gradients_List_r15 */
static int hf_lpp_FKP_Gradients_List_r15_item;    /* FKP_Gradients_Element_r15 */
static int hf_lpp_north_geometric_gradient_r15;   /* INTEGER_M2048_2047 */
static int hf_lpp_east_geometric_gradient_r15;    /* INTEGER_M2048_2047 */
static int hf_lpp_north_ionospheric_gradient_r15;  /* INTEGER_M8192_8191 */
static int hf_lpp_east_ionospheric_gradient_r15;  /* INTEGER_M8192_8191 */
static int hf_lpp_ssrUpdateInterval_r15;          /* INTEGER_0_15 */
static int hf_lpp_satelliteReferenceDatum_r15;    /* T_satelliteReferenceDatum_r15 */
static int hf_lpp_iod_ssr_r15;                    /* INTEGER_0_15 */
static int hf_lpp_ssr_OrbitCorrectionList_r15;    /* SSR_OrbitCorrectionList_r15 */
static int hf_lpp_orbit_IntegrityParameters_r17;  /* ORBIT_IntegrityParameters_r17 */
static int hf_lpp_SSR_OrbitCorrectionList_r15_item;  /* SSR_OrbitCorrectionSatelliteElement_r15 */
static int hf_lpp_delta_radial_r15;               /* INTEGER_M2097152_2097151 */
static int hf_lpp_delta_AlongTrack_r15;           /* INTEGER_M524288_524287 */
static int hf_lpp_delta_CrossTrack_r15;           /* INTEGER_M524288_524287 */
static int hf_lpp_dot_delta_radial_r15;           /* INTEGER_M1048576_1048575 */
static int hf_lpp_dot_delta_AlongTrack_r15;       /* INTEGER_M262144_262143 */
static int hf_lpp_dot_delta_CrossTrack_r15;       /* INTEGER_M262144_262143 */
static int hf_lpp_ssr_IntegrityOrbitBounds_r17;   /* SSR_IntegrityOrbitBounds_r17 */
static int hf_lpp_probOnsetConstFault_r17;        /* INTEGER_0_255 */
static int hf_lpp_meanConstFaultDuration_r17;     /* INTEGER_1_3600 */
static int hf_lpp_probOnsetSatFault_r17;          /* INTEGER_0_255 */
static int hf_lpp_meanSatFaultDuration_r17;       /* INTEGER_1_3600 */
static int hf_lpp_orbitRangeErrorCorrelationTime_r17;  /* INTEGER_0_255 */
static int hf_lpp_orbitRangeRateErrorCorrelationTime_r17;  /* INTEGER_0_255 */
static int hf_lpp_meanOrbitError_r17;             /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_stdDevOrbitError_r17;           /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_meanOrbitRateError_r17;         /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_stdDevOrbitRateError_r17;       /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_radial_r17;                     /* INTEGER_0_255 */
static int hf_lpp_alongTrack_r17;                 /* INTEGER_0_255 */
static int hf_lpp_crossTrack_r17;                 /* INTEGER_0_255 */
static int hf_lpp_ssr_ClockCorrectionList_r15;    /* SSR_ClockCorrectionList_r15 */
static int hf_lpp_clock_IntegrityParameters_r17;  /* CLOCK_IntegrityParameters_r17 */
static int hf_lpp_SSR_ClockCorrectionList_r15_item;  /* SSR_ClockCorrectionSatelliteElement_r15 */
static int hf_lpp_delta_Clock_C0_r15;             /* INTEGER_M2097152_2097151 */
static int hf_lpp_delta_Clock_C1_r15;             /* INTEGER_M1048576_1048575 */
static int hf_lpp_delta_Clock_C2_r15;             /* INTEGER_M67108864_67108863 */
static int hf_lpp_ssr_IntegrityClockBounds_r17;   /* SSR_IntegrityClockBounds_r17 */
static int hf_lpp_clockRangeErrorCorrelationTime_r17;  /* INTEGER_0_255 */
static int hf_lpp_clockRangeRateErrorCorrelationTime_r17;  /* INTEGER_0_255 */
static int hf_lpp_meanClock_r17;                  /* INTEGER_0_255 */
static int hf_lpp_stdDevClock_r17;                /* INTEGER_0_255 */
static int hf_lpp_meanClockRate_r17;              /* INTEGER_0_255 */
static int hf_lpp_stdDevClockRate_r17;            /* INTEGER_0_255 */
static int hf_lpp_ssr_CodeBiasSatList_r15;        /* SSR_CodeBiasSatList_r15 */
static int hf_lpp_SSR_CodeBiasSatList_r15_item;   /* SSR_CodeBiasSatElement_r15 */
static int hf_lpp_ssr_CodeBiasSignalList_r15;     /* SSR_CodeBiasSignalList_r15 */
static int hf_lpp_SSR_CodeBiasSignalList_r15_item;  /* SSR_CodeBiasSignalElement_r15 */
static int hf_lpp_signal_and_tracking_mode_ID_r15;  /* GNSS_SignalID */
static int hf_lpp_codeBias_r15;                   /* INTEGER_M8192_8191 */
static int hf_lpp_ssr_IntegrityCodeBiasBounds_r17;  /* SSR_IntegrityCodeBiasBounds_r17 */
static int hf_lpp_meanCodeBias_r17;               /* INTEGER_0_255 */
static int hf_lpp_stdDevCodeBias_r17;             /* INTEGER_0_255 */
static int hf_lpp_meanCodeBiasRate_r17;           /* INTEGER_0_255 */
static int hf_lpp_stdDevCodeBiasRate_r17;         /* INTEGER_0_255 */
static int hf_lpp_epochTime_r16;                  /* GNSS_SystemTime */
static int hf_lpp_ssrUpdateInterval_r16;          /* INTEGER_0_15 */
static int hf_lpp_iod_ssr_r16;                    /* INTEGER_0_15 */
static int hf_lpp_ssr_URA_SatList_r16;            /* SSR_URA_SatList_r16 */
static int hf_lpp_SSR_URA_SatList_r16_item;       /* SSR_URA_SatElement_r16 */
static int hf_lpp_ssr_URA_r16;                    /* BIT_STRING_SIZE_6 */
static int hf_lpp_ssr_PhaseBiasSatList_r16;       /* SSR_PhaseBiasSatList_r16 */
static int hf_lpp_SSR_PhaseBiasSatList_r16_item;  /* SSR_PhaseBiasSatElement_r16 */
static int hf_lpp_ssr_PhaseBiasSignalList_r16;    /* SSR_PhaseBiasSignalList_r16 */
static int hf_lpp_SSR_PhaseBiasSignalList_r16_item;  /* SSR_PhaseBiasSignalElement_r16 */
static int hf_lpp_signal_and_tracking_mode_ID_r16;  /* GNSS_SignalID */
static int hf_lpp_phaseBias_r16;                  /* INTEGER_M16384_16383 */
static int hf_lpp_phaseDiscontinuityIndicator_r16;  /* INTEGER_0_3 */
static int hf_lpp_phaseBiasIntegerIndicator_r16;  /* INTEGER_0_3 */
static int hf_lpp_ssr_IntegrityPhaseBiasBounds_r17;  /* SSR_IntegrityPhaseBiasBounds_r17 */
static int hf_lpp_meanPhaseBias_r17;              /* INTEGER_0_255 */
static int hf_lpp_stdDevPhaseBias_r17;            /* INTEGER_0_255 */
static int hf_lpp_meanPhaseBiasRate_r17;          /* INTEGER_0_255 */
static int hf_lpp_stdDevPhaseBiasRate_r17;        /* INTEGER_0_255 */
static int hf_lpp_stec_SatList_r16;               /* STEC_SatList_r16 */
static int hf_lpp_stec_IntegrityParameters_r17;   /* STEC_IntegrityParameters_r17 */
static int hf_lpp_STEC_SatList_r16_item;          /* STEC_SatElement_r16 */
static int hf_lpp_stecQualityIndicator_r16;       /* BIT_STRING_SIZE_6 */
static int hf_lpp_stec_C00_r16;                   /* INTEGER_M8192_8191 */
static int hf_lpp_stec_C01_r16;                   /* INTEGER_M2048_2047 */
static int hf_lpp_stec_C10_r16;                   /* INTEGER_M2048_2047 */
static int hf_lpp_stec_C11_r16;                   /* INTEGER_M512_511 */
static int hf_lpp_stec_IntegrityErrorBounds_r17;  /* STEC_IntegrityErrorBounds_r17 */
static int hf_lpp_probOnsetIonoFault_r17;         /* INTEGER_0_255 */
static int hf_lpp_meanIonoFaultDuration_r17;      /* INTEGER_1_256 */
static int hf_lpp_ionoRangeErrorCorrelationTime_r17;  /* INTEGER_1_255 */
static int hf_lpp_ionoRangeRateErrorCorrelationTime_r17;  /* INTEGER_1_255 */
static int hf_lpp_meanIonosphere_r17;             /* INTEGER_0_255 */
static int hf_lpp_stdDevIonosphere_r17;           /* INTEGER_0_255 */
static int hf_lpp_meanIonosphereRate_r17;         /* INTEGER_0_255 */
static int hf_lpp_stdDevIonosphereRate_r17;       /* INTEGER_0_255 */
static int hf_lpp_troposphericDelayQualityIndicator_r16;  /* BIT_STRING_SIZE_6 */
static int hf_lpp_gridList_r16;                   /* GridList_r16 */
static int hf_lpp_ssr_GriddedCorrectionIntegrityParameters_r17;  /* SSR_GriddedCorrectionIntegrityParameters_r17 */
static int hf_lpp_GridList_r16_item;              /* GridElement_r16 */
static int hf_lpp_tropospericDelayCorrection_r16;  /* TropospericDelayCorrection_r16 */
static int hf_lpp_stec_ResidualSatList_r16;       /* STEC_ResidualSatList_r16 */
static int hf_lpp_tropoHydroStaticVerticalDelay_r16;  /* INTEGER_M256_255 */
static int hf_lpp_tropoWetVerticalDelay_r16;      /* INTEGER_M128_127 */
static int hf_lpp_tropoDelayIntegrityErrorBounds_r17;  /* TropoDelayIntegrityErrorBounds_r17 */
static int hf_lpp_STEC_ResidualSatList_r16_item;  /* STEC_ResidualSatElement_r16 */
static int hf_lpp_stecResidualCorrection_r16;     /* T_stecResidualCorrection_r16 */
static int hf_lpp_b7_r16;                         /* INTEGER_M64_63 */
static int hf_lpp_b16_r16;                        /* INTEGER_M32768_32767 */
static int hf_lpp_probOnsetTroposphereFault_r17;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereFaultDuration_r17;  /* INTEGER_1_256 */
static int hf_lpp_troposphereRangeErrorCorrelationTime_r17;  /* INTEGER_1_255 */
static int hf_lpp_troposphereRangeRateErrorCorrelationTime_r17;  /* INTEGER_1_255 */
static int hf_lpp_meanTroposphereVerticalHydroStaticDelay_r17;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalHydroStaticDelay_r17;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereVerticalWetDelay_r17;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalWetDelay_r17;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereVerticalHydroStaticDelayRate_r17;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalHydroStaticDelayRate_r17;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereVerticalWetDelayRate_r17;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalWetDelayRate_r17;  /* INTEGER_0_255 */
static int hf_lpp_navic_RefTOWC_r16;              /* INTEGER_0_50400 */
static int hf_lpp_navic_CorrectionListAutoNav_r16;  /* NavIC_CorrectionListAutoNav_r16 */
static int hf_lpp_NavIC_CorrectionListAutoNav_r16_item;  /* NavIC_CorrectionElementAutoNav_r16 */
static int hf_lpp_navic_Tod_r16;                  /* INTEGER_0_65535 */
static int hf_lpp_navic_iodec_r16;                /* INTEGER_0_255 */
static int hf_lpp_navic_UDRAI_r16;                /* INTEGER_M16_15 */
static int hf_lpp_navic_UDRArateI_r16;            /* INTEGER_M16_15 */
static int hf_lpp_navic_EDC_r16;                  /* NavIC_EDC_r16 */
static int hf_lpp_navic_CDC_r16;                  /* NavIC_CDC_r16 */
static int hf_lpp_navic_AlphaEDC_r16;             /* INTEGER_M8192_8191 */
static int hf_lpp_navic_BetaEDC_r16;              /* INTEGER_M8192_8191 */
static int hf_lpp_navic_GammaEDC_r16;             /* INTEGER_M16384_16383 */
static int hf_lpp_navic_AoIcorrection_r16;        /* INTEGER_M2048_2047 */
static int hf_lpp_navic_AoRAcorrection_r16;       /* INTEGER_M2048_2047 */
static int hf_lpp_navic_SemiMajorcorrection_r16;  /* INTEGER_M2048_2047 */
static int hf_lpp_navic_ClockBiasCorrection_r16;  /* INTEGER_M4096_4095 */
static int hf_lpp_navic_ClockDriftCorrection_r16;  /* INTEGER_M128_127 */
static int hf_lpp_regionMasked_r16;               /* INTEGER_0_1023 */
static int hf_lpp_regionIgpList_r16;              /* RegionIgpList_r16 */
static int hf_lpp_RegionIgpList_r16_item;         /* RegionIgpElement_r16 */
static int hf_lpp_regionID_r16;                   /* INTEGER_0_15 */
static int hf_lpp_givei1_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd1_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei2_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd2_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei3_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd3_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei4_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd4_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei5_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd5_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei6_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd6_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei7_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd7_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei8_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd8_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei9_r16;                     /* INTEGER_0_15 */
static int hf_lpp_givd9_r16;                      /* INTEGER_0_511 */
static int hf_lpp_givei10_r16;                    /* INTEGER_0_15 */
static int hf_lpp_givd10_r16;                     /* INTEGER_0_511 */
static int hf_lpp_givei11_r16;                    /* INTEGER_0_15 */
static int hf_lpp_givd11_r16;                     /* INTEGER_0_511 */
static int hf_lpp_givei12_r16;                    /* INTEGER_0_15 */
static int hf_lpp_givd12_r16;                     /* INTEGER_0_511 */
static int hf_lpp_givei13_r16;                    /* INTEGER_0_15 */
static int hf_lpp_givd13_r16;                     /* INTEGER_0_511 */
static int hf_lpp_givei14_r16;                    /* INTEGER_0_15 */
static int hf_lpp_givd14_r16;                     /* INTEGER_0_511 */
static int hf_lpp_givei15_r16;                    /* INTEGER_0_15 */
static int hf_lpp_givd15_r16;                     /* INTEGER_0_511 */
static int hf_lpp_refEph_r17;                     /* T_refEph_r17 */
static int hf_lpp_gnss_SSR_OrbitCorrections_r17;  /* GNSS_SSR_OrbitCorrections_r15 */
static int hf_lpp_refEph_r17_01;                  /* T_refEph_r17_01 */
static int hf_lpp_gnss_SSR_ClockCorrections_r17;  /* GNSS_SSR_ClockCorrections_r15 */
static int hf_lpp_refEph_r17_02;                  /* T_refEph_r17_02 */
static int hf_lpp_gnss_SSR_URA_r17;               /* GNSS_SSR_URA_r16 */
static int hf_lpp_expirationTime_r18;             /* UTCTime */
static int hf_lpp_gridList_r18;                   /* GridList_r18 */
static int hf_lpp_GridList_r18_item;              /* GridElement_r18 */
static int hf_lpp_gnss_LOS_InfoList_r18;          /* GNSS_LOS_InfoList_r18 */
static int hf_lpp_GNSS_LOS_InfoList_r18_item;     /* GNSS_LOS_InfoElement_r18 */
static int hf_lpp_svID_r18;                       /* SV_ID */
static int hf_lpp_los_r18;                        /* T_los_r18 */
static int hf_lpp_ssr_SatellitePCV_List_r18;      /* SSR_SatellitePCV_List_r18 */
static int hf_lpp_SSR_SatellitePCV_List_r18_item;  /* SSR_SatellitePCV_Element_r18 */
static int hf_lpp_ssr_SatellitePCV_FrequencyList_r18;  /* SSR_SatellitePCV_FrequencyList_r18 */
static int hf_lpp_SSR_SatellitePCV_FrequencyList_r18_item;  /* SSR_SatellitePCV_FrequencyElement_r18 */
static int hf_lpp_frequencyID_r18;                /* GNSS_FrequencyID_r15 */
static int hf_lpp_phaseCenterVariations_r18;      /* SSR_PhaseCenterVariationList_r18 */
static int hf_lpp_SSR_PhaseCenterVariationList_r18_item;  /* INTEGER_M1024_1023 */
static int hf_lpp_gnss_CommonAssistDataReq;       /* GNSS_CommonAssistDataReq */
static int hf_lpp_gnss_GenericAssistDataReq;      /* GNSS_GenericAssistDataReq */
static int hf_lpp_gnss_PeriodicAssistDataReq_r15;  /* GNSS_PeriodicAssistDataReq_r15 */
static int hf_lpp_gnss_ReferenceTimeReq;          /* GNSS_ReferenceTimeReq */
static int hf_lpp_gnss_ReferenceLocationReq;      /* GNSS_ReferenceLocationReq */
static int hf_lpp_gnss_IonosphericModelReq;       /* GNSS_IonosphericModelReq */
static int hf_lpp_gnss_EarthOrientationParametersReq;  /* GNSS_EarthOrientationParametersReq */
static int hf_lpp_gnss_RTK_ReferenceStationInfoReq_r15;  /* GNSS_RTK_ReferenceStationInfoReq_r15 */
static int hf_lpp_gnss_RTK_AuxiliaryStationDataReq_r15;  /* GNSS_RTK_AuxiliaryStationDataReq_r15 */
static int hf_lpp_gnss_SSR_CorrectionPointsReq_r16;  /* GNSS_SSR_CorrectionPointsReq_r16 */
static int hf_lpp_gnss_Integrity_ServiceParametersReq_r17;  /* GNSS_Integrity_ServiceParametersReq_r17 */
static int hf_lpp_gnss_Integrity_ServiceAlertReq_r17;  /* GNSS_Integrity_ServiceAlertReq_r17 */
static int hf_lpp_gnss_SSR_IOD_UpdateReq_r18;     /* GNSS_SSR_IOD_UpdateReq_r18 */
static int hf_lpp_GNSS_GenericAssistDataReq_item;  /* GNSS_GenericAssistDataReqElement */
static int hf_lpp_gnss_TimeModelsReq;             /* GNSS_TimeModelListReq */
static int hf_lpp_gnss_DifferentialCorrectionsReq;  /* GNSS_DifferentialCorrectionsReq */
static int hf_lpp_gnss_NavigationModelReq;        /* GNSS_NavigationModelReq */
static int hf_lpp_gnss_RealTimeIntegrityReq;      /* GNSS_RealTimeIntegrityReq */
static int hf_lpp_gnss_DataBitAssistanceReq;      /* GNSS_DataBitAssistanceReq */
static int hf_lpp_gnss_AcquisitionAssistanceReq;  /* GNSS_AcquisitionAssistanceReq */
static int hf_lpp_gnss_AlmanacReq;                /* GNSS_AlmanacReq */
static int hf_lpp_gnss_UTCModelReq;               /* GNSS_UTC_ModelReq */
static int hf_lpp_gnss_AuxiliaryInformationReq;   /* GNSS_AuxiliaryInformationReq */
static int hf_lpp_bds_DifferentialCorrectionsReq_r12;  /* BDS_DifferentialCorrectionsReq_r12 */
static int hf_lpp_bds_GridModelReq_r12;           /* BDS_GridModelReq_r12 */
static int hf_lpp_gnss_RTK_ObservationsReq_r15;   /* GNSS_RTK_ObservationsReq_r15 */
static int hf_lpp_glo_RTK_BiasInformationReq_r15;  /* GLO_RTK_BiasInformationReq_r15 */
static int hf_lpp_gnss_RTK_MAC_CorrectionDifferencesReq_r15;  /* GNSS_RTK_MAC_CorrectionDifferencesReq_r15 */
static int hf_lpp_gnss_RTK_ResidualsReq_r15;      /* GNSS_RTK_ResidualsReq_r15 */
static int hf_lpp_gnss_RTK_FKP_GradientsReq_r15;  /* GNSS_RTK_FKP_GradientsReq_r15 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsReq_r15;  /* GNSS_SSR_OrbitCorrectionsReq_r15 */
static int hf_lpp_gnss_SSR_ClockCorrectionsReq_r15;  /* GNSS_SSR_ClockCorrectionsReq_r15 */
static int hf_lpp_gnss_SSR_CodeBiasReq_r15;       /* GNSS_SSR_CodeBiasReq_r15 */
static int hf_lpp_gnss_SSR_URA_Req_r16;           /* GNSS_SSR_URA_Req_r16 */
static int hf_lpp_gnss_SSR_PhaseBiasReq_r16;      /* GNSS_SSR_PhaseBiasReq_r16 */
static int hf_lpp_gnss_SSR_STEC_CorrectionReq_r16;  /* GNSS_SSR_STEC_CorrectionReq_r16 */
static int hf_lpp_gnss_SSR_GriddedCorrectionReq_r16;  /* GNSS_SSR_GriddedCorrectionReq_r16 */
static int hf_lpp_navic_DifferentialCorrectionsReq_r16;  /* NavIC_DifferentialCorrectionsReq_r16 */
static int hf_lpp_navic_GridModelReq_r16;         /* NavIC_GridModelReq_r16 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsSet2Req_r17;  /* GNSS_SSR_OrbitCorrectionsSet2Req_r17 */
static int hf_lpp_gnss_SSR_ClockCorrectionsSet2Req_r17;  /* GNSS_SSR_ClockCorrectionsSet2Req_r17 */
static int hf_lpp_gnss_SSR_URA_Set2Req_r17;       /* GNSS_SSR_URA_Set2Req_r17 */
static int hf_lpp_gnss_LOS_NLOS_GriddedIndicationsReq_r18;  /* GNSS_LOS_NLOS_GriddedIndicationsReq_r18 */
static int hf_lpp_gnss_SSR_SatellitePCVResidualsReq_r18;  /* GNSS_SSR_SatellitePCVResidualsReq_r18 */
static int hf_lpp_gnss_RTK_PeriodicObservationsReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_glo_RTK_PeriodicBiasInformationReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferencesReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_PeriodicResidualsReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_FKP_PeriodicGradientsReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicClockCorrectionsReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicCodeBiasReq_r15;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicURA_Req_r16;   /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicPhaseBiasReq_r16;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicSTEC_CorrectionReq_r16;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicGriddedCorrectionReq_r16;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_Integrity_PeriodicServiceAlertReq_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsSet2Req_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicClockCorrectionsSet2Req_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicURA_Set2Req_r17;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicIOD_UpdateReq_r18;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_TimeReqPrefList;           /* SEQUENCE_SIZE_1_8_OF_GNSS_ID */
static int hf_lpp_gnss_TimeReqPrefList_item;      /* GNSS_ID */
static int hf_lpp_gps_TOW_assistReq;              /* BOOLEAN */
static int hf_lpp_notOfLeapSecReq;                /* BOOLEAN */
static int hf_lpp_klobucharModelReq;              /* BIT_STRING_SIZE_2 */
static int hf_lpp_neQuickModelReq;                /* NULL */
static int hf_lpp_klobucharModel2Req_r16;         /* NULL */
static int hf_lpp_antennaDescriptionReq_r15;      /* BOOLEAN */
static int hf_lpp_antennaHeightReq_r15;           /* BOOLEAN */
static int hf_lpp_physicalReferenceStationReq_r15;  /* BOOLEAN */
static int hf_lpp_stationID_r15;                  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_correctionPointSetID_Req_r16;   /* INTEGER_0_16383 */
static int hf_lpp_GNSS_TimeModelListReq_item;     /* GNSS_TimeModelElementReq */
static int hf_lpp_gnss_TO_IDsReq;                 /* INTEGER_1_15 */
static int hf_lpp_deltaTreq;                      /* BOOLEAN */
static int hf_lpp_dgnss_SignalsReq;               /* GNSS_SignalIDs */
static int hf_lpp_dgnss_ValidityTimeReq;          /* BOOLEAN */
static int hf_lpp_storedNavList;                  /* StoredNavListInfo */
static int hf_lpp_reqNavList;                     /* ReqNavListInfo */
static int hf_lpp_gnss_WeekOrDay;                 /* T_gnss_WeekOrDay */
static int hf_lpp_gnss_Toe;                       /* T_gnss_Toe */
static int hf_lpp_t_toeLimit;                     /* T_t_toeLimit */
static int hf_lpp_satListRelatedDataList;         /* SatListRelatedDataList */
static int hf_lpp_SatListRelatedDataList_item;    /* SatListRelatedDataElement */
static int hf_lpp_clockModelID;                   /* INTEGER_1_8 */
static int hf_lpp_orbitModelID;                   /* INTEGER_1_8 */
static int hf_lpp_svReqList;                      /* BIT_STRING_SIZE_64 */
static int hf_lpp_clockModelID_PrefList;          /* T_clockModelID_PrefList */
static int hf_lpp_clockModelID_PrefList_item;     /* INTEGER_1_8 */
static int hf_lpp_orbitModelID_PrefList;          /* T_orbitModelID_PrefList */
static int hf_lpp_orbitModelID_PrefList_item;     /* INTEGER_1_8 */
static int hf_lpp_addNavparamReq;                 /* BOOLEAN */
static int hf_lpp_gnss_TOD_Req;                   /* INTEGER_0_3599 */
static int hf_lpp_gnss_TOD_FracReq;               /* INTEGER_0_999 */
static int hf_lpp_dataBitInterval;                /* INTEGER_0_15 */
static int hf_lpp_gnss_SignalType_01;             /* GNSS_SignalIDs */
static int hf_lpp_gnss_DataBitsReq;               /* GNSS_DataBitsReqSatList */
static int hf_lpp_GNSS_DataBitsReqSatList_item;   /* GNSS_DataBitsReqSatElement */
static int hf_lpp_gnss_SignalID_Req;              /* GNSS_SignalID */
static int hf_lpp_modelID;                        /* INTEGER_1_8 */
static int hf_lpp_gnss_RTK_SignalsReq_r15;        /* GNSS_SignalIDs */
static int hf_lpp_gnss_RTK_Integer_ms_Req_r15;    /* BOOLEAN */
static int hf_lpp_gnss_RTK_PhaseRangeRateReq_r15;  /* BOOLEAN */
static int hf_lpp_gnss_RTK_CNR_Req_r15;           /* BOOLEAN */
static int hf_lpp_aux_ReferenceStationList_r15;   /* AUX_ReferenceStationList_r15 */
static int hf_lpp_linkCombinations_PrefList_r15;  /* GNSS_Link_CombinationsList_r15 */
static int hf_lpp_AUX_ReferenceStationList_r15_item;  /* AUX_ReferenceStationID_Element_r15 */
static int hf_lpp_aux_stationID_r15;              /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_storedNavList_r15;              /* GNSS_NavListInfo_r15 */
static int hf_lpp_orbit_IntegrityReq_r17;         /* T_orbit_IntegrityReq_r17 */
static int hf_lpp_clock_IntegrityParametersReq_r17;  /* T_clock_IntegrityParametersReq_r17 */
static int hf_lpp_ssr_IntegrityClockBoundsReq_r17;  /* T_ssr_IntegrityClockBoundsReq_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Map_r15;  /* GNSS_SignalIDs */
static int hf_lpp_ssr_IntegrityCodeBiasBoundsReq_r17;  /* T_ssr_IntegrityCodeBiasBoundsReq_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Map_r16;  /* GNSS_SignalIDs */
static int hf_lpp_storedNavList_r16;              /* GNSS_NavListInfo_r15 */
static int hf_lpp_ssr_IntegrityPhaseBiasBoundsReq_r17;  /* T_ssr_IntegrityPhaseBiasBoundsReq_r17 */
static int hf_lpp_stec_IntegrityReq_r17;          /* T_stec_IntegrityReq_r17 */
static int hf_lpp_griddedCorrectionIntegrityReq_r17;  /* T_griddedCorrectionIntegrityReq_r17 */
static int hf_lpp_dgnss_SignalsReq_r16;           /* GNSS_SignalIDs */
static int hf_lpp_refEphReq_r17;                  /* T_refEphReq_r17 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsSet2Req_r17_01;  /* GNSS_SSR_OrbitCorrectionsReq_r15 */
static int hf_lpp_refEphReq_r17_01;               /* T_refEphReq_r17_01 */
static int hf_lpp_gnss_SSR_ClockCorrectionsSet2Req_r17_01;  /* GNSS_SSR_ClockCorrectionsReq_r15 */
static int hf_lpp_refEphReq_r17_02;               /* T_refEphReq_r17_02 */
static int hf_lpp_gridPointsSetID_Req_r18;        /* INTEGER_0_16383 */
static int hf_lpp_relativeLocationInfo_r18;       /* T_relativeLocationInfo_r18 */
static int hf_lpp_inside_r18;                     /* T_inside_r18 */
static int hf_lpp_outside_r18;                    /* T_outside_r18 */
static int hf_lpp_verticalGridType_r18;           /* T_verticalGridType_r18 */
static int hf_lpp_gnss_SignalMeasurementInformation;  /* GNSS_SignalMeasurementInformation */
static int hf_lpp_gnss_LocationInformation;       /* GNSS_LocationInformation */
static int hf_lpp_measurementReferenceTime;       /* MeasurementReferenceTime */
static int hf_lpp_gnss_MeasurementList;           /* GNSS_MeasurementList */
static int hf_lpp_gnss_TOD_msec;                  /* INTEGER_0_3599999 */
static int hf_lpp_gnss_TOD_frac;                  /* INTEGER_0_3999 */
static int hf_lpp_gnss_TOD_unc;                   /* INTEGER_0_127 */
static int hf_lpp_networkTime_01;                 /* T_networkTime */
static int hf_lpp_eUTRA_01;                       /* T_eUTRA_01 */
static int hf_lpp_cellGlobalId_01;                /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_uTRA_01;                        /* T_uTRA_01 */
static int hf_lpp_mode_01;                        /* T_mode_01 */
static int hf_lpp_fdd_01;                         /* T_fdd_01 */
static int hf_lpp_tdd_01;                         /* T_tdd_01 */
static int hf_lpp_referenceSystemFrameNumber;     /* INTEGER_0_4095 */
static int hf_lpp_gSM_01;                         /* T_gSM_01 */
static int hf_lpp_cellGlobalId_02;                /* CellGlobalIdGERAN */
static int hf_lpp_referenceFrame;                 /* T_referenceFrame */
static int hf_lpp_referenceFN;                    /* INTEGER_0_65535 */
static int hf_lpp_referenceFNMSB;                 /* INTEGER_0_63 */
static int hf_lpp_deltaGNSS_TOD;                  /* INTEGER_0_127 */
static int hf_lpp_nbIoT_r14;                      /* T_nbIoT_r14 */
static int hf_lpp_sfn_r14;                        /* BIT_STRING_SIZE_10 */
static int hf_lpp_nr_r15_01;                      /* T_nr_r15_01 */
static int hf_lpp_nr_sfn_r15;                     /* BIT_STRING_SIZE_10 */
static int hf_lpp_GNSS_MeasurementList_item;      /* GNSS_MeasurementForOneGNSS */
static int hf_lpp_gnss_SgnMeasList;               /* GNSS_SgnMeasList */
static int hf_lpp_GNSS_SgnMeasList_item;          /* GNSS_SgnMeasElement */
static int hf_lpp_gnss_CodePhaseAmbiguity;        /* INTEGER_0_127 */
static int hf_lpp_gnss_SatMeasList;               /* GNSS_SatMeasList */
static int hf_lpp_GNSS_SatMeasList_item;          /* GNSS_SatMeasElement */
static int hf_lpp_cNo;                            /* INTEGER_0_63 */
static int hf_lpp_mpathDet;                       /* T_mpathDet */
static int hf_lpp_carrierQualityInd;              /* INTEGER_0_3 */
static int hf_lpp_codePhase_01;                   /* INTEGER_0_2097151 */
static int hf_lpp_integerCodePhase;               /* INTEGER_0_127 */
static int hf_lpp_codePhaseRMSError;              /* INTEGER_0_63 */
static int hf_lpp_doppler;                        /* INTEGER_M32768_32767 */
static int hf_lpp_adr;                            /* INTEGER_0_33554431 */
static int hf_lpp_adrMSB_r15;                     /* INTEGER_0_15 */
static int hf_lpp_adrSign_r15;                    /* T_adrSign_r15 */
static int hf_lpp_adrRMSerror_r15;                /* INTEGER_0_127 */
static int hf_lpp_delta_codePhase_r15;            /* INTEGER_0_7 */
static int hf_lpp_agnss_List;                     /* GNSS_ID_Bitmap */
static int hf_lpp_ha_GNSS_Metrics_r17;            /* HA_GNSS_Metrics_r17 */
static int hf_lpp_nrOfUsedSatellites_r17;         /* INTEGER_0_64 */
static int hf_lpp_hdopi_r17;                      /* INTEGER_1_256 */
static int hf_lpp_pdopi_r17;                      /* INTEGER_1_256 */
static int hf_lpp_age_r17;                        /* INTEGER_0_99 */
static int hf_lpp_fixType_r17;                    /* T_fixType_r17 */
static int hf_lpp_gnss_PositioningInstructions;   /* GNSS_PositioningInstructions */
static int hf_lpp_gnss_Methods;                   /* GNSS_ID_Bitmap */
static int hf_lpp_fineTimeAssistanceMeasReq;      /* BOOLEAN */
static int hf_lpp_adrMeasReq;                     /* BOOLEAN */
static int hf_lpp_multiFreqMeasReq;               /* BOOLEAN */
static int hf_lpp_ha_GNSS_Req_r15;                /* T_ha_GNSS_Req_r15 */
static int hf_lpp_ha_GNSS_MetricsReq_r17;         /* T_ha_GNSS_MetricsReq_r17 */
static int hf_lpp_gnss_SupportList;               /* GNSS_SupportList */
static int hf_lpp_assistanceDataSupportList;      /* AssistanceDataSupportList */
static int hf_lpp_periodicalReportingNotSupported_r14;  /* PositioningModes */
static int hf_lpp_idleStateForMeasurements_r14_01;  /* T_idleStateForMeasurements_r14_01 */
static int hf_lpp_periodicAssistanceData_r15_01;  /* T_periodicAssistanceData_r15 */
static int hf_lpp_scheduledLocationRequestSupported_r17_01;  /* ScheduledLocationTimeSupportPerMode_r17 */
static int hf_lpp_periodicReportingIntervalMsSupport_r18_01;  /* PeriodicReportingIntervalMsSupportPerMode_r18 */
static int hf_lpp_GNSS_SupportList_item;          /* GNSS_SupportElement */
static int hf_lpp_sbas_IDs;                       /* SBAS_IDs */
static int hf_lpp_agnss_Modes;                    /* PositioningModes */
static int hf_lpp_gnss_Signals;                   /* GNSS_SignalIDs */
static int hf_lpp_fta_MeasSupport;                /* T_fta_MeasSupport */
static int hf_lpp_cellTime;                       /* AccessTypes */
static int hf_lpp_mode_02;                        /* PositioningModes */
static int hf_lpp_adr_Support;                    /* BOOLEAN */
static int hf_lpp_velocityMeasurementSupport;     /* BOOLEAN */
static int hf_lpp_adrEnhancementsSupport_r15;     /* T_adrEnhancementsSupport_r15 */
static int hf_lpp_ha_gnss_Modes_r15;              /* PositioningModes */
static int hf_lpp_ha_gnss_MetricsSupport_r17;     /* T_ha_gnss_MetricsSupport_r17 */
static int hf_lpp_gnss_CommonAssistanceDataSupport;  /* GNSS_CommonAssistanceDataSupport */
static int hf_lpp_gnss_GenericAssistanceDataSupport;  /* GNSS_GenericAssistanceDataSupport */
static int hf_lpp_gnss_ReferenceTimeSupport;      /* GNSS_ReferenceTimeSupport */
static int hf_lpp_gnss_ReferenceLocationSupport;  /* GNSS_ReferenceLocationSupport */
static int hf_lpp_gnss_IonosphericModelSupport;   /* GNSS_IonosphericModelSupport */
static int hf_lpp_gnss_EarthOrientationParametersSupport;  /* GNSS_EarthOrientationParametersSupport */
static int hf_lpp_gnss_RTK_ReferenceStationInfoSupport_r15;  /* GNSS_RTK_ReferenceStationInfoSupport_r15 */
static int hf_lpp_gnss_RTK_AuxiliaryStationDataSupport_r15;  /* GNSS_RTK_AuxiliaryStationDataSupport_r15 */
static int hf_lpp_gnss_Integrity_ServiceParametersSupport_r17;  /* GNSS_Integrity_ServiceParametersSupport_r17 */
static int hf_lpp_gnss_Integrity_ServiceAlertSupport_r17;  /* GNSS_Integrity_ServiceAlertSupport_r17 */
static int hf_lpp_gnss_SSR_IOD_UpdateSupport_r18;  /* GNSS_SSR_IOD_UpdateSupport_r18 */
static int hf_lpp_gnss_SystemTime_01;             /* GNSS_ID_Bitmap */
static int hf_lpp_fta_Support;                    /* AccessTypes */
static int hf_lpp_ionoModel;                      /* T_ionoModel */
static int hf_lpp_GNSS_GenericAssistanceDataSupport_item;  /* GNSS_GenericAssistDataSupportElement */
static int hf_lpp_gnss_TimeModelsSupport;         /* GNSS_TimeModelListSupport */
static int hf_lpp_gnss_DifferentialCorrectionsSupport;  /* GNSS_DifferentialCorrectionsSupport */
static int hf_lpp_gnss_NavigationModelSupport;    /* GNSS_NavigationModelSupport */
static int hf_lpp_gnss_RealTimeIntegritySupport;  /* GNSS_RealTimeIntegritySupport */
static int hf_lpp_gnss_DataBitAssistanceSupport;  /* GNSS_DataBitAssistanceSupport */
static int hf_lpp_gnss_AcquisitionAssistanceSupport;  /* GNSS_AcquisitionAssistanceSupport */
static int hf_lpp_gnss_AlmanacSupport;            /* GNSS_AlmanacSupport */
static int hf_lpp_gnss_UTC_ModelSupport;          /* GNSS_UTC_ModelSupport */
static int hf_lpp_gnss_AuxiliaryInformationSupport;  /* GNSS_AuxiliaryInformationSupport */
static int hf_lpp_bds_DifferentialCorrectionsSupport_r12;  /* BDS_DifferentialCorrectionsSupport_r12 */
static int hf_lpp_bds_GridModelSupport_r12;       /* BDS_GridModelSupport_r12 */
static int hf_lpp_gnss_RTK_ObservationsSupport_r15;  /* GNSS_RTK_ObservationsSupport_r15 */
static int hf_lpp_glo_RTK_BiasInformationSupport_r15;  /* GLO_RTK_BiasInformationSupport_r15 */
static int hf_lpp_gnss_RTK_MAC_CorrectionDifferencesSupport_r15;  /* GNSS_RTK_MAC_CorrectionDifferencesSupport_r15 */
static int hf_lpp_gnss_RTK_ResidualsSupport_r15;  /* GNSS_RTK_ResidualsSupport_r15 */
static int hf_lpp_gnss_RTK_FKP_GradientsSupport_r15;  /* GNSS_RTK_FKP_GradientsSupport_r15 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsSupport_r15;  /* GNSS_SSR_OrbitCorrectionsSupport_r15 */
static int hf_lpp_gnss_SSR_ClockCorrectionsSupport_r15;  /* GNSS_SSR_ClockCorrectionsSupport_r15 */
static int hf_lpp_gnss_SSR_CodeBiasSupport_r15;   /* GNSS_SSR_CodeBiasSupport_r15 */
static int hf_lpp_gnss_SSR_URA_Support_r16;       /* GNSS_SSR_URA_Support_r16 */
static int hf_lpp_gnss_SSR_PhaseBiasSupport_r16;  /* GNSS_SSR_PhaseBiasSupport_r16 */
static int hf_lpp_gnss_SSR_STEC_CorrectionSupport_r16;  /* GNSS_SSR_STEC_CorrectionSupport_r16 */
static int hf_lpp_gnss_SSR_GriddedCorrectionSupport_r16;  /* GNSS_SSR_GriddedCorrectionSupport_r16 */
static int hf_lpp_navic_DifferentialCorrectionsSupport_r16;  /* NavIC_DifferentialCorrectionsSupport_r16 */
static int hf_lpp_navic_GridModelSupport_r16;     /* NavIC_GridModelSupport_r16 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsSet2Support_r17;  /* GNSS_SSR_OrbitCorrectionsSet2Support_r17 */
static int hf_lpp_gnss_SSR_ClockCorrectionsSet2Support_r17;  /* GNSS_SSR_ClockCorrectionsSet2Support_r17 */
static int hf_lpp_gnss_SSR_URA_Set2Support_r17;   /* GNSS_SSR_URA_Set2Support_r17 */
static int hf_lpp_gnss_LOS_NLOS_GriddedIndicationsSupport_r18;  /* GNSS_LOS_NLOS_GriddedIndicationsSupport_r18 */
static int hf_lpp_gnss_SSR_SatellitePCVResidualsSupport_r18;  /* GNSS_SSR_SatellitePCVResidualsSupport_r18 */
static int hf_lpp_gnssSignalIDs;                  /* GNSS_SignalIDs */
static int hf_lpp_dgnss_ValidityTimeSup;          /* BOOLEAN */
static int hf_lpp_clockModel;                     /* T_clockModel */
static int hf_lpp_orbitModel;                     /* T_orbitModel */
static int hf_lpp_confidenceSupport_r10;          /* T_confidenceSupport_r10 */
static int hf_lpp_dopplerUncertaintyExtSupport_r10;  /* T_dopplerUncertaintyExtSupport_r10 */
static int hf_lpp_almanacModel;                   /* T_almanacModel */
static int hf_lpp_utc_Model;                      /* T_utc_Model */
static int hf_lpp_gnssSignalIDs_r15;              /* GNSS_SignalIDs */
static int hf_lpp_link_combinations_support_r15;  /* GNSS_Link_CombinationsList_r15 */
static int hf_lpp_orbit_IntegritySup_r17;         /* T_orbit_IntegritySup_r17 */
static int hf_lpp_clock_IntegrityParameterSupport_r17;  /* T_clock_IntegrityParameterSupport_r17 */
static int hf_lpp_ssr_IntegrityClockBoundsSupport_r17;  /* T_ssr_IntegrityClockBoundsSupport_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Sup_r15;  /* GNSS_SignalIDs */
static int hf_lpp_ssr_IntegrityCodeBiasBoundsSup_r17;  /* T_ssr_IntegrityCodeBiasBoundsSup_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Sup_r16;  /* GNSS_SignalIDs */
static int hf_lpp_ssr_IntegrityPhaseBiasBoundsSup_r17;  /* T_ssr_IntegrityPhaseBiasBoundsSup_r17 */
static int hf_lpp_stec_IntegritySup_r17;          /* T_stec_IntegritySup_r17 */
static int hf_lpp_griddedCorrectionIntegritySup_r17;  /* T_griddedCorrectionIntegritySup_r17 */
static int hf_lpp_gnssSignalIDs_r16;              /* GNSS_SignalIDs */
static int hf_lpp_gnss_SupportListReq;            /* BOOLEAN */
static int hf_lpp_assistanceDataSupportListReq;   /* BOOLEAN */
static int hf_lpp_locationVelocityTypesReq;       /* BOOLEAN */
static int hf_lpp_locationServerErrorCauses_01;   /* GNSS_LocationServerErrorCauses */
static int hf_lpp_targetDeviceErrorCauses_01;     /* GNSS_TargetDeviceErrorCauses */
static int hf_lpp_cause_02;                       /* T_cause_02 */
static int hf_lpp_cause_03;                       /* T_cause_03 */
static int hf_lpp_fineTimeAssistanceMeasurementsNotPossible;  /* NULL */
static int hf_lpp_adrMeasurementsNotPossible;     /* NULL */
static int hf_lpp_multiFrequencyMeasurementsNotPossible;  /* NULL */
static int hf_lpp_remoteUE_Indication_r18;        /* T_remoteUE_Indication_r18 */
static int hf_lpp_gnss_FrequencyID_r15;           /* INTEGER_0_7 */
static int hf_lpp_gnss_id;                        /* T_gnss_id */
static int hf_lpp_gnss_ids;                       /* T_gnss_ids */
static int hf_lpp_GNSS_Link_CombinationsList_r15_item;  /* GNSS_Link_Combinations_r15 */
static int hf_lpp_GNSS_NavListInfo_r15_item;      /* SatListElement_r15 */
static int hf_lpp_networkID_r15_01;               /* INTEGER_0_255 */
static int hf_lpp_deliveryAmount_r15;             /* INTEGER_1_32 */
static int hf_lpp_deliveryInterval_r15;           /* INTEGER_1_64 */
static int hf_lpp_referenceStationID_r15_01;      /* INTEGER_0_65535 */
static int hf_lpp_providerName_r15;               /* VisibleString_SIZE_1_32 */
static int hf_lpp_gnss_SignalID_01;               /* INTEGER_0_7 */
static int hf_lpp_gnss_SignalID_Ext_r15;          /* INTEGER_8_23 */
static int hf_lpp_gnss_SignalIDs;                 /* BIT_STRING_SIZE_8 */
static int hf_lpp_gnss_SignalIDs_Ext_r15;         /* BIT_STRING_SIZE_16 */
static int hf_lpp_subNetworkID_r15_01;            /* INTEGER_0_15 */
static int hf_lpp_sbas_id;                        /* T_sbas_id */
static int hf_lpp_sbas_IDs_01;                    /* T_sbas_IDs */
static int hf_lpp_satellite_id;                   /* INTEGER_0_63 */
static int hf_lpp_ecid_SignalMeasurementInformation;  /* ECID_SignalMeasurementInformation */
static int hf_lpp_ecid_Error;                     /* ECID_Error */
static int hf_lpp_primaryCellMeasuredResults;     /* MeasuredResultsElement */
static int hf_lpp_measuredResultsList;            /* MeasuredResultsList */
static int hf_lpp_MeasuredResultsList_item;       /* MeasuredResultsElement */
static int hf_lpp_arfcnEUTRA;                     /* ARFCN_ValueEUTRA */
static int hf_lpp_rsrp_Result;                    /* INTEGER_0_97 */
static int hf_lpp_rsrq_Result;                    /* INTEGER_0_34 */
static int hf_lpp_ue_RxTxTimeDiff;                /* INTEGER_0_4095 */
static int hf_lpp_arfcnEUTRA_v9a0;                /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_nrsrp_Result_r14;               /* INTEGER_0_113 */
static int hf_lpp_nrsrq_Result_r14;               /* INTEGER_0_74 */
static int hf_lpp_carrierFreqOffsetNB_r14;        /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_rsrp_Result_v1470;              /* INTEGER_M17_M1 */
static int hf_lpp_rsrq_Result_v1470;              /* INTEGER_M30_46 */
static int hf_lpp_requestedMeasurements;          /* T_requestedMeasurements */
static int hf_lpp_ecid_MeasSupported;             /* T_ecid_MeasSupported */
static int hf_lpp_ueRxTxSupTDD_r13;               /* T_ueRxTxSupTDD_r13 */
static int hf_lpp_periodicalReporting_r14_01;     /* T_periodicalReporting_r14_01 */
static int hf_lpp_triggeredReporting_r14;         /* T_triggeredReporting_r14 */
static int hf_lpp_idleStateForMeasurements_r14_02;  /* T_idleStateForMeasurements_r14_02 */
static int hf_lpp_locationServerErrorCauses_02;   /* ECID_LocationServerErrorCauses */
static int hf_lpp_targetDeviceErrorCauses_02;     /* ECID_TargetDeviceErrorCauses */
static int hf_lpp_cause_04;                       /* T_cause_04 */
static int hf_lpp_cause_05;                       /* T_cause_05 */
static int hf_lpp_rsrpMeasurementNotPossible;     /* NULL */
static int hf_lpp_rsrqMeasurementNotPossible;     /* NULL */
static int hf_lpp_ueRxTxMeasurementNotPossible;   /* NULL */
static int hf_lpp_nrsrpMeasurementNotPossible_r14;  /* NULL */
static int hf_lpp_nrsrqMeasurementNotPossible_r14;  /* NULL */
static int hf_lpp_tbs_MeasurementInformation_r13;  /* TBS_MeasurementInformation_r13 */
static int hf_lpp_tbs_Error_r13;                  /* TBS_Error_r13 */
static int hf_lpp_measurementReferenceTime_r13;   /* UTCTime */
static int hf_lpp_mbs_SgnMeasList_r13;            /* MBS_BeaconMeasList_r13 */
static int hf_lpp_MBS_BeaconMeasList_r13_item;    /* MBS_BeaconMeasElement_r13 */
static int hf_lpp_transmitterID_r13;              /* INTEGER_0_32767 */
static int hf_lpp_codePhase_r13;                  /* INTEGER_0_2097151 */
static int hf_lpp_codePhaseRMSError_r13;          /* INTEGER_0_63 */
static int hf_lpp_rssi_r14;                       /* INTEGER_M130_M30 */
static int hf_lpp_mbsSgnMeasListReq_r13;          /* BOOLEAN */
static int hf_lpp_mbsAssistanceAvailability_r14;  /* BOOLEAN */
static int hf_lpp_mbsRequestedMeasurements_r14;   /* T_mbsRequestedMeasurements_r14 */
static int hf_lpp_tbs_Modes_r13;                  /* T_tbs_Modes_r13 */
static int hf_lpp_mbs_AssistanceDataSupportList_r14;  /* MBS_AssistanceDataSupportList_r14 */
static int hf_lpp_periodicalReportingSupported_r14;  /* PositioningModes */
static int hf_lpp_mbs_ConfigSupport_r14;          /* T_mbs_ConfigSupport_r14 */
static int hf_lpp_mbs_IdleStateForMeasurements_r14;  /* T_mbs_IdleStateForMeasurements_r14 */
static int hf_lpp_mbs_AcquisitionAssistanceDataSupport_r14;  /* BOOLEAN */
static int hf_lpp_mbs_AlmanacAssistanceDataSupport_r14;  /* BOOLEAN */
static int hf_lpp_locationServerErrorCauses_r13;  /* TBS_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13;    /* TBS_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13;                      /* T_cause_r13 */
static int hf_lpp_cause_r13_01;                   /* T_cause_r13_01 */
static int hf_lpp_tbs_AssistanceDataList_r14;     /* TBS_AssistanceDataList_r14 */
static int hf_lpp_tbs_Error_r14;                  /* TBS_Error_r13 */
static int hf_lpp_mbs_AssistanceDataList_r14;     /* MBS_AssistanceDataList_r14 */
static int hf_lpp_MBS_AssistanceDataList_r14_item;  /* MBS_AssistanceDataElement_r14 */
static int hf_lpp_mbs_AlmanacAssistance_r14;      /* MBS_AlmanacAssistance_r14 */
static int hf_lpp_mbs_AcquisitionAssistance_r14;  /* MBS_AcquisitionAssistance_r14 */
static int hf_lpp_transmitterID_r14;              /* INTEGER_0_32767 */
static int hf_lpp_transmitterLatitude_r14;        /* T_transmitterLatitude_r14 */
static int hf_lpp_transmitterLongitude_r14;       /* T_transmitterLongitude_r14 */
static int hf_lpp_transmitterAltitude_r14;        /* T_transmitterAltitude_r14 */
static int hf_lpp_timeCorrection_r14;             /* INTEGER_0_25 */
static int hf_lpp_mbsConfiguration_r14;           /* T_mbsConfiguration_r14 */
static int hf_lpp_pnCodeIndex_r14;                /* INTEGER_1_128 */
static int hf_lpp_freq_r14;                       /* INTEGER_919750000_927250000 */
static int hf_lpp_mbs_AlmanacAssistanceDataReq_r14;  /* BOOLEAN */
static int hf_lpp_mbs_AcquisitionAssistanceDataReq_r14;  /* BOOLEAN */
static int hf_lpp_sensor_MeasurementInformation_r13;  /* Sensor_MeasurementInformation_r13 */
static int hf_lpp_sensor_Error_r13;               /* Sensor_Error_r13 */
static int hf_lpp_sensor_MotionInformation_r15;   /* Sensor_MotionInformation_r15 */
static int hf_lpp_uncompensatedBarometricPressure_r13;  /* INTEGER_30000_115000 */
static int hf_lpp_uncertainty_r14;                /* T_uncertainty_r14 */
static int hf_lpp_range_r14;                      /* INTEGER_0_1000 */
static int hf_lpp_confidence_r14;                 /* INTEGER_1_100 */
static int hf_lpp_adjustment_r16;                 /* INTEGER_M5000_5000 */
static int hf_lpp_refTime_r15;                    /* DisplacementTimeStamp_r15 */
static int hf_lpp_displacementInfoList_r15;       /* DisplacementInfoList_r15 */
static int hf_lpp_DisplacementInfoList_r15_item;  /* DisplacementInfoListElement_r15 */
static int hf_lpp_deltaTimeStamp_r15;             /* DeltaTime_r15 */
static int hf_lpp_displacement_r15;               /* Displacement_r15 */
static int hf_lpp_utcTime_r15;                    /* UTC_Time_r15 */
static int hf_lpp_gnssTime_r15;                   /* MeasurementReferenceTime */
static int hf_lpp_systemFrameNumber_r15;          /* SFN_r15 */
static int hf_lpp_measurementSFN_r15;             /* INTEGER_M8192_9214 */
static int hf_lpp_deltaTimeSec_r15;               /* INTEGER_1_16384 */
static int hf_lpp_deltaTimeSFN_r15;               /* INTEGER_1_4096 */
static int hf_lpp_sfn_r15;                        /* BIT_STRING_SIZE_10 */
static int hf_lpp_hyperSFN_r15;                   /* BIT_STRING_SIZE_10 */
static int hf_lpp_bearing_r15;                    /* INTEGER_0_3599 */
static int hf_lpp_bearingUncConfidence_r15;       /* INTEGER_0_100 */
static int hf_lpp_bearingRef_r15;                 /* T_bearingRef_r15 */
static int hf_lpp_horizontalDistance_r15;         /* INTEGER_0_8191 */
static int hf_lpp_horizontalDistanceUnc_r15;      /* INTEGER_0_255 */
static int hf_lpp_horizontalUncConfidence_r15;    /* INTEGER_0_100 */
static int hf_lpp_verticalDirection_r15;          /* T_verticalDirection_r15 */
static int hf_lpp_verticalDistance_r15;           /* INTEGER_0_8191 */
static int hf_lpp_verticalDistanceUnc_r15;        /* INTEGER_0_255 */
static int hf_lpp_verticalUncConfidence_r15;      /* INTEGER_0_100 */
static int hf_lpp_utcTime_r15_01;                 /* UTCTime */
static int hf_lpp_utcTime_ms_r15;                 /* INTEGER_0_999 */
static int hf_lpp_uncompensatedBarometricPressureReq_r13;  /* BOOLEAN */
static int hf_lpp_assistanceAvailability_r14;     /* BOOLEAN */
static int hf_lpp_sensor_MotionInformationReq_r15;  /* BOOLEAN */
static int hf_lpp_adjustmentReq_r16;              /* BOOLEAN */
static int hf_lpp_sensor_Modes_r13;               /* T_sensor_Modes_r13 */
static int hf_lpp_sensor_AssistanceDataSupportList_r14;  /* Sensor_AssistanceDataSupportList_r14 */
static int hf_lpp_idleStateForMeasurements_r14_03;  /* T_idleStateForMeasurements_r14_03 */
static int hf_lpp_sensor_MotionInformationSup_r15;  /* T_sensor_MotionInformationSup_r15 */
static int hf_lpp_adjustmentSupported_r16;        /* T_adjustmentSupported_r16 */
static int hf_lpp_validityPeriodSupported_v1520;  /* T_validityPeriodSupported_v1520 */
static int hf_lpp_validityAreaSupported_v1520;    /* T_validityAreaSupported_v1520 */
static int hf_lpp_locationServerErrorCauses_r13_01;  /* Sensor_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13_01;  /* Sensor_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13_02;                   /* T_cause_r13_02 */
static int hf_lpp_cause_r13_03;                   /* T_cause_r13_03 */
static int hf_lpp_sensor_AssistanceDataList_r14;  /* Sensor_AssistanceDataList_r14 */
static int hf_lpp_sensor_Error_r14;               /* Sensor_Error_r13 */
static int hf_lpp_refPressure_r14;                /* INTEGER_M20000_10000 */
static int hf_lpp_refPosition_r14;                /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_refTemperature_r14;             /* INTEGER_M64_63 */
static int hf_lpp_period_v1520;                   /* T_period_v1520 */
static int hf_lpp_pressureValidityPeriod_v1520;   /* PressureValidityPeriod_v1520 */
static int hf_lpp_referencePressureRate_v1520;    /* INTEGER_M128_127 */
static int hf_lpp_area_v1520;                     /* T_area_v1520 */
static int hf_lpp_pressureValidityArea_v1520;     /* PressureValidityArea_v1520 */
static int hf_lpp_gN_pressure_v1520;              /* T_gN_pressure_v1520 */
static int hf_lpp_gE_pressure_v1520;              /* T_gE_pressure_v1520 */
static int hf_lpp_centerPoint_v1520;              /* Ellipsoid_Point */
static int hf_lpp_validityAreaWidth_v1520;        /* INTEGER_1_128 */
static int hf_lpp_validityAreaHeight_v1520;       /* INTEGER_1_128 */
static int hf_lpp_beginTime_v1520;                /* GNSS_SystemTime */
static int hf_lpp_beginTimeAlt_v1520;             /* INTEGER_0_2881 */
static int hf_lpp_duration_v1520;                 /* INTEGER_1_2881 */
static int hf_lpp_wlan_MeasurementInformation_r13;  /* WLAN_MeasurementInformation_r13 */
static int hf_lpp_wlan_Error_r13;                 /* WLAN_Error_r13 */
static int hf_lpp_wlan_MeasurementList_r13;       /* WLAN_MeasurementList_r13 */
static int hf_lpp_WLAN_MeasurementList_r13_item;  /* WLAN_MeasurementElement_r13 */
static int hf_lpp_wlan_AP_Identifier_r13;         /* WLAN_AP_Identifier_r13 */
static int hf_lpp_rssi_r13;                       /* INTEGER_M127_128 */
static int hf_lpp_rtt_r13;                        /* WLAN_RTT_r13 */
static int hf_lpp_apChannelFrequency_r13;         /* INTEGER_0_256 */
static int hf_lpp_servingFlag_r13;                /* BOOLEAN */
static int hf_lpp_bssid_r13;                      /* OCTET_STRING_SIZE_6 */
static int hf_lpp_ssid_r13;                       /* T_ssid_r13 */
static int hf_lpp_rttValue_r13;                   /* INTEGER_0_16777215 */
static int hf_lpp_rttUnits_r13;                   /* T_rttUnits_r13 */
static int hf_lpp_rttAccuracy_r13;                /* INTEGER_0_255 */
static int hf_lpp_requestedMeasurements_r13;      /* T_requestedMeasurements_r13 */
static int hf_lpp_wlan_Modes_r13;                 /* T_wlan_Modes_r13 */
static int hf_lpp_wlan_MeasSupported_r13;         /* T_wlan_MeasSupported_r13 */
static int hf_lpp_wlan_AP_AD_Supported_r14;       /* T_wlan_AP_AD_Supported_r14 */
static int hf_lpp_idleStateForMeasurements_r14_04;  /* T_idleStateForMeasurements_r14_04 */
static int hf_lpp_locationServerErrorCauses_r13_02;  /* WLAN_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13_02;  /* WLAN_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13_04;                   /* T_cause_r13_04 */
static int hf_lpp_apLocationDataUnavailable_r14;  /* NULL */
static int hf_lpp_cause_r13_05;                   /* T_cause_r13_05 */
static int hf_lpp_wlan_AP_RSSI_MeasurementNotPossible_r13;  /* NULL */
static int hf_lpp_wlan_AP_RTT_MeasurementNotPossible_r13;  /* NULL */
static int hf_lpp_wlan_DataSet_r14;               /* SEQUENCE_SIZE_1_maxWLAN_DataSets_r14_OF_WLAN_DataSet_r14 */
static int hf_lpp_wlan_DataSet_r14_item;          /* WLAN_DataSet_r14 */
static int hf_lpp_wlan_Error_r14;                 /* WLAN_Error_r13 */
static int hf_lpp_wlan_AP_List_r14;               /* SEQUENCE_SIZE_1_maxWLAN_AP_r14_OF_WLAN_AP_Data_r14 */
static int hf_lpp_wlan_AP_List_r14_item;          /* WLAN_AP_Data_r14 */
static int hf_lpp_supportedChannels_11a_r14;      /* SupportedChannels_11a_r14 */
static int hf_lpp_supportedChannels_11bg_r14;     /* SupportedChannels_11bg_r14 */
static int hf_lpp_ch34_r14;                       /* BOOLEAN */
static int hf_lpp_ch36_r14;                       /* BOOLEAN */
static int hf_lpp_ch38_r14;                       /* BOOLEAN */
static int hf_lpp_ch40_r14;                       /* BOOLEAN */
static int hf_lpp_ch42_r14;                       /* BOOLEAN */
static int hf_lpp_ch44_r14;                       /* BOOLEAN */
static int hf_lpp_ch46_r14;                       /* BOOLEAN */
static int hf_lpp_ch48_r14;                       /* BOOLEAN */
static int hf_lpp_ch52_r14;                       /* BOOLEAN */
static int hf_lpp_ch56_r14;                       /* BOOLEAN */
static int hf_lpp_ch60_r14;                       /* BOOLEAN */
static int hf_lpp_ch64_r14;                       /* BOOLEAN */
static int hf_lpp_ch149_r14;                      /* BOOLEAN */
static int hf_lpp_ch153_r14;                      /* BOOLEAN */
static int hf_lpp_ch157_r14;                      /* BOOLEAN */
static int hf_lpp_ch161_r14;                      /* BOOLEAN */
static int hf_lpp_ch1_r14;                        /* BOOLEAN */
static int hf_lpp_ch2_r14;                        /* BOOLEAN */
static int hf_lpp_ch3_r14;                        /* BOOLEAN */
static int hf_lpp_ch4_r14;                        /* BOOLEAN */
static int hf_lpp_ch5_r14;                        /* BOOLEAN */
static int hf_lpp_ch6_r14;                        /* BOOLEAN */
static int hf_lpp_ch7_r14;                        /* BOOLEAN */
static int hf_lpp_ch8_r14;                        /* BOOLEAN */
static int hf_lpp_ch9_r14;                        /* BOOLEAN */
static int hf_lpp_ch10_r14;                       /* BOOLEAN */
static int hf_lpp_ch11_r14;                       /* BOOLEAN */
static int hf_lpp_ch12_r14;                       /* BOOLEAN */
static int hf_lpp_ch13_r14;                       /* BOOLEAN */
static int hf_lpp_ch14_r14;                       /* BOOLEAN */
static int hf_lpp_wlan_AP_Identifier_r14;         /* WLAN_AP_Identifier_r13 */
static int hf_lpp_wlan_AP_Location_r14;           /* WLAN_AP_Location_r14 */
static int hf_lpp_locationDataLCI_r14;            /* LocationDataLCI_r14 */
static int hf_lpp_latitudeUncertainty_r14;        /* BIT_STRING_SIZE_6 */
static int hf_lpp_latitude_r14;                   /* BIT_STRING_SIZE_34 */
static int hf_lpp_longitudeUncertainty_r14;       /* BIT_STRING_SIZE_6 */
static int hf_lpp_longitude_r14;                  /* BIT_STRING_SIZE_34 */
static int hf_lpp_altitudeUncertainty_r14;        /* BIT_STRING_SIZE_6 */
static int hf_lpp_altitude_r14;                   /* BIT_STRING_SIZE_30 */
static int hf_lpp_datum_r14;                      /* BIT_STRING_SIZE_8 */
static int hf_lpp_requestedAD_r14;                /* T_requestedAD_r14 */
static int hf_lpp_visibleAPs_r14;                 /* SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13 */
static int hf_lpp_visibleAPs_r14_item;            /* WLAN_AP_Identifier_r13 */
static int hf_lpp_wlan_AP_StoredData_r14;         /* SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13 */
static int hf_lpp_wlan_AP_StoredData_r14_item;    /* WLAN_AP_Identifier_r13 */
static int hf_lpp_bt_MeasurementInformation_r13;  /* BT_MeasurementInformation_r13 */
static int hf_lpp_bt_Error_r13;                   /* BT_Error_r13 */
static int hf_lpp_bt_AoA_Config_r18;              /* BT_AoA_Config_r18 */
static int hf_lpp_bt_Addr_r18;                    /* BIT_STRING_SIZE_48 */
static int hf_lpp_cte_Status_r18;                 /* T_cte_Status_r18 */
static int hf_lpp_primaryAdvInterval_r18;         /* INTEGER_32_16777 */
static int hf_lpp_secondAdvInterval_r18;          /* INTEGER_6_65535 */
static int hf_lpp_tx_Power_r18;                   /* INTEGER_M127_20 */
static int hf_lpp_cte_Length_r18;                 /* INTEGER_2_20 */
static int hf_lpp_cte_Count_r18;                  /* INTEGER_1_16 */
static int hf_lpp_tx_PHY_M2_r18;                  /* T_tx_PHY_M2_r18 */
static int hf_lpp_bt_MeasurementList_r13;         /* BT_MeasurementList_r13 */
static int hf_lpp_bt_MeasurementList_r18;         /* BT_MeasurementList_r18 */
static int hf_lpp_BT_MeasurementList_r13_item;    /* BT_MeasurementElement_r13 */
static int hf_lpp_btAddr_r13;                     /* T_btAddr_r13 */
static int hf_lpp_rssi_r13_01;                    /* INTEGER_M128_127 */
static int hf_lpp_BT_MeasurementList_r18_item;    /* BT_MeasurementElement_r18 */
static int hf_lpp_btAddr_r18;                     /* BIT_STRING_SIZE_48 */
static int hf_lpp_bt_azimuth_r18;                 /* INTEGER_0_359 */
static int hf_lpp_bt_elevation_r18;               /* INTEGER_0_180 */
static int hf_lpp_rssi_r18;                       /* INTEGER_M128_127 */
static int hf_lpp_requestedMeasurements_r13_01;   /* T_requestedMeasurements_r13_01 */
static int hf_lpp_bt_requestedAoA_Config_r18;     /* T_bt_requestedAoA_Config_r18 */
static int hf_lpp_bt_suggestedAoA_Config_r18;     /* BT_SuggestedAoA_Config_r18 */
static int hf_lpp_cte_Status_r18_01;              /* T_cte_Status_r18_01 */
static int hf_lpp_tx_PHY_M2_r18_01;               /* T_tx_PHY_M2_r18_01 */
static int hf_lpp_bt_Modes_r13;                   /* T_bt_Modes_r13 */
static int hf_lpp_bt_MeasSupported_r13;           /* T_bt_MeasSupported_r13 */
static int hf_lpp_idleStateForMeasurements_r14_05;  /* T_idleStateForMeasurements_r14_05 */
static int hf_lpp_bt_AoA_r18;                     /* T_bt_AoA_r18 */
static int hf_lpp_locationServerErrorCauses_r13_03;  /* BT_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13_03;  /* BT_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13_06;                   /* T_cause_r13_06 */
static int hf_lpp_cause_r13_07;                   /* T_cause_r13_07 */
static int hf_lpp_bt_Beacon_rssiMeasurementNotPossible_r13;  /* NULL */
static int hf_lpp_bt_BeaconInfo_r18;              /* BT_BeaconInfo_r18 */
static int hf_lpp_bt_Error_r18;                   /* BT_Error_r13 */
static int hf_lpp_referencePoint_r18;             /* ReferencePoint_r16 */
static int hf_lpp_bt_BeaconInfoList_r18;          /* SEQUENCE_SIZE_1_maxBT_BeaconAD_r18_OF_BT_BeaconInfoElement_r18 */
static int hf_lpp_bt_BeaconInfoList_r18_item;     /* BT_BeaconInfoElement_r18 */
static int hf_lpp_bt_BeaconLocation_r18;          /* RelativeLocation_r16 */
static int hf_lpp_bt_LCS_GCS_TranslationParameter_r18;  /* LCS_GCS_TranslationParameter_r16 */
static int hf_lpp_bt_antArrayConfig_r18;          /* BT_AntArrayConfig_r18 */
static int hf_lpp_bt_antElementList_r18;          /* SEQUENCE_SIZE_2_maxBT_BeaconAntElt_r18_OF_BT_AntElement_r18 */
static int hf_lpp_bt_antElementList_r18_item;     /* BT_AntElement_r18 */
static int hf_lpp_bt_antSwitchingPattern_r18;     /* SEQUENCE_SIZE_2_maxBT_BeaconAntElt_r18_OF_BT_AntSwitchElement_r18 */
static int hf_lpp_bt_antSwitchingPattern_r18_item;  /* BT_AntSwitchElement_r18 */
static int hf_lpp_bt_AoD_TransmConfig_r18;        /* BT_AoD_TransmConfig_r18 */
static int hf_lpp_bt_UniformLinearArray_r18;      /* BT_UniformLinearArray_r18 */
static int hf_lpp_bt_UniformRectangularArray_r18;  /* BT_UniformRectangularArray_r18 */
static int hf_lpp_bt_UniformCircularArray_r18;    /* BT_UniformCircularArray_r18 */
static int hf_lpp_bt_GenericArray_r18;            /* BT_GenericArray_r18 */
static int hf_lpp_polarization_r18;               /* T_polarization_r18 */
static int hf_lpp_antElementIndexShort_r18;       /* INTEGER_1_16 */
static int hf_lpp_antElementIndexOffset_r18;      /* T_antElementIndexOffset_r18 */
static int hf_lpp_cte_Type2us_r18;                /* T_cte_Type2us_r18 */
static int hf_lpp_tx_PHY_M2_r18_02;               /* T_tx_PHY_M2_r18_02 */
static int hf_lpp_bt_NoElements_r18;              /* INTEGER_2_maxBT_BeaconAntElt_r18 */
static int hf_lpp_bt_InterElementDist_r18;        /* INTEGER_30_130 */
static int hf_lpp_bt_NoElementsY_r18;             /* INTEGER_1_maxBT_BeaconAntElt_r18 */
static int hf_lpp_bt_NoElementsZ_r18;             /* INTEGER_1_maxBT_BeaconAntElt_r18 */
static int hf_lpp_bt_InterElementDistY_r18;       /* INTEGER_30_135 */
static int hf_lpp_bt_InterElementDistZ_r18;       /* INTEGER_30_135 */
static int hf_lpp_BT_GenericArray_r18_item;       /* BT_ULA_GenericAntElement_r18 */
static int hf_lpp_deltaY_r18;                     /* INTEGER_M135_135 */
static int hf_lpp_deltaX_r18;                     /* INTEGER_M135_135 */
static int hf_lpp_deltaZ_r18;                     /* INTEGER_M135_135 */
static int hf_lpp_requestedAD_r18;                /* T_requestedAD_r18 */
static int hf_lpp_nr_UL_SRS_Capability_r16;       /* NR_UL_SRS_Capability_r16 */
static int hf_lpp_nr_UE_TEG_Capability_r17;       /* NR_UE_TEG_Capability_r17 */
static int hf_lpp_nr_ECID_SignalMeasurementInformation_r16;  /* NR_ECID_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_ECID_Error_r16;              /* NR_ECID_Error_r16 */
static int hf_lpp_nr_PrimaryCellMeasuredResults_r16;  /* NR_MeasuredResultsElement_r16 */
static int hf_lpp_nr_MeasuredResultsList_r16;     /* NR_MeasuredResultsList_r16 */
static int hf_lpp_NR_MeasuredResultsList_r16_item;  /* NR_MeasuredResultsElement_r16 */
static int hf_lpp_nr_ARFCN_r16_01;                /* T_nr_ARFCN_r16 */
static int hf_lpp_ssb_ARFCN_r16;                  /* ARFCN_ValueNR_r15 */
static int hf_lpp_csi_RS_pointA_r16;              /* ARFCN_ValueNR_r15 */
static int hf_lpp_resultsSSB_Cell_r16;            /* MeasQuantityResults_r16 */
static int hf_lpp_resultsCSI_RS_Cell_r16;         /* MeasQuantityResults_r16 */
static int hf_lpp_resultsSSB_Indexes_r16;         /* ResultsPerSSB_IndexList_r16 */
static int hf_lpp_resultsCSI_RS_Indexes_r16;      /* ResultsPerCSI_RS_IndexList_r16 */
static int hf_lpp_nr_RSRP_r16;                    /* INTEGER_0_127 */
static int hf_lpp_nr_RSRQ_r16;                    /* INTEGER_0_127 */
static int hf_lpp_ResultsPerSSB_IndexList_r16_item;  /* ResultsPerSSB_Index_r16 */
static int hf_lpp_ssb_Results_r16;                /* MeasQuantityResults_r16 */
static int hf_lpp_ResultsPerCSI_RS_IndexList_r16_item;  /* ResultsPerCSI_RS_Index_r16 */
static int hf_lpp_csi_RS_Index_r16;               /* INTEGER_0_95 */
static int hf_lpp_csi_RS_Results_r16;             /* MeasQuantityResults_r16 */
static int hf_lpp_requestedMeasurements_r16;      /* T_requestedMeasurements_r16 */
static int hf_lpp_nr_ECID_MeasSupported_r16;      /* T_nr_ECID_MeasSupported_r16 */
static int hf_lpp_periodicalReporting_r16;        /* T_periodicalReporting_r16 */
static int hf_lpp_triggeredReporting_r16;         /* T_triggeredReporting_r16 */
static int hf_lpp_ten_ms_unit_ResponseTime_r17;   /* T_ten_ms_unit_ResponseTime_r17 */
static int hf_lpp_locationServerErrorCauses_r16;  /* NR_ECID_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16;    /* NR_ECID_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16;                      /* T_cause_r16 */
static int hf_lpp_cause_r16_01;                   /* T_cause_r16_01 */
static int hf_lpp_ss_RSRPMeasurementNotPossible_r16;  /* NULL */
static int hf_lpp_ss_RSRQMeasurementNotPossible_r16;  /* NULL */
static int hf_lpp_csi_RSRPMeasurementNotPossible_r16;  /* NULL */
static int hf_lpp_csi_RSRQMeasurementNotPossible_r16;  /* NULL */
static int hf_lpp_remoteUE_Indication_r18_01;     /* T_remoteUE_Indication_r18_01 */
static int hf_lpp_nr_DL_PRS_AssistanceData_r16;   /* NR_DL_PRS_AssistanceData_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexList_r16;  /* NR_SelectedDL_PRS_IndexList_r16 */
static int hf_lpp_nr_PositionCalculationAssistance_r16;  /* NR_PositionCalculationAssistance_r16 */
static int hf_lpp_nr_DL_TDOA_Error_r16;           /* NR_DL_TDOA_Error_r16 */
static int hf_lpp_nr_On_Demand_DL_PRS_Configurations_r17;  /* NR_On_Demand_DL_PRS_Configurations_r17 */
static int hf_lpp_nr_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17;  /* NR_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17 */
static int hf_lpp_assistanceDataValidityArea_r17;  /* AreaID_CellList_r17 */
static int hf_lpp_nr_PeriodicAssistData_r18;      /* NR_PeriodicAssistData_r18 */
static int hf_lpp_nr_AdType_r16;                  /* T_nr_AdType_r16 */
static int hf_lpp_nr_PosCalcAssistanceRequest_r17;  /* T_nr_PosCalcAssistanceRequest_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_Request_r17;  /* NR_On_Demand_DL_PRS_Request_r17 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17 */
static int hf_lpp_pre_configured_AssistanceDataRequest_r17;  /* T_pre_configured_AssistanceDataRequest_r17 */
static int hf_lpp_nr_PeriodicAssistDataReq_r18;   /* NR_PeriodicAssistDataReq_r18 */
static int hf_lpp_nr_IntegrityAssistanceRequest_r18;  /* T_nr_IntegrityAssistanceRequest_r18 */
static int hf_lpp_nr_DL_TDOA_SignalMeasurementInformation_r16;  /* NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_dl_tdoa_LocationInformation_r16;  /* NR_DL_TDOA_LocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_SignalMeasurementInstances_r17;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_TDOA_SignalMeasurementInstances_r17_item;  /* NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_TDOA_LocationInformationInstances_r17;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_LocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_LocationInformationInstances_r17_item;  /* NR_DL_TDOA_LocationInformation_r16 */
static int hf_lpp_dl_PRS_ReferenceInfo_r16;       /* DL_PRS_ID_Info_r16 */
static int hf_lpp_nr_DL_TDOA_MeasList_r16;        /* NR_DL_TDOA_MeasList_r16 */
static int hf_lpp_nr_UE_RxTEG_TimingErrorMargin_r17;  /* TEG_TimingErrorMargin_r17 */
static int hf_lpp_NR_DL_TDOA_MeasList_r16_item;   /* NR_DL_TDOA_MeasElement_r16 */
static int hf_lpp_nr_TimeStamp_r16;               /* NR_TimeStamp_r16 */
static int hf_lpp_nr_RSTD_r16;                    /* T_nr_RSTD_r16 */
static int hf_lpp_k0_r16_01;                      /* INTEGER_0_1970049 */
static int hf_lpp_k1_r16_01;                      /* INTEGER_0_985025 */
static int hf_lpp_k2_r16_01;                      /* INTEGER_0_492513 */
static int hf_lpp_k3_r16_01;                      /* INTEGER_0_246257 */
static int hf_lpp_k4_r16_01;                      /* INTEGER_0_123129 */
static int hf_lpp_k5_r16_01;                      /* INTEGER_0_61565 */
static int hf_lpp_kMinus6_r18_01;                 /* INTEGER_0_126083073 */
static int hf_lpp_kMinus5_r18_01;                 /* INTEGER_0_63041537 */
static int hf_lpp_kMinus4_r18_01;                 /* INTEGER_0_31520769 */
static int hf_lpp_kMinus3_r18_01;                 /* INTEGER_0_15760385 */
static int hf_lpp_kMinus2_r18_01;                 /* INTEGER_0_7880193 */
static int hf_lpp_kMinus1_r18_01;                 /* INTEGER_0_3940097 */
static int hf_lpp_nr_AdditionalPathList_r16;      /* NR_AdditionalPathList_r16 */
static int hf_lpp_nr_TimingQuality_r16;           /* NR_TimingQuality_r16 */
static int hf_lpp_nr_DL_PRS_RSRP_Result_r16;      /* INTEGER_0_126 */
static int hf_lpp_nr_DL_TDOA_AdditionalMeasurements_r16;  /* NR_DL_TDOA_AdditionalMeasurements_r16 */
static int hf_lpp_nr_UE_Rx_TEG_ID_r17;            /* INTEGER_0_maxNumOfRxTEGs_1_r17 */
static int hf_lpp_nr_DL_PRS_FirstPathRSRP_Result_r17;  /* INTEGER_0_126 */
static int hf_lpp_nr_los_nlos_Indicator_r17;      /* T_nr_los_nlos_Indicator_r17 */
static int hf_lpp_perTRP_r17;                     /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_perResource_r17_01;             /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_nr_AdditionalPathListExt_r17;   /* NR_AdditionalPathListExt_r17 */
static int hf_lpp_nr_DL_TDOA_AdditionalMeasurementsExt_r17;  /* NR_DL_TDOA_AdditionalMeasurementsExt_r17 */
static int hf_lpp_nr_MeasBasedOnAggregatedResources_r18;  /* T_nr_MeasBasedOnAggregatedResources_r18 */
static int hf_lpp_nr_AggregatedDL_PRS_ResourceInfo_List_r18;  /* SEQUENCE_SIZE_2_3_OF_NR_AggregatedDL_PRS_ResourceInfo_Element_r18 */
static int hf_lpp_nr_AggregatedDL_PRS_ResourceInfo_List_r18_item;  /* NR_AggregatedDL_PRS_ResourceInfo_Element_r18 */
static int hf_lpp_nr_RSCPD_r18;                   /* INTEGER_0_3599 */
static int hf_lpp_nr_RSCPD_AddMeasurementSamples_r18;  /* SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCPD_AdditionalMeasurementSamplesElement_r18 */
static int hf_lpp_nr_RSCPD_AddMeasurementSamples_r18_item;  /* NR_RSCPD_AdditionalMeasurementSamplesElement_r18 */
static int hf_lpp_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18;  /* T_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18 */
static int hf_lpp_NR_DL_TDOA_AdditionalMeasurements_r16_item;  /* NR_DL_TDOA_AdditionalMeasurementElement_r16 */
static int hf_lpp_NR_DL_TDOA_AdditionalMeasurementsExt_r17_item;  /* NR_DL_TDOA_AdditionalMeasurementElement_r16 */
static int hf_lpp_nr_RSTD_ResultDiff_r16;         /* T_nr_RSTD_ResultDiff_r16 */
static int hf_lpp_k0_r16_02;                      /* INTEGER_0_8191 */
static int hf_lpp_k1_r16_02;                      /* INTEGER_0_4095 */
static int hf_lpp_k2_r16_02;                      /* INTEGER_0_2047 */
static int hf_lpp_k3_r16_02;                      /* INTEGER_0_1023 */
static int hf_lpp_k4_r16_02;                      /* INTEGER_0_511 */
static int hf_lpp_k5_r16_02;                      /* INTEGER_0_255 */
static int hf_lpp_kMinus6_r18_02;                 /* INTEGER_0_524224 */
static int hf_lpp_kMinus5_r18_02;                 /* INTEGER_0_262112 */
static int hf_lpp_kMinus4_r18_02;                 /* INTEGER_0_131056 */
static int hf_lpp_kMinus3_r18_02;                 /* INTEGER_0_65528 */
static int hf_lpp_kMinus2_r18_02;                 /* INTEGER_0_32764 */
static int hf_lpp_kMinus1_r18_02;                 /* INTEGER_0_16382 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r16;  /* INTEGER_0_61 */
static int hf_lpp_nr_DL_PRS_FirstPathRSRP_ResultDiff_r17;  /* INTEGER_0_61 */
static int hf_lpp_nr_los_nlos_IndicatorPerResource_r17;  /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_nr_MeasBasedOnAggregatedResources_r18_01;  /* T_nr_MeasBasedOnAggregatedResources_r18_01 */
static int hf_lpp_nr_RSCPD_AdditionalMeasurementsAddSamples_r18;  /* SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCPD_AdditionalMeasurementSamplesElement_r18 */
static int hf_lpp_nr_RSCPD_AdditionalMeasurementsAddSamples_r18_item;  /* NR_RSCPD_AdditionalMeasurementSamplesElement_r18 */
static int hf_lpp_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_01;  /* T_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_01 */
static int hf_lpp_measurementReferenceTime_r16;   /* T_measurementReferenceTime_r16 */
static int hf_lpp_systemFrameNumber_r16_01;       /* NR_TimeStamp_r16 */
static int hf_lpp_utc_time_r16;                   /* UTCTime */
static int hf_lpp_locationCoordinates_r17;        /* LocationCoordinates */
static int hf_lpp_locationSource_r17;             /* LocationSource_r13 */
static int hf_lpp_nr_DL_PRS_RstdMeasurementInfoRequest_r16;  /* T_nr_DL_PRS_RstdMeasurementInfoRequest_r16 */
static int hf_lpp_nr_RequestedMeasurements_r16;   /* T_nr_RequestedMeasurements_r16 */
static int hf_lpp_nr_AssistanceAvailability_r16;  /* BOOLEAN */
static int hf_lpp_nr_DL_TDOA_ReportConfig_r16;    /* NR_DL_TDOA_ReportConfig_r16 */
static int hf_lpp_additionalPaths_r16;            /* T_additionalPaths_r16 */
static int hf_lpp_nr_UE_RxTEG_Request_r17;        /* T_nr_UE_RxTEG_Request_r17 */
static int hf_lpp_nr_los_nlos_IndicatorRequest_r17;  /* T_nr_los_nlos_IndicatorRequest_r17 */
static int hf_lpp_type_r17;                       /* LOS_NLOS_IndicatorType1_r17 */
static int hf_lpp_granularity_r17;                /* LOS_NLOS_IndicatorGranularity1_r17 */
static int hf_lpp_additionalPathsExt_r17;         /* T_additionalPathsExt_r17 */
static int hf_lpp_additionalPathsDL_PRS_RSRP_Request_r17;  /* T_additionalPathsDL_PRS_RSRP_Request_r17 */
static int hf_lpp_multiMeasInSameReport_r17;      /* T_multiMeasInSameReport_r17 */
static int hf_lpp_nr_DL_PRS_JointMeasurementRequest_r18;  /* T_nr_DL_PRS_JointMeasurementRequest_r18 */
static int hf_lpp_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18;  /* T_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18 */
static int hf_lpp_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18_item;  /* INTEGER_0_nrMaxFreqLayers_1_r16 */
static int hf_lpp_nr_DL_PRS_RxHoppingRequest_r18;  /* T_nr_DL_PRS_RxHoppingRequest_r18 */
static int hf_lpp_nr_DL_PRS_RxHoppingTotalBandwidth_r18;  /* T_nr_DL_PRS_RxHoppingTotalBandwidth_r18 */
static int hf_lpp_fr1_02;                         /* T_fr1_02 */
static int hf_lpp_fr2_02;                         /* T_fr2_02 */
static int hf_lpp_maxDL_PRS_RSTD_MeasurementsPerTRP_Pair_r16;  /* INTEGER_1_4 */
static int hf_lpp_timingReportingGranularityFactor_r16;  /* INTEGER_0_5 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_01;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_01 */
static int hf_lpp_reducedDL_PRS_ProcessingSamples_r17;  /* T_reducedDL_PRS_ProcessingSamples_r17 */
static int hf_lpp_lowerRxBeamSweepingFactor_FR2_r17;  /* T_lowerRxBeamSweepingFactor_FR2_r17 */
static int hf_lpp_timingReportingGranularityFactorExt_r18;  /* INTEGER_M6_M1 */
static int hf_lpp_nr_DL_PRS_MeasurementTimeWindowsConfig_r18;  /* NR_DL_PRS_MeasurementTimeWindowsConfig_r18 */
static int hf_lpp_nr_DL_TDOA_Mode_r16;            /* PositioningModes */
static int hf_lpp_nr_DL_TDOA_PRS_Capability_r16;  /* NR_DL_PRS_ResourcesCapability_r16 */
static int hf_lpp_nr_DL_TDOA_MeasurementCapability_r16;  /* NR_DL_TDOA_MeasurementCapability_r16 */
static int hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16;  /* NR_DL_PRS_QCL_ProcessingCapability_r16 */
static int hf_lpp_nr_DL_PRS_ProcessingCapability_r16;  /* NR_DL_PRS_ProcessingCapability_r16 */
static int hf_lpp_additionalPathsReport_r16;      /* T_additionalPathsReport_r16 */
static int hf_lpp_periodicalReporting_r16_01;     /* PositioningModes */
static int hf_lpp_ten_ms_unit_ResponseTime_r17_01;  /* PositioningModes */
static int hf_lpp_nr_PosCalcAssistanceSupport_r17;  /* T_nr_PosCalcAssistanceSupport_r17 */
static int hf_lpp_nr_los_nlos_AssistanceDataSupport_r17;  /* T_nr_los_nlos_AssistanceDataSupport_r17 */
static int hf_lpp_type_r17_01;                    /* LOS_NLOS_IndicatorType2_r17 */
static int hf_lpp_granularity_r17_01;             /* LOS_NLOS_IndicatorGranularity2_r17 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17 */
static int hf_lpp_nr_DL_TDOA_On_Demand_DL_PRS_Support_r17;  /* NR_On_Demand_DL_PRS_Support_r17 */
static int hf_lpp_nr_los_nlos_IndicatorSupport_r17;  /* T_nr_los_nlos_IndicatorSupport_r17 */
static int hf_lpp_additionalPathsExtSupport_r17;  /* T_additionalPathsExtSupport_r17 */
static int hf_lpp_nr_dl_prs_AssistanceDataValidity_r17;  /* T_nr_dl_prs_AssistanceDataValidity_r17 */
static int hf_lpp_area_validity_r17;              /* INTEGER_1_maxNrOfAreas_r17 */
static int hf_lpp_multiMeasInSameMeasReport_r17;  /* T_multiMeasInSameMeasReport_r17 */
static int hf_lpp_mg_ActivationRequest_r17;       /* T_mg_ActivationRequest_r17 */
static int hf_lpp_posMeasGapSupport_r17;          /* T_posMeasGapSupport_r17 */
static int hf_lpp_multiLocationEstimateInSameMeasReport_r17;  /* T_multiLocationEstimateInSameMeasReport_r17 */
static int hf_lpp_locationCoordinateTypes_r18;    /* LocationCoordinateTypes */
static int hf_lpp_periodicAssistanceData_r18;     /* T_periodicAssistanceData_r18 */
static int hf_lpp_nr_IntegrityAssistanceSupport_r18;  /* T_nr_IntegrityAssistanceSupport_r18 */
static int hf_lpp_nr_DL_TDOA_OnDemandPRS_ForBWA_Support_r18;  /* T_nr_DL_TDOA_OnDemandPRS_ForBWA_Support_r18 */
static int hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR1_r16;  /* INTEGER_1_4 */
static int hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR2_r16;  /* INTEGER_1_4 */
static int hf_lpp_supportOfDL_PRS_RSRP_MeasFR1_r16;  /* T_supportOfDL_PRS_RSRP_MeasFR1_r16 */
static int hf_lpp_supportOfDL_PRS_RSRP_MeasFR2_r16;  /* T_supportOfDL_PRS_RSRP_MeasFR2_r16 */
static int hf_lpp_dl_tdoa_MeasCapabilityBandList_r17;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17 */
static int hf_lpp_dl_tdoa_MeasCapabilityBandList_r17_item;  /* DL_TDOA_MeasCapabilityPerBand_r17 */
static int hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17;  /* T_supportOfDL_PRS_FirstPathRSRP_r17 */
static int hf_lpp_dl_PRS_MeasRRC_Inactive_r17;    /* T_dl_PRS_MeasRRC_Inactive_r17 */
static int hf_lpp_supportOfDL_PRS_BWA_RRC_Connected_r18;  /* T_supportOfDL_PRS_BWA_RRC_Connected_r18 */
static int hf_lpp_supportOfDL_PRS_BWA_RRC_Inactive_r18;  /* T_supportOfDL_PRS_BWA_RRC_Inactive_r18 */
static int hf_lpp_supportOfDL_PRS_BWA_RRC_Idle_r18;  /* T_supportOfDL_PRS_BWA_RRC_Idle_r18 */
static int hf_lpp_nr_DL_PRS_RSCPD_RRC_Connected_r18;  /* T_nr_DL_PRS_RSCPD_RRC_Connected_r18 */
static int hf_lpp_assocSingleRSTD_WithUpToNsampleRSCPD_r18;  /* T_assocSingleRSTD_WithUpToNsampleRSCPD_r18 */
static int hf_lpp_nr_DL_PRS_RSCPD_MeasurementRRC_Idle_r18;  /* T_nr_DL_PRS_RSCPD_MeasurementRRC_Idle_r18 */
static int hf_lpp_supportOfUE_basedCarrierPhasePositioning_r18;  /* T_supportOfUE_basedCarrierPhasePositioning_r18 */
static int hf_lpp_supportOfSymbolTimeStampForRSCPD_r18;  /* T_supportOfSymbolTimeStampForRSCPD_r18 */
static int hf_lpp_supportOfFinerTimingReportGranularityForPRS_Meas_r18;  /* T_supportOfFinerTimingReportGranularityForPRS_Meas_r18 */
static int hf_lpp_supportOfMeasurementsInTimeWindow_r18;  /* T_supportOfMeasurementsInTimeWindow_r18 */
static int hf_lpp_supportOfPRS_MeasurementRRC_Idle_r18;  /* T_supportOfPRS_MeasurementRRC_Idle_r18 */
static int hf_lpp_nr_DL_PRS_RSCPD_RRC_Inactive_r18;  /* T_nr_DL_PRS_RSCPD_RRC_Inactive_r18 */
static int hf_lpp_locationServerErrorCauses_r16_01;  /* NR_DL_TDOA_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16_01;  /* NR_DL_TDOA_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16_02;                   /* T_cause_r16_02 */
static int hf_lpp_cause_r16_03;                   /* T_cause_r16_03 */
static int hf_lpp_remoteUE_Indication_r18_02;     /* T_remoteUE_Indication_r18_02 */
static int hf_lpp_nr_DL_AoD_Error_r16;            /* NR_DL_AoD_Error_r16 */
static int hf_lpp_nr_DL_PRS_BeamInfo_r17;         /* NR_DL_PRS_BeamInfo_r16 */
static int hf_lpp_nr_AdType_r16_01;               /* T_nr_AdType_r16_01 */
static int hf_lpp_nr_PosCalcAssistanceRequest_r17_01;  /* T_nr_PosCalcAssistanceRequest_r17_01 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01 */
static int hf_lpp_nr_DL_PRS_BeamInfoRequest_r17;  /* T_nr_DL_PRS_BeamInfoRequest_r17 */
static int hf_lpp_pre_configured_AssistanceDataRequest_r17_01;  /* T_pre_configured_AssistanceDataRequest_r17_01 */
static int hf_lpp_nr_IntegrityAssistanceRequest_r18_01;  /* T_nr_IntegrityAssistanceRequest_r18_01 */
static int hf_lpp_nr_DL_AoD_SignalMeasurementInformation_r16;  /* NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_dl_AoD_LocationInformation_r16;  /* NR_DL_AoD_LocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_SignalMeasurementInstances_r17;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_AoD_SignalMeasurementInstances_r17_item;  /* NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_AoD_LocationInformationInstances_r17;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_LocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_LocationInformationInstances_r17_item;  /* NR_DL_AoD_LocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_MeasList_r16;         /* NR_DL_AoD_MeasList_r16 */
static int hf_lpp_NR_DL_AoD_MeasList_r16_item;    /* NR_DL_AoD_MeasElement_r16 */
static int hf_lpp_nr_DL_PRS_RxBeamIndex_r16;      /* INTEGER_1_8 */
static int hf_lpp_nr_DL_AoD_AdditionalMeasurements_r16;  /* NR_DL_AoD_AdditionalMeasurements_r16 */
static int hf_lpp_nr_los_nlos_Indicator_r17_01;   /* T_nr_los_nlos_Indicator_r17_01 */
static int hf_lpp_nr_DL_AoD_AdditionalMeasurementsExt_r17;  /* NR_DL_AoD_AdditionalMeasurementsExt_r17 */
static int hf_lpp_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_02;  /* T_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_02 */
static int hf_lpp_NR_DL_AoD_AdditionalMeasurements_r16_item;  /* NR_DL_AoD_AdditionalMeasurementElement_r16 */
static int hf_lpp_NR_DL_AoD_AdditionalMeasurementsExt_r17_item;  /* NR_DL_AoD_AdditionalMeasurementElement_r17 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r16_01;  /* INTEGER_0_30 */
static int hf_lpp_nr_DL_PRS_ResourceID_r17;       /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_TimeStamp_r17;               /* NR_TimeStamp_r16 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r17;  /* INTEGER_0_30 */
static int hf_lpp_nr_DL_PRS_RxBeamIndex_r17;      /* INTEGER_1_8 */
static int hf_lpp_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_03;  /* T_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_03 */
static int hf_lpp_measurementReferenceTime_r16_01;  /* T_measurementReferenceTime_r16_01 */
static int hf_lpp_sfn_time_r16;                   /* NR_TimeStamp_r16 */
static int hf_lpp_nr_DL_AoD_ReportConfig_r16;     /* NR_DL_AoD_ReportConfig_r16 */
static int hf_lpp_multiMeasInSameReport_r17_01;   /* T_multiMeasInSameReport_r17_01 */
static int hf_lpp_nr_DL_PRS_RxHoppingRequest_r18_01;  /* T_nr_DL_PRS_RxHoppingRequest_r18_01 */
static int hf_lpp_nr_DL_PRS_RxHoppingTotalBandwidth_r18_01;  /* T_nr_DL_PRS_RxHoppingTotalBandwidth_r18_01 */
static int hf_lpp_fr1_03;                         /* T_fr1_03 */
static int hf_lpp_fr2_03;                         /* T_fr2_03 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementsPerTRP_r16;  /* INTEGER_1_8 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementsPerTRP_r17;  /* INTEGER_9_24 */
static int hf_lpp_maxDL_PRS_RSRPP_MeasurementsPerTRP_r17;  /* INTEGER_1_24 */
static int hf_lpp_nr_los_nlos_IndicatorRequest_r17_01;  /* T_nr_los_nlos_IndicatorRequest_r17_01 */
static int hf_lpp_reducedDL_PRS_ProcessingSamples_r17_01;  /* T_reducedDL_PRS_ProcessingSamples_r17_01 */
static int hf_lpp_lowerRxBeamSweepingFactor_FR2_r17_01;  /* T_lowerRxBeamSweepingFactor_FR2_r17_01 */
static int hf_lpp_nr_DL_AoD_Mode_r16;             /* PositioningModes */
static int hf_lpp_nr_DL_AoD_PRS_Capability_r16;   /* NR_DL_PRS_ResourcesCapability_r16 */
static int hf_lpp_nr_DL_AoD_MeasurementCapability_r16;  /* NR_DL_AoD_MeasurementCapability_r16 */
static int hf_lpp_nr_PosCalcAssistanceSupport_r17_01;  /* T_nr_PosCalcAssistanceSupport_r17_01 */
static int hf_lpp_nr_los_nlos_AssistanceDataSupport_r17_01;  /* T_nr_los_nlos_AssistanceDataSupport_r17_01 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01 */
static int hf_lpp_dl_PRS_ResourcePrioritySubset_Sup_r17;  /* T_dl_PRS_ResourcePrioritySubset_Sup_r17 */
static int hf_lpp_nr_DL_PRS_BeamInfoSup_r17;      /* T_nr_DL_PRS_BeamInfoSup_r17 */
static int hf_lpp_nr_DL_AoD_On_Demand_DL_PRS_Support_r17;  /* NR_On_Demand_DL_PRS_Support_r17 */
static int hf_lpp_nr_los_nlos_IndicatorSupport_r17_01;  /* T_nr_los_nlos_IndicatorSupport_r17_01 */
static int hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_01;  /* T_nr_dl_prs_AssistanceDataValidity_r17_01 */
static int hf_lpp_multiMeasInSameMeasReport_r17_01;  /* T_multiMeasInSameMeasReport_r17_01 */
static int hf_lpp_mg_ActivationRequest_r17_01;    /* T_mg_ActivationRequest_r17_01 */
static int hf_lpp_posMeasGapSupport_r17_01;       /* T_posMeasGapSupport_r17_01 */
static int hf_lpp_multiLocationEstimateInSameMeasReport_r17_01;  /* T_multiLocationEstimateInSameMeasReport_r17_01 */
static int hf_lpp_nr_IntegrityAssistanceSupport_r18_01;  /* T_nr_IntegrityAssistanceSupport_r18_01 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_r16;  /* INTEGER_1_8 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_r16;  /* INTEGER_1_8 */
static int hf_lpp_dl_AoD_MeasCapabilityBandList_r16;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16 */
static int hf_lpp_dl_AoD_MeasCapabilityBandList_r16_item;  /* DL_AoD_MeasCapabilityPerBand_r16 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_v1730;  /* T_maxDL_PRS_RSRP_MeasurementFR1_v1730 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_v1730;  /* T_maxDL_PRS_RSRP_MeasurementFR2_v1730 */
static int hf_lpp_simul_NR_DL_AoD_DL_TDOA_r16;    /* T_simul_NR_DL_AoD_DL_TDOA_r16 */
static int hf_lpp_simul_NR_DL_AoD_Multi_RTT_r16;  /* T_simul_NR_DL_AoD_Multi_RTT_r16 */
static int hf_lpp_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17;  /* T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17 */
static int hf_lpp_dl_PRS_MeasRRC_Inactive_r17_01;  /* T_dl_PRS_MeasRRC_Inactive_r17_01 */
static int hf_lpp_supportOfMeasurementsInTimeWindow_r18_01;  /* T_supportOfMeasurementsInTimeWindow_r18_01 */
static int hf_lpp_supportOfPRS_MeasurementRRC_Idle_r18_01;  /* T_supportOfPRS_MeasurementRRC_Idle_r18_01 */
static int hf_lpp_locationServerErrorCauses_r16_02;  /* NR_DL_AoD_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16_02;  /* NR_DL_AoD_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16_04;                   /* T_cause_r16_04 */
static int hf_lpp_cause_r16_05;                   /* T_cause_r16_05 */
static int hf_lpp_remoteUE_Indication_r18_03;     /* T_remoteUE_Indication_r18_03 */
static int hf_lpp_nr_Multi_RTT_Error_r16;         /* NR_Multi_RTT_Error_r16 */
static int hf_lpp_nr_AdType_r16_02;               /* T_nr_AdType_r16_02 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02 */
static int hf_lpp_pre_configured_AssistanceDataRequest_r17_02;  /* T_pre_configured_AssistanceDataRequest_r17_02 */
static int hf_lpp_nr_Multi_RTT_SignalMeasurementInformation_r16;  /* NR_Multi_RTT_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_Multi_RTT_SignalMeasurementInstances_r17;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_Multi_RTT_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_Multi_RTT_SignalMeasurementInstances_r17_item;  /* NR_Multi_RTT_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_Multi_RTT_MeasList_r16;      /* NR_Multi_RTT_MeasList_r16 */
static int hf_lpp_nr_NTA_Offset_r16;              /* T_nr_NTA_Offset_r16 */
static int hf_lpp_nr_SRS_TxTEG_Set_r17;           /* SEQUENCE_SIZE_1_maxTxTEG_Sets_r17_OF_NR_SRS_TxTEG_Element_r17 */
static int hf_lpp_nr_SRS_TxTEG_Set_r17_item;      /* NR_SRS_TxTEG_Element_r17 */
static int hf_lpp_nr_UE_TxTEG_TimingErrorMargin_r17;  /* TEG_TimingErrorMargin_r17 */
static int hf_lpp_nr_UE_RxTxTEG_TimingErrorMargin_r17;  /* RxTxTEG_TimingErrorMargin_r17 */
static int hf_lpp_NR_Multi_RTT_MeasList_r16_item;  /* NR_Multi_RTT_MeasElement_r16 */
static int hf_lpp_nr_UE_RxTxTimeDiff_r16;         /* T_nr_UE_RxTxTimeDiff_r16 */
static int hf_lpp_nr_Multi_RTT_AdditionalMeasurements_r16;  /* NR_Multi_RTT_AdditionalMeasurements_r16 */
static int hf_lpp_nr_UE_RxTx_TEG_Info_r17;        /* NR_UE_RxTx_TEG_Info_r17 */
static int hf_lpp_nr_los_nlos_Indicator_r17_02;   /* T_nr_los_nlos_Indicator_r17_02 */
static int hf_lpp_nr_Multi_RTT_AdditionalMeasurementsExt_r17;  /* NR_Multi_RTT_AdditionalMeasurementsExt_r17 */
static int hf_lpp_nr_MeasBasedOnAggregatedResources_r18_02;  /* T_nr_MeasBasedOnAggregatedResources_r18_02 */
static int hf_lpp_nr_RSCP_AddSampleMeasurements_r18;  /* SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_RSCP_AddSampleMeasurements_r18_item;  /* NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_04;  /* T_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_04 */
static int hf_lpp_nr_NTN_UE_RxTxMeasurements_r18;  /* NR_NTN_UE_RxTxMeasurements_r18 */
static int hf_lpp_NR_Multi_RTT_AdditionalMeasurements_r16_item;  /* NR_Multi_RTT_AdditionalMeasurementElement_r16 */
static int hf_lpp_NR_Multi_RTT_AdditionalMeasurementsExt_r17_item;  /* NR_Multi_RTT_AdditionalMeasurementElement_r16 */
static int hf_lpp_nr_UE_RxTxTimeDiffAdditional_r16;  /* T_nr_UE_RxTxTimeDiffAdditional_r16 */
static int hf_lpp_nr_MeasBasedOnAggregatedResources_r18_03;  /* T_nr_MeasBasedOnAggregatedResources_r18_03 */
static int hf_lpp_nr_RSCP_AdditionalMeasurementsAddSample_r18;  /* SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_RSCP_AdditionalMeasurementsAddSample_r18_item;  /* NR_RSCP_AdditionalMeasurements_r18 */
static int hf_lpp_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_05;  /* T_nr_ReportDL_PRS_MeasBasedOnSingleOrMultiHopRx_r18_05 */
static int hf_lpp_nr_UE_Tx_TEG_ID_r17;            /* INTEGER_0_maxNumOfTxTEGs_1_r17 */
static int hf_lpp_carrierFreq_r17;                /* T_carrierFreq_r17 */
static int hf_lpp_absoluteFrequencyPointA_r17;    /* ARFCN_ValueNR_r15 */
static int hf_lpp_offsetToPointA_r17;             /* INTEGER_0_2199 */
static int hf_lpp_srs_PosResourceList_r17;        /* T_srs_PosResourceList_r17 */
static int hf_lpp_srs_PosResourceList_r17_item;   /* INTEGER_0_maxNumOfSRS_PosResources_1_r17 */
static int hf_lpp_case1_r17;                      /* T_case1_r17 */
static int hf_lpp_nr_UE_RxTx_TEG_ID_r17;          /* INTEGER_0_maxNumOfRxTxTEGs_1_r17 */
static int hf_lpp_case2_r17;                      /* T_case2_r17 */
static int hf_lpp_nr_UE_Tx_TEG_Index_r17;         /* INTEGER_1_maxTxTEG_Sets_r17 */
static int hf_lpp_case3_r17;                      /* T_case3_r17 */
static int hf_lpp_nr_NTN_UE_RxTxTimeDiffSubframeOffset_r18;  /* INTEGER_0_542 */
static int hf_lpp_nr_NTN_DL_TimingDrift_r18;      /* INTEGER_M265_265 */
static int hf_lpp_nr_UE_RxTxTimeDiffMeasurementInfoRequest_r16;  /* T_nr_UE_RxTxTimeDiffMeasurementInfoRequest_r16 */
static int hf_lpp_nr_RequestedMeasurements_r16_01;  /* T_nr_RequestedMeasurements_r16_01 */
static int hf_lpp_nr_Multi_RTT_ReportConfig_r16;  /* NR_Multi_RTT_ReportConfig_r16 */
static int hf_lpp_additionalPaths_r16_01;         /* T_additionalPaths_r16_01 */
static int hf_lpp_nr_UE_RxTxTEG_Request_r17;      /* T_nr_UE_RxTxTEG_Request_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTxTEGs_r17;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTxTEGs_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_02;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_02 */
static int hf_lpp_reducedDL_PRS_ProcessingSamples_r17_02;  /* T_reducedDL_PRS_ProcessingSamples_r17_02 */
static int hf_lpp_nr_los_nlos_IndicatorRequest_r17_02;  /* T_nr_los_nlos_IndicatorRequest_r17_02 */
static int hf_lpp_additionalPathsExt_r17_01;      /* T_additionalPathsExt_r17_01 */
static int hf_lpp_additionalPathsDL_PRS_RSRP_Request_r17_01;  /* T_additionalPathsDL_PRS_RSRP_Request_r17_01 */
static int hf_lpp_multiMeasInSameReport_r17_02;   /* T_multiMeasInSameReport_r17_02 */
static int hf_lpp_lowerRxBeamSweepingFactor_FR2_r17_02;  /* T_lowerRxBeamSweepingFactor_FR2_r17_02 */
static int hf_lpp_nr_DL_PRS_RxHoppingRequest_r18_02;  /* T_nr_DL_PRS_RxHoppingRequest_r18_02 */
static int hf_lpp_nr_DL_PRS_RxHoppingTotalBandwidth_r18_02;  /* T_nr_DL_PRS_RxHoppingTotalBandwidth_r18_02 */
static int hf_lpp_fr1_04;                         /* T_fr1_04 */
static int hf_lpp_fr2_04;                         /* T_fr2_04 */
static int hf_lpp_nr_DL_PRS_JointMeasurementRequest_r18_01;  /* T_nr_DL_PRS_JointMeasurementRequest_r18_01 */
static int hf_lpp_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18_01;  /* T_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18_01 */
static int hf_lpp_nr_NTN_UE_RxTxMeasurementsRequest_r18;  /* T_nr_NTN_UE_RxTxMeasurementsRequest_r18 */
static int hf_lpp_maxDL_PRS_RxTxTimeDiffMeasPerTRP_r16;  /* INTEGER_1_4 */
static int hf_lpp_nr_Multi_RTT_PRS_Capability_r16;  /* NR_DL_PRS_ResourcesCapability_r16 */
static int hf_lpp_nr_Multi_RTT_MeasurementCapability_r16;  /* NR_Multi_RTT_MeasurementCapability_r16 */
static int hf_lpp_additionalPathsReport_r16_01;   /* T_additionalPathsReport_r16_01 */
static int hf_lpp_periodicalReporting_r16_02;     /* T_periodicalReporting_r16_01 */
static int hf_lpp_ten_ms_unit_ResponseTime_r17_02;  /* T_ten_ms_unit_ResponseTime_r17_01 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02 */
static int hf_lpp_nr_Multi_RTT_On_Demand_DL_PRS_Support_r17;  /* NR_On_Demand_DL_PRS_Support_r17 */
static int hf_lpp_nr_UE_RxTx_TEG_ID_ReportingSupport_r17;  /* T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17 */
static int hf_lpp_nr_los_nlos_IndicatorSupport_r17_02;  /* T_nr_los_nlos_IndicatorSupport_r17_02 */
static int hf_lpp_additionalPathsExtSupport_r17_01;  /* T_additionalPathsExtSupport_r17_01 */
static int hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_02;  /* T_nr_dl_prs_AssistanceDataValidity_r17_02 */
static int hf_lpp_multiMeasInSameMeasReport_r17_02;  /* T_multiMeasInSameMeasReport_r17_02 */
static int hf_lpp_mg_ActivationRequest_r17_02;    /* T_mg_ActivationRequest_r17_02 */
static int hf_lpp_posMeasGapSupport_r17_02;       /* T_posMeasGapSupport_r17_02 */
static int hf_lpp_nr_MultiRTT_OnDemandPRS_ForBWA_Support_r18;  /* T_nr_MultiRTT_OnDemandPRS_ForBWA_Support_r18 */
static int hf_lpp_maxNrOfRx_TX_MeasFR1_r16;       /* INTEGER_1_4 */
static int hf_lpp_maxNrOfRx_TX_MeasFR2_r16;       /* INTEGER_1_4 */
static int hf_lpp_supportOfRSRP_MeasFR1_r16;      /* T_supportOfRSRP_MeasFR1_r16 */
static int hf_lpp_supportOfRSRP_MeasFR2_r16;      /* T_supportOfRSRP_MeasFR2_r16 */
static int hf_lpp_srs_AssocPRS_MultiLayersFR1_r16;  /* T_srs_AssocPRS_MultiLayersFR1_r16 */
static int hf_lpp_srs_AssocPRS_MultiLayersFR2_r16;  /* T_srs_AssocPRS_MultiLayersFR2_r16 */
static int hf_lpp_multi_RTT_MeasCapabilityBandList_r17;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17 */
static int hf_lpp_multi_RTT_MeasCapabilityBandList_r17_item;  /* Multi_RTT_MeasCapabilityPerBand_r17 */
static int hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17_01;  /* T_supportOfDL_PRS_FirstPathRSRP_r17_01 */
static int hf_lpp_dl_PRS_MeasRRC_Inactive_r17_02;  /* T_dl_PRS_MeasRRC_Inactive_r17_02 */
static int hf_lpp_supportOfDL_PRS_BWA_RRC_Connected_r18_01;  /* T_supportOfDL_PRS_BWA_RRC_Connected_r18_01 */
static int hf_lpp_supportOfDL_PRS_BWA_RRC_Inactive_r18_01;  /* T_supportOfDL_PRS_BWA_RRC_Inactive_r18_01 */
static int hf_lpp_nr_NTN_MeasAndReport_r18;       /* T_nr_NTN_MeasAndReport_r18 */
static int hf_lpp_nr_DL_PRS_RSCP_RRC_Connected_r18;  /* T_nr_DL_PRS_RSCP_RRC_Connected_r18 */
static int hf_lpp_nr_DL_PRS_RSCP_RRC_Inactive_r18;  /* T_nr_DL_PRS_RSCP_RRC_Inactive_r18 */
static int hf_lpp_assocSingleRx_Tx_WithUpToNsampleRSCP_r18;  /* T_assocSingleRx_Tx_WithUpToNsampleRSCP_r18 */
static int hf_lpp_supportOfSymbolTimeStampForRSCP_r18;  /* T_supportOfSymbolTimeStampForRSCP_r18 */
static int hf_lpp_supportOfFinerTimingReportGranularityForPRS_Meas_r18_01;  /* T_supportOfFinerTimingReportGranularityForPRS_Meas_r18_01 */
static int hf_lpp_supportOfMeasurementsInTimeWindow_r18_02;  /* T_supportOfMeasurementsInTimeWindow_r18_02 */
static int hf_lpp_locationServerErrorCauses_r16_03;  /* NR_Multi_RTT_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16_03;  /* NR_Multi_RTT_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16_06;                   /* T_cause_r16_06 */
static int hf_lpp_cause_r16_07;                   /* T_cause_r16_07 */
static int hf_lpp_remoteUE_Indication_r18_04;     /* T_remoteUE_Indication_r18_04 */
static int hf_lpp_valueTag_r15;                   /* INTEGER_0_63 */
static int hf_lpp_expirationTime_r15;             /* UTCTime */
static int hf_lpp_cipheringKeyData_r15;           /* CipheringKeyData_r15 */
static int hf_lpp_segmentationInfo_r15;           /* SegmentationInfo_r15 */
static int hf_lpp_assistanceDataElement_r15;      /* T_assistanceDataElement_r15 */
static int hf_lpp_cipherSetID_r15;                /* INTEGER_0_65535 */
static int hf_lpp_d0_r15;                         /* BIT_STRING_SIZE_1_128 */
static int hf_lpp_segmentationOption_r15;         /* T_segmentationOption_r15 */
static int hf_lpp_assistanceDataSegmentType_r15;  /* T_assistanceDataSegmentType_r15 */
static int hf_lpp_assistanceDataSegmentNumber_r15;  /* INTEGER_0_63 */
static int hf_lpp_otdoa_ReferenceCellInfo_r15;    /* OTDOA_ReferenceCellInfo */
static int hf_lpp_otdoa_NeighbourCellInfo_r15;    /* OTDOA_NeighbourCellInfoList */
static int hf_lpp_nr_trp_LocationInfo_r16;        /* NR_TRP_LocationInfo_r16 */
static int hf_lpp_nr_dl_prs_BeamInfo_r16;         /* NR_DL_PRS_BeamInfo_r16 */
static int hf_lpp_nr_rtd_Info_r16;                /* NR_RTD_Info_r16 */
/* named bits */
static int hf_lpp_T_accessTypes_eutra;
static int hf_lpp_T_accessTypes_utra;
static int hf_lpp_T_accessTypes_gsm;
static int hf_lpp_T_accessTypes_nb_iot;
static int hf_lpp_T_accessTypes_nr_v1510;
static int hf_lpp_UpdateCapabilities_r15_primaryCellID_r15;
static int hf_lpp_T_posModes_standalone;
static int hf_lpp_T_posModes_ue_based;
static int hf_lpp_T_posModes_ue_assisted;
static int hf_lpp_T_lpp_message_segmentation_req_r14_serverToTarget;
static int hf_lpp_T_lpp_message_segmentation_req_r14_targetToServer;
static int hf_lpp_T_lpp_message_segmentation_r14_serverToTarget;
static int hf_lpp_T_lpp_message_segmentation_r14_targetToServer;
static int hf_lpp_LocationSource_r13_a_gnss;
static int hf_lpp_LocationSource_r13_wlan;
static int hf_lpp_LocationSource_r13_bt;
static int hf_lpp_LocationSource_r13_tbs;
static int hf_lpp_LocationSource_r13_sensor;
static int hf_lpp_LocationSource_r13_ha_gnss_v1510;
static int hf_lpp_LocationSource_r13_motion_sensor_v1550;
static int hf_lpp_LocationSource_r13_dl_tdoa_r16;
static int hf_lpp_LocationSource_r13_dl_aod_r16;
static int hf_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18_rstd;
static int hf_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18_ueRxTx;
static int hf_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18_rsrp;
static int hf_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18_rsrpp;
static int hf_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18_rscp;
static int hf_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18_rscpd;
static int hf_lpp_T_adType_r14_prs;
static int hf_lpp_T_adType_r14_nprs;
static int hf_lpp_T_otdoa_Mode_ue_assisted;
static int hf_lpp_T_otdoa_Mode_ue_assisted_NB_r14;
static int hf_lpp_T_otdoa_Mode_ue_assisted_NB_TDD_r15;
static int hf_lpp_T_orbit_IntegrityReq_r17_correlationTimeReq;
static int hf_lpp_T_stec_IntegrityReq_r17_correlationTimeReq;
static int hf_lpp_T_periodicAssistanceData_r15_solicited;
static int hf_lpp_T_periodicAssistanceData_r15_unsolicited;
static int hf_lpp_T_ionoModel_klobuchar;
static int hf_lpp_T_ionoModel_neQuick;
static int hf_lpp_T_ionoModel_klobuchar2_r16;
static int hf_lpp_T_clockModel_model_1;
static int hf_lpp_T_clockModel_model_2;
static int hf_lpp_T_clockModel_model_3;
static int hf_lpp_T_clockModel_model_4;
static int hf_lpp_T_clockModel_model_5;
static int hf_lpp_T_clockModel_model_6;
static int hf_lpp_T_clockModel_model_7_r16;
static int hf_lpp_T_clockModel_model_8_r16;
static int hf_lpp_T_orbitModel_model_1;
static int hf_lpp_T_orbitModel_model_2;
static int hf_lpp_T_orbitModel_model_3;
static int hf_lpp_T_orbitModel_model_4;
static int hf_lpp_T_orbitModel_model_5;
static int hf_lpp_T_orbitModel_model_6;
static int hf_lpp_T_orbitModel_model_7_r16;
static int hf_lpp_T_orbitModel_model_8_r16;
static int hf_lpp_T_almanacModel_model_1;
static int hf_lpp_T_almanacModel_model_2;
static int hf_lpp_T_almanacModel_model_3;
static int hf_lpp_T_almanacModel_model_4;
static int hf_lpp_T_almanacModel_model_5;
static int hf_lpp_T_almanacModel_model_6;
static int hf_lpp_T_almanacModel_model_7;
static int hf_lpp_T_almanacModel_model_8_v16e0;
static int hf_lpp_T_utc_Model_model_1;
static int hf_lpp_T_utc_Model_model_2;
static int hf_lpp_T_utc_Model_model_3;
static int hf_lpp_T_utc_Model_model_4;
static int hf_lpp_T_utc_Model_model_5;
static int hf_lpp_T_orbit_IntegritySup_r17_correlationTimeSup;
static int hf_lpp_T_stec_IntegritySup_r17_correlationTimeSup;
static int hf_lpp_T_gnss_ids_gps;
static int hf_lpp_T_gnss_ids_sbas;
static int hf_lpp_T_gnss_ids_qzss;
static int hf_lpp_T_gnss_ids_galileo;
static int hf_lpp_T_gnss_ids_glonass;
static int hf_lpp_T_gnss_ids_bds;
static int hf_lpp_T_gnss_ids_navic_v1610;
static int hf_lpp_T_sbas_IDs_waas;
static int hf_lpp_T_sbas_IDs_egnos;
static int hf_lpp_T_sbas_IDs_msas;
static int hf_lpp_T_sbas_IDs_gagan;
static int hf_lpp_T_requestedMeasurements_rsrpReq;
static int hf_lpp_T_requestedMeasurements_rsrqReq;
static int hf_lpp_T_requestedMeasurements_ueRxTxReq;
static int hf_lpp_T_requestedMeasurements_nrsrpReq_r14;
static int hf_lpp_T_requestedMeasurements_nrsrqReq_r14;
static int hf_lpp_T_ecid_MeasSupported_rsrpSup;
static int hf_lpp_T_ecid_MeasSupported_rsrqSup;
static int hf_lpp_T_ecid_MeasSupported_ueRxTxSup;
static int hf_lpp_T_ecid_MeasSupported_nrsrpSup_r14;
static int hf_lpp_T_ecid_MeasSupported_nrsrqSup_r14;
static int hf_lpp_T_mbsRequestedMeasurements_r14_rssi;
static int hf_lpp_T_tbs_Modes_r13_standalone;
static int hf_lpp_T_tbs_Modes_r13_ue_assisted;
static int hf_lpp_T_tbs_Modes_r13_ue_based;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb1;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb2;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb3;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb4;
static int hf_lpp_T_sensor_Modes_r13_standalone;
static int hf_lpp_T_sensor_Modes_r13_ue_assisted;
static int hf_lpp_T_sensor_Modes_r13_ue_based;
static int hf_lpp_T_requestedMeasurements_r13_rssi;
static int hf_lpp_T_requestedMeasurements_r13_rtt;
static int hf_lpp_T_wlan_Modes_r13_standalone;
static int hf_lpp_T_wlan_Modes_r13_ue_assisted;
static int hf_lpp_T_wlan_Modes_r13_ue_based;
static int hf_lpp_T_wlan_MeasSupported_r13_rssi_r13;
static int hf_lpp_T_wlan_MeasSupported_r13_rtt_r13;
static int hf_lpp_T_wlan_AP_AD_Supported_r14_ap_identifier;
static int hf_lpp_T_wlan_AP_AD_Supported_r14_ap_location;
static int hf_lpp_T_requestedAD_r14_ap_identifier;
static int hf_lpp_T_requestedAD_r14_ap_location;
static int hf_lpp_T_requestedMeasurements_r13_01_rssi;
static int hf_lpp_T_requestedMeasurements_r13_01_aod_v1800;
static int hf_lpp_T_bt_requestedAoA_Config_r18_aoa_advConfig;
static int hf_lpp_T_bt_requestedAoA_Config_r18_aoa_cteConfig;
static int hf_lpp_T_bt_Modes_r13_standalone;
static int hf_lpp_T_bt_Modes_r13_ue_assisted;
static int hf_lpp_T_bt_Modes_r13_ue_based_v1810;
static int hf_lpp_T_bt_MeasSupported_r13_rssi_r13;
static int hf_lpp_T_bt_MeasSupported_r13_aod_v1800;
static int hf_lpp_T_requestedAD_r18_beacon_location;
static int hf_lpp_T_requestedAD_r18_beacon_antConfig;
static int hf_lpp_T_requestedAD_r18_beacon_transmConfig;
static int hf_lpp_T_requestedMeasurements_r16_ssrsrpReq;
static int hf_lpp_T_requestedMeasurements_r16_ssrsrqReq;
static int hf_lpp_T_requestedMeasurements_r16_csirsrpReq;
static int hf_lpp_T_requestedMeasurements_r16_csirsrqReq;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrpSup;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrqSup;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrpSup;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrqSup;
static int hf_lpp_T_nr_AdType_r16_dl_prs;
static int hf_lpp_T_nr_AdType_r16_posCalc;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpLoc;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_beamInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_rtdInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_losNlosInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpTEG_Info;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_nr_IntegrityBounds_r18;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_pruInfo_r18;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_serviceParameters;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_serviceAlert;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_riskParameters;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_integrityParaTRP_Loc;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_integrityParaBeamInfo;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_integrityParaRTD_Info;
static int hf_lpp_T_nr_RequestedMeasurements_r16_prsrsrpReq;
static int hf_lpp_T_nr_RequestedMeasurements_r16_firstPathRsrpReq_r17;
static int hf_lpp_T_nr_RequestedMeasurements_r16_dl_PRS_RSCPD_Request_r18;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpLocSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_beamInfoSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_rtdInfoSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpTEG_InfoSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_nr_IntegritySup_r18;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_pruInfoSup_r18;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoD;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoA;
static int hf_lpp_T_periodicAssistanceData_r18_solicited;
static int hf_lpp_T_periodicAssistanceData_r18_unsolicited;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_serviceParametersSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_serviceAlertSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_riskParametersSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_integrityParaTRP_LocSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_integrityParaBeamInfoSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_integrityParaRTD_InfoSup;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rstd;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rsrp;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rsrpp;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rscpd;
static int hf_lpp_T_nr_AdType_r16_01_dl_prs;
static int hf_lpp_T_nr_AdType_r16_01_posCalc;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_trpLoc;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_rtdInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamAntInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_losNlosInfo;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_nr_IntegrityBounds_r18;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_serviceParameters;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_serviceAlert;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_riskParameters;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityParaTRP_Loc;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityParaBeamInfo;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityParaRTD_Info;
static int hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityBeamAntInfo;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_trpLocSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamInfoSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_rtdInfoSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamAntInfoSup;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_nr_IntegrityBoundsSup_r18;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoD;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoA;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_serviceParametersSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_serviceAlertSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_riskParametersSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityParaTRP_LocSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityParaBeamInfoSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityParaRTD_InfoSup;
static int hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityBeamAntInfoSup;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_01_rsrp;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_01_rsrpp;
static int hf_lpp_T_nr_AdType_r16_02_dl_prs;
static int hf_lpp_T_nr_AdType_r16_02_ul_srs;
static int hf_lpp_T_nr_RequestedMeasurements_r16_01_prsrsrpReq;
static int hf_lpp_T_nr_RequestedMeasurements_r16_01_firstPathRsrpReq_r17;
static int hf_lpp_T_nr_RequestedMeasurements_r16_01_dl_PRS_RSCP_Request_r18;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoD;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoA;
static int hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case1;
static int hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case2;
static int hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case3;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rx_tx;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rsrp;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rsrpp;
static int hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rscp;
static int dummy_hf_lpp_eag_field; /* never registered */
static int hf_lpp_svHealthExt_v1240_e5bhs;
static int hf_lpp_svHealthExt_v1240_e1_bhs;
static int hf_lpp_kepSV_StatusINAV_e5bhs;
static int hf_lpp_kepSV_StatusINAV_e1_bhs;
static int hf_lpp_kepSV_StatusFNAV_e5ahs;
static int hf_lpp_bdsSvHealth_r12_sat_clock;
static int hf_lpp_bdsSvHealth_r12_b1i;
static int hf_lpp_bdsSvHealth_r12_b2i;
static int hf_lpp_bdsSvHealth_r12_nav;
static int hf_lpp_AssistanceDataSIBelement_r15_PDU;

static dissector_handle_t lppe_handle;

static uint32_t lpp_epdu_id = -1;

/* Initialize the subtree pointers */
static int ett_lpp;
static int ett_lpp_svHealthExt_v1240;
static int ett_kepSV_StatusINAV;
static int ett_kepSV_StatusFNAV;
static int ett_lpp_bdsSvHealth_r12;
static int ett_lpp_assistanceDataElement_r15;
static int ett_lpp_LPP_Message;
static int ett_lpp_Acknowledgement;
static int ett_lpp_LPP_MessageBody;
static int ett_lpp_T_c1;
static int ett_lpp_T_messageClassExtension;
static int ett_lpp_LPP_TransactionID;
static int ett_lpp_RequestCapabilities;
static int ett_lpp_T_criticalExtensions;
static int ett_lpp_T_c1_01;
static int ett_lpp_T_criticalExtensionsFuture;
static int ett_lpp_RequestCapabilities_r9_IEs;
static int ett_lpp_ProvideCapabilities;
static int ett_lpp_T_criticalExtensions_01;
static int ett_lpp_T_c1_02;
static int ett_lpp_T_criticalExtensionsFuture_01;
static int ett_lpp_ProvideCapabilities_r9_IEs;
static int ett_lpp_RequestAssistanceData;
static int ett_lpp_T_criticalExtensions_02;
static int ett_lpp_T_c1_03;
static int ett_lpp_T_criticalExtensionsFuture_02;
static int ett_lpp_RequestAssistanceData_r9_IEs;
static int ett_lpp_ProvideAssistanceData;
static int ett_lpp_T_criticalExtensions_03;
static int ett_lpp_T_c1_04;
static int ett_lpp_T_criticalExtensionsFuture_03;
static int ett_lpp_ProvideAssistanceData_r9_IEs;
static int ett_lpp_RequestLocationInformation;
static int ett_lpp_T_criticalExtensions_04;
static int ett_lpp_T_c1_05;
static int ett_lpp_T_criticalExtensionsFuture_04;
static int ett_lpp_RequestLocationInformation_r9_IEs;
static int ett_lpp_ProvideLocationInformation;
static int ett_lpp_T_criticalExtensions_05;
static int ett_lpp_T_c1_06;
static int ett_lpp_T_criticalExtensionsFuture_05;
static int ett_lpp_ProvideLocationInformation_r9_IEs;
static int ett_lpp_Abort;
static int ett_lpp_T_criticalExtensions_06;
static int ett_lpp_T_c1_07;
static int ett_lpp_T_criticalExtensionsFuture_06;
static int ett_lpp_Abort_r9_IEs;
static int ett_lpp_Error;
static int ett_lpp_T_criticalExtensionsFuture_07;
static int ett_lpp_Error_r9_IEs;
static int ett_lpp_AccessTypes;
static int ett_lpp_T_accessTypes;
static int ett_lpp_CarrierFreq_NB_r14;
static int ett_lpp_CellGlobalIdEUTRA_AndUTRA;
static int ett_lpp_T_plmn_Identity;
static int ett_lpp_T_mcc;
static int ett_lpp_T_mnc;
static int ett_lpp_T_cellIdentity;
static int ett_lpp_CellGlobalIdGERAN;
static int ett_lpp_T_plmn_Identity_01;
static int ett_lpp_T_mcc_01;
static int ett_lpp_T_mnc_01;
static int ett_lpp_ECGI;
static int ett_lpp_T_mcc_02;
static int ett_lpp_T_mnc_02;
static int ett_lpp_Ellipsoid_Point;
static int ett_lpp_Ellipsoid_PointWithUncertaintyCircle;
static int ett_lpp_EllipsoidPointWithUncertaintyEllipse;
static int ett_lpp_EllipsoidPointWithAltitude;
static int ett_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid;
static int ett_lpp_EllipsoidArc;
static int ett_lpp_EPDU_Sequence;
static int ett_lpp_EPDU;
static int ett_lpp_EPDU_Identifier;
static int ett_lpp_HA_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16;
static int ett_lpp_HA_EllipsoidPointWithScalableUncertaintyEllipse_r16;
static int ett_lpp_HighAccuracyEllipsoidPointWithUncertaintyEllipse_r15;
static int ett_lpp_HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15;
static int ett_lpp_HorizontalVelocity;
static int ett_lpp_HorizontalWithVerticalVelocity;
static int ett_lpp_HorizontalVelocityWithUncertainty;
static int ett_lpp_HorizontalWithVerticalVelocityAndUncertainty;
static int ett_lpp_Local2dPointWithUncertaintyEllipse_r18;
static int ett_lpp_Local3dPointWithUncertaintyEllipsoid_r18;
static int ett_lpp_LocationCoordinateTypes;
static int ett_lpp_NCGI_r15;
static int ett_lpp_T_mcc_r15;
static int ett_lpp_T_mnc_r15;
static int ett_lpp_PeriodicAssistanceDataControlParameters_r15;
static int ett_lpp_PeriodicSessionID_r15;
static int ett_lpp_UpdateCapabilities_r15;
static int ett_lpp_PeriodicReportingIntervalMsSupport_r18;
static int ett_lpp_PeriodicReportingIntervalMsSupportPerMode_r18;
static int ett_lpp_Polygon;
static int ett_lpp_PolygonPoints;
static int ett_lpp_PositioningModes;
static int ett_lpp_T_posModes;
static int ett_lpp_ScheduledLocationTimeSupport_r17;
static int ett_lpp_ScheduledLocationTimeSupportPerMode_r17;
static int ett_lpp_T_gnssTime_r17;
static int ett_lpp_VelocityTypes;
static int ett_lpp_CommonIEsRequestCapabilities;
static int ett_lpp_T_lpp_message_segmentation_req_r14;
static int ett_lpp_CommonIEsProvideCapabilities;
static int ett_lpp_T_lpp_message_segmentation_r14;
static int ett_lpp_CommonIEsRequestAssistanceData;
static int ett_lpp_CommonIEsProvideAssistanceData;
static int ett_lpp_CommonIEsRequestLocationInformation;
static int ett_lpp_PeriodicalReportingCriteria;
static int ett_lpp_PeriodicalReportingCriteriaExt_r18;
static int ett_lpp_TriggeredReportingCriteria;
static int ett_lpp_QoS;
static int ett_lpp_HorizontalAccuracy;
static int ett_lpp_VerticalAccuracy;
static int ett_lpp_HorizontalAccuracyExt_r15;
static int ett_lpp_VerticalAccuracyExt_r15;
static int ett_lpp_ResponseTime;
static int ett_lpp_ResponseTimeNB_r14;
static int ett_lpp_MessageSizeLimitNB_r14;
static int ett_lpp_ScheduledLocationTime_r17;
static int ett_lpp_T_gnssTime_r17_01;
static int ett_lpp_T_networkTime_r17;
static int ett_lpp_T_e_utraTime_r17_01;
static int ett_lpp_T_nrTime_r17_01;
static int ett_lpp_T_nr_Slot_r17;
static int ett_lpp_CommonIEsProvideLocationInformation;
static int ett_lpp_LocationCoordinates;
static int ett_lpp_Velocity;
static int ett_lpp_LocationError;
static int ett_lpp_LocationSource_r13;
static int ett_lpp_IntegrityInfo_r17;
static int ett_lpp_CommonIEsAbort;
static int ett_lpp_CommonIEsError;
static int ett_lpp_AreaID_CellList_r17;
static int ett_lpp_NR_Cell_IDs_r17;
static int ett_lpp_DL_PRS_ID_Info_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxResourceIDs_r16_OF_NR_DL_PRS_ResourceID_r16;
static int ett_lpp_LCS_GCS_TranslationParameter_r16;
static int ett_lpp_LocalOrigin_r18;
static int ett_lpp_LOS_NLOS_Indicator_r17;
static int ett_lpp_T_indicator_r17;
static int ett_lpp_NR_AdditionalPathList_r16;
static int ett_lpp_NR_AdditionalPathListExt_r17;
static int ett_lpp_NR_AdditionalPath_r16;
static int ett_lpp_T_nr_RelativeTimeDifference_r16;
static int ett_lpp_NR_AggregatedDL_PRS_ResourceInfo_Element_r18;
static int ett_lpp_NR_DL_PRS_AssistanceData_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxFreqLayers_r16_OF_NR_DL_PRS_AssistanceDataPerFreq_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPs_r16_OF_NR_SSB_Config_r16;
static int ett_lpp_NR_DL_PRS_AssistanceDataPerFreq_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_DL_PRS_AssistanceDataPerTRP_r16;
static int ett_lpp_NR_DL_PRS_AssistanceDataPerTRP_r16;
static int ett_lpp_NR_DL_PRS_PositioningFrequencyLayer_r16;
static int ett_lpp_NR_DL_PRS_SFN0_Offset_r16;
static int ett_lpp_NR_DL_PRS_ExpectedAoD_or_AoA_r17;
static int ett_lpp_T_expectedAoD_r17;
static int ett_lpp_T_expectedAoA_r17;
static int ett_lpp_NR_DL_PRS_AggregationInfo_r18;
static int ett_lpp_NR_linkedDL_PRS_ResourceSetID_PRS_AggregationList_r18;
static int ett_lpp_NR_DL_PRS_AggregationElement_r18;
static int ett_lpp_NR_DL_PRS_BeamInfo_r16;
static int ett_lpp_NR_DL_PRS_BeamInfoPerFreqLayer_r16;
static int ett_lpp_NR_DL_PRS_BeamInfoPerTRP_r16;
static int ett_lpp_DL_PRS_BeamInfoSet_r16;
static int ett_lpp_DL_PRS_BeamInfoResourceSet_r16;
static int ett_lpp_DL_PRS_BeamInfoElement_r16;
static int ett_lpp_NR_IntegrityBeamInfoBounds_r18;
static int ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_Assistance_r17;
static int ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerFreqLayer_r17;
static int ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerTRP_r17;
static int ett_lpp_T_nr_los_nlos_indicator_r17;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17;
static int ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17;
static int ett_lpp_NR_DL_PRS_Info_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ResourceSet_r16;
static int ett_lpp_NR_DL_PRS_ResourceSet_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_NR_DL_PRS_Resource_r16;
static int ett_lpp_DL_PRS_MutingOption1_r16;
static int ett_lpp_DL_PRS_MutingOption2_r16;
static int ett_lpp_NR_MutingPattern_r16;
static int ett_lpp_NR_DL_PRS_Resource_r16;
static int ett_lpp_T_dl_PRS_CombSizeN_AndReOffset_r16;
static int ett_lpp_DL_PRS_QCL_Info_r16;
static int ett_lpp_T_ssb_r16;
static int ett_lpp_T_dl_PRS_r16;
static int ett_lpp_NR_DL_PRS_Periodicity_and_ResourceSetSlotOffset_r16;
static int ett_lpp_T_scs15_r16;
static int ett_lpp_T_scs30_r16;
static int ett_lpp_T_scs60_r16;
static int ett_lpp_T_scs120_r16;
static int ett_lpp_DL_PRS_ResourcePrioritySubset_r17;
static int ett_lpp_NR_DL_PRSResourcePriorityItem_r17;
static int ett_lpp_NR_DL_PRS_MeasurementTimeWindowsConfig_r18;
static int ett_lpp_NR_DL_PRS_MeasurementTimeWindowsConfigElement_r18;
static int ett_lpp_T_nr_PeriodicOrOneShotTimeWindow_r18;
static int ett_lpp_T_nr_OneShotSlotOffsetTimeWindow_r18;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_SelectedDL_PRS_IndexPerTRP_r18;
static int ett_lpp_T_nr_MeasurementsToPerformInTimeWindow_r18;
static int ett_lpp_NR_SelectedDL_PRS_IndexPerTRP_r18;
static int ett_lpp_T_dl_SelectedPRS_ResourceSetIndexList_r18;
static int ett_lpp_NR_DL_PRS_ProcessingCapability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16;
static int ett_lpp_PRS_ProcessingCapabilityPerBand_r16;
static int ett_lpp_T_supportedBandwidthPRS_r16;
static int ett_lpp_T_durationOfPRS_Processing_r16;
static int ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16;
static int ett_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17;
static int ett_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17;
static int ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17;
static int ett_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18;
static int ett_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18;
static int ett_lpp_T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18;
static int ett_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17;
static int ett_lpp_T_ppw_durationOfPRS_Processing1_r17;
static int ett_lpp_T_ppw_durationOfPRS_Processing2_r17;
static int ett_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17;
static int ett_lpp_T_ppw_maxNumOfDL_Bandwidth_r17;
static int ett_lpp_PRS_BWA_TwoContiguousIntrabandInMG_r18;
static int ett_lpp_T_prs_durationOfTwoPRS_BWA_Processing_r18;
static int ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18;
static int ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18;
static int ett_lpp_PRS_BWA_ThreeContiguousIntrabandInMG_r18;
static int ett_lpp_T_prs_durationOfThreePRS_BWA_Processing_r18;
static int ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01;
static int ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01;
static int ett_lpp_DL_PRS_MeasurementWithRxFH_RRC_Connected_r18;
static int ett_lpp_T_processingDuration_r18;
static int ett_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16;
static int ett_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16;
static int ett_lpp_NR_DL_PRS_ResourcesCapability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16;
static int ett_lpp_DL_PRS_ResourcesCapabilityPerBand_r16;
static int ett_lpp_DL_PRS_ResourcesBandCombinationList_r16;
static int ett_lpp_DL_PRS_ResourcesBandCombination_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16;
static int ett_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16;
static int ett_lpp_T_fr1_FR2Mix_r16;
static int ett_lpp_NR_DL_PRS_TRP_TEG_Info_r17;
static int ett_lpp_NR_DL_PRS_TRP_TEG_InfoPerFreqLayer_r17;
static int ett_lpp_NR_DL_PRS_TRP_TEG_InfoPerTRP_r17;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_TEG_InfoPerResourceSet_r17;
static int ett_lpp_DL_PRS_TEG_InfoPerResourceSet_r17;
static int ett_lpp_DL_PRS_TEG_InfoElement_r17;
static int ett_lpp_NR_IntegrityRiskParameters_r18;
static int ett_lpp_NR_IntegrityServiceAlert_r18;
static int ett_lpp_NR_TRP_IntegrityServiceAlertPerFreqLayer_r18;
static int ett_lpp_NR_TRP_IntegrityServiceAlertElement_r18;
static int ett_lpp_NR_IntegrityServiceParameters_r18;
static int ett_lpp_NR_On_Demand_DL_PRS_Configurations_r17;
static int ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_On_Demand_DL_PRS_Configuration_r17;
static int ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_OnDemandDL_PRS_AggregationInfo_r18;
static int ett_lpp_On_Demand_DL_PRS_Configuration_r17;
static int ett_lpp_DL_PRS_Configuration_ID_r17;
static int ett_lpp_OnDemandDL_PRS_AggregationInfo_r18;
static int ett_lpp_NR_On_Demand_DL_PRS_Information_r17;
static int ett_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17;
static int ett_lpp_DL_PRS_QCL_InformationReqTRPlist_r17;
static int ett_lpp_DL_PRS_QCL_InformationReqPerTRP_r17;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17;
static int ett_lpp_DL_PRS_QCL_InfoReq_r17;
static int ett_lpp_T_dl_prs_QCL_InformationReq_r17;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16;
static int ett_lpp_NR_On_Demand_DL_PRS_Request_r17;
static int ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17;
static int ett_lpp_T_dl_PRS_AggregationID_PrefList_r18;
static int ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18;
static int ett_lpp_DL_PRS_StartTime_and_Duration_r17;
static int ett_lpp_T_dl_prs_duration_r17;
static int ett_lpp_NR_OnDemandDL_PRS_AggregationReqElement_r18;
static int ett_lpp_NR_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17;
static int ett_lpp_NR_On_Demand_DL_PRS_Support_r17;
static int ett_lpp_NR_PeriodicAssistData_r18;
static int ett_lpp_NR_PeriodicAssistDataReq_r18;
static int ett_lpp_NR_PeriodicControlParam_r18;
static int ett_lpp_NR_PositionCalculationAssistance_r16;
static int ett_lpp_NR_IntegrityParametersTRP_LocationInfo_r18;
static int ett_lpp_NR_IntegrityParametersDL_PRS_BeamInfo_r18;
static int ett_lpp_NR_IntegrityParametersRTD_Info_r18;
static int ett_lpp_NR_IntegrityParametersTRP_BeamAntennaInfo_r18;
static int ett_lpp_NR_PRU_DL_Info_r18;
static int ett_lpp_NR_PRU_RSCP_MeasurementInformation_r18;
static int ett_lpp_NR_PRU_RSCP_MeasElement_r18;
static int ett_lpp_T_nr_los_nlos_Indicator_r18;
static int ett_lpp_SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCP_AdditionalMeasurements_r18;
static int ett_lpp_T_nr_PRU_RSRP_AddSampleMeasurements_r18;
static int ett_lpp_T_nr_PRU_FirstPathRSRP_ResultDiff_AddSampleMeasurements_r18;
static int ett_lpp_NR_PRU_RSCP_AdditionalMeasurements_r18;
static int ett_lpp_NR_PRU_RSCP_AdditionalMeasurementElement_r18;
static int ett_lpp_SEQUENCE_SIZE_1_nrNumOfSamples_r18_OF_NR_RSCP_AdditionalMeasurements_r18;
static int ett_lpp_T_nr_PRU_RSRPDiff_AdditionalMeasurementsList_r18;
static int ett_lpp_T_nr_PRU_FirstPathRSRP_ResultDiff_AdditionalMeasurementsList_r18;
static int ett_lpp_NR_RTD_Info_r16;
static int ett_lpp_ReferenceTRP_RTD_Info_r16;
static int ett_lpp_T_refTime_r16;
static int ett_lpp_RTD_InfoList_r16;
static int ett_lpp_RTD_InfoListPerFreqLayer_r16;
static int ett_lpp_RTD_InfoElement_r16;
static int ett_lpp_NR_IntegrityRTD_InfoBounds_r18;
static int ett_lpp_NR_SelectedDL_PRS_IndexList_r16;
static int ett_lpp_NR_SelectedDL_PRS_PerFreq_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_SelectedDL_PRS_IndexPerTRP_r16;
static int ett_lpp_NR_SelectedDL_PRS_IndexPerTRP_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_SelectedPRS_ResourceSetIndex_r16;
static int ett_lpp_DL_SelectedPRS_ResourceSetIndex_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_SelectedPRS_ResourceIndex_r16;
static int ett_lpp_DL_SelectedPRS_ResourceIndex_r16;
static int ett_lpp_NR_SSB_Config_r16;
static int ett_lpp_T_ssb_PositionsInBurst_r16;
static int ett_lpp_NR_TimeStamp_r16;
static int ett_lpp_T_nr_Slot_r16;
static int ett_lpp_NR_TimingQuality_r16;
static int ett_lpp_NR_TRP_BeamAntennaInfo_r17;
static int ett_lpp_NR_TRP_BeamAntennaInfoPerFreqLayer_r17;
static int ett_lpp_NR_TRP_BeamAntennaInfoPerTRP_r17;
static int ett_lpp_NR_TRP_BeamAntennaAngles_r17;
static int ett_lpp_NR_TRP_BeamAntennaInfoAzimuthElevation_r17;
static int ett_lpp_SEQUENCE_SIZE_1_1801_OF_ElevationElement_R17;
static int ett_lpp_ElevationElement_R17;
static int ett_lpp_SEQUENCE_SIZE_2_maxNumResourcesPerAngle_r17_OF_BeamPowerElement_r17;
static int ett_lpp_BeamPowerElement_r17;
static int ett_lpp_NR_IntegrityBeamPowerBounds_r18;
static int ett_lpp_NR_TRP_LocationInfo_r16;
static int ett_lpp_NR_TRP_LocationInfoPerFreqLayer_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_TRP_LocationInfoElement_r16;
static int ett_lpp_TRP_LocationInfoElement_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_ResourceSets_TRP_Element_r16;
static int ett_lpp_DL_PRS_ResourceSets_TRP_Element_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_Resource_ARP_Element_r16;
static int ett_lpp_DL_PRS_Resource_ARP_Element_r16;
static int ett_lpp_NR_IntegrityLocationBounds_r18;
static int ett_lpp_T_meanLocationErrorBound_r18;
static int ett_lpp_T_stdDevLocationErrorBound_r18;
static int ett_lpp_NR_UE_TEG_Capability_r17;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17;
static int ett_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17;
static int ett_lpp_NR_UL_SRS_Capability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16;
static int ett_lpp_SRS_CapabilityPerBand_r16;
static int ett_lpp_OLPC_SRS_Pos_r16;
static int ett_lpp_SpatialRelationsSRS_Pos_r16;
static int ett_lpp_SRS_PosResourcesPerBand_r16;
static int ett_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17;
static int ett_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17;
static int ett_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17;
static int ett_lpp_PosSRS_TxFrequencyHoppingRRC_Connected_r18;
static int ett_lpp_PosSRS_TxFrequencyHoppingRRC_Inactive_r18;
static int ett_lpp_PosSRS_BWA_RRC_Connected_r18;
static int ett_lpp_PosSRS_BWA_IndependentCA_RRC_Connected_r18;
static int ett_lpp_PosSRS_BWA_RRC_Inactive_r18;
static int ett_lpp_NR_PhaseQuality_r18;
static int ett_lpp_ReferencePoint_r16;
static int ett_lpp_T_referencePointGeographicLocation_r16;
static int ett_lpp_RelativeCartesianLocation_r18;
static int ett_lpp_X_Value_r18;
static int ett_lpp_Y_Value_r18;
static int ett_lpp_Z_Value_r18;
static int ett_lpp_RelativeLocation_r16;
static int ett_lpp_Delta_Latitude_r16;
static int ett_lpp_Delta_Longitude_r16;
static int ett_lpp_Delta_Height_r16;
static int ett_lpp_LocationUncertainty_r16;
static int ett_lpp_OTDOA_ProvideAssistanceData;
static int ett_lpp_OTDOA_ReferenceCellInfo;
static int ett_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info;
static int ett_lpp_PRS_Info;
static int ett_lpp_T_prs_MutingInfo_r9;
static int ett_lpp_T_prsHoppingInfo_r14;
static int ett_lpp_T_nb4_r14;
static int ett_lpp_TDD_Config_v1520;
static int ett_lpp_OTDOA_NeighbourCellInfoList;
static int ett_lpp_OTDOA_NeighbourFreqInfo;
static int ett_lpp_OTDOA_NeighbourCellInfoElement;
static int ett_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_Add_PRSconfigNeighbourElement_r14;
static int ett_lpp_Add_PRSconfigNeighbourElement_r14;
static int ett_lpp_OTDOA_ReferenceCellInfoNB_r14;
static int ett_lpp_PRS_Info_NB_r14;
static int ett_lpp_NPRS_Info_r14;
static int ett_lpp_T_partA_r14;
static int ett_lpp_T_nprsBitmap_r14;
static int ett_lpp_T_nprs_MutingInfoA_r14;
static int ett_lpp_T_partB_r14;
static int ett_lpp_T_nprs_MutingInfoB_r14;
static int ett_lpp_T_partA_TDD_r15;
static int ett_lpp_T_nprsBitmap_r15;
static int ett_lpp_T_nprs_MutingInfoA_r15;
static int ett_lpp_OTDOA_NeighbourCellInfoListNB_r14;
static int ett_lpp_OTDOA_NeighbourCellInfoNB_r14;
static int ett_lpp_OTDOA_RequestAssistanceData;
static int ett_lpp_T_adType_r14;
static int ett_lpp_OTDOA_ProvideLocationInformation;
static int ett_lpp_OTDOA_SignalMeasurementInformation;
static int ett_lpp_NeighbourMeasurementList;
static int ett_lpp_NeighbourMeasurementElement;
static int ett_lpp_AdditionalPathList_r14;
static int ett_lpp_MotionTimeSource_r15;
static int ett_lpp_OTDOA_SignalMeasurementInformation_NB_r14;
static int ett_lpp_NeighbourMeasurementList_NB_r14;
static int ett_lpp_NeighbourMeasurementElement_NB_r14;
static int ett_lpp_OTDOA_MeasQuality;
static int ett_lpp_AdditionalPath_r14;
static int ett_lpp_OTDOA_RequestLocationInformation;
static int ett_lpp_OTDOA_ProvideCapabilities;
static int ett_lpp_T_otdoa_Mode;
static int ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA;
static int ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0;
static int ett_lpp_SupportedBandEUTRA;
static int ett_lpp_SupportedBandEUTRA_v9a0;
static int ett_lpp_OTDOA_RequestCapabilities;
static int ett_lpp_OTDOA_Error;
static int ett_lpp_OTDOA_LocationServerErrorCauses;
static int ett_lpp_OTDOA_TargetDeviceErrorCauses;
static int ett_lpp_A_GNSS_ProvideAssistanceData;
static int ett_lpp_GNSS_CommonAssistData;
static int ett_lpp_GNSS_GenericAssistData;
static int ett_lpp_GNSS_GenericAssistDataElement;
static int ett_lpp_GNSS_PeriodicAssistData_r15;
static int ett_lpp_GNSS_ReferenceTime;
static int ett_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell;
static int ett_lpp_GNSS_ReferenceTimeForOneCell;
static int ett_lpp_GNSS_SystemTime;
static int ett_lpp_GPS_TOW_Assist;
static int ett_lpp_GPS_TOW_AssistElement;
static int ett_lpp_NetworkTime;
static int ett_lpp_T_cellID;
static int ett_lpp_T_eUTRA;
static int ett_lpp_T_uTRA;
static int ett_lpp_T_mode;
static int ett_lpp_T_fdd;
static int ett_lpp_T_tdd;
static int ett_lpp_T_gSM;
static int ett_lpp_T_nBIoT_r14;
static int ett_lpp_T_nr_r15;
static int ett_lpp_GNSS_ReferenceLocation;
static int ett_lpp_GNSS_IonosphericModel;
static int ett_lpp_KlobucharModelParameter;
static int ett_lpp_KlobucharModel2Parameter_r16;
static int ett_lpp_NeQuickModelParameter;
static int ett_lpp_GNSS_EarthOrientationParameters;
static int ett_lpp_GNSS_RTK_ReferenceStationInfo_r15;
static int ett_lpp_AntennaDescription_r15;
static int ett_lpp_AntennaReferencePointUnc_r15;
static int ett_lpp_PhysicalReferenceStationInfo_r15;
static int ett_lpp_EqualIntegerAmbiguityLevel_r16;
static int ett_lpp_ReferenceStationList_r16;
static int ett_lpp_GNSS_RTK_CommonObservationInfo_r15;
static int ett_lpp_GNSS_RTK_AuxiliaryStationData_r15;
static int ett_lpp_AuxiliaryStationList_r15;
static int ett_lpp_AuxiliaryStationElement_r15;
static int ett_lpp_Aux_ARP_Unc_r15;
static int ett_lpp_GNSS_SSR_CorrectionPoints_r16;
static int ett_lpp_T_correctionPoints_r16;
static int ett_lpp_GNSS_SSR_ListOfCorrectionPoints_r16;
static int ett_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16;
static int ett_lpp_RelativeLocationElement_r16;
static int ett_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16;
static int ett_lpp_GNSS_Integrity_ServiceParameters_r17;
static int ett_lpp_GNSS_Integrity_ServiceAlert_r17;
static int ett_lpp_GNSS_LOS_NLOS_GridPoints_r18;
static int ett_lpp_ArrayOfGridPoints_r18;
static int ett_lpp_T_bitmaskOfGrids_r18;
static int ett_lpp_VerticalGridPoints_r18;
static int ett_lpp_GNSS_SSR_IOD_Update_r18;
static int ett_lpp_GNSS_TimeModelList;
static int ett_lpp_GNSS_TimeModelElement;
static int ett_lpp_GNSS_DifferentialCorrections;
static int ett_lpp_DGNSS_SgnTypeList;
static int ett_lpp_DGNSS_SgnTypeElement;
static int ett_lpp_DGNSS_SatList;
static int ett_lpp_DGNSS_CorrectionsElement;
static int ett_lpp_GNSS_NavigationModel;
static int ett_lpp_GNSS_NavModelSatelliteList;
static int ett_lpp_GNSS_NavModelSatelliteElement;
static int ett_lpp_GNSS_ClockModel;
static int ett_lpp_GNSS_OrbitModel;
static int ett_lpp_StandardClockModelList;
static int ett_lpp_StandardClockModelElement;
static int ett_lpp_NAV_ClockModel;
static int ett_lpp_CNAV_ClockModel;
static int ett_lpp_GLONASS_ClockModel;
static int ett_lpp_SBAS_ClockModel;
static int ett_lpp_BDS_ClockModel_r12;
static int ett_lpp_BDS_ClockModel2_r16;
static int ett_lpp_NavIC_ClockModel_r16;
static int ett_lpp_NavModelKeplerianSet;
static int ett_lpp_NavModelNAV_KeplerianSet;
static int ett_lpp_T_addNAVparam;
static int ett_lpp_T_ephemSF1Rsvd;
static int ett_lpp_NavModelCNAV_KeplerianSet;
static int ett_lpp_NavModel_GLONASS_ECEF;
static int ett_lpp_NavModel_SBAS_ECEF;
static int ett_lpp_NavModel_BDS_KeplerianSet_r12;
static int ett_lpp_NavModel_BDS_KeplerianSet2_r16;
static int ett_lpp_NavModel_NavIC_KeplerianSet_r16;
static int ett_lpp_GNSS_RealTimeIntegrity;
static int ett_lpp_GNSS_BadSignalList;
static int ett_lpp_BadSignalElement;
static int ett_lpp_GNSS_DataBitAssistance;
static int ett_lpp_GNSS_DataBitsSatList;
static int ett_lpp_GNSS_DataBitsSatElement;
static int ett_lpp_GNSS_DataBitsSgnList;
static int ett_lpp_GNSS_DataBitsSgnElement;
static int ett_lpp_GNSS_AcquisitionAssistance;
static int ett_lpp_GNSS_AcquisitionAssistList;
static int ett_lpp_GNSS_AcquisitionAssistElement;
static int ett_lpp_GNSS_Almanac;
static int ett_lpp_GNSS_AlmanacList;
static int ett_lpp_GNSS_AlmanacElement;
static int ett_lpp_AlmanacKeplerianSet;
static int ett_lpp_AlmanacNAV_KeplerianSet;
static int ett_lpp_AlmanacReducedKeplerianSet;
static int ett_lpp_AlmanacMidiAlmanacSet;
static int ett_lpp_AlmanacGLONASS_AlmanacSet;
static int ett_lpp_AlmanacECEF_SBAS_AlmanacSet;
static int ett_lpp_AlmanacBDS_AlmanacSet_r12;
static int ett_lpp_AlmanacNavIC_AlmanacSet_r16;
static int ett_lpp_GNSS_UTC_Model;
static int ett_lpp_UTC_ModelSet1;
static int ett_lpp_UTC_ModelSet2;
static int ett_lpp_UTC_ModelSet3;
static int ett_lpp_UTC_ModelSet4;
static int ett_lpp_UTC_ModelSet5_r12;
static int ett_lpp_GNSS_AuxiliaryInformation;
static int ett_lpp_GNSS_ID_GPS;
static int ett_lpp_GNSS_ID_GPS_SatElement;
static int ett_lpp_GNSS_ID_GLONASS;
static int ett_lpp_GNSS_ID_GLONASS_SatElement;
static int ett_lpp_GNSS_ID_BDS_r16;
static int ett_lpp_GNSS_ID_BDS_SatElement_r16;
static int ett_lpp_BDS_DifferentialCorrections_r12;
static int ett_lpp_BDS_SgnTypeList_r12;
static int ett_lpp_BDS_SgnTypeElement_r12;
static int ett_lpp_DBDS_CorrectionList_r12;
static int ett_lpp_DBDS_CorrectionElement_r12;
static int ett_lpp_BDS_GridModelParameter_r12;
static int ett_lpp_GridIonList_r12;
static int ett_lpp_GridIonElement_r12;
static int ett_lpp_GNSS_RTK_Observations_r15;
static int ett_lpp_GNSS_ObservationList_r15;
static int ett_lpp_GNSS_RTK_SatelliteDataElement_r15;
static int ett_lpp_GNSS_RTK_SatelliteSignalDataList_r15;
static int ett_lpp_GNSS_RTK_SatelliteSignalDataElement_r15;
static int ett_lpp_GLO_RTK_BiasInformation_r15;
static int ett_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15;
static int ett_lpp_RTK_CorrectionDifferencesList_r15;
static int ett_lpp_RTK_CorrectionDifferencesElement_r15;
static int ett_lpp_Geometric_Ionospheric_Corrections_Differences_r15;
static int ett_lpp_Geometric_Ionospheric_Corrections_Differences_Element_r15;
static int ett_lpp_GNSS_RTK_Residuals_r15;
static int ett_lpp_RTK_Residuals_List_r15;
static int ett_lpp_RTK_Residuals_Element_r15;
static int ett_lpp_GNSS_RTK_FKP_Gradients_r15;
static int ett_lpp_FKP_Gradients_List_r15;
static int ett_lpp_FKP_Gradients_Element_r15;
static int ett_lpp_GNSS_SSR_OrbitCorrections_r15;
static int ett_lpp_SSR_OrbitCorrectionList_r15;
static int ett_lpp_SSR_OrbitCorrectionSatelliteElement_r15;
static int ett_lpp_ORBIT_IntegrityParameters_r17;
static int ett_lpp_SSR_IntegrityOrbitBounds_r17;
static int ett_lpp_RAC_OrbitalErrorComponents_r17;
static int ett_lpp_GNSS_SSR_ClockCorrections_r15;
static int ett_lpp_SSR_ClockCorrectionList_r15;
static int ett_lpp_SSR_ClockCorrectionSatelliteElement_r15;
static int ett_lpp_CLOCK_IntegrityParameters_r17;
static int ett_lpp_SSR_IntegrityClockBounds_r17;
static int ett_lpp_GNSS_SSR_CodeBias_r15;
static int ett_lpp_SSR_CodeBiasSatList_r15;
static int ett_lpp_SSR_CodeBiasSatElement_r15;
static int ett_lpp_SSR_CodeBiasSignalList_r15;
static int ett_lpp_SSR_CodeBiasSignalElement_r15;
static int ett_lpp_SSR_IntegrityCodeBiasBounds_r17;
static int ett_lpp_GNSS_SSR_URA_r16;
static int ett_lpp_SSR_URA_SatList_r16;
static int ett_lpp_SSR_URA_SatElement_r16;
static int ett_lpp_GNSS_SSR_PhaseBias_r16;
static int ett_lpp_SSR_PhaseBiasSatList_r16;
static int ett_lpp_SSR_PhaseBiasSatElement_r16;
static int ett_lpp_SSR_PhaseBiasSignalList_r16;
static int ett_lpp_SSR_PhaseBiasSignalElement_r16;
static int ett_lpp_SSR_IntegrityPhaseBiasBounds_r17;
static int ett_lpp_GNSS_SSR_STEC_Correction_r16;
static int ett_lpp_STEC_SatList_r16;
static int ett_lpp_STEC_SatElement_r16;
static int ett_lpp_STEC_IntegrityParameters_r17;
static int ett_lpp_STEC_IntegrityErrorBounds_r17;
static int ett_lpp_GNSS_SSR_GriddedCorrection_r16;
static int ett_lpp_GridList_r16;
static int ett_lpp_GridElement_r16;
static int ett_lpp_TropospericDelayCorrection_r16;
static int ett_lpp_STEC_ResidualSatList_r16;
static int ett_lpp_STEC_ResidualSatElement_r16;
static int ett_lpp_T_stecResidualCorrection_r16;
static int ett_lpp_SSR_GriddedCorrectionIntegrityParameters_r17;
static int ett_lpp_TropoDelayIntegrityErrorBounds_r17;
static int ett_lpp_NavIC_DifferentialCorrections_r16;
static int ett_lpp_NavIC_CorrectionListAutoNav_r16;
static int ett_lpp_NavIC_CorrectionElementAutoNav_r16;
static int ett_lpp_NavIC_EDC_r16;
static int ett_lpp_NavIC_CDC_r16;
static int ett_lpp_NavIC_GridModelParameter_r16;
static int ett_lpp_RegionIgpList_r16;
static int ett_lpp_RegionIgpElement_r16;
static int ett_lpp_GNSS_SSR_OrbitCorrectionsSet2_r17;
static int ett_lpp_GNSS_SSR_ClockCorrectionsSet2_r17;
static int ett_lpp_GNSS_SSR_URA_Set2_r17;
static int ett_lpp_GNSS_LOS_NLOS_GriddedIndications_r18;
static int ett_lpp_GridList_r18;
static int ett_lpp_GridElement_r18;
static int ett_lpp_GNSS_LOS_InfoList_r18;
static int ett_lpp_GNSS_LOS_InfoElement_r18;
static int ett_lpp_GNSS_SSR_SatellitePCVResiduals_r18;
static int ett_lpp_SSR_SatellitePCV_List_r18;
static int ett_lpp_SSR_SatellitePCV_Element_r18;
static int ett_lpp_SSR_SatellitePCV_FrequencyList_r18;
static int ett_lpp_SSR_SatellitePCV_FrequencyElement_r18;
static int ett_lpp_SSR_PhaseCenterVariationList_r18;
static int ett_lpp_A_GNSS_RequestAssistanceData;
static int ett_lpp_GNSS_CommonAssistDataReq;
static int ett_lpp_GNSS_GenericAssistDataReq;
static int ett_lpp_GNSS_GenericAssistDataReqElement;
static int ett_lpp_GNSS_PeriodicAssistDataReq_r15;
static int ett_lpp_GNSS_ReferenceTimeReq;
static int ett_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID;
static int ett_lpp_GNSS_ReferenceLocationReq;
static int ett_lpp_GNSS_IonosphericModelReq;
static int ett_lpp_GNSS_EarthOrientationParametersReq;
static int ett_lpp_GNSS_RTK_ReferenceStationInfoReq_r15;
static int ett_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15;
static int ett_lpp_GNSS_SSR_CorrectionPointsReq_r16;
static int ett_lpp_GNSS_Integrity_ServiceParametersReq_r17;
static int ett_lpp_GNSS_Integrity_ServiceAlertReq_r17;
static int ett_lpp_GNSS_SSR_IOD_UpdateReq_r18;
static int ett_lpp_GNSS_TimeModelListReq;
static int ett_lpp_GNSS_TimeModelElementReq;
static int ett_lpp_GNSS_DifferentialCorrectionsReq;
static int ett_lpp_GNSS_NavigationModelReq;
static int ett_lpp_StoredNavListInfo;
static int ett_lpp_SatListRelatedDataList;
static int ett_lpp_SatListRelatedDataElement;
static int ett_lpp_ReqNavListInfo;
static int ett_lpp_T_clockModelID_PrefList;
static int ett_lpp_T_orbitModelID_PrefList;
static int ett_lpp_GNSS_RealTimeIntegrityReq;
static int ett_lpp_GNSS_DataBitAssistanceReq;
static int ett_lpp_GNSS_DataBitsReqSatList;
static int ett_lpp_GNSS_DataBitsReqSatElement;
static int ett_lpp_GNSS_AcquisitionAssistanceReq;
static int ett_lpp_GNSS_AlmanacReq;
static int ett_lpp_GNSS_UTC_ModelReq;
static int ett_lpp_GNSS_AuxiliaryInformationReq;
static int ett_lpp_BDS_DifferentialCorrectionsReq_r12;
static int ett_lpp_BDS_GridModelReq_r12;
static int ett_lpp_GNSS_RTK_ObservationsReq_r15;
static int ett_lpp_GLO_RTK_BiasInformationReq_r15;
static int ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15;
static int ett_lpp_AUX_ReferenceStationList_r15;
static int ett_lpp_AUX_ReferenceStationID_Element_r15;
static int ett_lpp_GNSS_RTK_ResidualsReq_r15;
static int ett_lpp_GNSS_RTK_FKP_GradientsReq_r15;
static int ett_lpp_GNSS_SSR_OrbitCorrectionsReq_r15;
static int ett_lpp_T_orbit_IntegrityReq_r17;
static int ett_lpp_GNSS_SSR_ClockCorrectionsReq_r15;
static int ett_lpp_GNSS_SSR_CodeBiasReq_r15;
static int ett_lpp_GNSS_SSR_URA_Req_r16;
static int ett_lpp_GNSS_SSR_PhaseBiasReq_r16;
static int ett_lpp_GNSS_SSR_STEC_CorrectionReq_r16;
static int ett_lpp_T_stec_IntegrityReq_r17;
static int ett_lpp_GNSS_SSR_GriddedCorrectionReq_r16;
static int ett_lpp_NavIC_DifferentialCorrectionsReq_r16;
static int ett_lpp_NavIC_GridModelReq_r16;
static int ett_lpp_GNSS_SSR_OrbitCorrectionsSet2Req_r17;
static int ett_lpp_GNSS_SSR_ClockCorrectionsSet2Req_r17;
static int ett_lpp_GNSS_SSR_URA_Set2Req_r17;
static int ett_lpp_GNSS_LOS_NLOS_GriddedIndicationsReq_r18;
static int ett_lpp_T_relativeLocationInfo_r18;
static int ett_lpp_GNSS_SSR_SatellitePCVResidualsReq_r18;
static int ett_lpp_A_GNSS_ProvideLocationInformation;
static int ett_lpp_GNSS_SignalMeasurementInformation;
static int ett_lpp_MeasurementReferenceTime;
static int ett_lpp_T_networkTime;
static int ett_lpp_T_eUTRA_01;
static int ett_lpp_T_uTRA_01;
static int ett_lpp_T_mode_01;
static int ett_lpp_T_fdd_01;
static int ett_lpp_T_tdd_01;
static int ett_lpp_T_gSM_01;
static int ett_lpp_T_referenceFrame;
static int ett_lpp_T_nbIoT_r14;
static int ett_lpp_T_nr_r15_01;
static int ett_lpp_GNSS_MeasurementList;
static int ett_lpp_GNSS_MeasurementForOneGNSS;
static int ett_lpp_GNSS_SgnMeasList;
static int ett_lpp_GNSS_SgnMeasElement;
static int ett_lpp_GNSS_SatMeasList;
static int ett_lpp_GNSS_SatMeasElement;
static int ett_lpp_GNSS_LocationInformation;
static int ett_lpp_HA_GNSS_Metrics_r17;
static int ett_lpp_A_GNSS_RequestLocationInformation;
static int ett_lpp_GNSS_PositioningInstructions;
static int ett_lpp_A_GNSS_ProvideCapabilities;
static int ett_lpp_T_periodicAssistanceData_r15;
static int ett_lpp_GNSS_SupportList;
static int ett_lpp_GNSS_SupportElement;
static int ett_lpp_T_fta_MeasSupport;
static int ett_lpp_AssistanceDataSupportList;
static int ett_lpp_GNSS_CommonAssistanceDataSupport;
static int ett_lpp_GNSS_ReferenceTimeSupport;
static int ett_lpp_GNSS_ReferenceLocationSupport;
static int ett_lpp_GNSS_IonosphericModelSupport;
static int ett_lpp_T_ionoModel;
static int ett_lpp_GNSS_EarthOrientationParametersSupport;
static int ett_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15;
static int ett_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15;
static int ett_lpp_GNSS_Integrity_ServiceParametersSupport_r17;
static int ett_lpp_GNSS_Integrity_ServiceAlertSupport_r17;
static int ett_lpp_GNSS_SSR_IOD_UpdateSupport_r18;
static int ett_lpp_GNSS_GenericAssistanceDataSupport;
static int ett_lpp_GNSS_GenericAssistDataSupportElement;
static int ett_lpp_GNSS_TimeModelListSupport;
static int ett_lpp_GNSS_DifferentialCorrectionsSupport;
static int ett_lpp_GNSS_NavigationModelSupport;
static int ett_lpp_T_clockModel;
static int ett_lpp_T_orbitModel;
static int ett_lpp_GNSS_RealTimeIntegritySupport;
static int ett_lpp_GNSS_DataBitAssistanceSupport;
static int ett_lpp_GNSS_AcquisitionAssistanceSupport;
static int ett_lpp_GNSS_AlmanacSupport;
static int ett_lpp_T_almanacModel;
static int ett_lpp_GNSS_UTC_ModelSupport;
static int ett_lpp_T_utc_Model;
static int ett_lpp_GNSS_AuxiliaryInformationSupport;
static int ett_lpp_BDS_DifferentialCorrectionsSupport_r12;
static int ett_lpp_BDS_GridModelSupport_r12;
static int ett_lpp_GNSS_RTK_ObservationsSupport_r15;
static int ett_lpp_GLO_RTK_BiasInformationSupport_r15;
static int ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15;
static int ett_lpp_GNSS_RTK_ResidualsSupport_r15;
static int ett_lpp_GNSS_RTK_FKP_GradientsSupport_r15;
static int ett_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15;
static int ett_lpp_T_orbit_IntegritySup_r17;
static int ett_lpp_GNSS_SSR_ClockCorrectionsSupport_r15;
static int ett_lpp_GNSS_SSR_CodeBiasSupport_r15;
static int ett_lpp_GNSS_SSR_URA_Support_r16;
static int ett_lpp_GNSS_SSR_PhaseBiasSupport_r16;
static int ett_lpp_GNSS_SSR_STEC_CorrectionSupport_r16;
static int ett_lpp_T_stec_IntegritySup_r17;
static int ett_lpp_GNSS_SSR_GriddedCorrectionSupport_r16;
static int ett_lpp_NavIC_DifferentialCorrectionsSupport_r16;
static int ett_lpp_NavIC_GridModelSupport_r16;
static int ett_lpp_GNSS_SSR_OrbitCorrectionsSet2Support_r17;
static int ett_lpp_GNSS_SSR_ClockCorrectionsSet2Support_r17;
static int ett_lpp_GNSS_SSR_URA_Set2Support_r17;
static int ett_lpp_GNSS_LOS_NLOS_GriddedIndicationsSupport_r18;
static int ett_lpp_GNSS_SSR_SatellitePCVResidualsSupport_r18;
static int ett_lpp_A_GNSS_RequestCapabilities;
static int ett_lpp_A_GNSS_Error;
static int ett_lpp_GNSS_LocationServerErrorCauses;
static int ett_lpp_GNSS_TargetDeviceErrorCauses;
static int ett_lpp_GNSS_FrequencyID_r15;
static int ett_lpp_GNSS_ID;
static int ett_lpp_GNSS_ID_Bitmap;
static int ett_lpp_T_gnss_ids;
static int ett_lpp_GNSS_Link_CombinationsList_r15;
static int ett_lpp_GNSS_Link_Combinations_r15;
static int ett_lpp_GNSS_NavListInfo_r15;
static int ett_lpp_SatListElement_r15;
static int ett_lpp_GNSS_NetworkID_r15;
static int ett_lpp_GNSS_PeriodicControlParam_r15;
static int ett_lpp_GNSS_ReferenceStationID_r15;
static int ett_lpp_GNSS_SignalID;
static int ett_lpp_GNSS_SignalIDs;
static int ett_lpp_GNSS_SubNetworkID_r15;
static int ett_lpp_SBAS_ID;
static int ett_lpp_SBAS_IDs;
static int ett_lpp_T_sbas_IDs;
static int ett_lpp_SV_ID;
static int ett_lpp_ECID_ProvideLocationInformation;
static int ett_lpp_ECID_SignalMeasurementInformation;
static int ett_lpp_MeasuredResultsList;
static int ett_lpp_MeasuredResultsElement;
static int ett_lpp_ECID_RequestLocationInformation;
static int ett_lpp_T_requestedMeasurements;
static int ett_lpp_ECID_ProvideCapabilities;
static int ett_lpp_T_ecid_MeasSupported;
static int ett_lpp_ECID_RequestCapabilities;
static int ett_lpp_ECID_Error;
static int ett_lpp_ECID_LocationServerErrorCauses;
static int ett_lpp_ECID_TargetDeviceErrorCauses;
static int ett_lpp_TBS_ProvideLocationInformation_r13;
static int ett_lpp_TBS_MeasurementInformation_r13;
static int ett_lpp_MBS_BeaconMeasList_r13;
static int ett_lpp_MBS_BeaconMeasElement_r13;
static int ett_lpp_TBS_RequestLocationInformation_r13;
static int ett_lpp_T_mbsRequestedMeasurements_r14;
static int ett_lpp_TBS_ProvideCapabilities_r13;
static int ett_lpp_T_tbs_Modes_r13;
static int ett_lpp_T_mbs_ConfigSupport_r14;
static int ett_lpp_MBS_AssistanceDataSupportList_r14;
static int ett_lpp_TBS_RequestCapabilities_r13;
static int ett_lpp_TBS_Error_r13;
static int ett_lpp_TBS_LocationServerErrorCauses_r13;
static int ett_lpp_TBS_TargetDeviceErrorCauses_r13;
static int ett_lpp_TBS_ProvideAssistanceData_r14;
static int ett_lpp_TBS_AssistanceDataList_r14;
static int ett_lpp_MBS_AssistanceDataList_r14;
static int ett_lpp_MBS_AssistanceDataElement_r14;
static int ett_lpp_MBS_AlmanacAssistance_r14;
static int ett_lpp_MBS_AcquisitionAssistance_r14;
static int ett_lpp_TBS_RequestAssistanceData_r14;
static int ett_lpp_Sensor_ProvideLocationInformation_r13;
static int ett_lpp_Sensor_MeasurementInformation_r13;
static int ett_lpp_T_uncertainty_r14;
static int ett_lpp_Sensor_MotionInformation_r15;
static int ett_lpp_DisplacementInfoList_r15;
static int ett_lpp_DisplacementInfoListElement_r15;
static int ett_lpp_DisplacementTimeStamp_r15;
static int ett_lpp_DeltaTime_r15;
static int ett_lpp_SFN_r15;
static int ett_lpp_Displacement_r15;
static int ett_lpp_UTC_Time_r15;
static int ett_lpp_Sensor_RequestLocationInformation_r13;
static int ett_lpp_Sensor_ProvideCapabilities_r13;
static int ett_lpp_T_sensor_Modes_r13;
static int ett_lpp_Sensor_AssistanceDataSupportList_r14;
static int ett_lpp_Sensor_RequestCapabilities_r13;
static int ett_lpp_Sensor_Error_r13;
static int ett_lpp_Sensor_LocationServerErrorCauses_r13;
static int ett_lpp_Sensor_TargetDeviceErrorCauses_r13;
static int ett_lpp_Sensor_ProvideAssistanceData_r14;
static int ett_lpp_Sensor_AssistanceDataList_r14;
static int ett_lpp_T_period_v1520;
static int ett_lpp_T_area_v1520;
static int ett_lpp_PressureValidityArea_v1520;
static int ett_lpp_PressureValidityPeriod_v1520;
static int ett_lpp_Sensor_RequestAssistanceData_r14;
static int ett_lpp_WLAN_ProvideLocationInformation_r13;
static int ett_lpp_WLAN_MeasurementInformation_r13;
static int ett_lpp_WLAN_MeasurementList_r13;
static int ett_lpp_WLAN_MeasurementElement_r13;
static int ett_lpp_WLAN_AP_Identifier_r13;
static int ett_lpp_WLAN_RTT_r13;
static int ett_lpp_WLAN_RequestLocationInformation_r13;
static int ett_lpp_T_requestedMeasurements_r13;
static int ett_lpp_WLAN_ProvideCapabilities_r13;
static int ett_lpp_T_wlan_Modes_r13;
static int ett_lpp_T_wlan_MeasSupported_r13;
static int ett_lpp_T_wlan_AP_AD_Supported_r14;
static int ett_lpp_WLAN_RequestCapabilities_r13;
static int ett_lpp_WLAN_Error_r13;
static int ett_lpp_WLAN_LocationServerErrorCauses_r13;
static int ett_lpp_WLAN_TargetDeviceErrorCauses_r13;
static int ett_lpp_WLAN_ProvideAssistanceData_r14;
static int ett_lpp_SEQUENCE_SIZE_1_maxWLAN_DataSets_r14_OF_WLAN_DataSet_r14;
static int ett_lpp_WLAN_DataSet_r14;
static int ett_lpp_SEQUENCE_SIZE_1_maxWLAN_AP_r14_OF_WLAN_AP_Data_r14;
static int ett_lpp_SupportedChannels_11a_r14;
static int ett_lpp_SupportedChannels_11bg_r14;
static int ett_lpp_WLAN_AP_Data_r14;
static int ett_lpp_WLAN_AP_Location_r14;
static int ett_lpp_LocationDataLCI_r14;
static int ett_lpp_WLAN_RequestAssistanceData_r14;
static int ett_lpp_T_requestedAD_r14;
static int ett_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13;
static int ett_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13;
static int ett_lpp_BT_ProvideLocationInformation_r13;
static int ett_lpp_BT_AoA_Config_r18;
static int ett_lpp_BT_MeasurementInformation_r13;
static int ett_lpp_BT_MeasurementList_r13;
static int ett_lpp_BT_MeasurementElement_r13;
static int ett_lpp_BT_MeasurementList_r18;
static int ett_lpp_BT_MeasurementElement_r18;
static int ett_lpp_BT_RequestLocationInformation_r13;
static int ett_lpp_T_requestedMeasurements_r13_01;
static int ett_lpp_T_bt_requestedAoA_Config_r18;
static int ett_lpp_BT_SuggestedAoA_Config_r18;
static int ett_lpp_BT_ProvideCapabilities_r13;
static int ett_lpp_T_bt_Modes_r13;
static int ett_lpp_T_bt_MeasSupported_r13;
static int ett_lpp_BT_RequestCapabilities_r13;
static int ett_lpp_BT_Error_r13;
static int ett_lpp_BT_LocationServerErrorCauses_r13;
static int ett_lpp_BT_TargetDeviceErrorCauses_r13;
static int ett_lpp_BT_ProvideAssistanceData_r18;
static int ett_lpp_BT_BeaconInfo_r18;
static int ett_lpp_SEQUENCE_SIZE_1_maxBT_BeaconAD_r18_OF_BT_BeaconInfoElement_r18;
static int ett_lpp_BT_BeaconInfoElement_r18;
static int ett_lpp_SEQUENCE_SIZE_2_maxBT_BeaconAntElt_r18_OF_BT_AntElement_r18;
static int ett_lpp_SEQUENCE_SIZE_2_maxBT_BeaconAntElt_r18_OF_BT_AntSwitchElement_r18;
static int ett_lpp_BT_AntArrayConfig_r18;
static int ett_lpp_BT_AntElement_r18;
static int ett_lpp_BT_AntSwitchElement_r18;
static int ett_lpp_BT_AoD_TransmConfig_r18;
static int ett_lpp_BT_UniformLinearArray_r18;
static int ett_lpp_BT_UniformRectangularArray_r18;
static int ett_lpp_BT_UniformCircularArray_r18;
static int ett_lpp_BT_GenericArray_r18;
static int ett_lpp_BT_ULA_GenericAntElement_r18;
static int ett_lpp_BT_RequestAssistanceData_r18;
static int ett_lpp_T_requestedAD_r18;
static int ett_lpp_NR_UL_ProvideCapabilities_r16;
static int ett_lpp_NR_UL_RequestCapabilities_r16;
static int ett_lpp_NR_ECID_ProvideLocationInformation_r16;
static int ett_lpp_NR_ECID_SignalMeasurementInformation_r16;
static int ett_lpp_NR_MeasuredResultsList_r16;
static int ett_lpp_NR_MeasuredResultsElement_r16;
static int ett_lpp_T_nr_ARFCN_r16;
static int ett_lpp_MeasQuantityResults_r16;
static int ett_lpp_ResultsPerSSB_IndexList_r16;
static int ett_lpp_ResultsPerSSB_Index_r16;
static int ett_lpp_ResultsPerCSI_RS_IndexList_r16;
static int ett_lpp_ResultsPerCSI_RS_Index_r16;
static int ett_lpp_NR_ECID_RequestLocationInformation_r16;
static int ett_lpp_T_requestedMeasurements_r16;
static int ett_lpp_NR_ECID_ProvideCapabilities_r16;
static int ett_lpp_T_nr_ECID_MeasSupported_r16;
static int ett_lpp_NR_ECID_RequestCapabilities_r16;
static int ett_lpp_NR_ECID_Error_r16;
static int ett_lpp_NR_ECID_LocationServerErrorCauses_r16;
static int ett_lpp_NR_ECID_TargetDeviceErrorCauses_r16;
static int ett_lpp_NR_DL_TDOA_ProvideAssistanceData_r16;
static int ett_lpp_NR_DL_TDOA_RequestAssistanceData_r16;
static int ett_lpp_T_nr_AdType_r16;
static int ett_lpp_T_nr_PosCalcAssistanceRequest_r17;
static int ett_lpp_T_nr_IntegrityAssistanceRequest_r18;
static int ett_lpp_NR_DL_TDOA_ProvideLocationInformation_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_SignalMeasurementInformation_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_LocationInformation_r16;
static int ett_lpp_NR_DL_TDOA_SignalMeasurementInformation_r16;
static int ett_lpp_NR_DL_TDOA_MeasList_r16;
static int ett_lpp_NR_DL_TDOA_MeasElement_r16;
static int ett_lpp_T_nr_RSTD_r16;
static int ett_lpp_T_nr_los_nlos_Indicator_r17;
static int ett_lpp_SEQUENCE_SIZE_2_3_OF_NR_AggregatedDL_PRS_ResourceInfo_Element_r18;
static int ett_lpp_SEQUENCE_SIZE_1_nrNumOfSamples_1_r18_OF_NR_RSCPD_AdditionalMeasurementSamplesElement_r18;
static int ett_lpp_NR_DL_TDOA_AdditionalMeasurements_r16;
static int ett_lpp_NR_DL_TDOA_AdditionalMeasurementsExt_r17;
static int ett_lpp_NR_DL_TDOA_AdditionalMeasurementElement_r16;
static int ett_lpp_T_nr_RSTD_ResultDiff_r16;
static int ett_lpp_NR_RSCPD_AdditionalMeasurementSamplesElement_r18;
static int ett_lpp_NR_DL_TDOA_LocationInformation_r16;
static int ett_lpp_T_measurementReferenceTime_r16;
static int ett_lpp_NR_DL_TDOA_RequestLocationInformation_r16;
static int ett_lpp_T_nr_RequestedMeasurements_r16;
static int ett_lpp_T_nr_los_nlos_IndicatorRequest_r17;
static int ett_lpp_T_nr_DL_PRS_JointMeasurementRequest_r18;
static int ett_lpp_T_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18;
static int ett_lpp_T_nr_DL_PRS_RxHoppingRequest_r18;
static int ett_lpp_T_nr_DL_PRS_RxHoppingTotalBandwidth_r18;
static int ett_lpp_NR_DL_TDOA_ReportConfig_r16;
static int ett_lpp_NR_DL_TDOA_ProvideCapabilities_r16;
static int ett_lpp_T_nr_PosCalcAssistanceSupport_r17;
static int ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17;
static int ett_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17;
static int ett_lpp_T_nr_los_nlos_IndicatorSupport_r17;
static int ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17;
static int ett_lpp_T_periodicAssistanceData_r18;
static int ett_lpp_T_nr_IntegrityAssistanceSupport_r18;
static int ett_lpp_NR_DL_TDOA_MeasurementCapability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17;
static int ett_lpp_DL_TDOA_MeasCapabilityPerBand_r17;
static int ett_lpp_T_supportOfMeasurementsInTimeWindow_r18;
static int ett_lpp_NR_DL_TDOA_RequestCapabilities_r16;
static int ett_lpp_NR_DL_TDOA_Error_r16;
static int ett_lpp_NR_DL_TDOA_LocationServerErrorCauses_r16;
static int ett_lpp_NR_DL_TDOA_TargetDeviceErrorCauses_r16;
static int ett_lpp_NR_DL_AoD_ProvideAssistanceData_r16;
static int ett_lpp_NR_DL_AoD_RequestAssistanceData_r16;
static int ett_lpp_T_nr_AdType_r16_01;
static int ett_lpp_T_nr_PosCalcAssistanceRequest_r17_01;
static int ett_lpp_T_nr_IntegrityAssistanceRequest_r18_01;
static int ett_lpp_NR_DL_AoD_ProvideLocationInformation_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_SignalMeasurementInformation_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_LocationInformation_r16;
static int ett_lpp_NR_DL_AoD_SignalMeasurementInformation_r16;
static int ett_lpp_NR_DL_AoD_MeasList_r16;
static int ett_lpp_NR_DL_AoD_MeasElement_r16;
static int ett_lpp_T_nr_los_nlos_Indicator_r17_01;
static int ett_lpp_NR_DL_AoD_AdditionalMeasurements_r16;
static int ett_lpp_NR_DL_AoD_AdditionalMeasurementsExt_r17;
static int ett_lpp_NR_DL_AoD_AdditionalMeasurementElement_r16;
static int ett_lpp_NR_DL_AoD_AdditionalMeasurementElement_r17;
static int ett_lpp_NR_DL_AoD_LocationInformation_r16;
static int ett_lpp_T_measurementReferenceTime_r16_01;
static int ett_lpp_NR_DL_AoD_RequestLocationInformation_r16;
static int ett_lpp_T_nr_DL_PRS_RxHoppingRequest_r18_01;
static int ett_lpp_T_nr_DL_PRS_RxHoppingTotalBandwidth_r18_01;
static int ett_lpp_NR_DL_AoD_ReportConfig_r16;
static int ett_lpp_T_nr_los_nlos_IndicatorRequest_r17_01;
static int ett_lpp_NR_DL_AoD_ProvideCapabilities_r16;
static int ett_lpp_T_nr_PosCalcAssistanceSupport_r17_01;
static int ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01;
static int ett_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01;
static int ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_01;
static int ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01;
static int ett_lpp_T_nr_IntegrityAssistanceSupport_r18_01;
static int ett_lpp_NR_DL_AoD_MeasurementCapability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16;
static int ett_lpp_DL_AoD_MeasCapabilityPerBand_r16;
static int ett_lpp_T_supportOfMeasurementsInTimeWindow_r18_01;
static int ett_lpp_NR_DL_AoD_RequestCapabilities_r16;
static int ett_lpp_NR_DL_AoD_Error_r16;
static int ett_lpp_NR_DL_AoD_LocationServerErrorCauses_r16;
static int ett_lpp_NR_DL_AoD_TargetDeviceErrorCauses_r16;
static int ett_lpp_NR_Multi_RTT_ProvideAssistanceData_r16;
static int ett_lpp_NR_Multi_RTT_RequestAssistanceData_r16;
static int ett_lpp_T_nr_AdType_r16_02;
static int ett_lpp_NR_Multi_RTT_ProvideLocationInformation_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_Multi_RTT_SignalMeasurementInformation_r16;
static int ett_lpp_NR_Multi_RTT_SignalMeasurementInformation_r16;
static int ett_lpp_SEQUENCE_SIZE_1_maxTxTEG_Sets_r17_OF_NR_SRS_TxTEG_Element_r17;
static int ett_lpp_NR_Multi_RTT_MeasList_r16;
static int ett_lpp_NR_Multi_RTT_MeasElement_r16;
static int ett_lpp_T_nr_UE_RxTxTimeDiff_r16;
static int ett_lpp_T_nr_los_nlos_Indicator_r17_02;
static int ett_lpp_NR_Multi_RTT_AdditionalMeasurements_r16;
static int ett_lpp_NR_Multi_RTT_AdditionalMeasurementsExt_r17;
static int ett_lpp_NR_Multi_RTT_AdditionalMeasurementElement_r16;
static int ett_lpp_T_nr_UE_RxTxTimeDiffAdditional_r16;
static int ett_lpp_NR_SRS_TxTEG_Element_r17;
static int ett_lpp_T_carrierFreq_r17;
static int ett_lpp_T_srs_PosResourceList_r17;
static int ett_lpp_NR_UE_RxTx_TEG_Info_r17;
static int ett_lpp_T_case1_r17;
static int ett_lpp_T_case2_r17;
static int ett_lpp_T_case3_r17;
static int ett_lpp_NR_RSCP_AdditionalMeasurements_r18;
static int ett_lpp_NR_NTN_UE_RxTxMeasurements_r18;
static int ett_lpp_NR_Multi_RTT_RequestLocationInformation_r16;
static int ett_lpp_T_nr_RequestedMeasurements_r16_01;
static int ett_lpp_T_nr_los_nlos_IndicatorRequest_r17_02;
static int ett_lpp_T_nr_DL_PRS_RxHoppingRequest_r18_02;
static int ett_lpp_T_nr_DL_PRS_RxHoppingTotalBandwidth_r18_02;
static int ett_lpp_T_nr_DL_PRS_JointMeasurementRequest_r18_01;
static int ett_lpp_T_nr_DL_PRS_JointMeasurementRequestedPFL_List_r18_01;
static int ett_lpp_NR_Multi_RTT_ReportConfig_r16;
static int ett_lpp_NR_Multi_RTT_ProvideCapabilities_r16;
static int ett_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02;
static int ett_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17;
static int ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_02;
static int ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02;
static int ett_lpp_NR_Multi_RTT_MeasurementCapability_r16;
static int ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17;
static int ett_lpp_Multi_RTT_MeasCapabilityPerBand_r17;
static int ett_lpp_T_supportOfMeasurementsInTimeWindow_r18_02;
static int ett_lpp_NR_Multi_RTT_RequestCapabilities_r16;
static int ett_lpp_NR_Multi_RTT_Error_r16;
static int ett_lpp_NR_Multi_RTT_LocationServerErrorCauses_r16;
static int ett_lpp_NR_Multi_RTT_TargetDeviceErrorCauses_r16;
static int ett_lpp_AssistanceDataSIBelement_r15;
static int ett_lpp_CipheringKeyData_r15;
static int ett_lpp_SegmentationInfo_r15;
static int ett_lpp_OTDOA_UE_Assisted_r15;
static int ett_lpp_NR_UEB_TRP_LocationData_r16;
static int ett_lpp_NR_UEB_TRP_RTD_Info_r16;
static int ett_lpp_NR_IntegrityParameters_r18;

/* Include constants */
#define maxEPDU                        16
#define maxAddPRSconfig_r14            2
#define maxAvailNarrowBands_Minus1_r14 15
#define maxFreqLayers                  3
#define maxCarrier_r14                 5
#define maxCells_r14                   72
#define maxPaths_r14                   2
#define maxBands                       64
#define maxFBI                         64
#define maxFBI_Plus1                   65
#define maxFBI2                        256
#define maxEARFCN                      65535
#define maxEARFCN_Plus1                65536
#define maxEARFCN2                     262143
#define maxMBS_r14                     64
#define maxWLAN_AP_r13                 64
#define maxKnownAPs_r14                2048
#define maxVisibleAPs_r14              32
#define maxWLAN_AP_r14                 128
#define maxWLAN_DataSets_r14           8
#define maxBT_Beacon_r13               32
#define maxBT_BeaconAntElt_r18         74
#define maxBT_BeaconAD_r18             64
#define nrMaxBands_r16                 1024
#define nrMaxFreqLayers_r16            4
#define nrMaxFreqLayers_1_r16          3
#define nrMaxNumDL_PRS_ResourcesPerSet_1_r16 63
#define nrMaxNumDL_PRS_ResourceSetsPerTRP_1_r16 7
#define nrMaxResourceIDs_r16           64
#define nrMaxResourceOffsetValue_1_r16 511
#define nrMaxResourcesPerSet_r16       64
#define nrMaxSetsPerTrpPerFreqLayer_r16 2
#define nrMaxSetsPerTrpPerFreqLayer_1_r16 1
#define nrMaxTRPs_r16                  256
#define nrMaxTRPsPerFreq_r16           64
#define nrMaxTRPsPerFreq_1_r16         63
#define maxSimultaneousBands_r16       4
#define maxBandComb_r16                1024
#define nrMaxConfiguredBands_r16       16
#define maxNumOfRxTEGs_r17             32
#define maxNumOfRxTEGs_1_r17           31
#define maxNumOfTxTEGs_1_r17           7
#define maxTxTEG_Sets_r17              256
#define maxNumOfRxTxTEGs_1_r17         255
#define maxNumOfTRP_TxTEGs_1_r17       7
#define maxNumOfSRS_PosResources_r17   64
#define maxNumOfSRS_PosResources_1_r17 63
#define maxNumResourcesPerAngle_r17    24
#define maxNumPrioResources_r17        24
#define maxAddMeasTDOA_r17             31
#define maxAddMeasAoD_r17              23
#define maxAddMeasRTT_r17              31
#define maxOD_DL_PRS_Configs_r17       8
#define maxCellIDsPerArea_r17          256
#define maxNrOfAreas_r17               16
#define maxMeasInstances_r17           32
#define nrMaxNumPRS_BandWidthAggregation_r18 256
#define nrNumOfSamples_r18             4
#define nrNumOfSamples_1_r18           3

typedef enum _T_GNSS_ID_enum {
  T_GNSS_ID_GPS =   0,
  T_GNSS_ID_SBAS =   1,
  T_GNSS_ID_QZSS =   2,
  T_GNSS_ID_GALILEO =   3,
  T_GNSS_ID_GLONASS =   4,
  T_GNSS_ID_BDS =   5,
  T_GNSS_ID_NAVIC_V1610 =   6
} T_GNSS_ID_enum;

static const value_string lpp_ePDU_ID_vals[] = {
  { 1, "OMA LPP extensions (LPPe)"},
  { 0, NULL}
};

struct lpp_private_data {
  lpp_pos_sib_type_t pos_sib_type;
  bool is_ciphered;
  bool is_segmented;
};

static struct lpp_private_data*
lpp_get_private_data(packet_info *pinfo)
{
  struct lpp_private_data *lpp_data = (struct lpp_private_data*)p_get_proto_data(pinfo->pool, pinfo, proto_lpp, 0);
  if (!lpp_data) {
    lpp_data = wmem_new0(pinfo->pool, struct lpp_private_data);
    p_add_proto_data(pinfo->pool, pinfo, proto_lpp, 0, lpp_data);
  }
  return lpp_data;
}

/* Forward declarations */
static int dissect_GNSS_ReferenceTime_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_ReferenceLocation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_IonosphericModel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_EarthOrientationParameters_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_ReferenceStationInfo_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_CommonObservationInfo_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_AuxiliaryStationData_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_CorrectionPoints_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_Integrity_ServiceParameters_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_Integrity_ServiceAlert_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_TimeModelList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_DifferentialCorrections_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_NavigationModel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RealTimeIntegrity_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_DataBitAssistance_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_AcquisitionAssistance_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_Almanac_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_UTC_Model_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_AuxiliaryInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_BDS_DifferentialCorrections_r12_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_BDS_GridModelParameter_r12_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_Observations_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GLO_RTK_BiasInformation_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_MAC_CorrectionDifferences_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_Residuals_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_FKP_Gradients_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_OrbitCorrections_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_ClockCorrections_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_CodeBias_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_URA_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_PhaseBias_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_STEC_Correction_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_GriddedCorrection_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NavIC_DifferentialCorrections_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NavIC_GridModelParameter_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_OTDOA_UE_Assisted_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_Sensor_AssistanceDataList_r14_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_TBS_AssistanceDataList_r14_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_DL_PRS_AssistanceData_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_UEB_TRP_LocationData_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_UEB_TRP_RTD_Info_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_TRP_BeamAntennaInfo_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_DL_PRS_TRP_TEG_Info_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_On_Demand_DL_PRS_Configurations_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_OrbitCorrectionsSet2_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_ClockCorrectionsSet2_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_URA_Set2_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_LOS_NLOS_GridPoints_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_IOD_Update_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_LOS_NLOS_GriddedIndications_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_SatellitePCVResiduals_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_PRU_DL_Info_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_IntegrityRiskParameters_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_IntegrityServiceParameters_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_IntegrityServiceAlert_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_IntegrityParameters_r18_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static void
lpp_degreesLatitude_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%f degrees (%u)",
             ((float)v/8388607.0)*90, v);
}

static void
lpp_degreesLongitude_fmt(char *s, uint32_t v)
{
  int32_t longitude = (int32_t) v;

  snprintf(s, ITEM_LABEL_LENGTH, "%f degrees (%d)",
             ((float)longitude/8388608.0)*180, longitude);
}

static void
lpp_uncertainty_fmt(char *s, uint32_t v)
{
  double uncertainty = 10*(pow(1.1, (double)v)-1);

  if (uncertainty < 1000) {
    snprintf(s, ITEM_LABEL_LENGTH, "%fm (%u)", uncertainty, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%fkm (%u)", uncertainty/1000, v);
  }
}

static void
lpp_angle_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%u degrees (%u)", 2*v, v);
}

static void
lpp_confidence_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "no information (0)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%u%%", v);
  }
}

static void
lpp_1_10_degrees_fmt(char *s, uint32_t v)
{
  double val = (double)v/10;

  snprintf(s, ITEM_LABEL_LENGTH, "%g degrees (%u)", val, v);
}

static void
lpp_1_100_m_fmt(char *s, uint32_t v)
{
  double val = (double)v/100;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%u)", val, v);
}

static void
lpp_measurementLimit_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%u octets (%u)", 100*v, v);
}

static void
lpp_altitude_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um", v);
}

static void
lpp_uncertaintyAltitude_fmt(char *s, uint32_t v)
{
  double uncertainty = 45*(pow(1.025, (double)v)-1);

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%u)", uncertainty, v);
}

static void
lpp_radius_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um (%u)", 5*v, v);
}

static void
lpp_nr_LTE_fineTiming_Offset_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
lpp_expectedRSTD_fmt(char *s, uint32_t v)
{
  int32_t rstd = 3*((int32_t)v-8192);

  snprintf(s, ITEM_LABEL_LENGTH, "%dTs (%u)", rstd, v);
}

static void
lpp_expectedRSTD_Uncertainty_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%uTs (%u)", 3*v, v);
}

static void
lpp_rstd_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSTD < -15391Ts (0)");
  } else if (v < 2260) {
    snprintf(s, ITEM_LABEL_LENGTH, "-%uTs <= RSTD < -%uTs (%u)", 15391-5*(v-1), 15391-5*v, v);
  } else if (v < 6355) {
    snprintf(s, ITEM_LABEL_LENGTH, "-%uTs <= RSTD < -%uTs (%u)", 6356-v, 6355-v, v);
  } else if (v == 6355) {
    snprintf(s, ITEM_LABEL_LENGTH, "-1Ts <= RSTD <= 0Ts (6355)");
  } else if (v < 10452) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs < RSTD <= %uTs (%u)", v-6356, v-6355, v);
  } else if (v < 12711) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs < RSTD <= %uTs (%u)", 5*(v-1)-48159, 5*v-48159, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "15391Ts < RSTD (12711)");
  }
}

static const value_string lpp_error_Resolution_vals[] = {
  { 0, "5 meters"},
  { 1, "10 meters"},
  { 2, "20 meters"},
  { 3, "30 meters"},
  { 0, NULL}
};

static const value_string lpp_error_Value_vals[] = {
  {  0, "0 to (R*1-1) meters"},
  {  1, "R*1 to (R*2-1) meters"},
  {  2, "R*2 to (R*3-1) meters"},
  {  3, "R*3 to (R*4-1) meters"},
  {  4, "R*4 to (R*5-1) meters"},
  {  5, "R*5 to (R*6-1) meters"},
  {  6, "R*6 to (R*7-1) meters"},
  {  7, "R*7 to (R*8-1) meters"},
  {  8, "R*8 to (R*9-1) meters"},
  {  9, "R*9 to (R*10-1) meters"},
  { 10, "R*10 to (R*11-1) meters"},
  { 11, "R*11 to (R*12-1) meters"},
  { 12, "R*12 to (R*13-1) meters"},
  { 13, "R*13 to (R*14-1) meters"},
  { 14, "R*14 to (R*15-1) meters"},
  { 15, "R*15 to (R*16-1) meters"},
  { 16, "R*16 to (R*17-1) meters"},
  { 17, "R*17 to (R*18-1) meters"},
  { 18, "R*18 to (R*19-1) meters"},
  { 19, "R*19 to (R*20-1) meters"},
  { 20, "R*20 to (R*21-1) meters"},
  { 21, "R*21 to (R*22-1) meters"},
  { 22, "R*22 to (R*23-1) meters"},
  { 23, "R*23 to (R*24-1) meters"},
  { 24, "R*24 to (R*25-1) meters"},
  { 25, "R*25 to (R*26-1) meters"},
  { 26, "R*26 to (R*27-1) meters"},
  { 27, "R*27 to (R*28-1) meters"},
  { 28, "R*28 to (R*29-1) meters"},
  { 29, "R*29 to (R*30-1) meters"},
  { 30, "R*30 to (R*31-1) meters"},
  { 31, "R*31 meters or more"},
  { 0, NULL}
};
static value_string_ext lpp_error_Value_vals_ext = VALUE_STRING_EXT_INIT(lpp_error_Value_vals);

static const value_string lpp_error_NumSamples_vals[] = {
  {  0, "Not the baseline metric"},
  {  1, "5-9"},
  {  2, "10-14"},
  {  3, "15-24"},
  {  4, "25-34"},
  {  5, "35-44"},
  {  6, "45-54"},
  {  7, "55 or more"},
  { 0, NULL}
};

static void
lpp_relativeTimeDifference_fmt(char *s, uint32_t v)
{
  double rtd = (double)((int32_t)v)*0.5;

  snprintf(s, ITEM_LABEL_LENGTH, "%.1f Ts (%d)", rtd, (int32_t)v);
}

static void
lpp_referenceTimeUnc_fmt(char *s, uint32_t v)
{
  double referenceTimeUnc = 0.5*(pow(1.14, (double)v)-1);

  snprintf(s, ITEM_LABEL_LENGTH, "%fus (%u)", referenceTimeUnc, v);
}

static const value_string lpp_kp_vals[] = {
  { 0, "No UTC correction at the end of current quarter"},
  { 1, "UTC correction by plus (+1 s) in the end of current quarter"},
  { 3, "UTC correction by minus (-1 s) in the end of current quarter"},
  { 0, NULL}
};

static void
lpp_fractionalSecondsFromFrameStructureStart_fmt(char *s, uint32_t v)
{
  float frac = ((float)v)/4;

  snprintf(s, ITEM_LABEL_LENGTH, "%fus (%u)", frac, v);
}

static void
lpp_frameDrift_fmt(char *s, uint32_t v)
{
  double drift = (double)((int32_t)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", drift, (int32_t)v);
}

static const value_string lpp_dataID_vals[] = {
  { 0, "Parameters are applicable worldwide"},
  { 1, "Parameters have been generated by BDS"},
  { 3, "Parameters have been generated by QZSS"},
  { 0, NULL}
};

static void
lpp_alpha0_fmt(char *s, uint32_t v)
{
  double alpha = (double)((int32_t)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", alpha, (int32_t)v);
}

static void
lpp_alpha1_fmt(char *s, uint32_t v)
{
  double alpha = (double)((int32_t)v)*pow(2, -27);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", alpha, (int32_t)v);
}

static void
lpp_alpha2_3_fmt(char *s, uint32_t v)
{
  double alpha = (double)((int32_t)v)*pow(2, -24);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", alpha, (int32_t)v);
}

static void
lpp_beta0_fmt(char *s, uint32_t v)
{
  double beta = (double)((int32_t)v)*pow(2, 11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", beta, (int32_t)v);
}

static void
lpp_beta1_fmt(char *s, uint32_t v)
{
  double beta = (double)((int32_t)v)*pow(2, 14);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", beta, (int32_t)v);
}

static void
lpp_beta2_3_fmt(char *s, uint32_t v)
{
  double beta = (double)((int32_t)v)*pow(2, 16);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", beta, (int32_t)v);
}

static void
lpp_ai0_fmt(char *s, uint32_t v)
{
  double ai = (double)v*pow(2, -2);

  snprintf(s, ITEM_LABEL_LENGTH, "%gsfu (%u)", ai, v);
}

static void
lpp_ai1_fmt(char *s, uint32_t v)
{
  double ai = (double)v*pow(2, -8);

  snprintf(s, ITEM_LABEL_LENGTH, "%gsfu/degree (%u)", ai, v);
}

static void
lpp_ai2_fmt(char *s, uint32_t v)
{
  double ai = (double)v*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%gsfu/degree2 (%u)", ai, v);
}

static void
lpp_teop_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_pmX_Y_fmt(char *s, uint32_t v)
{
  double pm = (double)((int32_t)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%g arc-seconds (%d)", pm, (int32_t)v);
}

static void
lpp_pmX_Ydot_fmt(char *s, uint32_t v)
{
  double pmDot = (double)((int32_t)v)*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%g arc-seconds/day (%d)", pmDot, (int32_t)v);
}

static void
lpp_deltaUT1_fmt(char *s, uint32_t v)
{
  double deltaUT1 = (double)((int32_t)v)*pow(2, -24);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", deltaUT1, (int32_t)v);
}

static void
lpp_deltaUT1dot_fmt(char *s, uint32_t v)
{
  double deltaUT1dot = (double)((int32_t)v)*pow(2, -25);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/day (%d)", deltaUT1dot, (int32_t)v);
}

static void
lpp_1_1000m_64_fmt(char *s, uint64_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%"PRId64")", (double)v/1000, (int64_t)v);
}

static void
lpp_1_1000m_32_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", (double)v/1000, (int32_t)v);
}

static const value_string lpp_clockSteeringIndicator_vals[] = {
  { 0, "Clock steering is not applied"},
  { 1, "Clock steering has been applied"},
  { 2, "Unknown clock steering status"},
  { 3, "Reserved"},
  { 0, NULL}
};

static const value_string lpp_externalClockIndicator_vals[] = {
  { 0, "Internal clock is used"},
  { 1, "External clock is used, clock status is \"locked\""},
  { 2, "External clock is used, clock status is \"not locked\", which may indicate external clock failure and that the transmitted data may not be reliable"},
  { 3, "Unknown clock is used"},
  { 0, NULL}
};

static const value_string lpp_smoothingIndicator_r15_vals[] = {
  { 0, "Other type of smoothing is used"},
  { 1, "Divergence-free smoothing is used"},
  { 0, NULL}
};

static const value_string lpp_smoothingInterval_r15_vals[] = {
  { 0, "No smoothing"},
  { 1, "< 30 s"},
  { 2, "30-60 s"},
  { 3, "1-2 min"},
  { 4, "2-4 min"},
  { 5, "4-8 min"},
  { 6, "> 8 min"},
  { 7, "Unlimited smoothing interval"},
  { 0, NULL}
};

static void
lpp_aux_master_delta_fmt(char *s, uint32_t v)
{
  double delta = (double)((int32_t)v)*25*pow(10, -6);
  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%u)", delta, (int32_t)v);
}

static void
lpp_gnss_TimeModelRefTime_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", v*16, v);
}

static void
lpp_tA0_fmt(char *s, uint32_t v)
{
  double tA0 = (double)((int32_t)v)*pow(2, -35);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", tA0, (int32_t)v);
}

static void
lpp_tA1_fmt(char *s, uint32_t v)
{
  double tA1 = (double)((int32_t)v)*pow(2, -51);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", tA1, (int32_t)v);
}

static void
lpp_tA2_fmt(char *s, uint32_t v)
{
  double tA2 = (double)((int32_t)v)*pow(2, -68);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", tA2, (int32_t)v);
}

static const value_string lpp_gnss_TO_ID_vals[] = {
  { 1, "GPS"},
  { 2, "Galileo"},
  { 3, "QZSS"},
  { 4, "GLONASS"},
  { 0, NULL}
};

static const value_string lpp_gnss_StatusHealth_vals[] = {
  { 0, "UDRE Scale Factor = 1.0"},
  { 1, "UDRE Scale Factor = 0.75"},
  { 2, "UDRE Scale Factor = 0.5"},
  { 3, "UDRE Scale Factor = 0.3"},
  { 4, "UDRE Scale Factor = 0.2"},
  { 5, "UDRE Scale Factor = 0.1"},
  { 6, "Reference Station Transmission Not Monitored"},
  { 7, "Data is invalid - disregard"},
  { 0, NULL}
};

static const value_string lpp_udre_vals[] = {
  { 0, "UDRE <= 1.0m"},
  { 1, "1.0m < UDRE <= 4.0m"},
  { 2, "4.0m < UDRE <= 8.0m"},
  { 3, "8.0m < UDRE"},
  { 0, NULL}
};

static void
lpp_pseudoRangeCor_fmt(char *s, uint32_t v)
{
  double pseudoRangeCor = ((double)(int32_t)v)*0.32;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%d)", pseudoRangeCor, (int32_t)v);
}

static void
lpp_rangeRateCor_fmt(char *s, uint32_t v)
{
  double rangeRateCor = ((double)(int32_t)v)*0.032;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", rangeRateCor, (int32_t)v);
}

static const value_string lpp_udreGrowthRate_vals[] = {
  { 0, "1.5"},
  { 1, "2"},
  { 2, "4"},
  { 3, "6"},
  { 4, "8"},
  { 5, "10"},
  { 6, "12"},
  { 7, "16"},
  { 0, NULL}
};

static const value_string lpp_udreValidityTime_vals[] = {
  { 0, "20s"},
  { 1, "40s"},
  { 2, "80s"},
  { 3, "160s"},
  { 4, "320s"},
  { 5, "640s"},
  { 6, "1280s"},
  { 7, "2560s"},
  { 0, NULL}
};

static const value_string lpp_signal_health_status_vals[] = {
  { 0, "Signal OK"},
  { 1, "Signal out of service"},
  { 2, "Signal will be out of service"},
  { 3, "Signal Component currently in Test"},
  { 0, NULL}
};
static void
lpp_stanClockToc_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um/s (%u)", 60*v, v);
}

static void
lpp_stanClockAF2_fmt(char *s, uint32_t v)
{
  double stanClockAF2 = (double)((int32_t)v)*pow(2, -59);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", stanClockAF2, (int32_t)v);
}

static void
lpp_stanClockAF1_fmt(char *s, uint32_t v)
{
  double stanClockAF1 = (double)((int32_t)v)*pow(2, -46);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", stanClockAF1, (int32_t)v);
}

static void
lpp_stanClockAF0_fmt(char *s, uint32_t v)
{
  double stanClockAF0 = (double)((int32_t)v)*pow(2, -34);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", stanClockAF0, (int32_t)v);
}

static void
lpp_stanClockTgd_fmt(char *s, uint32_t v)
{
  double stanClockTgd = (double)((int32_t)v)*pow(2, -32);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", stanClockTgd, (int32_t)v);
}

static void
lpp_sisa_fmt(char *s, uint32_t v)
{
  if (v < 50) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", v, v);
  } else if (v < 75) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", 50+((v-50)*2), v);
  } else if (v < 100) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", 100+((v-75)*4), v);
  } else if (v < 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", 200+((v-100)*16), v);
  } else if (v < 255) {
    snprintf(s, ITEM_LABEL_LENGTH, "Spare (%u)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "No Accuracy Prediction Available (255)");
  }
}

static const value_string lpp_stanModelID_vals[] = {
  { 0, "I/Nav"},
  { 1, "F/Nav"},
  { 0, NULL}
};

static void
lpp_navToc_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_navaf2_fmt(char *s, uint32_t v)
{
  double navaf2 = (double)((int32_t)v)*pow(2, -55);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", navaf2, (int32_t)v);
}

static void
lpp_navaf1_fmt(char *s, uint32_t v)
{
  double navaf1 = (double)((int32_t)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", navaf1, (int32_t)v);
}

static void
lpp_navaf0_navTgd_fmt(char *s, uint32_t v)
{
  double navaf0_navTgd = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", navaf0_navTgd, (int32_t)v);
}

static void
lpp_cnavToc_cnavTop_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 300*v, v);
}

static void
lpp_cnavAf2_fmt(char *s, uint32_t v)
{
  double cnavAf2 = (double)((int32_t)v)*pow(2, -60);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", cnavAf2, (int32_t)v);
}

static void
lpp_cnavAf1_fmt(char *s, uint32_t v)
{
  double cnavAf1 = (double)((int32_t)v)*pow(2, -48);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", cnavAf1, (int32_t)v);
}

static void
lpp_cnavX_fmt(char *s, uint32_t v)
{
  double cnavX = (double)((int32_t)v)*pow(2, -35);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", cnavX, (int32_t)v);
}

static void
lpp_gloTau_gloDeltaTau_fmt(char *s, uint32_t v)
{
  double gloTau_gloDeltaTau = (double)((int32_t)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", gloTau_gloDeltaTau, (int32_t)v);
}

static void
lpp_gloGamma_fmt(char *s, uint32_t v)
{
  double gloGamma = (double)((int32_t)v)*pow(2, -40);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%d)", gloGamma, (int32_t)v);
}

static void
lpp_sbasTo_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_sbasAgfo_fmt(char *s, uint32_t v)
{
  double sbasAgfo = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", sbasAgfo, (int32_t)v);
}

static void
lpp_sbasAgf1_fmt(char *s, uint32_t v)
{
  double sbasAgf1 = (double)((int32_t)v)*pow(2, -40);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", sbasAgf1, (int32_t)v);
}

static void
lpp_bdsAODC_AODE_r12_fmt(char *s, uint32_t v)
{
  if (v < 25) {
    snprintf(s, ITEM_LABEL_LENGTH, "Age of the satellite clock correction parameters is %u hours (%u)", v, v);
  } else if (v < 31) {
    snprintf(s, ITEM_LABEL_LENGTH, "Age of the satellite clock correction parameters is %u days (%u)", v-23, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "Age of the satellite clock correction parameters is over 7 days (%u)", v);
  }
}


static void
lpp_bdsToc_Toe_r12_fmt(char *s, uint32_t v)
{
  double bdsToc = (double)((int32_t)v)*pow(2, 3);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", bdsToc, (int32_t)v);
}

static void
lpp_bdsA0_r12_fmt(char *s, uint32_t v)
{
  double bdsA0 = (double)((int32_t)v)*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", bdsA0, (int32_t)v);
}

static void
lpp_bdsA1_r12_fmt(char *s, uint32_t v)
{
  double bdsA1 = (double)((int32_t)v)*pow(2, -50);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", bdsA1, (int32_t)v);
}

static void
lpp_bdsA2_r12_fmt(char *s, uint32_t v)
{
  double bdsA2 = (double)((int32_t)v)*pow(2, -66);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", bdsA2, (int32_t)v);
}

static void
lpp_bdsTgd1_r12_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gns (%d)", (float)((int32_t)v)*0.1, (int32_t)v);
}

static void
lpp_keplerToe_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 60*v, v);
}

static void
lpp_keplerW_M0_I0_Omega0_fmt(char *s, uint32_t v)
{
  double keplerW_M0_I0_Omega0 = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", keplerW_M0_I0_Omega0, (int32_t)v);
}

static void
lpp_keplerDeltaN_OmegaDot_IDot_fmt(char *s, uint32_t v)
{
  double keplerDeltaN_OmegaDot_IDot = (double)((int32_t)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", keplerDeltaN_OmegaDot_IDot, (int32_t)v);
}

static void
lpp_keplerE_fmt(char *s, uint32_t v)
{
  double keplerE = (double)v*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", keplerE, v);
}

static void
lpp_keplerAPowerHalf_fmt(char *s, uint32_t v)
{
  double keplerAPowerHalf = (double)v*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", keplerAPowerHalf, v);
}

static void
lpp_keplerCrs_Crc_fmt(char *s, uint32_t v)
{
  double keplerCrs_Crc = (double)((int32_t)v)*pow(2, -5);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", keplerCrs_Crc, (int32_t)v);
}

static void
lpp_keplerCx_fmt(char *s, uint32_t v)
{
  double keplerCx = (double)((int32_t)v)*pow(2, -29);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", keplerCx, (int32_t)v);
}

static void
lpp_navToe_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_navOmega_M0_I0_OmegaA0_fmt(char *s, uint32_t v)
{
  double navOmega_M0_I0_OmegaA0 = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", navOmega_M0_I0_OmegaA0, (int32_t)v);
}

static void
lpp_navDeltaN_OmegaADot_IDot_fmt(char *s, uint32_t v)
{
  double navDeltaN_OmegaADot_IDot = (double)((int32_t)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", navDeltaN_OmegaADot_IDot, (int32_t)v);
}

static void
lpp_navE_fmt(char *s, uint32_t v)
{
  double navE = (double)v*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", navE, v);
}

static void
lpp_navAPowerHalf_fmt(char *s, uint32_t v)
{
  double navAPowerHalf = (double)v*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", navAPowerHalf, v);
}

static void
lpp_navCrs_Crc_fmt(char *s, uint32_t v)
{
  double navCrs_Crc = (double)((int32_t)v)*pow(2, -5);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", navCrs_Crc, (int32_t)v);
}

static void
lpp_navCx_fmt(char *s, uint32_t v)
{
  double navCx = (double)((int32_t)v)*pow(2, -29);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", navCx, (int32_t)v);
}

static void
lpp_cnavDeltaA_fmt(char *s, uint32_t v)
{
  double cnavDeltaA = (double)((int32_t)v)*pow(2, -9);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", cnavDeltaA, (int32_t)v);
}

static void
lpp_cnavAdot_fmt(char *s, uint32_t v)
{
  double cnavAdot = (double)((int32_t)v)*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", cnavAdot, (int32_t)v);
}

static void
lpp_cnavDeltaNo_fmt(char *s, uint32_t v)
{
  double cnavDeltaNo = (double)((int32_t)v)*pow(2, -44);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", cnavDeltaNo, (int32_t)v);
}

static void
lpp_cnavDeltaNoDot_fmt(char *s, uint32_t v)
{
  double cnavDeltaNoDot = (double)((int32_t)v)*pow(2, -57);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s2 (%d)", cnavDeltaNoDot, (int32_t)v);
}

static void
lpp_cnavDeltaOmegaDot_IoDot_fmt(char *s, uint32_t v)
{
  double cnavDeltaOmegaDot_IoDot = (double)((int32_t)v)*pow(2, -44);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", cnavDeltaOmegaDot_IoDot, (int32_t)v);
}

static void
lpp_cnavCx_fmt(char *s, uint32_t v)
{
  double cnavCx = (double)((int32_t)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", cnavCx, (int32_t)v);
}

static void
lpp_cnavCrs_Crc_fmt(char *s, uint32_t v)
{
  double cnavCrs_Crc = (double)((int32_t)v)*pow(2, -8);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", cnavCrs_Crc, (int32_t)v);
}

static void
lpp_gloX_Y_Z_fmt(char *s, uint32_t v)
{
  double gloX_Y_Z = (double)((int32_t)v)*pow(2, -11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gkm (%d)", gloX_Y_Z, (int32_t)v);
}

static void
lpp_gloXdot_Ydot_Zdot_fmt(char *s, uint32_t v)
{
  double gloXdot_Ydot_Zdot = (double)((int32_t)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gkm/s (%d)", gloXdot_Ydot_Zdot, (int32_t)v);
}

static void
lpp_gloXdotdot_Ydotdot_Zdotdot_fmt(char *s, uint32_t v)
{
  double gloXdotdot_Ydotdot_Zdotdot = (double)((int32_t)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gkm/s2 (%d)", gloXdotdot_Ydotdot_Zdotdot, (int32_t)v);
}

static void
lpp_sbasXg_Yg_fmt(char *s, uint32_t v)
{
  double sbasXg_Yg = (double)((int32_t)v)*0.08;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%d)", sbasXg_Yg, (int32_t)v);
}

static void
lpp_sbasZg_fmt(char *s, uint32_t v)
{
  double sbasZg = (double)((int32_t)v)*0.4;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%d)", sbasZg, (int32_t)v);
}

static void
lpp_sbasXgDot_YgDot_fmt(char *s, uint32_t v)
{
  double sbasXgDot_YgDot = (double)((int32_t)v)*0.000625;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", sbasXgDot_YgDot, (int32_t)v);
}

static void
lpp_sbasZgDot_fmt(char *s, uint32_t v)
{
  double sbasZgDot = (double)((int32_t)v)*0.004;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", sbasZgDot, (int32_t)v);
}

static void
lpp_sbasXgDotDot_YgDotDot_fmt(char *s, uint32_t v)
{
  double sbasXgDotDot_YgDotDot = (double)((int32_t)v)*0.0000125;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s2 (%d)", sbasXgDotDot_YgDotDot, (int32_t)v);
}

static void
lpp_sbasZgDotDot_fmt(char *s, uint32_t v)
{
  double sbasZgDotDot = (double)((int32_t)v)*0.0000625;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s2 (%d)", sbasZgDotDot, (int32_t)v);
}

static void
lpp_bdsAPowerHalf_r12_fmt(char *s, uint32_t v)
{
  double bdsAPowerHalf = (double)v*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", bdsAPowerHalf, v);
}

static void
lpp_bdsE_r12_fmt(char *s, uint32_t v)
{
  double bdsE = (double)v*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", bdsE, v);
}

static void
lpp_bdsW_M0_Omega0_I0_r12_fmt(char *s, uint32_t v)
{
  double bdsW_M0_Omega0_I0 = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", bdsW_M0_Omega0_I0, (int32_t)v);
}

static void
lpp_bdsDeltaN_OmegaDot_IDot_r12_fmt(char *s, uint32_t v)
{
  double bdsDeltaN_OmegaDot_IDot = (double)((int32_t)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", bdsDeltaN_OmegaDot_IDot, (int32_t)v);
}

static void
lpp_bdsCuc_Cus_Cic_Cis_r12_fmt(char *s, uint32_t v)
{
  double bdsCuc_Cus_Cic_Cis = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", bdsCuc_Cus_Cic_Cis, (int32_t)v);
}

static void
lpp_bdsCrc_Crs_r12_fmt(char *s, uint32_t v)
{
  double bdsCrc_Crs = (double)((int32_t)v)*pow(2, -6);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", bdsCrc_Crs, (int32_t)v);
}

static void
lpp_doppler0_fmt(char *s, uint32_t v)
{
  double doppler0 = (double)((int32_t)v)*0.5;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", doppler0, (int32_t)v);
}

static void
lpp_doppler1_fmt(char *s, uint32_t v)
{
  double doppler1 = (double)((int32_t)(v-42))/210;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s2 (%u)", doppler1, v);
}

static const value_string lpp_dopplerUncertainty_vals[] = {
  { 0, "40m/s"},
  { 1, "20m/s"},
  { 2, "10m/s"},
  { 3, "5m/s"},
  { 4, "2.5m/s"},
  { 0, NULL}
};

static void
lpp_codePhase_fmt(char *s, uint32_t v)
{
  double codePhase = (double)v*pow(2, -10);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

static const value_string lpp_codePhaseSearchWindow_vals[] = {
  {  0, "No information"},
  {  1, "0.002ms"},
  {  2, "0.004ms"},
  {  3, "0.008ms"},
  {  4, "0.012ms"},
  {  5, "0.016ms"},
  {  6, "0.024ms"},
  {  7, "0.032ms"},
  {  8, "0.048ms"},
  {  9, "0.064ms"},
  { 10, "0.096ms"},
  { 11, "0.128ms"},
  { 12, "0.164ms"},
  { 13, "0.200ms"},
  { 14, "0.250ms"},
  { 15, "0.300ms"},
  { 16, "0.360ms"},
  { 17, "0.420ms"},
  { 18, "0.480ms"},
  { 19, "0.540ms"},
  { 20, "0.600ms"},
  { 21, "0.660ms"},
  { 22, "0.720ms"},
  { 23, "0.780ms"},
  { 24, "0.850ms"},
  { 25, "1.000ms"},
  { 26, "1.150ms"},
  { 27, "1.300ms"},
  { 28, "1.450ms"},
  { 29, "1.600ms"},
  { 30, "1.800ms"},
  { 31, "2.000ms"},
  { 0, NULL}
};
static value_string_ext lpp_codePhaseSearchWindow_vals_ext = VALUE_STRING_EXT_INIT(lpp_codePhaseSearchWindow_vals);

static void
lpp_azimuth_elevation_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%f degrees (%u)", (float)v*0.703125, v);
}

static void
lpp_kepAlmanacE_fmt(char *s, uint32_t v)
{
  double kepAlmanacE = (double)v*pow(2, -16);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", kepAlmanacE, v);
}

static void
lpp_kepAlmanacDeltaI_fmt(char *s, uint32_t v)
{
  double kepAlmanacDeltaI = (double)((int32_t)v)*pow(2, -14);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", kepAlmanacDeltaI, (int32_t)v);
}

static void
lpp_kepAlmanacOmegaDot_fmt(char *s, uint32_t v)
{
  double kepAlmanacOmegaDot = (double)((int32_t)v)*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", kepAlmanacOmegaDot, (int32_t)v);
}

static void
lpp_kepAlmanacAPowerHalf_fmt(char *s, uint32_t v)
{
  double kepAlmanacAPowerHalf = (double)((int32_t)v)*pow(2, -9);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%d)", kepAlmanacAPowerHalf, (int32_t)v);
}

static void
lpp_kepAlmanacOmega0_W_M0_fmt(char *s, uint32_t v)
{
  double kepAlmanacOmega0_W_M0 = (double)((int32_t)v)*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", kepAlmanacOmega0_W_M0, (int32_t)v);
}

static void
lpp_kepAlmanacAF0_fmt(char *s, uint32_t v)
{
  double kepAlmanacAF0 = (double)((int32_t)v)*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", kepAlmanacAF0, (int32_t)v);
}

static void
lpp_kepAlmanacAF1_fmt(char *s, uint32_t v)
{
  double kepAlmanacAF1 = (double)((int32_t)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", kepAlmanacAF1, (int32_t)v);
}

static void
lpp_navAlmE_fmt(char *s, uint32_t v)
{
  double navAlmE = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", navAlmE, v);
}

static void
lpp_navAlmDeltaI_fmt(char *s, uint32_t v)
{
  double navAlmDeltaI = (double)((int32_t)v)*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", navAlmDeltaI, (int32_t)v);
}

static void
lpp_navAlmOMEGADOT_fmt(char *s, uint32_t v)
{
  double navAlmOMEGADOT = (double)((int32_t)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", navAlmOMEGADOT, (int32_t)v);
}

static void
lpp_navAlmSqrtA_fmt(char *s, uint32_t v)
{
  double navAlmSqrtA = (double)v*pow(2, -11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", navAlmSqrtA, v);
}

static void
lpp_navAlmOMEGAo_Omega_Mo_fmt(char *s, uint32_t v)
{
  double navAlmOMEGAo_Omega_Mo = (double)((int32_t)v)*pow(2, -23);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", navAlmOMEGAo_Omega_Mo, (int32_t)v);
}

static void
lpp_navAlmaf0_fmt(char *s, uint32_t v)
{
  double navAlmaf0 = (double)((int32_t)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", navAlmaf0, (int32_t)v);
}

static void
lpp_navAlmaf1_fmt(char *s, uint32_t v)
{
  double navAlmaf1 = (double)((int32_t)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", navAlmaf1, (int32_t)v);
}

static void
lpp_redAlmDeltaA_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dm (%d)", 512*(int)v, (int)v);
}

static void
lpp_redAlmOmega0_Phi0_fmt(char *s, uint32_t v)
{
  double redAlmOmega0_Phi0 = (double)((int32_t)v)*pow(2, -6);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", redAlmOmega0_Phi0, (int32_t)v);
}

static void
lpp_midiAlmE_fmt(char *s, uint32_t v)
{
  double midiAlmE = (double)v*pow(2, -16);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", midiAlmE, v);
}

static void
lpp_midiAlmDeltaI_fmt(char *s, uint32_t v)
{
  double midiAlmDeltaI = (double)((int32_t)v)*pow(2, -14);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", midiAlmDeltaI, (int32_t)v);
}

static void
lpp_midiAlmOmegaDot_fmt(char *s, uint32_t v)
{
  double midiAlmOmegaDot = (double)((int32_t)v)*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", midiAlmOmegaDot, (int32_t)v);
}

static void
lpp_midiAlmSqrtA_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fm1/2 (%u)", (float)v*0.0625, v);
}

static void
lpp_midiAlmOmega0_Omega_Mo_fmt(char *s, uint32_t v)
{
  double midiAlmOmega0_Omega_Mo = (double)((int32_t)v)*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", midiAlmOmega0_Omega_Mo, (int32_t)v);
}

static void
lpp_midiAlmaf0_fmt(char *s, uint32_t v)
{
  double midiAlmaf0 = (double)((int32_t)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", midiAlmaf0, (int32_t)v);
}

static void
lpp_midiAlmaf1_fmt(char *s, uint32_t v)
{
  double midiAlmaf1 = (double)((int32_t)v)*pow(2, -37);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", midiAlmaf1, (int32_t)v);
}

static void
lpp_gloAlmLambdaA_DeltaIa_fmt(char *s, uint32_t v)
{
  double gloAlmLambdaA_DeltaIa = (double)((int32_t)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", gloAlmLambdaA_DeltaIa, (int32_t)v);
}

static void
lpp_gloAlmtlambdaA_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fs (%u)", (float)v*0.03125, v);
}

static void
lpp_gloAlmDeltaTA_fmt(char *s, uint32_t v)
{
  double gloAlmDeltaTA = (double)((int32_t)v)*pow(2, -9);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/orbit period (%d)", gloAlmDeltaTA, (int32_t)v);
}

static void
lpp_gloAlmDeltaTdotA_fmt(char *s, uint32_t v)
{
  double gloAlmDeltaTdotA = (double)((int32_t)v)*pow(2, -14);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/orbit period (%d)", gloAlmDeltaTdotA, (int32_t)v);
}

static void
lpp_gloAlmEpsilonA_fmt(char *s, uint32_t v)
{
  double gloAlmEpsilonA = (double)v*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", gloAlmEpsilonA, (int32_t)v);
}

static void
lpp_gloAlmOmegaA_fmt(char *s, uint32_t v)
{
  double gloAlmOmegaA = (double)((int32_t)v)*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", gloAlmOmegaA, (int32_t)v);
}

static void
lpp_gloAlmTauA_fmt(char *s, uint32_t v)
{
  double gloAlmTauA = (double)((int32_t)v)*pow(2, -18);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", gloAlmTauA, (int32_t)v);
}

static void
lpp_sbasAlmXg_Yg_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fkm (%d)", (int32_t)v*2.6, (int32_t)v);
}

static void
lpp_sbasAlmZg_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dkm (%d)", (int32_t)v*26, (int32_t)v);
}

static void
lpp_sbasAlmXgdot_YgDot_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dm/s (%d)", (int32_t)v*10, (int32_t)v);
}

static void
lpp_sbasAlmZgDot_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", (int32_t)v*40.96, (int32_t)v);
}

static void
lpp_sbasAlmTo_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um/s (%u)", v*64, v);
}

static void
lpp_bdsAlmToa_r12_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", v*4096, v);
}

static void
lpp_bdsAlmSqrtA_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmSqrtA = (double)v*pow(2, -11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", bdsAlmSqrtA, v);
}

static void
lpp_bdsAlmE_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmE = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", bdsAlmE, v);
}

static void
lpp_bdsAlmW_M0_Omega0_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmW_M0_Omega0 = (double)((int32_t)v)*pow(2, -23);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", bdsAlmW_M0_Omega0, (int32_t)v);
}

static void
lpp_bdsAlmOmegaDot_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmOmegaDot = (double)((int32_t)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", bdsAlmOmegaDot, (int32_t)v);
}

static void
lpp_bdsAlmDeltaI_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmDeltaI = (double)((int32_t)v)*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", bdsAlmDeltaI, (int32_t)v);
}

static void
lpp_bdsAlmA0_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmA0 = (double)((int32_t)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", bdsAlmA0, (int32_t)v);
}

static void
lpp_bdsAlmA1_r12_fmt(char *s, uint32_t v)
{
  double bdsAlmA1 = (double)((int32_t)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", bdsAlmA1, (int32_t)v);
}

static const true_false_string lpp_bdsSvHealth_r12_b1i_b2i_value = {
  "OK",
  "Weak"
};

static const true_false_string lpp_bdsSvHealth_r12_nav_value = {
  "OK",
  "Bad (IOD over limit)"
};

static void
lpp_gnss_Utc_A1_fmt(char *s, uint32_t v)
{
  double gnss_Utc_A1 = (double)((int32_t)v)*pow(2, -50);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", gnss_Utc_A1, (int32_t)v);
}

static void
lpp_gnss_Utc_A0_fmt(char *s, uint32_t v)
{
  double gnss_Utc_A0 = (double)((int32_t)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", gnss_Utc_A0, (int32_t)v);
}

static void
lpp_gnss_Utc_Tot_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", v*4096, v);
}

static const value_string lpp_bds_UDREI_vals[] = {
  {  0, "1 meter"},
  {  1, "1.5 meters"},
  {  2, "2 meters"},
  {  3, "3 meters"},
  {  4, "4 meters"},
  {  5, "5 meters"},
  {  6, "6 meters"},
  {  7, "8 meters"},
  {  8, "10 meters"},
  {  9, "15 meters"},
  { 10, "20 meters"},
  { 11, "50 meters"},
  { 12, "100 meters"},
  { 13, "150 meters"},
  { 14, "Not monitored"},
  { 15, "Not available"},
  { 0, NULL}
};
static value_string_ext lpp_bds_UDREI_vals_ext = VALUE_STRING_EXT_INIT(lpp_bds_UDREI_vals);

static const value_string lpp_bds_RURAI_vals[] = {
  {  0, "0.75 meter"},
  {  1, "1 meter"},
  {  2, "1.25 meters"},
  {  3, "1.75 meters"},
  {  4, "2.25 meters"},
  {  5, "3 meters"},
  {  6, "3.75 meters"},
  {  7, "4.5 meters"},
  {  8, "5.25 meters"},
  {  9, "6 meters"},
  { 10, "7.5 meters"},
  { 11, "15 meters"},
  { 12, "50 meters"},
  { 13, "150 meters"},
  { 14, "300 meters"},
  { 15, "> 300 meters"},
  { 0, NULL}
};
static value_string_ext lpp_bds_RURAI_vals_ext = VALUE_STRING_EXT_INIT(lpp_bds_RURAI_vals);

static void
lpp_bds_ECC_DeltaT_r12_fmt(char *s, uint32_t v)
{
  if ((int32_t)v == -4096) {
    snprintf(s, ITEM_LABEL_LENGTH, "Not available (%d)", (int32_t)v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", (float)((int32_t)v)*0.1, (int32_t)v);
  }
}

static void
lpp_bds_GridIonElement_dt_r12_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", (float)((int32_t)v)*0.125, (int32_t)v);
}

static const value_string lpp_bds_givei_vals[] = {
  {  0, "0.3 meter"},
  {  1, "0.6 meter"},
  {  2, "0.9 meter"},
  {  3, "1.2 meters"},
  {  4, "1.5 meters"},
  {  5, "1.8 meters"},
  {  6, "2.1 meters"},
  {  7, "2.4 meters"},
  {  8, "2.7 meters"},
  {  9, "3 meters"},
  { 10, "3.6 meters"},
  { 11, "4.5 meters"},
  { 12, "6 meters"},
  { 13, "9 meters"},
  { 14, "15 meters"},
  { 15, "45 meters"},
  { 0, NULL}
};
static value_string_ext lpp_bds_givei_vals_ext = VALUE_STRING_EXT_INIT(lpp_bds_givei_vals);

static void
lpp_fine_PseudoRange_r15_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)*pow(2, -29);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%d)", val, (int32_t)v);
}

static void
lpp_fine_PhaseRange_r15_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%d)", val, (int32_t)v);
}

static void
lpp_carrier_to_noise_ratio_r15_fmt(char *s, uint32_t v)
{
  double val = (double)v*pow(2, -4);

  snprintf(s, ITEM_LABEL_LENGTH, "%gdB-Hz (%d)", val, v);
}

static void
lpp_fine_PhaseRangeRate_r15_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/1000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%d)", val, (int32_t)v);
}

static void
lpp_cpBias_r15_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/50;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (int32_t)v);
}

static const value_string lpp_ambiguityStatusFlag_r15_vals[] = {
  { 0, "Reserved for future use (artificial observations)"},
  { 1, "Correct Integer Ambiguity Level for L1 and L2"},
  { 2, "Correct Integer Ambiguity Level for L1-L2 widelane"},
  { 3, "Uncertain Integer Ambiguity Level. Only a likely guess is used"},
  { 0, NULL}
};

static void
lpp_1_2000m_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/2000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (int32_t)v);
}

static void
lpp_1_100ppm_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/100;

  snprintf(s, ITEM_LABEL_LENGTH, "%gppm (%d)", val, (int32_t)v);
}

static void
lpp_1_10ppm_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/10;

  snprintf(s, ITEM_LABEL_LENGTH, "%gppm (%d)", val, (int32_t)v);
}

static const value_string lpp_ssrUpdateInterval_r15_vals[] = {
  {  0, "1 second"},
  {  1, "2 seconds"},
  {  2, "5 seconds"},
  {  3, "10 seconds"},
  {  4, "15 seconds"},
  {  5, "30 seconds"},
  {  6, "60 seconds"},
  {  7, "120 seconds"},
  {  8, "240 seconds"},
  {  9, "300 seconds"},
  { 10, "600 seconds"},
  { 11, "900 seconds"},
  { 12, "1800 seconds"},
  { 13, "3600 seconds"},
  { 14, "7200 seconds"},
  { 15, "10800 seconds"},
  { 0, NULL}
};

static void
lpp_1_10000m_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/10000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (int32_t)v);
}

static void
lpp_4_10000m_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/10000*4;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (int32_t)v);
}

static void
lpp_1_1000000m_s_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/1000000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", val, (int32_t)v);
}

static void
lpp_4_1000000m_s_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/1000000*4;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", val, (int32_t)v);
}

static void
lpp_2_100000000m_s2_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/100000000*2;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s2 (%d)", val, (int32_t)v);
}

static void
lpp_1_100000m_fmt(char *s, uint32_t v)
{
  double val = (double)((int32_t)v)/100000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (int32_t)v);
}

static void
lpp_tauC_fmt(char *s, uint32_t v)
{
  double tauC = (double)((int32_t)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", tauC, (int32_t)v);
}

static void
lpp_b1_fmt(char *s, uint32_t v)
{
  double b1 = (double)((int32_t)v)*pow(2, -10);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", b1, (int32_t)v);
}

static void
lpp_b2_fmt(char *s, uint32_t v)
{
  double b2 = (double)((int32_t)v)*pow(2, -16);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/msd (%d)", b2, (int32_t)v);
}

static const value_string lpp_utcStandardID_vals[] = {
  { 0, "UTC as operated by the Communications Research Laboratory (CRL), Tokyo, Japan"},
  { 1, "UTC as operated by the National Institute of Standards and Technology (NIST)"},
  { 2, "UTC as operated by the U. S. Naval Observatory (USNO)"},
  { 3, "UTC as operated by the International Bureau of Weights and Measures (BIPM)"},
  { 0, NULL}
};

static const value_string lpp_dataBitInterval_vals[] = {
  {  0, "0.1"},
  {  1, "0.2"},
  {  2, "0.4"},
  {  3, "0.8"},
  {  4, "1.6"},
  {  5, "3.2"},
  {  6, "6.4"},
  {  7, "12.8"},
  {  8, "25.6"},
  {  9, "51.2"},
  { 10, "102.4"},
  { 11, "204.8"},
  { 12, "409.6"},
  { 13, "819.2"},
  { 14, "1638.4"},
  { 15, "Not specified"},
  { 0, NULL}
};
static value_string_ext lpp_dataBitInterval_vals_ext = VALUE_STRING_EXT_INIT(lpp_dataBitInterval_vals);

static const value_string lpp_carrierQualityInd_vals[] = {
  { 0, "Data direct, carrier phase not continuous"},
  { 1, "Data inverted, carrier phase not continuous"},
  { 2, "Data direct, carrier phase continuous"},
  { 3, "Data inverted, carrier phase continuous"},
  { 0, NULL}
};

static void
lpp_GNSS_SatMeas_codePhase_fmt(char *s, uint32_t v)
{
  double codePhase = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

static void
lpp_codePhaseRMSError_fmt(char *s, uint32_t v)
{
  uint8_t mantissa = v & 0x07;
  uint8_t exponent = (v & 0x38) >> 3;
  uint8_t mantissa_1 = (v - 1) & 0x07;
  uint8_t exponent_1 = ((v - 1) & 0x38) >> 3;

  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "P < 0.5 (0)");
  } else if (v < 63) {
    snprintf(s, ITEM_LABEL_LENGTH, "%f <= P < %f (%u)", 0.5*(1+mantissa_1/8)*pow(2, exponent_1),
               0.5*(1+mantissa/8)*pow(2, exponent), v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "112 <= P (63)");
  }
}

static void
lpp_transmitterLatitude_fmt(char *s, uint32_t v)
{
  double lat = ((double)v*4.0/pow(2, 20))-90.0;

  snprintf(s, ITEM_LABEL_LENGTH, "%g degrees (%u)", lat, v);
}

static void
lpp_transmitterLongitude_fmt(char *s, uint32_t v)
{
  double longitude = ((double)v*4.0/pow(2, 20))-180.0;

  snprintf(s, ITEM_LABEL_LENGTH, "%g degrees (%u)", longitude, v);
}

static void
lpp_transmitterAltitude_fmt(char *s, uint32_t v)
{
  double alt = ((double)v*0.29)-500.0;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%u)", alt, v);
}

static void
lpp_refPressure_fmt(char *s, uint32_t v)
{
  int32_t pressure = (int32_t)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%dPa (%d)", 101325+pressure, pressure);
}

static void
lpp_refTemperature_fmt(char *s, uint32_t v)
{
  int32_t temp = (int32_t)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%dK (%d)", 273+temp, temp);
}

static void
lpp_referencePressureRate_v1520_fmt(char *s, uint32_t v)
{
  int32_t rate = (int32_t)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%dPa/hour (%d)", 10*rate, rate);
}

static void
lpp_PressureValidityPeriod_v1520_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%umin (%u)", 15*v, v);
}

static void
lpp_doppler_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", (int32_t)v*0.04, (int32_t)v);
}

static void
lpp_adr_fmt(char *s, uint32_t v)
{
  double adr = (double)v*pow(2, -10);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%u)", adr, v);
}

static void
lpp_adrMSB_r15_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um (%u)", v*32768, v);
}

static void
lpp_GNSS_SatMeas_delta_codePhase_r15_fmt(char *s, uint32_t v)
{
  double codePhase = (double)v*pow(2, -24);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

static void
lpp_deliveryAmount_r15_fmt(char *s, uint32_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", pow(2, v), v);
}

static void
lpp_rsrp_Result_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRP < -140dBm (0)");
  } else if (v < 97) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSRP < %ddBm (%u)", v-141, v-140, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= RSRP (97)");
  }
}

static void
lpp_rsrq_Result_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -19.5dB (0)");
  } else if (v < 34) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%u)", ((float)v/2)-20, (((float)v+1)/2)-20, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-3dB <= RSRQ (34)");
  }
}

static void
lpp_nrsrp_Result_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "NRSRP < -156dBm (0)");
  } else if (v < 113) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= NRSRP < %ddBm (%u)", v-157, v-156, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= NRSRP (97)");
  }
}

static void
lpp_nrsrq_Result_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "NRSRQ < -34dB (0)");
  } else if (v < 74) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= NRSRQ < %.1fdB (%u)", (((float)v-1)/2)-34, ((float)v/2)-34, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "2.5dB <= NRSRQ (%u)", v);
  }
}

static void
lpp_rsrp_Result_v1470_fmt(char *s, uint32_t v)
{
  int32_t d = (int32_t)v;

  if (d == -17) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRP < -157dBm (-17)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSRP < %ddBm (%d)", d-141, d-140, d);
  }
}

static void
lpp_rsrq_Result_v1470_fmt(char *s, uint32_t v)
{
  int32_t d = (int32_t)v;

  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -34.5dB (-30)");
  } else if (v < 46) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%d)", ((float)d/2)-20, (((float)d+1)/2)-20, d);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "3dB <= RSRQ (46)");
  }
}

static void
lpp_ue_RxTxTimeDiff_fmt(char *s, uint32_t v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "T < 2Ts (0)");
  } else if (v < 2048) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs <= T < %uTs (%u)", v*2, (v+1)*2, v);
  } else if (v < 4095) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs <= T < %uTs (%u)", (v*8)-12288, ((v+1)*8)-12288, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "20472Ts <= T (4095)");
  }
}

static void
lpp_mbs_beaconMeasElt_codePhase_fmt(char *s, uint32_t v)
{
  double codePhase = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}


static const value_string lpp_Initiator_vals[] = {
  {   0, "locationServer" },
  {   1, "targetDevice" },
  { 0, NULL }
};


static int
dissect_lpp_Initiator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_lpp_TransactionNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t LPP_TransactionID_sequence[] = {
  { &hf_lpp_initiator       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_Initiator },
  { &hf_lpp_transactionNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_TransactionNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LPP_TransactionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_LPP_TransactionID, LPP_TransactionID_sequence);

  return offset;
}



static int
dissect_lpp_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_lpp_SequenceNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t Acknowledgement_sequence[] = {
  { &hf_lpp_ackRequested    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ackIndicator    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SequenceNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Acknowledgement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Acknowledgement, Acknowledgement_sequence);

  return offset;
}


static int * const T_lpp_message_segmentation_req_r14_bits[] = {
  &hf_lpp_T_lpp_message_segmentation_req_r14_serverToTarget,
  &hf_lpp_T_lpp_message_segmentation_req_r14_targetToServer,
  NULL
};

static int
dissect_lpp_T_lpp_message_segmentation_req_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, false, T_lpp_message_segmentation_req_r14_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t CommonIEsRequestCapabilities_eag_1_sequence[] = {
  { &hf_lpp_lpp_message_segmentation_req_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_lpp_message_segmentation_req_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestCapabilities_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_remoteUE_IndicationReq_r18_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_remoteUE_IndicationReq_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t CommonIEsRequestCapabilities_eag_2_sequence[] = {
  { &hf_lpp_remoteUE_IndicationReq_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_remoteUE_IndicationReq_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestCapabilities_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestCapabilities_eag_2_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestCapabilities_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestCapabilities_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestCapabilities_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsRequestCapabilities, CommonIEsRequestCapabilities_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_RequestCapabilities_sequence[] = {
  { &hf_lpp_gnss_SupportListReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_assistanceDataSupportListReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_locationVelocityTypesReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_RequestCapabilities, A_GNSS_RequestCapabilities_sequence);

  return offset;
}


static const per_sequence_t OTDOA_RequestCapabilities_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OTDOA_RequestCapabilities, OTDOA_RequestCapabilities_sequence);

  return offset;
}


static const per_sequence_t ECID_RequestCapabilities_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_ECID_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ECID_RequestCapabilities, ECID_RequestCapabilities_sequence);

  return offset;
}



static int
dissect_lpp_EPDU_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, &lpp_epdu_id, false);



  return offset;
}



static int
dissect_lpp_EPDU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 32, false,
                                          NULL);

  return offset;
}


static const per_sequence_t EPDU_Identifier_sequence[] = {
  { &hf_lpp_ePDU_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU_ID },
  { &hf_lpp_ePDU_Name       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Name },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_EPDU_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_EPDU_Identifier, EPDU_Identifier_sequence);

  return offset;
}



static int
dissect_lpp_EPDU_Body(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *lppe_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, false, &lppe_tvb);

  switch(lpp_epdu_id){
  case 1:
    if (lppe_tvb && lppe_handle) {
      call_dissector(lppe_handle, lppe_tvb, actx->pinfo, tree);
    }
    break;
  default:
    break;
  }
  lpp_epdu_id = -1;


  return offset;
}


static const per_sequence_t EPDU_sequence[] = {
  { &hf_lpp_ePDU_Identifier , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU_Identifier },
  { &hf_lpp_ePDU_Body       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU_Body },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_EPDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_EPDU, EPDU_sequence);

  return offset;
}


static const per_sequence_t EPDU_Sequence_sequence_of[1] = {
  { &hf_lpp_EPDU_Sequence_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU },
};

static int
dissect_lpp_EPDU_Sequence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_EPDU_Sequence, EPDU_Sequence_sequence_of,
                                                  1, maxEPDU, false);

  return offset;
}


static const per_sequence_t Sensor_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_Sensor_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_RequestCapabilities_r13, Sensor_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t TBS_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_TBS_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TBS_RequestCapabilities_r13, TBS_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t WLAN_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_WLAN_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_RequestCapabilities_r13, WLAN_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t BT_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_BT_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BT_RequestCapabilities_r13, BT_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t RequestCapabilities_r9_IEs_eag_1_sequence[] = {
  { &hf_lpp_sensor_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_RequestCapabilities_r13 },
  { &hf_lpp_tbs_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TBS_RequestCapabilities_r13 },
  { &hf_lpp_wlan_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_WLAN_RequestCapabilities_r13 },
  { &hf_lpp_bt_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BT_RequestCapabilities_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities_r9_IEs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestCapabilities_r9_IEs_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_ECID_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_ECID_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_ECID_RequestCapabilities_r16, NR_ECID_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_RequestCapabilities_r16, NR_Multi_RTT_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_RequestCapabilities_r16, NR_DL_AoD_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_RequestCapabilities_r16, NR_DL_TDOA_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_UL_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_UL_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UL_RequestCapabilities_r16, NR_UL_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t RequestCapabilities_r9_IEs_eag_2_sequence[] = {
  { &hf_lpp_nr_ECID_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_ECID_RequestCapabilities_r16 },
  { &hf_lpp_nr_Multi_RTT_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_Multi_RTT_RequestCapabilities_r16 },
  { &hf_lpp_nr_DL_AoD_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_AoD_RequestCapabilities_r16 },
  { &hf_lpp_nr_DL_TDOA_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_TDOA_RequestCapabilities_r16 },
  { &hf_lpp_nr_UL_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UL_RequestCapabilities_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities_r9_IEs_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestCapabilities_r9_IEs_eag_2_sequence);

  return offset;
}


static const per_sequence_t RequestCapabilities_r9_IEs_sequence[] = {
  { &hf_lpp_commonIEsRequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CommonIEsRequestCapabilities },
  { &hf_lpp_a_gnss_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_RequestCapabilities },
  { &hf_lpp_otdoa_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OTDOA_RequestCapabilities },
  { &hf_lpp_ecid_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECID_RequestCapabilities },
  { &hf_lpp_epdu_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Sequence },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestCapabilities_r9_IEs_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestCapabilities_r9_IEs_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestCapabilities_r9_IEs, RequestCapabilities_r9_IEs_sequence);

  return offset;
}



static int
dissect_lpp_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lpp_T_c1_01_vals[] = {
  {   0, "requestCapabilities-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_01_choice[] = {
  {   0, &hf_lpp_requestCapabilities_r9, ASN1_NO_EXTENSIONS     , dissect_lpp_RequestCapabilities_r9_IEs },
  {   1, &hf_lpp_spare3          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   2, &hf_lpp_spare2          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   3, &hf_lpp_spare1          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_c1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_c1_01, T_c1_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensionsFuture(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_criticalExtensionsFuture, T_criticalExtensionsFuture_sequence);

  return offset;
}


static const value_string lpp_T_criticalExtensions_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_choice[] = {
  {   0, &hf_lpp_c1_01           , ASN1_NO_EXTENSIONS     , dissect_lpp_T_c1_01 },
  {   1, &hf_lpp_criticalExtensionsFuture, ASN1_NO_EXTENSIONS     , dissect_lpp_T_criticalExtensionsFuture },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_criticalExtensions, T_criticalExtensions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RequestCapabilities_sequence[] = {
  { &hf_lpp_criticalExtensions, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_criticalExtensions },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Request Capabilities");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestCapabilities, RequestCapabilities_sequence);

  return offset;
}


static const value_string lpp_SegmentationInfo_r14_vals[] = {
  {   0, "noMoreMessages" },
  {   1, "moreMessagesOnTheWay" },
  { 0, NULL }
};


static int
dissect_lpp_SegmentationInfo_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static int * const T_lpp_message_segmentation_r14_bits[] = {
  &hf_lpp_T_lpp_message_segmentation_r14_serverToTarget,
  &hf_lpp_T_lpp_message_segmentation_r14_targetToServer,
  NULL
};

static int
dissect_lpp_T_lpp_message_segmentation_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, false, T_lpp_message_segmentation_r14_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t CommonIEsProvideCapabilities_eag_1_sequence[] = {
  { &hf_lpp_segmentationInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SegmentationInfo_r14 },
  { &hf_lpp_lpp_message_segmentation_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_lpp_message_segmentation_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideCapabilities_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_locationEstimateAndMeasurementReporting_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_locationEstimateAndMeasurementReporting_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t CommonIEsProvideCapabilities_eag_2_sequence[] = {
  { &hf_lpp_remoteUE_Indication_r18_bool, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_locationEstimateAndMeasurementReporting_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_locationEstimateAndMeasurementReporting_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideCapabilities_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideCapabilities_eag_2_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideCapabilities_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideCapabilities_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideCapabilities_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsProvideCapabilities, CommonIEsProvideCapabilities_sequence);

  return offset;
}


static const value_string lpp_T_gnss_id_vals[] = {
  { T_GNSS_ID_GPS, "gps" },
  { T_GNSS_ID_SBAS, "sbas" },
  { T_GNSS_ID_QZSS, "qzss" },
  { T_GNSS_ID_GALILEO, "galileo" },
  { T_GNSS_ID_GLONASS, "glonass" },
  { T_GNSS_ID_BDS, "bds" },
  { T_GNSS_ID_NAVIC_V1610, "navic-v1610" },
  { 0, NULL }
};


static int
dissect_lpp_T_gnss_id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint32_t gnss_id;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, &gnss_id, true, 2, NULL);

  actx->private_data = GUINT_TO_POINTER(gnss_id);


  return offset;
}


static const per_sequence_t GNSS_ID_sequence[] = {
  { &hf_lpp_gnss_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_id },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID, GNSS_ID_sequence);

  return offset;
}


static int * const T_sbas_IDs_bits[] = {
  &hf_lpp_T_sbas_IDs_waas,
  &hf_lpp_T_sbas_IDs_egnos,
  &hf_lpp_T_sbas_IDs_msas,
  &hf_lpp_T_sbas_IDs_gagan,
  NULL
};

static int
dissect_lpp_T_sbas_IDs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_sbas_IDs_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t SBAS_IDs_sequence[] = {
  { &hf_lpp_sbas_IDs_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_sbas_IDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SBAS_IDs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SBAS_IDs, SBAS_IDs_sequence);

  return offset;
}


static int * const T_posModes_bits[] = {
  &hf_lpp_T_posModes_standalone,
  &hf_lpp_T_posModes_ue_based,
  &hf_lpp_T_posModes_ue_assisted,
  NULL
};

static int
dissect_lpp_T_posModes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_posModes_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t PositioningModes_sequence[] = {
  { &hf_lpp_posModes        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_posModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PositioningModes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PositioningModes, PositioningModes_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, false, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SignalIDs_eag_1_sequence[] = {
  { &hf_lpp_gnss_SignalIDs_Ext_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SignalIDs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SignalIDs_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SignalIDs_sequence[] = {
  { &hf_lpp_gnss_SignalIDs  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_8 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs_eag_1 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_SignalIDs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SignalIDs, GNSS_SignalIDs_sequence);

  return offset;
}


static int * const T_accessTypes_bits[] = {
  &hf_lpp_T_accessTypes_eutra,
  &hf_lpp_T_accessTypes_utra,
  &hf_lpp_T_accessTypes_gsm,
  &hf_lpp_T_accessTypes_nb_iot,
  &hf_lpp_T_accessTypes_nr_v1510,
  NULL
};

static int
dissect_lpp_T_accessTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_accessTypes_bits, 5, NULL, NULL);

  return offset;
}


static const per_sequence_t AccessTypes_sequence[] = {
  { &hf_lpp_accessTypes     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_accessTypes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AccessTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AccessTypes, AccessTypes_sequence);

  return offset;
}


static const per_sequence_t T_fta_MeasSupport_sequence[] = {
  { &hf_lpp_cellTime        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_AccessTypes },
  { &hf_lpp_mode_02         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_fta_MeasSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_fta_MeasSupport, T_fta_MeasSupport_sequence);

  return offset;
}


static const value_string lpp_T_adrEnhancementsSupport_r15_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_adrEnhancementsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SupportElement_eag_1_sequence[] = {
  { &hf_lpp_adrEnhancementsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_adrEnhancementsSupport_r15 },
  { &hf_lpp_ha_gnss_Modes_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SupportElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SupportElement_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_ha_gnss_MetricsSupport_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_ha_gnss_MetricsSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SupportElement_eag_2_sequence[] = {
  { &hf_lpp_ha_gnss_MetricsSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ha_gnss_MetricsSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SupportElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SupportElement_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SupportElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_IDs        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_IDs },
  { &hf_lpp_agnss_Modes     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_gnss_Signals    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_fta_MeasSupport , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_fta_MeasSupport },
  { &hf_lpp_adr_Support     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_velocityMeasurementSupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SupportElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SupportElement_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SupportElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SupportElement, GNSS_SupportElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_SupportList_sequence_of[1] = {
  { &hf_lpp_GNSS_SupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SupportElement },
};

static int
dissect_lpp_GNSS_SupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_SupportList, GNSS_SupportList_sequence_of,
                                                  1, 16, false);

  return offset;
}


static int * const T_gnss_ids_bits[] = {
  &hf_lpp_T_gnss_ids_gps,
  &hf_lpp_T_gnss_ids_sbas,
  &hf_lpp_T_gnss_ids_qzss,
  &hf_lpp_T_gnss_ids_galileo,
  &hf_lpp_T_gnss_ids_glonass,
  &hf_lpp_T_gnss_ids_bds,
  &hf_lpp_T_gnss_ids_navic_v1610,
  NULL
};

static int
dissect_lpp_T_gnss_ids(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 16, false, T_gnss_ids_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_ID_Bitmap_sequence[] = {
  { &hf_lpp_gnss_ids        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_ids },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_ID_Bitmap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID_Bitmap, GNSS_ID_Bitmap_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTimeSupport_sequence[] = {
  { &hf_lpp_gnss_SystemTime_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_Bitmap },
  { &hf_lpp_fta_Support     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AccessTypes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTimeSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTimeSupport, GNSS_ReferenceTimeSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceLocationSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceLocationSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceLocationSupport, GNSS_ReferenceLocationSupport_sequence);

  return offset;
}


static int * const T_ionoModel_bits[] = {
  &hf_lpp_T_ionoModel_klobuchar,
  &hf_lpp_T_ionoModel_neQuick,
  &hf_lpp_T_ionoModel_klobuchar2_r16,
  NULL
};

static int
dissect_lpp_T_ionoModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_ionoModel_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModelSupport_sequence[] = {
  { &hf_lpp_ionoModel       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ionoModel },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModelSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_IonosphericModelSupport, GNSS_IonosphericModelSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_EarthOrientationParametersSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_EarthOrientationParametersSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_EarthOrientationParametersSupport, GNSS_EarthOrientationParametersSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfoSupport_r15_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15, GNSS_RTK_ReferenceStationInfoSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_AuxiliaryStationDataSupport_r15_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15, GNSS_RTK_AuxiliaryStationDataSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_eag_1_sequence[] = {
  { &hf_lpp_gnss_RTK_ReferenceStationInfoSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15 },
  { &hf_lpp_gnss_RTK_AuxiliaryStationDataSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistanceDataSupport_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceParametersSupport_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceParametersSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceParametersSupport_r17, GNSS_Integrity_ServiceParametersSupport_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceAlertSupport_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceAlertSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceAlertSupport_r17, GNSS_Integrity_ServiceAlertSupport_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_eag_2_sequence[] = {
  { &hf_lpp_gnss_Integrity_ServiceParametersSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceParametersSupport_r17 },
  { &hf_lpp_gnss_Integrity_ServiceAlertSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceAlertSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistanceDataSupport_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_IOD_UpdateSupport_r18_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_IOD_UpdateSupport_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_IOD_UpdateSupport_r18, GNSS_SSR_IOD_UpdateSupport_r18_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_IOD_UpdateSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_IOD_UpdateSupport_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistanceDataSupport_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_sequence[] = {
  { &hf_lpp_gnss_ReferenceTimeSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceTimeSupport },
  { &hf_lpp_gnss_ReferenceLocationSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceLocationSupport },
  { &hf_lpp_gnss_IonosphericModelSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_IonosphericModelSupport },
  { &hf_lpp_gnss_EarthOrientationParametersSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_EarthOrientationParametersSupport },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_CommonAssistanceDataSupport, GNSS_CommonAssistanceDataSupport_sequence);

  return offset;
}


static const value_string lpp_T_sbas_id_vals[] = {
  {   0, "waas" },
  {   1, "egnos" },
  {   2, "msas" },
  {   3, "gagan" },
  { 0, NULL }
};


static int
dissect_lpp_T_sbas_id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t SBAS_ID_sequence[] = {
  { &hf_lpp_sbas_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_sbas_id },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SBAS_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SBAS_ID, SBAS_ID_sequence);

  return offset;
}


static const per_sequence_t GNSS_TimeModelListSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_TimeModelListSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_TimeModelListSupport, GNSS_TimeModelListSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_DifferentialCorrectionsSupport_sequence[] = {
  { &hf_lpp_gnssSignalIDs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_dgnss_ValidityTimeSup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DifferentialCorrectionsSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DifferentialCorrectionsSupport, GNSS_DifferentialCorrectionsSupport_sequence);

  return offset;
}


static int * const T_clockModel_bits[] = {
  &hf_lpp_T_clockModel_model_1,
  &hf_lpp_T_clockModel_model_2,
  &hf_lpp_T_clockModel_model_3,
  &hf_lpp_T_clockModel_model_4,
  &hf_lpp_T_clockModel_model_5,
  &hf_lpp_T_clockModel_model_6,
  &hf_lpp_T_clockModel_model_7_r16,
  &hf_lpp_T_clockModel_model_8_r16,
  NULL
};

static int
dissect_lpp_T_clockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_clockModel_bits, 8, NULL, NULL);

  return offset;
}


static int * const T_orbitModel_bits[] = {
  &hf_lpp_T_orbitModel_model_1,
  &hf_lpp_T_orbitModel_model_2,
  &hf_lpp_T_orbitModel_model_3,
  &hf_lpp_T_orbitModel_model_4,
  &hf_lpp_T_orbitModel_model_5,
  &hf_lpp_T_orbitModel_model_6,
  &hf_lpp_T_orbitModel_model_7_r16,
  &hf_lpp_T_orbitModel_model_8_r16,
  NULL
};

static int
dissect_lpp_T_orbitModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_orbitModel_bits, 8, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_NavigationModelSupport_sequence[] = {
  { &hf_lpp_clockModel      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_clockModel },
  { &hf_lpp_orbitModel      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_orbitModel },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NavigationModelSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_NavigationModelSupport, GNSS_NavigationModelSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_RealTimeIntegritySupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RealTimeIntegritySupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RealTimeIntegritySupport, GNSS_RealTimeIntegritySupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_DataBitAssistanceSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitAssistanceSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitAssistanceSupport, GNSS_DataBitAssistanceSupport_sequence);

  return offset;
}


static const value_string lpp_T_confidenceSupport_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_confidenceSupport_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dopplerUncertaintyExtSupport_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_dopplerUncertaintyExtSupport_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistanceSupport_sequence[] = {
  { &hf_lpp_confidenceSupport_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_confidenceSupport_r10 },
  { &hf_lpp_dopplerUncertaintyExtSupport_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_dopplerUncertaintyExtSupport_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AcquisitionAssistanceSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AcquisitionAssistanceSupport, GNSS_AcquisitionAssistanceSupport_sequence);

  return offset;
}


static int * const T_almanacModel_bits[] = {
  &hf_lpp_T_almanacModel_model_1,
  &hf_lpp_T_almanacModel_model_2,
  &hf_lpp_T_almanacModel_model_3,
  &hf_lpp_T_almanacModel_model_4,
  &hf_lpp_T_almanacModel_model_5,
  &hf_lpp_T_almanacModel_model_6,
  &hf_lpp_T_almanacModel_model_7,
  &hf_lpp_T_almanacModel_model_8_v16e0,
  NULL
};

static int
dissect_lpp_T_almanacModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_almanacModel_bits, 8, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_AlmanacSupport_sequence[] = {
  { &hf_lpp_almanacModel    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_almanacModel },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AlmanacSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AlmanacSupport, GNSS_AlmanacSupport_sequence);

  return offset;
}


static int * const T_utc_Model_bits[] = {
  &hf_lpp_T_utc_Model_model_1,
  &hf_lpp_T_utc_Model_model_2,
  &hf_lpp_T_utc_Model_model_3,
  &hf_lpp_T_utc_Model_model_4,
  &hf_lpp_T_utc_Model_model_5,
  NULL
};

static int
dissect_lpp_T_utc_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_utc_Model_bits, 5, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_UTC_ModelSupport_sequence[] = {
  { &hf_lpp_utc_Model       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_utc_Model },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_UTC_ModelSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_UTC_ModelSupport, GNSS_UTC_ModelSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_AuxiliaryInformationSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_AuxiliaryInformationSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AuxiliaryInformationSupport, GNSS_AuxiliaryInformationSupport_sequence);

  return offset;
}


static const per_sequence_t BDS_DifferentialCorrectionsSupport_r12_sequence[] = {
  { &hf_lpp_gnssSignalIDs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_DifferentialCorrectionsSupport_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_DifferentialCorrectionsSupport_r12, BDS_DifferentialCorrectionsSupport_r12_sequence);

  return offset;
}


static const per_sequence_t BDS_GridModelSupport_r12_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_BDS_GridModelSupport_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_GridModelSupport_r12, BDS_GridModelSupport_r12_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_1_sequence[] = {
  { &hf_lpp_bds_DifferentialCorrectionsSupport_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_DifferentialCorrectionsSupport_r12 },
  { &hf_lpp_bds_GridModelSupport_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_GridModelSupport_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ObservationsSupport_r15_sequence[] = {
  { &hf_lpp_gnssSignalIDs_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ObservationsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ObservationsSupport_r15, GNSS_RTK_ObservationsSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GLO_RTK_BiasInformationSupport_r15_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GLO_RTK_BiasInformationSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GLO_RTK_BiasInformationSupport_r15, GLO_RTK_BiasInformationSupport_r15_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_FrequencyID_r15_sequence[] = {
  { &hf_lpp_gnss_FrequencyID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_FrequencyID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_FrequencyID_r15, GNSS_FrequencyID_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_Link_Combinations_r15_sequence[] = {
  { &hf_lpp_l1_r15          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_l2_r15          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_FrequencyID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Link_Combinations_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Link_Combinations_r15, GNSS_Link_Combinations_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_Link_CombinationsList_r15_sequence_of[1] = {
  { &hf_lpp_GNSS_Link_CombinationsList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_Combinations_r15 },
};

static int
dissect_lpp_GNSS_Link_CombinationsList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_Link_CombinationsList_r15, GNSS_Link_CombinationsList_r15_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t GNSS_RTK_MAC_CorrectionDifferencesSupport_r15_sequence[] = {
  { &hf_lpp_link_combinations_support_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15, GNSS_RTK_MAC_CorrectionDifferencesSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ResidualsSupport_r15_sequence[] = {
  { &hf_lpp_link_combinations_support_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ResidualsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ResidualsSupport_r15, GNSS_RTK_ResidualsSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_FKP_GradientsSupport_r15_sequence[] = {
  { &hf_lpp_link_combinations_support_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_FKP_GradientsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_FKP_GradientsSupport_r15, GNSS_RTK_FKP_GradientsSupport_r15_sequence);

  return offset;
}


static int * const T_orbit_IntegritySup_r17_bits[] = {
  &hf_lpp_T_orbit_IntegritySup_r17_correlationTimeSup,
  NULL
};

static int
dissect_lpp_T_orbit_IntegritySup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_orbit_IntegritySup_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1_sequence[] = {
  { &hf_lpp_orbit_IntegritySup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_orbit_IntegritySup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsSupport_r15_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15, GNSS_SSR_OrbitCorrectionsSupport_r15_sequence);

  return offset;
}


static const value_string lpp_T_clock_IntegrityParameterSupport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_clock_IntegrityParameterSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityClockBoundsSupport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityClockBoundsSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsSupport_r15_eag_1_sequence[] = {
  { &hf_lpp_clock_IntegrityParameterSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_clock_IntegrityParameterSupport_r17 },
  { &hf_lpp_ssr_IntegrityClockBoundsSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityClockBoundsSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_ClockCorrectionsSupport_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsSupport_r15_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrectionsSupport_r15, GNSS_SSR_ClockCorrectionsSupport_r15_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityCodeBiasBoundsSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityCodeBiasBoundsSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasSupport_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityCodeBiasBoundsSup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityCodeBiasBoundsSup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasSupport_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_CodeBiasSupport_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasSupport_r15_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Sup_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_CodeBiasSupport_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CodeBiasSupport_r15, GNSS_SSR_CodeBiasSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_2_sequence[] = {
  { &hf_lpp_gnss_RTK_ObservationsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ObservationsSupport_r15 },
  { &hf_lpp_glo_RTK_BiasInformationSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GLO_RTK_BiasInformationSupport_r15 },
  { &hf_lpp_gnss_RTK_MAC_CorrectionDifferencesSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15 },
  { &hf_lpp_gnss_RTK_ResidualsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ResidualsSupport_r15 },
  { &hf_lpp_gnss_RTK_FKP_GradientsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_FKP_GradientsSupport_r15 },
  { &hf_lpp_gnss_SSR_OrbitCorrectionsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15 },
  { &hf_lpp_gnss_SSR_CodeBiasSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CodeBiasSupport_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_Support_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_Support_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_Support_r16, GNSS_SSR_URA_Support_r16_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityPhaseBiasBoundsSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasSupport_r16_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityPhaseBiasBoundsSup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsSup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_PhaseBiasSupport_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasSupport_r16_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Sup_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_PhaseBiasSupport_r16, GNSS_SSR_PhaseBiasSupport_r16_sequence);

  return offset;
}


static int * const T_stec_IntegritySup_r17_bits[] = {
  &hf_lpp_T_stec_IntegritySup_r17_correlationTimeSup,
  NULL
};

static int
dissect_lpp_T_stec_IntegritySup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_stec_IntegritySup_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionSupport_r16_eag_1_sequence[] = {
  { &hf_lpp_stec_IntegritySup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_stec_IntegritySup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_STEC_CorrectionSupport_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionSupport_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_STEC_CorrectionSupport_r16, GNSS_SSR_STEC_CorrectionSupport_r16_sequence);

  return offset;
}


static const value_string lpp_T_griddedCorrectionIntegritySup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_griddedCorrectionIntegritySup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionSupport_r16_eag_1_sequence[] = {
  { &hf_lpp_griddedCorrectionIntegritySup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_griddedCorrectionIntegritySup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_GriddedCorrectionSupport_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionSupport_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_GriddedCorrectionSupport_r16, GNSS_SSR_GriddedCorrectionSupport_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_DifferentialCorrectionsSupport_r16_sequence[] = {
  { &hf_lpp_gnssSignalIDs_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_DifferentialCorrectionsSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_DifferentialCorrectionsSupport_r16, NavIC_DifferentialCorrectionsSupport_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_GridModelSupport_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NavIC_GridModelSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_GridModelSupport_r16, NavIC_GridModelSupport_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_URA_Support_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_Support_r16 },
  { &hf_lpp_gnss_SSR_PhaseBiasSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16 },
  { &hf_lpp_gnss_SSR_STEC_CorrectionSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16 },
  { &hf_lpp_gnss_SSR_GriddedCorrectionSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16 },
  { &hf_lpp_navic_DifferentialCorrectionsSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_DifferentialCorrectionsSupport_r16 },
  { &hf_lpp_navic_GridModelSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_GridModelSupport_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsSet2Support_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsSet2Support_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrectionsSet2Support_r17, GNSS_SSR_OrbitCorrectionsSet2Support_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsSet2Support_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsSet2Support_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrectionsSet2Support_r17, GNSS_SSR_ClockCorrectionsSet2Support_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_Set2Support_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_Set2Support_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_Set2Support_r17, GNSS_SSR_URA_Set2Support_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_4_sequence[] = {
  { &hf_lpp_gnss_SSR_OrbitCorrectionsSet2Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsSet2Support_r17 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsSet2Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsSet2Support_r17 },
  { &hf_lpp_gnss_SSR_URA_Set2Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_Set2Support_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_4_sequence);

  return offset;
}


static const per_sequence_t GNSS_LOS_NLOS_GriddedIndicationsSupport_r18_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_LOS_NLOS_GriddedIndicationsSupport_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_LOS_NLOS_GriddedIndicationsSupport_r18, GNSS_LOS_NLOS_GriddedIndicationsSupport_r18_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_SatellitePCVResidualsSupport_r18_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_SatellitePCVResidualsSupport_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_SatellitePCVResidualsSupport_r18, GNSS_SSR_SatellitePCVResidualsSupport_r18_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_5_sequence[] = {
  { &hf_lpp_gnss_LOS_NLOS_GriddedIndicationsSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_LOS_NLOS_GriddedIndicationsSupport_r18 },
  { &hf_lpp_gnss_SSR_SatellitePCVResidualsSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_SatellitePCVResidualsSupport_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_5_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_ID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_ID },
  { &hf_lpp_gnss_TimeModelsSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_TimeModelListSupport },
  { &hf_lpp_gnss_DifferentialCorrectionsSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DifferentialCorrectionsSupport },
  { &hf_lpp_gnss_NavigationModelSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavigationModelSupport },
  { &hf_lpp_gnss_RealTimeIntegritySupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_RealTimeIntegritySupport },
  { &hf_lpp_gnss_DataBitAssistanceSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitAssistanceSupport },
  { &hf_lpp_gnss_AcquisitionAssistanceSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AcquisitionAssistanceSupport },
  { &hf_lpp_gnss_AlmanacSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AlmanacSupport },
  { &hf_lpp_gnss_UTC_ModelSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_UTC_ModelSupport },
  { &hf_lpp_gnss_AuxiliaryInformationSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AuxiliaryInformationSupport },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_4 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_GenericAssistDataSupportElement, GNSS_GenericAssistDataSupportElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistanceDataSupport_sequence_of[1] = {
  { &hf_lpp_GNSS_GenericAssistanceDataSupport_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement },
};

static int
dissect_lpp_GNSS_GenericAssistanceDataSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_GenericAssistanceDataSupport, GNSS_GenericAssistanceDataSupport_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t AssistanceDataSupportList_sequence[] = {
  { &hf_lpp_gnss_CommonAssistanceDataSupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport },
  { &hf_lpp_gnss_GenericAssistanceDataSupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistanceDataSupport },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AssistanceDataSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AssistanceDataSupportList, AssistanceDataSupportList_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_eag_1_sequence[] = {
  { &hf_lpp_highAccuracyEllipsoidPointWithUncertaintyEllipse_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_highAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, LocationCoordinateTypes_eag_1_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_eag_2_sequence[] = {
  { &hf_lpp_ha_EllipsoidPointWithScalableUncertaintyEllipse_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_ha_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, LocationCoordinateTypes_eag_2_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_eag_3_sequence[] = {
  { &hf_lpp_local2dPointWithUncertaintyEllipse_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_local3dPointWithUncertaintyEllipsoid_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, LocationCoordinateTypes_eag_3_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_sequence[] = {
  { &hf_lpp_ellipsoidPoint  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithUncertaintyCircle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithUncertaintyEllipse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_polygon         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithAltitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidArc    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_LocationCoordinateTypes_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_LocationCoordinateTypes_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_LocationCoordinateTypes_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_LocationCoordinateTypes, LocationCoordinateTypes_sequence);

  return offset;
}


static const per_sequence_t VelocityTypes_sequence[] = {
  { &hf_lpp_horizontalVelocity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_horizontalWithVerticalVelocity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_horizontalVelocityWithUncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_horizontalWithVerticalVelocityAndUncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_VelocityTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_VelocityTypes, VelocityTypes_sequence);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_01_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_1_sequence[] = {
  { &hf_lpp_periodicalReportingNotSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_idleStateForMeasurements_r14_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_1_sequence);

  return offset;
}


static int * const T_periodicAssistanceData_r15_bits[] = {
  &hf_lpp_T_periodicAssistanceData_r15_solicited,
  &hf_lpp_T_periodicAssistanceData_r15_unsolicited,
  NULL
};

static int
dissect_lpp_T_periodicAssistanceData_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_periodicAssistanceData_r15_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_2_sequence[] = {
  { &hf_lpp_periodicAssistanceData_r15_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_periodicAssistanceData_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_2_sequence);

  return offset;
}


static const per_sequence_t T_gnssTime_r17_sequence[] = {
  { &hf_lpp_posModes_r17    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_gnss_TimeIDs_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_Bitmap },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_gnssTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_gnssTime_r17, T_gnssTime_r17_sequence);

  return offset;
}


static const per_sequence_t ScheduledLocationTimeSupportPerMode_r17_sequence[] = {
  { &hf_lpp_utcTime_r17_PositioningModes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_gnssTime_r17_01 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_gnssTime_r17 },
  { &hf_lpp_e_utraTime_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_nrTime_r17_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_relativeTime_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ScheduledLocationTimeSupportPerMode_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ScheduledLocationTimeSupportPerMode_r17, ScheduledLocationTimeSupportPerMode_r17_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_3_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_3_sequence);

  return offset;
}


static const per_sequence_t PeriodicReportingIntervalMsSupportPerMode_r18_sequence[] = {
  { &hf_lpp_minPeriodicReportingIntervalMs1_Supported_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_minPeriodicReportingIntervalMs10_Supported_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_minPeriodicReportingIntervalMs100_Supported_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PeriodicReportingIntervalMsSupportPerMode_r18, PeriodicReportingIntervalMsSupportPerMode_r18_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_4_sequence[] = {
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_4_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_sequence[] = {
  { &hf_lpp_gnss_SupportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SupportList },
  { &hf_lpp_assistanceDataSupportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AssistanceDataSupportList },
  { &hf_lpp_locationCoordinateTypes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_LocationCoordinateTypes },
  { &hf_lpp_velocityTypes   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_VelocityTypes },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_ProvideCapabilities, A_GNSS_ProvideCapabilities_sequence);

  return offset;
}


static int * const T_otdoa_Mode_bits[] = {
  &hf_lpp_T_otdoa_Mode_ue_assisted,
  &hf_lpp_T_otdoa_Mode_ue_assisted_NB_r14,
  &hf_lpp_T_otdoa_Mode_ue_assisted_NB_TDD_r15,
  NULL
};

static int
dissect_lpp_T_otdoa_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_otdoa_Mode_bits, 3, NULL, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_maxFBI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxFBI, NULL, false);

  return offset;
}


static const per_sequence_t SupportedBandEUTRA_sequence[] = {
  { &hf_lpp_bandEUTRA       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_maxFBI },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SupportedBandEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SupportedBandEUTRA, SupportedBandEUTRA_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_sequence_of[1] = {
  { &hf_lpp_supportedBandListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SupportedBandEUTRA },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA, SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_sequence_of,
                                                  1, maxBands, false);

  return offset;
}



static int
dissect_lpp_INTEGER_maxFBI_Plus1_maxFBI2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            maxFBI_Plus1, maxFBI2, NULL, false);

  return offset;
}


static const per_sequence_t SupportedBandEUTRA_v9a0_sequence[] = {
  { &hf_lpp_bandEUTRA_v9a0  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_maxFBI_Plus1_maxFBI2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SupportedBandEUTRA_v9a0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SupportedBandEUTRA_v9a0, SupportedBandEUTRA_v9a0_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0_sequence_of[1] = {
  { &hf_lpp_supportedBandListEUTRA_v9a0_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SupportedBandEUTRA_v9a0 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0, SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0_sequence_of,
                                                  1, maxBands, false);

  return offset;
}


static const value_string lpp_T_interFreqRSTDmeasurement_r10_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_interFreqRSTDmeasurement_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_additionalNeighbourCellInfoList_r10_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalNeighbourCellInfoList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_id_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_id_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_tp_separation_via_muting_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_tp_separation_via_muting_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_additional_prs_config_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additional_prs_config_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_based_tbs_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_based_tbs_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_additionalPathsReport_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsReport_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_densePrsConfig_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_densePrsConfig_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxSupportedPrsBandwidth_r14_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSupportedPrsBandwidth_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_prsOccGroup_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsOccGroup_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prsFrequencyHopping_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsFrequencyHopping_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxSupportedPrsConfigs_r14_vals[] = {
  {   0, "c2" },
  {   1, "c3" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSupportedPrsConfigs_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_multiPrbNprs_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiPrbNprs_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_numberOfRXantennas_r14_vals[] = {
  {   0, "rx1" },
  { 0, NULL }
};


static int
dissect_lpp_T_numberOfRXantennas_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_motionMeasurements_r15_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_motionMeasurements_r15_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_interRAT_RSTDmeasurement_r15_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_interRAT_RSTDmeasurement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_utcTime_r17_enum_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_utcTime_r17_enum(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_e_utraTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_e_utraTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nrTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nrTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_relativeTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_relativeTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t ScheduledLocationTimeSupport_r17_sequence[] = {
  { &hf_lpp_utcTime_r17_enum, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_utcTime_r17_enum },
  { &hf_lpp_gnssTime_r17    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ID_Bitmap },
  { &hf_lpp_e_utraTime_r17  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_e_utraTime_r17 },
  { &hf_lpp_nrTime_r17      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nrTime_r17 },
  { &hf_lpp_relativeTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_relativeTime_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ScheduledLocationTimeSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ScheduledLocationTimeSupport_r17, ScheduledLocationTimeSupport_r17_sequence);

  return offset;
}


static const value_string lpp_T_minPeriodicReportingIntervalMs_r18_vals[] = {
  {   0, "ms1" },
  {   1, "ms10" },
  {   2, "ms100" },
  { 0, NULL }
};


static int
dissect_lpp_T_minPeriodicReportingIntervalMs_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t PeriodicReportingIntervalMsSupport_r18_sequence[] = {
  { &hf_lpp_minPeriodicReportingIntervalMs_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_minPeriodicReportingIntervalMs_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicReportingIntervalMsSupport_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PeriodicReportingIntervalMsSupport_r18, PeriodicReportingIntervalMsSupport_r18_sequence);

  return offset;
}


static const per_sequence_t OTDOA_ProvideCapabilities_sequence[] = {
  { &hf_lpp_otdoa_Mode      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_otdoa_Mode },
  { &hf_lpp_supportedBandListEUTRA, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA },
  { &hf_lpp_supportedBandListEUTRA_v9a0, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0 },
  { &hf_lpp_interFreqRSTDmeasurement_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_interFreqRSTDmeasurement_r10 },
  { &hf_lpp_additionalNeighbourCellInfoList_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_additionalNeighbourCellInfoList_r10 },
  { &hf_lpp_prs_id_r14      , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prs_id_r14 },
  { &hf_lpp_tp_separation_via_muting_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_tp_separation_via_muting_r14 },
  { &hf_lpp_additional_prs_config_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_additional_prs_config_r14 },
  { &hf_lpp_prs_based_tbs_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prs_based_tbs_r14 },
  { &hf_lpp_additionalPathsReport_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsReport_r14 },
  { &hf_lpp_densePrsConfig_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_densePrsConfig_r14 },
  { &hf_lpp_maxSupportedPrsBandwidth_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_maxSupportedPrsBandwidth_r14 },
  { &hf_lpp_prsOccGroup_r14 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prsOccGroup_r14 },
  { &hf_lpp_prsFrequencyHopping_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prsFrequencyHopping_r14 },
  { &hf_lpp_maxSupportedPrsConfigs_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_maxSupportedPrsConfigs_r14 },
  { &hf_lpp_periodicalReporting_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r14 },
  { &hf_lpp_multiPrbNprs_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_multiPrbNprs_r14 },
  { &hf_lpp_idleStateForMeasurements_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14 },
  { &hf_lpp_numberOfRXantennas_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_numberOfRXantennas_r14 },
  { &hf_lpp_motionMeasurements_r15_01, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_motionMeasurements_r15_01 },
  { &hf_lpp_interRAT_RSTDmeasurement_r15, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_interRAT_RSTDmeasurement_r15 },
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { &hf_lpp_periodicReportingIntervalMsSupport_r18, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupport_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OTDOA_ProvideCapabilities, OTDOA_ProvideCapabilities_sequence);

  return offset;
}


static int * const T_ecid_MeasSupported_bits[] = {
  &hf_lpp_T_ecid_MeasSupported_rsrpSup,
  &hf_lpp_T_ecid_MeasSupported_rsrqSup,
  &hf_lpp_T_ecid_MeasSupported_ueRxTxSup,
  &hf_lpp_T_ecid_MeasSupported_nrsrpSup_r14,
  &hf_lpp_T_ecid_MeasSupported_nrsrqSup_r14,
  NULL
};

static int
dissect_lpp_T_ecid_MeasSupported(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_ecid_MeasSupported_bits, 5, NULL, NULL);

  return offset;
}


static const value_string lpp_T_ueRxTxSupTDD_r13_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_ueRxTxSupTDD_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_1_sequence[] = {
  { &hf_lpp_ueRxTxSupTDD_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ueRxTxSupTDD_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r14_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r14_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_triggeredReporting_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_triggeredReporting_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_02_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_2_sequence[] = {
  { &hf_lpp_periodicalReporting_r14_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r14_01 },
  { &hf_lpp_triggeredReporting_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_triggeredReporting_r14 },
  { &hf_lpp_idleStateForMeasurements_r14_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_2_sequence);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_3_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_3_sequence);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_4_sequence[] = {
  { &hf_lpp_periodicReportingIntervalMsSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupport_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_4_sequence);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_sequence[] = {
  { &hf_lpp_ecid_MeasSupported, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ecid_MeasSupported },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ECID_ProvideCapabilities, ECID_ProvideCapabilities_sequence);

  return offset;
}


static int * const T_sensor_Modes_r13_bits[] = {
  &hf_lpp_T_sensor_Modes_r13_standalone,
  &hf_lpp_T_sensor_Modes_r13_ue_assisted,
  &hf_lpp_T_sensor_Modes_r13_ue_based,
  NULL
};

static int
dissect_lpp_T_sensor_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_sensor_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static const value_string lpp_T_validityPeriodSupported_v1520_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_validityPeriodSupported_v1520(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_validityAreaSupported_v1520_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_validityAreaSupported_v1520(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_AssistanceDataSupportList_r14_eag_1_sequence[] = {
  { &hf_lpp_validityPeriodSupported_v1520, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_validityPeriodSupported_v1520 },
  { &hf_lpp_validityAreaSupported_v1520, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_validityAreaSupported_v1520 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_AssistanceDataSupportList_r14_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_AssistanceDataSupportList_r14_eag_1_sequence);

  return offset;
}


static const per_sequence_t Sensor_AssistanceDataSupportList_r14_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_AssistanceDataSupportList_r14_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_AssistanceDataSupportList_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_AssistanceDataSupportList_r14, Sensor_AssistanceDataSupportList_r14_sequence);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_03_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_sensor_AssistanceDataSupportList_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_AssistanceDataSupportList_r14 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_idleStateForMeasurements_r14_03, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_sensor_MotionInformationSup_r15_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_sensor_MotionInformationSup_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_sensor_MotionInformationSup_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_sensor_MotionInformationSup_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_adjustmentSupported_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_adjustmentSupported_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_3_sequence[] = {
  { &hf_lpp_adjustmentSupported_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_adjustmentSupported_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_3_sequence);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_4_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_4_sequence);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_5_sequence[] = {
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_5_sequence);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_sensor_Modes_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_sensor_Modes_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_4 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_ProvideCapabilities_r13, Sensor_ProvideCapabilities_r13_sequence);

  return offset;
}


static int * const T_tbs_Modes_r13_bits[] = {
  &hf_lpp_T_tbs_Modes_r13_standalone,
  &hf_lpp_T_tbs_Modes_r13_ue_assisted,
  &hf_lpp_T_tbs_Modes_r13_ue_based,
  NULL
};

static int
dissect_lpp_T_tbs_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_tbs_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t MBS_AssistanceDataSupportList_r14_sequence[] = {
  { &hf_lpp_mbs_AcquisitionAssistanceDataSupport_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_mbs_AlmanacAssistanceDataSupport_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_MBS_AssistanceDataSupportList_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_MBS_AssistanceDataSupportList_r14, MBS_AssistanceDataSupportList_r14_sequence);

  return offset;
}


static int * const T_mbs_ConfigSupport_r14_bits[] = {
  &hf_lpp_T_mbs_ConfigSupport_r14_tb1,
  &hf_lpp_T_mbs_ConfigSupport_r14_tb2,
  &hf_lpp_T_mbs_ConfigSupport_r14_tb3,
  &hf_lpp_T_mbs_ConfigSupport_r14_tb4,
  NULL
};

static int
dissect_lpp_T_mbs_ConfigSupport_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_mbs_ConfigSupport_r14_bits, 4, NULL, NULL);

  return offset;
}


static const value_string lpp_T_mbs_IdleStateForMeasurements_r14_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_mbs_IdleStateForMeasurements_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_mbs_AssistanceDataSupportList_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_MBS_AssistanceDataSupportList_r14 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_mbs_ConfigSupport_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mbs_ConfigSupport_r14 },
  { &hf_lpp_mbs_IdleStateForMeasurements_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mbs_IdleStateForMeasurements_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TBS_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TBS_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_eag_3_sequence[] = {
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TBS_ProvideCapabilities_r13_eag_3_sequence);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_tbs_Modes_r13   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_tbs_Modes_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_TBS_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_TBS_ProvideCapabilities_r13_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_TBS_ProvideCapabilities_r13_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TBS_ProvideCapabilities_r13, TBS_ProvideCapabilities_r13_sequence);

  return offset;
}


static int * const T_wlan_Modes_r13_bits[] = {
  &hf_lpp_T_wlan_Modes_r13_standalone,
  &hf_lpp_T_wlan_Modes_r13_ue_assisted,
  &hf_lpp_T_wlan_Modes_r13_ue_based,
  NULL
};

static int
dissect_lpp_T_wlan_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_wlan_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static int * const T_wlan_MeasSupported_r13_bits[] = {
  &hf_lpp_T_wlan_MeasSupported_r13_rssi_r13,
  &hf_lpp_T_wlan_MeasSupported_r13_rtt_r13,
  NULL
};

static int
dissect_lpp_T_wlan_MeasSupported_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_wlan_MeasSupported_r13_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_wlan_AP_AD_Supported_r14_bits[] = {
  &hf_lpp_T_wlan_AP_AD_Supported_r14_ap_identifier,
  &hf_lpp_T_wlan_AP_AD_Supported_r14_ap_location,
  NULL
};

static int
dissect_lpp_T_wlan_AP_AD_Supported_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_wlan_AP_AD_Supported_r14_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_04_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_wlan_AP_AD_Supported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_wlan_AP_AD_Supported_r14 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_idleStateForMeasurements_r14_04, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, WLAN_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, WLAN_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_eag_3_sequence[] = {
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, WLAN_ProvideCapabilities_r13_eag_3_sequence);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_wlan_Modes_r13  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_wlan_Modes_r13 },
  { &hf_lpp_wlan_MeasSupported_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_wlan_MeasSupported_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_ProvideCapabilities_r13_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_ProvideCapabilities_r13_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_ProvideCapabilities_r13, WLAN_ProvideCapabilities_r13_sequence);

  return offset;
}


static int * const T_bt_Modes_r13_bits[] = {
  &hf_lpp_T_bt_Modes_r13_standalone,
  &hf_lpp_T_bt_Modes_r13_ue_assisted,
  &hf_lpp_T_bt_Modes_r13_ue_based_v1810,
  NULL
};

static int
dissect_lpp_T_bt_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_bt_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static int * const T_bt_MeasSupported_r13_bits[] = {
  &hf_lpp_T_bt_MeasSupported_r13_rssi_r13,
  &hf_lpp_T_bt_MeasSupported_r13_aod_v1800,
  NULL
};

static int
dissect_lpp_T_bt_MeasSupported_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_bt_MeasSupported_r13_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_05_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_idleStateForMeasurements_r14_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_05 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BT_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BT_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_bt_AoA_r18_vals[] = {
  {   0, "request-only" },
  {   1, "suggestion" },
  { 0, NULL }
};


static int
dissect_lpp_T_bt_AoA_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_eag_3_sequence[] = {
  { &hf_lpp_bt_AoA_r18      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_bt_AoA_r18 },
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BT_ProvideCapabilities_r13_eag_3_sequence);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_bt_Modes_r13    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_bt_Modes_r13 },
  { &hf_lpp_bt_MeasSupported_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_bt_MeasSupported_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BT_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BT_ProvideCapabilities_r13_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BT_ProvideCapabilities_r13_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BT_ProvideCapabilities_r13, BT_ProvideCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t ProvideCapabilities_r9_IEs_eag_1_sequence[] = {
  { &hf_lpp_sensor_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_ProvideCapabilities_r13 },
  { &hf_lpp_tbs_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TBS_ProvideCapabilities_r13 },
  { &hf_lpp_wlan_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_WLAN_ProvideCapabilities_r13 },
  { &hf_lpp_bt_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BT_ProvideCapabilities_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities_r9_IEs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ProvideCapabilities_r9_IEs_eag_1_sequence);

  return offset;
}


static int * const T_nr_ECID_MeasSupported_r16_bits[] = {
  &hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrpSup,
  &hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrqSup,
  &hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrpSup,
  &hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrqSup,
  NULL
};

static int
dissect_lpp_T_nr_ECID_MeasSupported_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_ECID_MeasSupported_r16_bits, 4, NULL, NULL);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_triggeredReporting_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_triggeredReporting_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ten_ms_unit_ResponseTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ten_ms_unit_ResponseTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_ECID_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ten_ms_unit_ResponseTime_r17 },
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_ECID_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_ECID_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_ECID_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_periodicReportingIntervalMsSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupport_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_ECID_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_ECID_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t NR_ECID_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_ECID_MeasSupported_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_ECID_MeasSupported_r16 },
  { &hf_lpp_periodicalReporting_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r16 },
  { &hf_lpp_triggeredReporting_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_triggeredReporting_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_ECID_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_ECID_ProvideCapabilities_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_ECID_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_ECID_ProvideCapabilities_r16, NR_ECID_ProvideCapabilities_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2U, NULL, false);

  return offset;
}


static const value_string lpp_T_maxNrOfTRP_AcrossFreqs_r16_vals[] = {
  {   0, "n4" },
  {   1, "n6" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n32" },
  {   5, "n64" },
  {   6, "n128" },
  {   7, "n256" },
  {   8, "n24-v1690" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNrOfTRP_AcrossFreqs_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, true, 1, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, false);

  return offset;
}



static int
dissect_lpp_FreqBandIndicatorNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, false);

  return offset;
}


static const value_string lpp_T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16_vals[] = {
  {   0, "n6" },
  {   1, "n24" },
  {   2, "n32" },
  {   3, "n64" },
  {   4, "n96" },
  {   5, "n128" },
  {   6, "n256" },
  {   7, "n512" },
  {   8, "n1024" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t DL_PRS_ResourcesCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_maxNrOfDL_PRS_ResourcesPerResourceSet_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16 },
  { &hf_lpp_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_ResourcesCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_ResourcesCapabilityPerBand_r16, DL_PRS_ResourcesCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_ResourcesCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16_sequence_of[1] = {
  { &hf_lpp_bandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16, SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16_sequence_of,
                                                  1, maxSimultaneousBands_r16, false);

  return offset;
}


static const value_string lpp_T_fr1_Only_r16_vals[] = {
  {   0, "n6" },
  {   1, "n24" },
  {   2, "n64" },
  {   3, "n128" },
  {   4, "n192" },
  {   5, "n256" },
  {   6, "n512" },
  {   7, "n1024" },
  {   8, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1_Only_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_Only_r16_vals[] = {
  {   0, "n24" },
  {   1, "n64" },
  {   2, "n96" },
  {   3, "n128" },
  {   4, "n192" },
  {   5, "n256" },
  {   6, "n512" },
  {   7, "n1024" },
  {   8, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2_Only_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr1_r16_vals[] = {
  {   0, "n6" },
  {   1, "n24" },
  {   2, "n64" },
  {   3, "n96" },
  {   4, "n128" },
  {   5, "n192" },
  {   6, "n256" },
  {   7, "n512" },
  {   8, "n1024" },
  {   9, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_r16_vals[] = {
  {   0, "n24" },
  {   1, "n64" },
  {   2, "n96" },
  {   3, "n128" },
  {   4, "n192" },
  {   5, "n256" },
  {   6, "n512" },
  {   7, "n1024" },
  {   8, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_fr1_FR2Mix_r16_sequence[] = {
  { &hf_lpp_fr1_r16         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_fr1_r16 },
  { &hf_lpp_fr2_r16         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_fr2_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_fr1_FR2Mix_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_fr1_FR2Mix_r16, T_fr1_FR2Mix_r16_sequence);

  return offset;
}


static const value_string lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16_vals[] = {
  {   0, "fr1-Only-r16" },
  {   1, "fr2-Only-r16" },
  {   2, "fr1-FR2Mix-r16" },
  { 0, NULL }
};

static const per_choice_t T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16_choice[] = {
  {   0, &hf_lpp_fr1_Only_r16    , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr1_Only_r16 },
  {   1, &hf_lpp_fr2_Only_r16    , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr2_Only_r16 },
  {   2, &hf_lpp_fr1_FR2Mix_r16  , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr1_FR2Mix_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16, T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DL_PRS_ResourcesBandCombination_r16_sequence[] = {
  { &hf_lpp_bandList_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16 },
  { &hf_lpp_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_ResourcesBandCombination_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_ResourcesBandCombination_r16, DL_PRS_ResourcesBandCombination_r16_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_ResourcesBandCombinationList_r16_sequence_of[1] = {
  { &hf_lpp_DL_PRS_ResourcesBandCombinationList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_ResourcesBandCombination_r16 },
};

static int
dissect_lpp_DL_PRS_ResourcesBandCombinationList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DL_PRS_ResourcesBandCombinationList_r16, DL_PRS_ResourcesBandCombinationList_r16_sequence_of,
                                                  1, maxBandComb_r16, false);

  return offset;
}


static const per_sequence_t NR_DL_PRS_ResourcesCapability_r16_sequence[] = {
  { &hf_lpp_maxNrOfDL_PRS_ResourceSetPerTrpPerFrequencyLayer_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_2 },
  { &hf_lpp_maxNrOfTRP_AcrossFreqs_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfTRP_AcrossFreqs_r16 },
  { &hf_lpp_maxNrOfPosLayer_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16 },
  { &hf_lpp_dl_PRS_ResourcesBandCombinationList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_ResourcesBandCombinationList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_ResourcesCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_PRS_ResourcesCapability_r16, NR_DL_PRS_ResourcesCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_supportOfRSRP_MeasFR1_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfRSRP_MeasFR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfRSRP_MeasFR2_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfRSRP_MeasFR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_srs_AssocPRS_MultiLayersFR1_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_srs_AssocPRS_MultiLayersFR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_srs_AssocPRS_MultiLayersFR2_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_srs_AssocPRS_MultiLayersFR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_UE_RxTEG_ID_MaxSupport_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_UE_RxTEG_ID_MaxSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_UE_TxTEG_ID_MaxSupport_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_UE_TxTEG_ID_MaxSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_UE_RxTxTEG_ID_MaxSupport_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n36" },
  {  10, "n48" },
  {  11, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_UE_RxTxTEG_ID_MaxSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_UE_TEG_ID_CapabilityPerBand_r17_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_nr_UE_RxTEG_ID_MaxSupport_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_RxTEG_ID_MaxSupport_r17 },
  { &hf_lpp_nr_UE_TxTEG_ID_MaxSupport_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_TxTEG_ID_MaxSupport_r17 },
  { &hf_lpp_nr_UE_RxTxTEG_ID_MaxSupport_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_RxTxTEG_ID_MaxSupport_r17 },
  { &hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17 },
  { &hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17, NR_UE_TEG_ID_CapabilityPerBand_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17_sequence_of[1] = {
  { &hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const per_sequence_t NR_UE_TEG_Capability_r17_sequence[] = {
  { &hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UE_TEG_Capability_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UE_TEG_Capability_r17, NR_UE_TEG_Capability_r17_sequence);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasRRC_Inactive_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_BWA_RRC_Connected_r18_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Connected_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_BWA_RRC_Inactive_r18_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Inactive_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_NTN_MeasAndReport_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_NTN_MeasAndReport_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_RSCP_RRC_Connected_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_RSCP_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_RSCP_RRC_Inactive_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_RSCP_RRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_assocSingleRx_Tx_WithUpToNsampleRSCP_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_assocSingleRx_Tx_WithUpToNsampleRSCP_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfSymbolTimeStampForRSCP_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfSymbolTimeStampForRSCP_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfFinerTimingReportGranularityForPRS_Meas_r18_01_vals[] = {
  {   0, "minus1" },
  {   1, "minus2" },
  {   2, "minus3" },
  {   3, "minus4" },
  {   4, "minus5" },
  {   5, "minus6" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfFinerTimingReportGranularityForPRS_Meas_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static int * const T_supportOfMeasurementsInTimeWindow_r18_02_bits[] = {
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rx_tx,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rsrp,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rsrpp,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_02_rscp,
  NULL
};

static int
dissect_lpp_T_supportOfMeasurementsInTimeWindow_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_supportOfMeasurementsInTimeWindow_r18_02_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t Multi_RTT_MeasCapabilityPerBand_r17_eag_1_sequence[] = {
  { &hf_lpp_supportOfDL_PRS_BWA_RRC_Connected_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Connected_r18_01 },
  { &hf_lpp_supportOfDL_PRS_BWA_RRC_Inactive_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Inactive_r18_01 },
  { &hf_lpp_nr_NTN_MeasAndReport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_NTN_MeasAndReport_r18 },
  { &hf_lpp_nr_DL_PRS_RSCP_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_RSCP_RRC_Connected_r18 },
  { &hf_lpp_nr_DL_PRS_RSCP_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_RSCP_RRC_Inactive_r18 },
  { &hf_lpp_assocSingleRx_Tx_WithUpToNsampleRSCP_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_assocSingleRx_Tx_WithUpToNsampleRSCP_r18 },
  { &hf_lpp_supportOfSymbolTimeStampForRSCP_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfSymbolTimeStampForRSCP_r18 },
  { &hf_lpp_supportOfFinerTimingReportGranularityForPRS_Meas_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfFinerTimingReportGranularityForPRS_Meas_r18_01 },
  { &hf_lpp_supportOfMeasurementsInTimeWindow_r18_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfMeasurementsInTimeWindow_r18_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Multi_RTT_MeasCapabilityPerBand_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Multi_RTT_MeasCapabilityPerBand_r17_eag_1_sequence);

  return offset;
}


static const per_sequence_t Multi_RTT_MeasCapabilityPerBand_r17_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_01 },
  { &hf_lpp_dl_PRS_MeasRRC_Inactive_r17_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_02 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Multi_RTT_MeasCapabilityPerBand_r17_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Multi_RTT_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Multi_RTT_MeasCapabilityPerBand_r17, Multi_RTT_MeasCapabilityPerBand_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17_sequence_of[1] = {
  { &hf_lpp_multi_RTT_MeasCapabilityBandList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_Multi_RTT_MeasCapabilityPerBand_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_MeasurementCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_UE_TEG_Capability_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UE_TEG_Capability_r17 },
  { &hf_lpp_multi_RTT_MeasCapabilityBandList_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_MeasurementCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_MeasurementCapability_r16_sequence[] = {
  { &hf_lpp_maxNrOfRx_TX_MeasFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_maxNrOfRx_TX_MeasFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_supportOfRSRP_MeasFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfRSRP_MeasFR1_r16 },
  { &hf_lpp_supportOfRSRP_MeasFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfRSRP_MeasFR2_r16 },
  { &hf_lpp_srs_AssocPRS_MultiLayersFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_srs_AssocPRS_MultiLayersFR1_r16 },
  { &hf_lpp_srs_AssocPRS_MultiLayersFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_srs_AssocPRS_MultiLayersFR2_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_MeasurementCapability_r16, NR_Multi_RTT_MeasurementCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_ssb_FromNeighCellAsQCL_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssb_FromNeighCellAsQCL_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_FromServNeighCellAsQCL_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_FromServNeighCellAsQCL_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_ssb_FromNeighCellAsQCL_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ssb_FromNeighCellAsQCL_r16 },
  { &hf_lpp_prs_FromServNeighCellAsQCL_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_prs_FromServNeighCellAsQCL_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16, DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const per_sequence_t NR_DL_PRS_QCL_ProcessingCapability_r16_sequence[] = {
  { &hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16, NR_DL_PRS_QCL_ProcessingCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_fr1_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz80" },
  {   6, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportedBandwidthPRS_r16_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};

static const per_choice_t T_supportedBandwidthPRS_r16_choice[] = {
  {   0, &hf_lpp_fr1             , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr1 },
  {   1, &hf_lpp_fr2             , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr2 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_supportedBandwidthPRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_supportedBandwidthPRS_r16, T_supportedBandwidthPRS_r16_choice,
                                 NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_BufferType_r16_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_BufferType_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbols_r16_vals[] = {
  {   0, "nDot125" },
  {   1, "nDot25" },
  {   2, "nDot5" },
  {   3, "n1" },
  {   4, "n2" },
  {   5, "n4" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n12" },
  {   9, "n16" },
  {  10, "n20" },
  {  11, "n25" },
  {  12, "n30" },
  {  13, "n32" },
  {  14, "n35" },
  {  15, "n40" },
  {  16, "n45" },
  {  17, "n50" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbols_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r16_vals[] = {
  {   0, "n8" },
  {   1, "n16" },
  {   2, "n20" },
  {   3, "n30" },
  {   4, "n40" },
  {   5, "n80" },
  {   6, "n160" },
  {   7, "n320" },
  {   8, "n640" },
  {   9, "n1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_durationOfPRS_Processing_r16_sequence[] = {
  { &hf_lpp_durationOfPRS_ProcessingSymbols_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbols_r16 },
  { &hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_durationOfPRS_Processing_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_durationOfPRS_Processing_r16, T_durationOfPRS_Processing_r16_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs15_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_eag_1_sequence[] = {
  { &hf_lpp_scs15_v1690     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs15_v1690 },
  { &hf_lpp_scs30_v1690     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs30_v1690 },
  { &hf_lpp_scs60_v1690     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs60_v1690 },
  { &hf_lpp_scs120_v1690    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs120_v1690 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_sequence);

  return offset;
}


static const per_sequence_t T_maxNumOfDL_PRS_ResProcessedPerSlot_r16_sequence[] = {
  { &hf_lpp_scs15_r16_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r16_01 },
  { &hf_lpp_scs30_r16_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r16_01 },
  { &hf_lpp_scs60_r16_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r16_01 },
  { &hf_lpp_scs120_r16_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r16_01 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_T_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16, T_maxNumOfDL_PRS_ResProcessedPerSlot_r16_sequence);

  return offset;
}


static const value_string lpp_T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_ProcessingWindowType1A_r17_vals[] = {
  {   0, "option1" },
  {   1, "option2" },
  {   2, "option3" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_ProcessingWindowType1A_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_ProcessingWindowType1B_r17_vals[] = {
  {   0, "option1" },
  {   1, "option2" },
  {   2, "option3" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_ProcessingWindowType1B_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_ProcessingWindowType2_r17_vals[] = {
  {   0, "option1" },
  {   1, "option2" },
  {   2, "option3" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_ProcessingWindowType2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prsProcessingType_r17_vals[] = {
  {   0, "type1A" },
  {   1, "type1B" },
  {   2, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsProcessingType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_dl_PRS_BufferType_r17_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_dl_PRS_BufferType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsN_r17_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms4" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms12" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms25" },
  {  12, "ms30" },
  {  13, "ms32" },
  {  14, "ms35" },
  {  15, "ms40" },
  {  16, "ms45" },
  {  17, "ms50" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsT_r17_vals[] = {
  {   0, "ms1" },
  {   1, "ms2" },
  {   2, "ms4" },
  {   3, "ms8" },
  {   4, "ms16" },
  {   5, "ms20" },
  {   6, "ms30" },
  {   7, "ms40" },
  {   8, "ms80" },
  {   9, "ms160" },
  {  10, "ms320" },
  {  11, "ms640" },
  {  12, "ms1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_durationOfPRS_Processing1_r17_sequence[] = {
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN_r17 },
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_durationOfPRS_Processing1_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_durationOfPRS_Processing1_r17, T_ppw_durationOfPRS_Processing1_r17_sequence);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsN2_r17_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms3" },
  {   6, "ms4" },
  {   7, "ms5" },
  {   8, "ms6" },
  {   9, "ms8" },
  {  10, "ms12" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsT2_r17_vals[] = {
  {   0, "ms4" },
  {   1, "ms5" },
  {   2, "ms6" },
  {   3, "ms8" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_durationOfPRS_Processing2_r17_sequence[] = {
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN2_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN2_r17 },
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT2_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_durationOfPRS_Processing2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_durationOfPRS_Processing2_r17, T_ppw_durationOfPRS_Processing2_r17_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17_sequence[] = {
  { &hf_lpp_scs15_r17_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r17_01 },
  { &hf_lpp_scs30_r17_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r17_01 },
  { &hf_lpp_scs60_r17_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r17_01 },
  { &hf_lpp_scs120_r17_02   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17, T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17_sequence);

  return offset;
}


static const value_string lpp_T_fr1_01_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz80" },
  {   6, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_01_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_maxNumOfDL_Bandwidth_r17_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};

static const per_choice_t T_ppw_maxNumOfDL_Bandwidth_r17_choice[] = {
  {   0, &hf_lpp_fr1_01          , ASN1_NO_EXTENSIONS     , dissect_lpp_T_fr1_01 },
  {   1, &hf_lpp_fr2_01          , ASN1_NO_EXTENSIONS     , dissect_lpp_T_fr2_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_ppw_maxNumOfDL_Bandwidth_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_ppw_maxNumOfDL_Bandwidth_r17, T_ppw_maxNumOfDL_Bandwidth_r17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1_sequence[] = {
  { &hf_lpp_ppw_maxNumOfDL_Bandwidth_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ppw_maxNumOfDL_Bandwidth_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1_sequence);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence[] = {
  { &hf_lpp_prsProcessingType_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_prsProcessingType_r17 },
  { &hf_lpp_ppw_dl_PRS_BufferType_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_dl_PRS_BufferType_r17 },
  { &hf_lpp_ppw_durationOfPRS_Processing1_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ppw_durationOfPRS_Processing1_r17 },
  { &hf_lpp_ppw_durationOfPRS_Processing2_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ppw_durationOfPRS_Processing2_r17 },
  { &hf_lpp_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17, PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence_of[1] = {
  { &hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17, SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence_of,
                                                  1, 3, false);

  return offset;
}


static const value_string lpp_T_dl_PRS_BufferType_RRC_Inactive_r17_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_BufferType_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbols_r17_vals[] = {
  {   0, "nDot125" },
  {   1, "nDot25" },
  {   2, "nDot5" },
  {   3, "n1" },
  {   4, "n2" },
  {   5, "n4" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n12" },
  {   9, "n16" },
  {  10, "n20" },
  {  11, "n25" },
  {  12, "n30" },
  {  13, "n32" },
  {  14, "n35" },
  {  15, "n40" },
  {  16, "n45" },
  {  17, "n50" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbols_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r17_vals[] = {
  {   0, "n8" },
  {   1, "n16" },
  {   2, "n20" },
  {   3, "n30" },
  {   4, "n40" },
  {   5, "n80" },
  {   6, "n160" },
  {   7, "n320" },
  {   8, "n640" },
  {   9, "n1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_durationOfPRS_Processing_RRC_Inactive_r17_sequence[] = {
  { &hf_lpp_durationOfPRS_ProcessingSymbols_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbols_r17 },
  { &hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17, T_durationOfPRS_Processing_RRC_Inactive_r17_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17_sequence[] = {
  { &hf_lpp_scs15_r17_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r17 },
  { &hf_lpp_scs30_r17_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r17 },
  { &hf_lpp_scs60_r17_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r17 },
  { &hf_lpp_scs120_r17_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17, T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17_sequence);

  return offset;
}


static const value_string lpp_T_supportedLowerRxBeamSweepingFactor_FR2_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportedLowerRxBeamSweepingFactor_FR2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17 },
  { &hf_lpp_prs_ProcessingWindowType1A_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_ProcessingWindowType1A_r17 },
  { &hf_lpp_prs_ProcessingWindowType1B_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_ProcessingWindowType1B_r17 },
  { &hf_lpp_prs_ProcessingWindowType2_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_ProcessingWindowType2_r17 },
  { &hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 },
  { &hf_lpp_dl_PRS_BufferType_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_BufferType_RRC_Inactive_r17 },
  { &hf_lpp_durationOfPRS_Processing_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17 },
  { &hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17 },
  { &hf_lpp_supportedLowerRxBeamSweepingFactor_FR2_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportedLowerRxBeamSweepingFactor_FR2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_2_sequence[] = {
  { &hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_prs_MeasurementWithoutMG_r17_vals[] = {
  {   0, "cp" },
  {   1, "symbolDot25" },
  {   2, "symbolDot5" },
  {   3, "slotDot5" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_MeasurementWithoutMG_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_3_sequence[] = {
  { &hf_lpp_prs_MeasurementWithoutMG_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_MeasurementWithoutMG_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_3_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18_sequence[] = {
  { &hf_lpp_scs15_r18_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r18 },
  { &hf_lpp_scs30_r18_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r18 },
  { &hf_lpp_scs60_r18_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18 },
  { &hf_lpp_scs120_r18_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18, T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18_sequence[] = {
  { &hf_lpp_scs15_r18_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r18_01 },
  { &hf_lpp_scs30_r18_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r18_01 },
  { &hf_lpp_scs60_r18_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18_01 },
  { &hf_lpp_scs120_r18_02   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r18_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18, T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18_sequence[] = {
  { &hf_lpp_scs15_r18_03    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r18_02 },
  { &hf_lpp_scs30_r18_03    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r18_02 },
  { &hf_lpp_scs60_r18_03    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18_02 },
  { &hf_lpp_scs120_r18_03   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r18_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18, T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18_sequence);

  return offset;
}


static const value_string lpp_T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR1_r18_vals[] = {
  {   0, "mhz10" },
  {   1, "mhz20" },
  {   2, "mhz40" },
  {   3, "mhz50" },
  {   4, "mhz80" },
  {   5, "mhz100" },
  {   6, "mhz160" },
  {   7, "mhz200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR2_r18_vals[] = {
  {   0, "mhz100" },
  {   1, "mhz200" },
  {   2, "mhz400" },
  {   3, "mhz800" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz80" },
  {   6, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_BufferTypeOfBWA_r18_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_BufferTypeOfBWA_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsN_r18_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms4" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms12" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms25" },
  {  12, "ms30" },
  {  13, "ms32" },
  {  14, "ms35" },
  {  15, "ms40" },
  {  16, "ms45" },
  {  17, "ms50" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsN_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsT_r18_vals[] = {
  {   0, "ms8" },
  {   1, "ms16" },
  {   2, "ms20" },
  {   3, "ms30" },
  {   4, "ms40" },
  {   5, "ms80" },
  {   6, "ms160" },
  {   7, "ms320" },
  {   8, "ms640" },
  {   9, "ms1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsT_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_prs_durationOfTwoPRS_BWA_Processing_r18_sequence[] = {
  { &hf_lpp_prs_durationOfTwoPRS_BWA_ProcessingSymbolsN_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsN_r18 },
  { &hf_lpp_prs_durationOfTwoPRS_BWA_ProcessingSymbolsT_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_prs_durationOfTwoPRS_BWA_ProcessingSymbolsT_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_prs_durationOfTwoPRS_BWA_Processing_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_prs_durationOfTwoPRS_BWA_Processing_r18, T_prs_durationOfTwoPRS_BWA_Processing_r18_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r18_03_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r18_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r18_03_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r18_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r18_03_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_sequence[] = {
  { &hf_lpp_scs15_r18_04    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r18_03 },
  { &hf_lpp_scs30_r18_04    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r18_03 },
  { &hf_lpp_scs60_r18_04    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18, T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_sequence);

  return offset;
}


static const value_string lpp_T_scs60_r18_04_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r18_03_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r18_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_sequence[] = {
  { &hf_lpp_scs60_r18_05    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18_04 },
  { &hf_lpp_scs120_r18_04   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r18_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18, T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_sequence);

  return offset;
}


static const per_sequence_t PRS_BWA_TwoContiguousIntrabandInMG_r18_sequence[] = {
  { &hf_lpp_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR1_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR1_r18 },
  { &hf_lpp_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR2_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfTwoAggregatedDL_PRS_Bandwidth_FR2_r18 },
  { &hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18 },
  { &hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18 },
  { &hf_lpp_dl_PRS_BufferTypeOfBWA_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_PRS_BufferTypeOfBWA_r18 },
  { &hf_lpp_prs_durationOfTwoPRS_BWA_Processing_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_durationOfTwoPRS_BWA_Processing_r18 },
  { &hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18 },
  { &hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_BWA_TwoContiguousIntrabandInMG_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_BWA_TwoContiguousIntrabandInMG_r18, PRS_BWA_TwoContiguousIntrabandInMG_r18_sequence);

  return offset;
}


static const value_string lpp_T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR1_r18_vals[] = {
  {   0, "mhz15" },
  {   1, "mhz20" },
  {   2, "mhz30" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz60" },
  {   6, "mhz80" },
  {   7, "mhz100" },
  {   8, "mhz120" },
  {   9, "mhz140" },
  {  10, "mhz150" },
  {  11, "mhz180" },
  {  12, "mhz200" },
  {  13, "mhz240" },
  {  14, "mhz300" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR2_r18_vals[] = {
  {   0, "mhz150" },
  {   1, "mhz200" },
  {   2, "mhz300" },
  {   3, "mhz400" },
  {   4, "mhz600" },
  {   5, "mhz800" },
  {   6, "mhz1000" },
  {   7, "mhz1200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_01_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz80" },
  {   6, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_01_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_BufferTypeOfBWA_r18_01_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_BufferTypeOfBWA_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_durationOfThreePRS_BWA_ProcessingSymbolsN_r18_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms4" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms12" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms25" },
  {  12, "ms30" },
  {  13, "ms32" },
  {  14, "ms35" },
  {  15, "ms40" },
  {  16, "ms45" },
  {  17, "ms50" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_durationOfThreePRS_BWA_ProcessingSymbolsN_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_durationOfThreePRS_BWA_ProcessingSymbolsT_r18_vals[] = {
  {   0, "ms8" },
  {   1, "ms16" },
  {   2, "ms20" },
  {   3, "ms30" },
  {   4, "ms40" },
  {   5, "ms80" },
  {   6, "ms160" },
  {   7, "ms320" },
  {   8, "ms640" },
  {   9, "ms1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_durationOfThreePRS_BWA_ProcessingSymbolsT_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_prs_durationOfThreePRS_BWA_Processing_r18_sequence[] = {
  { &hf_lpp_prs_durationOfThreePRS_BWA_ProcessingSymbolsN_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_prs_durationOfThreePRS_BWA_ProcessingSymbolsN_r18 },
  { &hf_lpp_prs_durationOfThreePRS_BWA_ProcessingSymbolsT_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_prs_durationOfThreePRS_BWA_ProcessingSymbolsT_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_prs_durationOfThreePRS_BWA_Processing_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_prs_durationOfThreePRS_BWA_Processing_r18, T_prs_durationOfThreePRS_BWA_Processing_r18_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r18_04_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r18_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r18_04_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r18_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r18_05_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01_sequence[] = {
  { &hf_lpp_scs15_r18_05    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r18_04 },
  { &hf_lpp_scs30_r18_05    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r18_04 },
  { &hf_lpp_scs60_r18_06    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18_05 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01, T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01_sequence);

  return offset;
}


static const value_string lpp_T_scs60_r18_06_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r18_06(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r18_04_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r18_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01_sequence[] = {
  { &hf_lpp_scs60_r18_07    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r18_06 },
  { &hf_lpp_scs120_r18_05   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r18_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01, T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01_sequence);

  return offset;
}


static const per_sequence_t PRS_BWA_ThreeContiguousIntrabandInMG_r18_sequence[] = {
  { &hf_lpp_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR1_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR1_r18 },
  { &hf_lpp_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR2_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfThreeAggregatedDL_PRS_Bandwidth_FR2_r18 },
  { &hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR1_r18_01 },
  { &hf_lpp_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maximumOfDL_PRS_BandwidthPerPFL_FR2_r18_01 },
  { &hf_lpp_dl_PRS_BufferTypeOfBWA_r18_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_PRS_BufferTypeOfBWA_r18_01 },
  { &hf_lpp_prs_durationOfThreePRS_BWA_Processing_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_durationOfThreePRS_BWA_Processing_r18 },
  { &hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR1_r18_01 },
  { &hf_lpp_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumOfAggregatedDL_PRS_ResourcePerSlot_FR2_r18_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_BWA_ThreeContiguousIntrabandInMG_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_BWA_ThreeContiguousIntrabandInMG_r18, PRS_BWA_ThreeContiguousIntrabandInMG_r18_sequence);

  return offset;
}


static const value_string lpp_T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_Connected_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_IdleAndInactive_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_IdleAndInactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasurementWithRxFH_RRC_Inactive_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasurementWithRxFH_RRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasurementWithRxFH_RRC_Idle_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasurementWithRxFH_RRC_Idle_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_reducedNumOfSampleForMeasurementWithFH_RRC_Connected_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_reducedNumOfSampleForMeasurementWithFH_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_reducedNumOfSampleForMeasurementWithFH_RRC_IdleAndInactive_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_reducedNumOfSampleForMeasurementWithFH_RRC_IdleAndInactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfPRS_BWA_WithTwoPFL_Combination_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfPRS_BWA_WithTwoPFL_Combination_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumPRS_BandwidthAcrossAllHopsFR1_r18_vals[] = {
  {   0, "mhz40" },
  {   1, "mhz50" },
  {   2, "mhz80" },
  {   3, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumPRS_BandwidthAcrossAllHopsFR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumPRS_BandwidthAcrossAllHopsFR2_r18_vals[] = {
  {   0, "mhz100" },
  {   1, "mhz200" },
  {   2, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumPRS_BandwidthAcrossAllHopsFR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumFH_Hops_r18_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n4" },
  {   3, "n5" },
  {   4, "n6" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumFH_Hops_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_processingPRS_SymbolsDurationN3_r18_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms4" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms12" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms25" },
  {  12, "ms30" },
  {  13, "ms32" },
  {  14, "ms35" },
  {  15, "ms40" },
  {  16, "ms45" },
  {  17, "ms50" },
  { 0, NULL }
};


static int
dissect_lpp_T_processingPRS_SymbolsDurationN3_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_processingDurationT3_r18_vals[] = {
  {   0, "ms8" },
  {   1, "ms16" },
  {   2, "ms20" },
  {   3, "ms30" },
  {   4, "ms40" },
  {   5, "ms80" },
  {   6, "ms160" },
  {   7, "ms320" },
  {   8, "ms640" },
  {   9, "ms1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_processingDurationT3_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_processingDuration_r18_sequence[] = {
  { &hf_lpp_processingPRS_SymbolsDurationN3_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_processingPRS_SymbolsDurationN3_r18 },
  { &hf_lpp_processingDurationT3_r18, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_processingDurationT3_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_processingDuration_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_processingDuration_r18, T_processingDuration_r18_sequence);

  return offset;
}


static const value_string lpp_T_rf_RxRetuneTimeFR1_r18_vals[] = {
  {   0, "n70" },
  {   1, "n140" },
  {   2, "n210" },
  { 0, NULL }
};


static int
dissect_lpp_T_rf_RxRetuneTimeFR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_rf_RxRetuneTimeFR2_r18_vals[] = {
  {   0, "n35" },
  {   1, "n70" },
  {   2, "n140" },
  { 0, NULL }
};


static int
dissect_lpp_T_rf_RxRetuneTimeFR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_numOfOverlappingPRB_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  { 0, NULL }
};


static int
dissect_lpp_T_numOfOverlappingPRB_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DL_PRS_MeasurementWithRxFH_RRC_Connected_r18_sequence[] = {
  { &hf_lpp_maximumPRS_BandwidthAcrossAllHopsFR1_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumPRS_BandwidthAcrossAllHopsFR1_r18 },
  { &hf_lpp_maximumPRS_BandwidthAcrossAllHopsFR2_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumPRS_BandwidthAcrossAllHopsFR2_r18 },
  { &hf_lpp_maximumFH_Hops_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumFH_Hops_r18 },
  { &hf_lpp_processingDuration_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_processingDuration_r18 },
  { &hf_lpp_rf_RxRetuneTimeFR1_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_rf_RxRetuneTimeFR1_r18 },
  { &hf_lpp_rf_RxRetuneTimeFR2_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_rf_RxRetuneTimeFR2_r18 },
  { &hf_lpp_numOfOverlappingPRB_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_numOfOverlappingPRB_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_MeasurementWithRxFH_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_MeasurementWithRxFH_RRC_Connected_r18, DL_PRS_MeasurementWithRxFH_RRC_Connected_r18_sequence);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_4_sequence[] = {
  { &hf_lpp_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Inactive_r18 },
  { &hf_lpp_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfOneSymbolPRS_ResProcessedPerSlot_RRC_Connected_r18 },
  { &hf_lpp_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ppw_maxNumOfOneSymbolPRS_ResProcessedPerSlot_r18 },
  { &hf_lpp_prs_BWA_TwoContiguousIntrabandInMG_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PRS_BWA_TwoContiguousIntrabandInMG_r18 },
  { &hf_lpp_prs_BWA_ThreeContiguousIntrabandInMG_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PRS_BWA_ThreeContiguousIntrabandInMG_r18 },
  { &hf_lpp_prs_BWA_TwoContiguousIntraband_RRC_IdleAndInactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PRS_BWA_TwoContiguousIntrabandInMG_r18 },
  { &hf_lpp_prs_BWA_ThreeContiguousIntraband_RRC_IdleAndInactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PRS_BWA_ThreeContiguousIntrabandInMG_r18 },
  { &hf_lpp_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_Connected_r18 },
  { &hf_lpp_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_IdleAndInactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_reducedNumOfSampleInMeasurementWithPRS_BWA_RRC_IdleAndInactive_r18 },
  { &hf_lpp_dl_PRS_MeasurementWithRxFH_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasurementWithRxFH_RRC_Inactive_r18 },
  { &hf_lpp_dl_PRS_MeasurementWithRxFH_RRC_Idle_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasurementWithRxFH_RRC_Idle_r18 },
  { &hf_lpp_reducedNumOfSampleForMeasurementWithFH_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_reducedNumOfSampleForMeasurementWithFH_RRC_Connected_r18 },
  { &hf_lpp_reducedNumOfSampleForMeasurementWithFH_RRC_IdleAndInactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_reducedNumOfSampleForMeasurementWithFH_RRC_IdleAndInactive_r18 },
  { &hf_lpp_supportOfPRS_BWA_WithTwoPFL_Combination_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfPRS_BWA_WithTwoPFL_Combination_r18 },
  { &hf_lpp_dl_PRS_MeasurementWithRxFH_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_DL_PRS_MeasurementWithRxFH_RRC_Connected_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_4_sequence);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_supportedBandwidthPRS_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_supportedBandwidthPRS_r16 },
  { &hf_lpp_dl_PRS_BufferType_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_PRS_BufferType_r16 },
  { &hf_lpp_durationOfPRS_Processing_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_Processing_r16 },
  { &hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_ProcessingCapabilityPerBand_r16, PRS_ProcessingCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_prs_ProcessingCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const value_string lpp_T_simulLTE_NR_PRS_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_simulLTE_NR_PRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dummy_vals[] = {
  {   0, "m1" },
  {   1, "m2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dummy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_PRS_ProcessingCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_dummy           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dummy },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_ProcessingCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_PRS_ProcessingCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_PRS_ProcessingCapability_r16_sequence[] = {
  { &hf_lpp_prs_ProcessingCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16 },
  { &hf_lpp_maxSupportedFreqLayers_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_simulLTE_NR_PRS_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_simulLTE_NR_PRS_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_ProcessingCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_PRS_ProcessingCapability_r16, NR_DL_PRS_ProcessingCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_olpc_SRS_PosBasedOnPRS_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_olpc_SRS_PosBasedOnSSB_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_olpc_SRS_PosBasedOnSSB_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_olpc_SRS_PosBasedOnPRS_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberPathLossEstimatePerServing_r16_vals[] = {
  {   0, "n1" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberPathLossEstimatePerServing_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t OLPC_SRS_Pos_r16_sequence[] = {
  { &hf_lpp_olpc_SRS_PosBasedOnPRS_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Serving_r16 },
  { &hf_lpp_olpc_SRS_PosBasedOnSSB_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_olpc_SRS_PosBasedOnSSB_Neigh_r16 },
  { &hf_lpp_olpc_SRS_PosBasedOnPRS_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Neigh_r16 },
  { &hf_lpp_maxNumberPathLossEstimatePerServing_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberPathLossEstimatePerServing_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OLPC_SRS_Pos_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OLPC_SRS_Pos_r16, OLPC_SRS_Pos_r16_sequence);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnSRS_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnSRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t SpatialRelationsSRS_Pos_r16_sequence[] = {
  { &hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnSRS_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnSRS_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SpatialRelationsSRS_Pos_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SpatialRelationsSRS_Pos_r16, SpatialRelationsSRS_Pos_r16_sequence);

  return offset;
}


static const value_string lpp_T_maxNumOfSRSposResourceSets_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSRSposResourceSets_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResources_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dummy1_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_dummy1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dummy2_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_dummy2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_RRC_Inactive_InInitialUL_BWP_r17_sequence[] = {
  { &hf_lpp_maxNumOfSRSposResourceSets_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSRSposResourceSets_r17 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17 },
  { &hf_lpp_maxNumOfPeriodicSRSposResources_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17 },
  { &hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17 },
  { &hf_lpp_dummy1          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dummy1 },
  { &hf_lpp_dummy2          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dummy2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17, PosSRS_RRC_Inactive_InInitialUL_BWP_r17_sequence);

  return offset;
}


static const value_string lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz15" },
  {   3, "mhz20" },
  {   4, "mhz25" },
  {   5, "mhz30" },
  {   6, "mhz35" },
  {   7, "mhz40" },
  {   8, "mhz45" },
  {   9, "mhz50" },
  {  10, "mhz60" },
  {  11, "mhz70" },
  {  12, "mhz80" },
  {  13, "mhz90" },
  {  14, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSRSposResourceSets_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSRSposResourceSets_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResources_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_differentNumerologyBetweenSRSposAndInitialBWP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_differentNumerologyBetweenSRSposAndInitialBWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_srsPosWithoutRestrictionOnBWP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_srsPosWithoutRestrictionOnBWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_differentCenterFreqBetweenSRSposAndInitialBWP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_differentCenterFreqBetweenSRSposAndInitialBWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResources_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_switchingTimeSRS_TX_OtherTX_r17_vals[] = {
  {   0, "us100" },
  {   1, "us140" },
  {   2, "us200" },
  {   3, "us300" },
  {   4, "us500" },
  { 0, NULL }
};


static int
dissect_lpp_T_switchingTimeSRS_TX_OtherTX_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17_sequence[] = {
  { &hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17 },
  { &hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17 },
  { &hf_lpp_maxNumOfSRSposResourceSets_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSRSposResourceSets_r17_01 },
  { &hf_lpp_maxNumOfPeriodicSRSposResources_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17_01 },
  { &hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01 },
  { &hf_lpp_differentNumerologyBetweenSRSposAndInitialBWP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_differentNumerologyBetweenSRSposAndInitialBWP_r17 },
  { &hf_lpp_srsPosWithoutRestrictionOnBWP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_srsPosWithoutRestrictionOnBWP_r17 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01 },
  { &hf_lpp_differentCenterFreqBetweenSRSposAndInitialBWP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_differentCenterFreqBetweenSRSposAndInitialBWP_r17 },
  { &hf_lpp_maxNumOfSemiPersistentSRSposResources_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17 },
  { &hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17 },
  { &hf_lpp_switchingTimeSRS_TX_OtherTX_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_switchingTimeSRS_TX_OtherTX_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17, PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_posSRS_RRC_Inactive_InInitialUL_BWP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17 },
  { &hf_lpp_posSRS_RRC_Inactive_OutsideInitialUL_BWP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 },
  { &hf_lpp_olpc_SRS_PosRRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_OLPC_SRS_Pos_r16 },
  { &hf_lpp_spatialRelationsSRS_PosRRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SpatialRelationsSRS_Pos_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SRS_CapabilityPerBand_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResources_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17_sequence[] = {
  { &hf_lpp_maxNumOfSemiPersistentSRSposResources_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17_01 },
  { &hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17, PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_eag_2_sequence[] = {
  { &hf_lpp_posSRS_SP_RRC_Inactive_InInitialUL_BWP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SRS_CapabilityPerBand_r16_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_posSRS_Preconfigured_RRC_InactiveInitialUL_BWP_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posSRS_Preconfigured_RRC_InactiveInitialUL_BWP_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_posSRS_Preconfigured_RRC_InactiveOutsideInitialUL_BWP_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posSRS_Preconfigured_RRC_InactiveOutsideInitialUL_BWP_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_BandwidthAcrossAllHopsFR1_r18_vals[] = {
  {   0, "mhz40" },
  {   1, "mhz50" },
  {   2, "mhz80" },
  {   3, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_BandwidthAcrossAllHopsFR2_r18_vals[] = {
  {   0, "mhz100" },
  {   1, "mhz200" },
  {   2, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumTxFH_Hops_r18_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n4" },
  {   3, "n5" },
  {   4, "n6" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumTxFH_Hops_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_rf_TxRetuneTimeFR1_r18_vals[] = {
  {   0, "n70" },
  {   1, "n140" },
  {   2, "n210" },
  { 0, NULL }
};


static int
dissect_lpp_T_rf_TxRetuneTimeFR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_rf_TxRetuneTimeFR2_r18_vals[] = {
  {   0, "n35" },
  {   1, "n70" },
  {   2, "n140" },
  { 0, NULL }
};


static int
dissect_lpp_T_rf_TxRetuneTimeFR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_switchTimeBetweenActiveBWP_FrequencyHop_r18_vals[] = {
  {   0, "n100" },
  {   1, "n140" },
  {   2, "n200" },
  {   3, "n300" },
  {   4, "n500" },
  { 0, NULL }
};


static int
dissect_lpp_T_switchTimeBetweenActiveBWP_FrequencyHop_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_numOfOverlappingPRB_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  { 0, NULL }
};


static int
dissect_lpp_T_numOfOverlappingPRB_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_ResourcePeriodic_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_ResourcePeriodic_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_ResourceAperiodic_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_ResourceAperiodic_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_ResourceSemipersistent_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_ResourceSemipersistent_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_TxFrequencyHoppingRRC_Connected_r18_sequence[] = {
  { &hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR1_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR1_r18 },
  { &hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR2_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR2_r18 },
  { &hf_lpp_maximumTxFH_Hops_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumTxFH_Hops_r18 },
  { &hf_lpp_rf_TxRetuneTimeFR1_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_rf_TxRetuneTimeFR1_r18 },
  { &hf_lpp_rf_TxRetuneTimeFR2_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_rf_TxRetuneTimeFR2_r18 },
  { &hf_lpp_switchTimeBetweenActiveBWP_FrequencyHop_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_switchTimeBetweenActiveBWP_FrequencyHop_r18 },
  { &hf_lpp_numOfOverlappingPRB_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_numOfOverlappingPRB_r18_01 },
  { &hf_lpp_maximumSRS_ResourcePeriodic_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_ResourcePeriodic_r18 },
  { &hf_lpp_maximumSRS_ResourceAperiodic_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_ResourceAperiodic_r18 },
  { &hf_lpp_maximumSRS_ResourceSemipersistent_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_ResourceSemipersistent_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_TxFrequencyHoppingRRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_TxFrequencyHoppingRRC_Connected_r18, PosSRS_TxFrequencyHoppingRRC_Connected_r18_sequence);

  return offset;
}


static const value_string lpp_T_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01_vals[] = {
  {   0, "mhz40" },
  {   1, "mhz50" },
  {   2, "mhz80" },
  {   3, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01_vals[] = {
  {   0, "mhz100" },
  {   1, "mhz200" },
  {   2, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumTxFH_Hops_r18_01_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n4" },
  {   3, "n5" },
  {   4, "n6" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumTxFH_Hops_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_rf_TxRetuneTimeFR1_r18_01_vals[] = {
  {   0, "n70" },
  {   1, "n140" },
  {   2, "n210" },
  { 0, NULL }
};


static int
dissect_lpp_T_rf_TxRetuneTimeFR1_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_rf_TxRetuneTimeFR2_r18_01_vals[] = {
  {   0, "n35" },
  {   1, "n70" },
  {   2, "n140" },
  { 0, NULL }
};


static int
dissect_lpp_T_rf_TxRetuneTimeFR2_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_switchTimeBetweenActiveBWP_FrequencyHop_r18_01_vals[] = {
  {   0, "n100" },
  {   1, "n140" },
  {   2, "n200" },
  {   3, "n300" },
  {   4, "n500" },
  { 0, NULL }
};


static int
dissect_lpp_T_switchTimeBetweenActiveBWP_FrequencyHop_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_numOfOverlappingPRB_r18_02_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  { 0, NULL }
};


static int
dissect_lpp_T_numOfOverlappingPRB_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_ResourcePeriodic_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_ResourcePeriodic_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumSRS_ResourceSemipersistent_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumSRS_ResourceSemipersistent_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_TxFrequencyHoppingRRC_Inactive_r18_sequence[] = {
  { &hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR1_r18_01 },
  { &hf_lpp_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_BandwidthAcrossAllHopsFR2_r18_01 },
  { &hf_lpp_maximumTxFH_Hops_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumTxFH_Hops_r18_01 },
  { &hf_lpp_rf_TxRetuneTimeFR1_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_rf_TxRetuneTimeFR1_r18_01 },
  { &hf_lpp_rf_TxRetuneTimeFR2_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_rf_TxRetuneTimeFR2_r18_01 },
  { &hf_lpp_switchTimeBetweenActiveBWP_FrequencyHop_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_switchTimeBetweenActiveBWP_FrequencyHop_r18_01 },
  { &hf_lpp_numOfOverlappingPRB_r18_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_numOfOverlappingPRB_r18_02 },
  { &hf_lpp_maximumSRS_ResourcePeriodic_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_ResourcePeriodic_r18_01 },
  { &hf_lpp_maximumSRS_ResourceSemipersistent_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumSRS_ResourceSemipersistent_r18_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_TxFrequencyHoppingRRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_TxFrequencyHoppingRRC_Inactive_r18, PosSRS_TxFrequencyHoppingRRC_Inactive_r18_sequence);

  return offset;
}


static const value_string lpp_T_posSRS_TxFH_WithTimeWindow_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posSRS_TxFH_WithTimeWindow_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_numOfCarriersIntraBandContiguous_r18_02_vals[] = {
  {   0, "two" },
  {   1, "three" },
  {   2, "twoandthree" },
  { 0, NULL }
};


static int
dissect_lpp_T_numOfCarriersIntraBandContiguous_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_02_vals[] = {
  {   0, "mhz20" },
  {   1, "mhz40" },
  {   2, "mhz50" },
  {   3, "mhz80" },
  {   4, "mhz100" },
  {   5, "mhz160" },
  {   6, "mhz180" },
  {   7, "mhz190" },
  {   8, "mhz200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_02_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  {   4, "mhz600" },
  {   5, "mhz800" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_02_vals[] = {
  {   0, "mhz80" },
  {   1, "mhz100" },
  {   2, "mhz160" },
  {   3, "mhz200" },
  {   4, "mhz240" },
  {   5, "mhz300" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_02_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz300" },
  {   4, "mhz400" },
  {   5, "mhz600" },
  {   6, "mhz800" },
  {   7, "mhz1000" },
  {   8, "mhz1200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSet_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSet_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourcePeriodic_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourcePeriodic_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSemi_r18_02_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSemi_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_02_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSemiPerSlot_r18_02_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n10" },
  {   9, "n12" },
  {  10, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSemiPerSlot_r18_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_guardPeriod_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n30" },
  {   2, "n100" },
  {   3, "n140" },
  {   4, "n200" },
  { 0, NULL }
};


static int
dissect_lpp_T_guardPeriod_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_powerClassForTwoAggregatedCarriers_r18_01_vals[] = {
  {   0, "pc2" },
  {   1, "pc3" },
  { 0, NULL }
};


static int
dissect_lpp_T_powerClassForTwoAggregatedCarriers_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_powerClassForThreeAggregatedCarriers_r18_01_vals[] = {
  {   0, "pc2" },
  {   1, "pc3" },
  { 0, NULL }
};


static int
dissect_lpp_T_powerClassForThreeAggregatedCarriers_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_BWA_RRC_Inactive_r18_sequence[] = {
  { &hf_lpp_numOfCarriersIntraBandContiguous_r18_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_numOfCarriersIntraBandContiguous_r18_02 },
  { &hf_lpp_maximumAggregatedBW_TwoCarriersFR1_r18_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_02 },
  { &hf_lpp_maximumAggregatedBW_TwoCarriersFR2_r18_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_02 },
  { &hf_lpp_maximumAggregatedBW_ThreeCarriersFR1_r18_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_02 },
  { &hf_lpp_maximumAggregatedBW_ThreeCarriersFR2_r18_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_02 },
  { &hf_lpp_maximumAggregatedResourceSet_r18_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSet_r18_02 },
  { &hf_lpp_maximumAggregatedResourcePeriodic_r18_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourcePeriodic_r18_02 },
  { &hf_lpp_maximumAggregatedResourceSemi_r18_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSemi_r18_02 },
  { &hf_lpp_maximumAggregatedResourcePeriodicPerSlot_r18_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_02 },
  { &hf_lpp_maximumAggregatedResourceSemiPerSlot_r18_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSemiPerSlot_r18_02 },
  { &hf_lpp_guardPeriod_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_guardPeriod_r18_01 },
  { &hf_lpp_powerClassForTwoAggregatedCarriers_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_powerClassForTwoAggregatedCarriers_r18_01 },
  { &hf_lpp_powerClassForThreeAggregatedCarriers_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_powerClassForThreeAggregatedCarriers_r18_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_BWA_RRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_BWA_RRC_Inactive_r18, PosSRS_BWA_RRC_Inactive_r18_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_eag_3_sequence[] = {
  { &hf_lpp_posSRS_Preconfigured_RRC_InactiveInitialUL_BWP_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posSRS_Preconfigured_RRC_InactiveInitialUL_BWP_r18 },
  { &hf_lpp_posSRS_Preconfigured_RRC_InactiveOutsideInitialUL_BWP_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posSRS_Preconfigured_RRC_InactiveOutsideInitialUL_BWP_r18 },
  { &hf_lpp_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posSRS_ValidityAreaRRC_InactiveInitialUL_BWP_r18 },
  { &hf_lpp_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posSRS_ValidityAreaRRC_InactiveOutsideInitialUL_BWP_r18 },
  { &hf_lpp_posSRS_TxFH_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_TxFrequencyHoppingRRC_Connected_r18 },
  { &hf_lpp_posSRS_TxFH_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_TxFrequencyHoppingRRC_Inactive_r18 },
  { &hf_lpp_posSRS_TxFH_WithTimeWindow_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posSRS_TxFH_WithTimeWindow_r18 },
  { &hf_lpp_posSRS_BWA_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_BWA_RRC_Inactive_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SRS_CapabilityPerBand_r16_eag_3_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_olpc_SRS_Pos_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OLPC_SRS_Pos_r16 },
  { &hf_lpp_spatialRelationsSRS_Pos_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SpatialRelationsSRS_Pos_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SRS_CapabilityPerBand_r16, SRS_CapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_srs_CapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosResourceSetsPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosResourceSetsPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberAP_SRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberAP_SRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberSP_SRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSP_SRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_numOfCarriersIntraBandContiguous_r18_vals[] = {
  {   0, "two" },
  {   1, "three" },
  {   2, "twoandthree" },
  { 0, NULL }
};


static int
dissect_lpp_T_numOfCarriersIntraBandContiguous_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_vals[] = {
  {   0, "mhz20" },
  {   1, "mhz40" },
  {   2, "mhz50" },
  {   3, "mhz80" },
  {   4, "mhz100" },
  {   5, "mhz160" },
  {   6, "mhz180" },
  {   7, "mhz190" },
  {   8, "mhz200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  {   4, "mhz600" },
  {   5, "mhz800" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_vals[] = {
  {   0, "mhz80" },
  {   1, "mhz100" },
  {   2, "mhz160" },
  {   3, "mhz200" },
  {   4, "mhz240" },
  {   5, "mhz300" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz300" },
  {   4, "mhz400" },
  {   5, "mhz600" },
  {   6, "mhz800" },
  {   7, "mhz1000" },
  {   8, "mhz1200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSet_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSet_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourcePeriodic_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourcePeriodic_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceAperiodic_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceAperiodic_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSemi_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSemi_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceAperiodicPerSlot_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n10" },
  {   9, "n12" },
  {  10, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceAperiodicPerSlot_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSemiPerSlot_r18_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n10" },
  {   9, "n12" },
  {  10, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSemiPerSlot_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_BWA_RRC_Connected_r18_sequence[] = {
  { &hf_lpp_numOfCarriersIntraBandContiguous_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_numOfCarriersIntraBandContiguous_r18 },
  { &hf_lpp_maximumAggregatedBW_TwoCarriersFR1_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18 },
  { &hf_lpp_maximumAggregatedBW_TwoCarriersFR2_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18 },
  { &hf_lpp_maximumAggregatedBW_ThreeCarriersFR1_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18 },
  { &hf_lpp_maximumAggregatedBW_ThreeCarriersFR2_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18 },
  { &hf_lpp_maximumAggregatedResourceSet_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSet_r18 },
  { &hf_lpp_maximumAggregatedResourcePeriodic_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourcePeriodic_r18 },
  { &hf_lpp_maximumAggregatedResourceAperiodic_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceAperiodic_r18 },
  { &hf_lpp_maximumAggregatedResourceSemi_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSemi_r18 },
  { &hf_lpp_maximumAggregatedResourcePeriodicPerSlot_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18 },
  { &hf_lpp_maximumAggregatedResourceAperiodicPerSlot_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceAperiodicPerSlot_r18 },
  { &hf_lpp_maximumAggregatedResourceSemiPerSlot_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSemiPerSlot_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_BWA_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_BWA_RRC_Connected_r18, PosSRS_BWA_RRC_Connected_r18_sequence);

  return offset;
}


static const value_string lpp_T_numOfCarriersIntraBandContiguous_r18_01_vals[] = {
  {   0, "two" },
  {   1, "three" },
  {   2, "twoandthree" },
  { 0, NULL }
};


static int
dissect_lpp_T_numOfCarriersIntraBandContiguous_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_01_vals[] = {
  {   0, "mhz20" },
  {   1, "mhz40" },
  {   2, "mhz50" },
  {   3, "mhz80" },
  {   4, "mhz100" },
  {   5, "mhz160" },
  {   6, "mhz180" },
  {   7, "mhz190" },
  {   8, "mhz200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_01_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  {   4, "mhz600" },
  {   5, "mhz800" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_01_vals[] = {
  {   0, "mhz80" },
  {   1, "mhz100" },
  {   2, "mhz160" },
  {   3, "mhz200" },
  {   4, "mhz240" },
  {   5, "mhz300" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_01_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz300" },
  {   4, "mhz400" },
  {   5, "mhz600" },
  {   6, "mhz800" },
  {   7, "mhz1000" },
  {   8, "mhz1200" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSet_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSet_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourcePeriodic_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourcePeriodic_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceAperiodic_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceAperiodic_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSemi_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  {   6, "n32" },
  {   7, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSemi_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceAperiodicPerSlot_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n10" },
  {   9, "n12" },
  {  10, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceAperiodicPerSlot_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maximumAggregatedResourceSemiPerSlot_r18_01_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n3" },
  {   4, "n4" },
  {   5, "n5" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n10" },
  {   9, "n12" },
  {  10, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maximumAggregatedResourceSemiPerSlot_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_guardPeriod_r18_vals[] = {
  {   0, "n0" },
  {   1, "n30" },
  {   2, "n100" },
  {   3, "n140" },
  {   4, "n200" },
  { 0, NULL }
};


static int
dissect_lpp_T_guardPeriod_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_powerClassForTwoAggregatedCarriers_r18_vals[] = {
  {   0, "pc2" },
  {   1, "pc3" },
  { 0, NULL }
};


static int
dissect_lpp_T_powerClassForTwoAggregatedCarriers_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_powerClassForThreeAggregatedCarriers_r18_vals[] = {
  {   0, "pc2" },
  {   1, "pc3" },
  { 0, NULL }
};


static int
dissect_lpp_T_powerClassForThreeAggregatedCarriers_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_BWA_IndependentCA_RRC_Connected_r18_sequence[] = {
  { &hf_lpp_numOfCarriersIntraBandContiguous_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_numOfCarriersIntraBandContiguous_r18_01 },
  { &hf_lpp_maximumAggregatedBW_TwoCarriersFR1_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR1_r18_01 },
  { &hf_lpp_maximumAggregatedBW_TwoCarriersFR2_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_TwoCarriersFR2_r18_01 },
  { &hf_lpp_maximumAggregatedBW_ThreeCarriersFR1_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR1_r18_01 },
  { &hf_lpp_maximumAggregatedBW_ThreeCarriersFR2_r18_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maximumAggregatedBW_ThreeCarriersFR2_r18_01 },
  { &hf_lpp_maximumAggregatedResourceSet_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSet_r18_01 },
  { &hf_lpp_maximumAggregatedResourcePeriodic_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourcePeriodic_r18_01 },
  { &hf_lpp_maximumAggregatedResourceAperiodic_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceAperiodic_r18_01 },
  { &hf_lpp_maximumAggregatedResourceSemi_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSemi_r18_01 },
  { &hf_lpp_maximumAggregatedResourcePeriodicPerSlot_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourcePeriodicPerSlot_r18_01 },
  { &hf_lpp_maximumAggregatedResourceAperiodicPerSlot_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceAperiodicPerSlot_r18_01 },
  { &hf_lpp_maximumAggregatedResourceSemiPerSlot_r18_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maximumAggregatedResourceSemiPerSlot_r18_01 },
  { &hf_lpp_guardPeriod_r18 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_guardPeriod_r18 },
  { &hf_lpp_powerClassForTwoAggregatedCarriers_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_powerClassForTwoAggregatedCarriers_r18 },
  { &hf_lpp_powerClassForThreeAggregatedCarriers_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_powerClassForThreeAggregatedCarriers_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_BWA_IndependentCA_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_BWA_IndependentCA_RRC_Connected_r18, PosSRS_BWA_IndependentCA_RRC_Connected_r18_sequence);

  return offset;
}


static const per_sequence_t SRS_PosResourcesPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_posSRS_BWA_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_BWA_RRC_Connected_r18 },
  { &hf_lpp_posSRS_BWA_IndependentCA_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_BWA_IndependentCA_RRC_Connected_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_PosResourcesPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SRS_PosResourcesPerBand_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t SRS_PosResourcesPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_maxNumberSRS_PosResourceSetsPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumberSRS_PosResourceSetsPerBWP_r16 },
  { &hf_lpp_maxNumberSRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumberSRS_PosResourcesPerBWP_r16 },
  { &hf_lpp_maxNumberPeriodicSRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 },
  { &hf_lpp_maxNumberAP_SRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberAP_SRS_PosResourcesPerBWP_r16 },
  { &hf_lpp_maxNumberSP_SRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberSP_SRS_PosResourcesPerBWP_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SRS_PosResourcesPerBand_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_PosResourcesPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SRS_PosResourcesPerBand_r16, SRS_PosResourcesPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16_sequence_of[1] = {
  { &hf_lpp_srs_PosResourceConfigCA_BandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SRS_PosResourcesPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16, SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16_sequence_of,
                                                  1, nrMaxConfiguredBands_r16, false);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16_vals[] = {
  {   0, "n1" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_UL_SRS_Capability_r16_sequence[] = {
  { &hf_lpp_srs_CapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16 },
  { &hf_lpp_srs_PosResourceConfigCA_BandList_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16 },
  { &hf_lpp_maxNumberSRS_PosPathLossEstimateAllServingCells_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 },
  { &hf_lpp_maxNumberSRS_PosSpatialRelationsAllServingCells_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UL_SRS_Capability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UL_SRS_Capability_r16, NR_UL_SRS_Capability_r16_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsReport_r16_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsReport_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r16_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ten_ms_unit_ResponseTime_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ten_ms_unit_ResponseTime_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static int * const T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_bits[] = {
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoD,
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoA,
  NULL
};

static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_on_demand_DL_PRS_InformationSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_on_demand_DL_PRS_InformationSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_on_demand_DL_PRS_ConfigurationsSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_on_demand_DL_PRS_ConfigurationsSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Support_r17_sequence[] = {
  { &hf_lpp_nr_on_demand_DL_PRS_InformationSup_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_on_demand_DL_PRS_InformationSup_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_ConfigurationsSup_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_on_demand_DL_PRS_ConfigurationsSup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Support_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_On_Demand_DL_PRS_Support_r17, NR_On_Demand_DL_PRS_Support_r17_sequence);

  return offset;
}


static int * const T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_bits[] = {
  &hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case1,
  &hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case2,
  &hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case3,
  NULL
};

static int
dissect_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_bits, 3, NULL, NULL);

  return offset;
}


static const value_string lpp_LOS_NLOS_IndicatorType2_r17_vals[] = {
  {   0, "hardvalue" },
  {   1, "hardAndsoftvalue" },
  { 0, NULL }
};


static int
dissect_lpp_LOS_NLOS_IndicatorType2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_LOS_NLOS_IndicatorGranularity2_r17_vals[] = {
  {   0, "trpspecific" },
  {   1, "resourcespecific" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_IndicatorSupport_r17_02_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_02, T_nr_los_nlos_IndicatorSupport_r17_02_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsExtSupport_r17_01_vals[] = {
  {   0, "n4" },
  {   1, "n6" },
  {   2, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsExtSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_maxNrOfAreas_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfAreas_r17, NULL, false);

  return offset;
}


static const per_sequence_t T_nr_dl_prs_AssistanceDataValidity_r17_02_sequence[] = {
  { &hf_lpp_area_validity_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_maxNrOfAreas_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02, T_nr_dl_prs_AssistanceDataValidity_r17_02_sequence);

  return offset;
}


static const value_string lpp_T_multiMeasInSameMeasReport_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiMeasInSameMeasReport_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_mg_ActivationRequest_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_mg_ActivationRequest_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ten_ms_unit_ResponseTime_r17_01 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02 },
  { &hf_lpp_nr_Multi_RTT_On_Demand_DL_PRS_Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Support_r17 },
  { &hf_lpp_nr_UE_RxTx_TEG_ID_ReportingSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17 },
  { &hf_lpp_nr_los_nlos_IndicatorSupport_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_02 },
  { &hf_lpp_additionalPathsExtSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsExtSupport_r17_01 },
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { &hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02 },
  { &hf_lpp_multiMeasInSameMeasReport_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiMeasInSameMeasReport_r17_02 },
  { &hf_lpp_mg_ActivationRequest_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mg_ActivationRequest_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_posMeasGapSupport_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posMeasGapSupport_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_posMeasGapSupport_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posMeasGapSupport_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_nr_MultiRTT_OnDemandPRS_ForBWA_Support_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_MultiRTT_OnDemandPRS_ForBWA_Support_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_eag_3_sequence[] = {
  { &hf_lpp_nr_MultiRTT_OnDemandPRS_ForBWA_Support_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_MultiRTT_OnDemandPRS_ForBWA_Support_r18 },
  { &hf_lpp_periodicReportingIntervalMsSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupport_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_ProvideCapabilities_r16_eag_3_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_Multi_RTT_PRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourcesCapability_r16 },
  { &hf_lpp_nr_Multi_RTT_MeasurementCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16 },
  { &hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 },
  { &hf_lpp_nr_DL_PRS_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16 },
  { &hf_lpp_nr_UL_SRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_UL_SRS_Capability_r16 },
  { &hf_lpp_additionalPathsReport_r16_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsReport_r16_01 },
  { &hf_lpp_periodicalReporting_r16_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r16_01 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_ProvideCapabilities_r16, NR_Multi_RTT_ProvideCapabilities_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, false);

  return offset;
}


static const value_string lpp_T_simul_NR_DL_AoD_DL_TDOA_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_simul_NR_DL_AoD_DL_TDOA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_simul_NR_DL_AoD_Multi_RTT_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_simul_NR_DL_AoD_Multi_RTT_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasRRC_Inactive_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DL_AoD_MeasCapabilityPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17 },
  { &hf_lpp_dl_PRS_MeasRRC_Inactive_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_AoD_MeasCapabilityPerBand_r16_eag_1_sequence);

  return offset;
}


static int * const T_supportOfMeasurementsInTimeWindow_r18_01_bits[] = {
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_01_rsrp,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_01_rsrpp,
  NULL
};

static int
dissect_lpp_T_supportOfMeasurementsInTimeWindow_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_supportOfMeasurementsInTimeWindow_r18_01_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_supportOfPRS_MeasurementRRC_Idle_r18_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfPRS_MeasurementRRC_Idle_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DL_AoD_MeasCapabilityPerBand_r16_eag_2_sequence[] = {
  { &hf_lpp_supportOfMeasurementsInTimeWindow_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfMeasurementsInTimeWindow_r18_01 },
  { &hf_lpp_supportOfPRS_MeasurementRRC_Idle_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfPRS_MeasurementRRC_Idle_r18_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_AoD_MeasCapabilityPerBand_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t DL_AoD_MeasCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_simul_NR_DL_AoD_DL_TDOA_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_simul_NR_DL_AoD_DL_TDOA_r16 },
  { &hf_lpp_simul_NR_DL_AoD_Multi_RTT_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_simul_NR_DL_AoD_Multi_RTT_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_AoD_MeasCapabilityPerBand_r16, DL_AoD_MeasCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_dl_AoD_MeasCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const value_string lpp_T_maxDL_PRS_RSRP_MeasurementFR1_v1730_vals[] = {
  {   0, "n16" },
  {   1, "n24" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR1_v1730(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxDL_PRS_RSRP_MeasurementFR2_v1730_vals[] = {
  {   0, "n16" },
  {   1, "n24" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR2_v1730(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_MeasurementCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_v1730, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR1_v1730 },
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_v1730, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR2_v1730 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_MeasurementCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_MeasurementCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_MeasurementCapability_r16_sequence[] = {
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
  { &hf_lpp_dl_AoD_MeasCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_MeasurementCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_MeasurementCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_MeasurementCapability_r16, NR_DL_AoD_MeasurementCapability_r16_sequence);

  return offset;
}


static int * const T_nr_PosCalcAssistanceSupport_r17_01_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_trpLocSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_rtdInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamAntInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_nr_IntegrityBoundsSup_r18,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_PosCalcAssistanceSupport_r17_01_bits, 5, NULL, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_AssistanceDataSupport_r17_01_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01, T_nr_los_nlos_AssistanceDataSupport_r17_01_sequence);

  return offset;
}


static int * const T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_bits[] = {
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoD,
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoA,
  NULL
};

static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_ResourcePrioritySubset_Sup_r17_vals[] = {
  {   0, "sameSet" },
  {   1, "differentSet" },
  {   2, "sameOrDifferentSet" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_ResourcePrioritySubset_Sup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_BeamInfoSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_BeamInfoSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_IndicatorSupport_r17_01_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_01, T_nr_los_nlos_IndicatorSupport_r17_01_sequence);

  return offset;
}


static const per_sequence_t T_nr_dl_prs_AssistanceDataValidity_r17_01_sequence[] = {
  { &hf_lpp_area_validity_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_maxNrOfAreas_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01, T_nr_dl_prs_AssistanceDataValidity_r17_01_sequence);

  return offset;
}


static const value_string lpp_T_multiMeasInSameMeasReport_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiMeasInSameMeasReport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_mg_ActivationRequest_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_mg_ActivationRequest_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_nr_PosCalcAssistanceSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceSupport_r17_01 },
  { &hf_lpp_nr_los_nlos_AssistanceDataSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01 },
  { &hf_lpp_dl_PRS_ResourcePrioritySubset_Sup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_ResourcePrioritySubset_Sup_r17 },
  { &hf_lpp_nr_DL_PRS_BeamInfoSup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_BeamInfoSup_r17 },
  { &hf_lpp_nr_DL_AoD_On_Demand_DL_PRS_Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Support_r17 },
  { &hf_lpp_nr_los_nlos_IndicatorSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_01 },
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { &hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01 },
  { &hf_lpp_multiMeasInSameMeasReport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiMeasInSameMeasReport_r17_01 },
  { &hf_lpp_mg_ActivationRequest_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mg_ActivationRequest_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_posMeasGapSupport_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posMeasGapSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_posMeasGapSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posMeasGapSupport_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_multiLocationEstimateInSameMeasReport_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiLocationEstimateInSameMeasReport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_eag_3_sequence[] = {
  { &hf_lpp_multiLocationEstimateInSameMeasReport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiLocationEstimateInSameMeasReport_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_ProvideCapabilities_r16_eag_3_sequence);

  return offset;
}


static int * const T_nr_IntegrityAssistanceSupport_r18_01_bits[] = {
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_serviceParametersSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_serviceAlertSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_riskParametersSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityParaTRP_LocSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityParaBeamInfoSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityParaRTD_InfoSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_01_integrityBeamAntInfoSup,
  NULL
};

static int
dissect_lpp_T_nr_IntegrityAssistanceSupport_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_IntegrityAssistanceSupport_r18_01_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_eag_4_sequence[] = {
  { &hf_lpp_locationCoordinateTypes_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_LocationCoordinateTypes },
  { &hf_lpp_nr_IntegrityAssistanceSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_IntegrityAssistanceSupport_r18_01 },
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_ProvideCapabilities_r16_eag_4_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_DL_AoD_Mode_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_nr_DL_AoD_PRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourcesCapability_r16 },
  { &hf_lpp_nr_DL_AoD_MeasurementCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_MeasurementCapability_r16 },
  { &hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 },
  { &hf_lpp_nr_DL_PRS_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16 },
  { &hf_lpp_periodicalReporting_r16_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_ProvideCapabilities_r16, NR_DL_AoD_ProvideCapabilities_r16_sequence);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_RSRP_MeasFR1_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_RSRP_MeasFR2_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasRRC_Inactive_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_BWA_RRC_Connected_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_BWA_RRC_Inactive_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_BWA_RRC_Idle_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Idle_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_RSCPD_RRC_Connected_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_RSCPD_RRC_Connected_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_assocSingleRSTD_WithUpToNsampleRSCPD_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_assocSingleRSTD_WithUpToNsampleRSCPD_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_RSCPD_MeasurementRRC_Idle_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_RSCPD_MeasurementRRC_Idle_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfUE_basedCarrierPhasePositioning_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfUE_basedCarrierPhasePositioning_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfSymbolTimeStampForRSCPD_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfSymbolTimeStampForRSCPD_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfFinerTimingReportGranularityForPRS_Meas_r18_vals[] = {
  {   0, "minus1" },
  {   1, "minus2" },
  {   2, "minus3" },
  {   3, "minus4" },
  {   4, "minus5" },
  {   5, "minus6" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfFinerTimingReportGranularityForPRS_Meas_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, false, 0, NULL);

  return offset;
}


static int * const T_supportOfMeasurementsInTimeWindow_r18_bits[] = {
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rstd,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rsrp,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rsrpp,
  &hf_lpp_T_supportOfMeasurementsInTimeWindow_r18_rscpd,
  NULL
};

static int
dissect_lpp_T_supportOfMeasurementsInTimeWindow_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_supportOfMeasurementsInTimeWindow_r18_bits, 4, NULL, NULL);

  return offset;
}


static const value_string lpp_T_supportOfPRS_MeasurementRRC_Idle_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfPRS_MeasurementRRC_Idle_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DL_TDOA_MeasCapabilityPerBand_r17_eag_1_sequence[] = {
  { &hf_lpp_supportOfDL_PRS_BWA_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Connected_r18 },
  { &hf_lpp_supportOfDL_PRS_BWA_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Inactive_r18 },
  { &hf_lpp_supportOfDL_PRS_BWA_RRC_Idle_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_BWA_RRC_Idle_r18 },
  { &hf_lpp_nr_DL_PRS_RSCPD_RRC_Connected_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_RSCPD_RRC_Connected_r18 },
  { &hf_lpp_assocSingleRSTD_WithUpToNsampleRSCPD_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_assocSingleRSTD_WithUpToNsampleRSCPD_r18 },
  { &hf_lpp_nr_DL_PRS_RSCPD_MeasurementRRC_Idle_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_RSCPD_MeasurementRRC_Idle_r18 },
  { &hf_lpp_supportOfUE_basedCarrierPhasePositioning_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfUE_basedCarrierPhasePositioning_r18 },
  { &hf_lpp_supportOfSymbolTimeStampForRSCPD_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfSymbolTimeStampForRSCPD_r18 },
  { &hf_lpp_supportOfFinerTimingReportGranularityForPRS_Meas_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfFinerTimingReportGranularityForPRS_Meas_r18 },
  { &hf_lpp_supportOfMeasurementsInTimeWindow_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfMeasurementsInTimeWindow_r18 },
  { &hf_lpp_supportOfPRS_MeasurementRRC_Idle_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportOfPRS_MeasurementRRC_Idle_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_TDOA_MeasCapabilityPerBand_r17_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_RSCPD_RRC_Inactive_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_RSCPD_RRC_Inactive_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t DL_TDOA_MeasCapabilityPerBand_r17_eag_2_sequence[] = {
  { &hf_lpp_nr_DL_PRS_RSCPD_RRC_Inactive_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_RSCPD_RRC_Inactive_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_TDOA_MeasCapabilityPerBand_r17_eag_2_sequence);

  return offset;
}


static const per_sequence_t DL_TDOA_MeasCapabilityPerBand_r17_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17 },
  { &hf_lpp_dl_PRS_MeasRRC_Inactive_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_TDOA_MeasCapabilityPerBand_r17, DL_TDOA_MeasCapabilityPerBand_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17_sequence_of[1] = {
  { &hf_lpp_dl_tdoa_MeasCapabilityBandList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17_sequence_of,
                                                  1, nrMaxBands_r16, false);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_MeasurementCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_UE_TEG_Capability_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UE_TEG_Capability_r17 },
  { &hf_lpp_dl_tdoa_MeasCapabilityBandList_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_MeasurementCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_MeasurementCapability_r16_sequence[] = {
  { &hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR1_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR2_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_supportOfDL_PRS_RSRP_MeasFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR1_r16 },
  { &hf_lpp_supportOfDL_PRS_RSRP_MeasFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR2_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_MeasurementCapability_r16, NR_DL_TDOA_MeasurementCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsReport_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsReport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static int * const T_nr_PosCalcAssistanceSupport_r17_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpLocSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_beamInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_rtdInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpTEG_InfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_nr_IntegritySup_r18,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_pruInfoSup_r18,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_PosCalcAssistanceSupport_r17_bits, 6, NULL, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_AssistanceDataSupport_r17_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17, T_nr_los_nlos_AssistanceDataSupport_r17_sequence);

  return offset;
}


static int * const T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_bits[] = {
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoD,
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoA,
  NULL
};

static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_IndicatorSupport_r17_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_IndicatorSupport_r17, T_nr_los_nlos_IndicatorSupport_r17_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsExtSupport_r17_vals[] = {
  {   0, "n4" },
  {   1, "n6" },
  {   2, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsExtSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_nr_dl_prs_AssistanceDataValidity_r17_sequence[] = {
  { &hf_lpp_area_validity_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_maxNrOfAreas_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17, T_nr_dl_prs_AssistanceDataValidity_r17_sequence);

  return offset;
}


static const value_string lpp_T_multiMeasInSameMeasReport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiMeasInSameMeasReport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_mg_ActivationRequest_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_mg_ActivationRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_nr_PosCalcAssistanceSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceSupport_r17 },
  { &hf_lpp_nr_los_nlos_AssistanceDataSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17 },
  { &hf_lpp_nr_DL_TDOA_On_Demand_DL_PRS_Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Support_r17 },
  { &hf_lpp_nr_los_nlos_IndicatorSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17 },
  { &hf_lpp_additionalPathsExtSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsExtSupport_r17 },
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { &hf_lpp_nr_dl_prs_AssistanceDataValidity_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17 },
  { &hf_lpp_multiMeasInSameMeasReport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiMeasInSameMeasReport_r17 },
  { &hf_lpp_mg_ActivationRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mg_ActivationRequest_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_posMeasGapSupport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posMeasGapSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_posMeasGapSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posMeasGapSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_multiLocationEstimateInSameMeasReport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiLocationEstimateInSameMeasReport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_eag_3_sequence[] = {
  { &hf_lpp_multiLocationEstimateInSameMeasReport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiLocationEstimateInSameMeasReport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_ProvideCapabilities_r16_eag_3_sequence);

  return offset;
}


static int * const T_periodicAssistanceData_r18_bits[] = {
  &hf_lpp_T_periodicAssistanceData_r18_solicited,
  &hf_lpp_T_periodicAssistanceData_r18_unsolicited,
  NULL
};

static int
dissect_lpp_T_periodicAssistanceData_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_periodicAssistanceData_r18_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_nr_IntegrityAssistanceSupport_r18_bits[] = {
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_serviceParametersSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_serviceAlertSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_riskParametersSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_integrityParaTRP_LocSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_integrityParaBeamInfoSup,
  &hf_lpp_T_nr_IntegrityAssistanceSupport_r18_integrityParaRTD_InfoSup,
  NULL
};

static int
dissect_lpp_T_nr_IntegrityAssistanceSupport_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_IntegrityAssistanceSupport_r18_bits, 6, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_TDOA_OnDemandPRS_ForBWA_Support_r18_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_TDOA_OnDemandPRS_ForBWA_Support_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_eag_4_sequence[] = {
  { &hf_lpp_locationCoordinateTypes_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_LocationCoordinateTypes },
  { &hf_lpp_periodicAssistanceData_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_periodicAssistanceData_r18 },
  { &hf_lpp_nr_IntegrityAssistanceSupport_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_IntegrityAssistanceSupport_r18 },
  { &hf_lpp_nr_DL_TDOA_OnDemandPRS_ForBWA_Support_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_TDOA_OnDemandPRS_ForBWA_Support_r18 },
  { &hf_lpp_periodicReportingIntervalMsSupport_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicReportingIntervalMsSupportPerMode_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_ProvideCapabilities_r16_eag_4_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_DL_TDOA_Mode_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_nr_DL_TDOA_PRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourcesCapability_r16 },
  { &hf_lpp_nr_DL_TDOA_MeasurementCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16 },
  { &hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 },
  { &hf_lpp_nr_DL_PRS_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16 },
  { &hf_lpp_additionalPathsReport_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsReport_r16 },
  { &hf_lpp_periodicalReporting_r16_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_ProvideCapabilities_r16, NR_DL_TDOA_ProvideCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_UL_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_UE_TEG_Capability_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UE_TEG_Capability_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UL_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_UL_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_UL_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_UL_SRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_UL_SRS_Capability_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_UL_ProvideCapabilities_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UL_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UL_ProvideCapabilities_r16, NR_UL_ProvideCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t ProvideCapabilities_r9_IEs_eag_2_sequence[] = {
  { &hf_lpp_nr_ECID_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_ECID_ProvideCapabilities_r16 },
  { &hf_lpp_nr_Multi_RTT_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16 },
  { &hf_lpp_nr_DL_AoD_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16 },
  { &hf_lpp_nr_DL_TDOA_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16 },
  { &hf_lpp_nr_UL_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UL_ProvideCapabilities_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities_r9_IEs_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ProvideCapabilities_r9_IEs_eag_2_sequence);

  return offset;
}


static const per_sequence_t ProvideCapabilities_r9_IEs_sequence[] = {
  { &hf_lpp_commonIEsProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CommonIEsProvideCapabilities },
  { &hf_lpp_a_gnss_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_ProvideCapabilities },
  { &hf_lpp_otdoa_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OTDOA_ProvideCapabilities },
  { &hf_lpp_ecid_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECID_ProvideCapabilities },
  { &hf_lpp_epdu_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Sequence },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ProvideCapabilities_r9_IEs_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ProvideCapabilities_r9_IEs_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ProvideCapabilities_r9_IEs, ProvideCapabilities_r9_IEs_sequence);

  return offset;
}


static const value_string lpp_T_c1_02_vals[] = {
  {   0, "provideCapabilities-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_02_choice[] = {
  {   0, &hf_lpp_provideCapabilities_r9, ASN1_NO_EXTENSIONS     , dissect_lpp_ProvideCapabilities_r9_IEs },
  {   1, &hf_lpp_spare3          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   2, &hf_lpp_spare2          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   3, &hf_lpp_spare1          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_c1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_c1_02, T_c1_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensionsFuture_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_criticalExtensionsFuture_01, T_criticalExtensionsFuture_01_sequence);

  return offset;
}


static const value_string lpp_T_criticalExtensions_01_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_01_choice[] = {
  {   0, &hf_lpp_c1_02           , ASN1_NO_EXTENSIONS     , dissect_lpp_T_c1_02 },
  {   1, &hf_lpp_criticalExtensionsFuture_01, ASN1_NO_EXTENSIONS     , dissect_lpp_T_criticalExtensionsFuture_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensions_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_criticalExtensions_01, T_criticalExtensions_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ProvideCapabilities_sequence[] = {
  { &hf_lpp_criticalExtensions_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_criticalExtensions_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Provide Capabilities");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ProvideCapabilities, ProvideCapabilities_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, false);

  return offset;
}


static const per_sequence_t T_mcc_02_sequence_of[1] = {
  { &hf_lpp_mcc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc_02, T_mcc_02_sequence_of,
                                                  3, 3, false);

  return offset;
}


static const per_sequence_t T_mnc_02_sequence_of[1] = {
  { &hf_lpp_mnc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc_02, T_mnc_02_sequence_of,
                                                  2, 3, false);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ECGI_sequence[] = {
  { &hf_lpp_mcc_02          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc_02 },
  { &hf_lpp_mnc_02          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc_02 },
  { &hf_lpp_cellidentity    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ECGI, ECGI_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_segmentationInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SegmentationInfo_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestAssistanceData_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_periodicSessionInitiator_r15_vals[] = {
  {   0, "locationServer" },
  {   1, "targetDevice" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicSessionInitiator_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  return offset;
}


static const per_sequence_t PeriodicSessionID_r15_sequence[] = {
  { &hf_lpp_periodicSessionInitiator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_periodicSessionInitiator_r15 },
  { &hf_lpp_periodicSessionNumber_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicSessionID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PeriodicSessionID_r15, PeriodicSessionID_r15_sequence);

  return offset;
}


static int * const UpdateCapabilities_r15_bits[] = {
  &hf_lpp_UpdateCapabilities_r15_primaryCellID_r15,
  NULL
};

static int
dissect_lpp_UpdateCapabilities_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, UpdateCapabilities_r15_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t PeriodicAssistanceDataControlParameters_r15_eag_1_sequence[] = {
  { &hf_lpp_updateCapabilities_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_UpdateCapabilities_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicAssistanceDataControlParameters_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PeriodicAssistanceDataControlParameters_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t PeriodicAssistanceDataControlParameters_r15_sequence[] = {
  { &hf_lpp_periodicSessionID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PeriodicSessionID_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PeriodicAssistanceDataControlParameters_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicAssistanceDataControlParameters_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PeriodicAssistanceDataControlParameters_r15, PeriodicAssistanceDataControlParameters_r15_sequence);

  return offset;
}


static const per_sequence_t T_mcc_r15_sequence_of[1] = {
  { &hf_lpp_mcc_r15_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc_r15, T_mcc_r15_sequence_of,
                                                  3, 3, false);

  return offset;
}


static const per_sequence_t T_mnc_r15_sequence_of[1] = {
  { &hf_lpp_mnc_r15_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc_r15, T_mnc_r15_sequence_of,
                                                  2, 3, false);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_36(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t NCGI_r15_sequence[] = {
  { &hf_lpp_mcc_r15         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc_r15 },
  { &hf_lpp_mnc_r15         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc_r15 },
  { &hf_lpp_nr_cellidentity_r15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_36 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NCGI_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NCGI_r15, NCGI_r15_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestAssistanceData_eag_2_sequence[] = {
  { &hf_lpp_periodicAssistanceDataReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicAssistanceDataControlParameters_r15 },
  { &hf_lpp_primaryCellID_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NCGI_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestAssistanceData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestAssistanceData_eag_2_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestAssistanceData_sequence[] = {
  { &hf_lpp_primaryCellID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECGI },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestAssistanceData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestAssistanceData_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsRequestAssistanceData, CommonIEsRequestAssistanceData_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_8_OF_GNSS_ID_sequence_of[1] = {
  { &hf_lpp_gnss_TimeReqPrefList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID, SEQUENCE_SIZE_1_8_OF_GNSS_ID_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTimeReq_sequence[] = {
  { &hf_lpp_gnss_TimeReqPrefList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID },
  { &hf_lpp_gps_TOW_assistReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_notOfLeapSecReq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTimeReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTimeReq, GNSS_ReferenceTimeReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceLocationReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceLocationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceLocationReq, GNSS_ReferenceLocationReq_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModelReq_eag_1_sequence[] = {
  { &hf_lpp_klobucharModel2Req_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModelReq_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_IonosphericModelReq_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModelReq_sequence[] = {
  { &hf_lpp_klobucharModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_2 },
  { &hf_lpp_neQuickModelReq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_IonosphericModelReq_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_IonosphericModelReq, GNSS_IonosphericModelReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_EarthOrientationParametersReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_EarthOrientationParametersReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_EarthOrientationParametersReq, GNSS_EarthOrientationParametersReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, false);

  return offset;
}



static int
dissect_lpp_VisibleString_SIZE_1_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 32, false,
                                          NULL);

  return offset;
}


static const per_sequence_t GNSS_ReferenceStationID_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_providerName_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_VisibleString_SIZE_1_32 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceStationID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceStationID_r15, GNSS_ReferenceStationID_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfoReq_r15_sequence[] = {
  { &hf_lpp_antennaDescriptionReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_antennaHeightReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_physicalReferenceStationReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfoReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ReferenceStationInfoReq_r15, GNSS_RTK_ReferenceStationInfoReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_AuxiliaryStationDataReq_r15_sequence[] = {
  { &hf_lpp_master_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15, GNSS_RTK_AuxiliaryStationDataReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_1_sequence[] = {
  { &hf_lpp_gnss_RTK_ReferenceStationInfoReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ReferenceStationInfoReq_r15 },
  { &hf_lpp_gnss_RTK_AuxiliaryStationDataReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_SSR_CorrectionPointsReq_r16_sequence[] = {
  { &hf_lpp_correctionPointSetID_Req_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_16383 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CorrectionPointsReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CorrectionPointsReq_r16, GNSS_SSR_CorrectionPointsReq_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_2_sequence[] = {
  { &hf_lpp_gnss_SSR_CorrectionPointsReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CorrectionPointsReq_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceParametersReq_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceParametersReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceParametersReq_r17, GNSS_Integrity_ServiceParametersReq_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceAlertReq_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceAlertReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceAlertReq_r17, GNSS_Integrity_ServiceAlertReq_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_3_sequence[] = {
  { &hf_lpp_gnss_Integrity_ServiceParametersReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceParametersReq_r17 },
  { &hf_lpp_gnss_Integrity_ServiceAlertReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceAlertReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_IOD_UpdateReq_r18_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_IOD_UpdateReq_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_IOD_UpdateReq_r18, GNSS_SSR_IOD_UpdateReq_r18_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_4_sequence[] = {
  { &hf_lpp_gnss_SSR_IOD_UpdateReq_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_IOD_UpdateReq_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_4_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_sequence[] = {
  { &hf_lpp_gnss_ReferenceTimeReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceTimeReq },
  { &hf_lpp_gnss_ReferenceLocationReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceLocationReq },
  { &hf_lpp_gnss_IonosphericModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_IonosphericModelReq },
  { &hf_lpp_gnss_EarthOrientationParametersReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_EarthOrientationParametersReq },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_CommonAssistDataReq, GNSS_CommonAssistDataReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_TimeModelElementReq_sequence[] = {
  { &hf_lpp_gnss_TO_IDsReq  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_15 },
  { &hf_lpp_deltaTreq       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_TimeModelElementReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_TimeModelElementReq, GNSS_TimeModelElementReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_TimeModelListReq_sequence_of[1] = {
  { &hf_lpp_GNSS_TimeModelListReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_TimeModelElementReq },
};

static int
dissect_lpp_GNSS_TimeModelListReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_TimeModelListReq, GNSS_TimeModelListReq_sequence_of,
                                                  1, 15, false);

  return offset;
}


static const per_sequence_t GNSS_DifferentialCorrectionsReq_sequence[] = {
  { &hf_lpp_dgnss_SignalsReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_dgnss_ValidityTimeReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DifferentialCorrectionsReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DifferentialCorrectionsReq, GNSS_DifferentialCorrectionsReq_sequence);

  return offset;
}



static int
dissect_lpp_T_gnss_WeekOrDay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, false);

  proto_item_append_text(actx->created_item, " (days for glonass, weeks otherwise)");

  return offset;
}



static int
dissect_lpp_T_gnss_Toe(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, false);

  proto_item_append_text(actx->created_item, " (units of 15 mns for glonass, hours otherwise)");

  return offset;
}



static int
dissect_lpp_T_t_toeLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  proto_item_append_text(actx->created_item, " (units of 30 mns for glonass, hours otherwise)");

  return offset;
}



static int
dissect_lpp_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, false);

  return offset;
}


static const per_sequence_t SV_ID_sequence[] = {
  { &hf_lpp_satellite_id    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_SV_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SV_ID, SV_ID_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     11, 11, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SatListRelatedDataElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_clockModelID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { &hf_lpp_orbitModelID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SatListRelatedDataElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SatListRelatedDataElement, SatListRelatedDataElement_sequence);

  return offset;
}


static const per_sequence_t SatListRelatedDataList_sequence_of[1] = {
  { &hf_lpp_SatListRelatedDataList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SatListRelatedDataElement },
};

static int
dissect_lpp_SatListRelatedDataList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SatListRelatedDataList, SatListRelatedDataList_sequence_of,
                                                  1, 64, false);

  return offset;
}


static const per_sequence_t StoredNavListInfo_sequence[] = {
  { &hf_lpp_gnss_WeekOrDay  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_WeekOrDay },
  { &hf_lpp_gnss_Toe        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_Toe },
  { &hf_lpp_t_toeLimit      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_t_toeLimit },
  { &hf_lpp_satListRelatedDataList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SatListRelatedDataList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_StoredNavListInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_StoredNavListInfo, StoredNavListInfo_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, false, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t T_clockModelID_PrefList_sequence_of[1] = {
  { &hf_lpp_clockModelID_PrefList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
};

static int
dissect_lpp_T_clockModelID_PrefList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_clockModelID_PrefList, T_clockModelID_PrefList_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t T_orbitModelID_PrefList_sequence_of[1] = {
  { &hf_lpp_orbitModelID_PrefList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
};

static int
dissect_lpp_T_orbitModelID_PrefList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_orbitModelID_PrefList, T_orbitModelID_PrefList_sequence_of,
                                                  1, 8, false);

  return offset;
}


static const per_sequence_t ReqNavListInfo_sequence[] = {
  { &hf_lpp_svReqList       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_64 },
  { &hf_lpp_clockModelID_PrefList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_clockModelID_PrefList },
  { &hf_lpp_orbitModelID_PrefList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_orbitModelID_PrefList },
  { &hf_lpp_addNavparamReq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ReqNavListInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ReqNavListInfo, ReqNavListInfo_sequence);

  return offset;
}


static const value_string lpp_GNSS_NavigationModelReq_vals[] = {
  {   0, "storedNavList" },
  {   1, "reqNavList" },
  { 0, NULL }
};

static const per_choice_t GNSS_NavigationModelReq_choice[] = {
  {   0, &hf_lpp_storedNavList   , ASN1_EXTENSION_ROOT    , dissect_lpp_StoredNavListInfo },
  {   1, &hf_lpp_reqNavList      , ASN1_EXTENSION_ROOT    , dissect_lpp_ReqNavListInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_NavigationModelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_NavigationModelReq, GNSS_NavigationModelReq_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_RealTimeIntegrityReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RealTimeIntegrityReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RealTimeIntegrityReq, GNSS_RealTimeIntegrityReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_3599(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3599U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_999(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 999U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_DataBitsReqSatElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitsReqSatElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitsReqSatElement, GNSS_DataBitsReqSatElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_DataBitsReqSatList_sequence_of[1] = {
  { &hf_lpp_GNSS_DataBitsReqSatList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_DataBitsReqSatElement },
};

static int
dissect_lpp_GNSS_DataBitsReqSatList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_DataBitsReqSatList, GNSS_DataBitsReqSatList_sequence_of,
                                                  1, 64, false);

  return offset;
}


static const per_sequence_t GNSS_DataBitAssistanceReq_sequence[] = {
  { &hf_lpp_gnss_TOD_Req    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3599 },
  { &hf_lpp_gnss_TOD_FracReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_999 },
  { &hf_lpp_dataBitInterval , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_gnss_SignalType_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_gnss_DataBitsReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitsReqSatList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitAssistanceReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitAssistanceReq, GNSS_DataBitAssistanceReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_8_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            8U, 23U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_SignalID_eag_1_sequence[] = {
  { &hf_lpp_gnss_SignalID_Ext_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_8_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SignalID_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SignalID_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SignalID_sequence[] = {
  { &hf_lpp_gnss_SignalID_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID_eag_1 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_SignalID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SignalID, GNSS_SignalID_sequence);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistanceReq_sequence[] = {
  { &hf_lpp_gnss_SignalID_Req, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AcquisitionAssistanceReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AcquisitionAssistanceReq, GNSS_AcquisitionAssistanceReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_AlmanacReq_sequence[] = {
  { &hf_lpp_modelID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AlmanacReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AlmanacReq, GNSS_AlmanacReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_UTC_ModelReq_sequence[] = {
  { &hf_lpp_modelID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_UTC_ModelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_UTC_ModelReq, GNSS_UTC_ModelReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_AuxiliaryInformationReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_AuxiliaryInformationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AuxiliaryInformationReq, GNSS_AuxiliaryInformationReq_sequence);

  return offset;
}


static const per_sequence_t BDS_DifferentialCorrectionsReq_r12_sequence[] = {
  { &hf_lpp_dgnss_SignalsReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_DifferentialCorrectionsReq_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_DifferentialCorrectionsReq_r12, BDS_DifferentialCorrectionsReq_r12_sequence);

  return offset;
}


static const per_sequence_t BDS_GridModelReq_r12_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_BDS_GridModelReq_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_GridModelReq_r12, BDS_GridModelReq_r12_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_1_sequence[] = {
  { &hf_lpp_bds_DifferentialCorrectionsReq_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_DifferentialCorrectionsReq_r12 },
  { &hf_lpp_bds_GridModelReq_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_GridModelReq_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ObservationsReq_r15_sequence[] = {
  { &hf_lpp_gnss_RTK_SignalsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_gnss_RTK_Integer_ms_Req_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_gnss_RTK_PhaseRangeRateReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_gnss_RTK_CNR_Req_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ObservationsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ObservationsReq_r15, GNSS_RTK_ObservationsReq_r15_sequence);

  return offset;
}


static const per_sequence_t GLO_RTK_BiasInformationReq_r15_sequence[] = {
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GLO_RTK_BiasInformationReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GLO_RTK_BiasInformationReq_r15, GLO_RTK_BiasInformationReq_r15_sequence);

  return offset;
}


static const per_sequence_t AUX_ReferenceStationID_Element_r15_sequence[] = {
  { &hf_lpp_aux_stationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AUX_ReferenceStationID_Element_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AUX_ReferenceStationID_Element_r15, AUX_ReferenceStationID_Element_r15_sequence);

  return offset;
}


static const per_sequence_t AUX_ReferenceStationList_r15_sequence_of[1] = {
  { &hf_lpp_AUX_ReferenceStationList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_AUX_ReferenceStationID_Element_r15 },
};

static int
dissect_lpp_AUX_ReferenceStationList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_AUX_ReferenceStationList_r15, AUX_ReferenceStationList_r15_sequence_of,
                                                  1, 32, false);

  return offset;
}


static const per_sequence_t GNSS_RTK_MAC_CorrectionDifferencesReq_r15_sequence[] = {
  { &hf_lpp_master_ReferenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_aux_ReferenceStationList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AUX_ReferenceStationList_r15 },
  { &hf_lpp_linkCombinations_PrefList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15, GNSS_RTK_MAC_CorrectionDifferencesReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ResidualsReq_r15_sequence[] = {
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_linkCombinations_PrefList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ResidualsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ResidualsReq_r15, GNSS_RTK_ResidualsReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_FKP_GradientsReq_r15_sequence[] = {
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_linkCombinations_PrefList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_FKP_GradientsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_FKP_GradientsReq_r15, GNSS_RTK_FKP_GradientsReq_r15_sequence);

  return offset;
}


static const per_sequence_t SatListElement_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod_r15         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SatListElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SatListElement_r15, SatListElement_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_NavListInfo_r15_sequence_of[1] = {
  { &hf_lpp_GNSS_NavListInfo_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SatListElement_r15 },
};

static int
dissect_lpp_GNSS_NavListInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_NavListInfo_r15, GNSS_NavListInfo_r15_sequence_of,
                                                  1, 64, false);

  return offset;
}


static int * const T_orbit_IntegrityReq_r17_bits[] = {
  &hf_lpp_T_orbit_IntegrityReq_r17_correlationTimeReq,
  NULL
};

static int
dissect_lpp_T_orbit_IntegrityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_orbit_IntegrityReq_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsReq_r15_eag_1_sequence[] = {
  { &hf_lpp_orbit_IntegrityReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_orbit_IntegrityReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_OrbitCorrectionsReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsReq_r15_sequence[] = {
  { &hf_lpp_storedNavList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrectionsReq_r15, GNSS_SSR_OrbitCorrectionsReq_r15_sequence);

  return offset;
}


static const value_string lpp_T_clock_IntegrityParametersReq_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_clock_IntegrityParametersReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityClockBoundsReq_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityClockBoundsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsReq_r15_eag_1_sequence[] = {
  { &hf_lpp_clock_IntegrityParametersReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_clock_IntegrityParametersReq_r17 },
  { &hf_lpp_ssr_IntegrityClockBoundsReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityClockBoundsReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_ClockCorrectionsReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsReq_r15_sequence[] = {
  { &hf_lpp_storedNavList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrectionsReq_r15, GNSS_SSR_ClockCorrectionsReq_r15_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityCodeBiasBoundsReq_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityCodeBiasBoundsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasReq_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityCodeBiasBoundsReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityCodeBiasBoundsReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_CodeBiasReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasReq_r15_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Map_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_storedNavList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_CodeBiasReq_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CodeBiasReq_r15, GNSS_SSR_CodeBiasReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_2_sequence[] = {
  { &hf_lpp_gnss_RTK_ObservationsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ObservationsReq_r15 },
  { &hf_lpp_glo_RTK_BiasInformationReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GLO_RTK_BiasInformationReq_r15 },
  { &hf_lpp_gnss_RTK_MAC_CorrectionDifferencesReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15 },
  { &hf_lpp_gnss_RTK_ResidualsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ResidualsReq_r15 },
  { &hf_lpp_gnss_RTK_FKP_GradientsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_FKP_GradientsReq_r15 },
  { &hf_lpp_gnss_SSR_OrbitCorrectionsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15 },
  { &hf_lpp_gnss_SSR_CodeBiasReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CodeBiasReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_Req_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_Req_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_Req_r16, GNSS_SSR_URA_Req_r16_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityPhaseBiasBoundsReq_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasReq_r16_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityPhaseBiasBoundsReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasReq_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_PhaseBiasReq_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasReq_r16_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Map_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_storedNavList_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_PhaseBiasReq_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_PhaseBiasReq_r16, GNSS_SSR_PhaseBiasReq_r16_sequence);

  return offset;
}


static int * const T_stec_IntegrityReq_r17_bits[] = {
  &hf_lpp_T_stec_IntegrityReq_r17_correlationTimeReq,
  NULL
};

static int
dissect_lpp_T_stec_IntegrityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_stec_IntegrityReq_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionReq_r16_eag_1_sequence[] = {
  { &hf_lpp_stec_IntegrityReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_stec_IntegrityReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_STEC_CorrectionReq_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionReq_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_STEC_CorrectionReq_r16, GNSS_SSR_STEC_CorrectionReq_r16_sequence);

  return offset;
}


static const value_string lpp_T_griddedCorrectionIntegrityReq_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_griddedCorrectionIntegrityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionReq_r16_eag_1_sequence[] = {
  { &hf_lpp_griddedCorrectionIntegrityReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_griddedCorrectionIntegrityReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_GriddedCorrectionReq_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionReq_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_GriddedCorrectionReq_r16, GNSS_SSR_GriddedCorrectionReq_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_DifferentialCorrectionsReq_r16_sequence[] = {
  { &hf_lpp_dgnss_SignalsReq_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_DifferentialCorrectionsReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_DifferentialCorrectionsReq_r16, NavIC_DifferentialCorrectionsReq_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_GridModelReq_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NavIC_GridModelReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_GridModelReq_r16, NavIC_GridModelReq_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_URA_Req_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_Req_r16 },
  { &hf_lpp_gnss_SSR_PhaseBiasReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_PhaseBiasReq_r16 },
  { &hf_lpp_gnss_SSR_STEC_CorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16 },
  { &hf_lpp_gnss_SSR_GriddedCorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16 },
  { &hf_lpp_navic_DifferentialCorrectionsReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_DifferentialCorrectionsReq_r16 },
  { &hf_lpp_navic_GridModelReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_GridModelReq_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_3_sequence);

  return offset;
}


static const value_string lpp_T_refEphReq_r17_vals[] = {
  {   0, "b1c" },
  { 0, NULL }
};


static int
dissect_lpp_T_refEphReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsSet2Req_r17_sequence[] = {
  { &hf_lpp_refEphReq_r17   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_refEphReq_r17 },
  { &hf_lpp_gnss_SSR_OrbitCorrectionsSet2Req_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsSet2Req_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrectionsSet2Req_r17, GNSS_SSR_OrbitCorrectionsSet2Req_r17_sequence);

  return offset;
}


static const value_string lpp_T_refEphReq_r17_01_vals[] = {
  {   0, "b1c" },
  { 0, NULL }
};


static int
dissect_lpp_T_refEphReq_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsSet2Req_r17_sequence[] = {
  { &hf_lpp_refEphReq_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_refEphReq_r17_01 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsSet2Req_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsSet2Req_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrectionsSet2Req_r17, GNSS_SSR_ClockCorrectionsSet2Req_r17_sequence);

  return offset;
}


static const value_string lpp_T_refEphReq_r17_02_vals[] = {
  {   0, "b1c" },
  { 0, NULL }
};


static int
dissect_lpp_T_refEphReq_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, true, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_Set2Req_r17_sequence[] = {
  { &hf_lpp_refEphReq_r17_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_refEphReq_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_Set2Req_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_Set2Req_r17, GNSS_SSR_URA_Set2Req_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_4_sequence[] = {
  { &hf_lpp_gnss_SSR_OrbitCorrectionsSet2Req_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsSet2Req_r17 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsSet2Req_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsSet2Req_r17 },
  { &hf_lpp_gnss_SSR_URA_Set2Req_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_Set2Req_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_4_sequence);

  return offset;
}


static const value_string lpp_T_inside_r18_vals[] = {
  {   0, "upper-left" },
  {   1, "upper-right" },
  {   2, "lower-left" },
  {   3, "lower-right" },
  { 0, NULL }
};


static int
dissect_lpp_T_inside_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_outside_r18_vals[] = {
  {   0, "north" },
  {   1, "west" },
  {   2, "south" },
  {   3, "east" },
  {   4, "above" },
  {   5, "below" },
  { 0, NULL }
};


static int
dissect_lpp_T_outside_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_relativeLocationInfo_r18_vals[] = {
  {   0, "inside-r18" },
  {   1, "outside-r18" },
  { 0, NULL }
};

static const per_choice_t T_relativeLocationInfo_r18_choice[] = {
  {   0, &hf_lpp_inside_r18      , ASN1_NO_EXTENSIONS     , dissect_lpp_T_inside_r18 },
  {   1, &hf_lpp_outside_r18     , ASN1_NO_EXTENSIONS     , dissect_lpp_T_outside_r18 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_relativeLocationInfo_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_relativeLocationInfo_r18, T_relativeLocationInfo_r18_choice,
                                 NULL);

  return offset;
}


static const value_string lpp_T_verticalGridType_r18_vals[] = {
  {   0, "ground-level" },
  {   1, "threeD" },
  { 0, NULL }
};


static int
dissect_lpp_T_verticalGridType_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_M50_900(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -50, 900U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_LOS_NLOS_GriddedIndicationsReq_r18_sequence[] = {
  { &hf_lpp_gridPointsSetID_Req_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_relativeLocationInfo_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_relativeLocationInfo_r18 },
  { &hf_lpp_verticalGridType_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_verticalGridType_r18 },
  { &hf_lpp_referenceAltitudeFine_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_9 },
  { &hf_lpp_referenceAltitudeCoarse_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M50_900 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_LOS_NLOS_GriddedIndicationsReq_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_LOS_NLOS_GriddedIndicationsReq_r18, GNSS_LOS_NLOS_GriddedIndicationsReq_r18_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_SatellitePCVResidualsReq_r18_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_SatellitePCVResidualsReq_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_SatellitePCVResidualsReq_r18, GNSS_SSR_SatellitePCVResidualsReq_r18_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_5_sequence[] = {
  { &hf_lpp_gnss_LOS_NLOS_GriddedIndicationsReq_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_LOS_NLOS_GriddedIndicationsReq_r18 },
  { &hf_lpp_gnss_SSR_SatellitePCVResidualsReq_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_SatellitePCVResidualsReq_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_5(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_5_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_ID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_ID },
  { &hf_lpp_gnss_TimeModelsReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_TimeModelListReq },
  { &hf_lpp_gnss_DifferentialCorrectionsReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DifferentialCorrectionsReq },
  { &hf_lpp_gnss_NavigationModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavigationModelReq },
  { &hf_lpp_gnss_RealTimeIntegrityReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_RealTimeIntegrityReq },
  { &hf_lpp_gnss_DataBitAssistanceReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitAssistanceReq },
  { &hf_lpp_gnss_AcquisitionAssistanceReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AcquisitionAssistanceReq },
  { &hf_lpp_gnss_AlmanacReq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AlmanacReq },
  { &hf_lpp_gnss_UTCModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_UTC_ModelReq },
  { &hf_lpp_gnss_AuxiliaryInformationReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AuxiliaryInformationReq },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_4 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_5 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_GenericAssistDataReqElement, GNSS_GenericAssistDataReqElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReq_sequence_of[1] = {
  { &hf_lpp_GNSS_GenericAssistDataReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement },
};

static int
dissect_lpp_GNSS_GenericAssistDataReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_GenericAssistDataReq, GNSS_GenericAssistDataReq_sequence_of,
                                                  1, 16, false);

  return offset;
}



static int
dissect_lpp_INTEGER_1_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_1_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_PeriodicControlParam_r15_sequence[] = {
  { &hf_lpp_deliveryAmount_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_32 },
  { &hf_lpp_deliveryInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_64 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicControlParam_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_PeriodicControlParam_r15, GNSS_PeriodicControlParam_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_eag_1_sequence[] = {
  { &hf_lpp_gnss_SSR_PeriodicURA_Req_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicPhaseBiasReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicSTEC_CorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicGriddedCorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistDataReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_eag_2_sequence[] = {
  { &hf_lpp_gnss_Integrity_PeriodicServiceAlertReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistDataReq_r15_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsSet2Req_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicClockCorrectionsSet2Req_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicURA_Set2Req_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistDataReq_r15_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_eag_4_sequence[] = {
  { &hf_lpp_gnss_SSR_PeriodicIOD_UpdateReq_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistDataReq_r15_eag_4_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_sequence[] = {
  { &hf_lpp_gnss_RTK_PeriodicObservationsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_glo_RTK_PeriodicBiasInformationReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferencesReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_PeriodicResidualsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_FKP_PeriodicGradientsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicClockCorrectionsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicCodeBiasReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_PeriodicAssistDataReq_r15, GNSS_PeriodicAssistDataReq_r15_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_RequestAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_gnss_PeriodicAssistDataReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicAssistDataReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_RequestAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_RequestAssistanceData_eag_1_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_RequestAssistanceData_sequence[] = {
  { &hf_lpp_gnss_CommonAssistDataReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_CommonAssistDataReq },
  { &hf_lpp_gnss_GenericAssistDataReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_GenericAssistDataReq },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_RequestAssistanceData_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_RequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_RequestAssistanceData, A_GNSS_RequestAssistanceData_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_503(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, false);

  return offset;
}


static int * const T_adType_r14_bits[] = {
  &hf_lpp_T_adType_r14_prs,
  &hf_lpp_T_adType_r14_nprs,
  NULL
};

static int
dissect_lpp_T_adType_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_adType_r14_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t OTDOA_RequestAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_adType_r14      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_adType_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_RequestAssistanceData_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_1007(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, false);

  return offset;
}


static const per_sequence_t OTDOA_RequestAssistanceData_eag_2_sequence[] = {
  { &hf_lpp_nrPhysCellId_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1007 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestAssistanceData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_RequestAssistanceData_eag_2_sequence);

  return offset;
}


static const per_sequence_t OTDOA_RequestAssistanceData_sequence[] = {
  { &hf_lpp_physCellId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_503 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_OTDOA_RequestAssistanceData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_OTDOA_RequestAssistanceData_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OTDOA_RequestAssistanceData, OTDOA_RequestAssistanceData_sequence);

  return offset;
}


static const per_sequence_t Sensor_RequestAssistanceData_r14_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_Sensor_RequestAssistanceData_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_RequestAssistanceData_r14, Sensor_RequestAssistanceData_r14_sequence);

  return offset;
}


static const per_sequence_t TBS_RequestAssistanceData_r14_sequence[] = {
  { &hf_lpp_mbs_AlmanacAssistanceDataReq_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_mbs_AcquisitionAssistanceDataReq_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_RequestAssistanceData_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TBS_RequestAssistanceData_r14, TBS_RequestAssistanceData_r14_sequence);

  return offset;
}


static int * const T_requestedAD_r14_bits[] = {
  &hf_lpp_T_requestedAD_r14_ap_identifier,
  &hf_lpp_T_requestedAD_r14_ap_location,
  NULL
};

static int
dissect_lpp_T_requestedAD_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_requestedAD_r14_bits, 2, NULL, NULL);

  return offset;
}



static int
dissect_lpp_OCTET_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, false, NULL);

  return offset;
}



static int
dissect_lpp_T_ssid_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ssid_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 32, false, &ssid_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, ssid_tvb, 0, -1, ENC_ASCII|ENC_NA);


  return offset;
}


static const per_sequence_t WLAN_AP_Identifier_r13_sequence[] = {
  { &hf_lpp_bssid_r13       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_OCTET_STRING_SIZE_6 },
  { &hf_lpp_ssid_r13        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ssid_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_AP_Identifier_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_AP_Identifier_r13, WLAN_AP_Identifier_r13_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of[1] = {
  { &hf_lpp_visibleAPs_r14_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_AP_Identifier_r13 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13, SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of,
                                                  1, maxVisibleAPs_r14, false);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of[1] = {
  { &hf_lpp_wlan_AP_StoredData_r14_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_AP_Identifier_r13 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13, SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of,
                                                  1, maxKnownAPs_r14, false);

  return offset;
}


static const per_sequence_t WLAN_RequestAssistanceData_r14_sequence[] = {
  { &hf_lpp_requestedAD_r14 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_requestedAD_r14 },
  { &hf_lpp_visibleAPs_r14  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13 },
  { &hf_lpp_wlan_AP_StoredData_r14, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_RequestAssistanceData_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_RequestAssistanceData_r14, WLAN_RequestAssistanceData_r14_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_eag_1_sequence[] = {
  { &hf_lpp_sensor_RequestAssistanceData_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_RequestAssistanceData_r14 },
  { &hf_lpp_tbs_RequestAssistanceData_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TBS_RequestAssistanceData_r14 },
  { &hf_lpp_wlan_RequestAssistanceData_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_WLAN_RequestAssistanceData_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestAssistanceData_r9_IEs_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_NR_PhysCellID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, false);

  return offset;
}


static int * const T_nr_AdType_r16_02_bits[] = {
  &hf_lpp_T_nr_AdType_r16_02_dl_prs,
  &hf_lpp_T_nr_AdType_r16_02_ul_srs,
  NULL
};

static int
dissect_lpp_T_nr_AdType_r16_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_AdType_r16_02_bits, 2, NULL, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_1024(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_59(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 59U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 23U, NULL, false);

  return offset;
}


static const per_sequence_t T_dl_prs_duration_r17_sequence[] = {
  { &hf_lpp_seconds_r17     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_59 },
  { &hf_lpp_minutes_r17     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_59 },
  { &hf_lpp_hours_r17       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_dl_prs_duration_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_dl_prs_duration_r17, T_dl_prs_duration_r17_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_StartTime_and_Duration_r17_sequence[] = {
  { &hf_lpp_dl_prs_start_time_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_1024 },
  { &hf_lpp_dl_prs_duration_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_duration_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_StartTime_and_Duration_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_StartTime_and_Duration_r17, DL_PRS_StartTime_and_Duration_r17_sequence);

  return offset;
}


static const value_string lpp_T_dl_prs_FrequencyRangeReq_r17_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_FrequencyRangeReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_ResourceSetPeriodicityReq_r17_vals[] = {
  {   0, "p4" },
  {   1, "p5" },
  {   2, "p8" },
  {   3, "p10" },
  {   4, "p16" },
  {   5, "p20" },
  {   6, "p32" },
  {   7, "p40" },
  {   8, "p64" },
  {   9, "p80" },
  {  10, "p160" },
  {  11, "p320" },
  {  12, "p640" },
  {  13, "p1280" },
  {  14, "p2560" },
  {  15, "p5120" },
  {  16, "p10240" },
  {  17, "p20480" },
  {  18, "p40960" },
  {  19, "p81920" },
  {  20, "p128-v1760" },
  {  21, "p256-v1760" },
  {  22, "p512-v1760" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_ResourceSetPeriodicityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, true, 3, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, false);

  return offset;
}


static const value_string lpp_T_dl_prs_ResourceRepetitionFactorReq_r17_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_ResourceRepetitionFactorReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, true, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_NumSymbolsReq_r17_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n12" },
  {   4, "n1-v1800" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_NumSymbolsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 1, NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_CombSizeN_Req_r17_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_CombSizeN_Req_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, true, 0, NULL);

  return offset;
}



static int
dissect_lpp_ARFCN_ValueNR_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3279165U, NULL, false);

  return offset;
}



static int
dissect_lpp_NR_DL_PRS_ResourceSetID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, nrMaxNumDL_PRS_ResourceSetsPerTRP_1_r16, NULL, false);

  return offset;
}


static const value_string lpp_T_rs_Type_r16_vals[] = {
  {   0, "typeC" },
  {   1, "typeD" },
  {   2, "typeC-plus-typeD" },
  { 0, NULL }
};


static int
dissect_lpp_T_rs_Type_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t T_ssb_r16_sequence[] = {
  { &hf_lpp_pci_r16         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_ssb_Index_r16   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_rs_Type_r16     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_rs_Type_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ssb_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ssb_r16, T_ssb_r16_sequence);

  return offset;
}



static int
dissect_lpp_NR_DL_PRS_ResourceID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, nrMaxNumDL_PRS_ResourcesPerSet_1_r16, NULL, false);

  return offset;
}


static const per_sequence_t T_dl_PRS_r16_sequence[] = {
  { &hf_lpp_qcl_DL_PRS_ResourceID_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourceID_r16 },
  { &hf_lpp_qcl_DL_PRS_ResourceSetID_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourceSetID_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_dl_PRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_dl_PRS_r16, T_dl_PRS_r16_sequence);

  return offset;
}


static const value_string lpp_DL_PRS_QCL_Info_r16_vals[] = {
  {   0, "ssb-r16" },
  {   1, "dl-PRS-r16" },
  { 0, NULL }
};

static const per_choice_t DL_PRS_QCL_Info_r16_choice[] = {
  {   0, &hf_lpp_ssb_r16         , ASN1_NO_EXTENSIONS     , dissect_lpp_T_ssb_r16 },
  {   1, &hf_lpp_dl_PRS_r16      , ASN1_NO_EXTENSIONS     , dissect_lpp_T_dl_PRS_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_Info_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_DL_PRS_QCL_Info_r16, DL_PRS_QCL_Info_r16_choice,
                                 NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_QCL_InformationReq_r17_vals[] = {
  {   0, "dl-prs-QCL-InfoRecPerResourceSet-r17" },
  {   1, "dl-prs-QCL-Info-requested-r17" },
  { 0, NULL }
};

static const per_choice_t T_dl_prs_QCL_InformationReq_r17_choice[] = {
  {   0, &hf_lpp_dl_prs_QCL_InfoRecPerResourceSet_r17, ASN1_NO_EXTENSIONS     , dissect_lpp_DL_PRS_QCL_Info_r16 },
  {   1, &hf_lpp_dl_prs_QCL_Info_requested_r17, ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_dl_prs_QCL_InformationReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_dl_prs_QCL_InformationReq_r17, T_dl_prs_QCL_InformationReq_r17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16_sequence_of[1] = {
  { &hf_lpp_dl_prs_QCL_InfoRecPerResource_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_Info_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16, SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16_sequence_of,
                                                  1, nrMaxResourcesPerSet_r16, false);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InfoReq_r17_eag_1_sequence[] = {
  { &hf_lpp_dl_prs_QCL_InfoRecPerResource_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_InfoReq_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_PRS_QCL_InfoReq_r17_eag_1_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InfoReq_r17_sequence[] = {
  { &hf_lpp_nr_DL_PRS_ResourceSetID_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourceSetID_r16 },
  { &hf_lpp_dl_prs_QCL_InformationReq_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_prs_QCL_InformationReq_r17 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_InfoReq_r17_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_InfoReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_QCL_InfoReq_r17, DL_PRS_QCL_InfoReq_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17_sequence_of[1] = {
  { &hf_lpp_dl_prs_QCL_InformationReqSet_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_InfoReq_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17, SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17_sequence_of,
                                                  1, nrMaxSetsPerTrpPerFreqLayer_r16, false);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InformationReqPerTRP_r17_sequence[] = {
  { &hf_lpp_dl_PRS_ID_r17   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_nr_PhysCellID_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_CellGlobalID_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NCGI_r15 },
  { &hf_lpp_nr_ARFCN_r17    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ARFCN_ValueNR_r15 },
  { &hf_lpp_dl_prs_QCL_InformationReqSet_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_InformationReqPerTRP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_QCL_InformationReqPerTRP_r17, DL_PRS_QCL_InformationReqPerTRP_r17_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InformationReqTRPlist_r17_sequence_of[1] = {
  { &hf_lpp_DL_PRS_QCL_InformationReqTRPlist_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_InformationReqPerTRP_r17 },
};

static int
dissect_lpp_DL_PRS_QCL_InformationReqTRPlist_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DL_PRS_QCL_InformationReqTRPlist_r17, DL_PRS_QCL_InformationReqTRPlist_r17_sequence_of,
                                                  1, nrMaxTRPsPerFreq_r16, false);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_PerFreqLayer_r17_sequence[] = {
  { &hf_lpp_dl_prs_FrequencyRangeReq_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_prs_FrequencyRangeReq_r17 },
  { &hf_lpp_dl_prs_ResourceSetPeriodicityReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_ResourceSetPeriodicityReq_r17 },
  { &hf_lpp_dl_prs_ResourceBandwidthReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_63 },
  { &hf_lpp_dl_prs_ResourceRepetitionFactorReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_ResourceRepetitionFactorReq_r17 },
  { &hf_lpp_dl_prs_NumSymbolsReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_NumSymbolsReq_r17 },
  { &hf_lpp_dl_prs_CombSizeN_Req_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_CombSizeN_Req_r17 },
  { &hf_lpp_dl_prs_QCL_InformationReqTRPlist_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_DL_PRS_QCL_InformationReqTRPlist_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17, NR_On_Demand_DL_PRS_PerFreqLayer_r17_sequence);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Information_r17_sequence_of[1] = {
  { &hf_lpp_NR_On_Demand_DL_PRS_Information_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17 },
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Information_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_NR_On_Demand_DL_PRS_Information_r17, NR_On_Demand_DL_PRS_Information_r17_sequence_of,
                                                  1, nrMaxFreqLayers_r16, false);

  return offset;
}



static int
dissect_lpp_INTEGER_1_maxOD_DL_PRS_Configs_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxOD_DL_PRS_Configs_r17, NULL, false);

  return offset;
}


static const per_sequence_t DL_PRS_Configuration_ID_r17_sequence[] = {
  { &hf_lpp_nr_dl_prs_configuration_id_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_maxOD_DL_PRS_Configs_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_Configuration_ID_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_Configuration_ID_r17, DL_PRS_Configuration_ID_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17_sequence_of[1] = {
  { &hf_lpp_dl_prs_configuration_id_PrefList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_Configuration_ID_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17, SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17_sequence_of,
                                                  1, maxOD_DL_PRS_Configs_r17, false);

  return offset;
}


static const per_sequence_t T_dl_PRS_AggregationID_PrefList_r18_sequence_of[1] = {
  { &hf_lpp_dl_PRS_AggregationID_PrefList_r18_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_maxOD_DL_PRS_Configs_r17 },
};

static int
dissect_lpp_T_dl_PRS_AggregationID_PrefList_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_dl_PRS_AggregationID_PrefList_r18, T_dl_PRS_AggregationID_PrefList_r18_sequence_of,
                                                  1, maxOD_DL_PRS_Configs_r17, false);

  return offset;
}



static int
dissect_lpp_INTEGER_1_nrMaxFreqLayers_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, nrMaxFreqLayers_r16, NULL, false);

  return offset;
}


static const per_sequence_t NR_OnDemandDL_PRS_AggregationReqElement_r18_sequence_of[1] = {
  { &hf_lpp_NR_OnDemandDL_PRS_AggregationReqElement_r18_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_nrMaxFreqLayers_r16 },
};

static int
dissect_lpp_NR_OnDemandDL_PRS_AggregationReqElement_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_NR_OnDemandDL_PRS_AggregationReqElement_r18, NR_OnDemandDL_PRS_AggregationReqElement_r18_sequence_of,
                                                  2, 3, false);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18_sequence_of[1] = {
  { &hf_lpp_nr_OnDemandDL_PRS_AggregationReqList_r18_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_OnDemandDL_PRS_AggregationReqElement_r18 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18, SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18_sequence_of,
                                                  1, maxOD_DL_PRS_Configs_r17, false);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Request_r17_eag_1_sequence[] = {
  { &hf_lpp_dl_PRS_AggregationID_PrefList_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_AggregationID_PrefList_r18 },
  { &hf_lpp_nr_OnDemandDL_PRS_AggregationReqList_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_NR_OnDemandDL_PRS_AggregationReqElement_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Request_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_On_Demand_DL_PRS_Request_r17_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Request_r17_sequence[] = {
  { &hf_lpp_dl_prs_StartTime_and_Duration_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_DL_PRS_StartTime_and_Duration_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_Information_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Information_r17 },
  { &hf_lpp_dl_prs_configuration_id_PrefList_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_On_Demand_DL_PRS_Request_r17_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Request_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_On_Demand_DL_PRS_Request_r17, NR_On_Demand_DL_PRS_Request_r17_sequence);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02_vals[] = {
  {   0, "eAoD" },
  {   1, "eAoA" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_pre_configured_AssistanceDataRequest_r17_02_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_RequestAssistanceData_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_on_demand_DL_PRS_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Request_r17 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02 },
  { &hf_lpp_pre_configured_AssistanceDataRequest_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_RequestAssistanceData_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_RequestAssistanceData_r16_sequence[] = {
  { &hf_lpp_nr_PhysCellID_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_AdType_r16_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_AdType_r16_02 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_RequestAssistanceData_r16, NR_Multi_RTT_RequestAssistanceData_r16_sequence);

  return offset;
}


static int * const T_nr_AdType_r16_01_bits[] = {
  &hf_lpp_T_nr_AdType_r16_01_dl_prs,
  &hf_lpp_T_nr_AdType_r16_01_posCalc,
  NULL
};

static int
dissect_lpp_T_nr_AdType_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_AdType_r16_01_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_nr_PosCalcAssistanceRequest_r17_01_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_trpLoc,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_rtdInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamAntInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_losNlosInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_nr_IntegrityBounds_r18,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceRequest_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_PosCalcAssistanceRequest_r17_01_bits, 6, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01_vals[] = {
  {   0, "eAoD" },
  {   1, "eAoA" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_BeamInfoRequest_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_BeamInfoRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_pre_configured_AssistanceDataRequest_r17_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static int * const T_nr_IntegrityAssistanceRequest_r18_01_bits[] = {
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_serviceParameters,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_serviceAlert,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_riskParameters,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityParaTRP_Loc,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityParaBeamInfo,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityParaRTD_Info,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_01_integrityBeamAntInfo,
  NULL
};

static int
dissect_lpp_T_nr_IntegrityAssistanceRequest_r18_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_IntegrityAssistanceRequest_r18_01_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_RequestAssistanceData_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_PosCalcAssistanceRequest_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceRequest_r17_01 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01 },
  { &hf_lpp_nr_DL_PRS_BeamInfoRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_BeamInfoRequest_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Request_r17 },
  { &hf_lpp_pre_configured_AssistanceDataRequest_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_01 },
  { &hf_lpp_nr_IntegrityAssistanceRequest_r18_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_IntegrityAssistanceRequest_r18_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_RequestAssistanceData_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_RequestAssistanceData_r16_sequence[] = {
  { &hf_lpp_nr_PhysCellID_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_AdType_r16_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_AdType_r16_01 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_RequestAssistanceData_r16, NR_DL_AoD_RequestAssistanceData_r16_sequence);

  return offset;
}


static int * const T_nr_AdType_r16_bits[] = {
  &hf_lpp_T_nr_AdType_r16_dl_prs,
  &hf_lpp_T_nr_AdType_r16_posCalc,
  NULL
};

static int
dissect_lpp_T_nr_AdType_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_AdType_r16_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_nr_PosCalcAssistanceRequest_r17_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpLoc,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_beamInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_rtdInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_losNlosInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpTEG_Info,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_nr_IntegrityBounds_r18,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_pruInfo_r18,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_PosCalcAssistanceRequest_r17_bits, 7, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_vals[] = {
  {   0, "eAoD" },
  {   1, "eAoA" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}


static const value_string lpp_T_pre_configured_AssistanceDataRequest_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_pre_configured_AssistanceDataRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestAssistanceData_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_PosCalcAssistanceRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceRequest_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Request_r17 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17 },
  { &hf_lpp_pre_configured_AssistanceDataRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_pre_configured_AssistanceDataRequest_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_RequestAssistanceData_r16_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_4_81920(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            4U, 81920U, NULL, false);

  return offset;
}


static const per_sequence_t NR_PeriodicControlParam_r18_sequence[] = {
  { &hf_lpp_deliveryAmount_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_32 },
  { &hf_lpp_deliveryInterval_r18, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_4_81920 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_PeriodicControlParam_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_PeriodicControlParam_r18, NR_PeriodicControlParam_r18_sequence);

  return offset;
}


static const per_sequence_t NR_PeriodicAssistDataReq_r18_sequence[] = {
  { &hf_lpp_nr_PeriodicPRU_DL_InfoReq_r18, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PeriodicControlParam_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_PeriodicAssistDataReq_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_PeriodicAssistDataReq_r18, NR_PeriodicAssistDataReq_r18_sequence);

  return offset;
}


static int * const T_nr_IntegrityAssistanceRequest_r18_bits[] = {
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_serviceParameters,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_serviceAlert,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_riskParameters,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_integrityParaTRP_Loc,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_integrityParaBeamInfo,
  &hf_lpp_T_nr_IntegrityAssistanceRequest_r18_integrityParaRTD_Info,
  NULL
};

static int
dissect_lpp_T_nr_IntegrityAssistanceRequest_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_nr_IntegrityAssistanceRequest_r18_bits, 6, NULL, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestAssistanceData_r16_eag_2_sequence[] = {
  { &hf_lpp_nr_PeriodicAssistDataReq_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_PeriodicAssistDataReq_r18 },
  { &hf_lpp_nr_IntegrityAssistanceRequest_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_IntegrityAssistanceRequest_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_RequestAssistanceData_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestAssistanceData_r16_sequence[] = {
  { &hf_lpp_nr_PhysCellID_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_AdType_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_AdType_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_RequestAssistanceData_r16, NR_DL_TDOA_RequestAssistanceData_r16_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_eag_2_sequence[] = {
  { &hf_lpp_nr_Multi_RTT_RequestAssistanceData_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16 },
  { &hf_lpp_nr_DL_AoD_RequestAssistanceData_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16 },
  { &hf_lpp_nr_DL_TDOA_RequestAssistanceData_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestAssistanceData_r9_IEs_eag_2_sequence);

  return offset;
}


static int * const T_requestedAD_r18_bits[] = {
  &hf_lpp_T_requestedAD_r18_beacon_location,
  &hf_lpp_T_requestedAD_r18_beacon_antConfig,
  &hf_lpp_T_requestedAD_r18_beacon_transmConfig,
  NULL
};

static int
dissect_lpp_T_requestedAD_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, false, T_requestedAD_r18_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t BT_RequestAssistanceData_r18_sequence[] = {
  { &hf_lpp_requestedAD_r18 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_requestedAD_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_RequestAssistanceData_r18(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BT_RequestAssistanceData_r18, BT_RequestAssistanceData_r18_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_eag_3_sequence[] = {
  { &hf_lpp_bt_RequestAssistanceData_r18, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BT_RequestAssistanceData_r18 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestAssistanceData_r9_IEs_eag_3_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_sequence[] = {
  { &hf_lpp_commonIEsRequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CommonIEsRequestAssistanceData },
  { &hf_lpp_a_gnss_RequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_RequestAssistanceData },
  { &hf_lpp_otdoa_RequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OTDOA_RequestAssistanceData },
  { &hf_lpp_epdu_RequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Sequence },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestAssistanceData_r9_IEs_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestAssistanceData_r9_IEs_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestAssistanceData_r9_IEs_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestAssistanceData_r9_IEs, RequestAssistanceData_r9_IEs_sequence);

  return offset;
}


static const value_string lpp_T_c1_03_vals[] = {
  {   0, "requestAssistanceData-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_03_choice[] = {
  {   0, &hf_lpp_requestAssistanceData_r9, ASN1_NO_EXTENSIONS     , dissect_lpp_RequestAssistanceData_r9_IEs },
  {   1, &hf_lpp_spare3          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   2, &hf_lpp_spare2          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   3, &hf_lpp_spare1          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_c1_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_c1_03, T_c1_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensionsFuture_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_criticalExtensionsFuture_02, T_criticalExtensionsFuture_02_sequence);

  return offset;
}


static const value_string lpp_T_criticalExtensions_02_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_02_choice[] = {
  {   0, &hf_lpp_c1_03           , ASN1_NO_EXTENSIONS     , dissect_lpp_T_c1_03 },
  {   1, &hf_lpp_criticalExtensionsFuture_02, ASN1_NO_EXTENSIONS     , dissect_lpp_T_criticalExtensionsFuture_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensions_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_criticalExtensions_02, T_criticalExtensions_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RequestAssistanceData_sequence[] = {
  { &hf_lpp_criticalExtensions_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_criticalExtensions_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Request Assistance Data");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestAssistanceData, RequestAssistanceData_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_segmentationInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SegmentationInfo_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideAssistanceData_eag_1_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideAssistanceData_eag_2_sequence[] = {
  { &hf_lpp_periodicAssistanceData_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicAssistanceDataControlParameters_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideAssistanceData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideAssistanceData_eag_2_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideAssistanceData_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideAssistanceData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideAssistanceData_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsProvideAssistanceData, CommonIEsProvideAssistanceData_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_86399(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86399U, NULL, false);

  return offset;
}



static int
dissect_lpp_T_notificationOfLeapSecond(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *notificationOfLeapSecond_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, false, NULL, 0, &notificationOfLeapSecond_tvb, NULL);



  if (notificationOfLeapSecond_tvb) {
    unsigned bitvalue = tvb_get_bits8(notificationOfLeapSecond_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, notificationOfLeapSecond_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_lpp_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, false);

  return offset;
}


static const per_sequence_t GPS_TOW_AssistElement_sequence[] = {
  { &hf_lpp_satelliteID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_64 },
  { &hf_lpp_tlmWord         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_antiSpoof       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_alert           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_tlmRsvdBits     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GPS_TOW_AssistElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GPS_TOW_AssistElement, GPS_TOW_AssistElement_sequence);

  return offset;
}


static const per_sequence_t GPS_TOW_Assist_sequence_of[1] = {
  { &hf_lpp_GPS_TOW_Assist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GPS_TOW_AssistElement },
};

static int
dissect_lpp_GPS_TOW_Assist(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GPS_TOW_Assist, GPS_TOW_Assist_sequence_of,
                                                  1, 64, false);

  return offset;
}


static const per_sequence_t GNSS_SystemTime_sequence[] = {
  { &hf_lpp_gnss_TimeID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_gnss_DayNumber  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_32767 },
  { &hf_lpp_gnss_TimeOfDay  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_86399 },
  { &hf_lpp_gnss_TimeOfDayFrac_msec, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_999 },
  { &hf_lpp_notificationOfLeapSecond, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_notificationOfLeapSecond },
  { &hf_lpp_gps_TOW_Assist  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GPS_TOW_Assist },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_SystemTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SystemTime, GNSS_SystemTime_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_12533(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 12533U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_3999999(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3999999U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M64_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -64, 63U, NULL, false);

  return offset;
}


static const per_sequence_t T_mcc_sequence_of[1] = {
  { &hf_lpp_mcc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc, T_mcc_sequence_of,
                                                  3, 3, false);

  return offset;
}


static const per_sequence_t T_mnc_sequence_of[1] = {
  { &hf_lpp_mnc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc, T_mnc_sequence_of,
                                                  2, 3, false);

  return offset;
}


static const per_sequence_t T_plmn_Identity_sequence[] = {
  { &hf_lpp_mcc             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc },
  { &hf_lpp_mnc             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_plmn_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_plmn_Identity, T_plmn_Identity_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, false, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string lpp_T_cellIdentity_vals[] = {
  {   0, "eutra" },
  {   1, "utra" },
  { 0, NULL }
};

static const per_choice_t T_cellIdentity_choice[] = {
  {   0, &hf_lpp_eutra           , ASN1_NO_EXTENSIONS     , dissect_lpp_BIT_STRING_SIZE_28 },
  {   1, &hf_lpp_utra            , ASN1_NO_EXTENSIONS     , dissect_lpp_BIT_STRING_SIZE_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_cellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_cellIdentity, T_cellIdentity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellGlobalIdEUTRA_AndUTRA_sequence[] = {
  { &hf_lpp_plmn_Identity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_plmn_Identity },
  { &hf_lpp_cellIdentity    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cellIdentity },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_CellGlobalIdEUTRA_AndUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CellGlobalIdEUTRA_AndUTRA, CellGlobalIdEUTRA_AndUTRA_sequence);

  return offset;
}



int
dissect_lpp_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, false);

  return offset;
}



int
dissect_lpp_ARFCN_ValueEUTRA_v9a0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            maxEARFCN_Plus1, maxEARFCN2, NULL, false);

  return offset;
}


static const per_sequence_t T_eag_1_02_sequence[] = {
  { &hf_lpp_earfcn_v9a0     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ARFCN_ValueEUTRA_v9a0 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_eag_1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_02_sequence);

  return offset;
}


static const per_sequence_t T_eUTRA_sequence[] = {
  { &hf_lpp_physCellId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_503 },
  { &hf_lpp_cellGlobalIdEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CellGlobalIdEUTRA_AndUTRA },
  { &hf_lpp_earfcn          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueEUTRA },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_T_eag_1_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_eUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_eUTRA, T_eUTRA_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, false);

  return offset;
}


static const per_sequence_t T_fdd_sequence[] = {
  { &hf_lpp_primary_CPICH_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_fdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_fdd, T_fdd_sequence);

  return offset;
}


static const per_sequence_t T_tdd_sequence[] = {
  { &hf_lpp_cellParameters  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_tdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_tdd, T_tdd_sequence);

  return offset;
}


static const value_string lpp_T_mode_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t T_mode_choice[] = {
  {   0, &hf_lpp_fdd             , ASN1_NO_EXTENSIONS     , dissect_lpp_T_fdd },
  {   1, &hf_lpp_tdd             , ASN1_NO_EXTENSIONS     , dissect_lpp_T_tdd },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_mode, T_mode_choice,
                                 NULL);

  return offset;
}



int
dissect_lpp_ARFCN_ValueUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, false);

  return offset;
}


static const per_sequence_t T_uTRA_sequence[] = {
  { &hf_lpp_mode            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_mode },
  { &hf_lpp_cellGlobalIdUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CellGlobalIdEUTRA_AndUTRA },
  { &hf_lpp_uarfcn          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_uTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_uTRA, T_uTRA_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, false);

  return offset;
}


static const per_sequence_t T_mcc_01_sequence_of[1] = {
  { &hf_lpp_mcc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc_01, T_mcc_01_sequence_of,
                                                  3, 3, false);

  return offset;
}


static const per_sequence_t T_mnc_01_sequence_of[1] = {
  { &hf_lpp_mnc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc_01, T_mnc_01_sequence_of,
                                                  2, 3, false);

  return offset;
}


static const per_sequence_t T_plmn_Identity_01_sequence[] = {
  { &hf_lpp_mcc_01          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc_01 },
  { &hf_lpp_mnc_01          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_plmn_Identity_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_plmn_Identity_01, T_plmn_Identity_01_sequence);

  return offset;
}


static const per_sequence_t CellGlobalIdGERAN_sequence[] = {
  { &hf_lpp_plmn_Identity_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_plmn_Identity_01 },
  { &hf_lpp_locationAreaCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_16 },
  { &hf_lpp_cellGlobalIdGERAN_cellIdentity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_16 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_CellGlobalIdGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CellGlobalIdGERAN, CellGlobalIdGERAN_sequence);

  return offset;
}


static const per_sequence_t T_gSM_sequence[] = {
  { &hf_lpp_bcchCarrier     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_bsic            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_cellGlobalIdGERAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CellGlobalIdGERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_gSM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_gSM, T_gSM_sequence);

  return offset;
}



static int
dissect_lpp_ARFCN_ValueEUTRA_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN2, NULL, false);

  return offset;
}


static const value_string lpp_CarrierFreqOffsetNB_r14_vals[] = {
  {   0, "v-10" },
  {   1, "v-9" },
  {   2, "v-8" },
  {   3, "v-7" },
  {   4, "v-6" },
  {   5, "v-5" },
  {   6, "v-4" },
  {   7, "v-3" },
  {   8, "v-2" },
  {   9, "v-1" },
  {  10, "v-0dot5" },
  {  11, "v0" },
  {  12, "v1" },
  {  13, "v2" },
  {  14, "v3" },
  {  15, "v4" },
  {  16, "v5" },
  {  17, "v6" },
  {  18, "v7" },
  {  19, "v8" },
  {  20, "v9" },
  { 0, NULL }
};

static value_string_ext lpp_CarrierFreqOffsetNB_r14_vals_ext = VALUE_STRING_EXT_INIT(lpp_CarrierFreqOffsetNB_r14_vals);


static int
dissect_lpp_CarrierFreqOffsetNB_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t CarrierFreq_NB_r14_sequence[] = {
  { &hf_lpp_carrierFreq_r14 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueEUTRA_r14 },
  { &hf_lpp_carrierFreqOffset_r14, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CarrierFreqOffsetNB_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CarrierFreq_NB_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CarrierFreq_NB_r14, CarrierFreq_NB_r14_sequence);

  return offset;
}


static const per_sequence_t T_nBIoT_r14_sequence[] = {
  { &hf_lpp_nbPhysCellId_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_503 },
  { &hf_lpp_nbCellGlobalId_r14, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECGI },
  { &hf_lpp_nbCarrierFreq_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_CarrierFreq_NB_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nBIoT_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nBIoT_r14, T_nBIoT_r14_sequence);

  return offset;
}


static const per_sequence_t T_nr_r15_sequence[] = {
  { &hf_lpp_nrPhysCellId_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1007 },
  { &hf_lpp_nrCellGlobalID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NCGI_r15 },
  { &hf_lpp_nrARFCN_r15     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueNR_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_r15, T_nr_r15_sequence);

  return offset;
}


static const value_string lpp_T_cellID_vals[] = {
  {   0, "eUTRA" },
  {   1, "uTRA" },
  {   2, "gSM" },
  {   3, "nBIoT-r14" },
  {   4, "nr-r15" },
  { 0, NULL }
};

static const per_choice_t T_cellID_choice[] = {
  {   0, &hf_lpp_eUTRA           , ASN1_EXTENSION_ROOT    , dissect_lpp_T_eUTRA },
  {   1, &hf_lpp_uTRA            , ASN1_EXTENSION_ROOT    , dissect_lpp_T_uTRA },
  {   2, &hf_lpp_gSM             , ASN1_EXTENSION_ROOT    , dissect_lpp_T_gSM },
  {   3, &hf_lpp_nBIoT_r14       , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_T_nBIoT_r14 },
  {   4, &hf_lpp_nr_r15          , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_T_nr_r15 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_cellID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_cellID, T_cellID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NetworkTime_sequence[] = {
  { &hf_lpp_secondsFromFrameStructureStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_12533 },
  { &hf_lpp_fractionalSecondsFromFrameStructureStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3999999 },
  { &hf_lpp_frameDrift      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_cellID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cellID },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_NetworkTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NetworkTime, NetworkTime_sequence);

  return offset;
}


static const value_string lpp_T_bsAlign_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_bsAlign(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTimeForOneCell_sequence[] = {
  { &hf_lpp_networkTime     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NetworkTime },
  { &hf_lpp_referenceTimeUnc, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_bsAlign         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_bsAlign },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTimeForOneCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTimeForOneCell, GNSS_ReferenceTimeForOneCell_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell_sequence_of[1] = {
  { &hf_lpp_gnss_ReferenceTimeForCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceTimeForOneCell },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell, SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTime_sequence[] = {
  { &hf_lpp_gnss_SystemTime , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_referenceTimeUnc, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_gnss_ReferenceTimeForCells, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTime, GNSS_ReferenceTime_sequence);

  return offset;
}


static const value_string lpp_T_latitudeSign_04_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_lpp_T_latitudeSign_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8388607U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M8388608_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8388608, 8388607U, NULL, false);

  return offset;
}


static const value_string lpp_T_altitudeDirection_01_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_lpp_T_altitudeDirection_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_179(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 179U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, false);

  return offset;
}


static const per_sequence_t EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_sequence[] = {
  { &hf_lpp_latitudeSign_04 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_latitudeSign_04 },
  { &hf_lpp_degreesLatitude , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_8388607 },
  { &hf_lpp_degreesLongitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_altitudeDirection_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_altitudeDirection_01 },
  { &hf_lpp_altitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_32767 },
  { &hf_lpp_uncertaintySemiMajor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_uncertaintySemiMinor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_orientationMajorAxis, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_179 },
  { &hf_lpp_uncertaintyAltitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_confidence      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid, EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceLocation_sequence[] = {
  { &hf_lpp_threeDlocation  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceLocation, GNSS_ReferenceLocation_sequence);

  return offset;
}



static int
dissect_lpp_T_dataID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *dataID_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, false, NULL, 0, &dataID_tvb, NULL);



  if (dataID_tvb) {
    unsigned bitvalue = tvb_get_bits8(dataID_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, dataID_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_lpp_INTEGER_M128_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -128, 127U, NULL, false);

  return offset;
}


static const per_sequence_t KlobucharModelParameter_sequence[] = {
  { &hf_lpp_dataID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dataID },
  { &hf_lpp_alfa0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa1           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa2           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa3           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta1           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta2           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta3           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_KlobucharModelParameter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_KlobucharModelParameter, KlobucharModelParameter_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M1024_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1024, 1023U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M8192_8191(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8192, 8191U, NULL, false);

  return offset;
}


static const per_sequence_t NeQuickModelParameter_sequence[] = {
  { &hf_lpp_ai0             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { &hf_lpp_ai1             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_ai2             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_ionoStormFlag1  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag2  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag3  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag4  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag5  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NeQuickModelParameter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NeQuickModelParameter, NeQuickModelParameter_sequence);

  return offset;
}


static const per_sequence_t KlobucharModel2Parameter_r16_sequence[] = {
  { &hf_lpp_alfa1_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_alfa2_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa3_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alfa4_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alfa5_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alfa6_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa7_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa8_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa9_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_KlobucharModel2Parameter_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_KlobucharModel2Parameter_r16, KlobucharModel2Parameter_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModel_eag_1_sequence[] = {
  { &hf_lpp_klobucharModel2_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_KlobucharModel2Parameter_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModel_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_IonosphericModel_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModel_sequence[] = {
  { &hf_lpp_klobucharModel  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_KlobucharModelParameter },
  { &hf_lpp_neQuickModel    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NeQuickModelParameter },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_IonosphericModel_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_IonosphericModel, GNSS_IonosphericModel_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M1048576_1048575(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1048576, 1048575U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M16384_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16384, 16383U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M1073741824_1073741823(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1073741824, 1073741823U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M262144_262143(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -262144, 262143U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_EarthOrientationParameters_sequence[] = {
  { &hf_lpp_teop            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_pmX             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_pmXdot          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_pmY             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_pmYdot          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_deltaUT1        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1073741824_1073741823 },
  { &hf_lpp_deltaUT1dot     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M262144_262143 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_EarthOrientationParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_EarthOrientationParameters, GNSS_EarthOrientationParameters_sequence);

  return offset;
}


static const value_string lpp_T_referenceStationIndicator_r15_vals[] = {
  {   0, "physical" },
  {   1, "non-physical" },
  { 0, NULL }
};


static int
dissect_lpp_T_referenceStationIndicator_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, false, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_M137438953472_137438953471(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            INT64_C(-137438953472), UINT64_C(137438953471), NULL, false);

  return offset;
}



static int
dissect_lpp_VisibleString_SIZE_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 256, false,
                                          NULL);

  return offset;
}


static const value_string lpp_T_antennaSetUpID_r15_vals[] = {
  {   0, "non-zero" },
  { 0, NULL }
};


static int
dissect_lpp_T_antennaSetUpID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, false, 0, NULL);

  return offset;
}


static const per_sequence_t AntennaDescription_r15_sequence[] = {
  { &hf_lpp_antennaDescriptor_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_VisibleString_SIZE_1_256 },
  { &hf_lpp_antennaSetUpID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_antennaSetUpID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AntennaDescription_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AntennaDescription_r15, AntennaDescription_r15_sequence);

  return offset;
}


static const per_sequence_t AntennaReferencePointUnc_r15_sequence[] = {
  { &hf_lpp_uncertainty_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_confidence_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { &hf_lpp_uncertainty_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_confidence_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { &hf_lpp_uncertainty_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_confidence_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AntennaReferencePointUnc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AntennaReferencePointUnc_r15, AntennaReferencePointUnc_r15_sequence);

  return offset;
}


static const per_sequence_t PhysicalReferenceStationInfo_r15_sequence[] = {
  { &hf_lpp_physicalReferenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_physical_ARP_ECEF_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_physical_ARP_ECEF_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_physical_ARP_ECEF_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_physical_ARP_unc_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AntennaReferencePointUnc_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PhysicalReferenceStationInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PhysicalReferenceStationInfo_r15, PhysicalReferenceStationInfo_r15_sequence);

  return offset;
}


static const per_sequence_t ReferenceStationList_r16_sequence_of[1] = {
  { &hf_lpp_ReferenceStationList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
};

static int
dissect_lpp_ReferenceStationList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_ReferenceStationList_r16, ReferenceStationList_r16_sequence_of,
                                                  1, 16, false);

  return offset;
}


static const value_string lpp_EqualIntegerAmbiguityLevel_r16_vals[] = {
  {   0, "allReferenceStations-r16" },
  {   1, "referenceStationList-r16" },
  { 0, NULL }
};

static const per_choice_t EqualIntegerAmbiguityLevel_r16_choice[] = {
  {   0, &hf_lpp_allReferenceStations_r16, ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   1, &hf_lpp_referenceStationList_r16, ASN1_NO_EXTENSIONS     , dissect_lpp_ReferenceStationList_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_EqualIntegerAmbiguityLevel_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_EqualIntegerAmbiguityLevel_r16, EqualIntegerAmbiguityLevel_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfo_r15_eag_1_sequence[] = {
  { &hf_lpp_equalIntegerAmbiguityLevel_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_EqualIntegerAmbiguityLevel_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_RTK_ReferenceStationInfo_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfo_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_referenceStationIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_referenceStationIndicator_r15 },
  { &hf_lpp_antenna_reference_point_ECEF_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_antenna_reference_point_ECEF_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_antenna_reference_point_ECEF_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_antennaHeight_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_antennaDescription_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AntennaDescription_r15 },
  { &hf_lpp_antenna_reference_point_unc_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AntennaReferencePointUnc_r15 },
  { &hf_lpp_physical_reference_station_info_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PhysicalReferenceStationInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ReferenceStationInfo_r15, GNSS_RTK_ReferenceStationInfo_r15_sequence);

  return offset;
}



static int
dissect_lpp_T_smoothingIndicator_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     1, 1, false, NULL, 0, &param_tvb, NULL);



  if (param_tvb) {
    unsigned bitvalue = tvb_get_bits8(param_tvb, 0, 1);
    actx->created_item = proto_tree_add_uint(tree, hf_index, param_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_lpp_T_smoothingInterval_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     3, 3, false, NULL, 0, &param_tvb, NULL);



  if (param_tvb) {
    unsigned bitvalue = tvb_get_bits8(param_tvb, 0, 3);
    actx->created_item = proto_tree_add_uint(tree, hf_index, param_tvb, 0, 1, bitvalue);
  }

  return offset;
}


static const per_sequence_t GNSS_RTK_CommonObservationInfo_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_clockSteeringIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_externalClockIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_smoothingIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_smoothingIndicator_r15 },
  { &hf_lpp_smoothingInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_smoothingInterval_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_CommonObservationInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_CommonObservationInfo_r15, GNSS_RTK_CommonObservationInfo_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_NetworkID_r15_sequence[] = {
  { &hf_lpp_networkID_r15_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NetworkID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_NetworkID_r15, GNSS_NetworkID_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_SubNetworkID_r15_sequence[] = {
  { &hf_lpp_subNetworkID_r15_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SubNetworkID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SubNetworkID_r15, GNSS_SubNetworkID_r15_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M524288_524287(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -524288, 524287U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M4194304_4194303(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -4194304, 4194303U, NULL, false);

  return offset;
}


static const per_sequence_t Aux_ARP_Unc_r15_sequence[] = {
  { &hf_lpp_horizontalUncertainty_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_horizontalConfidence_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { &hf_lpp_verticalUncertainty_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_verticalConfidence_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Aux_ARP_Unc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Aux_ARP_Unc_r15, Aux_ARP_Unc_r15_sequence);

  return offset;
}


static const per_sequence_t AuxiliaryStationElement_r15_sequence[] = {
  { &hf_lpp_aux_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_aux_master_delta_latitude_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M524288_524287 },
  { &hf_lpp_aux_master_delta_longitude_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_aux_master_delta_height_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4194304_4194303 },
  { &hf_lpp_aux_ARP_unc_r15 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_Aux_ARP_Unc_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AuxiliaryStationElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AuxiliaryStationElement_r15, AuxiliaryStationElement_r15_sequence);

  return offset;
}


static const per_sequence_t AuxiliaryStationList_r15_sequence_of[1] = {
  { &hf_lpp_AuxiliaryStationList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_AuxiliaryStationElement_r15 },
};

static int
dissect_lpp_AuxiliaryStationList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_AuxiliaryStationList_r15, AuxiliaryStationList_r15_sequence_of,
                                                  1, 32, false);

  return offset;
}


static const per_sequence_t GNSS_RTK_AuxiliaryStationData_r15_sequence[] = {
  { &hf_lpp_networkID_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_NetworkID_r15 },
  { &hf_lpp_subNetworkID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SubNetworkID_r15 },
  { &hf_lpp_master_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_auxiliaryStationList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_AuxiliaryStationList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_AuxiliaryStationData_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_AuxiliaryStationData_r15, GNSS_RTK_AuxiliaryStationData_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistData_eag_1_sequence[] = {
  { &hf_lpp_gnss_RTK_ReferenceStationInfo_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15 },
  { &hf_lpp_gnss_RTK_CommonObservationInfo_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_CommonObservationInfo_r15 },
  { &hf_lpp_gnss_RTK_AuxiliaryStationData_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_AuxiliaryStationData_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistData_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M32768_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_M512_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -512, 511U, NULL, false);

  return offset;
}


static const per_sequence_t RelativeLocationElement_r16_sequence[] = {
  { &hf_lpp_deltaLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_deltaLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RelativeLocationElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RelativeLocationElement_r16, RelativeLocationElement_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16_sequence_of[1] = {
  { &hf_lpp_relativeLocationsList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_RelativeLocationElement_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16, SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16_sequence_of,
                                                  0, 63, false);

  return offset;
}


static const per_sequence_t GNSS_SSR_ListOfCorrectionPoints_r16_sequence[] = {
  { &hf_lpp_referencePointLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_referencePointLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_relativeLocationsList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ListOfCorrectionPoints_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ListOfCorrectionPoints_r16, GNSS_SSR_ListOfCorrectionPoints_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 511U, NULL, false);

  return offset;
}



static int
dissect_lpp_INTEGER_1_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1023U, NULL, false);

  return offset;
}


static const per_sequence_t GNSS_SSR_ArrayOfCorrectionPoints_r16_sequence[] = {
  { &hf_lpp_referencePointLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_referencePointLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_numberOfStepsLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_numberOfStepsLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_stepOfLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_511 },
  { &hf_lpp_stepOfLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_1023 },
  { &hf_lpp_bitmaskOfGrids_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_64 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16, GNSS_SSR_ArrayOfCorrectionPoints_r16_sequence);

  return offset;
}


static const value_string lpp_T_correctionPoints_r16_vals[] = {
  {   0, "listOfCorrectionPoints-r16" },
  {   1, "arrayOfCorrectionPoints-r1