/*
 * This file was generated by running ./tools/generate-bacnet-vendors.py
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * The BACNET Assigned Vendor IDs table is available at:
 * <https://bacnet.org/assigned-vendor-ids/>
 */

#include <wsutil/value_string.h>

static const value_string
BACnetVendorIdentifiers[] = {
    {    0, "ASHRAE" },
    {    1, "NIST" },
    {    2, "The Trane Company" },
    {    3, "Daikin Applied Americas" },
    {    4, "PolarSoft" },
    {    5, "Johnson Controls, Inc." },
    {    6, "ABB (Formerly American Auto-Matrix)" },
    {    7, "Siemens Schweiz AG" },
    {    8, "Delta Controls" },
    {    9, "Siemens Schweiz AG" },
    {   10, "Schneider Electric" },
    {   11, "TAC" },
    {   12, "Orion Analysis Corporation" },
    {   13, "Teletrol Systems Inc." },
    {   14, "Cimetrics Technology" },
    {   15, "Cornell University" },
    {   16, "United Technologies Carrier" },
    {   17, "Honeywell Inc." },
    {   18, "Alerton / Honeywell" },
    {   19, "TAC AB" },
    {   20, "Hewlett-Packard Company" },
    {   21, "Dorsette’s Inc." },
    {   22, "Siemens Schweiz AG" },
    {   23, "York Controls Group" },
    {   24, "Automated Logic Corporation" },
    {   25, "CSI Control Systems International" },
    {   26, "Phoenix Controls Corporation" },
    {   27, "Innovex Technologies, Inc." },
    {   28, "KMC Controls, Inc." },
    {   29, "Xn Technologies, Inc." },
    {   30, "Hyundai Information Technology Co., Ltd." },
    {   31, "Tokimec Inc." },
    {   32, "Simplex" },
    {   33, "North Building Technologies Limited" },
    {   34, "Notifier" },
    {   35, "Reliable Controls Corporation" },
    {   36, "Tridium Inc." },
    {   37, "MSA Safety" },
    {   38, "Silicon Energy" },
    {   39, "Kieback & Peter GmbH & Co KG" },
    {   40, "Anacon Systems, Inc." },
    {   41, "Systems Controls & Instruments, LLC" },
    {   42, "Acuity Brands Lighting, Inc." },
    {   43, "Micropower Manufacturing" },
    {   44, "Matrix Controls" },
    {   45, "METALAIRE" },
    {   46, "ESS Engineering" },
    {   47, "Sphere Systems Pty Ltd." },
    {   48, "Walker Technologies Corporation" },
    {   49, "H I Solutions, Inc." },
    {   50, "MBS GmbH" },
    {   51, "SAMSON AG" },
    {   52, "Badger Meter Inc." },
    {   53, "DAIKIN Industries Ltd." },
    {   54, "NARA Controls Inc." },
    {   55, "Mammoth Inc." },
    {   56, "Liebert Corporation" },
    {   57, "SEMCO Incorporated" },
    {   58, "Air Monitor Corporation" },
    {   59, "TRIATEK, LLC" },
    {   60, "NexLight" },
    {   61, "Multistack" },
    {   62, "TSI Incorporated" },
    {   63, "Weather-Rite, Inc." },
    {   64, "Dunham-Bush" },
    {   65, "Reliance Electric" },
    {   66, "LCS Inc." },
    {   67, "Regulator Australia PTY Ltd." },
    {   68, "Touch-Plate Lighting Controls" },
    {   69, "Amann GmbH" },
    {   70, "RLE Technologies" },
    {   71, "Cardkey Systems" },
    {   72, "SECOM Co., Ltd." },
    {   73, "ABB Gebäudetechnik AG Bereich NetServ" },
    {   74, "KNX Association cvba" },
    {   75, "Institute of Electrical Installation Engineers of Japan (IEIEJ)" },
    {   76, "Nohmi Bosai, Ltd." },
    {   77, "Carel Industries S.p.A." },
    {   78, "UTC Fire & Security España, S.L." },
    {   79, "Hochiki Corporation" },
    {   80, "Fr. Sauter AG" },
    {   81, "Matsushita Electric Works, Ltd." },
    {   82, "Mitsubishi Electric Corporation, Inazawa Works" },
    {   83, "Mitsubishi Heavy Industries, Ltd." },
    {   84, "Xylem, Inc." },
    {   85, "Yamatake Building Systems Co., Ltd." },
    {   86, "The Watt Stopper, Inc." },
    {   87, "Aichi Tokei Denki Co., Ltd." },
    {   88, "Activation Technologies, LLC" },
    {   89, "Saia-Burgess Controls, Ltd." },
    {   90, "Hitachi, Ltd." },
    {   91, "Novar Corp./Trend Control Systems Ltd." },
    {   92, "Mitsubishi Electric Lighting Corporation" },
    {   93, "Argus Control Systems, Ltd." },
    {   94, "Kyuki Corporation" },
    {   95, "Richards-Zeta Building Intelligence, Inc." },
    {   96, "Scientech R&D, Inc." },
    {   97, "VCI Controls, Inc." },
    {   98, "Toshiba Corporation" },
    {   99, "Mitsubishi Electric Corporation Air Conditioning & Refrigeration Systems Works" },
    {  100, "Custom Mechanical Equipment, LLC" },
    {  101, "ClimateMaster" },
    {  102, "ICP Panel-Tec, Inc." },
    {  103, "D-Tek Controls" },
    {  104, "NEC Engineering, Ltd." },
    {  105, "PRIVA BV" },
    {  106, "Meidensha Corporation" },
    {  107, "JCI Systems Integration Services" },
    {  108, "Freedom Corporation" },
    {  109, "Neuberger Gebäudeautomation GmbH" },
    {  110, "eZi Controls" },
    {  111, "Leviton Manufacturing" },
    {  112, "Fujitsu Limited" },
    {  113, "Vertiv (Formerly Emerson Network Power)" },
    {  114, "S. A. Armstrong, Ltd." },
    {  115, "Visonet AG" },
    {  116, "M&M Systems, Inc." },
    {  117, "Custom Software Engineering" },
    {  118, "Nittan Company, Limited" },
    {  119, "Elutions Inc. (Wizcon Systems SAS)" },
    {  120, "Pacom Systems Pty., Ltd." },
    {  121, "Unico, Inc." },
    {  122, "Ebtron, Inc." },
    {  123, "Scada Engine" },
    {  124, "Lenze Americas (Formerly: AC Technology Corporation)" },
    {  125, "Eagle Technology" },
    {  126, "Data Aire, Inc." },
    {  127, "ABB, Inc." },
    {  128, "Transbit Sp. z o. o." },
    {  129, "Carrier Japan Corporation" },
    {  130, "Shenzhen Junzhi Hi-Tech Co., Ltd." },
    {  131, "Tokai Soft" },
    {  132, "Blue Ridge Technologies" },
    {  133, "Veris Industries" },
    {  134, "Centaurus Prime" },
    {  135, "Sand Network Systems" },
    {  136, "Regulvar, Inc." },
    {  137, "AFDtek Division of Fastek International Inc." },
    {  138, "PowerCold Comfort Air Solutions, Inc." },
    {  139, "I Controls" },
    {  140, "Viconics Electronics, Inc." },
    {  141, "Yaskawa America, Inc." },
    {  142, "DEOS control systems GmbH" },
    {  143, "Digitale Mess- und Steuersysteme AG" },
    {  144, "Fujitsu General Limited" },
    {  145, "Project Engineering S.r.l." },
    {  146, "Sanyo Electric Co., Ltd." },
    {  147, "Integrated Information Systems, Inc." },
    {  148, "Temco Controls, Ltd." },
    {  149, "Airtek International Inc." },
    {  150, "Advantech Corporation" },
    {  151, "Titan Products, Ltd." },
    {  152, "Regel Partners" },
    {  153, "National Environmental Product" },
    {  154, "Unitec Corporation" },
    {  155, "Kanden Engineering Company" },
    {  156, "Messner Gebäudetechnik GmbH" },
    {  157, "Integrated.CH" },
    {  158, "Price Industries" },
    {  159, "SE-Elektronic GmbH" },
    {  160, "Rockwell Automation" },
    {  161, "Enflex Corp." },
    {  162, "ASI Controls" },
    {  163, "SysMik GmbH Dresden" },
    {  164, "HSC Regelungstechnik GmbH" },
    {  165, "Smart Temp Australia Pty. Ltd." },
    {  166, "Cooper Controls" },
    {  167, "Duksan Mecasys Co., Ltd." },
    {  168, "Fuji IT Co., Ltd." },
    {  169, "Vacon Plc" },
    {  170, "Leader Controls" },
    {  171, "ABB (Formerly Cylon Controls, Ltd)" },
    {  172, "Compas" },
    {  173, "Mitsubishi Electric Building Techno-Service Co., Ltd." },
    {  174, "Building Control Integrators" },
    {  175, "ITG Worldwide (M) Sdn Bhd" },
    {  176, "Lutron Electronics Co., Inc." },
    {  177, "Cooper-Atkins Corporation" },
    {  178, "LOYTEC Electronics GmbH" },
    {  179, "ProLon" },
    {  180, "Mega Controls Limited" },
    {  181, "Micro Control Systems, Inc." },
    {  182, "Kiyon, Inc." },
    {  183, "Dust Networks" },
    {  184, "Advanced Building Automation Systems" },
    {  185, "Hermos AG" },
    {  186, "CEZIM" },
    {  187, "Softing" },
    {  188, "Lynxspring, Inc." },
    {  189, "Schneider Toshiba Inverter Europe" },
    {  190, "Danfoss Drives A/S" },
    {  191, "Eaton Corporation" },
    {  192, "Matyca S.A." },
    {  193, "Botech AB" },
    {  194, "Noveo, Inc." },
    {  195, "AMEV" },
    {  196, "Yokogawa Electric Corporation" },
    {  197, "Bosch Building Automation GmbH" },
    {  198, "Exact Logic" },
    {  199, "Mass Electronics Pty Ltd dba Innotech Control Systems Australia" },
    {  200, "Kandenko Co., Ltd." },
    {  201, "DTF, Daten-Technik Fries" },
    {  202, "Klimasoft, Ltd." },
    {  203, "Toshiba Schneider Inverter Corporation" },
    {  204, "Control Applications, Ltd." },
    {  205, "CIMON CO., Ltd." },
    {  206, "Onicon Incorporated" },
    {  207, "Automation Displays, Inc." },
    {  208, "Control Solutions, Inc." },
    {  209, "Remsdaq Limited" },
    {  210, "NTT Facilities, Inc." },
    {  211, "VIPA GmbH" },
    {  212, "TSC21 Association of Japan" },
    {  213, "Strato Automation" },
    {  214, "HRW Limited" },
    {  215, "Lighting Control & Design, Inc." },
    {  216, "Mercy Electronic and Electrical Industries" },
    {  217, "Samsung SDS Co., Ltd" },
    {  218, "Impact Facility Solutions, Inc." },
    {  219, "Aircuity" },
    {  220, "Control Techniques, Ltd." },
    {  221, "OpenGeneral Pty., Ltd." },
    {  222, "WAGO Kontakttechnik GmbH & Co. KG" },
    {  223, "Franklin Electric" },
    {  224, "Chloride Power Protection Company" },
    {  225, "Computrols, Inc." },
    {  226, "Phoenix Contact GmbH & Co. KG" },
    {  227, "Grundfos Management A/S" },
    {  228, "Ridder Drive Systems" },
    {  229, "Soft Device SDN BHD" },
    {  230, "Integrated Control Technology Limited" },
    {  231, "AIRxpert Systems, Inc." },
    {  232, "Microtrol Limited" },
    {  233, "Red Lion Controls" },
    {  234, "Digital Electronics Corporation" },
    {  235, "Ennovatis GmbH" },
    {  236, "Serotonin Software Technologies, Inc." },
    {  237, "LS Industrial Systems Co., Ltd." },
    {  238, "Square D Company" },
    {  239, "S Squared Innovations, Inc." },
    {  240, "Aricent Ltd." },
    {  241, "EtherMetrics, LLC" },
    {  242, "Industrial Control Communications, Inc." },
    {  243, "Paragon Controls, Inc." },
    {  244, "A. O. Smith Corporation" },
    {  245, "Contemporary Control Systems, Inc." },
    {  246, "HMS Industrial Networks SLU" },
    {  247, "Ingenieurgesellschaft N. Hartleb mbH" },
    {  248, "Heat-Timer Corporation" },
    {  249, "Ingrasys Technology, Inc." },
    {  250, "Costerm Building Automation" },
    {  251, "WILO SE" },
    {  252, "Embedia Technologies Corp." },
    {  253, "Technilog" },
    {  254, "HR Controls Ltd. & Co. KG" },
    {  255, "Lennox International, Inc." },
    {  256, "RK-Tec Rauchklappen-Steuerungssysteme GmbH & Co. KG" },
    {  257, "Thermomax, Ltd." },
    {  258, "ELCON Electronic Control, Ltd." },
    {  259, "Larmia Control AB" },
    {  260, "BACnet Stack at SourceForge" },
    {  261, "G4S Security Services A/S" },
    {  262, "Exor International S.p.A." },
    {  263, "Cristal Controles" },
    {  264, "Regin AB" },
    {  265, "Dimension Software, Inc." },
    {  266, "SynapSense Corporation" },
    {  267, "Beijing Nantree Electronic Co., Ltd." },
    {  268, "Camus Hydronics Ltd." },
    {  269, "Kawasaki Heavy Industries, Ltd." },
    {  270, "Critical Environment Technologies" },
    {  271, "ILSHIN IBS Co., Ltd." },
    {  272, "ELESTA Energy Control AG" },
    {  273, "KROPMAN Installatietechniek" },
    {  274, "Baldor Electric Company" },
    {  275, "INGA mbH" },
    {  276, "GE Consumer & Industrial" },
    {  277, "Functional Devices, Inc." },
    {  278, "StudioSC" },
    {  279, "MG CO., LTD." },
    {  280, "Yokota Co., Ltd." },
    {  281, "Hitranse Technology Co., LTD" },
    {  282, "Vigilent Corporation" },
    {  283, "Kele, Inc." },
    {  284, "BELIMO Automation AG" },
    {  285, "Gentec" },
    {  286, "Embedded Science Labs, LLC" },
    {  287, "Parker Hannifin Corporation" },
    {  288, "MaCaPS International Limited" },
    {  289, "Link4 Corporation" },
    {  290, "Romutec Steuer-u. Regelsysteme GmbH" },
    {  291, "Pribusin, Inc." },
    {  292, "Advantage Controls" },
    {  293, "Critical Room Control" },
    {  294, "LEGRAND" },
    {  295, "Tongdy Control Technology Co., Ltd." },
    {  296, "ISSARO Integrierte Systemtechnik" },
    {  297, "Pro-Dev Industries" },
    {  298, "DRI-STEEM" },
    {  299, "Creative Electronic GmbH" },
    {  300, "Swegon AB" },
    {  301, "FIRVENA s.r.o." },
    {  302, "Hitachi Appliances, Inc." },
    {  303, "Real Time Automation, Inc." },
    {  304, "ITEC Hankyu-Hanshin Co." },
    {  305, "Cyrus E&M Engineering Co., Ltd." },
    {  306, "Badger Meter" },
    {  307, "Cirrascale Corporation" },
    {  308, "Elesta GmbH Building Automation" },
    {  309, "Securiton" },
    {  310, "OSlsoft, Inc." },
    {  311, "Hanazeder Electronic GmbH" },
    {  312, "Honeywell Security Deutschland, Novar GmbH" },
    {  313, "Siemens Industry, Inc." },
    {  314, "ETM Professional Control GmbH" },
    {  315, "Meitav-tec, Ltd." },
    {  316, "Janitza Electronics GmbH" },
    {  317, "MKS Nordhausen" },
    {  318, "De Gier Drive Systems B.V." },
    {  319, "Cypress Envirosystems" },
    {  320, "SMARTron s.r.o." },
    {  321, "Verari Systems, Inc." },
    {  322, "K-W Electronic Service, Inc." },
    {  323, "ALFA-SMART Energy Management" },
    {  324, "Telkonet, Inc." },
    {  325, "Securiton GmbH" },
    {  326, "Cemtrex, Inc." },
    {  327, "Performance Technologies, Inc." },
    {  328, "Xtralis (Aust) Pty Ltd" },
    {  329, "TROX GmbH" },
    {  330, "Beijing Hysine Technology Co., Ltd" },
    {  331, "RCK Controls, Inc." },
    {  332, "Distech Controls SAS" },
    {  333, "Novar/Honeywell" },
    {  334, "S4 Integration Solutions" },
    {  335, "Schneider Electric" },
    {  336, "LHA Systems" },
    {  337, "GHM engineering Group, Inc." },
    {  338, "Cllimalux S.A." },
    {  339, "VAISALA Oyj" },
    {  340, "COMPLEX (Beijing) Technology, Co., LTD." },
    {  341, "SCADAmetrics" },
    {  342, "POWERPEG NSI Limited" },
    {  343, "BACnet Interoperability Testing Services, Inc." },
    {  344, "Teco a.s." },
    {  345, "Plexus Technology, Inc." },
    {  346, "Energy Focus, Inc." },
    {  347, "Powersmiths International Corp." },
    {  348, "Nichibei Co., Ltd." },
    {  349, "HKC Technology Ltd." },
    {  350, "Ovation Networks, Inc." },
    {  351, "Setra Systems" },
    {  352, "AVG Automation" },
    {  353, "ZXC Ltd." },
    {  354, "Byte Sphere" },
    {  355, "Generiton Co., Ltd." },
    {  356, "Holter Regelarmaturen GmbH & Co. KG" },
    {  357, "Bedford Instruments, LLC" },
    {  358, "Standair Inc." },
    {  359, "WEG Automation – R&D" },
    {  360, "Prolon Control Systems ApS" },
    {  361, "Inneasoft" },
    {  362, "ConneXSoft GmbH" },
    {  363, "CEAG Notlichtsysteme GmbH" },
    {  364, "Distech Controls Inc." },
    {  365, "Industrial Technology Research Institute" },
    {  366, "Mitsubishi Electric Iconics Digital Solutions" },
    {  367, "IQ Controls s.c." },
    {  368, "OJ Electronics A/S" },
    {  369, "Rolbit Ltd." },
    {  370, "Synapsys Solutions Ltd." },
    {  371, "ACME Engineering Prod. Ltd." },
    {  372, "Zener Electric Pty, Ltd." },
    {  373, "Selectronix, Inc." },
    {  374, "Gorbet & Banerjee, LLC." },
    {  375, "IME" },
    {  376, "Stephen H. Dawson Computer Service" },
    {  377, "Accutrol, LLC" },
    {  378, "Schneider Elektronik GmbH" },
    {  379, "Alpha-Inno Tec GmbH" },
    {  380, "ADMMicro, Inc." },
    {  381, "Greystone Energy Systems, Inc." },
    {  382, "CAP Technologie" },
    {  383, "KeRo Systems" },
    {  384, "Domat Control System s.r.o." },
    {  385, "Efektronics Pty. Ltd." },
    {  386, "Hekatron Vertriebs GmbH" },
    {  387, "Securiton AG" },
    {  388, "Carlo Gavazzi Controls SpA" },
    {  389, "Chipkin Automation Systems" },
    {  390, "Savant Systems, LLC" },
    {  391, "Simmtronic Lighting Controls" },
    {  392, "Abelko Innovation AB" },
    {  393, "Seresco Technologies Inc." },
    {  394, "IT Watchdogs" },
    {  395, "Automation Assist Japan Corp." },
    {  396, "Thermokon Sensortechnik GmbH" },
    {  397, "EGauge Systems, LLC" },
    {  398, "Quantum Automation (ASIA) PTE, Ltd." },
    {  399, "Toshiba Lighting & Technology Corp." },
    {  400, "SPIN Engenharia de Automação Ltda." },
    {  401, "Logistics Systems & Software Services India PVT. Ltd." },
    {  402, "Delta Controls Integration Products" },
    {  403, "Focus Media" },
    {  404, "LUMEnergi Inc." },
    {  405, "Kara Systems" },
    {  406, "RF Code, Inc." },
    {  407, "Fatek Automation Corp." },
    {  408, "JANDA Software Company, LLC" },
    {  409, "Open System Solutions Limited" },
    {  410, "Intelec Systems PTY Ltd." },
    {  411, "Ecolodgix, LLC" },
    {  412, "Douglas Lighting Controls" },
    {  413, "iSAtech GmbH" },
    {  414, "AREAL" },
    {  415, "Beckhoff Automation" },
    {  416, "IPAS GmbH" },
    {  417, "KE2 Therm Solutions" },
    {  418, "Base2Products" },
    {  419, "DTL Controls, LLC" },
    {  420, "INNCOM International, Inc." },
    {  421, "METZ CONNECT GmbH" },
    {  422, "Greentrol Automation, Inc" },
    {  423, "BELIMO Automation AG" },
    {  424, "Samsung Heavy Industries Co, Ltd" },
    {  425, "Triacta Power Technologies, Inc." },
    {  426, "Globestar Systems" },
    {  427, "MLB Advanced Media, LP" },
    {  428, "SWG Stuckmann Wirtschaftliche Gebäudesysteme GmbH" },
    {  429, "SensorSwitch" },
    {  430, "Multitek Power Limited" },
    {  431, "Integra Metering AG" },
    {  432, "LG Electronics Inc." },
    {  433, "Electronic Theatre Controls, Inc." },
    {  434, "Mitsubishi Electric Corporation Nagoya Works" },
    {  435, "Delta Electronics, Inc." },
    {  436, "Elma Kurtalj, Ltd." },
    {  437, "Tyco Fire & Security GmbH" },
    {  438, "Nedap Security Management" },
    {  439, "ESC Automation Inc." },
    {  440, "DSP4YOU Ltd." },
    {  441, "GE Sensing and Inspection Technologies" },
    {  442, "Embedded Systems SIA" },
    {  443, "BEFEGA GmbH" },
    {  444, "Baseline Inc." },
    {  445, "Key2Act" },
    {  446, "OEMCtrl" },
    {  447, "Clarkson Controls Limited" },
    {  448, "Rogerwell Control System Limited" },
    {  449, "SCL Elements" },
    {  450, "Hitachi Ltd." },
    {  451, "Newron System SA" },
    {  452, "BEVECO Gebouwautomatisering BV" },
    {  453, "Streamside Solutions" },
    {  454, "Yellowstone Soft" },
    {  455, "Oztech Intelligent Systems Pty Ltd." },
    {  456, "Novelan GmbH" },
    {  457, "Flexim Americas Corporation" },
    {  458, "ICP DAS Co., Ltd." },
    {  459, "CARMA Industries Inc." },
    {  460, "Log-One Ltd." },
    {  461, "TECO Electric & Machinery Co., Ltd." },
    {  462, "ConnectEx, Inc." },
    {  463, "Turbo DDC Südwest" },
    {  464, "Quatrosense Environmental Ltd." },
    {  465, "Fifth Light Technology Ltd." },
    {  466, "Scientific Solutions, Ltd." },
    {  467, "Controller Area Network Solutions (M) Sdn Bhd" },
    {  468, "RESOL – Elektronische Regelungen GmbH" },
    {  469, "RPBUS LLC" },
    {  470, "BRS Sistemas Eletronicos" },
    {  471, "WindowMaster A/S" },
    {  472, "Sunlux Technologies Ltd." },
    {  473, "Measurlogic" },
    {  474, "Frimat GmbH" },
    {  475, "Spirax Sarco" },
    {  476, "Luxtron" },
    {  477, "Raypak Inc" },
    {  478, "Air Monitor Corporation" },
    {  479, "Regler Och Webbteknik Sverige (ROWS)" },
    {  480, "Intelligent Lighting Controls Inc." },
    {  481, "Sanyo Electric Industry Co., Ltd" },
    {  482, "E-Mon Energy Monitoring Products" },
    {  483, "Digital Control Systems" },
    {  484, "ATI Airtest Technologies, Inc." },
    {  485, "SCS SA" },
    {  486, "HMS Industrial Networks AB" },
    {  487, "Shenzhen Universal Intellisys Co Ltd" },
    {  488, "EK Intellisys Sdn Bhd" },
    {  489, "SysCom" },
    {  490, "Firecom, Inc." },
    {  491, "ESA Elektroschaltanlagen Grimma GmbH" },
    {  492, "Kumahira Co Ltd" },
    {  493, "Hotraco" },
    {  494, "SABO Elektronik GmbH" },
    {  495, "Equip’Trans" },
    {  496, "Temperature Control Specialities Co., Inc (TCS)" },
    {  497, "FlowCon International A/S" },
    {  498, "ThyssenKrupp Elevator Americas" },
    {  499, "Abatement Technologies" },
    {  500, "Continental Control Systems, LLC" },
    {  501, "WISAG Automatisierungstechnik GmbH & Co KG" },
    {  502, "EasyIO" },
    {  503, "EAP-Electric GmbH" },
    {  504, "Hardmeier" },
    {  505, "Mircom Group of Companies" },
    {  506, "Quest Controls" },
    {  507, "Mestek, Inc" },
    {  508, "Pulse Energy" },
    {  509, "Tachikawa Corporation" },
    {  510, "University of Nebraska-Lincoln" },
    {  511, "Redwood Systems" },
    {  512, "PASStec Industrie-Elektronik GmbH" },
    {  513, "NgEK, Inc." },
    {  514, "t-mac Technologies" },
    {  515, "Jireh Energy Tech Co., Ltd." },
    {  516, "Enlighted Inc." },
    {  517, "El-Piast Sp. Z o.o" },
    {  518, "NetxAutomation Software GmbH" },
    {  519, "Invertek Drives" },
    {  520, "Deutschmann Automation GmbH & Co. KG" },
    {  521, "EMU Electronic AG" },
    {  522, "Phaedrus Limited" },
    {  523, "Sigmatek GmbH & Co KG" },
    {  524, "Marlin Controls" },
    {  525, "Circutor, SA" },
    {  526, "UTC Fire & Security" },
    {  527, "DENT Instruments, Inc." },
    {  528, "FHP Manufacturing Company – Bosch Group" },
    {  529, "GE Intelligent Platforms" },
    {  530, "Inner Range Pty Ltd" },
    {  531, "GLAS Energy Technology" },
    {  532, "MSR-Electronic-GmbH" },
    {  533, "Energy Control Systems, Inc." },
    {  534, "EMT Controls" },
    {  535, "Daintree" },
    {  536, "EURO ICC d.o.o" },
    {  537, "TE Connectivity Energy" },
    {  538, "GEZE GmbH" },
    {  539, "NEC Corporation" },
    {  540, "Ho Cheung International Company Limited" },
    {  541, "Sharp Manufacturing Systems Corporation" },
    {  542, "DOT CONTROLS a.s." },
    {  543, "BeaconMedæs" },
    {  544, "Midea Commercial Aircon" },
    {  545, "AAON" },
    {  546, "Kamstrup A/S" },
    {  547, "CA Computer Automation GmbH" },
    {  548, "Laars Heating Systems Company" },
    {  549, "Hitachi Systems, Ltd." },
    {  550, "Fushan AKE Electronic Engineering Co., Ltd." },
    {  551, "Toshiba International Corporation" },
    {  552, "Starman Systems, LLC" },
    {  553, "Samsung Techwin Co., Ltd." },
    {  554, "ISAS-Integrated Switchgear and Systems P/L" },
    {  555, "Reserved for ASHRAE" },
    {  556, "Obvius" },
    {  557, "Marek Guzik" },
    {  558, "Vortek Instruments, LLC" },
    {  559, "Universal Lighting Technologies" },
    {  560, "Myers Power Products, Inc." },
    {  561, "Vector Controls GmbH" },
    {  562, "Crestron Electronics, Inc." },
    {  563, "A&E Controls Limited" },
    {  564, "Projektomontaza A.D." },
    {  565, "Freeaire Refrigeration" },
    {  566, "Aqua Cooler Pty Limited" },
    {  567, "Basic Controls" },
    {  568, "GE Measurement and Control Solutions Advanced Sensors" },
    {  569, "EQUAL Networks" },
    {  570, "Millennial Net" },
    {  571, "APLI Ltd" },
    {  572, "Electro Industries/GaugeTech" },
    {  573, "SangMyung University" },
    {  574, "Coppertree Analytics, Inc." },
    {  575, "CoreNetiX GmbH" },
    {  576, "Acutherm" },
    {  577, "Dr. Riedel Automatisierungstechnik GmbH" },
    {  578, "Shina System Co., Ltd" },
    {  579, "Iqapertus" },
    {  580, "PSE Technology" },
    {  581, "BA Systems" },
    {  582, "BTICINO" },
    {  583, "Monico, Inc." },
    {  584, "iCue" },
    {  585, "tekmar Control Systems Ltd." },
    {  586, "Control Technology Corporation" },
    {  587, "GFAE GmbH" },
    {  588, "BeKa Software GmbH" },
    {  589, "Isoil Industria SpA" },
    {  590, "Home Systems Consulting SpA" },
    {  591, "Socomec" },
    {  592, "Everex Communications, Inc." },
    {  593, "CET Electric Technology, Inc." },
    {  594, "Atrila GmbH" },
    {  595, "WingTechs" },
    {  596, "Shenzhen Mek Intellisys Pte Ltd." },
    {  597, "Nestfield Co., Ltd." },
    {  598, "Swissphone Telecom AG" },
    {  599, "PNTECH JSC" },
    {  600, "Horner APG, LLC" },
    {  601, "PVI Industries, LLC" },
    {  602, "Ela-compil" },
    {  603, "Pegasus Automation International LLC" },
    {  604, "Wight Electronic Services Ltd." },
    {  605, "Marcom" },
    {  606, "Exhausto A/S" },
    {  607, "Dwyer Instruments, Inc." },
    {  608, "Link GmbH" },
    {  609, "Oppermann Regelgerate GmbH" },
    {  610, "NuAire, Inc." },
    {  611, "Nortec Humidity, Inc." },
    {  612, "Bigwood Systems, Inc." },
    {  613, "Enbala Power Networks" },
    {  614, "Inter Energy Co., Ltd." },
    {  615, "ETC" },
    {  616, "COMELEC S.A.R.L" },
    {  617, "Pythia Technologies" },
    {  618, "TrendPoint Systems, Inc." },
    {  619, "AWEX" },
    {  620, "Eurevia" },
    {  621, "Kongsberg E-lon AS" },
    {  622, "FlaktWoods" },
    {  623, "E + E Elektronik GES M.B.H." },
    {  624, "ARC Informatique" },
    {  625, "SKIDATA AG" },
    {  626, "WSW Solutions" },
    {  627, "Trefon Electronic GmbH" },
    {  628, "Dongseo System" },
    {  629, "Kanontec Intelligence Technology Co., Ltd." },
    {  630, "EVCO S.p.A." },
    {  631, "Accuenergy (Canada) Inc." },
    {  632, "SoftDEL" },
    {  633, "Orion Energy Systems, Inc." },
    {  634, "Roboticsware" },
    {  635, "DOMIQ Sp. z o.o." },
    {  636, "Solidyne" },
    {  637, "Elecsys Corporation" },
    {  638, "Conditionaire International Pty. Limited" },
    {  639, "Quebec, Inc." },
    {  640, "Homerun Holdings" },
    {  641, "Murata Americas" },
    {  642, "Comptek" },
    {  643, "Westco Systems, Inc." },
    {  644, "Advancis Software & Services GmbH" },
    {  645, "Intergrid, LLC" },
    {  646, "Markerr Controls, Inc." },
    {  647, "Toshiba Elevator and Building Systems Corporation" },
    {  648, "Spectrum Controls, Inc." },
    {  649, "Mkservice" },
    {  650, "Fox Thermal Instruments" },
    {  651, "SyxthSense Ltd" },
    {  652, "DUHA System S R.O." },
    {  653, "NIBE" },
    {  654, "Melink Corporation" },
    {  655, "Fritz-Haber-Institut" },
    {  656, "MTU Onsite Energy GmbH, Gas Power Systems" },
    {  657, "Omega Engineering, Inc." },
    {  658, "Avelon" },
    {  659, "Ywire Technologies, Inc." },
    {  660, "M.R. Engineering Co., Ltd." },
    {  661, "Lochinvar, LLC" },
    {  662, "Sontay Limited" },
    {  663, "GRUPA Slawomir Chelminski" },
    {  664, "Arch Meter Corporation" },
    {  665, "Senva, Inc." },
    {  666, "Reserved for ASHRAE" },
    {  667, "FM-Tec" },
    {  668, "Systems Specialists, Inc." },
    {  669, "SenseAir" },
    {  670, "AB IndustrieTechnik Srl" },
    {  671, "Cortland Research, LLC" },
    {  672, "MediaView" },
    {  673, "VDA Elettronica" },
    {  674, "CSS, Inc." },
    {  675, "Tek-Air Systems, Inc." },
    {  676, "ICDT" },
    {  677, "The Armstrong Monitoring Corporation" },
    {  678, "DIXELL S.r.l" },
    {  679, "Lead System, Inc." },
    {  680, "ISM EuroCenter S.A." },
    {  681, "TDIS" },
    {  682, "Trade FIDES" },
    {  683, "Knürr GmbH (Emerson Network Power)" },
    {  684, "Resource Data Management" },
    {  685, "Abies Technology, Inc." },
    {  686, "UAB Komfovent" },
    {  687, "MIRAE Electrical Mfg. Co., Ltd." },
    {  688, "HunterDouglas Architectural Projects Scandinavia ApS" },
    {  689, "RUNPAQ Group Co., Ltd" },
    {  690, "Unicard SA" },
    {  691, "IE Technologies" },
    {  692, "Ruskin Manufacturing" },
    {  693, "Calon Associates Limited" },
    {  694, "Contec Co., Ltd." },
    {  695, "iT GmbH" },
    {  696, "Autani Corporation" },
    {  697, "Christian Fortin" },
    {  698, "HDL" },
    {  699, "IPID Sp. Z.O.O Limited" },
    {  700, "Fuji Electric Co., Ltd" },
    {  701, "View, Inc." },
    {  702, "Samsung S1 Corporation" },
    {  703, "New Lift" },
    {  704, "VRT Systems" },
    {  705, "Motion Control Engineering, Inc." },
    {  706, "Weiss Klimatechnik GmbH" },
    {  707, "Elkon" },
    {  708, "Eliwell Controls S.r.l." },
    {  709, "Japan Computer Technos Corp" },
    {  710, "Rational Network ehf" },
    {  711, "Magnum Energy Solutions, LLC" },
    {  712, "MelRok" },
    {  713, "VAE Group" },
    {  714, "LGCNS" },
    {  715, "Berghof Automationstechnik GmbH" },
    {  716, "Quark Communications, Inc." },
    {  717, "Sontex" },
    {  718, "mivune AG" },
    {  719, "Panduit" },
    {  720, "Smart Controls, LLC" },
    {  721, "Compu-Aire, Inc." },
    {  722, "Sierra" },
    {  723, "ProtoSense Technologies" },
    {  724, "Eltrac Technologies Pvt Ltd" },
    {  725, "Bektas Invisible Controls GmbH" },
    {  726, "Entelec" },
    {  727, "INNEXIV" },
    {  728, "Covenant" },
    {  729, "Davitor AB" },
    {  730, "TongFang Technovator" },
    {  731, "Building Robotics, Inc." },
    {  732, "HSS-MSR UG" },
    {  733, "FramTack LLC" },
    {  734, "B. L. Acoustics, Ltd." },
    {  735, "Traxxon Rock Drills, Ltd" },
    {  736, "Franke" },
    {  737, "Wurm GmbH & Co" },
    {  738, "AddENERGIE" },
    {  739, "Mirle Automation Corporation" },
    {  740, "Ibis Networks" },
    {  741, "ID-KARTA s.r.o." },
    {  742, "Anaren, Inc." },
    {  743, "Span, Incorporated" },
    {  744, "Bosch Thermotechnology Corp" },
    {  745, "DRC Technology S.A." },
    {  746, "Shanghai Energy Building Technology Co, Ltd" },
    {  747, "Fraport AG" },
    {  748, "Flowgroup" },
    {  749, "Skytron Energy, GmbH" },
    {  750, "ALTEL Wicha, Golda Sp. J." },
    {  751, "Drupal" },
    {  752, "Axiomatic Technology, Ltd" },
    {  753, "Bohnke + Partner" },
    {  754, "Function1" },
    {  755, "Optergy Pty, Ltd" },
    {  756, "LSI Virticus" },
    {  757, "Konzeptpark GmbH" },
    {  758, "NX Lighting Controls" },
    {  759, "eCurv, Inc." },
    {  760, "Agnosys GmbH" },
    {  761, "Shanghai Sunfull Automation Co., LTD" },
    {  762, "Kurz Instruments, Inc." },
    {  763, "Cias Elettronica S.r.l." },
    {  764, "Multiaqua, Inc." },
    {  765, "BlueBox" },
    {  766, "Sensidyne" },
    {  767, "Viessmann Elektronik GmbH" },
    {  768, "ADFweb.com srl" },
    {  769, "Gaylord Industries" },
    {  770, "Majur Ltd." },
    {  771, "Shanghai Huilin Technology Co., Ltd." },
    {  772, "Exotronic" },
    {  773, "SAFECONTROL s.r.o." },
    {  774, "Amatis" },
    {  775, "Universal Electric Corporation" },
    {  776, "iBACnet" },
    {  777, "Reserved for ASHRAE" },
    {  778, "Smartrise Engineering, Inc." },
    {  779, "Miratron, Inc." },
    {  780, "SmartEdge" },
    {  781, "Mitsubishi Electric Australia Pty Ltd" },
    {  782, "Triangle Research International Ptd Ltd" },
    {  783, "Produal Oy" },
    {  784, "Milestone Systems A/S" },
    {  785, "Trustbridge" },
    {  786, "Feedback Solutions" },
    {  787, "IES" },
    {  788, "ABB Power Protection SA" },
    {  789, "Riptide IO" },
    {  790, "Messerschmitt Systems AG" },
    {  791, "Dezem Energy Controlling" },
    {  792, "MechoSystems" },
    {  793, "evon GmbH" },
    {  794, "CS Lab GmbH" },
    {  795, "8760 Enterprises, Inc." },
    {  796, "Touche Controls" },
    {  797, "Ontrol Teknik Malzeme San. ve Tic. A.S." },
    {  798, "Uni Control System Sp. Z o.o." },
    {  799, "Weihai Ploumeter Co., Ltd" },
    {  800, "Elcom International Pvt. Ltd" },
    {  801, "Signify" },
    {  802, "AutomationDirect" },
    {  803, "Paragon Robotics" },
    {  804, "SMT System & Modules Technology AG" },
    {  805, "Radix IoT LLC" },
    {  806, "CMR Controls Ltd" },
    {  807, "Innovari, Inc." },
    {  808, "ABB Control Products" },
    {  809, "Gesellschaft fur Gebäudeautomation mbH" },
    {  810, "RODI Systems Corp." },
    {  811, "Nextek Power Systems" },
    {  812, "Creative Lighting" },
    {  813, "WaterFurnace International" },
    {  814, "Mercury Security" },
    {  815, "Hisense (Shandong) Air-Conditioning Co., Ltd." },
    {  816, "Layered Solutions, Inc." },
    {  817, "Leegood Automatic System, Inc." },
    {  818, "Shanghai Restar Technology Co., Ltd." },
    {  819, "Reimann Ingenieurbüro" },
    {  820, "LynTec" },
    {  821, "HTP" },
    {  822, "Elkor Technologies, Inc." },
    {  823, "Bentrol Pty Ltd" },
    {  824, "Team-Control Oy" },
    {  825, "NextDevice, LLC" },
    {  826, "iSMA CONTROLLI S.p.a." },
    {  827, "King I Electronics Co., Ltd" },
    {  828, "SAMDAV" },
    {  829, "Next Gen Industries Pvt. Ltd." },
    {  830, "Entic LLC" },
    {  831, "ETAP" },
    {  832, "Moralle Electronics Limited" },
    {  833, "Leicom AG" },
    {  834, "Watts Regulator Company" },
    {  835, "S.C. Orbtronics S.R.L." },
    {  836, "Gaussan Technologies" },
    {  837, "WEBfactory GmbH" },
    {  838, "Ocean Controls" },
    {  839, "Messana Air-Ray Conditioning s.r.l." },
    {  840, "Hangzhou BATOWN Technology Co. Ltd." },
    {  841, "Reasonable Controls" },
    {  842, "Servisys, Inc." },
    {  843, "halstrup-walcher GmbH" },
    {  844, "SWG Automation Fuzhou Limited" },
    {  845, "KSB Aktiengesellschaft" },
    {  846, "Hybryd Sp. z o.o." },
    {  847, "Helvatron AG" },
    {  848, "Oderon Sp. Z.O.O." },
    {  849, "mikolab" },
    {  850, "Exodraft" },
    {  851, "Hochhuth GmbH" },
    {  852, "Integrated System Technologies Ltd." },
    {  853, "Shanghai Cellcons Controls Co., Ltd" },
    {  854, "Emme Controls, LLC" },
    {  855, "Field Diagnostic Services, Inc." },
    {  856, "Ges Teknik A.S." },
    {  857, "Global Power Products, Inc." },
    {  858, "Option NV" },
    {  859, "BV-Control AG" },
    {  860, "Sigren Engineering AG" },
    {  861, "Shanghai Jaltone Technology Co., Ltd." },
    {  862, "MaxLine Solutions Ltd" },
    {  863, "Kron Instrumentos Elétricos Ltda" },
    {  864, "Thermo Matrix" },
    {  865, "Infinite Automation Systems, Inc." },
    {  866, "Vantage" },
    {  867, "Elecon Measurements Pvt Ltd" },
    {  868, "TBA" },
    {  869, "Carnes Company" },
    {  870, "Harman Professional" },
    {  871, "Nenutec Asia Pacific Pte Ltd" },
    {  872, "Gia NV" },
    {  873, "Kepware Tehnologies" },
    {  874, "Temperature Electronics Ltd" },
    {  875, "Packet Power" },
    {  876, "Project Haystack Corporation" },
    {  877, "DEOS Controls Americas Inc." },
    {  878, "Senseware Inc" },
    {  879, "MST Systemtechnik AG" },
    {  880, "Lonix Ltd" },
    {  881, "Gossen Metrawatt GmbH" },
    {  882, "Aviosys International Inc." },
    {  883, "Efficient Building Automation Corp." },
    {  884, "Accutron Instruments Inc." },
    {  885, "Vermont Energy Control Systems LLC" },
    {  886, "DCC Dynamics" },
    {  887, "B.E.G. Brück Electronic GmbH" },
    {  888, "Reserved for ASHRAE" },
    {  889, "NGBS Hungary Ltd." },
    {  890, "ILLUM Technology, LLC" },
    {  891, "Delta Controls Germany Limited" },
    {  892, "S+T Service & Technique S.A." },
    {  893, "SimpleSoft" },
    {  894, "Altair Engineering" },
    {  895, "EZEN Solution Inc." },
    {  896, "Fujitec Co. Ltd." },
    {  897, "Terralux" },
    {  898, "Annicom" },
    {  899, "Bihl+Wiedemann GmbH" },
    {  900, "Draper, Inc." },
    {  901, "Schüco International KG" },
    {  902, "Otis Elevator Company" },
    {  903, "Fidelix Oy" },
    {  904, "RAM GmbH Mess- und Regeltechnik" },
    {  905, "WEMS" },
    {  906, "Ravel Electronics Pvt Ltd" },
    {  907, "OmniMagni" },
    {  908, "Echelon" },
    {  909, "Intellimeter Canada, Inc." },
    {  910, "Bithouse Oy" },
    {  911, "Reserved for ASHRAE" },
    {  912, "BuildPulse" },
    {  913, "Shenzhen 1000 Building Automation Co. Ltd" },
    {  914, "AED Engineering GmbH" },
    {  915, "Güntner GmbH & Co. KG" },
    {  916, "KNXlogic" },
    {  917, "CIM Environmental Group" },
    {  918, "Flow Control" },
    {  919, "Lumen Cache, Inc." },
    {  920, "Ecosystem" },
    {  921, "Potter Electric Signal Company, LLC" },
    {  922, "Tyco Fire & Security S.p.A." },
    {  923, "Watanabe Electric Industry Co., Ltd." },
    {  924, "Causam Energy" },
    {  925, "W-tec AG" },
    {  926, "IMI Hydronic Engineering International SA" },
    {  927, "ARIGO Software" },
    {  928, "MSA Safety" },
    {  929, "Smart Solucoes Ltda – MERCATO" },
    {  930, "PIATRA Engineering" },
    {  931, "ODIN Automation Systems, LLC" },
    {  932, "Belparts NV" },
    {  933, "UAB, SALDA" },
    {  934, "Alre-IT Regeltechnik GmbH" },
    {  935, "Ingenieurbüro H. Lertes GmbH & Co. KG" },
    {  936, "Breathing Buildings" },
    {  937, "eWON SA" },
    {  938, "Cav. Uff. Giacomo Cimberio S.p.A" },
    {  939, "PKE Electronics AG" },
    {  940, "Allen" },
    {  941, "Kastle Systems" },
    {  942, "Logical Electro-Mechanical (EM) Systems, Inc." },
    {  943, "ppKinetics Instruments, LLC" },
    {  944, "Cathexis Technologies" },
    {  945, "Sylop sp. Z o.o. sp.k" },
    {  946, "Brauns Control GmbH" },
    {  947, "OMRON SOCIAL SOLUTIONS CO., LTD." },
    {  948, "Wildeboer Bauteile Gmbh" },
    {  949, "Shanghai Biens Technologies Ltd" },
    {  950, "Beijing HZHY Technology Co., Ltd" },
    {  951, "Building Clouds" },
    {  952, "The University of Sheffield-Department of Electronic and Electrical Engineering" },
    {  953, "Fabtronics Australia Pty Ltd" },
    {  954, "SLAT" },
    {  955, "Software Motor Corporation" },
    {  956, "Armstrong International Inc." },
    {  957, "Steril-Aire, Inc." },
    {  958, "Infinique" },
    {  959, "Arcom" },
    {  960, "Argo Performance, Ltd" },
    {  961, "Dialight" },
    {  962, "Ideal Technical Solutions" },
    {  963, "Neurobat AG" },
    {  964, "Neyer Software Consulting LLC" },
    {  965, "SCADA Technology Development Co., Ltd." },
    {  966, "Demand Logic Limited" },
    {  967, "GWA Group Limited" },
    {  968, "Occitaline" },
    {  969, "NAO Digital Co., Ltd." },
    {  970, "Shenzhen Chanslink Network Technology Co., Ltd." },
    {  971, "Samsung Electronics Co., Ltd." },
    {  972, "Mesa Laboratories, Inc." },
    {  973, "Fischer" },
    {  974, "OpSys Solutions Ltd." },
    {  975, "Advanced Devices Limited" },
    {  976, "Condair" },
    {  977, "INELCOM Ingenieria Electronica Comercial S.A." },
    {  978, "GridPoint, Inc." },
    {  979, "ADF Technologies Sdn Bhd" },
    {  980, "EPM, Inc." },
    {  981, "Lighting Controls Ltd" },
    {  982, "Perix Controls Ltd." },
    {  983, "AERCO International, Inc." },
    {  984, "KONE Inc." },
    {  985, "Ziehl-Abegg SE" },
    {  986, "Robot, S.A." },
    {  987, "Optigo Networks, Inc." },
    {  988, "Openmotics BVBA" },
    {  989, "Metropolitan Industries, Inc." },
    {  990, "Huawei Technologies Co., Ltd." },
    {  991, "Digital Lumens, Inc." },
    {  992, "Vanti" },
    {  993, "Cree Lighting" },
    {  994, "Richmond Heights SDN BHD" },
    {  995, "Payne-Sparkman Lighting Mangement" },
    {  996, "Ashcroft" },
    {  997, "Jet Controls Corp" },
    {  998, "Zumtobel Lighting GmbH" },
    {  999, "Reserved for ASHRAE" },
    { 1000, "Ekon GmbH" },
    { 1001, "Molex" },
    { 1002, "Maco Lighting Pty Ltd." },
    { 1003, "Axecon Corp." },
    { 1004, "Tensor plc" },
    { 1005, "Kaseman Environmental Control Equipment (Shanghai) Limited" },
    { 1006, "AB Axis Industries" },
    { 1007, "Netix Controls" },
    { 1008, "Eldridge Products, Inc." },
    { 1009, "Micronics" },
    { 1010, "Fortecho Solutions Ltd" },
    { 1011, "Sellers Manufacturing Company" },
    { 1012, "Rite-Hite Doors, Inc." },
    { 1013, "Violet Defense LLC" },
    { 1014, "Simna" },
    { 1015, "Multi-Énergie Best Inc." },
    { 1016, "Mega System Technologies, Inc." },
    { 1017, "Rheem" },
    { 1018, "Ing. Punzenberger COPA-DATA GmbH" },
    { 1019, "MEC Electronics GmbH" },
    { 1020, "Taco Comfort Solutions" },
    { 1021, "Alexander Maier GmbH" },
    { 1022, "Ecorithm, Inc." },
    { 1023, "Accurro Ltd" },
    { 1024, "ROMTECK Australia Pty Ltd" },
    { 1025, "Splash Monitoring Limited" },
    { 1026, "Light Application" },
    { 1027, "Logical Building Automation" },
    { 1028, "Exilight Oy" },
    { 1029, "Hager Electro SAS" },
    { 1030, "KLIF Co., LTD" },
    { 1031, "HygroMatik" },
    { 1032, "Daniel Mousseau Programmation & Electronique" },
    { 1033, "Aerionics Inc." },
    { 1034, "M2S Electronique Ltee" },
    { 1035, "Automation Components, Inc." },
    { 1036, "Niobrara Research & Development Corporation" },
    { 1037, "Netcom Sicherheitstechnik GmbH" },
    { 1038, "Lumel S.A." },
    { 1039, "Great Plains Industries, Inc." },
    { 1040, "Domotica Labs S.R.L" },
    { 1041, "Energy Cloud, Inc." },
    { 1042, "Vomatec" },
    { 1043, "Demma Companies" },
    { 1044, "Valsena" },
    { 1045, "Comsys Bärtsch AG" },
    { 1046, "bGrid" },
    { 1047, "MDJ Software Pty Ltd" },
    { 1048, "Dimonoff, Inc." },
    { 1049, "Edomo Systems, GmbH" },
    { 1050, "Effektiv, LLC" },
    { 1051, "SteamOVap" },
    { 1052, "grandcentrix GmbH" },
    { 1053, "Weintek Labs, Inc." },
    { 1054, "Intefox GmbH" },
    { 1055, "Radius22 Automation Company" },
    { 1056, "Ringdale, Inc." },
    { 1057, "Iwaki America" },
    { 1058, "Bractlet" },
    { 1059, "STULZ Air Technology Systems, Inc." },
    { 1060, "Climate Ready Engineering Pty Ltd" },
    { 1061, "Genea Energy Partners" },
    { 1062, "IoTall Chile" },
    { 1063, "IKS Co., Ltd." },
    { 1064, "Yodiwo AB" },
    { 1065, "TITAN electronic GmbH" },
    { 1066, "IDEC Corporation" },
    { 1067, "SIFRI SL" },
    { 1068, "Thermal Gas Systems Inc." },
    { 1069, "Building Automation Products, Inc." },
    { 1070, "Asset Mapping" },
    { 1071, "Smarteh Company" },
    { 1072, "Datapod (Australia) Pty Ltd." },
    { 1073, "Buildings Alive Pty Ltd" },
    { 1074, "Digital Elektronik" },
    { 1075, "Talent Automação e Tecnologia Ltda" },
    { 1076, "Norposh Limited" },
    { 1077, "Merkur Funksysteme AG" },
    { 1078, "Faster CZ spol. S.r.o" },
    { 1079, "Eco-Adapt" },
    { 1080, "Energocentrum Plus, s.r.o" },
    { 1081, "amBX UK Ltd" },
    { 1082, "Western Reserve Controls, Inc." },
    { 1083, "LayerZero Power Systems, Inc." },
    { 1084, "CIC Jan Hřebec s.r.o." },
    { 1085, "Sigrov BV" },
    { 1086, "ISYS-Intelligent Systems" },
    { 1087, "Gas Detection (Australia) Pty Ltd" },
    { 1088, "Kinco Automation (Shanghai) Ltd." },
    { 1089, "Lars Energy, LLC" },
    { 1090, "Flamefast (UK) Ltd." },
    { 1091, "Royal Service Air Conditioning" },
    { 1092, "Ampio Sp. Z o.o." },
    { 1093, "Inovonics Wireless Corporation" },
    { 1094, "Nvent Thermal Management" },
    { 1095, "Sinowell Control System Ltd" },
    { 1096, "Moxa Inc." },
    { 1097, "Matrix iControl SDN BHD" },
    { 1098, "PurpleSwift" },
    { 1099, "OTIM Technologies" },
    { 1100, "FlowMate Limited" },
    { 1101, "Degree Controls, Inc." },
    { 1102, "Fei Xing (Shanghai) Software Technologies Co., Ltd." },
    { 1103, "Berg GmbH" },
    { 1104, "ARENZ.IT" },
    { 1105, "Edelstrom Electronic Devices & Designing LLC" },
    { 1106, "Drive Connect, LLC" },
    { 1107, "DevelopNow" },
    { 1108, "Poort" },
    { 1109, "VMEIL Information (Shanghai) Ltd" },
    { 1110, "Rayleigh Instruments" },
    { 1111, "Reserved for ASHRAE" },
    { 1112, "CODESYS Development" },
    { 1113, "Smartware Technologies Group, LLC" },
    { 1114, "Polar Bear Solutions" },
    { 1115, "Codra" },
    { 1116, "Pharos Architectural Controls Ltd" },
    { 1117, "EngiNear Ltd." },
    { 1118, "Ad Hoc Electronics" },
    { 1119, "Unified Microsystems" },
    { 1120, "Industrieelektronik Brandenburg GmbH" },
    { 1121, "Hartmann GmbH" },
    { 1122, "Piscada" },
    { 1123, "KMB systems, s.r.o." },
    { 1124, "PowerTech Engineering AS" },
    { 1125, "Telefonbau Arthur Schwabe GmbH & Co. KG" },
    { 1126, "Wuxi Fistwelove Technology Co., Ltd." },
    { 1127, "Prysm" },
    { 1128, "STEINEL GmbH" },
    { 1129, "Georg Fischer JRG AG" },
    { 1130, "Make Develop SL" },
    { 1131, "Monnit Corporation" },
    { 1132, "Mirror Life Corporation" },
    { 1133, "Secure Meters Limited" },
    { 1134, "PECO" },
    { 1135, ".CCTECH, Inc." },
    { 1136, "LightFi Limited" },
    { 1137, "Nice Spa" },
    { 1138, "Fiber SenSys, Inc." },
    { 1139, "B&D Buchta und Degeorgi" },
    { 1140, "Ventacity Systems, Inc." },
    { 1141, "Hitachi-Johnson Controls Air Conditioning, Inc." },
    { 1142, "Sage Metering, Inc." },
    { 1143, "Andel Limited" },
    { 1144, "ECOSmart Technologies" },
    { 1145, "S.E.T." },
    { 1146, "Protec Fire Detection Spain SL" },
    { 1147, "AGRAMER UG" },
    { 1148, "Anylink Electronic GmbH" },
    { 1149, "Schindler, Ltd" },
    { 1150, "Jibreel Abdeen Est." },
    { 1151, "Fluidyne Control Systems Pvt. Ltd" },
    { 1152, "Prism Systems, Inc." },
    { 1153, "Enertiv" },
    { 1154, "Mirasoft GmbH & Co. KG" },
    { 1155, "DUALTECH IT" },
    { 1156, "Countlogic, LLC" },
    { 1157, "Kohler" },
    { 1158, "Chen Sen Controls Co., Ltd." },
    { 1159, "Greenheck" },
    { 1160, "Intwine Connect, LLC" },
    { 1161, "Karlborgs Elkontroll" },
    { 1162, "Datakom" },
    { 1163, "Hoga Control AS" },
    { 1164, "Cool Automation" },
    { 1165, "Inter Search Co., Ltd" },
    { 1166, "DABBEL-Automation Intelligence GmbH" },
    { 1167, "Gadgeon Engineering Smartness" },
    { 1168, "Coster Group S.r.l." },
    { 1169, "Walter Müller AG" },
    { 1170, "Fluke" },
    { 1171, "Quintex Systems Ltd" },
    { 1172, "Senfficient SDN BHD" },
    { 1173, "Nube iO Operations Pty Ltd" },
    { 1174, "DAS Integrator Pte Ltd" },
    { 1175, "CREVIS Co., Ltd" },
    { 1176, "iSquared software inc." },
    { 1177, "KTG GmbH" },
    { 1178, "POK Group Oy" },
    { 1179, "Adiscom" },
    { 1180, "Incusense" },
    { 1181, "75F" },
    { 1182, "Anord Mardix, Inc." },
    { 1183, "HOSCH Gebäudeautomation Neue Produkte GmbH" },
    { 1184, "Bosch.IO GmbH" },
    { 1185, "Royal Boon Edam International B.V." },
    { 1186, "Clack Corporation" },
    { 1187, "Unitex Controls LLC" },
    { 1188, "KTC Göteborg AB" },
    { 1189, "Interzon AB" },
    { 1190, "ISDE ING SL" },
    { 1191, "ABM automation building messaging GmbH" },
    { 1192, "Kentec Electronics Ltd" },
    { 1193, "Copeland LP" },
    { 1194, "Powerside" },
    { 1195, "SMC Group" },
    { 1196, "EOS Weather Instruments" },
    { 1197, "Zonex Systems" },
    { 1198, "Generex Systems Computervertriebsgesellschaft mbH" },
    { 1199, "Energy Wall LLC" },
    { 1200, "Thermofin" },
    { 1201, "SDATAWAY SA" },
    { 1202, "Biddle Air Systems Limited" },
    { 1203, "Kessler Ellis Products" },
    { 1204, "Thermoscreens" },
    { 1205, "Modio" },
    { 1206, "Newron Solutions" },
    { 1207, "Unitronics" },
    { 1208, "TRILUX GmbH & Co. KG" },
    { 1209, "Kollmorgen Steuerungstechnik GmbH" },
    { 1210, "Bosch Rexroth AG" },
    { 1211, "Alarko Carrier" },
    { 1212, "Verdigris Technologies" },
    { 1213, "Shanghai SIIC-Longchuang Smartech So., Ltd." },
    { 1214, "Quinda Co." },
    { 1215, "GRUNER AG" },
    { 1216, "BACMOVE" },
    { 1217, "PSIDAC AB" },
    { 1218, "ISICON-Control Automation" },
    { 1219, "Big Ass Fans" },
    { 1220, "din – Dietmar Nocker Facility Management GmbH" },
    { 1221, "Teldio" },
    { 1222, "MIKROKLIMA s.r.o." },
    { 1223, "Density" },
    { 1224, "ICONAG-Leittechnik GmbH" },
    { 1225, "Awair" },
    { 1226, "T&D Engineering, Ltd" },
    { 1227, "Sistemas Digitales" },
    { 1228, "Loxone Electronics GmbH" },
    { 1229, "ActronAir" },
    { 1230, "Inductive Automation" },
    { 1231, "Thor Engineering GmbH" },
    { 1232, "Berner International, LLC" },
    { 1233, "Potsdam Sensors LLC" },
    { 1234, "Kohler Mira Ltd" },
    { 1235, "Tecomon GmbH" },
    { 1236, "Two Dimensional Instruments, LLC" },
    { 1237, "LEFA Technologies Pte. Ltd." },
    { 1238, "EATON CEAG Notlichtsysteme GmbH" },
    { 1239, "Commbox Tecnologia" },
    { 1240, "IPVideo Corporation" },
    { 1241, "Bender GmbH & Co. KG" },
    { 1242, "Rhymebus Corporation" },
    { 1243, "Axon Systems Ltd" },
    { 1244, "Engineered Air" },
    { 1245, "Elipse Software Ltda" },
    { 1246, "Simatix Building Technologies Pvt. Ltd." },
    { 1247, "W.A. Benjamin Electric Co." },
    { 1248, "TROX Air Conditioning Components (Suzhou) Co. Ltd." },
    { 1249, "SC Medical Pty Ltd." },
    { 1250, "Elcanic A/S" },
    { 1251, "Obeo AS" },
    { 1252, "Tapa, Inc." },
    { 1253, "ASE Smart Energy, Inc." },
    { 1254, "Performance Services, Inc." },
    { 1255, "Veridify Security" },
    { 1256, "CD Innovation LTD" },
    { 1257, "Ben Peoples Industries, LLC" },
    { 1258, "UNICOMM Sp. z o.o" },
    { 1259, "Thing Technologies GmbH" },
    { 1260, "Beijing Hailin Control Technology, Inc." },
    { 1261, "Digital Realty" },
    { 1262, "Agrowtek Inc." },
    { 1263, "DSP Innovation BV" },
    { 1264, "STV Electronic GmbH" },
    { 1265, "Elmeasure India Pvt Ltd." },
    { 1266, "Pineshore Energy LLC" },
    { 1267, "Brasch Environmental Technologies, LLC" },
    { 1268, "ShenZhen ZhiXing Building Tech Co., Ltd" },
    { 1269, "Sinux" },
    { 1270, "Avnet Inc." },
    { 1271, "Somfy Activites SA" },
    { 1272, "Amico" },
    { 1273, "SageGlass" },
    { 1274, "AuVerte" },
    { 1275, "Agile Connects Pvt. Ltd." },
    { 1276, "Locimation Pty Ltd" },
    { 1277, "Envio Systems GmbH" },
    { 1278, "Voytech Systems Limited" },
    { 1279, "Davidsmeyer und Paul GmbH" },
    { 1280, "Lusher Engineering Services" },
    { 1281, "CHNT Nanjing Techsel Intelligent Company LTD" },
    { 1282, "Threetronics Pty Ltd" },
    { 1283, "SkyFoundry, LLC" },
    { 1284, "HanilProTech" },
    { 1285, "Sensorscall" },
    { 1286, "Shanghai Jingpu Information Technology, Co., Ltd." },
    { 1287, "Lichtmanufaktur Berlin GmbH" },
    { 1288, "Eco Parking Technologies" },
    { 1289, "Envision Digital International Pte Ltd" },
    { 1290, "Antony Developpement Electronique" },
    { 1291, "i2systems" },
    { 1292, "Thureon International Limited" },
    { 1293, "Pulsafeeder" },
    { 1294, "MegaChips Corporation" },
    { 1295, "TES Controls" },
    { 1296, "Cermate" },
    { 1297, "Grand Valley State University" },
    { 1298, "Symcon Gmbh" },
    { 1299, "The Chicago Faucet Company" },
    { 1300, "Geberit AG" },
    { 1301, "Rex Controls" },
    { 1302, "IVMS GmbH" },
    { 1303, "MNPP Saturn Ltd." },
    { 1304, "Regal Beloit" },
    { 1305, "ACS-Air Conditioning Solutions" },
    { 1306, "GBX Technology, LLC" },
    { 1307, "Kaiterra" },
    { 1308, "ThinKuan loT Technology (Shanghai) Co., Ltd" },
    { 1309, "HoCoSto B.V." },
    { 1310, "Shenzhen AS-AI Technology Co., Ltd." },
    { 1311, "RPS S.p.a." },
    { 1312, "Esmé solutions" },
    { 1313, "IOTech Systems Limited" },
    { 1314, "i-AutoLogic Co., Ltd." },
    { 1315, "New Age Micro, LLC" },
    { 1316, "Guardian Glass" },
    { 1317, "Guangzhou Zhaoyu Information Technology" },
    { 1318, "ACE IoT Solutions LLC" },
    { 1319, "Poris Electronics Co., Ltd." },
    { 1320, "Terminus Technologies Group" },
    { 1321, "Intech 21, Inc." },
    { 1322, "Accurate Electronics" },
    { 1323, "Fluence Bioengineering" },
    { 1324, "Mun Hean Singapore Pte Ltd" },
    { 1325, "Katronic AG & Co. KG" },
    { 1326, "Suzhou XinAo Information Technology Co. Ltd" },
    { 1327, "Linktekk Technology, JSC." },
    { 1328, "Stirling Ultracold" },
    { 1329, "UV Partners, Inc." },
    { 1330, "ProMinent GmbH" },
    { 1331, "Multi-Tech Systems, Inc." },
    { 1332, "JUMO GmbH & Co. KG" },
    { 1333, "Qingdao Huarui Technology Co. Ltd.," },
    { 1334, "Cairn Systemes" },
    { 1335, "NeuroLogic Research Corp." },
    { 1336, "Transition Technologies Advanced Solutions Sp. z o.o" },
    { 1337, "Xxter bv" },
    { 1338, "PassiveLogic" },
    { 1339, "EnSmart Controls" },
    { 1340, "Watts Heating and Hot Water Solutions, dba Lync" },
    { 1341, "Troposphaira Technologies LLP" },
    { 1342, "Network Thermostat" },
    { 1343, "Titanium Intelligent Solutions, LLC" },
    { 1344, "Numa Products, LLC" },
    { 1345, "WAREMA Renkhoff SE" },
    { 1346, "Frese A/S" },
    { 1347, "Mapped" },
    { 1348, "ELEKTRODESIGN ventilatory s.r.o" },
    { 1349, "AirCare Automation, Inc." },
    { 1350, "Antrum" },
    { 1351, "Bao Linh Connect Technology" },
    { 1352, "Virginia Controls, LLC" },
    { 1353, "Duosys SDN BHD" },
    { 1354, "Onsen SAS" },
    { 1355, "Vaughn Thermal Corporation" },
    { 1356, "Thermoplastic Engineering Ltd (TPE)" },
    { 1357, "Wirth Research Ltd." },
    { 1358, "SST Automation" },
    { 1359, "Shanghai Bencol Electronic Technology Co., Ltd" },
    { 1360, "AIWAA Systems Private Limited" },
    { 1361, "Enless Wireless" },
    { 1362, "Ozuno Engineering Pty Ltd" },
    { 1363, "Hubbell, The Electric Heater Company" },
    { 1364, "Industrial Turnaround Corporation (ITAC)" },
    { 1365, "Wadsworth Control Systems" },
    { 1366, "Services Hilo Inc." },
    { 1367, "iDM Energiesysteme GmbH" },
    { 1368, "BeNext B.V." },
    { 1369, "CleanAir.ai Corporation" },
    { 1370, "Revolution Microelectronics (America) Inc." },
    { 1371, "Real-Time Systems GmbH" },
    { 1372, "ZedBee Technologies Pvt Ltd" },
    { 1373, "Wimate Technology Solutions Pvt. Ltd." },
    { 1374, "Senticon Ltd." },
    { 1375, "Rossaker AB" },
    { 1376, "OPIT Solutions Ltd" },
    { 1377, "Hotowell International Co., Limited" },
    { 1378, "Inim Electronics S.R.L. Unipersonale" },
    { 1379, "Airthings ASA" },
    { 1380, "Analog Devices, Inc." },
    { 1381, "AIDirections DMCC" },
    { 1382, "Prima Electro S.p.A." },
    { 1383, "KLT Control System Ltd." },
    { 1384, "Evolution Controls Inc." },
    { 1385, "Bever Innovations" },
    { 1386, "Pelican Wireless Systems" },
    { 1387, "Control Concepts Inc." },
    { 1388, "Augmatic Technologies Pvt. Ltd." },
    { 1389, "Xiamen Milesight loT Co., Ltd" },
    { 1390, "Tianjin Anjie loT Schience and Technology Co., Ltd" },
    { 1391, "Guangzhou S. Energy Electronics Technology Co. Ltd." },
    { 1392, "AKVO Atmospheric Water Systems Pvt. Ltd." },
    { 1393, "EmFirst Co. Ltd." },
    { 1394, "Iion Systems ApS" },
    { 1396, "SAF Tehnika JSC" },
    { 1397, "Komfort IQ, Inc." },
    { 1398, "CoolTera Limited" },
    { 1399, "Hadron Solutions S.r.l.s" },
    { 1401, "Bitpool" },
    { 1402, "Sonicu, LLC" },
    { 1403, "Rishabh Instruments Limited" },
    { 1404, "Thing Warehouse LLC" },
    { 1405, "Innofriends GmbH" },
    { 1406, "Metronic AKP Sp. J." },
    { 1407, "Techknave" },
    { 1408, "Elsner Elektronik" },
    { 1409, "LEFOO Industrial (Hangzhou) Co., Ltd." },
    { 1410, "Calibration Technologies, Inc." },
    { 1411, "Allorado" },
    { 1412, "Verkada" },
    { 1413, "Wattsense" },
    { 1414, "Emerson Automation Solutions" },
    { 1415, "Growlink" },
    { 1416, "Olympia Electronics" },
    { 1417, "Normal Software, Inc." },
    { 1418, "ST Engineering Solution JSC" },
    { 1419, "Industrial Flow Solutions" },
    { 1420, "Ubiqisense ApS" },
    { 1421, "Tiger-Soft" },
    { 1422, "Ecodom Srl" },
    { 1423, "Bilgipro IoT Systems" },
    { 1424, "planspur netdesign GmbH" },
    { 1425, "Dolphin Solutions Ltd" },
    { 1426, "Mitsubishi Electric Corporation, Kobe Works" },
    { 1427, "Ecovena" },
    { 1428, "Gree Electric Appliances Inc of Zhuhai" },
    { 1429, "Conspec Controls" },
    { 1430, "Hangzhou Hikvision Digital Technology Co., Ltd." },
    { 1431, "Crystal Peak Security" },
    { 1432, "PermAlert" },
    { 1433, "Zhejiang Misilin Technology Co., Ltd." },
    { 1434, "Dekker Vacuum Technologies" },
    { 1435, "Edwards Limited" },
    { 1436, "Leybold GmbH" },
    { 1437, "International Gas Detectors" },
    { 1438, "Atlas Copco Airpower NV" },
    { 1439, "Air Sentry Limited" },
    { 1440, "Aelsys" },
    { 1441, "Granby Consulting LLC" },
    { 1442, "Clever Relay" },
    { 1443, "Monico Monitoring, Inc." },
    { 1444, "Oqdo" },
    { 1445, "Matrix Comsec Private Limited" },
    { 1446, "Resource Solutions" },
    { 1447, "American Gas Safety, LLC" },
    { 1448, "S&S Northern Ltd." },
    { 1449, "Ulbios Techsens" },
    { 1450, "Bowery Farming, Inc." },
    { 1451, "Ryobi Limited" },
    { 1452, "EkkoSense Ltd" },
    { 1453, "ClimaCool" },
    { 1454, "Grid Connect Inc." },
    { 1455, "Ziegler Instrumentation UK Ltd" },
    { 1456, "ControlTec, LLC" },
    { 1457, "Aeterlink Corporation" },
    { 1458, "Alpha Epsilon Automation" },
    { 1459, "Astralite Inc." },
    { 1460, "Delta Fire Ltda." },
    { 1461, "Bock Water Heaters, Inc." },
    { 1462, "Cleaver-Brooks" },
    { 1463, "Scanalytics, Inc." },
    { 1464, "WI6LABS" },
    { 1465, "AC&T System Co., Ltd" },
    { 1466, "VergeSense" },
    { 1467, "Systemair Mfg. Inc." },
    { 1468, "Seeley International" },
    { 1469, "Crane Building Services & Utilities" },
    { 1470, "Brady Corporation" },
    { 1471, "Qingdao Hisense Hitachi Air-Conditioning Systems Co., Ltd." },
    { 1472, "Golden Quality Co. Ltd." },
    { 1473, "Elvaco AB" },
    { 1474, "Strong Technology, LLC" },
    { 1475, "REC Environmental Technology (Guangzhou) Company Limited" },
    { 1476, "Disruptive Technologies Research AS" },
    { 1477, "Nico Consultancy Limited" },
    { 1478, "Horten lot (Jiangsu) Co., Ltd." },
    { 1479, "Paxton Controls Corp." },
    { 1480, "Fell Technology AS" },
    { 1481, "SHLOK Information Systems India Private Limited" },
    { 1482, "Microgro PLC Ltd." },
    { 1483, "Clouder Oy" },
    { 1484, "Gebäude Automatisierung GmbH" },
    { 1485, "solvimus GmbH" },
    { 1486, "GuangZhou Wangkong Ltd." },
    { 1487, "SafeSquare GmbH" },
    { 1488, "Heklatech AB" },
    { 1489, "Silvair" },
    { 1490, "Adveco" },
    { 1491, "Eura Drives Electric Co., Ltd." },
    { 1492, "Caleb Controls" },
    { 1493, "InBiot Monitoring S.L" },
    { 1494, "Qingdao Haier Air Conditioner Electric Co., Ltd." },
    { 1495, "Hangzhou Weiyl Technology Co., Ltd." },
    { 1496, "yord sàrl" },
    { 1497, "Infinitum Electric" },
    { 1498, "Red Bean Systems Limited" },
    { 1499, "Blue Time Concept SA" },
    { 1500, "Shenzhen INVT Electric Co., Ltd." },
    { 1501, "Messung Systems Pvt Ltd." },
    { 1502, "ABB Electrification Canada Inc." },
    { 1503, "Core Controls" },
    { 1504, "Noord Tech d.o.o." },
    { 1505, "Varibits AS" },
    { 1506, "Roger Sp. z o.o. sp.k." },
    { 1507, "Viega GmbH & Co. KG" },
    { 1508, "Astersoft" },
    { 1509, "BIG-EU" },
    { 1510, "Inferrix Limited" },
    { 1511, "Richards Electric Motor Co." },
    { 1512, "dAPPControls" },
    { 1513, "Entouch Controls" },
    { 1514, "Mavili Elektronik Ticaret ve Sanayi Anonim Sirketi" },
    { 1515, "BubblyNet" },
    { 1516, "AlMayssan Technical Services Co. Ltd." },
    { 1517, "Viridi Parente, Inc." },
    { 1518, "Novel Apps Corp." },
    { 1519, "Oventrop (China) HVAC System Technology Co., Ltd." },
    { 1521, "Lacroix Sofrel" },
    { 1522, "MachineSens loT Trading Co., LLC" },
    { 1523, "Elmec Inc." },
    { 1524, "Beijing Haishi Software Co., Ltd." },
    { 1525, "Radix Electrosystems Pvt. Ltd." },
    { 1526, "Värmebaronen AB" },
    { 1527, "Treau Inc., dba Gradient" },
    { 1528, "WEST Solution AG" },
    { 1529, "Trueway Controls Hongkong Limited" },
    { 1530, "BuildingLogiX" },
    { 1531, "Ifesca GmbH" },
    { 1532, "Fellowes Inc." },
    { 1533, "Caleffi S.p.A." },
    { 1534, "JDRF Electromag" },
    { 1535, "Redwire Labs" },
    { 1536, "Wecon Technology Co., Ltd." },
    { 1537, "Acacia Green Technologies Ltd" },
    { 1538, "Degree Analytics" },
    { 1539, "Roltek Teknoloji A.S." },
    { 1540, "Digital Control Technology Limited" },
    { 1541, "Kentima AB" },
    { 1542, "Pergamon Perceptive Technologies" },
    { 1543, "Prefect Controls Ltd." },
    { 1544, "SenTech Corporation" },
    { 1545, "S+S Regeltechnik GmbH" },
    { 1546, "AirBox, Inc." },
    { 1547, "RVE" },
    { 1548, "Motorola Solutions" },
    { 1549, "BACSYS Innovations Private Limited" },
    { 1550, "Ewattch" },
    { 1551, "Builtlayer LLC" },
    { 1552, "A&G Domotix S.R.L." },
    { 1553, "Hytronik Industrial Limited" },
    { 1554, "WHO Reinraumtechnik" },
    { 1555, "TRICO Limited" },
    { 1556, "SLKAutomation SRL" },
    { 1557, "Zaphire AS" },
    { 1558, "AJ Manufacturing" },
    { 1559, "Future Motors Ltd." },
    { 1560, "Himel Hong Kong Limited" },
    { 1561, "Shenzhen Sunricher Technology Co., Ltd." },
    { 1562, "Actility S.A." },
    { 1563, "Oy Halton Group Ltd." },
    { 1564, "AVTECH Software, Inc." },
    { 1565, "InControl Engineering LLC" },
    { 1566, "SoundWater Technologies LLC" },
    { 1567, "Circular Bv" },
    { 1568, "Normatic AS" },
    { 1569, "Dock Rd" },
    { 1570, "SmartD Technologies Inc." },
    { 1571, "Line of Sight Services LLC" },
    { 1572, "LAIIER Ltd." },
    { 1573, "Antec Controls" },
    { 1574, "CG Conception" },
    { 1575, "Shanghai YuanKong Automation Technology Co., Ltd." },
    { 1576, "Armatura LLC" },
    { 1577, "Ingy BV" },
    { 1578, "Heartful Code" },
    { 1579, "System Mart Ltd." },
    { 1580, "Spot7 GmbH" },
    { 1581, "Intempco Controls Ltd." },
    { 0, NULL }
};
value_string_ext BACnetVendorIdentifiers_ext = VALUE_STRING_EXT_INIT(BACnetVendorIdentifiers);
