/* Driver template for the LEMON parser generator.
** Copyright 1991-1995 by D. Richard Hipp.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
** Modified 1997 to make it suitable for use with makeheaders.
* Updated to sqlite lemon version 1.22
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#line 1 "./mate_grammar.lemon"


/* mate_grammar.lemon
* MATE's configuration language grammar 
*
* Copyright 2005, Luis E. Garcia Ontanon <luis.ontanon@gmail.com>
*
* $Id: mate_grammar.lemon 23221 2007-10-17 21:25:16Z morriss $
*
* Wireshark - Network traffic analyzer
* By Gerald Combs <gerald@wireshark.org>
* Copyright 1998 Gerald Combs
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "mate.h"
#include "mate_grammar.h"
#include <epan/ws_strsplit.h>
#include <wiretap/file_util.h>

#define DUMMY void*

typedef struct _extraction {
	gchar* as;
	header_field_info* hfi;
	struct _extraction* next;
	struct _extraction* last;
} extraction_t;

typedef struct _pdu_criteria_t {
	AVPL* criterium_avpl;
	avpl_match_mode criterium_match_mode;
	accept_mode_t criterium_accept_mode;
} pdu_criteria_t;

typedef struct _gop_options {
	gop_tree_mode_t pdu_tree_mode;
	gboolean drop_unassigned;
	gboolean show_times;
	float expiration;
	float idle_timeout;
	float lifetime;
	AVPL* start;
	AVPL* stop;
	AVPL* extras;
} gop_options_t;

typedef struct _gog_statements {
	float expiration;
	gop_tree_mode_t gop_tree_mode;
	GPtrArray* transform_list;
	AVPL* extras;
	LoAL* current_gogkeys;
} gog_statement_t;

typedef struct _transf_match_t {
    avpl_match_mode match_mode;
    AVPL* avpl;
} transf_match_t; 

typedef struct _transf_action_t {
    avpl_replace_mode replace_mode;
    AVPL* avpl;
} transf_action_t;

static void configuration_error(mate_config* mc, const gchar* fmt, ...) {
	static gchar error_buffer[256];
	const gchar* incl;
	gint i;
	mate_config_frame* current_frame;
	va_list list;
	
	va_start( list, fmt );
	g_vsnprintf(error_buffer,sizeof(error_buffer),fmt,list);
	va_end( list );

	i = (gint) mc->config_stack->len;
	
	while (i--) {

		if (i>0) {
			incl = "\n   included from: ";
		} else {
			incl = " ";
		}
		
		current_frame = g_ptr_array_index(mc->config_stack,(guint)i);
		
		g_string_sprintfa(mc->config_error,"%s%s at line %u",incl, current_frame->filename, current_frame->linenum);
	}
	
	g_string_sprintfa(mc->config_error,": %s\n",error_buffer);
	
	THROW(MateConfigError);

}

static AVPL_Transf* new_transform_elem(AVPL* match, AVPL* replace, avpl_match_mode match_mode, avpl_replace_mode replace_mode) {
	 AVPL_Transf* t = g_malloc(sizeof(AVPL_Transf));
	 
	 t->name = NULL;
	 t->match = match;
	 t->replace = replace;
	 t->match_mode = match_mode;
	 t->replace_mode = replace_mode;
	 
	 t->map = NULL;
	 t->next = NULL;
	 
	 return t;
}

static gchar* recolonize(mate_config* mc, gchar* s) {
	GString* str = g_string_new("");
	gchar** vec;
	gchar* r;
	guint i,v;
	gchar c;
	
	vec = g_strsplit(s,":",0);
	
	for (i = 0; vec[i]; i++) {
		g_strdown(vec[i]);
		
		v = 0;
		switch ( strlen(vec[i]) ) {
		 case 2:
		    c = vec[i][1];
			vec[i][1] = vec[i][0];
			vec[i][0] = c;
			if (vec[i][0] >= '0' && vec[i][0] <= '9') {
				v += (vec[i][1] - '0' )*16;
			} else {
				v += (vec[i][1] - 'a' + 10)*16;
			}
		 case 1:
			if (vec[i][0] >= '0' && vec[i][0] <= '9') {
				v += (vec[i][0] - '0' );
			} else {
				v += (vec[i][0] - 'a' + 10);
			}
		 case 0:
			break;
		  default:
			configuration_error(mc,"bad token %s",s);
		}
		
		g_string_sprintfa(str,":%.2X",v);					
	}
	
	g_strfreev(vec);
	
	g_string_erase(str,0,1);
	
	r = str->str;
	
	g_string_free(str,FALSE);

	return r;
}

#line 201 "mate_grammar.c"
#include <stdio.h>
#include <string.h>
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    MateParserTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is MateParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    MateParserARG_SDECL     A static variable declaration for the %extra_argument
**    MateParserARG_PDECL     A parameter declaration for the %extra_argument
**    MateParserARG_STORE     Code to store %extra_argument into yypParser
**    MateParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE short
#define YYNOCODE 138
#define YYACTIONTYPE short
#define MateParserTOKENTYPE  gchar* 
typedef union {
  MateParserTOKENTYPE yy0;
  AVPL_Transf* yy11;
  AVPL* yy70;
  LoAL* yy77;
  transf_action_t* yy85;
  avpl_replace_mode yy143;
  transf_match_t* yy146;
  GPtrArray* yy147;
  accept_mode_t yy148;
  gop_options_t* yy155;
  extraction_t* yy179;
  gboolean yy182;
  header_field_info* yy210;
  gchar* yy212;
  AVP* yy226;
  gog_statement_t* yy229;
  pdu_criteria_t* yy231;
  float yy255;
  gop_tree_mode_t yy256;
  avpl_match_mode yy274;
  int yy275;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define MateParserARG_SDECL  mate_config* mc ;
#define MateParserARG_PDECL , mate_config* mc 
#define MateParserARG_FETCH  mate_config* mc  = yypParser->mc 
#define MateParserARG_STORE yypParser->mc  = mc 
#define YYNSTATE 282
#define YYNRULE 147
#define YYERRORSYMBOL 62
#define YYERRSYMDT yy275
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   282,  106,  187,  107,  232,   96,  148,   97,   62,  424,
 /*    10 */   426,  149,  161,  176,  123,  240,  241,  405,  200,  201,
 /*    20 */   202,  203,  430,    1,  146,    5,  246,    4,  208,  225,
 /*    30 */   405,  100,  206,  207,   19,  405,  405,  243,  244,  245,
 /*    40 */   102,  101,  348,  226,    4,   93,   87,  233,  211,   19,
 /*    50 */     3,  183,  184,  185,  186,  188,  189,  234,  235,  424,
 /*    60 */   426,  424,  426,  424,  426,  405,  405,   99,  239,   11,
 /*    70 */   254,  103,  264,   90,  261,    7,    8,  281,  260,  236,
 /*    80 */   238,  422,  158,  104,  279,  105,  264,   67,  210,  214,
 /*    90 */   215,  252,  253,  121,  122,   63,   66,  229,  257,  262,
 /*   100 */   158,  256,  259,   93,   14,  127,  231,  237,  168,  131,
 /*   110 */   130,   64,   71,  180,  135,   98,  119,  116,  110,  136,
 /*   120 */   137,  138,  143,  139,   42,  113,   43,  144,  145,  154,
 /*   130 */   155,  140,   74,   15,  156,  422,   44,   74,   20,  167,
 /*   140 */   169,  170,  171,  172,  181,   47,   45,  132,  108,  126,
 /*   150 */    22,   73,   48,   50,  124,   16,   18,  128,   27,   53,
 /*   160 */    51,   26,   54,   25,   55,   24,   23,   56,   30,   57,
 /*   170 */    29,    2,   28,    6,  147,  230,  100,   68,  228,   12,
 /*   180 */   242,  151,   10,   32,   59,   34,   33,   60,  152,   69,
 /*   190 */   141,  133,  157,   70,  160,   31,  275,  258,  263,  163,
 /*   200 */    89,   79,   78,   88,  164,   80,   87,   11,   39,   37,
 /*   210 */    81,   82,   38,   83,   36,   84,   85,   17,   86,   35,
 /*   220 */   165,   40,   21,  280,  190,   41,   91,  191,   94,  173,
 /*   230 */   174,   92,  175,  178,  109,  111,  192,  112,  115,  114,
 /*   240 */   193,  117,  194,  118,  182,  120,  195,  196,  197,   61,
 /*   250 */   150,   46,  224,  125,  198,  227,    9,  199,   49,  247,
 /*   260 */    75,  204,   65,  129,  205,   77,  209,  431,  153,   52,
 /*   270 */    13,  248,  134,  276,   58,  212,   76,   72,  213,  431,
 /*   280 */   142,  216,  166,  220,  217,  265,  221,  218,  266,  222,
 /*   290 */   219,  267,  223,  249,  268,  250,  251,  269,  431,  255,
 /*   300 */   270,  431,  431,  271,  159,  431,  272,  273,  162,  274,
 /*   310 */   431,  431,  277,  431,  179,  278,  177,   95,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     0,    1,   63,    3,    7,    8,   68,   10,   70,    5,
 /*    10 */     5,   11,   12,   13,   14,   29,   30,    5,   44,   45,
 /*    20 */    46,   47,  110,  111,   24,   65,   66,   67,   47,    5,
 /*    30 */    18,    8,   51,   52,   25,   23,   24,   26,   27,   28,
 /*    40 */   108,  109,   56,   66,   67,   53,   54,   50,   10,   25,
 /*    50 */     4,  112,  113,  114,  115,  116,  117,   60,   61,   55,
 /*    60 */    55,   57,   57,   59,   59,   53,   54,  106,  107,   24,
 /*    70 */    81,  102,  103,   86,   81,   82,   96,   97,   99,    5,
 /*    80 */    57,    5,   37,  104,   97,  102,  103,   98,   50,   48,
 /*    90 */    49,   35,   36,    7,    8,   55,    4,   57,    2,    2,
 /*   100 */    37,    8,    8,   53,   58,   74,  108,  108,   74,   72,
 /*   110 */   100,   69,   69,  100,   75,    6,    9,   11,   13,   75,
 /*   120 */    72,   72,   75,   72,  118,   12,  119,   75,   75,   75,
 /*   130 */    75,   11,   40,   59,   75,   59,  120,   40,   77,   75,
 /*   140 */    75,   72,   72,   72,   72,  123,  121,   12,  122,   13,
 /*   150 */    18,   55,  124,  135,  125,   21,   23,  136,   18,  129,
 /*   160 */   133,   19,  130,   20,  131,   16,   22,  132,   15,  133,
 /*   170 */    16,    4,   17,   56,   64,  107,    8,   76,  105,   33,
 /*   180 */   105,  103,  101,   17,  126,   34,   16,  127,   80,   78,
 /*   190 */   128,  134,  105,   79,  103,   39,    8,   99,  103,   73,
 /*   200 */    42,   85,   84,   43,  105,   86,   54,   24,   18,   20,
 /*   210 */    98,   90,   19,   91,   16,   92,   87,   21,   88,   22,
 /*   220 */    89,   18,   23,    8,    2,    4,   98,    2,   71,  105,
 /*   230 */   105,   94,  105,   95,    5,    9,    2,   10,   10,    9,
 /*   240 */     2,    9,    2,   10,  105,   10,    2,    2,    2,    8,
 /*   250 */     8,    4,    2,    5,    2,    2,   32,    2,    4,    2,
 /*   260 */    41,    2,   31,    5,    2,    4,    2,  137,    5,    4,
 /*   270 */     4,    2,    5,    2,    4,    2,   25,   38,    2,  137,
 /*   280 */     5,    2,    5,    2,    2,    2,    2,    2,    2,    2,
 /*   290 */     2,    2,    2,    2,    2,    2,    2,    2,  137,    2,
 /*   300 */     2,  137,  137,    2,    8,  137,    2,    2,    8,    2,
 /*   310 */   137,  137,    2,  137,    5,    2,    8,    2,
};
#define YY_SHIFT_USE_DFLT (-27)
#define YY_SHIFT_MAX 182
static const short yy_shift_ofst[] = {
 /*     0 */   -27,    0,    9,   -3,  -14,   24,   23,   45,   -8,   93,
 /*    10 */    63,   94,   93,   50,   -3,   -3,  -26,  -26,  -19,   11,
 /*    20 */    11,  -19,   38,   41,   41,   38,   38,   38,   41,   41,
 /*    30 */    41,   41,   41,   41,   56,   41,   41,   38,   38,   38,
 /*    40 */    38,  109,  107,  106,  113,  105,  120,  135,  136,  132,
 /*    50 */   134,  133,  140,  142,  143,  149,  134,  144,  153,  154,
 /*    60 */   155,  167,  117,  168,  117,   93,  146,  151,  170,  166,
 /*    70 */   156,  117,   93,   94,   93,  188,  117,  158,  160,  152,
 /*    80 */   183,  190,  193,  189,  198,  196,  197,  117,  117,  117,
 /*    90 */   183,  203,  199,  215,  117,   12,    4,    5,   86,   40,
 /*   100 */    46,   74,   76,   92,   96,   97,  222,  221,  229,  225,
 /*   110 */   226,  227,  234,  230,  228,  238,  232,  233,  240,  235,
 /*   120 */   244,  245,  246,  247,  248,  252,  254,  255,  258,  259,
 /*   130 */   262,  264,  265,  267,  273,  276,  279,  282,  285,  288,
 /*   140 */   270,  275,  281,  284,  287,  290,  241,  250,  253,  242,
 /*   150 */   231,  224,  263,  257,  269,  291,  293,  294,  296,  239,
 /*   160 */   297,  300,  219,  251,  261,  277,  283,  286,  289,  292,
 /*   170 */   295,  298,  301,  304,  305,  307,  308,  266,  309,  271,
 /*   180 */   310,  313,  315,
};
#define YY_REDUCE_USE_DFLT (-89)
#define YY_REDUCE_MAX 94
static const short yy_reduce_ofst[] = {
 /*     0 */   -88,  -61,  -40,  -68,  -62,  -23,  -39,  -11,  -13,  -31,
 /*    10 */    -7,  -21,  -17,  -20,   -2,   -1,   31,   34,   10,   42,
 /*    20 */    43,   13,   37,   39,   44,   48,   49,   51,   47,   52,
 /*    30 */    53,   54,   55,   59,   61,   64,   65,   69,   70,   71,
 /*    40 */    72,    6,    7,   16,   25,   26,   22,   28,   29,   18,
 /*    50 */    27,   21,   30,   32,   33,   35,   36,   57,   58,   60,
 /*    60 */    62,  110,   73,   68,   75,   78,   81,  101,  111,  114,
 /*    70 */   108,   87,   91,   98,   95,  126,   99,  118,  116,  119,
 /*    80 */   112,  121,  122,  123,  129,  130,  131,  124,  125,  127,
 /*    90 */   128,  137,  138,  157,  139,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   284,  429,  339,  429,  340,  339,  429,  410,  408,  429,
 /*    10 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  342,
 /*    20 */   342,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*    30 */   429,  429,  429,  429,  354,  429,  429,  429,  429,  429,
 /*    40 */   429,  295,  297,  299,  301,  303,  306,  314,  328,  330,
 /*    50 */   324,  332,  316,  318,  320,  322,  324,  326,  308,  310,
 /*    60 */   312,  429,  429,  429,  429,  429,  350,  352,  361,  363,
 /*    70 */   365,  429,  429,  429,  429,  429,  429,  373,  375,  408,
 /*    80 */   410,  381,  383,  385,  371,  377,  379,  429,  429,  429,
 /*    90 */   410,  399,  397,  429,  429,  429,  429,  429,  429,  429,
 /*   100 */   419,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   110 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   120 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   130 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   140 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   150 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   160 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   170 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*   180 */   429,  429,  429,  283,  285,  286,  287,  288,  289,  290,
 /*   190 */   291,  292,  302,  300,  298,  296,  293,  294,  304,  323,
 /*   200 */   386,  387,  388,  389,  327,  331,  400,  401,  402,  329,
 /*   210 */   393,  394,  313,  325,  390,  391,  321,  319,  317,  315,
 /*   220 */   305,  311,  309,  307,  333,  334,  335,  337,  341,  414,
 /*   230 */   416,  418,  423,  425,  427,  428,  420,  421,  415,  417,
 /*   240 */   346,  347,  338,  343,  344,  345,  336,  349,  364,  362,
 /*   250 */   360,  353,  355,  356,  357,  359,  368,  409,  411,  413,
 /*   260 */   412,  358,  351,  366,  367,  369,  378,  376,  370,  384,
 /*   270 */   382,  380,  407,  374,  372,  392,  395,  396,  398,  403,
 /*   280 */   406,  404,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))


/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  MateParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */
 
#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void MateParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */
 
#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "DONE_KW",       "SEMICOLON",     "DEBUG_KW",    
  "OPEN_BRACE",    "CLOSE_BRACE",   "FILENAME_KW",   "QUOTED",      
  "NAME",          "LEVEL_KW",      "INTEGER",       "PDU_KW",      
  "GOP_KW",        "GOG_KW",        "DEFAULT_KW",    "LAST_EXTRACTED_KW",
  "DROP_UNASSIGNED_KW",  "DISCARD_PDU_DATA_KW",  "EXPIRATION_KW",  "IDLE_TIMEOUT_KW",
  "LIFETIME_KW",   "SHOW_TREE_KW",  "SHOW_TIMES_KW",  "GOP_TREE_KW", 
  "TRANSFORM_KW",  "MATCH_KW",      "STRICT_KW",     "EVERY_KW",    
  "LOOSE_KW",      "REPLACE_KW",    "INSERT_KW",     "PROTO_KW",    
  "TRANSPORT_KW",  "PAYLOAD_KW",    "CRITERIA_KW",   "ACCEPT_KW",   
  "REJECT_KW",     "EXTRACT_KW",    "FROM_KW",       "LAST_PDU_KW", 
  "SLASH",         "ON_KW",         "START_KW",      "STOP_KW",     
  "NO_TREE_KW",    "PDU_TREE_KW",   "FRAME_TREE_KW",  "BASIC_TREE_KW",
  "TRUE_KW",       "FALSE_KW",      "FLOATING",      "NULL_TREE_KW",
  "FULL_TREE_KW",  "MEMBER_KW",     "EXTRA_KW",      "COMMA",       
  "OPEN_PARENS",   "CLOSE_PARENS",  "AVP_OPERATOR",  "PIPE",        
  "DOTED_IP",      "COLONIZED",     "error",         "transform_decl",
  "transform_body",  "transform_statements",  "transform_statement",  "transform_match",
  "transform_action",  "match_mode",    "action_mode",   "gop_name",    
  "time_value",    "pdu_name",      "gop_tree_mode",  "true_false",  
  "criteria_statement",  "accept_mode",   "pdu_drop_unassigned_statement",  "discard_pdu_data_statement",
  "last_extracted_statement",  "extraction_statement",  "extraction_statements",  "gop_options", 
  "gop_start_statement",  "gop_stop_statement",  "extra_statement",  "gop_drop_unassigned_statement",
  "show_goptree_statement",  "show_times_statement",  "gop_expiration_statement",  "idle_timeout_statement",
  "lifetime_statement",  "gog_statements",  "gog_expiration_statement",  "gog_goptree_statement",
  "gog_key_statements",  "gog_key_statement",  "transform_list_statement",  "transform",   
  "gop_tree_type",  "payload_statement",  "proto_stack",   "field",       
  "transform_list",  "avpl",          "avps",          "avp",         
  "value",         "avp_oneoff",    "mate_config",   "decls",       
  "decl",          "pdu_decl",      "gop_decl",      "gog_decl",    
  "defaults_decl",  "debug_decl",    "dbgfile_default",  "dbglevel_default",
  "pdu_dbglevel_default",  "gop_dbglevel_default",  "gog_dbglevel_default",  "pdu_defaults",
  "gop_defaults",  "gog_defaults",  "pdu_last_extracted_default",  "pdu_drop_unassigned_default",
  "pdu_discard_default",  "gop_expiration_default",  "gop_idle_timeout_default",  "gop_lifetime_default",
  "gop_drop_unassigned_default",  "gop_tree_mode_default",  "gop_show_times_default",  "gog_expiration_default",
  "gog_goptree_default",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "mate_config ::= decls",
 /*   1 */ "decls ::= decls decl",
 /*   2 */ "decls ::=",
 /*   3 */ "decl ::= pdu_decl",
 /*   4 */ "decl ::= gop_decl",
 /*   5 */ "decl ::= gog_decl",
 /*   6 */ "decl ::= transform_decl",
 /*   7 */ "decl ::= defaults_decl",
 /*   8 */ "decl ::= debug_decl",
 /*   9 */ "decl ::= DONE_KW SEMICOLON",
 /*  10 */ "debug_decl ::= DEBUG_KW OPEN_BRACE dbgfile_default dbglevel_default pdu_dbglevel_default gop_dbglevel_default gog_dbglevel_default CLOSE_BRACE SEMICOLON",
 /*  11 */ "dbgfile_default ::= FILENAME_KW QUOTED SEMICOLON",
 /*  12 */ "dbgfile_default ::= FILENAME_KW NAME SEMICOLON",
 /*  13 */ "dbgfile_default ::=",
 /*  14 */ "dbglevel_default ::= LEVEL_KW INTEGER SEMICOLON",
 /*  15 */ "dbglevel_default ::=",
 /*  16 */ "pdu_dbglevel_default ::= PDU_KW LEVEL_KW INTEGER SEMICOLON",
 /*  17 */ "pdu_dbglevel_default ::=",
 /*  18 */ "gop_dbglevel_default ::= GOP_KW LEVEL_KW INTEGER SEMICOLON",
 /*  19 */ "gop_dbglevel_default ::=",
 /*  20 */ "gog_dbglevel_default ::= GOG_KW LEVEL_KW INTEGER SEMICOLON",
 /*  21 */ "gog_dbglevel_default ::=",
 /*  22 */ "defaults_decl ::= DEFAULT_KW OPEN_BRACE pdu_defaults gop_defaults gog_defaults CLOSE_BRACE SEMICOLON",
 /*  23 */ "pdu_defaults ::= PDU_KW OPEN_BRACE pdu_last_extracted_default pdu_drop_unassigned_default pdu_discard_default CLOSE_BRACE SEMICOLON",
 /*  24 */ "pdu_defaults ::=",
 /*  25 */ "pdu_last_extracted_default ::= LAST_EXTRACTED_KW true_false SEMICOLON",
 /*  26 */ "pdu_last_extracted_default ::=",
 /*  27 */ "pdu_drop_unassigned_default ::= DROP_UNASSIGNED_KW true_false SEMICOLON",
 /*  28 */ "pdu_drop_unassigned_default ::=",
 /*  29 */ "pdu_discard_default ::= DISCARD_PDU_DATA_KW true_false SEMICOLON",
 /*  30 */ "pdu_discard_default ::=",
 /*  31 */ "gop_defaults ::= GOP_KW OPEN_BRACE gop_expiration_default gop_idle_timeout_default gop_lifetime_default gop_drop_unassigned_default gop_tree_mode_default gop_show_times_default CLOSE_BRACE SEMICOLON",
 /*  32 */ "gop_defaults ::=",
 /*  33 */ "gop_expiration_default ::= EXPIRATION_KW time_value SEMICOLON",
 /*  34 */ "gop_expiration_default ::=",
 /*  35 */ "gop_idle_timeout_default ::= IDLE_TIMEOUT_KW time_value SEMICOLON",
 /*  36 */ "gop_idle_timeout_default ::=",
 /*  37 */ "gop_lifetime_default ::= LIFETIME_KW time_value SEMICOLON",
 /*  38 */ "gop_lifetime_default ::=",
 /*  39 */ "gop_drop_unassigned_default ::= DROP_UNASSIGNED_KW true_false SEMICOLON",
 /*  40 */ "gop_drop_unassigned_default ::=",
 /*  41 */ "gop_tree_mode_default ::= SHOW_TREE_KW gop_tree_mode SEMICOLON",
 /*  42 */ "gop_tree_mode_default ::=",
 /*  43 */ "gop_show_times_default ::= SHOW_TIMES_KW true_false SEMICOLON",
 /*  44 */ "gop_show_times_default ::=",
 /*  45 */ "gog_defaults ::= GOG_KW OPEN_BRACE gog_expiration_default gop_tree_mode_default gog_goptree_default CLOSE_BRACE SEMICOLON",
 /*  46 */ "gog_defaults ::=",
 /*  47 */ "gog_expiration_default ::= EXPIRATION_KW time_value SEMICOLON",
 /*  48 */ "gog_expiration_default ::=",
 /*  49 */ "gog_goptree_default ::= GOP_TREE_KW gop_tree_type SEMICOLON",
 /*  50 */ "gog_goptree_default ::=",
 /*  51 */ "transform_decl ::= TRANSFORM_KW NAME transform_body SEMICOLON",
 /*  52 */ "transform_body ::= OPEN_BRACE transform_statements CLOSE_BRACE",
 /*  53 */ "transform_statements ::= transform_statements transform_statement",
 /*  54 */ "transform_statements ::= transform_statement",
 /*  55 */ "transform_statement ::= transform_match transform_action SEMICOLON",
 /*  56 */ "transform_match ::= MATCH_KW match_mode avpl",
 /*  57 */ "transform_match ::=",
 /*  58 */ "transform_action ::=",
 /*  59 */ "transform_action ::= action_mode avpl",
 /*  60 */ "match_mode ::=",
 /*  61 */ "match_mode ::= STRICT_KW",
 /*  62 */ "match_mode ::= EVERY_KW",
 /*  63 */ "match_mode ::= LOOSE_KW",
 /*  64 */ "action_mode ::= REPLACE_KW",
 /*  65 */ "action_mode ::= INSERT_KW",
 /*  66 */ "action_mode ::=",
 /*  67 */ "pdu_decl ::= PDU_KW NAME PROTO_KW field TRANSPORT_KW proto_stack OPEN_BRACE payload_statement extraction_statements transform_list_statement criteria_statement pdu_drop_unassigned_statement discard_pdu_data_statement last_extracted_statement CLOSE_BRACE SEMICOLON",
 /*  68 */ "payload_statement ::=",
 /*  69 */ "payload_statement ::= PAYLOAD_KW proto_stack SEMICOLON",
 /*  70 */ "criteria_statement ::=",
 /*  71 */ "criteria_statement ::= CRITERIA_KW accept_mode match_mode avpl SEMICOLON",
 /*  72 */ "accept_mode ::=",
 /*  73 */ "accept_mode ::= ACCEPT_KW",
 /*  74 */ "accept_mode ::= REJECT_KW",
 /*  75 */ "extraction_statements ::= extraction_statements extraction_statement",
 /*  76 */ "extraction_statements ::= extraction_statement",
 /*  77 */ "extraction_statement ::= EXTRACT_KW NAME FROM_KW field SEMICOLON",
 /*  78 */ "pdu_drop_unassigned_statement ::= DROP_UNASSIGNED_KW true_false SEMICOLON",
 /*  79 */ "pdu_drop_unassigned_statement ::=",
 /*  80 */ "discard_pdu_data_statement ::= DISCARD_PDU_DATA_KW true_false SEMICOLON",
 /*  81 */ "discard_pdu_data_statement ::=",
 /*  82 */ "last_extracted_statement ::= LAST_PDU_KW true_false SEMICOLON",
 /*  83 */ "last_extracted_statement ::=",
 /*  84 */ "proto_stack ::= proto_stack SLASH field",
 /*  85 */ "proto_stack ::= field",
 /*  86 */ "field ::= NAME",
 /*  87 */ "gop_decl ::= GOP_KW NAME ON_KW pdu_name MATCH_KW avpl OPEN_BRACE gop_start_statement gop_stop_statement extra_statement transform_list_statement gop_expiration_statement idle_timeout_statement lifetime_statement gop_drop_unassigned_statement show_goptree_statement show_times_statement CLOSE_BRACE SEMICOLON",
 /*  88 */ "gop_drop_unassigned_statement ::= DROP_UNASSIGNED_KW true_false SEMICOLON",
 /*  89 */ "gop_drop_unassigned_statement ::=",
 /*  90 */ "gop_start_statement ::= START_KW avpl SEMICOLON",
 /*  91 */ "gop_start_statement ::=",
 /*  92 */ "gop_stop_statement ::= STOP_KW avpl SEMICOLON",
 /*  93 */ "gop_stop_statement ::=",
 /*  94 */ "show_goptree_statement ::= SHOW_TREE_KW gop_tree_mode SEMICOLON",
 /*  95 */ "show_goptree_statement ::=",
 /*  96 */ "show_times_statement ::= SHOW_TIMES_KW true_false SEMICOLON",
 /*  97 */ "show_times_statement ::=",
 /*  98 */ "gop_expiration_statement ::= EXPIRATION_KW time_value SEMICOLON",
 /*  99 */ "gop_expiration_statement ::=",
 /* 100 */ "idle_timeout_statement ::= IDLE_TIMEOUT_KW time_value SEMICOLON",
 /* 101 */ "idle_timeout_statement ::=",
 /* 102 */ "lifetime_statement ::= LIFETIME_KW time_value SEMICOLON",
 /* 103 */ "lifetime_statement ::=",
 /* 104 */ "gop_tree_mode ::= NO_TREE_KW",
 /* 105 */ "gop_tree_mode ::= PDU_TREE_KW",
 /* 106 */ "gop_tree_mode ::= FRAME_TREE_KW",
 /* 107 */ "gop_tree_mode ::= BASIC_TREE_KW",
 /* 108 */ "true_false ::= TRUE_KW",
 /* 109 */ "true_false ::= FALSE_KW",
 /* 110 */ "pdu_name ::= NAME",
 /* 111 */ "time_value ::= FLOATING",
 /* 112 */ "time_value ::= INTEGER",
 /* 113 */ "gog_decl ::= GOG_KW NAME OPEN_BRACE gog_key_statements extra_statement transform_list_statement gog_expiration_statement gog_goptree_statement CLOSE_BRACE SEMICOLON",
 /* 114 */ "gog_goptree_statement ::= GOP_TREE_KW gop_tree_type SEMICOLON",
 /* 115 */ "gog_goptree_statement ::=",
 /* 116 */ "gog_expiration_statement ::= EXPIRATION_KW time_value SEMICOLON",
 /* 117 */ "gog_expiration_statement ::=",
 /* 118 */ "gop_tree_type ::= NULL_TREE_KW",
 /* 119 */ "gop_tree_type ::= FULL_TREE_KW",
 /* 120 */ "gop_tree_type ::= BASIC_TREE_KW",
 /* 121 */ "gog_key_statements ::= gog_key_statements gog_key_statement",
 /* 122 */ "gog_key_statements ::= gog_key_statement",
 /* 123 */ "gog_key_statement ::= MEMBER_KW gop_name avpl SEMICOLON",
 /* 124 */ "gop_name ::= NAME",
 /* 125 */ "extra_statement ::= EXTRA_KW avpl SEMICOLON",
 /* 126 */ "extra_statement ::=",
 /* 127 */ "transform_list_statement ::= TRANSFORM_KW transform_list SEMICOLON",
 /* 128 */ "transform_list_statement ::=",
 /* 129 */ "transform_list ::= transform_list COMMA transform",
 /* 130 */ "transform_list ::= transform",
 /* 131 */ "transform ::= NAME",
 /* 132 */ "avpl ::= OPEN_PARENS avps CLOSE_PARENS",
 /* 133 */ "avpl ::= OPEN_PARENS CLOSE_PARENS",
 /* 134 */ "avps ::= avps COMMA avp",
 /* 135 */ "avps ::= avp",
 /* 136 */ "avp ::= NAME AVP_OPERATOR value",
 /* 137 */ "avp ::= NAME",
 /* 138 */ "avp ::= NAME OPEN_BRACE avp_oneoff CLOSE_BRACE",
 /* 139 */ "avp_oneoff ::= avp_oneoff PIPE value",
 /* 140 */ "avp_oneoff ::= value",
 /* 141 */ "value ::= QUOTED",
 /* 142 */ "value ::= NAME",
 /* 143 */ "value ::= FLOATING",
 /* 144 */ "value ::= INTEGER",
 /* 145 */ "value ::= DOTED_IP",
 /* 146 */ "value ::= COLONIZED",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *MateParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(int)(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to MateParser and MateParserFree.
*/
void *MateParserAlloc(void *(*mallocProc)(gulong)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (gulong)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
#line 182 "./mate_grammar.lemon"
{ if ((yypminor->yy0)) g_free((yypminor->yy0)); }
#line 871 "mate_grammar.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
     yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from MateParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void MateParserFree(
  void *p,                 /* The parser to be deleted */
  void (*freeProc)(void*)  /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)(pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;

  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      int j = i - iLookAhead + YYWILDCARD;
      if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
        }
#endif /* NDEBUG */

        return yy_action[j];
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     MateParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
	 MateParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 110, 1 },
  { 111, 2 },
  { 111, 0 },
  { 112, 1 },
  { 112, 1 },
  { 112, 1 },
  { 112, 1 },
  { 112, 1 },
  { 112, 1 },
  { 112, 2 },
  { 117, 9 },
  { 118, 3 },
  { 118, 3 },
  { 118, 0 },
  { 119, 3 },
  { 119, 0 },
  { 120, 4 },
  { 120, 0 },
  { 121, 4 },
  { 121, 0 },
  { 122, 4 },
  { 122, 0 },
  { 116, 7 },
  { 123, 7 },
  { 123, 0 },
  { 126, 3 },
  { 126, 0 },
  { 127, 3 },
  { 127, 0 },
  { 128, 3 },
  { 128, 0 },
  { 124, 10 },
  { 124, 0 },
  { 129, 3 },
  { 129, 0 },
  { 130, 3 },
  { 130, 0 },
  { 131, 3 },
  { 131, 0 },
  { 132, 3 },
  { 132, 0 },
  { 133, 3 },
  { 133, 0 },
  { 134, 3 },
  { 134, 0 },
  { 125, 7 },
  { 125, 0 },
  { 135, 3 },
  { 135, 0 },
  { 136, 3 },
  { 136, 0 },
  { 63, 4 },
  { 64, 3 },
  { 65, 2 },
  { 65, 1 },
  { 66, 3 },
  { 67, 3 },
  { 67, 0 },
  { 68, 0 },
  { 68, 2 },
  { 69, 0 },
  { 69, 1 },
  { 69, 1 },
  { 69, 1 },
  { 70, 1 },
  { 70, 1 },
  { 70, 0 },
  { 113, 16 },
  { 101, 0 },
  { 101, 3 },
  { 76, 0 },
  { 76, 5 },
  { 77, 0 },
  { 77, 1 },
  { 77, 1 },
  { 82, 2 },
  { 82, 1 },
  { 81, 5 },
  { 78, 3 },
  { 78, 0 },
  { 79, 3 },
  { 79, 0 },
  { 80, 3 },
  { 80, 0 },
  { 102, 3 },
  { 102, 1 },
  { 103, 1 },
  { 114, 19 },
  { 87, 3 },
  { 87, 0 },
  { 84, 3 },
  { 84, 0 },
  { 85, 3 },
  { 85, 0 },
  { 88, 3 },
  { 88, 0 },
  { 89, 3 },
  { 89, 0 },
  { 90, 3 },
  { 90, 0 },
  { 91, 3 },
  { 91, 0 },
  { 92, 3 },
  { 92, 0 },
  { 74, 1 },
  { 74, 1 },
  { 74, 1 },
  { 74, 1 },
  { 75, 1 },
  { 75, 1 },
  { 73, 1 },
  { 72, 1 },
  { 72, 1 },
  { 115, 10 },
  { 95, 3 },
  { 95, 0 },
  { 94, 3 },
  { 94, 0 },
  { 100, 1 },
  { 100, 1 },
  { 100, 1 },
  { 96, 2 },
  { 96, 1 },
  { 97, 4 },
  { 71, 1 },
  { 86, 3 },
  { 86, 0 },
  { 98, 3 },
  { 98, 0 },
  { 104, 3 },
  { 104, 1 },
  { 99, 1 },
  { 105, 3 },
  { 105, 2 },
  { 106, 3 },
  { 106, 1 },
  { 107, 3 },
  { 107, 1 },
  { 107, 4 },
  { 109, 3 },
  { 109, 1 },
  { 108, 1 },
  { 108, 1 },
  { 108, 1 },
  { 108, 1 },
  { 108, 1 },
  { 108, 1 },
};

static void yy_accept(
  yyParser *yypParser           /* The parser */
);  /* Forward declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  MateParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 13:
      case 15:
      case 17:
      case 19:
      case 21:
      case 24:
      case 26:
      case 28:
      case 30:
      case 32:
      case 34:
      case 36:
      case 38:
      case 40:
      case 42:
      case 44:
      case 46:
      case 48:
      case 50:
#line 250 "./mate_grammar.lemon"
{
}
#line 1288 "mate_grammar.c"
        break;
      case 9:
#line 261 "./mate_grammar.lemon"
{
  yy_destructor(1,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1296 "mate_grammar.c"
        break;
      case 10:
#line 266 "./mate_grammar.lemon"
{
  yy_destructor(3,&yymsp[-8].minor);
  yy_destructor(4,&yymsp[-7].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1306 "mate_grammar.c"
        break;
      case 11:
#line 268 "./mate_grammar.lemon"
{ mc->dbg_facility = eth_fopen(yymsp[-1].minor.yy0,"w"); if (mc->dbg_facility == NULL) report_open_failure(yymsp[-1].minor.yy0,errno,TRUE);   yy_destructor(6,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1313 "mate_grammar.c"
        break;
      case 12:
#line 269 "./mate_grammar.lemon"
{ mc->dbg_facility = eth_fopen(yymsp[-1].minor.yy0,"w"); if (mc->dbg_facility == NULL) report_open_failure(yymsp[-1].minor.yy0,errno,TRUE);    yy_destructor(6,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1320 "mate_grammar.c"
        break;
      case 14:
#line 272 "./mate_grammar.lemon"
{ mc->dbg_lvl = (int) strtol(yymsp[-1].minor.yy0,NULL,10);   yy_destructor(9,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1327 "mate_grammar.c"
        break;
      case 16:
#line 275 "./mate_grammar.lemon"
{ mc->dbg_pdu_lvl = (int) strtol(yymsp[-1].minor.yy0,NULL,10);   yy_destructor(11,&yymsp[-3].minor);
  yy_destructor(9,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1335 "mate_grammar.c"
        break;
      case 18:
#line 278 "./mate_grammar.lemon"
{ mc->dbg_gop_lvl = (int) strtol(yymsp[-1].minor.yy0,NULL,10);   yy_destructor(12,&yymsp[-3].minor);
  yy_destructor(9,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1343 "mate_grammar.c"
        break;
      case 20:
#line 281 "./mate_grammar.lemon"
{ mc->dbg_gog_lvl = (int) strtol(yymsp[-1].minor.yy0,NULL,10);   yy_destructor(13,&yymsp[-3].minor);
  yy_destructor(9,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1351 "mate_grammar.c"
        break;
      case 22:
#line 288 "./mate_grammar.lemon"
{
  yy_destructor(14,&yymsp[-6].minor);
  yy_destructor(4,&yymsp[-5].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1361 "mate_grammar.c"
        break;
      case 23:
#line 290 "./mate_grammar.lemon"
{
  yy_destructor(11,&yymsp[-6].minor);
  yy_destructor(4,&yymsp[-5].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1371 "mate_grammar.c"
        break;
      case 25:
#line 293 "./mate_grammar.lemon"
{ mc->defaults.pdu.last_extracted = yymsp[-1].minor.yy182;   yy_destructor(15,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1378 "mate_grammar.c"
        break;
      case 27:
#line 296 "./mate_grammar.lemon"
{ mc->defaults.pdu.drop_unassigned = yymsp[-1].minor.yy182;   yy_destructor(16,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1385 "mate_grammar.c"
        break;
      case 29:
#line 299 "./mate_grammar.lemon"
{ mc->defaults.pdu.discard = yymsp[-1].minor.yy182;   yy_destructor(17,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1392 "mate_grammar.c"
        break;
      case 31:
#line 302 "./mate_grammar.lemon"
{
  yy_destructor(12,&yymsp[-9].minor);
  yy_destructor(4,&yymsp[-8].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1402 "mate_grammar.c"
        break;
      case 33:
      case 47:
#line 305 "./mate_grammar.lemon"
{ mc->defaults.gop.expiration = yymsp[-1].minor.yy255;   yy_destructor(18,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1410 "mate_grammar.c"
        break;
      case 35:
#line 308 "./mate_grammar.lemon"
{ mc->defaults.gop.idle_timeout = yymsp[-1].minor.yy255;   yy_destructor(19,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1417 "mate_grammar.c"
        break;
      case 37:
#line 311 "./mate_grammar.lemon"
{ mc->defaults.gop.lifetime = yymsp[-1].minor.yy255;   yy_destructor(20,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1424 "mate_grammar.c"
        break;
      case 39:
#line 314 "./mate_grammar.lemon"
{ mc->defaults.gop.drop_unassigned = yymsp[-1].minor.yy182;   yy_destructor(16,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1431 "mate_grammar.c"
        break;
      case 41:
#line 317 "./mate_grammar.lemon"
{ mc->defaults.gop.pdu_tree_mode = yymsp[-1].minor.yy256;   yy_destructor(21,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1438 "mate_grammar.c"
        break;
      case 43:
#line 320 "./mate_grammar.lemon"
{ mc->defaults.gop.show_times = yymsp[-1].minor.yy182;   yy_destructor(22,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1445 "mate_grammar.c"
        break;
      case 45:
#line 323 "./mate_grammar.lemon"
{
  yy_destructor(13,&yymsp[-6].minor);
  yy_destructor(4,&yymsp[-5].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1455 "mate_grammar.c"
        break;
      case 49:
#line 329 "./mate_grammar.lemon"
{ mc->defaults.gog.gop_tree_mode = yymsp[-1].minor.yy256;   yy_destructor(23,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1462 "mate_grammar.c"
        break;
      case 51:
#line 336 "./mate_grammar.lemon"
{
	AVPL_Transf* c;

	if ( g_hash_table_lookup(mc->transfs,yymsp[-2].minor.yy0) ) {
		configuration_error(mc,"yygotominor.yy11 transformation called '%s' exists already",yymsp[-2].minor.yy0);
	}

	for ( c = yymsp[-1].minor.yy11; c; c = c->next )
		c->name = g_strdup(yymsp[-2].minor.yy0);
	
	g_hash_table_insert(mc->transfs,yymsp[-1].minor.yy11->name,yymsp[-1].minor.yy11);
	
	yygotominor.yy11 = NULL;
  yy_destructor(24,&yymsp[-3].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1482 "mate_grammar.c"
        break;
      case 52:
#line 351 "./mate_grammar.lemon"
{ yygotominor.yy11 = yymsp[-1].minor.yy11;   yy_destructor(4,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
}
#line 1489 "mate_grammar.c"
        break;
      case 53:
#line 353 "./mate_grammar.lemon"
{
    AVPL_Transf* c;
	
	for ( c = yymsp[-1].minor.yy11; c->next; c = c->next ) ;
	c->next = yymsp[0].minor.yy11;
	yygotominor.yy11 = yymsp[-1].minor.yy11;
}
#line 1500 "mate_grammar.c"
        break;
      case 54:
#line 361 "./mate_grammar.lemon"
{ yygotominor.yy11 = yymsp[0].minor.yy11; }
#line 1505 "mate_grammar.c"
        break;
      case 55:
#line 363 "./mate_grammar.lemon"
{
	yygotominor.yy11 = new_transform_elem(yymsp[-2].minor.yy146->avpl,yymsp[-1].minor.yy85->avpl,yymsp[-2].minor.yy146->match_mode,yymsp[-1].minor.yy85->replace_mode);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1513 "mate_grammar.c"
        break;
      case 56:
#line 367 "./mate_grammar.lemon"
{
    yygotominor.yy146 = g_malloc(sizeof(transf_match_t));
    yygotominor.yy146->match_mode = yymsp[-1].minor.yy274;
    yygotominor.yy146->avpl = yymsp[0].minor.yy70;
  yy_destructor(25,&yymsp[-2].minor);
}
#line 1523 "mate_grammar.c"
        break;
      case 57:
#line 373 "./mate_grammar.lemon"
{
    yygotominor.yy146 = g_malloc(sizeof(transf_match_t));
    yygotominor.yy146->match_mode = AVPL_STRICT;
    yygotominor.yy146->avpl = new_avpl("");

}
#line 1533 "mate_grammar.c"
        break;
      case 58:
#line 380 "./mate_grammar.lemon"
{
    yygotominor.yy85 = g_malloc(sizeof(transf_action_t));
    yygotominor.yy85->replace_mode = AVPL_INSERT;
    yygotominor.yy85->avpl = new_avpl("");
}
#line 1542 "mate_grammar.c"
        break;
      case 59:
#line 385 "./mate_grammar.lemon"
{
    yygotominor.yy85 = g_malloc(sizeof(transf_action_t));
    yygotominor.yy85->replace_mode = yymsp[-1].minor.yy143;
    yygotominor.yy85->avpl = yymsp[0].minor.yy70;
}
#line 1551 "mate_grammar.c"
        break;
      case 60:
#line 391 "./mate_grammar.lemon"
{ yygotominor.yy274 = AVPL_STRICT; }
#line 1556 "mate_grammar.c"
        break;
      case 61:
#line 392 "./mate_grammar.lemon"
{ yygotominor.yy274 = AVPL_STRICT;   yy_destructor(26,&yymsp[0].minor);
}
#line 1562 "mate_grammar.c"
        break;
      case 62:
#line 393 "./mate_grammar.lemon"
{ yygotominor.yy274 = AVPL_EVERY;   yy_destructor(27,&yymsp[0].minor);
}
#line 1568 "mate_grammar.c"
        break;
      case 63:
#line 394 "./mate_grammar.lemon"
{ yygotominor.yy274 = AVPL_LOOSE;   yy_destructor(28,&yymsp[0].minor);
}
#line 1574 "mate_grammar.c"
        break;
      case 64:
#line 396 "./mate_grammar.lemon"
{ yygotominor.yy143 = AVPL_REPLACE;   yy_destructor(29,&yymsp[0].minor);
}
#line 1580 "mate_grammar.c"
        break;
      case 65:
#line 397 "./mate_grammar.lemon"
{ yygotominor.yy143 = AVPL_INSERT;   yy_destructor(30,&yymsp[0].minor);
}
#line 1586 "mate_grammar.c"
        break;
      case 66:
#line 398 "./mate_grammar.lemon"
{ yygotominor.yy143 = AVPL_INSERT; }
#line 1591 "mate_grammar.c"
        break;
      case 67:
#line 414 "./mate_grammar.lemon"
{
    
	mate_cfg_pdu* cfg  = new_pducfg(yymsp[-14].minor.yy0);
	extraction_t *extraction, *next_extraction;
	GPtrArray* transport_stack = g_ptr_array_new();
	int i;
	
	if (! cfg ) configuration_error(mc,"could not create Pdu %s.",yymsp[-14].minor.yy0);

	cfg->hfid_proto = yymsp[-12].minor.yy210->id;

	cfg->last_extracted = yymsp[-2].minor.yy182;
	cfg->discard = yymsp[-3].minor.yy182;
	cfg->drop_unassigned = yymsp[-4].minor.yy182;
	
	g_string_sprintfa(mc->protos_filter,"||%s",yymsp[-12].minor.yy210->abbrev);

	/* flip the transport_stack */
	for (i = yymsp[-10].minor.yy147->len - 1; yymsp[-10].minor.yy147->len; i--) {
		g_ptr_array_add(transport_stack,g_ptr_array_remove_index(yymsp[-10].minor.yy147,i));
	}
	
	g_ptr_array_free(yymsp[-10].minor.yy147,FALSE);
	
	cfg->transport_ranges = transport_stack;
	cfg->payload_ranges = yymsp[-8].minor.yy147;
	
	if (yymsp[-5].minor.yy231) {
		cfg->criterium = yymsp[-5].minor.yy231->criterium_avpl;
		cfg->criterium_match_mode = yymsp[-5].minor.yy231->criterium_match_mode;
		cfg->criterium_accept_mode = yymsp[-5].minor.yy231->criterium_accept_mode;
	}
	
	cfg->transforms = yymsp[-6].minor.yy147;
	
	for (extraction = yymsp[-7].minor.yy179; extraction; extraction = next_extraction) {
		next_extraction = extraction->next;
		
		if ( ! add_hfid(extraction->hfi, extraction->as, cfg->hfids_attr) ) {
			configuration_error(mc,"MATE: failed to create extraction rule '%s'",extraction->as);
		}
		
		g_free(extraction);
	}
  yy_destructor(11,&yymsp[-15].minor);
  yy_destructor(31,&yymsp[-13].minor);
  yy_destructor(32,&yymsp[-11].minor);
  yy_destructor(4,&yymsp[-9].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1646 "mate_grammar.c"
        break;
      case 68:
#line 460 "./mate_grammar.lemon"
{ yygotominor.yy147 = NULL; }
#line 1651 "mate_grammar.c"
        break;
      case 69:
#line 461 "./mate_grammar.lemon"
{ yygotominor.yy147 = yymsp[-1].minor.yy147;   yy_destructor(33,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1658 "mate_grammar.c"
        break;
      case 70:
#line 463 "./mate_grammar.lemon"
{ yygotominor.yy231 = NULL; }
#line 1663 "mate_grammar.c"
        break;
      case 71:
#line 464 "./mate_grammar.lemon"
{
	yygotominor.yy231 = g_malloc(sizeof(pdu_criteria_t));
	yygotominor.yy231->criterium_avpl = yymsp[-1].minor.yy70;
	yygotominor.yy231->criterium_match_mode = yymsp[-2].minor.yy274;
	yygotominor.yy231->criterium_accept_mode = yymsp[-3].minor.yy148;
  yy_destructor(34,&yymsp[-4].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1675 "mate_grammar.c"
        break;
      case 72:
#line 471 "./mate_grammar.lemon"
{ yygotominor.yy148 = ACCEPT_MODE; }
#line 1680 "mate_grammar.c"
        break;
      case 73:
#line 472 "./mate_grammar.lemon"
{ yygotominor.yy148 = ACCEPT_MODE;   yy_destructor(35,&yymsp[0].minor);
}
#line 1686 "mate_grammar.c"
        break;
      case 74:
#line 473 "./mate_grammar.lemon"
{ yygotominor.yy148 = REJECT_MODE;   yy_destructor(36,&yymsp[0].minor);
}
#line 1692 "mate_grammar.c"
        break;
      case 75:
#line 475 "./mate_grammar.lemon"
{ yygotominor.yy179 = yymsp[-1].minor.yy179; yygotominor.yy179->last = yygotominor.yy179->last->next = yymsp[0].minor.yy179; }
#line 1697 "mate_grammar.c"
        break;
      case 76:
#line 476 "./mate_grammar.lemon"
{ yygotominor.yy179 = yymsp[0].minor.yy179; yygotominor.yy179->last = yygotominor.yy179; }
#line 1702 "mate_grammar.c"
        break;
      case 77:
#line 478 "./mate_grammar.lemon"
{
	yygotominor.yy179 = g_malloc(sizeof(extraction_t));
	yygotominor.yy179->as = yymsp[-3].minor.yy0;
	yygotominor.yy179->hfi = yymsp[-1].minor.yy210;
	yygotominor.yy179->next = yygotominor.yy179->last = NULL;
  yy_destructor(37,&yymsp[-4].minor);
  yy_destructor(38,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1715 "mate_grammar.c"
        break;
      case 78:
      case 88:
#line 486 "./mate_grammar.lemon"
{ yygotominor.yy182 = yymsp[-1].minor.yy182;   yy_destructor(16,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1723 "mate_grammar.c"
        break;
      case 79:
#line 487 "./mate_grammar.lemon"
{ yygotominor.yy182 =  mc->defaults.pdu.drop_unassigned; }
#line 1728 "mate_grammar.c"
        break;
      case 80:
#line 489 "./mate_grammar.lemon"
{ yygotominor.yy182 = yymsp[-1].minor.yy182;   yy_destructor(17,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1735 "mate_grammar.c"
        break;
      case 81:
#line 490 "./mate_grammar.lemon"
{ yygotominor.yy182 =  mc->defaults.pdu.discard; }
#line 1740 "mate_grammar.c"
        break;
      case 82:
#line 492 "./mate_grammar.lemon"
{ yygotominor.yy182 = yymsp[-1].minor.yy182;   yy_destructor(39,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1747 "mate_grammar.c"
        break;
      case 83:
#line 493 "./mate_grammar.lemon"
{ yygotominor.yy182 = mc->defaults.pdu.last_extracted; }
#line 1752 "mate_grammar.c"
        break;
      case 84:
#line 495 "./mate_grammar.lemon"
{
	int* hfidp = g_malloc(sizeof(int));

	g_string_sprintfa(mc->fields_filter,"||%s",yymsp[0].minor.yy210->abbrev);
	
	*hfidp = yymsp[0].minor.yy210->id;
	g_ptr_array_add(yymsp[-2].minor.yy147,hfidp);
	yygotominor.yy147 = yymsp[-2].minor.yy147;
  yy_destructor(40,&yymsp[-1].minor);
}
#line 1766 "mate_grammar.c"
        break;
      case 85:
#line 505 "./mate_grammar.lemon"
{
	int* hfidp = g_malloc(sizeof(int));
	*hfidp = yymsp[0].minor.yy210->id;
	
	g_string_sprintfa(mc->fields_filter,"||%s",yymsp[0].minor.yy210->abbrev);

	yygotominor.yy147 = g_ptr_array_new();
	g_ptr_array_add(yygotominor.yy147,hfidp);
}
#line 1779 "mate_grammar.c"
        break;
      case 86:
#line 515 "./mate_grammar.lemon"
{
	yygotominor.yy210 = proto_registrar_get_byname(yymsp[0].minor.yy0);
}
#line 1786 "mate_grammar.c"
        break;
      case 87:
#line 533 "./mate_grammar.lemon"
{
	mate_cfg_gop* cfg;
	
	if (g_hash_table_lookup(mc->gopcfgs,yymsp[-17].minor.yy0)) configuration_error(mc,"yygotominor.yy0 Gop Named '%s' exists already.",yymsp[-17].minor.yy0);
	if (g_hash_table_lookup(mc->gops_by_pduname,yymsp[-15].minor.yy212) ) configuration_error(mc,"Gop for Pdu '%s' exists already",yymsp[-15].minor.yy212);

	cfg = new_gopcfg(yymsp[-17].minor.yy0);
	g_hash_table_insert(mc->gops_by_pduname,yymsp[-15].minor.yy212,cfg);
	g_hash_table_insert(mc->gopcfgs,cfg->name,cfg);
    
	cfg->on_pdu = yymsp[-15].minor.yy212;
	cfg->key = yymsp[-13].minor.yy70;
    cfg->drop_unassigned = yymsp[-4].minor.yy182;
    cfg->show_times = yymsp[-2].minor.yy182;
    cfg->pdu_tree_mode = yymsp[-3].minor.yy256;
    cfg->expiration = yymsp[-7].minor.yy255;
    cfg->idle_timeout = yymsp[-6].minor.yy255;
    cfg->lifetime = yymsp[-5].minor.yy255;
    cfg->start = yymsp[-11].minor.yy70;
    cfg->stop = yymsp[-10].minor.yy70;
    cfg->transforms = yymsp[-8].minor.yy147;
    
    merge_avpl(cfg->extra,yymsp[-9].minor.yy70,TRUE);
    delete_avpl(yymsp[-9].minor.yy70,TRUE);
  yy_destructor(12,&yymsp[-18].minor);
  yy_destructor(41,&yymsp[-16].minor);
  yy_destructor(25,&yymsp[-14].minor);
  yy_destructor(4,&yymsp[-12].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1821 "mate_grammar.c"
        break;
      case 89:
#line 560 "./mate_grammar.lemon"
{ yygotominor.yy182 =  mc->defaults.gop.drop_unassigned; }
#line 1826 "mate_grammar.c"
        break;
      case 90:
#line 562 "./mate_grammar.lemon"
{ yygotominor.yy70 = yymsp[-1].minor.yy70;   yy_destructor(42,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1833 "mate_grammar.c"
        break;
      case 91:
      case 93:
#line 563 "./mate_grammar.lemon"
{ yygotominor.yy70 = NULL; }
#line 1839 "mate_grammar.c"
        break;
      case 92:
#line 565 "./mate_grammar.lemon"
{ yygotominor.yy70 = yymsp[-1].minor.yy70;   yy_destructor(43,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1846 "mate_grammar.c"
        break;
      case 94:
#line 568 "./mate_grammar.lemon"
{ yygotominor.yy256 = yymsp[-1].minor.yy256;   yy_destructor(21,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1853 "mate_grammar.c"
        break;
      case 95:
#line 569 "./mate_grammar.lemon"
{ yygotominor.yy256 = mc->defaults.gop.pdu_tree_mode; }
#line 1858 "mate_grammar.c"
        break;
      case 96:
#line 571 "./mate_grammar.lemon"
{ yygotominor.yy182 = yymsp[-1].minor.yy182;   yy_destructor(22,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1865 "mate_grammar.c"
        break;
      case 97:
#line 572 "./mate_grammar.lemon"
{ yygotominor.yy182 = mc->defaults.gop.show_times; }
#line 1870 "mate_grammar.c"
        break;
      case 98:
      case 116:
#line 574 "./mate_grammar.lemon"
{ yygotominor.yy255 = yymsp[-1].minor.yy255;   yy_destructor(18,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1878 "mate_grammar.c"
        break;
      case 99:
      case 101:
      case 103:
#line 575 "./mate_grammar.lemon"
{ yygotominor.yy255 = mc->defaults.gop.lifetime; }
#line 1885 "mate_grammar.c"
        break;
      case 100:
#line 577 "./mate_grammar.lemon"
{ yygotominor.yy255 = yymsp[-1].minor.yy255;   yy_destructor(19,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1892 "mate_grammar.c"
        break;
      case 102:
#line 580 "./mate_grammar.lemon"
{ yygotominor.yy255 = yymsp[-1].minor.yy255;   yy_destructor(20,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1899 "mate_grammar.c"
        break;
      case 104:
#line 583 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_NO_TREE;   yy_destructor(44,&yymsp[0].minor);
}
#line 1905 "mate_grammar.c"
        break;
      case 105:
#line 584 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_PDU_TREE;   yy_destructor(45,&yymsp[0].minor);
}
#line 1911 "mate_grammar.c"
        break;
      case 106:
#line 585 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_FRAME_TREE;   yy_destructor(46,&yymsp[0].minor);
}
#line 1917 "mate_grammar.c"
        break;
      case 107:
#line 586 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_BASIC_PDU_TREE;   yy_destructor(47,&yymsp[0].minor);
}
#line 1923 "mate_grammar.c"
        break;
      case 108:
#line 588 "./mate_grammar.lemon"
{ yygotominor.yy182 = TRUE;   yy_destructor(48,&yymsp[0].minor);
}
#line 1929 "mate_grammar.c"
        break;
      case 109:
#line 589 "./mate_grammar.lemon"
{ yygotominor.yy182 = FALSE;   yy_destructor(49,&yymsp[0].minor);
}
#line 1935 "mate_grammar.c"
        break;
      case 110:
#line 591 "./mate_grammar.lemon"
{
	mate_cfg_pdu* c;
	if (( c =  g_hash_table_lookup(mc->pducfgs,yymsp[0].minor.yy0) )) {
		yygotominor.yy212 = c->name;
	} else {
		configuration_error(mc,"No such Pdu: '%s'",yymsp[0].minor.yy0);
	}
}
#line 1947 "mate_grammar.c"
        break;
      case 111:
      case 112:
#line 601 "./mate_grammar.lemon"
{
	yygotominor.yy255 = (float) strtod(yymsp[0].minor.yy0,NULL);
}
#line 1955 "mate_grammar.c"
        break;
      case 113:
#line 618 "./mate_grammar.lemon"
{
	mate_cfg_gog* cfg = NULL;
	
	if ( g_hash_table_lookup(mc->gogcfgs,yymsp[-8].minor.yy0) ) {
		configuration_error(mc,"Gog '%s' exists already ",yymsp[-8].minor.yy0);
	}
	
	cfg = new_gogcfg(yymsp[-8].minor.yy0);

	cfg->expiration = yymsp[-3].minor.yy255;
	cfg->gop_tree_mode = yymsp[-2].minor.yy256;
	cfg->transforms = yymsp[-4].minor.yy147;
	cfg->keys = yymsp[-6].minor.yy77;
	
    merge_avpl(cfg->extra,yymsp[-5].minor.yy70,TRUE);
    delete_avpl(yymsp[-5].minor.yy70,TRUE);
  yy_destructor(13,&yymsp[-9].minor);
  yy_destructor(4,&yymsp[-7].minor);
  yy_destructor(5,&yymsp[-1].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1980 "mate_grammar.c"
        break;
      case 114:
#line 636 "./mate_grammar.lemon"
{ yygotominor.yy256 = yymsp[-1].minor.yy256;   yy_destructor(23,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 1987 "mate_grammar.c"
        break;
      case 115:
#line 637 "./mate_grammar.lemon"
{ yygotominor.yy256 = mc->defaults.gog.gop_tree_mode; }
#line 1992 "mate_grammar.c"
        break;
      case 117:
#line 640 "./mate_grammar.lemon"
{ yygotominor.yy255 = mc->defaults.gog.expiration; }
#line 1997 "mate_grammar.c"
        break;
      case 118:
#line 642 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_NULL_TREE;   yy_destructor(51,&yymsp[0].minor);
}
#line 2003 "mate_grammar.c"
        break;
      case 119:
#line 643 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_FULL_TREE;   yy_destructor(52,&yymsp[0].minor);
}
#line 2009 "mate_grammar.c"
        break;
      case 120:
#line 644 "./mate_grammar.lemon"
{ yygotominor.yy256 = GOP_BASIC_TREE;   yy_destructor(47,&yymsp[0].minor);
}
#line 2015 "mate_grammar.c"
        break;
      case 121:
#line 646 "./mate_grammar.lemon"
{
	loal_append(yymsp[-1].minor.yy77,yymsp[0].minor.yy70);
	yygotominor.yy77 = yymsp[-1].minor.yy77;
}
#line 2023 "mate_grammar.c"
        break;
      case 122:
#line 651 "./mate_grammar.lemon"
{
	yygotominor.yy77 = new_loal("");
	loal_append(yygotominor.yy77,yymsp[0].minor.yy70);
}
#line 2031 "mate_grammar.c"
        break;
      case 123:
#line 657 "./mate_grammar.lemon"
{
	rename_avpl(yymsp[-1].minor.yy70,yymsp[-2].minor.yy212);
	yygotominor.yy70 = yymsp[-1].minor.yy70;
  yy_destructor(53,&yymsp[-3].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 2041 "mate_grammar.c"
        break;
      case 124:
#line 662 "./mate_grammar.lemon"
{
	mate_cfg_gop* c;
	if (( c = g_hash_table_lookup(mc->gopcfgs,yymsp[0].minor.yy0) )) {
		yygotominor.yy212 = c->name;
	} else {
		configuration_error(mc,"No Gop called '%s' has been already declared",yymsp[0].minor.yy0);
	}
}
#line 2053 "mate_grammar.c"
        break;
      case 125:
#line 674 "./mate_grammar.lemon"
{ yygotominor.yy70 = yymsp[-1].minor.yy70;   yy_destructor(54,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 2060 "mate_grammar.c"
        break;
      case 126:
#line 675 "./mate_grammar.lemon"
{ yygotominor.yy70 = new_avpl(""); }
#line 2065 "mate_grammar.c"
        break;
      case 127:
#line 677 "./mate_grammar.lemon"
{ yygotominor.yy147 = yymsp[-1].minor.yy147;   yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(2,&yymsp[0].minor);
}
#line 2072 "mate_grammar.c"
        break;
      case 128:
#line 678 "./mate_grammar.lemon"
{ yygotominor.yy147 = g_ptr_array_new(); }
#line 2077 "mate_grammar.c"
        break;
      case 129:
#line 680 "./mate_grammar.lemon"
{ 
	yygotominor.yy147 = yymsp[-2].minor.yy147;
	g_ptr_array_add(yymsp[-2].minor.yy147,yymsp[0].minor.yy11);
  yy_destructor(55,&yymsp[-1].minor);
}
#line 2086 "mate_grammar.c"
        break;
      case 130:
#line 685 "./mate_grammar.lemon"
{
	yygotominor.yy147 = g_ptr_array_new();
	g_ptr_array_add(yygotominor.yy147,yymsp[0].minor.yy11);
}
#line 2094 "mate_grammar.c"
        break;
      case 131:
#line 690 "./mate_grammar.lemon"
{
	AVPL_Transf* t;
	
	if (( t = g_hash_table_lookup(mc->transfs,yymsp[0].minor.yy0) )) {
		yygotominor.yy11 = t;
	} else {
		configuration_error(mc,"There's no such Transformation: %s",yymsp[0].minor.yy0);
	}	
}
#line 2107 "mate_grammar.c"
        break;
      case 132:
#line 700 "./mate_grammar.lemon"
{ yygotominor.yy70 = yymsp[-1].minor.yy70;   yy_destructor(56,&yymsp[-2].minor);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2114 "mate_grammar.c"
        break;
      case 133:
#line 701 "./mate_grammar.lemon"
{ yygotominor.yy70 = new_avpl("");   yy_destructor(56,&yymsp[-1].minor);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2121 "mate_grammar.c"
        break;
      case 134:
#line 703 "./mate_grammar.lemon"
{ yygotominor.yy70 = yymsp[-2].minor.yy70; if ( ! insert_avp(yymsp[-2].minor.yy70,yymsp[0].minor.yy226) ) delete_avp(yymsp[0].minor.yy226);   yy_destructor(55,&yymsp[-1].minor);
}
#line 2127 "mate_grammar.c"
        break;
      case 135:
#line 704 "./mate_grammar.lemon"
{ yygotominor.yy70 = new_avpl(""); if ( ! insert_avp(yygotominor.yy70,yymsp[0].minor.yy226) ) delete_avp(yymsp[0].minor.yy226); }
#line 2132 "mate_grammar.c"
        break;
      case 136:
#line 706 "./mate_grammar.lemon"
{ yygotominor.yy226 = new_avp(yymsp[-2].minor.yy0,yymsp[0].minor.yy212,*yymsp[-1].minor.yy0); }
#line 2137 "mate_grammar.c"
        break;
      case 137:
#line 707 "./mate_grammar.lemon"
{ yygotominor.yy226 = new_avp(yymsp[0].minor.yy0,"",'?'); }
#line 2142 "mate_grammar.c"
        break;
      case 138:
#line 708 "./mate_grammar.lemon"
{ yygotominor.yy226 = new_avp(yymsp[-3].minor.yy0,yymsp[-1].minor.yy212,'|');   yy_destructor(4,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
}
#line 2149 "mate_grammar.c"
        break;
      case 139:
#line 710 "./mate_grammar.lemon"
{ yygotominor.yy212 = g_strdup_printf("%s|%s",yymsp[-2].minor.yy212,yymsp[0].minor.yy212);   yy_destructor(59,&yymsp[-1].minor);
}
#line 2155 "mate_grammar.c"
        break;
      case 140:
#line 711 "./mate_grammar.lemon"
{ yygotominor.yy212 = g_strdup(yymsp[0].minor.yy212); }
#line 2160 "mate_grammar.c"
        break;
      case 141:
      case 142:
      case 143:
      case 144:
      case 145:
#line 713 "./mate_grammar.lemon"
{ yygotominor.yy212 = g_strdup(yymsp[0].minor.yy0); }
#line 2169 "mate_grammar.c"
        break;
      case 146:
#line 718 "./mate_grammar.lemon"
{ yygotominor.yy212 = recolonize(mc,yymsp[0].minor.yy0); }
#line 2174 "mate_grammar.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  MateParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 190 "./mate_grammar.lemon"

	configuration_error(mc,"Parse Error");
#line 2222 "mate_grammar.c"
  MateParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser _U_,       /* The parser */
  int yymajor _U_,               /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  MateParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 186 "./mate_grammar.lemon"

	configuration_error(mc,"Syntax Error before %s",yyminor);
#line 2240 "mate_grammar.c"
  MateParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  MateParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  MateParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "MateParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void MateParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  MateParserTOKENTYPE yyminor       /* The value for the token */
  MateParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  MateParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor((YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor((YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}

